%% visualize results of data simulated from warpMix model
% input: 
% dataidx: 1,2 or 3, corresponds to three different fixed effect functions
function [] = plotwarpMixResultsPriorModel2(dataidx)
datatype = sprintf("warpMix%d",dataidx);
load(sprintf("./data/warpMixData%d_mu.csv",dataidx));
newVars = struct();
oldName = sprintf("warpMixData%d_mu",dataidx);
newName = "mu";
newVars.(newName) = eval(oldName);
clear(oldName);
mu = newVars.mu;
load(sprintf("./result/warpMixEst_mu%d.csv",dataidx));
newVars = struct();
oldName = sprintf("warpMixEst_mu%d",dataidx);
newName = "mu_est";
newVars.(newName) = eval(oldName);
clear(oldName);
mu_est = newVars.mu_est;
resultfile = sprintf("./result/Data_warpMix%d_PriorModel2MCMC_main_BSpline_random_BSpline_basisnum_6_6_nG_7.mat", ...
    dataidx);
load(resultfile)

% uniform subsample for posterior samples visualization
visN =1000;
activeIndeces = round(linspace(burn,iterations,visN));
cols = get(0, 'DefaultAxesColorOrder');
numrep = ceil(N/length(cols));
cols = repmat(cols,numrep,1);

% posterior samples and posterior mean for fixed effect
first = true;
for ii = burn+1:iterations
    qmu_s = U1*a_samples(ii,:)';
    gam_bar = mean(gamma_samples(ii,:,:),3);
    gt_bar = interp1(tG,gam_bar,t,'linear');
    gt_bar(end) = 1;
    if first
        post_mean = qmu_s;
        post_mean_gam = gt_bar;
        first = false;
    else
        post_mean = post_mean + qmu_s;
        post_mean_gam = post_mean_gam + gt_bar;
    end
end
post_mean = post_mean/(iterations-burn);
post_mean_gam = post_mean_gam/(iterations-burn);
post_mean_warped = qComposeGamma(post_mean,t,post_mean_gam);

first = true;
for ii = activeIndeces
    qmu_s = U1*a_samples(ii,:)';
    qmu_s_warped = qComposeGamma(qmu_s,t,post_mean_gam);
    plot1 = plot(t,qmu_s_warped,'color',[cols(1,:),0.1]);
    hold on
    if first
        plot_temp = plot(NaN,NaN,'color',cols(1,:),'LineWidth',3);
        first = false;
    end
end
plot2 = plot(t,post_mean_warped,'color','red','linewidth',8);
plot3 = plot(t,mu_est,'color',cols(3,:),'linewidth',8);
plot4 = plot(t,mu,'color','black','linewidth',8);
hold off
legend([plot_temp, plot2,plot3,plot4],{'Centered Post. Samp.', ...
    'Centered Post. Mean','warpMix Estimate','Truth'},'Location','best')
switch dataidx
    case 1
        ylim([-2 3])
    case 2
        ylim([-1.3 1.3])
    case 3
        ylim([-3.2 1.3])
end
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel2/%s_PostMean.png",datatype))
close all
end



