import numpy as np
from src.evaluation.aux.load_results import *
from matplotlib.ticker import LogFormatter
import matplotlib.ticker as ticker
from matplotlib.ticker import ScalarFormatter
import matplotlib.pyplot as plt
import os
import argparse
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import config as config


time="_Date-2022-05-25_Time-04-10"

'''this file plots the figures in Appendix I.1.6 Outperform the best expert'''

parser = argparse.ArgumentParser(description='task4 for plotting the figures in Appendix I.1.6 Outperform the best expert')
parser.add_argument('-t', default="time", type=str, help='please input time of your .txt file generated by .sh bash file. For example, _Date-2022-05-18_Time-16-45')

args = parser.parse_args()
time = args.t

if time == "time":
    print("please input time of your .txt file generated by .sh bash file. For example, _Date-2022-05-18_Time-16-45")
    exit()


my_pal = config.COLOR
# rename macros
n_RS = config.n_RS
n_Oracle = config.n_CAMS_best_policy
n_QBC = config.n_qbc
n_IWAL = config.n_iwal
n_MP = config.n_mp
n_CQBC = config.n_contextual_qbc
n_CIWAL = config.n_contextual_iwal
n_CAMS = config.n_CAMS_identity
n_test = config.n_CAMS_test


def rename_method_list(methods, policy_name):
    arr = []
    for item in methods:
        arr.append(policy_name)
    return arr


def find_nearest(array, value):
    array = np.asarray(array)
    idx = (np.abs(array - value)).argmin()
    return array[idx]


def organize_plot(dataset_name, folder_name, budget, policy_name="policy_name"):

    # Preprocess and load data from experiment

    path = os.getcwd() + "/resources/results/" + folder_name + "/"
    data = np.load(path + "data.npz")
    num_reals = data["num_reals"]
    print(dataset_name, ":", num_reals)
    methods = data["methods"]
    budget_raw = data["budgets"]

    eval = np.load(path + "eval_results.npz")
    box_budget = eval["box_budget"]
    box_budget_actual = eval["box_budget_actual"]
    eval_num_queries = eval["num_queries_under_budget"]

    max_method = eval['max_method']
    max_budget_actual = eval['max_budget_actual']
    max_cumulative_loss = eval['max_cumulative_loss']
    max_method = rename_method_list(max_method, policy_name)
    max_bar_query = []
    for item in max_budget_actual:
        # print(item)
        min_bar = 0
        for j in budget_raw:
            if item >= j:
                min_bar = j
        max_bar_query.append(min_bar)

    eval_query_arr = []
    eval_query_arr_final = []
    for method_ in eval_query_arr:
        counter = 0
        array_temp = []
        for item in method_:
            counter = counter + item
            array_temp.append(counter)
        eval_query_arr_final.append(array_temp)


    box_cumulative_loss = eval["box_cumulative_loss"]
    box_method = eval["box_method"]
    box_ = np.repeat(policy_name, len(box_method))
    box_df_shading = {"budget": box_budget_actual, "budget_fixed": box_budget, "c_regret": box_cumulative_loss,
                      "method": box_}

    box_df_shading = pd.DataFrame(box_df_shading)
    reshape_budget = []
    reshape_budget_fixed = []
    budget_raw = np.asarray(budget_raw)

    for index, row in box_df_shading.iterrows():
        reshape_budget.append(row['budget'])
        budget_w_max = np.concatenate((budget_raw, [max_budget_actual[max_method.index(row['method'])]]))
        round_value = find_nearest(budget_w_max, row['budget'])

        if round_value == max_bar_query[max_method.index(row['method'])]:
            reshape_budget_fixed.append(max_budget_actual[max_method.index(row['method'])])
        else:
            reshape_budget_fixed.append(round_value)

    box_df_shading = {"budget": reshape_budget, "budget_fixed": reshape_budget_fixed, "c_regret": box_cumulative_loss,
                      "method": box_}

    box_df_shading = pd.DataFrame(box_df_shading)

    print(box_df_shading)

    for item in methods:
        for budget_ in budget_raw:
            print(item)
            x = np.where((box_df_shading["method"] == item) & (box_df_shading["budget_fixed"] == budget_))
            y = box_df_shading.loc[x]["budget"].mean()

            box_df_shading.iloc[[x], [box_df_shading.columns.get_loc("budget_fixed")]] = y

    shade_df_2 = box_df_shading.filter(["budget_fixed", "method", "c_regret"], axis=1).drop_duplicates().reset_index(
        drop=True)

    print(shade_df_2)
    return shade_df_2


##########################

# HIV
dataset_name="HIV"
budget = 200

# random sampling
policy_0 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[0]"
policy_1 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[1]"
policy_2 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[2]"
policy_3 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[3]"
policy_4 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[4]"
policy_5 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[5]"
policy_6 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[6]"
policy_7 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[7]"
policy_8 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[8]"
policy_9 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[9]"
policy_10 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[10]"
policy_11 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[11]"
policy_12 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[12]"
policy_13 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[13]"
policy_14 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[14]"
policy_15 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[15]"
policy_16 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[16]"
policy_17 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[17]"
policy_18 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[18]"
policy_19 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[19]"
policy_20 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[20]"
policy_21 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[21]"
policy_22 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[22]"
policy_23 = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000010000_policy[23]"

# ap="drift_contextual_streamsize3000_numreals200_Date-2022-01-14_Time-12-53-32_which_methods00000001000_policy[6]"
CAMS = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000001000_policy[6]"
CAMS_max = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000000100_policy[6]"
CAMS_random_policy = "HIV_contextual_streamsize4000_numreals200" + time + "_which_methods00000000010_policy[6]"

# #random sampling
# policy_0="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[0]"
# policy_1="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[1]"
# policy_2="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[2]"
# policy_3="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[3]"
# policy_4="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[4]"
# policy_5="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[5]"
# policy_6="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[6]"
# policy_7="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[7]"
# policy_8="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[8]"
# policy_9="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[9]"
# policy_10="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[10]"
# policy_11="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[11]"
# policy_12="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[12]"
# policy_13="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[13]"
# policy_14="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[14]"
# policy_15="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[15]"
# policy_16="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[16]"
# policy_17="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[17]"
# policy_18="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[18]"
# policy_19="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[19]"
# policy_20="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[20]"
# policy_21="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[21]"
# policy_22="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-14_which_methods00000010000_policy[22]"
# policy_23="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000010000_policy[23]"


# #ap="drift_contextual_streamsize3000_numreals200_Date-2022-01-14_Time-12-53-32_which_methods00000001000_policy[6]"
# CAMS="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000001000_policy[6]"
# CAMS_max="HIV_contextual_streamsize4000_numreals200_Date-2022-02-25_Time-01-00-13_which_methods00000000100_policy[6]"


shade_df = []
shade_df_0 = organize_plot(dataset_name,
                           policy_0, budget, "policy_0")

shade_df_1 = organize_plot(dataset_name,
                           policy_1, budget, "policy_1")

shade_df_2 = organize_plot(dataset_name,
                           policy_2, budget, "policy_2")

shade_df_3 = organize_plot(dataset_name,
                           policy_3, budget, "policy_3")

shade_df_4 = organize_plot(dataset_name,
                           policy_4, budget, "policy_4")

shade_df_5 = organize_plot(dataset_name,
                           policy_5, budget, "policy_5")

shade_df_6 = organize_plot(dataset_name,
                           policy_6, budget, "policy_6")

shade_df_7 = organize_plot(dataset_name,
                           policy_7, budget, "policy_7")

shade_df_8 = organize_plot(dataset_name,
                           policy_8, budget, "policy_8")

shade_df_9 = organize_plot(dataset_name,
                           policy_9, budget, "policy_9")

shade_df_10 = organize_plot(dataset_name,
                            policy_10, budget, "policy_10")

shade_df_11 = organize_plot(dataset_name,
                            policy_11, budget, "classifier_11")

shade_df_12 = organize_plot(dataset_name,
                            policy_12, budget, "classifier_12")

shade_df_13 = organize_plot(dataset_name,
                            policy_13, budget, "classifier_13")

shade_df_14 = organize_plot(dataset_name,
                            policy_14, budget, "classifier_14")

shade_df_15 = organize_plot(dataset_name,
                            policy_15, budget, "policy_15")

shade_df_16 = organize_plot(dataset_name,
                            policy_16, budget, "policy_16")

shade_df_17 = organize_plot(dataset_name,
                            policy_17, budget, "policy_17")

shade_df_18 = organize_plot(dataset_name,
                            policy_18, budget, "policy_18")

shade_df_19 = organize_plot(dataset_name,
                            policy_19, budget, "policy_19")

shade_df_20 = organize_plot(dataset_name,
                            policy_20, budget, "policy_20")

shade_df_21 = organize_plot(dataset_name,
                            policy_21, budget, "policy_21")

shade_df_22 = organize_plot(dataset_name,
                            policy_22, budget, "policy_22")

shade_df_23 = organize_plot(dataset_name,
                            policy_23, budget, "policy_23")

shade_df_cams = organize_plot(dataset_name,
                              CAMS, budget, "CAMS")
shade_df_cams_max = organize_plot(dataset_name,
                                  CAMS_max, budget, "CAMS_MAX")
shade_df_cams_random_policy = organize_plot(dataset_name,
                                            CAMS_random_policy, budget, "CAMS_random_policy")

print(shade_df_cams)


# plot the normal policy column
shade_df = shade_df_cams

shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)

shade_df = shade_df.append(shade_df_0)
shade_df = shade_df.append(shade_df_1)
shade_df = shade_df.append(shade_df_2)
shade_df = shade_df.append(shade_df_3)
shade_df = shade_df.append(shade_df_4)
shade_df = shade_df.append(shade_df_5)
shade_df = shade_df.append(shade_df_6)
shade_df = shade_df.append(shade_df_7)
shade_df = shade_df.append(shade_df_8)
shade_df = shade_df.append(shade_df_9)
shade_df = shade_df.append(shade_df_10)

shade_df = pd.DataFrame(shade_df)
print(shade_df)

fig, ax = plt.subplots(figsize=(10, 10), dpi=300)


sns.lineplot(x="budget_fixed", y="c_regret", label="best policy", data=shade_df[shade_df["method"] == "policy_0"],
             ci=63, color="purple", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_1"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_2"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_3"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_4"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_5"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_6"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_7"], ci=63, color="grey",
             linewidth=1)
# sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_8"],ci=63,  color="grey", linewidth=1)
# sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_9"],ci=63,  color="grey", linewidth=1)
# sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_10"],ci=63,  color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


ax.set_ylim(100, 180)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)

plt.xlabel("Query cost", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21, title=None)
plt.legend('')
plt.savefig("./task4/" + dataset_name + "_task4_normal_policy_shade_line_plot.png", bbox_inches='tight',
            pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_normal_policy_shade_line_plot.pdf", bbox_inches='tight',
            pad_inches=0.01)


shade_df = shade_df_cams
shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
shade_df = shade_df.append(shade_df_11)
shade_df = shade_df.append(shade_df_12)
shade_df = shade_df.append(shade_df_13)
# shade_df=shade_df.append(shade_df_14)


fig, ax = plt.subplots(figsize=(10, 10), dpi=300)


# classifiers
sns.lineplot(x="budget_fixed", y="c_regret", label="best classifier",
             data=shade_df[shade_df["method"] == "classifier_11"], ci=63, color="y", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_12"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_13"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_14"], ci=63, color="grey",
             linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)

sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


ax.set_ylim(100, 200)

plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21, title=None)
plt.legend('')
plt.savefig("./task4/" + dataset_name + "_task4_classifier_shade_line_plot.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_classifier_shade_line_plot.pdf", bbox_inches='tight', pad_inches=0.01)

# malicious policy
shade_df = shade_df_cams
shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
# shade_df=shade_df.append(shade_df_15)
# shade_df=shade_df.append(shade_df_16)
# shade_df=shade_df.append(shade_df_17)
# shade_df=shade_df.append(shade_df_18)
# shade_df=shade_df.append(shade_df_19)
shade_df = shade_df.append(shade_df_20)
shade_df = shade_df.append(shade_df_21)
shade_df = shade_df.append(shade_df_22)
shade_df = shade_df.append(shade_df_23)

fig, ax = plt.subplots(figsize=(10, 10), dpi=300)


sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_15"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_16"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_17"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_18"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_19"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_20"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_21"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_22"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_23"], ci=63, color="grey",
             linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


ax.set_ylim(100, 1100)
ax.set_yscale('log')

ticks_loc = ax.get_yticks()
ax.yaxis.set_major_locator(ticker.FixedLocator(ticks_loc))
ax.yaxis.set_major_formatter(ticker.FormatStrFormatter('%0.0e'))

plt.xticks(fontsize=20)
plt.yticks(fontsize=20)


plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21, title=None)
plt.legend('')

plt.savefig("./task4/" + dataset_name + "_task4_malicious_policy_shade_line_plot.png", bbox_inches='tight',
            pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_malicious_policy_shade_line_plot.pdf", bbox_inches='tight',
            pad_inches=0.01)

print("completed! HIV")



###########################################################################

#this section plots the figures for VERTEBRAL benmarks

# VERTEBRAL
dataset_name = "VERTEBRAL"
budget = 20

policy_0 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[0]"
policy_1 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[1]"
policy_2 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[2]"
policy_3 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[3]"
policy_4 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[4]"
policy_5 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[5]"
policy_6 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[6]"
policy_7 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[7]"
policy_8 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[8]"
policy_9 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[9]"
policy_10 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[10]"
policy_11 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[11]"
policy_12 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[12]"
policy_13 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[13]"
policy_14 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[14]"
policy_15 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[15]"
policy_16 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[16]"
policy_17 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[17]"
policy_18 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[18]"
policy_19 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[19]"
policy_20 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[20]"
policy_21 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[21]"
policy_22 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[22]"
policy_23 = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000010000_policy[23]"

CAMS = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000001000_policy[6]"
CAMS_max = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000000100_policy[6]"
CAMS_random_policy = "VERTEBRAL_contextual_streamsize80_numreals200" + time + "_which_methods00000000010_policy[6]"


# policy_0="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[0]"
# policy_1="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[1]"
# policy_2="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[2]"
# policy_3="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[3]"
# policy_4="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[4]"
# policy_5="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[5]"
# policy_6="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[6]"
# policy_7="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[7]"
# policy_8="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[8]"
# policy_9="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[9]"
# policy_10="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[10]"
# policy_11="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[11]"
# policy_12="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[12]"
# policy_13="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[13]"
# policy_14="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[14]"
# policy_15="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[15]"
# policy_16="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[16]"
# policy_17="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[17]"
# policy_18="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[18]"
# policy_19="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[19]"
# policy_20="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[20]"
# policy_21="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[21]"
# policy_22="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[22]"
# policy_23="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000010000_policy[23]"

# #ap="drift_contextual_streamsize3000_numreals200_Date-2022-01-14_timestamp-12-53-32_which_methods00000001000_policy[6]"
# CAMS="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000001000_policy[6]"
# CAMS_max="VERTEBRAL_contextual_streamsize80_numreals200_Date-"+timestamp+"_which_methods00000000100_policy[6]"


shade_df = []
shade_df_0 = organize_plot(dataset_name,
                           policy_0, budget, "policy_0")

shade_df_1 = organize_plot(dataset_name,
                           policy_1, budget, "policy_1")

shade_df_2 = organize_plot(dataset_name,
                           policy_2, budget, "policy_2")

shade_df_3 = organize_plot(dataset_name,
                           policy_3, budget, "policy_3")

shade_df_4 = organize_plot(dataset_name,
                           policy_4, budget, "policy_4")

shade_df_5 = organize_plot(dataset_name,
                           policy_5, budget, "policy_5")

shade_df_6 = organize_plot(dataset_name,
                           policy_6, budget, "classifier_6")

shade_df_7 = organize_plot(dataset_name,
                           policy_7, budget, "classifier_7")

shade_df_8 = organize_plot(dataset_name,
                           policy_8, budget, "classifier_8")

shade_df_9 = organize_plot(dataset_name,
                           policy_9, budget, "classifier_9")

shade_df_10 = organize_plot(dataset_name,
                            policy_10, budget, "classifier_10")

shade_df_11 = organize_plot(dataset_name,
                            policy_11, budget, "classifier_11")

shade_df_12 = organize_plot(dataset_name,
                            policy_12, budget, "policy_12")

shade_df_13 = organize_plot(dataset_name,
                            policy_13, budget, "policy_13")

shade_df_14 = organize_plot(dataset_name,
                            policy_14, budget, "policy_14")

shade_df_15 = organize_plot(dataset_name,
                            policy_15, budget, "policy_15")

shade_df_16 = organize_plot(dataset_name,
                            policy_16, budget, "policy_16")

shade_df_17 = organize_plot(dataset_name,
                            policy_17, budget, "policy_17")

shade_df_18 = organize_plot(dataset_name,
                            policy_18, budget, "policy_18")

shade_df_19 = organize_plot(dataset_name,
                            policy_19, budget, "policy_19")

shade_df_20 = organize_plot(dataset_name,
                            policy_20, budget, "policy_20")

shade_df_21 = organize_plot(dataset_name,
                            policy_21, budget, "policy_21")

shade_df_22 = organize_plot(dataset_name,
                            policy_22, budget, "policy_22")

shade_df_cams = organize_plot(dataset_name,
                              CAMS, budget, "CAMS")
shade_df_cams_max = organize_plot(dataset_name,
                                  CAMS_max, budget, "CAMS_MAX")
shade_df_cams_random_policy = organize_plot(dataset_name,
                                            CAMS_random_policy, budget, "CAMS_random_policy")

print(shade_df_cams)

# box_df20, regret_t, cumulative_loss_t, sampled_regret_t, num_instances, methods, eval_regret, eval_cumulative_loss, eval_sampled_regret, eval_num_queries =  organize_plot(dataset_name,
#    best_policy, budget,    "CAMS_policy")

shade_df = shade_df_cams

shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
shade_df = shade_df.append(shade_df_0)
shade_df = shade_df.append(shade_df_1)
shade_df = shade_df.append(shade_df_2)
shade_df = shade_df.append(shade_df_3)
shade_df = shade_df.append(shade_df_4)
shade_df = shade_df.append(shade_df_5)

shade_df = pd.DataFrame(shade_df)
print(shade_df)

plt.figure(figsize=(10, 10), dpi=300)

sns.lineplot(x="budget_fixed", y="c_regret", label="best policy", data=shade_df[shade_df["method"] == "policy_0"],
             ci=63, color="purple", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_1"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_2"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_3"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_4"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_5"], ci=63, color="grey",
             linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.ylabel("", fontsize=30)
plt.xlabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21, title=None)
plt.legend('')

plt.savefig("./task4/" + dataset_name + "_task4_normal_policy_shade_line_plot.png", bbox_inches='tight',
            pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_normal_policy_shade_line_plot.pdf", bbox_inches='tight',
            pad_inches=0.01)

shade_df = shade_df_cams
shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
# shade_df=shade_df.append(shade_df_6)
shade_df = shade_df.append(shade_df_7)
# shade_df=shade_df.append(shade_df_8)
shade_df = shade_df.append(shade_df_9)
shade_df = shade_df.append(shade_df_10)
# shade_df=shade_df.append(shade_df_11)

plt.figure(figsize=(10, 10), dpi=300)

print(shade_df)


sns.lineplot(x="budget_fixed", y="c_regret", label="best classifier",
             data=shade_df[shade_df["method"] == "classifier_10"], ci=63, color="y", linewidth=3)

sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_6"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_7"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_8"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_9"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "classifier_11"], ci=63, color="grey",
             linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21, title=None)
plt.legend('')

plt.savefig("./task4/" + dataset_name + "_task4_classifier_shade_line_plot.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_classifier_shade_line_plot.pdf", bbox_inches='tight', pad_inches=0.01)

shade_df = shade_df_cams
shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
# shade_df=shade_df.append(shade_df_12)
# shade_df=shade_df.append(shade_df_13)
shade_df = shade_df.append(shade_df_14)
shade_df = shade_df.append(shade_df_15)
shade_df = shade_df.append(shade_df_16)
# shade_df=shade_df.append(shade_df_17)
# shade_df=shade_df.append(shade_df_18)
shade_df = shade_df.append(shade_df_19)
shade_df = shade_df.append(shade_df_20)
shade_df = shade_df.append(shade_df_21)
shade_df = shade_df.append(shade_df_22)

plt.figure(figsize=(10, 10), dpi=300)


sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_12"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_13"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_14"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_15"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_16"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_17"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_18"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_19"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_20"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_21"], ci=63, color="grey",
             linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"] == "policy_22"], ci=63, color="grey",
             linewidth=1)


sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)


plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(fontsize=21, title=None)
plt.legend(loc=2)
plt.legend('')
plt.savefig("./task4/" + dataset_name + "_task4_malicious_policy_shade_line_plot.png", bbox_inches='tight',
            pad_inches=0.01)
plt.savefig("./task4/" + dataset_name + "_task4_malicious_policy_shade_line_plot.pdf", bbox_inches='tight',
            pad_inches=0.01)

print("legend!")


shade_df = []
shade_df = shade_df_cams
shade_df = shade_df.append(shade_df_cams_max)
shade_df = shade_df.append(shade_df_cams_random_policy)
shade_df = shade_df.append(shade_df_10)
shade_df = shade_df.append(shade_df_0)
shade_df = shade_df.append(shade_df_14)


plt.figure(figsize=(10, 10), dpi=300)
line_ = sns.lineplot(x="budget_fixed", y="c_regret", label="best classifier",
                     data=shade_df[shade_df["method"] == "classifier_10"], ci=63, color="y", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="best policy", data=shade_df[shade_df["method"] == "policy_0"],
             ci=63, color="purple", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_MAX", data=shade_df[shade_df["method"] == "CAMS_MAX"],
             color="blue", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="CAMS_random_policy",
             data=shade_df[shade_df["method"] == "CAMS_random_policy"], color="g", ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label=n_CAMS, data=shade_df[shade_df["method"] == n_CAMS],
             color=my_pal[n_CAMS], ci=63, linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", label="top suboptimal policies/classifiers",
             data=shade_df[shade_df["method"] == "policy_14"], ci=63, color="grey", linewidth=1)


fig = plt.figure(figsize=(10, 10), dpi=300)
handles, labels = line_.get_legend_handles_labels()
fig.legend(handles, labels, ncol=8, loc='center')
fig.savefig("./task4/" + 'legend_task4_outperform_all.png', bbox_inches='tight', pad_inches=0)
fig.savefig("./task4/" + 'legend_task4_outperform_all.pdf', bbox_inches='tight', pad_inches=0)
print("completed!")





