MODEL="timm://resnet50.a3_in1k"

#CHECKPOINTS=$(ls -1 /lustre$USER/code/interpretability-comparison/tools/model_training/output/train/20240103-122936-resnet50_a1_in1k-224//checkpoint-*.pth.tar)
# CHECKPOINTS=$(ls -1 /lustre$USER/code/interpretability-comparison/tools/model_training/output/train/20240108-162845-resnet50_a3_in1k-224//checkpoint-*.pth.tar)
CHECKPOINTS=$(ls -1 /lustre$USER/code/interpretability-comparison/tools/model_training/output/train/20240110-150345-resnet50_a3_in1k-224//checkpoint-*.pth.tar)

N_CHECKPOINTS=$(echo "${CHECKPOINTS}" | wc -l)
echo "Number of available checkpoints: ${N_CHECKPOINTS}"

CID=$1

# If CID is larger then N_checkpoints, exit.
# We need to subtract 1 here for some magical reason.
if [ $CID -ge $N_CHECKPOINTS ]
then
  echo "CID ($CID) is not smaller than number of available checkpoints ($N_CHECKPOINTS), exit."
  exit -1
fi

CID=$((CID+1))
CHECKPOINT=$(echo "$CHECKPOINTS" | head -n$CID | tail -n1)
echo "Checkpoint: $CHECKPOINT"

DATA_DIR="$USER/interpretability-comparison-data/"
(cd ../../stimuli_generation && HF_HOME=/tmp python collect_extreme_activations.py \
  --imagenet-path="$USER/ImageNet2012-webdataset/imagenet-train-{000000..000146}.tar" \
  --output-path ${DATA_DIR}/activations-hard-15k \
  --n-extreme-images=15000 \
  --ignore-extreme-image-range="-14750:-250" \
  --model=$MODEL \
  --model-checkpoint=$CHECKPOINT \
  --batch-size=1024)

(cd ../../stimuli_generation && HF_HOME=/tmp python find_most_extreme_units.py \
  --similarity-function=dreamsim \
  --similarity-function-args ${DATA_DIR}/dependencies/dreamsim_features_imagenet_train.pkl \
  --similarity-function-args dreamsim_logistic_regression.hard_coded.pkl \
  --activations-root=${DATA_DIR}/activations-hard-15k/ \
  --output-dir=${DATA_DIR}/machine-interpretability-training-hard_coded --model=$MODEL \
  --model-checkpoint=$CHECKPOINT)

(cd ../../stimuli_generation && HF_HOME=/tmp python find_most_extreme_units.py \
  --similarity-function=dreamsim \
  --similarity-function-args ${DATA_DIR}/dependencies/dreamsim_features_imagenet_train.pkl \
  --similarity-function-args dreamsim_logistic_regression.hard_coded.pkl \
  --activations-root=${DATA_DIR}/activations-hard-15k/ \
  --output-dir=${DATA_DIR}/machine-interpretability-hard-15k-training-hard_coded --model=$MODEL \
  --model-checkpoint=$CHECKPOINT \
  --stop-max=270 \
  --start-min=230)