# Set the working directory and load necessary files
abpath <- getwd()
PReBiM_path <- file.path(abpath, "PReBiM.R")
source(PReBiM_path)

# data_path <- file.path(abpath, "gen_data.R")
# source(data_path)

# Setting parameters
direction = 2  # Choose direction: 1 for unidirectional, 2 for bidirectional
rep.time = 500  # Number of repetitions
W = 3  # Upper limit of valid IVs
gamma_threshold = 0.1  # A3_required
n = 5000  # Sample size
g = 6  # Number of candidate IVs
num.IV.XtoY = 2  # Number of valid IVs for X to Y
num.IV.YtoX = 2  # Number of valid IVs for Y to X

# Generate data
beta.XtoY <- runif(1, 0.5, 1)  # Effect of X on Y
beta.YtoX <- runif(1, 0.5, 1)  # Effect of Y on X (beta.YtoX = 0 if direction = 1)
# generating genetic variants
G <- matrix(0, n, g)
for (m in 1:g) {
  mafj <- runif(1, min = 0.1, max = 0.5)
  non_zero_count <- round(mafj * n)
  G[sample(1:n, non_zero_count), m] <- sample(1:2, non_zero_count, replace = TRUE)
}
epsilon1 <- rnorm(n)
epsilon2 <- rnorm(n)
epsilon3 <- rnorm(n)

gamma.toX <- c(0.3, 0.4, 0, 0, 0.4, 0.3)
gamma.toY <- c(0, 0, 0.4, 0.5, 0.6, 0.7)
gamma.toU <- c(0, 0, 0, 0, 0.4, 0.5)
beta.UtoX <- 0.7
beta.UtoY <- 0.6
redu.para = 1 / (1 - beta.XtoY * beta.YtoX) # Constructing the reduction parameter
X = redu.para * (G %*% gamma.toX + G %*% gamma.toY * beta.YtoX + G %*% gamma.toU * (beta.UtoX + beta.YtoX * beta.UtoY) + epsilon1 + epsilon2 * beta.YtoX + epsilon3 * (beta.UtoX + beta.UtoY))
Y = redu.para * (G %*% gamma.toX * beta.XtoY + G %*% gamma.toY + G %*% gamma.toU * (beta.UtoY + beta.XtoY * beta.UtoX) + epsilon2 + epsilon1 * beta.XtoY + epsilon3 * (beta.UtoX + beta.UtoY))


# Result
PReBiM(X, Y, G, alpha = 0.01, direction = 2, W = W, Test_method = "pearson")
