import torch
from tqdm import tqdm
import torchvision.utils as tvu
import os
import numpy as np

def compute_alpha(beta, t):
    beta = torch.cat([torch.zeros(1).to(beta.device), beta], dim=0)
    a = (1 - beta).cumprod(dim=0).index_select(0, t + 1).view(-1, 1, 1, 1)
    return a


# x: 初始噪声；seq: 时间下标序列；model: 扩散模型；betas: beta序列；H_funcs: 观测矩阵；y_0: 观测；sigma_0: 观测噪声标准差；clas_fn: 分类器；classes: 类别
def efficient_generalized_steps(x, seq, model, b, H_funcs, A_funcs, y_0, sigma_0, etaB, etaA, etaC, cls_fn=None, classes=None):
    with torch.no_grad():
        #initialize x_T as given in the paper
        largest_alphas = compute_alpha(b, (torch.ones(x.size(0)) * seq[-1]).to(x.device).long())
        
        # setup iteration variables
        # x = H_funcs.V(init_y.view(x.size(0), -1)).view(*x.size())
        # 观测对应的噪声水平
        var_obs = H_funcs.ratio ** 2 * sigma_0 ** 2
        # var_obs = 0.1
        y_upsampling = H_funcs.upsampling(y_0)/torch.sqrt(torch.tensor(1+var_obs))
        # y_upsampling = H_funcs.upsampling(y_0)
        alpha_obs = 1 / torch.tensor(1+var_obs)
        sigma_y = sigma_0
        y = y_0
        # print(alpha_obs)
        # alpha_obs = torch.tensor(0.)
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]


        t = (torch.ones(n) * seq[-1]).to(x.device)
        # alpha_t和alpha_{t-1}
        at = compute_alpha(b, t.long())
        noise = torch.randn_like(x)
        x_T = noise * (1 - at).sqrt()
        et = model(x_T, t)
        if et.size(1) == 6:
            et = et[:, :3]
        x_obs_t = (x_T - et * (1 - at/alpha_obs).sqrt()) / (at/alpha_obs).sqrt()
        x0_t = (x_T - et * (1 - at).sqrt()) / at.sqrt()
        x0_t += H_funcs.upsampling(y_0 - H_funcs.downsampling(x0_t))
        # x_obs_t = y_upsampling

        
        xt = x_T
        v = None
        beta=0.0
        # 1000steps: 0.1
        # 100steps: 1.8
        # 20steps: 1.7
        lr=0.7
        N=1
        lam=1
        init_noise = torch.randn_like(x_obs_t)
        # et = None
        eta=0.85
        #iterate over the timesteps
        for i, j in tqdm(zip(reversed(seq), reversed(seq_next))):
            for _ in range(N):
                t = (torch.ones(n) * i).to(x.device)
                next_t = (torch.ones(n) * j).to(x.device)
                at = compute_alpha(b, t.long())
                at_next = compute_alpha(b, next_t.long())
                # print(at[0,0,0,0])
                # 加噪, Stochastic Encoding
                sigma_t = (1 - at).sqrt()[0, 0, 0, 0]
                et = init_noise
                xt = at.sqrt() * x0_t + A_funcs.Lambda_noise(
                    torch.randn_like(x0_t).reshape(x0_t.size(0), -1), 
                    at.sqrt()[0, 0, 0, 0], sigma_y, sigma_t, eta, et.reshape(et.size(0), -1), at, at_next).reshape(*x0_t.size())
                # if (1 - at).sqrt()[0,0,0,0] >= H_funcs.ratio * sigma_0 * at_next.sqrt()[0,0,0,0]:
                #     xt = at.sqrt() * x0_t + (1 - at - at * H_funcs.ratio ** 2 * sigma_0 ** 2).sqrt() * torch.randn_like(x0_t)
                # else:
                #     xt = at.sqrt() * x0_t + (1 - at).sqrt() * eta * torch.randn_like(x0_t)
                # Score Function
                et = model(xt, t)
                if et.size(1) == 6:
                    et = et[:, :3]
                x0_t_new = (xt - (1 - at).sqrt() * et) / at.sqrt()
                d = diff = x0_t_new - x0_t
                if v is None:
                    v = d
                else:
                    v = beta * v + (1 - beta) * d
                x0_t += lr * v
                # 投影
                sigma_t = (1-at_next).sqrt()[0,0,0,0]
                x0_t = x0_t - A_funcs.Lambda(A_funcs.A_pinv(
                    A_funcs.A(x0_t.reshape(x0_t.size(0), -1)) - y.reshape(y.size(0), -1)
                ).reshape(x0_t.size(0), -1), at_next.sqrt()[0, 0, 0, 0], sigma_y, sigma_t, eta).reshape(*x0_t.size())
                # if (1-at_next).sqrt()[0,0,0,0] >= H_funcs.ratio * sigma_0 * at_next.sqrt()[0,0,0,0]:
                #     x0_t += H_funcs.upsampling(y_0 - H_funcs.downsampling(x0_t))
                # else:
                #     x0_t += H_funcs.upsampling(y_0 - H_funcs.downsampling(x0_t)) * (1-eta**2)**0.5 * (1-at_next).sqrt() / (H_funcs.ratio * sigma_0 * at_next.sqrt())

                # xt = xt_next
                xt_next = x0_t
                x0_preds.append(x0_t.to('cpu'))
                xs.append(xt_next.to('cpu'))

    return xs, x0_preds