import csv
import numpy as np
import pandas as pd
import keyboard
from comtypes.client import CreateObject
from comtypes.gen import STKObjects
from time import ctime
import time 
from multiprocessing import  Process

def MultiProcessFunc(GroundNum):
    j=GroundNum
    print("Now is Process ",GroundNum)
    # 打开STK桌面软件，创建STK实例
    app = CreateObject("STK11.Application")
    # 显示STK GUI界面
    app.Visible = True
    #  获取Object Model的根对象：IAgStkObjectRoot
    #  此接口为Object Model中的最顶层接口，由此接口可创建场景、地面站、卫星等
    root = app.Personality2
    #建立场景，名字为sce
    root.NewScenario('sce')
    Sce = root.CurrentScenario
    #接口转换，获取场景的接口
    scenario2 = Sce.QueryInterface(STKObjects.IAgScenario)
    #设定场景的时间,仿真时间设置为1小时
    scenario2.StartTime = '12 Oct 2020 0:00:00.00'
    scenario2.StopTime = '12 Oct 2020 0:12:00.00'
    root.Rewind()
    n = 2

    if n == 1:
    #     #GEO
    #     SatObj = Sce.Children.New(18, 'GEO')
    #     SatIAF = SatObj.QueryInterface(STKObjects.IAgSatellite)
    #     # 查看当前卫星轨道预报模型
    #     SatIAF.PropagatorType
    #     # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
    #     ProIAF = SatIAF.Propagator
    #     # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
    #     ProTwoBodyIAF = ProIAF.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
    #     # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
    #     ProTwoBodyIAF.InitialState.Representation.AssignClassical(3,42871, 0, 0, 0, 0, 0)
    #     # 传递参数
    #     ProTwoBodyIAF.Propagate()
    #     # Connect命令，选择Delta类型形成Walker星座,总卫星数量24颗、4个轨道面、每个轨道面6颗卫星、相位因子1
    #     root.ExecuteCommand(
    #         'Walker */Satellite/GEO Type Delta NumPlanes 1 NumSatsPerPlane 6 InterPlanePhaseIncrement 0 ColorByPlane Yes')
    #     SatObj.Unload()
        #搭建Telesat星座
        # SatObj1 = Sce.Children.New(18, 'telesat_layer_1')
        # SatIAF1 = SatObj1.QueryInterface(STKObjects.IAgSatellite)
        # # 查看当前卫星轨道预报模型
        # SatIAF1.PropagatorType
        # # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
        # ProIAF1 = SatIAF1.Propagator
        # # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
        # ProTwoBodyIAF1 = ProIAF1.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
        # # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
        # ProTwoBodyIAF1.InitialState.Representation.AssignClassical(3, 7386, 0, 98, 0, 0, 0)
        # # 传递参数
        # ProTwoBodyIAF1.Propagate()
        # root.ExecuteCommand('Walker */Satellite/telesat_layer_1 Type Delta NumPlanes 6 NumSatsPerPlane 13 InterPlanePhaseIncrement 4 ColorByPlane Yes')
        # SatObj1.Unload()

        # SatObj = Sce.Children.New(18, 'telesat_layer_2')
        # SatIAF = SatObj.QueryInterface(STKObjects.IAgSatellite)
        # # 查看当前卫星轨道预报模型
        # SatIAF.PropagatorType
        # # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
        # ProIAF = SatIAF.Propagator
        # # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
        # ProTwoBodyIAF = ProIAF.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
        # # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
        # ProTwoBodyIAF.InitialState.Representation.AssignClassical(3, 7696, 0, 51, 0, 0, 0)
        # # 传递参数
        # ProTwoBodyIAF.Propagate()
        # root.ExecuteCommand('Walker */Satellite/telesat_layer_2 Type Delta NumPlanes 20 NumSatsPerPlane 11 InterPlanePhaseIncrement 4 ColorByPlane Yes')
        # SatObj.Unload()
        #搭建Iridium星座
        SatObj = Sce.Children.New(18, 'Iridium')
        SatIAF = SatObj.QueryInterface(STKObjects.IAgSatellite)
        # 查看当前卫星轨道预报模型
        SatIAF.PropagatorType
        # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
        ProIAF = SatIAF.Propagator
        # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
        ProTwoBodyIAF = ProIAF.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
        # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
        ProTwoBodyIAF.InitialState.Representation.AssignClassical(3, 7151, 0, 86.4, 0, 0, 0)
        # 传递参数
        ProTwoBodyIAF.Propagate()
        root.ExecuteCommand('Walker */Satellite/Iridium Type Star NumPlanes 6 NumSatsPerPlane 11 InterPlanePhaseIncrement 4 ColorByPlane Yes')
        SatObj.Unload()
    #
    elif n == 2:
    #     #GEO
    #     SatObj = Sce.Children.New(18, 'GEO')
    #     SatIAF = SatObj.QueryInterface(STKObjects.IAgSatellite)
    #     # 查看当前卫星轨道预报模型
    #     SatIAF.PropagatorType
    #     # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
    #     ProIAF = SatIAF.Propagator
    #     # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
    #     ProTwoBodyIAF = ProIAF.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
    #     # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
    #     ProTwoBodyIAF.InitialState.Representation.AssignClassical(3,42871, 0, 0, 0, 0, 0)
    #     # 传递参数
    #     ProTwoBodyIAF.Propagate()
    #     # Connect命令，选择Delta类型形成Walker星座,总卫星数量24颗、4个轨道面、每个轨道面6颗卫星、相位因子1
    #     root.ExecuteCommand(
    #         'Walker */Satellite/GEO Type Delta NumPlanes 1 NumSatsPerPlane 6 InterPlanePhaseIncrement 0 ColorByPlane Yes')
    #     SatObj.Unload()
        #搭建Starlink星座
        SatObj = Sce.Children.New(18, 'Starlink')
        SatIAF = SatObj.QueryInterface(STKObjects.IAgSatellite)
        # 查看当前卫星轨道预报模型
        SatIAF.PropagatorType
        # 其返回值为7，表示预报模型为二体模型(ePropagatorTwoBody)
        ProIAF = SatIAF.Propagator
        # 由IAgVePropagator跳转至IAgVePropagatorTwoBody
        ProTwoBodyIAF = ProIAF.QueryInterface(STKObjects.IAgVePropagatorTwoBody)
        # 设置卫星坐标系为J2000，轨道六要素为7000km，0，60°，0°，0°，0°
        ProTwoBodyIAF.InitialState.Representation.AssignClassical(3, 6921, 0, 53, 0, 0, 0)
        # 传递参数
        ProTwoBodyIAF.Propagate()
        root.ExecuteCommand('Walker */Satellite/Starlink Type Delta NumPlanes 72 NumSatsPerPlane 22 InterPlanePhaseIncrement 45 ColorByPlane Yes')
        SatObj.Unload()

    df = pd.read_csv("D:/STK_Files/地面站.csv", encoding="utf-8", header=None)
    df_array = np.array(df)#将pandas读取的数据转化为array
    df_list = df_array.tolist()#将数组转化为list
    #输出地面站的数目
    print(len(df_list))
    #for i in range(len(df_list)):
    target1 = Sce.Children.New(STKObjects.eFacility, "target{}".format(j))
    target2 = target1.QueryInterface(STKObjects.IAgFacility)
    target2.Position.AssignGeodetic(df_list[j][2], df_list[j][3], df_list[j][4])
    #可见性分析
    ground_name = []
    sat_name = []
    start_time = []
    end_time = []

    sat_list = root.CurrentScenario.Children.GetElements(STKObjects.eSatellite)
    target_list = root.CurrentScenario.Children.GetElements(STKObjects.eFacility)
    num_sat = len(sat_list)
    num_target = len(df_list)

    for i in range(num_sat):  # 102
        access = target_list[0].GetAccessToObject(sat_list[i])
        print(target_list[0].InstanceName + '-' + sat_list[i].InstanceName)
        access.ComputeAccess()
        accessDP = access.DataProviders.Item('Access Data')
        accessDP2 = accessDP.QueryInterface(STKObjects.IAgDataPrvInterval)
        root.UnitPreferences.SetCurrentUnit("DateFormat", "EpSec")
        results = accessDP2.Exec(scenario2.StartTime, scenario2.StopTime)
        try:
            # j地面站对于i卫星的可见性起止时间
            accessStartTimes = results.DataSets.GetDataSetByName('Start Time').GetValues()  # 注意是个元组，有多个值
            accessStopTimes = results.DataSets.GetDataSetByName('Stop Time').GetValues()  # 注意是个元组，有多个值
            visibleInterval = list(zip(accessStartTimes, accessStopTimes))
            print("共%3d圈可见圈次：" %len(visibleInterval))
            for tempInterval in visibleInterval:

                
                print(tempInterval)
            for k in range(len(visibleInterval)):
                ground_name.append(target_list[0].InstanceName)
                sat_name.append(sat_list[i].InstanceName)
                start_time.append(accessStartTimes[k])
                end_time.append(accessStopTimes[k])
        except:
            print('卫星之间不可见')
            access.ClearAccess()#程序优化，便于构建拓扑
            ground_name.append(target_list[0].InstanceName)
            sat_name.append(sat_list[i].InstanceName)
            start_time.append(0)
            end_time.append(0)
    data = pd.DataFrame([ground_name, sat_name, start_time, end_time])
    data = data.T
    CSV_Save_str='D:\\STK_Files\\telesat_sawable\\'+'地面站'+str(GroundNum)+'星地可见性'+'.csv'
    data.to_csv(CSV_Save_str, header=['地面站节点', '卫星节点', '开始时间', '结束时间'], index=False,encoding='utf_8_sig')
    ground_name.clear()
    sat_name.clear()
    start_time.clear()
    end_time.clear()
if __name__ == '__main__':

    CalStartTime=time.time()  #Cal start time     5042(without speedup)
    process_list = []
    GroundNum=1
    while(GroundNum<=910):
        for i in range(GroundNum,GroundNum+1):  #开启8个子进程执行fun1函数
            p = Process(target=MultiProcessFunc,args=(i,)) #实例化进程对象
            p.start()
            process_list.append(p)

        for i in process_list:
            p.join()
        GroundNum+=1
    # for j in range(1,50):
    #     for i in range(1584):  # 102
    #         access = target_list[j].GetAccessToObject(sat_list[i])
    #         print(target_list[j].InstanceName + '-' + sat_list[i].InstanceName)
    #         access.ComputeAccess()
    #         accessDP = access.DataProviders.Item('Access Data')
    #         accessDP2 = accessDP.QueryInterface(STKObjects.IAgDataPrvInterval)
    #         root.UnitPreferences.SetCurrentUnit("DateFormat", "EpSec")
    #         results = accessDP2.Exec(scenario2.StartTime, scenario2.StopTime)
    #         try:
    #             # j地面站对于i卫星的可见性起止时间
    #             accessStartTimes = results.DataSets.GetDataSetByName('Start Time').GetValues()  # 注意是个元组，有多个值
    #             accessStopTimes = results.DataSets.GetDataSetByName('Stop Time').GetValues()  # 注意是个元组，有多个值
    #             visibleInterval = list(zip(accessStartTimes, accessStopTimes))
    #             print("共%3d圈可见圈次：" %len(visibleInterval))
    #             for tempInterval in visibleInterval: 
    #                 print(tempInterval)
    #             for k in range(len(visibleInterval)):
    #                 ground_name.append(target_list[j].InstanceName)
    #                 sat_name.append(sat_list[i].InstanceName)
    #                 start_time.append(accessStartTimes[k])
    #                 end_time.append(accessStopTimes[k])
    #         except:
    #             print('卫星之间不可见')
    #             access.ClearAccess()#程序优化，便于构建拓扑
    #             ground_name.append(target_list[j].InstanceName)
    #             sat_name.append(sat_list[i].InstanceName)
    #             start_time.append(0)
    #             end_time.append(0)
    CalEndtime=time.time()  #Cal end time
    print("Calculate Start time 1 is: ",CalStartTime)
    print("Calculate End time 1 is: ",CalEndtime)
    # data = pd.DataFrame([ground_name, sat_name, start_time, end_time])
    # data = data.T
    # data.to_csv(f'星地可见性{1}' + '.csv', header=['地面站节点', '卫星节点', '开始时间', '结束时间'], index=False,encoding='utf_8_sig')
    # ground_name.clear()
    # sat_name.clear()
    # start_time.clear()
    # end_time.clear()
    

    # data = pd.DataFrame([ground_name, sat_name, start_time,end_time])
    # data = data.T
    # data.to_csv('星地可见性_V3' + '.csv', header=['地面站节点', '卫星节点', '开始时间', '结束时间'], index=False,encoding='utf_8_sig')
    print('屏幕提示，例如按xxx键退出程序')
    keyboard.wait('q')  #此处设置按下 q/Q键退出




    # data = pd.DataFrame([ground_name, sat_name, start_time, end_time])
    # data = data.T
    # data.to_csv(f'星地可见性{25}' + '.csv', header=['地面站节点', '卫星节点', '开始时间', '结束时间'], index=False,encoding='utf_8_sig')
    # ground_name.clear()
    # sat_name.clear()
    # start_time.clear()
    # end_time.clear()

    # data = pd.DataFrame([ground_name, sat_name, start_time,end_time])
    # data = data.T
    # data.to_csv('星地可见性_V3' + '.csv', header=['地面站节点', '卫星节点', '开始时间', '结束时间'], index=False,encoding='utf_8_sig')
    # print('屏幕提示，例如按xxx键退出程序')
    # keyboard.wait('q')  #此处设置按下 q/Q键退出

