import pandas as pd
import Ground_To_Satellite_module as gsm
import seaborn as sns
import matplotlib.pyplot as plt
import openpyxl

sat_ground_path = 'D:\\STK_Files\\iridum_sawable\\'
save_ground_path = 'D:\\STK_Files\\traffic_generator\\traffic_generator\\Ground_traffic\\1000.xlsx'
starlink_path = 'D:\\STK_Files\\traffic_generator\\traffic_generator\\iridium\\iridum.xlsx'
save_satellite_path = 'D:\\STK_Files\\traffic_generator\\traffic_generator\\iridium\\inter_1000\\'

sat_ground_data = pd.read_csv("D:\\STK_Files\\iridum_sawable\\ground_1_sawable.csv") 
for i in range(910):
    try:
        path = sat_ground_path + "\\ground_" + str(i+1) + "sawable"+".csv"
        data = pd.read_csv(path)
        sat_ground_data = pd.concat([sat_ground_data,data])
    except:
        print("No ground facility ",i)
                                                                                                                                                                      
print("Finish sawable data input")
ground_matrix = pd.read_excel(save_ground_path, header=None) 

sate_num = pd.read_excel(starlink_path, header=None) 
sate_ref = {}
global_time = 1000  

for i in range(len(sate_num)):
    sate_ref[sate_num.loc[i][0]] = i

sat_matrix_all = []

for j in range(global_time):
    dst_ground_count=0
    print(j)
    ground_sat = gsm.cal_ground_sat(g_time=j, data=sat_ground_data)
    sat_matrix = [[0] * len(sate_ref) for _ in range(len(sate_ref))]
    
    for i in range(910):
        dst_ground=[]
        dst_ground_value=[]
        print(i)
        src_ground = 'target' + str(i+1)
        dst_column = int(2 * j)
        if(ground_matrix.loc[dst_ground_count][dst_column]=='*'): 
            dst_ground_count=dst_ground_count+1
            while(1):
                if(ground_matrix.loc[dst_ground_count][dst_column]=='/'):
                    dst_ground_count=dst_ground_count+1
                    break
                dst_ground.append('target' + str(int(ground_matrix.loc[dst_ground_count][dst_column])+1))
                dst_ground_value.append(ground_matrix.loc[dst_ground_count][dst_column+1])
                dst_ground_count=dst_ground_count+1
        src_sat = ground_sat[src_ground]
        dst_ground_value_count=0
        for destination_ground in dst_ground:
            dst_sat = ground_sat[destination_ground]
            print(src_ground, destination_ground, src_sat, dst_sat)
            if src_sat != dst_sat:
                value = dst_ground_value[dst_ground_value_count]
                for Origin in src_sat:
                    Origin=sate_ref[Origin]
                    for Destination in dst_sat:
                        if(Origin != sate_ref[Destination]):
                            Destination=sate_ref[Destination]
                            sat_matrix[Origin][Destination] = sat_matrix[Origin][Destination] + value
            dst_ground_value_count=dst_ground_value_count+1
    sat_matrix_all.extend(sat_matrix)

    if (j + 1) % 1 == 0: 
        workbook = openpyxl.Workbook()  

        sheet = workbook.active  

        for row in sat_matrix_all:  
            sheet.append(row)  
        Name=save_satellite_path + str(j + 1) + '.xlsx'
        workbook.save(Name)
        sat_matrix_all = []

ax = sns.heatmap(sat_matrix, cmap="YlGnBu", xticklabels=11, yticklabels=False)
plt.show()