import datetime
import os
import time

import pandas as pd
import win32com.client

target_excel_dir = r'D:\STK_Files'
if not os.path.exists(target_excel_dir):
    os.makedirs(target_excel_dir)

app = win32com.client.Dispatch('STK11.Application')
app.Visible = True
root = app.Personality2
root.NewScenario('Beidou3G2') 
scenario = root.CurrentScenario
root.UnitPreferences.SetCurrentUnit('DateFormat', 'UTCG')
root.CurrentScenario.StartTime = '8 Jun 2020 16:00:00.00'
root.CurrentScenario.StopTime = '10 Jun 2020 04:00:00.00'


def createSatellite(path_tle, starttime, stoptime):

    satellite = root.CurrentScenario.Children.New(
        18, 'Beidou3G2') 
    satellite.SetPropagatorType(4) 
    propagator = satellite.Propagator
    propagator.UseScenarioAnalysisTime
    propagator.CommonTasks.AddSegsFromFile(
        '45344', path_tle)
    propagator.AutoUpdateEnabled = True
    propagator.Propagate()
    satOrbitDP = satellite.DataProviders.GetDataPrvTimeVarFromPath(
        'Classical Elements/J2000')
    results_orbit = satOrbitDP.Exec(
        starttime, stoptime, 300)
    satLLADP = satellite.DataProviders.GetDataPrvTimeVarFromPath(
        'LLA State/Fixed')
    results_LLA = satLLADP.Exec(
        starttime, stoptime, 300)
    sat_time = results_orbit.DataSets[0].GetValues()
    sat_sma = results_orbit.DataSets[1].GetValues()
    sat_inc = results_orbit.DataSets[3].GetValues()
    sat_lat = results_LLA.DataSets[1].GetValues()
    sat_lon = results_LLA.DataSets[2].GetValues()
    Data = pd.DataFrame(
        columns=('Time (UTC)',
                 'Semi-major Axis (km)', 'Inclination (deg)',
                 'latitude (deg)', 'longitude (deg)'))
    Data_a = pd.DataFrame(columns=('Time', 'Semi-major Axis (km)'))
    for j in range(0, len(sat_time)):
        t = sat_time[j].split('.', 1)[0]
        t_stamp = time.strptime(t, '%d %b %Y %H:%M:%S')
        t_stamp = time.mktime(t_stamp) / 3600
        t = datetime.datetime.strptime(t, '%d %b %Y %H:%M:%S')
        t = datetime.datetime.strftime(t, '%Y-%m-%d %H:%M:%S')
        sma = sat_sma[j]
        inc = sat_inc[j]
        lat = sat_lat[j]
        lon = sat_lon[j]
        Data_a = Data_a._append(pd.DataFrame(
            {'Time': [t_stamp], 'Semi-major Axis (km)': [sma]}),
            ignore_index=True)
        print(Data_a.head())
        Data = Data._append(pd.DataFrame(
            {'Time (UTC)': [t],
             'Semi-major Axis (km)': [sma], 'Inclination (deg)': [inc],
             'latitude (deg)': [lat], 'longitude (deg)': [lon]}),
            ignore_index=True)
        print(Data.head())
    Data.to_excel(target_excel_dir + '/' + 'test.xlsx',
                  'sheet1', float_format='%.3f', index=False)
    Data_a.to_excel(target_excel_dir + '/' + 'test.xlsx',
                    'sheet1', float_format='%.3f', index=False)

path_tle = r'D:/STK_Files/beidou3.txt'
t1 = scenario.StartTime
t2 = scenario.StopTime
t3 = '9 Jun 2020 04:00:00.00'
t4 = '9 Jun 2020 16:00:00.00'
createSatellite(path_tle,t1,t2)
