function x = ProjectOntoRn_Plus_HS(x,a,b)
% PROJECTONTOHS Projects point onto intersection of R_n^+ 
% and halfspace a'*x <= b
% if (all(x < 0) && dot(a,x) > b)
%   error('No intersection.');
% end
% check if the point is inside the set
if all(x >= 0) && dot(a,x) <= b
    return;
end

% Project onto Hs and check if it is in Rn+
y = ProjectOntoHS(x,a,b);
% disp(y);
if all(y >= 0)
    x = y;
    return;
end
% Project onto Rn+ and check if it is in HS
z = ProjectOntoRn_Plus(x);
if dot(a,z) <= b
    x = z;
    return;
end
% Project onto Hs and then move to the intersection
% for i = 1:size(y)
%     if y(i) <= 0
%         y(i) = 0;
%     else 
%         y(i) = b/a(i);
%     end
%     x = y;
% end
% Approach1: use cvx solver. Take too long
% x = ProjectOntoRn_Plus_HS_CVX(x,a,b);

% Approach2: modify projection onto a simplex
% x = proj_wsplx(x,a,b);

% Approach3: alternating projection/averaging projection
% for i = 1:100
%     x = ProjectOntoHS(x,a,b);
%     x = ProjectOntoRn_Plus(x);
% end

% Approach4: Dykstra's projection algorithm
n = length(x);
p = zeros(n,1);
q = zeros(n,1);
for i = 1:100
    y = ProjectOntoHS(x+p,a,b);
    p = x + p - y;
    x = ProjectOntoRn_Plus(y+q);
    q = y + q - x;
end

return;