# R$^2$-Gaussian: Rectifying Radiative Gaussian Splatting for Tomographic Reconstruction

This repository contains the offical implementation of paper "R$^2$-Gaussian: Rectifying Radiative Gaussian Splatting for Tomographic Reconstruction".

![cover](assets/cover.png)

## Method overview

A 3DGS-based framework for 3D CT reconstruction.
![pipeline](assets/pipeline.png)

## Environment setup

We recommend using [Conda](https://docs.conda.io/en/latest/miniconda.html) to set up an environment.

```sh
conda create -n r2_gaussian python=3.9 -y
conda activate r2_gaussian

pip install -r requirements.txt
pip install torch==1.12.0+cu116 torchvision==0.13.0+cu116 --extra-index-url https://download.pytorch.org/whl/cu116

pip install -e submodules/xray-gaussian-rasterization-voxelization
pip install -e submodules/simple-knn
```

## Dataset

Follow this [instruction](data_generator/README.md) to generate datasets and put them into `data` folder.

![gt_demo](assets/gt_demo.png)

## Training and evaluation

Use `train.py` to train Gaussians.

```sh
# Train 0_chest_cone
python train.py --config configs/full_model.yml \
    -s data/cone_ntrain_50_angle_360/0_chest_cone \
    -m output/cone_ntrain_50_angle_360/0_chest_cone
```

Testing are performed during training. You can check the test results with `tensorboard` or use `test.py` to evaluate the trained Gaussians.

```sh
# Test 0_chest_cone
python test.py -m output/cone_ntrain_50_angle_360/0_chest_cone
```

## Citation

If you find our code or paper useful, please cite as:

```sh
not released yet.
```

## Acknowledgement

We thank the following authors for their excellent works.

* [Gaussian Splatting](https://github.com/graphdeco-inria/gaussian-splatting)
* [TIGRE toolbox](https://github.com/CERN/TIGRE.git)

## License

R$^2$-Gaussian
The code is released under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International Public License for Noncommercial use only. Any commercial use should get formal permission first.

[Gaussian Splatting](https://github.com/graphdeco-inria/gaussian-splatting/blob/main/LICENSE.md)
Inria and the Max Planck Institut for Informatik (MPII) hold all the ownership rights on the Software named gaussian-splatting. The Software is in the process of being registered with the Agence pour la Protection des Programmes (APP).
