export CUDA_VISIBLE_DEVICES=0

$TRAIN_DATA_PATH=$1
$VALID_DATA_PATH=$2
$CKPT_PATH=$3
$WORK_DIR=$4

python -m torch.distributed.launch --nproc_per_node=1 src/gpt2_ft.py \
    --train_data $TRAIN_DATA_PATH \
    --valid_data $VALID_DATA_PATH \
    --train_batch_size 8 \
    --grad_acc 1 \
    --valid_batch_size 4 \
    --seq_len 512 \
    --model_card gpt2.md \
    --init_checkpoint $CKPT_PATH \
    --platform local \
    --clip 0.0 \
    --lr 0.0002 \
    --weight_decay 0.01 \
    --correct_bias \
    --adam_beta2 0.999 \
    --scheduler linear \
    --warmup_step 500 \
    --max_epoch 5 \
    --save_interval 1000 \
    --lora_dim 4 \
    --lora_alpha 32 \
    --lora_dropout 0.1 \
    --label_smooth 0.1 \
    --work_dir $WORK_DIR \
    --random_seed 0 \
    --nxr \
    --xr_mu0 0.25
