# Balancedness-aware regularization (BAR) on GPT-2 

This folder contains the implementation of BAR.

Our implementation is based on the fine-tuning code for GPT-2 in [HuggingFace](https://huggingface.co/) and [LoRA](https://github.com/microsoft/LoRA/tree/main).

### Installation

This code is tested with `Python 3.7.10` and `torch 1.9.0`.

More on environments can be found in `environment.yml`. You can also create one using commands below.
```bash
conda env create -n bar -f environment.yml
conda activate bar
```

### Data preparation

Please copy the folder `./data`, and script `create_datasets.sh` from [LoRA repo](https://github.com/microsoft/LoRA/tree/main).
```bash
bash create_datasets.sh
```

Please also find the `vocab` folder from [LoRA repo](https://github.com/microsoft/LoRA/tree/main/examples/NLG/vocab), and put it into `./BAR/`

### Download pretrained model

Please find the `download_pretrained_checkpoints.sh` from [LoRA repo](https://github.com/microsoft/LoRA/tree/main).
```bash
bash download_pretrained_checkpoints.sh
```

### Testing with WebNLG

Please copy the folder `./eval` from [LoRA repo](https://github.com/microsoft/LoRA/tree/main).

Train, generation, decode, test 4-in-1:

```bash
bash bar-train-gen-decode-eval.sh
```
Note that if this is your first run of above cmd, you have to run the code below before evaluation:

```bash
cd eval
bash download_evalscript.sh
cd ..
```
