import orjson, os

LOAD_DIR = "/fs/cml-projects/E2H/Codeforces/contest_solution/contest_solution_json"
SAVE_DIR = "/fs/cml-projects/E2H/Codeforces/contest_solution/contest_solution_jsonl_extract"

### Only repeat this part when the session is expired

def check_solution(file_name):
    with open(f"{LOAD_DIR}/{file_name}.json", "r") as f:
        a = f.read()
        solution_dict = orjson.loads(a)
    extracted_dict = {"source":solution_dict["source"]}

    input_list = []
    output_list = []
    answer_list = []
    length_list = []

    if "testCount" not in solution_dict.keys():
        return
    elif int(solution_dict["testCount"])==0:
        return

    for n in range(1, int(solution_dict["testCount"])+1):
        try:
            input_list.append(solution_dict[f"input#{n}"])
            output_list.append(solution_dict[f"output#{n}"])
            answer_list.append(solution_dict[f"answer#{n}"])
            length_list += [len(solution_dict[f"input#{n}"]), len(solution_dict[f"output#{n}"]), len(solution_dict[f"answer#{n}"]),]
        except:
            break

    max_length = max(length_list)
    if max_length in [258, 514]:
        for idx, input in enumerate(input_list):
            if len(input)==max_length:
                input_list[idx] = None
        
        for idx, output in enumerate(output_list):
            if len(output)==max_length:
                output_list[idx] = None

        for idx, answer in enumerate(answer_list):
            if len(answer)==max_length:
                answer_list[idx] = None

    extracted_dict["testcase"] = {"inputs": input_list, "outputs": output_list, "answers": answer_list}

    with open(f"{SAVE_DIR}/{file_name}.jsonl", "w") as wf:
        json_line = orjson.dumps(extracted_dict, option=orjson.OPT_NAIVE_UTC | orjson.OPT_SERIALIZE_NUMPY)
        wf.write(f"{str(json_line, encoding='utf-8')}")


def main():
    file_name_list = sorted(os.listdir(LOAD_DIR))
    for file_name in file_name_list:
        file_true_name, _ = os.path.splitext(file_name)
        check_solution(file_true_name)
    

if __name__ == "__main__":
    main()
