/*
    Propositional logic (week 1).
*/

/**

# Propositions and implications

*/

lemma implies_self : [('P : prop) -> ['P -> 'P]] {
    intro P : prop.
    intro p : P.
}

theorem modus_ponens : [('P : prop) -> ('Q : prop) -> /* Let 'P and 'Q be any propositions. */
                        'P -> /* Suppose 'P is true. */
                        ['P -> 'Q] -> /* Suppose that 'P true implies 'Q true. */
                        'Q /* Then, we will show that 'Q is true. */
                        ] {
    intro P : prop.
    intro Q : prop.
    intro p : P.
    intro h : [P -> Q].

    show Q by h.
}

/*** @exercise */
theorem modus_ponens_chain : [('P : prop) -> ('Q : prop) -> ('R : prop) -> /* Let 'P, 'Q and 'R be any propositions. */
                              'P -> /* Suppose 'P is true. */
                              ['P -> 'Q] -> /* Suppose that 'P true implies 'Q true. */
                              ['Q -> 'R] -> /* Also suppose that 'Q true implies 'R true. */
                              'R /* Then, we will show that 'R must be true. */
                        ] {
    intro P : prop.
    intro Q : prop.
    intro R : prop.
    intro p : P.
    intro hpq : [P -> Q].
    intro hqr : [Q -> R].

    show Q by hpq.
    show R by hqr.
}

lemma implies_transitive : [('P : prop) -> ('Q : prop) -> ('R : prop)
                            -> ['P -> 'Q] -> ['Q -> 'R] -> ['P -> 'R]] {
    intro P : prop.
    intro Q : prop.
    intro R : prop.
    intro h1 : [P -> Q].
    intro h2 : [Q -> R].

    current goal : [P -> R].

    intro hp : P.

    current goal : R.

    show Q by h1.
    show R by h2.
}

/*** @exercise */
lemma implies_transitive_2 : [('P : prop) -> ('Q : prop) -> ('R : prop) -> ('S : prop) -> ('T : prop)
                              -> ['P -> 'Q] -> ['S -> 'T] -> ['Q -> 'S] -> ['T -> 'R] -> ['P -> 'R]] {
    intro P : prop.
    intro Q : prop.
    intro R : prop.
    intro S : prop.
    intro T : prop.
    intro h1 : [P -> Q].
    intro h2 : [S -> T].
    intro h3 : [Q -> S].
    intro h4 : [T -> R].
    intro h5 : P.

    show Q by h1.
    show S by h3.
    show T by h2.
    show R by h4.
}

/**

# Logical connectives

*/

/*

## And - when we know more than a thing.

*/

and : [prop -> prop -> prop].
axiom and_intro : [('P : prop) -> ('Q : prop) -> 'P -> 'Q -> (and 'P 'Q)].

axiom and_elim_l : [('A : prop) -> ('B : prop) -> (and 'A 'B) -> 'A].
axiom and_elim_r : [('A : prop) -> ('B : prop) -> (and 'A 'B) -> 'B].

theorem and_self : [('P : prop) -> 'P -> (and 'P 'P)] {
    intro P : prop.
    intro h : P.
    show (and P P) by and_intro.
}

theorem and_comm : [('P : prop) -> ('Q : prop) -> (and 'P 'Q) -> (and 'Q 'P)] {
    intro P : prop.
    intro Q : prop.
    intro h : (and P Q).

    show P by and_elim_l.
    show Q by and_elim_r.
    show (and Q P) by and_intro.
}

theorem and_trans : [('P : prop) -> ('Q : prop) -> ('R : prop) ->
                     (and 'P 'Q) -> (and 'Q 'R) -> (and 'P 'R)] {
    intro P : prop.
    intro Q : prop.
    intro R : prop.

    intro h1 : (and P Q).
    intro h2 : (and Q R).

    show P by and_elim_l.
    show R by and_elim_r.
    show (and P R) by and_intro.
}

/*

## Negation - when things aren't true.

*/

false : prop.

not : [prop -> prop] = (lambda ('P : prop) ['P -> false]).

theorem contradiction : [('P : prop) -> 'P -> (not 'P) -> false] {
    intro P : prop.
    intro h : P.
    intro h2 : (not P).
    show false by modus_ponens.
}

theorem modus_tolens : [('P : prop) -> ('Q : prop) -> ['P -> 'Q] -> [(not 'Q) -> (not 'P)]] {
    /* Let P and Q be two propositions. */
    intro P : prop.
    intro Q : prop.

    /* Suppose P implies Q */
    intro p_implies_q : [P -> Q].
    /* We now must show that not Q implies not P. */
    current goal : [(not Q) -> (not P)].

    /* To show the implication, suppose Q is false. */
    intro q_false : (not Q).

    /* We must show that, under these assumptions, P is false. */
    current goal : (not P).

    /* Suppose P is true. We then have to show that this leads to absurd (false). */
    intro p_true : P.

    /* Since P implies Q, Q is also true. */
    show Q by p_implies_q.

    /* But we're under the assumption that Q is false. Thus, we have both Q and not Q -- contradiction! */
    apply contradiction.
}

/*

## Or - when there are cases to consider.

*/

/* or is a binary proposition -- when A and B are propositions, so is (or A B). */
or : [prop -> prop -> prop].

/* If any proposition P is true, then P or Q is also true for any Q. */
/* These are the two fundamental ways to prove P or Q -- you choose one of them and prove it. */
axiom or_intro_l : [('P : prop) -> 'P -> ('Q : prop) -> (or 'P 'Q)].
axiom or_intro_r : [('P : prop) -> 'P -> ('Q : prop) -> (or 'Q 'P)].

/* If you know that P or Q is true, how might you use this fact?
   For any R you want to prove, knowing P or Q, it is enough to show both P -> Q and Q -> R.
   The utility of "or" is that in each case you gain an additional assumption. */

axiom or_elim : [('P : prop) -> ('Q : prop) -> (or 'P 'Q) ->
                 ('R : prop) -> ['P -> 'R] -> ['Q -> 'R] -> 'R].

/* Let's start by proving the simplest propositions with or.
   If you want to prove that either A or B is true, it suffices to choose one of them and prove that proposition. */
lemma or_easy_left : [('P : prop) -> ('Q : prop) -> (or ['P -> 'P] ['P -> 'Q])] {
      intro P : prop.
      intro Q : prop.

      /* We now must show that either P implies P, or P implies Q. We get the choice:
         which one would you prefer to prove? */
      apply or_intro_l.
      goal [P -> P] {
          apply implies_self.
      }
      /* Obviously, had we applied or_intro_r, we wouldn't have enough information to show that P implies
         an arbitrary Q. */
}

/*
    Let's see a simple case. Let's say we know that either P is true and P implies Q, or both R is true and R implies Q.
    Then, we must be able to show that Q is true (unconditionally).
*/

lemma or_example : [('P : prop) -> ('Q : prop) -> ('R : prop) ->
                    (or (and 'P ['P -> 'Q]) (and 'R ['R -> 'Q])) -> 'Q] {
    intro P : prop.
    intro Q : prop.
    intro R : prop.
    intro h : (or (and P [P -> Q]) (and R [R -> Q])).

    current goal : Q.

    apply or_elim.
    goal [(and P [P -> Q]) -> Q] {
        intro h_and : (and P [P -> Q]).
        show P by and_elim_l.
        show [P -> Q] by and_elim_r.
        show Q by modus_ponens.
    }
    goal [(and R [R -> Q]) -> Q] {
        intro h_and : (and R [R -> Q]).
        show R by and_elim_l.
        show [R -> Q] by and_elim_r.
        show Q by modus_ponens.
    }
}
