# Prepare Datasets for OWVISCapTor

A dataset can be used by accessing [DatasetCatalog](https://detectron2.readthedocs.io/modules/data.html#detectron2.data.DatasetCatalog)
for its data, or [MetadataCatalog](https://detectron2.readthedocs.io/modules/data.html#detectron2.data.MetadataCatalog) for its metadata (class names, etc).
This document explains how to setup the builtin datasets so they can be used by the above APIs.
[Use Custom Datasets](https://detectron2.readthedocs.io/tutorials/datasets.html) gives a deeper dive on how to use `DatasetCatalog` and `MetadataCatalog`,
and how to add new datasets to them.

OWVISCapTor has builtin support for a few datasets.
The datasets are assumed to exist in a directory specified by the environment variable
`DETECTRON2_DATASETS`.
Under this directory, detectron2 will look for datasets in the structure described below, if needed.
```
$DETECTRON2_DATASETS/
  burst/
  vidstg/
```

You can set the location for builtin datasets by `export DETECTRON2_DATASETS=/path/to/datasets`.
If left unset, the default is `./datasets` relative to your current working directory.


## Expected dataset structure for BURST dataset:

```
burst/
  {train,valid,test}.json
  frames/
    {train,val,test}/
  annotations/
    {train,val,test}/
      {all_classes, uncommon_classes, common_classes}.json


```
Download the BURST data and run datasets/convert_burst.py to get the above structure.

## Expected dataset structure for VidSTG dataset:

```
vidstg/
  {train,valid,test}.json
  video/
```
Download the VidSTG data and run datasets/convert_vidstg.py to get the above structure.
