/* Copyright 2023 TU Graz
   Author: Michael Kerber
   
   This file is part of function_delaunay
   
   function_delaunay is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   function_delaunay is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with function_delaunay.  If not, see <https://www.gnu.org/licenses/>.
*/


#pragma once

namespace function_delaunay {

  struct Point_with_density {
    std::vector<double> x;
    double density;
    template<typename Iterator>
    Point_with_density(Iterator begin, Iterator end,double density)
      : density(density) {
      std::copy(begin,end,std::back_inserter(x));
    }
    int dimension() const {
      return x.size();
    }
  };
  
  struct Sort_by_density {
    bool operator() (Point_with_density& a, Point_with_density& b) {
      return a.density<b.density;
    }
  };
}
