#!/bin/bash

if [ -d Data/Pointcloud_Graphs ]
then
     rm -r Data/Pointcloud_Graphs
     mkdir Data/Pointcloud_Graphs
else
     mkdir Data/Pointcloud_Graphs
fi

let n=`ls -1 Data/Pointcloud_Presentations | wc -l`
let n=n-1

start=$(date +%s)

for i in $(seq 0 $n)
do
	./Graphcode/graphcode --primary-parameter 1 --slices 10 --relevance-threshold 0.1  ./Data/Pointcloud_Presentations/$i.txt  ./Data/Pointcloud_Graphs/$i.txt      #Shape
#	./Graphcode/graphcode --primary-parameter 1 --slices 10 --relevance-threshold 0  ./Data/Pointcloud_Presentations/$i.txt  ./Data/Pointcloud_Graphs/$i.txt        #Processes
#	./Graphcode/graphcode --primary-parameter 1 --slices 10 --relevance-threshold 0.002  ./Data/Pointcloud_Presentations/$i.txt  ./Data/Pointcloud_Graphs/$i.txt    #Orbit
#	./Graphcode/graphcode --primary-parameter 1 --slices 10 --relevance-threshold 0.1 --do-random-shuffles ./Data/Pointcloud_Presentations/$i.txt  ./Data/Pointcloud_Graphs/$i.txt      #Shape random shuffle
#	./Graphcode/graphcode --primary-parameter 1 --slices 10 --relevance-threshold 0.1 --do-exhaustive-reduction ./Data/Pointcloud_Presentations/$i.txt  ./Data/Pointcloud_Graphs/$i.txt      #Shape exhaustive reduction
done

end=$(date +%s)

echo
echo "Time Graphcode: $(($end-$start)) seconds"
