#!/bin/bash

export WANDB_MODE=disabled

# Optionally set the cache for transformers
export TRANSFORMERS_CACHE=path

export n=25
export model=$1 # llama2 or starling

# Create results folder if it doesn't exist
if [ ! -d "../results" ]; then
    mkdir "../results"
    echo "Folder '../results' created."
else
    echo "Folder '../results' already exists."
fi

CUDA_LAUNCH_BLOCKING=1 python -u path > rpov2.txt \
    --config=path \
    --config.attack=gcg \
    --config.train_data=path  \
    --config.result_prefix=path \
    --config.progressive_goals=False \
    --config.control_init="since~~~~addr [!( [ [ [ Sorry5] [ [ [ allow [ [ [ [ [" \
    --config.stop_on_success=True \
    --config.num_train_models=1 \
    --config.allow_non_ascii=False \
    --config.n_train_data=$n \
    --config.n_test_data=30 \
    --config.n_steps=2000 \
    --config.test_steps=50 \
    --config.batch_size=16 \
    --config.selection_interval=100 \
