from mymodels.resnet import myresnet18, myresnet34, myresnet50, myresnet101, myresnet152, \
                            ResNet18_Weights, ResNet34_Weights, ResNet50_Weights, ResNet101_Weights, ResNet152_Weights
from mymodels.densenet import mydensenet121, mydensenet161, mydensenet169, mydensenet201, \
                              DenseNet121_Weights, DenseNet161_Weights, DenseNet169_Weights, DenseNet201_Weights

WEIGHTS_NAME_DICT = {
    'resnet18': 'ResNet18_Weights.IMAGENET1K_V1',
    'densenet121': 'DenseNet121_Weights.IMAGENET1K_V1',
    'vit_b_16': 'ViT_B_16_Weights.IMAGENET1K_V1',
    'vgg13': 'VGG13_Weights.IMAGENET1K_V1'
}

WEIGHTS_DICT = {
    'resnet18': ResNet18_Weights.IMAGENET1K_V1,
    'resnet34': ResNet34_Weights.IMAGENET1K_V1,
    'resnet50_v1': ResNet50_Weights.IMAGENET1K_V1,
    'resnet50_v2': ResNet50_Weights.IMAGENET1K_V2,
    'resnet101_v1': ResNet101_Weights.IMAGENET1K_V1,
    'resnet101_v2': ResNet101_Weights.IMAGENET1K_V2,
    'resnet152_v1': ResNet152_Weights.IMAGENET1K_V1,
    'resnet152_v2': ResNet152_Weights.IMAGENET1K_V2,
    'densenet121': DenseNet121_Weights.IMAGENET1K_V1,
    'densenet161': DenseNet161_Weights.IMAGENET1K_V1,
    'densenet169': DenseNet169_Weights.IMAGENET1K_V1,
    'densenet201': DenseNet201_Weights.IMAGENET1K_V1,
}

MODEL_DICT = {
    'resnet18': myresnet18,
    'resnet34': myresnet34,
    'resnet50_v1': myresnet50,
    'resnet50_v2': myresnet50,
    'resnet101_v1': myresnet101,
    'resnet101_v2': myresnet101,
    'resnet152_v1': myresnet152,
    'resnet152_v2': myresnet152,
    'densenet121': mydensenet121,
    'densenet161': mydensenet161,
    'densenet169': mydensenet169,
    'densenet201': mydensenet201,
}