

from all_functions import * 
import argparse
import time


def main(args):
    
    with open(args.datapath,"rb") as handle:
        og_data = pickle.load(handle)
        samples = get_samples(og_data, args.samplesize, iterations=args.iter)
        
        samples_modified = []
        for s in samples:
            cdf_normalized = cdf_normalization(s,log=True)
            multivariate_format_dict = {}
            for k, v in cdf_normalized.items():
                all_metrics_vals = np.array(list(v.values()))
                multivariate_format_dict[k] = all_metrics_vals.T      
            samples_modified.append(multivariate_format_dict)

                     
        
        tests_time = []
        all_tests = []
        for p in samples_modified:
            start = time.time()
            all_tests.append(get_mv_testing(p,loss="logistic",abs_test=False,abs_tau=0.25,beta=0.2))
            end = time.time()
            exec_time = end-start
            tests_time.append(exec_time)
                    
        
        op = {}
        op['data'] = samples
        op['preprocessed_data'] = samples_modified
        op['rel_testing'] = all_tests        
        with open(f"{args.savepath}_relTest.pickle", 'wb') as handle:
            pickle.dump(op, handle, protocol=pickle.HIGHEST_PROTOCOL)
        
        timing = {}
        
        timing['testing_timing'] = tests_time
        
        
        with open(f"{args.savepath}_timing.pickle", 'wb') as handle:
            pickle.dump(timing, handle, protocol=pickle.HIGHEST_PROTOCOL)

    return 


















if __name__ == "__main__":    
    
    parser = argparse.ArgumentParser(description='Sample Based Ranks Script')
    parser.add_argument('--samplesize', type=int, help='Sample Size')
    parser.add_argument('--iter', type=int, help='Iterations')
    parser.add_argument('--datapath', help='Pickle path')
    parser.add_argument('--savepath', help='Output Pickle path')
    args = parser.parse_args()
    main(args)
    