## Train
```
python main.py \
    --model_name ems-transposenet \
    --mode train \
    --backbone_path ./models/backbones/efficient-net-b0.pth \
    --dataset_path DATASET_PATH \
    --scene all \
    --labels_file ./datasets/7Scenes/all_scenes.csv \
    --config_file 7Scenes_config.json \
    --save_dir ./out \
    --experiment EXP_NAME \
    --gpu GPU_NUM
```

## Test
```
for scene in heads fire stairs chess pumpkin office redkitchen
do
    python main.py \
        --model_name ems-transposenet \
        --mode test \
        --backbone_path ./models/backbones/efficient-net-b0.pth \
        --dataset_path DATASET_PATH \
        --scene ${scene} \
        --labels_file ./datasets/7Scenes/${scene}_test.csv \
        --config_file 7Scenes_config.json \
        --checkpoint_path CHECKPOINT_PATH \
        --save_dir ./out \
        --experiment EXP_NAME \
        --gpu GPU_NUM
done
```