# RanDumb
 
This repository contains simplified code for the paper:

**Random Representations Outperform Online Continually Learned Representations**  
Anonymous


## Libraries and Data Setup

* Setup scripts to run the code on a Python 3.x by:
```	
# Get all the required datasets into the 'data/' folder
# Setup the feature files in the directory `feats/` 
python get_feats.py 
python get_feats_vit.py
```
 
## Usage

* To run the RanDumb model, you can simply specify conditions from arguments, an example command below:
```
$ python main.py --dataset cifar100 --model SLDA --augment --embed --embed_mode RanDumb --embed_dim 25000
```

Arguments you can freely tweak given a dataset and model: 
  - Use RanDumb or RanPAC embedding function (`--embed_mode`)
  - Embedding Dimension (`--embed_dim`)
  - Use Flip Augmentation (`--augment`)
  - Switch mahalanobis distance on/off (`--model SLDA` or `--model NCM`)
  - Switch embedding on/off (`--embed`) 

Additional details and default hyperparameters can be found in `parse_args` function in `src/main.py` 
  
- Script to run RanDumb experiments given in `scripts/runall.sh`

**Notes:** Code given here is not online. Explanation below for why it does not vary from an online version. 
 
- **Computing covariance:** It is an exact rank-1 update to compute empirical covariance, so the matrix should be the same. (Also the online code is very slow to run)!
- **Shrinkage estimation:** We want the shrinked covariance. We use OAS method to obtain shrinkage parameters, but note that those parameters are a function of the empirical covariance matrix and again can be perfectly estimated online.
- **Please add extra lambda when inverting for exact reproducibility:** Goal here is simplicity at the cost of *slightly* worse results than original code used for the paper.

Overall, this code reaches similar performance for most tested cases.
