% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_db.R
\name{accuracy_db}
\alias{accuracy_db}
\title{Generate the accuracy database}
\usage{
accuracy_db(
  accuracy_db_dir = "accuracy_db",
  cor_types = c("loose_pearson", "cor_pearson", "sharp_pearson", "cor_spearman",
    "cor_kendall", "cor_dhsic", "cor_dcor", "cor_mic", "cor_xicor"),
  scenario_type = c("accuracy", "Xks"),
  ...
)
}
\arguments{
\item{accuracy_db_dir, }{the way to store the accuracy files}

\item{cor_types, }{which correlations will be calculated}

\item{scenario_type, }{which type of scenarios will be selected}
}
\value{
several accuracy_XXXXX_.rda files are generated at the specified directory
}
\description{
To generate the accuracy database and save it into a certain directory
}
\details{
The workflow for complete accuracy analysis is as follows: 
\enumerate{
  \item Call accuracy_db() to generate the basic results
  \item Call accuracy_results_frm_db() to generate the accuracy results data.frame
  \item Call accuracy_plot_lite() to draw the figures
}


scenario_type = "accuracy", 50 monotonic functions along with 
16 nonmonotonic scenarios are taken into consideration.

scenario_type = "Xks", y <- X^k with k = seq(1, 10, by = 0.1) are involved. 
 
Make sure a sub-folder named as "accuracy_db" under the current work directory 
is created before running this function. Another choice is to specify 
the accuracy_db_dir to an existing empty folder.
}
