% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_analysis.R
\name{accuracy_analysis}
\alias{accuracy_analysis}
\title{Basic function for accuracy analysis}
\usage{
accuracy_analysis(
  x_strs = "runif(512)",
  y_strs = c("y <- x", "y <- x^3"),
  cor_strs = three_cor_funs(),
  SNRs = dB_to_SNR(-50:50),
  nround = 10,
  ...
)
}
\arguments{
\item{x_strs, }{code string to generate x, with 'runif(512)' as default}

\item{y_strs, }{scenarios, with c("y <- x", 'y <- x^3') as default}

\item{cor_strs, }{correlation functions, with three_cor_funs() as default}

\item{SNRs, }{noise levels, with dB_to_SNR(-50:50) as default}

\item{nround, }{times of repetition, for robust estimation, with 10 as default}
}
\value{
a data.frame containing the correlation coefficient values of different types in different scenarios at different noise levels
}
\description{
To calculate the correlation scores in different scenarios at different noise levels
}
\details{
The core function for accuracy analysis, 
usually as a workhorse called by accuracy_db()


Since the ground truth, which can be calculated on the basis of noise level, 
and the measured value are both returned,  
the result of this function can be further utilize 
to evaluate the accuracy for correlation statistics.

For efficiency, parallel computation is adopted here.

The algorithm automatically detects how many logical cores can be employed,
and parallel::detectCores() - 1 cores are actually used for this task.
}
