# Polyhedral Complex Derivation from Piecewise Trilinear Networks

Welcome to the `tropical-nerf` repository! This project provides the source code used in the work of "Polyhedral Complex Derivation from Piecewise Trilinear Networks". The code is designed to be linear-time efficient using the predefined PyTorch library (v1.13+), making it easy to integrate into your workflows with the package of `tropical`.

### Getting Started

#### Installation

To set up the required Python packages, run the following command in your terminal:

```bash
pip install -r requirements.txt
```

#### Preparation

This command will install the necessary dependencies for the project, ensuring a smooth execution of the provided code.

For the Stanford 3D Scanning repository,
```bash
wget http://graphics.stanford.edu/pub/3Dscanrep/bunny.tar.gz -P tropical/stanford
tar xvf tropical/stanford/bunny.tar.gz -C tropical/stanford

wget http://graphics.stanford.edu/pub/3Dscanrep/dragon/dragon_recon.tar.gz -P tropical/stanford
tar xvf tropical/stanford/dragon_recon.tar.gz -C tropical/stanford

wget http://graphics.stanford.edu/pub/3Dscanrep/happy/happy_recon.tar.gz -P tropical/stanford
tar xvf tropical/stanford/happy_recon.tar.gz -C tropical/stanford

wget http://graphics.stanford.edu/pub/3Dscanrep/armadillo/Armadillo.ply.gz -P tropical/stanford
mkdir tropical/stanford/armadillo
gzip -d tropical/stanford/Armadillo.ply.gz
mv tropical/stanford/Armadillo.ply tropical/stanford/armadillo/Armadillo.ply

wget http://graphics.stanford.edu/pub/3Dscanrep/drill.tar.gz -P tropical/stanford
tar xvf tropical/stanford/drill.tar.gz -C tropical/stanford

wget http://graphics.stanford.edu/data/3Dscanrep/lucy.tar.gz -P tropical/stanford
tar xvf tropical/stanford/lucy.tar.gz -C tropical/stanford
mkdir tropical/stanford/lucy
mv tropical/stanford/lucy.ply tropical/stanford/lucy
```

For the tenth-reduced mesh of the Lucy,
```bash
tar xvf lucy_res10.tgz
```

For the pretrained SDFs for the Stanford 3D Scanning repository,
```bash
tar xvf stanford_small_models.tgz
```
Notice that it only offers the *small* models due to the maximum file size limit.

### Usage

For the Stanford [bunny|drill|happy|dragon|armadillo|lucy]:
```bash
python -m tropical.stanford.train -d {bunny|drill|happy|dragon|armadillo|lucy} -e
```

Note that `-h` option gives you this:
```bash
usage: python -m tropical.stanford.train [-h] 
                                         [-d {bunny,dragon,happy,armadillo,drill,lucy}] 
                                         [-s SEED] [-c]
                                         [-m {small,medium,large}] [-e]

Polyhedral complex derivation from piecewise trilinear networks

optional arguments:
  -h, --help            show this help message and exit
  -d {bunny,dragon,happy,armadillo,drill,lucy}, --dataset {bunny,dragon,happy,armadillo,drill,lucy}
                        Stanford 3D scanning model name
  -s SEED, --seed SEED  Seed
  -c, --cache           Cache the trained SDF?
  -m {small,medium,large}, --model_size {small,medium,large}
                        Model size
  -e, --eval            Run evaluation?
```

### Visualization

The above script will generate the extracted meshes under the path of `./meshes`. Or you could check with our generations with this command:
```bash
tar xvf meshes.tgz
```

The .ply extension refers to the Polygon File Format or Stanford Triangle Format, which is a file format commonly used to store three-dimensional data. You can easily visualize them by simply dragging and dropping them onto the website of `https://3dviewer.net`.

### License

This repository is licensed under Apache License 2.0.
