# [AdvUnlearn] Defensive Unlearning with Adversarial Training for Robust Concept Erasure in Diffusion Models
This is the code implementation of our Robust DM Unlearning Framework: ```AdvUnlearn```, and we developed our code based on the code base of SD [1] and ESD [2].

## Environment Setup
A suitable conda environment named ```ldm``` can be created and activated with:

```conda env create -f environment.yaml```

## Code Implementation

### Step 1: AdvUnlearn [Train]

#### a) Nudity Unlearning 
```python train-scripts/adv-train-esd-retain.py --attack_init random --attack_step 30 --retain_train 'reg' --dataset_retain 'coco_object' --prompt 'nudity' --train_method 'text_encoder_full' --retain_loss_w 0.3```

#### b) Style Unlearning
```python train-scripts/adv-train-esd-retain.py --attack_init random --attack_step 30 --retain_train 'reg' --dataset_retain 'coco_object' --prompt 'Van Gogh' --train_method 'text_encoder_layer0' --retain_loss_w 0.5```

#### c) Object Unlearning
```python train-scripts/adv-train-esd-retain.py --attack_init random --attack_step 30 --retain_train 'reg' --dataset_retain 'coco_object' --prompt 'Church' --train_method 'text_encoder_layer0' --retain_loss_w 0.5```

#### d) Nudity Unlearning: Fast AT variant
```python train-scripts/adv-train-esd-retain.py --attack_method fast_at --attack_init random --attack_step 30 --retain_train 'reg' --dataset_retain 'coco_object' --prompt 'nudity' --train_method 'text_encoder_full'   --retain_loss_w 0.3```

### Step 2: Attack Evaluation [Robustness Evaluation] 
Follow the instruction in ```UnlearnDiffAtk``` [3] to implement attacks on DMs with ```AdvUnlearn``` text encoder for robustness evaluation.



### Step 3: Image Generation Quality Evaluation [Model Utility Evaluation]
Generate 10k images for FID & CLIP evaluation 

```bash jobs/fid_10k_generate.sh```  

Calculate FID & CLIP scores  

```bash jobs/tri_quality_eval.sh```   





## References
[1] "High-resolution image synthesis with latent diffusion models." Proceedings of the IEEE/CVF conference on computer vision and pattern recognition. 2022.

[2] "Erasing concepts from diffusion models." Proceedings of the IEEE/CVF International Conference on Computer Vision. 2023.

[3] "To generate or not? safety-driven unlearned diffusion models are still easy to generate unsafe images... for now." arXiv preprint arXiv:2310.11868 (2023).

