![alt text](https://github.com/mgranz/weiper_icml/blob/master/WeiPer_v1.png?raw=true)

Repository of the 2024 NeurIPS submission.
We are still working on the code and will publish it after rebuttal period.
This is a working integration into the OpenOOD framework.
For further information on OpenOOD, see: https://github.com/Jingkang50/OpenOOD/tree/main/openood

# Instructions
## Installation 
We also provide an enviroment.yml file for setting up an environment with the necessary dependenciy versions.

Examplary for conda users:
```
conda env create --file environment.yml 
conda activate weiper_env
```

Then, install OpenOOD in editable mode:
```
cd OpenOOD
pip install -e .
```
This will install the package `openood` with NAC, WeiPer+Density and Weiper+KLDiv  as additional postprocessors.

Download all the data and network checkpoints calling the `/scripts/download/download.sh` in the `OpenOOD` directory.

## Test the methods
Open the `Evaluate_WeiPer.ipynb` notebook and follow the instructions

## How to find the code for the methods
The code is located in the postprocessor directory of OpenOOD:

`./OpenOOD/openood/postprocessors/weiper_density/`

`./OpenOOD/openood/postprocessors/weiper_kldiv/`

`./OpenOOD/openood/postprocessors/weiper_density_postprocessor.py/`

`./OpenOOD/openood/postprocessors/weiper_kldiv_postprocessor.py/`

# Density Evolution 

<img src="https://github.com/mgranz/weiper_icml/blob/master/Weiper/ResNet18_penultimate_layer_resize.gif" width="340" height="340" />
Evolution of the densities of specific penultimate output dimensions over the training period. Blue is the training data, red the OOD data and purple/turquois is the test data.

