from PIL import Image
import os

def concatenate_images(root, image_paths, rows, cols, output_path):
    images = [Image.open(root+'/'+img) for img in image_paths]

    # Determine width and height for the final image
    width = max(img.width for img in images) * cols
    height = max(img.height for img in images) * rows

    images = [img.resize((width//cols,height//rows)) for img in images]

    # Create a new blank image with calculated width and height
    result = Image.new('RGB', (width, height))

    # Paste each image into the result image
    for row in range(rows):
        for col in range(cols):
            index = rows * col + row
            if index < len(images):
                x_offset = col * images[index].width
                y_offset = row * images[index].height
                result.paste(images[index], (x_offset, y_offset))

    # Save the result image
    result.save(output_path)

# Example usage:
root = 'data/pic'
file = os.listdir(root)
file.sort(reverse=False)
rows = 2
cols = 2
item = rows*cols
for i in range(len(file)//item):
    output_path = 'ppt/output%d.jpg' % i
    concatenate_images(root, file[i*item:i*item+item], rows, cols, output_path)