#!/bin/bash

# Activate the conda environment
source activate tcmdp
python script/extract_wandb_exp.py --entity="anonymous" --project="paper_stackedTCRARL" --download_folder="paper_baselines/stacked_tc-rarl" --handle_missing_seed=True
python script/gather_agents.py --all_logs_folder "paper_baselines" --output_folder "paper_agents"
# Function to run the command with a specific agent file
run_command() {
    # Parameters
    core_range="$1"
    env_name="$2"
    cuda_device="$3"
    agent_number="$4"

    # Set the agent file explicitly
    agent_file="paper_agents/stacked_tc-rarl/${env_name}/3/agent_${agent_number}_${env_name}_3.pth"

    # Run the python command with the extracted agent number
    taskset -c ${core_range} python src/main_tc_adversary.py --agent_path ${agent_file} \
        --env_name ${env_name} \
        --agent_type stacked \
        --project_name paper_adversaryStackedTCRARL \
        --device ${cuda_device} \
        --radius 0.001 \
        --max_steps 5000000 \
        --nb_uncertainty_dim 3 \
        --experiment_name "tc_adv_${env_name}_${agent_number}" \
        --seed ${agent_number} \
        --omniscient_adversary True
}

# Argument parsing for the environment name, CUDA device, and starting agent number
if [ -z "$1" ] || [ -z "$2" ] || [ -z "$3" ]; then
    echo "Usage: $0 <env_name> <cuda_index> <starting_agent_number>"
    echo "Example: $0 Ant 0 0"
    exit 1
fi

env_name="$1"
cuda_index="$2"
starting_agent_number="$3"
cuda_device="cuda:${cuda_index}"

if [ "${cuda_index}" -eq "0" ]; then
    start_session_number=1
    start_core_range=0
else
    start_session_number=6
    start_core_range=15
fi

# Calculate core ranges and session names
core_range_1="$((start_core_range))-$((start_core_range + 2))"
core_range_2="$((start_core_range + 3))-$((start_core_range + 5))"
core_range_3="$((start_core_range + 6))-$((start_core_range + 8))"
core_range_4="$((start_core_range + 9))-$((start_core_range + 11))"
core_range_5="$((start_core_range + 12))-$((start_core_range + 14))"

session_1="tmux_${start_session_number}"
session_2="tmux_$((start_session_number + 1))"
session_3="tmux_$((start_session_number + 2))"
session_4="tmux_$((start_session_number + 3))"
session_5="tmux_$((start_session_number + 4))"

# Create tmux sessions
tmux new-session -d -s "${session_1}" "$(typeset -f); run_command '${core_range_1}' '${env_name}' '${cuda_device}' '${starting_agent_number}'"
tmux new-session -d -s "${session_2}" "$(typeset -f); run_command '${core_range_2}' '${env_name}' '${cuda_device}' '$((starting_agent_number + 1))'"
tmux new-session -d -s "${session_3}" "$(typeset -f); run_command '${core_range_3}' '${env_name}' '${cuda_device}' '$((starting_agent_number + 2))'"
tmux new-session -d -s "${session_4}" "$(typeset -f); run_command '${core_range_4}' '${env_name}' '${cuda_device}' '$((starting_agent_number + 3))'"
tmux new-session -d -s "${session_5}" "$(typeset -f); run_command '${core_range_5}' '${env_name}' '${cuda_device}' '$((starting_agent_number + 4))'"

# Attach to the first tmux session for convenience
#tmux attach -t "${session_1}"
