#!/bin/bash
source activate tcmdp
# #If not done download the agents from wandb and extract them
python script/extract_wandb_exp.py --entity="anonymous" --project="m2td3_oraclerrl" --download_folder="paper_baselines/oracle_m2td3"  --handle_missing_seed=True
python script/gather_agents.py --all_logs_folder "paper_baselines" --output_folder "paper_agents"

# Function to run the command multiple times
run_command() {
    # Activate the environment only once per session to avoid repeated activations
    source activate tcmdp

    # Loop over each file that matches the pattern in the specified directory
    for agent_file in paper_agents/oracle_m2td3/$2/3/agent_*_$2_3.pth; do
        # Extract the agent number from the filename using a Bash parameter expansion
        agent_number=$(basename $agent_file | sed -E "s/agent_([0-9]+)_${2}_3\.pth/\1/")

        # Run the python command with the extracted agent number
        taskset -c $1 python src/main_tc_adversary.py --agent_path $agent_file --env_name $2 --agent_type oracle_m2td3 --project_name paper_adversaryOracleM2TD3 --device $3 --radius 0.001 --max_steps 5000000 --nb_uncertainty_dim 3 --experiment_name tc_adv_$2_$agent_number --seed $agent_number --omniscient_adversary True --device $3
    done
}

# tmux 1
tmux new-session -d -s tmux_6 "$(typeset -f); run_command '15-17' 'Ant' 'cuda:0'"

# tmux 2
tmux new-session -d -s tmux_7 "$(typeset -f); run_command '18-20' 'HalfCheetah' 'cuda:0'"

# tmux 3
tmux new-session -d -s tmux_8 "$(typeset -f); run_command '21-23' 'Hopper' 'cuda:0'"

# tmux 4
tmux new-session -d -s tmux_9 "$(typeset -f); run_command '24-26' 'HumanoidStandup' 'cuda:0'"

# tmux 5
tmux new-session -d -s tmux_10 "$(typeset -f); run_command '27-29' 'Walker' 'cuda:0'"


echo "All tmux sessions started. Use 'tmux attach-session -t [session_name]' to attach to a session."
