#!/bin/bash
source activate tcmdp
# Function to run the command multiple times
run_command() {
    for i in {1..10}; do
        source activate tcmdp
        taskset -c $1 python src/main_stacked_tc_rarl.py --env_name $2 --project_name paper_stackedTCRARL --device $3 --radius 0.001 --max_steps 5000000 --nb_uncertainty_dim 3
    done
}

# tmux 1
tmux new-session -d -s tmux_1 "$(typeset -f); run_command '0-2' 'Ant' 'cuda:0'"

# tmux 2
tmux new-session -d -s tmux_2 "$(typeset -f); run_command '3-5' 'HalfCheetah' 'cuda:0'"

# tmux 3
tmux new-session -d -s tmux_3 "$(typeset -f); run_command '6-8' 'Hopper' 'cuda:0'"

# tmux 4
tmux new-session -d -s tmux_4 "$(typeset -f); run_command '9-11' 'HumanoidStandup' 'cuda:0'"

# tmux 5
tmux new-session -d -s tmux_5 "$(typeset -f); run_command '12-14' 'Walker' 'cuda:0'"

echo "All tmux sessions started. Use 'tmux attach-session -t [session_name]' to attach to a session."
