# README for Hill Climbing Search

## Overview
This Python script is designed to perform a series of experiments involving random hill climbing search for Most Probable Explanation (MPE) inference for Probabilistic Circuits (PCs). It utilizes PC models to evaluate samples based on various initialization methods and computes likelihood scores.

## Dependencies
- Python 3.6 or newer
- NumPy
- PyTorch
- WandB (for experiment tracking)
- Matplotlib (for plotting)
- Loguru (for enhanced logging)
- deeprob (a library for working with SPNs)

## Installation
Ensure that you have the required dependencies installed using pip:
```bash
pip install numpy torch wandb matplotlib loguru deeprob
```

## Usage
The script can be executed from the command line with various arguments to control the experiment settings:
```bash
python <script_name>.py --debug --seed 42 --num-steps 10 --num-samples 5 --spn-model-directory "<path_to_spn_model>" --nn-model-output-directory "<path_to_nn_outputs>" --initialization sequential
```

### Command Line Arguments
- `--debug`: Enable debug mode for verbose logging.
- `--seed`: Set the random seed for reproducibility.
- `--num-steps`: Specify the number of steps in the hill climbing search.
- `--num-samples`: Define the number of samples for hill climbing search.
- `--spn-model-directory`: Directory containing the SPN models.
- `--nn-model-output-directory`: Directory for loading outputs from the neural network models.
- `--initialization`: Initialization method for samples (options include `spn_approx`, `nn_approx`, `mle`, `sequential`).

## Output
- Outputs are saved in a structured directory format, which includes detailed logging of each experiment's configuration and results.
- Results include the likelihood scores, sampled data points, and MPE output.

## Note
Before running the script, ensure that the path to the parent directory (`anympe`) is added to your Python path in the script. Modify the `sys.path.append()` call in the script accordingly.