# Linearly-Decomposing-and-Recomposing-Vision-Transformers


This repo is for linearly Decomposing and Recomposing for Vision Transformers.


# Usage

Create the environment:

```bash
pip install -r requirements.txt
```

Compile operations:
```bash
cd rpe_ops
python setup.py install --user
```

## Data Preparation

You can download the ImageNet-1K dataset from [`http://www.image-net.org/`](http://www.image-net.org/).

The train set and validation set should be saved as the `*.tar` archives:

```
ImageNet/
├── train.tar
└── val.tar
```

Our code also supports storing images as individual files as follow:
```
ImageNet/
├── train
│   ├── n01440764
│   │   ├── n01440764_10026.JPEG
│   │   ├── n01440764_10027.JPEG
...
├── val
│   ├── n01440764
│   │   ├── ILSVRC2012_val_00000293.JPEG
```

## Decomposition

Extract the 1th component within ViT with chebyscheff power-up method.

```bash
python -m torch.distributed.launch --nproc_per_node=1 --master_port='12345' --use_env main.py \
    --model mini_deit_base_patch16_224 --batch-size 128 --epochs 100 \
    --data-path /path/to/data/ --output_dir result/power0_chebyscheff \
    --teacher-model regnety_160 --distillation-type soft --distillation-alpha 1.0 --repeated_time 12 \
    --drop-path 0.0 --lr 5e-4 --weight-decay 0.05 --power 0 --power_method chebyscheff
```
Then get the items for the 1th component, which would be used to extract the 2th component individually with the 1th component frozen. 
```bash
python -m torch.distributed.launch --nproc_per_node=1 --master_port='12345' --use_env main.py \
    --model mini_deit_base_patch16_224 --batch-size 128 --epochs 100 \
    --data-path /path/to/data/ --output_dir result/power1_chebyscheff \
    --teacher-model regnety_160 --distillation-type soft --distillation-alpha 1.0 --repeated_time 12 \
    --drop-path 0.0 --lr 5e-4 --weight-decay 0.05 --power 1 --power_method chebyscheff \
    --gene-dict-path path/to/1th/component/pkl \
    --init-other-items-path path/to/1th/component/pth
```
Reapeat the similar process, we could get all components with the power added one by one.

## Recomposition

Since we have Decomposed all compnents in Vision Transformer, we could recompose those components in different ways for downstream tasks. Here we take image classification task CIFAR10 for example, and we use 6 components to initialize a 6-layer Vision Transformer.

### Recomposition with Constraint

If you want to recompose the downstream model from these components with the polynomial relation like the process of the decomposition, we run the following command.

```bash
python -m torch.distributed.launch --nproc_per_node=1 --master_port='12345' --use_env main.py \
    --model mini_deit_base_patch16_224 --batch-size 128 --epochs 100 \
    --data-path /path/to/data/ --data-set CIFAR10  --output_dir result/power5_depth6_CIFAR10_with_const \
    --teacher-model regnety_160 --distillation-type none --distillation-alpha 1.0  --depth 6 --repeated_time 6 \
    --drop-path 0.0 --lr 0.0001 --weight-decay 0.05 \
    --power 5 --power_method chebyscheff \
    --gene-dict-path path/to/all/components/pkl \
    --init-other-items-path path/to/all/components/pth \
    --learngene_d true --constraint_d true

```
If you want to recompose the downstream model from these components without the polynomial relation, which means we just use the components to calculate the parameters in polynomial way in different layers just as a parameter initialzation, we run the following command.

### Recomposition without Constraint

```bash
python -m torch.distributed.launch --nproc_per_node=1 --master_port='12345' --use_env main.py \
    --model mini_deit_base_patch16_224 --batch-size 128 --epochs 100 \
    --data-path /path/to/data/ --data-set CIFAR10 --output_dir result/power5_depth6_CIFAR10_without_const \
    --teacher-model regnety_160 --distillation-type none --distillation-alpha 1.0 --depth 6  --repeated_time 1 \
    --drop-path 0.0 --lr 0.0001 --weight-decay 0.05 \
    --power 5 --power_method chebyscheff --use_power_list "[0,1,2,3,4,5]" \
    --gene-dict-path path/to/all/components/pkl \
    --init-other-items-path path/to/all/components/pth \
    --learngene_d true 
```