import numpy as np


# download elasticity/Meshes/Random_UnitCell_*_10.npy
# from GeoFNO datasets (https://drive.google.com/drive/folders/1JUkPbx0-lgjFHPURH_kp1uqjfRn3aw9-)
# to Forward_Problem/datas

if __name__ == "__main__":
    rr = np.load("data/Random_UnitCell_rr_10.npy")
    sigma = np.load("data/Random_UnitCell_sigma_10.npy")
    theta = np.load("data/Random_UnitCell_theta_10.npy")
    XY = np.load("data/Random_UnitCell_XY_10.npy")
    
    XY = np.transpose(XY, (2, 0, 1))
    sigma = np.transpose(sigma, (1, 0))
    sigma = np.expand_dims(sigma, axis=2)
    
    print(XY.shape)
    print(sigma.shape)

    np.save("data/ELA_train", {"x":XY[:1000,...], "y2":sigma[:1000,...], "y1":XY[:1000,...]})
    np.save("data/ELA_val", {"x":XY[1000:,...], "y2":sigma[1000:,...], "y1":XY[1000:,...]})
