# Code README 

The code is provided for reference. 
Rerunning all the experiments would take a significant amount of compute, 
and the data generated from the experiments is too large to share in its entirety through openreview.

If you find an issue with the code or missing files, please let us know!  

## Installation

To install the dependencies, including the specific version of `pytorch`, see `requirements/readme.md`.
Once the dependencies are installed, the library can be installed using `pip install -e .` from the directory containing `setup.cfg`.

## Workspace and environment variables

The code relies on a `workspace` directory to save datasets, experiment results, plots and logs,
which is set by environment variables. To configure the environment variables, see `envs/readme.md`.

## Sanity checks

To check whether the library is installed correctly, try `python -c "import optexp"`.

## Experiment structures

The file `src/optexp/experiments/__main__.py` contains a list of all experiments that can be run.

The experiments definitions are in `src/optexp/experiments/`, organized by subfolders.
Each file defines the model, optimizers, and grid-search over hyperparameters, 
and another file defines 

## Wandb and running experiments

(Only required for running experiments!)

We use wandb as the backend to save experiment results and download data.
If an experiment has already run and is saved on the specified entity/project on wandb, 
the experiment will not run again (unless `--force` is passed).

Use the small experiment in `src/experiments/toy_models/smaller/balanced_x_smaller_longer.py` to check whether the library works. 
To run the first experiment in the list and upload it to WANDB, use 
```
python balanced_x_smaller_longer.py --test 
```
To run all of them by sending them to a slurm cluster, use 
```
python balanced_x_smaller_longer.py --slurm
```

Once an experiment has been run and uploaded to WANDB, the data can be downloaded with 
```
python balanced_x_smaller_longer.py --download 
```
and it can then be plotted.
If data from that experiment is already present in the `workspace` directory,
the library will not download it again.
Note: Some of our experiment (`bigger_models`) override the wandb project 
by using the context manager `UseWandbProject(WANDB_PROJECT)`.

## Plotting 

(Assumes you have downloaded the data)

To generate the main figures in the paper, run `python src/optexp/plotter/script/plot_paper_figures.py`.
To generate all the figures, call `bash make_all_plots.sh`.

To plot data from a specific experiment, for example `src/optexp/experiments/toy_models/smaller/balanced_x_smaller_longer.py`, use 
```
python balanced_x_smaller_longer.py --plot
```
If the experiment has per-class statistics (usually indicated by the `_perclass.py` suffix), use 
```
python balanced_x_smaller_longer.py --plot --perclass
```
to generate the additional plots.
Some of the figures that require additional processing and are generated by scripts in `/src/optexp/plotter/scripts`.
The large-scale experiment on GPT2-small require the additional flag `--use_steps`.
