import os
import time
import pickle

def receive_large_tensor(s):
    # 接收数据长度信息
    data_length = int.from_bytes(s.recv(4), byteorder='big')
    data = bytearray()
    while len(data) < data_length:
        packet = s.recv(4096)
        if not packet:
            break
        data.extend(packet)
    
    # 反序列化tensor
    tensor = pickle.loads(data)
    return tensor
def send_large_tensor(s, tensor):
    # 使用pickle序列化tensor
    data = pickle.dumps(tensor)
    length = len(data)
    s.sendall(length.to_bytes(4, byteorder='big'))  # 先发送数据的总长度

    # 开始发送数据
    start = 0
    CHUNK_SIZE = 4096  # 假设每个chunk的大小为4096 bytes
    while start < length:
        end = min(start + CHUNK_SIZE, length)
        s.sendall(data[start:end])
        start = end
        
def wait_them(file_path, suffix, bb=False):
    path_13b = os.path.join(file_path, f"meta-llama#Llama-2-13b-hf.pkl_{suffix}")
    path_7b = os.path.join(file_path, f"meta-llama#Llama-2-7b-hf.pkl_{suffix}")
    path_7b_expert = os.path.join(file_path, f"meta-llama#Llama-2-7b-chat-hf.pkl_{suffix}")
    path_list = [path_13b, path_7b, path_7b_expert]
    # wait all unread
    bz = 1
    while bz:
        time.sleep(0.1)
        bz = 0
        for idx, path_i in enumerate(path_list):
            if os.path.exists(path_i) == bb:
                bz = 1
                
def clear_share_io():
    file_path = "/xx/analysis/vllm_inject/logits_gsm"
    path_13b = os.path.join(file_path, "meta-llama#Llama-2-13b-hf.pkl_unread")
    path_7b = os.path.join(file_path, "meta-llama#Llama-2-7b-hf.pkl_unread")
    path_7b_expert = os.path.join(file_path, "meta-llama#Llama-2-7b-chat-hf.pkl_unread")
    path_list = [path_13b, path_7b, path_7b_expert]
    for path_i in path_list:
        if os.path.exists(path_i):
            os.remove(path_i)

    file_path = "/xx/analysis/vllm_inject/batch_num_gsm"
    path_13b = os.path.join(file_path, "meta-llama#Llama-2-13b-hf.pkl_read")
    path_7b = os.path.join(file_path, "meta-llama#Llama-2-7b-hf.pkl_read")
    path_7b_expert = os.path.join(file_path, "meta-llama#Llama-2-7b-chat-hf.pkl_read")
    path_list = [path_13b, path_7b, path_7b_expert]
    for path_i in path_list:
        if os.path.exists(path_i):
            os.remove(path_i)
        if os.path.exists(path_i.replace("_read", "_write")):
            os.remove(path_i.replace("_read", "_write"))