from vllm.sequence import Sequence, Logprob, SequenceData, SampleLogprobs, SequenceStatus, SequenceOutput
from typing import TYPE_CHECKING, Dict, List, Optional, Union
from vllm.lora.request import LoRARequest
from vllm.block import LogicalTokenBlock

def append_token_id(
    self,
    token_id: int,
    logprobs: Dict[int, Logprob],
    logits,
) -> None:
    assert token_id in logprobs
    self._append_tokens_to_blocks([token_id])
    self.output_logprobs.append(logprobs)
    self.data.append_token_id(token_id, logprobs[token_id].logprob, logits)

def get_logits_list(self):
    return self.data.logits_list
setattr(Sequence, "append_token_id", append_token_id)
setattr(Sequence, "get_logits_list", get_logits_list)

# def __init__(
#     self,
#     prompt_token_ids: List[int],
#     output_token_ids: Optional[List[int]] = None,
# ) -> None:
#     if output_token_ids is None:
#         output_token_ids = []

#     self.prompt_token_ids = prompt_token_ids
#     self.output_token_ids = output_token_ids
#     self.cumulative_logprob = 0.0
#     # The number of tokens that are computed (that run against the model).
#     self._num_computed_tokens = 0
#     self.logits_list = []
        
def SequenceData_append_token_id(self, token_id: int, logprob: float, logits) -> None:
    self.output_token_ids.append(token_id)
    self.cumulative_logprob += logprob
    self.logits_list.append(logits)

def __init__(
    self,
    prompt_token_ids: List[int],
    output_token_ids: Optional[List[int]] = None,
    logits_list = None
) -> None:
    if output_token_ids is None:
        output_token_ids = []

    self.prompt_token_ids = prompt_token_ids
    self.output_token_ids = output_token_ids
    self.cumulative_logprob = 0.0
    # The number of tokens that are computed (that run against the model).
    self._num_computed_tokens = 0
    self.logits_list = [] if logits_list is None else logits_list
setattr(SequenceData, "__init__", __init__)
setattr(SequenceData, "append_token_id", SequenceData_append_token_id)

setattr(SequenceOutput, "logits", None)