import csv
import json
import os
import re

def process_file(file_path):
    with open(file_path, 'r') as f:
        text = f.read()
        text= text.replace("'",'"')
    pattern = r'INFO - imitation.scripts.train_adversarial - (\d+\.\d+)\nINFO - imitation.scripts.train_adversarial - (.*?})\n'
    matches = re.findall(pattern, text)

    output_file = os.path.join(os.path.dirname(file_path), 'output.csv')
    with open(output_file, 'w') as f:
        writer = csv.DictWriter(f, fieldnames=['timestamp', 'n_traj', 'monitor_return_len', 'return_min', 'return_mean', 'return_std', 'return_max', 'len_min', 'len_mean', 'len_std', 'len_max', 'monitor_return_min', 'monitor_return_mean', 'monitor_return_std', 'monitor_return_max'])
        writer.writeheader()
        try: first_timestamp = float(matches[0][0])
        except IndexError:
            os.remove(output_file)

        for match in matches:
            timestamp, json_str = match
            data = json.loads(json_str)
            data['timestamp'] = float(timestamp) - first_timestamp
            writer.writerow(data)

def process_directory(dir_path):
    for root, dirs, files in os.walk(dir_path):
        for file in files:
            if file == 'cout.txt':
                file_path = os.path.join(root, file)
                print(file_path)
                process_file(file_path)
                
#运行一下就可以把数据提取到csv中
dir_path = r"/home/luotianjiao/imitation/output/sacred"
process_directory(dir_path)