#!/bin/bash

source activate p311

DATA1=$1          #dataset/coil_1_train.npy
DATA2=$2          #dataset/coil_1_test.npy
CATEGORY=$3       #1
MODELNAME=$4      #model/vae_coil_1
MODELTYPE=$5      #vae_2d
MODELEPOCHS=$6    #4000
MODELLR=$7        #0.001
FIXEPOCHS=$8      #200
FIXLR=$9          #0.1
FIXSIGMA=${10}    #0.1
STEP=${11}

if [ "$STEP" = 1 ]
then
  python generate_coil_data.py $DATA1 0 3 $CATEGORY
fi

if [ "$STEP" = 2 ]
then
  python train_model.py $DATA1 $MODELNAME $MODELEPOCHS $MODELLR $MODELTYPE
fi

if [ "$STEP" = 3 ]
then
  python diffeo_model.py $DATA1 $MODELNAME $MODELTYPE 1    $FIXEPOCHS $FIXLR    0-1 7. -1    1 $FIXSIGMA     0 -1
fi

if [ "$STEP" = 4 ]
then
  python generate_coil_data.py $DATA2 1 3 $CATEGORY
fi

if [ "$STEP" = 5 ]
then
  python diffeo_model.py $DATA2 $MODELNAME $MODELTYPE 0 $FIXSIGMA $FIXLR
fi

if [ "$STEP" = 6 ]
then
  python inverse_model.py [-1.8_2.] $DATA1 $MODELNAME $MODELTYPE 0 -1 -1
fi

if [ "$STEP" = 7 ]
then
  python inverse_model.py [-1.8_2.] $DATA1 $MODELNAME $MODELTYPE 1 $FIXSIGMA $FIXLR
fi
