#ifndef CUFFTDX_FFT_49_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_49_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<374, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<284>;
.reg .b32 r<15>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 392, r2;
mov.u32 r4, %tid.x;
add.f32 f29, %18, %32;
add.f32 f30, %16, f29;
add.f32 f31, %21, %29;
add.f32 f32, f31, f30;
add.f32 f33, %24, %26;
add.f32 f34, %20, %33;
add.f32 f35, %17, f34;
add.f32 f36, %23, %31;
add.f32 f37, f36, f35;
add.f32 f38, %25, %28;
fma.rn.f32 f39, f29, 0f3F1F9D07, %16;
mul.f32 f40, f31, 0f3E63DC87;
sub.f32 f41, f39, f40;
mul.f32 f42, f33, 0f3F66A5E5;
sub.f32 f43, f41, f42;
sub.f32 f44, %20, %33;
mul.f32 f45, f44, 0f3F48261C;
sub.f32 f46, %23, %31;
fma.rn.f32 f47, f46, 0f3F7994E0, f45;
sub.f32 f48, %25, %28;
fma.rn.f32 f49, f48, 0f3EDE2602, f47;
sub.f32 f50, f43, f49;
add.f32 f51, f49, f43;
mul.f32 f52, f29, 0f3E63DC87;
sub.f32 f53, %16, f52;
mul.f32 f54, f31, 0f3F66A5E5;
sub.f32 f55, f53, f54;
fma.rn.f32 f56, f33, 0f3F1F9D07, f55;
mul.f32 f57, f44, 0f3F7994E0;
mul.f32 f58, f46, 0f3EDE2602;
sub.f32 f59, f57, f58;
mul.f32 f60, f48, 0f3F48261C;
sub.f32 f61, f59, f60;
sub.f32 f62, f56, f61;
add.f32 f63, f61, f56;
mul.f32 f64, f29, 0f3F66A5E5;
sub.f32 f65, %16, f64;
fma.rn.f32 f66, f31, 0f3F1F9D07, f65;
mul.f32 f67, f33, 0f3E63DC87;
sub.f32 f68, f66, f67;
mul.f32 f69, f44, 0f3EDE2602;
mul.f32 f70, f46, 0f3F48261C;
sub.f32 f71, f69, f70;
fma.rn.f32 f72, f48, 0f3F7994E0, f71;
sub.f32 f73, f68, f72;
add.f32 f74, f72, f68;
fma.rn.f32 f75, f34, 0f3F1F9D07, %17;
mul.f32 f76, f36, 0f3E63DC87;
sub.f32 f77, f75, f76;
mul.f32 f78, f38, 0f3F66A5E5;
sub.f32 f79, f77, f78;
sub.f32 f80, %18, %32;
mul.f32 f81, f80, 0f3F48261C;
sub.f32 f82, %21, %29;
fma.rn.f32 f83, f82, 0f3F7994E0, f81;
sub.f32 f84, %24, %26;
fma.rn.f32 f85, f84, 0f3EDE2602, f83;
add.f32 f86, f85, f79;
sub.f32 f87, f79, f85;
mul.f32 f88, f34, 0f3E63DC87;
sub.f32 f89, %17, f88;
mul.f32 f90, f36, 0f3F66A5E5;
sub.f32 f91, f89, f90;
fma.rn.f32 f92, f38, 0f3F1F9D07, f91;
mul.f32 f93, f80, 0f3F7994E0;
mul.f32 f94, f82, 0f3EDE2602;
sub.f32 f95, f93, f94;
mul.f32 f96, f84, 0f3F48261C;
sub.f32 f97, f95, f96;
add.f32 f98, f97, f92;
sub.f32 f99, f92, f97;
mul.f32 f100, f34, 0f3F66A5E5;
sub.f32 f101, %17, f100;
fma.rn.f32 f102, f36, 0f3F1F9D07, f101;
mul.f32 f103, f38, 0f3E63DC87;
sub.f32 f104, f102, f103;
mul.f32 f105, f80, 0f3EDE2602;
mul.f32 f106, f82, 0f3F48261C;
sub.f32 f107, f105, f106;
fma.rn.f32 f108, f84, 0f3F7994E0, f107;
add.f32 f109, f108, f104;
sub.f32 f110, f104, f108;
mul.wide.u32 rd2, r4, 613566757;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 2;
mul.lo.s32 r10, r9, 7;
sub.s32 r11, r4, r10;
mad.lo.s32 r12, r9, 392, r3;
mul.wide.u32 rd4, r11, 8;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f111, f112}, [rd6];
mul.f32 f115, f86, f112;
mul.f32 f116, f50, f112;
mul.f32 f117, f111, f86;
mul.f32 f118, f111, f111;
mul.f32 f119, f112, f112;
sub.f32 f120, f118, f119;
mul.f32 f121, f112, f111;
fma.rn.f32 f122, f112, f111, f121;
mul.f32 f123, f98, f122;
mul.f32 f124, f62, f122;
mul.f32 f125, f120, f98;
mul.f32 f126, f111, f120;
mul.f32 f127, f112, f122;
sub.f32 f128, f126, f127;
mul.f32 f129, f111, f122;
fma.rn.f32 f130, f112, f120, f129;
mul.f32 f131, f109, f130;
mul.f32 f132, f73, f130;
mul.f32 f133, f128, f109;
mul.f32 f134, f111, f128;
mul.f32 f135, f112, f130;
sub.f32 f136, f134, f135;
mul.f32 f137, f111, f130;
fma.rn.f32 f138, f112, f128, f137;
mul.f32 f139, f110, f138;
mul.f32 f140, f74, f138;
mul.f32 f141, f136, f110;
mul.f32 f142, f111, f136;
mul.f32 f143, f112, f138;
sub.f32 f144, f142, f143;
mul.f32 f145, f111, f138;
fma.rn.f32 f146, f112, f136, f145;
mul.f32 f147, f99, f146;
mul.f32 f148, f63, f146;
mul.f32 f149, f144, f99;
mul.f32 f150, f111, f144;
mul.f32 f151, f112, f146;
sub.f32 f152, f150, f151;
mul.f32 f153, f111, f146;
fma.rn.f32 f154, f112, f144, f153;
mul.f32 f155, f87, f154;
mul.f32 f156, f51, f154;
mul.f32 f157, f152, f87;
barrier.sync 0;
mad.lo.s32 r13, r11, 56, r12;
add.f32 f158, f38, f37;
add.f32 f159, f33, f32;
st.shared.v2.f32 [r13], {f159, f158};
fma.rn.f32 f160, f111, f50, f115;
sub.f32 f161, f117, f116;
st.shared.v2.f32 [r13+8], {f160, f161};
fma.rn.f32 f162, f120, f62, f123;
sub.f32 f163, f125, f124;
st.shared.v2.f32 [r13+16], {f162, f163};
sub.f32 f164, f133, f132;
fma.rn.f32 f165, f128, f73, f131;
st.shared.v2.f32 [r13+24], {f165, f164};
fma.rn.f32 f166, f136, f74, f139;
sub.f32 f167, f141, f140;
st.shared.v2.f32 [r13+32], {f166, f167};
fma.rn.f32 f168, f144, f63, f147;
sub.f32 f169, f149, f148;
st.shared.v2.f32 [r13+40], {f168, f169};
fma.rn.f32 f170, f152, f51, f155;
sub.f32 f171, f157, f156;
st.shared.v2.f32 [r13+48], {f170, f171};
barrier.sync 0;
mad.lo.s32 r14, r11, -48, r13;
ld.shared.v2.f32 {f172, f173}, [r14];
ld.shared.v2.f32 {f176, f177}, [r14+56];
ld.shared.v2.f32 {f180, f181}, [r14+112];
ld.shared.v2.f32 {f184, f185}, [r14+168];
ld.shared.v2.f32 {f188, f189}, [r14+224];
ld.shared.v2.f32 {f192, f193}, [r14+280];
ld.shared.v2.f32 {f196, f197}, [r14+336];
add.f32 f200, f176, f196;
add.f32 f201, f172, f200;
add.f32 f202, f180, f192;
add.f32 f203, f202, f201;
add.f32 f204, f184, f188;
add.f32 f205, f177, f197;
add.f32 f206, f173, f205;
add.f32 f207, f181, f193;
add.f32 f208, f207, f206;
add.f32 f209, f185, f189;
fma.rn.f32 f210, f200, 0f3F1F9D07, f172;
mul.f32 f211, f202, 0f3E63DC87;
sub.f32 f212, f210, f211;
mul.f32 f213, f204, 0f3F66A5E5;
sub.f32 f214, f212, f213;
sub.f32 f215, f177, f197;
mul.f32 f216, f215, 0f3F48261C;
sub.f32 f217, f181, f193;
fma.rn.f32 f218, f217, 0f3F7994E0, f216;
sub.f32 f219, f185, f189;
fma.rn.f32 f220, f219, 0f3EDE2602, f218;
mul.f32 f221, f200, 0f3E63DC87;
sub.f32 f222, f172, f221;
mul.f32 f223, f202, 0f3F66A5E5;
sub.f32 f224, f222, f223;
fma.rn.f32 f225, f204, 0f3F1F9D07, f224;
mul.f32 f226, f215, 0f3F7994E0;
mul.f32 f227, f217, 0f3EDE2602;
sub.f32 f228, f226, f227;
mul.f32 f229, f219, 0f3F48261C;
sub.f32 f230, f228, f229;
mul.f32 f231, f200, 0f3F66A5E5;
sub.f32 f232, f172, f231;
fma.rn.f32 f233, f202, 0f3F1F9D07, f232;
mul.f32 f234, f204, 0f3E63DC87;
sub.f32 f235, f233, f234;
mul.f32 f236, f215, 0f3EDE2602;
mul.f32 f237, f217, 0f3F48261C;
sub.f32 f238, f236, f237;
fma.rn.f32 f239, f219, 0f3F7994E0, f238;
fma.rn.f32 f240, f205, 0f3F1F9D07, f173;
mul.f32 f241, f207, 0f3E63DC87;
sub.f32 f242, f240, f241;
mul.f32 f243, f209, 0f3F66A5E5;
sub.f32 f244, f242, f243;
sub.f32 f245, f176, f196;
mul.f32 f246, f245, 0f3F48261C;
sub.f32 f247, f180, f192;
fma.rn.f32 f248, f247, 0f3F7994E0, f246;
sub.f32 f249, f184, f188;
fma.rn.f32 f250, f249, 0f3EDE2602, f248;
mul.f32 f251, f205, 0f3E63DC87;
sub.f32 f252, f173, f251;
mul.f32 f253, f207, 0f3F66A5E5;
sub.f32 f254, f252, f253;
fma.rn.f32 f255, f209, 0f3F1F9D07, f254;
mul.f32 f256, f245, 0f3F7994E0;
mul.f32 f257, f247, 0f3EDE2602;
sub.f32 f258, f256, f257;
mul.f32 f259, f249, 0f3F48261C;
sub.f32 f260, f258, f259;
mul.f32 f261, f205, 0f3F66A5E5;
sub.f32 f262, f173, f261;
fma.rn.f32 f263, f207, 0f3F1F9D07, f262;
mul.f32 f264, f209, 0f3E63DC87;
sub.f32 f265, f263, f264;
mul.f32 f266, f245, 0f3EDE2602;
mul.f32 f267, f247, 0f3F48261C;
sub.f32 f268, f266, f267;
fma.rn.f32 f269, f249, 0f3F7994E0, f268;
add.f32 %1, f209, f208;
add.f32 %0, f204, f203;
add.f32 %3, f250, f244;
sub.f32 %2, f214, f220;
add.f32 %5, f260, f255;
sub.f32 %4, f225, f230;
add.f32 %7, f269, f265;
sub.f32 %6, f235, f239;
sub.f32 %9, f265, f269;
add.f32 %8, f239, f235;
sub.f32 %11, f255, f260;
add.f32 %10, f230, f225;
sub.f32 %13, f244, f250;
add.f32 %12, f220, f214;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y): "r"(smem), "l"(lut_sp_7_49), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<375, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<270>;
.reg .b32 r<15>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 196, r2;
mov.u32 r4, %tid.x;
add.f32 f29, %18, %32;
add.f32 f30, %16, f29;
add.f32 f31, %21, %29;
add.f32 f32, f31, f30;
add.f32 f33, %24, %26;
add.f32 f34, f33, f32;
add.f32 f35, %20, %33;
add.f32 f36, %17, f35;
add.f32 f37, %23, %31;
add.f32 f38, f37, f36;
add.f32 f39, %25, %28;
add.f32 f40, f39, f38;
fma.rn.f32 f41, f29, 0f3F1F9D07, %16;
mul.f32 f42, f31, 0f3E63DC87;
sub.f32 f43, f41, f42;
mul.f32 f44, f33, 0f3F66A5E5;
sub.f32 f45, f43, f44;
sub.f32 f46, %20, %33;
mul.f32 f47, f46, 0f3F48261C;
sub.f32 f48, %23, %31;
fma.rn.f32 f49, f48, 0f3F7994E0, f47;
sub.f32 f50, %25, %28;
fma.rn.f32 f51, f50, 0f3EDE2602, f49;
sub.f32 f52, f45, f51;
add.f32 f53, f51, f45;
mul.f32 f54, f29, 0f3E63DC87;
sub.f32 f55, %16, f54;
mul.f32 f56, f31, 0f3F66A5E5;
sub.f32 f57, f55, f56;
fma.rn.f32 f58, f33, 0f3F1F9D07, f57;
mul.f32 f59, f46, 0f3F7994E0;
mul.f32 f60, f48, 0f3EDE2602;
sub.f32 f61, f59, f60;
mul.f32 f62, f50, 0f3F48261C;
sub.f32 f63, f61, f62;
sub.f32 f64, f58, f63;
add.f32 f65, f63, f58;
mul.f32 f66, f29, 0f3F66A5E5;
sub.f32 f67, %16, f66;
fma.rn.f32 f68, f31, 0f3F1F9D07, f67;
mul.f32 f69, f33, 0f3E63DC87;
sub.f32 f70, f68, f69;
mul.f32 f71, f46, 0f3EDE2602;
mul.f32 f72, f48, 0f3F48261C;
sub.f32 f73, f71, f72;
fma.rn.f32 f74, f50, 0f3F7994E0, f73;
sub.f32 f75, f70, f74;
add.f32 f76, f74, f70;
fma.rn.f32 f77, f35, 0f3F1F9D07, %17;
mul.f32 f78, f37, 0f3E63DC87;
sub.f32 f79, f77, f78;
mul.f32 f80, f39, 0f3F66A5E5;
sub.f32 f81, f79, f80;
sub.f32 f82, %18, %32;
mul.f32 f83, f82, 0f3F48261C;
sub.f32 f84, %21, %29;
fma.rn.f32 f85, f84, 0f3F7994E0, f83;
sub.f32 f86, %24, %26;
fma.rn.f32 f87, f86, 0f3EDE2602, f85;
add.f32 f88, f87, f81;
sub.f32 f89, f81, f87;
mul.f32 f90, f35, 0f3E63DC87;
sub.f32 f91, %17, f90;
mul.f32 f92, f37, 0f3F66A5E5;
sub.f32 f93, f91, f92;
fma.rn.f32 f94, f39, 0f3F1F9D07, f93;
mul.f32 f95, f82, 0f3F7994E0;
mul.f32 f96, f84, 0f3EDE2602;
sub.f32 f97, f95, f96;
mul.f32 f98, f86, 0f3F48261C;
sub.f32 f99, f97, f98;
add.f32 f100, f99, f94;
sub.f32 f101, f94, f99;
mul.f32 f102, f35, 0f3F66A5E5;
sub.f32 f103, %17, f102;
fma.rn.f32 f104, f37, 0f3F1F9D07, f103;
mul.f32 f105, f39, 0f3E63DC87;
sub.f32 f106, f104, f105;
mul.f32 f107, f82, 0f3EDE2602;
mul.f32 f108, f84, 0f3F48261C;
sub.f32 f109, f107, f108;
fma.rn.f32 f110, f86, 0f3F7994E0, f109;
add.f32 f111, f110, f106;
sub.f32 f112, f106, f110;
mul.wide.u32 rd2, r4, 613566757;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 2;
mul.lo.s32 r10, r9, 7;
sub.s32 r11, r4, r10;
mul.wide.u32 rd4, r11, 8;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f113, f114}, [rd6];
mul.f32 f117, f88, f114;
fma.rn.f32 f118, f113, f52, f117;
mul.f32 f119, f52, f114;
mul.f32 f120, f113, f88;
sub.f32 f121, f120, f119;
mul.f32 f122, f113, f113;
mul.f32 f123, f114, f114;
sub.f32 f124, f122, f123;
mul.f32 f125, f114, f113;
fma.rn.f32 f126, f114, f113, f125;
mul.f32 f127, f100, f126;
fma.rn.f32 f128, f124, f64, f127;
mul.f32 f129, f64, f126;
mul.f32 f130, f124, f100;
sub.f32 f131, f130, f129;
mul.f32 f132, f113, f124;
mul.f32 f133, f114, f126;
sub.f32 f134, f132, f133;
mul.f32 f135, f113, f126;
fma.rn.f32 f136, f114, f124, f135;
mul.f32 f137, f111, f136;
fma.rn.f32 f138, f134, f75, f137;
mul.f32 f139, f75, f136;
mul.f32 f140, f134, f111;
sub.f32 f141, f140, f139;
mul.f32 f142, f113, f134;
mul.f32 f143, f114, f136;
sub.f32 f144, f142, f143;
mul.f32 f145, f113, f136;
fma.rn.f32 f146, f114, f134, f145;
mul.f32 f147, f112, f146;
fma.rn.f32 f148, f144, f76, f147;
mul.f32 f149, f76, f146;
mul.f32 f150, f144, f112;
sub.f32 f151, f150, f149;
mul.f32 f152, f113, f144;
mul.f32 f153, f114, f146;
sub.f32 f154, f152, f153;
mul.f32 f155, f113, f146;
fma.rn.f32 f156, f114, f144, f155;
mul.f32 f157, f101, f156;
fma.rn.f32 f158, f154, f65, f157;
mul.f32 f159, f65, f156;
mul.f32 f160, f154, f101;
sub.f32 f161, f160, f159;
mul.f32 f162, f113, f154;
mul.f32 f163, f114, f156;
sub.f32 f164, f162, f163;
mul.f32 f165, f113, f156;
fma.rn.f32 f166, f114, f154, f165;
mul.f32 f167, f89, f166;
fma.rn.f32 f168, f164, f53, f167;
mul.f32 f169, f53, f166;
mul.f32 f170, f164, f89;
sub.f32 f171, f170, f169;
mad.lo.s32 r12, r9, 196, r3;
barrier.sync 0;
mad.lo.s32 r13, r11, 28, r12;
st.shared.f32 [r13], f34;
st.shared.f32 [r13+4], f118;
st.shared.f32 [r13+8], f128;
st.shared.f32 [r13+12], f138;
st.shared.f32 [r13+16], f148;
st.shared.f32 [r13+20], f158;
st.shared.f32 [r13+24], f168;
barrier.sync 0;
mad.lo.s32 r14, r11, -24, r13;
ld.shared.f32 f172, [r14];
ld.shared.f32 f173, [r14+28];
ld.shared.f32 f174, [r14+56];
ld.shared.f32 f175, [r14+84];
ld.shared.f32 f176, [r14+112];
ld.shared.f32 f177, [r14+140];
ld.shared.f32 f178, [r14+168];
barrier.sync 0;
st.shared.f32 [r13], f40;
st.shared.f32 [r13+4], f121;
st.shared.f32 [r13+8], f131;
st.shared.f32 [r13+12], f141;
st.shared.f32 [r13+16], f151;
st.shared.f32 [r13+20], f161;
st.shared.f32 [r13+24], f171;
barrier.sync 0;
ld.shared.f32 f179, [r14];
ld.shared.f32 f180, [r14+28];
ld.shared.f32 f181, [r14+56];
ld.shared.f32 f182, [r14+84];
ld.shared.f32 f183, [r14+112];
ld.shared.f32 f184, [r14+140];
ld.shared.f32 f185, [r14+168];
add.f32 f186, f173, f178;
add.f32 f187, f172, f186;
add.f32 f188, f174, f177;
add.f32 f189, f188, f187;
add.f32 f190, f175, f176;
add.f32 f191, f180, f185;
add.f32 f192, f179, f191;
add.f32 f193, f181, f184;
add.f32 f194, f193, f192;
add.f32 f195, f182, f183;
fma.rn.f32 f196, f186, 0f3F1F9D07, f172;
mul.f32 f197, f188, 0f3E63DC87;
sub.f32 f198, f196, f197;
mul.f32 f199, f190, 0f3F66A5E5;
sub.f32 f200, f198, f199;
sub.f32 f201, f180, f185;
mul.f32 f202, f201, 0f3F48261C;
sub.f32 f203, f181, f184;
fma.rn.f32 f204, f203, 0f3F7994E0, f202;
sub.f32 f205, f182, f183;
fma.rn.f32 f206, f205, 0f3EDE2602, f204;
mul.f32 f207, f186, 0f3E63DC87;
sub.f32 f208, f172, f207;
mul.f32 f209, f188, 0f3F66A5E5;
sub.f32 f210, f208, f209;
fma.rn.f32 f211, f190, 0f3F1F9D07, f210;
mul.f32 f212, f201, 0f3F7994E0;
mul.f32 f213, f203, 0f3EDE2602;
sub.f32 f214, f212, f213;
mul.f32 f215, f205, 0f3F48261C;
sub.f32 f216, f214, f215;
mul.f32 f217, f186, 0f3F66A5E5;
sub.f32 f218, f172, f217;
fma.rn.f32 f219, f188, 0f3F1F9D07, f218;
mul.f32 f220, f190, 0f3E63DC87;
sub.f32 f221, f219, f220;
mul.f32 f222, f201, 0f3EDE2602;
mul.f32 f223, f203, 0f3F48261C;
sub.f32 f224, f222, f223;
fma.rn.f32 f225, f205, 0f3F7994E0, f224;
fma.rn.f32 f226, f191, 0f3F1F9D07, f179;
mul.f32 f227, f193, 0f3E63DC87;
sub.f32 f228, f226, f227;
mul.f32 f229, f195, 0f3F66A5E5;
sub.f32 f230, f228, f229;
sub.f32 f231, f173, f178;
mul.f32 f232, f231, 0f3F48261C;
sub.f32 f233, f174, f177;
fma.rn.f32 f234, f233, 0f3F7994E0, f232;
sub.f32 f235, f175, f176;
fma.rn.f32 f236, f235, 0f3EDE2602, f234;
mul.f32 f237, f191, 0f3E63DC87;
sub.f32 f238, f179, f237;
mul.f32 f239, f193, 0f3F66A5E5;
sub.f32 f240, f238, f239;
fma.rn.f32 f241, f195, 0f3F1F9D07, f240;
mul.f32 f242, f231, 0f3F7994E0;
mul.f32 f243, f233, 0f3EDE2602;
sub.f32 f244, f242, f243;
mul.f32 f245, f235, 0f3F48261C;
sub.f32 f246, f244, f245;
mul.f32 f247, f191, 0f3F66A5E5;
sub.f32 f248, f179, f247;
fma.rn.f32 f249, f193, 0f3F1F9D07, f248;
mul.f32 f250, f195, 0f3E63DC87;
sub.f32 f251, f249, f250;
mul.f32 f252, f231, 0f3EDE2602;
mul.f32 f253, f233, 0f3F48261C;
sub.f32 f254, f252, f253;
fma.rn.f32 f255, f235, 0f3F7994E0, f254;
add.f32 %0, f190, f189;
add.f32 %1, f195, f194;
add.f32 %3, f236, f230;
sub.f32 %2, f200, f206;
sub.f32 %4, f211, f216;
add.f32 %5, f246, f241;
sub.f32 %6, f221, f225;
add.f32 %7, f255, f251;
add.f32 %8, f225, f221;
sub.f32 %9, f251, f255;
add.f32 %10, f216, f211;
sub.f32 %11, f241, f246;
sub.f32 %13, f230, f236;
add.f32 %12, f206, f200;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y): "r"(smem), "l"(lut_sp_7_49), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y));
};


#endif
