#ifndef CUFFTDX_FFT_15625_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_15625_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<1155, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<2811>;
.reg .b32 r<21>;
.reg .b64 rd<15>;
mov.u32 r19, %tid.y;
mov.u32 r20, %50;
mad.lo.s32 r3, r19, 125000, r20;
add.f32 f101, %63, %93;
add.f32 f103, %73, %83;
add.f32 f2810, %53, f101;
add.f32 f104, f103, f2810;
add.f32 f105, %103, %105;
add.f32 f107, %104, %84;
add.f32 f2806, %54, f105;
add.f32 f108, f107, f2806;
mul.f32 f110, f103, 0f3F4F1BBD;
fma.rn.f32 f2805, f101, 0f3E9E377A, %53;
sub.f32 f111, f2805, f110;
sub.f32 f112, %103, %105;
sub.f32 f114, %104, %84;
mul.f32 f2803, f112, 0f3F737871;
mul.f32 f2804, f114, 0fBF167918;
sub.f32 f116, f2804, f2803;
sub.f32 f117, f111, f116;
add.f32 f118, f116, f111;
mul.f32 f119, f101, 0f3F4F1BBD;
sub.f32 f120, %53, f119;
fma.rn.f32 f121, f103, 0f3E9E377A, f120;
mul.f32 f122, f112, 0f3F167918;
mul.f32 f123, f114, 0f3F737871;
sub.f32 f124, f123, f122;
sub.f32 f125, f121, f124;
add.f32 f126, f124, f121;
fma.rn.f32 f2801, f105, 0f3E9E377A, %54;
mul.f32 f2802, f107, 0f3F4F1BBD;
sub.f32 f129, f2801, f2802;
sub.f32 f130, %63, %93;
sub.f32 f132, %73, %83;
mul.f32 f2799, f130, 0f3F737871;
mul.f32 f2800, f132, 0fBF167918;
sub.f32 f134, f2800, f2799;
add.f32 f135, f134, f129;
sub.f32 f136, f129, f134;
mul.f32 f137, f105, 0f3F4F1BBD;
sub.f32 f138, %54, f137;
fma.rn.f32 f139, f107, 0f3E9E377A, f138;
mul.f32 f140, f130, 0f3F167918;
mul.f32 f141, f132, 0f3F737871;
sub.f32 f142, f141, f140;
add.f32 f143, f142, f139;
sub.f32 f144, f139, f142;
add.f32 f145, %65, %95;
add.f32 f147, %75, %85;
add.f32 f2798, %55, f145;
add.f32 f148, f147, f2798;
add.f32 f149, %66, %96;
add.f32 f151, %106, %107;
add.f32 f2794, %108, f149;
add.f32 f152, f151, f2794;
fma.rn.f32 f2792, f145, 0f3E9E377A, %55;
mul.f32 f2793, f147, 0f3F4F1BBD;
sub.f32 f155, f2792, f2793;
sub.f32 f156, %66, %96;
sub.f32 f158, %106, %107;
mul.f32 f2790, f156, 0f3F737871;
mul.f32 f2791, f158, 0fBF167918;
sub.f32 f160, f2791, f2790;
sub.f32 f161, f155, f160;
add.f32 f162, f160, f155;
mul.f32 f163, f145, 0f3F4F1BBD;
sub.f32 f164, %55, f163;
fma.rn.f32 f165, f147, 0f3E9E377A, f164;
mul.f32 f166, f156, 0f3F167918;
mul.f32 f167, f158, 0f3F737871;
sub.f32 f168, f167, f166;
sub.f32 f169, f165, f168;
add.f32 f170, f168, f165;
mul.f32 f172, f151, 0f3F4F1BBD;
fma.rn.f32 f2789, f149, 0f3E9E377A, %108;
sub.f32 f173, f2789, f172;
sub.f32 f174, %65, %95;
sub.f32 f176, %75, %85;
mul.f32 f177, f176, 0fBF167918;
mul.f32 f2788, f174, 0f3F737871;
sub.f32 f178, f177, f2788;
add.f32 f179, f178, f173;
sub.f32 f180, f173, f178;
mul.f32 f181, f149, 0f3F4F1BBD;
sub.f32 f182, %108, f181;
fma.rn.f32 f183, f151, 0f3E9E377A, f182;
mul.f32 f184, f174, 0f3F167918;
mul.f32 f185, f176, 0f3F737871;
sub.f32 f186, f185, f184;
add.f32 f187, f186, f183;
sub.f32 f188, f183, f186;
add.f32 f189, %67, %97;
add.f32 f191, %77, %87;
add.f32 f2787, %57, f189;
add.f32 f192, f191, f2787;
add.f32 f193, %112, %111;
add.f32 f195, %78, %109;
add.f32 f2782, %110, f193;
add.f32 f196, f195, f2782;
mul.f32 f198, f191, 0f3F4F1BBD;
fma.rn.f32 f2781, f189, 0f3E9E377A, %57;
sub.f32 f199, f2781, f198;
sub.f32 f200, %112, %111;
sub.f32 f202, %78, %109;
mul.f32 f203, f202, 0fBF167918;
mul.f32 f2780, f200, 0f3F737871;
sub.f32 f204, f203, f2780;
sub.f32 f205, f199, f204;
add.f32 f206, f204, f199;
mul.f32 f207, f189, 0f3F4F1BBD;
sub.f32 f208, %57, f207;
fma.rn.f32 f209, f191, 0f3E9E377A, f208;
mul.f32 f210, f200, 0f3F167918;
mul.f32 f211, f202, 0f3F737871;
sub.f32 f212, f211, f210;
sub.f32 f213, f209, f212;
add.f32 f214, f212, f209;
fma.rn.f32 f2778, f193, 0f3E9E377A, %110;
mul.f32 f2779, f195, 0f3F4F1BBD;
sub.f32 f217, f2778, f2779;
sub.f32 f218, %67, %97;
sub.f32 f220, %77, %87;
mul.f32 f2776, f218, 0f3F737871;
mul.f32 f2777, f220, 0fBF167918;
sub.f32 f222, f2777, f2776;
add.f32 f223, f222, f217;
sub.f32 f224, f217, f222;
mul.f32 f225, f193, 0f3F4F1BBD;
sub.f32 f226, %110, f225;
fma.rn.f32 f227, f195, 0f3E9E377A, f226;
mul.f32 f228, f218, 0f3F167918;
mul.f32 f229, f220, 0f3F737871;
sub.f32 f230, f229, f228;
add.f32 f231, f230, f227;
sub.f32 f232, f227, f230;
add.f32 f233, %69, %99;
add.f32 f235, %79, %89;
add.f32 f2775, %59, f233;
add.f32 f236, f235, f2775;
add.f32 f237, %114, %113;
add.f32 f239, %115, %90;
add.f32 f2771, %60, f237;
add.f32 f240, f239, f2771;
fma.rn.f32 f2769, f233, 0f3E9E377A, %59;
mul.f32 f2770, f235, 0f3F4F1BBD;
sub.f32 f243, f2769, f2770;
sub.f32 f244, %114, %113;
sub.f32 f246, %115, %90;
mul.f32 f2767, f244, 0f3F737871;
mul.f32 f2768, f246, 0fBF167918;
sub.f32 f248, f2768, f2767;
sub.f32 f249, f243, f248;
add.f32 f250, f248, f243;
mul.f32 f251, f233, 0f3F4F1BBD;
sub.f32 f252, %59, f251;
fma.rn.f32 f253, f235, 0f3E9E377A, f252;
mul.f32 f254, f244, 0f3F167918;
mul.f32 f255, f246, 0f3F737871;
sub.f32 f256, f255, f254;
sub.f32 f257, f253, f256;
add.f32 f258, f256, f253;
mul.f32 f260, f239, 0f3F4F1BBD;
fma.rn.f32 f2766, f237, 0f3E9E377A, %60;
sub.f32 f261, f2766, f260;
sub.f32 f262, %69, %99;
sub.f32 f264, %79, %89;
mul.f32 f2764, f262, 0f3F737871;
mul.f32 f2765, f264, 0fBF167918;
sub.f32 f266, f2765, f2764;
add.f32 f267, f266, f261;
sub.f32 f268, f261, f266;
mul.f32 f269, f237, 0f3F4F1BBD;
sub.f32 f270, %60, f269;
fma.rn.f32 f271, f239, 0f3E9E377A, f270;
mul.f32 f272, f262, 0f3F167918;
mul.f32 f273, f264, 0f3F737871;
sub.f32 f274, f273, f272;
add.f32 f275, f274, f271;
sub.f32 f276, f271, f274;
add.f32 f277, %71, %101;
add.f32 f279, %81, %91;
add.f32 f2763, %61, f277;
add.f32 f280, f279, f2763;
add.f32 f281, %72, %102;
add.f32 f283, %118, %116;
add.f32 f2759, %117, f281;
add.f32 f284, f283, f2759;
mul.f32 f286, f279, 0f3F4F1BBD;
fma.rn.f32 f2758, f277, 0f3E9E377A, %61;
sub.f32 f287, f2758, f286;
sub.f32 f288, %72, %102;
sub.f32 f290, %118, %116;
mul.f32 f2756, f288, 0f3F737871;
mul.f32 f2757, f290, 0fBF167918;
sub.f32 f292, f2757, f2756;
sub.f32 f293, f287, f292;
add.f32 f294, f292, f287;
mul.f32 f295, f277, 0f3F4F1BBD;
sub.f32 f296, %61, f295;
fma.rn.f32 f297, f279, 0f3E9E377A, f296;
mul.f32 f298, f288, 0f3F167918;
mul.f32 f299, f290, 0f3F737871;
sub.f32 f300, f299, f298;
sub.f32 f301, f297, f300;
add.f32 f302, f300, f297;
mul.f32 f304, f283, 0f3F4F1BBD;
fma.rn.f32 f2755, f281, 0f3E9E377A, %117;
sub.f32 f305, f2755, f304;
sub.f32 f306, %71, %101;
sub.f32 f308, %81, %91;
mul.f32 f2753, f306, 0f3F737871;
mul.f32 f2754, f308, 0fBF167918;
sub.f32 f310, f2754, f2753;
add.f32 f311, f310, f305;
sub.f32 f312, f305, f310;
mul.f32 f313, f281, 0f3F4F1BBD;
sub.f32 f314, %117, f313;
fma.rn.f32 f315, f283, 0f3E9E377A, f314;
mul.f32 f316, f306, 0f3F167918;
mul.f32 f317, f308, 0f3F737871;
sub.f32 f318, f317, f316;
add.f32 f319, f318, f315;
sub.f32 f320, f315, f318;
mul.f32 f322, f179, 0fBE7EA890;
mul.f32 f2752, f161, 0f3F77F511;
sub.f32 f323, f2752, f322;
mul.f32 f324, f179, 0f3F77F511;
fma.rn.f32 f325, f161, 0fBE7EA890, f324;
mul.f32 f327, f223, 0fBEF6A86B;
mul.f32 f2751, f205, 0f3F6055A2;
sub.f32 f328, f2751, f327;
mul.f32 f329, f223, 0f3F6055A2;
fma.rn.f32 f330, f205, 0fBEF6A86B, f329;
mul.f32 f332, f267, 0fBF2F3E7B;
mul.f32 f2750, f249, 0f3F3A9DB0;
sub.f32 f333, f2750, f332;
mul.f32 f334, f267, 0f3F3A9DB0;
fma.rn.f32 f335, f249, 0fBF2F3E7B, f334;
mul.f32 f337, f311, 0fBF5825E0;
mul.f32 f2749, f293, 0f3F092BF2;
sub.f32 f338, f2749, f337;
mul.f32 f339, f311, 0f3F092BF2;
fma.rn.f32 f340, f293, 0fBF5825E0, f339;
mul.f32 f342, f187, 0fBEF6A86B;
mul.f32 f2748, f169, 0f3F6055A2;
sub.f32 f343, f2748, f342;
mul.f32 f344, f187, 0f3F6055A2;
fma.rn.f32 f345, f169, 0fBEF6A86B, f344;
mul.f32 f2746, f213, 0f3F092BF2;
mul.f32 f2747, f231, 0fBF5825E0;
sub.f32 f348, f2746, f2747;
mul.f32 f349, f231, 0f3F092BF2;
fma.rn.f32 f350, f213, 0fBF5825E0, f349;
mul.f32 f2744, f257, 0f3D809851;
mul.f32 f2745, f275, 0fBF7F7EAE;
sub.f32 f353, f2744, f2745;
mul.f32 f354, f275, 0f3D809851;
fma.rn.f32 f355, f257, 0fBF7F7EAE, f354;
mul.f32 f2742, f301, 0fBED9FFBE;
mul.f32 f2743, f319, 0fBF67A2BF;
sub.f32 f358, f2742, f2743;
mul.f32 f359, f319, 0fBED9FFBE;
fma.rn.f32 f360, f301, 0fBF67A2BF, f359;
mul.f32 f2740, f170, 0f3F3A9DB0;
mul.f32 f2741, f188, 0fBF2F3E7B;
sub.f32 f363, f2740, f2741;
mul.f32 f364, f188, 0f3F3A9DB0;
fma.rn.f32 f365, f170, 0fBF2F3E7B, f364;
mul.f32 f367, f232, 0fBF7F7EAE;
mul.f32 f2739, f214, 0f3D809851;
sub.f32 f368, f2739, f367;
mul.f32 f369, f232, 0f3D809851;
fma.rn.f32 f370, f214, 0fBF7F7EAE, f369;
mul.f32 f372, f276, 0fBF45405B;
mul.f32 f2738, f258, 0fBF232E38;
sub.f32 f373, f2738, f372;
mul.f32 f374, f276, 0fBF232E38;
fma.rn.f32 f375, f258, 0fBF45405B, f374;
mul.f32 f377, f320, 0fBE00575B;
mul.f32 f2737, f302, 0fBF7DFB3B;
sub.f32 f378, f2737, f377;
mul.f32 f379, f320, 0fBF7DFB3B;
fma.rn.f32 f380, f302, 0fBE00575B, f379;
mul.f32 f382, f180, 0fBF5825E0;
mul.f32 f2736, f162, 0f3F092BF2;
sub.f32 f383, f2736, f382;
mul.f32 f384, f180, 0f3F092BF2;
fma.rn.f32 f385, f162, 0fBF5825E0, f384;
mul.f32 f387, f224, 0fBF67A2BF;
mul.f32 f2735, f206, 0fBED9FFBE;
sub.f32 f388, f2735, f387;
mul.f32 f389, f224, 0fBED9FFBE;
fma.rn.f32 f390, f206, 0fBF67A2BF, f389;
mul.f32 f2733, f250, 0fBF7DFB3B;
mul.f32 f2734, f268, 0fBE00575B;
sub.f32 f393, f2733, f2734;
mul.f32 f394, f268, 0fBF7DFB3B;
fma.rn.f32 f395, f250, 0fBE00575B, f394;
mul.f32 f2731, f294, 0fBF232E38;
mul.f32 f2732, f312, 0f3F45405B;
sub.f32 f398, f2731, f2732;
mul.f32 f399, f312, 0fBF232E38;
fma.rn.f32 f400, f294, 0f3F45405B, f399;
add.f32 f401, f148, f280;
add.f32 f403, f192, f236;
mul.f32 f408, f403, 0f3F4F1BBD;
fma.rn.f32 f2730, f401, 0f3E9E377A, f104;
sub.f32 f409, f2730, f408;
add.f32 f2729, f152, f284;
sub.f32 f410, f152, f284;
add.f32 f2728, f196, f240;
sub.f32 f412, f196, f240;
mul.f32 f413, f412, 0fBF167918;
mul.f32 f2727, f410, 0f3F737871;
sub.f32 f414, f413, f2727;
sub.f32 f415, f409, f414;
add.f32 f416, f414, f409;
add.f32 f2726, f104, f401;
mul.f32 f417, f401, 0f3F4F1BBD;
sub.f32 f418, f104, f417;
fma.rn.f32 f419, f403, 0f3E9E377A, f418;
mul.f32 f420, f410, 0f3F167918;
mul.f32 f421, f412, 0f3F737871;
sub.f32 f422, f421, f420;
sub.f32 f423, f419, f422;
add.f32 f424, f422, f419;
fma.rn.f32 f2724, f2729, 0f3E9E377A, f108;
mul.f32 f2725, f2728, 0f3F4F1BBD;
sub.f32 f427, f2724, f2725;
sub.f32 f428, f148, f280;
sub.f32 f430, f192, f236;
mul.f32 f2722, f428, 0f3F737871;
mul.f32 f2723, f430, 0fBF167918;
sub.f32 f432, f2723, f2722;
add.f32 f433, f432, f427;
sub.f32 f434, f427, f432;
add.f32 f2721, f108, f2729;
mul.f32 f435, f2729, 0f3F4F1BBD;
sub.f32 f436, f108, f435;
fma.rn.f32 f437, f2728, 0f3E9E377A, f436;
mul.f32 f438, f428, 0f3F167918;
mul.f32 f439, f430, 0f3F737871;
sub.f32 f440, f439, f438;
add.f32 f441, f440, f437;
sub.f32 f442, f437, f440;
add.f32 f443, f323, f338;
add.f32 f445, f328, f333;
add.f32 f2720, f117, f443;
add.f32 f446, f445, f2720;
add.f32 f447, f325, f340;
add.f32 f449, f330, f335;
add.f32 f2719, f135, f447;
add.f32 f450, f449, f2719;
fma.rn.f32 f2717, f443, 0f3E9E377A, f117;
mul.f32 f2718, f445, 0f3F4F1BBD;
sub.f32 f453, f2717, f2718;
sub.f32 f454, f325, f340;
sub.f32 f456, f330, f335;
mul.f32 f2715, f454, 0f3F737871;
mul.f32 f2716, f456, 0fBF167918;
sub.f32 f458, f2716, f2715;
sub.f32 f459, f453, f458;
add.f32 f460, f458, f453;
mul.f32 f461, f443, 0f3F4F1BBD;
sub.f32 f462, f117, f461;
fma.rn.f32 f463, f445, 0f3E9E377A, f462;
mul.f32 f464, f454, 0f3F167918;
mul.f32 f465, f456, 0f3F737871;
sub.f32 f466, f465, f464;
sub.f32 f467, f463, f466;
add.f32 f468, f466, f463;
mul.f32 f470, f449, 0f3F4F1BBD;
fma.rn.f32 f2714, f447, 0f3E9E377A, f135;
sub.f32 f471, f2714, f470;
sub.f32 f472, f323, f338;
sub.f32 f474, f328, f333;
mul.f32 f2712, f472, 0f3F737871;
mul.f32 f2713, f474, 0fBF167918;
sub.f32 f476, f2713, f2712;
add.f32 f477, f476, f471;
sub.f32 f478, f471, f476;
mul.f32 f479, f447, 0f3F4F1BBD;
sub.f32 f480, f135, f479;
fma.rn.f32 f481, f449, 0f3E9E377A, f480;
mul.f32 f482, f472, 0f3F167918;
mul.f32 f483, f474, 0f3F737871;
sub.f32 f484, f483, f482;
add.f32 f485, f484, f481;
sub.f32 f486, f481, f484;
add.f32 f487, f343, f358;
add.f32 f489, f348, f353;
add.f32 f2711, f125, f487;
add.f32 f490, f489, f2711;
add.f32 f491, f345, f360;
add.f32 f493, f350, f355;
add.f32 f2710, f143, f491;
add.f32 f494, f493, f2710;
mul.f32 f496, f489, 0f3F4F1BBD;
fma.rn.f32 f2709, f487, 0f3E9E377A, f125;
sub.f32 f497, f2709, f496;
sub.f32 f498, f345, f360;
sub.f32 f500, f350, f355;
mul.f32 f2707, f498, 0f3F737871;
mul.f32 f2708, f500, 0fBF167918;
sub.f32 f502, f2708, f2707;
sub.f32 f503, f497, f502;
add.f32 f504, f502, f497;
mul.f32 f505, f487, 0f3F4F1BBD;
sub.f32 f506, f125, f505;
fma.rn.f32 f507, f489, 0f3E9E377A, f506;
mul.f32 f508, f498, 0f3F167918;
mul.f32 f509, f500, 0f3F737871;
sub.f32 f510, f509, f508;
sub.f32 f511, f507, f510;
add.f32 f512, f510, f507;
mul.f32 f514, f493, 0f3F4F1BBD;
fma.rn.f32 f2706, f491, 0f3E9E377A, f143;
sub.f32 f515, f2706, f514;
sub.f32 f516, f343, f358;
sub.f32 f518, f348, f353;
mul.f32 f2704, f516, 0f3F737871;
mul.f32 f2705, f518, 0fBF167918;
sub.f32 f520, f2705, f2704;
add.f32 f521, f520, f515;
sub.f32 f522, f515, f520;
mul.f32 f523, f491, 0f3F4F1BBD;
sub.f32 f524, f143, f523;
fma.rn.f32 f525, f493, 0f3E9E377A, f524;
mul.f32 f526, f516, 0f3F167918;
mul.f32 f527, f518, 0f3F737871;
sub.f32 f528, f527, f526;
add.f32 f529, f528, f525;
sub.f32 f530, f525, f528;
add.f32 f531, f363, f378;
add.f32 f533, f368, f373;
add.f32 f2703, f126, f531;
add.f32 f534, f533, f2703;
add.f32 f535, f365, f380;
add.f32 f537, f370, f375;
add.f32 f2702, f144, f535;
add.f32 f538, f537, f2702;
mul.f32 f540, f533, 0f3F4F1BBD;
fma.rn.f32 f2701, f531, 0f3E9E377A, f126;
sub.f32 f541, f2701, f540;
sub.f32 f542, f365, f380;
sub.f32 f544, f370, f375;
mul.f32 f2699, f542, 0f3F737871;
mul.f32 f2700, f544, 0fBF167918;
sub.f32 f546, f2700, f2699;
sub.f32 f547, f541, f546;
add.f32 f548, f546, f541;
mul.f32 f549, f531, 0f3F4F1BBD;
sub.f32 f550, f126, f549;
fma.rn.f32 f551, f533, 0f3E9E377A, f550;
mul.f32 f552, f542, 0f3F167918;
mul.f32 f553, f544, 0f3F737871;
sub.f32 f554, f553, f552;
sub.f32 f555, f551, f554;
add.f32 f556, f554, f551;
fma.rn.f32 f2697, f535, 0f3E9E377A, f144;
mul.f32 f2698, f537, 0f3F4F1BBD;
sub.f32 f559, f2697, f2698;
sub.f32 f560, f363, f378;
sub.f32 f562, f368, f373;
mul.f32 f2695, f560, 0f3F737871;
mul.f32 f2696, f562, 0fBF167918;
sub.f32 f564, f2696, f2695;
add.f32 f565, f564, f559;
sub.f32 f566, f559, f564;
mul.f32 f567, f535, 0f3F4F1BBD;
sub.f32 f568, f144, f567;
fma.rn.f32 f569, f537, 0f3E9E377A, f568;
mul.f32 f570, f560, 0f3F167918;
mul.f32 f571, f562, 0f3F737871;
sub.f32 f572, f571, f570;
add.f32 f573, f572, f569;
sub.f32 f574, f569, f572;
add.f32 f575, f383, f398;
add.f32 f577, f388, f393;
add.f32 f2694, f118, f575;
add.f32 f578, f577, f2694;
add.f32 f579, f385, f400;
add.f32 f581, f390, f395;
add.f32 f2693, f136, f579;
add.f32 f582, f581, f2693;
fma.rn.f32 f2691, f575, 0f3E9E377A, f118;
mul.f32 f2692, f577, 0f3F4F1BBD;
sub.f32 f585, f2691, f2692;
sub.f32 f586, f385, f400;
sub.f32 f588, f390, f395;
mul.f32 f2689, f586, 0f3F737871;
mul.f32 f2690, f588, 0fBF167918;
sub.f32 f590, f2690, f2689;
sub.f32 f591, f585, f590;
add.f32 f592, f590, f585;
mul.f32 f593, f575, 0f3F4F1BBD;
sub.f32 f594, f118, f593;
fma.rn.f32 f595, f577, 0f3E9E377A, f594;
mul.f32 f596, f586, 0f3F167918;
mul.f32 f597, f588, 0f3F737871;
sub.f32 f598, f597, f596;
sub.f32 f599, f595, f598;
add.f32 f600, f598, f595;
mul.f32 f602, f581, 0f3F4F1BBD;
fma.rn.f32 f2688, f579, 0f3E9E377A, f136;
sub.f32 f603, f2688, f602;
sub.f32 f604, f383, f398;
sub.f32 f606, f388, f393;
mul.f32 f2686, f604, 0f3F737871;
mul.f32 f2687, f606, 0fBF167918;
sub.f32 f608, f2687, f2686;
add.f32 f609, f608, f603;
sub.f32 f610, f603, f608;
mul.f32 f611, f579, 0f3F4F1BBD;
sub.f32 f612, f136, f611;
fma.rn.f32 f613, f581, 0f3E9E377A, f612;
mul.f32 f614, f604, 0f3F167918;
mul.f32 f615, f606, 0f3F737871;
sub.f32 f616, f615, f614;
add.f32 f617, f616, f613;
sub.f32 f618, f613, f616;
mov.u32 r18, %tid.x;
mul.wide.u32 rd2, r18, -776530087;
shr.u64 rd3, rd2, 41;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 625;
sub.s32 r7, r18, r6;
mad.lo.s32 r8, r5, 125000, r3;
mov.u64 rd5, %51;
mul.wide.u32 rd14, r7, 8;
add.s64 rd6, rd5, rd14;
ld.global.v2.f32 {f619, f620}, [rd6];
mul.f32 f624, f620, f450;
mul.f32 f625, f619, f450;
mul.f32 f627, f620, f620;
mul.f32 f2685, f619, f619;
sub.f32 f628, f2685, f627;
mul.f32 f629, f620, f619;
fma.rn.f32 f630, f620, f619, f629;
mul.f32 f632, f630, f494;
mul.f32 f633, f628, f494;
mul.f32 f2683, f619, f628;
mul.f32 f2684, f620, f630;
sub.f32 f636, f2683, f2684;
mul.f32 f2682, f628, f490;
mul.f32 f637, f619, f630;
fma.rn.f32 f638, f620, f628, f637;
mul.f32 f640, f638, f538;
mul.f32 f641, f636, f538;
mul.f32 f643, f620, f638;
mul.f32 f2681, f619, f636;
sub.f32 f644, f2681, f643;
mul.f32 f2680, f636, f534;
mul.f32 f645, f619, f638;
fma.rn.f32 f646, f620, f636, f645;
mul.f32 f648, f646, f582;
mul.f32 f649, f644, f582;
mul.f32 f2678, f619, f644;
mul.f32 f2679, f620, f646;
sub.f32 f652, f2678, f2679;
mul.f32 f2677, f644, f578;
mul.f32 f653, f619, f646;
fma.rn.f32 f654, f620, f644, f653;
mul.f32 f656, f654, f433;
mul.f32 f657, f652, f433;
mul.f32 f659, f620, f654;
mul.f32 f2676, f619, f652;
sub.f32 f660, f2676, f659;
mul.f32 f2675, f652, f415;
mul.f32 f661, f619, f654;
fma.rn.f32 f662, f620, f652, f661;
mul.f32 f664, f662, f477;
mul.f32 f665, f660, f477;
mul.f32 f667, f620, f662;
mul.f32 f2674, f619, f660;
sub.f32 f668, f2674, f667;
mul.f32 f2673, f660, f459;
mul.f32 f669, f619, f662;
fma.rn.f32 f670, f620, f660, f669;
mul.f32 f672, f670, f521;
mul.f32 f673, f668, f521;
mul.f32 f2671, f619, f668;
mul.f32 f2672, f620, f670;
sub.f32 f676, f2671, f2672;
mul.f32 f2670, f668, f503;
mul.f32 f677, f619, f670;
fma.rn.f32 f678, f620, f668, f677;
mul.f32 f680, f678, f565;
mul.f32 f681, f676, f565;
mul.f32 f683, f620, f678;
mul.f32 f2669, f619, f676;
sub.f32 f684, f2669, f683;
mul.f32 f2668, f676, f547;
mul.f32 f685, f619, f678;
fma.rn.f32 f686, f620, f676, f685;
mul.f32 f688, f686, f609;
mul.f32 f689, f684, f609;
mul.f32 f691, f620, f686;
mul.f32 f2667, f619, f684;
sub.f32 f692, f2667, f691;
mul.f32 f2666, f684, f591;
mul.f32 f693, f619, f686;
fma.rn.f32 f694, f620, f684, f693;
mul.f32 f696, f694, f441;
mul.f32 f697, f692, f441;
mul.f32 f2664, f619, f692;
mul.f32 f2665, f620, f694;
sub.f32 f700, f2664, f2665;
mul.f32 f2663, f692, f423;
mul.f32 f701, f619, f694;
fma.rn.f32 f702, f620, f692, f701;
mul.f32 f704, f702, f485;
mul.f32 f705, f700, f485;
mul.f32 f707, f620, f702;
mul.f32 f2662, f619, f700;
sub.f32 f708, f2662, f707;
mul.f32 f2661, f700, f467;
mul.f32 f709, f619, f702;
fma.rn.f32 f710, f620, f700, f709;
mul.f32 f712, f710, f529;
mul.f32 f713, f708, f529;
mul.f32 f2659, f619, f708;
mul.f32 f2660, f620, f710;
sub.f32 f716, f2659, f2660;
mul.f32 f2658, f708, f511;
mul.f32 f717, f619, f710;
fma.rn.f32 f718, f620, f708, f717;
mul.f32 f720, f718, f573;
mul.f32 f721, f716, f573;
mul.f32 f723, f620, f718;
mul.f32 f2657, f619, f716;
sub.f32 f724, f2657, f723;
mul.f32 f2656, f716, f555;
mul.f32 f725, f619, f718;
fma.rn.f32 f726, f620, f716, f725;
mul.f32 f728, f726, f617;
mul.f32 f729, f724, f617;
mul.f32 f731, f620, f726;
mul.f32 f2655, f619, f724;
sub.f32 f732, f2655, f731;
mul.f32 f2654, f724, f599;
mul.f32 f733, f619, f726;
fma.rn.f32 f734, f620, f724, f733;
mul.f32 f736, f734, f442;
mul.f32 f737, f732, f442;
mul.f32 f2652, f619, f732;
mul.f32 f2653, f620, f734;
sub.f32 f740, f2652, f2653;
mul.f32 f2651, f732, f424;
mul.f32 f741, f619, f734;
fma.rn.f32 f742, f620, f732, f741;
mul.f32 f744, f742, f486;
mul.f32 f745, f740, f486;
mul.f32 f747, f620, f742;
mul.f32 f2650, f619, f740;
sub.f32 f748, f2650, f747;
mul.f32 f2649, f740, f468;
mul.f32 f749, f619, f742;
fma.rn.f32 f750, f620, f740, f749;
mul.f32 f752, f750, f530;
mul.f32 f753, f748, f530;
mul.f32 f755, f620, f750;
mul.f32 f2648, f619, f748;
sub.f32 f756, f2648, f755;
mul.f32 f2647, f748, f512;
mul.f32 f757, f619, f750;
fma.rn.f32 f758, f620, f748, f757;
mul.f32 f760, f758, f574;
mul.f32 f761, f756, f574;
mul.f32 f2645, f619, f756;
mul.f32 f2646, f620, f758;
sub.f32 f764, f2645, f2646;
mul.f32 f2644, f756, f556;
mul.f32 f765, f619, f758;
fma.rn.f32 f766, f620, f756, f765;
mul.f32 f768, f766, f618;
mul.f32 f769, f764, f618;
mul.f32 f771, f620, f766;
mul.f32 f2643, f619, f764;
sub.f32 f772, f2643, f771;
mul.f32 f2642, f764, f600;
mul.f32 f773, f619, f766;
fma.rn.f32 f774, f620, f764, f773;
mul.f32 f776, f774, f434;
mul.f32 f777, f772, f434;
mul.f32 f2640, f619, f772;
mul.f32 f2641, f620, f774;
sub.f32 f780, f2640, f2641;
mul.f32 f2639, f772, f416;
mul.f32 f781, f619, f774;
fma.rn.f32 f782, f620, f772, f781;
mul.f32 f784, f782, f478;
mul.f32 f785, f780, f478;
mul.f32 f787, f620, f782;
mul.f32 f2638, f619, f780;
sub.f32 f788, f2638, f787;
mul.f32 f2637, f780, f460;
mul.f32 f789, f619, f782;
fma.rn.f32 f790, f620, f780, f789;
mul.f32 f792, f790, f522;
mul.f32 f793, f788, f522;
mul.f32 f795, f620, f790;
mul.f32 f2636, f619, f788;
sub.f32 f796, f2636, f795;
mul.f32 f2635, f788, f504;
mul.f32 f797, f619, f790;
fma.rn.f32 f798, f620, f788, f797;
mul.f32 f800, f798, f566;
mul.f32 f801, f796, f566;
mul.f32 f2633, f619, f796;
mul.f32 f2634, f620, f798;
sub.f32 f804, f2633, f2634;
mul.f32 f2632, f619, f446;
mul.f32 f805, f619, f798;
mul.f32 f2631, f796, f548;
fma.rn.f32 f806, f620, f796, f805;
mul.f32 f807, f804, f592;
mul.f32 f808, f806, f610;
mul.f32 f809, f804, f610;
barrier.sync 0;
add.f32 f810, f2728, f2721;
add.f32 f811, f403, f2726;
mad.lo.s32 r17, r7, 200, r8;
st.shared.v2.f32 [r17], {f811, f810};
fma.rn.f32 f812, f620, f446, f625;
sub.f32 f813, f2632, f624;
st.shared.v2.f32 [r17+8], {f813, f812};
fma.rn.f32 f814, f630, f490, f633;
sub.f32 f815, f2682, f632;
st.shared.v2.f32 [r17+16], {f815, f814};
fma.rn.f32 f816, f638, f534, f641;
sub.f32 f817, f2680, f640;
st.shared.v2.f32 [r17+24], {f817, f816};
fma.rn.f32 f818, f646, f578, f649;
sub.f32 f819, f2677, f648;
st.shared.v2.f32 [r17+32], {f819, f818};
sub.f32 f820, f2675, f656;
fma.rn.f32 f821, f654, f415, f657;
st.shared.v2.f32 [r17+40], {f820, f821};
fma.rn.f32 f822, f662, f459, f665;
sub.f32 f823, f2673, f664;
st.shared.v2.f32 [r17+48], {f823, f822};
sub.f32 f824, f2670, f672;
fma.rn.f32 f825, f670, f503, f673;
st.shared.v2.f32 [r17+56], {f824, f825};
fma.rn.f32 f826, f678, f547, f681;
sub.f32 f827, f2668, f680;
st.shared.v2.f32 [r17+64], {f827, f826};
fma.rn.f32 f828, f686, f591, f689;
sub.f32 f829, f2666, f688;
st.shared.v2.f32 [r17+72], {f829, f828};
fma.rn.f32 f830, f694, f423, f697;
sub.f32 f831, f2663, f696;
st.shared.v2.f32 [r17+80], {f831, f830};
fma.rn.f32 f832, f702, f467, f705;
sub.f32 f833, f2661, f704;
st.shared.v2.f32 [r17+88], {f833, f832};
fma.rn.f32 f834, f710, f511, f713;
sub.f32 f835, f2658, f712;
st.shared.v2.f32 [r17+96], {f835, f834};
fma.rn.f32 f836, f718, f555, f721;
sub.f32 f837, f2656, f720;
st.shared.v2.f32 [r17+104], {f837, f836};
fma.rn.f32 f838, f726, f599, f729;
sub.f32 f839, f2654, f728;
st.shared.v2.f32 [r17+112], {f839, f838};
fma.rn.f32 f840, f734, f424, f737;
sub.f32 f841, f2651, f736;
st.shared.v2.f32 [r17+120], {f841, f840};
fma.rn.f32 f842, f742, f468, f745;
sub.f32 f843, f2649, f744;
st.shared.v2.f32 [r17+128], {f843, f842};
fma.rn.f32 f844, f750, f512, f753;
sub.f32 f845, f2647, f752;
st.shared.v2.f32 [r17+136], {f845, f844};
fma.rn.f32 f846, f758, f556, f761;
sub.f32 f847, f2644, f760;
st.shared.v2.f32 [r17+144], {f847, f846};
fma.rn.f32 f848, f766, f600, f769;
sub.f32 f849, f2642, f768;
st.shared.v2.f32 [r17+152], {f849, f848};
fma.rn.f32 f850, f774, f416, f777;
sub.f32 f851, f2639, f776;
st.shared.v2.f32 [r17+160], {f851, f850};
fma.rn.f32 f852, f782, f460, f785;
sub.f32 f853, f2637, f784;
st.shared.v2.f32 [r17+168], {f853, f852};
fma.rn.f32 f854, f790, f504, f793;
sub.f32 f855, f2635, f792;
st.shared.v2.f32 [r17+176], {f855, f854};
fma.rn.f32 f856, f798, f548, f801;
sub.f32 f857, f2631, f800;
st.shared.v2.f32 [r17+184], {f857, f856};
fma.rn.f32 f858, f806, f592, f809;
sub.f32 f859, f807, f808;
st.shared.v2.f32 [r17+192], {f859, f858};
barrier.sync 0;
mad.lo.s32 r10, r7, -192, r17;
ld.shared.v2.f32 {f860, f861}, [r10];
ld.shared.v2.f32 {f864, f865}, [r10+5000];
ld.shared.v2.f32 {f868, f869}, [r10+10000];
ld.shared.v2.f32 {f872, f873}, [r10+15000];
ld.shared.v2.f32 {f876, f877}, [r10+20000];
ld.shared.v2.f32 {f880, f881}, [r10+25000];
ld.shared.v2.f32 {f884, f885}, [r10+30000];
ld.shared.v2.f32 {f888, f889}, [r10+35000];
ld.shared.v2.f32 {f892, f893}, [r10+40000];
ld.shared.v2.f32 {f896, f897}, [r10+45000];
ld.shared.v2.f32 {f900, f901}, [r10+50000];
ld.shared.v2.f32 {f904, f905}, [r10+55000];
ld.shared.v2.f32 {f908, f909}, [r10+60000];
ld.shared.v2.f32 {f912, f913}, [r10+65000];
ld.shared.v2.f32 {f916, f917}, [r10+70000];
ld.shared.v2.f32 {f920, f921}, [r10+75000];
ld.shared.v2.f32 {f924, f925}, [r10+80000];
ld.shared.v2.f32 {f928, f929}, [r10+85000];
ld.shared.v2.f32 {f932, f933}, [r10+90000];
ld.shared.v2.f32 {f936, f937}, [r10+95000];
ld.shared.v2.f32 {f940, f941}, [r10+100000];
ld.shared.v2.f32 {f944, f945}, [r10+105000];
ld.shared.v2.f32 {f948, f949}, [r10+110000];
ld.shared.v2.f32 {f952, f953}, [r10+115000];
ld.shared.v2.f32 {f956, f957}, [r10+120000];
add.f32 f960, f880, f940;
add.f32 f962, f900, f920;
add.f32 f2630, f860, f960;
add.f32 f963, f962, f2630;
add.f32 f964, f881, f941;
add.f32 f966, f901, f921;
add.f32 f2629, f861, f964;
add.f32 f967, f966, f2629;
fma.rn.f32 f2627, f960, 0f3E9E377A, f860;
mul.f32 f2628, f962, 0f3F4F1BBD;
sub.f32 f970, f2627, f2628;
sub.f32 f971, f881, f941;
sub.f32 f973, f901, f921;
mul.f32 f2625, f971, 0f3F737871;
mul.f32 f2626, f973, 0fBF167918;
sub.f32 f975, f2626, f2625;
sub.f32 f976, f970, f975;
add.f32 f977, f975, f970;
mul.f32 f978, f960, 0f3F4F1BBD;
sub.f32 f979, f860, f978;
fma.rn.f32 f980, f962, 0f3E9E377A, f979;
mul.f32 f981, f971, 0f3F167918;
mul.f32 f982, f973, 0f3F737871;
sub.f32 f983, f982, f981;
sub.f32 f984, f980, f983;
add.f32 f985, f983, f980;
mul.f32 f987, f966, 0f3F4F1BBD;
fma.rn.f32 f2624, f964, 0f3E9E377A, f861;
sub.f32 f988, f2624, f987;
sub.f32 f989, f880, f940;
sub.f32 f991, f900, f920;
mul.f32 f2622, f989, 0f3F737871;
mul.f32 f2623, f991, 0fBF167918;
sub.f32 f993, f2623, f2622;
add.f32 f994, f993, f988;
sub.f32 f995, f988, f993;
mul.f32 f996, f964, 0f3F4F1BBD;
sub.f32 f997, f861, f996;
fma.rn.f32 f998, f966, 0f3E9E377A, f997;
mul.f32 f999, f989, 0f3F167918;
mul.f32 f1000, f991, 0f3F737871;
sub.f32 f1001, f1000, f999;
add.f32 f1002, f1001, f998;
sub.f32 f1003, f998, f1001;
add.f32 f1004, f884, f944;
add.f32 f1006, f904, f924;
add.f32 f2621, f864, f1004;
add.f32 f1007, f1006, f2621;
add.f32 f1008, f885, f945;
add.f32 f1010, f905, f925;
add.f32 f2620, f865, f1008;
add.f32 f1011, f1010, f2620;
mul.f32 f1013, f1006, 0f3F4F1BBD;
fma.rn.f32 f2619, f1004, 0f3E9E377A, f864;
sub.f32 f1014, f2619, f1013;
sub.f32 f1015, f885, f945;
sub.f32 f1017, f905, f925;
mul.f32 f2617, f1015, 0f3F737871;
mul.f32 f2618, f1017, 0fBF167918;
sub.f32 f1019, f2618, f2617;
sub.f32 f1020, f1014, f1019;
add.f32 f1021, f1019, f1014;
mul.f32 f1022, f1004, 0f3F4F1BBD;
sub.f32 f1023, f864, f1022;
fma.rn.f32 f1024, f1006, 0f3E9E377A, f1023;
mul.f32 f1025, f1015, 0f3F167918;
mul.f32 f1026, f1017, 0f3F737871;
sub.f32 f1027, f1026, f1025;
sub.f32 f1028, f1024, f1027;
add.f32 f1029, f1027, f1024;
fma.rn.f32 f2615, f1008, 0f3E9E377A, f865;
mul.f32 f2616, f1010, 0f3F4F1BBD;
sub.f32 f1032, f2615, f2616;
sub.f32 f1033, f884, f944;
sub.f32 f1035, f904, f924;
mul.f32 f2613, f1033, 0f3F737871;
mul.f32 f2614, f1035, 0fBF167918;
sub.f32 f1037, f2614, f2613;
add.f32 f1038, f1037, f1032;
sub.f32 f1039, f1032, f1037;
mul.f32 f1040, f1008, 0f3F4F1BBD;
sub.f32 f1041, f865, f1040;
fma.rn.f32 f1042, f1010, 0f3E9E377A, f1041;
mul.f32 f1043, f1033, 0f3F167918;
mul.f32 f1044, f1035, 0f3F737871;
sub.f32 f1045, f1044, f1043;
add.f32 f1046, f1045, f1042;
sub.f32 f1047, f1042, f1045;
add.f32 f1048, f888, f948;
add.f32 f1050, f908, f928;
add.f32 f2612, f868, f1048;
add.f32 f1051, f1050, f2612;
add.f32 f1052, f889, f949;
add.f32 f1054, f909, f929;
add.f32 f2611, f869, f1052;
add.f32 f1055, f1054, f2611;
fma.rn.f32 f2609, f1048, 0f3E9E377A, f868;
mul.f32 f2610, f1050, 0f3F4F1BBD;
sub.f32 f1058, f2609, f2610;
sub.f32 f1059, f889, f949;
sub.f32 f1061, f909, f929;
mul.f32 f2607, f1059, 0f3F737871;
mul.f32 f2608, f1061, 0fBF167918;
sub.f32 f1063, f2608, f2607;
sub.f32 f1064, f1058, f1063;
add.f32 f1065, f1063, f1058;
mul.f32 f1066, f1048, 0f3F4F1BBD;
sub.f32 f1067, f868, f1066;
fma.rn.f32 f1068, f1050, 0f3E9E377A, f1067;
mul.f32 f1069, f1059, 0f3F167918;
mul.f32 f1070, f1061, 0f3F737871;
sub.f32 f1071, f1070, f1069;
sub.f32 f1072, f1068, f1071;
add.f32 f1073, f1071, f1068;
mul.f32 f1075, f1054, 0f3F4F1BBD;
fma.rn.f32 f2606, f1052, 0f3E9E377A, f869;
sub.f32 f1076, f2606, f1075;
sub.f32 f1077, f888, f948;
sub.f32 f1079, f908, f928;
mul.f32 f1080, f1079, 0fBF167918;
mul.f32 f2605, f1077, 0f3F737871;
sub.f32 f1081, f1080, f2605;
add.f32 f1082, f1081, f1076;
sub.f32 f1083, f1076, f1081;
mul.f32 f1084, f1052, 0f3F4F1BBD;
sub.f32 f1085, f869, f1084;
fma.rn.f32 f1086, f1054, 0f3E9E377A, f1085;
mul.f32 f1087, f1077, 0f3F167918;
mul.f32 f1088, f1079, 0f3F737871;
sub.f32 f1089, f1088, f1087;
add.f32 f1090, f1089, f1086;
sub.f32 f1091, f1086, f1089;
add.f32 f1092, f892, f952;
add.f32 f1094, f912, f932;
add.f32 f2604, f872, f1092;
add.f32 f1095, f1094, f2604;
add.f32 f1096, f893, f953;
add.f32 f1098, f913, f933;
add.f32 f2603, f873, f1096;
add.f32 f1099, f1098, f2603;
mul.f32 f1101, f1094, 0f3F4F1BBD;
fma.rn.f32 f2602, f1092, 0f3E9E377A, f872;
sub.f32 f1102, f2602, f1101;
sub.f32 f1103, f893, f953;
sub.f32 f1105, f913, f933;
mul.f32 f1106, f1105, 0fBF167918;
mul.f32 f2601, f1103, 0f3F737871;
sub.f32 f1107, f1106, f2601;
sub.f32 f1108, f1102, f1107;
add.f32 f1109, f1107, f1102;
mul.f32 f1110, f1092, 0f3F4F1BBD;
sub.f32 f1111, f872, f1110;
fma.rn.f32 f1112, f1094, 0f3E9E377A, f1111;
mul.f32 f1113, f1103, 0f3F167918;
mul.f32 f1114, f1105, 0f3F737871;
sub.f32 f1115, f1114, f1113;
sub.f32 f1116, f1112, f1115;
add.f32 f1117, f1115, f1112;
fma.rn.f32 f2599, f1096, 0f3E9E377A, f873;
mul.f32 f2600, f1098, 0f3F4F1BBD;
sub.f32 f1120, f2599, f2600;
sub.f32 f1121, f892, f952;
sub.f32 f1123, f912, f932;
mul.f32 f2597, f1121, 0f3F737871;
mul.f32 f2598, f1123, 0fBF167918;
sub.f32 f1125, f2598, f2597;
add.f32 f1126, f1125, f1120;
sub.f32 f1127, f1120, f1125;
mul.f32 f1128, f1096, 0f3F4F1BBD;
sub.f32 f1129, f873, f1128;
fma.rn.f32 f1130, f1098, 0f3E9E377A, f1129;
mul.f32 f1131, f1121, 0f3F167918;
mul.f32 f1132, f1123, 0f3F737871;
sub.f32 f1133, f1132, f1131;
add.f32 f1134, f1133, f1130;
sub.f32 f1135, f1130, f1133;
add.f32 f1136, f896, f956;
add.f32 f1138, f916, f936;
add.f32 f2596, f876, f1136;
add.f32 f1139, f1138, f2596;
add.f32 f1140, f897, f957;
add.f32 f1142, f917, f937;
add.f32 f2595, f877, f1140;
add.f32 f1143, f1142, f2595;
fma.rn.f32 f2593, f1136, 0f3E9E377A, f876;
mul.f32 f2594, f1138, 0f3F4F1BBD;
sub.f32 f1146, f2593, f2594;
sub.f32 f1147, f897, f957;
sub.f32 f1149, f917, f937;
mul.f32 f2591, f1147, 0f3F737871;
mul.f32 f2592, f1149, 0fBF167918;
sub.f32 f1151, f2592, f2591;
sub.f32 f1152, f1146, f1151;
add.f32 f1153, f1151, f1146;
mul.f32 f1154, f1136, 0f3F4F1BBD;
sub.f32 f1155, f876, f1154;
fma.rn.f32 f1156, f1138, 0f3E9E377A, f1155;
mul.f32 f1157, f1147, 0f3F167918;
mul.f32 f1158, f1149, 0f3F737871;
sub.f32 f1159, f1158, f1157;
sub.f32 f1160, f1156, f1159;
add.f32 f1161, f1159, f1156;
mul.f32 f1163, f1142, 0f3F4F1BBD;
fma.rn.f32 f2590, f1140, 0f3E9E377A, f877;
sub.f32 f1164, f2590, f1163;
sub.f32 f1165, f896, f956;
sub.f32 f1167, f916, f936;
mul.f32 f2588, f1165, 0f3F737871;
mul.f32 f2589, f1167, 0fBF167918;
sub.f32 f1169, f2589, f2588;
add.f32 f1170, f1169, f1164;
sub.f32 f1171, f1164, f1169;
mul.f32 f1172, f1140, 0f3F4F1BBD;
sub.f32 f1173, f877, f1172;
fma.rn.f32 f1174, f1142, 0f3E9E377A, f1173;
mul.f32 f1175, f1165, 0f3F167918;
mul.f32 f1176, f1167, 0f3F737871;
sub.f32 f1177, f1176, f1175;
add.f32 f1178, f1177, f1174;
sub.f32 f1179, f1174, f1177;
mul.f32 f1181, f1038, 0fBE7EA890;
mul.f32 f2587, f1020, 0f3F77F511;
sub.f32 f1182, f2587, f1181;
mul.f32 f1183, f1038, 0f3F77F511;
fma.rn.f32 f1184, f1020, 0fBE7EA890, f1183;
mul.f32 f1186, f1082, 0fBEF6A86B;
mul.f32 f2586, f1064, 0f3F6055A2;
sub.f32 f1187, f2586, f1186;
mul.f32 f1188, f1082, 0f3F6055A2;
fma.rn.f32 f1189, f1064, 0fBEF6A86B, f1188;
mul.f32 f1191, f1126, 0fBF2F3E7B;
mul.f32 f2585, f1108, 0f3F3A9DB0;
sub.f32 f1192, f2585, f1191;
mul.f32 f1193, f1126, 0f3F3A9DB0;
fma.rn.f32 f1194, f1108, 0fBF2F3E7B, f1193;
mul.f32 f1196, f1170, 0fBF5825E0;
mul.f32 f2584, f1152, 0f3F092BF2;
sub.f32 f1197, f2584, f1196;
mul.f32 f1198, f1170, 0f3F092BF2;
fma.rn.f32 f1199, f1152, 0fBF5825E0, f1198;
mul.f32 f1201, f1046, 0fBEF6A86B;
mul.f32 f2583, f1028, 0f3F6055A2;
sub.f32 f1202, f2583, f1201;
mul.f32 f1203, f1046, 0f3F6055A2;
fma.rn.f32 f1204, f1028, 0fBEF6A86B, f1203;
mul.f32 f2581, f1072, 0f3F092BF2;
mul.f32 f2582, f1090, 0fBF5825E0;
sub.f32 f1207, f2581, f2582;
mul.f32 f1208, f1090, 0f3F092BF2;
fma.rn.f32 f1209, f1072, 0fBF5825E0, f1208;
mul.f32 f2579, f1116, 0f3D809851;
mul.f32 f2580, f1134, 0fBF7F7EAE;
sub.f32 f1212, f2579, f2580;
mul.f32 f1213, f1134, 0f3D809851;
fma.rn.f32 f1214, f1116, 0fBF7F7EAE, f1213;
mul.f32 f2577, f1160, 0fBED9FFBE;
mul.f32 f2578, f1178, 0fBF67A2BF;
sub.f32 f1217, f2577, f2578;
mul.f32 f1218, f1178, 0fBED9FFBE;
fma.rn.f32 f1219, f1160, 0fBF67A2BF, f1218;
mul.f32 f1221, f1047, 0fBF2F3E7B;
mul.f32 f2576, f1029, 0f3F3A9DB0;
sub.f32 f1222, f2576, f1221;
mul.f32 f1223, f1047, 0f3F3A9DB0;
fma.rn.f32 f1224, f1029, 0fBF2F3E7B, f1223;
mul.f32 f1226, f1091, 0fBF7F7EAE;
mul.f32 f2575, f1073, 0f3D809851;
sub.f32 f1227, f2575, f1226;
mul.f32 f1228, f1091, 0f3D809851;
fma.rn.f32 f1229, f1073, 0fBF7F7EAE, f1228;
mul.f32 f1231, f1135, 0fBF45405B;
mul.f32 f2574, f1117, 0fBF232E38;
sub.f32 f1232, f2574, f1231;
mul.f32 f1233, f1135, 0fBF232E38;
fma.rn.f32 f1234, f1117, 0fBF45405B, f1233;
mul.f32 f1236, f1179, 0fBE00575B;
mul.f32 f2573, f1161, 0fBF7DFB3B;
sub.f32 f1237, f2573, f1236;
mul.f32 f1238, f1179, 0fBF7DFB3B;
fma.rn.f32 f1239, f1161, 0fBE00575B, f1238;
mul.f32 f1241, f1039, 0fBF5825E0;
mul.f32 f2572, f1021, 0f3F092BF2;
sub.f32 f1242, f2572, f1241;
mul.f32 f1243, f1039, 0f3F092BF2;
fma.rn.f32 f1244, f1021, 0fBF5825E0, f1243;
mul.f32 f1246, f1083, 0fBF67A2BF;
mul.f32 f2571, f1065, 0fBED9FFBE;
sub.f32 f1247, f2571, f1246;
mul.f32 f1248, f1083, 0fBED9FFBE;
fma.rn.f32 f1249, f1065, 0fBF67A2BF, f1248;
mul.f32 f2569, f1109, 0fBF7DFB3B;
mul.f32 f2570, f1127, 0fBE00575B;
sub.f32 f1252, f2569, f2570;
mul.f32 f1253, f1127, 0fBF7DFB3B;
fma.rn.f32 f1254, f1109, 0fBE00575B, f1253;
mul.f32 f2567, f1153, 0fBF232E38;
mul.f32 f2568, f1171, 0f3F45405B;
sub.f32 f1257, f2567, f2568;
mul.f32 f1258, f1171, 0fBF232E38;
fma.rn.f32 f1259, f1153, 0f3F45405B, f1258;
add.f32 f1260, f1007, f1139;
add.f32 f1262, f1051, f1095;
mul.f32 f1267, f1262, 0f3F4F1BBD;
fma.rn.f32 f2566, f1260, 0f3E9E377A, f963;
sub.f32 f1268, f2566, f1267;
add.f32 f2565, f1011, f1143;
sub.f32 f1269, f1011, f1143;
add.f32 f2564, f1055, f1099;
sub.f32 f1271, f1055, f1099;
mul.f32 f1272, f1271, 0fBF167918;
mul.f32 f2563, f1269, 0f3F737871;
sub.f32 f1273, f1272, f2563;
sub.f32 f1274, f1268, f1273;
add.f32 f1275, f1273, f1268;
add.f32 f2562, f963, f1260;
mul.f32 f1276, f1260, 0f3F4F1BBD;
sub.f32 f1277, f963, f1276;
fma.rn.f32 f1278, f1262, 0f3E9E377A, f1277;
mul.f32 f1279, f1269, 0f3F167918;
mul.f32 f1280, f1271, 0f3F737871;
sub.f32 f1281, f1280, f1279;
sub.f32 f1282, f1278, f1281;
add.f32 f1283, f1281, f1278;
mul.f32 f1285, f2564, 0f3F4F1BBD;
fma.rn.f32 f2561, f2565, 0f3E9E377A, f967;
sub.f32 f1286, f2561, f1285;
sub.f32 f1287, f1007, f1139;
sub.f32 f1289, f1051, f1095;
mul.f32 f2559, f1287, 0f3F737871;
mul.f32 f2560, f1289, 0fBF167918;
sub.f32 f1291, f2560, f2559;
add.f32 f1292, f1291, f1286;
sub.f32 f1293, f1286, f1291;
add.f32 f2558, f967, f2565;
mul.f32 f1294, f2565, 0f3F4F1BBD;
sub.f32 f1295, f967, f1294;
fma.rn.f32 f1296, f2564, 0f3E9E377A, f1295;
mul.f32 f1297, f1287, 0f3F167918;
mul.f32 f1298, f1289, 0f3F737871;
sub.f32 f1299, f1298, f1297;
add.f32 f1300, f1299, f1296;
sub.f32 f1301, f1296, f1299;
add.f32 f1302, f1182, f1197;
add.f32 f1304, f1187, f1192;
add.f32 f2557, f976, f1302;
add.f32 f1305, f1304, f2557;
add.f32 f1306, f1184, f1199;
add.f32 f1308, f1189, f1194;
add.f32 f2556, f994, f1306;
add.f32 f1309, f1308, f2556;
fma.rn.f32 f2554, f1302, 0f3E9E377A, f976;
mul.f32 f2555, f1304, 0f3F4F1BBD;
sub.f32 f1312, f2554, f2555;
sub.f32 f1313, f1184, f1199;
sub.f32 f1315, f1189, f1194;
mul.f32 f2552, f1313, 0f3F737871;
mul.f32 f2553, f1315, 0fBF167918;
sub.f32 f1317, f2553, f2552;
sub.f32 f1318, f1312, f1317;
add.f32 f1319, f1317, f1312;
mul.f32 f1320, f1302, 0f3F4F1BBD;
sub.f32 f1321, f976, f1320;
fma.rn.f32 f1322, f1304, 0f3E9E377A, f1321;
mul.f32 f1323, f1313, 0f3F167918;
mul.f32 f1324, f1315, 0f3F737871;
sub.f32 f1325, f1324, f1323;
sub.f32 f1326, f1322, f1325;
add.f32 f1327, f1325, f1322;
mul.f32 f1329, f1308, 0f3F4F1BBD;
fma.rn.f32 f2551, f1306, 0f3E9E377A, f994;
sub.f32 f1330, f2551, f1329;
sub.f32 f1331, f1182, f1197;
sub.f32 f1333, f1187, f1192;
mul.f32 f2549, f1331, 0f3F737871;
mul.f32 f2550, f1333, 0fBF167918;
sub.f32 f1335, f2550, f2549;
add.f32 f1336, f1335, f1330;
sub.f32 f1337, f1330, f1335;
mul.f32 f1338, f1306, 0f3F4F1BBD;
sub.f32 f1339, f994, f1338;
fma.rn.f32 f1340, f1308, 0f3E9E377A, f1339;
mul.f32 f1341, f1331, 0f3F167918;
mul.f32 f1342, f1333, 0f3F737871;
sub.f32 f1343, f1342, f1341;
add.f32 f1344, f1343, f1340;
sub.f32 f1345, f1340, f1343;
add.f32 f1346, f1202, f1217;
add.f32 f1348, f1207, f1212;
add.f32 f2548, f984, f1346;
add.f32 f1349, f1348, f2548;
add.f32 f1350, f1204, f1219;
add.f32 f1352, f1209, f1214;
add.f32 f2547, f1002, f1350;
add.f32 f1353, f1352, f2547;
mul.f32 f1355, f1348, 0f3F4F1BBD;
fma.rn.f32 f2546, f1346, 0f3E9E377A, f984;
sub.f32 f1356, f2546, f1355;
sub.f32 f1357, f1204, f1219;
sub.f32 f1359, f1209, f1214;
mul.f32 f2544, f1357, 0f3F737871;
mul.f32 f2545, f1359, 0fBF167918;
sub.f32 f1361, f2545, f2544;
sub.f32 f1362, f1356, f1361;
add.f32 f1363, f1361, f1356;
mul.f32 f1364, f1346, 0f3F4F1BBD;
sub.f32 f1365, f984, f1364;
fma.rn.f32 f1366, f1348, 0f3E9E377A, f1365;
mul.f32 f1367, f1357, 0f3F167918;
mul.f32 f1368, f1359, 0f3F737871;
sub.f32 f1369, f1368, f1367;
sub.f32 f1370, f1366, f1369;
add.f32 f1371, f1369, f1366;
mul.f32 f1373, f1352, 0f3F4F1BBD;
fma.rn.f32 f2543, f1350, 0f3E9E377A, f1002;
sub.f32 f1374, f2543, f1373;
sub.f32 f1375, f1202, f1217;
sub.f32 f1377, f1207, f1212;
mul.f32 f2541, f1375, 0f3F737871;
mul.f32 f2542, f1377, 0fBF167918;
sub.f32 f1379, f2542, f2541;
add.f32 f1380, f1379, f1374;
sub.f32 f1381, f1374, f1379;
mul.f32 f1382, f1350, 0f3F4F1BBD;
sub.f32 f1383, f1002, f1382;
fma.rn.f32 f1384, f1352, 0f3E9E377A, f1383;
mul.f32 f1385, f1375, 0f3F167918;
mul.f32 f1386, f1377, 0f3F737871;
sub.f32 f1387, f1386, f1385;
add.f32 f1388, f1387, f1384;
sub.f32 f1389, f1384, f1387;
add.f32 f1390, f1222, f1237;
add.f32 f1392, f1227, f1232;
add.f32 f2540, f985, f1390;
add.f32 f1393, f1392, f2540;
add.f32 f1394, f1224, f1239;
add.f32 f1396, f1229, f1234;
add.f32 f2539, f1003, f1394;
add.f32 f1397, f1396, f2539;
mul.f32 f1399, f1392, 0f3F4F1BBD;
fma.rn.f32 f2538, f1390, 0f3E9E377A, f985;
sub.f32 f1400, f2538, f1399;
sub.f32 f1401, f1224, f1239;
sub.f32 f1403, f1229, f1234;
mul.f32 f2536, f1401, 0f3F737871;
mul.f32 f2537, f1403, 0fBF167918;
sub.f32 f1405, f2537, f2536;
sub.f32 f1406, f1400, f1405;
add.f32 f1407, f1405, f1400;
mul.f32 f1408, f1390, 0f3F4F1BBD;
sub.f32 f1409, f985, f1408;
fma.rn.f32 f1410, f1392, 0f3E9E377A, f1409;
mul.f32 f1411, f1401, 0f3F167918;
mul.f32 f1412, f1403, 0f3F737871;
sub.f32 f1413, f1412, f1411;
sub.f32 f1414, f1410, f1413;
add.f32 f1415, f1413, f1410;
fma.rn.f32 f2534, f1394, 0f3E9E377A, f1003;
mul.f32 f2535, f1396, 0f3F4F1BBD;
sub.f32 f1418, f2534, f2535;
sub.f32 f1419, f1222, f1237;
sub.f32 f1421, f1227, f1232;
mul.f32 f2532, f1419, 0f3F737871;
mul.f32 f2533, f1421, 0fBF167918;
sub.f32 f1423, f2533, f2532;
add.f32 f1424, f1423, f1418;
sub.f32 f1425, f1418, f1423;
mul.f32 f1426, f1394, 0f3F4F1BBD;
sub.f32 f1427, f1003, f1426;
fma.rn.f32 f1428, f1396, 0f3E9E377A, f1427;
mul.f32 f1429, f1419, 0f3F167918;
mul.f32 f1430, f1421, 0f3F737871;
sub.f32 f1431, f1430, f1429;
add.f32 f1432, f1431, f1428;
sub.f32 f1433, f1428, f1431;
add.f32 f1434, f1242, f1257;
add.f32 f1436, f1247, f1252;
add.f32 f2531, f977, f1434;
add.f32 f1437, f1436, f2531;
add.f32 f1438, f1244, f1259;
add.f32 f1440, f1249, f1254;
add.f32 f2530, f995, f1438;
add.f32 f1441, f1440, f2530;
fma.rn.f32 f2528, f1434, 0f3E9E377A, f977;
mul.f32 f2529, f1436, 0f3F4F1BBD;
sub.f32 f1444, f2528, f2529;
sub.f32 f1445, f1244, f1259;
sub.f32 f1447, f1249, f1254;
mul.f32 f2526, f1445, 0f3F737871;
mul.f32 f2527, f1447, 0fBF167918;
sub.f32 f1449, f2527, f2526;
sub.f32 f1450, f1444, f1449;
add.f32 f1451, f1449, f1444;
mul.f32 f1452, f1434, 0f3F4F1BBD;
sub.f32 f1453, f977, f1452;
fma.rn.f32 f1454, f1436, 0f3E9E377A, f1453;
mul.f32 f1455, f1445, 0f3F167918;
mul.f32 f1456, f1447, 0f3F737871;
sub.f32 f1457, f1456, f1455;
sub.f32 f1458, f1454, f1457;
add.f32 f1459, f1457, f1454;
mul.f32 f1461, f1440, 0f3F4F1BBD;
fma.rn.f32 f2525, f1438, 0f3E9E377A, f995;
sub.f32 f1462, f2525, f1461;
sub.f32 f1463, f1242, f1257;
sub.f32 f1465, f1247, f1252;
mul.f32 f2523, f1463, 0f3F737871;
mul.f32 f2524, f1465, 0fBF167918;
sub.f32 f1467, f2524, f2523;
add.f32 f1468, f1467, f1462;
sub.f32 f1469, f1462, f1467;
mul.f32 f1470, f1438, 0f3F4F1BBD;
sub.f32 f1471, f995, f1470;
fma.rn.f32 f1472, f1440, 0f3E9E377A, f1471;
mul.f32 f1473, f1463, 0f3F167918;
mul.f32 f1474, f1465, 0f3F737871;
sub.f32 f1475, f1474, f1473;
add.f32 f1476, f1475, f1472;
sub.f32 f1477, f1472, f1475;
mul.wide.u32 rd7, r7, 1374389535;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 25;
sub.s32 r13, r7, r12;
mul.wide.u32 rd12, r11, 8;
mov.u64 rd13, %52;
add.s64 rd11, rd13, rd12;
ld.global.v2.f32 {f1478, f1479}, [rd11];
mul.f32 f1483, f1479, f1309;
mul.f32 f1484, f1478, f1309;
mul.f32 f1486, f1479, f1479;
mul.f32 f2522, f1478, f1478;
sub.f32 f1487, f2522, f1486;
mul.f32 f1488, f1479, f1478;
fma.rn.f32 f1489, f1479, f1478, f1488;
mul.f32 f1491, f1489, f1353;
mul.f32 f1492, f1487, f1353;
mul.f32 f1494, f1479, f1489;
mul.f32 f2521, f1478, f1487;
sub.f32 f1495, f2521, f1494;
mul.f32 f2520, f1487, f1349;
mul.f32 f1496, f1478, f1489;
fma.rn.f32 f1497, f1479, f1487, f1496;
mul.f32 f1499, f1497, f1397;
mul.f32 f1500, f1495, f1397;
mul.f32 f2518, f1478, f1495;
mul.f32 f2519, f1479, f1497;
sub.f32 f1503, f2518, f2519;
mul.f32 f2517, f1495, f1393;
mul.f32 f1504, f1478, f1497;
fma.rn.f32 f1505, f1479, f1495, f1504;
mul.f32 f1507, f1505, f1441;
mul.f32 f1508, f1503, f1441;
mul.f32 f1510, f1479, f1505;
mul.f32 f2516, f1478, f1503;
sub.f32 f1511, f2516, f1510;
mul.f32 f2515, f1503, f1437;
mul.f32 f1512, f1478, f1505;
fma.rn.f32 f1513, f1479, f1503, f1512;
mul.f32 f1515, f1513, f1292;
mul.f32 f1516, f1511, f1292;
mul.f32 f2513, f1478, f1511;
mul.f32 f2514, f1479, f1513;
sub.f32 f1519, f2513, f2514;
mul.f32 f2512, f1511, f1274;
mul.f32 f1520, f1478, f1513;
fma.rn.f32 f1521, f1479, f1511, f1520;
mul.f32 f1523, f1521, f1336;
mul.f32 f1524, f1519, f1336;
mul.f32 f1526, f1479, f1521;
mul.f32 f2511, f1478, f1519;
sub.f32 f1527, f2511, f1526;
mul.f32 f2510, f1519, f1318;
mul.f32 f1528, f1478, f1521;
fma.rn.f32 f1529, f1479, f1519, f1528;
mul.f32 f1531, f1529, f1380;
mul.f32 f1532, f1527, f1380;
mul.f32 f1534, f1479, f1529;
mul.f32 f2509, f1478, f1527;
sub.f32 f1535, f2509, f1534;
mul.f32 f2508, f1527, f1362;
mul.f32 f1536, f1478, f1529;
fma.rn.f32 f1537, f1479, f1527, f1536;
mul.f32 f1539, f1537, f1424;
mul.f32 f1540, f1535, f1424;
mul.f32 f2506, f1478, f1535;
mul.f32 f2507, f1479, f1537;
sub.f32 f1543, f2506, f2507;
mul.f32 f2505, f1535, f1406;
mul.f32 f1544, f1478, f1537;
fma.rn.f32 f1545, f1479, f1535, f1544;
mul.f32 f1547, f1545, f1468;
mul.f32 f1548, f1543, f1468;
mul.f32 f1550, f1479, f1545;
mul.f32 f2504, f1478, f1543;
sub.f32 f1551, f2504, f1550;
mul.f32 f2503, f1543, f1450;
mul.f32 f1552, f1478, f1545;
fma.rn.f32 f1553, f1479, f1543, f1552;
mul.f32 f1555, f1553, f1300;
mul.f32 f1556, f1551, f1300;
mul.f32 f1558, f1479, f1553;
mul.f32 f2502, f1478, f1551;
sub.f32 f1559, f2502, f1558;
mul.f32 f2501, f1551, f1282;
mul.f32 f1560, f1478, f1553;
fma.rn.f32 f1561, f1479, f1551, f1560;
mul.f32 f1563, f1561, f1344;
mul.f32 f1564, f1559, f1344;
mul.f32 f2499, f1478, f1559;
mul.f32 f2500, f1479, f1561;
sub.f32 f1567, f2499, f2500;
mul.f32 f2498, f1559, f1326;
mul.f32 f1568, f1478, f1561;
fma.rn.f32 f1569, f1479, f1559, f1568;
mul.f32 f1571, f1569, f1388;
mul.f32 f1572, f1567, f1388;
mul.f32 f1574, f1479, f1569;
mul.f32 f2497, f1478, f1567;
sub.f32 f1575, f2497, f1574;
mul.f32 f2496, f1567, f1370;
mul.f32 f1576, f1478, f1569;
fma.rn.f32 f1577, f1479, f1567, f1576;
mul.f32 f1579, f1577, f1432;
mul.f32 f1580, f1575, f1432;
mul.f32 f2494, f1478, f1575;
mul.f32 f2495, f1479, f1577;
sub.f32 f1583, f2494, f2495;
mul.f32 f2493, f1575, f1414;
mul.f32 f1584, f1478, f1577;
fma.rn.f32 f1585, f1479, f1575, f1584;
mul.f32 f1587, f1585, f1476;
mul.f32 f1588, f1583, f1476;
mul.f32 f1590, f1479, f1585;
mul.f32 f2492, f1478, f1583;
sub.f32 f1591, f2492, f1590;
mul.f32 f2491, f1583, f1458;
mul.f32 f1592, f1478, f1585;
fma.rn.f32 f1593, f1479, f1583, f1592;
mul.f32 f1595, f1593, f1301;
mul.f32 f1596, f1591, f1301;
mul.f32 f1598, f1479, f1593;
mul.f32 f2490, f1478, f1591;
sub.f32 f1599, f2490, f1598;
mul.f32 f2489, f1591, f1283;
mul.f32 f1600, f1478, f1593;
fma.rn.f32 f1601, f1479, f1591, f1600;
mul.f32 f1603, f1601, f1345;
mul.f32 f1604, f1599, f1345;
mul.f32 f2487, f1478, f1599;
mul.f32 f2488, f1479, f1601;
sub.f32 f1607, f2487, f2488;
mul.f32 f2486, f1599, f1327;
mul.f32 f1608, f1478, f1601;
fma.rn.f32 f1609, f1479, f1599, f1608;
mul.f32 f1611, f1609, f1389;
mul.f32 f1612, f1607, f1389;
mul.f32 f1614, f1479, f1609;
mul.f32 f2485, f1478, f1607;
sub.f32 f1615, f2485, f1614;
mul.f32 f2484, f1607, f1371;
mul.f32 f1616, f1478, f1609;
fma.rn.f32 f1617, f1479, f1607, f1616;
mul.f32 f1619, f1617, f1433;
mul.f32 f1620, f1615, f1433;
mul.f32 f1622, f1479, f1617;
mul.f32 f2483, f1478, f1615;
sub.f32 f1623, f2483, f1622;
mul.f32 f2482, f1615, f1415;
mul.f32 f1624, f1478, f1617;
fma.rn.f32 f1625, f1479, f1615, f1624;
mul.f32 f1627, f1625, f1477;
mul.f32 f1628, f1623, f1477;
mul.f32 f2480, f1478, f1623;
mul.f32 f2481, f1479, f1625;
sub.f32 f1631, f2480, f2481;
mul.f32 f2479, f1623, f1459;
mul.f32 f1632, f1478, f1625;
fma.rn.f32 f1633, f1479, f1623, f1632;
mul.f32 f1635, f1633, f1293;
mul.f32 f1636, f1631, f1293;
mul.f32 f1638, f1479, f1633;
mul.f32 f2478, f1478, f1631;
sub.f32 f1639, f2478, f1638;
mul.f32 f2477, f1631, f1275;
mul.f32 f1640, f1478, f1633;
fma.rn.f32 f1641, f1479, f1631, f1640;
mul.f32 f1643, f1641, f1337;
mul.f32 f1644, f1639, f1337;
mul.f32 f2475, f1478, f1639;
mul.f32 f2476, f1479, f1641;
sub.f32 f1647, f2475, f2476;
mul.f32 f2474, f1639, f1319;
mul.f32 f1648, f1478, f1641;
fma.rn.f32 f1649, f1479, f1639, f1648;
mul.f32 f1651, f1649, f1381;
mul.f32 f1652, f1647, f1381;
mul.f32 f1654, f1479, f1649;
mul.f32 f2473, f1478, f1647;
sub.f32 f1655, f2473, f1654;
mul.f32 f2472, f1647, f1363;
mul.f32 f1656, f1478, f1649;
fma.rn.f32 f1657, f1479, f1647, f1656;
mul.f32 f1659, f1657, f1425;
mul.f32 f1660, f1655, f1425;
mul.f32 f1662, f1479, f1657;
mul.f32 f2471, f1478, f1655;
sub.f32 f1663, f2471, f1662;
mul.f32 f2470, f1478, f1305;
mul.f32 f1664, f1478, f1657;
mul.f32 f2469, f1655, f1407;
fma.rn.f32 f1665, f1479, f1655, f1664;
mul.f32 f1666, f1663, f1451;
mul.f32 f1667, f1665, f1469;
mul.f32 f1668, f1663, f1469;
shl.b32 r14, r13, 3;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 5000, r15;
add.f32 f1669, f2564, f2558;
add.f32 f1670, f1262, f2562;
st.shared.v2.f32 [r16], {f1670, f1669};
fma.rn.f32 f1671, f1479, f1305, f1484;
sub.f32 f1672, f2470, f1483;
st.shared.v2.f32 [r16+200], {f1672, f1671};
fma.rn.f32 f1673, f1489, f1349, f1492;
sub.f32 f1674, f2520, f1491;
st.shared.v2.f32 [r16+400], {f1674, f1673};
fma.rn.f32 f1675, f1497, f1393, f1500;
sub.f32 f1676, f2517, f1499;
st.shared.v2.f32 [r16+600], {f1676, f1675};
fma.rn.f32 f1677, f1505, f1437, f1508;
sub.f32 f1678, f2515, f1507;
st.shared.v2.f32 [r16+800], {f1678, f1677};
fma.rn.f32 f1679, f1513, f1274, f1516;
sub.f32 f1680, f2512, f1515;
st.shared.v2.f32 [r16+1000], {f1680, f1679};
fma.rn.f32 f1681, f1521, f1318, f1524;
sub.f32 f1682, f2510, f1523;
st.shared.v2.f32 [r16+1200], {f1682, f1681};
fma.rn.f32 f1683, f1529, f1362, f1532;
sub.f32 f1684, f2508, f1531;
st.shared.v2.f32 [r16+1400], {f1684, f1683};
fma.rn.f32 f1685, f1537, f1406, f1540;
sub.f32 f1686, f2505, f1539;
st.shared.v2.f32 [r16+1600], {f1686, f1685};
sub.f32 f1687, f2503, f1547;
fma.rn.f32 f1688, f1545, f1450, f1548;
st.shared.v2.f32 [r16+1800], {f1687, f1688};
fma.rn.f32 f1689, f1553, f1282, f1556;
sub.f32 f1690, f2501, f1555;
st.shared.v2.f32 [r16+2000], {f1690, f1689};
fma.rn.f32 f1691, f1561, f1326, f1564;
sub.f32 f1692, f2498, f1563;
st.shared.v2.f32 [r16+2200], {f1692, f1691};
fma.rn.f32 f1693, f1569, f1370, f1572;
sub.f32 f1694, f2496, f1571;
st.shared.v2.f32 [r16+2400], {f1694, f1693};
fma.rn.f32 f1695, f1577, f1414, f1580;
sub.f32 f1696, f2493, f1579;
st.shared.v2.f32 [r16+2600], {f1696, f1695};
fma.rn.f32 f1697, f1585, f1458, f1588;
sub.f32 f1698, f2491, f1587;
st.shared.v2.f32 [r16+2800], {f1698, f1697};
fma.rn.f32 f1699, f1593, f1283, f1596;
sub.f32 f1700, f2489, f1595;
st.shared.v2.f32 [r16+3000], {f1700, f1699};
fma.rn.f32 f1701, f1601, f1327, f1604;
sub.f32 f1702, f2486, f1603;
st.shared.v2.f32 [r16+3200], {f1702, f1701};
fma.rn.f32 f1703, f1609, f1371, f1612;
sub.f32 f1704, f2484, f1611;
st.shared.v2.f32 [r16+3400], {f1704, f1703};
fma.rn.f32 f1705, f1617, f1415, f1620;
sub.f32 f1706, f2482, f1619;
st.shared.v2.f32 [r16+3600], {f1706, f1705};
fma.rn.f32 f1707, f1625, f1459, f1628;
sub.f32 f1708, f2479, f1627;
st.shared.v2.f32 [r16+3800], {f1708, f1707};
fma.rn.f32 f1709, f1633, f1275, f1636;
sub.f32 f1710, f2477, f1635;
st.shared.v2.f32 [r16+4000], {f1710, f1709};
fma.rn.f32 f1711, f1641, f1319, f1644;
sub.f32 f1712, f2474, f1643;
st.shared.v2.f32 [r16+4200], {f1712, f1711};
fma.rn.f32 f1713, f1649, f1363, f1652;
sub.f32 f1714, f2472, f1651;
st.shared.v2.f32 [r16+4400], {f1714, f1713};
fma.rn.f32 f1715, f1657, f1407, f1660;
sub.f32 f1716, f2469, f1659;
st.shared.v2.f32 [r16+4600], {f1716, f1715};
fma.rn.f32 f1717, f1665, f1451, f1668;
sub.f32 f1718, f1666, f1667;
st.shared.v2.f32 [r16+4800], {f1718, f1717};
barrier.sync 0;
ld.shared.v2.f32 {f1719, f1720}, [r10];
ld.shared.v2.f32 {f1723, f1724}, [r10+5000];
ld.shared.v2.f32 {f1727, f1728}, [r10+10000];
ld.shared.v2.f32 {f1731, f1732}, [r10+15000];
ld.shared.v2.f32 {f1735, f1736}, [r10+20000];
ld.shared.v2.f32 {f1739, f1740}, [r10+25000];
ld.shared.v2.f32 {f1743, f1744}, [r10+30000];
ld.shared.v2.f32 {f1747, f1748}, [r10+35000];
ld.shared.v2.f32 {f1751, f1752}, [r10+40000];
ld.shared.v2.f32 {f1755, f1756}, [r10+45000];
ld.shared.v2.f32 {f1759, f1760}, [r10+50000];
ld.shared.v2.f32 {f1763, f1764}, [r10+55000];
ld.shared.v2.f32 {f1767, f1768}, [r10+60000];
ld.shared.v2.f32 {f1771, f1772}, [r10+65000];
ld.shared.v2.f32 {f1775, f1776}, [r10+70000];
ld.shared.v2.f32 {f1779, f1780}, [r10+75000];
ld.shared.v2.f32 {f1783, f1784}, [r10+80000];
ld.shared.v2.f32 {f1787, f1788}, [r10+85000];
ld.shared.v2.f32 {f1791, f1792}, [r10+90000];
ld.shared.v2.f32 {f1795, f1796}, [r10+95000];
ld.shared.v2.f32 {f1799, f1800}, [r10+100000];
ld.shared.v2.f32 {f1803, f1804}, [r10+105000];
ld.shared.v2.f32 {f1807, f1808}, [r10+110000];
ld.shared.v2.f32 {f1811, f1812}, [r10+115000];
ld.shared.v2.f32 {f1815, f1816}, [r10+120000];
add.f32 f1819, f1739, f1799;
add.f32 f1821, f1759, f1779;
add.f32 f2468, f1719, f1819;
add.f32 f1822, f1821, f2468;
add.f32 f1823, f1740, f1800;
add.f32 f1825, f1760, f1780;
add.f32 f2467, f1720, f1823;
add.f32 f1826, f1825, f2467;
fma.rn.f32 f2465, f1819, 0f3E9E377A, f1719;
mul.f32 f2466, f1821, 0f3F4F1BBD;
sub.f32 f1829, f2465, f2466;
sub.f32 f1830, f1740, f1800;
sub.f32 f1832, f1760, f1780;
mul.f32 f2463, f1830, 0f3F737871;
mul.f32 f2464, f1832, 0fBF167918;
sub.f32 f1834, f2464, f2463;
sub.f32 f1835, f1829, f1834;
add.f32 f1836, f1834, f1829;
mul.f32 f1837, f1819, 0f3F4F1BBD;
sub.f32 f1838, f1719, f1837;
fma.rn.f32 f1839, f1821, 0f3E9E377A, f1838;
mul.f32 f1840, f1830, 0f3F167918;
mul.f32 f1841, f1832, 0f3F737871;
sub.f32 f1842, f1841, f1840;
sub.f32 f1843, f1839, f1842;
add.f32 f1844, f1842, f1839;
mul.f32 f1846, f1825, 0f3F4F1BBD;
fma.rn.f32 f2462, f1823, 0f3E9E377A, f1720;
sub.f32 f1847, f2462, f1846;
sub.f32 f1848, f1739, f1799;
sub.f32 f1850, f1759, f1779;
mul.f32 f1851, f1850, 0fBF167918;
mul.f32 f2461, f1848, 0f3F737871;
sub.f32 f1852, f1851, f2461;
add.f32 f1853, f1852, f1847;
sub.f32 f1854, f1847, f1852;
mul.f32 f1855, f1823, 0f3F4F1BBD;
sub.f32 f1856, f1720, f1855;
fma.rn.f32 f1857, f1825, 0f3E9E377A, f1856;
mul.f32 f1858, f1848, 0f3F167918;
mul.f32 f1859, f1850, 0f3F737871;
sub.f32 f1860, f1859, f1858;
add.f32 f1861, f1860, f1857;
sub.f32 f1862, f1857, f1860;
add.f32 f1863, f1743, f1803;
add.f32 f1865, f1763, f1783;
add.f32 f2460, f1723, f1863;
add.f32 f1866, f1865, f2460;
add.f32 f1867, f1744, f1804;
add.f32 f1869, f1764, f1784;
add.f32 f2459, f1724, f1867;
add.f32 f1870, f1869, f2459;
mul.f32 f1872, f1865, 0f3F4F1BBD;
fma.rn.f32 f2458, f1863, 0f3E9E377A, f1723;
sub.f32 f1873, f2458, f1872;
sub.f32 f1874, f1744, f1804;
sub.f32 f1876, f1764, f1784;
mul.f32 f2456, f1874, 0f3F737871;
mul.f32 f2457, f1876, 0fBF167918;
sub.f32 f1878, f2457, f2456;
sub.f32 f1879, f1873, f1878;
add.f32 f1880, f1878, f1873;
mul.f32 f1881, f1863, 0f3F4F1BBD;
sub.f32 f1882, f1723, f1881;
fma.rn.f32 f1883, f1865, 0f3E9E377A, f1882;
mul.f32 f1884, f1874, 0f3F167918;
mul.f32 f1885, f1876, 0f3F737871;
sub.f32 f1886, f1885, f1884;
sub.f32 f1887, f1883, f1886;
add.f32 f1888, f1886, f1883;
fma.rn.f32 f2454, f1867, 0f3E9E377A, f1724;
mul.f32 f2455, f1869, 0f3F4F1BBD;
sub.f32 f1891, f2454, f2455;
sub.f32 f1892, f1743, f1803;
sub.f32 f1894, f1763, f1783;
mul.f32 f2452, f1892, 0f3F737871;
mul.f32 f2453, f1894, 0fBF167918;
sub.f32 f1896, f2453, f2452;
add.f32 f1897, f1896, f1891;
sub.f32 f1898, f1891, f1896;
mul.f32 f1899, f1867, 0f3F4F1BBD;
sub.f32 f1900, f1724, f1899;
fma.rn.f32 f1901, f1869, 0f3E9E377A, f1900;
mul.f32 f1902, f1892, 0f3F167918;
mul.f32 f1903, f1894, 0f3F737871;
sub.f32 f1904, f1903, f1902;
add.f32 f1905, f1904, f1901;
sub.f32 f1906, f1901, f1904;
add.f32 f1907, f1747, f1807;
add.f32 f1909, f1767, f1787;
add.f32 f2451, f1727, f1907;
add.f32 f1910, f1909, f2451;
add.f32 f1911, f1748, f1808;
add.f32 f1913, f1768, f1788;
add.f32 f2450, f1728, f1911;
add.f32 f1914, f1913, f2450;
fma.rn.f32 f2448, f1907, 0f3E9E377A, f1727;
mul.f32 f2449, f1909, 0f3F4F1BBD;
sub.f32 f1917, f2448, f2449;
sub.f32 f1918, f1748, f1808;
sub.f32 f1920, f1768, f1788;
mul.f32 f2446, f1918, 0f3F737871;
mul.f32 f2447, f1920, 0fBF167918;
sub.f32 f1922, f2447, f2446;
sub.f32 f1923, f1917, f1922;
add.f32 f1924, f1922, f1917;
mul.f32 f1925, f1907, 0f3F4F1BBD;
sub.f32 f1926, f1727, f1925;
fma.rn.f32 f1927, f1909, 0f3E9E377A, f1926;
mul.f32 f1928, f1918, 0f3F167918;
mul.f32 f1929, f1920, 0f3F737871;
sub.f32 f1930, f1929, f1928;
sub.f32 f1931, f1927, f1930;
add.f32 f1932, f1930, f1927;
mul.f32 f1934, f1913, 0f3F4F1BBD;
fma.rn.f32 f2445, f1911, 0f3E9E377A, f1728;
sub.f32 f1935, f2445, f1934;
sub.f32 f1936, f1747, f1807;
sub.f32 f1938, f1767, f1787;
mul.f32 f1939, f1938, 0fBF167918;
mul.f32 f2444, f1936, 0f3F737871;
sub.f32 f1940, f1939, f2444;
add.f32 f1941, f1940, f1935;
sub.f32 f1942, f1935, f1940;
mul.f32 f1943, f1911, 0f3F4F1BBD;
sub.f32 f1944, f1728, f1943;
fma.rn.f32 f1945, f1913, 0f3E9E377A, f1944;
mul.f32 f1946, f1936, 0f3F167918;
mul.f32 f1947, f1938, 0f3F737871;
sub.f32 f1948, f1947, f1946;
add.f32 f1949, f1948, f1945;
sub.f32 f1950, f1945, f1948;
add.f32 f1951, f1751, f1811;
add.f32 f1953, f1771, f1791;
add.f32 f2443, f1731, f1951;
add.f32 f1954, f1953, f2443;
add.f32 f1955, f1752, f1812;
add.f32 f1957, f1772, f1792;
add.f32 f2442, f1732, f1955;
add.f32 f1958, f1957, f2442;
mul.f32 f1960, f1953, 0f3F4F1BBD;
fma.rn.f32 f2441, f1951, 0f3E9E377A, f1731;
sub.f32 f1961, f2441, f1960;
sub.f32 f1962, f1752, f1812;
sub.f32 f1964, f1772, f1792;
mul.f32 f1965, f1964, 0fBF167918;
mul.f32 f2440, f1962, 0f3F737871;
sub.f32 f1966, f1965, f2440;
sub.f32 f1967, f1961, f1966;
add.f32 f1968, f1966, f1961;
mul.f32 f1969, f1951, 0f3F4F1BBD;
sub.f32 f1970, f1731, f1969;
fma.rn.f32 f1971, f1953, 0f3E9E377A, f1970;
mul.f32 f1972, f1962, 0f3F167918;
mul.f32 f1973, f1964, 0f3F737871;
sub.f32 f1974, f1973, f1972;
sub.f32 f1975, f1971, f1974;
add.f32 f1976, f1974, f1971;
mul.f32 f1978, f1957, 0f3F4F1BBD;
fma.rn.f32 f2439, f1955, 0f3E9E377A, f1732;
sub.f32 f1979, f2439, f1978;
sub.f32 f1980, f1751, f1811;
sub.f32 f1982, f1771, f1791;
mul.f32 f2437, f1980, 0f3F737871;
mul.f32 f2438, f1982, 0fBF167918;
sub.f32 f1984, f2438, f2437;
add.f32 f1985, f1984, f1979;
sub.f32 f1986, f1979, f1984;
mul.f32 f1987, f1955, 0f3F4F1BBD;
sub.f32 f1988, f1732, f1987;
fma.rn.f32 f1989, f1957, 0f3E9E377A, f1988;
mul.f32 f1990, f1980, 0f3F167918;
mul.f32 f1991, f1982, 0f3F737871;
sub.f32 f1992, f1991, f1990;
add.f32 f1993, f1992, f1989;
sub.f32 f1994, f1989, f1992;
add.f32 f1995, f1755, f1815;
add.f32 f1997, f1775, f1795;
add.f32 f2436, f1735, f1995;
add.f32 f1998, f1997, f2436;
add.f32 f1999, f1756, f1816;
add.f32 f2001, f1776, f1796;
add.f32 f2435, f1736, f1999;
add.f32 f2002, f2001, f2435;
fma.rn.f32 f2433, f1995, 0f3E9E377A, f1735;
mul.f32 f2434, f1997, 0f3F4F1BBD;
sub.f32 f2005, f2433, f2434;
sub.f32 f2006, f1756, f1816;
sub.f32 f2008, f1776, f1796;
mul.f32 f2431, f2006, 0f3F737871;
mul.f32 f2432, f2008, 0fBF167918;
sub.f32 f2010, f2432, f2431;
sub.f32 f2011, f2005, f2010;
add.f32 f2012, f2010, f2005;
mul.f32 f2013, f1995, 0f3F4F1BBD;
sub.f32 f2014, f1735, f2013;
fma.rn.f32 f2015, f1997, 0f3E9E377A, f2014;
mul.f32 f2016, f2006, 0f3F167918;
mul.f32 f2017, f2008, 0f3F737871;
sub.f32 f2018, f2017, f2016;
sub.f32 f2019, f2015, f2018;
add.f32 f2020, f2018, f2015;
mul.f32 f2022, f2001, 0f3F4F1BBD;
fma.rn.f32 f2430, f1999, 0f3E9E377A, f1736;
sub.f32 f2023, f2430, f2022;
sub.f32 f2024, f1755, f1815;
sub.f32 f2026, f1775, f1795;
mul.f32 f2428, f2024, 0f3F737871;
mul.f32 f2429, f2026, 0fBF167918;
sub.f32 f2028, f2429, f2428;
add.f32 f2029, f2028, f2023;
sub.f32 f2030, f2023, f2028;
mul.f32 f2031, f1999, 0f3F4F1BBD;
sub.f32 f2032, f1736, f2031;
fma.rn.f32 f2033, f2001, 0f3E9E377A, f2032;
mul.f32 f2034, f2024, 0f3F167918;
mul.f32 f2035, f2026, 0f3F737871;
sub.f32 f2036, f2035, f2034;
add.f32 f2037, f2036, f2033;
sub.f32 f2038, f2033, f2036;
mul.f32 f2040, f1897, 0fBE7EA890;
mul.f32 f2427, f1879, 0f3F77F511;
sub.f32 f2041, f2427, f2040;
mul.f32 f2042, f1897, 0f3F77F511;
fma.rn.f32 f2043, f1879, 0fBE7EA890, f2042;
mul.f32 f2045, f1941, 0fBEF6A86B;
mul.f32 f2426, f1923, 0f3F6055A2;
sub.f32 f2046, f2426, f2045;
mul.f32 f2047, f1941, 0f3F6055A2;
fma.rn.f32 f2048, f1923, 0fBEF6A86B, f2047;
mul.f32 f2050, f1985, 0fBF2F3E7B;
mul.f32 f2425, f1967, 0f3F3A9DB0;
sub.f32 f2051, f2425, f2050;
mul.f32 f2052, f1985, 0f3F3A9DB0;
fma.rn.f32 f2053, f1967, 0fBF2F3E7B, f2052;
mul.f32 f2055, f2029, 0fBF5825E0;
mul.f32 f2424, f2011, 0f3F092BF2;
sub.f32 f2056, f2424, f2055;
mul.f32 f2057, f2029, 0f3F092BF2;
fma.rn.f32 f2058, f2011, 0fBF5825E0, f2057;
mul.f32 f2422, f1887, 0f3F6055A2;
mul.f32 f2423, f1905, 0fBEF6A86B;
sub.f32 f2061, f2422, f2423;
mul.f32 f2062, f1905, 0f3F6055A2;
fma.rn.f32 f2063, f1887, 0fBEF6A86B, f2062;
mul.f32 f2420, f1931, 0f3F092BF2;
mul.f32 f2421, f1949, 0fBF5825E0;
sub.f32 f2066, f2420, f2421;
mul.f32 f2067, f1949, 0f3F092BF2;
fma.rn.f32 f2068, f1931, 0fBF5825E0, f2067;
mul.f32 f2418, f1975, 0f3D809851;
mul.f32 f2419, f1993, 0fBF7F7EAE;
sub.f32 f2071, f2418, f2419;
mul.f32 f2072, f1993, 0f3D809851;
fma.rn.f32 f2073, f1975, 0fBF7F7EAE, f2072;
mul.f32 f2416, f2019, 0fBED9FFBE;
mul.f32 f2417, f2037, 0fBF67A2BF;
sub.f32 f2076, f2416, f2417;
mul.f32 f2077, f2037, 0fBED9FFBE;
fma.rn.f32 f2078, f2019, 0fBF67A2BF, f2077;
mul.f32 f2080, f1906, 0fBF2F3E7B;
mul.f32 f2415, f1888, 0f3F3A9DB0;
sub.f32 f2081, f2415, f2080;
mul.f32 f2082, f1906, 0f3F3A9DB0;
fma.rn.f32 f2083, f1888, 0fBF2F3E7B, f2082;
mul.f32 f2085, f1950, 0fBF7F7EAE;
mul.f32 f2414, f1932, 0f3D809851;
sub.f32 f2086, f2414, f2085;
mul.f32 f2087, f1950, 0f3D809851;
fma.rn.f32 f2088, f1932, 0fBF7F7EAE, f2087;
mul.f32 f2090, f1994, 0fBF45405B;
mul.f32 f2413, f1976, 0fBF232E38;
sub.f32 f2091, f2413, f2090;
mul.f32 f2092, f1994, 0fBF232E38;
fma.rn.f32 f2093, f1976, 0fBF45405B, f2092;
mul.f32 f2095, f2038, 0fBE00575B;
mul.f32 f2412, f2020, 0fBF7DFB3B;
sub.f32 f2096, f2412, f2095;
mul.f32 f2097, f2038, 0fBF7DFB3B;
fma.rn.f32 f2098, f2020, 0fBE00575B, f2097;
mul.f32 f2100, f1898, 0fBF5825E0;
mul.f32 f2411, f1880, 0f3F092BF2;
sub.f32 f2101, f2411, f2100;
mul.f32 f2102, f1898, 0f3F092BF2;
fma.rn.f32 f2103, f1880, 0fBF5825E0, f2102;
mul.f32 f2409, f1924, 0fBED9FFBE;
mul.f32 f2410, f1942, 0fBF67A2BF;
sub.f32 f2106, f2409, f2410;
mul.f32 f2107, f1942, 0fBED9FFBE;
fma.rn.f32 f2108, f1924, 0fBF67A2BF, f2107;
mul.f32 f2407, f1968, 0fBF7DFB3B;
mul.f32 f2408, f1986, 0fBE00575B;
sub.f32 f2111, f2407, f2408;
mul.f32 f2112, f1986, 0fBF7DFB3B;
fma.rn.f32 f2113, f1968, 0fBE00575B, f2112;
mul.f32 f2405, f2012, 0fBF232E38;
mul.f32 f2406, f2030, 0f3F45405B;
sub.f32 f2116, f2405, f2406;
mul.f32 f2117, f2030, 0fBF232E38;
fma.rn.f32 f2118, f2012, 0f3F45405B, f2117;
add.f32 f2119, f1866, f1998;
add.f32 f2121, f1910, f1954;
mul.f32 f2126, f2121, 0f3F4F1BBD;
fma.rn.f32 f2404, f2119, 0f3E9E377A, f1822;
sub.f32 f2127, f2404, f2126;
add.f32 f2403, f1870, f2002;
sub.f32 f2128, f1870, f2002;
add.f32 f2402, f1914, f1958;
sub.f32 f2130, f1914, f1958;
mul.f32 f2131, f2130, 0fBF167918;
mul.f32 f2401, f2128, 0f3F737871;
sub.f32 f2132, f2131, f2401;
add.f32 f2400, f1822, f2119;
mul.f32 f2133, f2119, 0f3F4F1BBD;
sub.f32 f2134, f1822, f2133;
fma.rn.f32 f2135, f2121, 0f3E9E377A, f2134;
mul.f32 f2136, f2128, 0f3F167918;
mul.f32 f2137, f2130, 0f3F737871;
sub.f32 f2138, f2137, f2136;
mul.f32 f2140, f2402, 0f3F4F1BBD;
fma.rn.f32 f2399, f2403, 0f3E9E377A, f1826;
sub.f32 f2141, f2399, f2140;
sub.f32 f2142, f1866, f1998;
sub.f32 f2144, f1910, f1954;
mul.f32 f2145, f2144, 0fBF167918;
mul.f32 f2398, f2142, 0f3F737871;
sub.f32 f2146, f2145, f2398;
add.f32 f2397, f1826, f2403;
mul.f32 f2147, f2403, 0f3F4F1BBD;
sub.f32 f2148, f1826, f2147;
fma.rn.f32 f2149, f2402, 0f3E9E377A, f2148;
mul.f32 f2150, f2142, 0f3F167918;
mul.f32 f2151, f2144, 0f3F737871;
sub.f32 f2152, f2151, f2150;
add.f32 f2153, f2041, f2056;
add.f32 f2155, f2046, f2051;
fma.rn.f32 f2395, f2153, 0f3E9E377A, f1835;
mul.f32 f2396, f2155, 0f3F4F1BBD;
sub.f32 f2161, f2395, f2396;
add.f32 f2394, f2043, f2058;
sub.f32 f2162, f2043, f2058;
add.f32 f2393, f2048, f2053;
sub.f32 f2164, f2048, f2053;
mul.f32 f2391, f2162, 0f3F737871;
mul.f32 f2392, f2164, 0fBF167918;
sub.f32 f2166, f2392, f2391;
add.f32 f2390, f1835, f2153;
mul.f32 f2167, f2153, 0f3F4F1BBD;
sub.f32 f2168, f1835, f2167;
fma.rn.f32 f2169, f2155, 0f3E9E377A, f2168;
mul.f32 f2170, f2162, 0f3F167918;
mul.f32 f2171, f2164, 0f3F737871;
sub.f32 f2172, f2171, f2170;
fma.rn.f32 f2388, f2394, 0f3E9E377A, f1853;
mul.f32 f2389, f2393, 0f3F4F1BBD;
sub.f32 f2175, f2388, f2389;
sub.f32 f2176, f2041, f2056;
sub.f32 f2178, f2046, f2051;
mul.f32 f2386, f2176, 0f3F737871;
mul.f32 f2387, f2178, 0fBF167918;
sub.f32 f2180, f2387, f2386;
add.f32 f2385, f1853, f2394;
mul.f32 f2181, f2394, 0f3F4F1BBD;
sub.f32 f2182, f1853, f2181;
fma.rn.f32 f2183, f2393, 0f3E9E377A, f2182;
mul.f32 f2184, f2176, 0f3F167918;
mul.f32 f2185, f2178, 0f3F737871;
sub.f32 f2186, f2185, f2184;
add.f32 f2187, f2061, f2076;
add.f32 f2189, f2066, f2071;
mul.f32 f2194, f2189, 0f3F4F1BBD;
fma.rn.f32 f2384, f2187, 0f3E9E377A, f1843;
sub.f32 f2195, f2384, f2194;
add.f32 f2383, f2063, f2078;
sub.f32 f2196, f2063, f2078;
add.f32 f2382, f2068, f2073;
sub.f32 f2198, f2068, f2073;
mul.f32 f2380, f2196, 0f3F737871;
mul.f32 f2381, f2198, 0fBF167918;
sub.f32 f2200, f2381, f2380;
add.f32 f2379, f1843, f2187;
mul.f32 f2201, f2187, 0f3F4F1BBD;
sub.f32 f2202, f1843, f2201;
fma.rn.f32 f2203, f2189, 0f3E9E377A, f2202;
mul.f32 f2204, f2196, 0f3F167918;
mul.f32 f2205, f2198, 0f3F737871;
sub.f32 f2206, f2205, f2204;
mul.f32 f2208, f2382, 0f3F4F1BBD;
fma.rn.f32 f2378, f2383, 0f3E9E377A, f1861;
sub.f32 f2209, f2378, f2208;
sub.f32 f2210, f2061, f2076;
sub.f32 f2212, f2066, f2071;
mul.f32 f2376, f2210, 0f3F737871;
mul.f32 f2377, f2212, 0fBF167918;
sub.f32 f2214, f2377, f2376;
add.f32 f2375, f1861, f2383;
mul.f32 f2215, f2383, 0f3F4F1BBD;
sub.f32 f2216, f1861, f2215;
fma.rn.f32 f2217, f2382, 0f3E9E377A, f2216;
mul.f32 f2218, f2210, 0f3F167918;
mul.f32 f2219, f2212, 0f3F737871;
sub.f32 f2220, f2219, f2218;
add.f32 f2221, f2081, f2096;
add.f32 f2223, f2086, f2091;
mul.f32 f2228, f2223, 0f3F4F1BBD;
fma.rn.f32 f2374, f2221, 0f3E9E377A, f1844;
sub.f32 f2229, f2374, f2228;
add.f32 f2373, f2083, f2098;
sub.f32 f2230, f2083, f2098;
add.f32 f2372, f2088, f2093;
sub.f32 f2232, f2088, f2093;
mul.f32 f2370, f2230, 0f3F737871;
mul.f32 f2371, f2232, 0fBF167918;
sub.f32 f2234, f2371, f2370;
add.f32 f2369, f1844, f2221;
mul.f32 f2235, f2221, 0f3F4F1BBD;
sub.f32 f2236, f1844, f2235;
fma.rn.f32 f2237, f2223, 0f3E9E377A, f2236;
mul.f32 f2238, f2230, 0f3F167918;
mul.f32 f2239, f2232, 0f3F737871;
sub.f32 f2240, f2239, f2238;
mul.f32 f2242, f2372, 0f3F4F1BBD;
fma.rn.f32 f2368, f2373, 0f3E9E377A, f1862;
sub.f32 f2243, f2368, f2242;
sub.f32 f2244, f2081, f2096;
sub.f32 f2246, f2086, f2091;
mul.f32 f2247, f2246, 0fBF167918;
mul.f32 f2367, f2244, 0f3F737871;
sub.f32 f2248, f2247, f2367;
add.f32 f2366, f1862, f2373;
mul.f32 f2249, f2373, 0f3F4F1BBD;
sub.f32 f2250, f1862, f2249;
fma.rn.f32 f2251, f2372, 0f3E9E377A, f2250;
mul.f32 f2252, f2244, 0f3F167918;
mul.f32 f2253, f2246, 0f3F737871;
sub.f32 f2254, f2253, f2252;
add.f32 f2255, f2101, f2116;
add.f32 f2257, f2106, f2111;
fma.rn.f32 f2364, f2255, 0f3E9E377A, f1836;
mul.f32 f2365, f2257, 0f3F4F1BBD;
sub.f32 f2263, f2364, f2365;
add.f32 f2363, f2103, f2118;
sub.f32 f2264, f2103, f2118;
add.f32 f2362, f2108, f2113;
sub.f32 f2266, f2108, f2113;
mul.f32 f2360, f2264, 0f3F737871;
mul.f32 f2361, f2266, 0fBF167918;
sub.f32 f2268, f2361, f2360;
add.f32 f2359, f1836, f2255;
mul.f32 f2269, f2255, 0f3F4F1BBD;
sub.f32 f2270, f1836, f2269;
fma.rn.f32 f2271, f2257, 0f3E9E377A, f2270;
mul.f32 f2272, f2264, 0f3F167918;
mul.f32 f2273, f2266, 0f3F737871;
sub.f32 f2274, f2273, f2272;
fma.rn.f32 f2357, f2363, 0f3E9E377A, f1854;
mul.f32 f2358, f2362, 0f3F4F1BBD;
sub.f32 f2277, f2357, f2358;
sub.f32 f2278, f2101, f2116;
sub.f32 f2280, f2106, f2111;
mul.f32 f2355, f2278, 0f3F737871;
mul.f32 f2356, f2280, 0fBF167918;
sub.f32 f2282, f2356, f2355;
add.f32 f2354, f1854, f2363;
mul.f32 f2283, f2363, 0f3F4F1BBD;
sub.f32 f2284, f1854, f2283;
fma.rn.f32 f2285, f2362, 0f3E9E377A, f2284;
mul.f32 f2286, f2278, 0f3F167918;
mul.f32 f2287, f2280, 0f3F737871;
sub.f32 f2288, f2287, f2286;
add.f32 %1, f2402, f2397;
add.f32 %0, f2121, f2400;
add.f32 %3, f2393, f2385;
add.f32 %2, f2155, f2390;
add.f32 %5, f2382, f2375;
add.f32 %4, f2189, f2379;
add.f32 %7, f2372, f2366;
add.f32 %6, f2223, f2369;
add.f32 %9, f2362, f2354;
add.f32 %8, f2257, f2359;
add.f32 %11, f2146, f2141;
sub.f32 %10, f2127, f2132;
add.f32 %13, f2180, f2175;
sub.f32 %12, f2161, f2166;
sub.f32 %14, f2195, f2200;
add.f32 %15, f2214, f2209;
sub.f32 %16, f2229, f2234;
add.f32 %17, f2248, f2243;
sub.f32 %18, f2263, f2268;
add.f32 %19, f2282, f2277;
sub.f32 %20, f2135, f2138;
add.f32 %21, f2152, f2149;
add.f32 %23, f2186, f2183;
sub.f32 %22, f2169, f2172;
add.f32 %25, f2220, f2217;
sub.f32 %24, f2203, f2206;
add.f32 %27, f2254, f2251;
sub.f32 %26, f2237, f2240;
sub.f32 %28, f2271, f2274;
add.f32 %29, f2288, f2285;
sub.f32 %31, f2149, f2152;
add.f32 %30, f2138, f2135;
sub.f32 %33, f2183, f2186;
add.f32 %32, f2172, f2169;
sub.f32 %35, f2217, f2220;
add.f32 %34, f2206, f2203;
sub.f32 %37, f2251, f2254;
add.f32 %36, f2240, f2237;
sub.f32 %39, f2285, f2288;
add.f32 %38, f2274, f2271;
sub.f32 %41, f2141, f2146;
add.f32 %40, f2132, f2127;
sub.f32 %43, f2175, f2180;
add.f32 %42, f2166, f2161;
sub.f32 %45, f2209, f2214;
add.f32 %44, f2200, f2195;
sub.f32 %47, f2243, f2248;
add.f32 %46, f2234, f2229;
sub.f32 %49, f2277, f2282;
add.f32 %48, f2268, f2263;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_15625), "l"(lut_sp_25_625), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[5].y), "f"(rmem[10].y), "f"(rmem[20].y), "f"(rmem[11].y), "f"(rmem[16].y), "f"(rmem[1].y), "f"(rmem[17].y), "f"(rmem[2].y), "f"(rmem[22].y), "f"(rmem[7].y), "f"(rmem[23].y), "f"(rmem[8].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[4].y), "f"(rmem[14].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<170, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<2239>;
.reg .b32 r<17>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %50;
mad.lo.s32 r3, r1, 62500, r2;
add.f32 f101, %66, %106;
add.f32 f102, %53, f101;
add.f32 f103, %79, %93;
add.f32 f104, f103, f102;
add.f32 f105, %68, %108;
add.f32 f106, %54, f105;
add.f32 f107, %81, %94;
add.f32 f108, f107, f106;
fma.rn.f32 f109, f101, 0f3E9E377A, %53;
mul.f32 f110, f103, 0f3F4F1BBD;
sub.f32 f111, f109, f110;
sub.f32 f112, %68, %108;
mul.f32 f113, f112, 0f3F737871;
sub.f32 f114, %81, %94;
mul.f32 f115, f114, 0fBF167918;
sub.f32 f116, f115, f113;
sub.f32 f117, f111, f116;
add.f32 f118, f116, f111;
mul.f32 f119, f101, 0f3F4F1BBD;
sub.f32 f120, %53, f119;
fma.rn.f32 f121, f103, 0f3E9E377A, f120;
mul.f32 f122, f112, 0f3F167918;
mul.f32 f123, f114, 0f3F737871;
sub.f32 f124, f123, f122;
sub.f32 f125, f121, f124;
add.f32 f126, f124, f121;
fma.rn.f32 f127, f105, 0f3E9E377A, %54;
mul.f32 f128, f107, 0f3F4F1BBD;
sub.f32 f129, f127, f128;
sub.f32 f130, %66, %106;
mul.f32 f131, f130, 0f3F737871;
sub.f32 f132, %79, %93;
mul.f32 f133, f132, 0fBF167918;
sub.f32 f134, f133, f131;
add.f32 f135, f134, f129;
sub.f32 f136, f129, f134;
mul.f32 f137, f105, 0f3F4F1BBD;
sub.f32 f138, %54, f137;
fma.rn.f32 f139, f107, 0f3E9E377A, f138;
mul.f32 f140, f130, 0f3F167918;
mul.f32 f141, f132, 0f3F737871;
sub.f32 f142, f141, f140;
add.f32 f143, f142, f139;
sub.f32 f144, f139, f142;
add.f32 f145, %69, %109;
add.f32 f146, %55, f145;
add.f32 f147, %82, %95;
add.f32 f148, f147, f146;
add.f32 f149, %70, %110;
add.f32 f150, %57, f149;
add.f32 f151, %84, %97;
add.f32 f152, f151, f150;
fma.rn.f32 f153, f145, 0f3E9E377A, %55;
mul.f32 f154, f147, 0f3F4F1BBD;
sub.f32 f155, f153, f154;
sub.f32 f156, %70, %110;
mul.f32 f157, f156, 0f3F737871;
sub.f32 f158, %84, %97;
mul.f32 f159, f158, 0fBF167918;
sub.f32 f160, f159, f157;
sub.f32 f161, f155, f160;
add.f32 f162, f160, f155;
mul.f32 f163, f145, 0f3F4F1BBD;
sub.f32 f164, %55, f163;
fma.rn.f32 f165, f147, 0f3E9E377A, f164;
mul.f32 f166, f156, 0f3F167918;
mul.f32 f167, f158, 0f3F737871;
sub.f32 f168, f167, f166;
sub.f32 f169, f165, f168;
add.f32 f170, f168, f165;
fma.rn.f32 f171, f149, 0f3E9E377A, %57;
mul.f32 f172, f151, 0f3F4F1BBD;
sub.f32 f173, f171, f172;
sub.f32 f174, %69, %109;
mul.f32 f175, f174, 0f3F737871;
sub.f32 f176, %82, %95;
mul.f32 f177, f176, 0fBF167918;
sub.f32 f178, f177, f175;
add.f32 f179, f178, f173;
sub.f32 f180, f173, f178;
mul.f32 f181, f149, 0f3F4F1BBD;
sub.f32 f182, %57, f181;
fma.rn.f32 f183, f151, 0f3E9E377A, f182;
mul.f32 f184, f174, 0f3F167918;
mul.f32 f185, f176, 0f3F737871;
sub.f32 f186, f185, f184;
add.f32 f187, f186, f183;
sub.f32 f188, f183, f186;
add.f32 f189, %71, %111;
add.f32 f190, %58, f189;
add.f32 f191, %85, %98;
add.f32 f192, f191, f190;
add.f32 f193, %73, %113;
add.f32 f194, %60, f193;
add.f32 f195, %86, %100;
add.f32 f196, f195, f194;
fma.rn.f32 f197, f189, 0f3E9E377A, %58;
mul.f32 f198, f191, 0f3F4F1BBD;
sub.f32 f199, f197, f198;
sub.f32 f200, %73, %113;
mul.f32 f201, f200, 0f3F737871;
sub.f32 f202, %86, %100;
mul.f32 f203, f202, 0fBF167918;
sub.f32 f204, f203, f201;
sub.f32 f205, f199, f204;
add.f32 f206, f204, f199;
mul.f32 f207, f189, 0f3F4F1BBD;
sub.f32 f208, %58, f207;
fma.rn.f32 f209, f191, 0f3E9E377A, f208;
mul.f32 f210, f200, 0f3F167918;
mul.f32 f211, f202, 0f3F737871;
sub.f32 f212, f211, f210;
sub.f32 f213, f209, f212;
add.f32 f214, f212, f209;
fma.rn.f32 f215, f193, 0f3E9E377A, %60;
mul.f32 f216, f195, 0f3F4F1BBD;
sub.f32 f217, f215, f216;
sub.f32 f218, %71, %111;
mul.f32 f219, f218, 0f3F737871;
sub.f32 f220, %85, %98;
mul.f32 f221, f220, 0fBF167918;
sub.f32 f222, f221, f219;
add.f32 f223, f222, f217;
sub.f32 f224, f217, f222;
mul.f32 f225, f193, 0f3F4F1BBD;
sub.f32 f226, %60, f225;
fma.rn.f32 f227, f195, 0f3E9E377A, f226;
mul.f32 f228, f218, 0f3F167918;
mul.f32 f229, f220, 0f3F737871;
sub.f32 f230, f229, f228;
add.f32 f231, f230, f227;
sub.f32 f232, f227, f230;
add.f32 f233, %74, %114;
add.f32 f234, %61, f233;
add.f32 f235, %87, %101;
add.f32 f236, f235, f234;
add.f32 f237, %76, %116;
add.f32 f238, %62, f237;
add.f32 f239, %89, %102;
add.f32 f240, f239, f238;
fma.rn.f32 f241, f233, 0f3E9E377A, %61;
mul.f32 f242, f235, 0f3F4F1BBD;
sub.f32 f243, f241, f242;
sub.f32 f244, %76, %116;
mul.f32 f245, f244, 0f3F737871;
sub.f32 f246, %89, %102;
mul.f32 f247, f246, 0fBF167918;
sub.f32 f248, f247, f245;
sub.f32 f249, f243, f248;
add.f32 f250, f248, f243;
mul.f32 f251, f233, 0f3F4F1BBD;
sub.f32 f252, %61, f251;
fma.rn.f32 f253, f235, 0f3E9E377A, f252;
mul.f32 f254, f244, 0f3F167918;
mul.f32 f255, f246, 0f3F737871;
sub.f32 f256, f255, f254;
sub.f32 f257, f253, f256;
add.f32 f258, f256, f253;
fma.rn.f32 f259, f237, 0f3E9E377A, %62;
mul.f32 f260, f239, 0f3F4F1BBD;
sub.f32 f261, f259, f260;
sub.f32 f262, %74, %114;
mul.f32 f263, f262, 0f3F737871;
sub.f32 f264, %87, %101;
mul.f32 f265, f264, 0fBF167918;
sub.f32 f266, f265, f263;
add.f32 f267, f266, f261;
sub.f32 f268, f261, f266;
mul.f32 f269, f237, 0f3F4F1BBD;
sub.f32 f270, %62, f269;
fma.rn.f32 f271, f239, 0f3E9E377A, f270;
mul.f32 f272, f262, 0f3F167918;
mul.f32 f273, f264, 0f3F737871;
sub.f32 f274, f273, f272;
add.f32 f275, f274, f271;
sub.f32 f276, f271, f274;
add.f32 f277, %77, %117;
add.f32 f278, %63, f277;
add.f32 f279, %90, %103;
add.f32 f280, f279, f278;
add.f32 f281, %78, %118;
add.f32 f282, %65, f281;
add.f32 f283, %92, %105;
add.f32 f284, f283, f282;
fma.rn.f32 f285, f277, 0f3E9E377A, %63;
mul.f32 f286, f279, 0f3F4F1BBD;
sub.f32 f287, f285, f286;
sub.f32 f288, %78, %118;
mul.f32 f289, f288, 0f3F737871;
sub.f32 f290, %92, %105;
mul.f32 f291, f290, 0fBF167918;
sub.f32 f292, f291, f289;
sub.f32 f293, f287, f292;
add.f32 f294, f292, f287;
mul.f32 f295, f277, 0f3F4F1BBD;
sub.f32 f296, %63, f295;
fma.rn.f32 f297, f279, 0f3E9E377A, f296;
mul.f32 f298, f288, 0f3F167918;
mul.f32 f299, f290, 0f3F737871;
sub.f32 f300, f299, f298;
sub.f32 f301, f297, f300;
add.f32 f302, f300, f297;
fma.rn.f32 f303, f281, 0f3E9E377A, %65;
mul.f32 f304, f283, 0f3F4F1BBD;
sub.f32 f305, f303, f304;
sub.f32 f306, %77, %117;
mul.f32 f307, f306, 0f3F737871;
sub.f32 f308, %90, %103;
mul.f32 f309, f308, 0fBF167918;
sub.f32 f310, f309, f307;
add.f32 f311, f310, f305;
sub.f32 f312, f305, f310;
mul.f32 f313, f281, 0f3F4F1BBD;
sub.f32 f314, %65, f313;
fma.rn.f32 f315, f283, 0f3E9E377A, f314;
mul.f32 f316, f306, 0f3F167918;
mul.f32 f317, f308, 0f3F737871;
sub.f32 f318, f317, f316;
add.f32 f319, f318, f315;
sub.f32 f320, f315, f318;
mov.u32 r4, %tid.x;
mul.f32 f321, f161, 0f3F77F511;
mul.f32 f322, f179, 0fBE7EA890;
sub.f32 f323, f321, f322;
mul.f32 f324, f179, 0f3F77F511;
fma.rn.f32 f325, f161, 0fBE7EA890, f324;
mul.f32 f326, f205, 0f3F6055A2;
mul.f32 f327, f223, 0fBEF6A86B;
sub.f32 f328, f326, f327;
mul.f32 f329, f223, 0f3F6055A2;
fma.rn.f32 f330, f205, 0fBEF6A86B, f329;
mul.f32 f331, f249, 0f3F3A9DB0;
mul.f32 f332, f267, 0fBF2F3E7B;
sub.f32 f333, f331, f332;
mul.f32 f334, f267, 0f3F3A9DB0;
fma.rn.f32 f335, f249, 0fBF2F3E7B, f334;
mul.f32 f336, f293, 0f3F092BF2;
mul.f32 f337, f311, 0fBF5825E0;
sub.f32 f338, f336, f337;
mul.f32 f339, f311, 0f3F092BF2;
fma.rn.f32 f340, f293, 0fBF5825E0, f339;
mul.f32 f341, f169, 0f3F6055A2;
mul.f32 f342, f187, 0fBEF6A86B;
sub.f32 f343, f341, f342;
mul.f32 f344, f187, 0f3F6055A2;
fma.rn.f32 f345, f169, 0fBEF6A86B, f344;
mul.f32 f346, f213, 0f3F092BF2;
mul.f32 f347, f231, 0fBF5825E0;
sub.f32 f348, f346, f347;
mul.f32 f349, f231, 0f3F092BF2;
fma.rn.f32 f350, f213, 0fBF5825E0, f349;
mul.f32 f351, f257, 0f3D809851;
mul.f32 f352, f275, 0fBF7F7EAE;
sub.f32 f353, f351, f352;
mul.f32 f354, f275, 0f3D809851;
fma.rn.f32 f355, f257, 0fBF7F7EAE, f354;
mul.f32 f356, f301, 0fBED9FFBE;
mul.f32 f357, f319, 0fBF67A2BF;
sub.f32 f358, f356, f357;
mul.f32 f359, f319, 0fBED9FFBE;
fma.rn.f32 f360, f301, 0fBF67A2BF, f359;
mul.f32 f361, f170, 0f3F3A9DB0;
mul.f32 f362, f188, 0fBF2F3E7B;
sub.f32 f363, f361, f362;
mul.f32 f364, f188, 0f3F3A9DB0;
fma.rn.f32 f365, f170, 0fBF2F3E7B, f364;
mul.f32 f366, f214, 0f3D809851;
mul.f32 f367, f232, 0fBF7F7EAE;
sub.f32 f368, f366, f367;
mul.f32 f369, f232, 0f3D809851;
fma.rn.f32 f370, f214, 0fBF7F7EAE, f369;
mul.f32 f371, f258, 0fBF232E38;
mul.f32 f372, f276, 0fBF45405B;
sub.f32 f373, f371, f372;
mul.f32 f374, f276, 0fBF232E38;
fma.rn.f32 f375, f258, 0fBF45405B, f374;
mul.f32 f376, f302, 0fBF7DFB3B;
mul.f32 f377, f320, 0fBE00575B;
sub.f32 f378, f376, f377;
mul.f32 f379, f320, 0fBF7DFB3B;
fma.rn.f32 f380, f302, 0fBE00575B, f379;
mul.f32 f381, f162, 0f3F092BF2;
mul.f32 f382, f180, 0fBF5825E0;
sub.f32 f383, f381, f382;
mul.f32 f384, f180, 0f3F092BF2;
fma.rn.f32 f385, f162, 0fBF5825E0, f384;
mul.f32 f386, f206, 0fBED9FFBE;
mul.f32 f387, f224, 0fBF67A2BF;
sub.f32 f388, f386, f387;
mul.f32 f389, f224, 0fBED9FFBE;
fma.rn.f32 f390, f206, 0fBF67A2BF, f389;
mul.f32 f391, f250, 0fBF7DFB3B;
mul.f32 f392, f268, 0fBE00575B;
sub.f32 f393, f391, f392;
mul.f32 f394, f268, 0fBF7DFB3B;
fma.rn.f32 f395, f250, 0fBE00575B, f394;
mul.f32 f396, f294, 0fBF232E38;
mul.f32 f397, f312, 0f3F45405B;
sub.f32 f398, f396, f397;
mul.f32 f399, f312, 0fBF232E38;
fma.rn.f32 f400, f294, 0f3F45405B, f399;
add.f32 f401, f148, f280;
add.f32 f402, f104, f401;
add.f32 f403, f192, f236;
add.f32 f404, f403, f402;
add.f32 f405, f152, f284;
add.f32 f406, f108, f405;
add.f32 f407, f196, f240;
add.f32 f408, f407, f406;
fma.rn.f32 f409, f401, 0f3E9E377A, f104;
mul.f32 f410, f403, 0f3F4F1BBD;
sub.f32 f411, f409, f410;
sub.f32 f412, f152, f284;
mul.f32 f413, f412, 0f3F737871;
sub.f32 f414, f196, f240;
mul.f32 f415, f414, 0fBF167918;
sub.f32 f416, f415, f413;
sub.f32 f417, f411, f416;
add.f32 f418, f416, f411;
mul.f32 f419, f401, 0f3F4F1BBD;
sub.f32 f420, f104, f419;
fma.rn.f32 f421, f403, 0f3E9E377A, f420;
mul.f32 f422, f412, 0f3F167918;
mul.f32 f423, f414, 0f3F737871;
sub.f32 f424, f423, f422;
sub.f32 f425, f421, f424;
add.f32 f426, f424, f421;
fma.rn.f32 f427, f405, 0f3E9E377A, f108;
mul.f32 f428, f407, 0f3F4F1BBD;
sub.f32 f429, f427, f428;
sub.f32 f430, f148, f280;
mul.f32 f431, f430, 0f3F737871;
sub.f32 f432, f192, f236;
mul.f32 f433, f432, 0fBF167918;
sub.f32 f434, f433, f431;
add.f32 f435, f434, f429;
sub.f32 f436, f429, f434;
mul.f32 f437, f405, 0f3F4F1BBD;
sub.f32 f438, f108, f437;
fma.rn.f32 f439, f407, 0f3E9E377A, f438;
mul.f32 f440, f430, 0f3F167918;
mul.f32 f441, f432, 0f3F737871;
sub.f32 f442, f441, f440;
add.f32 f443, f442, f439;
sub.f32 f444, f439, f442;
add.f32 f445, f323, f338;
add.f32 f446, f117, f445;
add.f32 f447, f328, f333;
add.f32 f448, f447, f446;
add.f32 f449, f325, f340;
add.f32 f450, f135, f449;
add.f32 f451, f330, f335;
add.f32 f452, f451, f450;
fma.rn.f32 f453, f445, 0f3E9E377A, f117;
mul.f32 f454, f447, 0f3F4F1BBD;
sub.f32 f455, f453, f454;
sub.f32 f456, f325, f340;
mul.f32 f457, f456, 0f3F737871;
sub.f32 f458, f330, f335;
mul.f32 f459, f458, 0fBF167918;
sub.f32 f460, f459, f457;
sub.f32 f461, f455, f460;
add.f32 f462, f460, f455;
mul.f32 f463, f445, 0f3F4F1BBD;
sub.f32 f464, f117, f463;
fma.rn.f32 f465, f447, 0f3E9E377A, f464;
mul.f32 f466, f456, 0f3F167918;
mul.f32 f467, f458, 0f3F737871;
sub.f32 f468, f467, f466;
sub.f32 f469, f465, f468;
add.f32 f470, f468, f465;
fma.rn.f32 f471, f449, 0f3E9E377A, f135;
mul.f32 f472, f451, 0f3F4F1BBD;
sub.f32 f473, f471, f472;
sub.f32 f474, f323, f338;
mul.f32 f475, f474, 0f3F737871;
sub.f32 f476, f328, f333;
mul.f32 f477, f476, 0fBF167918;
sub.f32 f478, f477, f475;
add.f32 f479, f478, f473;
sub.f32 f480, f473, f478;
mul.f32 f481, f449, 0f3F4F1BBD;
sub.f32 f482, f135, f481;
fma.rn.f32 f483, f451, 0f3E9E377A, f482;
mul.f32 f484, f474, 0f3F167918;
mul.f32 f485, f476, 0f3F737871;
sub.f32 f486, f485, f484;
add.f32 f487, f486, f483;
sub.f32 f488, f483, f486;
add.f32 f489, f343, f358;
add.f32 f490, f125, f489;
add.f32 f491, f348, f353;
add.f32 f492, f491, f490;
add.f32 f493, f345, f360;
add.f32 f494, f143, f493;
add.f32 f495, f350, f355;
add.f32 f496, f495, f494;
fma.rn.f32 f497, f489, 0f3E9E377A, f125;
mul.f32 f498, f491, 0f3F4F1BBD;
sub.f32 f499, f497, f498;
sub.f32 f500, f345, f360;
mul.f32 f501, f500, 0f3F737871;
sub.f32 f502, f350, f355;
mul.f32 f503, f502, 0fBF167918;
sub.f32 f504, f503, f501;
sub.f32 f505, f499, f504;
add.f32 f506, f504, f499;
mul.f32 f507, f489, 0f3F4F1BBD;
sub.f32 f508, f125, f507;
fma.rn.f32 f509, f491, 0f3E9E377A, f508;
mul.f32 f510, f500, 0f3F167918;
mul.f32 f511, f502, 0f3F737871;
sub.f32 f512, f511, f510;
sub.f32 f513, f509, f512;
add.f32 f514, f512, f509;
fma.rn.f32 f515, f493, 0f3E9E377A, f143;
mul.f32 f516, f495, 0f3F4F1BBD;
sub.f32 f517, f515, f516;
sub.f32 f518, f343, f358;
mul.f32 f519, f518, 0f3F737871;
sub.f32 f520, f348, f353;
mul.f32 f521, f520, 0fBF167918;
sub.f32 f522, f521, f519;
add.f32 f523, f522, f517;
sub.f32 f524, f517, f522;
mul.f32 f525, f493, 0f3F4F1BBD;
sub.f32 f526, f143, f525;
fma.rn.f32 f527, f495, 0f3E9E377A, f526;
mul.f32 f528, f518, 0f3F167918;
mul.f32 f529, f520, 0f3F737871;
sub.f32 f530, f529, f528;
add.f32 f531, f530, f527;
sub.f32 f532, f527, f530;
add.f32 f533, f363, f378;
add.f32 f534, f126, f533;
add.f32 f535, f368, f373;
add.f32 f536, f535, f534;
add.f32 f537, f365, f380;
add.f32 f538, f144, f537;
add.f32 f539, f370, f375;
add.f32 f540, f539, f538;
fma.rn.f32 f541, f533, 0f3E9E377A, f126;
mul.f32 f542, f535, 0f3F4F1BBD;
sub.f32 f543, f541, f542;
sub.f32 f544, f365, f380;
mul.f32 f545, f544, 0f3F737871;
sub.f32 f546, f370, f375;
mul.f32 f547, f546, 0fBF167918;
sub.f32 f548, f547, f545;
sub.f32 f549, f543, f548;
add.f32 f550, f548, f543;
mul.f32 f551, f533, 0f3F4F1BBD;
sub.f32 f552, f126, f551;
fma.rn.f32 f553, f535, 0f3E9E377A, f552;
mul.f32 f554, f544, 0f3F167918;
mul.f32 f555, f546, 0f3F737871;
sub.f32 f556, f555, f554;
sub.f32 f557, f553, f556;
add.f32 f558, f556, f553;
fma.rn.f32 f559, f537, 0f3E9E377A, f144;
mul.f32 f560, f539, 0f3F4F1BBD;
sub.f32 f561, f559, f560;
sub.f32 f562, f363, f378;
mul.f32 f563, f562, 0f3F737871;
sub.f32 f564, f368, f373;
mul.f32 f565, f564, 0fBF167918;
sub.f32 f566, f565, f563;
add.f32 f567, f566, f561;
sub.f32 f568, f561, f566;
mul.f32 f569, f537, 0f3F4F1BBD;
sub.f32 f570, f144, f569;
fma.rn.f32 f571, f539, 0f3E9E377A, f570;
mul.f32 f572, f562, 0f3F167918;
mul.f32 f573, f564, 0f3F737871;
sub.f32 f574, f573, f572;
add.f32 f575, f574, f571;
sub.f32 f576, f571, f574;
add.f32 f577, f383, f398;
add.f32 f578, f118, f577;
add.f32 f579, f388, f393;
add.f32 f580, f579, f578;
add.f32 f581, f385, f400;
add.f32 f582, f136, f581;
add.f32 f583, f390, f395;
add.f32 f584, f583, f582;
fma.rn.f32 f585, f577, 0f3E9E377A, f118;
mul.f32 f586, f579, 0f3F4F1BBD;
sub.f32 f587, f585, f586;
sub.f32 f588, f385, f400;
mul.f32 f589, f588, 0f3F737871;
sub.f32 f590, f390, f395;
mul.f32 f591, f590, 0fBF167918;
sub.f32 f592, f591, f589;
sub.f32 f593, f587, f592;
add.f32 f594, f592, f587;
mul.f32 f595, f577, 0f3F4F1BBD;
sub.f32 f596, f118, f595;
fma.rn.f32 f597, f579, 0f3E9E377A, f596;
mul.f32 f598, f588, 0f3F167918;
mul.f32 f599, f590, 0f3F737871;
sub.f32 f600, f599, f598;
sub.f32 f601, f597, f600;
add.f32 f602, f600, f597;
fma.rn.f32 f603, f581, 0f3E9E377A, f136;
mul.f32 f604, f583, 0f3F4F1BBD;
sub.f32 f605, f603, f604;
sub.f32 f606, f383, f398;
mul.f32 f607, f606, 0f3F737871;
sub.f32 f608, f388, f393;
mul.f32 f609, f608, 0fBF167918;
sub.f32 f610, f609, f607;
add.f32 f611, f610, f605;
sub.f32 f612, f605, f610;
mul.f32 f613, f581, 0f3F4F1BBD;
sub.f32 f614, f136, f613;
fma.rn.f32 f615, f583, 0f3E9E377A, f614;
mul.f32 f616, f606, 0f3F167918;
mul.f32 f617, f608, 0f3F737871;
sub.f32 f618, f617, f616;
add.f32 f619, f618, f615;
sub.f32 f620, f615, f618;
mul.wide.u32 rd2, r4, -776530087;
shr.u64 rd3, rd2, 41;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 625;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %51;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f621, f622}, [rd6];
mul.f32 f625, f621, f448;
mul.f32 f626, f622, f452;
sub.f32 f627, f625, f626;
mul.f32 f628, f621, f452;
fma.rn.f32 f629, f622, f448, f628;
mul.f32 f630, f621, f621;
mul.f32 f631, f622, f622;
sub.f32 f632, f630, f631;
mul.f32 f633, f622, f621;
fma.rn.f32 f634, f622, f621, f633;
mul.f32 f635, f632, f492;
mul.f32 f636, f634, f496;
sub.f32 f637, f635, f636;
mul.f32 f638, f632, f496;
fma.rn.f32 f639, f634, f492, f638;
mul.f32 f640, f621, f632;
mul.f32 f641, f622, f634;
sub.f32 f642, f640, f641;
mul.f32 f643, f621, f634;
fma.rn.f32 f644, f622, f632, f643;
mul.f32 f645, f642, f536;
mul.f32 f646, f644, f540;
sub.f32 f647, f645, f646;
mul.f32 f648, f642, f540;
fma.rn.f32 f649, f644, f536, f648;
mul.f32 f650, f621, f642;
mul.f32 f651, f622, f644;
sub.f32 f652, f650, f651;
mul.f32 f653, f621, f644;
fma.rn.f32 f654, f622, f642, f653;
mul.f32 f655, f652, f580;
mul.f32 f656, f654, f584;
sub.f32 f657, f655, f656;
mul.f32 f658, f652, f584;
fma.rn.f32 f659, f654, f580, f658;
mul.f32 f660, f621, f652;
mul.f32 f661, f622, f654;
sub.f32 f662, f660, f661;
mul.f32 f663, f621, f654;
fma.rn.f32 f664, f622, f652, f663;
mul.f32 f665, f662, f417;
mul.f32 f666, f664, f435;
sub.f32 f667, f665, f666;
mul.f32 f668, f662, f435;
fma.rn.f32 f669, f664, f417, f668;
mul.f32 f670, f621, f662;
mul.f32 f671, f622, f664;
sub.f32 f672, f670, f671;
mul.f32 f673, f621, f664;
fma.rn.f32 f674, f622, f662, f673;
mul.f32 f675, f672, f461;
mul.f32 f676, f674, f479;
sub.f32 f677, f675, f676;
mul.f32 f678, f672, f479;
fma.rn.f32 f679, f674, f461, f678;
mul.f32 f680, f621, f672;
mul.f32 f681, f622, f674;
sub.f32 f682, f680, f681;
mul.f32 f683, f621, f674;
fma.rn.f32 f684, f622, f672, f683;
mul.f32 f685, f682, f505;
mul.f32 f686, f684, f523;
sub.f32 f687, f685, f686;
mul.f32 f688, f682, f523;
fma.rn.f32 f689, f684, f505, f688;
mul.f32 f690, f621, f682;
mul.f32 f691, f622, f684;
sub.f32 f692, f690, f691;
mul.f32 f693, f621, f684;
fma.rn.f32 f694, f622, f682, f693;
mul.f32 f695, f692, f549;
mul.f32 f696, f694, f567;
sub.f32 f697, f695, f696;
mul.f32 f698, f692, f567;
fma.rn.f32 f699, f694, f549, f698;
mul.f32 f700, f621, f692;
mul.f32 f701, f622, f694;
sub.f32 f702, f700, f701;
mul.f32 f703, f621, f694;
fma.rn.f32 f704, f622, f692, f703;
mul.f32 f705, f702, f593;
mul.f32 f706, f704, f611;
sub.f32 f707, f705, f706;
mul.f32 f708, f702, f611;
fma.rn.f32 f709, f704, f593, f708;
mul.f32 f710, f621, f702;
mul.f32 f711, f622, f704;
sub.f32 f712, f710, f711;
mul.f32 f713, f621, f704;
fma.rn.f32 f714, f622, f702, f713;
mul.f32 f715, f712, f425;
mul.f32 f716, f714, f443;
sub.f32 f717, f715, f716;
mul.f32 f718, f712, f443;
fma.rn.f32 f719, f714, f425, f718;
mul.f32 f720, f621, f712;
mul.f32 f721, f622, f714;
sub.f32 f722, f720, f721;
mul.f32 f723, f621, f714;
fma.rn.f32 f724, f622, f712, f723;
mul.f32 f725, f722, f469;
mul.f32 f726, f724, f487;
sub.f32 f727, f725, f726;
mul.f32 f728, f722, f487;
fma.rn.f32 f729, f724, f469, f728;
mul.f32 f730, f621, f722;
mul.f32 f731, f622, f724;
sub.f32 f732, f730, f731;
mul.f32 f733, f621, f724;
fma.rn.f32 f734, f622, f722, f733;
mul.f32 f735, f732, f513;
mul.f32 f736, f734, f531;
sub.f32 f737, f735, f736;
mul.f32 f738, f732, f531;
fma.rn.f32 f739, f734, f513, f738;
mul.f32 f740, f621, f732;
mul.f32 f741, f622, f734;
sub.f32 f742, f740, f741;
mul.f32 f743, f621, f734;
fma.rn.f32 f744, f622, f732, f743;
mul.f32 f745, f742, f557;
mul.f32 f746, f744, f575;
sub.f32 f747, f745, f746;
mul.f32 f748, f742, f575;
fma.rn.f32 f749, f744, f557, f748;
mul.f32 f750, f621, f742;
mul.f32 f751, f622, f744;
sub.f32 f752, f750, f751;
mul.f32 f753, f621, f744;
fma.rn.f32 f754, f622, f742, f753;
mul.f32 f755, f752, f601;
mul.f32 f756, f754, f619;
sub.f32 f757, f755, f756;
mul.f32 f758, f752, f619;
fma.rn.f32 f759, f754, f601, f758;
mul.f32 f760, f621, f752;
mul.f32 f761, f622, f754;
sub.f32 f762, f760, f761;
mul.f32 f763, f621, f754;
fma.rn.f32 f764, f622, f752, f763;
mul.f32 f765, f762, f426;
mul.f32 f766, f764, f444;
sub.f32 f767, f765, f766;
mul.f32 f768, f762, f444;
fma.rn.f32 f769, f764, f426, f768;
mul.f32 f770, f621, f762;
mul.f32 f771, f622, f764;
sub.f32 f772, f770, f771;
mul.f32 f773, f621, f764;
fma.rn.f32 f774, f622, f762, f773;
mul.f32 f775, f772, f470;
mul.f32 f776, f774, f488;
sub.f32 f777, f775, f776;
mul.f32 f778, f772, f488;
fma.rn.f32 f779, f774, f470, f778;
mul.f32 f780, f621, f772;
mul.f32 f781, f622, f774;
sub.f32 f782, f780, f781;
mul.f32 f783, f621, f774;
fma.rn.f32 f784, f622, f772, f783;
mul.f32 f785, f782, f514;
mul.f32 f786, f784, f532;
sub.f32 f787, f785, f786;
mul.f32 f788, f782, f532;
fma.rn.f32 f789, f784, f514, f788;
mul.f32 f790, f621, f782;
mul.f32 f791, f622, f784;
sub.f32 f792, f790, f791;
mul.f32 f793, f621, f784;
fma.rn.f32 f794, f622, f782, f793;
mul.f32 f795, f792, f558;
mul.f32 f796, f794, f576;
sub.f32 f797, f795, f796;
mul.f32 f798, f792, f576;
fma.rn.f32 f799, f794, f558, f798;
mul.f32 f800, f621, f792;
mul.f32 f801, f622, f794;
sub.f32 f802, f800, f801;
mul.f32 f803, f621, f794;
fma.rn.f32 f804, f622, f792, f803;
mul.f32 f805, f802, f602;
mul.f32 f806, f804, f620;
sub.f32 f807, f805, f806;
mul.f32 f808, f802, f620;
fma.rn.f32 f809, f804, f602, f808;
mul.f32 f810, f621, f802;
mul.f32 f811, f622, f804;
sub.f32 f812, f810, f811;
mul.f32 f813, f621, f804;
fma.rn.f32 f814, f622, f802, f813;
mul.f32 f815, f812, f418;
mul.f32 f816, f814, f436;
sub.f32 f817, f815, f816;
mul.f32 f818, f812, f436;
fma.rn.f32 f819, f814, f418, f818;
mul.f32 f820, f621, f812;
mul.f32 f821, f622, f814;
sub.f32 f822, f820, f821;
mul.f32 f823, f621, f814;
fma.rn.f32 f824, f622, f812, f823;
mul.f32 f825, f822, f462;
mul.f32 f826, f824, f480;
sub.f32 f827, f825, f826;
mul.f32 f828, f822, f480;
fma.rn.f32 f829, f824, f462, f828;
mul.f32 f830, f621, f822;
mul.f32 f831, f622, f824;
sub.f32 f832, f830, f831;
mul.f32 f833, f621, f824;
fma.rn.f32 f834, f622, f822, f833;
mul.f32 f835, f832, f506;
mul.f32 f836, f834, f524;
sub.f32 f837, f835, f836;
mul.f32 f838, f832, f524;
fma.rn.f32 f839, f834, f506, f838;
mul.f32 f840, f621, f832;
mul.f32 f841, f622, f834;
sub.f32 f842, f840, f841;
mul.f32 f843, f621, f834;
fma.rn.f32 f844, f622, f832, f843;
mul.f32 f845, f842, f550;
mul.f32 f846, f844, f568;
sub.f32 f847, f845, f846;
mul.f32 f848, f842, f568;
fma.rn.f32 f849, f844, f550, f848;
mul.f32 f850, f621, f842;
mul.f32 f851, f622, f844;
sub.f32 f852, f850, f851;
mul.f32 f853, f621, f844;
fma.rn.f32 f854, f622, f842, f853;
mul.f32 f855, f852, f594;
mul.f32 f856, f854, f612;
sub.f32 f857, f855, f856;
mul.f32 f858, f852, f612;
fma.rn.f32 f859, f854, f594, f858;
mad.lo.s32 r8, r5, 62500, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 100, r8;
st.shared.f32 [r9], f404;
st.shared.f32 [r9+4], f627;
st.shared.f32 [r9+8], f637;
st.shared.f32 [r9+12], f647;
st.shared.f32 [r9+16], f657;
st.shared.f32 [r9+20], f667;
st.shared.f32 [r9+24], f677;
st.shared.f32 [r9+28], f687;
st.shared.f32 [r9+32], f697;
st.shared.f32 [r9+36], f707;
st.shared.f32 [r9+40], f717;
st.shared.f32 [r9+44], f727;
st.shared.f32 [r9+48], f737;
st.shared.f32 [r9+52], f747;
st.shared.f32 [r9+56], f757;
st.shared.f32 [r9+60], f767;
st.shared.f32 [r9+64], f777;
st.shared.f32 [r9+68], f787;
st.shared.f32 [r9+72], f797;
st.shared.f32 [r9+76], f807;
st.shared.f32 [r9+80], f817;
st.shared.f32 [r9+84], f827;
st.shared.f32 [r9+88], f837;
st.shared.f32 [r9+92], f847;
st.shared.f32 [r9+96], f857;
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.f32 f860, [r10];
ld.shared.f32 f861, [r10+2500];
ld.shared.f32 f862, [r10+5000];
ld.shared.f32 f863, [r10+7500];
ld.shared.f32 f864, [r10+10000];
ld.shared.f32 f865, [r10+12500];
ld.shared.f32 f866, [r10+15000];
ld.shared.f32 f867, [r10+17500];
ld.shared.f32 f868, [r10+20000];
ld.shared.f32 f869, [r10+22500];
ld.shared.f32 f870, [r10+25000];
ld.shared.f32 f871, [r10+27500];
ld.shared.f32 f872, [r10+30000];
ld.shared.f32 f873, [r10+32500];
ld.shared.f32 f874, [r10+35000];
ld.shared.f32 f875, [r10+37500];
ld.shared.f32 f876, [r10+40000];
ld.shared.f32 f877, [r10+42500];
ld.shared.f32 f878, [r10+45000];
ld.shared.f32 f879, [r10+47500];
ld.shared.f32 f880, [r10+50000];
ld.shared.f32 f881, [r10+52500];
ld.shared.f32 f882, [r10+55000];
ld.shared.f32 f883, [r10+57500];
ld.shared.f32 f884, [r10+60000];
barrier.sync 0;
st.shared.f32 [r9], f408;
st.shared.f32 [r9+4], f629;
st.shared.f32 [r9+8], f639;
st.shared.f32 [r9+12], f649;
st.shared.f32 [r9+16], f659;
st.shared.f32 [r9+20], f669;
st.shared.f32 [r9+24], f679;
st.shared.f32 [r9+28], f689;
st.shared.f32 [r9+32], f699;
st.shared.f32 [r9+36], f709;
st.shared.f32 [r9+40], f719;
st.shared.f32 [r9+44], f729;
st.shared.f32 [r9+48], f739;
st.shared.f32 [r9+52], f749;
st.shared.f32 [r9+56], f759;
st.shared.f32 [r9+60], f769;
st.shared.f32 [r9+64], f779;
st.shared.f32 [r9+68], f789;
st.shared.f32 [r9+72], f799;
st.shared.f32 [r9+76], f809;
st.shared.f32 [r9+80], f819;
st.shared.f32 [r9+84], f829;
st.shared.f32 [r9+88], f839;
st.shared.f32 [r9+92], f849;
st.shared.f32 [r9+96], f859;
barrier.sync 0;
ld.shared.f32 f885, [r10];
ld.shared.f32 f886, [r10+2500];
ld.shared.f32 f887, [r10+5000];
ld.shared.f32 f888, [r10+7500];
ld.shared.f32 f889, [r10+10000];
ld.shared.f32 f890, [r10+12500];
ld.shared.f32 f891, [r10+15000];
ld.shared.f32 f892, [r10+17500];
ld.shared.f32 f893, [r10+20000];
ld.shared.f32 f894, [r10+22500];
ld.shared.f32 f895, [r10+25000];
ld.shared.f32 f896, [r10+27500];
ld.shared.f32 f897, [r10+30000];
ld.shared.f32 f898, [r10+32500];
ld.shared.f32 f899, [r10+35000];
ld.shared.f32 f900, [r10+37500];
ld.shared.f32 f901, [r10+40000];
ld.shared.f32 f902, [r10+42500];
ld.shared.f32 f903, [r10+45000];
ld.shared.f32 f904, [r10+47500];
ld.shared.f32 f905, [r10+50000];
ld.shared.f32 f906, [r10+52500];
ld.shared.f32 f907, [r10+55000];
ld.shared.f32 f908, [r10+57500];
ld.shared.f32 f909, [r10+60000];
add.f32 f910, f865, f880;
add.f32 f911, f860, f910;
add.f32 f912, f870, f875;
add.f32 f913, f912, f911;
add.f32 f914, f890, f905;
add.f32 f915, f885, f914;
add.f32 f916, f895, f900;
add.f32 f917, f916, f915;
fma.rn.f32 f918, f910, 0f3E9E377A, f860;
mul.f32 f919, f912, 0f3F4F1BBD;
sub.f32 f920, f918, f919;
sub.f32 f921, f890, f905;
mul.f32 f922, f921, 0f3F737871;
sub.f32 f923, f895, f900;
mul.f32 f924, f923, 0fBF167918;
sub.f32 f925, f924, f922;
sub.f32 f926, f920, f925;
add.f32 f927, f925, f920;
mul.f32 f928, f910, 0f3F4F1BBD;
sub.f32 f929, f860, f928;
fma.rn.f32 f930, f912, 0f3E9E377A, f929;
mul.f32 f931, f921, 0f3F167918;
mul.f32 f932, f923, 0f3F737871;
sub.f32 f933, f932, f931;
sub.f32 f934, f930, f933;
add.f32 f935, f933, f930;
fma.rn.f32 f936, f914, 0f3E9E377A, f885;
mul.f32 f937, f916, 0f3F4F1BBD;
sub.f32 f938, f936, f937;
sub.f32 f939, f865, f880;
mul.f32 f940, f939, 0f3F737871;
sub.f32 f941, f870, f875;
mul.f32 f942, f941, 0fBF167918;
sub.f32 f943, f942, f940;
add.f32 f944, f943, f938;
sub.f32 f945, f938, f943;
mul.f32 f946, f914, 0f3F4F1BBD;
sub.f32 f947, f885, f946;
fma.rn.f32 f948, f916, 0f3E9E377A, f947;
mul.f32 f949, f939, 0f3F167918;
mul.f32 f950, f941, 0f3F737871;
sub.f32 f951, f950, f949;
add.f32 f952, f951, f948;
sub.f32 f953, f948, f951;
add.f32 f954, f866, f881;
add.f32 f955, f861, f954;
add.f32 f956, f871, f876;
add.f32 f957, f956, f955;
add.f32 f958, f891, f906;
add.f32 f959, f886, f958;
add.f32 f960, f896, f901;
add.f32 f961, f960, f959;
fma.rn.f32 f962, f954, 0f3E9E377A, f861;
mul.f32 f963, f956, 0f3F4F1BBD;
sub.f32 f964, f962, f963;
sub.f32 f965, f891, f906;
mul.f32 f966, f965, 0f3F737871;
sub.f32 f967, f896, f901;
mul.f32 f968, f967, 0fBF167918;
sub.f32 f969, f968, f966;
sub.f32 f970, f964, f969;
add.f32 f971, f969, f964;
mul.f32 f972, f954, 0f3F4F1BBD;
sub.f32 f973, f861, f972;
fma.rn.f32 f974, f956, 0f3E9E377A, f973;
mul.f32 f975, f965, 0f3F167918;
mul.f32 f976, f967, 0f3F737871;
sub.f32 f977, f976, f975;
sub.f32 f978, f974, f977;
add.f32 f979, f977, f974;
fma.rn.f32 f980, f958, 0f3E9E377A, f886;
mul.f32 f981, f960, 0f3F4F1BBD;
sub.f32 f982, f980, f981;
sub.f32 f983, f866, f881;
mul.f32 f984, f983, 0f3F737871;
sub.f32 f985, f871, f876;
mul.f32 f986, f985, 0fBF167918;
sub.f32 f987, f986, f984;
add.f32 f988, f987, f982;
sub.f32 f989, f982, f987;
mul.f32 f990, f958, 0f3F4F1BBD;
sub.f32 f991, f886, f990;
fma.rn.f32 f992, f960, 0f3E9E377A, f991;
mul.f32 f993, f983, 0f3F167918;
mul.f32 f994, f985, 0f3F737871;
sub.f32 f995, f994, f993;
add.f32 f996, f995, f992;
sub.f32 f997, f992, f995;
add.f32 f998, f867, f882;
add.f32 f999, f862, f998;
add.f32 f1000, f872, f877;
add.f32 f1001, f1000, f999;
add.f32 f1002, f892, f907;
add.f32 f1003, f887, f1002;
add.f32 f1004, f897, f902;
add.f32 f1005, f1004, f1003;
fma.rn.f32 f1006, f998, 0f3E9E377A, f862;
mul.f32 f1007, f1000, 0f3F4F1BBD;
sub.f32 f1008, f1006, f1007;
sub.f32 f1009, f892, f907;
mul.f32 f1010, f1009, 0f3F737871;
sub.f32 f1011, f897, f902;
mul.f32 f1012, f1011, 0fBF167918;
sub.f32 f1013, f1012, f1010;
sub.f32 f1014, f1008, f1013;
add.f32 f1015, f1013, f1008;
mul.f32 f1016, f998, 0f3F4F1BBD;
sub.f32 f1017, f862, f1016;
fma.rn.f32 f1018, f1000, 0f3E9E377A, f1017;
mul.f32 f1019, f1009, 0f3F167918;
mul.f32 f1020, f1011, 0f3F737871;
sub.f32 f1021, f1020, f1019;
sub.f32 f1022, f1018, f1021;
add.f32 f1023, f1021, f1018;
fma.rn.f32 f1024, f1002, 0f3E9E377A, f887;
mul.f32 f1025, f1004, 0f3F4F1BBD;
sub.f32 f1026, f1024, f1025;
sub.f32 f1027, f867, f882;
mul.f32 f1028, f1027, 0f3F737871;
sub.f32 f1029, f872, f877;
mul.f32 f1030, f1029, 0fBF167918;
sub.f32 f1031, f1030, f1028;
add.f32 f1032, f1031, f1026;
sub.f32 f1033, f1026, f1031;
mul.f32 f1034, f1002, 0f3F4F1BBD;
sub.f32 f1035, f887, f1034;
fma.rn.f32 f1036, f1004, 0f3E9E377A, f1035;
mul.f32 f1037, f1027, 0f3F167918;
mul.f32 f1038, f1029, 0f3F737871;
sub.f32 f1039, f1038, f1037;
add.f32 f1040, f1039, f1036;
sub.f32 f1041, f1036, f1039;
add.f32 f1042, f868, f883;
add.f32 f1043, f863, f1042;
add.f32 f1044, f873, f878;
add.f32 f1045, f1044, f1043;
add.f32 f1046, f893, f908;
add.f32 f1047, f888, f1046;
add.f32 f1048, f898, f903;
add.f32 f1049, f1048, f1047;
fma.rn.f32 f1050, f1042, 0f3E9E377A, f863;
mul.f32 f1051, f1044, 0f3F4F1BBD;
sub.f32 f1052, f1050, f1051;
sub.f32 f1053, f893, f908;
mul.f32 f1054, f1053, 0f3F737871;
sub.f32 f1055, f898, f903;
mul.f32 f1056, f1055, 0fBF167918;
sub.f32 f1057, f1056, f1054;
sub.f32 f1058, f1052, f1057;
add.f32 f1059, f1057, f1052;
mul.f32 f1060, f1042, 0f3F4F1BBD;
sub.f32 f1061, f863, f1060;
fma.rn.f32 f1062, f1044, 0f3E9E377A, f1061;
mul.f32 f1063, f1053, 0f3F167918;
mul.f32 f1064, f1055, 0f3F737871;
sub.f32 f1065, f1064, f1063;
sub.f32 f1066, f1062, f1065;
add.f32 f1067, f1065, f1062;
fma.rn.f32 f1068, f1046, 0f3E9E377A, f888;
mul.f32 f1069, f1048, 0f3F4F1BBD;
sub.f32 f1070, f1068, f1069;
sub.f32 f1071, f868, f883;
mul.f32 f1072, f1071, 0f3F737871;
sub.f32 f1073, f873, f878;
mul.f32 f1074, f1073, 0fBF167918;
sub.f32 f1075, f1074, f1072;
add.f32 f1076, f1075, f1070;
sub.f32 f1077, f1070, f1075;
mul.f32 f1078, f1046, 0f3F4F1BBD;
sub.f32 f1079, f888, f1078;
fma.rn.f32 f1080, f1048, 0f3E9E377A, f1079;
mul.f32 f1081, f1071, 0f3F167918;
mul.f32 f1082, f1073, 0f3F737871;
sub.f32 f1083, f1082, f1081;
add.f32 f1084, f1083, f1080;
sub.f32 f1085, f1080, f1083;
add.f32 f1086, f869, f884;
add.f32 f1087, f864, f1086;
add.f32 f1088, f874, f879;
add.f32 f1089, f1088, f1087;
add.f32 f1090, f894, f909;
add.f32 f1091, f889, f1090;
add.f32 f1092, f899, f904;
add.f32 f1093, f1092, f1091;
fma.rn.f32 f1094, f1086, 0f3E9E377A, f864;
mul.f32 f1095, f1088, 0f3F4F1BBD;
sub.f32 f1096, f1094, f1095;
sub.f32 f1097, f894, f909;
mul.f32 f1098, f1097, 0f3F737871;
sub.f32 f1099, f899, f904;
mul.f32 f1100, f1099, 0fBF167918;
sub.f32 f1101, f1100, f1098;
sub.f32 f1102, f1096, f1101;
add.f32 f1103, f1101, f1096;
mul.f32 f1104, f1086, 0f3F4F1BBD;
sub.f32 f1105, f864, f1104;
fma.rn.f32 f1106, f1088, 0f3E9E377A, f1105;
mul.f32 f1107, f1097, 0f3F167918;
mul.f32 f1108, f1099, 0f3F737871;
sub.f32 f1109, f1108, f1107;
sub.f32 f1110, f1106, f1109;
add.f32 f1111, f1109, f1106;
fma.rn.f32 f1112, f1090, 0f3E9E377A, f889;
mul.f32 f1113, f1092, 0f3F4F1BBD;
sub.f32 f1114, f1112, f1113;
sub.f32 f1115, f869, f884;
mul.f32 f1116, f1115, 0f3F737871;
sub.f32 f1117, f874, f879;
mul.f32 f1118, f1117, 0fBF167918;
sub.f32 f1119, f1118, f1116;
add.f32 f1120, f1119, f1114;
sub.f32 f1121, f1114, f1119;
mul.f32 f1122, f1090, 0f3F4F1BBD;
sub.f32 f1123, f889, f1122;
fma.rn.f32 f1124, f1092, 0f3E9E377A, f1123;
mul.f32 f1125, f1115, 0f3F167918;
mul.f32 f1126, f1117, 0f3F737871;
sub.f32 f1127, f1126, f1125;
add.f32 f1128, f1127, f1124;
sub.f32 f1129, f1124, f1127;
mul.f32 f1130, f970, 0f3F77F511;
mul.f32 f1131, f988, 0fBE7EA890;
sub.f32 f1132, f1130, f1131;
mul.f32 f1133, f988, 0f3F77F511;
fma.rn.f32 f1134, f970, 0fBE7EA890, f1133;
mul.f32 f1135, f1014, 0f3F6055A2;
mul.f32 f1136, f1032, 0fBEF6A86B;
sub.f32 f1137, f1135, f1136;
mul.f32 f1138, f1032, 0f3F6055A2;
fma.rn.f32 f1139, f1014, 0fBEF6A86B, f1138;
mul.f32 f1140, f1058, 0f3F3A9DB0;
mul.f32 f1141, f1076, 0fBF2F3E7B;
sub.f32 f1142, f1140, f1141;
mul.f32 f1143, f1076, 0f3F3A9DB0;
fma.rn.f32 f1144, f1058, 0fBF2F3E7B, f1143;
mul.f32 f1145, f1102, 0f3F092BF2;
mul.f32 f1146, f1120, 0fBF5825E0;
sub.f32 f1147, f1145, f1146;
mul.f32 f1148, f1120, 0f3F092BF2;
fma.rn.f32 f1149, f1102, 0fBF5825E0, f1148;
mul.f32 f1150, f978, 0f3F6055A2;
mul.f32 f1151, f996, 0fBEF6A86B;
sub.f32 f1152, f1150, f1151;
mul.f32 f1153, f996, 0f3F6055A2;
fma.rn.f32 f1154, f978, 0fBEF6A86B, f1153;
mul.f32 f1155, f1022, 0f3F092BF2;
mul.f32 f1156, f1040, 0fBF5825E0;
sub.f32 f1157, f1155, f1156;
mul.f32 f1158, f1040, 0f3F092BF2;
fma.rn.f32 f1159, f1022, 0fBF5825E0, f1158;
mul.f32 f1160, f1066, 0f3D809851;
mul.f32 f1161, f1084, 0fBF7F7EAE;
sub.f32 f1162, f1160, f1161;
mul.f32 f1163, f1084, 0f3D809851;
fma.rn.f32 f1164, f1066, 0fBF7F7EAE, f1163;
mul.f32 f1165, f1110, 0fBED9FFBE;
mul.f32 f1166, f1128, 0fBF67A2BF;
sub.f32 f1167, f1165, f1166;
mul.f32 f1168, f1128, 0fBED9FFBE;
fma.rn.f32 f1169, f1110, 0fBF67A2BF, f1168;
mul.f32 f1170, f979, 0f3F3A9DB0;
mul.f32 f1171, f997, 0fBF2F3E7B;
sub.f32 f1172, f1170, f1171;
mul.f32 f1173, f997, 0f3F3A9DB0;
fma.rn.f32 f1174, f979, 0fBF2F3E7B, f1173;
mul.f32 f1175, f1023, 0f3D809851;
mul.f32 f1176, f1041, 0fBF7F7EAE;
sub.f32 f1177, f1175, f1176;
mul.f32 f1178, f1041, 0f3D809851;
fma.rn.f32 f1179, f1023, 0fBF7F7EAE, f1178;
mul.f32 f1180, f1067, 0fBF232E38;
mul.f32 f1181, f1085, 0fBF45405B;
sub.f32 f1182, f1180, f1181;
mul.f32 f1183, f1085, 0fBF232E38;
fma.rn.f32 f1184, f1067, 0fBF45405B, f1183;
mul.f32 f1185, f1111, 0fBF7DFB3B;
mul.f32 f1186, f1129, 0fBE00575B;
sub.f32 f1187, f1185, f1186;
mul.f32 f1188, f1129, 0fBF7DFB3B;
fma.rn.f32 f1189, f1111, 0fBE00575B, f1188;
mul.f32 f1190, f971, 0f3F092BF2;
mul.f32 f1191, f989, 0fBF5825E0;
sub.f32 f1192, f1190, f1191;
mul.f32 f1193, f989, 0f3F092BF2;
fma.rn.f32 f1194, f971, 0fBF5825E0, f1193;
mul.f32 f1195, f1015, 0fBED9FFBE;
mul.f32 f1196, f1033, 0fBF67A2BF;
sub.f32 f1197, f1195, f1196;
mul.f32 f1198, f1033, 0fBED9FFBE;
fma.rn.f32 f1199, f1015, 0fBF67A2BF, f1198;
mul.f32 f1200, f1059, 0fBF7DFB3B;
mul.f32 f1201, f1077, 0fBE00575B;
sub.f32 f1202, f1200, f1201;
mul.f32 f1203, f1077, 0fBF7DFB3B;
fma.rn.f32 f1204, f1059, 0fBE00575B, f1203;
mul.f32 f1205, f1103, 0fBF232E38;
mul.f32 f1206, f1121, 0f3F45405B;
sub.f32 f1207, f1205, f1206;
mul.f32 f1208, f1121, 0fBF232E38;
fma.rn.f32 f1209, f1103, 0f3F45405B, f1208;
add.f32 f1210, f957, f1089;
add.f32 f1211, f913, f1210;
add.f32 f1212, f1001, f1045;
add.f32 f1213, f1212, f1211;
add.f32 f1214, f961, f1093;
add.f32 f1215, f917, f1214;
add.f32 f1216, f1005, f1049;
add.f32 f1217, f1216, f1215;
fma.rn.f32 f1218, f1210, 0f3E9E377A, f913;
mul.f32 f1219, f1212, 0f3F4F1BBD;
sub.f32 f1220, f1218, f1219;
sub.f32 f1221, f961, f1093;
mul.f32 f1222, f1221, 0f3F737871;
sub.f32 f1223, f1005, f1049;
mul.f32 f1224, f1223, 0fBF167918;
sub.f32 f1225, f1224, f1222;
sub.f32 f1226, f1220, f1225;
add.f32 f1227, f1225, f1220;
mul.f32 f1228, f1210, 0f3F4F1BBD;
sub.f32 f1229, f913, f1228;
fma.rn.f32 f1230, f1212, 0f3E9E377A, f1229;
mul.f32 f1231, f1221, 0f3F167918;
mul.f32 f1232, f1223, 0f3F737871;
sub.f32 f1233, f1232, f1231;
sub.f32 f1234, f1230, f1233;
add.f32 f1235, f1233, f1230;
fma.rn.f32 f1236, f1214, 0f3E9E377A, f917;
mul.f32 f1237, f1216, 0f3F4F1BBD;
sub.f32 f1238, f1236, f1237;
sub.f32 f1239, f957, f1089;
mul.f32 f1240, f1239, 0f3F737871;
sub.f32 f1241, f1001, f1045;
mul.f32 f1242, f1241, 0fBF167918;
sub.f32 f1243, f1242, f1240;
add.f32 f1244, f1243, f1238;
sub.f32 f1245, f1238, f1243;
mul.f32 f1246, f1214, 0f3F4F1BBD;
sub.f32 f1247, f917, f1246;
fma.rn.f32 f1248, f1216, 0f3E9E377A, f1247;
mul.f32 f1249, f1239, 0f3F167918;
mul.f32 f1250, f1241, 0f3F737871;
sub.f32 f1251, f1250, f1249;
add.f32 f1252, f1251, f1248;
sub.f32 f1253, f1248, f1251;
add.f32 f1254, f1132, f1147;
add.f32 f1255, f926, f1254;
add.f32 f1256, f1137, f1142;
add.f32 f1257, f1256, f1255;
add.f32 f1258, f1134, f1149;
add.f32 f1259, f944, f1258;
add.f32 f1260, f1139, f1144;
add.f32 f1261, f1260, f1259;
fma.rn.f32 f1262, f1254, 0f3E9E377A, f926;
mul.f32 f1263, f1256, 0f3F4F1BBD;
sub.f32 f1264, f1262, f1263;
sub.f32 f1265, f1134, f1149;
mul.f32 f1266, f1265, 0f3F737871;
sub.f32 f1267, f1139, f1144;
mul.f32 f1268, f1267, 0fBF167918;
sub.f32 f1269, f1268, f1266;
sub.f32 f1270, f1264, f1269;
add.f32 f1271, f1269, f1264;
mul.f32 f1272, f1254, 0f3F4F1BBD;
sub.f32 f1273, f926, f1272;
fma.rn.f32 f1274, f1256, 0f3E9E377A, f1273;
mul.f32 f1275, f1265, 0f3F167918;
mul.f32 f1276, f1267, 0f3F737871;
sub.f32 f1277, f1276, f1275;
sub.f32 f1278, f1274, f1277;
add.f32 f1279, f1277, f1274;
fma.rn.f32 f1280, f1258, 0f3E9E377A, f944;
mul.f32 f1281, f1260, 0f3F4F1BBD;
sub.f32 f1282, f1280, f1281;
sub.f32 f1283, f1132, f1147;
mul.f32 f1284, f1283, 0f3F737871;
sub.f32 f1285, f1137, f1142;
mul.f32 f1286, f1285, 0fBF167918;
sub.f32 f1287, f1286, f1284;
add.f32 f1288, f1287, f1282;
sub.f32 f1289, f1282, f1287;
mul.f32 f1290, f1258, 0f3F4F1BBD;
sub.f32 f1291, f944, f1290;
fma.rn.f32 f1292, f1260, 0f3E9E377A, f1291;
mul.f32 f1293, f1283, 0f3F167918;
mul.f32 f1294, f1285, 0f3F737871;
sub.f32 f1295, f1294, f1293;
add.f32 f1296, f1295, f1292;
sub.f32 f1297, f1292, f1295;
add.f32 f1298, f1152, f1167;
add.f32 f1299, f934, f1298;
add.f32 f1300, f1157, f1162;
add.f32 f1301, f1300, f1299;
add.f32 f1302, f1154, f1169;
add.f32 f1303, f952, f1302;
add.f32 f1304, f1159, f1164;
add.f32 f1305, f1304, f1303;
fma.rn.f32 f1306, f1298, 0f3E9E377A, f934;
mul.f32 f1307, f1300, 0f3F4F1BBD;
sub.f32 f1308, f1306, f1307;
sub.f32 f1309, f1154, f1169;
mul.f32 f1310, f1309, 0f3F737871;
sub.f32 f1311, f1159, f1164;
mul.f32 f1312, f1311, 0fBF167918;
sub.f32 f1313, f1312, f1310;
sub.f32 f1314, f1308, f1313;
add.f32 f1315, f1313, f1308;
mul.f32 f1316, f1298, 0f3F4F1BBD;
sub.f32 f1317, f934, f1316;
fma.rn.f32 f1318, f1300, 0f3E9E377A, f1317;
mul.f32 f1319, f1309, 0f3F167918;
mul.f32 f1320, f1311, 0f3F737871;
sub.f32 f1321, f1320, f1319;
sub.f32 f1322, f1318, f1321;
add.f32 f1323, f1321, f1318;
fma.rn.f32 f1324, f1302, 0f3E9E377A, f952;
mul.f32 f1325, f1304, 0f3F4F1BBD;
sub.f32 f1326, f1324, f1325;
sub.f32 f1327, f1152, f1167;
mul.f32 f1328, f1327, 0f3F737871;
sub.f32 f1329, f1157, f1162;
mul.f32 f1330, f1329, 0fBF167918;
sub.f32 f1331, f1330, f1328;
add.f32 f1332, f1331, f1326;
sub.f32 f1333, f1326, f1331;
mul.f32 f1334, f1302, 0f3F4F1BBD;
sub.f32 f1335, f952, f1334;
fma.rn.f32 f1336, f1304, 0f3E9E377A, f1335;
mul.f32 f1337, f1327, 0f3F167918;
mul.f32 f1338, f1329, 0f3F737871;
sub.f32 f1339, f1338, f1337;
add.f32 f1340, f1339, f1336;
sub.f32 f1341, f1336, f1339;
add.f32 f1342, f1172, f1187;
add.f32 f1343, f935, f1342;
add.f32 f1344, f1177, f1182;
add.f32 f1345, f1344, f1343;
add.f32 f1346, f1174, f1189;
add.f32 f1347, f953, f1346;
add.f32 f1348, f1179, f1184;
add.f32 f1349, f1348, f1347;
fma.rn.f32 f1350, f1342, 0f3E9E377A, f935;
mul.f32 f1351, f1344, 0f3F4F1BBD;
sub.f32 f1352, f1350, f1351;
sub.f32 f1353, f1174, f1189;
mul.f32 f1354, f1353, 0f3F737871;
sub.f32 f1355, f1179, f1184;
mul.f32 f1356, f1355, 0fBF167918;
sub.f32 f1357, f1356, f1354;
sub.f32 f1358, f1352, f1357;
add.f32 f1359, f1357, f1352;
mul.f32 f1360, f1342, 0f3F4F1BBD;
sub.f32 f1361, f935, f1360;
fma.rn.f32 f1362, f1344, 0f3E9E377A, f1361;
mul.f32 f1363, f1353, 0f3F167918;
mul.f32 f1364, f1355, 0f3F737871;
sub.f32 f1365, f1364, f1363;
sub.f32 f1366, f1362, f1365;
add.f32 f1367, f1365, f1362;
fma.rn.f32 f1368, f1346, 0f3E9E377A, f953;
mul.f32 f1369, f1348, 0f3F4F1BBD;
sub.f32 f1370, f1368, f1369;
sub.f32 f1371, f1172, f1187;
mul.f32 f1372, f1371, 0f3F737871;
sub.f32 f1373, f1177, f1182;
mul.f32 f1374, f1373, 0fBF167918;
sub.f32 f1375, f1374, f1372;
add.f32 f1376, f1375, f1370;
sub.f32 f1377, f1370, f1375;
mul.f32 f1378, f1346, 0f3F4F1BBD;
sub.f32 f1379, f953, f1378;
fma.rn.f32 f1380, f1348, 0f3E9E377A, f1379;
mul.f32 f1381, f1371, 0f3F167918;
mul.f32 f1382, f1373, 0f3F737871;
sub.f32 f1383, f1382, f1381;
add.f32 f1384, f1383, f1380;
sub.f32 f1385, f1380, f1383;
add.f32 f1386, f1192, f1207;
add.f32 f1387, f927, f1386;
add.f32 f1388, f1197, f1202;
add.f32 f1389, f1388, f1387;
add.f32 f1390, f1194, f1209;
add.f32 f1391, f945, f1390;
add.f32 f1392, f1199, f1204;
add.f32 f1393, f1392, f1391;
fma.rn.f32 f1394, f1386, 0f3E9E377A, f927;
mul.f32 f1395, f1388, 0f3F4F1BBD;
sub.f32 f1396, f1394, f1395;
sub.f32 f1397, f1194, f1209;
mul.f32 f1398, f1397, 0f3F737871;
sub.f32 f1399, f1199, f1204;
mul.f32 f1400, f1399, 0fBF167918;
sub.f32 f1401, f1400, f1398;
sub.f32 f1402, f1396, f1401;
add.f32 f1403, f1401, f1396;
mul.f32 f1404, f1386, 0f3F4F1BBD;
sub.f32 f1405, f927, f1404;
fma.rn.f32 f1406, f1388, 0f3E9E377A, f1405;
mul.f32 f1407, f1397, 0f3F167918;
mul.f32 f1408, f1399, 0f3F737871;
sub.f32 f1409, f1408, f1407;
sub.f32 f1410, f1406, f1409;
add.f32 f1411, f1409, f1406;
fma.rn.f32 f1412, f1390, 0f3E9E377A, f945;
mul.f32 f1413, f1392, 0f3F4F1BBD;
sub.f32 f1414, f1412, f1413;
sub.f32 f1415, f1192, f1207;
mul.f32 f1416, f1415, 0f3F737871;
sub.f32 f1417, f1197, f1202;
mul.f32 f1418, f1417, 0fBF167918;
sub.f32 f1419, f1418, f1416;
add.f32 f1420, f1419, f1414;
sub.f32 f1421, f1414, f1419;
mul.f32 f1422, f1390, 0f3F4F1BBD;
sub.f32 f1423, f945, f1422;
fma.rn.f32 f1424, f1392, 0f3E9E377A, f1423;
mul.f32 f1425, f1415, 0f3F167918;
mul.f32 f1426, f1417, 0f3F737871;
sub.f32 f1427, f1426, f1425;
add.f32 f1428, f1427, f1424;
sub.f32 f1429, f1424, f1427;
mul.wide.u32 rd7, r7, 1374389535;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 25;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 8;
mov.u64 rd10, %52;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f1430, f1431}, [rd11];
mul.f32 f1434, f1430, f1257;
mul.f32 f1435, f1431, f1261;
sub.f32 f1436, f1434, f1435;
mul.f32 f1437, f1430, f1261;
fma.rn.f32 f1438, f1431, f1257, f1437;
mul.f32 f1439, f1430, f1430;
mul.f32 f1440, f1431, f1431;
sub.f32 f1441, f1439, f1440;
mul.f32 f1442, f1431, f1430;
fma.rn.f32 f1443, f1431, f1430, f1442;
mul.f32 f1444, f1441, f1301;
mul.f32 f1445, f1443, f1305;
sub.f32 f1446, f1444, f1445;
mul.f32 f1447, f1441, f1305;
fma.rn.f32 f1448, f1443, f1301, f1447;
mul.f32 f1449, f1430, f1441;
mul.f32 f1450, f1431, f1443;
sub.f32 f1451, f1449, f1450;
mul.f32 f1452, f1430, f1443;
fma.rn.f32 f1453, f1431, f1441, f1452;
mul.f32 f1454, f1451, f1345;
mul.f32 f1455, f1453, f1349;
sub.f32 f1456, f1454, f1455;
mul.f32 f1457, f1451, f1349;
fma.rn.f32 f1458, f1453, f1345, f1457;
mul.f32 f1459, f1430, f1451;
mul.f32 f1460, f1431, f1453;
sub.f32 f1461, f1459, f1460;
mul.f32 f1462, f1430, f1453;
fma.rn.f32 f1463, f1431, f1451, f1462;
mul.f32 f1464, f1461, f1389;
mul.f32 f1465, f1463, f1393;
sub.f32 f1466, f1464, f1465;
mul.f32 f1467, f1461, f1393;
fma.rn.f32 f1468, f1463, f1389, f1467;
mul.f32 f1469, f1430, f1461;
mul.f32 f1470, f1431, f1463;
sub.f32 f1471, f1469, f1470;
mul.f32 f1472, f1430, f1463;
fma.rn.f32 f1473, f1431, f1461, f1472;
mul.f32 f1474, f1471, f1226;
mul.f32 f1475, f1473, f1244;
sub.f32 f1476, f1474, f1475;
mul.f32 f1477, f1471, f1244;
fma.rn.f32 f1478, f1473, f1226, f1477;
mul.f32 f1479, f1430, f1471;
mul.f32 f1480, f1431, f1473;
sub.f32 f1481, f1479, f1480;
mul.f32 f1482, f1430, f1473;
fma.rn.f32 f1483, f1431, f1471, f1482;
mul.f32 f1484, f1481, f1270;
mul.f32 f1485, f1483, f1288;
sub.f32 f1486, f1484, f1485;
mul.f32 f1487, f1481, f1288;
fma.rn.f32 f1488, f1483, f1270, f1487;
mul.f32 f1489, f1430, f1481;
mul.f32 f1490, f1431, f1483;
sub.f32 f1491, f1489, f1490;
mul.f32 f1492, f1430, f1483;
fma.rn.f32 f1493, f1431, f1481, f1492;
mul.f32 f1494, f1491, f1314;
mul.f32 f1495, f1493, f1332;
sub.f32 f1496, f1494, f1495;
mul.f32 f1497, f1491, f1332;
fma.rn.f32 f1498, f1493, f1314, f1497;
mul.f32 f1499, f1430, f1491;
mul.f32 f1500, f1431, f1493;
sub.f32 f1501, f1499, f1500;
mul.f32 f1502, f1430, f1493;
fma.rn.f32 f1503, f1431, f1491, f1502;
mul.f32 f1504, f1501, f1358;
mul.f32 f1505, f1503, f1376;
sub.f32 f1506, f1504, f1505;
mul.f32 f1507, f1501, f1376;
fma.rn.f32 f1508, f1503, f1358, f1507;
mul.f32 f1509, f1430, f1501;
mul.f32 f1510, f1431, f1503;
sub.f32 f1511, f1509, f1510;
mul.f32 f1512, f1430, f1503;
fma.rn.f32 f1513, f1431, f1501, f1512;
mul.f32 f1514, f1511, f1402;
mul.f32 f1515, f1513, f1420;
sub.f32 f1516, f1514, f1515;
mul.f32 f1517, f1511, f1420;
fma.rn.f32 f1518, f1513, f1402, f1517;
mul.f32 f1519, f1430, f1511;
mul.f32 f1520, f1431, f1513;
sub.f32 f1521, f1519, f1520;
mul.f32 f1522, f1430, f1513;
fma.rn.f32 f1523, f1431, f1511, f1522;
mul.f32 f1524, f1521, f1234;
mul.f32 f1525, f1523, f1252;
sub.f32 f1526, f1524, f1525;
mul.f32 f1527, f1521, f1252;
fma.rn.f32 f1528, f1523, f1234, f1527;
mul.f32 f1529, f1430, f1521;
mul.f32 f1530, f1431, f1523;
sub.f32 f1531, f1529, f1530;
mul.f32 f1532, f1430, f1523;
fma.rn.f32 f1533, f1431, f1521, f1532;
mul.f32 f1534, f1531, f1278;
mul.f32 f1535, f1533, f1296;
sub.f32 f1536, f1534, f1535;
mul.f32 f1537, f1531, f1296;
fma.rn.f32 f1538, f1533, f1278, f1537;
mul.f32 f1539, f1430, f1531;
mul.f32 f1540, f1431, f1533;
sub.f32 f1541, f1539, f1540;
mul.f32 f1542, f1430, f1533;
fma.rn.f32 f1543, f1431, f1531, f1542;
mul.f32 f1544, f1541, f1322;
mul.f32 f1545, f1543, f1340;
sub.f32 f1546, f1544, f1545;
mul.f32 f1547, f1541, f1340;
fma.rn.f32 f1548, f1543, f1322, f1547;
mul.f32 f1549, f1430, f1541;
mul.f32 f1550, f1431, f1543;
sub.f32 f1551, f1549, f1550;
mul.f32 f1552, f1430, f1543;
fma.rn.f32 f1553, f1431, f1541, f1552;
mul.f32 f1554, f1551, f1366;
mul.f32 f1555, f1553, f1384;
sub.f32 f1556, f1554, f1555;
mul.f32 f1557, f1551, f1384;
fma.rn.f32 f1558, f1553, f1366, f1557;
mul.f32 f1559, f1430, f1551;
mul.f32 f1560, f1431, f1553;
sub.f32 f1561, f1559, f1560;
mul.f32 f1562, f1430, f1553;
fma.rn.f32 f1563, f1431, f1551, f1562;
mul.f32 f1564, f1561, f1410;
mul.f32 f1565, f1563, f1428;
sub.f32 f1566, f1564, f1565;
mul.f32 f1567, f1561, f1428;
fma.rn.f32 f1568, f1563, f1410, f1567;
mul.f32 f1569, f1430, f1561;
mul.f32 f1570, f1431, f1563;
sub.f32 f1571, f1569, f1570;
mul.f32 f1572, f1430, f1563;
fma.rn.f32 f1573, f1431, f1561, f1572;
mul.f32 f1574, f1571, f1235;
mul.f32 f1575, f1573, f1253;
sub.f32 f1576, f1574, f1575;
mul.f32 f1577, f1571, f1253;
fma.rn.f32 f1578, f1573, f1235, f1577;
mul.f32 f1579, f1430, f1571;
mul.f32 f1580, f1431, f1573;
sub.f32 f1581, f1579, f1580;
mul.f32 f1582, f1430, f1573;
fma.rn.f32 f1583, f1431, f1571, f1582;
mul.f32 f1584, f1581, f1279;
mul.f32 f1585, f1583, f1297;
sub.f32 f1586, f1584, f1585;
mul.f32 f1587, f1581, f1297;
fma.rn.f32 f1588, f1583, f1279, f1587;
mul.f32 f1589, f1430, f1581;
mul.f32 f1590, f1431, f1583;
sub.f32 f1591, f1589, f1590;
mul.f32 f1592, f1430, f1583;
fma.rn.f32 f1593, f1431, f1581, f1592;
mul.f32 f1594, f1591, f1323;
mul.f32 f1595, f1593, f1341;
sub.f32 f1596, f1594, f1595;
mul.f32 f1597, f1591, f1341;
fma.rn.f32 f1598, f1593, f1323, f1597;
mul.f32 f1599, f1430, f1591;
mul.f32 f1600, f1431, f1593;
sub.f32 f1601, f1599, f1600;
mul.f32 f1602, f1430, f1593;
fma.rn.f32 f1603, f1431, f1591, f1602;
mul.f32 f1604, f1601, f1367;
mul.f32 f1605, f1603, f1385;
sub.f32 f1606, f1604, f1605;
mul.f32 f1607, f1601, f1385;
fma.rn.f32 f1608, f1603, f1367, f1607;
mul.f32 f1609, f1430, f1601;
mul.f32 f1610, f1431, f1603;
sub.f32 f1611, f1609, f1610;
mul.f32 f1612, f1430, f1603;
fma.rn.f32 f1613, f1431, f1601, f1612;
mul.f32 f1614, f1611, f1411;
mul.f32 f1615, f1613, f1429;
sub.f32 f1616, f1614, f1615;
mul.f32 f1617, f1611, f1429;
fma.rn.f32 f1618, f1613, f1411, f1617;
mul.f32 f1619, f1430, f1611;
mul.f32 f1620, f1431, f1613;
sub.f32 f1621, f1619, f1620;
mul.f32 f1622, f1430, f1613;
fma.rn.f32 f1623, f1431, f1611, f1622;
mul.f32 f1624, f1621, f1227;
mul.f32 f1625, f1623, f1245;
sub.f32 f1626, f1624, f1625;
mul.f32 f1627, f1621, f1245;
fma.rn.f32 f1628, f1623, f1227, f1627;
mul.f32 f1629, f1430, f1621;
mul.f32 f1630, f1431, f1623;
sub.f32 f1631, f1629, f1630;
mul.f32 f1632, f1430, f1623;
fma.rn.f32 f1633, f1431, f1621, f1632;
mul.f32 f1634, f1631, f1271;
mul.f32 f1635, f1633, f1289;
sub.f32 f1636, f1634, f1635;
mul.f32 f1637, f1631, f1289;
fma.rn.f32 f1638, f1633, f1271, f1637;
mul.f32 f1639, f1430, f1631;
mul.f32 f1640, f1431, f1633;
sub.f32 f1641, f1639, f1640;
mul.f32 f1642, f1430, f1633;
fma.rn.f32 f1643, f1431, f1631, f1642;
mul.f32 f1644, f1641, f1315;
mul.f32 f1645, f1643, f1333;
sub.f32 f1646, f1644, f1645;
mul.f32 f1647, f1641, f1333;
fma.rn.f32 f1648, f1643, f1315, f1647;
mul.f32 f1649, f1430, f1641;
mul.f32 f1650, f1431, f1643;
sub.f32 f1651, f1649, f1650;
mul.f32 f1652, f1430, f1643;
fma.rn.f32 f1653, f1431, f1641, f1652;
mul.f32 f1654, f1651, f1359;
mul.f32 f1655, f1653, f1377;
sub.f32 f1656, f1654, f1655;
mul.f32 f1657, f1651, f1377;
fma.rn.f32 f1658, f1653, f1359, f1657;
mul.f32 f1659, f1430, f1651;
mul.f32 f1660, f1431, f1653;
sub.f32 f1661, f1659, f1660;
mul.f32 f1662, f1430, f1653;
fma.rn.f32 f1663, f1431, f1651, f1662;
mul.f32 f1664, f1661, f1403;
mul.f32 f1665, f1663, f1421;
sub.f32 f1666, f1664, f1665;
mul.f32 f1667, f1661, f1421;
fma.rn.f32 f1668, f1663, f1403, f1667;
shl.b32 r14, r13, 2;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 2500, r15;
st.shared.f32 [r16], f1213;
st.shared.f32 [r16+100], f1436;
st.shared.f32 [r16+200], f1446;
st.shared.f32 [r16+300], f1456;
st.shared.f32 [r16+400], f1466;
st.shared.f32 [r16+500], f1476;
st.shared.f32 [r16+600], f1486;
st.shared.f32 [r16+700], f1496;
st.shared.f32 [r16+800], f1506;
st.shared.f32 [r16+900], f1516;
st.shared.f32 [r16+1000], f1526;
st.shared.f32 [r16+1100], f1536;
st.shared.f32 [r16+1200], f1546;
st.shared.f32 [r16+1300], f1556;
st.shared.f32 [r16+1400], f1566;
st.shared.f32 [r16+1500], f1576;
st.shared.f32 [r16+1600], f1586;
st.shared.f32 [r16+1700], f1596;
st.shared.f32 [r16+1800], f1606;
st.shared.f32 [r16+1900], f1616;
st.shared.f32 [r16+2000], f1626;
st.shared.f32 [r16+2100], f1636;
st.shared.f32 [r16+2200], f1646;
st.shared.f32 [r16+2300], f1656;
st.shared.f32 [r16+2400], f1666;
barrier.sync 0;
ld.shared.f32 f1669, [r10];
ld.shared.f32 f1670, [r10+2500];
ld.shared.f32 f1671, [r10+5000];
ld.shared.f32 f1672, [r10+7500];
ld.shared.f32 f1673, [r10+10000];
ld.shared.f32 f1674, [r10+12500];
ld.shared.f32 f1675, [r10+15000];
ld.shared.f32 f1676, [r10+17500];
ld.shared.f32 f1677, [r10+20000];
ld.shared.f32 f1678, [r10+22500];
ld.shared.f32 f1679, [r10+25000];
ld.shared.f32 f1680, [r10+27500];
ld.shared.f32 f1681, [r10+30000];
ld.shared.f32 f1682, [r10+32500];
ld.shared.f32 f1683, [r10+35000];
ld.shared.f32 f1684, [r10+37500];
ld.shared.f32 f1685, [r10+40000];
ld.shared.f32 f1686, [r10+42500];
ld.shared.f32 f1687, [r10+45000];
ld.shared.f32 f1688, [r10+47500];
ld.shared.f32 f1689, [r10+50000];
ld.shared.f32 f1690, [r10+52500];
ld.shared.f32 f1691, [r10+55000];
ld.shared.f32 f1692, [r10+57500];
ld.shared.f32 f1693, [r10+60000];
barrier.sync 0;
st.shared.f32 [r16], f1217;
st.shared.f32 [r16+100], f1438;
st.shared.f32 [r16+200], f1448;
st.shared.f32 [r16+300], f1458;
st.shared.f32 [r16+400], f1468;
st.shared.f32 [r16+500], f1478;
st.shared.f32 [r16+600], f1488;
st.shared.f32 [r16+700], f1498;
st.shared.f32 [r16+800], f1508;
st.shared.f32 [r16+900], f1518;
st.shared.f32 [r16+1000], f1528;
st.shared.f32 [r16+1100], f1538;
st.shared.f32 [r16+1200], f1548;
st.shared.f32 [r16+1300], f1558;
st.shared.f32 [r16+1400], f1568;
st.shared.f32 [r16+1500], f1578;
st.shared.f32 [r16+1600], f1588;
st.shared.f32 [r16+1700], f1598;
st.shared.f32 [r16+1800], f1608;
st.shared.f32 [r16+1900], f1618;
st.shared.f32 [r16+2000], f1628;
st.shared.f32 [r16+2100], f1638;
st.shared.f32 [r16+2200], f1648;
st.shared.f32 [r16+2300], f1658;
st.shared.f32 [r16+2400], f1668;
barrier.sync 0;
ld.shared.f32 f1694, [r10];
ld.shared.f32 f1695, [r10+2500];
ld.shared.f32 f1696, [r10+5000];
ld.shared.f32 f1697, [r10+7500];
ld.shared.f32 f1698, [r10+10000];
ld.shared.f32 f1699, [r10+12500];
ld.shared.f32 f1700, [r10+15000];
ld.shared.f32 f1701, [r10+17500];
ld.shared.f32 f1702, [r10+20000];
ld.shared.f32 f1703, [r10+22500];
ld.shared.f32 f1704, [r10+25000];
ld.shared.f32 f1705, [r10+27500];
ld.shared.f32 f1706, [r10+30000];
ld.shared.f32 f1707, [r10+32500];
ld.shared.f32 f1708, [r10+35000];
ld.shared.f32 f1709, [r10+37500];
ld.shared.f32 f1710, [r10+40000];
ld.shared.f32 f1711, [r10+42500];
ld.shared.f32 f1712, [r10+45000];
ld.shared.f32 f1713, [r10+47500];
ld.shared.f32 f1714, [r10+50000];
ld.shared.f32 f1715, [r10+52500];
ld.shared.f32 f1716, [r10+55000];
ld.shared.f32 f1717, [r10+57500];
ld.shared.f32 f1718, [r10+60000];
add.f32 f1719, f1674, f1689;
add.f32 f1720, f1669, f1719;
add.f32 f1721, f1679, f1684;
add.f32 f1722, f1721, f1720;
add.f32 f1723, f1699, f1714;
add.f32 f1724, f1694, f1723;
add.f32 f1725, f1704, f1709;
add.f32 f1726, f1725, f1724;
fma.rn.f32 f1727, f1719, 0f3E9E377A, f1669;
mul.f32 f1728, f1721, 0f3F4F1BBD;
sub.f32 f1729, f1727, f1728;
sub.f32 f1730, f1699, f1714;
mul.f32 f1731, f1730, 0f3F737871;
sub.f32 f1732, f1704, f1709;
mul.f32 f1733, f1732, 0fBF167918;
sub.f32 f1734, f1733, f1731;
sub.f32 f1735, f1729, f1734;
add.f32 f1736, f1734, f1729;
mul.f32 f1737, f1719, 0f3F4F1BBD;
sub.f32 f1738, f1669, f1737;
fma.rn.f32 f1739, f1721, 0f3E9E377A, f1738;
mul.f32 f1740, f1730, 0f3F167918;
mul.f32 f1741, f1732, 0f3F737871;
sub.f32 f1742, f1741, f1740;
sub.f32 f1743, f1739, f1742;
add.f32 f1744, f1742, f1739;
fma.rn.f32 f1745, f1723, 0f3E9E377A, f1694;
mul.f32 f1746, f1725, 0f3F4F1BBD;
sub.f32 f1747, f1745, f1746;
sub.f32 f1748, f1674, f1689;
mul.f32 f1749, f1748, 0f3F737871;
sub.f32 f1750, f1679, f1684;
mul.f32 f1751, f1750, 0fBF167918;
sub.f32 f1752, f1751, f1749;
add.f32 f1753, f1752, f1747;
sub.f32 f1754, f1747, f1752;
mul.f32 f1755, f1723, 0f3F4F1BBD;
sub.f32 f1756, f1694, f1755;
fma.rn.f32 f1757, f1725, 0f3E9E377A, f1756;
mul.f32 f1758, f1748, 0f3F167918;
mul.f32 f1759, f1750, 0f3F737871;
sub.f32 f1760, f1759, f1758;
add.f32 f1761, f1760, f1757;
sub.f32 f1762, f1757, f1760;
add.f32 f1763, f1675, f1690;
add.f32 f1764, f1670, f1763;
add.f32 f1765, f1680, f1685;
add.f32 f1766, f1765, f1764;
add.f32 f1767, f1700, f1715;
add.f32 f1768, f1695, f1767;
add.f32 f1769, f1705, f1710;
add.f32 f1770, f1769, f1768;
fma.rn.f32 f1771, f1763, 0f3E9E377A, f1670;
mul.f32 f1772, f1765, 0f3F4F1BBD;
sub.f32 f1773, f1771, f1772;
sub.f32 f1774, f1700, f1715;
mul.f32 f1775, f1774, 0f3F737871;
sub.f32 f1776, f1705, f1710;
mul.f32 f1777, f1776, 0fBF167918;
sub.f32 f1778, f1777, f1775;
sub.f32 f1779, f1773, f1778;
add.f32 f1780, f1778, f1773;
mul.f32 f1781, f1763, 0f3F4F1BBD;
sub.f32 f1782, f1670, f1781;
fma.rn.f32 f1783, f1765, 0f3E9E377A, f1782;
mul.f32 f1784, f1774, 0f3F167918;
mul.f32 f1785, f1776, 0f3F737871;
sub.f32 f1786, f1785, f1784;
sub.f32 f1787, f1783, f1786;
add.f32 f1788, f1786, f1783;
fma.rn.f32 f1789, f1767, 0f3E9E377A, f1695;
mul.f32 f1790, f1769, 0f3F4F1BBD;
sub.f32 f1791, f1789, f1790;
sub.f32 f1792, f1675, f1690;
mul.f32 f1793, f1792, 0f3F737871;
sub.f32 f1794, f1680, f1685;
mul.f32 f1795, f1794, 0fBF167918;
sub.f32 f1796, f1795, f1793;
add.f32 f1797, f1796, f1791;
sub.f32 f1798, f1791, f1796;
mul.f32 f1799, f1767, 0f3F4F1BBD;
sub.f32 f1800, f1695, f1799;
fma.rn.f32 f1801, f1769, 0f3E9E377A, f1800;
mul.f32 f1802, f1792, 0f3F167918;
mul.f32 f1803, f1794, 0f3F737871;
sub.f32 f1804, f1803, f1802;
add.f32 f1805, f1804, f1801;
sub.f32 f1806, f1801, f1804;
add.f32 f1807, f1676, f1691;
add.f32 f1808, f1671, f1807;
add.f32 f1809, f1681, f1686;
add.f32 f1810, f1809, f1808;
add.f32 f1811, f1701, f1716;
add.f32 f1812, f1696, f1811;
add.f32 f1813, f1706, f1711;
add.f32 f1814, f1813, f1812;
fma.rn.f32 f1815, f1807, 0f3E9E377A, f1671;
mul.f32 f1816, f1809, 0f3F4F1BBD;
sub.f32 f1817, f1815, f1816;
sub.f32 f1818, f1701, f1716;
mul.f32 f1819, f1818, 0f3F737871;
sub.f32 f1820, f1706, f1711;
mul.f32 f1821, f1820, 0fBF167918;
sub.f32 f1822, f1821, f1819;
sub.f32 f1823, f1817, f1822;
add.f32 f1824, f1822, f1817;
mul.f32 f1825, f1807, 0f3F4F1BBD;
sub.f32 f1826, f1671, f1825;
fma.rn.f32 f1827, f1809, 0f3E9E377A, f1826;
mul.f32 f1828, f1818, 0f3F167918;
mul.f32 f1829, f1820, 0f3F737871;
sub.f32 f1830, f1829, f1828;
sub.f32 f1831, f1827, f1830;
add.f32 f1832, f1830, f1827;
fma.rn.f32 f1833, f1811, 0f3E9E377A, f1696;
mul.f32 f1834, f1813, 0f3F4F1BBD;
sub.f32 f1835, f1833, f1834;
sub.f32 f1836, f1676, f1691;
mul.f32 f1837, f1836, 0f3F737871;
sub.f32 f1838, f1681, f1686;
mul.f32 f1839, f1838, 0fBF167918;
sub.f32 f1840, f1839, f1837;
add.f32 f1841, f1840, f1835;
sub.f32 f1842, f1835, f1840;
mul.f32 f1843, f1811, 0f3F4F1BBD;
sub.f32 f1844, f1696, f1843;
fma.rn.f32 f1845, f1813, 0f3E9E377A, f1844;
mul.f32 f1846, f1836, 0f3F167918;
mul.f32 f1847, f1838, 0f3F737871;
sub.f32 f1848, f1847, f1846;
add.f32 f1849, f1848, f1845;
sub.f32 f1850, f1845, f1848;
add.f32 f1851, f1677, f1692;
add.f32 f1852, f1672, f1851;
add.f32 f1853, f1682, f1687;
add.f32 f1854, f1853, f1852;
add.f32 f1855, f1702, f1717;
add.f32 f1856, f1697, f1855;
add.f32 f1857, f1707, f1712;
add.f32 f1858, f1857, f1856;
fma.rn.f32 f1859, f1851, 0f3E9E377A, f1672;
mul.f32 f1860, f1853, 0f3F4F1BBD;
sub.f32 f1861, f1859, f1860;
sub.f32 f1862, f1702, f1717;
mul.f32 f1863, f1862, 0f3F737871;
sub.f32 f1864, f1707, f1712;
mul.f32 f1865, f1864, 0fBF167918;
sub.f32 f1866, f1865, f1863;
sub.f32 f1867, f1861, f1866;
add.f32 f1868, f1866, f1861;
mul.f32 f1869, f1851, 0f3F4F1BBD;
sub.f32 f1870, f1672, f1869;
fma.rn.f32 f1871, f1853, 0f3E9E377A, f1870;
mul.f32 f1872, f1862, 0f3F167918;
mul.f32 f1873, f1864, 0f3F737871;
sub.f32 f1874, f1873, f1872;
sub.f32 f1875, f1871, f1874;
add.f32 f1876, f1874, f1871;
fma.rn.f32 f1877, f1855, 0f3E9E377A, f1697;
mul.f32 f1878, f1857, 0f3F4F1BBD;
sub.f32 f1879, f1877, f1878;
sub.f32 f1880, f1677, f1692;
mul.f32 f1881, f1880, 0f3F737871;
sub.f32 f1882, f1682, f1687;
mul.f32 f1883, f1882, 0fBF167918;
sub.f32 f1884, f1883, f1881;
add.f32 f1885, f1884, f1879;
sub.f32 f1886, f1879, f1884;
mul.f32 f1887, f1855, 0f3F4F1BBD;
sub.f32 f1888, f1697, f1887;
fma.rn.f32 f1889, f1857, 0f3E9E377A, f1888;
mul.f32 f1890, f1880, 0f3F167918;
mul.f32 f1891, f1882, 0f3F737871;
sub.f32 f1892, f1891, f1890;
add.f32 f1893, f1892, f1889;
sub.f32 f1894, f1889, f1892;
add.f32 f1895, f1678, f1693;
add.f32 f1896, f1673, f1895;
add.f32 f1897, f1683, f1688;
add.f32 f1898, f1897, f1896;
add.f32 f1899, f1703, f1718;
add.f32 f1900, f1698, f1899;
add.f32 f1901, f1708, f1713;
add.f32 f1902, f1901, f1900;
fma.rn.f32 f1903, f1895, 0f3E9E377A, f1673;
mul.f32 f1904, f1897, 0f3F4F1BBD;
sub.f32 f1905, f1903, f1904;
sub.f32 f1906, f1703, f1718;
mul.f32 f1907, f1906, 0f3F737871;
sub.f32 f1908, f1708, f1713;
mul.f32 f1909, f1908, 0fBF167918;
sub.f32 f1910, f1909, f1907;
sub.f32 f1911, f1905, f1910;
add.f32 f1912, f1910, f1905;
mul.f32 f1913, f1895, 0f3F4F1BBD;
sub.f32 f1914, f1673, f1913;
fma.rn.f32 f1915, f1897, 0f3E9E377A, f1914;
mul.f32 f1916, f1906, 0f3F167918;
mul.f32 f1917, f1908, 0f3F737871;
sub.f32 f1918, f1917, f1916;
sub.f32 f1919, f1915, f1918;
add.f32 f1920, f1918, f1915;
fma.rn.f32 f1921, f1899, 0f3E9E377A, f1698;
mul.f32 f1922, f1901, 0f3F4F1BBD;
sub.f32 f1923, f1921, f1922;
sub.f32 f1924, f1678, f1693;
mul.f32 f1925, f1924, 0f3F737871;
sub.f32 f1926, f1683, f1688;
mul.f32 f1927, f1926, 0fBF167918;
sub.f32 f1928, f1927, f1925;
add.f32 f1929, f1928, f1923;
sub.f32 f1930, f1923, f1928;
mul.f32 f1931, f1899, 0f3F4F1BBD;
sub.f32 f1932, f1698, f1931;
fma.rn.f32 f1933, f1901, 0f3E9E377A, f1932;
mul.f32 f1934, f1924, 0f3F167918;
mul.f32 f1935, f1926, 0f3F737871;
sub.f32 f1936, f1935, f1934;
add.f32 f1937, f1936, f1933;
sub.f32 f1938, f1933, f1936;
mul.f32 f1939, f1779, 0f3F77F511;
mul.f32 f1940, f1797, 0fBE7EA890;
sub.f32 f1941, f1939, f1940;
mul.f32 f1942, f1797, 0f3F77F511;
fma.rn.f32 f1943, f1779, 0fBE7EA890, f1942;
mul.f32 f1944, f1823, 0f3F6055A2;
mul.f32 f1945, f1841, 0fBEF6A86B;
sub.f32 f1946, f1944, f1945;
mul.f32 f1947, f1841, 0f3F6055A2;
fma.rn.f32 f1948, f1823, 0fBEF6A86B, f1947;
mul.f32 f1949, f1867, 0f3F3A9DB0;
mul.f32 f1950, f1885, 0fBF2F3E7B;
sub.f32 f1951, f1949, f1950;
mul.f32 f1952, f1885, 0f3F3A9DB0;
fma.rn.f32 f1953, f1867, 0fBF2F3E7B, f1952;
mul.f32 f1954, f1911, 0f3F092BF2;
mul.f32 f1955, f1929, 0fBF5825E0;
sub.f32 f1956, f1954, f1955;
mul.f32 f1957, f1929, 0f3F092BF2;
fma.rn.f32 f1958, f1911, 0fBF5825E0, f1957;
mul.f32 f1959, f1787, 0f3F6055A2;
mul.f32 f1960, f1805, 0fBEF6A86B;
sub.f32 f1961, f1959, f1960;
mul.f32 f1962, f1805, 0f3F6055A2;
fma.rn.f32 f1963, f1787, 0fBEF6A86B, f1962;
mul.f32 f1964, f1831, 0f3F092BF2;
mul.f32 f1965, f1849, 0fBF5825E0;
sub.f32 f1966, f1964, f1965;
mul.f32 f1967, f1849, 0f3F092BF2;
fma.rn.f32 f1968, f1831, 0fBF5825E0, f1967;
mul.f32 f1969, f1875, 0f3D809851;
mul.f32 f1970, f1893, 0fBF7F7EAE;
sub.f32 f1971, f1969, f1970;
mul.f32 f1972, f1893, 0f3D809851;
fma.rn.f32 f1973, f1875, 0fBF7F7EAE, f1972;
mul.f32 f1974, f1919, 0fBED9FFBE;
mul.f32 f1975, f1937, 0fBF67A2BF;
sub.f32 f1976, f1974, f1975;
mul.f32 f1977, f1937, 0fBED9FFBE;
fma.rn.f32 f1978, f1919, 0fBF67A2BF, f1977;
mul.f32 f1979, f1788, 0f3F3A9DB0;
mul.f32 f1980, f1806, 0fBF2F3E7B;
sub.f32 f1981, f1979, f1980;
mul.f32 f1982, f1806, 0f3F3A9DB0;
fma.rn.f32 f1983, f1788, 0fBF2F3E7B, f1982;
mul.f32 f1984, f1832, 0f3D809851;
mul.f32 f1985, f1850, 0fBF7F7EAE;
sub.f32 f1986, f1984, f1985;
mul.f32 f1987, f1850, 0f3D809851;
fma.rn.f32 f1988, f1832, 0fBF7F7EAE, f1987;
mul.f32 f1989, f1876, 0fBF232E38;
mul.f32 f1990, f1894, 0fBF45405B;
sub.f32 f1991, f1989, f1990;
mul.f32 f1992, f1894, 0fBF232E38;
fma.rn.f32 f1993, f1876, 0fBF45405B, f1992;
mul.f32 f1994, f1920, 0fBF7DFB3B;
mul.f32 f1995, f1938, 0fBE00575B;
sub.f32 f1996, f1994, f1995;
mul.f32 f1997, f1938, 0fBF7DFB3B;
fma.rn.f32 f1998, f1920, 0fBE00575B, f1997;
mul.f32 f1999, f1780, 0f3F092BF2;
mul.f32 f2000, f1798, 0fBF5825E0;
sub.f32 f2001, f1999, f2000;
mul.f32 f2002, f1798, 0f3F092BF2;
fma.rn.f32 f2003, f1780, 0fBF5825E0, f2002;
mul.f32 f2004, f1824, 0fBED9FFBE;
mul.f32 f2005, f1842, 0fBF67A2BF;
sub.f32 f2006, f2004, f2005;
mul.f32 f2007, f1842, 0fBED9FFBE;
fma.rn.f32 f2008, f1824, 0fBF67A2BF, f2007;
mul.f32 f2009, f1868, 0fBF7DFB3B;
mul.f32 f2010, f1886, 0fBE00575B;
sub.f32 f2011, f2009, f2010;
mul.f32 f2012, f1886, 0fBF7DFB3B;
fma.rn.f32 f2013, f1868, 0fBE00575B, f2012;
mul.f32 f2014, f1912, 0fBF232E38;
mul.f32 f2015, f1930, 0f3F45405B;
sub.f32 f2016, f2014, f2015;
mul.f32 f2017, f1930, 0fBF232E38;
fma.rn.f32 f2018, f1912, 0f3F45405B, f2017;
add.f32 f2019, f1766, f1898;
add.f32 f2020, f1722, f2019;
add.f32 f2021, f1810, f1854;
add.f32 f2022, f1770, f1902;
add.f32 f2023, f1726, f2022;
add.f32 f2024, f1814, f1858;
fma.rn.f32 f2025, f2019, 0f3E9E377A, f1722;
mul.f32 f2026, f2021, 0f3F4F1BBD;
sub.f32 f2027, f2025, f2026;
sub.f32 f2028, f1770, f1902;
mul.f32 f2029, f2028, 0f3F737871;
sub.f32 f2030, f1814, f1858;
mul.f32 f2031, f2030, 0fBF167918;
sub.f32 f2032, f2031, f2029;
mul.f32 f2033, f2019, 0f3F4F1BBD;
sub.f32 f2034, f1722, f2033;
fma.rn.f32 f2035, f2021, 0f3E9E377A, f2034;
mul.f32 f2036, f2028, 0f3F167918;
mul.f32 f2037, f2030, 0f3F737871;
sub.f32 f2038, f2037, f2036;
fma.rn.f32 f2039, f2022, 0f3E9E377A, f1726;
mul.f32 f2040, f2024, 0f3F4F1BBD;
sub.f32 f2041, f2039, f2040;
sub.f32 f2042, f1766, f1898;
mul.f32 f2043, f2042, 0f3F737871;
sub.f32 f2044, f1810, f1854;
mul.f32 f2045, f2044, 0fBF167918;
sub.f32 f2046, f2045, f2043;
mul.f32 f2047, f2022, 0f3F4F1BBD;
sub.f32 f2048, f1726, f2047;
fma.rn.f32 f2049, f2024, 0f3E9E377A, f2048;
mul.f32 f2050, f2042, 0f3F167918;
mul.f32 f2051, f2044, 0f3F737871;
sub.f32 f2052, f2051, f2050;
add.f32 f2053, f1941, f1956;
add.f32 f2054, f1735, f2053;
add.f32 f2055, f1946, f1951;
add.f32 f2056, f1943, f1958;
add.f32 f2057, f1753, f2056;
add.f32 f2058, f1948, f1953;
fma.rn.f32 f2059, f2053, 0f3E9E377A, f1735;
mul.f32 f2060, f2055, 0f3F4F1BBD;
sub.f32 f2061, f2059, f2060;
sub.f32 f2062, f1943, f1958;
mul.f32 f2063, f2062, 0f3F737871;
sub.f32 f2064, f1948, f1953;
mul.f32 f2065, f2064, 0fBF167918;
sub.f32 f2066, f2065, f2063;
mul.f32 f2067, f2053, 0f3F4F1BBD;
sub.f32 f2068, f1735, f2067;
fma.rn.f32 f2069, f2055, 0f3E9E377A, f2068;
mul.f32 f2070, f2062, 0f3F167918;
mul.f32 f2071, f2064, 0f3F737871;
sub.f32 f2072, f2071, f2070;
fma.rn.f32 f2073, f2056, 0f3E9E377A, f1753;
mul.f32 f2074, f2058, 0f3F4F1BBD;
sub.f32 f2075, f2073, f2074;
sub.f32 f2076, f1941, f1956;
mul.f32 f2077, f2076, 0f3F737871;
sub.f32 f2078, f1946, f1951;
mul.f32 f2079, f2078, 0fBF167918;
sub.f32 f2080, f2079, f2077;
mul.f32 f2081, f2056, 0f3F4F1BBD;
sub.f32 f2082, f1753, f2081;
fma.rn.f32 f2083, f2058, 0f3E9E377A, f2082;
mul.f32 f2084, f2076, 0f3F167918;
mul.f32 f2085, f2078, 0f3F737871;
sub.f32 f2086, f2085, f2084;
add.f32 f2087, f1961, f1976;
add.f32 f2088, f1743, f2087;
add.f32 f2089, f1966, f1971;
add.f32 f2090, f1963, f1978;
add.f32 f2091, f1761, f2090;
add.f32 f2092, f1968, f1973;
fma.rn.f32 f2093, f2087, 0f3E9E377A, f1743;
mul.f32 f2094, f2089, 0f3F4F1BBD;
sub.f32 f2095, f2093, f2094;
sub.f32 f2096, f1963, f1978;
mul.f32 f2097, f2096, 0f3F737871;
sub.f32 f2098, f1968, f1973;
mul.f32 f2099, f2098, 0fBF167918;
sub.f32 f2100, f2099, f2097;
mul.f32 f2101, f2087, 0f3F4F1BBD;
sub.f32 f2102, f1743, f2101;
fma.rn.f32 f2103, f2089, 0f3E9E377A, f2102;
mul.f32 f2104, f2096, 0f3F167918;
mul.f32 f2105, f2098, 0f3F737871;
sub.f32 f2106, f2105, f2104;
fma.rn.f32 f2107, f2090, 0f3E9E377A, f1761;
mul.f32 f2108, f2092, 0f3F4F1BBD;
sub.f32 f2109, f2107, f2108;
sub.f32 f2110, f1961, f1976;
mul.f32 f2111, f2110, 0f3F737871;
sub.f32 f2112, f1966, f1971;
mul.f32 f2113, f2112, 0fBF167918;
sub.f32 f2114, f2113, f2111;
mul.f32 f2115, f2090, 0f3F4F1BBD;
sub.f32 f2116, f1761, f2115;
fma.rn.f32 f2117, f2092, 0f3E9E377A, f2116;
mul.f32 f2118, f2110, 0f3F167918;
mul.f32 f2119, f2112, 0f3F737871;
sub.f32 f2120, f2119, f2118;
add.f32 f2121, f1981, f1996;
add.f32 f2122, f1744, f2121;
add.f32 f2123, f1986, f1991;
add.f32 f2124, f1983, f1998;
add.f32 f2125, f1762, f2124;
add.f32 f2126, f1988, f1993;
fma.rn.f32 f2127, f2121, 0f3E9E377A, f1744;
mul.f32 f2128, f2123, 0f3F4F1BBD;
sub.f32 f2129, f2127, f2128;
sub.f32 f2130, f1983, f1998;
mul.f32 f2131, f2130, 0f3F737871;
sub.f32 f2132, f1988, f1993;
mul.f32 f2133, f2132, 0fBF167918;
sub.f32 f2134, f2133, f2131;
mul.f32 f2135, f2121, 0f3F4F1BBD;
sub.f32 f2136, f1744, f2135;
fma.rn.f32 f2137, f2123, 0f3E9E377A, f2136;
mul.f32 f2138, f2130, 0f3F167918;
mul.f32 f2139, f2132, 0f3F737871;
sub.f32 f2140, f2139, f2138;
fma.rn.f32 f2141, f2124, 0f3E9E377A, f1762;
mul.f32 f2142, f2126, 0f3F4F1BBD;
sub.f32 f2143, f2141, f2142;
sub.f32 f2144, f1981, f1996;
mul.f32 f2145, f2144, 0f3F737871;
sub.f32 f2146, f1986, f1991;
mul.f32 f2147, f2146, 0fBF167918;
sub.f32 f2148, f2147, f2145;
mul.f32 f2149, f2124, 0f3F4F1BBD;
sub.f32 f2150, f1762, f2149;
fma.rn.f32 f2151, f2126, 0f3E9E377A, f2150;
mul.f32 f2152, f2144, 0f3F167918;
mul.f32 f2153, f2146, 0f3F737871;
sub.f32 f2154, f2153, f2152;
add.f32 f2155, f2001, f2016;
add.f32 f2156, f1736, f2155;
add.f32 f2157, f2006, f2011;
add.f32 f2158, f2003, f2018;
add.f32 f2159, f1754, f2158;
add.f32 f2160, f2008, f2013;
fma.rn.f32 f2161, f2155, 0f3E9E377A, f1736;
mul.f32 f2162, f2157, 0f3F4F1BBD;
sub.f32 f2163, f2161, f2162;
sub.f32 f2164, f2003, f2018;
mul.f32 f2165, f2164, 0f3F737871;
sub.f32 f2166, f2008, f2013;
mul.f32 f2167, f2166, 0fBF167918;
sub.f32 f2168, f2167, f2165;
mul.f32 f2169, f2155, 0f3F4F1BBD;
sub.f32 f2170, f1736, f2169;
fma.rn.f32 f2171, f2157, 0f3E9E377A, f2170;
mul.f32 f2172, f2164, 0f3F167918;
mul.f32 f2173, f2166, 0f3F737871;
sub.f32 f2174, f2173, f2172;
fma.rn.f32 f2175, f2158, 0f3E9E377A, f1754;
mul.f32 f2176, f2160, 0f3F4F1BBD;
sub.f32 f2177, f2175, f2176;
sub.f32 f2178, f2001, f2016;
mul.f32 f2179, f2178, 0f3F737871;
sub.f32 f2180, f2006, f2011;
mul.f32 f2181, f2180, 0fBF167918;
sub.f32 f2182, f2181, f2179;
mul.f32 f2183, f2158, 0f3F4F1BBD;
sub.f32 f2184, f1754, f2183;
fma.rn.f32 f2185, f2160, 0f3E9E377A, f2184;
mul.f32 f2186, f2178, 0f3F167918;
mul.f32 f2187, f2180, 0f3F737871;
sub.f32 f2188, f2187, f2186;
add.f32 %0, f2021, f2020;
add.f32 %1, f2024, f2023;
add.f32 %3, f2058, f2057;
add.f32 %2, f2055, f2054;
add.f32 %5, f2092, f2091;
add.f32 %4, f2089, f2088;
add.f32 %7, f2126, f2125;
add.f32 %6, f2123, f2122;
add.f32 %9, f2160, f2159;
add.f32 %8, f2157, f2156;
add.f32 %11, f2046, f2041;
sub.f32 %10, f2027, f2032;
add.f32 %13, f2080, f2075;
sub.f32 %12, f2061, f2066;
add.f32 %15, f2114, f2109;
sub.f32 %14, f2095, f2100;
add.f32 %17, f2148, f2143;
sub.f32 %16, f2129, f2134;
add.f32 %19, f2182, f2177;
sub.f32 %18, f2163, f2168;
sub.f32 %20, f2035, f2038;
add.f32 %21, f2052, f2049;
add.f32 %23, f2086, f2083;
sub.f32 %22, f2069, f2072;
add.f32 %25, f2120, f2117;
sub.f32 %24, f2103, f2106;
add.f32 %27, f2154, f2151;
sub.f32 %26, f2137, f2140;
add.f32 %29, f2188, f2185;
sub.f32 %28, f2171, f2174;
add.f32 %30, f2038, f2035;
sub.f32 %31, f2049, f2052;
sub.f32 %33, f2083, f2086;
add.f32 %32, f2072, f2069;
sub.f32 %35, f2117, f2120;
add.f32 %34, f2106, f2103;
sub.f32 %37, f2151, f2154;
add.f32 %36, f2140, f2137;
sub.f32 %39, f2185, f2188;
add.f32 %38, f2174, f2171;
sub.f32 %41, f2041, f2046;
add.f32 %40, f2032, f2027;
sub.f32 %43, f2075, f2080;
add.f32 %42, f2066, f2061;
sub.f32 %45, f2109, f2114;
add.f32 %44, f2100, f2095;
sub.f32 %47, f2143, f2148;
add.f32 %46, f2134, f2129;
sub.f32 %49, f2177, f2182;
add.f32 %48, f2168, f2163;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_15625), "l"(lut_sp_25_625), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y));
};


#endif
