#ifndef CUFFTDX_FFT_144_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_144_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<571, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<485>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 1152, r2;
mov.u32 r4, %tid.x;
add.f64 fd49, %36, %47;
add.f64 fd50, %26, fd49;
add.f64 fd51, %38, %49;
add.f64 fd52, %27, fd51;
mul.f64 fd53, fd49, 0d3FE0000000000000;
sub.f64 fd54, %26, fd53;
sub.f64 fd55, %38, %49;
mul.f64 fd56, fd55, 0d3FEBB67AE8584CAA;
add.f64 fd57, fd56, fd54;
sub.f64 fd58, fd54, fd56;
mul.f64 fd59, fd51, 0d3FE0000000000000;
sub.f64 fd60, %27, fd59;
sub.f64 fd61, %36, %47;
mul.f64 fd62, fd61, 0d3FEBB67AE8584CAA;
sub.f64 fd63, fd60, fd62;
add.f64 fd64, fd62, fd60;
add.f64 fd65, %42, %52;
add.f64 fd66, %31, fd65;
add.f64 fd67, %43, %54;
add.f64 fd68, %33, fd67;
mul.f64 fd69, fd65, 0d3FE0000000000000;
sub.f64 fd70, %31, fd69;
sub.f64 fd71, %43, %54;
mul.f64 fd72, fd71, 0d3FEBB67AE8584CAA;
add.f64 fd73, fd72, fd70;
sub.f64 fd74, fd70, fd72;
mul.f64 fd75, fd67, 0d3FE0000000000000;
sub.f64 fd76, %33, fd75;
sub.f64 fd77, %42, %52;
mul.f64 fd78, fd77, 0d3FEBB67AE8584CAA;
sub.f64 fd79, fd76, fd78;
add.f64 fd80, fd78, fd76;
mul.f64 fd81, fd73, 0d3FE0000000000000;
mul.f64 fd82, fd79, 0dBFEBB67AE8584CAA;
sub.f64 fd83, fd81, fd82;
mul.f64 fd84, fd79, 0d3FE0000000000000;
fma.rn.f64 fd85, fd73, 0dBFEBB67AE8584CAA, fd84;
mul.f64 fd86, fd74, 0dBFE0000000000000;
mul.f64 fd87, fd80, 0dBFEBB67AE8584CAA;
sub.f64 fd88, fd86, fd87;
mul.f64 fd89, fd80, 0dBFE0000000000000;
fma.rn.f64 fd90, fd74, 0dBFEBB67AE8584CAA, fd89;
add.f64 fd91, fd50, fd66;
add.f64 fd92, fd52, fd68;
sub.f64 fd93, fd50, fd66;
sub.f64 fd94, fd52, fd68;
add.f64 fd95, fd57, fd83;
add.f64 fd96, fd63, fd85;
sub.f64 fd97, fd57, fd83;
sub.f64 fd98, fd63, fd85;
add.f64 fd99, fd58, fd88;
add.f64 fd100, fd64, fd90;
sub.f64 fd101, fd58, fd88;
sub.f64 fd102, fd64, fd90;
add.f64 fd103, %39, %50;
add.f64 fd104, %28, fd103;
add.f64 fd105, %41, %51;
add.f64 fd106, %30, fd105;
mul.f64 fd107, fd103, 0d3FE0000000000000;
sub.f64 fd108, %28, fd107;
sub.f64 fd109, %41, %51;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd105, 0d3FE0000000000000;
sub.f64 fd114, %30, fd113;
sub.f64 fd115, %39, %50;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, %44, %55;
add.f64 fd120, %34, fd119;
add.f64 fd121, %46, %56;
add.f64 fd122, %35, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, %34, fd123;
sub.f64 fd125, %46, %56;
mul.f64 fd126, fd125, 0d3FEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, %35, fd129;
sub.f64 fd131, %44, %55;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
mul.f64 fd135, fd127, 0d3FE0000000000000;
mul.f64 fd136, fd133, 0dBFEBB67AE8584CAA;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd133, 0d3FE0000000000000;
fma.rn.f64 fd139, fd127, 0dBFEBB67AE8584CAA, fd138;
mul.f64 fd140, fd128, 0dBFE0000000000000;
mul.f64 fd141, fd134, 0dBFEBB67AE8584CAA;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd134, 0dBFE0000000000000;
fma.rn.f64 fd144, fd128, 0dBFEBB67AE8584CAA, fd143;
add.f64 fd145, fd104, fd120;
add.f64 fd146, fd106, fd122;
sub.f64 fd147, fd104, fd120;
sub.f64 fd148, fd106, fd122;
add.f64 fd149, fd111, fd137;
add.f64 fd150, fd117, fd139;
sub.f64 fd151, fd111, fd137;
sub.f64 fd152, fd117, fd139;
add.f64 fd153, fd112, fd142;
add.f64 fd154, fd118, fd144;
sub.f64 fd155, fd112, fd142;
sub.f64 fd156, fd118, fd144;
mul.f64 fd157, fd149, 0d3FEBB67AE8584CAA;
mul.f64 fd158, fd150, 0dBFE0000000000000;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd150, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd161, fd149, 0dBFE0000000000000, fd160;
mul.f64 fd162, fd153, 0d3FE0000000000000;
mul.f64 fd163, fd154, 0dBFEBB67AE8584CAA;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, 0d3FE0000000000000;
fma.rn.f64 fd166, fd153, 0dBFEBB67AE8584CAA, fd165;
mul.f64 fd167, fd151, 0dBFE0000000000000;
mul.f64 fd168, fd152, 0dBFEBB67AE8584CAA;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd152, 0dBFE0000000000000;
fma.rn.f64 fd171, fd151, 0dBFEBB67AE8584CAA, fd170;
mul.f64 fd172, fd155, 0dBFEBB67AE8584CAA;
mul.f64 fd173, fd156, 0dBFE0000000000000;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd156, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd176, fd155, 0dBFE0000000000000, fd175;
add.f64 fd177, fd91, fd145;
add.f64 fd178, fd92, fd146;
sub.f64 fd179, fd91, fd145;
sub.f64 fd180, fd92, fd146;
add.f64 fd181, fd95, fd159;
add.f64 fd182, fd96, fd161;
sub.f64 fd183, fd95, fd159;
sub.f64 fd184, fd96, fd161;
add.f64 fd185, fd99, fd164;
add.f64 fd186, fd100, fd166;
sub.f64 fd187, fd99, fd164;
sub.f64 fd188, fd100, fd166;
add.f64 fd189, fd93, fd148;
sub.f64 fd190, fd94, fd147;
sub.f64 fd191, fd93, fd148;
add.f64 fd192, fd94, fd147;
add.f64 fd193, fd97, fd169;
add.f64 fd194, fd98, fd171;
sub.f64 fd195, fd97, fd169;
sub.f64 fd196, fd98, fd171;
add.f64 fd197, fd101, fd174;
add.f64 fd198, fd102, fd176;
sub.f64 fd199, fd101, fd174;
sub.f64 fd200, fd102, fd176;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 12;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd201, fd202}, [rd6];
mul.f64 fd205, fd201, fd181;
mul.f64 fd206, fd202, fd182;
sub.f64 fd207, fd205, fd206;
mul.f64 fd208, fd201, fd182;
fma.rn.f64 fd209, fd202, fd181, fd208;
mul.f64 fd210, fd201, fd201;
mul.f64 fd211, fd202, fd202;
sub.f64 fd212, fd210, fd211;
mul.f64 fd213, fd202, fd201;
fma.rn.f64 fd214, fd202, fd201, fd213;
mul.f64 fd215, fd212, fd185;
mul.f64 fd216, fd214, fd186;
sub.f64 fd217, fd215, fd216;
mul.f64 fd218, fd212, fd186;
fma.rn.f64 fd219, fd214, fd185, fd218;
mul.f64 fd220, fd201, fd212;
mul.f64 fd221, fd202, fd214;
sub.f64 fd222, fd220, fd221;
mul.f64 fd223, fd201, fd214;
fma.rn.f64 fd224, fd202, fd212, fd223;
mul.f64 fd225, fd222, fd189;
mul.f64 fd226, fd224, fd190;
sub.f64 fd227, fd225, fd226;
mul.f64 fd228, fd222, fd190;
fma.rn.f64 fd229, fd224, fd189, fd228;
mul.f64 fd230, fd201, fd222;
mul.f64 fd231, fd202, fd224;
sub.f64 fd232, fd230, fd231;
mul.f64 fd233, fd201, fd224;
fma.rn.f64 fd234, fd202, fd222, fd233;
mul.f64 fd235, fd232, fd193;
mul.f64 fd236, fd234, fd194;
sub.f64 fd237, fd235, fd236;
mul.f64 fd238, fd232, fd194;
fma.rn.f64 fd239, fd234, fd193, fd238;
mul.f64 fd240, fd201, fd232;
mul.f64 fd241, fd202, fd234;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd201, fd234;
fma.rn.f64 fd244, fd202, fd232, fd243;
mul.f64 fd245, fd242, fd197;
mul.f64 fd246, fd244, fd198;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd242, fd198;
fma.rn.f64 fd249, fd244, fd197, fd248;
mul.f64 fd250, fd201, fd242;
mul.f64 fd251, fd202, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd201, fd244;
fma.rn.f64 fd254, fd202, fd242, fd253;
mul.f64 fd255, fd252, fd179;
mul.f64 fd256, fd254, fd180;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd252, fd180;
fma.rn.f64 fd259, fd254, fd179, fd258;
ld.global.v2.f64 {fd260, fd261}, [rd6+192];
mul.f64 fd264, fd260, fd183;
mul.f64 fd265, fd261, fd184;
sub.f64 fd266, fd264, fd265;
mul.f64 fd267, fd260, fd184;
fma.rn.f64 fd268, fd261, fd183, fd267;
mul.f64 fd269, fd201, fd260;
mul.f64 fd270, fd202, fd261;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd201, fd261;
fma.rn.f64 fd273, fd202, fd260, fd272;
mul.f64 fd274, fd271, fd187;
mul.f64 fd275, fd273, fd188;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd271, fd188;
fma.rn.f64 fd278, fd273, fd187, fd277;
mul.f64 fd279, fd201, fd271;
mul.f64 fd280, fd202, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd201, fd273;
fma.rn.f64 fd283, fd202, fd271, fd282;
mul.f64 fd284, fd281, fd191;
mul.f64 fd285, fd283, fd192;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd192;
fma.rn.f64 fd288, fd283, fd191, fd287;
mul.f64 fd289, fd201, fd281;
mul.f64 fd290, fd202, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd201, fd283;
fma.rn.f64 fd293, fd202, fd281, fd292;
mul.f64 fd294, fd291, fd195;
mul.f64 fd295, fd293, fd196;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd196;
fma.rn.f64 fd298, fd293, fd195, fd297;
mul.f64 fd299, fd201, fd291;
mul.f64 fd300, fd202, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd201, fd293;
fma.rn.f64 fd303, fd202, fd291, fd302;
mul.f64 fd304, fd301, fd199;
mul.f64 fd305, fd303, fd200;
sub.f64 fd306, fd304, fd305;
mul.f64 fd307, fd301, fd200;
fma.rn.f64 fd308, fd303, fd199, fd307;
mad.lo.s32 r8, r5, 1152, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 96, r8;
st.shared.v2.f64 [r9], {fd177, fd207};
st.shared.v2.f64 [r9+16], {fd217, fd227};
st.shared.v2.f64 [r9+32], {fd237, fd247};
st.shared.v2.f64 [r9+48], {fd257, fd266};
st.shared.v2.f64 [r9+64], {fd276, fd286};
st.shared.v2.f64 [r9+80], {fd296, fd306};
barrier.sync 0;
mad.lo.s32 r10, r7, -88, r9;
ld.shared.f64 fd309, [r10];
ld.shared.f64 fd310, [r10+96];
ld.shared.f64 fd311, [r10+192];
ld.shared.f64 fd312, [r10+288];
ld.shared.f64 fd313, [r10+384];
ld.shared.f64 fd314, [r10+480];
ld.shared.f64 fd315, [r10+576];
ld.shared.f64 fd316, [r10+672];
ld.shared.f64 fd317, [r10+768];
ld.shared.f64 fd318, [r10+864];
ld.shared.f64 fd319, [r10+960];
ld.shared.f64 fd320, [r10+1056];
barrier.sync 0;
st.shared.v2.f64 [r9], {fd178, fd209};
st.shared.v2.f64 [r9+16], {fd219, fd229};
st.shared.v2.f64 [r9+32], {fd239, fd249};
st.shared.v2.f64 [r9+48], {fd259, fd268};
st.shared.v2.f64 [r9+64], {fd278, fd288};
st.shared.v2.f64 [r9+80], {fd298, fd308};
barrier.sync 0;
ld.shared.f64 fd321, [r10];
ld.shared.f64 fd322, [r10+96];
ld.shared.f64 fd323, [r10+192];
ld.shared.f64 fd324, [r10+288];
ld.shared.f64 fd325, [r10+384];
ld.shared.f64 fd326, [r10+480];
ld.shared.f64 fd327, [r10+576];
ld.shared.f64 fd328, [r10+672];
ld.shared.f64 fd329, [r10+768];
ld.shared.f64 fd330, [r10+864];
ld.shared.f64 fd331, [r10+960];
ld.shared.f64 fd332, [r10+1056];
add.f64 fd333, fd313, fd317;
add.f64 fd334, fd309, fd333;
add.f64 fd335, fd325, fd329;
add.f64 fd336, fd321, fd335;
mul.f64 fd337, fd333, 0d3FE0000000000000;
sub.f64 fd338, fd309, fd337;
sub.f64 fd339, fd325, fd329;
mul.f64 fd340, fd339, 0d3FEBB67AE8584CAA;
add.f64 fd341, fd340, fd338;
sub.f64 fd342, fd338, fd340;
mul.f64 fd343, fd335, 0d3FE0000000000000;
sub.f64 fd344, fd321, fd343;
sub.f64 fd345, fd313, fd317;
mul.f64 fd346, fd345, 0d3FEBB67AE8584CAA;
sub.f64 fd347, fd344, fd346;
add.f64 fd348, fd346, fd344;
add.f64 fd349, fd315, fd319;
add.f64 fd350, fd311, fd349;
add.f64 fd351, fd327, fd331;
add.f64 fd352, fd323, fd351;
mul.f64 fd353, fd349, 0d3FE0000000000000;
sub.f64 fd354, fd311, fd353;
sub.f64 fd355, fd327, fd331;
mul.f64 fd356, fd355, 0d3FEBB67AE8584CAA;
add.f64 fd357, fd356, fd354;
sub.f64 fd358, fd354, fd356;
mul.f64 fd359, fd351, 0d3FE0000000000000;
sub.f64 fd360, fd323, fd359;
sub.f64 fd361, fd315, fd319;
mul.f64 fd362, fd361, 0d3FEBB67AE8584CAA;
sub.f64 fd363, fd360, fd362;
add.f64 fd364, fd362, fd360;
mul.f64 fd365, fd357, 0d3FE0000000000000;
mul.f64 fd366, fd363, 0dBFEBB67AE8584CAA;
sub.f64 fd367, fd365, fd366;
mul.f64 fd368, fd363, 0d3FE0000000000000;
fma.rn.f64 fd369, fd357, 0dBFEBB67AE8584CAA, fd368;
mul.f64 fd370, fd358, 0dBFE0000000000000;
mul.f64 fd371, fd364, 0dBFEBB67AE8584CAA;
sub.f64 fd372, fd370, fd371;
mul.f64 fd373, fd364, 0dBFE0000000000000;
fma.rn.f64 fd374, fd358, 0dBFEBB67AE8584CAA, fd373;
add.f64 fd375, fd334, fd350;
add.f64 fd376, fd336, fd352;
sub.f64 fd377, fd334, fd350;
sub.f64 fd378, fd336, fd352;
add.f64 fd379, fd341, fd367;
add.f64 fd380, fd347, fd369;
sub.f64 fd381, fd341, fd367;
sub.f64 fd382, fd347, fd369;
add.f64 fd383, fd342, fd372;
add.f64 fd384, fd348, fd374;
sub.f64 fd385, fd342, fd372;
sub.f64 fd386, fd348, fd374;
add.f64 fd387, fd314, fd318;
add.f64 fd388, fd310, fd387;
add.f64 fd389, fd326, fd330;
add.f64 fd390, fd322, fd389;
mul.f64 fd391, fd387, 0d3FE0000000000000;
sub.f64 fd392, fd310, fd391;
sub.f64 fd393, fd326, fd330;
mul.f64 fd394, fd393, 0d3FEBB67AE8584CAA;
add.f64 fd395, fd394, fd392;
sub.f64 fd396, fd392, fd394;
mul.f64 fd397, fd389, 0d3FE0000000000000;
sub.f64 fd398, fd322, fd397;
sub.f64 fd399, fd314, fd318;
mul.f64 fd400, fd399, 0d3FEBB67AE8584CAA;
sub.f64 fd401, fd398, fd400;
add.f64 fd402, fd400, fd398;
add.f64 fd403, fd316, fd320;
add.f64 fd404, fd312, fd403;
add.f64 fd405, fd328, fd332;
add.f64 fd406, fd324, fd405;
mul.f64 fd407, fd403, 0d3FE0000000000000;
sub.f64 fd408, fd312, fd407;
sub.f64 fd409, fd328, fd332;
mul.f64 fd410, fd409, 0d3FEBB67AE8584CAA;
add.f64 fd411, fd410, fd408;
sub.f64 fd412, fd408, fd410;
mul.f64 fd413, fd405, 0d3FE0000000000000;
sub.f64 fd414, fd324, fd413;
sub.f64 fd415, fd316, fd320;
mul.f64 fd416, fd415, 0d3FEBB67AE8584CAA;
sub.f64 fd417, fd414, fd416;
add.f64 fd418, fd416, fd414;
mul.f64 fd419, fd411, 0d3FE0000000000000;
mul.f64 fd420, fd417, 0dBFEBB67AE8584CAA;
sub.f64 fd421, fd419, fd420;
mul.f64 fd422, fd417, 0d3FE0000000000000;
fma.rn.f64 fd423, fd411, 0dBFEBB67AE8584CAA, fd422;
mul.f64 fd424, fd412, 0dBFE0000000000000;
mul.f64 fd425, fd418, 0dBFEBB67AE8584CAA;
sub.f64 fd426, fd424, fd425;
mul.f64 fd427, fd418, 0dBFE0000000000000;
fma.rn.f64 fd428, fd412, 0dBFEBB67AE8584CAA, fd427;
add.f64 fd429, fd388, fd404;
add.f64 fd430, fd390, fd406;
sub.f64 fd431, fd388, fd404;
sub.f64 fd432, fd390, fd406;
add.f64 fd433, fd395, fd421;
add.f64 fd434, fd401, fd423;
sub.f64 fd435, fd395, fd421;
sub.f64 fd436, fd401, fd423;
add.f64 fd437, fd396, fd426;
add.f64 fd438, fd402, fd428;
sub.f64 fd439, fd396, fd426;
sub.f64 fd440, fd402, fd428;
mul.f64 fd441, fd433, 0d3FEBB67AE8584CAA;
mul.f64 fd442, fd434, 0dBFE0000000000000;
sub.f64 fd443, fd441, fd442;
mul.f64 fd444, fd434, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd445, fd433, 0dBFE0000000000000, fd444;
mul.f64 fd446, fd437, 0d3FE0000000000000;
mul.f64 fd447, fd438, 0dBFEBB67AE8584CAA;
sub.f64 fd448, fd446, fd447;
mul.f64 fd449, fd438, 0d3FE0000000000000;
fma.rn.f64 fd450, fd437, 0dBFEBB67AE8584CAA, fd449;
mul.f64 fd451, fd435, 0dBFE0000000000000;
mul.f64 fd452, fd436, 0dBFEBB67AE8584CAA;
sub.f64 fd453, fd451, fd452;
mul.f64 fd454, fd436, 0dBFE0000000000000;
fma.rn.f64 fd455, fd435, 0dBFEBB67AE8584CAA, fd454;
mul.f64 fd456, fd439, 0dBFEBB67AE8584CAA;
mul.f64 fd457, fd440, 0dBFE0000000000000;
sub.f64 fd458, fd456, fd457;
mul.f64 fd459, fd440, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd460, fd439, 0dBFE0000000000000, fd459;
add.f64 %0, fd375, fd429;
add.f64 %1, fd376, fd430;
add.f64 %3, fd380, fd445;
add.f64 %2, fd379, fd443;
add.f64 %5, fd384, fd450;
add.f64 %4, fd383, fd448;
sub.f64 %7, fd378, fd431;
add.f64 %6, fd377, fd432;
add.f64 %9, fd382, fd455;
add.f64 %8, fd381, fd453;
add.f64 %11, fd386, fd460;
add.f64 %10, fd385, fd458;
sub.f64 %12, fd375, fd429;
sub.f64 %13, fd376, fd430;
sub.f64 %15, fd380, fd445;
sub.f64 %14, fd379, fd443;
sub.f64 %17, fd384, fd450;
sub.f64 %16, fd383, fd448;
add.f64 %19, fd378, fd431;
sub.f64 %18, fd377, fd432;
sub.f64 %21, fd382, fd455;
sub.f64 %20, fd381, fd453;
sub.f64 %23, fd386, fd460;
sub.f64 %22, fd385, fd458;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y): "r"(smem), "l"(lut_dp_12_144), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<572, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<509>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 2304, r2;
mov.u32 r4, %tid.x;
add.f64 fd49, %36, %47;
add.f64 fd50, %26, fd49;
add.f64 fd51, %38, %49;
add.f64 fd52, %27, fd51;
mul.f64 fd53, fd49, 0d3FE0000000000000;
sub.f64 fd54, %26, fd53;
sub.f64 fd55, %38, %49;
mul.f64 fd56, fd55, 0d3FEBB67AE8584CAA;
add.f64 fd57, fd56, fd54;
sub.f64 fd58, fd54, fd56;
mul.f64 fd59, fd51, 0d3FE0000000000000;
sub.f64 fd60, %27, fd59;
sub.f64 fd61, %36, %47;
mul.f64 fd62, fd61, 0d3FEBB67AE8584CAA;
sub.f64 fd63, fd60, fd62;
add.f64 fd64, fd62, fd60;
add.f64 fd65, %42, %52;
add.f64 fd66, %31, fd65;
add.f64 fd67, %43, %54;
add.f64 fd68, %33, fd67;
mul.f64 fd69, fd65, 0d3FE0000000000000;
sub.f64 fd70, %31, fd69;
sub.f64 fd71, %43, %54;
mul.f64 fd72, fd71, 0d3FEBB67AE8584CAA;
add.f64 fd73, fd72, fd70;
sub.f64 fd74, fd70, fd72;
mul.f64 fd75, fd67, 0d3FE0000000000000;
sub.f64 fd76, %33, fd75;
sub.f64 fd77, %42, %52;
mul.f64 fd78, fd77, 0d3FEBB67AE8584CAA;
sub.f64 fd79, fd76, fd78;
add.f64 fd80, fd78, fd76;
mul.f64 fd81, fd73, 0d3FE0000000000000;
mul.f64 fd82, fd79, 0dBFEBB67AE8584CAA;
sub.f64 fd83, fd81, fd82;
mul.f64 fd84, fd79, 0d3FE0000000000000;
fma.rn.f64 fd85, fd73, 0dBFEBB67AE8584CAA, fd84;
mul.f64 fd86, fd74, 0dBFE0000000000000;
mul.f64 fd87, fd80, 0dBFEBB67AE8584CAA;
sub.f64 fd88, fd86, fd87;
mul.f64 fd89, fd80, 0dBFE0000000000000;
fma.rn.f64 fd90, fd74, 0dBFEBB67AE8584CAA, fd89;
add.f64 fd91, fd50, fd66;
add.f64 fd92, fd52, fd68;
sub.f64 fd93, fd50, fd66;
sub.f64 fd94, fd52, fd68;
add.f64 fd95, fd57, fd83;
add.f64 fd96, fd63, fd85;
sub.f64 fd97, fd57, fd83;
sub.f64 fd98, fd63, fd85;
add.f64 fd99, fd58, fd88;
add.f64 fd100, fd64, fd90;
sub.f64 fd101, fd58, fd88;
sub.f64 fd102, fd64, fd90;
add.f64 fd103, %39, %50;
add.f64 fd104, %28, fd103;
add.f64 fd105, %41, %51;
add.f64 fd106, %30, fd105;
mul.f64 fd107, fd103, 0d3FE0000000000000;
sub.f64 fd108, %28, fd107;
sub.f64 fd109, %41, %51;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd105, 0d3FE0000000000000;
sub.f64 fd114, %30, fd113;
sub.f64 fd115, %39, %50;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, %44, %55;
add.f64 fd120, %34, fd119;
add.f64 fd121, %46, %56;
add.f64 fd122, %35, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, %34, fd123;
sub.f64 fd125, %46, %56;
mul.f64 fd126, fd125, 0d3FEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, %35, fd129;
sub.f64 fd131, %44, %55;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
mul.f64 fd135, fd127, 0d3FE0000000000000;
mul.f64 fd136, fd133, 0dBFEBB67AE8584CAA;
sub.f64 fd137, fd135, fd136;
mul.f64 fd138, fd133, 0d3FE0000000000000;
fma.rn.f64 fd139, fd127, 0dBFEBB67AE8584CAA, fd138;
mul.f64 fd140, fd128, 0dBFE0000000000000;
mul.f64 fd141, fd134, 0dBFEBB67AE8584CAA;
sub.f64 fd142, fd140, fd141;
mul.f64 fd143, fd134, 0dBFE0000000000000;
fma.rn.f64 fd144, fd128, 0dBFEBB67AE8584CAA, fd143;
add.f64 fd145, fd104, fd120;
add.f64 fd146, fd106, fd122;
sub.f64 fd147, fd104, fd120;
sub.f64 fd148, fd106, fd122;
add.f64 fd149, fd111, fd137;
add.f64 fd150, fd117, fd139;
sub.f64 fd151, fd111, fd137;
sub.f64 fd152, fd117, fd139;
add.f64 fd153, fd112, fd142;
add.f64 fd154, fd118, fd144;
sub.f64 fd155, fd112, fd142;
sub.f64 fd156, fd118, fd144;
mul.f64 fd157, fd149, 0d3FEBB67AE8584CAA;
mul.f64 fd158, fd150, 0dBFE0000000000000;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd150, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd161, fd149, 0dBFE0000000000000, fd160;
mul.f64 fd162, fd153, 0d3FE0000000000000;
mul.f64 fd163, fd154, 0dBFEBB67AE8584CAA;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, 0d3FE0000000000000;
fma.rn.f64 fd166, fd153, 0dBFEBB67AE8584CAA, fd165;
mul.f64 fd167, fd151, 0dBFE0000000000000;
mul.f64 fd168, fd152, 0dBFEBB67AE8584CAA;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd152, 0dBFE0000000000000;
fma.rn.f64 fd171, fd151, 0dBFEBB67AE8584CAA, fd170;
mul.f64 fd172, fd155, 0dBFEBB67AE8584CAA;
mul.f64 fd173, fd156, 0dBFE0000000000000;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd156, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd176, fd155, 0dBFE0000000000000, fd175;
sub.f64 fd177, fd91, fd145;
sub.f64 fd178, fd92, fd146;
add.f64 fd179, fd95, fd159;
add.f64 fd180, fd96, fd161;
sub.f64 fd181, fd95, fd159;
sub.f64 fd182, fd96, fd161;
add.f64 fd183, fd99, fd164;
add.f64 fd184, fd100, fd166;
sub.f64 fd185, fd99, fd164;
sub.f64 fd186, fd100, fd166;
add.f64 fd187, fd93, fd148;
sub.f64 fd188, fd94, fd147;
sub.f64 fd189, fd93, fd148;
add.f64 fd190, fd94, fd147;
add.f64 fd191, fd97, fd169;
add.f64 fd192, fd98, fd171;
sub.f64 fd193, fd97, fd169;
sub.f64 fd194, fd98, fd171;
add.f64 fd195, fd101, fd174;
add.f64 fd196, fd102, fd176;
sub.f64 fd197, fd101, fd174;
sub.f64 fd198, fd102, fd176;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 12;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 2304, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd199, fd200}, [rd6];
mul.f64 fd203, fd199, fd179;
mul.f64 fd204, fd200, fd180;
mul.f64 fd205, fd199, fd180;
mul.f64 fd206, fd199, fd199;
mul.f64 fd207, fd200, fd200;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd200, fd199;
fma.rn.f64 fd210, fd200, fd199, fd209;
mul.f64 fd211, fd208, fd183;
mul.f64 fd212, fd210, fd184;
mul.f64 fd213, fd208, fd184;
mul.f64 fd214, fd199, fd208;
mul.f64 fd215, fd200, fd210;
sub.f64 fd216, fd214, fd215;
mul.f64 fd217, fd199, fd210;
fma.rn.f64 fd218, fd200, fd208, fd217;
mul.f64 fd219, fd216, fd187;
mul.f64 fd220, fd218, fd188;
mul.f64 fd221, fd216, fd188;
mul.f64 fd222, fd199, fd216;
mul.f64 fd223, fd200, fd218;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd199, fd218;
fma.rn.f64 fd226, fd200, fd216, fd225;
mul.f64 fd227, fd224, fd191;
mul.f64 fd228, fd226, fd192;
mul.f64 fd229, fd224, fd192;
mul.f64 fd230, fd199, fd224;
mul.f64 fd231, fd200, fd226;
sub.f64 fd232, fd230, fd231;
mul.f64 fd233, fd199, fd226;
fma.rn.f64 fd234, fd200, fd224, fd233;
mul.f64 fd235, fd232, fd195;
mul.f64 fd236, fd234, fd196;
mul.f64 fd237, fd232, fd196;
mul.f64 fd238, fd199, fd232;
mul.f64 fd239, fd200, fd234;
sub.f64 fd240, fd238, fd239;
mul.f64 fd241, fd199, fd234;
fma.rn.f64 fd242, fd200, fd232, fd241;
mul.f64 fd243, fd240, fd177;
mul.f64 fd244, fd242, fd178;
mul.f64 fd245, fd240, fd178;
ld.global.v2.f64 {fd246, fd247}, [rd6+192];
mul.f64 fd250, fd246, fd181;
mul.f64 fd251, fd247, fd182;
mul.f64 fd252, fd246, fd182;
mul.f64 fd253, fd199, fd246;
mul.f64 fd254, fd200, fd247;
sub.f64 fd255, fd253, fd254;
mul.f64 fd256, fd199, fd247;
fma.rn.f64 fd257, fd200, fd246, fd256;
mul.f64 fd258, fd255, fd185;
mul.f64 fd259, fd257, fd186;
mul.f64 fd260, fd255, fd186;
mul.f64 fd261, fd199, fd255;
mul.f64 fd262, fd200, fd257;
sub.f64 fd263, fd261, fd262;
mul.f64 fd264, fd199, fd257;
fma.rn.f64 fd265, fd200, fd255, fd264;
mul.f64 fd266, fd263, fd189;
mul.f64 fd267, fd265, fd190;
mul.f64 fd268, fd263, fd190;
mul.f64 fd269, fd199, fd263;
mul.f64 fd270, fd200, fd265;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd199, fd265;
fma.rn.f64 fd273, fd200, fd263, fd272;
mul.f64 fd274, fd271, fd193;
mul.f64 fd275, fd273, fd194;
mul.f64 fd276, fd271, fd194;
mul.f64 fd277, fd199, fd271;
mul.f64 fd278, fd200, fd273;
sub.f64 fd279, fd277, fd278;
mul.f64 fd280, fd199, fd273;
fma.rn.f64 fd281, fd200, fd271, fd280;
mul.f64 fd282, fd279, fd197;
mul.f64 fd283, fd281, fd198;
mul.f64 fd284, fd279, fd198;
barrier.sync 0;
mad.lo.s32 r9, r7, 192, r8;
add.f64 fd285, fd92, fd146;
add.f64 fd286, fd91, fd145;
st.shared.v2.f64 [r9], {fd286, fd285};
fma.rn.f64 fd287, fd200, fd179, fd205;
sub.f64 fd288, fd203, fd204;
st.shared.v2.f64 [r9+16], {fd288, fd287};
fma.rn.f64 fd289, fd210, fd183, fd213;
sub.f64 fd290, fd211, fd212;
st.shared.v2.f64 [r9+32], {fd290, fd289};
sub.f64 fd291, fd219, fd220;
fma.rn.f64 fd292, fd218, fd187, fd221;
st.shared.v2.f64 [r9+48], {fd291, fd292};
sub.f64 fd293, fd227, fd228;
fma.rn.f64 fd294, fd226, fd191, fd229;
st.shared.v2.f64 [r9+64], {fd293, fd294};
fma.rn.f64 fd295, fd234, fd195, fd237;
sub.f64 fd296, fd235, fd236;
st.shared.v2.f64 [r9+80], {fd296, fd295};
fma.rn.f64 fd297, fd242, fd177, fd245;
sub.f64 fd298, fd243, fd244;
st.shared.v2.f64 [r9+96], {fd298, fd297};
fma.rn.f64 fd299, fd247, fd181, fd252;
sub.f64 fd300, fd250, fd251;
st.shared.v2.f64 [r9+112], {fd300, fd299};
fma.rn.f64 fd301, fd257, fd185, fd260;
sub.f64 fd302, fd258, fd259;
st.shared.v2.f64 [r9+128], {fd302, fd301};
sub.f64 fd303, fd266, fd267;
fma.rn.f64 fd304, fd265, fd189, fd268;
st.shared.v2.f64 [r9+144], {fd303, fd304};
sub.f64 fd305, fd274, fd275;
fma.rn.f64 fd306, fd273, fd193, fd276;
st.shared.v2.f64 [r9+160], {fd305, fd306};
fma.rn.f64 fd307, fd281, fd197, fd284;
sub.f64 fd308, fd282, fd283;
st.shared.v2.f64 [r9+176], {fd308, fd307};
barrier.sync 0;
mad.lo.s32 r10, r7, -176, r9;
ld.shared.v2.f64 {fd309, fd310}, [r10];
ld.shared.v2.f64 {fd313, fd314}, [r10+192];
ld.shared.v2.f64 {fd317, fd318}, [r10+384];
ld.shared.v2.f64 {fd321, fd322}, [r10+576];
ld.shared.v2.f64 {fd325, fd326}, [r10+768];
ld.shared.v2.f64 {fd329, fd330}, [r10+960];
ld.shared.v2.f64 {fd333, fd334}, [r10+1152];
ld.shared.v2.f64 {fd337, fd338}, [r10+1344];
ld.shared.v2.f64 {fd341, fd342}, [r10+1536];
ld.shared.v2.f64 {fd345, fd346}, [r10+1728];
ld.shared.v2.f64 {fd349, fd350}, [r10+1920];
ld.shared.v2.f64 {fd353, fd354}, [r10+2112];
add.f64 fd357, fd325, fd341;
add.f64 fd358, fd309, fd357;
add.f64 fd359, fd326, fd342;
add.f64 fd360, fd310, fd359;
mul.f64 fd361, fd357, 0d3FE0000000000000;
sub.f64 fd362, fd309, fd361;
sub.f64 fd363, fd326, fd342;
mul.f64 fd364, fd363, 0d3FEBB67AE8584CAA;
add.f64 fd365, fd364, fd362;
sub.f64 fd366, fd362, fd364;
mul.f64 fd367, fd359, 0d3FE0000000000000;
sub.f64 fd368, fd310, fd367;
sub.f64 fd369, fd325, fd341;
mul.f64 fd370, fd369, 0d3FEBB67AE8584CAA;
sub.f64 fd371, fd368, fd370;
add.f64 fd372, fd370, fd368;
add.f64 fd373, fd333, fd349;
add.f64 fd374, fd317, fd373;
add.f64 fd375, fd334, fd350;
add.f64 fd376, fd318, fd375;
mul.f64 fd377, fd373, 0d3FE0000000000000;
sub.f64 fd378, fd317, fd377;
sub.f64 fd379, fd334, fd350;
mul.f64 fd380, fd379, 0d3FEBB67AE8584CAA;
add.f64 fd381, fd380, fd378;
sub.f64 fd382, fd378, fd380;
mul.f64 fd383, fd375, 0d3FE0000000000000;
sub.f64 fd384, fd318, fd383;
sub.f64 fd385, fd333, fd349;
mul.f64 fd386, fd385, 0d3FEBB67AE8584CAA;
sub.f64 fd387, fd384, fd386;
add.f64 fd388, fd386, fd384;
mul.f64 fd389, fd381, 0d3FE0000000000000;
mul.f64 fd390, fd387, 0dBFEBB67AE8584CAA;
sub.f64 fd391, fd389, fd390;
mul.f64 fd392, fd387, 0d3FE0000000000000;
fma.rn.f64 fd393, fd381, 0dBFEBB67AE8584CAA, fd392;
mul.f64 fd394, fd382, 0dBFE0000000000000;
mul.f64 fd395, fd388, 0dBFEBB67AE8584CAA;
sub.f64 fd396, fd394, fd395;
mul.f64 fd397, fd388, 0dBFE0000000000000;
fma.rn.f64 fd398, fd382, 0dBFEBB67AE8584CAA, fd397;
add.f64 fd399, fd358, fd374;
add.f64 fd400, fd360, fd376;
sub.f64 fd401, fd358, fd374;
sub.f64 fd402, fd360, fd376;
add.f64 fd403, fd365, fd391;
add.f64 fd404, fd371, fd393;
sub.f64 fd405, fd365, fd391;
sub.f64 fd406, fd371, fd393;
add.f64 fd407, fd366, fd396;
add.f64 fd408, fd372, fd398;
sub.f64 fd409, fd366, fd396;
sub.f64 fd410, fd372, fd398;
add.f64 fd411, fd329, fd345;
add.f64 fd412, fd313, fd411;
add.f64 fd413, fd330, fd346;
add.f64 fd414, fd314, fd413;
mul.f64 fd415, fd411, 0d3FE0000000000000;
sub.f64 fd416, fd313, fd415;
sub.f64 fd417, fd330, fd346;
mul.f64 fd418, fd417, 0d3FEBB67AE8584CAA;
add.f64 fd419, fd418, fd416;
sub.f64 fd420, fd416, fd418;
mul.f64 fd421, fd413, 0d3FE0000000000000;
sub.f64 fd422, fd314, fd421;
sub.f64 fd423, fd329, fd345;
mul.f64 fd424, fd423, 0d3FEBB67AE8584CAA;
sub.f64 fd425, fd422, fd424;
add.f64 fd426, fd424, fd422;
add.f64 fd427, fd337, fd353;
add.f64 fd428, fd321, fd427;
add.f64 fd429, fd338, fd354;
add.f64 fd430, fd322, fd429;
mul.f64 fd431, fd427, 0d3FE0000000000000;
sub.f64 fd432, fd321, fd431;
sub.f64 fd433, fd338, fd354;
mul.f64 fd434, fd433, 0d3FEBB67AE8584CAA;
add.f64 fd435, fd434, fd432;
sub.f64 fd436, fd432, fd434;
mul.f64 fd437, fd429, 0d3FE0000000000000;
sub.f64 fd438, fd322, fd437;
sub.f64 fd439, fd337, fd353;
mul.f64 fd440, fd439, 0d3FEBB67AE8584CAA;
sub.f64 fd441, fd438, fd440;
add.f64 fd442, fd440, fd438;
mul.f64 fd443, fd435, 0d3FE0000000000000;
mul.f64 fd444, fd441, 0dBFEBB67AE8584CAA;
sub.f64 fd445, fd443, fd444;
mul.f64 fd446, fd441, 0d3FE0000000000000;
fma.rn.f64 fd447, fd435, 0dBFEBB67AE8584CAA, fd446;
mul.f64 fd448, fd436, 0dBFE0000000000000;
mul.f64 fd449, fd442, 0dBFEBB67AE8584CAA;
sub.f64 fd450, fd448, fd449;
mul.f64 fd451, fd442, 0dBFE0000000000000;
fma.rn.f64 fd452, fd436, 0dBFEBB67AE8584CAA, fd451;
add.f64 fd453, fd412, fd428;
add.f64 fd454, fd414, fd430;
sub.f64 fd455, fd412, fd428;
sub.f64 fd456, fd414, fd430;
add.f64 fd457, fd419, fd445;
add.f64 fd458, fd425, fd447;
sub.f64 fd459, fd419, fd445;
sub.f64 fd460, fd425, fd447;
add.f64 fd461, fd420, fd450;
add.f64 fd462, fd426, fd452;
sub.f64 fd463, fd420, fd450;
sub.f64 fd464, fd426, fd452;
mul.f64 fd465, fd457, 0d3FEBB67AE8584CAA;
mul.f64 fd466, fd458, 0dBFE0000000000000;
sub.f64 fd467, fd465, fd466;
mul.f64 fd468, fd458, 0d3FEBB67AE8584CAA;
fma.rn.f64 fd469, fd457, 0dBFE0000000000000, fd468;
mul.f64 fd470, fd461, 0d3FE0000000000000;
mul.f64 fd471, fd462, 0dBFEBB67AE8584CAA;
sub.f64 fd472, fd470, fd471;
mul.f64 fd473, fd462, 0d3FE0000000000000;
fma.rn.f64 fd474, fd461, 0dBFEBB67AE8584CAA, fd473;
mul.f64 fd475, fd459, 0dBFE0000000000000;
mul.f64 fd476, fd460, 0dBFEBB67AE8584CAA;
sub.f64 fd477, fd475, fd476;
mul.f64 fd478, fd460, 0dBFE0000000000000;
fma.rn.f64 fd479, fd459, 0dBFEBB67AE8584CAA, fd478;
mul.f64 fd480, fd463, 0dBFEBB67AE8584CAA;
mul.f64 fd481, fd464, 0dBFE0000000000000;
sub.f64 fd482, fd480, fd481;
mul.f64 fd483, fd464, 0dBFEBB67AE8584CAA;
fma.rn.f64 fd484, fd463, 0dBFE0000000000000, fd483;
add.f64 %1, fd400, fd454;
add.f64 %0, fd399, fd453;
add.f64 %3, fd404, fd469;
add.f64 %2, fd403, fd467;
add.f64 %5, fd408, fd474;
add.f64 %4, fd407, fd472;
sub.f64 %7, fd402, fd455;
add.f64 %6, fd401, fd456;
add.f64 %9, fd406, fd479;
add.f64 %8, fd405, fd477;
add.f64 %11, fd410, fd484;
add.f64 %10, fd409, fd482;
sub.f64 %13, fd400, fd454;
sub.f64 %12, fd399, fd453;
sub.f64 %15, fd404, fd469;
sub.f64 %14, fd403, fd467;
sub.f64 %17, fd408, fd474;
sub.f64 %16, fd407, fd472;
add.f64 %19, fd402, fd455;
sub.f64 %18, fd401, fd456;
sub.f64 %21, fd406, fd479;
sub.f64 %20, fd405, fd477;
sub.f64 %23, fd410, fd484;
sub.f64 %22, fd409, fd482;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y): "r"(smem), "l"(lut_dp_12_144), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y));
};


#endif
