#ifndef CUFFTDX_FFT_144_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_144_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<198, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<510>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 1152, r2;
mov.u32 r4, %tid.x;
add.f32 f49, %36, %47;
add.f32 f50, %26, f49;
add.f32 f51, %38, %49;
add.f32 f52, %27, f51;
mul.f32 f53, f49, 0f3F000000;
sub.f32 f54, %26, f53;
sub.f32 f55, %38, %49;
mul.f32 f56, f55, 0f3F5DB3D7;
add.f32 f57, f56, f54;
sub.f32 f58, f54, f56;
mul.f32 f59, f51, 0f3F000000;
sub.f32 f60, %27, f59;
sub.f32 f61, %36, %47;
mul.f32 f62, f61, 0f3F5DB3D7;
sub.f32 f63, f60, f62;
add.f32 f64, f62, f60;
add.f32 f65, %42, %52;
add.f32 f66, %31, f65;
add.f32 f67, %43, %54;
add.f32 f68, %33, f67;
mul.f32 f69, f65, 0f3F000000;
sub.f32 f70, %31, f69;
sub.f32 f71, %43, %54;
mul.f32 f72, f71, 0f3F5DB3D7;
add.f32 f73, f72, f70;
sub.f32 f74, f70, f72;
mul.f32 f75, f67, 0f3F000000;
sub.f32 f76, %33, f75;
sub.f32 f77, %42, %52;
mul.f32 f78, f77, 0f3F5DB3D7;
sub.f32 f79, f76, f78;
add.f32 f80, f78, f76;
mul.f32 f81, f73, 0f3F000000;
mul.f32 f82, f79, 0fBF5DB3D7;
sub.f32 f83, f81, f82;
mul.f32 f84, f79, 0f3F000000;
fma.rn.f32 f85, f73, 0fBF5DB3D7, f84;
mul.f32 f86, f74, 0fBF000000;
mul.f32 f87, f80, 0fBF5DB3D7;
sub.f32 f88, f86, f87;
mul.f32 f89, f80, 0fBF000000;
fma.rn.f32 f90, f74, 0fBF5DB3D7, f89;
add.f32 f91, f50, f66;
add.f32 f92, f52, f68;
sub.f32 f93, f50, f66;
sub.f32 f94, f52, f68;
add.f32 f95, f57, f83;
add.f32 f96, f63, f85;
sub.f32 f97, f57, f83;
sub.f32 f98, f63, f85;
add.f32 f99, f58, f88;
add.f32 f100, f64, f90;
sub.f32 f101, f58, f88;
sub.f32 f102, f64, f90;
add.f32 f103, %39, %50;
add.f32 f104, %28, f103;
add.f32 f105, %41, %51;
add.f32 f106, %30, f105;
mul.f32 f107, f103, 0f3F000000;
sub.f32 f108, %28, f107;
sub.f32 f109, %41, %51;
mul.f32 f110, f109, 0f3F5DB3D7;
add.f32 f111, f110, f108;
sub.f32 f112, f108, f110;
mul.f32 f113, f105, 0f3F000000;
sub.f32 f114, %30, f113;
sub.f32 f115, %39, %50;
mul.f32 f116, f115, 0f3F5DB3D7;
sub.f32 f117, f114, f116;
add.f32 f118, f116, f114;
add.f32 f119, %44, %55;
add.f32 f120, %34, f119;
add.f32 f121, %46, %56;
add.f32 f122, %35, f121;
mul.f32 f123, f119, 0f3F000000;
sub.f32 f124, %34, f123;
sub.f32 f125, %46, %56;
mul.f32 f126, f125, 0f3F5DB3D7;
add.f32 f127, f126, f124;
sub.f32 f128, f124, f126;
mul.f32 f129, f121, 0f3F000000;
sub.f32 f130, %35, f129;
sub.f32 f131, %44, %55;
mul.f32 f132, f131, 0f3F5DB3D7;
sub.f32 f133, f130, f132;
add.f32 f134, f132, f130;
mul.f32 f135, f127, 0f3F000000;
mul.f32 f136, f133, 0fBF5DB3D7;
sub.f32 f137, f135, f136;
mul.f32 f138, f133, 0f3F000000;
fma.rn.f32 f139, f127, 0fBF5DB3D7, f138;
mul.f32 f140, f128, 0fBF000000;
mul.f32 f141, f134, 0fBF5DB3D7;
sub.f32 f142, f140, f141;
mul.f32 f143, f134, 0fBF000000;
fma.rn.f32 f144, f128, 0fBF5DB3D7, f143;
add.f32 f145, f104, f120;
add.f32 f146, f106, f122;
sub.f32 f147, f104, f120;
sub.f32 f148, f106, f122;
add.f32 f149, f111, f137;
add.f32 f150, f117, f139;
sub.f32 f151, f111, f137;
sub.f32 f152, f117, f139;
add.f32 f153, f112, f142;
add.f32 f154, f118, f144;
sub.f32 f155, f112, f142;
sub.f32 f156, f118, f144;
mul.f32 f157, f149, 0f3F5DB3D7;
mul.f32 f158, f150, 0fBF000000;
sub.f32 f159, f157, f158;
mul.f32 f160, f150, 0f3F5DB3D7;
fma.rn.f32 f161, f149, 0fBF000000, f160;
mul.f32 f162, f153, 0f3F000000;
mul.f32 f163, f154, 0fBF5DB3D7;
sub.f32 f164, f162, f163;
mul.f32 f165, f154, 0f3F000000;
fma.rn.f32 f166, f153, 0fBF5DB3D7, f165;
mul.f32 f167, f151, 0fBF000000;
mul.f32 f168, f152, 0fBF5DB3D7;
sub.f32 f169, f167, f168;
mul.f32 f170, f152, 0fBF000000;
fma.rn.f32 f171, f151, 0fBF5DB3D7, f170;
mul.f32 f172, f155, 0fBF5DB3D7;
mul.f32 f173, f156, 0fBF000000;
sub.f32 f174, f172, f173;
mul.f32 f175, f156, 0fBF5DB3D7;
fma.rn.f32 f176, f155, 0fBF000000, f175;
sub.f32 f177, f91, f145;
sub.f32 f178, f92, f146;
add.f32 f179, f95, f159;
add.f32 f180, f96, f161;
sub.f32 f181, f95, f159;
sub.f32 f182, f96, f161;
add.f32 f183, f99, f164;
add.f32 f184, f100, f166;
sub.f32 f185, f99, f164;
sub.f32 f186, f100, f166;
add.f32 f187, f93, f148;
sub.f32 f188, f94, f147;
sub.f32 f189, f93, f148;
add.f32 f190, f94, f147;
add.f32 f191, f97, f169;
add.f32 f192, f98, f171;
sub.f32 f193, f97, f169;
sub.f32 f194, f98, f171;
add.f32 f195, f101, f174;
add.f32 f196, f102, f176;
sub.f32 f197, f101, f174;
sub.f32 f198, f102, f176;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 12;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1152, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f199, f200}, [rd6];
mul.f32 f203, f199, f179;
mul.f32 f204, f200, f180;
mul.f32 f205, f199, f180;
mul.f32 f206, f199, f199;
mul.f32 f207, f200, f200;
sub.f32 f208, f206, f207;
mul.f32 f209, f200, f199;
fma.rn.f32 f210, f200, f199, f209;
mul.f32 f211, f208, f183;
mul.f32 f212, f210, f184;
mul.f32 f213, f208, f184;
mul.f32 f214, f199, f208;
mul.f32 f215, f200, f210;
sub.f32 f216, f214, f215;
mul.f32 f217, f199, f210;
fma.rn.f32 f218, f200, f208, f217;
mul.f32 f219, f216, f187;
mul.f32 f220, f218, f188;
mul.f32 f221, f216, f188;
mul.f32 f222, f199, f216;
mul.f32 f223, f200, f218;
sub.f32 f224, f222, f223;
mul.f32 f225, f199, f218;
fma.rn.f32 f226, f200, f216, f225;
mul.f32 f227, f224, f191;
mul.f32 f228, f226, f192;
mul.f32 f229, f224, f192;
mul.f32 f230, f199, f224;
mul.f32 f231, f200, f226;
sub.f32 f232, f230, f231;
mul.f32 f233, f199, f226;
fma.rn.f32 f234, f200, f224, f233;
mul.f32 f235, f232, f195;
mul.f32 f236, f234, f196;
mul.f32 f237, f232, f196;
mul.f32 f238, f199, f232;
mul.f32 f239, f200, f234;
sub.f32 f240, f238, f239;
mul.f32 f241, f199, f234;
fma.rn.f32 f242, f200, f232, f241;
mul.f32 f243, f240, f177;
mul.f32 f244, f242, f178;
mul.f32 f245, f240, f178;
mul.f32 f246, f199, f240;
mul.f32 f247, f200, f242;
sub.f32 f248, f246, f247;
mul.f32 f249, f199, f242;
fma.rn.f32 f250, f200, f240, f249;
mul.f32 f251, f248, f181;
mul.f32 f252, f250, f182;
mul.f32 f253, f248, f182;
mul.f32 f254, f199, f248;
mul.f32 f255, f200, f250;
sub.f32 f256, f254, f255;
mul.f32 f257, f199, f250;
fma.rn.f32 f258, f200, f248, f257;
mul.f32 f259, f256, f185;
mul.f32 f260, f258, f186;
mul.f32 f261, f256, f186;
mul.f32 f262, f199, f256;
mul.f32 f263, f200, f258;
sub.f32 f264, f262, f263;
mul.f32 f265, f199, f258;
fma.rn.f32 f266, f200, f256, f265;
mul.f32 f267, f264, f189;
mul.f32 f268, f266, f190;
mul.f32 f269, f264, f190;
mul.f32 f270, f199, f264;
mul.f32 f271, f200, f266;
sub.f32 f272, f270, f271;
mul.f32 f273, f199, f266;
fma.rn.f32 f274, f200, f264, f273;
mul.f32 f275, f272, f193;
mul.f32 f276, f274, f194;
mul.f32 f277, f272, f194;
mul.f32 f278, f199, f272;
mul.f32 f279, f200, f274;
sub.f32 f280, f278, f279;
mul.f32 f281, f199, f274;
fma.rn.f32 f282, f200, f272, f281;
mul.f32 f283, f280, f197;
mul.f32 f284, f282, f198;
mul.f32 f285, f280, f198;
barrier.sync 0;
mad.lo.s32 r9, r7, 96, r8;
add.f32 f286, f92, f146;
add.f32 f287, f91, f145;
fma.rn.f32 f288, f200, f179, f205;
sub.f32 f289, f203, f204;
st.shared.v4.f32 [r9], {f287, f286, f289, f288};
fma.rn.f32 f290, f210, f183, f213;
sub.f32 f291, f211, f212;
sub.f32 f292, f219, f220;
fma.rn.f32 f293, f218, f187, f221;
st.shared.v4.f32 [r9+16], {f291, f290, f292, f293};
sub.f32 f294, f227, f228;
fma.rn.f32 f295, f226, f191, f229;
fma.rn.f32 f296, f234, f195, f237;
sub.f32 f297, f235, f236;
st.shared.v4.f32 [r9+32], {f294, f295, f297, f296};
fma.rn.f32 f298, f242, f177, f245;
sub.f32 f299, f243, f244;
fma.rn.f32 f300, f250, f181, f253;
sub.f32 f301, f251, f252;
st.shared.v4.f32 [r9+48], {f299, f298, f301, f300};
fma.rn.f32 f302, f258, f185, f261;
sub.f32 f303, f259, f260;
fma.rn.f32 f304, f266, f189, f269;
sub.f32 f305, f267, f268;
st.shared.v4.f32 [r9+64], {f303, f302, f305, f304};
fma.rn.f32 f306, f274, f193, f277;
sub.f32 f307, f275, f276;
fma.rn.f32 f308, f282, f197, f285;
sub.f32 f309, f283, f284;
st.shared.v4.f32 [r9+80], {f307, f306, f309, f308};
barrier.sync 0;
mad.lo.s32 r10, r7, -88, r9;
ld.shared.v2.f32 {f310, f311}, [r10];
ld.shared.v2.f32 {f314, f315}, [r10+96];
ld.shared.v2.f32 {f318, f319}, [r10+192];
ld.shared.v2.f32 {f322, f323}, [r10+288];
ld.shared.v2.f32 {f326, f327}, [r10+384];
ld.shared.v2.f32 {f330, f331}, [r10+480];
ld.shared.v2.f32 {f334, f335}, [r10+576];
ld.shared.v2.f32 {f338, f339}, [r10+672];
ld.shared.v2.f32 {f342, f343}, [r10+768];
ld.shared.v2.f32 {f346, f347}, [r10+864];
ld.shared.v2.f32 {f350, f351}, [r10+960];
ld.shared.v2.f32 {f354, f355}, [r10+1056];
add.f32 f358, f326, f342;
add.f32 f359, f310, f358;
add.f32 f360, f327, f343;
add.f32 f361, f311, f360;
mul.f32 f362, f358, 0f3F000000;
sub.f32 f363, f310, f362;
sub.f32 f364, f327, f343;
mul.f32 f365, f364, 0f3F5DB3D7;
add.f32 f366, f365, f363;
sub.f32 f367, f363, f365;
mul.f32 f368, f360, 0f3F000000;
sub.f32 f369, f311, f368;
sub.f32 f370, f326, f342;
mul.f32 f371, f370, 0f3F5DB3D7;
sub.f32 f372, f369, f371;
add.f32 f373, f371, f369;
add.f32 f374, f334, f350;
add.f32 f375, f318, f374;
add.f32 f376, f335, f351;
add.f32 f377, f319, f376;
mul.f32 f378, f374, 0f3F000000;
sub.f32 f379, f318, f378;
sub.f32 f380, f335, f351;
mul.f32 f381, f380, 0f3F5DB3D7;
add.f32 f382, f381, f379;
sub.f32 f383, f379, f381;
mul.f32 f384, f376, 0f3F000000;
sub.f32 f385, f319, f384;
sub.f32 f386, f334, f350;
mul.f32 f387, f386, 0f3F5DB3D7;
sub.f32 f388, f385, f387;
add.f32 f389, f387, f385;
mul.f32 f390, f382, 0f3F000000;
mul.f32 f391, f388, 0fBF5DB3D7;
sub.f32 f392, f390, f391;
mul.f32 f393, f388, 0f3F000000;
fma.rn.f32 f394, f382, 0fBF5DB3D7, f393;
mul.f32 f395, f383, 0fBF000000;
mul.f32 f396, f389, 0fBF5DB3D7;
sub.f32 f397, f395, f396;
mul.f32 f398, f389, 0fBF000000;
fma.rn.f32 f399, f383, 0fBF5DB3D7, f398;
add.f32 f400, f359, f375;
add.f32 f401, f361, f377;
sub.f32 f402, f359, f375;
sub.f32 f403, f361, f377;
add.f32 f404, f366, f392;
add.f32 f405, f372, f394;
sub.f32 f406, f366, f392;
sub.f32 f407, f372, f394;
add.f32 f408, f367, f397;
add.f32 f409, f373, f399;
sub.f32 f410, f367, f397;
sub.f32 f411, f373, f399;
add.f32 f412, f330, f346;
add.f32 f413, f314, f412;
add.f32 f414, f331, f347;
add.f32 f415, f315, f414;
mul.f32 f416, f412, 0f3F000000;
sub.f32 f417, f314, f416;
sub.f32 f418, f331, f347;
mul.f32 f419, f418, 0f3F5DB3D7;
add.f32 f420, f419, f417;
sub.f32 f421, f417, f419;
mul.f32 f422, f414, 0f3F000000;
sub.f32 f423, f315, f422;
sub.f32 f424, f330, f346;
mul.f32 f425, f424, 0f3F5DB3D7;
sub.f32 f426, f423, f425;
add.f32 f427, f425, f423;
add.f32 f428, f338, f354;
add.f32 f429, f322, f428;
add.f32 f430, f339, f355;
add.f32 f431, f323, f430;
mul.f32 f432, f428, 0f3F000000;
sub.f32 f433, f322, f432;
sub.f32 f434, f339, f355;
mul.f32 f435, f434, 0f3F5DB3D7;
add.f32 f436, f435, f433;
sub.f32 f437, f433, f435;
mul.f32 f438, f430, 0f3F000000;
sub.f32 f439, f323, f438;
sub.f32 f440, f338, f354;
mul.f32 f441, f440, 0f3F5DB3D7;
sub.f32 f442, f439, f441;
add.f32 f443, f441, f439;
mul.f32 f444, f436, 0f3F000000;
mul.f32 f445, f442, 0fBF5DB3D7;
sub.f32 f446, f444, f445;
mul.f32 f447, f442, 0f3F000000;
fma.rn.f32 f448, f436, 0fBF5DB3D7, f447;
mul.f32 f449, f437, 0fBF000000;
mul.f32 f450, f443, 0fBF5DB3D7;
sub.f32 f451, f449, f450;
mul.f32 f452, f443, 0fBF000000;
fma.rn.f32 f453, f437, 0fBF5DB3D7, f452;
add.f32 f454, f413, f429;
add.f32 f455, f415, f431;
sub.f32 f456, f413, f429;
sub.f32 f457, f415, f431;
add.f32 f458, f420, f446;
add.f32 f459, f426, f448;
sub.f32 f460, f420, f446;
sub.f32 f461, f426, f448;
add.f32 f462, f421, f451;
add.f32 f463, f427, f453;
sub.f32 f464, f421, f451;
sub.f32 f465, f427, f453;
mul.f32 f466, f458, 0f3F5DB3D7;
mul.f32 f467, f459, 0fBF000000;
sub.f32 f468, f466, f467;
mul.f32 f469, f459, 0f3F5DB3D7;
fma.rn.f32 f470, f458, 0fBF000000, f469;
mul.f32 f471, f462, 0f3F000000;
mul.f32 f472, f463, 0fBF5DB3D7;
sub.f32 f473, f471, f472;
mul.f32 f474, f463, 0f3F000000;
fma.rn.f32 f475, f462, 0fBF5DB3D7, f474;
mul.f32 f476, f460, 0fBF000000;
mul.f32 f477, f461, 0fBF5DB3D7;
sub.f32 f478, f476, f477;
mul.f32 f479, f461, 0fBF000000;
fma.rn.f32 f480, f460, 0fBF5DB3D7, f479;
mul.f32 f481, f464, 0fBF5DB3D7;
mul.f32 f482, f465, 0fBF000000;
sub.f32 f483, f481, f482;
mul.f32 f484, f465, 0fBF5DB3D7;
fma.rn.f32 f485, f464, 0fBF000000, f484;
add.f32 %1, f401, f455;
add.f32 %0, f400, f454;
add.f32 %3, f405, f470;
add.f32 %2, f404, f468;
add.f32 %5, f409, f475;
add.f32 %4, f408, f473;
sub.f32 %7, f403, f456;
add.f32 %6, f402, f457;
add.f32 %9, f407, f480;
add.f32 %8, f406, f478;
add.f32 %11, f411, f485;
add.f32 %10, f410, f483;
sub.f32 %13, f401, f455;
sub.f32 %12, f400, f454;
sub.f32 %15, f405, f470;
sub.f32 %14, f404, f468;
sub.f32 %17, f409, f475;
sub.f32 %16, f408, f473;
add.f32 %19, f403, f456;
sub.f32 %18, f402, f457;
sub.f32 %21, f407, f480;
sub.f32 %20, f406, f478;
sub.f32 %23, f411, f485;
sub.f32 %22, f410, f483;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y): "r"(smem), "l"(lut_sp_12_144), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<199, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<486>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %24;
mad.lo.s32 r3, r1, 576, r2;
mov.u32 r4, %tid.x;
add.f32 f49, %36, %47;
add.f32 f50, %26, f49;
add.f32 f51, %38, %49;
add.f32 f52, %27, f51;
mul.f32 f53, f49, 0f3F000000;
sub.f32 f54, %26, f53;
sub.f32 f55, %38, %49;
mul.f32 f56, f55, 0f3F5DB3D7;
add.f32 f57, f56, f54;
sub.f32 f58, f54, f56;
mul.f32 f59, f51, 0f3F000000;
sub.f32 f60, %27, f59;
sub.f32 f61, %36, %47;
mul.f32 f62, f61, 0f3F5DB3D7;
sub.f32 f63, f60, f62;
add.f32 f64, f62, f60;
add.f32 f65, %42, %52;
add.f32 f66, %31, f65;
add.f32 f67, %43, %54;
add.f32 f68, %33, f67;
mul.f32 f69, f65, 0f3F000000;
sub.f32 f70, %31, f69;
sub.f32 f71, %43, %54;
mul.f32 f72, f71, 0f3F5DB3D7;
add.f32 f73, f72, f70;
sub.f32 f74, f70, f72;
mul.f32 f75, f67, 0f3F000000;
sub.f32 f76, %33, f75;
sub.f32 f77, %42, %52;
mul.f32 f78, f77, 0f3F5DB3D7;
sub.f32 f79, f76, f78;
add.f32 f80, f78, f76;
mul.f32 f81, f73, 0f3F000000;
mul.f32 f82, f79, 0fBF5DB3D7;
sub.f32 f83, f81, f82;
mul.f32 f84, f79, 0f3F000000;
fma.rn.f32 f85, f73, 0fBF5DB3D7, f84;
mul.f32 f86, f74, 0fBF000000;
mul.f32 f87, f80, 0fBF5DB3D7;
sub.f32 f88, f86, f87;
mul.f32 f89, f80, 0fBF000000;
fma.rn.f32 f90, f74, 0fBF5DB3D7, f89;
add.f32 f91, f50, f66;
add.f32 f92, f52, f68;
sub.f32 f93, f50, f66;
sub.f32 f94, f52, f68;
add.f32 f95, f57, f83;
add.f32 f96, f63, f85;
sub.f32 f97, f57, f83;
sub.f32 f98, f63, f85;
add.f32 f99, f58, f88;
add.f32 f100, f64, f90;
sub.f32 f101, f58, f88;
sub.f32 f102, f64, f90;
add.f32 f103, %39, %50;
add.f32 f104, %28, f103;
add.f32 f105, %41, %51;
add.f32 f106, %30, f105;
mul.f32 f107, f103, 0f3F000000;
sub.f32 f108, %28, f107;
sub.f32 f109, %41, %51;
mul.f32 f110, f109, 0f3F5DB3D7;
add.f32 f111, f110, f108;
sub.f32 f112, f108, f110;
mul.f32 f113, f105, 0f3F000000;
sub.f32 f114, %30, f113;
sub.f32 f115, %39, %50;
mul.f32 f116, f115, 0f3F5DB3D7;
sub.f32 f117, f114, f116;
add.f32 f118, f116, f114;
add.f32 f119, %44, %55;
add.f32 f120, %34, f119;
add.f32 f121, %46, %56;
add.f32 f122, %35, f121;
mul.f32 f123, f119, 0f3F000000;
sub.f32 f124, %34, f123;
sub.f32 f125, %46, %56;
mul.f32 f126, f125, 0f3F5DB3D7;
add.f32 f127, f126, f124;
sub.f32 f128, f124, f126;
mul.f32 f129, f121, 0f3F000000;
sub.f32 f130, %35, f129;
sub.f32 f131, %44, %55;
mul.f32 f132, f131, 0f3F5DB3D7;
sub.f32 f133, f130, f132;
add.f32 f134, f132, f130;
mul.f32 f135, f127, 0f3F000000;
mul.f32 f136, f133, 0fBF5DB3D7;
sub.f32 f137, f135, f136;
mul.f32 f138, f133, 0f3F000000;
fma.rn.f32 f139, f127, 0fBF5DB3D7, f138;
mul.f32 f140, f128, 0fBF000000;
mul.f32 f141, f134, 0fBF5DB3D7;
sub.f32 f142, f140, f141;
mul.f32 f143, f134, 0fBF000000;
fma.rn.f32 f144, f128, 0fBF5DB3D7, f143;
add.f32 f145, f104, f120;
add.f32 f146, f106, f122;
sub.f32 f147, f104, f120;
sub.f32 f148, f106, f122;
add.f32 f149, f111, f137;
add.f32 f150, f117, f139;
sub.f32 f151, f111, f137;
sub.f32 f152, f117, f139;
add.f32 f153, f112, f142;
add.f32 f154, f118, f144;
sub.f32 f155, f112, f142;
sub.f32 f156, f118, f144;
mul.f32 f157, f149, 0f3F5DB3D7;
mul.f32 f158, f150, 0fBF000000;
sub.f32 f159, f157, f158;
mul.f32 f160, f150, 0f3F5DB3D7;
fma.rn.f32 f161, f149, 0fBF000000, f160;
mul.f32 f162, f153, 0f3F000000;
mul.f32 f163, f154, 0fBF5DB3D7;
sub.f32 f164, f162, f163;
mul.f32 f165, f154, 0f3F000000;
fma.rn.f32 f166, f153, 0fBF5DB3D7, f165;
mul.f32 f167, f151, 0fBF000000;
mul.f32 f168, f152, 0fBF5DB3D7;
sub.f32 f169, f167, f168;
mul.f32 f170, f152, 0fBF000000;
fma.rn.f32 f171, f151, 0fBF5DB3D7, f170;
mul.f32 f172, f155, 0fBF5DB3D7;
mul.f32 f173, f156, 0fBF000000;
sub.f32 f174, f172, f173;
mul.f32 f175, f156, 0fBF5DB3D7;
fma.rn.f32 f176, f155, 0fBF000000, f175;
add.f32 f177, f91, f145;
add.f32 f178, f92, f146;
sub.f32 f179, f91, f145;
sub.f32 f180, f92, f146;
add.f32 f181, f95, f159;
add.f32 f182, f96, f161;
sub.f32 f183, f95, f159;
sub.f32 f184, f96, f161;
add.f32 f185, f99, f164;
add.f32 f186, f100, f166;
sub.f32 f187, f99, f164;
sub.f32 f188, f100, f166;
add.f32 f189, f93, f148;
sub.f32 f190, f94, f147;
sub.f32 f191, f93, f148;
add.f32 f192, f94, f147;
add.f32 f193, f97, f169;
add.f32 f194, f98, f171;
sub.f32 f195, f97, f169;
sub.f32 f196, f98, f171;
add.f32 f197, f101, f174;
add.f32 f198, f102, f176;
sub.f32 f199, f101, f174;
sub.f32 f200, f102, f176;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 12;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %25;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f201, f202}, [rd6];
mul.f32 f205, f201, f181;
mul.f32 f206, f202, f182;
sub.f32 f207, f205, f206;
mul.f32 f208, f201, f182;
fma.rn.f32 f209, f202, f181, f208;
mul.f32 f210, f201, f201;
mul.f32 f211, f202, f202;
sub.f32 f212, f210, f211;
mul.f32 f213, f202, f201;
fma.rn.f32 f214, f202, f201, f213;
mul.f32 f215, f212, f185;
mul.f32 f216, f214, f186;
sub.f32 f217, f215, f216;
mul.f32 f218, f212, f186;
fma.rn.f32 f219, f214, f185, f218;
mul.f32 f220, f201, f212;
mul.f32 f221, f202, f214;
sub.f32 f222, f220, f221;
mul.f32 f223, f201, f214;
fma.rn.f32 f224, f202, f212, f223;
mul.f32 f225, f222, f189;
mul.f32 f226, f224, f190;
sub.f32 f227, f225, f226;
mul.f32 f228, f222, f190;
fma.rn.f32 f229, f224, f189, f228;
mul.f32 f230, f201, f222;
mul.f32 f231, f202, f224;
sub.f32 f232, f230, f231;
mul.f32 f233, f201, f224;
fma.rn.f32 f234, f202, f222, f233;
mul.f32 f235, f232, f193;
mul.f32 f236, f234, f194;
sub.f32 f237, f235, f236;
mul.f32 f238, f232, f194;
fma.rn.f32 f239, f234, f193, f238;
mul.f32 f240, f201, f232;
mul.f32 f241, f202, f234;
sub.f32 f242, f240, f241;
mul.f32 f243, f201, f234;
fma.rn.f32 f244, f202, f232, f243;
mul.f32 f245, f242, f197;
mul.f32 f246, f244, f198;
sub.f32 f247, f245, f246;
mul.f32 f248, f242, f198;
fma.rn.f32 f249, f244, f197, f248;
mul.f32 f250, f201, f242;
mul.f32 f251, f202, f244;
sub.f32 f252, f250, f251;
mul.f32 f253, f201, f244;
fma.rn.f32 f254, f202, f242, f253;
mul.f32 f255, f252, f179;
mul.f32 f256, f254, f180;
sub.f32 f257, f255, f256;
mul.f32 f258, f252, f180;
fma.rn.f32 f259, f254, f179, f258;
mul.f32 f260, f201, f252;
mul.f32 f261, f202, f254;
sub.f32 f262, f260, f261;
mul.f32 f263, f201, f254;
fma.rn.f32 f264, f202, f252, f263;
mul.f32 f265, f262, f183;
mul.f32 f266, f264, f184;
sub.f32 f267, f265, f266;
mul.f32 f268, f262, f184;
fma.rn.f32 f269, f264, f183, f268;
mul.f32 f270, f201, f262;
mul.f32 f271, f202, f264;
sub.f32 f272, f270, f271;
mul.f32 f273, f201, f264;
fma.rn.f32 f274, f202, f262, f273;
mul.f32 f275, f272, f187;
mul.f32 f276, f274, f188;
sub.f32 f277, f275, f276;
mul.f32 f278, f272, f188;
fma.rn.f32 f279, f274, f187, f278;
mul.f32 f280, f201, f272;
mul.f32 f281, f202, f274;
sub.f32 f282, f280, f281;
mul.f32 f283, f201, f274;
fma.rn.f32 f284, f202, f272, f283;
mul.f32 f285, f282, f191;
mul.f32 f286, f284, f192;
sub.f32 f287, f285, f286;
mul.f32 f288, f282, f192;
fma.rn.f32 f289, f284, f191, f288;
mul.f32 f290, f201, f282;
mul.f32 f291, f202, f284;
sub.f32 f292, f290, f291;
mul.f32 f293, f201, f284;
fma.rn.f32 f294, f202, f282, f293;
mul.f32 f295, f292, f195;
mul.f32 f296, f294, f196;
sub.f32 f297, f295, f296;
mul.f32 f298, f292, f196;
fma.rn.f32 f299, f294, f195, f298;
mul.f32 f300, f201, f292;
mul.f32 f301, f202, f294;
sub.f32 f302, f300, f301;
mul.f32 f303, f201, f294;
fma.rn.f32 f304, f202, f292, f303;
mul.f32 f305, f302, f199;
mul.f32 f306, f304, f200;
sub.f32 f307, f305, f306;
mul.f32 f308, f302, f200;
fma.rn.f32 f309, f304, f199, f308;
mad.lo.s32 r8, r5, 576, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 48, r8;
st.shared.v4.f32 [r9], {f177, f207, f217, f227};
st.shared.v4.f32 [r9+16], {f237, f247, f257, f267};
st.shared.v4.f32 [r9+32], {f277, f287, f297, f307};
barrier.sync 0;
mad.lo.s32 r10, r7, -44, r9;
ld.shared.f32 f310, [r10];
ld.shared.f32 f311, [r10+48];
ld.shared.f32 f312, [r10+96];
ld.shared.f32 f313, [r10+144];
ld.shared.f32 f314, [r10+192];
ld.shared.f32 f315, [r10+240];
ld.shared.f32 f316, [r10+288];
ld.shared.f32 f317, [r10+336];
ld.shared.f32 f318, [r10+384];
ld.shared.f32 f319, [r10+432];
ld.shared.f32 f320, [r10+480];
ld.shared.f32 f321, [r10+528];
barrier.sync 0;
st.shared.v4.f32 [r9], {f178, f209, f219, f229};
st.shared.v4.f32 [r9+16], {f239, f249, f259, f269};
st.shared.v4.f32 [r9+32], {f279, f289, f299, f309};
barrier.sync 0;
ld.shared.f32 f322, [r10];
ld.shared.f32 f323, [r10+48];
ld.shared.f32 f324, [r10+96];
ld.shared.f32 f325, [r10+144];
ld.shared.f32 f326, [r10+192];
ld.shared.f32 f327, [r10+240];
ld.shared.f32 f328, [r10+288];
ld.shared.f32 f329, [r10+336];
ld.shared.f32 f330, [r10+384];
ld.shared.f32 f331, [r10+432];
ld.shared.f32 f332, [r10+480];
ld.shared.f32 f333, [r10+528];
add.f32 f334, f314, f318;
add.f32 f335, f310, f334;
add.f32 f336, f326, f330;
add.f32 f337, f322, f336;
mul.f32 f338, f334, 0f3F000000;
sub.f32 f339, f310, f338;
sub.f32 f340, f326, f330;
mul.f32 f341, f340, 0f3F5DB3D7;
add.f32 f342, f341, f339;
sub.f32 f343, f339, f341;
mul.f32 f344, f336, 0f3F000000;
sub.f32 f345, f322, f344;
sub.f32 f346, f314, f318;
mul.f32 f347, f346, 0f3F5DB3D7;
sub.f32 f348, f345, f347;
add.f32 f349, f347, f345;
add.f32 f350, f316, f320;
add.f32 f351, f312, f350;
add.f32 f352, f328, f332;
add.f32 f353, f324, f352;
mul.f32 f354, f350, 0f3F000000;
sub.f32 f355, f312, f354;
sub.f32 f356, f328, f332;
mul.f32 f357, f356, 0f3F5DB3D7;
add.f32 f358, f357, f355;
sub.f32 f359, f355, f357;
mul.f32 f360, f352, 0f3F000000;
sub.f32 f361, f324, f360;
sub.f32 f362, f316, f320;
mul.f32 f363, f362, 0f3F5DB3D7;
sub.f32 f364, f361, f363;
add.f32 f365, f363, f361;
mul.f32 f366, f358, 0f3F000000;
mul.f32 f367, f364, 0fBF5DB3D7;
sub.f32 f368, f366, f367;
mul.f32 f369, f364, 0f3F000000;
fma.rn.f32 f370, f358, 0fBF5DB3D7, f369;
mul.f32 f371, f359, 0fBF000000;
mul.f32 f372, f365, 0fBF5DB3D7;
sub.f32 f373, f371, f372;
mul.f32 f374, f365, 0fBF000000;
fma.rn.f32 f375, f359, 0fBF5DB3D7, f374;
add.f32 f376, f335, f351;
add.f32 f377, f337, f353;
sub.f32 f378, f335, f351;
sub.f32 f379, f337, f353;
add.f32 f380, f342, f368;
add.f32 f381, f348, f370;
sub.f32 f382, f342, f368;
sub.f32 f383, f348, f370;
add.f32 f384, f343, f373;
add.f32 f385, f349, f375;
sub.f32 f386, f343, f373;
sub.f32 f387, f349, f375;
add.f32 f388, f315, f319;
add.f32 f389, f311, f388;
add.f32 f390, f327, f331;
add.f32 f391, f323, f390;
mul.f32 f392, f388, 0f3F000000;
sub.f32 f393, f311, f392;
sub.f32 f394, f327, f331;
mul.f32 f395, f394, 0f3F5DB3D7;
add.f32 f396, f395, f393;
sub.f32 f397, f393, f395;
mul.f32 f398, f390, 0f3F000000;
sub.f32 f399, f323, f398;
sub.f32 f400, f315, f319;
mul.f32 f401, f400, 0f3F5DB3D7;
sub.f32 f402, f399, f401;
add.f32 f403, f401, f399;
add.f32 f404, f317, f321;
add.f32 f405, f313, f404;
add.f32 f406, f329, f333;
add.f32 f407, f325, f406;
mul.f32 f408, f404, 0f3F000000;
sub.f32 f409, f313, f408;
sub.f32 f410, f329, f333;
mul.f32 f411, f410, 0f3F5DB3D7;
add.f32 f412, f411, f409;
sub.f32 f413, f409, f411;
mul.f32 f414, f406, 0f3F000000;
sub.f32 f415, f325, f414;
sub.f32 f416, f317, f321;
mul.f32 f417, f416, 0f3F5DB3D7;
sub.f32 f418, f415, f417;
add.f32 f419, f417, f415;
mul.f32 f420, f412, 0f3F000000;
mul.f32 f421, f418, 0fBF5DB3D7;
sub.f32 f422, f420, f421;
mul.f32 f423, f418, 0f3F000000;
fma.rn.f32 f424, f412, 0fBF5DB3D7, f423;
mul.f32 f425, f413, 0fBF000000;
mul.f32 f426, f419, 0fBF5DB3D7;
sub.f32 f427, f425, f426;
mul.f32 f428, f419, 0fBF000000;
fma.rn.f32 f429, f413, 0fBF5DB3D7, f428;
add.f32 f430, f389, f405;
add.f32 f431, f391, f407;
sub.f32 f432, f389, f405;
sub.f32 f433, f391, f407;
add.f32 f434, f396, f422;
add.f32 f435, f402, f424;
sub.f32 f436, f396, f422;
sub.f32 f437, f402, f424;
add.f32 f438, f397, f427;
add.f32 f439, f403, f429;
sub.f32 f440, f397, f427;
sub.f32 f441, f403, f429;
mul.f32 f442, f434, 0f3F5DB3D7;
mul.f32 f443, f435, 0fBF000000;
sub.f32 f444, f442, f443;
mul.f32 f445, f435, 0f3F5DB3D7;
fma.rn.f32 f446, f434, 0fBF000000, f445;
mul.f32 f447, f438, 0f3F000000;
mul.f32 f448, f439, 0fBF5DB3D7;
sub.f32 f449, f447, f448;
mul.f32 f450, f439, 0f3F000000;
fma.rn.f32 f451, f438, 0fBF5DB3D7, f450;
mul.f32 f452, f436, 0fBF000000;
mul.f32 f453, f437, 0fBF5DB3D7;
sub.f32 f454, f452, f453;
mul.f32 f455, f437, 0fBF000000;
fma.rn.f32 f456, f436, 0fBF5DB3D7, f455;
mul.f32 f457, f440, 0fBF5DB3D7;
mul.f32 f458, f441, 0fBF000000;
sub.f32 f459, f457, f458;
mul.f32 f460, f441, 0fBF5DB3D7;
fma.rn.f32 f461, f440, 0fBF000000, f460;
add.f32 %0, f376, f430;
add.f32 %1, f377, f431;
add.f32 %3, f381, f446;
add.f32 %2, f380, f444;
add.f32 %5, f385, f451;
add.f32 %4, f384, f449;
sub.f32 %7, f379, f432;
add.f32 %6, f378, f433;
add.f32 %9, f383, f456;
add.f32 %8, f382, f454;
add.f32 %11, f387, f461;
add.f32 %10, f386, f459;
sub.f32 %12, f376, f430;
sub.f32 %13, f377, f431;
sub.f32 %15, f381, f446;
sub.f32 %14, f380, f444;
sub.f32 %17, f385, f451;
sub.f32 %16, f384, f449;
add.f32 %19, f379, f432;
sub.f32 %18, f378, f433;
sub.f32 %21, f383, f456;
sub.f32 %20, f382, f454;
sub.f32 %23, f387, f461;
sub.f32 %22, f386, f459;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y): "r"(smem), "l"(lut_sp_12_144), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y));
};


#endif
