//Copyright (c) 2019-2022, NVIDIA CORPORATION.  All rights reserved.
//
//NVIDIA CORPORATION and its licensors retain all intellectual property
//and proprietary rights in and to this software, related documentation
//and any modifications thereto.  Any use, reproduction, disclosure or
//distribution of this software and related documentation without an express
//license agreement from NVIDIA CORPORATION is strictly prohibited.
//


// Pre-computed twiddles for N=2
#define T_2_0 {1.0,0.0}
#define T_2_1 {-1.0,0.0}
// Pre-computed twiddles for N=3
#define T_3_1 {-0.5,-0.8660254037844385965883020617184229195118}
#define T_3_2 {-0.5,0.8660254037844385965883020617184229195118}
// Pre-computed twiddles for N=4
#define T_4_1 {0.0,-1.0}
#define T_4_3 {-0.0,1.0}
// Pre-computed twiddles for N=5
#define T_5_1 {0.3090169943749474512628694355953484773636,-0.9510565162951535311819384332920890301466}
#define T_5_2 {-0.8090169943749474512628694355953484773636,-0.5877852522924731371034567928290925920010}
#define T_5_3 {-0.8090169943749474512628694355953484773636,0.5877852522924731371034567928290925920010}
#define T_5_4 {0.3090169943749474512628694355953484773636,0.9510565162951535311819384332920890301466}
// Pre-computed twiddles for N=6
#define T_6_1 {0.5,-0.8660254037844385965883020617184229195118}
#define T_6_5 {0.5,0.8660254037844385965883020617184229195118}
// Pre-computed twiddles for N=7
#define T_7_1 {0.6234898018587334833640056785952765494585,-0.7818314824680298036341241640911903232336}
#define T_7_2 {-0.2225209339563143928764077372761676087976,-0.9749279121818236193419693336181808263063}
#define T_7_3 {-0.9009688679024191459987491725769359618425,-0.4338837391175581204016964420588919892907}
#define T_7_4 {-0.9009688679024191459987491725769359618425,0.4338837391175581204016964420588919892907}
#define T_7_5 {-0.2225209339563143928764077372761676087976,0.9749279121818236193419693336181808263063}
#define T_7_6 {0.6234898018587334833640056785952765494585,0.7818314824680298036341241640911903232336}
// Pre-computed twiddles for N=8
#define T_8_1 {0.7071067811865475727373109293694142252207,-0.7071067811865475727373109293694142252207}
#define T_8_3 {-0.7071067811865475727373109293694142252207,-0.7071067811865475727373109293694142252207}
#define T_8_5 {-0.7071067811865475727373109293694142252207,0.7071067811865475727373109293694142252207}
#define T_8_7 {0.7071067811865475727373109293694142252207,0.7071067811865475727373109293694142252207}
// Pre-computed twiddles for N=9
#define T_9_1 {0.7660444431189780134516809084743726998568,-0.6427876096865393629187224178167525678873}
#define T_9_2 {0.1736481776669303589422099776129471138120,-0.9848077530122080203156542665965389460325}
#define T_9_4 {-0.9396926207859084279050421173451468348503,-0.3420201433256687129080830800376133993268}
#define T_9_5 {-0.9396926207859084279050421173451468348503,0.3420201433256687129080830800376133993268}
#define T_9_7 {0.1736481776669303589422099776129471138120,0.9848077530122080203156542665965389460325}
#define T_9_8 {0.7660444431189780134516809084743726998568,0.6427876096865393629187224178167525678873}
// Pre-computed twiddles for N=10
#define T_10_1 {0.8090169943749474512628694355953484773636,-0.5877852522924731371034567928290925920010}
#define T_10_3 {-0.3090169943749474512628694355953484773636,-0.9510565162951535311819384332920890301466}
#define T_10_7 {-0.3090169943749474512628694355953484773636,0.9510565162951535311819384332920890301466}
#define T_10_9 {0.8090169943749474512628694355953484773636,0.5877852522924731371034567928290925920010}
// Pre-computed twiddles for N=11
#define T_11_1 {0.8412535328311812055090967987780459225178,-0.5406408174555975554298470342473592609167}
#define T_11_2 {0.4154150130018864350844864929968025535345,-0.9096319953545183301102383666147943586111}
#define T_11_3 {-0.1423148382732851435772403192459023557603,-0.9898214418809326842207951813179533928633}
#define T_11_4 {-0.6548607339452851006100786435126792639494,-0.7557495743542582689045161714602727442980}
#define T_11_5 {-0.9594929736144973686506887133873533457518,-0.2817325568414296710351152341900160536170}
#define T_11_6 {-0.9594929736144973686506887133873533457518,0.2817325568414296710351152341900160536170}
#define T_11_7 {-0.6548607339452851006100786435126792639494,0.7557495743542582689045161714602727442980}
#define T_11_8 {-0.1423148382732851435772403192459023557603,0.9898214418809326842207951813179533928633}
#define T_11_9 {0.4154150130018864350844864929968025535345,0.9096319953545183301102383666147943586111}
#define T_11_10 {0.8412535328311812055090967987780459225178,0.5406408174555975554298470342473592609167}
// Pre-computed twiddles for N=12
#define T_12_1 {0.8660254037844385965883020617184229195118,-0.5}
#define T_12_5 {-0.8660254037844385965883020617184229195118,-0.5}
#define T_12_7 {-0.8660254037844385965883020617184229195118,0.5}
#define T_12_11 {0.8660254037844385965883020617184229195118,0.5}
// Pre-computed twiddles for N=13
#define T_13_1 {0.8854560256532099105086786039464641362429,-0.4647231720437685620339607339701615273952}
#define T_13_2 {0.5680647467311558118652214943722356110811,-0.8229838658936563522416918203816749155521}
#define T_13_3 {0.1205366802553230476391377123945858329535,-0.9927088740980539727232212499075103551149}
#define T_13_4 {-0.3546048870425356214219902994955191388726,-0.9350162426854148334243177487223874777555}
#define T_13_5 {-0.7485107481711010812830409122398123145103,-0.6631226582407951930520084715681150555611}
#define T_13_6 {-0.9709418174260520117968553677201271057129,-0.2393156642875577666540465315847541205585}
#define T_13_7 {-0.9709418174260520117968553677201271057129,0.2393156642875577666540465315847541205585}
#define T_13_8 {-0.7485107481711010812830409122398123145103,0.6631226582407951930520084715681150555611}
#define T_13_9 {-0.3546048870425356214219902994955191388726,0.9350162426854148334243177487223874777555}
#define T_13_10 {0.1205366802553230476391377123945858329535,0.9927088740980539727232212499075103551149}
#define T_13_11 {0.5680647467311558118652214943722356110811,0.8229838658936563522416918203816749155521}
#define T_13_12 {0.8854560256532099105086786039464641362429,0.4647231720437685620339607339701615273952}
// Pre-computed twiddles for N=14
#define T_14_1 {0.9009688679024191459987491725769359618425,-0.4338837391175581204016964420588919892907}
#define T_14_3 {0.2225209339563143928764077372761676087976,-0.9749279121818236193419693336181808263063}
#define T_14_5 {-0.6234898018587334833640056785952765494585,-0.7818314824680298036341241640911903232336}
#define T_14_9 {-0.6234898018587334833640056785952765494585,0.7818314824680298036341241640911903232336}
#define T_14_11 {0.2225209339563143928764077372761676087976,0.9749279121818236193419693336181808263063}
#define T_14_13 {0.9009688679024191459987491725769359618425,0.4338837391175581204016964420588919892907}
// Pre-computed twiddles for N=15
#define T_15_1 {0.9135454576426008665990252666233573108912,-0.4067366430758002082690438783174613490701}
#define T_15_2 {0.6691306063588582375700752891134470701218,-0.7431448254773942441175904605188407003880}
#define T_15_4 {-0.1045284632676534708473070622858358547091,-0.9945218953682732898613494398887269198895}
#define T_15_7 {-0.9781476007338056888329447247087955474854,-0.2079116908177593425754992040310753509402}
#define T_15_8 {-0.9781476007338056888329447247087955474854,0.2079116908177593425754992040310753509402}
#define T_15_11 {-0.1045284632676534708473070622858358547091,0.9945218953682732898613494398887269198895}
#define T_15_13 {0.6691306063588582375700752891134470701218,0.7431448254773942441175904605188407003880}
#define T_15_14 {0.9135454576426008665990252666233573108912,0.4067366430758002082690438783174613490701}
// Pre-computed twiddles for N=16
#define T_16_1 {0.9238795325112867384831361050601117312908,-0.3826834323650897817792326804919866845012}
#define T_16_3 {0.3826834323650897817792326804919866845012,-0.9238795325112867384831361050601117312908}
#define T_16_5 {-0.3826834323650897817792326804919866845012,-0.9238795325112867384831361050601117312908}
#define T_16_7 {-0.9238795325112867384831361050601117312908,-0.3826834323650897817792326804919866845012}
#define T_16_9 {-0.9238795325112867384831361050601117312908,0.3826834323650897817792326804919866845012}
#define T_16_11 {-0.3826834323650897817792326804919866845012,0.9238795325112867384831361050601117312908}
#define T_16_13 {0.3826834323650897817792326804919866845012,0.9238795325112867384831361050601117312908}
#define T_16_15 {0.9238795325112867384831361050601117312908,0.3826834323650897817792326804919866845012}
// Pre-computed twiddles for N=17
#define T_17_1 {0.9324722294043558123988191255193669348955,-0.3612416661871529210969811174436472356319}
#define T_17_2 {0.7390089172206590895086719683604314923286,-0.6736956436465572073402086061832960695028}
#define T_17_3 {0.4457383557765382531279385602829279378057,-0.8951632913550623404930206561402883380651}
#define T_17_4 {0.0922683594633020021102964847159455530345,-0.9957341762950344676852409975253976881504}
#define T_17_5 {-0.2736629900720828900695380525576183572412,-0.9618256431728190447572046650748234242201}
#define T_17_6 {-0.6026346363792564053696310111263301223516,-0.7980172272802394939361647629993967711926}
#define T_17_7 {-0.8502171357296141041004489125043619424105,-0.5264321628773558359171147458255290985107}
#define T_17_8 {-0.9829730996839017853616837783192750066519,-0.1837495178165703402228814411500934511423}
#define T_17_9 {-0.9829730996839017853616837783192750066519,0.1837495178165703402228814411500934511423}
#define T_17_10 {-0.8502171357296141041004489125043619424105,0.5264321628773558359171147458255290985107}
#define T_17_11 {-0.6026346363792564053696310111263301223516,0.7980172272802394939361647629993967711926}
#define T_17_12 {-0.2736629900720828900695380525576183572412,0.9618256431728190447572046650748234242201}
#define T_17_13 {0.0922683594633020021102964847159455530345,0.9957341762950344676852409975253976881504}
#define T_17_14 {0.4457383557765382531279385602829279378057,0.8951632913550623404930206561402883380651}
#define T_17_15 {0.7390089172206590895086719683604314923286,0.6736956436465572073402086061832960695028}
#define T_17_16 {0.9324722294043558123988191255193669348955,0.3612416661871529210969811174436472356319}
// Pre-computed twiddles for N=18
#define T_18_1 {0.9396926207859084279050421173451468348503,-0.3420201433256687129080830800376133993268}
#define T_18_5 {-0.1736481776669303589422099776129471138120,-0.9848077530122080203156542665965389460325}
#define T_18_7 {-0.7660444431189780134516809084743726998568,-0.6427876096865393629187224178167525678873}
#define T_18_11 {-0.7660444431189780134516809084743726998568,0.6427876096865393629187224178167525678873}
#define T_18_13 {-0.1736481776669303589422099776129471138120,0.9848077530122080203156542665965389460325}
#define T_18_17 {0.9396926207859084279050421173451468348503,0.3420201433256687129080830800376133993268}
// Pre-computed twiddles for N=19
#define T_19_1 {0.9458172417006346366363800370891112834215,-0.3246994692046835107035462897329125553370}
#define T_19_2 {0.7891405093963935746259608094987925142050,-0.6142127126896678168677112807927187532187}
#define T_19_3 {0.5469481581224269195473652871442027390003,-0.8371664782625285461392650177003815770149}
#define T_19_4 {0.2454854871407991523390990096231689676642,-0.9694002659393303744650438602548092603683}
#define T_19_5 {-0.0825793454723323244737187565078784245998,-0.9965844930066698470483288474497385323048}
#define T_19_6 {-0.4016954246529694794176634786708746105433,-0.9157733266550573958397762908134609460831}
#define T_19_7 {-0.6772815716257410967315877314831595867872,-0.7357239106731315869680543073627632111311}
#define T_19_8 {-0.8794737512064890738727740426838863641024,-0.4759473930370735628159195584885310381651}
#define T_19_9 {-0.9863613034027223225308489418239332735538,-0.1645945902807338934170644506593816913664}
#define T_19_10 {-0.9863613034027223225308489418239332735538,0.1645945902807338934170644506593816913664}
#define T_19_11 {-0.8794737512064890738727740426838863641024,0.4759473930370735628159195584885310381651}
#define T_19_12 {-0.6772815716257410967315877314831595867872,0.7357239106731315869680543073627632111311}
#define T_19_13 {-0.4016954246529694794176634786708746105433,0.9157733266550573958397762908134609460831}
#define T_19_14 {-0.0825793454723323244737187565078784245998,0.9965844930066698470483288474497385323048}
#define T_19_15 {0.2454854871407991523390990096231689676642,0.9694002659393303744650438602548092603683}
#define T_19_16 {0.5469481581224269195473652871442027390003,0.8371664782625285461392650177003815770149}
#define T_19_17 {0.7891405093963935746259608094987925142050,0.6142127126896678168677112807927187532187}
#define T_19_18 {0.9458172417006346366363800370891112834215,0.3246994692046835107035462897329125553370}
// Pre-computed twiddles for N=20
#define T_20_1 {0.9510565162951535311819384332920890301466,-0.3090169943749474512628694355953484773636}
#define T_20_3 {0.5877852522924731371034567928290925920010,-0.8090169943749474512628694355953484773636}
#define T_20_7 {-0.5877852522924731371034567928290925920010,-0.8090169943749474512628694355953484773636}
#define T_20_9 {-0.9510565162951535311819384332920890301466,-0.3090169943749474512628694355953484773636}
#define T_20_11 {-0.9510565162951535311819384332920890301466,0.3090169943749474512628694355953484773636}
#define T_20_13 {-0.5877852522924731371034567928290925920010,0.8090169943749474512628694355953484773636}
#define T_20_17 {0.5877852522924731371034567928290925920010,0.8090169943749474512628694355953484773636}
#define T_20_19 {0.9510565162951535311819384332920890301466,0.3090169943749474512628694355953484773636}
// Pre-computed twiddles for N=21
#define T_21_1 {0.9555728057861406776751778124889824539423,-0.2947551744109042082264693362958496436477}
#define T_21_2 {0.8262387743159949060611779714236035943031,-0.5633200580636220644592526696214918047190}
#define T_21_4 {0.3653410243663950396353357064072042703629,-0.9308737486442042463608004254638217389584}
#define T_21_5 {0.0747300935864242538153590089677891228348,-0.9972037971811801293497978804225567728281}
#define T_21_8 {-0.7330518718298263403099213064706418663263,-0.6801727377709193556043487660645041614771}
#define T_21_10 {-0.9888308262251285229993413850024808198214,-0.1490422661761744427266762613726314157248}
#define T_21_11 {-0.9888308262251285229993413850024808198214,0.1490422661761744427266762613726314157248}
#define T_21_13 {-0.7330518718298263403099213064706418663263,0.6801727377709193556043487660645041614771}
#define T_21_16 {0.0747300935864242538153590089677891228348,0.9972037971811801293497978804225567728281}
#define T_21_17 {0.3653410243663950396353357064072042703629,0.9308737486442042463608004254638217389584}
#define T_21_19 {0.8262387743159949060611779714236035943031,0.5633200580636220644592526696214918047190}
#define T_21_20 {0.9555728057861406776751778124889824539423,0.2947551744109042082264693362958496436477}
// Pre-computed twiddles for N=22
#define T_22_1 {0.9594929736144973686506887133873533457518,-0.2817325568414296710351152341900160536170}
#define T_22_3 {0.6548607339452851006100786435126792639494,-0.7557495743542582689045161714602727442980}
#define T_22_5 {0.1423148382732851435772403192459023557603,-0.9898214418809326842207951813179533928633}
#define T_22_7 {-0.4154150130018864350844864929968025535345,-0.9096319953545183301102383666147943586111}
#define T_22_9 {-0.8412535328311812055090967987780459225178,-0.5406408174555975554298470342473592609167}
#define T_22_13 {-0.8412535328311812055090967987780459225178,0.5406408174555975554298470342473592609167}
#define T_22_15 {-0.4154150130018864350844864929968025535345,0.9096319953545183301102383666147943586111}
#define T_22_17 {0.1423148382732851435772403192459023557603,0.9898214418809326842207951813179533928633}
#define T_22_19 {0.6548607339452851006100786435126792639494,0.7557495743542582689045161714602727442980}
#define T_22_21 {0.9594929736144973686506887133873533457518,0.2817325568414296710351152341900160536170}
// Pre-computed twiddles for N=23
#define T_23_1 {0.9629172873477992444790629633644130080938,-0.2697967711570242732577185051923152059317}
#define T_23_2 {0.8544194045464885700624790842994116246700,-0.5195839500354335616094658689689822494984}
#define T_23_3 {0.6825531432186541236362131712667178362608,-0.7308359642781241394260405286331661045551}
#define T_23_4 {0.4600650377311521488365997356595471501350,-0.8878852184023752203145818384655285626650}
#define T_23_5 {0.2034560130526337773382294926705071702600,-0.9790840876823229121939107244543265551329}
#define T_23_6 {-0.0682424133646709757394788198325841221958,-0.9976687691905391508484512996801640838385}
#define T_23_7 {-0.3348796121709861628445992209890391677618,-0.9422609221188205097519130504224449396133}
#define T_23_8 {-0.5766803221148671942941632551082875579596,-0.8169698930104419831721429545723367482424}
#define T_23_9 {-0.7757112907044197980255262336868327111006,-0.6310879443260527521530889316636603325605}
#define T_23_10 {-0.9172113015054530471559246507240459322929,-0.3984010898462414518306218269572127610445}
#define T_23_11 {-0.9906859460363307556818313059920910745859,-0.1361666490962465947411885736073600128293}
#define T_23_12 {-0.9906859460363307556818313059920910745859,0.1361666490962465947411885736073600128293}
#define T_23_13 {-0.9172113015054530471559246507240459322929,0.3984010898462414518306218269572127610445}
#define T_23_14 {-0.7757112907044197980255262336868327111006,0.6310879443260527521530889316636603325605}
#define T_23_15 {-0.5766803221148671942941632551082875579596,0.8169698930104419831721429545723367482424}
#define T_23_16 {-0.3348796121709861628445992209890391677618,0.9422609221188205097519130504224449396133}
#define T_23_17 {-0.0682424133646709757394788198325841221958,0.9976687691905391508484512996801640838385}
#define T_23_18 {0.2034560130526337773382294926705071702600,0.9790840876823229121939107244543265551329}
#define T_23_19 {0.4600650377311521488365997356595471501350,0.8878852184023752203145818384655285626650}
#define T_23_20 {0.6825531432186541236362131712667178362608,0.7308359642781241394260405286331661045551}
#define T_23_21 {0.8544194045464885700624790842994116246700,0.5195839500354335616094658689689822494984}
#define T_23_22 {0.9629172873477992444790629633644130080938,0.2697967711570242732577185051923152059317}
// Pre-computed twiddles for N=24
#define T_24_1 {0.9659258262890683122137147620378527790308,-0.2588190451025207394764038326684385538101}
#define T_24_5 {0.2588190451025207394764038326684385538101,-0.9659258262890683122137147620378527790308}
#define T_24_7 {-0.2588190451025207394764038326684385538101,-0.9659258262890683122137147620378527790308}
#define T_24_11 {-0.9659258262890683122137147620378527790308,-0.2588190451025207394764038326684385538101}
#define T_24_13 {-0.9659258262890683122137147620378527790308,0.2588190451025207394764038326684385538101}
#define T_24_17 {-0.2588190451025207394764038326684385538101,0.9659258262890683122137147620378527790308}
#define T_24_19 {0.2588190451025207394764038326684385538101,0.9659258262890683122137147620378527790308}
#define T_24_23 {0.9659258262890683122137147620378527790308,0.2588190451025207394764038326684385538101}
// Pre-computed twiddles for N=25
#define T_25_1 {0.9685831611286310760533524444326758384705,-0.2486898871648547948431939857982797548175}
#define T_25_2 {0.8763066800438635839398671123490203171968,-0.4817536741017152679411594817793229594827}
#define T_25_3 {0.7289686274214115524472390461596660315990,-0.6845471059286887260952880751574411988258}
#define T_25_4 {0.5358267949789966566598309327673632651567,-0.8443279255020150753097141205216757953167}
#define T_25_6 {0.0627905195293133738809743249476014170796,-0.9980267284282715589682766221812926232815}
#define T_25_7 {-0.1873813145857246287295794218152877874672,-0.9822872507286887211463977109815459698439}
#define T_25_8 {-0.4257792915650726595089281545369885861874,-0.9048270524660195768262838100781664252281}
#define T_25_9 {-0.6374239897486897454825793829513713717461,-0.7705132427757892532582673084107227623463}
#define T_25_11 {-0.9297764858882514582560929738974664360285,-0.3681245526846779747565108209528261795640}
#define T_25_12 {-0.9921147013144778759041741977853234857321,-0.1253332335643042583228634612169116735458}
#define T_25_13 {-0.9921147013144778759041741977853234857321,0.1253332335643042583228634612169116735458}
#define T_25_14 {-0.9297764858882514582560929738974664360285,0.3681245526846779747565108209528261795640}
#define T_25_16 {-0.6374239897486897454825793829513713717461,0.7705132427757892532582673084107227623463}
#define T_25_17 {-0.4257792915650726595089281545369885861874,0.9048270524660195768262838100781664252281}
#define T_25_18 {-0.1873813145857246287295794218152877874672,0.9822872507286887211463977109815459698439}
#define T_25_19 {0.0627905195293133738809743249476014170796,0.9980267284282715589682766221812926232815}
#define T_25_21 {0.5358267949789966566598309327673632651567,0.8443279255020150753097141205216757953167}
#define T_25_22 {0.7289686274214115524472390461596660315990,0.6845471059286887260952880751574411988258}
#define T_25_23 {0.8763066800438635839398671123490203171968,0.4817536741017152679411594817793229594827}
#define T_25_24 {0.9685831611286310760533524444326758384705,0.2486898871648547948431939857982797548175}
// Pre-computed twiddles for N=26
#define T_26_1 {0.9709418174260520117968553677201271057129,-0.2393156642875577666540465315847541205585}
#define T_26_3 {0.7485107481711010812830409122398123145103,-0.6631226582407951930520084715681150555611}
#define T_26_5 {0.3546048870425356214219902994955191388726,-0.9350162426854148334243177487223874777555}
#define T_26_7 {-0.1205366802553230476391377123945858329535,-0.9927088740980539727232212499075103551149}
#define T_26_9 {-0.5680647467311558118652214943722356110811,-0.8229838658936563522416918203816749155521}
#define T_26_11 {-0.8854560256532099105086786039464641362429,-0.4647231720437685620339607339701615273952}
#define T_26_15 {-0.8854560256532099105086786039464641362429,0.4647231720437685620339607339701615273952}
#define T_26_17 {-0.5680647467311558118652214943722356110811,0.8229838658936563522416918203816749155521}
#define T_26_19 {-0.1205366802553230476391377123945858329535,0.9927088740980539727232212499075103551149}
#define T_26_21 {0.3546048870425356214219902994955191388726,0.9350162426854148334243177487223874777555}
#define T_26_23 {0.7485107481711010812830409122398123145103,0.6631226582407951930520084715681150555611}
#define T_26_25 {0.9709418174260520117968553677201271057129,0.2393156642875577666540465315847541205585}
// Pre-computed twiddles for N=27
#define T_27_1 {0.9730448705798238062669724968145601451397,-0.2306158707424401654861867427825927734375}
#define T_27_2 {0.8936326403234122750518508837558329105377,-0.4487991802004621666455363993009086698294}
#define T_27_4 {0.5971585917027861789563303318573161959648,-0.8021231927550437346141620764683466404676}
#define T_27_5 {0.3960797660391568442150855844374746084213,-0.9182161068802739967154025180207099765539}
#define T_27_7 {-0.0581448289104758292422658882969699334353,-0.9983081582712681756319739179161842912436}
#define T_27_8 {-0.2868032327110902612865572791633894667029,-0.9579895123154889002847767187631689012051}
#define T_27_10 {-0.6862416378687336004915664489089976996183,-0.7273736415730487347985899759805761277676}
#define T_27_11 {-0.8354878114129363764206459563865792006254,-0.5495089780708060089864375186152756214142}
#define T_27_13 {-0.9932383577419430231714159162947908043861,-0.1160929141252302343456648259234498254955}
#define T_27_14 {-0.9932383577419430231714159162947908043861,0.1160929141252302343456648259234498254955}
#define T_27_16 {-0.8354878114129363764206459563865792006254,0.5495089780708060089864375186152756214142}
#define T_27_17 {-0.6862416378687336004915664489089976996183,0.7273736415730487347985899759805761277676}
#define T_27_19 {-0.2868032327110902612865572791633894667029,0.9579895123154889002847767187631689012051}
#define T_27_20 {-0.0581448289104758292422658882969699334353,0.9983081582712681756319739179161842912436}
#define T_27_22 {0.3960797660391568442150855844374746084213,0.9182161068802739967154025180207099765539}
#define T_27_23 {0.5971585917027861789563303318573161959648,0.8021231927550437346141620764683466404676}
#define T_27_25 {0.8936326403234122750518508837558329105377,0.4487991802004621666455363993009086698294}
#define T_27_26 {0.9730448705798238062669724968145601451397,0.2306158707424401654861867427825927734375}
// Pre-computed twiddles for N=28
#define T_28_1 {0.9749279121818236193419693336181808263063,-0.2225209339563143928764077372761676087976}
#define T_28_3 {0.7818314824680298036341241640911903232336,-0.6234898018587334833640056785952765494585}
#define T_28_5 {0.4338837391175581204016964420588919892907,-0.9009688679024191459987491725769359618425}
#define T_28_9 {-0.4338837391175581204016964420588919892907,-0.9009688679024191459987491725769359618425}
#define T_28_11 {-0.7818314824680298036341241640911903232336,-0.6234898018587334833640056785952765494585}
#define T_28_13 {-0.9749279121818236193419693336181808263063,-0.2225209339563143928764077372761676087976}
#define T_28_15 {-0.9749279121818236193419693336181808263063,0.2225209339563143928764077372761676087976}
#define T_28_17 {-0.7818314824680298036341241640911903232336,0.6234898018587334833640056785952765494585}
#define T_28_19 {-0.4338837391175581204016964420588919892907,0.9009688679024191459987491725769359618425}
#define T_28_23 {0.4338837391175581204016964420588919892907,0.9009688679024191459987491725769359618425}
#define T_28_25 {0.7818314824680298036341241640911903232336,0.6234898018587334833640056785952765494585}
#define T_28_27 {0.9749279121818236193419693336181808263063,0.2225209339563143928764077372761676087976}
// Pre-computed twiddles for N=29
#define T_29_1 {0.9766205557100866574415931609109975397587,-0.2149704402110240719636635731148999184370}
#define T_29_2 {0.9075754196709570065237926428380887955427,-0.4198891015602645992998986912425607442856}
#define T_29_3 {0.7960930657056437542706817112048156559467,-0.6051742151937651303938991986797191202641}
#define T_29_4 {0.6473862847818276922140512397163547575474,-0.7621620551276364619042169579188339412212}
#define T_29_5 {0.4684084406997901517399895965354517102242,-0.8835120444460229371941295539727434515953}
#define T_29_6 {0.2675283385292208104822009318013442680240,-0.9635499925192229087045348023821134120226}
#define T_29_7 {0.0541389085854175264311827220353734446689,-0.9985334138511238188939955762180034071207}
#define T_29_8 {-0.1617819965527647341207995168588240630925,-0.9868265225415261410191192226193379610777}
#define T_29_9 {-0.3701381553399143431448692354024387896061,-0.9289767198167914186157645417551975697279}
#define T_29_10 {-0.5611870653623823868016984306450467556715,-0.8276889981568905652054013444285374134779}
#define T_29_11 {-0.7259954919231308423377413419075310230255,-0.6876994588534233177057330976822413504124}
#define T_29_12 {-0.8568571761675892739518189955560956150293,-0.5155538571770217348699816284351982176304}
#define T_29_13 {-0.9476531711828024562294103816384449601173,-0.3193015301359799495983793349296320229769}
#define T_29_14 {-0.9941379571543595972116236225701868534088,-0.1081190184239417678702110947597248014063}
#define T_29_15 {-0.9941379571543595972116236225701868534088,0.1081190184239417678702110947597248014063}
#define T_29_16 {-0.9476531711828024562294103816384449601173,0.3193015301359799495983793349296320229769}
#define T_29_17 {-0.8568571761675892739518189955560956150293,0.5155538571770217348699816284351982176304}
#define T_29_18 {-0.7259954919231308423377413419075310230255,0.6876994588534233177057330976822413504124}
#define T_29_19 {-0.5611870653623823868016984306450467556715,0.8276889981568905652054013444285374134779}
#define T_29_20 {-0.3701381553399143431448692354024387896061,0.9289767198167914186157645417551975697279}
#define T_29_21 {-0.1617819965527647341207995168588240630925,0.9868265225415261410191192226193379610777}
#define T_29_22 {0.0541389085854175264311827220353734446689,0.9985334138511238188939955762180034071207}
#define T_29_23 {0.2675283385292208104822009318013442680240,0.9635499925192229087045348023821134120226}
#define T_29_24 {0.4684084406997901517399895965354517102242,0.8835120444460229371941295539727434515953}
#define T_29_25 {0.6473862847818276922140512397163547575474,0.7621620551276364619042169579188339412212}
#define T_29_26 {0.7960930657056437542706817112048156559467,0.6051742151937651303938991986797191202641}
#define T_29_27 {0.9075754196709570065237926428380887955427,0.4198891015602645992998986912425607442856}
#define T_29_28 {0.9766205557100866574415931609109975397587,0.2149704402110240719636635731148999184370}
// Pre-computed twiddles for N=30
#define T_30_1 {0.9781476007338056888329447247087955474854,-0.2079116908177593425754992040310753509402}
#define T_30_7 {0.1045284632676534708473070622858358547091,-0.9945218953682732898613494398887269198895}
#define T_30_11 {-0.6691306063588582375700752891134470701218,-0.7431448254773942441175904605188407003880}
#define T_30_13 {-0.9135454576426008665990252666233573108912,-0.4067366430758002082690438783174613490701}
#define T_30_17 {-0.9135454576426008665990252666233573108912,0.4067366430758002082690438783174613490701}
#define T_30_19 {-0.6691306063588582375700752891134470701218,0.7431448254773942441175904605188407003880}
#define T_30_23 {0.1045284632676534708473070622858358547091,0.9945218953682732898613494398887269198895}
#define T_30_29 {0.9781476007338056888329447247087955474854,0.2079116908177593425754992040310753509402}
// Pre-computed twiddles for N=31
#define T_31_1 {0.9795299412524944848712493694620206952095,-0.2012985200886600878344978582390467636287}
#define T_31_2 {0.9189578116202306024007384621654637157917,-0.3943558551133185541281989117123885080218}
#define T_31_3 {0.8207634412072762897238931145693641155958,-0.5712682150947923087613844472798518836498}
#define T_31_4 {0.6889669190756865235769623723172117024660,-0.7247927872291199946630513295531272888184}
#define T_31_5 {0.5289640103269624971105145050387363880873,-0.8486442574947509198679540531884413212538}
#define T_31_6 {0.3473052528448202780353426533110905438662,-0.9377521321470804194220249883073847740889}
#define T_31_7 {0.1514277775045766716299766585507313720882,-0.9884683243281113806943949384731240570545}
#define T_31_8 {-0.0506491688387127117487729321965161943808,-0.9987165071710527586290595536411274224520}
#define T_31_9 {-0.2506525322587205284463607313227839767933,-0.9680771188662042892048020803485997021198}
#define T_31_10 {-0.4403941515576342835558421029418241232634,-0.8978045395707416886921237164642661809921}
#define T_31_11 {-0.6121059825476627969109699733962770551443,-0.7907757369376985367992460851382929831743}
#define T_31_12 {-0.7587581226927908595314420381328091025352,-0.6513724827222222568678944298881106078625}
#define T_31_13 {-0.8743466161445820894471125939162448048592,-0.4853019625310810436502606535213999450207}
#define T_31_14 {-0.9541392564000488185627091297646984457970,-0.2993631229733579313112556974374456331134}
#define T_31_15 {-0.9948693233918951550620590751350391656160,-0.1011683219874321831843744234902260359377}
#define T_31_16 {-0.9948693233918951550620590751350391656160,0.1011683219874321831843744234902260359377}
#define T_31_17 {-0.9541392564000488185627091297646984457970,0.2993631229733579313112556974374456331134}
#define T_31_18 {-0.8743466161445820894471125939162448048592,0.4853019625310810436502606535213999450207}
#define T_31_19 {-0.7587581226927908595314420381328091025352,0.6513724827222222568678944298881106078625}
#define T_31_20 {-0.6121059825476627969109699733962770551443,0.7907757369376985367992460851382929831743}
#define T_31_21 {-0.4403941515576342835558421029418241232634,0.8978045395707416886921237164642661809921}
#define T_31_22 {-0.2506525322587205284463607313227839767933,0.9680771188662042892048020803485997021198}
#define T_31_23 {-0.0506491688387127117487729321965161943808,0.9987165071710527586290595536411274224520}
#define T_31_24 {0.1514277775045766716299766585507313720882,0.9884683243281113806943949384731240570545}
#define T_31_25 {0.3473052528448202780353426533110905438662,0.9377521321470804194220249883073847740889}
#define T_31_26 {0.5289640103269624971105145050387363880873,0.8486442574947509198679540531884413212538}
#define T_31_27 {0.6889669190756865235769623723172117024660,0.7247927872291199946630513295531272888184}
#define T_31_28 {0.8207634412072762897238931145693641155958,0.5712682150947923087613844472798518836498}
#define T_31_29 {0.9189578116202306024007384621654637157917,0.3943558551133185541281989117123885080218}
#define T_31_30 {0.9795299412524944848712493694620206952095,0.2012985200886600878344978582390467636287}
// Pre-computed twiddles for N=32
#define T_32_1 {0.9807852804032304305792422383092343807220,-0.1950903220161282758393639369387528859079}
#define T_32_3 {0.8314696123025452356714026791451033204794,-0.5555702330196021776487214083317667245865}
#define T_32_5 {0.5555702330196021776487214083317667245865,-0.8314696123025452356714026791451033204794}
#define T_32_7 {0.1950903220161282758393639369387528859079,-0.9807852804032304305792422383092343807220}
#define T_32_9 {-0.1950903220161282758393639369387528859079,-0.9807852804032304305792422383092343807220}
#define T_32_11 {-0.5555702330196021776487214083317667245865,-0.8314696123025452356714026791451033204794}
#define T_32_13 {-0.8314696123025452356714026791451033204794,-0.5555702330196021776487214083317667245865}
#define T_32_15 {-0.9807852804032304305792422383092343807220,-0.1950903220161282758393639369387528859079}
#define T_32_17 {-0.9807852804032304305792422383092343807220,0.1950903220161282758393639369387528859079}
#define T_32_19 {-0.8314696123025452356714026791451033204794,0.5555702330196021776487214083317667245865}
#define T_32_21 {-0.5555702330196021776487214083317667245865,0.8314696123025452356714026791451033204794}
#define T_32_23 {-0.1950903220161282758393639369387528859079,0.9807852804032304305792422383092343807220}
#define T_32_25 {0.1950903220161282758393639369387528859079,0.9807852804032304305792422383092343807220}
#define T_32_27 {0.5555702330196021776487214083317667245865,0.8314696123025452356714026791451033204794}
#define T_32_29 {0.8314696123025452356714026791451033204794,0.5555702330196021776487214083317667245865}
#define T_32_31 {0.9807852804032304305792422383092343807220,0.1950903220161282758393639369387528859079}
// Pre-computed twiddles for N=33
#define T_33_1 {0.9819286972627067067165285152441356331110,-0.1892512443604102145844336746449698694050}
#define T_33_2 {0.9283679330160725662324239237932488322258,-0.3716624556603275175703515742497984319925}
#define T_33_4 {0.7237340381050701987319939689768943935633,-0.6900790114821120369015261530876159667969}
#define T_33_5 {0.5800569095711981537633050720614846795797,-0.8145759520503357276055567126604728400707}
#define T_33_7 {0.2357589355094272254298459756682859733701,-0.9718115683235416524254901560198049992323}
#define T_33_8 {0.0475819158237422989987663868305389769375,-0.9988673391830079628661565038783010095358}
#define T_33_10 {-0.3270679633174216616176011029892833903432,-0.9450008187146684557333742304763291031122}
#define T_33_13 {-0.7860530947427875059219104514340870082378,-0.6181589862206051666504436070681549608707}
#define T_33_14 {-0.8888354486549234767522875699796713888645,-0.4582265217274104074363094696309417486191}
#define T_33_16 {-0.9954719225730845888477915650582872331142,-0.0950560433041826580158328852121485397220}
#define T_33_17 {-0.9954719225730845888477915650582872331142,0.0950560433041826580158328852121485397220}
#define T_33_19 {-0.8888354486549234767522875699796713888645,0.4582265217274104074363094696309417486191}
#define T_33_20 {-0.7860530947427875059219104514340870082378,0.6181589862206051666504436070681549608707}
#define T_33_23 {-0.3270679633174216616176011029892833903432,0.9450008187146684557333742304763291031122}
#define T_33_25 {0.0475819158237422989987663868305389769375,0.9988673391830079628661565038783010095358}
#define T_33_26 {0.2357589355094272254298459756682859733701,0.9718115683235416524254901560198049992323}
#define T_33_28 {0.5800569095711981537633050720614846795797,0.8145759520503357276055567126604728400707}
#define T_33_29 {0.7237340381050701987319939689768943935633,0.6900790114821120369015261530876159667969}
#define T_33_31 {0.9283679330160725662324239237932488322258,0.3716624556603275175703515742497984319925}
#define T_33_32 {0.9819286972627067067165285152441356331110,0.1892512443604102145844336746449698694050}
// Pre-computed twiddles for N=34
#define T_34_1 {0.9829730996839017853616837783192750066519,-0.1837495178165703402228814411500934511423}
#define T_34_3 {0.8502171357296141041004489125043619424105,-0.5264321628773558359171147458255290985107}
#define T_34_5 {0.6026346363792564053696310111263301223516,-0.7980172272802394939361647629993967711926}
#define T_34_7 {0.2736629900720828900695380525576183572412,-0.9618256431728190447572046650748234242201}
#define T_34_9 {-0.0922683594633020021102964847159455530345,-0.9957341762950344676852409975253976881504}
#define T_34_11 {-0.4457383557765382531279385602829279378057,-0.8951632913550623404930206561402883380651}
#define T_34_13 {-0.7390089172206590895086719683604314923286,-0.6736956436465572073402086061832960695028}
#define T_34_15 {-0.9324722294043558123988191255193669348955,-0.3612416661871529210969811174436472356319}
#define T_34_19 {-0.9324722294043558123988191255193669348955,0.3612416661871529210969811174436472356319}
#define T_34_21 {-0.7390089172206590895086719683604314923286,0.6736956436465572073402086061832960695028}
#define T_34_23 {-0.4457383557765382531279385602829279378057,0.8951632913550623404930206561402883380651}
#define T_34_25 {-0.0922683594633020021102964847159455530345,0.9957341762950344676852409975253976881504}
#define T_34_27 {0.2736629900720828900695380525576183572412,0.9618256431728190447572046650748234242201}
#define T_34_29 {0.6026346363792564053696310111263301223516,0.7980172272802394939361647629993967711926}
#define T_34_31 {0.8502171357296141041004489125043619424105,0.5264321628773558359171147458255290985107}
#define T_34_33 {0.9829730996839017853616837783192750066519,0.1837495178165703402228814411500934511423}
// Pre-computed twiddles for N=35
#define T_35_1 {0.9839295885986296674730056111002340912819,-0.1785568947986366505897848355743917636573}
#define T_35_2 {0.9362348706397372044563098825165070593357,-0.3513748240813426848561107362911570817232}
#define T_35_3 {0.8584487936018661002890439704060554504395,-0.5128992774059061288127736588648986071348}
#define T_35_4 {0.7530714660036109675544935271318536251783,-0.6579387259397125875537426509254146367311}
#define T_35_6 {0.4738686624729986918147517371835419908166,-0.8805955318567380007976908018463291227818}
#define T_35_8 {0.1342332658176554893714182981057092547417,-0.9909497617679347003516454606142360717058}
#define T_35_9 {-0.0448648303505149240177907188353856327012,-0.9989930665413147004016991559183225035667}
#define T_35_11 {-0.3930250316539236066226692400960018858314,-0.9195277725514506839132877757947426289320}
#define T_35_12 {-0.5508969814521025298859058239031583070755,-0.8345732537213026436262452989467419683933}
#define T_35_13 {-0.6910626489868646471492752425547223538160,-0.7227948638273915538121627832879312336445}
#define T_35_16 {-0.9639628606958532408555129222804680466652,-0.2660368455666751175137108020862797275186}
#define T_35_17 {-0.9959742939952390683444605201657395809889,-0.0896393089034334955567118186081643216312}
#define T_35_18 {-0.9959742939952390683444605201657395809889,0.0896393089034334955567118186081643216312}
#define T_35_19 {-0.9639628606958532408555129222804680466652,0.2660368455666751175137108020862797275186}
#define T_35_22 {-0.6910626489868646471492752425547223538160,0.7227948638273915538121627832879312336445}
#define T_35_23 {-0.5508969814521025298859058239031583070755,0.8345732537213026436262452989467419683933}
#define T_35_24 {-0.3930250316539236066226692400960018858314,0.9195277725514506839132877757947426289320}
#define T_35_26 {-0.0448648303505149240177907188353856327012,0.9989930665413147004016991559183225035667}
#define T_35_27 {0.1342332658176554893714182981057092547417,0.9909497617679347003516454606142360717058}
#define T_35_29 {0.4738686624729986918147517371835419908166,0.8805955318567380007976908018463291227818}
#define T_35_31 {0.7530714660036109675544935271318536251783,0.6579387259397125875537426509254146367311}
#define T_35_32 {0.8584487936018661002890439704060554504395,0.5128992774059061288127736588648986071348}
#define T_35_33 {0.9362348706397372044563098825165070593357,0.3513748240813426848561107362911570817232}
#define T_35_34 {0.9839295885986296674730056111002340912819,0.1785568947986366505897848355743917636573}
// Pre-computed twiddles for N=36
#define T_36_1 {0.9848077530122080203156542665965389460325,-0.1736481776669303589422099776129471138120}
#define T_36_5 {0.6427876096865393629187224178167525678873,-0.7660444431189780134516809084743726998568}
#define T_36_7 {0.3420201433256687129080830800376133993268,-0.9396926207859084279050421173451468348503}
#define T_36_11 {-0.3420201433256687129080830800376133993268,-0.9396926207859084279050421173451468348503}
#define T_36_13 {-0.6427876096865393629187224178167525678873,-0.7660444431189780134516809084743726998568}
#define T_36_17 {-0.9848077530122080203156542665965389460325,-0.1736481776669303589422099776129471138120}
#define T_36_19 {-0.9848077530122080203156542665965389460325,0.1736481776669303589422099776129471138120}
#define T_36_23 {-0.6427876096865393629187224178167525678873,0.7660444431189780134516809084743726998568}
#define T_36_25 {-0.3420201433256687129080830800376133993268,0.9396926207859084279050421173451468348503}
#define T_36_29 {0.3420201433256687129080830800376133993268,0.9396926207859084279050421173451468348503}
#define T_36_31 {0.6427876096865393629187224178167525678873,0.7660444431189780134516809084743726998568}
#define T_36_35 {0.9848077530122080203156542665965389460325,0.1736481776669303589422099776129471138120}
// Pre-computed twiddles for N=37
#define T_37_1 {0.9856159103477084570954502851236611604691,-0.1690008203218490712149701948874280788004}
#define T_37_2 {0.9428774454610842070678700110875070095062,-0.3331397947420575711419132858281955122948}
#define T_37_3 {0.8730141131611881544216657857759855687618,-0.4876949438136345404970484196383040398359}
#define T_37_4 {0.7780357543184395208157866363762877881527,-0.6282199972956422628911354877345729619265}
#define T_37_5 {0.6606747233900814864071548981883097440004,-0.7506723052527243256193401066411752253771}
#define T_37_6 {0.5243072835572316625629696318355854600668,-0.8515291377333112921022006958082783967257}
#define T_37_7 {0.3728564777803086149887690226023551076651,-0.9278890272965093499735189652710687369108}
#define T_37_8 {0.2106792699957263093057946434782934375107,-0.9775552389476861447903388580016326159239}
#define T_37_9 {0.0424412031961483027231452069827355444431,-0.9990989662046815267260058135434519499540}
#define T_37_10 {-0.1270178197468787573143345071002840995789,-0.9919004352588768336218549848126713186502}
#define T_37_11 {-0.2928227712765503754077656139997998252511,-0.9561667347392509563874796185700688511133}
#define T_37_12 {-0.4502037448176732792326504295488120988011,-0.8929258581495684854445471501094289124012}
#define T_37_13 {-0.5946331763042865814483661779377143830061,-0.8039971303669405378045098586881067603827}
#define T_37_14 {-0.7219560939545244249160305116674862802029,-0.6919388689775461953601620734843891113997}
#define T_37_15 {-0.8285096492438420723303238446533214300871,-0.5599747861375954371965235623065382242203}
#define T_37_16 {-0.9112284903881356923349699172831606119871,-0.4119012482439926570165766861464362591505}
#define T_37_17 {-0.9677329469334988720774504145083483308554,-0.2519780613851251849233392476890003308654}
#define T_37_18 {-0.9963974885425265215488366266072262078524,-0.0848059244755091923284595623044879175723}
#define T_37_19 {-0.9963974885425265215488366266072262078524,0.0848059244755091923284595623044879175723}
#define T_37_20 {-0.9677329469334988720774504145083483308554,0.2519780613851251849233392476890003308654}
#define T_37_21 {-0.9112284903881356923349699172831606119871,0.4119012482439926570165766861464362591505}
#define T_37_22 {-0.8285096492438420723303238446533214300871,0.5599747861375954371965235623065382242203}
#define T_37_23 {-0.7219560939545244249160305116674862802029,0.6919388689775461953601620734843891113997}
#define T_37_24 {-0.5946331763042865814483661779377143830061,0.8039971303669405378045098586881067603827}
#define T_37_25 {-0.4502037448176732792326504295488120988011,0.8929258581495684854445471501094289124012}
#define T_37_26 {-0.2928227712765503754077656139997998252511,0.9561667347392509563874796185700688511133}
#define T_37_27 {-0.1270178197468787573143345071002840995789,0.9919004352588768336218549848126713186502}
#define T_37_28 {0.0424412031961483027231452069827355444431,0.9990989662046815267260058135434519499540}
#define T_37_29 {0.2106792699957263093057946434782934375107,0.9775552389476861447903388580016326159239}
#define T_37_30 {0.3728564777803086149887690226023551076651,0.9278890272965093499735189652710687369108}
#define T_37_31 {0.5243072835572316625629696318355854600668,0.8515291377333112921022006958082783967257}
#define T_37_32 {0.6606747233900814864071548981883097440004,0.7506723052527243256193401066411752253771}
#define T_37_33 {0.7780357543184395208157866363762877881527,0.6282199972956422628911354877345729619265}
#define T_37_34 {0.8730141131611881544216657857759855687618,0.4876949438136345404970484196383040398359}
#define T_37_35 {0.9428774454610842070678700110875070095062,0.3331397947420575711419132858281955122948}
#define T_37_36 {0.9856159103477084570954502851236611604691,0.1690008203218490712149701948874280788004}
// Pre-computed twiddles for N=38
#define T_38_1 {0.9863613034027223225308489418239332735538,-0.1645945902807338934170644506593816913664}
#define T_38_3 {0.8794737512064890738727740426838863641024,-0.4759473930370735628159195584885310381651}
#define T_38_5 {0.6772815716257410967315877314831595867872,-0.7357239106731315869680543073627632111311}
#define T_38_7 {0.4016954246529694794176634786708746105433,-0.9157733266550573958397762908134609460831}
#define T_38_9 {0.0825793454723323244737187565078784245998,-0.9965844930066698470483288474497385323048}
#define T_38_11 {-0.2454854871407991523390990096231689676642,-0.9694002659393303744650438602548092603683}
#define T_38_13 {-0.5469481581224269195473652871442027390003,-0.8371664782625285461392650177003815770149}
#define T_38_15 {-0.7891405093963935746259608094987925142050,-0.6142127126896678168677112807927187532187}
#define T_38_17 {-0.9458172417006346366363800370891112834215,-0.3246994692046835107035462897329125553370}
#define T_38_21 {-0.9458172417006346366363800370891112834215,0.3246994692046835107035462897329125553370}
#define T_38_23 {-0.7891405093963935746259608094987925142050,0.6142127126896678168677112807927187532187}
#define T_38_25 {-0.5469481581224269195473652871442027390003,0.8371664782625285461392650177003815770149}
#define T_38_27 {-0.2454854871407991523390990096231689676642,0.9694002659393303744650438602548092603683}
#define T_38_29 {0.0825793454723323244737187565078784245998,0.9965844930066698470483288474497385323048}
#define T_38_31 {0.4016954246529694794176634786708746105433,0.9157733266550573958397762908134609460831}
#define T_38_33 {0.6772815716257410967315877314831595867872,0.7357239106731315869680543073627632111311}
#define T_38_35 {0.8794737512064890738727740426838863641024,0.4759473930370735628159195584885310381651}
#define T_38_37 {0.9863613034027223225308489418239332735538,0.1645945902807338934170644506593816913664}
// Pre-computed twiddles for N=39
#define T_39_1 {0.9870502626379128452427380580047611147165,-0.1604112808577602411475027111009694635868}
#define T_39_2 {0.9485364419471454811016997155093122273684,-0.3166679938014724804418165149400010704994}
#define T_39_4 {0.7994427634035011775992529692302923649549,-0.6007422642379789401445577823324128985405}
#define T_39_5 {0.6927243535095993776096179317391943186522,-0.7212024473438145566461798807722516357899}
#define T_39_7 {0.4286925614030541731303003416542196646333,-0.9034504346103823246849628958443645387888}
#define T_39_8 {0.2782174639164526341872374359809327870607,-0.9605181116313723510558020279859192669392}
#define T_39_10 {-0.0402659401094151436772961005772231146693,-0.9991889981715695867592330614570528268814}
#define T_39_11 {-0.2000256937760444275742344188984134234488,-0.9797906520422676734938249865081161260605}
#define T_39_14 {-0.6324453755953772793318989897670689970255,-0.7746049618276545922768150376214180141687}
#define T_39_16 {-0.8451900855437947113202312721114140003920,-0.5344658261278011357475747900025453418493}
#define T_39_17 {-0.9199794436588242252383906816248781979084,-0.3919666098600750880898146988329244777560}
#define T_39_19 {-0.9967573081342100405066730672842822968960,-0.0804665687167258752987564207614923361689}
#define T_39_20 {-0.9967573081342100405066730672842822968960,0.0804665687167258752987564207614923361689}
#define T_39_22 {-0.9199794436588242252383906816248781979084,0.3919666098600750880898146988329244777560}
#define T_39_23 {-0.8451900855437947113202312721114140003920,0.5344658261278011357475747900025453418493}
#define T_39_25 {-0.6324453755953772793318989897670689970255,0.7746049618276545922768150376214180141687}
#define T_39_28 {-0.2000256937760444275742344188984134234488,0.9797906520422676734938249865081161260605}
#define T_39_29 {-0.0402659401094151436772961005772231146693,0.9991889981715695867592330614570528268814}
#define T_39_31 {0.2782174639164526341872374359809327870607,0.9605181116313723510558020279859192669392}
#define T_39_32 {0.4286925614030541731303003416542196646333,0.9034504346103823246849628958443645387888}
#define T_39_34 {0.6927243535095993776096179317391943186522,0.7212024473438145566461798807722516357899}
#define T_39_35 {0.7994427634035011775992529692302923649549,0.6007422642379789401445577823324128985405}
#define T_39_37 {0.9485364419471454811016997155093122273684,0.3166679938014724804418165149400010704994}
#define T_39_38 {0.9870502626379128452427380580047611147165,0.1604112808577602411475027111009694635868}
// Pre-computed twiddles for N=40
#define T_40_1 {0.9876883405951377703502203075913712382317,-0.1564344650402308689596253543641068972647}
#define T_40_3 {0.8910065241883678988088490768859628587961,-0.4539904997395468044807387286709854379296}
#define T_40_7 {0.4539904997395468044807387286709854379296,-0.8910065241883678988088490768859628587961}
#define T_40_9 {0.1564344650402308689596253543641068972647,-0.9876883405951377703502203075913712382317}
#define T_40_11 {-0.1564344650402308689596253543641068972647,-0.9876883405951377703502203075913712382317}
#define T_40_13 {-0.4539904997395468044807387286709854379296,-0.8910065241883678988088490768859628587961}
#define T_40_17 {-0.8910065241883678988088490768859628587961,-0.4539904997395468044807387286709854379296}
#define T_40_19 {-0.9876883405951377703502203075913712382317,-0.1564344650402308689596253543641068972647}
#define T_40_21 {-0.9876883405951377703502203075913712382317,0.1564344650402308689596253543641068972647}
#define T_40_23 {-0.8910065241883678988088490768859628587961,0.4539904997395468044807387286709854379296}
#define T_40_27 {-0.4539904997395468044807387286709854379296,0.8910065241883678988088490768859628587961}
#define T_40_29 {-0.1564344650402308689596253543641068972647,0.9876883405951377703502203075913712382317}
#define T_40_31 {0.1564344650402308689596253543641068972647,0.9876883405951377703502203075913712382317}
#define T_40_33 {0.4539904997395468044807387286709854379296,0.8910065241883678988088490768859628587961}
#define T_40_37 {0.8910065241883678988088490768859628587961,0.4539904997395468044807387286709854379296}
#define T_40_39 {0.9876883405951377703502203075913712382317,0.1564344650402308689596253543641068972647}
// Pre-computed twiddles for N=41
#define T_41_1 {0.9882804237803485269964198778325226157904,-0.1526492842188744980536085904532228596509}
#define T_41_2 {0.9533963920549305415264029761601705104113,-0.3017205985951922908583355820155702531338}
#define T_41_3 {0.8961655569610555982507094086031429469585,-0.4437198378669596765533356119703967124224}
#define T_41_4 {0.8179293607667176280173748637025710195303,-0.5753186602186205478304259486321825534105}
#define T_41_5 {0.7205215936007870469737213170446921139956,-0.6934325007922417238859225108171813189983}
#define T_41_6 {0.6062254109666380674781294146669097244740,-0.7952928712734264049544208319275639951229}
#define T_41_7 {0.4777198185122629170429320311086485162377,-0.8785122509109424271400712314061820507050}
#define T_41_8 {0.3380168784085027522401389887818368151784,-0.9411400479795615225953042681794613599777}
#define T_41_9 {0.1903911091646683650946414445570553652942,-0.9817083199968549278580098871316295117140}
#define T_41_10 {0.0383027336900353468363000786212069215253,-0.9992661810508099984318164388241712003946}
#define T_41_11 {-0.1146834253984004292625797916116425767541,-0.9934020897596750332425585838791448622942}
#define T_41_12 {-0.2649815021966616668258609479380538687110,-0.9642534954531409852052092901431024074554}
#define T_41_13 {-0.4090686371713398994387489437940530478954,-0.9125036164765499835382911442138720303774}
#define T_41_14 {-0.5435675500012211447398158270516432821751,-0.8393654261319499765292562187823932617903}
#define T_41_15 {-0.6653257001655653590788119799981359392405,-0.7465532216119626918171547913516405969858}
#define T_41_16 {-0.7714891798219428720173596047970931977034,-0.6362424423265597983601082887616939842701}
#define T_41_17 {-0.8595696069872011957357926803524605929852,-0.5110186794471103244319465375156141817570}
#define T_41_18 {-0.9275024511020946160755329401581548154354,-0.3738170718407687886930546028452226892114}
#define T_41_19 {-0.9736954238777790759939989584381692111492,-0.2278535089031375748813701420658617280424}
#define T_41_20 {-0.9970658011837404410826479761453811079264,-0.0765492528364956487108017313403252046555}
#define T_41_21 {-0.9970658011837404410826479761453811079264,0.0765492528364956487108017313403252046555}
#define T_41_22 {-0.9736954238777790759939989584381692111492,0.2278535089031375748813701420658617280424}
#define T_41_23 {-0.9275024511020946160755329401581548154354,0.3738170718407687886930546028452226892114}
#define T_41_24 {-0.8595696069872011957357926803524605929852,0.5110186794471103244319465375156141817570}
#define T_41_25 {-0.7714891798219428720173596047970931977034,0.6362424423265597983601082887616939842701}
#define T_41_26 {-0.6653257001655653590788119799981359392405,0.7465532216119626918171547913516405969858}
#define T_41_27 {-0.5435675500012211447398158270516432821751,0.8393654261319499765292562187823932617903}
#define T_41_28 {-0.4090686371713398994387489437940530478954,0.9125036164765499835382911442138720303774}
#define T_41_29 {-0.2649815021966616668258609479380538687110,0.9642534954531409852052092901431024074554}
#define T_41_30 {-0.1146834253984004292625797916116425767541,0.9934020897596750332425585838791448622942}
#define T_41_31 {0.0383027336900353468363000786212069215253,0.9992661810508099984318164388241712003946}
#define T_41_32 {0.1903911091646683650946414445570553652942,0.9817083199968549278580098871316295117140}
#define T_41_33 {0.3380168784085027522401389887818368151784,0.9411400479795615225953042681794613599777}
#define T_41_34 {0.4777198185122629170429320311086485162377,0.8785122509109424271400712314061820507050}
#define T_41_35 {0.6062254109666380674781294146669097244740,0.7952928712734264049544208319275639951229}
#define T_41_36 {0.7205215936007870469737213170446921139956,0.6934325007922417238859225108171813189983}
#define T_41_37 {0.8179293607667176280173748637025710195303,0.5753186602186205478304259486321825534105}
#define T_41_38 {0.8961655569610555982507094086031429469585,0.4437198378669596765533356119703967124224}
#define T_41_39 {0.9533963920549305415264029761601705104113,0.3017205985951922908583355820155702531338}
#define T_41_40 {0.9882804237803485269964198778325226157904,0.1526492842188744980536085904532228596509}
// Pre-computed twiddles for N=42
#define T_42_1 {0.9888308262251285229993413850024808198214,-0.1490422661761744427266762613726314157248}
#define T_42_5 {0.7330518718298263403099213064706418663263,-0.6801727377709193556043487660645041614771}
#define T_42_11 {-0.0747300935864242538153590089677891228348,-0.9972037971811801293497978804225567728281}
#define T_42_13 {-0.3653410243663950396353357064072042703629,-0.9308737486442042463608004254638217389584}
#define T_42_17 {-0.8262387743159949060611779714236035943031,-0.5633200580636220644592526696214918047190}
#define T_42_19 {-0.9555728057861406776751778124889824539423,-0.2947551744109042082264693362958496436477}
#define T_42_23 {-0.9555728057861406776751778124889824539423,0.2947551744109042082264693362958496436477}
#define T_42_25 {-0.8262387743159949060611779714236035943031,0.5633200580636220644592526696214918047190}
#define T_42_29 {-0.3653410243663950396353357064072042703629,0.9308737486442042463608004254638217389584}
#define T_42_31 {-0.0747300935864242538153590089677891228348,0.9972037971811801293497978804225567728281}
#define T_42_37 {0.7330518718298263403099213064706418663263,0.6801727377709193556043487660645041614771}
#define T_42_41 {0.9888308262251285229993413850024808198214,0.1490422661761744427266762613726314157248}
// Pre-computed twiddles for N=43
#define T_43_1 {0.9893433680751102521355733188102021813393,-0.1456011677350048660883885531802661716938}
#define T_43_2 {0.9576005999084059583381645097688306123018,-0.2880990993652375875555549100681673735380}
#define T_43_3 {0.9054482374931466237555355291988234966993,-0.4244566988758151082627989580942085012794}
#define T_43_4 {0.8339978178898779237471217129495926201344,-0.5517677407704458802939484485250432044268}
#define T_43_5 {0.7447721827437818742367880986421369016171,-0.6673188112222394607897513196803629398346}
#define T_43_6 {0.6396730215588912749069550045533105731010,-0.7686471397785320514017826099006924778223}
#define T_43_7 {0.5209403404879302534880025632446631789207,-0.8535930890373464308140682987868785858154}
#define T_43_8 {0.3911047204901559881662365114607382565737,-0.9203461835691594261632531015493441373110}
#define T_43_9 {0.2529333823916807277853990854055155068636,-0.9674836970574252070775855827378109097481}
#define T_43_10 {0.1093712083778743821005363656695408280939,-0.9940009752399459053151531406911090016365}
#define T_43_11 {-0.0365220230576588367199519780115224421024,-0.9993328483702393905119265582470688968897}
#define T_43_12 {-0.1816368509794364372034181087656179443002,-0.9833656768294660732721013118862174451351}
#define T_43_13 {-0.3228804047714461944451613817363977432251,-0.9464397731576092986927051242673769593239}
#define T_43_14 {-0.4572423233046385426803226437186822295189,-0.8893421488825189458182762791693676263094}
#define T_43_15 {-0.5818589155579528826578439293371047824621,-0.8132897407355653696114927697635721415281}
#define T_43_16 {-0.6940741952206338494235637881502043455839,-0.7199034737579957932140928278386127203703}
#define T_43_17 {-0.7914964884292541302812651338172145187855,-0.6111737140978492632825691543985158205032}
#define T_43_18 {-0.8720494081438076028334194234048482030630,-0.4894178478110854935145823674247367307544}
#define T_43_19 {-0.9340161087325480337995031732134521007538,-0.3572308898011327671362380442587891593575}
#define T_43_20 {-0.9760758775559271738231359449855517596006,-0.2174301755815569725527325317671056836843}
#define T_43_21 {-0.9973322836635516441816662336350418627262,-0.0729953146609075287365442363807233050466}
#define T_43_22 {-0.9973322836635516441816662336350418627262,0.0729953146609075287365442363807233050466}
#define T_43_23 {-0.9760758775559271738231359449855517596006,0.2174301755815569725527325317671056836843}
#define T_43_24 {-0.9340161087325480337995031732134521007538,0.3572308898011327671362380442587891593575}
#define T_43_25 {-0.8720494081438076028334194234048482030630,0.4894178478110854935145823674247367307544}
#define T_43_26 {-0.7914964884292541302812651338172145187855,0.6111737140978492632825691543985158205032}
#define T_43_27 {-0.6940741952206338494235637881502043455839,0.7199034737579957932140928278386127203703}
#define T_43_28 {-0.5818589155579528826578439293371047824621,0.8132897407355653696114927697635721415281}
#define T_43_29 {-0.4572423233046385426803226437186822295189,0.8893421488825189458182762791693676263094}
#define T_43_30 {-0.3228804047714461944451613817363977432251,0.9464397731576092986927051242673769593239}
#define T_43_31 {-0.1816368509794364372034181087656179443002,0.9833656768294660732721013118862174451351}
#define T_43_32 {-0.0365220230576588367199519780115224421024,0.9993328483702393905119265582470688968897}
#define T_43_33 {0.1093712083778743821005363656695408280939,0.9940009752399459053151531406911090016365}
#define T_43_34 {0.2529333823916807277853990854055155068636,0.9674836970574252070775855827378109097481}
#define T_43_35 {0.3911047204901559881662365114607382565737,0.9203461835691594261632531015493441373110}
#define T_43_36 {0.5209403404879302534880025632446631789207,0.8535930890373464308140682987868785858154}
#define T_43_37 {0.6396730215588912749069550045533105731010,0.7686471397785320514017826099006924778223}
#define T_43_38 {0.7447721827437818742367880986421369016171,0.6673188112222394607897513196803629398346}
#define T_43_39 {0.8339978178898779237471217129495926201344,0.5517677407704458802939484485250432044268}
#define T_43_40 {0.9054482374931466237555355291988234966993,0.4244566988758151082627989580942085012794}
#define T_43_41 {0.9576005999084059583381645097688306123018,0.2880990993652375875555549100681673735380}
#define T_43_42 {0.9893433680751102521355733188102021813393,0.1456011677350048660883885531802661716938}
// Pre-computed twiddles for N=44
#define T_44_1 {0.9898214418809326842207951813179533928633,-0.1423148382732851435772403192459023557603}
#define T_44_3 {0.9096319953545183301102383666147943586111,-0.4154150130018864350844864929968025535345}
#define T_44_5 {0.7557495743542582689045161714602727442980,-0.6548607339452851006100786435126792639494}
#define T_44_7 {0.5406408174555975554298470342473592609167,-0.8412535328311812055090967987780459225178}
#define T_44_9 {0.2817325568414296710351152341900160536170,-0.9594929736144973686506887133873533457518}
#define T_44_13 {-0.2817325568414296710351152341900160536170,-0.9594929736144973686506887133873533457518}
#define T_44_15 {-0.5406408174555975554298470342473592609167,-0.8412535328311812055090967987780459225178}
#define T_44_17 {-0.7557495743542582689045161714602727442980,-0.6548607339452851006100786435126792639494}
#define T_44_19 {-0.9096319953545183301102383666147943586111,-0.4154150130018864350844864929968025535345}
#define T_44_21 {-0.9898214418809326842207951813179533928633,-0.1423148382732851435772403192459023557603}
#define T_44_23 {-0.9898214418809326842207951813179533928633,0.1423148382732851435772403192459023557603}
#define T_44_25 {-0.9096319953545183301102383666147943586111,0.4154150130018864350844864929968025535345}
#define T_44_27 {-0.7557495743542582689045161714602727442980,0.6548607339452851006100786435126792639494}
#define T_44_29 {-0.5406408174555975554298470342473592609167,0.8412535328311812055090967987780459225178}
#define T_44_31 {-0.2817325568414296710351152341900160536170,0.9594929736144973686506887133873533457518}
#define T_44_35 {0.2817325568414296710351152341900160536170,0.9594929736144973686506887133873533457518}
#define T_44_37 {0.5406408174555975554298470342473592609167,0.8412535328311812055090967987780459225178}
#define T_44_39 {0.7557495743542582689045161714602727442980,0.6548607339452851006100786435126792639494}
#define T_44_41 {0.9096319953545183301102383666147943586111,0.4154150130018864350844864929968025535345}
#define T_44_43 {0.9898214418809326842207951813179533928633,0.1423148382732851435772403192459023557603}
// Pre-computed twiddles for N=45
#define T_45_1 {0.9902680687415703619791429446195252239704,-0.1391731009600654378477457839835551567376}
#define T_45_2 {0.9612616959383188941501430235803127288818,-0.2756373558169991633270967668067896738648}
#define T_45_4 {0.8480480961564259567708745635172817856073,-0.5299192642332049008047079041716642677784}
#define T_45_7 {0.5591929034707467938147829045192338526249,-0.8290375725550417351783494268602225929499}
#define T_45_8 {0.4383711467890774038380641286494210362434,-0.8987940462991670376169395240140147507191}
#define T_45_11 {0.0348994967025009691918846499447681708261,-0.9993908270190957621181837566837202757597}
#define T_45_13 {-0.2419218955996677300479547056966111995280,-0.9702957262759964729426087615138385444880}
#define T_45_14 {-0.3746065934159120147661781174974748864770,-0.9271838545667874242894868075381964445114}
#define T_45_16 {-0.6156614753256582917018135958642233163118,-0.7880107536067219031750141766679007560015}
#define T_45_17 {-0.7193398003386511918577639335126150399446,-0.6946583704589972541043607634492218494415}
#define T_45_19 {-0.8829475928589269884128043486271053552628,-0.4694715627858907502911733899964019656181}
#define T_45_22 {-0.9975640502598241976528470331686548888683,-0.0697564737441253024385900971537921577692}
#define T_45_23 {-0.9975640502598241976528470331686548888683,0.0697564737441253024385900971537921577692}
#define T_45_26 {-0.8829475928589269884128043486271053552628,0.4694715627858907502911733899964019656181}
#define T_45_28 {-0.7193398003386511918577639335126150399446,0.6946583704589972541043607634492218494415}
#define T_45_29 {-0.6156614753256582917018135958642233163118,0.7880107536067219031750141766679007560015}
#define T_45_31 {-0.3746065934159120147661781174974748864770,0.9271838545667874242894868075381964445114}
#define T_45_32 {-0.2419218955996677300479547056966111995280,0.9702957262759964729426087615138385444880}
#define T_45_34 {0.0348994967025009691918846499447681708261,0.9993908270190957621181837566837202757597}
#define T_45_37 {0.4383711467890774038380641286494210362434,0.8987940462991670376169395240140147507191}
#define T_45_38 {0.5591929034707467938147829045192338526249,0.8290375725550417351783494268602225929499}
#define T_45_41 {0.8480480961564259567708745635172817856073,0.5299192642332049008047079041716642677784}
#define T_45_43 {0.9612616959383188941501430235803127288818,0.2756373558169991633270967668067896738648}
#define T_45_44 {0.9902680687415703619791429446195252239704,0.1391731009600654378477457839835551567376}
// Pre-computed twiddles for N=46
#define T_46_1 {0.9906859460363307556818313059920910745859,-0.1361666490962465947411885736073600128293}
#define T_46_3 {0.9172113015054530471559246507240459322929,-0.3984010898462414518306218269572127610445}
#define T_46_5 {0.7757112907044197980255262336868327111006,-0.6310879443260527521530889316636603325605}
#define T_46_7 {0.5766803221148671942941632551082875579596,-0.8169698930104419831721429545723367482424}
#define T_46_9 {0.3348796121709861628445992209890391677618,-0.9422609221188205097519130504224449396133}
#define T_46_11 {0.0682424133646709757394788198325841221958,-0.9976687691905391508484512996801640838385}
#define T_46_13 {-0.2034560130526337773382294926705071702600,-0.9790840876823229121939107244543265551329}
#define T_46_15 {-0.4600650377311521488365997356595471501350,-0.8878852184023752203145818384655285626650}
#define T_46_17 {-0.6825531432186541236362131712667178362608,-0.7308359642781241394260405286331661045551}
#define T_46_19 {-0.8544194045464885700624790842994116246700,-0.5195839500354335616094658689689822494984}
#define T_46_21 {-0.9629172873477992444790629633644130080938,-0.2697967711570242732577185051923152059317}
#define T_46_25 {-0.9629172873477992444790629633644130080938,0.2697967711570242732577185051923152059317}
#define T_46_27 {-0.8544194045464885700624790842994116246700,0.5195839500354335616094658689689822494984}
#define T_46_29 {-0.6825531432186541236362131712667178362608,0.7308359642781241394260405286331661045551}
#define T_46_31 {-0.4600650377311521488365997356595471501350,0.8878852184023752203145818384655285626650}
#define T_46_33 {-0.2034560130526337773382294926705071702600,0.9790840876823229121939107244543265551329}
#define T_46_35 {0.0682424133646709757394788198325841221958,0.9976687691905391508484512996801640838385}
#define T_46_37 {0.3348796121709861628445992209890391677618,0.9422609221188205097519130504224449396133}
#define T_46_39 {0.5766803221148671942941632551082875579596,0.8169698930104419831721429545723367482424}
#define T_46_41 {0.7757112907044197980255262336868327111006,0.6310879443260527521530889316636603325605}
#define T_46_43 {0.9172113015054530471559246507240459322929,0.3984010898462414518306218269572127610445}
#define T_46_45 {0.9906859460363307556818313059920910745859,0.1361666490962465947411885736073600128293}
// Pre-computed twiddles for N=47
#define T_47_1 {0.9910774881547801395953456449205987155437,-0.1332869553737788537173258873735903762281}
#define T_47_2 {0.9644691750543765706993326602969318628311,-0.2641954018712859841855333797866478562355}
#define T_47_3 {0.9206498866764287747344042145414277911186,-0.3903892751634948088401699806126998737454}
#define T_47_4 {0.8604015792601393819438726495718583464622,-0.5096166425919174125525046292750630527735}
#define T_47_5 {0.7847993852786609991767363680992275476456,-0.6197498889602448546298774090246297419071}
#define T_47_6 {0.6951924276746422881601006338314618915319,-0.7188236838779293869094999536173418164253}
#define T_47_7 {0.5931797447293551961422508611576631665230,-0.8050700531275629678873428929364308714867}
#define T_47_8 {0.4805817551866837789020792115479707717896,-0.8769499282066715029060333108645863831043}
#define T_47_9 {0.3594077728375128510940328396827680990100,-0.9331806110416025479281643129070289433002}
#define T_47_10 {0.2318201502675282799081912799010751768947,-0.9727586637650371681473870921763591468334}
#define T_47_11 {0.1000956916240983429755573297370574437082,-0.9949778150885040250983593068667687475681}
#define T_47_12 {-0.0334149770076745677993557137597235850990,-0.9994415637302546118192481117148417979479}
#define T_47_13 {-0.1663293545831300290771537220280151814222,-0.9860702539900285668039714437327347695827}
#define T_47_14 {-0.2962755808856339934109769274073187261820,-0.9551024972069124263640560457133688032627}
#define T_47_15 {-0.4209347624283349964535716480895644053817,-0.9070909137343406980491522517695557326078}
#define T_47_16 {-0.5380823531633727174749992627766914665699,-0.8428922714167970120513473375467583537102}
#define T_47_17 {-0.6456278515588024236038222625211346894503,-0.7636521965473320738837514909391757100821}
#define T_47_18 {-0.7416521056479575824127437044808175414801,-0.6707847301392234617978260757809039205313}
#define T_47_19 {-0.8244415603417603044533734646392986178398,-0.5659470943305952017610138682357501238585}
#define T_47_20 {-0.8925188358598812321531568159116432070732,-0.4510101192161018457404964010493131354451}
#define T_47_21 {-0.9446690916079187871901012840680778026581,-0.3280248578395690839393239457422168925405}
#define T_47_22 {-0.9799617050365868609063113581214565783739,-0.1991859851038360884611932988264015875757}
#define T_47_23 {-0.9977668786231531639074887607421260327101,-0.0667926337451215518248304192638897802681}
#define T_47_24 {-0.9977668786231531639074887607421260327101,0.0667926337451215518248304192638897802681}
#define T_47_25 {-0.9799617050365868609063113581214565783739,0.1991859851038360884611932988264015875757}
#define T_47_26 {-0.9446690916079187871901012840680778026581,0.3280248578395690839393239457422168925405}
#define T_47_27 {-0.8925188358598812321531568159116432070732,0.4510101192161018457404964010493131354451}
#define T_47_28 {-0.8244415603417603044533734646392986178398,0.5659470943305952017610138682357501238585}
#define T_47_29 {-0.7416521056479575824127437044808175414801,0.6707847301392234617978260757809039205313}
#define T_47_30 {-0.6456278515588024236038222625211346894503,0.7636521965473320738837514909391757100821}
#define T_47_31 {-0.5380823531633727174749992627766914665699,0.8428922714167970120513473375467583537102}
#define T_47_32 {-0.4209347624283349964535716480895644053817,0.9070909137343406980491522517695557326078}
#define T_47_33 {-0.2962755808856339934109769274073187261820,0.9551024972069124263640560457133688032627}
#define T_47_34 {-0.1663293545831300290771537220280151814222,0.9860702539900285668039714437327347695827}
#define T_47_35 {-0.0334149770076745677993557137597235850990,0.9994415637302546118192481117148417979479}
#define T_47_36 {0.1000956916240983429755573297370574437082,0.9949778150885040250983593068667687475681}
#define T_47_37 {0.2318201502675282799081912799010751768947,0.9727586637650371681473870921763591468334}
#define T_47_38 {0.3594077728375128510940328396827680990100,0.9331806110416025479281643129070289433002}
#define T_47_39 {0.4805817551866837789020792115479707717896,0.8769499282066715029060333108645863831043}
#define T_47_40 {0.5931797447293551961422508611576631665230,0.8050700531275629678873428929364308714867}
#define T_47_41 {0.6951924276746422881601006338314618915319,0.7188236838779293869094999536173418164253}
#define T_47_42 {0.7847993852786609991767363680992275476456,0.6197498889602448546298774090246297419071}
#define T_47_43 {0.8604015792601393819438726495718583464622,0.5096166425919174125525046292750630527735}
#define T_47_44 {0.9206498866764287747344042145414277911186,0.3903892751634948088401699806126998737454}
#define T_47_45 {0.9644691750543765706993326602969318628311,0.2641954018712859841855333797866478562355}
#define T_47_46 {0.9910774881547801395953456449205987155437,0.1332869553737788537173258873735903762281}
// Pre-computed twiddles for N=48
#define T_48_1 {0.9914448613738103821546587823831941932440,-0.1305261922200516011560722517970134504139}
#define T_48_5 {0.7933533402912351650826394688920117914677,-0.6087614290087206558865773331490345299244}
#define T_48_7 {0.6087614290087206558865773331490345299244,-0.7933533402912351650826394688920117914677}
#define T_48_11 {0.1305261922200516011560722517970134504139,-0.9914448613738103821546587823831941932440}
#define T_48_13 {-0.1305261922200516011560722517970134504139,-0.9914448613738103821546587823831941932440}
#define T_48_17 {-0.6087614290087206558865773331490345299244,-0.7933533402912351650826394688920117914677}
#define T_48_19 {-0.7933533402912351650826394688920117914677,-0.6087614290087206558865773331490345299244}
#define T_48_23 {-0.9914448613738103821546587823831941932440,-0.1305261922200516011560722517970134504139}
#define T_48_25 {-0.9914448613738103821546587823831941932440,0.1305261922200516011560722517970134504139}
#define T_48_29 {-0.7933533402912351650826394688920117914677,0.6087614290087206558865773331490345299244}
#define T_48_31 {-0.6087614290087206558865773331490345299244,0.7933533402912351650826394688920117914677}
#define T_48_35 {-0.1305261922200516011560722517970134504139,0.9914448613738103821546587823831941932440}
#define T_48_37 {0.1305261922200516011560722517970134504139,0.9914448613738103821546587823831941932440}
#define T_48_41 {0.6087614290087206558865773331490345299244,0.7933533402912351650826394688920117914677}
#define T_48_43 {0.7933533402912351650826394688920117914677,0.6087614290087206558865773331490345299244}
#define T_48_47 {0.9914448613738103821546587823831941932440,0.1305261922200516011560722517970134504139}
// Pre-computed twiddles for N=49
#define T_49_1 {0.9917900138232461637599612913618329912424,-0.1278771616845060243861098570050671696663}
#define T_49_2 {0.9672948630390294511016691103577613830566,-0.2536545839095074028612941674509784206748}
#define T_49_3 {0.9269167573460217468550581543240696191788,-0.3752670048793741441883753395813982933760}
#define T_49_4 {0.8713187041233892982106112867768388241529,-0.4907175520039379068570895015000132843852}
#define T_49_5 {0.8014136218679566159295291072339750826359,-0.5981105304912159859043185861082747578621}
#define T_49_6 {0.7183493500977276013941263954620808362961,-0.6956825506034863826343439541233237832785}
#define T_49_8 {0.5183925683105250481474968182737939059734,-0.8551427630053461959036553707846906036139}
#define T_49_9 {0.4047833431223938349674540404521394520998,-0.9144126230158124979396916387486271560192}
#define T_49_10 {0.2845275866310324475172421898605534806848,-0.9586678530366605777146560285473242402077}
#define T_49_11 {0.1595998950333792354427941972971893846989,-0.9871817834144501757620560056238900870085}
#define T_49_12 {0.0320515775716551723495406633901438908651,-0.9994862162006878936182374673080630600452}
#define T_49_13 {-0.0960230259076817610486287435378471855074,-0.9953791129491982303534314269199967384338}
#define T_49_15 {-0.3453650544213076045707566663622856140137,-0.9384684220497604423272264284605626016855}
#define T_49_16 {-0.4625382902408352592260598612483590841293,-0.8865993063730001066957697730686049908400}
#define T_49_17 {-0.5721166601221696623724710661917924880981,-0.8201722545969558630929441278567537665367}
#define T_49_18 {-0.6723008902613167858675069510354660451412,-0.7402779970753154969997922307811677455902}
#define T_49_19 {-0.7614459583691344235489850689191371202469,-0.6482283953077884186555479573144111782312}
#define T_49_20 {-0.8380881048918407127956697877380065619946,-0.5455349012105487060964037482335697859526}
#define T_49_22 {-0.9490557470106686377420146527583710849285,-0.3151082180236207119783387042843969538808}
#define T_49_23 {-0.9815591569910653291231028561014682054520,-0.1911586287013722906813484314625384286046}
#define T_49_24 {-0.9979453927503363352968790422892197966576,-0.0640702199807129252340232028473110403866}
#define T_49_25 {-0.9979453927503363352968790422892197966576,0.0640702199807129252340232028473110403866}
#define T_49_26 {-0.9815591569910653291231028561014682054520,0.1911586287013722906813484314625384286046}
#define T_49_27 {-0.9490557470106686377420146527583710849285,0.3151082180236207119783387042843969538808}
#define T_49_29 {-0.8380881048918407127956697877380065619946,0.5455349012105487060964037482335697859526}
#define T_49_30 {-0.7614459583691344235489850689191371202469,0.6482283953077884186555479573144111782312}
#define T_49_31 {-0.6723008902613167858675069510354660451412,0.7402779970753154969997922307811677455902}
#define T_49_32 {-0.5721166601221696623724710661917924880981,0.8201722545969558630929441278567537665367}
#define T_49_33 {-0.4625382902408352592260598612483590841293,0.8865993063730001066957697730686049908400}
#define T_49_34 {-0.3453650544213076045707566663622856140137,0.9384684220497604423272264284605626016855}
#define T_49_36 {-0.0960230259076817610486287435378471855074,0.9953791129491982303534314269199967384338}
#define T_49_37 {0.0320515775716551723495406633901438908651,0.9994862162006878936182374673080630600452}
#define T_49_38 {0.1595998950333792354427941972971893846989,0.9871817834144501757620560056238900870085}
#define T_49_39 {0.2845275866310324475172421898605534806848,0.9586678530366605777146560285473242402077}
#define T_49_40 {0.4047833431223938349674540404521394520998,0.9144126230158124979396916387486271560192}
#define T_49_41 {0.5183925683105250481474968182737939059734,0.8551427630053461959036553707846906036139}
#define T_49_43 {0.7183493500977276013941263954620808362961,0.6956825506034863826343439541233237832785}
#define T_49_44 {0.8014136218679566159295291072339750826359,0.5981105304912159859043185861082747578621}
#define T_49_45 {0.8713187041233892982106112867768388241529,0.4907175520039379068570895015000132843852}
#define T_49_46 {0.9269167573460217468550581543240696191788,0.3752670048793741441883753395813982933760}
#define T_49_47 {0.9672948630390294511016691103577613830566,0.2536545839095074028612941674509784206748}
#define T_49_48 {0.9917900138232461637599612913618329912424,0.1278771616845060243861098570050671696663}
// Pre-computed twiddles for N=50
#define T_50_1 {0.9921147013144778759041741977853234857321,-0.1253332335643042583228634612169116735458}
#define T_50_3 {0.9297764858882514582560929738974664360285,-0.3681245526846779747565108209528261795640}
#define T_50_7 {0.6374239897486897454825793829513713717461,-0.7705132427757892532582673084107227623463}
#define T_50_9 {0.4257792915650726595089281545369885861874,-0.9048270524660195768262838100781664252281}
#define T_50_11 {0.1873813145857246287295794218152877874672,-0.9822872507286887211463977109815459698439}
#define T_50_13 {-0.0627905195293133738809743249476014170796,-0.9980267284282715589682766221812926232815}
#define T_50_17 {-0.5358267949789966566598309327673632651567,-0.8443279255020150753097141205216757953167}
#define T_50_19 {-0.7289686274214115524472390461596660315990,-0.6845471059286887260952880751574411988258}
#define T_50_21 {-0.8763066800438635839398671123490203171968,-0.4817536741017152679411594817793229594827}
#define T_50_23 {-0.9685831611286310760533524444326758384705,-0.2486898871648547948431939857982797548175}
#define T_50_27 {-0.9685831611286310760533524444326758384705,0.2486898871648547948431939857982797548175}
#define T_50_29 {-0.8763066800438635839398671123490203171968,0.4817536741017152679411594817793229594827}
#define T_50_31 {-0.7289686274214115524472390461596660315990,0.6845471059286887260952880751574411988258}
#define T_50_33 {-0.5358267949789966566598309327673632651567,0.8443279255020150753097141205216757953167}
#define T_50_37 {-0.0627905195293133738809743249476014170796,0.9980267284282715589682766221812926232815}
#define T_50_39 {0.1873813145857246287295794218152877874672,0.9822872507286887211463977109815459698439}
#define T_50_41 {0.4257792915650726595089281545369885861874,0.9048270524660195768262838100781664252281}
#define T_50_43 {0.6374239897486897454825793829513713717461,0.7705132427757892532582673084107227623463}
#define T_50_47 {0.9297764858882514582560929738974664360285,0.3681245526846779747565108209528261795640}
#define T_50_49 {0.9921147013144778759041741977853234857321,0.1253332335643042583228634612169116735458}
// Pre-computed twiddles for N=51
#define T_51_1 {0.9924205096719357355183888103056233376265,-0.1228882906647141282086010960483690723777}
#define T_51_2 {0.9697969360350094936151776892074849456549,-0.2439137201083771411269651707698358222842}
#define T_51_4 {0.8810121942857844778984599543036893010139,-0.4730935568360100651474908772797789424658}
#define T_51_5 {0.8161969123562217154344011760258581489325,-0.5777738314082511150715504300023894757032}
#define T_51_7 {0.6506183002042421614774525551183614879847,-0.7594049166547071072486119192035403102636}
#define T_51_8 {0.5523649729605057956405289587564766407013,-0.8336023852211195128703025147842708975077}
#define T_51_10 {0.3323547994796596793953824544587405398488,-0.9431544344712774474714933603536337614059}
#define T_51_11 {0.2139330832064974263762024975221720524132,-0.9768483177596006816756357693520840257406}
#define T_51_13 {-0.0307950585561703529813293300776422256604,-0.9995257197133659010646056231053080409765}
#define T_51_14 {-0.1533916548786853628616455580413457937539,-0.9881654720812593772905074729351326823235}
#define T_51_16 {-0.3897858732926793856599090304371202364564,-0.9209055179449536776559170903055928647518}
#define T_51_19 {-0.6961339459629266590567908679076936095953,-0.7179119230644419591413907255628146231174}
#define T_51_20 {-0.7790805745256704772927491831069346517324,-0.6269238058941064561935263554914854466915}
#define T_51_22 {-0.9084652718195236342779708138550631701946,-0.4179603448867834081248417987808352336287}
#define T_51_23 {-0.9529420004271565991516013127693440765142,-0.3031526741130434743354271631687879562378}
#define T_51_25 {-0.9981033287370441042796187502972315996885,-0.0615609061339428345616120452632458182052}
#define T_51_26 {-0.9981033287370441042796187502972315996885,0.0615609061339428345616120452632458182052}
#define T_51_28 {-0.9529420004271565991516013127693440765142,0.3031526741130434743354271631687879562378}
#define T_51_29 {-0.9084652718195236342779708138550631701946,0.4179603448867834081248417987808352336287}
#define T_51_31 {-0.7790805745256704772927491831069346517324,0.6269238058941064561935263554914854466915}
#define T_51_32 {-0.6961339459629266590567908679076936095953,0.7179119230644419591413907255628146231174}
#define T_51_35 {-0.3897858732926793856599090304371202364564,0.9209055179449536776559170903055928647518}
#define T_51_37 {-0.1533916548786853628616455580413457937539,0.9881654720812593772905074729351326823235}
#define T_51_38 {-0.0307950585561703529813293300776422256604,0.9995257197133659010646056231053080409765}
#define T_51_40 {0.2139330832064974263762024975221720524132,0.9768483177596006816756357693520840257406}
#define T_51_41 {0.3323547994796596793953824544587405398488,0.9431544344712774474714933603536337614059}
#define T_51_43 {0.5523649729605057956405289587564766407013,0.8336023852211195128703025147842708975077}
#define T_51_44 {0.6506183002042421614774525551183614879847,0.7594049166547071072486119192035403102636}
#define T_51_46 {0.8161969123562217154344011760258581489325,0.5777738314082511150715504300023894757032}
#define T_51_47 {0.8810121942857844778984599543036893010139,0.4730935568360100651474908772797789424658}
#define T_51_49 {0.9697969360350094936151776892074849456549,0.2439137201083771411269651707698358222842}
#define T_51_50 {0.9924205096719357355183888103056233376265,0.1228882906647141282086010960483690723777}
// Pre-computed twiddles for N=52
#define T_52_1 {0.9927088740980539727232212499075103551149,-0.1205366802553230476391377123945858329535}
#define T_52_3 {0.9350162426854148334243177487223874777555,-0.3546048870425356214219902994955191388726}
#define T_52_5 {0.8229838658936563522416918203816749155521,-0.5680647467311558118652214943722356110811}
#define T_52_7 {0.6631226582407951930520084715681150555611,-0.7485107481711010812830409122398123145103}
#define T_52_9 {0.4647231720437685620339607339701615273952,-0.8854560256532099105086786039464641362429}
#define T_52_11 {0.2393156642875577666540465315847541205585,-0.9709418174260520117968553677201271057129}
#define T_52_15 {-0.2393156642875577666540465315847541205585,-0.9709418174260520117968553677201271057129}
#define T_52_17 {-0.4647231720437685620339607339701615273952,-0.8854560256532099105086786039464641362429}
#define T_52_19 {-0.6631226582407951930520084715681150555611,-0.7485107481711010812830409122398123145103}
#define T_52_21 {-0.8229838658936563522416918203816749155521,-0.5680647467311558118652214943722356110811}
#define T_52_23 {-0.9350162426854148334243177487223874777555,-0.3546048870425356214219902994955191388726}
#define T_52_25 {-0.9927088740980539727232212499075103551149,-0.1205366802553230476391377123945858329535}
#define T_52_27 {-0.9927088740980539727232212499075103551149,0.1205366802553230476391377123945858329535}
#define T_52_29 {-0.9350162426854148334243177487223874777555,0.3546048870425356214219902994955191388726}
#define T_52_31 {-0.8229838658936563522416918203816749155521,0.5680647467311558118652214943722356110811}
#define T_52_33 {-0.6631226582407951930520084715681150555611,0.7485107481711010812830409122398123145103}
#define T_52_35 {-0.4647231720437685620339607339701615273952,0.8854560256532099105086786039464641362429}
#define T_52_37 {-0.2393156642875577666540465315847541205585,0.9709418174260520117968553677201271057129}
#define T_52_41 {0.2393156642875577666540465315847541205585,0.9709418174260520117968553677201271057129}
#define T_52_43 {0.4647231720437685620339607339701615273952,0.8854560256532099105086786039464641362429}
#define T_52_45 {0.6631226582407951930520084715681150555611,0.7485107481711010812830409122398123145103}
#define T_52_47 {0.8229838658936563522416918203816749155521,0.5680647467311558118652214943722356110811}
#define T_52_49 {0.9350162426854148334243177487223874777555,0.3546048870425356214219902994955191388726}
#define T_52_51 {0.9927088740980539727232212499075103551149,0.1205366802553230476391377123945858329535}
// Pre-computed twiddles for N=53
#define T_53_1 {0.9929810960135169173312874590919818729162,-0.1182731709213658000123814417747780680656}
#define T_53_2 {0.9720229140804107492712660132383462041616,-0.2348860457809836821407856177756912074983}
#define T_53_3 {0.9374196611341208962286941641650628298521,-0.3482016354343988040476176593074342235923}
#define T_53_4 {0.8896570909947473237977533244702499359846,-0.4566292373937130832928232848644256591797}
#define T_53_5 {0.8294056854502017683827830296650063246489,-0.5586467658036524674969314219197258353233}
#define T_53_6 {0.7575112421616200242269201226008590310812,-0.6528221181905216052854257213766686618328}
#define T_53_7 {0.6749830015182105569238046882674098014832,-0.7378332790417272413208138459594920277596}
#define T_53_8 {0.5829794791144721211040291564131621271372,-0.8124868780056813122314451902639120817184}
#define T_53_9 {0.4827922027307448571420422922528814524412,-0.8757349421956368562547368128434754908085}
#define T_53_10 {0.3758275821142381678541255496384110301733,-0.9266896074318334841635191878594923764467}
#define T_53_11 {0.2635871660690676243632424302631989121437,-0.9646355819083586302653543498308863490820}
#define T_53_12 {0.1476465640024812453479086116203689016402,-0.9890401873221640327571435591380577534437}
#define T_53_13 {0.0296333278225597400445945339697573217563,-0.9995608365087943480986609756655525416136}
#define T_53_14 {-0.0887958953229348035840473585267318412662,-0.9960498426152168960356902971398085355759}
#define T_53_15 {-0.2059786187410983793188989920963649637997,-0.9785564922995040326725302293198183178902}
#define T_53_16 {-0.3202698538628376279113751934346510097384,-0.9473263538541913941770644669304601848125}
#define T_53_17 {-0.4300652022765204529619609274959657341242,-0.9027978299657435368175129042356275022030}
#define T_53_18 {-0.5338233779647907351062485759030096232891,-0.8455960035018260656514144102402497082949}
#define T_53_19 {-0.6300878435817111045125216151063796132803,-0.7765238627180424124674118502298370003700}
#define T_53_20 {-0.7175072570443311592569557433307636529207,-0.6965510290629970402420667596743442118168}
#define T_53_21 {-0.7948544414133532631794309963879641145468,-0.6068001458185933172373438537761103361845}
#define T_53_22 {-0.8610436117673555544982377796259243041277,-0.5085311186492205148823586569051258265972}
#define T_53_23 {-0.9151456172430184610178116599854547530413,-0.4031234292879722347358040224207798019052}
#define T_53_24 {-0.9564009842765224256311284989351406693459,-0.2920567706369758265161351573624415323138}
#define T_53_25 {-0.9842305779475968297020926911500282585621,-0.1768902751225729652606588615526561625302}
#define T_53_26 {-0.9982437317643214624851566441066097468138,-0.0592406278937142871665599841435323469341}
#define T_53_27 {-0.9982437317643214624851566441066097468138,0.0592406278937142871665599841435323469341}
#define T_53_28 {-0.9842305779475968297020926911500282585621,0.1768902751225729652606588615526561625302}
#define T_53_29 {-0.9564009842765224256311284989351406693459,0.2920567706369758265161351573624415323138}
#define T_53_30 {-0.9151456172430184610178116599854547530413,0.4031234292879722347358040224207798019052}
#define T_53_31 {-0.8610436117673555544982377796259243041277,0.5085311186492205148823586569051258265972}
#define T_53_32 {-0.7948544414133532631794309963879641145468,0.6068001458185933172373438537761103361845}
#define T_53_33 {-0.7175072570443311592569557433307636529207,0.6965510290629970402420667596743442118168}
#define T_53_34 {-0.6300878435817111045125216151063796132803,0.7765238627180424124674118502298370003700}
#define T_53_35 {-0.5338233779647907351062485759030096232891,0.8455960035018260656514144102402497082949}
#define T_53_36 {-0.4300652022765204529619609274959657341242,0.9027978299657435368175129042356275022030}
#define T_53_37 {-0.3202698538628376279113751934346510097384,0.9473263538541913941770644669304601848125}
#define T_53_38 {-0.2059786187410983793188989920963649637997,0.9785564922995040326725302293198183178902}
#define T_53_39 {-0.0887958953229348035840473585267318412662,0.9960498426152168960356902971398085355759}
#define T_53_40 {0.0296333278225597400445945339697573217563,0.9995608365087943480986609756655525416136}
#define T_53_41 {0.1476465640024812453479086116203689016402,0.9890401873221640327571435591380577534437}
#define T_53_42 {0.2635871660690676243632424302631989121437,0.9646355819083586302653543498308863490820}
#define T_53_43 {0.3758275821142381678541255496384110301733,0.9266896074318334841635191878594923764467}
#define T_53_44 {0.4827922027307448571420422922528814524412,0.8757349421956368562547368128434754908085}
#define T_53_45 {0.5829794791144721211040291564131621271372,0.8124868780056813122314451902639120817184}
#define T_53_46 {0.6749830015182105569238046882674098014832,0.7378332790417272413208138459594920277596}
#define T_53_47 {0.7575112421616200242269201226008590310812,0.6528221181905216052854257213766686618328}
#define T_53_48 {0.8294056854502017683827830296650063246489,0.5586467658036524674969314219197258353233}
#define T_53_49 {0.8896570909947473237977533244702499359846,0.4566292373937130832928232848644256591797}
#define T_53_50 {0.9374196611341208962286941641650628298521,0.3482016354343988040476176593074342235923}
#define T_53_51 {0.9720229140804107492712660132383462041616,0.2348860457809836821407856177756912074983}
#define T_53_52 {0.9929810960135169173312874590919818729162,0.1182731709213658000123814417747780680656}
// Pre-computed twiddles for N=54
#define T_54_1 {0.9932383577419430231714159162947908043861,-0.1160929141252302343456648259234498254955}
#define T_54_5 {0.8354878114129363764206459563865792006254,-0.5495089780708060089864375186152756214142}
#define T_54_7 {0.6862416378687336004915664489089976996183,-0.7273736415730487347985899759805761277676}
#define T_54_11 {0.2868032327110902612865572791633894667029,-0.9579895123154889002847767187631689012051}
#define T_54_13 {0.0581448289104758292422658882969699334353,-0.9983081582712681756319739179161842912436}
#define T_54_17 {-0.3960797660391568442150855844374746084213,-0.9182161068802739967154025180207099765539}
#define T_54_19 {-0.5971585917027861789563303318573161959648,-0.8021231927550437346141620764683466404676}
#define T_54_23 {-0.8936326403234122750518508837558329105377,-0.4487991802004621666455363993009086698294}
#define T_54_25 {-0.9730448705798238062669724968145601451397,-0.2306158707424401654861867427825927734375}
#define T_54_29 {-0.9730448705798238062669724968145601451397,0.2306158707424401654861867427825927734375}
#define T_54_31 {-0.8936326403234122750518508837558329105377,0.4487991802004621666455363993009086698294}
#define T_54_35 {-0.5971585917027861789563303318573161959648,0.8021231927550437346141620764683466404676}
#define T_54_37 {-0.3960797660391568442150855844374746084213,0.9182161068802739967154025180207099765539}
#define T_54_41 {0.0581448289104758292422658882969699334353,0.9983081582712681756319739179161842912436}
#define T_54_43 {0.2868032327110902612865572791633894667029,0.9579895123154889002847767187631689012051}
#define T_54_47 {0.6862416378687336004915664489089976996183,0.7273736415730487347985899759805761277676}
#define T_54_49 {0.8354878114129363764206459563865792006254,0.5495089780708060089864375186152756214142}
#define T_54_53 {0.9932383577419430231714159162947908043861,0.1160929141252302343456648259234498254955}
// Pre-computed twiddles for N=55
#define T_55_1 {0.9934817353485502211540847383730579167604,-0.1139914098905406292239206322847167029977}
#define T_55_2 {0.9740119169423334666291225403256248682737,-0.2264967674257643837076869886004715226591}
#define T_55_3 {0.9418443636395247287040888295450713485479,-0.3360493932154301477410740517370868474245}
#define T_55_4 {0.8973984286913584407230359829554799944162,-0.4412211012432212808853648766671540215611}
#define T_55_6 {0.7741416106390824891647639560687821358442,-0.6330124538088703900484688347205519676208}
#define T_55_7 {0.6969375686552934379136559073231182992458,-0.7171318047589635424898801829840522259474}
#define T_55_8 {0.6106478796354380955690999144280795007944,-0.7919022459222750942586799283162690699100}
#define T_55_9 {0.5163974616389619409773104052874259650707,-0.8563490302515889274204141656809952110052}
#define T_55_12 {0.1985904666457454781358649142930516973138,-0.9800825610923934450013916830357629805803}
#define T_55_13 {0.0855750084788397397117520881693053524941,-0.9963317308626913337832320394227281212807}
#define T_55_14 {-0.0285560507936962540420644529604032868519,-0.9995921928281892299139599344925954937935}
#define T_55_16 {-0.2542183341934869389433515607379376888275,-0.9671468547019571593281739296799059957266}
#define T_55_17 {-0.3628077053506409965777379511564504355192,-0.9318640292114522827304767815803643316031}
#define T_55_18 {-0.4666673232256737247070077501120977103710,-0.8844329309978142816817126004025340080261}
#define T_55_19 {-0.5644432188667691807637538659037090837955,-0.8254718969627740099426205233612563461065}
#define T_55_21 {-0.7367411378764049389999968298070598393679,-0.6761749002740193859040118695702403783798}
#define T_55_23 {-0.8707460771197771398632880845980253070593,-0.4917329246456037528112403833802090957761}
#define T_55_24 {-0.9211236531148501160970454293419606983662,-0.3892701063173915065895869247469818219543}
#define T_55_26 {-0.9853538358476929825968682052916847169399,-0.1705221926326237757987058785147382877767}
#define T_55_27 {-0.9983691039261356481304687804367858916521,-0.0570888108627679857765002680025645531714}
#define T_55_28 {-0.9983691039261356481304687804367858916521,0.0570888108627679857765002680025645531714}
#define T_55_29 {-0.9853538358476929825968682052916847169399,0.1705221926326237757987058785147382877767}
#define T_55_31 {-0.9211236531148501160970454293419606983662,0.3892701063173915065895869247469818219543}
#define T_55_32 {-0.8707460771197771398632880845980253070593,0.4917329246456037528112403833802090957761}
#define T_55_34 {-0.7367411378764049389999968298070598393679,0.6761749002740193859040118695702403783798}
#define T_55_36 {-0.5644432188667691807637538659037090837955,0.8254718969627740099426205233612563461065}
#define T_55_37 {-0.4666673232256737247070077501120977103710,0.8844329309978142816817126004025340080261}
#define T_55_38 {-0.3628077053506409965777379511564504355192,0.9318640292114522827304767815803643316031}
#define T_55_39 {-0.2542183341934869389433515607379376888275,0.9671468547019571593281739296799059957266}
#define T_55_41 {-0.0285560507936962540420644529604032868519,0.9995921928281892299139599344925954937935}
#define T_55_42 {0.0855750084788397397117520881693053524941,0.9963317308626913337832320394227281212807}
#define T_55_43 {0.1985904666457454781358649142930516973138,0.9800825610923934450013916830357629805803}
#define T_55_46 {0.5163974616389619409773104052874259650707,0.8563490302515889274204141656809952110052}
#define T_55_47 {0.6106478796354380955690999144280795007944,0.7919022459222750942586799283162690699100}
#define T_55_48 {0.6969375686552934379136559073231182992458,0.7171318047589635424898801829840522259474}
#define T_55_49 {0.7741416106390824891647639560687821358442,0.6330124538088703900484688347205519676208}
#define T_55_51 {0.8973984286913584407230359829554799944162,0.4412211012432212808853648766671540215611}
#define T_55_52 {0.9418443636395247287040888295450713485479,0.3360493932154301477410740517370868474245}
#define T_55_53 {0.9740119169423334666291225403256248682737,0.2264967674257643837076869886004715226591}
#define T_55_54 {0.9934817353485502211540847383730579167604,0.1139914098905406292239206322847167029977}
// Pre-computed twiddles for N=56
#define T_56_1 {0.9937122098932426039752385804604273289442,-0.1119644761033078556033970585303904954344}
#define T_56_3 {0.9438833303083675740907665385748259723186,-0.3302790619551670969755718942906241863966}
#define T_56_5 {0.8467241992282841245298641297267749905586,-0.5320320765153365716315647659939713776112}
#define T_56_9 {0.5320320765153365716315647659939713776112,-0.8467241992282841245298641297267749905586}
#define T_56_11 {0.3302790619551670969755718942906241863966,-0.9438833303083675740907665385748259723186}
#define T_56_13 {0.1119644761033078556033970585303904954344,-0.9937122098932426039752385804604273289442}
#define T_56_15 {-0.1119644761033078556033970585303904954344,-0.9937122098932426039752385804604273289442}
#define T_56_17 {-0.3302790619551670969755718942906241863966,-0.9438833303083675740907665385748259723186}
#define T_56_19 {-0.5320320765153365716315647659939713776112,-0.8467241992282841245298641297267749905586}
#define T_56_23 {-0.8467241992282841245298641297267749905586,-0.5320320765153365716315647659939713776112}
#define T_56_25 {-0.9438833303083675740907665385748259723186,-0.3302790619551670969755718942906241863966}
#define T_56_27 {-0.9937122098932426039752385804604273289442,-0.1119644761033078556033970585303904954344}
#define T_56_29 {-0.9937122098932426039752385804604273289442,0.1119644761033078556033970585303904954344}
#define T_56_31 {-0.9438833303083675740907665385748259723186,0.3302790619551670969755718942906241863966}
#define T_56_33 {-0.8467241992282841245298641297267749905586,0.5320320765153365716315647659939713776112}
#define T_56_37 {-0.5320320765153365716315647659939713776112,0.8467241992282841245298641297267749905586}
#define T_56_39 {-0.3302790619551670969755718942906241863966,0.9438833303083675740907665385748259723186}
#define T_56_41 {-0.1119644761033078556033970585303904954344,0.9937122098932426039752385804604273289442}
#define T_56_43 {0.1119644761033078556033970585303904954344,0.9937122098932426039752385804604273289442}
#define T_56_45 {0.3302790619551670969755718942906241863966,0.9438833303083675740907665385748259723186}
#define T_56_47 {0.5320320765153365716315647659939713776112,0.8467241992282841245298641297267749905586}
#define T_56_51 {0.8467241992282841245298641297267749905586,0.5320320765153365716315647659939713776112}
#define T_56_53 {0.9438833303083675740907665385748259723186,0.3302790619551670969755718942906241863966}
#define T_56_55 {0.9937122098932426039752385804604273289442,0.1119644761033078556033970585303904954344}
// Pre-computed twiddles for N=57
#define T_57_1 {0.9939306773179494847170190041651949286461,-0.1100082209940792948854593191754247527570}
#define T_57_2 {0.9757963826274356211598615118418820202351,-0.2186810912063757994516777216631453484297}
#define T_57_4 {0.9043571606975775445391718676546588540077,-0.4267764354964036499495705356821417808533}
#define T_57_5 {0.8519194088383270635489452615729533135891,-0.5236729139878778527261715680651832371950}
#define T_57_7 {0.7167825131684512074414783455722499638796,-0.6972968010939953886762054935388732701540}
#define T_57_8 {0.6357237482099680203617708684760145843029,-0.7719166509163208900190511485561728477478}
#define T_57_10 {0.4515333583108893655833071534289047122002,-0.8922542386183940354982269127503968775272}
#define T_57_11 {0.3506375551927543576802293046057457104325,-0.9365112411970547556805399835866410285234}
#define T_57_13 {0.1373535578184081618058343110533314757049,-0.9905220846375032417441275356395635753870}
#define T_57_14 {0.0275543423681619964460409732964762952179,-0.9996203070249514155420911265537142753601}
#define T_57_16 {-0.1917106319237384115528044503662385977805,-0.9814514932524178725259389466373249888420}
#define T_57_17 {-0.2985148110016945244282737803587224334478,-0.9544050018795073864197320290259085595608}
#define T_57_20 {-0.5922352526649800052993555254943203181028,-0.8057651056609781425876803950814064592123}
#define T_57_22 {-0.7541066097768962528391512023517861962318,-0.6567520240477343618223926569044124335051}
#define T_57_23 {-0.8217778152252451784320896877034101635218,-0.5698080575102661970987583117675967514515}
#define T_57_25 {-0.9264940672148017641873707361810375005007,-0.3763093719478354803875674861046718433499}
#define T_57_26 {-0.9622680003092504152917285864532459527254,-0.2721034648453349857888383667159359902143}
#define T_57_28 {-0.9984815164333161741083699780574534088373,-0.0550877603558654407867045676994166569784}
#define T_57_29 {-0.9984815164333161741083699780574534088373,0.0550877603558654407867045676994166569784}
#define T_57_31 {-0.9622680003092504152917285864532459527254,0.2721034648453349857888383667159359902143}
#define T_57_32 {-0.9264940672148017641873707361810375005007,0.3763093719478354803875674861046718433499}
#define T_57_34 {-0.8217778152252451784320896877034101635218,0.5698080575102661970987583117675967514515}
#define T_57_35 {-0.7541066097768962528391512023517861962318,0.6567520240477343618223926569044124335051}
#define T_57_37 {-0.5922352526649800052993555254943203181028,0.8057651056609781425876803950814064592123}
#define T_57_40 {-0.2985148110016945244282737803587224334478,0.9544050018795073864197320290259085595608}
#define T_57_41 {-0.1917106319237384115528044503662385977805,0.9814514932524178725259389466373249888420}
#define T_57_43 {0.0275543423681619964460409732964762952179,0.9996203070249514155420911265537142753601}
#define T_57_44 {0.1373535578184081618058343110533314757049,0.9905220846375032417441275356395635753870}
#define T_57_46 {0.3506375551927543576802293046057457104325,0.9365112411970547556805399835866410285234}
#define T_57_47 {0.4515333583108893655833071534289047122002,0.8922542386183940354982269127503968775272}
#define T_57_49 {0.6357237482099680203617708684760145843029,0.7719166509163208900190511485561728477478}
#define T_57_50 {0.7167825131684512074414783455722499638796,0.6972968010939953886762054935388732701540}
#define T_57_52 {0.8519194088383270635489452615729533135891,0.5236729139878778527261715680651832371950}
#define T_57_53 {0.9043571606975775445391718676546588540077,0.4267764354964036499495705356821417808533}
#define T_57_55 {0.9757963826274356211598615118418820202351,0.2186810912063757994516777216631453484297}
#define T_57_56 {0.9939306773179494847170190041651949286461,0.1100082209940792948854593191754247527570}
// Pre-computed twiddles for N=58
#define T_58_1 {0.9941379571543595972116236225701868534088,-0.1081190184239417678702110947597248014063}
#define T_58_3 {0.9476531711828024562294103816384449601173,-0.3193015301359799495983793349296320229769}
#define T_58_5 {0.8568571761675892739518189955560956150293,-0.5155538571770217348699816284351982176304}
#define T_58_7 {0.7259954919231308423377413419075310230255,-0.6876994588534233177057330976822413504124}
#define T_58_9 {0.5611870653623823868016984306450467556715,-0.8276889981568905652054013444285374134779}
#define T_58_11 {0.3701381553399143431448692354024387896061,-0.9289767198167914186157645417551975697279}
#define T_58_13 {0.1617819965527647341207995168588240630925,-0.9868265225415261410191192226193379610777}
#define T_58_15 {-0.0541389085854175264311827220353734446689,-0.9985334138511238188939955762180034071207}
#define T_58_17 {-0.2675283385292208104822009318013442680240,-0.9635499925192229087045348023821134120226}
#define T_58_19 {-0.4684084406997901517399895965354517102242,-0.8835120444460229371941295539727434515953}
#define T_58_21 {-0.6473862847818276922140512397163547575474,-0.7621620551276364619042169579188339412212}
#define T_58_23 {-0.7960930657056437542706817112048156559467,-0.6051742151937651303938991986797191202641}
#define T_58_25 {-0.9075754196709570065237926428380887955427,-0.4198891015602645992998986912425607442856}
#define T_58_27 {-0.9766205557100866574415931609109975397587,-0.2149704402110240719636635731148999184370}
#define T_58_31 {-0.9766205557100866574415931609109975397587,0.2149704402110240719636635731148999184370}
#define T_58_33 {-0.9075754196709570065237926428380887955427,0.4198891015602645992998986912425607442856}
#define T_58_35 {-0.7960930657056437542706817112048156559467,0.6051742151937651303938991986797191202641}
#define T_58_37 {-0.6473862847818276922140512397163547575474,0.7621620551276364619042169579188339412212}
#define T_58_39 {-0.4684084406997901517399895965354517102242,0.8835120444460229371941295539727434515953}
#define T_58_41 {-0.2675283385292208104822009318013442680240,0.9635499925192229087045348023821134120226}
#define T_58_43 {-0.0541389085854175264311827220353734446689,0.9985334138511238188939955762180034071207}
#define T_58_45 {0.1617819965527647341207995168588240630925,0.9868265225415261410191192226193379610777}
#define T_58_47 {0.3701381553399143431448692354024387896061,0.9289767198167914186157645417551975697279}
#define T_58_49 {0.5611870653623823868016984306450467556715,0.8276889981568905652054013444285374134779}
#define T_58_51 {0.7259954919231308423377413419075310230255,0.6876994588534233177057330976822413504124}
#define T_58_53 {0.8568571761675892739518189955560956150293,0.5155538571770217348699816284351982176304}
#define T_58_55 {0.9476531711828024562294103816384449601173,0.3193015301359799495983793349296320229769}
#define T_58_57 {0.9941379571543595972116236225701868534088,0.1081190184239417678702110947597248014063}
// Pre-computed twiddles for N=59
#define T_59_1 {0.9943348002101370930461143871070817112923,-0.1062934856473654043895749055081978440285}
#define T_59_2 {0.9774033898178666746048293134663254022598,-0.2113826236296243166190578222085605375469}
#define T_59_3 {0.9493976084683812821651827107416465878487,-0.3140767120219488117704997875989647582173}
#define T_59_4 {0.9106347728549132325426285206049215048552,-0.4132121857683782040204789609560975804925}
#define T_59_5 {0.8615540813938060704657573296572081744671,-0.5076658003388400119959555922832805663347}
#define T_59_6 {0.8027116379309636728933696758758742362261,-0.5963673585385014241921908251242712140083}
#define T_59_7 {0.7347741508630672990776133701729122549295,-0.6783118362696161085523272049613296985626}
#define T_59_8 {0.6585113790650386489389234156988095492125,-0.7525707698561384662028217462648171931505}
#define T_59_9 {0.5747874102144069352604560663166921585798,-0.8183027759081690222231486586679238826036}
#define T_59_10 {0.4845508703326501520614044693502364680171,-0.8747630845319612769017680875549558550119}
#define T_59_11 {0.3888241754733206545502355311327846720815,-0.9213119778704129680946266489627305418253}
#define T_59_12 {0.2886919473396210022997365740593522787094,-0.9574220383620054564133283747651148587465}
#define T_59_13 {0.1852887240871143315068536594480974599719,-0.9826841245925209689104917742952238768339}
#define T_59_14 {0.0797861055530830753923510201275348663330,-0.9968120070307501245920889232365880161524}
#define T_59_15 {-0.0266205214377747655107864233059444813989,-0.9996456111234526265008071277406997978687}
#define T_59_16 {-0.1327255272837219723935930915104108862579,-0.9911528310040071954034601731109432876110}
#define T_59_17 {-0.2373266998711148212386490286007756367326,-0.9714298932647099649173583202355075627565}
#define T_59_18 {-0.3392388661180302800168817611847771331668,-0.9407002666710332361432733705441933125257}
#define T_59_19 {-0.4373073204588553974936360191350104287267,-0.8993121301712192483535091014346107840538}
#define T_59_20 {-0.5304209081197425179610149825748521834612,-0.8477344278896709051096536313707474619150}
#define T_59_21 {-0.6175246149461919298317980064894072711468,-0.7865515558026424658422115498979110270739}
#define T_59_22 {-0.6976315211349847222876974228711333125830,-0.7164567402983151866990851885930169373751}
#define T_59_23 {-0.7698339834299062767186683231557253748178,-0.6382441836448200511711092985933646559715}
#define T_59_24 {-0.8333139190825149533736748708179220557213,-0.5528000653611934156472784707148093730211}
#define T_59_25 {-0.8873520750565715431434909987729042768478,-0.4610925014493258422554333719745045527816}
#define T_59_26 {-0.9313361774523384317703289525525178760290,-0.3641605752528221939812169694050680845976}
#define T_59_27 {-0.9647678688145159275890705430356319993734,-0.2631025642275212628184988261637045070529}
#define T_59_28 {-0.9872683547213445542922727327095344662666,-0.1590634960190720481598702917835908010602}
#define T_59_29 {-0.9985826956767619444477190882025752216578,-0.0532221748421786572391667391457303892821}
#define T_59_30 {-0.9985826956767619444477190882025752216578,0.0532221748421786572391667391457303892821}
#define T_59_31 {-0.9872683547213445542922727327095344662666,0.1590634960190720481598702917835908010602}
#define T_59_32 {-0.9647678688145159275890705430356319993734,0.2631025642275212628184988261637045070529}
#define T_59_33 {-0.9313361774523384317703289525525178760290,0.3641605752528221939812169694050680845976}
#define T_59_34 {-0.8873520750565715431434909987729042768478,0.4610925014493258422554333719745045527816}
#define T_59_35 {-0.8333139190825149533736748708179220557213,0.5528000653611934156472784707148093730211}
#define T_59_36 {-0.7698339834299062767186683231557253748178,0.6382441836448200511711092985933646559715}
#define T_59_37 {-0.6976315211349847222876974228711333125830,0.7164567402983151866990851885930169373751}
#define T_59_38 {-0.6175246149461919298317980064894072711468,0.7865515558026424658422115498979110270739}
#define T_59_39 {-0.5304209081197425179610149825748521834612,0.8477344278896709051096536313707474619150}
#define T_59_40 {-0.4373073204588553974936360191350104287267,0.8993121301712192483535091014346107840538}
#define T_59_41 {-0.3392388661180302800168817611847771331668,0.9407002666710332361432733705441933125257}
#define T_59_42 {-0.2373266998711148212386490286007756367326,0.9714298932647099649173583202355075627565}
#define T_59_43 {-0.1327255272837219723935930915104108862579,0.9911528310040071954034601731109432876110}
#define T_59_44 {-0.0266205214377747655107864233059444813989,0.9996456111234526265008071277406997978687}
#define T_59_45 {0.0797861055530830753923510201275348663330,0.9968120070307501245920889232365880161524}
#define T_59_46 {0.1852887240871143315068536594480974599719,0.9826841245925209689104917742952238768339}
#define T_59_47 {0.2886919473396210022997365740593522787094,0.9574220383620054564133283747651148587465}
#define T_59_48 {0.3888241754733206545502355311327846720815,0.9213119778704129680946266489627305418253}
#define T_59_49 {0.4845508703326501520614044693502364680171,0.8747630845319612769017680875549558550119}
#define T_59_50 {0.5747874102144069352604560663166921585798,0.8183027759081690222231486586679238826036}
#define T_59_51 {0.6585113790650386489389234156988095492125,0.7525707698561384662028217462648171931505}
#define T_59_52 {0.7347741508630672990776133701729122549295,0.6783118362696161085523272049613296985626}
#define T_59_53 {0.8027116379309636728933696758758742362261,0.5963673585385014241921908251242712140083}
#define T_59_54 {0.8615540813938060704657573296572081744671,0.5076658003388400119959555922832805663347}
#define T_59_55 {0.9106347728549132325426285206049215048552,0.4132121857683782040204789609560975804925}
#define T_59_56 {0.9493976084683812821651827107416465878487,0.3140767120219488117704997875989647582173}
#define T_59_57 {0.9774033898178666746048293134663254022598,0.2113826236296243166190578222085605375469}
#define T_59_58 {0.9943348002101370930461143871070817112923,0.1062934856473654043895749055081978440285}
// Pre-computed twiddles for N=60
#define T_60_1 {0.9945218953682732898613494398887269198895,-0.1045284632676534708473070622858358547091}
#define T_60_7 {0.7431448254773942441175904605188407003880,-0.6691306063588582375700752891134470701218}
#define T_60_11 {0.4067366430758002082690438783174613490701,-0.9135454576426008665990252666233573108912}
#define T_60_13 {0.2079116908177593425754992040310753509402,-0.9781476007338056888329447247087955474854}
#define T_60_17 {-0.2079116908177593425754992040310753509402,-0.9781476007338056888329447247087955474854}
#define T_60_19 {-0.4067366430758002082690438783174613490701,-0.9135454576426008665990252666233573108912}
#define T_60_23 {-0.7431448254773942441175904605188407003880,-0.6691306063588582375700752891134470701218}
#define T_60_29 {-0.9945218953682732898613494398887269198895,-0.1045284632676534708473070622858358547091}
#define T_60_31 {-0.9945218953682732898613494398887269198895,0.1045284632676534708473070622858358547091}
#define T_60_37 {-0.7431448254773942441175904605188407003880,0.6691306063588582375700752891134470701218}
#define T_60_41 {-0.4067366430758002082690438783174613490701,0.9135454576426008665990252666233573108912}
#define T_60_43 {-0.2079116908177593425754992040310753509402,0.9781476007338056888329447247087955474854}
#define T_60_47 {0.2079116908177593425754992040310753509402,0.9781476007338056888329447247087955474854}
#define T_60_49 {0.4067366430758002082690438783174613490701,0.9135454576426008665990252666233573108912}
#define T_60_53 {0.7431448254773942441175904605188407003880,0.6691306063588582375700752891134470701218}
#define T_60_59 {0.9945218953682732898613494398887269198895,0.1045284632676534708473070622858358547091}
// Pre-computed twiddles for N=61
#define T_61_1 {0.9946998756145890574487111734924837946892,-0.1028209971373603981437128140896675176919}
#define T_61_2 {0.9788556850953578081231398755335249006748,-0.2045520661262008321745753391951438970864}
#define T_61_3 {0.9526353808033825032453023595735430717468,-0.3041148323275179032876280871278140693903}
#define T_61_4 {0.9163169044870047574846694260486401617527,-0.4004539056512664840781212660658638924360}
#define T_61_5 {0.8702852410301552543714365128835197538137,-0.4925480679538644102066768937220331281424}
#define T_61_6 {0.8150283375168113630948596437519881874323,-0.5794210982045636670889621200331021100283}
#define T_61_7 {0.7511319308705198816156212160422001034021,-0.6601521206712317457743210979970172047615}
#define T_61_8 {0.6792733388972931329874427319737151265144,-0.7338853664321991487895502359606325626373}
#define T_61_9 {0.6002142805483682286293856122938450425863,-0.7998392447397193461000597380916588008404}
#define T_61_10 {0.5147928015098307552577239221136551350355,-0.8573146280763322968354600561724510043859}
#define T_61_11 {0.4239143907098607000349943518813233822584,-0.9057022630804715257468728850653860718012}
#define T_61_12 {0.3285423819108347354145394092483911663294,-0.9444892287836612609908115700818598270416}
#define T_61_13 {0.2296877421317955469959315450978465378284,-0.9732643737003825457065886439522728323936}
#define T_61_14 {0.1283983551465509576061663210566621273756,-0.9917226741361014896725123435317073017359}
#define T_61_15 {0.0257479136549885571916274074055763776414,-0.9996684675143130416330450316308997571468}
#define T_61_16 {-0.0771754621266463464168694486033928114921,-0.9970175264485267030423187861742917448282}
#define T_61_17 {-0.1792807588107356575601869508318486623466,-0.9837979515735163493772574838658329099417}
#define T_61_18 {-0.2794856348516094324274661175877554342151,-0.9601498736716017612380369428137782961130}
#define T_61_19 {-0.3767278936351851070796215026348363608122,-0.9263239682514949890901334583759307861328}
#define T_61_20 {-0.4699767430273200652379728126106783747673,-0.8826787983255474090427128430746961385012}
#define T_61_21 {-0.5582437220268647859455768411862663924694,-0.8296770135526189138275299228553194552660}
#define T_61_22 {-0.6405931786981751141496488344273529946804,-0.7678804460365999950965942844050005078316}
#define T_61_23 {-0.7161521883143933120408064496587030589581,-0.6979441547663435274628795923490542918444}
#define T_61_24 {-0.7841198065767104319334634965343866497278,-0.6206094818274228153143212693976238369942}
#define T_61_25 {-0.8437755598231856390967209335940424352884,-0.5366961939916005119854958138603251427412}
#define T_61_26 {-0.8944870822287955824947403016267344355583,-0.4470937929851139247539038024115143343806}
#define T_61_27 {-0.9357168190404936414239500663825310766697,-0.3527520865490947898912565960927167907357}
#define T_61_28 {-0.9670277247913203755302902209223248064518,-0.2546711202412287322616180063050705939531}
#define T_61_29 {-0.9880878960910771668935126399446744471788,-0.1538905767040617822427606142809963785112}
#define T_61_30 {-0.9986740898848305292290206125471740961075,-0.0514787547703465311887960353942617075518}
#define T_61_31 {-0.9986740898848305292290206125471740961075,0.0514787547703465311887960353942617075518}
#define T_61_32 {-0.9880878960910771668935126399446744471788,0.1538905767040617822427606142809963785112}
#define T_61_33 {-0.9670277247913203755302902209223248064518,0.2546711202412287322616180063050705939531}
#define T_61_34 {-0.9357168190404936414239500663825310766697,0.3527520865490947898912565960927167907357}
#define T_61_35 {-0.8944870822287955824947403016267344355583,0.4470937929851139247539038024115143343806}
#define T_61_36 {-0.8437755598231856390967209335940424352884,0.5366961939916005119854958138603251427412}
#define T_61_37 {-0.7841198065767104319334634965343866497278,0.6206094818274228153143212693976238369942}
#define T_61_38 {-0.7161521883143933120408064496587030589581,0.6979441547663435274628795923490542918444}
#define T_61_39 {-0.6405931786981751141496488344273529946804,0.7678804460365999950965942844050005078316}
#define T_61_40 {-0.5582437220268647859455768411862663924694,0.8296770135526189138275299228553194552660}
#define T_61_41 {-0.4699767430273200652379728126106783747673,0.8826787983255474090427128430746961385012}
#define T_61_42 {-0.3767278936351851070796215026348363608122,0.9263239682514949890901334583759307861328}
#define T_61_43 {-0.2794856348516094324274661175877554342151,0.9601498736716017612380369428137782961130}
#define T_61_44 {-0.1792807588107356575601869508318486623466,0.9837979515735163493772574838658329099417}
#define T_61_45 {-0.0771754621266463464168694486033928114921,0.9970175264485267030423187861742917448282}
#define T_61_46 {0.0257479136549885571916274074055763776414,0.9996684675143130416330450316308997571468}
#define T_61_47 {0.1283983551465509576061663210566621273756,0.9917226741361014896725123435317073017359}
#define T_61_48 {0.2296877421317955469959315450978465378284,0.9732643737003825457065886439522728323936}
#define T_61_49 {0.3285423819108347354145394092483911663294,0.9444892287836612609908115700818598270416}
#define T_61_50 {0.4239143907098607000349943518813233822584,0.9057022630804715257468728850653860718012}
#define T_61_51 {0.5147928015098307552577239221136551350355,0.8573146280763322968354600561724510043859}
#define T_61_52 {0.6002142805483682286293856122938450425863,0.7998392447397193461000597380916588008404}
#define T_61_53 {0.6792733388972931329874427319737151265144,0.7338853664321991487895502359606325626373}
#define T_61_54 {0.7511319308705198816156212160422001034021,0.6601521206712317457743210979970172047615}
#define T_61_55 {0.8150283375168113630948596437519881874323,0.5794210982045636670889621200331021100283}
#define T_61_56 {0.8702852410301552543714365128835197538137,0.4925480679538644102066768937220331281424}
#define T_61_57 {0.9163169044870047574846694260486401617527,0.4004539056512664840781212660658638924360}
#define T_61_58 {0.9526353808033825032453023595735430717468,0.3041148323275179032876280871278140693903}
#define T_61_59 {0.9788556850953578081231398755335249006748,0.2045520661262008321745753391951438970864}
#define T_61_60 {0.9946998756145890574487111734924837946892,0.1028209971373603981437128140896675176919}
// Pre-computed twiddles for N=62
#define T_62_1 {0.9948693233918951550620590751350391656160,-0.1011683219874321831843744234902260359377}
#define T_62_3 {0.9541392564000488185627091297646984457970,-0.2993631229733579313112556974374456331134}
#define T_62_5 {0.8743466161445820894471125939162448048592,-0.4853019625310810436502606535213999450207}
#define T_62_7 {0.7587581226927908595314420381328091025352,-0.6513724827222222568678944298881106078625}
#define T_62_9 {0.6121059825476627969109699733962770551443,-0.7907757369376985367992460851382929831743}
#define T_62_11 {0.4403941515576342835558421029418241232634,-0.8978045395707416886921237164642661809921}
#define T_62_13 {0.2506525322587205284463607313227839767933,-0.9680771188662042892048020803485997021198}
#define T_62_15 {0.0506491688387127117487729321965161943808,-0.9987165071710527586290595536411274224520}
#define T_62_17 {-0.1514277775045766716299766585507313720882,-0.9884683243281113806943949384731240570545}
#define T_62_19 {-0.3473052528448202780353426533110905438662,-0.9377521321470804194220249883073847740889}
#define T_62_21 {-0.5289640103269624971105145050387363880873,-0.8486442574947509198679540531884413212538}
#define T_62_23 {-0.6889669190756865235769623723172117024660,-0.7247927872291199946630513295531272888184}
#define T_62_25 {-0.8207634412072762897238931145693641155958,-0.5712682150947923087613844472798518836498}
#define T_62_27 {-0.9189578116202306024007384621654637157917,-0.3943558551133185541281989117123885080218}
#define T_62_29 {-0.9795299412524944848712493694620206952095,-0.2012985200886600878344978582390467636287}
#define T_62_33 {-0.9795299412524944848712493694620206952095,0.2012985200886600878344978582390467636287}
#define T_62_35 {-0.9189578116202306024007384621654637157917,0.3943558551133185541281989117123885080218}
#define T_62_37 {-0.8207634412072762897238931145693641155958,0.5712682150947923087613844472798518836498}
#define T_62_39 {-0.6889669190756865235769623723172117024660,0.7247927872291199946630513295531272888184}
#define T_62_41 {-0.5289640103269624971105145050387363880873,0.8486442574947509198679540531884413212538}
#define T_62_43 {-0.3473052528448202780353426533110905438662,0.9377521321470804194220249883073847740889}
#define T_62_45 {-0.1514277775045766716299766585507313720882,0.9884683243281113806943949384731240570545}
#define T_62_47 {0.0506491688387127117487729321965161943808,0.9987165071710527586290595536411274224520}
#define T_62_49 {0.2506525322587205284463607313227839767933,0.9680771188662042892048020803485997021198}
#define T_62_51 {0.4403941515576342835558421029418241232634,0.8978045395707416886921237164642661809921}
#define T_62_53 {0.6121059825476627969109699733962770551443,0.7907757369376985367992460851382929831743}
#define T_62_55 {0.7587581226927908595314420381328091025352,0.6513724827222222568678944298881106078625}
#define T_62_57 {0.8743466161445820894471125939162448048592,0.4853019625310810436502606535213999450207}
#define T_62_59 {0.9541392564000488185627091297646984457970,0.2993631229733579313112556974374456331134}
#define T_62_61 {0.9948693233918951550620590751350391656160,0.1011683219874321831843744234902260359377}
// Pre-computed twiddles for N=63
#define T_63_1 {0.9950307753654014097932645199762191623449,-0.0995678465958166614147017980940290726721}
#define T_63_2 {0.9801724878485438274822172388667240738869,-0.1981461431993975785825767843562061898410}
#define T_63_4 {0.9214762118704076243602685281075537204742,-0.3884347962746947380274775696307187899947}
#define T_63_5 {0.8782215733702285476169890898745507001877,-0.4782539786213181876028954775392776355147}
#define T_63_8 {0.6982368180860728523740021955745760351419,-0.7158668492597184407344457213184796273708}
#define T_63_10 {0.5425462638657594371949244305142201483250,-0.8400259231507714030584565989556722342968}
#define T_63_11 {0.4562106573531629627460404208250110968947,-0.8898718088114686564082944641995709389448}
#define T_63_13 {0.2708404681430051086366006529715377837420,-0.9626242469500120302328127763757947832346}
#define T_63_16 {-0.0249306917380728750022189643686942872591,-0.9996891820008162454769262694753706455231}
#define T_63_17 {-0.1243437046474851759292334918427513912320,-0.9922392066001720634105254248424898833036}
#define T_63_19 {-0.3184866502516844333214862672321032732725,-0.9479273461671317013710336141230072826147}
#define T_63_20 {-0.4112871031306115643388920943834818899632,-0.9115058523116731370450338545197155326605}
#define T_63_22 {-0.5837436722347898454543724255927372723818,-0.8119380057158565033859076720545999705791}
#define T_63_23 {-0.6616858375968593941607309716346208006144,-0.7497812029677342060551836766535416245461}
#define T_63_25 {-0.7971325072229225039421862675226293504238,-0.6038044103254773808941990864695981144905}
#define T_63_26 {-0.8532908816321556066952780383871868252754,-0.5214352033794981133851820231939200311899}
#define T_63_29 {-0.9690772862290779610106028485461138188839,-0.2467573976902936450095182863151421770453}
#define T_63_31 {-0.9987569212189223444298136200814042240381,-0.0498458856606971631442171144499297952279}
#define T_63_32 {-0.9987569212189223444298136200814042240381,0.0498458856606971631442171144499297952279}
#define T_63_34 {-0.9690772862290779610106028485461138188839,0.2467573976902936450095182863151421770453}
#define T_63_37 {-0.8532908816321556066952780383871868252754,0.5214352033794981133851820231939200311899}
#define T_63_38 {-0.7971325072229225039421862675226293504238,0.6038044103254773808941990864695981144905}
#define T_63_40 {-0.6616858375968593941607309716346208006144,0.7497812029677342060551836766535416245461}
#define T_63_41 {-0.5837436722347898454543724255927372723818,0.8119380057158565033859076720545999705791}
#define T_63_43 {-0.4112871031306115643388920943834818899632,0.9115058523116731370450338545197155326605}
#define T_63_44 {-0.3184866502516844333214862672321032732725,0.9479273461671317013710336141230072826147}
#define T_63_46 {-0.1243437046474851759292334918427513912320,0.9922392066001720634105254248424898833036}
#define T_63_47 {-0.0249306917380728750022189643686942872591,0.9996891820008162454769262694753706455231}
#define T_63_50 {0.2708404681430051086366006529715377837420,0.9626242469500120302328127763757947832346}
#define T_63_52 {0.4562106573531629627460404208250110968947,0.8898718088114686564082944641995709389448}
#define T_63_53 {0.5425462638657594371949244305142201483250,0.8400259231507714030584565989556722342968}
#define T_63_55 {0.6982368180860728523740021955745760351419,0.7158668492597184407344457213184796273708}
#define T_63_58 {0.8782215733702285476169890898745507001877,0.4782539786213181876028954775392776355147}
#define T_63_59 {0.9214762118704076243602685281075537204742,0.3884347962746947380274775696307187899947}
#define T_63_61 {0.9801724878485438274822172388667240738869,0.1981461431993975785825767843562061898410}
#define T_63_62 {0.9950307753654014097932645199762191623449,0.0995678465958166614147017980940290726721}
// Pre-computed twiddles for N=64
#define T_64_1 {0.9951847266721969287317506314138881862164,-0.0980171403295606036287779261328978464007}
#define T_64_3 {0.9569403357322088243819280251045711338520,-0.2902846772544623865641710835916455835104}
#define T_64_5 {0.8819212643483550495560052695509511977434,-0.4713967368259976420397094898362411186099}
#define T_64_7 {0.7730104533627369933768136434082407504320,-0.6343932841636454877942696839454583823681}
#define T_64_9 {0.6343932841636454877942696839454583823681,-0.7730104533627369933768136434082407504320}
#define T_64_11 {0.4713967368259976420397094898362411186099,-0.8819212643483550495560052695509511977434}
#define T_64_13 {0.2902846772544623865641710835916455835104,-0.9569403357322088243819280251045711338520}
#define T_64_15 {0.0980171403295606036287779261328978464007,-0.9951847266721969287317506314138881862164}
#define T_64_17 {-0.0980171403295606036287779261328978464007,-0.9951847266721969287317506314138881862164}
#define T_64_19 {-0.2902846772544623865641710835916455835104,-0.9569403357322088243819280251045711338520}
#define T_64_21 {-0.4713967368259976420397094898362411186099,-0.8819212643483550495560052695509511977434}
#define T_64_23 {-0.6343932841636454877942696839454583823681,-0.7730104533627369933768136434082407504320}
#define T_64_25 {-0.7730104533627369933768136434082407504320,-0.6343932841636454877942696839454583823681}
#define T_64_27 {-0.8819212643483550495560052695509511977434,-0.4713967368259976420397094898362411186099}
#define T_64_29 {-0.9569403357322088243819280251045711338520,-0.2902846772544623865641710835916455835104}
#define T_64_31 {-0.9951847266721969287317506314138881862164,-0.0980171403295606036287779261328978464007}
#define T_64_33 {-0.9951847266721969287317506314138881862164,0.0980171403295606036287779261328978464007}
#define T_64_35 {-0.9569403357322088243819280251045711338520,0.2902846772544623865641710835916455835104}
#define T_64_37 {-0.8819212643483550495560052695509511977434,0.4713967368259976420397094898362411186099}
#define T_64_39 {-0.7730104533627369933768136434082407504320,0.6343932841636454877942696839454583823681}
#define T_64_41 {-0.6343932841636454877942696839454583823681,0.7730104533627369933768136434082407504320}
#define T_64_43 {-0.4713967368259976420397094898362411186099,0.8819212643483550495560052695509511977434}
#define T_64_45 {-0.2902846772544623865641710835916455835104,0.9569403357322088243819280251045711338520}
#define T_64_47 {-0.0980171403295606036287779261328978464007,0.9951847266721969287317506314138881862164}
#define T_64_49 {0.0980171403295606036287779261328978464007,0.9951847266721969287317506314138881862164}
#define T_64_51 {0.2902846772544623865641710835916455835104,0.9569403357322088243819280251045711338520}
#define T_64_53 {0.4713967368259976420397094898362411186099,0.8819212643483550495560052695509511977434}
#define T_64_55 {0.6343932841636454877942696839454583823681,0.7730104533627369933768136434082407504320}
#define T_64_57 {0.7730104533627369933768136434082407504320,0.6343932841636454877942696839454583823681}
#define T_64_59 {0.8819212643483550495560052695509511977434,0.4713967368259976420397094898362411186099}
#define T_64_61 {0.9569403357322088243819280251045711338520,0.2902846772544623865641710835916455835104}
#define T_64_63 {0.9951847266721969287317506314138881862164,0.0980171403295606036287779261328978464007}
// Pre-computed twiddles for N=72
#define T_72_1 {0.9961946980917455451987052583717741072178,-0.0871557427476581797476384849687747191638}
#define T_72_5 {0.9063077870366499366738821663602720946074,-0.4226182617406994412867504706809995695949}
#define T_72_7 {0.8191520442889917985596071048348676413298,-0.5735764363510460484008035564329475164413}
#define T_72_11 {0.5735764363510460484008035564329475164413,-0.8191520442889917985596071048348676413298}
#define T_72_35 {-0.9961946980917455451987052583717741072178,-0.0871557427476581797476384849687747191638}
// Pre-computed twiddles for N=80
#define T_80_1 {0.9969173337331279638462433467793744057417,-0.0784590957278449435685629964609688613564}
#define T_80_3 {0.9723699203976765570445195407955907285213,-0.2334453638559054189371977372502442449331}
#define T_80_7 {0.8526401643540921782005170825868844985962,-0.5224985647159489099422557956131640821695}
// Pre-computed twiddles for N=81
#define T_81_1 {0.9969929411677920239043260153266601264477,-0.0774924206719309477398027752315101679415}
#define T_81_2 {0.9879898494768090122519765827746596187353,-0.1545187928078404770992904104787157848477}
#define T_81_4 {0.9522478853384153119066013459814712405205,-0.3053259976951130938438438988669076934457}
#define T_81_5 {0.9257239692688904453277132233779411762953,-0.3781998581716424778775831327948253601789}
#define T_81_7 {0.8561668995302664786350987924379296600819,-0.5166993711518629295298410397663246840239}
#define T_81_8 {0.8135520702629676081940601761743891984224,-0.5814920712880267128497280282317660748959}
#define T_81_10 {0.7139297345578989872905140146031044423580,-0.7002173477671684853618216948234476149082}
#define T_81_11 {0.6575213685690636244984830227622296661139,-0.7534358963276607257242289961141068488359}
#define T_81_13 {0.5332044328016912748680056211014743894339,-0.8459864259198410785245414444943889975548}
#define T_81_14 {0.4660435197025388220914976500353077426553,-0.8847617971766578159886762477981392294168}
#define T_81_16 {0.3237339420583210114479300045786658301950,-0.9461481568757503790578766711405478417873}
#define T_81_17 {0.2494411440579812899720479890675051137805,-0.9683899605278059041779670224059373140335}
#define T_81_19 {0.0968108707031790916008873182363458909094,-0.9953027957931658287193954492977354675531}
#define T_81_20 {0.0193913317718243730092275711740512633696,-0.9998119704485014525019437314767856150866}
#define T_81_22 {-0.1353312997501311121251177382873720489442,-0.9908004033648453168225955778325442224741}
#define T_81_23 {-0.2117038722294107555566000655744574032724,-0.9773338582506355676216003303125035017729}
#define T_81_25 {-0.3601777248047104418304797945893369615078,-0.9328837047320005515516072591708507388830}
#define T_81_26 {-0.4313860656812534277726456366508500650525,-0.9021674247810377300638151609746273607016}
#define T_81_28 {-0.5656068754865386516428316099336370825768,-0.8246750041091067684462245779286604374647}
#define T_81_29 {-0.6278121246720985704214967881853226572275,-0.7783649119241600189411656174343079328537}
#define T_81_31 {-0.7405440131090045285944256647781003266573,-0.6720078605555224182666052001877687871456}
#define T_81_32 {-0.7903926695187593054470198694616556167603,-0.6126005451932028389450124450377188622952}
#define T_81_34 {-0.8755582313020908724610080753336660563946,-0.4831125992966384674609514604526339098811}
#define T_81_35 {-0.9103629409661466720393718787818215787411,-0.4138107245051391713808186523237964138389}
#define T_81_37 {-0.9633708786158803327737132349284365773201,-0.2681726127606373633049940963246626779437}
#define T_81_38 {-0.9812553106273846914575642585987225174904,-0.1927122605480896810892232906553545035422}
#define T_81_40 {-0.9992479525042300414483520398789551109076,-0.0387753712568167097085591876748367212713}
#define T_81_41 {-0.9992479525042300414483520398789551109076,0.0387753712568167097085591876748367212713}
#define T_81_43 {-0.9812553106273846914575642585987225174904,0.1927122605480896810892232906553545035422}
#define T_81_44 {-0.9633708786158803327737132349284365773201,0.2681726127606373633049940963246626779437}
#define T_81_46 {-0.9103629409661466720393718787818215787411,0.4138107245051391713808186523237964138389}
#define T_81_47 {-0.8755582313020908724610080753336660563946,0.4831125992966384674609514604526339098811}
#define T_81_49 {-0.7903926695187593054470198694616556167603,0.6126005451932028389450124450377188622952}
#define T_81_50 {-0.7405440131090045285944256647781003266573,0.6720078605555224182666052001877687871456}
#define T_81_52 {-0.6278121246720985704214967881853226572275,0.7783649119241600189411656174343079328537}
#define T_81_53 {-0.5656068754865386516428316099336370825768,0.8246750041091067684462245779286604374647}
// Pre-computed twiddles for N=96
#define T_96_1 {0.9978589232386034790778239766950719058514,-0.0654031292301430616786817040519963484257}
#define T_96_5 {0.9469301294951056879867223869950976222754,-0.3214394653031615867178061307640746235847}
#define T_96_7 {0.8968727415326882557167209597537294030190,-0.4422886902190013014291025683633051812649}
#define T_96_11 {0.7518398074789773843917828344274312257767,-0.6593458151000688438614361075451597571373}
#define T_96_35 {-0.6593458151000688438614361075451597571373,-0.7518398074789773843917828344274312257767}
#define T_96_49 {-0.9978589232386034790778239766950719058514,0.0654031292301430616786817040519963484257}
// Pre-computed twiddles for N=100
#define T_100_1 {0.9980267284282715589682766221812926232815,-0.0627905195293133738809743249476014170796}
#define T_100_3 {0.9822872507286887211463977109815459698439,-0.1873813145857246287295794218152877874672}
#define T_100_7 {0.9048270524660195768262838100781664252281,-0.4257792915650726595089281545369885861874}
#define T_100_9 {0.8443279255020150753097141205216757953167,-0.5358267949789966566598309327673632651567}
#define T_100_21 {0.2486898871648547948431939857982797548175,-0.9685831611286310760533524444326758384705}
#define T_100_27 {-0.1253332335643042583228634612169116735458,-0.9921147013144778759041741977853234857321}
#define T_100_33 {-0.4817536741017152679411594817793229594827,-0.8763066800438635839398671123490203171968}
#define T_100_39 {-0.7705132427757892532582673084107227623463,-0.6374239897486897454825793829513713717461}
#define T_100_51 {-0.9980267284282715589682766221812926232815,0.0627905195293133738809743249476014170796}
#define T_100_57 {-0.9048270524660195768262838100781664252281,0.4257792915650726595089281545369885861874}
// Pre-computed twiddles for N=108
#define T_108_1 {0.9983081582712681756319739179161842912436,-0.0581448289104758292422658882969699334353}
#define T_108_5 {0.9579895123154889002847767187631689012051,-0.2868032327110902612865572791633894667029}
#define T_108_7 {0.9182161068802739967154025180207099765539,-0.3960797660391568442150855844374746084213}
#define T_108_11 {0.8021231927550437346141620764683466404676,-0.5971585917027861789563303318573161959648}
#define T_108_13 {0.7273736415730487347985899759805761277676,-0.6862416378687336004915664489089976996183}
#define T_108_17 {0.5495089780708060089864375186152756214142,-0.8354878114129363764206459563865792006254}
#define T_108_19 {0.4487991802004621666455363993009086698294,-0.8936326403234122750518508837558329105377}
#define T_108_23 {0.2306158707424401654861867427825927734375,-0.9730448705798238062669724968145601451397}
#define T_108_25 {0.1160929141252302343456648259234498254955,-0.9932383577419430231714159162947908043861}
#define T_108_29 {-0.1160929141252302343456648259234498254955,-0.9932383577419430231714159162947908043861}
#define T_108_31 {-0.2306158707424401654861867427825927734375,-0.9730448705798238062669724968145601451397}
#define T_108_35 {-0.4487991802004621666455363993009086698294,-0.8936326403234122750518508837558329105377}
#define T_108_37 {-0.5495089780708060089864375186152756214142,-0.8354878114129363764206459563865792006254}
#define T_108_41 {-0.7273736415730487347985899759805761277676,-0.6862416378687336004915664489089976996183}
#define T_108_43 {-0.8021231927550437346141620764683466404676,-0.5971585917027861789563303318573161959648}
#define T_108_47 {-0.9182161068802739967154025180207099765539,-0.3960797660391568442150855844374746084213}
#define T_108_49 {-0.9579895123154889002847767187631689012051,-0.2868032327110902612865572791633894667029}
#define T_108_53 {-0.9983081582712681756319739179161842912436,-0.0581448289104758292422658882969699334353}
#define T_108_55 {-0.9983081582712681756319739179161842912436,0.0581448289104758292422658882969699334353}
#define T_108_59 {-0.9579895123154889002847767187631689012051,0.2868032327110902612865572791633894667029}
#define T_108_61 {-0.9182161068802739967154025180207099765539,0.3960797660391568442150855844374746084213}
#define T_108_65 {-0.8021231927550437346141620764683466404676,0.5971585917027861789563303318573161959648}
#define T_108_67 {-0.7273736415730487347985899759805761277676,0.6862416378687336004915664489089976996183}
#define T_108_71 {-0.5495089780708060089864375186152756214142,0.8354878114129363764206459563865792006254}
// Pre-computed twiddles for N=121
#define T_121_1 {0.9986520883988230234962202302995137870312,-0.0519038181318997385305102909569541225210}
#define T_121_2 {0.9946119873266613398143931590311694890261,-0.1036677127465887443547032376045535784215}
#define T_121_3 {0.9878905881817251488641318246664013713598,-0.1551521375359205257016270707026706077158}
#define T_121_4 {0.9785060106677815339182302523113321512938,-0.2062182995929881801355776360651361756027}
#define T_121_5 {0.9664835539466369862537931112456135451794,-0.2567285335732630846550250680593308061361}
#define T_121_6 {0.9518556284360696340129948112007696181536,-0.3065466728160248788270791919785551726818}
#define T_121_7 {0.9346616684370731009678934242401737719774,-0.3555384164256048529217935083579504862428}
#define T_121_8 {0.9149480258259531373354889183246996253729,-0.4035716913228565294602390167710836976767}
#define T_121_9 {0.8927678450978636659485232485167216509581,-0.4505170082908268036625543118134373798966}
#define T_121_10 {0.8681809200986438934677380530047230422497,-0.4962478110547915988171041590248933061957}
#define T_121_12 {0.8120582747708500193084546481259167194366,-0.5835763517965671942633321123139467090368}
#define T_121_18 {0.5940688504813661507952815554745029658079,-0.8044141973434756343053209093341138213873}
#define T_121_24 {0.3188772832476185481453967440756969153881,-0.9477960108739739153449477271351497620344}
#define T_121_30 {0.0129814231979309014503032315701602783520,-0.9999157377758168818715489578607957810163}
#define T_121_36 {-0.2941644017754964091082570121216122061014,-0.9557548350534588177396244645933620631695}
#define T_121_42 {-0.5729855062290020173421112303913105279207,-0.8195655005254273151038546529889572411776}
#define T_121_48 {-0.7966345564572361315214266141992993652821,-0.6044612340408462847207715640251990407705}
#define T_121_54 {-0.9435766665119819096574360628437716513872,-0.3311541550609564121820937998563749715686}
#define T_121_60 {-0.9996629653035123963533692403871100395918,-0.0259606587086783635598408181976992636919}
// Pre-computed twiddles for N=125
#define T_125_1 {0.9987369566060174674859695187478791922331,-0.0502443181797695564982930704900354612619}
#define T_125_2 {0.9949510169813001736471846925269346684217,-0.1003617148512148948835687178871012292802}
#define T_125_3 {0.9886517447379140621777082742482889443636,-0.1502255891207570637213564168632728978992}
#define T_125_4 {0.9798550523842468606972033740021288394928,-0.1997099805144070261420097267546225339174}
#define T_125_6 {0.9548645447466429514449259841057937592268,-0.2970415815770349188262855477660195901990}
#define T_125_7 {0.9387338576538740708699037895712535828352,-0.3446429231745170573830705507134553045034}
#define T_125_8 {0.9202318473658703812390058374148793518543,-0.3913736668372024274376030916755553334951}
#define T_125_9 {0.8994052515663710778426320757716894149780,-0.4371157666509328798554179229540750384331}
#define T_125_11 {0.8509944817946918371731612751318607479334,-0.5251746299612957136204727248696144670248}
#define T_125_12 {0.8235325976284274540617502680106554180384,-0.5672689491267565164989150616747792810202}
#define T_125_13 {0.7939903986478353825617659822455607354641,-0.6079302976946053815865411706909071654081}
#define T_125_14 {0.7624425110114478876255361683433875441551,-0.6470559615694443378330902305606286972761}
#define T_125_16 {0.6936533058128049322732522341539151966572,-0.7203090248879069346088499514735303819180}
#define T_125_17 {0.6565857557529564125786691874964162707329,-0.7542513807361037603271824991679750382900}
#define T_125_18 {0.6178596130903343253137904866889584809542,-0.7862884321366189199764562545169610530138}
#define T_125_19 {0.5775727034222676303798493790964130312204,-0.8163392507171839396207246863923501223326}
#define T_125_21 {0.4927273415482915641661065819789655506611,-0.8701837546695256886408742502680979669094}
#define T_125_22 {0.4483832160900322327812261846702313050628,-0.8938414241512637747888447847799398005009}
#define T_125_23 {0.4029064357136626361999276468850439414382,-0.9152411726209175313329069467727094888687}
#define T_125_24 {0.3564118787132506960269040519051486626267,-0.9343289424566120215942532922781538218260}
#define T_125_26 {0.2608415062898969405402738175325794145465,-0.9653816388332738807065425135078839957714}
#define T_125_27 {0.2120071099220546539942944264112156815827,-0.9772681235681934808212645293679088354111}
#define T_125_28 {0.1626371651948836094536687824074761010706,-0.9866859442078680375587396156333852559328}
#define T_125_29 {0.1128563848734816937868785657883563544601,-0.9936113105200083950307998748030513525009}
#define T_125_31 {0.0125660398833526074091615498673490947112,-0.9999210442038161117395134169782977551222}
#define T_125_32 {-0.0376901826699345410265351574707892723382,-0.9992894726405892047438328518182970583439}
#define T_125_33 {-0.0878511965507431796806869783722504507750,-0.9961336091431725048295220403815619647503}
#define T_125_34 {-0.1377902906846380504113369624974438920617,-0.9904614256966511876001391101453918963671}
#define T_125_36 {-0.2364989970237246774686923345143441110849,-0.9716317329146739734113680242444388568401}
#define T_125_37 {-0.2850192624699761090312222222564741969109,-0.9585217890173758359395606021280400454998}
#define T_125_38 {-0.3328195445229866211711566847952781245112,-0.9429905358928645231486598277115263044834}
#define T_125_39 {-0.3797790955218011132998867651622276753187,-0.9250772068344580434384738509834278374910}
#define T_125_41 {-0.4707039321653325725236527432571165263653,-0.8822912264349532796003927614947315305471}
#define T_125_42 {-0.5144395337815064195297054538968950510025,-0.8575266561936522036191377083014231175184}
#define T_125_43 {-0.5568756164881879522354779510351363569498,-0.8305958991958126702570552879478782415390}
#define T_125_44 {-0.5979049830575188240189277166791725903749,-0.8015669848708765199418735392100643366575}
#define T_125_46 {-0.6753328081210244748788795732252765446901,-0.7375131173581739307820726025965996086597}
#define T_125_47 {-0.7115356772092853443467674878775142133236,-0.7026499697988491943689837171405088156462}
#define T_125_48 {-0.7459411454241821060051620406738948076963,-0.6660118674342516698061444913037121295929}
#define T_125_49 {-0.7784623015670234513763148243015166372061,-0.6276913612907004669239086069865152239799}
#define T_125_51 {-0.8375280400421417636991350263997446745634,-0.5463943467342691207022653543390333652496}
#define T_125_52 {-0.8639234171928352745695178782625589519739,-0.5036232016357607976786425751924980431795}
#define T_125_53 {-0.8881364488135444767991089065617416054010,-0.4595798606214878678777324694237904623151}
#define T_125_54 {-0.9101059706849956576490967563586309552193,-0.4143755809932841427389860200491966679692}
#define T_125_56 {-0.9470983049947442333760250221530441194773,-0.3209436098072094845079504921159241348505}
#define T_125_57 {-0.9620276715860859306772567833831999450922,-0.2729519355173252170843056774174328893423}
#define T_125_58 {-0.9745268727865771252183435535698663443327,-0.2242707609493811982126487691857619211078}
#define T_125_59 {-0.9845643345292053316697433729132171720266,-0.1750230589752760357313832173531409353018}
#define T_125_61 {-0.9971589002606139340301183437986765056849,-0.0753268055279327219952989480589167214930}
#define T_125_62 {-0.9996841892832999398876836494309827685356,-0.0251300954433374794383393435737161780708}
#define T_125_63 {-0.9996841892832999398876836494309827685356,0.0251300954433374794383393435737161780708}
#define T_125_66 {-0.9845643345292053316697433729132171720266,0.1750230589752760357313832173531409353018}
#define T_125_69 {-0.9470983049947442333760250221530441194773,0.3209436098072094845079504921159241348505}
#define T_125_72 {-0.8881364488135444767991089065617416054010,0.4595798606214878678777324694237904623151}
// Pre-computed twiddles for N=128
#define T_128_1 {0.9987954562051724050064649418345652520657,-0.0490676743274180149345653489945107139647}
#define T_128_3 {0.9891765099647810144389836750633548945189,-0.1467304744553617479319029826001496985555}
#define T_128_5 {0.9700312531945439742386838588572572916746,-0.2429801799032638986997056917971349321306}
#define T_128_7 {0.9415440651830208063088889502978418022394,-0.3368898533922200511092626129538984969258}
#define T_128_9 {0.9039892931234433381959547659789677709341,-0.4275550934302820849097770405933260917664}
#define T_128_11 {0.8577286100002721180857179206213913857937,-0.5141027441932217723064013625844381749630}
#define T_128_13 {0.8032075314806449428672863177780527621508,-0.5956993044924333569056784654094371944666}
#define T_128_15 {0.7409511253549591058842338497925084084272,-0.6715589548470184411144145997241139411926}
#define T_128_17 {0.6715589548470184411144145997241139411926,-0.7409511253549591058842338497925084084272}
#define T_128_19 {0.5956993044924333569056784654094371944666,-0.8032075314806449428672863177780527621508}
#define T_128_21 {0.5141027441932217723064013625844381749630,-0.8577286100002721180857179206213913857937}
#define T_128_23 {0.4275550934302820849097770405933260917664,-0.9039892931234433381959547659789677709341}
#define T_128_25 {0.3368898533922200511092626129538984969258,-0.9415440651830208063088889502978418022394}
#define T_128_27 {0.2429801799032638986997056917971349321306,-0.9700312531945439742386838588572572916746}
#define T_128_29 {0.1467304744553617479319029826001496985555,-0.9891765099647810144389836750633548945189}
#define T_128_31 {0.0490676743274180149345653489945107139647,-0.9987954562051724050064649418345652520657}
#define T_128_33 {-0.0490676743274180149345653489945107139647,-0.9987954562051724050064649418345652520657}
#define T_128_35 {-0.1467304744553617479319029826001496985555,-0.9891765099647810144389836750633548945189}
#define T_128_37 {-0.2429801799032638986997056917971349321306,-0.9700312531945439742386838588572572916746}
#define T_128_39 {-0.3368898533922200511092626129538984969258,-0.9415440651830208063088889502978418022394}
#define T_128_41 {-0.4275550934302820849097770405933260917664,-0.9039892931234433381959547659789677709341}
#define T_128_43 {-0.5141027441932217723064013625844381749630,-0.8577286100002721180857179206213913857937}
#define T_128_45 {-0.5956993044924333569056784654094371944666,-0.8032075314806449428672863177780527621508}
#define T_128_47 {-0.6715589548470184411144145997241139411926,-0.7409511253549591058842338497925084084272}
#define T_128_49 {-0.7409511253549591058842338497925084084272,-0.6715589548470184411144145997241139411926}
#define T_128_51 {-0.8032075314806449428672863177780527621508,-0.5956993044924333569056784654094371944666}
#define T_128_53 {-0.8577286100002721180857179206213913857937,-0.5141027441932217723064013625844381749630}
#define T_128_55 {-0.9039892931234433381959547659789677709341,-0.4275550934302820849097770405933260917664}
#define T_128_57 {-0.9415440651830208063088889502978418022394,-0.3368898533922200511092626129538984969258}
#define T_128_59 {-0.9700312531945439742386838588572572916746,-0.2429801799032638986997056917971349321306}
#define T_128_61 {-0.9891765099647810144389836750633548945189,-0.1467304744553617479319029826001496985555}
#define T_128_63 {-0.9987954562051724050064649418345652520657,-0.0490676743274180149345653489945107139647}
#define T_128_65 {-0.9987954562051724050064649418345652520657,0.0490676743274180149345653489945107139647}
#define T_128_67 {-0.9891765099647810144389836750633548945189,0.1467304744553617479319029826001496985555}
#define T_128_69 {-0.9700312531945439742386838588572572916746,0.2429801799032638986997056917971349321306}
#define T_128_71 {-0.9415440651830208063088889502978418022394,0.3368898533922200511092626129538984969258}
#define T_128_73 {-0.9039892931234433381959547659789677709341,0.4275550934302820849097770405933260917664}
#define T_128_75 {-0.8577286100002721180857179206213913857937,0.5141027441932217723064013625844381749630}
#define T_128_77 {-0.8032075314806449428672863177780527621508,0.5956993044924333569056784654094371944666}
#define T_128_79 {-0.7409511253549591058842338497925084084272,0.6715589548470184411144145997241139411926}
#define T_128_81 {-0.6715589548470184411144145997241139411926,0.7409511253549591058842338497925084084272}
#define T_128_83 {-0.5956993044924333569056784654094371944666,0.8032075314806449428672863177780527621508}
#define T_128_85 {-0.5141027441932217723064013625844381749630,0.8577286100002721180857179206213913857937}
#define T_128_87 {-0.4275550934302820849097770405933260917664,0.9039892931234433381959547659789677709341}
#define T_128_89 {-0.3368898533922200511092626129538984969258,0.9415440651830208063088889502978418022394}
#define T_128_91 {-0.2429801799032638986997056917971349321306,0.9700312531945439742386838588572572916746}
#define T_128_93 {-0.1467304744553617479319029826001496985555,0.9891765099647810144389836750633548945189}
#define T_128_95 {-0.0490676743274180149345653489945107139647,0.9987954562051724050064649418345652520657}
#define T_128_97 {0.0490676743274180149345653489945107139647,0.9987954562051724050064649418345652520657}
#define T_128_99 {0.1467304744553617479319029826001496985555,0.9891765099647810144389836750633548945189}
#define T_128_101 {0.2429801799032638986997056917971349321306,0.9700312531945439742386838588572572916746}
#define T_128_103 {0.3368898533922200511092626129538984969258,0.9415440651830208063088889502978418022394}
#define T_128_105 {0.4275550934302820849097770405933260917664,0.9039892931234433381959547659789677709341}
#define T_128_107 {0.5141027441932217723064013625844381749630,0.8577286100002721180857179206213913857937}
#define T_128_109 {0.5956993044924333569056784654094371944666,0.8032075314806449428672863177780527621508}
#define T_128_111 {0.6715589548470184411144145997241139411926,0.7409511253549591058842338497925084084272}
#define T_128_113 {0.7409511253549591058842338497925084084272,0.6715589548470184411144145997241139411926}
#define T_128_115 {0.8032075314806449428672863177780527621508,0.5956993044924333569056784654094371944666}
#define T_128_117 {0.8577286100002721180857179206213913857937,0.5141027441932217723064013625844381749630}
#define T_128_119 {0.9039892931234433381959547659789677709341,0.4275550934302820849097770405933260917664}
#define T_128_121 {0.9415440651830208063088889502978418022394,0.3368898533922200511092626129538984969258}
#define T_128_123 {0.9700312531945439742386838588572572916746,0.2429801799032638986997056917971349321306}
#define T_128_125 {0.9891765099647810144389836750633548945189,0.1467304744553617479319029826001496985555}
#define T_128_127 {0.9987954562051724050064649418345652520657,0.0490676743274180149345653489945107139647}
// Pre-computed twiddles for N=144
#define T_144_1 {0.9990482215818577982346937460533808916807,-0.0436193873653360000841594512621668400243}
#define T_144_5 {0.9762960071199333622615768035757355391979,-0.2164396139381028760784175801745732314885}
#define T_144_7 {0.9537169507482269326104074025352019816637,-0.3007057995042731191048801520082633942366}
#define T_144_11 {0.8870108331782217137018164976325351744890,-0.4617486132350339111951598169980570673943}
#define T_144_13 {0.8433914458128857205565509502775967121124,-0.5372996083468238870395339290553238242865}
#define T_144_17 {0.7372773368101240842875654379895422607660,-0.6755902076156602431566966515674721449614}
#define T_144_19 {0.6755902076156602431566966515674721449614,-0.7372773368101240842875654379895422607660}
#define T_144_23 {0.5372996083468238870395339290553238242865,-0.8433914458128857205565509502775967121124}
#define T_144_35 {0.0436193873653360000841594512621668400243,-0.9990482215818577982346937460533808916807}
#define T_144_49 {-0.5372996083468238870395339290553238242865,-0.8433914458128857205565509502775967121124}
#define T_144_77 {-0.9762960071199333622615768035757355391979,0.2164396139381028760784175801745732314885}
// Pre-computed twiddles for N=162
#define T_162_1 {0.9992479525042300414483520398789551109076,-0.0387753712568167097085591876748367212713}
#define T_162_5 {0.9812553106273846914575642585987225174904,-0.1927122605480896810892232906553545035422}
#define T_162_7 {0.9633708786158803327737132349284365773201,-0.2681726127606373633049940963246626779437}
#define T_162_11 {0.9103629409661466720393718787818215787411,-0.4138107245051391713808186523237964138389}
#define T_162_13 {0.8755582313020908724610080753336660563946,-0.4831125992966384674609514604526339098811}
#define T_162_17 {0.7903926695187593054470198694616556167603,-0.6126005451932028389450124450377188622952}
#define T_162_19 {0.7405440131090045285944256647781003266573,-0.6720078605555224182666052001877687871456}
#define T_162_23 {0.6278121246720985704214967881853226572275,-0.7783649119241600189411656174343079328537}
#define T_162_25 {0.5656068754865386516428316099336370825768,-0.8246750041091067684462245779286604374647}
#define T_162_29 {0.4313860656812534277726456366508500650525,-0.9021674247810377300638151609746273607016}
#define T_162_31 {0.3601777248047104418304797945893369615078,-0.9328837047320005515516072591708507388830}
#define T_162_35 {0.2117038722294107555566000655744574032724,-0.9773338582506355676216003303125035017729}
#define T_162_37 {0.1353312997501311121251177382873720489442,-0.9908004033648453168225955778325442224741}
#define T_162_41 {-0.0193913317718243730092275711740512633696,-0.9998119704485014525019437314767856150866}
#define T_162_43 {-0.0968108707031790916008873182363458909094,-0.9953027957931658287193954492977354675531}
#define T_162_47 {-0.2494411440579812899720479890675051137805,-0.9683899605278059041779670224059373140335}
#define T_162_49 {-0.3237339420583210114479300045786658301950,-0.9461481568757503790578766711405478417873}
#define T_162_53 {-0.4660435197025388220914976500353077426553,-0.8847617971766578159886762477981392294168}
#define T_162_55 {-0.5332044328016912748680056211014743894339,-0.8459864259198410785245414444943889975548}
#define T_162_59 {-0.6575213685690636244984830227622296661139,-0.7534358963276607257242289961141068488359}
#define T_162_61 {-0.7139297345578989872905140146031044423580,-0.7002173477671684853618216948234476149082}
#define T_162_65 {-0.8135520702629676081940601761743891984224,-0.5814920712880267128497280282317660748959}
#define T_162_67 {-0.8561668995302664786350987924379296600819,-0.5166993711518629295298410397663246840239}
#define T_162_71 {-0.9257239692688904453277132233779411762953,-0.3781998581716424778775831327948253601789}
#define T_162_73 {-0.9522478853384153119066013459814712405205,-0.3053259976951130938438438988669076934457}
#define T_162_77 {-0.9879898494768090122519765827746596187353,-0.1545187928078404770992904104787157848477}
#define T_162_79 {-0.9969929411677920239043260153266601264477,-0.0774924206719309477398027752315101679415}
#define T_162_83 {-0.9969929411677920239043260153266601264477,0.0774924206719309477398027752315101679415}
#define T_162_85 {-0.9879898494768090122519765827746596187353,0.1545187928078404770992904104787157848477}
#define T_162_89 {-0.9522478853384153119066013459814712405205,0.3053259976951130938438438988669076934457}
#define T_162_91 {-0.9257239692688904453277132233779411762953,0.3781998581716424778775831327948253601789}
#define T_162_95 {-0.8561668995302664786350987924379296600819,0.5166993711518629295298410397663246840239}
#define T_162_97 {-0.8135520702629676081940601761743891984224,0.5814920712880267128497280282317660748959}
#define T_162_101 {-0.7139297345578989872905140146031044423580,0.7002173477671684853618216948234476149082}
#define T_162_103 {-0.6575213685690636244984830227622296661139,0.7534358963276607257242289961141068488359}
#define T_162_107 {-0.5332044328016912748680056211014743894339,0.8459864259198410785245414444943889975548}
// Pre-computed twiddles for N=192
#define T_192_1 {0.9994645874763656845374271142645739018917,-0.0327190828217761436880195446974539663643}
#define T_192_5 {0.9866433320848789767509856574179138988256,-0.1628954733945887356494353070957004092634}
#define T_192_7 {0.9738769792773336320124144549481570720673,-0.2270762630343731991455769048116053454578}
#define T_192_11 {0.9359059267573256457595221036172006279230,-0.3522500479212334889567159734724555164576}
#define T_192_13 {0.9108638249211757909051812021061778068542,-0.4127070298043947205179904358374187722802}
#define T_192_19 {0.8128466845916152427875545072311069816351,-0.5824776968678021527026089643186423927546}
#define T_192_35 {0.4127070298043947205179904358374187722802,-0.9108638249211757909051812021061778068542}
#define T_192_49 {-0.0327190828217761436880195446974539663643,-0.9994645874763656845374271142645739018917}
#define T_192_77 {-0.8128466845916152427875545072311069816351,-0.5824776968678021527026089643186423927546}
#define T_192_91 {-0.9866433320848789767509856574179138988256,-0.1628954733945887356494353070957004092634}
// Pre-computed twiddles for N=200
#define T_200_1 {0.9995065603657316000152377455378882586956,-0.0314107590781282919323302849079482257366}
#define T_200_3 {0.9955619646030799962943547143368050456047,-0.0941083133185143250187820740393362939358}
#define T_200_7 {0.9759167619387474346126509772147983312607,-0.2181432413965425642921047710842685773969}
#define T_200_9 {0.9602936856769430651326047154725529253483,-0.2789911060392292752041498715698253363371}
#define T_200_11 {0.9408807689542254548697997051931452006102,-0.3387379202452913684595614540739916265011}
#define T_200_13 {0.9177546256839811400496387250314000993967,-0.3971478906347806203669392743904609233141}
#define T_200_17 {0.8607420270039436438480606739176437258720,-0.5090414157503713177277404611231759190559}
#define T_200_19 {0.8270805742745618305278298976190853863955,-0.5620833778521305834630084063974209129810}
#define T_200_21 {0.7901550123756904131511191735626198351383,-0.6129070536529764856581437015847768634558}
#define T_200_23 {0.7501110696304595926164893171517178416252,-0.6613118653236518262872323248302564024925}
#define T_200_27 {0.6613118653236518262872323248302564024925,-0.7501110696304595926164893171517178416252}
#define T_200_33 {0.5090414157503713177277404611231759190559,-0.8607420270039436438480606739176437258720}
#define T_200_39 {0.3387379202452913684595614540739916265011,-0.9408807689542254548697997051931452006102}
#define T_200_51 {-0.0314107590781282919323302849079482257366,-0.9995065603657316000152377455378882586956}
#define T_200_57 {-0.2181432413965425642921047710842685773969,-0.9759167619387474346126509772147983312607}
#define T_200_63 {-0.3971478906347806203669392743904609233141,-0.9177546256839811400496387250314000993967}
#define T_200_69 {-0.5620833778521305834630084063974209129810,-0.8270805742745618305278298976190853863955}
#define T_200_81 {-0.8270805742745618305278298976190853863955,-0.5620833778521305834630084063974209129810}
#define T_200_87 {-0.9177546256839811400496387250314000993967,-0.3971478906347806203669392743904609233141}
#define T_200_93 {-0.9759167619387474346126509772147983312607,-0.2181432413965425642921047710842685773969}
#define T_200_99 {-0.9995065603657316000152377455378882586956,-0.0314107590781282919323302849079482257366}
#define T_200_111 {-0.9408807689542254548697997051931452006102,0.3387379202452913684595614540739916265011}
#define T_200_117 {-0.8607420270039436438480606739176437258720,0.5090414157503713177277404611231759190559}
// Pre-computed twiddles for N=216
#define T_216_1 {0.9995769500822005992901608806278090924025,-0.0290847187431114082012406640842527849600}
#define T_216_5 {0.9894416385809444713927973680256400257349,-0.1449318593072467242777179308177437633276}
#define T_216_7 {0.9793406217655514778286374166782479733229,-0.2022175723320379370218091708011343143880}
#define T_216_11 {0.9492426435730338951657358848024159669876,-0.3145447561516136469883520021539879962802}
#define T_216_13 {0.9293475242268224301156465116946492344141,-0.3692061473126844739489627045259112492204}
#define T_216_17 {0.8802013911801110923605051539198029786348,-0.4746003697476404159516505387728102505207}
#define T_216_19 {0.8511166724369997327315218171861488372087,-0.5249765803345601833385103418549988418818}
#define T_216_23 {0.7844156649195757058379285808769054710865,-0.6202354912682600529549858947575557976961}
#define T_216_25 {0.7470250712409959303883510983723681420088,-0.6647958656139377753291341832664329558611}
#define T_216_29 {0.6647958656139377753291341832664329558611,-0.7470250712409959303883510983723681420088}
#define T_216_31 {0.6202354912682600529549858947575557976961,-0.7844156649195757058379285808769054710865}
#define T_216_35 {0.5249765803345601833385103418549988418818,-0.8511166724369997327315218171861488372087}
#define T_216_49 {0.1449318593072467242777179308177437633276,-0.9894416385809444713927973680256400257349}
#define T_216_77 {-0.6202354912682600529549858947575557976961,-0.7844156649195757058379285808769054710865}
#define T_216_91 {-0.8802013911801110923605051539198029786348,-0.4746003697476404159516505387728102505207}
#define T_216_119 {-0.9492426435730338951657358848024159669876,0.3145447561516136469883520021539879962802}
// Pre-computed twiddles for N=243
#define T_243_1 {0.9996657333896874497725093533517792820930,-0.0258538485811760469779141402568711782806}
#define T_243_2 {0.9986631570270831925739685175358317792416,-0.0516904130056945673721280343215767061338}
#define T_243_4 {0.9946562024066014640055755080538801848888,-0.1032426220806014760533741991821443662047}
#define T_243_5 {0.9916545029310011027945392925175838172436,-0.1289238023666266774736044453675276599824}
#define T_243_7 {0.9836646919866011140598516249156091362238,-0.1800104823028513545413176188958459533751}
#define T_243_8 {0.9786819219718442264266400343331042677164,-0.2053818288103820000056742856031632982194}
#define T_243_10 {0.9667573063666620170053533911413978785276,-0.2556957383037036235506889170210342854261}
#define T_243_11 {0.9598234327779119334778101801930461078882,-0.2806046647695387696863633664179360494018}
#define T_243_13 {0.9440357285532999798149944581382442265749,-0.3298432100481077378084648898948216810822}
#define T_243_14 {0.9351924525221896322690895431151147931814,-0.3541399112575875918196288694161921739578}
#define T_243_16 {0.9156366087890058791387559722352307289839,-0.4020069659164738906653724370698910206556}
#define T_243_17 {0.9049371148181253321496342323371209204197,-0.4255453186496674367056414212129311636090}
#define T_243_19 {0.8817307427216080073506532244209665805101,-0.4717530045899035462397819173929747194052}
#define T_243_20 {0.8692393788266478127368941386521328240633,-0.4943914464238468586820829386851983144879}
#define T_243_22 {0.8425220442191495573425186194072011858225,-0.5386618651851877714875627134460955858231}
#define T_243_23 {0.8283139349323630495902648362971376627684,-0.5602642458669525593606408619962166994810}
#define T_243_25 {0.7982463190078928905180077890690881758928,-0.6023311499419146120004597833030857145786}
#define T_243_26 {0.7824069135703197730435931589454412460327,-0.6227675502122490547307620545325335115194}
#define T_243_28 {0.7491698465089360325919187744148075580597,-0.6623779442899478953066250142001081258059}
#define T_243_29 {0.7317944049686120333575445329188369214535,-0.6815254572329891846749205797095783054829}
#define T_243_31 {0.6955877784024419030473040947981644421816,-0.7184411197427074124988166659022681415081}
#define T_243_32 {0.6767807987092619992353093039127998054028,-0.7361845899626352496269987568666692823172}
#define T_243_34 {0.6378223635507059841032173608255106955767,-0.7701835057663797279303707910003140568733}
#define T_243_35 {0.6176969530934570684621576219797134399414,-0.7864162219455163027603816772170830518007}
#define T_243_37 {0.5762210099555802322868203191319480538368,-0.8172939175631805941435459317290224134922}
#define T_243_38 {0.5548982053207968112573666985554154962301,-0.8319182542364116361710557612241245806217}
#define T_243_40 {0.5111541954058731462851028481964021921158,-0.8594890275733452211781582263938616961241}
#define T_243_41 {0.4887622344495642368045196235470939427614,-0.8724170322591536796963396227511111646891}
#define T_243_43 {0.4430132393803352108818671695189550518990,-0.8965150694404092623912561066390480846167}
#define T_243_44 {0.4196867899904290766244230326265096664429,-0.9076689915974487377070545335300266742706}
#define T_243_46 {0.3722079496062699610625656987394904717803,-0.9281493641919367210135760615230537950993}
#define T_243_47 {0.3480872997940905322344917749433079734445,-0.9374621228199350175813719943107571452856}
#define T_243_49 {0.2991641574276416304378756194637389853597,-0.9542016594570611465186971145158167928457}
#define T_243_50 {0.2743943716193014692450447000737767666578,-0.9616172465298491456309193381457589566708}
#define T_243_52 {0.2243211568052675963791386948287254199386,-0.9745152736666299331247387272014748305082}
#define T_243_53 {0.1990512034071405256252518256587791256607,-0.9799890909710011754896186175756156444550}
#define T_243_55 {0.1481290623512488136004350280927610583603,-0.9889680383545971231740168150281533598900}
#define T_243_56 {0.1225109178364454237675218450931424740702,-0.9924671657092095644614460070442873984575}
#define T_243_58 {0.0710461022867300423522252117436437401921,-0.9974730328935532686074338926118798553944}
#define T_243_59 {0.0452338371907063732657583443597104633227,-0.9989764261347735541107795143034309148788}
#define T_243_61 {-0.0064641373965392589021061731102690828266,-0.9999791072456057916539862162608187645674}
#define T_243_62 {-0.0323152850743106193065479203596623847261,-0.9994777247895852978487596374179702252150}
#define T_243_64 {-0.0839355009969068172059891708158829715103,-0.9964711895847256917235768014506902545691}
#define T_243_65 {-0.1096700594125315647575646949007932562381,-0.9939680468045498651363800490798894315958}
#define T_243_67 {-0.1609020666180572822767658180964644998312,-0.9869703769404826187994217434606980532408}
#define T_243_68 {-0.1863652651091820544593247177544981241226,-0.9824805280313622102283943604561500251293}
#define T_243_70 {-0.2369009482781190834010942580789560452104,-0.9715338083180264927563030141755007207394}
#define T_243_71 {-0.2619396481729058812071286865830188617110,-0.9650842557595965542915905643894802778959}
#define T_243_73 {-0.3114750797604245446947857089980971068144,-0.9502543210573878296187899650249164551497}
#define T_243_74 {-0.3359386953715421397781426549045136198401,-0.9418838532176173616861092341423500329256}
#define T_243_76 {-0.3841759634635175113537286506470991298556,-0.9232598924987903687977564004540909081697}
#define T_243_77 {-0.4079173677281835996843994962546275928617,-0.9130188503561741386604921899561304599047}
#define T_243_79 {-0.4545663677185005635550396618782542645931,-0.8907128703118692980567061567853670567274}
#define T_243_80 {-0.4774427770379489621710433766565984115005,-0.8786628446988590246391481741738971322775}
#define T_243_82 {-0.5222229563517384320903147454373538494110,-0.8528089961176830158251505054067820310593}
#define T_243_83 {-0.5440967893085826290189288556575775146484,-0.8390224573061747515012598341854754835367}
#define T_243_85 {-0.5867388346784178088100247805414255708456,-0.8097762282755726070959667595161590725183}
#define T_243_86 {-0.6074785394674836469519618731283117085695,-0.7943360901321637745908788019733037799597}
#define T_243_88 {-0.6477259966150589187705577387532684952021,-0.7618733709147660349003672308754175901413}
#define T_243_89 {-0.6672068422114196817318543253350071609020,-0.7448724922470058018575400637928396463394}
#define T_243_91 {-0.7048176581937560802870734733005519956350,-0.7093885174558928197185991848527919501066}
#define T_243_92 {-0.7229224844997927945655646908562630414963,-0.6909291435484877785810908790153916925192}
#define T_243_94 {-0.7576704634441179253556697403837461024523,-0.6526373179832544169087782393035013228655}
#define T_243_95 {-0.7742903859041323499923237250186502933502,-0.6328304656828950269797928740445058792830}
#define T_243_97 {-0.8059665493764742727478278538910672068596,-0.5919610808880759744710076120099984109402}
#define T_243_98 {-0.8210016138212185010658572537067811936140,-0.5709258709350581995067841489799320697784}
#define T_243_100 {-0.8494154576472973117162723610817920416594,-0.5277247201996817516089777200249955058098}
#define T_243_101 {-0.8627752414301085304160210398549679666758,-0.5055876608217588774607520463177934288979}
#define T_243_103 {-0.8877558814098559514249586754885967820883,-0.4603145609495857271120655695995083078742}
#define T_243_104 {-0.8993600372190930780647022402263246476650,-0.4372087870266007092467930306156631559134}
#define T_243_106 {-0.9207572368443383004077418263477738946676,-0.3901360157672949524609862237412016838789}
#define T_243_107 {-0.9305359759215685588884525714092887938023,-0.3662004881423480129321035292377928271890}
#define T_243_109 {-0.9482210499160764749504437531868461519480,-0.3176111466810532801829936033755075186491}
#define T_243_110 {-0.9561155617738796852478344590053893625736,-0.2929898164336406929386669162340695038438}
#define T_243_112 {-0.9699821500217434833146512573875952512026,-0.2431761267871417053765270566145773045719}
#define T_243_113 {-0.9759449561369035741620336921187117695808,-0.2180170694944258691361227420202339999378}
#define T_243_115 {-0.9859096633447964608265579045109916478395,-0.1672786170535553174065768189393565990031}
#define T_243_116 {-0.9899049026997269740135720894613768905401,-0.1417331422464204460087699999348842538893}
#define T_243_118 {-0.9959077999460093089112433517584577202797,-0.0903750740342681158079329861720907501876}
#define T_243_119 {-0.9979114447011320221392338680743705481291,-0.0645968152039976400979881532293802592903}
#define T_243_121 {-0.9999164298554372720673200092278420925140,-0.0129280046858085244376734834759190562181}
#define T_243_122 {-0.9999164298554372720673200092278420925140,0.0129280046858085244376734834759190562181}
#define T_243_124 {-0.9979114447011320221392338680743705481291,0.0645968152039976400979881532293802592903}
#define T_243_125 {-0.9959077999460093089112433517584577202797,0.0903750740342681158079329861720907501876}
#define T_243_128 {-0.9859096633447964608265579045109916478395,0.1672786170535553174065768189393565990031}
#define T_243_130 {-0.9759449561369035741620336921187117695808,0.2180170694944258691361227420202339999378}
#define T_243_134 {-0.9482210499160764749504437531868461519480,0.3176111466810532801829936033755075186491}
#define T_243_136 {-0.9305359759215685588884525714092887938023,0.3662004881423480129321035292377928271890}
#define T_243_140 {-0.8877558814098559514249586754885967820883,0.4603145609495857271120655695995083078742}
#define T_243_142 {-0.8627752414301085304160210398549679666758,0.5055876608217588774607520463177934288979}
#define T_243_146 {-0.8059665493764742727478278538910672068596,0.5919610808880759744710076120099984109402}
#define T_243_148 {-0.7742903859041323499923237250186502933502,0.6328304656828950269797928740445058792830}
#define T_243_152 {-0.7048176581937560802870734733005519956350,0.7093885174558928197185991848527919501066}
#define T_243_154 {-0.6672068422114196817318543253350071609020,0.7448724922470058018575400637928396463394}
#define T_243_158 {-0.5867388346784178088100247805414255708456,0.8097762282755726070959667595161590725183}
#define T_243_160 {-0.5440967893085826290189288556575775146484,0.8390224573061747515012598341854754835367}
// Pre-computed twiddles for N=250
#define T_250_1 {0.9996841892832999398876836494309827685356,-0.0251300954433374794383393435737161780708}
#define T_250_3 {0.9971589002606139340301183437986765056849,-0.0753268055279327219952989480589167214930}
#define T_250_7 {0.9845643345292053316697433729132171720266,-0.1750230589752760357313832173531409353018}
#define T_250_9 {0.9745268727865771252183435535698663443327,-0.2242707609493811982126487691857619211078}
#define T_250_11 {0.9620276715860859306772567833831999450922,-0.2729519355173252170843056774174328893423}
#define T_250_13 {0.9470983049947442333760250221530441194773,-0.3209436098072094845079504921159241348505}
#define T_250_17 {0.9101059706849956576490967563586309552193,-0.4143755809932841427389860200491966679692}
#define T_250_19 {0.8881364488135444767991089065617416054010,-0.4595798606214878678777324694237904623151}
#define T_250_21 {0.8639234171928352745695178782625589519739,-0.5036232016357607976786425751924980431795}
#define T_250_23 {0.8375280400421417636991350263997446745634,-0.5463943467342691207022653543390333652496}
#define T_250_27 {0.7784623015670234513763148243015166372061,-0.6276913612907004669239086069865152239799}
#define T_250_33 {0.6753328081210244748788795732252765446901,-0.7375131173581739307820726025965996086597}
#define T_250_39 {0.5568756164881879522354779510351363569498,-0.8305958991958126702570552879478782415390}
#define T_250_51 {0.2850192624699761090312222222564741969109,-0.9585217890173758359395606021280400454998}
#define T_250_57 {0.1377902906846380504113369624974438920617,-0.9904614256966511876001391101453918963671}
#define T_250_63 {-0.0125660398833526074091615498673490947112,-0.9999210442038161117395134169782977551222}
#define T_250_69 {-0.1626371651948836094536687824074761010706,-0.9866859442078680375587396156333852559328}
#define T_250_81 {-0.4483832160900322327812261846702313050628,-0.8938414241512637747888447847799398005009}
#define T_250_87 {-0.5775727034222676303798493790964130312204,-0.8163392507171839396207246863923501223326}
#define T_250_93 {-0.6936533058128049322732522341539151966572,-0.7203090248879069346088499514735303819180}
#define T_250_99 {-0.7939903986478353825617659822455607354641,-0.6079302976946053815865411706909071654081}
#define T_250_111 {-0.9387338576538740708699037895712535828352,-0.3446429231745170573830705507134553045034}
#define T_250_117 {-0.9798550523842468606972033740021288394928,-0.1997099805144070261420097267546225339174}
#define T_250_123 {-0.9987369566060174674859695187478791922331,-0.0502443181797695564982930704900354612619}
#define T_250_129 {-0.9949510169813001736471846925269346684217,0.1003617148512148948835687178871012292802}
#define T_250_141 {-0.9202318473658703812390058374148793518543,0.3913736668372024274376030916755553334951}
#define T_250_147 {-0.8509944817946918371731612751318607479334,0.5251746299612957136204727248696144670248}
// Pre-computed twiddles for N=256
#define T_256_1 {0.9996988186962042499672520534659270197153,-0.0245412285229122881236030195850617019460}
#define T_256_3 {0.9972904566786902069708276030723936855793,-0.0735645635996674263079597722025937400758}
#define T_256_5 {0.9924795345987099670637121562322136014700,-0.1224106751992161956632543251544120721519}
#define T_256_7 {0.9852776423889412216183814052783418446779,-0.1709618887603012171716443390323547646403}
#define T_256_9 {0.9757021300385285700329518476792145520449,-0.2191012401568697975928756704888655804098}
#define T_256_11 {0.9637760657954398402225137942878063768148,-0.2667127574748983653840639362897491082549}
#define T_256_13 {0.9495281805930366747503512669936753809452,-0.3136817403988914620960315460251877084374}
#define T_256_15 {0.9329927988347388456702447001589462161064,-0.3598950365349881663767916961660375818610}
#define T_256_17 {0.9142097557035306909511973572080023586750,-0.4052413140049898609973411112150643020868}
#define T_256_19 {0.8932243011955153244585403626842889934778,-0.4496113296546065951631021562207024544477}
#define T_256_21 {0.8700869911087114605408032730338163673878,-0.4928981922297840378988098564150277525187}
#define T_256_23 {0.8448535652497071168909315019845962524414,-0.5349976198870972643462096129951532930136}
#define T_256_25 {0.8175848131515837113880706965574063360691,-0.5758081914178453386554679127584677189589}
#define T_256_27 {0.7883464276266062276121715512999799102545,-0.6152315905806268192534957961470354348421}
#define T_256_29 {0.7572088465064845674845628309412859380245,-0.6531728429537767555146388076536823064089}
#define T_256_31 {0.7242470829514668917425979088875465095043,-0.6895405447370669405060539247642736881971}
#define T_256_33 {0.6895405447370669405060539247642736881971,-0.7242470829514668917425979088875465095043}
#define T_256_35 {0.6531728429537767555146388076536823064089,-0.7572088465064845674845628309412859380245}
#define T_256_37 {0.6152315905806268192534957961470354348421,-0.7883464276266062276121715512999799102545}
#define T_256_39 {0.5758081914178453386554679127584677189589,-0.8175848131515837113880706965574063360691}
#define T_256_41 {0.5349976198870972643462096129951532930136,-0.8448535652497071168909315019845962524414}
#define T_256_43 {0.4928981922297840378988098564150277525187,-0.8700869911087114605408032730338163673878}
#define T_256_45 {0.4496113296546065951631021562207024544477,-0.8932243011955153244585403626842889934778}
#define T_256_47 {0.4052413140049898609973411112150643020868,-0.9142097557035306909511973572080023586750}
#define T_256_49 {0.3598950365349881663767916961660375818610,-0.9329927988347388456702447001589462161064}
#define T_256_51 {0.3136817403988914620960315460251877084374,-0.9495281805930366747503512669936753809452}
#define T_256_53 {0.2667127574748983653840639362897491082549,-0.9637760657954398402225137942878063768148}
#define T_256_55 {0.2191012401568697975928756704888655804098,-0.9757021300385285700329518476792145520449}
#define T_256_57 {0.1709618887603012171716443390323547646403,-0.9852776423889412216183814052783418446779}
#define T_256_59 {0.1224106751992161956632543251544120721519,-0.9924795345987099670637121562322136014700}
#define T_256_61 {0.0735645635996674263079597722025937400758,-0.9972904566786902069708276030723936855793}
#define T_256_63 {0.0245412285229122881236030195850617019460,-0.9996988186962042499672520534659270197153}
#define T_256_65 {-0.0245412285229122881236030195850617019460,-0.9996988186962042499672520534659270197153}
#define T_256_67 {-0.0735645635996674263079597722025937400758,-0.9972904566786902069708276030723936855793}
#define T_256_69 {-0.1224106751992161956632543251544120721519,-0.9924795345987099670637121562322136014700}
#define T_256_71 {-0.1709618887603012171716443390323547646403,-0.9852776423889412216183814052783418446779}
#define T_256_73 {-0.2191012401568697975928756704888655804098,-0.9757021300385285700329518476792145520449}
#define T_256_75 {-0.2667127574748983653840639362897491082549,-0.9637760657954398402225137942878063768148}
#define T_256_77 {-0.3136817403988914620960315460251877084374,-0.9495281805930366747503512669936753809452}
#define T_256_79 {-0.3598950365349881663767916961660375818610,-0.9329927988347388456702447001589462161064}
#define T_256_81 {-0.4052413140049898609973411112150643020868,-0.9142097557035306909511973572080023586750}
#define T_256_83 {-0.4496113296546065951631021562207024544477,-0.8932243011955153244585403626842889934778}
#define T_256_85 {-0.4928981922297840378988098564150277525187,-0.8700869911087114605408032730338163673878}
#define T_256_87 {-0.5349976198870972643462096129951532930136,-0.8448535652497071168909315019845962524414}
#define T_256_89 {-0.5758081914178453386554679127584677189589,-0.8175848131515837113880706965574063360691}
#define T_256_91 {-0.6152315905806268192534957961470354348421,-0.7883464276266062276121715512999799102545}
#define T_256_93 {-0.6531728429537767555146388076536823064089,-0.7572088465064845674845628309412859380245}
#define T_256_95 {-0.6895405447370669405060539247642736881971,-0.7242470829514668917425979088875465095043}
#define T_256_97 {-0.7242470829514668917425979088875465095043,-0.6895405447370669405060539247642736881971}
#define T_256_99 {-0.7572088465064845674845628309412859380245,-0.6531728429537767555146388076536823064089}
#define T_256_101 {-0.7883464276266062276121715512999799102545,-0.6152315905806268192534957961470354348421}
#define T_256_103 {-0.8175848131515837113880706965574063360691,-0.5758081914178453386554679127584677189589}
#define T_256_105 {-0.8448535652497071168909315019845962524414,-0.5349976198870972643462096129951532930136}
#define T_256_107 {-0.8700869911087114605408032730338163673878,-0.4928981922297840378988098564150277525187}
#define T_256_109 {-0.8932243011955153244585403626842889934778,-0.4496113296546065951631021562207024544477}
#define T_256_111 {-0.9142097557035306909511973572080023586750,-0.4052413140049898609973411112150643020868}
#define T_256_113 {-0.9329927988347388456702447001589462161064,-0.3598950365349881663767916961660375818610}
#define T_256_115 {-0.9495281805930366747503512669936753809452,-0.3136817403988914620960315460251877084374}
#define T_256_117 {-0.9637760657954398402225137942878063768148,-0.2667127574748983653840639362897491082549}
#define T_256_119 {-0.9757021300385285700329518476792145520449,-0.2191012401568697975928756704888655804098}
#define T_256_121 {-0.9852776423889412216183814052783418446779,-0.1709618887603012171716443390323547646403}
#define T_256_123 {-0.9924795345987099670637121562322136014700,-0.1224106751992161956632543251544120721519}
#define T_256_125 {-0.9972904566786902069708276030723936855793,-0.0735645635996674263079597722025937400758}
#define T_256_127 {-0.9996988186962042499672520534659270197153,-0.0245412285229122881236030195850617019460}
#define T_256_129 {-0.9996988186962042499672520534659270197153,0.0245412285229122881236030195850617019460}
#define T_256_131 {-0.9972904566786902069708276030723936855793,0.0735645635996674263079597722025937400758}
#define T_256_133 {-0.9924795345987099670637121562322136014700,0.1224106751992161956632543251544120721519}
#define T_256_135 {-0.9852776423889412216183814052783418446779,0.1709618887603012171716443390323547646403}
#define T_256_137 {-0.9757021300385285700329518476792145520449,0.2191012401568697975928756704888655804098}
#define T_256_139 {-0.9637760657954398402225137942878063768148,0.2667127574748983653840639362897491082549}
#define T_256_141 {-0.9495281805930366747503512669936753809452,0.3136817403988914620960315460251877084374}
#define T_256_143 {-0.9329927988347388456702447001589462161064,0.3598950365349881663767916961660375818610}
#define T_256_145 {-0.9142097557035306909511973572080023586750,0.4052413140049898609973411112150643020868}
#define T_256_147 {-0.8932243011955153244585403626842889934778,0.4496113296546065951631021562207024544477}
#define T_256_149 {-0.8700869911087114605408032730338163673878,0.4928981922297840378988098564150277525187}
#define T_256_151 {-0.8448535652497071168909315019845962524414,0.5349976198870972643462096129951532930136}
#define T_256_153 {-0.8175848131515837113880706965574063360691,0.5758081914178453386554679127584677189589}
#define T_256_155 {-0.7883464276266062276121715512999799102545,0.6152315905806268192534957961470354348421}
#define T_256_157 {-0.7572088465064845674845628309412859380245,0.6531728429537767555146388076536823064089}
#define T_256_159 {-0.7242470829514668917425979088875465095043,0.6895405447370669405060539247642736881971}
#define T_256_161 {-0.6895405447370669405060539247642736881971,0.7242470829514668917425979088875465095043}
#define T_256_163 {-0.6531728429537767555146388076536823064089,0.7572088465064845674845628309412859380245}
#define T_256_165 {-0.6152315905806268192534957961470354348421,0.7883464276266062276121715512999799102545}
#define T_256_167 {-0.5758081914178453386554679127584677189589,0.8175848131515837113880706965574063360691}
#define T_256_169 {-0.5349976198870972643462096129951532930136,0.8448535652497071168909315019845962524414}
#define T_256_171 {-0.4928981922297840378988098564150277525187,0.8700869911087114605408032730338163673878}
#define T_256_173 {-0.4496113296546065951631021562207024544477,0.8932243011955153244585403626842889934778}
#define T_256_175 {-0.4052413140049898609973411112150643020868,0.9142097557035306909511973572080023586750}
#define T_256_177 {-0.3598950365349881663767916961660375818610,0.9329927988347388456702447001589462161064}
#define T_256_179 {-0.3136817403988914620960315460251877084374,0.9495281805930366747503512669936753809452}
#define T_256_181 {-0.2667127574748983653840639362897491082549,0.9637760657954398402225137942878063768148}
#define T_256_183 {-0.2191012401568697975928756704888655804098,0.9757021300385285700329518476792145520449}
#define T_256_185 {-0.1709618887603012171716443390323547646403,0.9852776423889412216183814052783418446779}
#define T_256_187 {-0.1224106751992161956632543251544120721519,0.9924795345987099670637121562322136014700}
#define T_256_189 {-0.0735645635996674263079597722025937400758,0.9972904566786902069708276030723936855793}
#define T_256_191 {-0.0245412285229122881236030195850617019460,0.9996988186962042499672520534659270197153}
#define T_256_193 {0.0245412285229122881236030195850617019460,0.9996988186962042499672520534659270197153}
#define T_256_195 {0.0735645635996674263079597722025937400758,0.9972904566786902069708276030723936855793}
#define T_256_197 {0.1224106751992161956632543251544120721519,0.9924795345987099670637121562322136014700}
#define T_256_199 {0.1709618887603012171716443390323547646403,0.9852776423889412216183814052783418446779}
#define T_256_201 {0.2191012401568697975928756704888655804098,0.9757021300385285700329518476792145520449}
#define T_256_203 {0.2667127574748983653840639362897491082549,0.9637760657954398402225137942878063768148}
#define T_256_205 {0.3136817403988914620960315460251877084374,0.9495281805930366747503512669936753809452}
#define T_256_207 {0.3598950365349881663767916961660375818610,0.9329927988347388456702447001589462161064}
#define T_256_209 {0.4052413140049898609973411112150643020868,0.9142097557035306909511973572080023586750}
#define T_256_211 {0.4496113296546065951631021562207024544477,0.8932243011955153244585403626842889934778}
#define T_256_213 {0.4928981922297840378988098564150277525187,0.8700869911087114605408032730338163673878}
#define T_256_215 {0.5349976198870972643462096129951532930136,0.8448535652497071168909315019845962524414}
#define T_256_217 {0.5758081914178453386554679127584677189589,0.8175848131515837113880706965574063360691}
#define T_256_219 {0.6152315905806268192534957961470354348421,0.7883464276266062276121715512999799102545}
#define T_256_221 {0.6531728429537767555146388076536823064089,0.7572088465064845674845628309412859380245}
#define T_256_223 {0.6895405447370669405060539247642736881971,0.7242470829514668917425979088875465095043}
#define T_256_225 {0.7242470829514668917425979088875465095043,0.6895405447370669405060539247642736881971}
#define T_256_227 {0.7572088465064845674845628309412859380245,0.6531728429537767555146388076536823064089}
#define T_256_229 {0.7883464276266062276121715512999799102545,0.6152315905806268192534957961470354348421}
#define T_256_231 {0.8175848131515837113880706965574063360691,0.5758081914178453386554679127584677189589}
#define T_256_233 {0.8448535652497071168909315019845962524414,0.5349976198870972643462096129951532930136}
#define T_256_235 {0.8700869911087114605408032730338163673878,0.4928981922297840378988098564150277525187}
#define T_256_237 {0.8932243011955153244585403626842889934778,0.4496113296546065951631021562207024544477}
#define T_256_239 {0.9142097557035306909511973572080023586750,0.4052413140049898609973411112150643020868}
#define T_256_241 {0.9329927988347388456702447001589462161064,0.3598950365349881663767916961660375818610}
#define T_256_243 {0.9495281805930366747503512669936753809452,0.3136817403988914620960315460251877084374}
#define T_256_245 {0.9637760657954398402225137942878063768148,0.2667127574748983653840639362897491082549}
#define T_256_247 {0.9757021300385285700329518476792145520449,0.2191012401568697975928756704888655804098}
#define T_256_249 {0.9852776423889412216183814052783418446779,0.1709618887603012171716443390323547646403}
#define T_256_251 {0.9924795345987099670637121562322136014700,0.1224106751992161956632543251544120721519}
#define T_256_253 {0.9972904566786902069708276030723936855793,0.0735645635996674263079597722025937400758}
#define T_256_255 {0.9996988186962042499672520534659270197153,0.0245412285229122881236030195850617019460}
// Pre-computed twiddles for N=288
#define T_288_1 {0.9997620270799091324320784224255476146936,-0.0218148850345611204637474855871914769523}
#define T_288_5 {0.9940563382223196464693160123715642839670,-0.1088668748519645707029113168573530856520}
#define T_288_7 {0.9883615104677606622018970483622979372740,-0.1521233861899166928122184572202968411148}
#define T_288_11 {0.9713420698132614328201839271059725433588,-0.2376858923261730982545714141451753675938}
#define T_288_13 {0.9600498543859287137181013349618297070265,-0.2798290140309920293049117390182800590992}
#define T_288_17 {0.9320078692827985511470956225821282714605,-0.3624380382837016356667447780637303367257}
#define T_288_19 {0.9153114791194471022706125040713232010603,-0.4027466898587372390316829751100158318877}
#define T_288_23 {0.8767267557075076878092545484832953661680,-0.4809887689193876325610688127198955044150}
#define T_288_25 {0.8549118706729466055094235343858599662781,-0.5187732581605214443598583784478250890970}
#define T_288_35 {0.7223639620597556154635299208166543394327,-0.6915130557822694035152721880876924842596}
#define T_288_49 {0.4809887689193876325610688127198955044150,-0.8767267557075076878092545484832953661680}
#define T_288_77 {-0.1088668748519645707029113168573530856520,-0.9940563382223196464693160123715642839670}
#define T_288_91 {-0.4027466898587372390316829751100158318877,-0.9153114791194471022706125040713232010603}
#define T_288_119 {-0.8549118706729466055094235343858599662781,-0.5187732581605214443598583784478250890970}
#define T_288_133 {-0.9713420698132614328201839271059725433588,-0.2376858923261730982545714141451753675938}
#define T_288_161 {-0.9320078692827985511470956225821282714605,0.3624380382837016356667447780637303367257}
// Pre-computed twiddles for N=324
#define T_324_1 {0.9998119704485014525019437314767856150866,-0.0193913317718243730092275711740512633696}
#define T_324_5 {0.9953027957931658287193954492977354675531,-0.0968108707031790916008873182363458909094}
#define T_324_7 {0.9908004033648453168225955778325442224741,-0.1353312997501311121251177382873720489442}
#define T_324_11 {0.9773338582506355676216003303125035017729,-0.2117038722294107555566000655744574032724}
#define T_324_13 {0.9683899605278059041779670224059373140335,-0.2494411440579812899720479890675051137805}
#define T_324_17 {0.9461481568757503790578766711405478417873,-0.3237339420583210114479300045786658301950}
#define T_324_19 {0.9328837047320005515516072591708507388830,-0.3601777248047104418304797945893369615078}
#define T_324_23 {0.9021674247810377300638151609746273607016,-0.4313860656812534277726456366508500650525}
#define T_324_25 {0.8847617971766578159886762477981392294168,-0.4660435197025388220914976500353077426553}
#define T_324_29 {0.8459864259198410785245414444943889975548,-0.5332044328016912748680056211014743894339}
#define T_324_31 {0.8246750041091067684462245779286604374647,-0.5656068754865386516428316099336370825768}
#define T_324_35 {0.7783649119241600189411656174343079328537,-0.6278121246720985704214967881853226572275}
#define T_324_37 {0.7534358963276607257242289961141068488359,-0.6575213685690636244984830227622296661139}
#define T_324_41 {0.7002173477671684853618216948234476149082,-0.7139297345578989872905140146031044423580}
#define T_324_43 {0.6720078605555224182666052001877687871456,-0.7405440131090045285944256647781003266573}
#define T_324_47 {0.6126005451932028389450124450377188622952,-0.7903926695187593054470198694616556167603}
#define T_324_49 {0.5814920712880267128497280282317660748959,-0.8135520702629676081940601761743891984224}
#define T_324_53 {0.5166993711518629295298410397663246840239,-0.8561668995302664786350987924379296600819}
#define T_324_55 {0.4831125992966384674609514604526339098811,-0.8755582313020908724610080753336660563946}
#define T_324_59 {0.4138107245051391713808186523237964138389,-0.9103629409661466720393718787818215787411}
#define T_324_61 {0.3781998581716424778775831327948253601789,-0.9257239692688904453277132233779411762953}
#define T_324_65 {0.3053259976951130938438438988669076934457,-0.9522478853384153119066013459814712405205}
#define T_324_67 {0.2681726127606373633049940963246626779437,-0.9633708786158803327737132349284365773201}
#define T_324_71 {0.1927122605480896810892232906553545035422,-0.9812553106273846914575642585987225174904}
#define T_324_73 {0.1545187928078404770992904104787157848477,-0.9879898494768090122519765827746596187353}
#define T_324_77 {0.0774924206719309477398027752315101679415,-0.9969929411677920239043260153266601264477}
#define T_324_79 {0.0387753712568167097085591876748367212713,-0.9992479525042300414483520398789551109076}
#define T_324_83 {-0.0387753712568167097085591876748367212713,-0.9992479525042300414483520398789551109076}
#define T_324_85 {-0.0774924206719309477398027752315101679415,-0.9969929411677920239043260153266601264477}
#define T_324_89 {-0.1545187928078404770992904104787157848477,-0.9879898494768090122519765827746596187353}
#define T_324_91 {-0.1927122605480896810892232906553545035422,-0.9812553106273846914575642585987225174904}
#define T_324_95 {-0.2681726127606373633049940963246626779437,-0.9633708786158803327737132349284365773201}
#define T_324_97 {-0.3053259976951130938438438988669076934457,-0.9522478853384153119066013459814712405205}
#define T_324_101 {-0.3781998581716424778775831327948253601789,-0.9257239692688904453277132233779411762953}
#define T_324_103 {-0.4138107245051391713808186523237964138389,-0.9103629409661466720393718787818215787411}
#define T_324_107 {-0.4831125992966384674609514604526339098811,-0.8755582313020908724610080753336660563946}
#define T_324_109 {-0.5166993711518629295298410397663246840239,-0.8561668995302664786350987924379296600819}
#define T_324_113 {-0.5814920712880267128497280282317660748959,-0.8135520702629676081940601761743891984224}
#define T_324_115 {-0.6126005451932028389450124450377188622952,-0.7903926695187593054470198694616556167603}
#define T_324_119 {-0.6720078605555224182666052001877687871456,-0.7405440131090045285944256647781003266573}
#define T_324_121 {-0.7002173477671684853618216948234476149082,-0.7139297345578989872905140146031044423580}
#define T_324_125 {-0.7534358963276607257242289961141068488359,-0.6575213685690636244984830227622296661139}
#define T_324_127 {-0.7783649119241600189411656174343079328537,-0.6278121246720985704214967881853226572275}
#define T_324_131 {-0.8246750041091067684462245779286604374647,-0.5656068754865386516428316099336370825768}
#define T_324_133 {-0.8459864259198410785245414444943889975548,-0.5332044328016912748680056211014743894339}
#define T_324_137 {-0.8847617971766578159886762477981392294168,-0.4660435197025388220914976500353077426553}
#define T_324_139 {-0.9021674247810377300638151609746273607016,-0.4313860656812534277726456366508500650525}
#define T_324_143 {-0.9328837047320005515516072591708507388830,-0.3601777248047104418304797945893369615078}
#define T_324_145 {-0.9461481568757503790578766711405478417873,-0.3237339420583210114479300045786658301950}
#define T_324_149 {-0.9683899605278059041779670224059373140335,-0.2494411440579812899720479890675051137805}
#define T_324_151 {-0.9773338582506355676216003303125035017729,-0.2117038722294107555566000655744574032724}
#define T_324_155 {-0.9908004033648453168225955778325442224741,-0.1353312997501311121251177382873720489442}
#define T_324_157 {-0.9953027957931658287193954492977354675531,-0.0968108707031790916008873182363458909094}
#define T_324_161 {-0.9998119704485014525019437314767856150866,-0.0193913317718243730092275711740512633696}
#define T_324_163 {-0.9998119704485014525019437314767856150866,0.0193913317718243730092275711740512633696}
#define T_324_167 {-0.9953027957931658287193954492977354675531,0.0968108707031790916008873182363458909094}
#define T_324_169 {-0.9908004033648453168225955778325442224741,0.1353312997501311121251177382873720489442}
#define T_324_173 {-0.9773338582506355676216003303125035017729,0.2117038722294107555566000655744574032724}
#define T_324_175 {-0.9683899605278059041779670224059373140335,0.2494411440579812899720479890675051137805}
#define T_324_179 {-0.9461481568757503790578766711405478417873,0.3237339420583210114479300045786658301950}
#define T_324_181 {-0.9328837047320005515516072591708507388830,0.3601777248047104418304797945893369615078}
#define T_324_185 {-0.9021674247810377300638151609746273607016,0.4313860656812534277726456366508500650525}
#define T_324_187 {-0.8847617971766578159886762477981392294168,0.4660435197025388220914976500353077426553}
#define T_324_191 {-0.8459864259198410785245414444943889975548,0.5332044328016912748680056211014743894339}
#define T_324_193 {-0.8246750041091067684462245779286604374647,0.5656068754865386516428316099336370825768}
#define T_324_197 {-0.7783649119241600189411656174343079328537,0.6278121246720985704214967881853226572275}
#define T_324_199 {-0.7534358963276607257242289961141068488359,0.6575213685690636244984830227622296661139}
#define T_324_203 {-0.7002173477671684853618216948234476149082,0.7139297345578989872905140146031044423580}
#define T_324_205 {-0.6720078605555224182666052001877687871456,0.7405440131090045285944256647781003266573}
#define T_324_209 {-0.6126005451932028389450124450377188622952,0.7903926695187593054470198694616556167603}
#define T_324_211 {-0.5814920712880267128497280282317660748959,0.8135520702629676081940601761743891984224}
#define T_324_215 {-0.5166993711518629295298410397663246840239,0.8561668995302664786350987924379296600819}
// Pre-computed twiddles for N=343
#define T_343_1 {0.9998322241852237723946927872020751237869,-0.0183173000419952144990354270248644752428}
#define T_343_2 {0.9993289530383430152582491245993878692389,-0.0366284536841123345429771518411143915728}
#define T_343_3 {0.9984903554328112829097108260612003505230,-0.0549273165889077666368400798546645091847}
#define T_343_4 {0.9973167127614216420639081661647651344538,-0.0732077485431148339278806247421016450971}
#define T_343_5 {0.9958084188418849791446518793236464262009,-0.0914636155180024029709429100876150187105}
#define T_343_6 {0.9939659797846838173995820397976785898209,-0.1096887917276581358994036463627708144486}
#define T_343_8 {0.9892812511064961178419707721332088112831,-0.1460226222513681115788841680114273913205}
#define T_343_9 {0.9864405334538516312292699694808106869459,-0.1641190846893822163909959499505930580199}
#define T_343_10 {0.9832688140727500192284082913829479366541,-0.1821604767010881475997052802995312958956}
#define T_343_11 {0.9797671572387982585894405929138883948326,-0.2001407444679969560574761544557986781001}
#define T_343_12 {0.9759367379386528762452712726371828466654,-0.2180538546819596745773850443583796732128}
#define T_343_13 {0.9717788414757521087139480187033768743277,-0.2358937965696536742665756491987849585712}
#define T_343_15 {0.9624863072347562553687794206780381500721,-0.2713302570403868241299960573087446391582}
#define T_343_16 {0.9573547875816684760152952549105975776911,-0.2889148848613694031683962748502381145954}
#define T_343_17 {0.9519020259695478713979355234187096357346,-0.3064025668219348408349844703479902818799}
#define T_343_18 {0.9461298520814387380539756122743710875511,-0.3237874349019040920438783359713852405548}
#define T_343_19 {0.9400402027796954662619555165292695164680,-0.3410636555804633651689528051065281033516}
#define T_343_20 {0.9336351214560646427642609523900318890810,-0.3582254317936114929032953568821540102363}
#define T_343_22 {0.9198873648075919229327723769529256969690,-0.3921826565101322326079014146671397611499}
#define T_343_23 {0.9125493025648960809803611482493579387665,-0.4089667106114160954888347987434826791286}
#define T_343_24 {0.9049050329166776762690460600424557924271,-0.4256135352665215698664269439177587628365}
#define T_343_25 {0.8969571209100737352315491079934872686863,-0.4421175446063087544068537226849002763629}
#define T_343_26 {0.8887082334799096816624341954593546688557,-0.4584732006835495754515363842074293643236}
#define T_343_27 {0.8801611385538047338528144791780505329370,-0.4746750153311948272616405120061244815588}
#define T_343_29 {0.8621838972819457769247719625127501785755,-0.5065954276024560165581078763352707028389}
#define T_343_30 {0.8527597832287951984397977867047302424908,-0.5223033142797182115657506074057891964912}
#define T_343_31 {0.8430495242407655132055310787109192460775,-0.5378359412287532226315533989691175520420}
#define T_343_32 {0.8330563786110832813491811066342052072287,-0.5531880964512770892937965072633232921362}
#define T_343_33 {0.8227836995560490196410796670534182339907,-0.5683546285065876890740810267743654549122}
#define T_343_34 {0.8122349340898594727278236860001925379038,-0.5833304482401391322099470926332287490368}
#define T_343_36 {0.7903233939992904133475803973851725459099,-0.6126899157791340089218579123553354293108}
#define T_343_37 {0.7789679718278943454379259492270648479462,-0.6270637119674019599457892581995110958815}
#define T_343_38 {0.7673511656841821571006789781677071005106,-0.6412270959052860375138038762088399380445}
#define T_343_39 {0.7554768736063856016116346836497541517019,-0.6551753150462258368236234673531726002693}
#define T_343_40 {0.7433490800325611713716966733045410364866,-0.6689036890425593684383898107626009732485}
#define T_343_41 {0.7309718544636055748142666743660811334848,-0.6824076113160209011709866899764165282249}
#define T_343_43 {0.7054858024368363400569137411366682499647,-0.7087240524774456318368720530997961759567}
#define T_343_44 {0.6923855278653112677034187072422355413437,-0.7215277408406929327000511875667143613100}
#define T_343_45 {0.6790529222016324917277074746380094438791,-0.7340893193947338746241371154610533267260}
#define T_343_46 {0.6654924592233565361354408196348231285810,-0.7464045730814148349452352704247459769249}
#define T_343_47 {0.6517086891659332748005795110657345503569,-0.7584693694972929334241484866652172058821}
#define T_343_48 {0.6377062371958668318683294273796491324902,-0.7702796602802703951340390631230548024178}
#define T_343_52 {0.5796046485099634049120709278213325887918,-0.8148978165547149377090363486786372959614}
#define T_343_60 {0.4543984957848437034044764004647731781006,-0.8907985221297076705582185240928083658218}
#define T_343_64 {0.3879658598892251064604863586282590404153,-0.9216737446409191125695770097081549465656}
#define T_343_68 {0.3194511763119168290536720178351970389485,-0.9476027363578751749884077071328647434711}
#define T_343_72 {0.2492221342051153532004548196709947660565,-0.9684463474154092477164113006438128650188}
#define T_343_76 {0.1776556229537462061607300256582675501704,-0.9840927190224081355651719604793470352888}
#define T_343_80 {0.1051357095705101191152053274890931788832,-0.9944578837603457177607424455345608294010}
#define T_343_88 {-0.0412045616053484248242355647562362719327,-0.9991507314228974534486837910662870854139}
#define T_343_92 {-0.1142395734336983242895868784216872882098,-0.9934532298310205788993698661215603351593}
#define T_343_96 {-0.1866615100829776829893802414517267607152,-0.9824242874916837564569505047984421253204}
#define T_343_100 {-0.2580817138363782348164932045619934797287,-0.9661230920453551807014491714653559029102}
#define T_343_104 {-0.3281169028512835872390951408306136727333,-0.9446371250714643563739514320332091301680}
#define T_343_108 {-0.3963912280698235757192549044702900573611,-0.9180816926119903520486786874243989586830}
#define T_343_116 {-0.5262031062287327864979147307167295366526,-0.8503589189249636248746355704497545957565}
#define T_343_120 {-0.5870440140569427311945105429913382977247,-0.8095550170062020267636171411140821874142}
#define T_343_124 {-0.6447345064623469790276999447087291628122,-0.7644065777953207296846471763274166733027}
#define T_343_128 {-0.6989649831208283314865070678933989256620,-0.7151558937538725624349922327382955700159}
#define T_343_132 {-0.7494444121404670866581909649539738893509,-0.6620672723458165265242314490024000406265}
#define T_343_136 {-0.7959018919058652441478329819801729172468,-0.6054256176118288923504451304324902594090}
#define T_343_144 {-0.8757766556444949168636071590299252420664,-0.4827165311320337770517596709396457299590}
#define T_343_148 {-0.9087652857492778402104249835247173905373,-0.4173076268378441699979930490371771156788}
#define T_343_151 {-0.9303149613070847978590904858720023185015,-0.3667616020907821794416747707145987078547}
#define T_343_152 {-0.9368769592658326983425354228529613465071,-0.3496592100843436967672062110068509355187}
#define T_343_155 {-0.9546684501846829373761238457518629729748,-0.2976712116110247774436459167191060259938}
#define T_343_156 {-0.9599608128045554744645073697029147297144,-0.2801343211383018894089502737188013270497}
#define T_343_159 {-0.9738986397233733161016289159306325018406,-0.2269833464044513360313715111260535195470}
#define T_343_160 {-0.9778929651462107131010270677506923675537,-0.2091060704942636350178730708648799918592}
#define T_343_163 {-0.9879023296787865504597903054673224687576,-0.1550773581643241361138763068083790130913}
#define T_343_164 {-0.9905771820597212284909005575173068791628,-0.1369556365492923810656122896034503355622}
#define T_343_167 {-0.9966043682058220998243314170395024120808,-0.0823391357318874334003666604075988288969}
#define T_343_171 {-0.9999580551666213956707451870897784829140,-0.0091590341951608318649125095589624834247}
#define T_343_172 {-0.9999580551666213956707451870897784829140,0.0091590341951608318649125095589624834247}
#define T_343_176 {-0.9966043682058220998243314170395024120808,0.0823391357318874334003666604075988288969}
#define T_343_180 {-0.9879023296787865504597903054673224687576,0.1550773581643241361138763068083790130913}
#define T_343_184 {-0.9738986397233733161016289159306325018406,0.2269833464044513360313715111260535195470}
#define T_343_188 {-0.9546684501846829373761238457518629729748,0.2976712116110247774436459167191060259938}
#define T_343_192 {-0.9303149613070847978590904858720023185015,0.3667616020907821794416747707145987078547}
// Pre-computed twiddles for N=400
#define T_400_1 {0.9998766324816605877146002967492677271366,-0.0157073173118206753373637951654018252157}
#define T_400_3 {0.9988898749619700145885303754766937345266,-0.0471064507096426582366532898049626965076}
#define T_400_7 {0.9939609554551797065968798960966523736715,-0.1097343110910452695927475019743724260479}
#define T_400_9 {0.9900236577165575369008365669287741184235,-0.1409012319375826660650119492856902070343}
#define T_400_11 {0.9851093261547738677563756937161087989807,-0.1719291002794095524208728420489933341742}
#define T_400_13 {0.9792228106217657490617511939490213990211,-0.2027872953565124924946161399930133484304}
#define T_400_17 {0.9645574184577980769716987197170965373516,-0.2638730499653729189013517952844267711043}
#define T_400_19 {0.9557930147983301205627526542230043560266,-0.2940403252323039451354702578100841492414}
#define T_400_21 {0.9460853588275452974443169296137057244778,-0.3239174181981493982895869976346148177981}
#define T_400_23 {0.9354440308298673789622057483938988298178,-0.3534748437792571418292197904520435258746}
#define T_400_27 {0.9114032766354452919088657836255151778460,-0.4115143586051087654098523671564180403948}
#define T_400_29 {0.8980275757606156483703330195567104965448,-0.4399391698559151353542517881578532978892}
#define T_400_31 {0.8837656300886934657157212313904892653227,-0.4679298142605733956678193408151855692267}
#define T_400_33 {0.8686315144381911990123512623540591448545,-0.4954586684324075451790747592895058915019}
#define T_400_37 {0.8358073613682702740490526593930553644896,-0.5490228179981317957469855173258110880852}
#define T_400_39 {0.8181497174250234039050155843142420053482,-0.5750052520432785696513633411086630076170}
// Pre-computed twiddles for N=432
#define T_432_1 {0.9998942319271074685715916530170943588018,-0.0145438976515826559610111701204004930332}
#define T_432_5 {0.9973569167005722491126107343006879091263,-0.0726579707226106125128595181195123586804}
#define T_432_7 {0.9948217482960330926289316266775131225586,-0.1016350781828018745578390280570602044463}
#define T_432_11 {0.9872291131173740463822241508751176297665,-0.1593068680675225889942225876438897103071}
#define T_432_13 {0.9821780704706306597273623992805369198322,-0.1879527544001118599670263620282639749348}
#define T_432_17 {0.9695878998781159996411815882311202585697,-0.2447433439543237887470183977711712941527}
#define T_432_19 {0.9620594244736132560902319710294250398874,-0.2728399966674610044314874812698690220714}
#define T_432_23 {0.9445675372676047842901425610762089490891,-0.3283171752135610188538805687130661681294}
#define T_432_25 {0.9346189253489883830283702081942465156317,-0.3556507618148764815479978551593376323581}
#define T_432_29 {0.9123584453530141358257310457702260464430,-0.4093923145260925378075000935496063902974}
#define T_432_31 {0.9000654118641211454132644576020538806915,-0.4357548099170793776124810392502695322037}
#define T_432_35 {0.8732057547721957524444746923109050840139,-0.4873517311272423380152929439645959064364}
#define T_432_37 {0.8586618571206131589335086573555599898100,-0.5125425007998651860674499403103254735470}
#define T_432_41 {0.8274074411415105467781927472969982773066,-0.5616021067834928715001296950504183769226}
#define T_432_43 {0.8107233671702123167790432489709928631783,-0.5854294337699404993102803018700797110796}
#define T_432_47 {0.7753120572814657940341476205503568053246,-0.6315783513024976203453775269736070185900}
#define T_432_49 {0.7566147828674928410563893521612044423819,-0.6538608952570696963846330618252977728844}
#define T_432_53 {0.7173160805192894118320623420004267245531,-0.6967479032106550507208453382190782576799}
#define T_432_55 {0.6967479032106550507208453382190782576799,-0.7173160805192894118320623420004267245531}
#define T_432_59 {0.6538608952570696963846330618252977728844,-0.7566147828674928410563893521612044423819}
#define T_432_61 {0.6315783513024976203453775269736070185900,-0.7753120572814657940341476205503568053246}
#define T_432_65 {0.5854294337699404993102803018700797110796,-0.8107233671702123167790432489709928631783}
#define T_432_67 {0.5616021067834928715001296950504183769226,-0.8274074411415105467781927472969982773066}
#define T_432_71 {0.5125425007998651860674499403103254735470,-0.8586618571206131589335086573555599898100}
#define T_432_77 {0.4357548099170793776124810392502695322037,-0.9000654118641211454132644576020538806915}
#define T_432_91 {0.2447433439543237887470183977711712941527,-0.9695878998781159996411815882311202585697}
#define T_432_119 {-0.1593068680675225889942225876438897103071,-0.9872291131173740463822241508751176297665}
#define T_432_133 {-0.3556507618148764815479978551593376323581,-0.9346189253489883830283702081942465156317}
#define T_432_161 {-0.6967479032106550507208453382190782576799,-0.7173160805192894118320623420004267245531}
#define T_432_175 {-0.8274074411415105467781927472969982773066,-0.5616021067834928715001296950504183769226}
#define T_432_203 {-0.9821780704706306597273623992805369198322,-0.1879527544001118599670263620282639749348}
#define T_432_217 {-0.9998942319271074685715916530170943588018,0.0145438976515826559610111701204004930332}
#define T_432_245 {-0.9123584453530141358257310457702260464430,0.4093923145260925378075000935496063902974}
// Pre-computed twiddles for N=500
#define T_500_1 {0.9999210442038161117395134169782977551222,-0.0125660398833526074091615498673490947112}
#define T_500_3 {0.9992894726405892047438328518182970583439,-0.0376901826699345410265351574707892723382}
#define T_500_7 {0.9961336091431725048295220403815619647503,-0.0878511965507431796806869783722504507750}
#define T_500_9 {0.9936113105200083950307998748030513525009,-0.1128563848734816937868785657883563544601}
#define T_500_11 {0.9904614256966511876001391101453918963671,-0.1377902906846380504113369624974438920617}
#define T_500_13 {0.9866859442078680375587396156333852559328,-0.1626371651948836094536687824074761010706}
#define T_500_17 {0.9772681235681934808212645293679088354111,-0.2120071099220546539942944264112156815827}
#define T_500_19 {0.9716317329146739734113680242444388568401,-0.2364989970237246774686923345143441110849}
#define T_500_21 {0.9653816388332738807065425135078839957714,-0.2608415062898969405402738175325794145465}
#define T_500_23 {0.9585217890173758359395606021280400454998,-0.2850192624699761090312222222564741969109}
#define T_500_27 {0.9429905358928645231486598277115263044834,-0.3328195445229866211711566847952781245112}
#define T_500_29 {0.9343289424566120215942532922781538218260,-0.3564118787132506960269040519051486626267}
#define T_500_31 {0.9250772068344580434384738509834278374910,-0.3797790955218011132998867651622276753187}
#define T_500_33 {0.9152411726209175313329069467727094888687,-0.4029064357136626361999276468850439414382}
#define T_500_37 {0.8938414241512637747888447847799398005009,-0.4483832160900322327812261846702313050628}
#define T_500_39 {0.8822912264349532796003927614947315305471,-0.4707039321653325725236527432571165263653}
#define T_500_41 {0.8701837546695256886408742502680979669094,-0.4927273415482915641661065819789655506611}
#define T_500_43 {0.8575266561936522036191377083014231175184,-0.5144395337815064195297054538968950510025}
#define T_500_47 {0.8305958991958126702570552879478782415390,-0.5568756164881879522354779510351363569498}
#define T_500_49 {0.8163392507171839396207246863923501223326,-0.5775727034222676303798493790964130312204}
#define T_500_51 {0.8015669848708765199418735392100643366575,-0.5979049830575188240189277166791725903749}
#define T_500_57 {0.7542513807361037603271824991679750382900,-0.6565857557529564125786691874964162707329}
#define T_500_63 {0.7026499697988491943689837171405088156462,-0.7115356772092853443467674878775142133236}
#define T_500_69 {0.6470559615694443378330902305606286972761,-0.7624425110114478876255361683433875441551}
#define T_500_81 {0.5251746299612957136204727248696144670248,-0.8509944817946918371731612751318607479334}
#define T_500_87 {0.4595798606214878678777324694237904623151,-0.8881364488135444767991089065617416054010}
#define T_500_93 {0.3913736668372024274376030916755553334951,-0.9202318473658703812390058374148793518543}
#define T_500_99 {0.3209436098072094845079504921159241348505,-0.9470983049947442333760250221530441194773}
#define T_500_111 {0.1750230589752760357313832173531409353018,-0.9845643345292053316697433729132171720266}
#define T_500_117 {0.1003617148512148948835687178871012292802,-0.9949510169813001736471846925269346684217}
#define T_500_123 {0.0251300954433374794383393435737161780708,-0.9996841892832999398876836494309827685356}
#define T_500_129 {-0.0502443181797695564982930704900354612619,-0.9987369566060174674859695187478791922331}
#define T_500_141 {-0.1997099805144070261420097267546225339174,-0.9798550523842468606972033740021288394928}
#define T_500_147 {-0.2729519355173252170843056774174328893423,-0.9620276715860859306772567833831999450922}
#define T_500_153 {-0.3446429231745170573830705507134553045034,-0.9387338576538740708699037895712535828352}
#define T_500_159 {-0.4143755809932841427389860200491966679692,-0.9101059706849956576490967563586309552193}
#define T_500_171 {-0.5463943467342691207022653543390333652496,-0.8375280400421417636991350263997446745634}
#define T_500_177 {-0.6079302976946053815865411706909071654081,-0.7939903986478353825617659822455607354641}
#define T_500_183 {-0.6660118674342516698061444913037121295929,-0.7459411454241821060051620406738948076963}
#define T_500_189 {-0.7203090248879069346088499514735303819180,-0.6936533058128049322732522341539151966572}
#define T_500_201 {-0.8163392507171839396207246863923501223326,-0.5775727034222676303798493790964130312204}
#define T_500_207 {-0.8575266561936522036191377083014231175184,-0.5144395337815064195297054538968950510025}
#define T_500_213 {-0.8938414241512637747888447847799398005009,-0.4483832160900322327812261846702313050628}
#define T_500_219 {-0.9250772068344580434384738509834278374910,-0.3797790955218011132998867651622276753187}
#define T_500_231 {-0.9716317329146739734113680242444388568401,-0.2364989970237246774686923345143441110849}
#define T_500_237 {-0.9866859442078680375587396156333852559328,-0.1626371651948836094536687824074761010706}
#define T_500_243 {-0.9961336091431725048295220403815619647503,-0.0878511965507431796806869783722504507750}
#define T_500_249 {-0.9999210442038161117395134169782977551222,-0.0125660398833526074091615498673490947112}
#define T_500_261 {-0.9904614256966511876001391101453918963671,0.1377902906846380504113369624974438920617}
#define T_500_267 {-0.9772681235681934808212645293679088354111,0.2120071099220546539942944264112156815827}
#define T_500_273 {-0.9585217890173758359395606021280400454998,0.2850192624699761090312222222564741969109}
#define T_500_279 {-0.9343289424566120215942532922781538218260,0.3564118787132506960269040519051486626267}
#define T_500_291 {-0.8701837546695256886408742502680979669094,0.4927273415482915641661065819789655506611}
#define T_500_297 {-0.8305958991958126702570552879478782415390,0.5568756164881879522354779510351363569498}
// Pre-computed twiddles for N=512
#define T_512_1 {0.9999247018391445029905639785283710807562,-0.0122715382857199253874291855481715174392}
#define T_512_3 {0.9993223845883495437547594519855920225382,-0.0368072229413588317137318028926529223099}
#define T_512_5 {0.9981181129001491791896683025697711855173,-0.0613207363022085782944259335636161267757}
#define T_512_7 {0.9963126121827780012907282980449963361025,-0.0857973123444398938497457152152492199093}
#define T_512_9 {0.9939069700023560605117722843715455383062,-0.1102222072938830593757941755939100403339}
#define T_512_11 {0.9909026354277800097136719159607309848070,-0.1345807085071261954833943264020490460098}
#define T_512_13 {0.9873014181578584347320770575606729835272,-0.1588581433338614457007054170389892533422}
#define T_512_15 {0.9831054874312162850102936317853163927794,-0.1830398879551409507815407096131821162999}
#define T_512_17 {0.9783173707196276547293223302403930574656,-0.2071113761922185603214785487580229528248}
#define T_512_19 {0.9729399522055601767789312361855991184711,-0.2310581082806711095134488687108387239277}
#define T_512_21 {0.9669764710448520705909913885989226400852,-0.2548656596045145716900037768937181681395}
#define T_512_23 {0.9604305194155657865451303223380818963051,-0.2785196893850531152381222455005627125502}
#define T_512_25 {0.9533060403541938621074791626597288995981,-0.3020059493192280841711294669948983937502}
#define T_512_27 {0.9456073253805212797118429080001078546047,-0.3253102921622629262188297616376075893641}
#define T_512_29 {0.9373390119125749597728258777351584285498,-0.3484186802494345647218665362743195146322}
#define T_512_31 {0.9285060804732155892438072442018892616034,-0.3713171939518375430644425705395406112075}
#define T_512_33 {0.9191138516900577704049624117033090442419,-0.3939920400610480988312644967663800343871}
#define T_512_35 {0.9091679830905223802517411968437954783440,-0.4164295600976372080381793239212129265070}
#define T_512_37 {0.8986744656939538167250702827004715800285,-0.4386162385385276585303415686212247237563}
#define T_512_39 {0.8876396204028539349550896986329462379217,-0.4605387109582400051444039945636177435517}
#define T_512_41 {0.8760700941954066012229418447532225400209,-0.4821837720791227743788454063178505748510}
#define T_512_43 {0.8639728561215866964317910969839431345463,-0.5035383837257175754231752762279938906431}
#define T_512_45 {0.8513551931052651955411647577420808374882,-0.5245896826784689492839675040158908814192}
#define T_512_47 {0.8382247055548380787470819086593110114336,-0.5453249884220464638318048855580855160952}
#define T_512_49 {0.8245893027850252909871642259531654417515,-0.5657318107836132314858446079597342759371}
#define T_512_51 {0.8104571982525947682063360844040289521217,-0.5857978574564388640766310345497913658619}
#define T_512_53 {0.7958369046088835663255167673924006521702,-0.6055110414043255451232994346355553716421}
#define T_512_55 {0.7807372285720944882214666904474142938852,-0.6248594881423863434122267790371552109718}
#define T_512_57 {0.7651672656224589585960416115995030850172,-0.6438315428897914971528848582238424569368}
#define T_512_59 {0.7491363945234593701982817037787754088640,-0.6624157775901717837285787027212791144848}
#define T_512_61 {0.7326542716724128156968731673259753733873,-0.6806009977954530221211371099343523383141}
#define T_512_63 {0.7157308252838187057065510998654644936323,-0.6983762494089728045665310673939529806376}
#define T_512_65 {0.6983762494089728045665310673939529806376,-0.7157308252838187057065510998654644936323}
#define T_512_67 {0.6806009977954530221211371099343523383141,-0.7326542716724128156968731673259753733873}
#define T_512_69 {0.6624157775901717837285787027212791144848,-0.7491363945234593701982817037787754088640}
#define T_512_71 {0.6438315428897914971528848582238424569368,-0.7651672656224589585960416115995030850172}
#define T_512_73 {0.6248594881423863434122267790371552109718,-0.7807372285720944882214666904474142938852}
#define T_512_75 {0.6055110414043255451232994346355553716421,-0.7958369046088835663255167673924006521702}
#define T_512_77 {0.5857978574564388640766310345497913658619,-0.8104571982525947682063360844040289521217}
#define T_512_79 {0.5657318107836132314858446079597342759371,-0.8245893027850252909871642259531654417515}
#define T_512_81 {0.5453249884220464638318048855580855160952,-0.8382247055548380787470819086593110114336}
#define T_512_83 {0.5245896826784689492839675040158908814192,-0.8513551931052651955411647577420808374882}
#define T_512_85 {0.5035383837257175754231752762279938906431,-0.8639728561215866964317910969839431345463}
#define T_512_87 {0.4821837720791227743788454063178505748510,-0.8760700941954066012229418447532225400209}
#define T_512_89 {0.4605387109582400051444039945636177435517,-0.8876396204028539349550896986329462379217}
#define T_512_91 {0.4386162385385276585303415686212247237563,-0.8986744656939538167250702827004715800285}
#define T_512_93 {0.4164295600976372080381793239212129265070,-0.9091679830905223802517411968437954783440}
#define T_512_95 {0.3939920400610480988312644967663800343871,-0.9191138516900577704049624117033090442419}
#define T_512_97 {0.3713171939518375430644425705395406112075,-0.9285060804732155892438072442018892616034}
#define T_512_99 {0.3484186802494345647218665362743195146322,-0.9373390119125749597728258777351584285498}
#define T_512_101 {0.3253102921622629262188297616376075893641,-0.9456073253805212797118429080001078546047}
#define T_512_103 {0.3020059493192280841711294669948983937502,-0.9533060403541938621074791626597288995981}
#define T_512_105 {0.2785196893850531152381222455005627125502,-0.9604305194155657865451303223380818963051}
#define T_512_107 {0.2548656596045145716900037768937181681395,-0.9669764710448520705909913885989226400852}
#define T_512_109 {0.2310581082806711095134488687108387239277,-0.9729399522055601767789312361855991184711}
#define T_512_111 {0.2071113761922185603214785487580229528248,-0.9783173707196276547293223302403930574656}
#define T_512_113 {0.1830398879551409507815407096131821162999,-0.9831054874312162850102936317853163927794}
#define T_512_115 {0.1588581433338614457007054170389892533422,-0.9873014181578584347320770575606729835272}
#define T_512_117 {0.1345807085071261954833943264020490460098,-0.9909026354277800097136719159607309848070}
#define T_512_119 {0.1102222072938830593757941755939100403339,-0.9939069700023560605117722843715455383062}
#define T_512_121 {0.0857973123444398938497457152152492199093,-0.9963126121827780012907282980449963361025}
#define T_512_123 {0.0613207363022085782944259335636161267757,-0.9981181129001491791896683025697711855173}
#define T_512_125 {0.0368072229413588317137318028926529223099,-0.9993223845883495437547594519855920225382}
#define T_512_127 {0.0122715382857199253874291855481715174392,-0.9999247018391445029905639785283710807562}
#define T_512_129 {-0.0122715382857199253874291855481715174392,-0.9999247018391445029905639785283710807562}
#define T_512_131 {-0.0368072229413588317137318028926529223099,-0.9993223845883495437547594519855920225382}
#define T_512_133 {-0.0613207363022085782944259335636161267757,-0.9981181129001491791896683025697711855173}
#define T_512_135 {-0.0857973123444398938497457152152492199093,-0.9963126121827780012907282980449963361025}
#define T_512_137 {-0.1102222072938830593757941755939100403339,-0.9939069700023560605117722843715455383062}
#define T_512_139 {-0.1345807085071261954833943264020490460098,-0.9909026354277800097136719159607309848070}
#define T_512_141 {-0.1588581433338614457007054170389892533422,-0.9873014181578584347320770575606729835272}
#define T_512_143 {-0.1830398879551409507815407096131821162999,-0.9831054874312162850102936317853163927794}
#define T_512_145 {-0.2071113761922185603214785487580229528248,-0.9783173707196276547293223302403930574656}
#define T_512_147 {-0.2310581082806711095134488687108387239277,-0.9729399522055601767789312361855991184711}
#define T_512_149 {-0.2548656596045145716900037768937181681395,-0.9669764710448520705909913885989226400852}
#define T_512_151 {-0.2785196893850531152381222455005627125502,-0.9604305194155657865451303223380818963051}
#define T_512_153 {-0.3020059493192280841711294669948983937502,-0.9533060403541938621074791626597288995981}
#define T_512_155 {-0.3253102921622629262188297616376075893641,-0.9456073253805212797118429080001078546047}
#define T_512_157 {-0.3484186802494345647218665362743195146322,-0.9373390119125749597728258777351584285498}
#define T_512_159 {-0.3713171939518375430644425705395406112075,-0.9285060804732155892438072442018892616034}
#define T_512_161 {-0.3939920400610480988312644967663800343871,-0.9191138516900577704049624117033090442419}
#define T_512_163 {-0.4164295600976372080381793239212129265070,-0.9091679830905223802517411968437954783440}
#define T_512_165 {-0.4386162385385276585303415686212247237563,-0.8986744656939538167250702827004715800285}
#define T_512_167 {-0.4605387109582400051444039945636177435517,-0.8876396204028539349550896986329462379217}
#define T_512_169 {-0.4821837720791227743788454063178505748510,-0.8760700941954066012229418447532225400209}
#define T_512_171 {-0.5035383837257175754231752762279938906431,-0.8639728561215866964317910969839431345463}
#define T_512_173 {-0.5245896826784689492839675040158908814192,-0.8513551931052651955411647577420808374882}
#define T_512_175 {-0.5453249884220464638318048855580855160952,-0.8382247055548380787470819086593110114336}
#define T_512_177 {-0.5657318107836132314858446079597342759371,-0.8245893027850252909871642259531654417515}
#define T_512_179 {-0.5857978574564388640766310345497913658619,-0.8104571982525947682063360844040289521217}
#define T_512_181 {-0.6055110414043255451232994346355553716421,-0.7958369046088835663255167673924006521702}
#define T_512_183 {-0.6248594881423863434122267790371552109718,-0.7807372285720944882214666904474142938852}
#define T_512_185 {-0.6438315428897914971528848582238424569368,-0.7651672656224589585960416115995030850172}
#define T_512_187 {-0.6624157775901717837285787027212791144848,-0.7491363945234593701982817037787754088640}
#define T_512_189 {-0.6806009977954530221211371099343523383141,-0.7326542716724128156968731673259753733873}
#define T_512_191 {-0.6983762494089728045665310673939529806376,-0.7157308252838187057065510998654644936323}
#define T_512_193 {-0.7157308252838187057065510998654644936323,-0.6983762494089728045665310673939529806376}
#define T_512_195 {-0.7326542716724128156968731673259753733873,-0.6806009977954530221211371099343523383141}
#define T_512_197 {-0.7491363945234593701982817037787754088640,-0.6624157775901717837285787027212791144848}
#define T_512_199 {-0.7651672656224589585960416115995030850172,-0.6438315428897914971528848582238424569368}
#define T_512_201 {-0.7807372285720944882214666904474142938852,-0.6248594881423863434122267790371552109718}
#define T_512_203 {-0.7958369046088835663255167673924006521702,-0.6055110414043255451232994346355553716421}
#define T_512_205 {-0.8104571982525947682063360844040289521217,-0.5857978574564388640766310345497913658619}
#define T_512_207 {-0.8245893027850252909871642259531654417515,-0.5657318107836132314858446079597342759371}
#define T_512_209 {-0.8382247055548380787470819086593110114336,-0.5453249884220464638318048855580855160952}
#define T_512_211 {-0.8513551931052651955411647577420808374882,-0.5245896826784689492839675040158908814192}
#define T_512_213 {-0.8639728561215866964317910969839431345463,-0.5035383837257175754231752762279938906431}
#define T_512_215 {-0.8760700941954066012229418447532225400209,-0.4821837720791227743788454063178505748510}
#define T_512_217 {-0.8876396204028539349550896986329462379217,-0.4605387109582400051444039945636177435517}
#define T_512_219 {-0.8986744656939538167250702827004715800285,-0.4386162385385276585303415686212247237563}
#define T_512_221 {-0.9091679830905223802517411968437954783440,-0.4164295600976372080381793239212129265070}
#define T_512_223 {-0.9191138516900577704049624117033090442419,-0.3939920400610480988312644967663800343871}
#define T_512_225 {-0.9285060804732155892438072442018892616034,-0.3713171939518375430644425705395406112075}
#define T_512_227 {-0.9373390119125749597728258777351584285498,-0.3484186802494345647218665362743195146322}
#define T_512_229 {-0.9456073253805212797118429080001078546047,-0.3253102921622629262188297616376075893641}
#define T_512_231 {-0.9533060403541938621074791626597288995981,-0.3020059493192280841711294669948983937502}
#define T_512_233 {-0.9604305194155657865451303223380818963051,-0.2785196893850531152381222455005627125502}
#define T_512_235 {-0.9669764710448520705909913885989226400852,-0.2548656596045145716900037768937181681395}
#define T_512_237 {-0.9729399522055601767789312361855991184711,-0.2310581082806711095134488687108387239277}
#define T_512_239 {-0.9783173707196276547293223302403930574656,-0.2071113761922185603214785487580229528248}
#define T_512_241 {-0.9831054874312162850102936317853163927794,-0.1830398879551409507815407096131821162999}
#define T_512_243 {-0.9873014181578584347320770575606729835272,-0.1588581433338614457007054170389892533422}
#define T_512_245 {-0.9909026354277800097136719159607309848070,-0.1345807085071261954833943264020490460098}
#define T_512_247 {-0.9939069700023560605117722843715455383062,-0.1102222072938830593757941755939100403339}
#define T_512_249 {-0.9963126121827780012907282980449963361025,-0.0857973123444398938497457152152492199093}
#define T_512_251 {-0.9981181129001491791896683025697711855173,-0.0613207363022085782944259335636161267757}
#define T_512_253 {-0.9993223845883495437547594519855920225382,-0.0368072229413588317137318028926529223099}
#define T_512_255 {-0.9999247018391445029905639785283710807562,-0.0122715382857199253874291855481715174392}
#define T_512_257 {-0.9999247018391445029905639785283710807562,0.0122715382857199253874291855481715174392}
#define T_512_259 {-0.9993223845883495437547594519855920225382,0.0368072229413588317137318028926529223099}
#define T_512_261 {-0.9981181129001491791896683025697711855173,0.0613207363022085782944259335636161267757}
#define T_512_263 {-0.9963126121827780012907282980449963361025,0.0857973123444398938497457152152492199093}
#define T_512_265 {-0.9939069700023560605117722843715455383062,0.1102222072938830593757941755939100403339}
#define T_512_267 {-0.9909026354277800097136719159607309848070,0.1345807085071261954833943264020490460098}
#define T_512_269 {-0.9873014181578584347320770575606729835272,0.1588581433338614457007054170389892533422}
#define T_512_271 {-0.9831054874312162850102936317853163927794,0.1830398879551409507815407096131821162999}
#define T_512_273 {-0.9783173707196276547293223302403930574656,0.2071113761922185603214785487580229528248}
#define T_512_275 {-0.9729399522055601767789312361855991184711,0.2310581082806711095134488687108387239277}
#define T_512_277 {-0.9669764710448520705909913885989226400852,0.2548656596045145716900037768937181681395}
#define T_512_279 {-0.9604305194155657865451303223380818963051,0.2785196893850531152381222455005627125502}
#define T_512_281 {-0.9533060403541938621074791626597288995981,0.3020059493192280841711294669948983937502}
#define T_512_283 {-0.9456073253805212797118429080001078546047,0.3253102921622629262188297616376075893641}
#define T_512_285 {-0.9373390119125749597728258777351584285498,0.3484186802494345647218665362743195146322}
#define T_512_287 {-0.9285060804732155892438072442018892616034,0.3713171939518375430644425705395406112075}
#define T_512_289 {-0.9191138516900577704049624117033090442419,0.3939920400610480988312644967663800343871}
#define T_512_291 {-0.9091679830905223802517411968437954783440,0.4164295600976372080381793239212129265070}
#define T_512_293 {-0.8986744656939538167250702827004715800285,0.4386162385385276585303415686212247237563}
#define T_512_295 {-0.8876396204028539349550896986329462379217,0.4605387109582400051444039945636177435517}
#define T_512_297 {-0.8760700941954066012229418447532225400209,0.4821837720791227743788454063178505748510}
#define T_512_299 {-0.8639728561215866964317910969839431345463,0.5035383837257175754231752762279938906431}
#define T_512_301 {-0.8513551931052651955411647577420808374882,0.5245896826784689492839675040158908814192}
#define T_512_303 {-0.8382247055548380787470819086593110114336,0.5453249884220464638318048855580855160952}
#define T_512_305 {-0.8245893027850252909871642259531654417515,0.5657318107836132314858446079597342759371}
#define T_512_307 {-0.8104571982525947682063360844040289521217,0.5857978574564388640766310345497913658619}
#define T_512_309 {-0.7958369046088835663255167673924006521702,0.6055110414043255451232994346355553716421}
#define T_512_311 {-0.7807372285720944882214666904474142938852,0.6248594881423863434122267790371552109718}
#define T_512_313 {-0.7651672656224589585960416115995030850172,0.6438315428897914971528848582238424569368}
#define T_512_315 {-0.7491363945234593701982817037787754088640,0.6624157775901717837285787027212791144848}
#define T_512_317 {-0.7326542716724128156968731673259753733873,0.6806009977954530221211371099343523383141}
#define T_512_319 {-0.7157308252838187057065510998654644936323,0.6983762494089728045665310673939529806376}
#define T_512_321 {-0.6983762494089728045665310673939529806376,0.7157308252838187057065510998654644936323}
#define T_512_323 {-0.6806009977954530221211371099343523383141,0.7326542716724128156968731673259753733873}
#define T_512_325 {-0.6624157775901717837285787027212791144848,0.7491363945234593701982817037787754088640}
#define T_512_327 {-0.6438315428897914971528848582238424569368,0.7651672656224589585960416115995030850172}
#define T_512_329 {-0.6248594881423863434122267790371552109718,0.7807372285720944882214666904474142938852}
#define T_512_331 {-0.6055110414043255451232994346355553716421,0.7958369046088835663255167673924006521702}
#define T_512_333 {-0.5857978574564388640766310345497913658619,0.8104571982525947682063360844040289521217}
#define T_512_335 {-0.5657318107836132314858446079597342759371,0.8245893027850252909871642259531654417515}
#define T_512_337 {-0.5453249884220464638318048855580855160952,0.8382247055548380787470819086593110114336}
#define T_512_339 {-0.5245896826784689492839675040158908814192,0.8513551931052651955411647577420808374882}
#define T_512_341 {-0.5035383837257175754231752762279938906431,0.8639728561215866964317910969839431345463}
#define T_512_343 {-0.4821837720791227743788454063178505748510,0.8760700941954066012229418447532225400209}
#define T_512_345 {-0.4605387109582400051444039945636177435517,0.8876396204028539349550896986329462379217}
#define T_512_347 {-0.4386162385385276585303415686212247237563,0.8986744656939538167250702827004715800285}
#define T_512_349 {-0.4164295600976372080381793239212129265070,0.9091679830905223802517411968437954783440}
#define T_512_351 {-0.3939920400610480988312644967663800343871,0.9191138516900577704049624117033090442419}
#define T_512_353 {-0.3713171939518375430644425705395406112075,0.9285060804732155892438072442018892616034}
#define T_512_355 {-0.3484186802494345647218665362743195146322,0.9373390119125749597728258777351584285498}
#define T_512_357 {-0.3253102921622629262188297616376075893641,0.9456073253805212797118429080001078546047}
#define T_512_359 {-0.3020059493192280841711294669948983937502,0.9533060403541938621074791626597288995981}
#define T_512_361 {-0.2785196893850531152381222455005627125502,0.9604305194155657865451303223380818963051}
#define T_512_363 {-0.2548656596045145716900037768937181681395,0.9669764710448520705909913885989226400852}
#define T_512_365 {-0.2310581082806711095134488687108387239277,0.9729399522055601767789312361855991184711}
#define T_512_367 {-0.2071113761922185603214785487580229528248,0.9783173707196276547293223302403930574656}
#define T_512_369 {-0.1830398879551409507815407096131821162999,0.9831054874312162850102936317853163927794}
#define T_512_371 {-0.1588581433338614457007054170389892533422,0.9873014181578584347320770575606729835272}
#define T_512_373 {-0.1345807085071261954833943264020490460098,0.9909026354277800097136719159607309848070}
#define T_512_375 {-0.1102222072938830593757941755939100403339,0.9939069700023560605117722843715455383062}
#define T_512_377 {-0.0857973123444398938497457152152492199093,0.9963126121827780012907282980449963361025}
#define T_512_379 {-0.0613207363022085782944259335636161267757,0.9981181129001491791896683025697711855173}
#define T_512_381 {-0.0368072229413588317137318028926529223099,0.9993223845883495437547594519855920225382}
#define T_512_383 {-0.0122715382857199253874291855481715174392,0.9999247018391445029905639785283710807562}
#define T_512_385 {0.0122715382857199253874291855481715174392,0.9999247018391445029905639785283710807562}
#define T_512_387 {0.0368072229413588317137318028926529223099,0.9993223845883495437547594519855920225382}
#define T_512_389 {0.0613207363022085782944259335636161267757,0.9981181129001491791896683025697711855173}
#define T_512_391 {0.0857973123444398938497457152152492199093,0.9963126121827780012907282980449963361025}
#define T_512_393 {0.1102222072938830593757941755939100403339,0.9939069700023560605117722843715455383062}
#define T_512_395 {0.1345807085071261954833943264020490460098,0.9909026354277800097136719159607309848070}
#define T_512_397 {0.1588581433338614457007054170389892533422,0.9873014181578584347320770575606729835272}
#define T_512_399 {0.1830398879551409507815407096131821162999,0.9831054874312162850102936317853163927794}
#define T_512_401 {0.2071113761922185603214785487580229528248,0.9783173707196276547293223302403930574656}
#define T_512_403 {0.2310581082806711095134488687108387239277,0.9729399522055601767789312361855991184711}
#define T_512_405 {0.2548656596045145716900037768937181681395,0.9669764710448520705909913885989226400852}
#define T_512_407 {0.2785196893850531152381222455005627125502,0.9604305194155657865451303223380818963051}
#define T_512_409 {0.3020059493192280841711294669948983937502,0.9533060403541938621074791626597288995981}
#define T_512_411 {0.3253102921622629262188297616376075893641,0.9456073253805212797118429080001078546047}
#define T_512_413 {0.3484186802494345647218665362743195146322,0.9373390119125749597728258777351584285498}
#define T_512_415 {0.3713171939518375430644425705395406112075,0.9285060804732155892438072442018892616034}
#define T_512_417 {0.3939920400610480988312644967663800343871,0.9191138516900577704049624117033090442419}
#define T_512_419 {0.4164295600976372080381793239212129265070,0.9091679830905223802517411968437954783440}
#define T_512_421 {0.4386162385385276585303415686212247237563,0.8986744656939538167250702827004715800285}
#define T_512_423 {0.4605387109582400051444039945636177435517,0.8876396204028539349550896986329462379217}
#define T_512_425 {0.4821837720791227743788454063178505748510,0.8760700941954066012229418447532225400209}
#define T_512_427 {0.5035383837257175754231752762279938906431,0.8639728561215866964317910969839431345463}
#define T_512_429 {0.5245896826784689492839675040158908814192,0.8513551931052651955411647577420808374882}
#define T_512_431 {0.5453249884220464638318048855580855160952,0.8382247055548380787470819086593110114336}
#define T_512_433 {0.5657318107836132314858446079597342759371,0.8245893027850252909871642259531654417515}
#define T_512_435 {0.5857978574564388640766310345497913658619,0.8104571982525947682063360844040289521217}
#define T_512_437 {0.6055110414043255451232994346355553716421,0.7958369046088835663255167673924006521702}
#define T_512_439 {0.6248594881423863434122267790371552109718,0.7807372285720944882214666904474142938852}
#define T_512_441 {0.6438315428897914971528848582238424569368,0.7651672656224589585960416115995030850172}
#define T_512_443 {0.6624157775901717837285787027212791144848,0.7491363945234593701982817037787754088640}
#define T_512_445 {0.6806009977954530221211371099343523383141,0.7326542716724128156968731673259753733873}
#define T_512_447 {0.6983762494089728045665310673939529806376,0.7157308252838187057065510998654644936323}
#define T_512_449 {0.7157308252838187057065510998654644936323,0.6983762494089728045665310673939529806376}
#define T_512_451 {0.7326542716724128156968731673259753733873,0.6806009977954530221211371099343523383141}
#define T_512_453 {0.7491363945234593701982817037787754088640,0.6624157775901717837285787027212791144848}
#define T_512_455 {0.7651672656224589585960416115995030850172,0.6438315428897914971528848582238424569368}
#define T_512_457 {0.7807372285720944882214666904474142938852,0.6248594881423863434122267790371552109718}
#define T_512_459 {0.7958369046088835663255167673924006521702,0.6055110414043255451232994346355553716421}
#define T_512_461 {0.8104571982525947682063360844040289521217,0.5857978574564388640766310345497913658619}
#define T_512_463 {0.8245893027850252909871642259531654417515,0.5657318107836132314858446079597342759371}
#define T_512_465 {0.8382247055548380787470819086593110114336,0.5453249884220464638318048855580855160952}
#define T_512_467 {0.8513551931052651955411647577420808374882,0.5245896826784689492839675040158908814192}
#define T_512_469 {0.8639728561215866964317910969839431345463,0.5035383837257175754231752762279938906431}
#define T_512_471 {0.8760700941954066012229418447532225400209,0.4821837720791227743788454063178505748510}
#define T_512_473 {0.8876396204028539349550896986329462379217,0.4605387109582400051444039945636177435517}
#define T_512_475 {0.8986744656939538167250702827004715800285,0.4386162385385276585303415686212247237563}
#define T_512_477 {0.9091679830905223802517411968437954783440,0.4164295600976372080381793239212129265070}
#define T_512_479 {0.9191138516900577704049624117033090442419,0.3939920400610480988312644967663800343871}
#define T_512_481 {0.9285060804732155892438072442018892616034,0.3713171939518375430644425705395406112075}
#define T_512_483 {0.9373390119125749597728258777351584285498,0.3484186802494345647218665362743195146322}
#define T_512_485 {0.9456073253805212797118429080001078546047,0.3253102921622629262188297616376075893641}
#define T_512_487 {0.9533060403541938621074791626597288995981,0.3020059493192280841711294669948983937502}
#define T_512_489 {0.9604305194155657865451303223380818963051,0.2785196893850531152381222455005627125502}
#define T_512_491 {0.9669764710448520705909913885989226400852,0.2548656596045145716900037768937181681395}
#define T_512_493 {0.9729399522055601767789312361855991184711,0.2310581082806711095134488687108387239277}
#define T_512_495 {0.9783173707196276547293223302403930574656,0.2071113761922185603214785487580229528248}
#define T_512_497 {0.9831054874312162850102936317853163927794,0.1830398879551409507815407096131821162999}
#define T_512_499 {0.9873014181578584347320770575606729835272,0.1588581433338614457007054170389892533422}
#define T_512_501 {0.9909026354277800097136719159607309848070,0.1345807085071261954833943264020490460098}
#define T_512_503 {0.9939069700023560605117722843715455383062,0.1102222072938830593757941755939100403339}
#define T_512_505 {0.9963126121827780012907282980449963361025,0.0857973123444398938497457152152492199093}
#define T_512_507 {0.9981181129001491791896683025697711855173,0.0613207363022085782944259335636161267757}
#define T_512_509 {0.9993223845883495437547594519855920225382,0.0368072229413588317137318028926529223099}
#define T_512_511 {0.9999247018391445029905639785283710807562,0.0122715382857199253874291855481715174392}
// Pre-computed twiddles for N=576
#define T_576_1 {0.9999405050001497485823165334295481443405,-0.0109080914941823738095738605125006870367}
#define T_576_5 {0.9985129789397630961644836133928038179874,-0.0545145016380063213157214363491220865399}
#define T_576_7 {0.9970861323044666324477702801232226192951,-0.0762839745039523009495496808085590600967}
#define T_576_11 {0.9928096670090550412979268912749830633402,-0.1197036553049625196010197214491199702024}
#define T_576_13 {0.9899620837148078722478317104105371981859,-0.1413331978235674857291570560846594162285}
#define T_576_17 {0.9828549916653012141765088927058968693018,-0.1843802195426633983021957874370855279267}
#define T_576_19 {0.9785988655009383307969983434304594993591,-0.2057772106922348964719304831305635161698}
#define T_576_23 {0.9686915803565930849217124887218233197927,-0.2482672393737162808147189707597135566175}
#define T_576_25 {0.9630451367077627056190181065176147967577,-0.2693400539532260218322790024103596806526}
#define T_576_29 {0.9503800829845611142232542079000268131495,-0.3110911407710909570845103644387563690543}
#define T_576_31 {0.9433675007898252307114717041258700191975,-0.3317495417533520840613903146731900051236}
#define T_576_35 {0.9279989121921845551810292818117886781693,-0.3725829021441029453853843733668327331543}
#define T_576_37 {0.9196502204050922557598823914304375648499,-0.3927384270845740710242921522876713424921}
#define T_576_41 {0.9016439075888160736838017328409478068352,-0.4324792063301661770857720057392725721002}
#define T_576_43 {0.8919948565893142111704605667910072952509,-0.4520455461767197147260333167650969699025}
#define T_576_47 {0.8714279253502613675763655010086949914694,-0.4905235681593079766216192183492239564657}
#define T_576_49 {0.8605198338560789972362385924498084932566,-0.5094169368408417719606973150803241878748}
#define T_576_53 {0.8374803549513079037325269382563419640064,-0.5464674327630434369496015278855338692665}
#define T_576_59 {0.7999465651001297361588626699813175946474,-0.6000712399244809702736347389873117208481}
#define T_576_67 {0.7446028722923262455068993403983768075705,-0.6675077247298474292236392102495301514864}
#define T_576_71 {0.7147778973340463970487235201289877295494,-0.6993515264033670630894334863114636391401}
#define T_576_77 {0.6675077247298474292236392102495301514864,-0.7446028722923262455068993403983768075705}
#define T_576_91 {0.5464674327630434369496015278855338692665,-0.8374803549513079037325269382563419640064}
#define T_576_119 {0.2693400539532260218322790024103596806526,-0.9630451367077627056190181065176147967577}
#define T_576_133 {0.1197036553049625196010197214491199702024,-0.9928096670090550412979268912749830633402}
#define T_576_161 {-0.1843802195426633983021957874370855279267,-0.9828549916653012141765088927058968693018}
#define T_576_175 {-0.3317495417533520840613903146731900051236,-0.9433675007898252307114717041258700191975}
#define T_576_203 {-0.6000712399244809702736347389873117208481,-0.7999465651001297361588626699813175946474}
#define T_576_217 {-0.7147778973340463970487235201289877295494,-0.6993515264033670630894334863114636391401}
#define T_576_245 {-0.8919948565893142111704605667910072952509,-0.4520455461767197147260333167650969699025}
#define T_576_259 {-0.9503800829845611142232542079000268131495,-0.3110911407710909570845103644387563690543}
#define T_576_287 {-0.9999405050001497485823165334295481443405,-0.0109080914941823738095738605125006870367}
#define T_576_301 {-0.9899620837148078722478317104105371981859,0.1413331978235674857291570560846594162285}
#define T_576_329 {-0.9016439075888160736838017328409478068352,0.4324792063301661770857720057392725721002}
// Pre-computed twiddles for N=625
#define T_625_1 {0.9999494680510517818916582655219826847315,-0.0100529271567306524581830728948261821643}
#define T_625_2 {0.9997978773111629857694993006589356809855,-0.0201048383254575774303773982865095604211}
#define T_625_3 {0.9995452431006844884464612732699606567621,-0.0301547176208567559163586935255807475187}
#define T_625_4 {0.9991915909518144234269243497692514210939,-0.0402015493629532053021513604562642285600}
#define T_625_6 {0.9981813860104127300587606441695243120193,-0.0602820091099435170778342296671326039359}
#define T_625_7 {0.9975249353131302454400497481401544064283,-0.0703136077053038016648756070026138331741}
#define T_625_8 {0.9967676708576360677938055232516489923000,-0.0803381001333942218467498719292052555829}
#define T_625_9 {0.9959096691760279673744093997811432927847,-0.0903544732799355793106954592985857743770}
#define T_625_11 {0.9938918111585802739327277777192648500204,-0.1103588134763917733005555987801926676184}
#define T_625_12 {0.9927321587553373793966215998807456344366,-0.1203447588097115023009209267002006527036}
#define T_625_13 {0.9914721769705635567859758339182008057833,-0.1303185416326145262821967207855777814984}
#define T_625_14 {0.9901119931429293030689109400555025786161,-0.1402791539557319833164683586801402270794}
#define T_625_16 {0.9870915793339134491901631918153725564480,-0.1601568419021817957226261341929784975946}
#define T_625_17 {0.9854316546073247362613756195059977471828,-0.1700719086088891551789004097372526302934}
#define T_625_18 {0.9836721383166108223505830210342537611723,-0.1799697871855897857162887021331698633730}
#define T_625_19 {0.9818132082853465725236219441285356879234,-0.1898494773140938784994347088286303915083}
#define T_625_21 {0.9777978685121797575163782312301918864250,-0.2095503002456405583497911493395804427564}
#define T_625_22 {0.9756418645761659735882176391896791756153,-0.2193694420067258954443190077654435299337}
#define T_625_23 {0.9733872584703672226069670614378992468119,-0.2291664134369226779597283893963322043419}
#define T_625_24 {0.9710342780540647256160013967019040137529,-0.2389402244161105970388092600842355750501}
#define T_625_26 {0.9660341554134970198930432161432690918446,-0.2584144163442346764369972333952318876982}
#define T_625_27 {0.9633875185211158154174881929066032171249,-0.2681128291554261688922622397512895986438}
#define T_625_28 {0.9606435179309280592008235544199123978615,-0.2777841454390272413199625134438974782825}
#define T_625_29 {0.9578024309623294207938215549802407622337,-0.2874273877741164162635811862855916842818}
#define T_625_31 {0.9518301561981014069502293750701937824488,-0.3066257551998819441685384390439139679074}
#define T_625_32 {0.9486995719838390295208796487713698297739,-0.3161789400287130513689248800801578909159}
#define T_625_33 {0.9454731084928994500060639438743237406015,-0.3257001705814321357301821535656927153468}
#define T_625_34 {0.9421510918042592663823597831651568412781,-0.3351884846053667099674555629462702199817}
#define T_625_36 {0.9352217514007470366976804143632762134075,-0.3540625307864689874648433942638803273439}
#define T_625_37 {0.9316151279920259486999611908686347305775,-0.3634463554589605904787674717226764187217}
#define T_625_38 {0.9279143519271306761453388389782048761845,-0.3727934488260932766046096276113530620933}
#define T_625_39 {0.9241197972209157507350596461037639528513,-0.3821028662341773296517999369825702160597}
#define T_625_41 {0.9162508952933617889513584486849140375853,-0.4006049136919229147757448572519933804870}
#define T_625_42 {0.9121773433339237513450825645122677087784,-0.4097956738525492248470527556492015719414}
#define T_625_43 {0.9080116031765956829957531226682476699352,-0.4189450184650349573445282658212818205357}
#define T_625_44 {0.9037540958273154734214926975255366414785,-0.4280520228609502875194436910533113405108}
#define T_625_46 {0.8949655099049148576639822749712038785219,-0.4461353338177057592517371631402056664228}
#define T_625_47 {0.8904353195405447785049091180553659796715,-0.4551098128086537575320846826798515394330}
#define T_625_48 {0.8858151383119573507585187144286464899778,-0.4640382966279483212268530678556999191642}
#define T_625_49 {0.8811054331526765315274474232865031808615,-0.4729198829282125204898079573467839509249}
#define T_625_51 {0.8714193639662127788270140626991633325815,-0.4905387773710874199650788796134293079376}
#define T_625_52 {0.8664439788509370465874326328048482537270,-0.4992743048795490468094726566050667315722}
#define T_625_53 {0.8613810275298499075091740451171062886715,-0.5079593737806400444156906814896501600742}
#define T_625_54 {0.8562310216845464561075118581356946378946,-0.5165931063274438184151904351892881095409}
#define T_625_56 {0.8456719370854187678432367647474166005850,-0.5337030773999673627372430928517132997513}
#define T_625_57 {0.8402639254738420993007252945972140878439,-0.5421775867253177949578457628376781940460}
#define T_625_58 {0.8347709935146954141060859910794533789158,-0.5505973014704015344733534220722503960133}
#define T_625_59 {0.8291936963450933228969574884104076772928,-0.5589613707060275826776774010795634239912}
#define T_625_61 {0.8177882694974004662569200263533275574446,-0.5755191971363310399212309675931464880705}
#define T_625_62 {0.8119612924962041899945575096353422850370,-0.5837112809325288864670255861710757017136}
#define T_625_63 {0.8060522555218471163485105535073671489954,-0.5918443725914295239221019073738716542721}
#define T_625_64 {0.8000617557646388933179082414426375180483,-0.5999176501510879999656822292308788746595}
#define T_625_66 {0.7878387977664520480658438827958889305592,-0.6158815054325884608132923858647700399160}
#define T_625_67 {0.7816075748252524491022086294833570718765,-0.6237704697849901780415393659495748579502}
#define T_625_68 {0.7752973595759157232620850663806777447462,-0.6315963934623227693521130277076736092567}
#define T_625_69 {0.7689087897533913862346821588289458304644,-0.6393584855462347560361990872479509562254}
#define T_625_71 {0.7558991768574195857510744644969236105680,-0.6546880435950205301409710045845713466406}
#define T_625_72 {0.7492794485861613562605043625808320939541,-0.6622539602950049397733778278052341192961}
#define T_625_73 {0.7425839952132153864994279501843266189098,-0.6697529470283645203210198815213516354561}
#define T_625_74 {0.7358134934071977051317503537575248628855,-0.6771842459182698670261402185133192688227}
#define T_625_76 {0.7220500890246939196259745585848577320576,-0.6918407829402886122238669486250728368759}
#define T_625_77 {0.7150585774315030285208649729611352086067,-0.6990645398256409848158909881021827459335}
#define T_625_78 {0.7079947992312527471625571706681512296200,-0.7062176465237173239586354611674323678017}
#define T_625_79 {0.7008594683169017125479172136692795902491,-0.7132993801136727762823852572182659059763}
#define T_625_81 {0.6863770400018340822612117335665971040726,-0.7272458724243958672062149162229616194963}
#define T_625_82 {0.6790314062517740500979357420874293893576,-0.7341092216582886242903782658686395734549}
#define T_625_83 {0.6716171469410040506531345272378530353308,-0.7408983789527587848766643219278194010258}
#define T_625_84 {0.6641350113834701973658525275823194533587,-0.7476126581691069361568224849179387092590}
#define T_625_86 {0.6489701430066630027937435443163849413395,-0.7608138757185697320650774599926080554724}
#define T_625_87 {0.6412889428080990050773380062310025095940,-0.7672994798851818787355227868829388171434}
#define T_625_88 {0.6335429314492969643524133971368428319693,-0.7737075377755030514137501995719503611326}
#define T_625_89 {0.6257328917723579131404676445527002215385,-0.7800374017662247139170972332067321985960}
#define T_625_91 {0.6099238911074591484862139623146504163742,-0.7924599971331904857407835152116604149342}
#define T_625_92 {0.6019265278387284645589261344866827130318,-0.7985514730335249167225697419780772179365}
#define T_625_93 {0.5938683315288471042947548994561657309532,-0.8045622442093236514892851118929684162140}
#define T_625_94 {0.5857501165705443213482794817537069320679,-0.8104917031886222922310025751357898116112}
#define T_625_96 {0.5693369185252644681938249959785025566816,-0.8221042958190623028968957441975362598896}
#define T_625_97 {0.5610435942200587833283975669473875313997,-0.8277862558563279238299514872778672724962}
#define T_625_98 {0.5526935686623315469034878333332017064095,-0.8333845565879515193685733720485586673021}
#define T_625_99 {0.5442876857382129562878958495275583118200,-0.8388986322278397800289440056076273322105}
#define T_625_101 {0.5273117514752824197543645823316182941198,-0.8496718877049364015974219910276588052511}
#define T_625_102 {0.5187434157905574938496329195913858711720,-0.8549299787549532458896806019765790551901}
#define T_625_103 {0.5101226538742247296198684125556610524654,-0.8601016672488885905778488449868746101856}
#define T_625_104 {0.5014503369740861415948529611341655254364,-0.8651864305157446199956439158995635807514}
#define T_625_106 {0.4839545491767599516563791439693886786699,-0.8750931346611736660889846461941488087177}
#define T_625_107 {0.4751328464720838140600278620695462450385,-0.8799140743296104405501978362735826522112}
#define T_625_108 {0.4662631249899246155266041569120716303587,-0.8846460864518815858659195328073110431433}
#define T_625_109 {0.4573462811389086279945104251964949071407,-0.8892886927923970841192158331978134810925}
#define T_625_111 {0.4393748356855865511150227575853932648897,-0.8983038204117045344432312958815600723028}
#define T_625_112 {0.4303220503476088421024314811802469193935,-0.9026754305865591909707745799096301198006}
#define T_625_113 {0.4212257749858722144509215468133334070444,-0.9069558128638635086105068694450892508030}
#define T_625_114 {0.4120869289054210904410524562990758568048,-0.9111445346514999155118630369543097913265}
#define T_625_116 {0.3936852232270234286382049049279885366559,-0.9192453127499148335388667874212842434645}
#define T_625_117 {0.3844242233771806849240704195835860446095,-0.9231565503644826309326276714273262768984}
#define T_625_118 {0.3751243721168776579233394841139670461416,-0.9269744901797019043243608393822796642780}
#define T_625_119 {0.3657866093253325234790906961279688403010,-0.9306987463396931836712155927671119570732}
#define T_625_121 {0.3470011277274495098410511673137079924345,-0.9378647116486887869157840214029420167208}
#define T_625_122 {0.3375553074551057575192203330516349524260,-0.9413056965773068940350754019164014607668}
#define T_625_123 {0.3280753725276349674899734054633881896734,-0.9446515494831168036071744609216693788767}
#define T_625_124 {0.3185622810242127456170635468879481777549,-0.9479019322211821307888612864189781248569}
#define T_625_126 {0.2994404772637143663516212654940318316221,-0.9541149828904684770947142169461585581303}
#define T_625_127 {0.2898336975306610163727327744709327816963,-0.9570770229065711509619518437830265611410}
#define T_625_128 {0.2801976260743935798203096965153235942125,-0.9599423369881517897894696034200023859739}
#define T_625_129 {0.2705332367538536564310902576835360378027,-0.9627106355554005956420837719633709639311}
#define T_625_131 {0.2511234141665813490718051070871297270060,-0.9679550768797691162603769043926149606705}
#define T_625_132 {0.2413799425321770664165654807220562361181,-0.9704306896132062210114099798374809324741}
#define T_625_133 {0.2316120760999064442930972518297494389117,-0.9728082268385126463172696276160422712564}
#define T_625_134 {0.2218208020484253029103172139002708718181,-0.9750874482725092606827388408419210463762}
#define T_625_136 {0.2021719915307735038201286670300760306418,-0.9793500323380199823475322773447260260582}
#define T_625_137 {0.1923164408499827837673024077957961708307,-0.9813329641761735500082863836723845452070}
#define T_625_138 {0.1824414539200502061166986322859884239733,-0.9832167186798331792729754852189216762781}
#define T_625_139 {0.1725480287456465922080184327569440938532,-0.9850011054694260970165942126186564564705}
#define T_625_141 {0.1527098648982631867720982654645922593772,-0.9882710646187887748581601954356301575899}
#define T_625_142 {0.1427671311474489335147097790468251332641,-0.9897563065037409124613532185321673750877}
#define T_625_143 {0.1328099687938694151156937550695147365332,-0.9911415197583902658706733745930250734091}
#define T_625_144 {0.1228393841471641101392719974683132022619,-0.9924265643876858389305084529041778296232}
#define T_625_146 {0.1028619798936414586609799926009145565331,-0.9946956384202959577933711443620268255472}
#define T_625_147 {0.0928571792811678370371808455274731386453,-0.9956794385021441318173174295225180685520}
#define T_625_148 {0.0828429941602083913521070712704386096448,-0.9965626113388820206395735112891998142004}
#define T_625_149 {0.0728204366033457090034985981219506356865,-0.9973450676736201891969813004834577441216}
#define T_625_151 {0.0527542566006264715405826848382275784388,-0.9986075247115431263722484800382517278194}
#define T_625_152 {0.0427126621211368767694338544060883577913,-0.9990873978258987264666757255326956510544}
#define T_625_153 {0.0326667509335237943313146047330519650131,-0.9994662992734908435465968068456277251244}
#define T_625_154 {0.0226175383167297565367714895501194405369,-0.9997441907610622457980298349866643548012}
#define T_625_156 {0.0025132714770037269634561649667148230947,-0.9999968417282540933399559435201808810234}
#define T_625_157 {-0.0075397509303570921582182684517192683415,-0.9999715756739829819466081062273588031530}
#define T_625_158 {-0.0175920113410997225322773829248035326600,-0.9998452485944885337332266317389439791441}
#define T_625_159 {-0.0276424938346043792825046381267384276725,-0.9996178732568780089806637079163920134306}
#define T_625_161 {-0.0477340623884916423480540004220529226586,-0.9988600799350685344180078573117498308420}
#define T_625_162 {-0.0577731179166413380543509958897629985586,-0.9983297385364165998922203471011016517878}
#define T_625_163 {-0.0678063346683007578397095471700595226139,-0.9976985020430021444681756292993668466806}
#define T_625_164 {-0.0778326986474765225576533111961907707155,-0.9969664342500459408569213337614201009274}
#define T_625_166 {-0.0978608158696515489927136854930722620338,-0.9952001108909334092800236248876899480820}
#define T_625_167 {-0.1078605449930568199734537415679369587451,-0.9941660338363007554107753094285726547241}
#define T_625_168 {-0.1178493733093558537561307275609578937292,-0.9930314824871324663746463556890375912189}
#define T_625_169 {-0.1278262913086236074455825928453123196959,-0.9917965715056101805302546381426509469748}
#define T_625_171 {-0.1477403644367836499373680680946563370526,-0.9890261799952952959102958629955537617207}
#define T_625_172 {-0.1576755069718226431874086301831994205713,-0.9874909794530675188894974780851043760777}
#define T_625_173 {-0.1675947142055242422564731441525509580970,-0.9858559792233186902521424599399324506521}
#define T_625_174 {-0.1774969836641414056011001321166986599565,-0.9841213445455451180876593753055203706026}
#define T_625_176 {-0.1972467080212628731672452886414248496294,-0.9803538831334196457234497756871860474348}
#define T_625_177 {-0.2070921669356412253559795999535708688200,-0.9783214371534033615418479712388943880796}
#define T_625_178 {-0.2169166963084052934807033352626604028046,-0.9761901181955526807243472831032704561949}
#define T_625_179 {-0.2267193032343216008150932339049177244306,-0.9739601416592692517681939534668345004320}
#define T_625_181 {-0.2462547893026399703497730797607800923288,-0.9692051272798304362154908631055150181055}
#define T_625_182 {-0.2559856941126726903590338224603328853846,-0.9666805699969629461776321477373130619526}
#define T_625_183 {-0.2656907280106526325624827222782187163830,-0.9640583162076707957055532460799440741539}
#define T_625_184 {-0.2753689101680248940695605597284156829119,-0.9613386309271433338707879556750413030386}
#define T_625_186 {-0.2946408096142865695732382391724968329072,-0.9556080751593917232966646224667783826590}
#define T_625_187 {-0.3042325792098980463684654296230291947722,-0.9525977838244708006953942458494566380978}
#define T_625_188 {-0.3137936018751875111298943465953925624490,-0.9494912192443889509263499348890036344528}
#define T_625_189 {-0.3233229113359364914614957342564594000578,-0.9462886953806719514403766879695467650890}
#define T_625_191 {-0.3422825416695712275050311745872022584081,-0.9395970741058202735374038638838101178408}
#define T_625_192 {-0.3517109464083127967626296594971790909767,-0.9361086529760148655654461435915436595678}
#define T_625_193 {-0.3611038058678774920196019593277014791965,-0.9325256250568850768800643891154322773218}
#define T_625_194 {-0.3704601707692759537948745673929806798697,-0.9288483524631988563768913991225417703390}
#define T_625_196 {-0.3890596383185932483073088405944872647524,-0.9212125692973394119889007924939505755901}
#define T_625_197 {-0.3983008612318227892323818650766042992473,-0.9172548304271764818551559983461629599333}
#define T_625_198 {-0.4075018303074807168862037087819771841168,-0.9132043902084862052603853044274728745222}
#define T_625_199 {-0.4166616156597678921613692182290833443403,-0.9090616579945454134303872706368565559387}
#define T_625_201 {-0.4348539365555282865116737411881331354380,-0.9005010015886493190961914478975813835859}
#define T_625_202 {-0.4438846335121400255019352698582224547863,-0.8960839425699989035933867853600531816483}
#define T_625_203 {-0.4528704697574726933950728380295913666487,-0.8915763218152700231300400446343701332808}
#define T_625_204 {-0.4618105371478895548875698295887559652328,-0.8869785948821864440816398200695402920246}
#define T_625_206 {-0.4795497560086358079800561426964122802019,-0.8775146901972968871419311653880868107080}
#define T_625_207 {-0.4883471146843615384725012518174480646849,-0.8726494689045877217736801867431495338678}
#define T_625_208 {-0.4970951190971508171223547378758667036891,-0.8676960542550539168260570477286819368601}
#define T_625_209 {-0.5057928851395788738543046747508924454451,-0.8626549468600877013102490309393033385277}
#define T_625_211 {-0.5230341911589180270425458729732781648636,-0.8523117005407917501358383560727816075087}
#define T_625_212 {-0.5315759886622380969711798570642713457346,-0.8470106069452519870210949193278793245554}
#define T_625_213 {-0.5400640630241156925350765050097834318876,-0.8416239111562147101608388766180723905563}
#define T_625_214 {-0.5484975564066704167842658534937072545290,-0.8361521575741531764336400556203443557024}
#define T_625_216 {-0.5651973965492598228621545786154456436634,-0.8249556975583226536841152665147092193365}
#define T_625_217 {-0.5734620555583554990519701277662534266710,-0.8192321226824456070758628811745438724756}
#define T_625_218 {-0.5816687582568207393052261977572925388813,-0.8134257530149683335096710834477562457323}
#define T_625_219 {-0.5898166752432919546222933604440186172724,-0.8075371753702420551945806437288410961628}
#define T_625_221 {-0.6059328642635862793852652430359739810228,-0.7955157848875950010736346484918612986803}
#define T_625_222 {-0.6138995075325276440381117026845458894968,-0.7893841869782546316614002535061445087194}
#define T_625_223 {-0.6218041077243211534053557443257886916399,-0.7831728108260403997675780374265741556883}
#define T_625_224 {-0.6296458659692600878798884878051467239857,-0.7768822841768375786486444667389150708914}
#define T_625_226 {-0.6451376929751027056170187279349192976952,-0.7640663303030451602992911830369848757982}
#define T_625_227 {-0.6527861960715837241764347709249705076218,-0.7575421983087092803188511425105389207602}
#define T_625_228 {-0.6603687260505968215085204064962454140186,-0.7509415061469912888725275479373522102833}
#define T_625_229 {-0.6678845165921063475877872406272217631340,-0.7442649209095699713856220114394091069698}
#define T_625_231 {-0.6827128478839764591512562219577375799417,-0.7306867778563879145536930082016624510288}
#define T_625_232 {-0.6900238900253774509963022865122184157372,-0.7237865923006904234071612336265388876200}
#define T_625_233 {-0.6972651956628107550173467643617186695337,-0.7168132580507298179384179093176499009132}
#define T_625_234 {-0.7044360329617029847781850548926740884781,-0.7097674798588468059179490410315338522196}
#define T_625_236 {-0.7185634108878365955419553756655659526587,-0.6954614471940469000443840741354506462812}
#define T_625_237 {-0.7255185237471978298984254251990932971239,-0.6882026385445545457741900463588535785675}
#define T_625_238 {-0.7324003128765530501453895340091548860073,-0.6808742774538681929996641883917618542910}
#define T_625_239 {-0.7392080827754685667940748317050747573376,-0.6734771045547250922780335713468957692385}
#define T_625_241 {-0.7525988203531378539778984304575715214014,-0.6584793205584099640148565413255710154772}
#define T_625_242 {-0.7591804347117565576752440392738208174706,-0.6508802251957486184608114854199811816216}
#define T_625_243 {-0.7656853233364364630375575870857574045658,-0.6432153493404652033760271478968206793070}
#define T_625_244 {-0.7721128288177779852574644792184699326754,-0.6354854676347906350386551821429748088121}
#define T_625_246 {-0.7847330998817070302209231158485636115074,-0.6198338180109623785085659619653597474098}
#define T_625_247 {-0.7909245900105082993647442890505772083998,-0.6119136319095279663571318451431579887867}
#define T_625_248 {-0.7970361462173010114184990015928633511066,-0.6039316034312769421177335971151478588581}
#define T_625_249 {-0.8030671508443926187581496378697920590639,-0.5958885392711202877435994196275714784861}
#define T_625_251 {-0.8148850754945862195910422087763436138630,-0.5796225614451032681628817044838797301054}
#define T_625_252 {-0.8206708011521579582137064790003933012486,-0.5714012916823650867215178550395648926497}
#define T_625_253 {-0.8263735866196754153989445512706879526377,-0.5631222738778264291781283645832445472479}
#define T_625_254 {-0.8319928555514105594781426589179318398237,-0.5547863447412973991745843704848084598780}
#define T_625_256 {-0.8429785806845486728633431994239799678326,-0.5379471279847712894550681994587648659945}
#define T_625_257 {-0.8483439266257484234756702790036797523499,-0.5294455422016571821686170551402028650045}
#define T_625_258 {-0.8536235356229666670913047710200771689415,-0.5208904485883242285737537713430356234312}
#define T_625_259 {-0.8588168740983388449450330881518311798573,-0.5122827117558800269492280676786322146654}
#define T_625_261 {-0.8689426488193063846665609162300825119019,-0.4949127933918132660195965399907436221838}
#define T_625_262 {-0.8738740617146393274694560204807203263044,-0.4861523673318466909343271709076361730695}
#define T_625_263 {-0.8787171574910247473511049065564293414354,-0.4773428088186660311897924202639842405915}
#define T_625_264 {-0.8834714466863258230944211391033604741096,-0.4684850081805932986434015674603870138526}
#define T_625_266 {-0.8927116924093823069341624432126991450787,-0.4506282661302732917008029289718251675367}
#define T_625_267 {-0.8971967150818874747741915598453488200903,-0.4416311293899813361640838138555409386754}
#define T_625_268 {-0.9015910635571866560411535829189233481884,-0.4325893596863208401259726088028401136398}
#define T_625_269 {-0.9058942937252941751680168636084999889135,-0.4235038708157818909683101082919165492058}
#define T_625_271 {-0.9142256687878009824288483287091366946697,-0.4052054127593781029936792492662789300084}
#define T_625_272 {-0.9182529716809616493478074517042841762304,-0.3959942928870098799443155712651787325740}
#define T_625_273 {-0.9221874723495493419989088579313829541206,-0.3867431522878577720980786125437589362264}
#define T_625_274 {-0.9260287731575901348790580414060968905687,-0.3774529259182506923941957666102098301053}
#define T_625_276 {-0.9334302317830763806583149744255933910608,-0.3587589753488995003571915276552317664027}
#define T_625_277 {-0.9369896415802629885405394816189073026180,-0.3493571404326670237772134441911475732923}
#define T_625_278 {-0.9404543555519829789446362156013492494822,-0.3399199981220644151136411892366595566273}
#define T_625_279 {-0.9438240235407373557308119416120462119579,-0.3304485021714786974200706026749685406685}
#define T_625_281 {-0.9502768690023574160719022074772510677576,-0.3114062816307281988947863737848820164800}
#define T_625_282 {-0.9533593943255084246501951383834239095449,-0.3018374815215959516834232090332079678774}
#define T_625_283 {-0.9563455694321727484918937989277765154839,-0.2922381765400498543350238378479843959212}
#define T_625_284 {-0.9592350925278542161933614806912373751402,-0.2826093368292684759879307421215344220400}
#define T_625_286 {-0.9647230243779428837669343010929878801107,-0.2632669486188402574455835747357923537493}
#define T_625_287 {-0.9673208785005658061351141441264189779758,-0.2535553549363405156924500261084176599979}
#define T_625_288 {-0.9698209714046909235563020956760738044977,-0.2438181359613384724394080649290117435157}
#define T_625_289 {-0.9722230504211841761730283906217664480209,-0.2340562757751382949589213922081398777664}
#define T_625_291 {-0.9767322056676015495924048082088120281696,-0.2144625804463383411668786493464722298086}
#define T_625_292 {-0.9788388261847201787801964201207738369703,-0.2046327255189626659337420733209000900388}
#define T_625_293 {-0.9808465214346523408650568853772711008787,-0.1947821896107088668337325998436426743865}
#define T_625_294 {-0.9827550885118900847459144642925821244717,-0.1849119682551322307872965211572591215372}
#define T_625_296 {-0.9862740766371433931425372065859846770763,-0.1651164611828580541796895886363927274942}
#define T_625_297 {-0.9878841420425021890849848205107264220715,-0.1551931760772660706670933450368465855718}
#define T_625_298 {-0.9893943680257961670321265046368353068829,-0.1452542065443727936635553987798630259931}
#define T_625_299 {-0.9908046019577008145517993398243561387062,-0.1353005570551802927425910638703498989344}
#define T_625_301 {-0.9933245336923797186301499095861800014973,-0.1153532434083082286457866416640172246844}
#define T_625_302 {-0.9944339768210305186002528898825403302908,-0.1053615952038983727412357893626904115081}
#define T_625_303 {-0.9954429185757831533010175917297601699829,-0.0953592987459886270995568224861926864833}
#define T_625_304 {-0.9963512569890512482473354793910402804613,-0.0853473649056469552132142553091398440301}
#define T_625_306 {-0.9978657667668942021776956607936881482601,-0.0652986333296357579492052991554373875260}
#define T_625_307 {-0.9984717850692077512064770417055115103722,-0.0552638617969271883634263531348551623523}
#define T_625_308 {-0.9989768939209825449054847013030666857958,-0.0452235050829326162835641866877267602831}
#define T_625_309 {-0.9993810422739491938770584056328516453505,-0.0351785779052378247411247969012038083747}
#define T_625_311 {-0.9998863043118163540512455256248358637094,-0.0150790732360371205339477640450240869541}
#define T_625_312 {-0.9999873669329657488447082869242876768112,-0.0050265270788188622791414772450480086263}
#define T_625_318 {-0.9984717850692077512064770417055115103722,0.0552638617969271883634263531348551623523}
#define T_625_321 {-0.9963512569890512482473354793910402804613,0.0853473649056469552132142553091398440301}
#define T_625_324 {-0.9933245336923797186301499095861800014973,0.1153532434083082286457866416640172246844}
#define T_625_327 {-0.9893943680257961670321265046368353068829,0.1452542065443727936635553987798630259931}
#define T_625_333 {-0.9788388261847201787801964201207738369703,0.2046327255189626659337420733209000900388}
#define T_625_336 {-0.9722230504211841761730283906217664480209,0.2340562757751382949589213922081398777664}
#define T_625_339 {-0.9647230243779428837669343010929878801107,0.2632669486188402574455835747357923537493}
#define T_625_342 {-0.9563455694321727484918937989277765154839,0.2922381765400498543350238378479843959212}
#define T_625_348 {-0.9369896415802629885405394816189073026180,0.3493571404326670237772134441911475732923}
#define T_625_351 {-0.9260287731575901348790580414060968905687,0.3774529259182506923941957666102098301053}
#define T_625_354 {-0.9142256687878009824288483287091366946697,0.4052054127593781029936792492662789300084}
#define T_625_357 {-0.9015910635571866560411535829189233481884,0.4325893596863208401259726088028401136398}
#define T_625_363 {-0.8738740617146393274694560204807203263044,0.4861523673318466909343271709076361730695}
#define T_625_366 {-0.8588168740983388449450330881518311798573,0.5122827117558800269492280676786322146654}
#define T_625_369 {-0.8429785806845486728633431994239799678326,0.5379471279847712894550681994587648659945}
#define T_625_372 {-0.8263735866196754153989445512706879526377,0.5631222738778264291781283645832445472479}
// Pre-computed twiddles for N=648
#define T_648_1 {0.9999529915072261632147387899749446660280,-0.0096961216859783958682550419894141668919}
#define T_648_5 {0.9988250086459503629399137025757227092981,-0.0484623782270029584973158875982335302979}
#define T_648_7 {0.9976974499728976653045720013324171304703,-0.0678218129924093443561261551622010301799}
#define T_648_11 {0.9943173181260184234631083199928980320692,-0.1064568967924682529879731873734272085130}
#define T_648_13 {0.9920660160815423234126342322269920259714,-0.1257180167521627089932678700279211625457}
#define T_648_17 {0.9864451725452738628519000485539436340332,-0.1640911989173239882155996838264400139451}
#define T_648_19 {0.9830777448228600334800830751191824674606,-0.1831888305383266302150957471894798800349}
#define T_648_23 {0.9752352087524931434359132254030555486679,-0.2211702683668877733591529022305621765554}
#define T_648_25 {0.9707630496616199700099514302564784884453,-0.2400397913090059065499559665113338269293}
#define T_648_29 {0.9607253577167205182973930277512408792973,-0.2775009676380957857055875592777738347650}
#define T_648_31 {0.9551635996281230278626139806874562054873,-0.2960785334086999398550688056275248527527}
#define T_648_35 {0.9429647161808759614487485123390797525644,-0.3328926914756765720326825430674944072962}
#define T_648_37 {0.9363321783233931050460796541301533579826,-0.3511154394727888372607083056209376081824}
#define T_648_41 {0.9220133805339184585037060060130897909403,-0.3871580118200006470630114563391543924809}
#define T_648_43 {0.9143325053161793780631683148385491222143,-0.4049642820326735948022189859329955652356}
#define T_648_47 {0.8979422434636881167335786813055165112019,-0.4401133120043048685410269627027446404099}
#define T_648_49 {0.8892390205361061505939801463682670146227,-0.4574428536505807940670820244122296571732}
#define T_648_53 {0.8708327540784920328675866585399489849806,-0.4915794080553705924785390379838645458221}
#define T_648_55 {0.8611366323925137011841002276923973113298,-0.5083735834518555707361997519910801202059}
#define T_648_59 {0.8407766423091030949521496040688361972570,-0.5413821549953696798951341406791470944881}
#define T_648_61 {0.8301204304712788140108159495866857469082,-0.5575841379685928522746962698874995112419}
#define T_648_65 {0.8078756085237110973196195118362084031105,-0.5893530360933448841720405653177294880152}
#define T_648_67 {0.7962953637817556939992869047273416072130,-0.6049080042615416763496227758878376334906}
#define T_648_71 {0.7722409794060690613193287390458863228559,-0.6353297330724850811023429741908330470324}
#define T_648_73 {0.7597758856425493867448039964074268937111,-0.6501850533471834614474005320516880601645}
#define T_648_77 {0.7339933312612353377701879253436345607042,-0.6791566753437932035808444197755306959152}
#define T_648_79 {0.7206855664077145284807102143531665205956,-0.6932620820235242398155151022365316748619}
#define T_648_83 {0.6932620820235242398155151022365316748619,-0.7206855664077145284807102143531665205956}
#define T_648_85 {0.6791566753437932035808444197755306959152,-0.7339933312612353377701879253436345607042}
#define T_648_89 {0.6501850533471834614474005320516880601645,-0.7597758856425493867448039964074268937111}
#define T_648_91 {0.6353297330724850811023429741908330470324,-0.7722409794060690613193287390458863228559}
#define T_648_95 {0.6049080042615416763496227758878376334906,-0.7962953637817556939992869047273416072130}
#define T_648_97 {0.5893530360933448841720405653177294880152,-0.8078756085237110973196195118362084031105}
#define T_648_101 {0.5575841379685928522746962698874995112419,-0.8301204304712788140108159495866857469082}
#define T_648_103 {0.5413821549953696798951341406791470944881,-0.8407766423091030949521496040688361972570}
#define T_648_107 {0.5083735834518555707361997519910801202059,-0.8611366323925137011841002276923973113298}
// Pre-computed twiddles for N=729
#define T_729_1 {0.9999628574261159030811541015282273292542,-0.0086188031766284319001858449382780236192}
#define T_729_2 {0.9998514324636050831784928050183225423098,-0.0172369661041893024178150994885072577745}
#define T_729_4 {0.9994057739990460653700665716314688324928,-0.0344688105012005627236781890587735688314}
#define T_729_5 {0.9990715736028027427195752352417912334204,-0.0430812119005435992247221577144955517724}
#define T_729_7 {0.9981805546111732763137069923686794936657,-0.0602957742808772068077161065957625396550}
#define T_729_8 {0.9976238022052646980952772537420969456434,-0.0688966564755575938683307413157308474183}
#define T_729_10 {0.9962880183623609164911272273457143455744,-0.0860824283323837757819774196832440793514}
#define T_729_11 {0.9955090861542660318761477356019895523787,-0.0946660413469276734721447041920328047127}
#define T_729_13 {0.9937294304759625163114833412691950798035,-0.1118115334208380495795154274674132466316}
#define T_729_14 {0.9927288392077390222212329717876855283976,-0.1203721388247922519099120108876377344131}
#define T_729_16 {0.9905065014529780276220094492600765079260,-0.1374658887847514665558890101237921044230}
#define T_729_17 {0.9892849200531290687621321922051720321178,-0.1459977635290147790492198964784620329738}
#define T_729_19 {0.9866213859285269949239705056243110448122,-0.1630283436353094916881900644511915743351}
#define T_729_20 {0.9851796310647999987963885359931737184525,-0.1715257838781811539075050632163765840232}
#define T_729_22 {0.9820766812314035698605607649369630962610,-0.1884818086222438404675472156668547540903}
#define T_729_23 {0.9804157167648209769694744863954838365316,-0.1969391335426312061862574864790076389909}
#define T_729_25 {0.9768754256476755992721905386133585125208,-0.2138092672586307252391435440586064942181}
#define T_729_26 {0.9749963619881616416762426524655893445015,-0.2222208228538668783880183354995097033679}
#define T_729_28 {0.9710210963894898572590363983181305229664,-0.2389937872969776500031713339922134764493}
#define T_729_29 {0.9689251897535244850701019458938390016556,-0.2473539501627100845038143006604514084756}
#define T_729_31 {0.9645176072704398917423418424732517451048,-0.2640185320489935594245878291985718533397}
#define T_729_32 {0.9622062588412366723744639784854371100664,-0.2723217131386166944828630676056491211057}
#define T_729_34 {0.9573693060890517969596658076625317335129,-0.2888667716414740072039535334624815732241}
#define T_729_35 {0.9548440610798200056663631585252005606890,-0.2971074200025925482471222949243383482099}
#define T_729_37 {0.9495809717221362911132587214524392038584,-0.3135218942007774178826196020963834598660}
#define T_729_38 {0.9468435183430549129113273920665960758924,-0.3216945006862024225569030022597871720791}
#define T_729_40 {0.9411578109299509886653822832158766686916,-0.3379674169584142573441454260319005697966}
#define T_729_41 {0.9382099792595437470765773468883708119392,-0.3460665179092111687353394700039643794298}
#define T_729_43 {0.9321054548753081592238345365331042557955,-0.3621869972703255502466390680638141930103}
#define T_729_44 {0.9289492156369756337142007396323606371880,-0.3702071781684515561217097001645015552640}
#define T_729_46 {0.9224299553589553335442019488255027681589,-0.3861644435424831378611543186707422137260}
#define T_729_47 {0.9190674186034806236733629702939651906490,-0.3941003426305724199885105463181389495730}
#define T_729_49 {0.9121377807737452991787563405523542314768,-0.4098837260555083794599795510293915867805}
#define T_729_50 {0.9085711944686548635630174430843908339739,-0.4177300379213850223258930327574489638209}
#define T_729_52 {0.9012358117803006551937983203970361500978,-0.4333289876810718643795894422510173171759}
#define T_729_53 {0.8974675603070237928093888513103593140841,-0.4410804668045941734355608332407427951694}
#define T_729_55 {0.8897313367070638356892686715582385659218,-0.4564845544829106982476218945521395653486}
#define T_729_56 {0.8857639392668940070407757048087660223246,-0.4641360187427756023303970778215443715453}
#define T_729_58 {0.8776320466778070317204196726379450410604,-0.4793349461953754775400682319741463288665}
#define T_729_59 {0.8734681556077324993125898799917194992304,-0.4868812803335387240366571859340183436871}
#define T_729_61 {0.8649460304698609602880310376349370926619,-0.5018648865725020558059554787178058177233}
#define T_729_62 {0.8605884294693890712579786850255914032459,-0.5093010456138984398677393983234651386738}
#define T_729_64 {0.8516817691064979545245705594425089657307,-0.5240593136006895802481153623375575989485}
#define T_729_65 {0.8471333713766597828254134583403356373310,-0.5313803262259660931121629801054950803518}
#define T_729_67 {0.8378481301870863706682257543434388935566,-0.5459033895681570935920490228454582393169}
#define T_729_68 {0.8331119764828649465471244184300303459167,-0.5531043614371651262473505994421429932117}
#define T_729_70 {0.8234543619588061691416669418686069548130,-0.5673825109844463643327117097214795649052}
#define T_729_71 {0.8185336185562906985424547201546374708414,-0.5744586280082707441252409807930234819651}
#define T_729_73 {0.8085100871338877226435215561650693416595,-0.5884823183433409710119121882598847150803}
#define T_729_74 {0.8034080437135130425829743217036593705416,-0.5954288499026780812073411652818322181702}
#define T_729_76 {0.7930252964565097650861957845336291939020,-0.6091887057226723634073550783796235918999}
#define T_729_77 {0.7877453639037954591373136281617917120457,-0.6160010078304067882015715440502390265465}
#define T_729_79 {0.7770103420236545987975773641665000468493,-0.6294878302145986426197055152442771941423}
#define T_729_80 {0.7715560501489147071652041631750762462616,-0.6361613486204623635345001275709364563227}
#define T_729_82 {0.7604759303643872092592914668784942477942,-0.6493661211800471066979412171349395066500}
#define T_729_83 {0.7548509255429350917054875935718882828951,-0.6558963944152874647741668923117686063051}
#define T_729_85 {0.7434331152821854749035423992609139531851,-0.6688102893211382848903667763806879520416}
#define T_729_86 {0.7376411580166103432176782916940283030272,-0.6751929516811575604506856507214251905680}
#define T_729_88 {0.7258932904651047568478361426969058811665,-0.6878073355655224263571767551184166222811}
#define T_729_89 {0.7199382528712511275514884800941217690706,-0.6940381200284969631653098076640162616968}
#define T_729_91 {0.7078681818687191373840050800936296582222,-0.7063445597566911926534771737351547926664}
#define T_729_92 {0.7017540450870486390400060372485313564539,-0.7124193008362171841696408591815270483494}
#define T_729_94 {0.6893698398769307900124658772256225347519,-0.7244095691444548679172044103324878960848}
#define T_729_95 {0.6831006914109973848781010019592940807343,-0.7303242056743136645380332083732355386019}
#define T_729_97 {0.6704106312458877336979412575601600110531,-0.7419902866699067400801936855714302510023}
#define T_729_98 {0.6639906622297059302084676346566993743181,-0.7477408645190902758415063544816803187132}
#define T_729_100 {0.6510032308363964403952195425517857074738,-0.7590749590393385259901037898089271038771}
#define T_729_101 {0.6444367332325289243755150891956873238087,-0.7646576337555169855519920929509680718184}
#define T_729_103 {0.6311606131403567632176532242738176137209,-0.7756521645817079368967483787855599075556}
#define T_729_104 {0.6244519768705949491760520686511881649494,-0.7810632039613734090011121224961243569851}
#define T_729_106 {0.6108960436068826549416144189308397471905,-0.7917108208844045869057026720838621258736}
#define T_729_107 {0.6040497536174378456763633948867209255695,-0.7969466074679737443986482503532897680998}
#define T_729_109 {0.5902230697739088149944564065663143992424,-0.8072401922022116593780083348974585533142}
#define T_729_110 {0.5832437030370770658649348661128897219896,-0.8122972256924172462788646953413262963295}
#define T_729_112 {0.5691555122112117448551771303755231201649,-0.8222298966345076287609572318615391850471}
#define T_729_113 {0.5620477346655154970989087814814411103725,-0.8271047962364638239662895102810580283403}
#define T_729_115 {0.5477074552808995910879730217857286334038,-0.8366699130659123184727832267526537179947}
#define T_729_116 {0.5404760187117529923739311925601214170456,-0.8413594197472877844745653419522568583488}
#define T_729_118 {0.5258932377215480569176975222944747656584,-0.8505505878657348972637919359840452671051}
#define T_729_119 {0.5185429765845305238869400454859714955091,-0.8550515665355248318135750196233857423067}
#define T_729_121 {0.5037274430622776799637563271971885114908,-0.8638626413417470617517324171785730868578}
#define T_729_122 {0.4962632712511393373588930444384459406137,-0.8681720829461853083941491604491602629423}
#define T_729_124 {0.4812248898731794621852486670832149684429,-0.8765971739439651910785755717370193451643}
#define T_729_125 {0.4736517974347407289315015077590942382812,-0.8807121974781769724316404790442902594805}
#define T_729_127 {0.4584006218586094139055830964935012161732,-0.8887456722142955678478415393328759819269}
#define T_729_128 {0.4507236716567481482620394217519788071513,-0.8926635266483445851903866241627838462591}
#define T_729_130 {0.4352698977999716056785928230965510010719,-0.9003000144780639590891269108396954834461}
#define T_729_131 {0.4274942221309309120513830748677719384432,-0.9040180805961075538590421274420805275440}
#define T_729_133 {0.4118481813547164582800519383454229682684,-0.9112524762736244898775339606800116598606}
#define T_729_134 {0.4039789785159937918201933371165068820119,-0.9147682684249460738357129230280406773090}
#define T_729_136 {0.3881511307183715953073033233522437512875,-0.9215957355164191566743170369591098278761}
#define T_729_137 {0.3801936615334845503966221258451696485281,-0.9249069032771688458893777351477183401585}
#define T_729_139 {0.3641945881565183396055829234683187678456,-0.9313228773940346316706495599646586924791}
#define T_729_140 {0.3561541724579690981755675238673575222492,-0.9344272071385653077868482796475291252136}
#define T_729_142 {0.3399945694137104790222281280875904485583,-0.9404273989889839757694289801293052732944}
#define T_729_143 {0.3318765824865012037392375532363075762987,-0.9433228153697336137994966520636808127165}
#define T_729_145 {0.3155672530064174696740053605026332661510,-0.9489032136261230654383780347416177392006}
#define T_729_146 {0.3073771219944935184642531567078549414873,-0.9515877809610536752771281499008182436228}
#define T_729_148 {0.2909289694071482412773832493257941678166,-0.9567446549417951695559736435825470834970}
#define T_729_149 {0.2826721696851723919508003746159374713898,-0.9592165785084603157883975654840469360352}
#define T_729_151 {0.2660961901269880969245207325002411380410,-0.9639464806719830747283594973850995302200}
#define T_729_152 {0.2577782416398705089832787962222937494516,-0.9662041079073595550852360247517935931683}
#define T_729_154 {0.2410855167038462310014068634700379334390,-0.9705038761569371175141895946580916643143}
#define T_729_155 {0.2327119802764780476245221052522538229823,-0.9725456977622183307730097112653311342001}
#define T_729_157 {0.2159136696037763092359540451070643030107,-0.9764124575599347766186042463232297450304}
#define T_729_158 {0.2074901432234333154003280696997535414994,-0.9782371085095469265269230163539759814739}
#define T_729_160 {0.1905974770427891762381022999761626124382,-0.9816682747980213230576396199467126280069}
#define T_729_161 {0.1821295921166914411060133716091513633728,-0.9832745352521886639252102213504258543253}
#define T_729_163 {0.1651538637366315731558330526240752078593,-0.9862678141827716515877000347245484590530}
#define T_729_164 {0.1566472813271606312479633515977184288204,-0.9876546103030194867500313193886540830135}
#define T_729_166 {0.1395998395860514607047520030391751788557,-0.9902080007693073726571242332283873111010}
#define T_729_167 {0.1310602466261420184778785369417164474726,-0.9913744054363592406176053373201284557581}
#define T_729_169 {0.1139524883051141190826172078232048079371,-0.9934862004120000866791428961732890456915}
#define T_729_170 {0.1053855937963505129406627247590222395957,-0.9944314338455872981370475827134214341640}
#define T_729_172 {0.0882289560001719153081722879505832679570,-0.9961002215254847191872045186755713075399}
#define T_729_173 {0.0796404871961308297168002923172025475651,-0.9968236518056555750533220816578250378370}
#define T_729_175 {0.0624464397071225266189209435196971753612,-0.9980483165498075237564989947713911533356}
#define T_729_176 {0.0538421382845137644346245053839083993807,-0.9985494600393869379928446505800820887089}
#define T_729_178 {0.0366221758946191494610289396405278239399,-0.9993291831187276486048176593612879514694}
#define T_729_179 {0.0280077941147840007996006050916548701935,-0.9996077047866447351509577856631949543953}
#define T_729_181 {0.0107734289409186501096371557650854811072,-0.9999419649303928903094629276893101632595}
#define T_729_182 {0.0021547258042520799938002173945506001473,-0.9999976785756596875387458567274734377861}
#define T_729_184 {-0.0150825204079289010294928630173671990633,-0.9998862523198048801731374624068848788738}
#define T_729_185 {-0.0236997830120613227344872342428061529063,-0.9997191206959988862834620704234112054110}
#define T_729_187 {-0.0409283865908329977378876662896800553426,-0.9991620825326946730982058397785294800997}
#define T_729_188 {-0.0495384477361095545977498488809942500666,-0.9987722173728585950414071703562512993813}
#define T_729_190 {-0.0667468907876345302065956843762251082808,-0.9977699397006223325234941512462683022022}
#define T_729_191 {-0.0753439943621479896185277880249486770481,-0.9971576016425671706855382581125013530254}
#define T_729_193 {-0.0925207724705710832235894258701591752470,-0.9957107545173190521481387804669793695211}
#define T_729_194 {-0.1010991710249807412624889479957346338779,-0.9948763529293787044593955215532332658768}
#define T_729_196 {-0.1182328009435131693782849993112904485315,-0.9929859036164871977092616361915133893490}
#define T_729_197 {-0.1267867595334056241007658627495402470231,-0.9919299963238425998923730730894021689892}
#define T_729_199 {-0.1438657868612569501465259236283600330353,-0.9895972086514752685815210497821681201458}
#define T_729_200 {-0.1523895868811470377668371156687499023974,-0.9883205015632293699567867406585719436407}
#define T_729_202 {-0.1694025937211726118292176579416263848543,-0.9855469350774418435534585114510264247656}
#define T_729_203 {-0.1778905367275810389671164557512383908033,-0.9840502817146963288053029828006401658058}
#define T_729_205 {-0.1948261493195256044419494401154224760830,-0.9808377906368238585699259601824451237917}
#define T_729_206 {-0.2032725608405778205955982684827176854014,-0.9791221915620713645012074266560375690460}
#define T_729_208 {-0.2201194571648120157369987737183691933751,-0.9754729235491206296160271449480205774307}
#define T_729_209 {-0.2285186904938111274177003906515892595053,-0.9735395256973359279228930063254665583372}
#define T_729_211 {-0.2452656078404777673096504031491349451244,-0.9694559204062044299732292529370170086622}
#define T_729_212 {-0.2536120478109155640389360542030772194266,-0.9673060163180801085403004435647744685411}
#define T_729_214 {-0.2702477903094253619542541855480521917343,-0.9627908037745649405536596532328985631466}
#define T_729_215 {-0.2785358570489075979992321663303300738335,-0.9604258307324051724407354413415305316448}
#define T_729_217 {-0.2950493031527505194411276079335948452353,-0.9554820295060898471817267818551044911146}
#define T_729_218 {-0.3032734558133272084745613028644584119320,-0.9529035685729390081633027875795960426331}
#define T_729_220 {-0.3196535657351958215066645152546698227525,-0.9475344837591794799891431466676294803619}
#define T_729_221 {-0.3278083061976017620331447233184007927775,-0.9447442587218296550233276320795994251966}
#define T_729_223 {-0.3440441292898558378610118779761251062155,-0.9389534797321883452525526081444695591927}
#define T_729_224 {-0.3521240058391863492204265639884397387505,-0.9359533559487698273215983135742135345936}
#define T_729_226 {-0.3682046879147244933250249232514761388302,-0.9297447541113745828056380560155957937241}
#define T_729_227 {-0.3762042988850878844075964479998219758272,-0.9265367372643026344647410041943658143282}
#define T_729_229 {-0.3921190894737323073826473773806355893612,-0.9199144632357353357221541045873891562223}
#define T_729_230 {-0.4000330868594427213835729162383358925581,-0.9165006979908446593796611523430328816175}
#define T_729_232 {-0.4157713463949855858814430575876031070948,-0.9094691789812895388322999679076019674540}
#define T_729_233 {-0.4235944394258828182842080423142760992050,-0.9058519475540537380098271569295320659876}
#define T_729_235 {-0.4391456463589897829535857454175129532814,-0.8984158843675600358835708902915939688683}
#define T_729_236 {-0.4468726050374945968357565106998663395643,-0.8945976049973548560600988821533974260092}
#define T_729_238 {-0.4622263628697101389697365902975434437394,-0.8867619688891935636476659965410362929106}
#define T_729_239 {-0.4698520214672515238341077292716363444924,-0.8827451942226235415134283357474487274885}
#define T_729_241 {-0.4849980657014033025298260781710268929601,-0.8745152235758376635388344766397494822741}
#define T_729_242 {-0.4925173262118797135045156210253480821848,-0.8703026389602073198403786591370590031147}
#define T_729_244 {-0.5074455312142361895766384805028792470694,-0.8616838357835788775318519583379384130239}
#define T_729_245 {-0.5148533667622017251375154955894686281681,-0.8572782574716483194876559537078719586134}
#define T_729_247 {-0.5295537525317945970471100736176595091820,-0.8482763837214229996064318584103602916002}
#define T_729_248 {-0.5368452107330925482386874136864207684994,-0.8436807569886499713618377427337691187859}
#define T_729_250 {-0.5513079495736786794779504816688131541014,-0.8343018307164776770079583911865483969450}
#define T_729_251 {-0.5584781558462748041193890458089299499989,-0.8295192278920024975263913802336901426315}
#define T_729_253 {-0.5726935789364780982069191850314382463694,-0.8197695192216699622278497372462879866362}
#define T_729_254 {-0.5797377397592804459947046780143864452839,-0.8148031376343618514823674559011124074459}
#define T_729_256 {-0.5936963436165197949279104250308591872454,-0.8046891645700066098001457248756196349859}
#define T_729_257 {-0.6006097497340067148385855944070499390364,-0.7995423244109430838122420936997514218092}
#define T_729_259 {-0.6143022025678901432144130012602545320988,-0.7890708484795512234200032253284007310867}
#define T_729_260 {-0.6210802321384044644148048064380418509245,-0.7837469905823597482452669282793067395687}
#define T_729_262 {-0.6344973800893406457035439416358713060617,-0.7729250123134603356334082491230219602585}
#define T_729_263 {-0.6411355017749441609353766580170486122370,-0.7674276958540071635894719292991794645786}
#define T_729_265 {-0.6542683750338017523162648103607352823019,-0.7562624500995858145557804164127446711063}
#define T_729_266 {-0.6607621510296252109739612023986410349607,-0.7505953502165483293140368914464488625526}
#define T_729_268 {-0.6736019698343483907976292357489001005888,-0.7390943013143083106797348591499030590057}
#define T_729_269 {-0.6799470588354110667239638132741674780846,-0.7332612066522229410381328307266812771559}
#define T_729_271 {-0.6924852393405822592598042319878004491329,-0.7214320434354274391708372604625765234232}
#define T_729_272 {-0.6986773994440992341381502228614408522844,-0.7154368536118548282942697369435336440802}
#define T_729_274 {-0.7109055594595243832145570195280015468597,-0.7032874842690866046268638456240296363831}
#define T_729_275 {-0.7169406510007588773092379597073886543512,-0.6971342072675877910015174165891949087381}
#define T_729_277 {-0.7288506155952406695419654170109424740076,-0.6846727540558619207189394728629849851131}
#define T_729_278 {-0.7347246039150080454405156160646583884954,-0.6783655035465280258577536187658552080393}
#define T_729_280 {-0.7463084108815584150065092217118944972754,-0.6656002973612940021297390558174811303616}
#define T_729_281 {-0.7520173690235292252026511050644330680370,-0.6591432899506214360130229579226579517126}
#define T_729_283 {-0.7632672742023699496982658274646382778883,-0.6460828647562820714611575567687395960093}
#define T_729_284 {-0.7688073855383711352473596889467444270849,-0.6394804171682306748181190414470620453358}
#define T_729_286 {-0.7797158679941611492125730364932678639889,-0.6261335042929038197101476725947577506304}
#define T_729_287 {-0.7850834287757186835676748160040006041527,-0.6193900304830236569486601183598395437002}
#define T_729_289 {-0.7956431958255496539322848548181354999542,-0.6057655527813594620312187544186599552631}
#define T_729_290 {-0.8008346176599674404172901631682179868221,-0.5988855609859147222095998586155474185944}
#define T_729_292 {-0.8110386097487645162829039691132493317127,-0.5849926268738703249994159705238416790962}
#define T_729_293 {-0.8160504219980837525838524015853181481361,-0.5779807165959340853333969789673574268818}
#define T_729_295 {-0.8258918174181526516974827245576307177544,-0.5638286139614953063059488158614840358496}
#define T_729_296 {-0.8307206695193891654582785122329369187355,-0.5566894728960282145990845492633525282145}
#define T_729_298 {-0.8401928889709542325192614953266456723213,-0.5422876628899478967937852758041117340326}
#define T_729_299 {-0.8448355526760610301195697502407710999250,-0.5350260637899191262789599932148121297359}
#define T_729_301 {-0.8539322636657457055164854864415246993303,-0.5203841745006234642545450697070918977261}
#define T_729_302 {-0.8583856351998035982830970169743523001671,-0.5130049719862660451141778139572124928236}
#define T_729_304 {-0.8671007562741130936245781413163058459759,-0.4981327920031576872439416092674946412444}
#define T_729_305 {-0.8713618584103077768787670720485039055347,-0.4906409193164943949305722981080180034041}
#define T_729_307 {-0.8796895632212818894046790774154942482710,-0.4755483911859550993916911920678103342652}
#define T_729_308 {-0.8837555472712789184086545901664067059755,-0.4679488568927615554926546792557928711176}
#define T_729_310 {-0.8916902684716001559195319714490324258804,-0.4526460704712298999119468589924508705735}
#define T_729_311 {-0.8955584161899875494938783049292396754026,-0.4449439551126423419979971640714211389422}
#define T_729_313 {-0.9030948491549369849806794263713527470827,-0.4294411408212092107206103719363454729319}
#define T_729_314 {-0.9067625745564626971173538549919612705708,-0.4216415935172139750619635378825478255749}
#define T_729_316 {-0.9138956809302382078286086652951780706644,-0.4059491155022463271251353944535367190838}
#define T_729_317 {-0.9173605320186272171767427607846911996603,-0.3980573505093220609829529621492838487029}
#define T_729_319 {-0.9240855430826517835640743214753456413746,-0.3821856997136868772102502589405048638582}
#define T_729_320 {-0.9273452034898469475976412468298804014921,-0.3742069929389006399667039204359753057361}
#define T_729_322 {-0.9336576233508152578011163313931319862604,-0.3581667800884208996414770354022039100528}
#define T_729_323 {-0.9367099138855462525654616001702379435301,-0.3501064655623092880531999071536120027304}
#define T_729_325 {-0.9426055224810786503653048384876456111670,-0.3339084140721415017161177729576593264937}
#define T_729_326 {-0.9454484025857242679435898935480508953333,-0.3257718803827338582834727276349440217018}
#define T_729_328 {-0.9509232585056187625482948533317539840937,-0.3094268191884086416365562399732880294323}
#define T_729_329 {-0.9535548276203866802092079524300061166286,-0.3012195058787771051456161330861505120993}
#define T_729_331 {-0.9586052707415827489612070166913326829672,-0.2847383621966959044158329561469145119190}
#define T_729_332 {-0.9610237695750973863084709591930732131004,-0.2764657561284400988377285557362483814359}
#define T_729_334 {-0.9656464235085896463672838763159234076738,-0.2598595481506683069206076197588117793202}
#define T_729_335 {-0.9678502352140367914756780010065995156765,-0.2515271798357659460698698694613995030522}
#define T_729_337 {-0.9720420095621031819632662518415600061417,-0.2348070093640053646044663082648185081780}
#define T_729_338 {-0.9740296608181456816666354825429152697325,-0.2264204492674814217512135883225710131228}
#define T_729_340 {-0.9777877532403812521621944142680149525404,-0.2095974942911469351969344643293879926205}
#define T_729_341 {-0.9795579152361233443713217639015056192875,-0.2011623491070327340857204490021103993058}
#define T_729_343 {-0.9828798133228976441344570957880932837725,-0.1842478563303950878093928622547537088394}
#define T_729_344 {-0.9844313026462394589088944485411047935486,-0.1757697652334669902174368871783372014761}
#define T_729_346 {-0.9873147855983258613932207481411751359701,-0.1587750425568573708900999008619692176580}
#define T_729_347 {-0.9886465650271132332704837608616799116135,-0.1502596734326611949139618218396208249032}
#define T_729_349 {-0.9910897051403672053382365447760093957186,-0.1331960823927642589836750630638562142849}
#define T_729_350 {-0.9922008843358094409836667182389646768570,-0.1246491280484453706423053631624497938901}
#define T_729_352 {-0.9942020482899025513034985124249942600727,-0.1075280762227344422132802037594956345856}
#define T_729_353 {-0.9950918843917935241449868044583126902580,-0.0989552505812072158430936497097718529403}
#define T_729_355 {-0.9966497343421426569065602052432950586081,-0.0817881839615998140757824330648873001337}
#define T_729_356 {-0.9973176324654871027775016045779921114445,-0.0731952182416002322673520552598347421736}
#define T_729_358 {-0.9984311269376477948611636747955344617367,-0.0559936135824322667176033974101301282644}
#define T_729_359 {-0.9988766405703624062795142890536226332188,-0.0473862524670078388844274286384461447597}
#define T_729_361 {-0.9995450351562887858491990300535690039396,-0.0301616096124420057789095039879612158984}
#define T_729_362 {-0.9997678664577099860721887125691864639521,-0.0215456074084403106927432247630349593237}
#define T_729_364 {-0.9999907143134170173226493716356344521046,-0.0043094416044383030209297125168177444721}
#define T_729_365 {-0.9999907143134170173226493716356344521046,0.0043094416044383030209297125168177444721}
#define T_729_368 {-0.9995450351562887858491990300535690039396,0.0301616096124420057789095039879612158984}
#define T_729_370 {-0.9988766405703624062795142890536226332188,0.0473862524670078388844274286384461447597}
#define T_729_374 {-0.9966497343421426569065602052432950586081,0.0817881839615998140757824330648873001337}
#define T_729_376 {-0.9950918843917935241449868044583126902580,0.0989552505812072158430936497097718529403}
#define T_729_380 {-0.9910897051403672053382365447760093957186,0.1331960823927642589836750630638562142849}
#define T_729_382 {-0.9886465650271132332704837608616799116135,0.1502596734326611949139618218396208249032}
#define T_729_385 {-0.9844313026462394589088944485411047935486,0.1757697652334669902174368871783372014761}
#define T_729_386 {-0.9828798133228976441344570957880932837725,0.1842478563303950878093928622547537088394}
#define T_729_388 {-0.9795579152361233443713217639015056192875,0.2011623491070327340857204490021103993058}
#define T_729_392 {-0.9720420095621031819632662518415600061417,0.2348070093640053646044663082648185081780}
#define T_729_394 {-0.9678502352140367914756780010065995156765,0.2515271798357659460698698694613995030522}
#define T_729_395 {-0.9656464235085896463672838763159234076738,0.2598595481506683069206076197588117793202}
#define T_729_398 {-0.9586052707415827489612070166913326829672,0.2847383621966959044158329561469145119190}
#define T_729_400 {-0.9535548276203866802092079524300061166286,0.3012195058787771051456161330861505120993}
#define T_729_404 {-0.9426055224810786503653048384876456111670,0.3339084140721415017161177729576593264937}
#define T_729_406 {-0.9367099138855462525654616001702379435301,0.3501064655623092880531999071536120027304}
#define T_729_410 {-0.9240855430826517835640743214753456413746,0.3821856997136868772102502589405048638582}
#define T_729_412 {-0.9173605320186272171767427607846911996603,0.3980573505093220609829529621492838487029}
#define T_729_416 {-0.9030948491549369849806794263713527470827,0.4294411408212092107206103719363454729319}
#define T_729_418 {-0.8955584161899875494938783049292396754026,0.4449439551126423419979971640714211389422}
#define T_729_422 {-0.8796895632212818894046790774154942482710,0.4755483911859550993916911920678103342652}
#define T_729_424 {-0.8713618584103077768787670720485039055347,0.4906409193164943949305722981080180034041}
#define T_729_428 {-0.8539322636657457055164854864415246993303,0.5203841745006234642545450697070918977261}
#define T_729_430 {-0.8448355526760610301195697502407710999250,0.5350260637899191262789599932148121297359}
#define T_729_434 {-0.8258918174181526516974827245576307177544,0.5638286139614953063059488158614840358496}
#define T_729_436 {-0.8160504219980837525838524015853181481361,0.5779807165959340853333969789673574268818}
#define T_729_440 {-0.7956431958255496539322848548181354999542,0.6057655527813594620312187544186599552631}
#define T_729_442 {-0.7850834287757186835676748160040006041527,0.6193900304830236569486601183598395437002}
#define T_729_446 {-0.7632672742023699496982658274646382778883,0.6460828647562820714611575567687395960093}
#define T_729_448 {-0.7520173690235292252026511050644330680370,0.6591432899506214360130229579226579517126}
#define T_729_452 {-0.7288506155952406695419654170109424740076,0.6846727540558619207189394728629849851131}
#define T_729_454 {-0.7169406510007588773092379597073886543512,0.6971342072675877910015174165891949087381}
#define T_729_458 {-0.6924852393405822592598042319878004491329,0.7214320434354274391708372604625765234232}
#define T_729_460 {-0.6799470588354110667239638132741674780846,0.7332612066522229410381328307266812771559}
#define T_729_464 {-0.6542683750338017523162648103607352823019,0.7562624500995858145557804164127446711063}
#define T_729_466 {-0.6411355017749441609353766580170486122370,0.7674276958540071635894719292991794645786}
#define T_729_470 {-0.6143022025678901432144130012602545320988,0.7890708484795512234200032253284007310867}
#define T_729_472 {-0.6006097497340067148385855944070499390364,0.7995423244109430838122420936997514218092}
#define T_729_476 {-0.5726935789364780982069191850314382463694,0.8197695192216699622278497372462879866362}
#define T_729_478 {-0.5584781558462748041193890458089299499989,0.8295192278920024975263913802336901426315}
#define T_729_482 {-0.5295537525317945970471100736176595091820,0.8482763837214229996064318584103602916002}
#define T_729_484 {-0.5148533667622017251375154955894686281681,0.8572782574716483194876559537078719586134}
// Pre-computed twiddles for N=864
#define T_864_1 {0.9999735576321774344066284356813412159681,-0.0072721411184216390097279081317083182512}
#define T_864_5 {0.9993390107217300366571066660981159657240,-0.0363530143139996486656428942296770401299}
#define T_864_7 {0.9987045980408904011227377850445918738842,-0.0508834536169025311580504933317570248619}
#define T_864_11 {0.9968021652056575643285896148881874978542,-0.0799089697175039831433807080429687630385}
#define T_864_13 {0.9955345474845739284219803266751114279032,-0.0943979065693972135830946967871568631381}
#define T_864_17 {0.9923678501135846374836546601727604866028,-0.1233128138554221014944189960260700900108}
#define T_864_19 {0.9904694403346357978179526071471627801657,-0.1377326677415107725188647691538790240884}
#define T_864_23 {0.9860445064163191331019220342568587511778,-0.1664819250435242703467508817993802949786}
#define T_864_25 {0.9835189183104177113037280832941178232431,-0.1808052469523652727723117550340248271823}
#define T_864_29 {0.9778441709579840379618076440237928181887,-0.2093341284250920253384720126632601022720}
#define T_864_31 {0.9746962121256348421383108870941214263439,-0.2235336530993475012696336534645524807274}
#define T_864_35 {0.9677824535432009156465937849134206771851,-0.2517878523954285574504297073872294276953}
#define T_864_37 {0.9640181163029596378422070301894564181566,-0.2658365502328328133785362297203391790390}
#define T_864_41 {0.9558785072229395440857047105964738875628,-0.2937622838780443723649682397081051021814}
#define T_864_43 {0.9515049572046937464975258080812636762857,-0.3076334123837881628915624787623528391123}
#define T_864_47 {0.9421549918355964781113698336412198841572,-0.3351775221569416318700973533850628882647}
#define T_864_49 {0.9371805543403823879344827219028957188129,-0.3488446768495307992452580947428941726685}
#define T_864_53 {0.9266380308727052428352521928900387138128,-0.3759547309721680830030265951791079714894}
#define T_864_55 {0.9210721750250234762802392651792615652084,-0.3893918956458550795218798157293349504471}
#define T_864_59 {0.9093571617513851457204054895555600523949,-0.4160162885891190431841835106752114370465}
#define T_864_61 {0.9032104824741843396296303581038955599070,-0.4291978848372289268020551844529109075665}
#define T_864_65 {0.8903452795881888759410571765329223126173,-0.4552859355559204512786664054146967828274}
#define T_864_67 {0.8836294774348275593567336727574001997709,-0.4681868714608020121126230606023455038667}
#define T_864_71 {0.8696385745813789425184836545668076723814,-0.4936889198676301937496191385434940457344}
#define T_864_77 {0.8472764631208279384466663941566366702318,-0.5311521392609280800556348367535974830389}
#define T_864_83 {0.8233015127566802870973106109886430203915,-0.5676042803684286930376856616931036114693}
#define T_864_85 {0.8149592551819879737706742162117734551430,-0.5795182588954549407489480472577270120382}
#define T_864_89 {0.7977593611696013331524568457098212093115,-0.6029759544677295579617748444434255361557}
#define T_864_91 {0.7889053631311945258275386549939867109060,-0.6145147093624676593037747807102277874947}
#define T_864_97 {0.7613497448832312608502093098650220781565,-0.6483413961534761904559331924247089773417}
#define T_864_103 {0.7323448541235920705716466727608349174261,-0.6809339282475904697733426473860163241625}
#define T_864_119 {0.6483413961534761904559331924247089773417,-0.7613497448832312608502093098650220781565}
#define T_864_133 {0.5676042803684286930376856616931036114693,-0.8233015127566802870973106109886430203915}
#define T_864_161 {0.3893918956458550795218798157293349504471,-0.9210721750250234762802392651792615652084}
#define T_864_175 {0.2937622838780443723649682397081051021814,-0.9558785072229395440857047105964738875628}
#define T_864_203 {0.0943979065693972135830946967871568631381,-0.9955345474845739284219803266751114279032}
#define T_864_217 {-0.0072721411184216390097279081317083182512,-0.9999735576321774344066284356813412159681}
#define T_864_245 {-0.2093341284250920253384720126632601022720,-0.9778441709579840379618076440237928181887}
#define T_864_259 {-0.3076334123837881628915624787623528391123,-0.9515049572046937464975258080812636762857}
#define T_864_287 {-0.4936889198676301937496191385434940457344,-0.8696385745813789425184836545668076723814}
#define T_864_301 {-0.5795182588954549407489480472577270120382,-0.8149592551819879737706742162117734551430}
#define T_864_329 {-0.7323448541235920705716466727608349174261,-0.6809339282475904697733426473860163241625}
#define T_864_343 {-0.7977593611696013331524568457098212093115,-0.6029759544677295579617748444434255361557}
#define T_864_371 {-0.9032104824741843396296303581038955599070,-0.4291978848372289268020551844529109075665}
#define T_864_385 {-0.9421549918355964781113698336412198841572,-0.3351775221569416318700973533850628882647}
#define T_864_413 {-0.9904694403346357978179526071471627801657,-0.1377326677415107725188647691538790240884}
#define T_864_427 {-0.9993390107217300366571066660981159657240,-0.0363530143139996486656428942296770401299}
#define T_864_455 {-0.9860445064163191331019220342568587511778,0.1664819250435242703467508817993802949786}
#define T_864_469 {-0.9640181163029596378422070301894564181566,0.2658365502328328133785362297203391790390}
#define T_864_497 {-0.8903452795881888759410571765329223126173,0.4552859355559204512786664054146967828274}
// Pre-computed twiddles for N=1000
#define T_1000_1 {0.9999802608561371153328423133643809705973,-0.0062831439655589510842603750973012211034}
#define T_1000_3 {0.9998223523808089652220587595365941524506,-0.0188484397154081752268073302047923789360}
#define T_1000_7 {0.9990329346781247066289211034018080681562,-0.0439681183178649015452776893653208389878}
#define T_1000_9 {0.9984015501089750221908047933538910001516,-0.0565185344820245266772573700109205674380}
#define T_1000_11 {0.9976125063612252263922641759563703089952,-0.0690600257144057955160931783211708534509}
#define T_1000_13 {0.9966659280340298687761446672084275633097,-0.0815906115681575561104921234800713136792}
#define T_1000_17 {0.9943007903969989236259152676211670041084,-0.1066111542752599117278577978140674531460}
#define T_1000_19 {0.9928826045698136981698667113960254937410,-0.1190971600948697445288004814756277482957}
#define T_1000_21 {0.9913076310695065895828292923397384583950,-0.1315643590922825068023627181901247240603}
#define T_1000_23 {0.9895761186026509337310130831610877066851,-0.1440107825522521645122964173424406908453}
#define T_1000_27 {0.9856445951489980483728459148551337420940,-0.1688334447127338711069910459627863019705}
#define T_1000_29 {0.9834452049953297247952832549344748258591,-0.1812057636271373617375957110198214650154}
#define T_1000_31 {0.9810905174433340869555308927374426275492,-0.1935494680508602627355685399379581212997}
#define T_1000_33 {0.9785809043254720673843394251889549195766,-0.2058626087698813278414888827683171257377}
#define T_1000_37 {0.9730985109821265188756456154806073755026,-0.2303894266765905973759487324059591628611}
#define T_1000_39 {0.9701265964901057969882458564825356006622,-0.2425992307954074334030991622057626955211}
#define T_1000_41 {0.9670014877624351079532516450854018330574,-0.2547707256833821598540623654116643592715}
#define T_1000_43 {0.9637236782900097109560988428711425513029,-0.2669019893203755655619602293882053345442}
#define T_1000_47 {0.9567120515588304341392245078168343752623,-0.2910361668282718250466700737888459116220}
#define T_1000_49 {0.9529793415172188586481638594705145806074,-0.3030352696327739958626068528246833011508}
#define T_1000_51 {0.9490961449902945989975933116511441767216,-0.3149865196553047752558995853178203105927}
#define T_1000_53 {0.9450630751798048123646367457695305347443,-0.3268880296549424580021536712592933326960}
#define T_1000_57 {0.9365498867481923950251143651257734745741,-0.3505343201912590189728291534265736117959}
#define T_1000_59 {0.9320711124582109485814385152480099350214,-0.3622753667045456871242947727296268567443}
#define T_1000_61 {0.9274451533346612652763951700762845575809,-0.3739592057378004485990174998732982203364}
#define T_1000_63 {0.9226727398701148885606926342006772756577,-0.3855839922773965366964432632812531664968}
#define T_1000_67 {0.9126915874035027576027800932934042066336,-0.4086490747363490383392559124331455677748}
#define T_1000_69 {0.9074844245411168852655237060389481484890,-0.4200857284118062473510235577123239636421}
#define T_1000_71 {0.9021339593682028423771157576993573457003,-0.4314560456809589661375525793118868023157}
#define T_1000_73 {0.8966410367852358787033040243841242045164,-0.4427582310389015507468002397217787802219}
#define T_1000_77 {0.8852313113324552507066300677252002060413,-0.4651510780774583686536516324849799275398}
#define T_1000_79 {0.8793163101905562273330474454269278794527,-0.4762382036679391195121979762916453182697}
#define T_1000_81 {0.8732624548099201522433077116147615015507,-0.4872501257253323281304346892284229397774}
#define T_1000_83 {0.8670707011644900319424777990207076072693,-0.4981851053394908412919050988421076908708}
#define T_1000_87 {0.8542774316992951533222822035895660519600,-0.5198173426207094438566969074599910527468}
#define T_1000_89 {0.8476779360850832389928655175026506185532,-0.5305111843067340515744945150800049304962}
#define T_1000_91 {0.8409445822981690410458099904644768685102,-0.5411212521268758957049271884898189455271}
#define T_1000_93 {0.8340784336131711329542781641066540032625,-0.5516458706284302904165883774112444370985}
#define T_1000_97 {0.8199521093254523718130144516180735081434,-0.5724321255945908903939312040165532380342}
#define T_1000_99 {0.8126941644330939462648188964521978050470,-0.5826904796685760112850971381703857332468}
#define T_1000_101 {0.8053078857111219956976810863125137984753,-0.5928568201610592280914602270058821886778}
#define T_1000_103 {0.7977944395385709874801705154823139309883,-0.6029295416890246839258793443150352686644}
#define T_1000_107 {0.7823908105765881026982810908521059900522,-0.6227877804881124523816993132641073316336}
#define T_1000_109 {0.7745030601987338281233519410307053476572,-0.6325701619131244290983318023791071027517}
#define T_1000_111 {0.7664930068093498416459397049038670957088,-0.6422526531765844204358018032507970929146}
#define T_1000_113 {0.7583619152887218772818300749349873512983,-0.6518337253008787968155957059934735298157}
#define T_1000_117 {0.7417417727387392023530310325440950691700,-0.6706855765367200072901709972938988357782}
#define T_1000_119 {0.7332553462225600560131510974315460771322,-0.6799533787224192327158789339591749012470}
#define T_1000_121 {0.7246531301870466901249301372445188462734,-0.6891138083873484809771525760879740118980}
#define T_1000_123 {0.7159364830218312159004767636361066251993,-0.6981654189934727305910655559273436665535}
#define T_1000_129 {0.6891138083873484809771525760879740118980,-0.7246531301870466901249301372445188462734}
#define T_1000_141 {0.6325701619131244290983318023791071027517,-0.7745030601987338281233519410307053476572}
#define T_1000_147 {0.6029295416890246839258793443150352686644,-0.7977944395385709874801705154823139309883}
#define T_1000_153 {0.5724321255945908903939312040165532380342,-0.8199521093254523718130144516180735081434}
#define T_1000_159 {0.5411212521268758957049271884898189455271,-0.8409445822981690410458099904644768685102}
#define T_1000_171 {0.4762382036679391195121979762916453182697,-0.8793163101905562273330474454269278794527}
#define T_1000_177 {0.4427582310389015507468002397217787802219,-0.8966410367852358787033040243841242045164}
#define T_1000_183 {0.4086490747363490383392559124331455677748,-0.9126915874035027576027800932934042066336}
#define T_1000_189 {0.3739592057378004485990174998732982203364,-0.9274451533346612652763951700762845575809}
#define T_1000_201 {0.3030352696327739958626068528246833011508,-0.9529793415172188586481638594705145806074}
#define T_1000_207 {0.2669019893203755655619602293882053345442,-0.9637236782900097109560988428711425513029}
#define T_1000_213 {0.2303894266765905973759487324059591628611,-0.9730985109821265188756456154806073755026}
#define T_1000_219 {0.1935494680508602627355685399379581212997,-0.9810905174433340869555308927374426275492}
#define T_1000_231 {0.1190971600948697445288004814756277482957,-0.9928826045698136981698667113960254937410}
#define T_1000_237 {0.0815906115681575561104921234800713136792,-0.9966659280340298687761446672084275633097}
#define T_1000_243 {0.0439681183178649015452776893653208389878,-0.9990329346781247066289211034018080681562}
#define T_1000_249 {0.0062831439655589510842603750973012211034,-0.9999802608561371153328423133643809705973}
#define T_1000_261 {-0.0690600257144057955160931783211708534509,-0.9976125063612252263922641759563703089952}
#define T_1000_267 {-0.1066111542752599117278577978140674531460,-0.9943007903969989236259152676211670041084}
#define T_1000_273 {-0.1440107825522521645122964173424406908453,-0.9895761186026509337310130831610877066851}
#define T_1000_279 {-0.1812057636271373617375957110198214650154,-0.9834452049953297247952832549344748258591}
#define T_1000_291 {-0.2547707256833821598540623654116643592715,-0.9670014877624351079532516450854018330574}
#define T_1000_297 {-0.2910361668282718250466700737888459116220,-0.9567120515588304341392245078168343752623}
#define T_1000_303 {-0.3268880296549424580021536712592933326960,-0.9450630751798048123646367457695305347443}
#define T_1000_309 {-0.3622753667045456871242947727296268567443,-0.9320711124582109485814385152480099350214}
#define T_1000_321 {-0.4314560456809589661375525793118868023157,-0.9021339593682028423771157576993573457003}
#define T_1000_327 {-0.4651510780774583686536516324849799275398,-0.8852313113324552507066300677252002060413}
#define T_1000_333 {-0.4981851053394908412919050988421076908708,-0.8670707011644900319424777990207076072693}
#define T_1000_339 {-0.5305111843067340515744945150800049304962,-0.8476779360850832389928655175026506185532}
#define T_1000_351 {-0.5928568201610592280914602270058821886778,-0.8053078857111219956976810863125137984753}
#define T_1000_357 {-0.6227877804881124523816993132641073316336,-0.7823908105765881026982810908521059900522}
#define T_1000_363 {-0.6518337253008787968155957059934735298157,-0.7583619152887218772818300749349873512983}
#define T_1000_369 {-0.6799533787224192327158789339591749012470,-0.7332553462225600560131510974315460771322}
#define T_1000_381 {-0.7332553462225600560131510974315460771322,-0.6799533787224192327158789339591749012470}
#define T_1000_387 {-0.7583619152887218772818300749349873512983,-0.6518337253008787968155957059934735298157}
#define T_1000_393 {-0.7823908105765881026982810908521059900522,-0.6227877804881124523816993132641073316336}
#define T_1000_399 {-0.8053078857111219956976810863125137984753,-0.5928568201610592280914602270058821886778}
#define T_1000_411 {-0.8476779360850832389928655175026506185532,-0.5305111843067340515744945150800049304962}
#define T_1000_417 {-0.8670707011644900319424777990207076072693,-0.4981851053394908412919050988421076908708}
#define T_1000_423 {-0.8852313113324552507066300677252002060413,-0.4651510780774583686536516324849799275398}
#define T_1000_429 {-0.9021339593682028423771157576993573457003,-0.4314560456809589661375525793118868023157}
#define T_1000_441 {-0.9320711124582109485814385152480099350214,-0.3622753667045456871242947727296268567443}
#define T_1000_447 {-0.9450630751798048123646367457695305347443,-0.3268880296549424580021536712592933326960}
#define T_1000_453 {-0.9567120515588304341392245078168343752623,-0.2910361668282718250466700737888459116220}
#define T_1000_459 {-0.9670014877624351079532516450854018330574,-0.2547707256833821598540623654116643592715}
#define T_1000_471 {-0.9834452049953297247952832549344748258591,-0.1812057636271373617375957110198214650154}
#define T_1000_477 {-0.9895761186026509337310130831610877066851,-0.1440107825522521645122964173424406908453}
#define T_1000_483 {-0.9943007903969989236259152676211670041084,-0.1066111542752599117278577978140674531460}
#define T_1000_489 {-0.9976125063612252263922641759563703089952,-0.0690600257144057955160931783211708534509}
#define T_1000_501 {-0.9999802608561371153328423133643809705973,0.0062831439655589510842603750973012211034}
#define T_1000_507 {-0.9990329346781247066289211034018080681562,0.0439681183178649015452776893653208389878}
#define T_1000_513 {-0.9966659280340298687761446672084275633097,0.0815906115681575561104921234800713136792}
#define T_1000_519 {-0.9928826045698136981698667113960254937410,0.1190971600948697445288004814756277482957}
#define T_1000_531 {-0.9810905174433340869555308927374426275492,0.1935494680508602627355685399379581212997}
#define T_1000_537 {-0.9730985109821265188756456154806073755026,0.2303894266765905973759487324059591628611}
#define T_1000_543 {-0.9637236782900097109560988428711425513029,0.2669019893203755655619602293882053345442}
#define T_1000_549 {-0.9529793415172188586481638594705145806074,0.3030352696327739958626068528246833011508}
#define T_1000_561 {-0.9274451533346612652763951700762845575809,0.3739592057378004485990174998732982203364}
#define T_1000_567 {-0.9126915874035027576027800932934042066336,0.4086490747363490383392559124331455677748}
#define T_1000_573 {-0.8966410367852358787033040243841242045164,0.4427582310389015507468002397217787802219}
#define T_1000_579 {-0.8793163101905562273330474454269278794527,0.4762382036679391195121979762916453182697}
#define T_1000_591 {-0.8409445822981690410458099904644768685102,0.5411212521268758957049271884898189455271}
#define T_1000_597 {-0.8199521093254523718130144516180735081434,0.5724321255945908903939312040165532380342}
// Pre-computed twiddles for N=1024
#define T_1024_1 {0.9999811752826011090888869148329831659794,-0.0061358846491544752690949771078976482386}
#define T_1024_3 {0.9998305817958234031905817573715467005968,-0.0184067299058048201854109748865084839053}
#define T_1024_5 {0.9995294175010931425617854984011501073837,-0.0306748031766366259509570824093316332437}
#define T_1024_7 {0.9990777277526453614697743432770948857069,-0.0429382569349408202419304814156930660829}
#define T_1024_9 {0.9984755805732947742114902212051674723625,-0.0551952443496899411434775117868412053213}
#define T_1024_11 {0.9977230666441916362430220033274963498116,-0.0674439195636640648201520775728567969054}
#define T_1024_13 {0.9968202992911656679098086897283792495728,-0.0796824379714301256338870871331891976297}
#define T_1024_15 {0.9957674144676598171344039656105451285839,-0.0919089564971327238618314936502429191023}
#define T_1024_17 {0.9945645707342554153740366018610075116158,-0.1041216338720545725449184715216688346118}
#define T_1024_19 {0.9932119492347945000076947508205194026232,-0.1163186309119047662230528317195421550423}
#define T_1024_21 {0.9917097536690995251973390622879378497601,-0.1284981107937931688045551936738775111735}
#define T_1024_23 {0.9900582102622971225613923706987407058477,-0.1406582393328492386341821429596166126430}
#define T_1024_25 {0.9882575677307494643741847539786249399185,-0.1527971852584434353516940063855145126581}
#define T_1024_27 {0.9863080972445986693841746273392345756292,-0.1649131204899699221222419964760774746537}
#define T_1024_29 {0.9842100923869290252099517601891420781612,-0.1770042204121487494639097803883487358689}
#define T_1024_31 {0.9819638691095552429644044423184823244810,-0.1890686641498062203758934174402384087443}
#define T_1024_33 {0.9795697656854405188653345248894765973091,-0.2011046348420919005484108765813289210200}
#define T_1024_35 {0.9770281426577543948397419626417104154825,-0.2131103199160913619358836967876413837075}
#define T_1024_37 {0.9743393827855758582145995205792132765055,-0.2250839113597928320409380376077024266124}
#define T_1024_39 {0.9715038909862517835236417340638581663370,-0.2370236059943671980132506860172725282609}
#define T_1024_41 {0.9685220942744172667460134107386693358421,-0.2489276057457201762890264262750861234963}
#define T_1024_43 {0.9653944416976893982962337759090587496758,-0.2607941179152755140080444107297807931900}
#define T_1024_45 {0.9621214042690415801928338623838499188423,-0.2726213554499489766236308696534251794219}
#define T_1024_47 {0.9587034748958715990596601841389201581478,-0.2844075372112718214090421042783418670297}
#define T_1024_49 {0.9551411683057706714095047573209740221500,-0.2961508882436238443425224886595970019698}
#define T_1024_51 {0.9514350209690083381985914456890895962715,-0.3078496400415348666079751183133339509368}
#define T_1024_53 {0.9475855910177410912353934691054746508598,-0.3195020308160156918830807626363821327686}
#define T_1024_55 {0.9435934581619603855884292897826526314020,-0.3311063057598764292066562120453454554081}
#define T_1024_57 {0.9394592236021899189779560401802882552147,-0.3426607173119943783312635332549689337611}
#define T_1024_59 {0.9351835099389476102516027822275646030903,-0.3541635254204903993091591019037878140807}
#define T_1024_61 {0.9307669610789837122410972369834780693054,-0.3656129978047738537938471381494309753180}
#define T_1024_63 {0.9262102421383113792785479745361953973770,-0.3770074102164182594520980273955501616001}
#define T_1024_65 {0.9215140393420419018255529408634174615145,-0.3883450466988263016787641390692442655563}
#define T_1024_67 {0.9166790599210427048504357117053586989641,-0.3996241998456468436096145069313934072852}
#define T_1024_69 {0.9117060320054298783176705001096706837416,-0.4108431710579039664033018652844475582242}
#define T_1024_71 {0.9065957045149153348262416329816915094852,-0.4220002707997996815869612419191980734468}
#define T_1024_73 {0.9013488470460220280955354610341601073742,-0.4330938188531519572599393086420604959130}
#define T_1024_75 {0.8959662497561851068894611671566963195801,-0.4441221445704292558609438401617808267474}
#define T_1024_77 {0.8904487232447578781702191008662339299917,-0.4550835871263438359157760260131908580661}
#define T_1024_79 {0.8847970984309377895371540034830104559660,-0.4659764957679661812051108427112922072411}
#define T_1024_81 {0.8790122264286335251881610020063817501068,-0.4767992300633221436356734557193703949451}
#define T_1024_83 {0.8730949784182900907936186740698758512735,-0.4875501601484359404103940960339969024062}
#define T_1024_85 {0.8670462455156926484534096744027920067310,-0.4982276669727818685373676999006420373917}
#define T_1024_87 {0.8608669386377673093946327753656078130007,-0.5088301425431069890947810563375242054462}
#define T_1024_89 {0.8545579883654005337589865121117327362299,-0.5193559901655896426930780762631911784410}
#define T_1024_91 {0.8481203448032972325165701477089896798134,-0.5298036246862947162838963777176104485989}
#define T_1024_93 {0.8415549774368984436989649111637845635414,-0.5401714727298928542253975138009991496801}
#define T_1024_95 {0.8348628749863800102559707738691940903664,-0.5504579729366048113092801941093057394028}
#define T_1024_97 {0.8280450452577557962641208177956286817789,-0.5606615761973360312353520384931471198797}
#define T_1024_99 {0.8211025149911046483452992106322199106216,-0.5707807458869672556645014083187561482191}
#define T_1024_101 {0.8140363297059484137818685667298268526793,-0.5808139580957645264902566850651055574417}
#define T_1024_103 {0.8068475535437992229859105464129243046045,-0.5907597018588742754374720789201091974974}
#define T_1024_105 {0.7995372691079050131435224102460779249668,-0.6006164793838689730520741250074934214354}
#define T_1024_107 {0.7921065773002123888701930809475015848875,-0.6103828062763094752796177999698556959629}
#define T_1024_109 {0.7845565971555752415866891169571317732334,-0.6200572117632892066296790289925411343575}
#define T_1024_111 {0.7768884656732324422989677259465679526329,-0.6296382389149269842576472910877782851458}
#define T_1024_113 {0.7691033376455795878001708842930383980274,-0.6391244448637757313846918805211316794157}
#define T_1024_115 {0.7612023854842617787141989538213238120079,-0.6485144010221124410975335194962099194527}
#define T_1024_117 {0.7531867990436125204212203243514522910118,-0.6578066932970786373502392052614595741034}
#define T_1024_119 {0.7450577854414659473292203983874060213566,-0.6669999223036374713657892243645619601011}
#define T_1024_121 {0.7368165688773699040226006218290422111750,-0.6760927035753159231035169796086847782135}
#define T_1024_123 {0.7284643904482251963727890142763499170542,-0.6850836677727003554139173502335324883461}
#define T_1024_125 {0.7200025079613816547663418532465584576130,-0.6939714608896540015692266933911014348269}
#define T_1024_127 {0.7114321957452164335578004283888731151819,-0.7027547444572252999250849825330078601837}
#define T_1024_129 {0.7027547444572252999250849825330078601837,-0.7114321957452164335578004283888731151819}
#define T_1024_131 {0.6939714608896540015692266933911014348269,-0.7200025079613816547663418532465584576130}
#define T_1024_133 {0.6850836677727003554139173502335324883461,-0.7284643904482251963727890142763499170542}
#define T_1024_135 {0.6760927035753159231035169796086847782135,-0.7368165688773699040226006218290422111750}
#define T_1024_137 {0.6669999223036374713657892243645619601011,-0.7450577854414659473292203983874060213566}
#define T_1024_139 {0.6578066932970786373502392052614595741034,-0.7531867990436125204212203243514522910118}
#define T_1024_141 {0.6485144010221124410975335194962099194527,-0.7612023854842617787141989538213238120079}
#define T_1024_143 {0.6391244448637757313846918805211316794157,-0.7691033376455795878001708842930383980274}
#define T_1024_145 {0.6296382389149269842576472910877782851458,-0.7768884656732324422989677259465679526329}
#define T_1024_147 {0.6200572117632892066296790289925411343575,-0.7845565971555752415866891169571317732334}
#define T_1024_149 {0.6103828062763094752796177999698556959629,-0.7921065773002123888701930809475015848875}
#define T_1024_151 {0.6006164793838689730520741250074934214354,-0.7995372691079050131435224102460779249668}
#define T_1024_153 {0.5907597018588742754374720789201091974974,-0.8068475535437992229859105464129243046045}
#define T_1024_155 {0.5808139580957645264902566850651055574417,-0.8140363297059484137818685667298268526793}
#define T_1024_157 {0.5707807458869672556645014083187561482191,-0.8211025149911046483452992106322199106216}
#define T_1024_159 {0.5606615761973360312353520384931471198797,-0.8280450452577557962641208177956286817789}
#define T_1024_161 {0.5504579729366048113092801941093057394028,-0.8348628749863800102559707738691940903664}
#define T_1024_163 {0.5401714727298928542253975138009991496801,-0.8415549774368984436989649111637845635414}
#define T_1024_165 {0.5298036246862947162838963777176104485989,-0.8481203448032972325165701477089896798134}
#define T_1024_167 {0.5193559901655896426930780762631911784410,-0.8545579883654005337589865121117327362299}
#define T_1024_169 {0.5088301425431069890947810563375242054462,-0.8608669386377673093946327753656078130007}
#define T_1024_171 {0.4982276669727818685373676999006420373917,-0.8670462455156926484534096744027920067310}
#define T_1024_173 {0.4875501601484359404103940960339969024062,-0.8730949784182900907936186740698758512735}
#define T_1024_175 {0.4767992300633221436356734557193703949451,-0.8790122264286335251881610020063817501068}
#define T_1024_177 {0.4659764957679661812051108427112922072411,-0.8847970984309377895371540034830104559660}
#define T_1024_179 {0.4550835871263438359157760260131908580661,-0.8904487232447578781702191008662339299917}
#define T_1024_181 {0.4441221445704292558609438401617808267474,-0.8959662497561851068894611671566963195801}
#define T_1024_183 {0.4330938188531519572599393086420604959130,-0.9013488470460220280955354610341601073742}
#define T_1024_185 {0.4220002707997996815869612419191980734468,-0.9065957045149153348262416329816915094852}
#define T_1024_187 {0.4108431710579039664033018652844475582242,-0.9117060320054298783176705001096706837416}
#define T_1024_189 {0.3996241998456468436096145069313934072852,-0.9166790599210427048504357117053586989641}
#define T_1024_191 {0.3883450466988263016787641390692442655563,-0.9215140393420419018255529408634174615145}
#define T_1024_193 {0.3770074102164182594520980273955501616001,-0.9262102421383113792785479745361953973770}
#define T_1024_195 {0.3656129978047738537938471381494309753180,-0.9307669610789837122410972369834780693054}
#define T_1024_197 {0.3541635254204903993091591019037878140807,-0.9351835099389476102516027822275646030903}
#define T_1024_199 {0.3426607173119943783312635332549689337611,-0.9394592236021899189779560401802882552147}
#define T_1024_201 {0.3311063057598764292066562120453454554081,-0.9435934581619603855884292897826526314020}
#define T_1024_203 {0.3195020308160156918830807626363821327686,-0.9475855910177410912353934691054746508598}
#define T_1024_205 {0.3078496400415348666079751183133339509368,-0.9514350209690083381985914456890895962715}
#define T_1024_207 {0.2961508882436238443425224886595970019698,-0.9551411683057706714095047573209740221500}
#define T_1024_209 {0.2844075372112718214090421042783418670297,-0.9587034748958715990596601841389201581478}
#define T_1024_211 {0.2726213554499489766236308696534251794219,-0.9621214042690415801928338623838499188423}
#define T_1024_213 {0.2607941179152755140080444107297807931900,-0.9653944416976893982962337759090587496758}
#define T_1024_215 {0.2489276057457201762890264262750861234963,-0.9685220942744172667460134107386693358421}
#define T_1024_217 {0.2370236059943671980132506860172725282609,-0.9715038909862517835236417340638581663370}
#define T_1024_219 {0.2250839113597928320409380376077024266124,-0.9743393827855758582145995205792132765055}
#define T_1024_221 {0.2131103199160913619358836967876413837075,-0.9770281426577543948397419626417104154825}
#define T_1024_223 {0.2011046348420919005484108765813289210200,-0.9795697656854405188653345248894765973091}
#define T_1024_225 {0.1890686641498062203758934174402384087443,-0.9819638691095552429644044423184823244810}
#define T_1024_227 {0.1770042204121487494639097803883487358689,-0.9842100923869290252099517601891420781612}
#define T_1024_229 {0.1649131204899699221222419964760774746537,-0.9863080972445986693841746273392345756292}
#define T_1024_231 {0.1527971852584434353516940063855145126581,-0.9882575677307494643741847539786249399185}
#define T_1024_233 {0.1406582393328492386341821429596166126430,-0.9900582102622971225613923706987407058477}
#define T_1024_235 {0.1284981107937931688045551936738775111735,-0.9917097536690995251973390622879378497601}
#define T_1024_237 {0.1163186309119047662230528317195421550423,-0.9932119492347945000076947508205194026232}
#define T_1024_239 {0.1041216338720545725449184715216688346118,-0.9945645707342554153740366018610075116158}
#define T_1024_241 {0.0919089564971327238618314936502429191023,-0.9957674144676598171344039656105451285839}
#define T_1024_243 {0.0796824379714301256338870871331891976297,-0.9968202992911656679098086897283792495728}
#define T_1024_245 {0.0674439195636640648201520775728567969054,-0.9977230666441916362430220033274963498116}
#define T_1024_247 {0.0551952443496899411434775117868412053213,-0.9984755805732947742114902212051674723625}
#define T_1024_249 {0.0429382569349408202419304814156930660829,-0.9990777277526453614697743432770948857069}
#define T_1024_251 {0.0306748031766366259509570824093316332437,-0.9995294175010931425617854984011501073837}
#define T_1024_253 {0.0184067299058048201854109748865084839053,-0.9998305817958234031905817573715467005968}
#define T_1024_255 {0.0061358846491544752690949771078976482386,-0.9999811752826011090888869148329831659794}
#define T_1024_257 {-0.0061358846491544752690949771078976482386,-0.9999811752826011090888869148329831659794}
#define T_1024_259 {-0.0184067299058048201854109748865084839053,-0.9998305817958234031905817573715467005968}
#define T_1024_261 {-0.0306748031766366259509570824093316332437,-0.9995294175010931425617854984011501073837}
#define T_1024_263 {-0.0429382569349408202419304814156930660829,-0.9990777277526453614697743432770948857069}
#define T_1024_265 {-0.0551952443496899411434775117868412053213,-0.9984755805732947742114902212051674723625}
#define T_1024_267 {-0.0674439195636640648201520775728567969054,-0.9977230666441916362430220033274963498116}
#define T_1024_269 {-0.0796824379714301256338870871331891976297,-0.9968202992911656679098086897283792495728}
#define T_1024_271 {-0.0919089564971327238618314936502429191023,-0.9957674144676598171344039656105451285839}
#define T_1024_273 {-0.1041216338720545725449184715216688346118,-0.9945645707342554153740366018610075116158}
#define T_1024_275 {-0.1163186309119047662230528317195421550423,-0.9932119492347945000076947508205194026232}
#define T_1024_277 {-0.1284981107937931688045551936738775111735,-0.9917097536690995251973390622879378497601}
#define T_1024_279 {-0.1406582393328492386341821429596166126430,-0.9900582102622971225613923706987407058477}
#define T_1024_281 {-0.1527971852584434353516940063855145126581,-0.9882575677307494643741847539786249399185}
#define T_1024_283 {-0.1649131204899699221222419964760774746537,-0.9863080972445986693841746273392345756292}
#define T_1024_285 {-0.1770042204121487494639097803883487358689,-0.9842100923869290252099517601891420781612}
#define T_1024_287 {-0.1890686641498062203758934174402384087443,-0.9819638691095552429644044423184823244810}
#define T_1024_289 {-0.2011046348420919005484108765813289210200,-0.9795697656854405188653345248894765973091}
#define T_1024_291 {-0.2131103199160913619358836967876413837075,-0.9770281426577543948397419626417104154825}
#define T_1024_293 {-0.2250839113597928320409380376077024266124,-0.9743393827855758582145995205792132765055}
#define T_1024_295 {-0.2370236059943671980132506860172725282609,-0.9715038909862517835236417340638581663370}
#define T_1024_297 {-0.2489276057457201762890264262750861234963,-0.9685220942744172667460134107386693358421}
#define T_1024_299 {-0.2607941179152755140080444107297807931900,-0.9653944416976893982962337759090587496758}
#define T_1024_301 {-0.2726213554499489766236308696534251794219,-0.9621214042690415801928338623838499188423}
#define T_1024_303 {-0.2844075372112718214090421042783418670297,-0.9587034748958715990596601841389201581478}
#define T_1024_305 {-0.2961508882436238443425224886595970019698,-0.9551411683057706714095047573209740221500}
#define T_1024_307 {-0.3078496400415348666079751183133339509368,-0.9514350209690083381985914456890895962715}
#define T_1024_309 {-0.3195020308160156918830807626363821327686,-0.9475855910177410912353934691054746508598}
#define T_1024_311 {-0.3311063057598764292066562120453454554081,-0.9435934581619603855884292897826526314020}
#define T_1024_313 {-0.3426607173119943783312635332549689337611,-0.9394592236021899189779560401802882552147}
#define T_1024_315 {-0.3541635254204903993091591019037878140807,-0.9351835099389476102516027822275646030903}
#define T_1024_317 {-0.3656129978047738537938471381494309753180,-0.9307669610789837122410972369834780693054}
#define T_1024_319 {-0.3770074102164182594520980273955501616001,-0.9262102421383113792785479745361953973770}
#define T_1024_321 {-0.3883450466988263016787641390692442655563,-0.9215140393420419018255529408634174615145}
#define T_1024_323 {-0.3996241998456468436096145069313934072852,-0.9166790599210427048504357117053586989641}
#define T_1024_325 {-0.4108431710579039664033018652844475582242,-0.9117060320054298783176705001096706837416}
#define T_1024_327 {-0.4220002707997996815869612419191980734468,-0.9065957045149153348262416329816915094852}
#define T_1024_329 {-0.4330938188531519572599393086420604959130,-0.9013488470460220280955354610341601073742}
#define T_1024_331 {-0.4441221445704292558609438401617808267474,-0.8959662497561851068894611671566963195801}
#define T_1024_333 {-0.4550835871263438359157760260131908580661,-0.8904487232447578781702191008662339299917}
#define T_1024_335 {-0.4659764957679661812051108427112922072411,-0.8847970984309377895371540034830104559660}
#define T_1024_337 {-0.4767992300633221436356734557193703949451,-0.8790122264286335251881610020063817501068}
#define T_1024_339 {-0.4875501601484359404103940960339969024062,-0.8730949784182900907936186740698758512735}
#define T_1024_341 {-0.4982276669727818685373676999006420373917,-0.8670462455156926484534096744027920067310}
#define T_1024_343 {-0.5088301425431069890947810563375242054462,-0.8608669386377673093946327753656078130007}
#define T_1024_345 {-0.5193559901655896426930780762631911784410,-0.8545579883654005337589865121117327362299}
#define T_1024_347 {-0.5298036246862947162838963777176104485989,-0.8481203448032972325165701477089896798134}
#define T_1024_349 {-0.5401714727298928542253975138009991496801,-0.8415549774368984436989649111637845635414}
#define T_1024_351 {-0.5504579729366048113092801941093057394028,-0.8348628749863800102559707738691940903664}
#define T_1024_353 {-0.5606615761973360312353520384931471198797,-0.8280450452577557962641208177956286817789}
#define T_1024_355 {-0.5707807458869672556645014083187561482191,-0.8211025149911046483452992106322199106216}
#define T_1024_357 {-0.5808139580957645264902566850651055574417,-0.8140363297059484137818685667298268526793}
#define T_1024_359 {-0.5907597018588742754374720789201091974974,-0.8068475535437992229859105464129243046045}
#define T_1024_361 {-0.6006164793838689730520741250074934214354,-0.7995372691079050131435224102460779249668}
#define T_1024_363 {-0.6103828062763094752796177999698556959629,-0.7921065773002123888701930809475015848875}
#define T_1024_365 {-0.6200572117632892066296790289925411343575,-0.7845565971555752415866891169571317732334}
#define T_1024_367 {-0.6296382389149269842576472910877782851458,-0.7768884656732324422989677259465679526329}
#define T_1024_369 {-0.6391244448637757313846918805211316794157,-0.7691033376455795878001708842930383980274}
#define T_1024_371 {-0.6485144010221124410975335194962099194527,-0.7612023854842617787141989538213238120079}
#define T_1024_373 {-0.6578066932970786373502392052614595741034,-0.7531867990436125204212203243514522910118}
#define T_1024_375 {-0.6669999223036374713657892243645619601011,-0.7450577854414659473292203983874060213566}
#define T_1024_377 {-0.6760927035753159231035169796086847782135,-0.7368165688773699040226006218290422111750}
#define T_1024_379 {-0.6850836677727003554139173502335324883461,-0.7284643904482251963727890142763499170542}
#define T_1024_381 {-0.6939714608896540015692266933911014348269,-0.7200025079613816547663418532465584576130}
#define T_1024_383 {-0.7027547444572252999250849825330078601837,-0.7114321957452164335578004283888731151819}
#define T_1024_385 {-0.7114321957452164335578004283888731151819,-0.7027547444572252999250849825330078601837}
#define T_1024_387 {-0.7200025079613816547663418532465584576130,-0.6939714608896540015692266933911014348269}
#define T_1024_389 {-0.7284643904482251963727890142763499170542,-0.6850836677727003554139173502335324883461}
#define T_1024_391 {-0.7368165688773699040226006218290422111750,-0.6760927035753159231035169796086847782135}
#define T_1024_393 {-0.7450577854414659473292203983874060213566,-0.6669999223036374713657892243645619601011}
#define T_1024_395 {-0.7531867990436125204212203243514522910118,-0.6578066932970786373502392052614595741034}
#define T_1024_397 {-0.7612023854842617787141989538213238120079,-0.6485144010221124410975335194962099194527}
#define T_1024_399 {-0.7691033376455795878001708842930383980274,-0.6391244448637757313846918805211316794157}
#define T_1024_401 {-0.7768884656732324422989677259465679526329,-0.6296382389149269842576472910877782851458}
#define T_1024_403 {-0.7845565971555752415866891169571317732334,-0.6200572117632892066296790289925411343575}
#define T_1024_405 {-0.7921065773002123888701930809475015848875,-0.6103828062763094752796177999698556959629}
#define T_1024_407 {-0.7995372691079050131435224102460779249668,-0.6006164793838689730520741250074934214354}
#define T_1024_409 {-0.8068475535437992229859105464129243046045,-0.5907597018588742754374720789201091974974}
#define T_1024_411 {-0.8140363297059484137818685667298268526793,-0.5808139580957645264902566850651055574417}
#define T_1024_413 {-0.8211025149911046483452992106322199106216,-0.5707807458869672556645014083187561482191}
#define T_1024_415 {-0.8280450452577557962641208177956286817789,-0.5606615761973360312353520384931471198797}
#define T_1024_417 {-0.8348628749863800102559707738691940903664,-0.5504579729366048113092801941093057394028}
#define T_1024_419 {-0.8415549774368984436989649111637845635414,-0.5401714727298928542253975138009991496801}
#define T_1024_421 {-0.8481203448032972325165701477089896798134,-0.5298036246862947162838963777176104485989}
#define T_1024_423 {-0.8545579883654005337589865121117327362299,-0.5193559901655896426930780762631911784410}
#define T_1024_425 {-0.8608669386377673093946327753656078130007,-0.5088301425431069890947810563375242054462}
#define T_1024_427 {-0.8670462455156926484534096744027920067310,-0.4982276669727818685373676999006420373917}
#define T_1024_429 {-0.8730949784182900907936186740698758512735,-0.4875501601484359404103940960339969024062}
#define T_1024_431 {-0.8790122264286335251881610020063817501068,-0.4767992300633221436356734557193703949451}
#define T_1024_433 {-0.8847970984309377895371540034830104559660,-0.4659764957679661812051108427112922072411}
#define T_1024_435 {-0.8904487232447578781702191008662339299917,-0.4550835871263438359157760260131908580661}
#define T_1024_437 {-0.8959662497561851068894611671566963195801,-0.4441221445704292558609438401617808267474}
#define T_1024_439 {-0.9013488470460220280955354610341601073742,-0.4330938188531519572599393086420604959130}
#define T_1024_441 {-0.9065957045149153348262416329816915094852,-0.4220002707997996815869612419191980734468}
#define T_1024_443 {-0.9117060320054298783176705001096706837416,-0.4108431710579039664033018652844475582242}
#define T_1024_445 {-0.9166790599210427048504357117053586989641,-0.3996241998456468436096145069313934072852}
#define T_1024_447 {-0.9215140393420419018255529408634174615145,-0.3883450466988263016787641390692442655563}
#define T_1024_449 {-0.9262102421383113792785479745361953973770,-0.3770074102164182594520980273955501616001}
#define T_1024_451 {-0.9307669610789837122410972369834780693054,-0.3656129978047738537938471381494309753180}
#define T_1024_453 {-0.9351835099389476102516027822275646030903,-0.3541635254204903993091591019037878140807}
#define T_1024_455 {-0.9394592236021899189779560401802882552147,-0.3426607173119943783312635332549689337611}
#define T_1024_457 {-0.9435934581619603855884292897826526314020,-0.3311063057598764292066562120453454554081}
#define T_1024_459 {-0.9475855910177410912353934691054746508598,-0.3195020308160156918830807626363821327686}
#define T_1024_461 {-0.9514350209690083381985914456890895962715,-0.3078496400415348666079751183133339509368}
#define T_1024_463 {-0.9551411683057706714095047573209740221500,-0.2961508882436238443425224886595970019698}
#define T_1024_465 {-0.9587034748958715990596601841389201581478,-0.2844075372112718214090421042783418670297}
#define T_1024_467 {-0.9621214042690415801928338623838499188423,-0.2726213554499489766236308696534251794219}
#define T_1024_469 {-0.9653944416976893982962337759090587496758,-0.2607941179152755140080444107297807931900}
#define T_1024_471 {-0.9685220942744172667460134107386693358421,-0.2489276057457201762890264262750861234963}
#define T_1024_473 {-0.9715038909862517835236417340638581663370,-0.2370236059943671980132506860172725282609}
#define T_1024_475 {-0.9743393827855758582145995205792132765055,-0.2250839113597928320409380376077024266124}
#define T_1024_477 {-0.9770281426577543948397419626417104154825,-0.2131103199160913619358836967876413837075}
#define T_1024_479 {-0.9795697656854405188653345248894765973091,-0.2011046348420919005484108765813289210200}
#define T_1024_481 {-0.9819638691095552429644044423184823244810,-0.1890686641498062203758934174402384087443}
#define T_1024_483 {-0.9842100923869290252099517601891420781612,-0.1770042204121487494639097803883487358689}
#define T_1024_485 {-0.9863080972445986693841746273392345756292,-0.1649131204899699221222419964760774746537}
#define T_1024_487 {-0.9882575677307494643741847539786249399185,-0.1527971852584434353516940063855145126581}
#define T_1024_489 {-0.9900582102622971225613923706987407058477,-0.1406582393328492386341821429596166126430}
#define T_1024_491 {-0.9917097536690995251973390622879378497601,-0.1284981107937931688045551936738775111735}
#define T_1024_493 {-0.9932119492347945000076947508205194026232,-0.1163186309119047662230528317195421550423}
#define T_1024_495 {-0.9945645707342554153740366018610075116158,-0.1041216338720545725449184715216688346118}
#define T_1024_497 {-0.9957674144676598171344039656105451285839,-0.0919089564971327238618314936502429191023}
#define T_1024_499 {-0.9968202992911656679098086897283792495728,-0.0796824379714301256338870871331891976297}
#define T_1024_501 {-0.9977230666441916362430220033274963498116,-0.0674439195636640648201520775728567969054}
#define T_1024_503 {-0.9984755805732947742114902212051674723625,-0.0551952443496899411434775117868412053213}
#define T_1024_505 {-0.9990777277526453614697743432770948857069,-0.0429382569349408202419304814156930660829}
#define T_1024_507 {-0.9995294175010931425617854984011501073837,-0.0306748031766366259509570824093316332437}
#define T_1024_509 {-0.9998305817958234031905817573715467005968,-0.0184067299058048201854109748865084839053}
#define T_1024_511 {-0.9999811752826011090888869148329831659794,-0.0061358846491544752690949771078976482386}
#define T_1024_513 {-0.9999811752826011090888869148329831659794,0.0061358846491544752690949771078976482386}
#define T_1024_515 {-0.9998305817958234031905817573715467005968,0.0184067299058048201854109748865084839053}
#define T_1024_517 {-0.9995294175010931425617854984011501073837,0.0306748031766366259509570824093316332437}
#define T_1024_519 {-0.9990777277526453614697743432770948857069,0.0429382569349408202419304814156930660829}
#define T_1024_521 {-0.9984755805732947742114902212051674723625,0.0551952443496899411434775117868412053213}
#define T_1024_523 {-0.9977230666441916362430220033274963498116,0.0674439195636640648201520775728567969054}
#define T_1024_525 {-0.9968202992911656679098086897283792495728,0.0796824379714301256338870871331891976297}
#define T_1024_527 {-0.9957674144676598171344039656105451285839,0.0919089564971327238618314936502429191023}
#define T_1024_529 {-0.9945645707342554153740366018610075116158,0.1041216338720545725449184715216688346118}
#define T_1024_531 {-0.9932119492347945000076947508205194026232,0.1163186309119047662230528317195421550423}
#define T_1024_533 {-0.9917097536690995251973390622879378497601,0.1284981107937931688045551936738775111735}
#define T_1024_535 {-0.9900582102622971225613923706987407058477,0.1406582393328492386341821429596166126430}
#define T_1024_537 {-0.9882575677307494643741847539786249399185,0.1527971852584434353516940063855145126581}
#define T_1024_539 {-0.9863080972445986693841746273392345756292,0.1649131204899699221222419964760774746537}
#define T_1024_541 {-0.9842100923869290252099517601891420781612,0.1770042204121487494639097803883487358689}
#define T_1024_543 {-0.9819638691095552429644044423184823244810,0.1890686641498062203758934174402384087443}
#define T_1024_545 {-0.9795697656854405188653345248894765973091,0.2011046348420919005484108765813289210200}
#define T_1024_547 {-0.9770281426577543948397419626417104154825,0.2131103199160913619358836967876413837075}
#define T_1024_549 {-0.9743393827855758582145995205792132765055,0.2250839113597928320409380376077024266124}
#define T_1024_551 {-0.9715038909862517835236417340638581663370,0.2370236059943671980132506860172725282609}
#define T_1024_553 {-0.9685220942744172667460134107386693358421,0.2489276057457201762890264262750861234963}
#define T_1024_555 {-0.9653944416976893982962337759090587496758,0.2607941179152755140080444107297807931900}
#define T_1024_557 {-0.9621214042690415801928338623838499188423,0.2726213554499489766236308696534251794219}
#define T_1024_559 {-0.9587034748958715990596601841389201581478,0.2844075372112718214090421042783418670297}
#define T_1024_561 {-0.9551411683057706714095047573209740221500,0.2961508882436238443425224886595970019698}
#define T_1024_563 {-0.9514350209690083381985914456890895962715,0.3078496400415348666079751183133339509368}
#define T_1024_565 {-0.9475855910177410912353934691054746508598,0.3195020308160156918830807626363821327686}
#define T_1024_567 {-0.9435934581619603855884292897826526314020,0.3311063057598764292066562120453454554081}
#define T_1024_569 {-0.9394592236021899189779560401802882552147,0.3426607173119943783312635332549689337611}
#define T_1024_571 {-0.9351835099389476102516027822275646030903,0.3541635254204903993091591019037878140807}
#define T_1024_573 {-0.9307669610789837122410972369834780693054,0.3656129978047738537938471381494309753180}
#define T_1024_575 {-0.9262102421383113792785479745361953973770,0.3770074102164182594520980273955501616001}
#define T_1024_577 {-0.9215140393420419018255529408634174615145,0.3883450466988263016787641390692442655563}
#define T_1024_579 {-0.9166790599210427048504357117053586989641,0.3996241998456468436096145069313934072852}
#define T_1024_581 {-0.9117060320054298783176705001096706837416,0.4108431710579039664033018652844475582242}
#define T_1024_583 {-0.9065957045149153348262416329816915094852,0.4220002707997996815869612419191980734468}
#define T_1024_585 {-0.9013488470460220280955354610341601073742,0.4330938188531519572599393086420604959130}
#define T_1024_587 {-0.8959662497561851068894611671566963195801,0.4441221445704292558609438401617808267474}
#define T_1024_589 {-0.8904487232447578781702191008662339299917,0.4550835871263438359157760260131908580661}
#define T_1024_591 {-0.8847970984309377895371540034830104559660,0.4659764957679661812051108427112922072411}
#define T_1024_593 {-0.8790122264286335251881610020063817501068,0.4767992300633221436356734557193703949451}
#define T_1024_595 {-0.8730949784182900907936186740698758512735,0.4875501601484359404103940960339969024062}
#define T_1024_597 {-0.8670462455156926484534096744027920067310,0.4982276669727818685373676999006420373917}
#define T_1024_599 {-0.8608669386377673093946327753656078130007,0.5088301425431069890947810563375242054462}
#define T_1024_601 {-0.8545579883654005337589865121117327362299,0.5193559901655896426930780762631911784410}
#define T_1024_603 {-0.8481203448032972325165701477089896798134,0.5298036246862947162838963777176104485989}
#define T_1024_605 {-0.8415549774368984436989649111637845635414,0.5401714727298928542253975138009991496801}
#define T_1024_607 {-0.8348628749863800102559707738691940903664,0.5504579729366048113092801941093057394028}
#define T_1024_609 {-0.8280450452577557962641208177956286817789,0.5606615761973360312353520384931471198797}
#define T_1024_611 {-0.8211025149911046483452992106322199106216,0.5707807458869672556645014083187561482191}
#define T_1024_613 {-0.8140363297059484137818685667298268526793,0.5808139580957645264902566850651055574417}
#define T_1024_615 {-0.8068475535437992229859105464129243046045,0.5907597018588742754374720789201091974974}
#define T_1024_617 {-0.7995372691079050131435224102460779249668,0.6006164793838689730520741250074934214354}
#define T_1024_619 {-0.7921065773002123888701930809475015848875,0.6103828062763094752796177999698556959629}
#define T_1024_621 {-0.7845565971555752415866891169571317732334,0.6200572117632892066296790289925411343575}
#define T_1024_623 {-0.7768884656732324422989677259465679526329,0.6296382389149269842576472910877782851458}
#define T_1024_625 {-0.7691033376455795878001708842930383980274,0.6391244448637757313846918805211316794157}
#define T_1024_627 {-0.7612023854842617787141989538213238120079,0.6485144010221124410975335194962099194527}
#define T_1024_629 {-0.7531867990436125204212203243514522910118,0.6578066932970786373502392052614595741034}
#define T_1024_631 {-0.7450577854414659473292203983874060213566,0.6669999223036374713657892243645619601011}
#define T_1024_633 {-0.7368165688773699040226006218290422111750,0.6760927035753159231035169796086847782135}
#define T_1024_635 {-0.7284643904482251963727890142763499170542,0.6850836677727003554139173502335324883461}
#define T_1024_637 {-0.7200025079613816547663418532465584576130,0.6939714608896540015692266933911014348269}
#define T_1024_639 {-0.7114321957452164335578004283888731151819,0.7027547444572252999250849825330078601837}
#define T_1024_641 {-0.7027547444572252999250849825330078601837,0.7114321957452164335578004283888731151819}
#define T_1024_643 {-0.6939714608896540015692266933911014348269,0.7200025079613816547663418532465584576130}
#define T_1024_645 {-0.6850836677727003554139173502335324883461,0.7284643904482251963727890142763499170542}
#define T_1024_647 {-0.6760927035753159231035169796086847782135,0.7368165688773699040226006218290422111750}
#define T_1024_649 {-0.6669999223036374713657892243645619601011,0.7450577854414659473292203983874060213566}
#define T_1024_651 {-0.6578066932970786373502392052614595741034,0.7531867990436125204212203243514522910118}
#define T_1024_653 {-0.6485144010221124410975335194962099194527,0.7612023854842617787141989538213238120079}
#define T_1024_655 {-0.6391244448637757313846918805211316794157,0.7691033376455795878001708842930383980274}
#define T_1024_657 {-0.6296382389149269842576472910877782851458,0.7768884656732324422989677259465679526329}
#define T_1024_659 {-0.6200572117632892066296790289925411343575,0.7845565971555752415866891169571317732334}
#define T_1024_661 {-0.6103828062763094752796177999698556959629,0.7921065773002123888701930809475015848875}
#define T_1024_663 {-0.6006164793838689730520741250074934214354,0.7995372691079050131435224102460779249668}
#define T_1024_665 {-0.5907597018588742754374720789201091974974,0.8068475535437992229859105464129243046045}
#define T_1024_667 {-0.5808139580957645264902566850651055574417,0.8140363297059484137818685667298268526793}
#define T_1024_669 {-0.5707807458869672556645014083187561482191,0.8211025149911046483452992106322199106216}
#define T_1024_671 {-0.5606615761973360312353520384931471198797,0.8280450452577557962641208177956286817789}
#define T_1024_673 {-0.5504579729366048113092801941093057394028,0.8348628749863800102559707738691940903664}
#define T_1024_675 {-0.5401714727298928542253975138009991496801,0.8415549774368984436989649111637845635414}
#define T_1024_677 {-0.5298036246862947162838963777176104485989,0.8481203448032972325165701477089896798134}
#define T_1024_679 {-0.5193559901655896426930780762631911784410,0.8545579883654005337589865121117327362299}
#define T_1024_681 {-0.5088301425431069890947810563375242054462,0.8608669386377673093946327753656078130007}
#define T_1024_683 {-0.4982276669727818685373676999006420373917,0.8670462455156926484534096744027920067310}
#define T_1024_685 {-0.4875501601484359404103940960339969024062,0.8730949784182900907936186740698758512735}
#define T_1024_687 {-0.4767992300633221436356734557193703949451,0.8790122264286335251881610020063817501068}
#define T_1024_689 {-0.4659764957679661812051108427112922072411,0.8847970984309377895371540034830104559660}
#define T_1024_691 {-0.4550835871263438359157760260131908580661,0.8904487232447578781702191008662339299917}
#define T_1024_693 {-0.4441221445704292558609438401617808267474,0.8959662497561851068894611671566963195801}
#define T_1024_695 {-0.4330938188531519572599393086420604959130,0.9013488470460220280955354610341601073742}
#define T_1024_697 {-0.4220002707997996815869612419191980734468,0.9065957045149153348262416329816915094852}
#define T_1024_699 {-0.4108431710579039664033018652844475582242,0.9117060320054298783176705001096706837416}
#define T_1024_701 {-0.3996241998456468436096145069313934072852,0.9166790599210427048504357117053586989641}
#define T_1024_703 {-0.3883450466988263016787641390692442655563,0.9215140393420419018255529408634174615145}
#define T_1024_705 {-0.3770074102164182594520980273955501616001,0.9262102421383113792785479745361953973770}
#define T_1024_707 {-0.3656129978047738537938471381494309753180,0.9307669610789837122410972369834780693054}
#define T_1024_709 {-0.3541635254204903993091591019037878140807,0.9351835099389476102516027822275646030903}
#define T_1024_711 {-0.3426607173119943783312635332549689337611,0.9394592236021899189779560401802882552147}
#define T_1024_713 {-0.3311063057598764292066562120453454554081,0.9435934581619603855884292897826526314020}
#define T_1024_715 {-0.3195020308160156918830807626363821327686,0.9475855910177410912353934691054746508598}
#define T_1024_717 {-0.3078496400415348666079751183133339509368,0.9514350209690083381985914456890895962715}
#define T_1024_719 {-0.2961508882436238443425224886595970019698,0.9551411683057706714095047573209740221500}
#define T_1024_721 {-0.2844075372112718214090421042783418670297,0.9587034748958715990596601841389201581478}
#define T_1024_723 {-0.2726213554499489766236308696534251794219,0.9621214042690415801928338623838499188423}
#define T_1024_725 {-0.2607941179152755140080444107297807931900,0.9653944416976893982962337759090587496758}
#define T_1024_727 {-0.2489276057457201762890264262750861234963,0.9685220942744172667460134107386693358421}
#define T_1024_729 {-0.2370236059943671980132506860172725282609,0.9715038909862517835236417340638581663370}
#define T_1024_731 {-0.2250839113597928320409380376077024266124,0.9743393827855758582145995205792132765055}
#define T_1024_733 {-0.2131103199160913619358836967876413837075,0.9770281426577543948397419626417104154825}
#define T_1024_735 {-0.2011046348420919005484108765813289210200,0.9795697656854405188653345248894765973091}
#define T_1024_737 {-0.1890686641498062203758934174402384087443,0.9819638691095552429644044423184823244810}
#define T_1024_739 {-0.1770042204121487494639097803883487358689,0.9842100923869290252099517601891420781612}
#define T_1024_741 {-0.1649131204899699221222419964760774746537,0.9863080972445986693841746273392345756292}
#define T_1024_743 {-0.1527971852584434353516940063855145126581,0.9882575677307494643741847539786249399185}
#define T_1024_745 {-0.1406582393328492386341821429596166126430,0.9900582102622971225613923706987407058477}
#define T_1024_747 {-0.1284981107937931688045551936738775111735,0.9917097536690995251973390622879378497601}
#define T_1024_749 {-0.1163186309119047662230528317195421550423,0.9932119492347945000076947508205194026232}
#define T_1024_751 {-0.1041216338720545725449184715216688346118,0.9945645707342554153740366018610075116158}
#define T_1024_753 {-0.0919089564971327238618314936502429191023,0.9957674144676598171344039656105451285839}
#define T_1024_755 {-0.0796824379714301256338870871331891976297,0.9968202992911656679098086897283792495728}
#define T_1024_757 {-0.0674439195636640648201520775728567969054,0.9977230666441916362430220033274963498116}
#define T_1024_759 {-0.0551952443496899411434775117868412053213,0.9984755805732947742114902212051674723625}
#define T_1024_761 {-0.0429382569349408202419304814156930660829,0.9990777277526453614697743432770948857069}
#define T_1024_763 {-0.0306748031766366259509570824093316332437,0.9995294175010931425617854984011501073837}
#define T_1024_765 {-0.0184067299058048201854109748865084839053,0.9998305817958234031905817573715467005968}
#define T_1024_767 {-0.0061358846491544752690949771078976482386,0.9999811752826011090888869148329831659794}
#define T_1024_769 {0.0061358846491544752690949771078976482386,0.9999811752826011090888869148329831659794}
#define T_1024_771 {0.0184067299058048201854109748865084839053,0.9998305817958234031905817573715467005968}
#define T_1024_773 {0.0306748031766366259509570824093316332437,0.9995294175010931425617854984011501073837}
#define T_1024_775 {0.0429382569349408202419304814156930660829,0.9990777277526453614697743432770948857069}
#define T_1024_777 {0.0551952443496899411434775117868412053213,0.9984755805732947742114902212051674723625}
#define T_1024_779 {0.0674439195636640648201520775728567969054,0.9977230666441916362430220033274963498116}
#define T_1024_781 {0.0796824379714301256338870871331891976297,0.9968202992911656679098086897283792495728}
#define T_1024_783 {0.0919089564971327238618314936502429191023,0.9957674144676598171344039656105451285839}
#define T_1024_785 {0.1041216338720545725449184715216688346118,0.9945645707342554153740366018610075116158}
#define T_1024_787 {0.1163186309119047662230528317195421550423,0.9932119492347945000076947508205194026232}
#define T_1024_789 {0.1284981107937931688045551936738775111735,0.9917097536690995251973390622879378497601}
#define T_1024_791 {0.1406582393328492386341821429596166126430,0.9900582102622971225613923706987407058477}
#define T_1024_793 {0.1527971852584434353516940063855145126581,0.9882575677307494643741847539786249399185}
#define T_1024_795 {0.1649131204899699221222419964760774746537,0.9863080972445986693841746273392345756292}
#define T_1024_797 {0.1770042204121487494639097803883487358689,0.9842100923869290252099517601891420781612}
#define T_1024_799 {0.1890686641498062203758934174402384087443,0.9819638691095552429644044423184823244810}
#define T_1024_801 {0.2011046348420919005484108765813289210200,0.9795697656854405188653345248894765973091}
#define T_1024_803 {0.2131103199160913619358836967876413837075,0.9770281426577543948397419626417104154825}
#define T_1024_805 {0.2250839113597928320409380376077024266124,0.9743393827855758582145995205792132765055}
#define T_1024_807 {0.2370236059943671980132506860172725282609,0.9715038909862517835236417340638581663370}
#define T_1024_809 {0.2489276057457201762890264262750861234963,0.9685220942744172667460134107386693358421}
#define T_1024_811 {0.2607941179152755140080444107297807931900,0.9653944416976893982962337759090587496758}
#define T_1024_813 {0.2726213554499489766236308696534251794219,0.9621214042690415801928338623838499188423}
#define T_1024_815 {0.2844075372112718214090421042783418670297,0.9587034748958715990596601841389201581478}
#define T_1024_817 {0.2961508882436238443425224886595970019698,0.9551411683057706714095047573209740221500}
#define T_1024_819 {0.3078496400415348666079751183133339509368,0.9514350209690083381985914456890895962715}
#define T_1024_821 {0.3195020308160156918830807626363821327686,0.9475855910177410912353934691054746508598}
#define T_1024_823 {0.3311063057598764292066562120453454554081,0.9435934581619603855884292897826526314020}
#define T_1024_825 {0.3426607173119943783312635332549689337611,0.9394592236021899189779560401802882552147}
#define T_1024_827 {0.3541635254204903993091591019037878140807,0.9351835099389476102516027822275646030903}
#define T_1024_829 {0.3656129978047738537938471381494309753180,0.9307669610789837122410972369834780693054}
#define T_1024_831 {0.3770074102164182594520980273955501616001,0.9262102421383113792785479745361953973770}
#define T_1024_833 {0.3883450466988263016787641390692442655563,0.9215140393420419018255529408634174615145}
#define T_1024_835 {0.3996241998456468436096145069313934072852,0.9166790599210427048504357117053586989641}
#define T_1024_837 {0.4108431710579039664033018652844475582242,0.9117060320054298783176705001096706837416}
#define T_1024_839 {0.4220002707997996815869612419191980734468,0.9065957045149153348262416329816915094852}
#define T_1024_841 {0.4330938188531519572599393086420604959130,0.9013488470460220280955354610341601073742}
#define T_1024_843 {0.4441221445704292558609438401617808267474,0.8959662497561851068894611671566963195801}
#define T_1024_845 {0.4550835871263438359157760260131908580661,0.8904487232447578781702191008662339299917}
#define T_1024_847 {0.4659764957679661812051108427112922072411,0.8847970984309377895371540034830104559660}
#define T_1024_849 {0.4767992300633221436356734557193703949451,0.8790122264286335251881610020063817501068}
#define T_1024_851 {0.4875501601484359404103940960339969024062,0.8730949784182900907936186740698758512735}
#define T_1024_853 {0.4982276669727818685373676999006420373917,0.8670462455156926484534096744027920067310}
#define T_1024_855 {0.5088301425431069890947810563375242054462,0.8608669386377673093946327753656078130007}
#define T_1024_857 {0.5193559901655896426930780762631911784410,0.8545579883654005337589865121117327362299}
#define T_1024_859 {0.5298036246862947162838963777176104485989,0.8481203448032972325165701477089896798134}
#define T_1024_861 {0.5401714727298928542253975138009991496801,0.8415549774368984436989649111637845635414}
#define T_1024_863 {0.5504579729366048113092801941093057394028,0.8348628749863800102559707738691940903664}
#define T_1024_865 {0.5606615761973360312353520384931471198797,0.8280450452577557962641208177956286817789}
#define T_1024_867 {0.5707807458869672556645014083187561482191,0.8211025149911046483452992106322199106216}
#define T_1024_869 {0.5808139580957645264902566850651055574417,0.8140363297059484137818685667298268526793}
#define T_1024_871 {0.5907597018588742754374720789201091974974,0.8068475535437992229859105464129243046045}
#define T_1024_873 {0.6006164793838689730520741250074934214354,0.7995372691079050131435224102460779249668}
#define T_1024_875 {0.6103828062763094752796177999698556959629,0.7921065773002123888701930809475015848875}
#define T_1024_877 {0.6200572117632892066296790289925411343575,0.7845565971555752415866891169571317732334}
#define T_1024_879 {0.6296382389149269842576472910877782851458,0.7768884656732324422989677259465679526329}
#define T_1024_881 {0.6391244448637757313846918805211316794157,0.7691033376455795878001708842930383980274}
#define T_1024_883 {0.6485144010221124410975335194962099194527,0.7612023854842617787141989538213238120079}
#define T_1024_885 {0.6578066932970786373502392052614595741034,0.7531867990436125204212203243514522910118}
#define T_1024_887 {0.6669999223036374713657892243645619601011,0.7450577854414659473292203983874060213566}
#define T_1024_889 {0.6760927035753159231035169796086847782135,0.7368165688773699040226006218290422111750}
#define T_1024_891 {0.6850836677727003554139173502335324883461,0.7284643904482251963727890142763499170542}
#define T_1024_893 {0.6939714608896540015692266933911014348269,0.7200025079613816547663418532465584576130}
#define T_1024_895 {0.7027547444572252999250849825330078601837,0.7114321957452164335578004283888731151819}
#define T_1024_897 {0.7114321957452164335578004283888731151819,0.7027547444572252999250849825330078601837}
#define T_1024_899 {0.7200025079613816547663418532465584576130,0.6939714608896540015692266933911014348269}
#define T_1024_901 {0.7284643904482251963727890142763499170542,0.6850836677727003554139173502335324883461}
#define T_1024_903 {0.7368165688773699040226006218290422111750,0.6760927035753159231035169796086847782135}
#define T_1024_905 {0.7450577854414659473292203983874060213566,0.6669999223036374713657892243645619601011}
#define T_1024_907 {0.7531867990436125204212203243514522910118,0.6578066932970786373502392052614595741034}
#define T_1024_909 {0.7612023854842617787141989538213238120079,0.6485144010221124410975335194962099194527}
#define T_1024_911 {0.7691033376455795878001708842930383980274,0.6391244448637757313846918805211316794157}
#define T_1024_913 {0.7768884656732324422989677259465679526329,0.6296382389149269842576472910877782851458}
#define T_1024_915 {0.7845565971555752415866891169571317732334,0.6200572117632892066296790289925411343575}
#define T_1024_917 {0.7921065773002123888701930809475015848875,0.6103828062763094752796177999698556959629}
#define T_1024_919 {0.7995372691079050131435224102460779249668,0.6006164793838689730520741250074934214354}
#define T_1024_921 {0.8068475535437992229859105464129243046045,0.5907597018588742754374720789201091974974}
#define T_1024_923 {0.8140363297059484137818685667298268526793,0.5808139580957645264902566850651055574417}
#define T_1024_925 {0.8211025149911046483452992106322199106216,0.5707807458869672556645014083187561482191}
#define T_1024_927 {0.8280450452577557962641208177956286817789,0.5606615761973360312353520384931471198797}
#define T_1024_929 {0.8348628749863800102559707738691940903664,0.5504579729366048113092801941093057394028}
#define T_1024_931 {0.8415549774368984436989649111637845635414,0.5401714727298928542253975138009991496801}
#define T_1024_933 {0.8481203448032972325165701477089896798134,0.5298036246862947162838963777176104485989}
#define T_1024_935 {0.8545579883654005337589865121117327362299,0.5193559901655896426930780762631911784410}
#define T_1024_937 {0.8608669386377673093946327753656078130007,0.5088301425431069890947810563375242054462}
#define T_1024_939 {0.8670462455156926484534096744027920067310,0.4982276669727818685373676999006420373917}
#define T_1024_941 {0.8730949784182900907936186740698758512735,0.4875501601484359404103940960339969024062}
#define T_1024_943 {0.8790122264286335251881610020063817501068,0.4767992300633221436356734557193703949451}
#define T_1024_945 {0.8847970984309377895371540034830104559660,0.4659764957679661812051108427112922072411}
#define T_1024_947 {0.8904487232447578781702191008662339299917,0.4550835871263438359157760260131908580661}
#define T_1024_949 {0.8959662497561851068894611671566963195801,0.4441221445704292558609438401617808267474}
#define T_1024_951 {0.9013488470460220280955354610341601073742,0.4330938188531519572599393086420604959130}
#define T_1024_953 {0.9065957045149153348262416329816915094852,0.4220002707997996815869612419191980734468}
#define T_1024_955 {0.9117060320054298783176705001096706837416,0.4108431710579039664033018652844475582242}
#define T_1024_957 {0.9166790599210427048504357117053586989641,0.3996241998456468436096145069313934072852}
#define T_1024_959 {0.9215140393420419018255529408634174615145,0.3883450466988263016787641390692442655563}
#define T_1024_961 {0.9262102421383113792785479745361953973770,0.3770074102164182594520980273955501616001}
#define T_1024_963 {0.9307669610789837122410972369834780693054,0.3656129978047738537938471381494309753180}
#define T_1024_965 {0.9351835099389476102516027822275646030903,0.3541635254204903993091591019037878140807}
#define T_1024_967 {0.9394592236021899189779560401802882552147,0.3426607173119943783312635332549689337611}
#define T_1024_969 {0.9435934581619603855884292897826526314020,0.3311063057598764292066562120453454554081}
#define T_1024_971 {0.9475855910177410912353934691054746508598,0.3195020308160156918830807626363821327686}
#define T_1024_973 {0.9514350209690083381985914456890895962715,0.3078496400415348666079751183133339509368}
#define T_1024_975 {0.9551411683057706714095047573209740221500,0.2961508882436238443425224886595970019698}
#define T_1024_977 {0.9587034748958715990596601841389201581478,0.2844075372112718214090421042783418670297}
#define T_1024_979 {0.9621214042690415801928338623838499188423,0.2726213554499489766236308696534251794219}
#define T_1024_981 {0.9653944416976893982962337759090587496758,0.2607941179152755140080444107297807931900}
#define T_1024_983 {0.9685220942744172667460134107386693358421,0.2489276057457201762890264262750861234963}
#define T_1024_985 {0.9715038909862517835236417340638581663370,0.2370236059943671980132506860172725282609}
#define T_1024_987 {0.9743393827855758582145995205792132765055,0.2250839113597928320409380376077024266124}
#define T_1024_989 {0.9770281426577543948397419626417104154825,0.2131103199160913619358836967876413837075}
#define T_1024_991 {0.9795697656854405188653345248894765973091,0.2011046348420919005484108765813289210200}
#define T_1024_993 {0.9819638691095552429644044423184823244810,0.1890686641498062203758934174402384087443}
#define T_1024_995 {0.9842100923869290252099517601891420781612,0.1770042204121487494639097803883487358689}
#define T_1024_997 {0.9863080972445986693841746273392345756292,0.1649131204899699221222419964760774746537}
#define T_1024_999 {0.9882575677307494643741847539786249399185,0.1527971852584434353516940063855145126581}
#define T_1024_1001 {0.9900582102622971225613923706987407058477,0.1406582393328492386341821429596166126430}
#define T_1024_1003 {0.9917097536690995251973390622879378497601,0.1284981107937931688045551936738775111735}
#define T_1024_1005 {0.9932119492347945000076947508205194026232,0.1163186309119047662230528317195421550423}
#define T_1024_1007 {0.9945645707342554153740366018610075116158,0.1041216338720545725449184715216688346118}
#define T_1024_1009 {0.9957674144676598171344039656105451285839,0.0919089564971327238618314936502429191023}
#define T_1024_1011 {0.9968202992911656679098086897283792495728,0.0796824379714301256338870871331891976297}
#define T_1024_1013 {0.9977230666441916362430220033274963498116,0.0674439195636640648201520775728567969054}
#define T_1024_1015 {0.9984755805732947742114902212051674723625,0.0551952443496899411434775117868412053213}
#define T_1024_1017 {0.9990777277526453614697743432770948857069,0.0429382569349408202419304814156930660829}
#define T_1024_1019 {0.9995294175010931425617854984011501073837,0.0306748031766366259509570824093316332437}
#define T_1024_1021 {0.9998305817958234031905817573715467005968,0.0184067299058048201854109748865084839053}
#define T_1024_1023 {0.9999811752826011090888869148329831659794,0.0061358846491544752690949771078976482386}
// Pre-computed twiddles for N=1250
#define T_1250_1 {0.9999873669329657488447082869242876768112,-0.0050265270788188622791414772450480086263}
#define T_1250_3 {0.9998863043118163540512455256248358637094,-0.0150790732360371205339477640450240869541}
#define T_1250_7 {0.9993810422739491938770584056328516453505,-0.0351785779052378247411247969012038083747}
#define T_1250_9 {0.9989768939209825449054847013030666857958,-0.0452235050829326162835641866877267602831}
#define T_1250_11 {0.9984717850692077512064770417055115103722,-0.0552638617969271883634263531348551623523}
#define T_1250_13 {0.9978657667668942021776956607936881482601,-0.0652986333296357579492052991554373875260}
#define T_1250_17 {0.9963512569890512482473354793910402804613,-0.0853473649056469552132142553091398440301}
#define T_1250_19 {0.9954429185757831533010175917297601699829,-0.0953592987459886270995568224861926864833}
#define T_1250_21 {0.9944339768210305186002528898825403302908,-0.1053615952038983727412357893626904115081}
#define T_1250_23 {0.9933245336923797186301499095861800014973,-0.1153532434083082286457866416640172246844}
#define T_1250_27 {0.9908046019577008145517993398243561387062,-0.1353005570551802927425910638703498989344}
#define T_1250_29 {0.9893943680257961670321265046368353068829,-0.1452542065443727936635553987798630259931}
#define T_1250_31 {0.9878841420425021890849848205107264220715,-0.1551931760772660706670933450368465855718}
#define T_1250_33 {0.9862740766371433931425372065859846770763,-0.1651164611828580541796895886363927274942}
#define T_1250_37 {0.9827550885118900847459144642925821244717,-0.1849119682551322307872965211572591215372}
#define T_1250_39 {0.9808465214346523408650568853772711008787,-0.1947821896107088668337325998436426743865}
#define T_1250_41 {0.9788388261847201787801964201207738369703,-0.2046327255189626659337420733209000900388}
#define T_1250_43 {0.9767322056676015495924048082088120281696,-0.2144625804463383411668786493464722298086}
#define T_1250_47 {0.9722230504211841761730283906217664480209,-0.2340562757751382949589213922081398777664}
#define T_1250_49 {0.9698209714046909235563020956760738044977,-0.2438181359613384724394080649290117435157}
#define T_1250_51 {0.9673208785005658061351141441264189779758,-0.2535553549363405156924500261084176599979}
#define T_1250_53 {0.9647230243779428837669343010929878801107,-0.2632669486188402574455835747357923537493}
#define T_1250_57 {0.9592350925278542161933614806912373751402,-0.2826093368292684759879307421215344220400}
#define T_1250_59 {0.9563455694321727484918937989277765154839,-0.2922381765400498543350238378479843959212}
#define T_1250_61 {0.9533593943255084246501951383834239095449,-0.3018374815215959516834232090332079678774}
#define T_1250_63 {0.9502768690023574160719022074772510677576,-0.3114062816307281988947863737848820164800}
#define T_1250_67 {0.9438240235407373557308119416120462119579,-0.3304485021714786974200706026749685406685}
#define T_1250_69 {0.9404543555519829789446362156013492494822,-0.3399199981220644151136411892366595566273}
#define T_1250_71 {0.9369896415802629885405394816189073026180,-0.3493571404326670237772134441911475732923}
#define T_1250_73 {0.9334302317830763806583149744255933910608,-0.3587589753488995003571915276552317664027}
#define T_1250_77 {0.9260287731575901348790580414060968905687,-0.3774529259182506923941957666102098301053}
#define T_1250_79 {0.9221874723495493419989088579313829541206,-0.3867431522878577720980786125437589362264}
#define T_1250_81 {0.9182529716809616493478074517042841762304,-0.3959942928870098799443155712651787325740}
#define T_1250_83 {0.9142256687878009824288483287091366946697,-0.4052054127593781029936792492662789300084}
#define T_1250_87 {0.9058942937252941751680168636084999889135,-0.4235038708157818909683101082919165492058}
#define T_1250_89 {0.9015910635571866560411535829189233481884,-0.4325893596863208401259726088028401136398}
#define T_1250_91 {0.8971967150818874747741915598453488200903,-0.4416311293899813361640838138555409386754}
#define T_1250_93 {0.8927116924093823069341624432126991450787,-0.4506282661302732917008029289718251675367}
#define T_1250_97 {0.8834714466863258230944211391033604741096,-0.4684850081805932986434015674603870138526}
#define T_1250_99 {0.8787171574910247473511049065564293414354,-0.4773428088186660311897924202639842405915}
#define T_1250_101 {0.8738740617146393274694560204807203263044,-0.4861523673318466909343271709076361730695}
#define T_1250_103 {0.8689426488193063846665609162300825119019,-0.4949127933918132660195965399907436221838}
#define T_1250_107 {0.8588168740983388449450330881518311798573,-0.5122827117558800269492280676786322146654}
#define T_1250_109 {0.8536235356229666670913047710200771689415,-0.5208904485883242285737537713430356234312}
#define T_1250_111 {0.8483439266257484234756702790036797523499,-0.5294455422016571821686170551402028650045}
#define T_1250_113 {0.8429785806845486728633431994239799678326,-0.5379471279847712894550681994587648659945}
#define T_1250_117 {0.8319928555514105594781426589179318398237,-0.5547863447412973991745843704848084598780}
#define T_1250_119 {0.8263735866196754153989445512706879526377,-0.5631222738778264291781283645832445472479}
#define T_1250_121 {0.8206708011521579582137064790003933012486,-0.5714012916823650867215178550395648926497}
#define T_1250_123 {0.8148850754945862195910422087763436138630,-0.5796225614451032681628817044838797301054}
#define T_1250_129 {0.7970361462173010114184990015928633511066,-0.6039316034312769421177335971151478588581}
#define T_1250_141 {0.7591804347117565576752440392738208174706,-0.6508802251957486184608114854199811816216}
#define T_1250_147 {0.7392080827754685667940748317050747573376,-0.6734771045547250922780335713468957692385}
#define T_1250_153 {0.7185634108878365955419553756655659526587,-0.6954614471940469000443840741354506462812}
#define T_1250_159 {0.6972651956628107550173467643617186695337,-0.7168132580507298179384179093176499009132}
#define T_1250_171 {0.6527861960715837241764347709249705076218,-0.7575421983087092803188511425105389207602}
#define T_1250_177 {0.6296458659692600878798884878051467239857,-0.7768822841768375786486444667389150708914}
#define T_1250_183 {0.6059328642635862793852652430359739810228,-0.7955157848875950010736346484918612986803}
#define T_1250_189 {0.5816687582568207393052261977572925388813,-0.8134257530149683335096710834477562457323}
#define T_1250_201 {0.5315759886622380969711798570642713457346,-0.8470106069452519870210949193278793245554}
#define T_1250_207 {0.5057928851395788738543046747508924454451,-0.8626549468600877013102490309393033385277}
#define T_1250_213 {0.4795497560086358079800561426964122802019,-0.8775146901972968871419311653880868107080}
#define T_1250_219 {0.4528704697574726933950728380295913666487,-0.8915763218152700231300400446343701332808}
#define T_1250_231 {0.3983008612318227892323818650766042992473,-0.9172548304271764818551559983461629599333}
#define T_1250_237 {0.3704601707692759537948745673929806798697,-0.9288483524631988563768913991225417703390}
#define T_1250_243 {0.3422825416695712275050311745872022584081,-0.9395970741058202735374038638838101178408}
#define T_1250_249 {0.3137936018751875111298943465953925624490,-0.9494912192443889509263499348890036344528}
#define T_1250_261 {0.2559856941126726903590338224603328853846,-0.9666805699969629461776321477373130619526}
#define T_1250_267 {0.2267193032343216008150932339049177244306,-0.9739601416592692517681939534668345004320}
#define T_1250_273 {0.1972467080212628731672452886414248496294,-0.9803538831334196457234497756871860474348}
#define T_1250_279 {0.1675947142055242422564731441525509580970,-0.9858559792233186902521424599399324506521}
#define T_1250_291 {0.1078605449930568199734537415679369587451,-0.9941660338363007554107753094285726547241}
#define T_1250_297 {0.0778326986474765225576533111961907707155,-0.9969664342500459408569213337614201009274}
#define T_1250_303 {0.0477340623884916423480540004220529226586,-0.9988600799350685344180078573117498308420}
#define T_1250_309 {0.0175920113410997225322773829248035326600,-0.9998452485944885337332266317389439791441}
#define T_1250_321 {-0.0427126621211368767694338544060883577913,-0.9990873978258987264666757255326956510544}
#define T_1250_327 {-0.0728204366033457090034985981219506356865,-0.9973450676736201891969813004834577441216}
#define T_1250_333 {-0.1028619798936414586609799926009145565331,-0.9946956384202959577933711443620268255472}
#define T_1250_339 {-0.1328099687938694151156937550695147365332,-0.9911415197583902658706733745930250734091}
#define T_1250_351 {-0.1923164408499827837673024077957961708307,-0.9813329641761735500082863836723845452070}
#define T_1250_357 {-0.2218208020484253029103172139002708718181,-0.9750874482725092606827388408419210463762}
#define T_1250_363 {-0.2511234141665813490718051070871297270060,-0.9679550768797691162603769043926149606705}
#define T_1250_369 {-0.2801976260743935798203096965153235942125,-0.9599423369881517897894696034200023859739}
#define T_1250_381 {-0.3375553074551057575192203330516349524260,-0.9413056965773068940350754019164014607668}
#define T_1250_387 {-0.3657866093253325234790906961279688403010,-0.9306987463396931836712155927671119570732}
#define T_1250_393 {-0.3936852232270234286382049049279885366559,-0.9192453127499148335388667874212842434645}
#define T_1250_399 {-0.4212257749858722144509215468133334070444,-0.9069558128638635086105068694450892508030}
#define T_1250_411 {-0.4751328464720838140600278620695462450385,-0.8799140743296104405501978362735826522112}
#define T_1250_417 {-0.5014503369740861415948529611341655254364,-0.8651864305157446199956439158995635807514}
#define T_1250_423 {-0.5273117514752824197543645823316182941198,-0.8496718877049364015974219910276588052511}
#define T_1250_429 {-0.5526935686623315469034878333332017064095,-0.8333845565879515193685733720485586673021}
#define T_1250_441 {-0.6019265278387284645589261344866827130318,-0.7985514730335249167225697419780772179365}
#define T_1250_447 {-0.6257328917723579131404676445527002215385,-0.7800374017662247139170972332067321985960}
#define T_1250_453 {-0.6489701430066630027937435443163849413395,-0.7608138757185697320650774599926080554724}
#define T_1250_459 {-0.6716171469410040506531345272378530353308,-0.7408983789527587848766643219278194010258}
#define T_1250_471 {-0.7150585774315030285208649729611352086067,-0.6990645398256409848158909881021827459335}
#define T_1250_477 {-0.7358134934071977051317503537575248628855,-0.6771842459182698670261402185133192688227}
#define T_1250_483 {-0.7558991768574195857510744644969236105680,-0.6546880435950205301409710045845713466406}
#define T_1250_489 {-0.7752973595759157232620850663806777447462,-0.6315963934623227693521130277076736092567}
#define T_1250_501 {-0.8119612924962041899945575096353422850370,-0.5837112809325288864670255861710757017136}
#define T_1250_507 {-0.8291936963450933228969574884104076772928,-0.5589613707060275826776774010795634239912}
#define T_1250_513 {-0.8456719370854187678432367647474166005850,-0.5337030773999673627372430928517132997513}
#define T_1250_519 {-0.8613810275298499075091740451171062886715,-0.5079593737806400444156906814896501600742}
#define T_1250_531 {-0.8904353195405447785049091180553659796715,-0.4551098128086537575320846826798515394330}
#define T_1250_537 {-0.9037540958273154734214926975255366414785,-0.4280520228609502875194436910533113405108}
#define T_1250_543 {-0.9162508952933617889513584486849140375853,-0.4006049136919229147757448572519933804870}
#define T_1250_549 {-0.9279143519271306761453388389782048761845,-0.3727934488260932766046096276113530620933}
#define T_1250_561 {-0.9486995719838390295208796487713698297739,-0.3161789400287130513689248800801578909159}
#define T_1250_567 {-0.9578024309623294207938215549802407622337,-0.2874273877741164162635811862855916842818}
#define T_1250_573 {-0.9660341554134970198930432161432690918446,-0.2584144163442346764369972333952318876982}
#define T_1250_579 {-0.9733872584703672226069670614378992468119,-0.2291664134369226779597283893963322043419}
#define T_1250_591 {-0.9854316546073247362613756195059977471828,-0.1700719086088891551789004097372526302934}
#define T_1250_597 {-0.9901119931429293030689109400555025786161,-0.1402791539557319833164683586801402270794}
#define T_1250_603 {-0.9938918111585802739327277777192648500204,-0.1103588134763917733005555987801926676184}
#define T_1250_609 {-0.9967676708576360677938055232516489923000,-0.0803381001333942218467498719292052555829}
#define T_1250_621 {-0.9997978773111629857694993006589356809855,-0.0201048383254575774303773982865095604211}
#define T_1250_627 {-0.9999494680510517818916582655219826847315,0.0100529271567306524581830728948261821643}
#define T_1250_633 {-0.9991915909518144234269243497692514210939,0.0402015493629532053021513604562642285600}
#define T_1250_639 {-0.9975249353131302454400497481401544064283,0.0703136077053038016648756070026138331741}
#define T_1250_651 {-0.9914721769705635567859758339182008057833,0.1303185416326145262821967207855777814984}
#define T_1250_657 {-0.9870915793339134491901631918153725564480,0.1601568419021817957226261341929784975946}
#define T_1250_663 {-0.9818132082853465725236219441285356879234,0.1898494773140938784994347088286303915083}
#define T_1250_669 {-0.9756418645761659735882176391896791756153,0.2193694420067258954443190077654435299337}
#define T_1250_681 {-0.9606435179309280592008235544199123978615,0.2777841454390272413199625134438974782825}
#define T_1250_687 {-0.9518301561981014069502293750701937824488,0.3066257551998819441685384390439139679074}
#define T_1250_693 {-0.9421510918042592663823597831651568412781,0.3351884846053667099674555629462702199817}
#define T_1250_699 {-0.9316151279920259486999611908686347305775,0.3634463554589605904787674717226764187217}
#define T_1250_711 {-0.9080116031765956829957531226682476699352,0.4189450184650349573445282658212818205357}
#define T_1250_717 {-0.8949655099049148576639822749712038785219,0.4461353338177057592517371631402056664228}
#define T_1250_723 {-0.8811054331526765315274474232865031808615,0.4729198829282125204898079573467839509249}
#define T_1250_729 {-0.8664439788509370465874326328048482537270,0.4992743048795490468094726566050667315722}
#define T_1250_741 {-0.8347709935146954141060859910794533789158,0.5505973014704015344733534220722503960133}
#define T_1250_747 {-0.8177882694974004662569200263533275574446,0.5755191971363310399212309675931464880705}
// Pre-computed twiddles for N=1296
#define T_1296_1 {0.9999882478077495306933997198939323425293,-0.0048481178190018601320554481048930028919}
#define T_1296_5 {0.9997062090049132487834526727965567260981,-0.0242383101107481388480913153671281179413}
#define T_1296_7 {0.9994241967185149011498879190185107290745,-0.0339304437570622369202411050537193659693}
#define T_1296_11 {0.9985783189429906503420397712034173309803,-0.0533042300102982355425318417019298067316}
#define T_1296_13 {0.9980145329807432741375805562711320817471,-0.0629840611522379661968429331864172127098}
#define T_1296_17 {0.9966055319295779035826399194775149226189,-0.0823250492095999042430065628650481812656}
#define T_1296_19 {0.9957604493106914089750603125139605253935,-0.0919843877436274381942382660781731829047}
#define T_1296_23 {0.9937895171394426352406981095555238425732,-0.1112762131982996532952867596577561926097}
#define T_1296_25 {0.9926638528881819301119548981660045683384,-0.1209068863596693688133854038824210874736}
#define T_1296_29 {0.9901326572022358663005547896318603307009,-0.1401332264013062656182739829091588035226}
#define T_1296_31 {0.9887273637429387918018619529902935028076,-0.1497270856790396120761243992092204280198}
#define T_1296_35 {0.9856380461865491549033890805731061846018,-0.1688716729044927866709713271120563149452}
#define T_1296_37 {0.9839543125377806509490596909017767757177,-0.1784206009358321187718843248148914426565}
#define T_1296_41 {0.9803094869820240253588394807593431323767,-0.1974672371129975179115945138619281351566}
#define T_1296_43 {0.9783487377505475368622001042240299284458,-0.2069631545515053794304094481049105525017}
#define T_1296_47 {0.9741514880817274679714046214940026402473,-0.2258957243246448032270023986711748875678}
#define T_1296_49 {0.9719153822571453549272746386122889816761,-0.2353305966761375933593569698132341727614}
#define T_1296_53 {0.9671692597675166647164246569445822387934,-0.2541330812010785256127576303697424009442}
#define T_1296_55 {0.9646596893185994670005811713053844869137,-0.2634989256216107578190133153839269652963}
#define T_1296_59 {0.9593687097016201370536236936459317803383,-0.2821554161192877385744282037194352596998}
#define T_1296_61 {0.9565877979755121884863910963758826255798,-0.2914443081694350068389098851184826344252}
#define T_1296_65 {0.9507564379281665534193734856671653687954,-0.3099390193863051368161620757746277377009}
#define T_1296_67 {0.9477065378538220841164729790762066841125,-0.3191430997360308330357270278909709304571}
#define T_1296_71 {0.9413397312888872603409140538133215159178,-0.3374603832999741315212816061830380931497}
#define T_1296_73 {0.9380234233862577708507046736485790461302,-0.3465718643784075347902273733780020847917}
#define T_1296_77 {0.9311265572577218652128294706926681101322,-0.3646962220388118569580626626702724024653}
#define T_1296_79 {0.9275466474543785366790871194098144769669,-0.3737073946233104848602124548051506280899}
#define T_1296_83 {0.9201255571995390347694865340599790215492,-0.3916234913641390424920984969503479078412}
#define T_1296_85 {0.9162850744565779192996046731423120945692,-0.4005267311030605847932406504696700721979}
#define T_1296_89 {0.9083460390586792776446145580848678946495,-0.4182194081178063904680186624318594112992}
#define T_1296_91 {0.9042482328079178843793783926230389624834,-0.4270071819814714175755909764120588079095}
#define T_1296_95 {0.8957979694835052075774228796944953501225,-0.4444614694990209891045651602325960993767}
#define T_1296_97 {0.8914463068781385279848450409190263599157,-0.4531263421534081903274682190385647118092}
#define T_1296_101 {0.8824919653936212915468217943271156400442,-0.4703274721039624739482576387672452256083}
#define T_1296_103 {0.8778901283746644024219563107180874794722,-0.4788621122017435172146804234216688200831}
#define T_1296_107 {0.8684392849969004846144571274635381996632,-0.4957955307120791577091267754440195858479}
#define T_1296_109 {0.8635911671778986331560190592426806688309,-0.5041927170956703729842729444499127566814}
#define T_1296_113 {0.8536518182639163399016979383304715156555,-0.5208440968031696760576210181170608848333}
#define T_1296_115 {0.8485615216365590685043684970878530293703,-0.5290967246145524827127815115090925246477}
#define T_1296_119 {0.8381420768678403687701461421966087073088,-0.5454519767895824600145715521648526191711}
#define T_1296_121 {0.8328139083312672275027921386936213821173,-0.5535530634817222850330153960385359823704}
#define T_1296_125 {0.8219231835983180634030986766447313129902,-0.5695983499481065415182001743232831358910}
#define T_1296_127 {0.8163616513150518949615275232645217329264,-0.5775410411928850740181928813399281352758}
#define T_1296_131 {0.8050088612582783076376813369279261678457,-0.5932627860363820504474574590858537703753}
#define T_1296_133 {0.7992186708398696382005255145486444234848,-0.6010403615240428321087051699578296393156}
#define T_1296_137 {0.7874134210530723265719643677584826946259,-0.6164252625789253814403423348267097026110}
#define T_1296_139 {0.7813994715786822808922806871123611927032,-0.6240311417041268793326480590621940791607}
#define T_1296_143 {0.7691517504817649841797333465365227311850,-0.6390661818081415646020104759372770786285}
#define T_1296_145 {0.7629191303530551415690297289984300732613,-0.6464939292378065749389293159765657037497}
#define T_1296_149 {0.7502393007408245662048784652142785489559,-0.6611663872459931923231124528683722019196}
#define T_1296_151 {0.7437932833766611739889640375622548162937,-0.6684097183642424555571892597072292119265}
#define T_1296_155 {0.7306920736508674130149643133336212486029,-0.6827071799122924611324947363755200058222}
#define T_1296_157 {0.7240381130254825992054179550905246287584,-0.6897599661378576163528464348928537219763}
#define T_1296_161 {0.7105266081175209968989747721934691071510,-0.7036703341459058513862601103028282523155}
#define T_1296_163 {0.7036703341459058513862601103028282523155,-0.7105266081175209968989747721934691071510}
#define T_1296_167 {0.6897599661378576163528464348928537219763,-0.7240381130254825992054179550905246287584}
#define T_1296_169 {0.6827071799122924611324947363755200058222,-0.7306920736508674130149643133336212486029}
#define T_1296_173 {0.6684097183642424555571892597072292119265,-0.7437932833766611739889640375622548162937}
#define T_1296_175 {0.6611663872459931923231124528683722019196,-0.7502393007408245662048784652142785489559}
#define T_1296_179 {0.6464939292378065749389293159765657037497,-0.7629191303530551415690297289984300732613}
#define T_1296_181 {0.6390661818081415646020104759372770786285,-0.7691517504817649841797333465365227311850}
#define T_1296_185 {0.6240311417041268793326480590621940791607,-0.7813994715786822808922806871123611927032}
#define T_1296_187 {0.6164252625789253814403423348267097026110,-0.7874134210530723265719643677584826946259}
#define T_1296_191 {0.6010403615240428321087051699578296393156,-0.7992186708398696382005255145486444234848}
#define T_1296_193 {0.5932627860363820504474574590858537703753,-0.8050088612582783076376813369279261678457}
#define T_1296_197 {0.5775410411928850740181928813399281352758,-0.8163616513150518949615275232645217329264}
#define T_1296_199 {0.5695983499481065415182001743232831358910,-0.8219231835983180634030986766447313129902}
#define T_1296_203 {0.5535530634817222850330153960385359823704,-0.8328139083312672275027921386936213821173}
#define T_1296_205 {0.5454519767895824600145715521648526191711,-0.8381420768678403687701461421966087073088}
#define T_1296_209 {0.5290967246145524827127815115090925246477,-0.8485615216365590685043684970878530293703}
#define T_1296_211 {0.5208440968031696760576210181170608848333,-0.8536518182639163399016979383304715156555}
#define T_1296_215 {0.5041927170956703729842729444499127566814,-0.8635911671778986331560190592426806688309}
// Pre-computed twiddles for N=1331
#define T_1331_1 {0.9999888577519229215795348864048719406128,-0.0047206325851934256149222690623901144136}
#define T_1331_2 {0.9999554312559911783964139431191142648458,-0.0094411599734681612983155929441636544652}
#define T_1331_3 {0.9998997212570973625034298493119422346354,-0.0141614769702497790559991841519149602391}
#define T_1331_4 {0.9998217289967107346271291135053616017103,-0.0188814783856523157878903873552189907059}
#define T_1331_5 {0.9997214562128495796144989071763120591640,-0.0236010590368223860391339030684321187437}
#define T_1331_6 {0.9995989051400421265825002592464443296194,-0.0283201137502831178094364616981692961417}
#define T_1331_7 {0.9994540785092775880826820866786874830723,-0.0330385373642778992775426161188079277053}
#define T_1331_8 {0.9992869795479443206787095732579473406076,-0.0377562247311138479699543779588566394523}
#define T_1331_9 {0.9990976119797584376058807720255572348833,-0.0424730707195049780877660339228896191344}
#define T_1331_10 {0.9988859800246808751111871060857083648443,-0.0471889702169150174193568147984478855506}
#define T_1331_12 {0.9983959423143420330859498790232464671135,-0.0566175093964489117848160049106809310615}
#define T_1331_13 {0.9981175474793243518334406871872488409281,-0.0613299389683276963136648873842204920948}
#define T_1331_14 {0.9978169100976583827389276848407462239265,-0.0660410018334174064857933217354002408683}
#define T_1331_15 {0.9974940368688970382393677027721423655748,-0.0707505930080557510208905114268418401480}
#define T_1331_16 {0.9971489349881073049886026637977920472622,-0.0754586075413763018859825137951702345163}
#define T_1331_17 {0.9967816121457107048087209477671422064304,-0.0801649405176473039968954026335268281400}
#define T_1331_18 {0.9963920765273118762550552673928905278444,-0.0848694870586096522524499619066773448139}
#define T_1331_19 {0.9959803368135157208840269049687776714563,-0.0895721423258140497791757184131711255759}
#define T_1331_20 {0.9955464021797342244468609351315535604954,-0.0942728015229572641198174665078113321215}
#define T_1331_21 {0.9950902822959821758530551960575394332409,-0.0989713598982175091212099005133495666087}
#define T_1331_23 {0.9941115279303341933925253215420525521040,-0.1083617554122139614580788702369318343699}
#define T_1331_24 {0.9935889152594860052047920362383592873812,-0.1130533832907174573989550481201149523258}
#define T_1331_25 {0.9930441609602771446674296385026536881924,-0.1177424918315358032261386256323021370918}
#define T_1331_26 {0.9924772771722824016293884596962016075850,-0.1224289765402477581091034153359942138195}
#define T_1331_27 {0.9918882765282215352442563016666099429131,-0.1271127329809028649876267991203349083662}
#define T_1331_28 {0.9912771721536771662997011844709049910307,-0.1317936567783487000760089813411468639970}
#define T_1331_29 {0.9906439776668022334504826176271308213472,-0.1364716436205569427553285777321434579790}
#define T_1331_30 {0.9899887071780169023327289323788136243820,-0.1411465892609477801311612665813299827278}
#define T_1331_31 {0.9893113752896939283587585123314056545496,-0.1458183895207130487126079287918400950730}
#define T_1331_32 {0.9886119970958331393262596975546330213547,-0.1504869402911378772902395439814426936209}
#define T_1331_34 {0.9871471646236041896926849403826054185629,-0.1598138772934909745959686233618413098156}
#define T_1331_35 {0.9863817429882896226089883384702261537313,-0.1644720556793274890416967082273913547397}
#define T_1331_36 {0.9855943403328170093757876202289480715990,-0.1691265688882717943553046779925352893770}
#define T_1331_37 {0.9847849742040577503132681158604100346565,-0.1737773131968421147508507829115842469037}
#define T_1331_38 {0.9839536626383281747720843668503221124411,-0.1784241849655448797218326717484160326421}
#define T_1331_39 {0.9831004241609878624430507443321403115988,-0.1830670806411839601768321017516427673399}
#define T_1331_40 {0.9822252777860261963027710407914128154516,-0.1877058967591685445519544828130165114999}
#define T_1331_41 {0.9813282430156392566189538229082245379686,-0.1923405299458187112104923244260135106742}
#define T_1331_42 {0.9804093398397950576139692202559672296047,-0.1969708769206690301967199729915591888130}
#define T_1331_43 {0.9794685887357876818981594624347053468227,-0.2015968344987701388326684082130668684840}
#define T_1331_45 {0.9775216270863439360638835751160513609648,-0.2108351692163020485448754470780841074884}
#define T_1331_46 {0.9765154599279670666334141060360707342625,-0.2154473404840983596919556930515682324767}
#define T_1331_47 {0.9754875316145789065913618287595454603434,-0.2200547106164642552350585447129560634494}
#define T_1331_48 {0.9744378650530443053412454901263117790222,-0.2246571769404777374479209584023919887841}
#define T_1331_49 {0.9733664836346533899558153279940597712994,-0.2292546368924956723400754299291293136775}
#define T_1331_50 {0.9722734112346014256900161853991448879242,-0.2338469880204395168199482668569544330239}
#define T_1331_51 {0.9711586722114561309737723604484926909208,-0.2384341279860781315225182197536923922598}
#define T_1331_52 {0.9700222914066148893752483672869857400656,-0.2430159545673086785022576350456802174449}
#define T_1331_53 {0.9688642941437515254676782205933704972267,-0.2475923656604342715237265792893595062196}
#define T_1331_54 {0.9676847062282514233544361559324897825718,-0.2521632592824394891728445600165287032723}
#define T_1331_56 {0.9652608640659816607865195692284032702446,-0.2612880867980675869688411694369278848171}
#define T_1331_57 {0.9640166638333133031224519982060883194208,-0.2658418173495067371447930781869217753410}
#define T_1331_58 {0.9627509809750074420975352040841244161129,-0.2703896237499895938150018537271535024047}
#define T_1331_59 {0.9614638436961685519221987306082155555487,-0.2749314046539418354697659196972381323576}
#define T_1331_60 {0.9601552806800025541278387208876665681601,-0.2794670588500645092011609449400566518307}
#define T_1331_61 {0.9588253210871769960377264396811369806528,-0.2839964852635890046883559989510104060173}
#define T_1331_62 {0.9574739945551712372306951692735310643911,-0.2885195829585298632480316882720217108727}
#define T_1331_63 {0.9561013311976160888860931663657538592815,-0.2930362511399338676376657986111240461469}
#define T_1331_64 {0.9547073616036230170323051424929872155190,-0.2975463891561264118124086053285282105207}
#define T_1331_65 {0.9532921168371020215204225678462535142899,-0.3020498965009540959236744583904510363936}
#define T_1331_67 {0.9503979284119460357871389533102046698332,-0.3110366178929442337874888835358433425426}
#define T_1331_68 {0.9489190492488420725081255113764200359583,-0.3155196316755484176042045874055474996567}
#define T_1331_69 {0.9474190239028343896166006743442267179489,-0.3199956142621339649778633429377805441618}
#define T_1331_70 {0.9458978858012323520654263120377436280251,-0.3244644659076841297640214634157018736005}
#define T_1331_71 {0.9443556688418320854694343324808869510889,-0.3289260870260916624907565619650995358825}
#define T_1331_72 {0.9427924073921613024040766504185739904642,-0.3333803781923779241402883144473889842629}
#define T_1331_73 {0.9412081362887139146522486043977551162243,-0.3378272401449084472169204218516824766994}
#define T_1331_74 {0.9396028908361733211762611972517333924770,-0.3422665737876052771682111597328912466764}
#define T_1331_75 {0.9379767068066253710156843226286582648754,-0.3466982801921548174028941957658389583230}
#define T_1331_76 {0.9363296204387621113340856027207337319851,-0.3511222606002128432400866131501970812678}
#define T_1331_78 {0.9329728879710285083248777482367586344481,-0.3599466492565234210232461009582038968801}
#define T_1331_79 {0.9312633166742499968293600431934464722872,-0.3643468608577209444376876490423455834389}
#define T_1331_80 {0.9295329926436727285832262168696615844965,-0.3687389531726989466697830266639357432723}
#define T_1331_81 {0.9277819544386957106851809840009082108736,-0.3731228283258931077703834944259142503142}
#define T_1331_82 {0.9260102410803232597658052327460609376431,-0.3774983886248544640018565132777439430356}
#define T_1331_83 {0.9242178920502946981585523644753266125917,-0.3818655365624263331447707514598732814193}
#define T_1331_84 {0.9224049472902052793088500948215369135141,-0.3862241748189172430016924408846534788609}
#define T_1331_85 {0.9205714472006154558414436905877664685249,-0.3905742062642698630980930829537101089954}
#define T_1331_86 {0.9187174326401509327766348178556654602289,-0.3949155339602250514019488036865368485451}
#define T_1331_87 {0.9168429449245920626054839885910041630268,-0.3992480611624825148631146021216409280896}
#define T_1331_89 {0.9130327175715514664844363323936704546213,-0.4078863280914273303778827539645135402679}
#define T_1331_90 {0.9110970628430665740893346082884818315506,-0.4121918753186884498695974343718262389302}
#define T_1331_91 {0.9091411047755887375743100164982024580240,-0.4164882370576893366731496826105285435915}
#define T_1331_92 {0.9071648869566579787004911850090138614178,-0.4207753175661732569778905599378049373627}
#define T_1331_93 {0.9051684534252927294417645498469937592745,-0.4250530213087111430780851151212118566036}
#define T_1331_94 {0.9031518486710083948310057166963815689087,-0.4293212529588303905114798908471129834652}
#define T_1331_95 {0.9011151176328257017544842710776720196009,-0.4335799174011392143057719295029528439045}
#define T_1331_96 {0.8990583056982697218728617372107692062855,-0.4378289197334462312660718907864065840840}
#define T_1331_97 {0.8969814587023582364011531353753525763750,-0.4420681652688753238145125123992329463363}
#define T_1331_98 {0.8948846229265798868368619878310710191727,-0.4462975595379756188485487200523493811488}
#define T_1331_100 {0.8906311723875368624447901311214081943035,-0.4547264174991393903546565979922888800502}
#define T_1331_101 {0.8884746524102742348816263984190300107002,-0.4589256933583500397411114590795477852225}
#define T_1331_102 {0.8862983332230369715176721001625992357731,-0.4631147422897120558005212842545006424189}
#define T_1331_103 {0.8841022633240016581623876845696941018105,-0.4672934709423806620698371716571273282170}
#define T_1331_104 {0.8818864916514795870838838709460105746984,-0.4714617861954931710144478529400657862425}
#define T_1331_105 {0.8796510675828258518649249708687420934439,-0.4756195951602444349504139609052799642086}
#define T_1331_106 {0.8773960409333396714970376706332899630070,-0.4797668051819565238069742463267175480723}
#define T_1331_107 {0.8751214619551536122443735621345695108175,-0.4839033238421436844411971378576708957553}
#define T_1331_108 {0.8728273813361143718125845225586090236902,-0.4880290589605717488375091761554358527064}
#define T_1331_109 {0.8705138501986525723097543050243984907866,-0.4921439185973122687478564785124035552144}
#define T_1331_111 {0.8658286430242602138562801883381325751543,-0.5003406448798339845041027729166671633720}
#define T_1331_112 {0.8634570713948109821345155978633556514978,-0.5044223288656999315549001039471477270126}
#define T_1331_113 {0.8610662580595750403844590437074657529593,-0.5084927720541181361824101259117014706135}
#define T_1331_114 {0.8586562562966230105487852597434539347887,-0.5125518837373130853762859260314144194126}
#define T_1331_115 {0.8562271198116297998836898841545917093754,-0.5165995734600261624080985711771063506603}
#define T_1331_116 {0.8537789027366781136052509282308164983988,-0.5206357510215312567325440795684698969126}
#define T_1331_117 {0.8513116596290519755285686187562532722950,-0.5246603264776450448181321917218156158924}
#define T_1331_118 {0.8488254454700209228334983890817966312170,-0.5286732101427312757735421655524987727404}
#define T_1331_119 {0.8463203156636148749569770188827533274889,-0.5326743125916992838142505206633359193802}
#define T_1331_120 {0.8437963260353892325227320725389290601015,-0.5366635446619969496140356568503193557262}
#define T_1331_126 {0.8282595110357071632734005106613039970398,-0.5603446996080995168298954922647681087255}
#define T_1331_138 {0.7952056137059991813842430019576568156481,-0.6063398650348377216801054601091891527176}
#define T_1331_144 {0.7777150468726141685493757904623635113239,-0.6286169786666023773236133820319082587957}
#define T_1331_150 {0.7596006050236041584611257349024526774883,-0.6503898222203161605392551791737787425518}
#define T_1331_156 {0.7408768193780026489747569939936511218548,-0.6716409297447070159137183509301394224167}
#define T_1331_162 {0.7215587099641721513521019915060605853796,-0.6923532538197821883940719089878257364035}
#define T_1331_168 {0.7016617735708928771387604683695826679468,-0.7125101792320928106860833395330701023340}
#define T_1331_174 {0.6812019713159972456040236465923953801394,-0.7320955363032882745599749796383548527956}
#define T_1331_180 {0.6601957158425255656197805365081876516342,-0.7510936138612651635781958248117007315159}
#define T_1331_186 {0.6386598581526726770007940103823784738779,-0.7694891718435081795490759759559296071529}
#define T_1331_192 {0.6166116740900869919173032940307166427374,-0.7872674535225118175318925750616472214460}
#define T_1331_204 {0.5710494709478671770952473707438912242651,-0.8209156483647762625466270947072189301252}
#define T_1331_210 {0.5475720013992103618605256087903399020433,-0.8367585692920408435568901950318831950426}
#define T_1331_216 {0.5236552752201175664481525018345564603806,-0.8519302510969679609331706160446628928185}
#define T_1331_222 {0.4993184781624636081609480697807157412171,-0.8664185232123798874326325858419295400381}
#define T_1331_228 {0.4745811329546638090981502955401083454490,-0.8802117632953263548500899560167454183102}
#define T_1331_234 {0.4494630836407417784350570855167461559176,-0.8932989065504085557378743942535948008299}
#define T_1331_240 {0.4239844796616416000567539867915911599994,-0.9056694546058440264957312137994449585676}
#define T_1331_246 {0.3981657596915530450409903551189927384257,-0.9173134839351531066853340234956704080105}
#define T_1331_252 {0.3720276352422174914735819584166165441275,-0.9282216538177093800854322580562438815832}
#define T_1331_258 {0.3455910740483661425237471576110692694783,-0.9383852138317699820291295509377960115671}
#define T_1331_270 {0.2919076923683351365568228175106924027205,-0.9564464956996776567876850094762630760670}
#define T_1331_276 {0.2647039361390695066944545033038593828678,-0.9643297289788816950562022611848078668118}
#define T_1331_282 {0.2372878371334118663416035133195691742003,-0.9714393868628898864869825047207996249199}
#define T_1331_288 {0.2096813882641448412158524661208502948284,-0.9777697660572354232400016371684614568949}
#define T_1331_294 {0.1819067351407546440089646466731210239232,-0.9833157883968055568146837686072103679180}
#define T_1331_300 {0.1539861583044511150752953199116745963693,-0.9880730049194930142419934782083146274090}
#define T_1331_306 {0.1259420553549464583120709448849083855748,-0.9920375994351079418365202400309499353170}
#define T_1331_312 {0.0977969229833310083055408767904737032950,-0.9952063915866861121273245771590154618025}
#define T_1331_318 {0.0695733389254589440486853391121258027852,-0.9975768394017391349493095731304492801428}
#define T_1331_324 {0.0412939438503206746045037789372145198286,-0.9991470413313980891700794018106535077095}
#define T_1331_336 {-0.0153415110186981250295357170898569165729,-0.9998823120946100928563282650429755449295}
#define T_1331_342 {-0.0436521384328999798030146450855681905523,-0.9990467911015153967824176106660161167383}
#define T_1331_348 {-0.0719277485503986291348610393470153212547,-0.9974098450428843243287246878026053309441}
#define T_1331_354 {-0.1001456589674334651807185991856385953724,-0.9949727870600172385806558850163128226995}
#define T_1331_360 {-0.1282832335663504630396403172198915854096,-0.9917375721357748474815707595553249120712}
#define T_1331_366 {-0.1563179006740629817251431177282938733697,-0.9877067955263109100272345131088513880968}
#define T_1331_372 {-0.1842271711688159563369282523126457817852,-0.9828836906791850180908909351273905485868}
#define T_1331_378 {-0.2119886565207281803324690372392069548368,-0.9772721266395234529511526488931849598885}
#define T_1331_384 {-0.2395800867516407473001294192727073095739,-0.9708766049463115610507202291046269237995}
#define T_1331_390 {-0.2669793282998646488657357167539885267615,-0.9637022560213051036726028542034327983856}
#define T_1331_402 {-0.3211134995920587043016780626203399151564,-0.9470407173821729918117284796608146280050}
#define T_1331_408 {-0.3478050034603221152273988536762772127986,-0.9375668933830616502689281333005055785179}
#define T_1331_414 {-0.3742175017302744599589914287207648158073,-0.9273409628603451748674046939413528889418}
#define T_1331_420 {-0.4003298065673261962871265495778061449528,-0.9163711289503654322530223907961044460535}
#define T_1331_426 {-0.4261209709489738317600426853459794074297,-0.9046661915411141619003387859265785664320}
#define T_1331_432 {-0.4515703054682857486845648509188322350383,-0.8922355402130532908699933614116162061691}
#define T_1331_438 {-0.4766573949307317814572115821647457778454,-0.8790891467068902009884823200991377234459}
#define T_1331_444 {-0.5013621147310426406917827080178540199995,-0.8652375569243494490834223142883274704218}
#define T_1331_450 {-0.5256646469969610269146187420119531452656,-0.8506918824683590285573586697864811867476}
#define T_1331_456 {-0.5495454964869354030909676112059969455004,-0.8354637917294367444043245995999313890934}
#define T_1331_468 {-0.5959658728883110434537684341194108128548,-0.8030097623020989727748997211165260523558}
#define T_1331_474 {-0.6184681618509685341322779095207806676626,-0.7858098579024598295816872450814116746187}
#define T_1331_480 {-0.6404743220120940883077764738118276000023,-0.7679795849130029994356050337955821305513}
#define T_1331_486 {-0.6619667002562314994662528988556005060673,-0.7495332465954239742345066588313784450293}
#define T_1331_492 {-0.6829280556184968986599415075033903121948,-0.7304856404126909286134150534053333103657}
#define T_1331_498 {-0.7033415731151031469181589272920973598957,-0.7108520461586729233260939508909359574318}
#define T_1331_504 {-0.7231908772321671285965294373454526066780,-0.6906482137008453925375306425848975777626}
#define T_1331_510 {-0.7424600450619787128658799701952375471592,-0.6698903503459089359139966290968004614115}
#define T_1331_516 {-0.7611336190761933684356677076721098273993,-0.6485951078384541990118350440752692520618}
#define T_1331_522 {-0.7791966195257030713960944012796971946955,-0.6267795690031039423928405085462145507336}
#define T_1331_534 {-0.8134334413370495342476829137012828141451,-0.5816580064905534364072536845924332737923}
#define T_1331_540 {-0.8295797982723868146948120738670695573092,-0.5583881788669472490127532182668801397085}
#define T_1331_546 {-0.8450606748217003305612138319702353328466,-0.5346704179865315875730402694898657500744}
#define T_1331_552 {-0.8598636523849668700236748009047005325556,-0.5105237499932642197819632201571948826313}
#define T_1331_558 {-0.8739768561657610401738338623545132577419,-0.4859675450959793363558958390058251097798}
#define T_1331_564 {-0.8873889646970948286153202388959471136332,-0.4610215020298057964076576809020480141044}
#define T_1331_570 {-0.9000892189233820062099766801111400127411,-0.4357056322540439063928374707757029682398}
#define T_1331_576 {-0.9120674308312418654409725604637060314417,-0.4100402438991784803690165972511749714613}
#define T_1331_582 {-0.9233139916222190546335468752658925950527,-0.3840459254759054363859149816562421619892}
#define T_1331_588 {-0.9338198794208626418722474227251950651407,-0.3577435293592400866735658837569644674659}
#define T_1331_600 {-0.9525765261012730800160852595581673085690,-0.3042991323037755324598663264623610302806}
#define T_1331_606 {-0.9608122385938927534354547788097988814116,-0.2772000039108812319277319602406350895762}
#define T_1331_611 {-0.9670868239715223468877525192510802298784,-0.2544466052056378324586205508239800110459}
#define T_1331_612 {-0.9682771973859432002029734576353803277016,-0.2498785085244891179812043446872849017382}
#define T_1331_617 {-0.9739048872200914974683882974204607307911,-0.2269565391188826108948006776699912734330}
#define T_1331_618 {-0.9749654141642219995489426764834206551313,-0.2223565631673307674276429679594002664089}
#define T_1331_623 {-0.9799416939799570069880019218544475734234,-0.1992844108295785676698841371035086922348}
#define T_1331_624 {-0.9808715237099848716084693478478584438562,-0.1946562456610438085480296876994543708861}
#define T_1331_629 {-0.9851924015867951078817554844135884195566,-0.1714524186345675882403583045743289403617}
#define T_1331_630 {-0.9859907882028695613740865155705250799656,-0.1667997769155701581755835150033817626536}
#define T_1331_635 {-0.9896527979769412786126281389442738145590,-0.1434828890718732874454133252584142610431}
#define T_1331_636 {-0.9903191010215264267202428527525626122952,-0.1388095031037706594823077921319054439664}
#define T_1331_641 {-0.9933193050662645351422952444409020245075,-0.1153982590105817329639847912403638474643}
#define T_1331_642 {-0.9938529900379077242078551535087171941996,-0.1107078777355546828076171550492290407419}
#define T_1331_647 {-0.9961889816204698711032961000455543398857,-0.0872210576522157166046156362426700070500}
#define T_1331_648 {-0.9965896204025731508480134834826458245516,-0.0825174436459055610226798194162256550044}
#define T_1331_653 {-0.9982595256145260220748127721890341490507,-0.0589738884580409197799788501015427755192}
#define T_1331_654 {-0.9985267968187769849208734740386717021465,-0.0542608149112499896227213014299195492640}
#define T_1331_659 {-0.9995292760793262898388888970657717436552,-0.0306794110168016366524401661308729671873}
#define T_1331_665 {-0.9999972144341010560353311120707076042891,-0.0023603228674316028765090003105342475465}
#define T_1331_666 {-0.9999972144341010560353311120707076042891,0.0023603228674316028765090003105342475465}
#define T_1331_672 {-0.9995292760793262898388888970657717436552,0.0306794110168016366524401661308729671873}
#define T_1331_678 {-0.9982595256145260220748127721890341490507,0.0589738884580409197799788501015427755192}
#define T_1331_684 {-0.9961889816204698711032961000455543398857,0.0872210576522157166046156362426700070500}
#define T_1331_690 {-0.9933193050662645351422952444409020245075,0.1153982590105817329639847912403638474643}
#define T_1331_696 {-0.9896527979769412786126281389442738145590,0.1434828890718732874454133252584142610431}
#define T_1331_702 {-0.9851924015867951078817554844135884195566,0.1714524186345675882403583045743289403617}
#define T_1331_708 {-0.9799416939799570069880019218544475734234,0.1992844108295785676698841371035086922348}
#define T_1331_714 {-0.9739048872200914974683882974204607307911,0.2269565391188826108948006776699912734330}
#define T_1331_720 {-0.9670868239715223468877525192510802298784,0.2544466052056378324586205508239800110459}
// Pre-computed twiddles for N=1728
#define T_1728_1 {0.9999933893861943090541899437084794044495,-0.0036360945960279551607274850510975738871}
#define T_1728_5 {0.9998347390248375488042142933409195393324,-0.0181795115208017304953003190348681528121}
#define T_1728_7 {0.9996760970536633372773849259829148650169,-0.0254499701287601541588312414887695922516}
#define T_1728_11 {0.9992002214785726810220012339414097368717,-0.0399864651747465493780708811755175702274}
#define T_1728_13 {0.9988830130412104102433090702106710523367,-0.0472517328540768138944727638772747013718}
#define T_1728_17 {0.9980901387433863680698209464026149362326,-0.0617743874369278758718060373666958184913}
#define T_1728_19 {0.9976145148138723106612246738222893327475,-0.0690310063137001966859784829466661904007}
#define T_1728_23 {0.9965050191585387295845066546462476253510,-0.0835329084363788249012472419963160064071}
#define T_1728_25 {0.9958712061081035349374701581837143748999,-0.0907774247530250127935502746368001680821}
#define T_1728_29 {0.9944456171551021572696527073276229202747,-0.1052516722955411793138935649949416983873}
#define T_1728_31 {0.9936539166444308124326312281482387334108,-0.1124806380546562040168012686081056017429}
#define T_1728_35 {0.9919129128968936504051612246257718652487,-0.1269203420591022979380113611114211380482}
#define T_1728_37 {0.9909637017325507724052613411913625895977,-0.1341303166645042843629909157243673689663}
#define T_1728_41 {0.9889081118139692039292754088819492608309,-0.1485286046138259152815663810542901046574}
#define T_1728_43 {0.9878018417690599406455476128030568361282,-0.1557161565080936171945324986154446378350}
#define T_1728_47 {0.9854326440289048472109811882546637207270,-0.1700661755970356014966426982937264256179}
#define T_1728_49 {0.9841698416280552086377042542153503745794,-0.1772278838947438373008225198645959608257}
#define T_1728_53 {0.9814881636761355609976931191340554505587,-0.1915228042914142447816772119040251709521}
#define T_1728_55 {0.9800694299448950985720330209005624055862,-0.1986552604072901184739663449363433755934}
#define T_1728_59 {0.9770765481146769237952298681193497031927,-0.2128882785037904123992547056332114152610}
#define T_1728_61 {0.9755025582934635508536302950233221054077,-0.2199880877750153285177248108084313571453}
#define T_1728_65 {0.9721998970346039659062853388604708015919,-0.2341524294255892535421281763774459250271}
#define T_1728_67 {0.9704714002573253672778719192137941718102,-0.2412162127274744549687568451190600171685}
#define T_1728_71 {0.9668605314577121134789194911718368530273,-0.2553051364726344751865383386757457628846}
#define T_1728_73 {0.9649783503952192864616677070443984121084,-0.2623295318269015519163644967193249613047}
#define T_1728_77 {0.9610609926328369523318428946367930620909,-0.2763363321019985385795791898999596014619}
#define T_1728_79 {0.9590260231013771896613206990878097712994,-0.2833179962768987425469902063923655077815}
#define T_1728_83 {0.9548040408263572809133279406523797661066,-0.2972360066036075498807633721298770979047}
#define T_1728_85 {0.9526172513612137793259648788080085068941,-0.3041716167051193298043187951407162472606}
#define T_1728_89 {0.9480926540084575471212247066432610154152,-0.3179942128643213350436269593046745285392}
#define T_1728_91 {0.9457550854029795894817311818769667297602,-0.3248804679176677256968730489461449906230}
#define T_1728_95 {0.9409300264357753906807602106709964573383,-0.3386010711022204300313376279518706724048}
#define T_1728_97 {0.9384427912460171494757332766312174499035,-0.3454346936229544251517609154689125716686}
#define T_1728_101 {0.9333195671311090846344882265839260071516,-0.3590467735688473438493417688732733950019}
#define T_1728_103 {0.9306838491463124141134244382556062191725,-0.3658245111227567680778349767933832481503}
#define T_1728_107 {0.9252648982609064098880935489432886242867,-0.3793215892171634129326207585108932107687}
#define T_1728_109 {0.9224819519400822009913554211379960179329,-0.3860402159682536638030114772845990955830}
#define T_1728_113 {0.9167698534113102315501464545377530157566,-0.3994158683330004677713986893650144338608}
#define T_1728_115 {0.9138410032861832288375580901629291474819,-0.4060721865788176065947823190072085708380}
#define T_1728_119 {0.9078384757635787893903511758253443986177,-0.4193200471278017982257324547390453517437}
#define T_1728_121 {0.9047651158081826405776837418670766055584,-0.4259108888213658516974646772723644971848}
#define T_1728_125 {0.8984750161697507842006871214834973216057,-0.4390246522904678316834292672865558415651}
#define T_1728_127 {0.8952586091369715282084484897495713084936,-0.4455468805480913840888490540237398818135}
#define T_1728_131 {0.8886839311294693066756167354469653218985,-0.4585203054961389246280134557309793308377}
#define T_1728_133 {0.8853260078548547129528856203251052647829,-0.4649708160904140741287449145602295175195}
#define T_1728_137 {0.8784698806689305028427838806237559765577,-0.4777977278697702057108642748062266036868}
#define T_1728_139 {0.8749720393420946651374947578005958348513,-0.4841734507070126203309712309419410303235}
#define T_1728_143 {0.8678377261229622829930008265364449471235,-0.4968477444023736144806946413154946640134}
#define T_1728_145 {0.8642016315269342996430168568622320890427,-0.5031456449838206390623440711351577192545}
#define T_1728_149 {0.8567925278212928930088310153223574161530,-0.5156612883178249839843942936568055301905}
#define T_1728_157 {0.8414321982753925066589317793841473758221,-0.5403627075450715411264468457375187426805}
#define T_1728_161 {0.8334842217000436592755363562901038676500,-0.5525432581952950394921231236367020756006}
#define T_1728_163 {0.8294440098560504903701939838356338441372,-0.5585898625234044789777954065357334911823}
#define T_1728_173 {0.8085893309906420078903011017246171832085,-0.5883734305762845506748703883204143494368}
#define T_1728_175 {0.8042892153566539858999817624862771481276,-0.5942380483114303446612325387832242995501}
#define T_1728_185 {0.7821552445324865265874336728302296251059,-0.6230836006912123803402892008307389914989}
#define T_1728_187 {0.7776034106230155229511069592263083904982,-0.6287550682002125412850546126719564199448}
#define T_1728_191 {0.7683766156489815202235149627085775136948,-0.6399979504059504220592202727857511490583}
#define T_1728_199 {0.7494373936011673453805315148201771080494,-0.6620752170805738190395572928537148982286}
#define T_1728_203 {0.7397289728574233391711345575458835810423,-0.6729049314095575384797598417208064347506}
#define T_1728_205 {0.7348159530513419523956031298439484089613,-0.6782665516898559454617156916356179863214}
#define T_1728_215 {0.7096732139225847557639781371108256280422,-0.7045309996308105615625549944525118917227}
#define T_1728_217 {0.7045309996308105615625549944525118917227,-0.7096732139225847557639781371108256280422}
#define T_1728_245 {0.6287550682002125412850546126719564199448,-0.7776034106230155229511069592263083904982}
#define T_1728_259 {0.5883734305762845506748703883204143494368,-0.8085893309906420078903011017246171832085}
#define T_1728_287 {0.5031456449838206390623440711351577192545,-0.8642016315269342996430168568622320890427}
#define T_1728_301 {0.4585203054961389246280134557309793308377,-0.8886839311294693066756167354469653218985}
#define T_1728_329 {0.3658245111227567680778349767933832481503,-0.9306838491463124141134244382556062191725}
#define T_1728_343 {0.3179942128643213350436269593046745285392,-0.9480926540084575471212247066432610154152}
#define T_1728_371 {0.2199880877750153285177248108084313571453,-0.9755025582934635508536302950233221054077}
#define T_1728_385 {0.1700661755970356014966426982937264256179,-0.9854326440289048472109811882546637207270}
#define T_1728_413 {0.0690310063137001966859784829466661904007,-0.9976145148138723106612246738222893327475}
#define T_1728_427 {0.0181795115208017304953003190348681528121,-0.9998347390248375488042142933409195393324}
#define T_1728_455 {-0.0835329084363788249012472419963160064071,-0.9965050191585387295845066546462476253510}
#define T_1728_469 {-0.1341303166645042843629909157243673689663,-0.9909637017325507724052613411913625895977}
#define T_1728_497 {-0.2341524294255892535421281763774459250271,-0.9721998970346039659062853388604708015919}
#define T_1728_511 {-0.2833179962768987425469902063923655077815,-0.9590260231013771896613206990878097712994}
#define T_1728_539 {-0.3793215892171634129326207585108932107687,-0.9252648982609064098880935489432886242867}
#define T_1728_553 {-0.4259108888213658516974646772723644971848,-0.9047651158081826405776837418670766055584}
#define T_1728_581 {-0.5156612883178249839843942936568055301905,-0.8567925278212928930088310153223574161530}
#define T_1728_595 {-0.5585898625234044789777954065357334911823,-0.8294440098560504903701939838356338441372}
#define T_1728_623 {-0.6399979504059504220592202727857511490583,-0.7683766156489815202235149627085775136948}
#define T_1728_637 {-0.6782665516898559454617156916356179863214,-0.7348159530513419523956031298439484089613}
#define T_1728_665 {-0.7494373936011673453805315148201771080494,-0.6620752170805738190395572928537148982286}
#define T_1728_679 {-0.7821552445324865265874336728302296251059,-0.6230836006912123803402892008307389914989}
#define T_1728_707 {-0.8414321982753925066589317793841473758221,-0.5403627075450715411264468457375187426805}
#define T_1728_721 {-0.8678377261229622829930008265364449471235,-0.4968477444023736144806946413154946640134}
#define T_1728_749 {-0.9138410032861832288375580901629291474819,-0.4060721865788176065947823190072085708380}
#define T_1728_763 {-0.9333195671311090846344882265839260071516,-0.3590467735688473438493417688732733950019}
#define T_1728_791 {-0.9649783503952192864616677070443984121084,-0.2623295318269015519163644967193249613047}
#define T_1728_805 {-0.9770765481146769237952298681193497031927,-0.2128882785037904123992547056332114152610}
#define T_1728_833 {-0.9936539166444308124326312281482387334108,-0.1124806380546562040168012686081056017429}
#define T_1728_847 {-0.9980901387433863680698209464026149362326,-0.0617743874369278758718060373666958184913}
#define T_1728_875 {-0.9992002214785726810220012339414097368717,0.0399864651747465493780708811755175702274}
#define T_1728_889 {-0.9958712061081035349374701581837143748999,0.0907774247530250127935502746368001680821}
#define T_1728_917 {-0.9814881636761355609976931191340554505587,0.1915228042914142447816772119040251709521}
#define T_1728_931 {-0.9704714002573253672778719192137941718102,0.2412162127274744549687568451190600171685}
#define T_1728_959 {-0.9409300264357753906807602106709964573383,0.3386010711022204300313376279518706724048}
#define T_1728_973 {-0.9224819519400822009913554211379960179329,0.3860402159682536638030114772845990955830}
#define T_1728_1001 {-0.8784698806689305028427838806237559765577,0.4777977278697702057108642748062266036868}
// Pre-computed twiddles for N=2000
#define T_2000_1 {0.9999950652018582131219659459020476788282,-0.0031415874858795635182762140402701334096}
#define T_2000_3 {0.9999555871089498282344720792025327682495,-0.0094246384331440075793340227505723305512}
#define T_2000_7 {0.9997582044369840437170182667614426463842,-0.0219893760925051091892346022405035910197}
#define T_2000_9 {0.9996003076502565365402119823556859046221,-0.0282705667702732518775654568798927357420}
#define T_2000_11 {0.9994029483549728976043979855603538453579,-0.0345506413744722726266722645505069522187}
#define T_2000_13 {0.9991661343425400909623590450792107731104,-0.0408293519785099950913931365903408732265}
#define T_2000_17 {0.9985741811195097961117994600499514490366,-0.0533816897587604741182154555190209066495}
#define T_2000_19 {0.9982190652782118034380687277007382363081,-0.0596548213901706980699657378863776102662}
#define T_2000_21 {0.9978245414574414828834392210410442203283,-0.0659255979513778539446988702366070356220}
#define T_2000_23 {0.9973906252323236909518300308263860642910,-0.0721937718828605939913600764157308731228}
#define T_2000_27 {0.9964046856445923916467677372565958648920,-0.0847213221420734380329164991962898056954}
#define T_2000_29 {0.9958527012051856530661098076961934566498,-0.0909802039035699089408737449957698117942}
#define T_2000_31 {0.9952614022063083210056788630026858299971,-0.0972354939223993297581216666003456339240}
#define T_2000_33 {0.9946308119914323286891999487124849110842,-0.1034869452504225267874815585855685640126}
#define T_2000_37 {0.9932518590423393689547992835287004709244,-0.1159773448089613662181918130045232828707}
#define T_2000_39 {0.9925035507468237261363697143679019063711,-0.1222157999398894440146179363182454835624}
#define T_2000_41 {0.9917160601105629025298071610450278967619,-0.1284494302003028332048728543668403290212}
#define T_2000_43 {0.9908894182223386692953681631479412317276,-0.1346779894971525948221824364736676216125}
#define T_2000_47 {0.9891188127719617861899337185604963451624,-0.1471189118386373728686322692738031037152}
#define T_2000_49 {0.9881749191102805474073988989403005689383,-0.1533307837369606296817892143735662102699}
#define T_2000_51 {0.9871920139948191508239005997893400490284,-0.1595366023984862990925392978169838897884}
#define T_2000_53 {0.9861701362289888583845254288462456315756,-0.1657361228281196974254640963408746756613}
#define T_2000_57 {0.9840096256511396966004667774541303515434,-0.1781152902642101354402370816387701779604}
#define T_2000_59 {0.9828710781323791723096405803516972810030,-0.1842944485623333183976768623324460349977}
#define T_2000_61 {0.9816937285463989137923590533318929374218,-0.1904663312311898892836836694186786189675}
#define T_2000_63 {0.9804776233729444179232359601883217692375,-0.1966306946154200430143532685178797692060}
#define T_2000_67 {0.9779293398307218332377033220836892724037,-0.2089358904024117002951044241854106076062}
#define T_2000_69 {0.9765972620638245782487274482264183461666,-0.2150762370171133697205334556201705709100}
#define T_2000_71 {0.9752266299092233747813907029922120273113,-0.2212080927902471405577244922824320383370}
#define T_2000_73 {0.9738174974771288683328407387307379394770,-0.2273312156466464339921174087066901847720}
#define T_2000_77 {0.9708839558187309926040597929386422038078,-0.2395502960419218507759353542496683076024}
#define T_2000_79 {0.9693596624036292519477342466416303068399,-0.2456457711924263376257471236385754309595}
#define T_2000_81 {0.9677971003288654561202974946354515850544,-0.2517315486684971181929881822725292295218}
#define T_2000_83 {0.9661963312817146709576832108723465353251,-0.2578073882140598516166107856406597420573}
#define T_2000_87 {0.9628804265585876320798774941067676991224,-0.2699282944604963208057313295284984633327}
#define T_2000_89 {0.9611654217888518925150265204138122498989,-0.2759728826487457542526726683718152344227}
#define T_2000_91 {0.9594124718540428808921660674968734383583,-0.2820065759001294525276648528233636170626}
#define T_2000_93 {0.9576216459576222250760224596888292580843,-0.2880291360147692047988243757572490721941}
#define T_2000_97 {0.9539266505673935636622218225966207683086,-0.3000399062412762440921198958676541224122}
#define T_2000_99 {0.9520226269456766310383954987628385424614,-0.3060276421885007036571835214999737218022}
#define T_2000_101 {0.9500810191007716953848216689948458224535,-0.3120032966884148661890208131808321923018}
#define T_2000_103 {0.9481019036840320213244126534846145659685,-0.3179666338324109720048227245570160448551}
#define T_2000_107 {0.9440314641410497698004178346309345215559,-0.3298554148588528911467676607571775093675}
#define T_2000_109 {0.9419403007087906454231074349081609398127,-0.3357803893925806471010275799926603212953}
#define T_2000_111 {0.9398119510863196524041995871812105178833,-0.3416921078914832987649674578278791159391}
#define T_2000_113 {0.9376464992972356471412354039784986525774,-0.3475903369710370283129918789200019091368}
#define T_2000_117 {0.9332046326338986341752956832351628690958,-0.3593453960058906604402295670297462493181}
#define T_2000_119 {0.9309283931169357595436508745478931814432,-0.3652017618915878172103361976041924208403}
#define T_2000_121 {0.9286154021410173431405610244837589561939,-0.3710437102370510165094685817166464403272}
#define T_2000_123 {0.9262657510190666076965726460912264883518,-0.3768710104121626436324277165113016963005}
#define T_2000_127 {0.9214568408214984795989721533260308206081,-0.3884807466313661139523105703119654208422}
#define T_2000_129 {0.9189977715934213309267875047225970774889,-0.3942627243429510097705303905968321487308}
#define T_2000_131 {0.9165024219068980126934320651344023644924,-0.4000291372372647424882075029017869383097}
#define T_2000_133 {0.9139708902740611984327756545098964124918,-0.4057797576662000027525323275767732411623}
#define T_2000_137 {0.9087996823560401393748975351627450436354,-0.4172327136617652865169247888843528926373}
#define T_2000_139 {0.9061602102212897857924644995364360511303,-0.4229345970853032876668464723479701206088}
#define T_2000_141 {0.9034849644330348317211587527708616107702,-0.4286197837751283268303836848645005375147}
#define T_2000_143 {0.9007740506053980578116124888765625655651,-0.4342880492898045785565841470088344067335}
#define T_2000_147 {0.8952456483248116825279794284142553806305,-0.4455729223768962743434940421138890087605}
#define T_2000_149 {0.8924283781237178914125252049416303634644,-0.4511890844418450230435269077133852988482}
#define T_2000_151 {0.8895758763783380151934920831990893930197,-0.4567874343342994691852254618424922227859}
#define T_2000_153 {0.8866882557005565379526501601503696292639,-0.4623677510409917590372685936017660424113}
#define T_2000_157 {0.8808081149230035933328508690465241670609,-0.4734734044123121154967748225317336618900}
#define T_2000_159 {0.8778158269611217034977812545548658818007,-0.4789983026447610092724005426134681329131}
#define T_2000_161 {0.8747888843334528097273050661897286772728,-0.4845042908443979445820559703861363232136}
#define T_2000_163 {0.8717274065385088865909324340464081615210,-0.4899911516442365666534897172823548316956}
#define T_2000_167 {0.8655013302530190077987981567275710403919,-0.5009066253607098451183787801710423082113}
#define T_2000_169 {0.8623369775573039852645251812646165490150,-0.5063348073531325210794307167816441506147}
#define T_2000_171 {0.8591385812742724503721092332853004336357,-0.5117430001143449258549367186788003891706}
#define T_2000_173 {0.8559062676711329809009498603700194507837,-0.5171309901381572204925873847969342023134}
#define T_2000_177 {0.8493404002633165861269048946269322186708,-0.5278455119450663479696572721877600997686}
#define T_2000_179 {0.8460071056678422074526224605506286025047,-0.5331716207371886007138073182431980967522}
#define T_2000_181 {0.8426404121604322838834377762395888566971,-0.5384766808266602255983457325783092528582}
#define T_2000_183 {0.8392404526523816743477368618187028914690,-0.5437604827787925199089613670366816222668}
#define T_2000_187 {0.8323412738406634758803193108178675174713,-0.5542634787366941262476416341087315231562}
#define T_2000_189 {0.8288423269047618946459010658145416527987,-0.5594822581021670071521612044307403266430}
#define T_2000_191 {0.8253106586929995769352785828232299536467,-0.5646789500660770455553461033559869974852}
#define T_2000_193 {0.8217464086295902525591827725293114781380,-0.5698533494719237868508798783295787870884}
#define T_2000_197 {0.8145207270705093760554404980211984366179,-0.5801344543918494078837966299033723771572}
#define T_2000_199 {0.8108595808323734166478402585198637098074,-0.5852407540255101237036683414771687239408}
// Pre-computed twiddles for N=2048
#define T_2048_1 {0.9999952938095761911796444110223092138767,-0.0030679567629659761432425746363605867373}
#define T_2048_3 {0.9999576445519638978609577861789148300886,-0.0092037547820598194364682953505507612135}
#define T_2048_5 {0.9998823474542125611108644989144522696733,-0.0153392062849881018887776562564795312937}
#define T_2048_7 {0.9997694053512152789764400040439795702696,-0.0214740802754695078724544998749479418620}
#define T_2048_9 {0.9996188224951786382987961587787140160799,-0.0276081457789657432055907548829054576345}
#define T_2048_11 {0.9994306045554617323745105750276707112789,-0.0337411718513775868433235416432580677792}
#define T_2048_13 {0.9992047586183638863133182894671335816383,-0.0398729275877398106620042028680472867563}
#define T_2048_15 {0.9989412931868568712445721757831051945686,-0.0460031821309146299325831819260201882571}
#define T_2048_17 {0.9986402181802652711084533621033187955618,-0.0521317046802833236607277456187148345634}
#define T_2048_19 {0.9983015449338928926081848658213857561350,-0.0582582645004357593809807269735756563023}
#define T_2048_21 {0.9979252861985959954793656834226567298174,-0.0643826309298574650519242368318373337388}
#define T_2048_23 {0.9975114561403034540987277978274505585432,-0.0705045733896138698826305812872305978090}
#define T_2048_25 {0.9970600703394829622538964031264185905457,-0.0766238613920314920457954599442018661648}
#define T_2048_27 {0.9965711457905548353863878219272010028362,-0.0827402645493756916383887300980859436095}
#define T_2048_29 {0.9960447009012519670179131026088725775480,-0.0888535525825246003117641180324426386505}
#define T_2048_31 {0.9954807554919269385607094591250643134117,-0.0949634953296390055266229524022492114455}
#define T_2048_33 {0.9948793307948056163780847782618366181850,-0.1010698627548278216714550126198446378112}
#define T_2048_35 {0.9942404494531879022289899694442283362150,-0.1071724249568088427331247203255770727992}
#define T_2048_37 {0.9935641355205953040297117695445194840431,-0.1132709521775643463081806316949950996786}
#define T_2048_39 {0.9928504144598651048880810776608996093273,-0.1193652148109913685436467289946449454874}
#define T_2048_41 {0.9920993131421917965440115949604660272598,-0.1254549834115462336736612769527710042894}
#define T_2048_43 {0.9913108598461154441494613820395898073912,-0.1315400287028831161073583189136115834117}
#define T_2048_45 {0.9904850842564570934101197963173035532236,-0.1376201215864860383231160767536493949592}
#define T_2048_47 {0.9896220174632008870219124219147488474846,-0.1436950331502944433470503327043843455613}
#define T_2048_49 {0.9887216919603237785807436921459157019854,-0.1497645346773215091484843242142233066261}
#define T_2048_51 {0.9877841416445721778316624295257497578859,-0.1558283976542652327079707674784003756940}
#define T_2048_53 {0.9868094018141855272574503032956272363663,-0.1618863937801118257908683517598547041416}
#define T_2048_55 {0.9857975091675674761404479795601218938828,-0.1679382949747311726262921638408442959189}
#define T_2048_57 {0.9847485018019042080084091139724478125572,-0.1739838733874638221355013456559390760958}
#define T_2048_59 {0.9836624192117302545312895745155401527882,-0.1800229014056995147097239851063932292163}
#define T_2048_61 {0.9825393022874412407574595818005036562681,-0.1860551516634466606703313118487130850554}
#define T_2048_63 {0.9813791933137545608900609295233152806759,-0.1920803970498924373444538105104584246874}
#define T_2048_65 {0.9801821359681174294919969725015107542276,-0.1980984107179535880227660982200177386403}
#define T_2048_67 {0.9789481753190621970972529197752010077238,-0.2041089660928168680875671725516440346837}
#define T_2048_69 {0.9776773578245099294292685954133048653603,-0.2101118368804696101559414955772808752954}
#define T_2048_71 {0.9763697313300211400033390418684575706720,-0.2161067970762195200595812138999463059008}
#define T_2048_73 {0.9750253450669941202022528159432113170624,-0.2220936209732035371278158208951936103404}
#define T_2048_75 {0.9736442496508119770481926025240682065487,-0.2280720831708857310182736455317353829741}
#define T_2048_77 {0.9722264970789362692471513582859188318253,-0.2340419585835434301834823145327391102910}
#define T_2048_79 {0.9707721407289503501303329358051996678114,-0.2400030224487414987066813409910537302494}
#define T_2048_81 {0.9692812353565485317119510000338777899742,-0.2459550503357946227289687612937996163964}
#define T_2048_83 {0.9677538370934755107555247377604246139526,-0.2518978181542169680895426608913112431765}
#define T_2048_85 {0.9661900034454125041349925595568493008614,-0.2578311021621589871344326638791244477034}
#define T_2048_87 {0.9645897932898127580259028945874888449907,-0.2637546789748314024492970020219217985868}
#define T_2048_89 {0.9629532668736838774137254404195118695498,-0.2696683255729150907598068442894145846367}
#define T_2048_91 {0.9612804858113206396552641308517195284367,-0.2755718193109581437560962058341829106212}
#define T_2048_93 {0.9595715130819845173348880962294060736895,-0.2814649379257579964175306486140470951796}
#define T_2048_95 {0.9578264130275329080177471041679382324219,-0.2873474595447295110162144737842027097940}
#define T_2048_97 {0.9560452513499964055654345429502427577972,-0.2932191626942586282211777870543301105499}
#define T_2048_99 {0.9542280951091056673263324228173587471247,-0.2990798263080404750802188118541380390525}
#define T_2048_101 {0.9523750127197658787991940698702819645405,-0.3049292297354024294797625316277844831347}
#define T_2048_103 {0.9504860739494817023498285379901062697172,-0.3107671527496114749489208861632505431771}
#define T_2048_105 {0.9485613499157302674902325634320732206106,-0.3165933755561658458077545219566673040390}
#define T_2048_107 {0.9466009130832835349877996122813783586025,-0.3224076788010698524367114714550552889705}
#define T_2048_109 {0.9446048372614802568492109458020422607660,-0.3282098435790925528010575362714007496834}
#define T_2048_111 {0.9425731976014468660451939285849221050739,-0.3339996514420093820518786742468364536762}
#define T_2048_113 {0.9405060705932682951768697421357501298189,-0.3397768844068268512259578528755810111761}
#define T_2048_115 {0.9384035340631080579498757288092747330666,-0.3455413249639890382880480501626152545214}
#define T_2048_117 {0.9362656671702782595900771411834284663200,-0.3512927560855671482720197218441171571612}
#define T_2048_119 {0.9340925504042588700670535217795986682177,-0.3570309612334300330971359471732284873724}
#define T_2048_121 {0.9318842655816681475045015758951194584370,-0.3627557243673972253716897284903097897768}
#define T_2048_123 {0.9296408958431812141753880496253259480000,-0.3684668299533723212491054255224298685789}
#define T_2048_125 {0.9273625256504011149516486511856783181429,-0.3741640629714579890929826433421112596989}
#define T_2048_127 {0.9250492407826775842494271273608319461346,-0.3798472089240511606611505612818291410804}
#define T_2048_129 {0.9227011283338785174734653082850854843855,-0.3855160538439188488979425528668798506260}
#define T_2048_131 {0.9203182767091105942469653200532775372267,-0.3911703843022538706897250904148677363992}
#define T_2048_133 {0.9179007756213904967168559778656344860792,-0.3968099874167103080502272405283292755485}
#define T_2048_135 {0.9154487160882678331574879848631098866463,-0.4024346508594184301799145941913593560457}
#define T_2048_137 {0.9129621904283982125605234614340588450432,-0.4080441628649786878213490126654505729675}
#define T_2048_139 {0.9104412922580672473671370426018256694078,-0.4136383122384345578659292641532374545932}
#define T_2048_141 {0.9078861164876662614986457811028230935335,-0.4192168883632239606562563949410105124116}
#define T_2048_143 {0.9052967593181188155071481560298707336187,-0.4247796812091088058949139849573839455843}
#define T_2048_145 {0.9026733182372588260022894246503710746765,-0.4303264813400826116485120564902899786830}
#define T_2048_147 {0.9000158920161602793541533173993229866028,-0.4358570799222554748020286297105485573411}
#define T_2048_149 {0.8973245807054183176276751510158646851778,-0.4413712687317166705192050812911475077271}
#define T_2048_151 {0.8945994856313826959492985224642325192690,-0.4468688401623742145751805310283089056611}
#define T_2048_153 {0.8918407093923427231274558835139032453299,-0.4523495872337708889610041751438984647393}
#define T_2048_155 {0.8890483558546645737052926961041521281004,-0.4578133035988772303603866475896211341023}
#define T_2048_157 {0.8862225301488806383787277809460647404194,-0.4632597835518602047422120904229814186692}
#define T_2048_159 {0.8833633386657315789136646344559267163277,-0.4686888220358279566468695520597975701094}
#define T_2048_161 {0.8804708890521607544954463264730293303728,-0.4741002146505500225437401695671724155545}
#define T_2048_163 {0.8775452902072612415551589037931989878416,-0.4794937576601530082598401349969208240509}
#define T_2048_165 {0.8745866522781761132065980746119748800993,-0.4848692480007911198569559019233565777540}
#define T_2048_167 {0.8715950866559510901154794737522024661303,-0.4902264832882911593792130133806494995952}
#define T_2048_169 {0.8685707059713408950685220588638912886381,-0.4955652618257725405825908637780230492353}
#define T_2048_171 {0.8655136240905690891977997125650290399790,-0.5008853826112408258453001508314628154039}
#define T_2048_173 {0.8624239561110405016819413503981195390224,-0.5061866453451553393705353300902061164379}
#define T_2048_175 {0.8593018183570083623479263223998714238405,-0.5114688504379704125923922219953965395689}
#define T_2048_177 {0.8561473283751944718389381705492269247770,-0.5167317990176498732068921526661142706871}
#define T_2048_179 {0.8529606049303636305936038297659251838923,-0.5219752929371543892500540096079930663109}
#define T_2048_181 {0.8497417680008524376589207349752541631460,-0.5271991347819013906672580560552887618542}
#define T_2048_183 {0.8464909387740521262699644466920290142298,-0.5324031278771980124631113540090154856443}
#define T_2048_185 {0.8432082396418454361963767951237969100475,-0.5375870762956455051195803207519929856062}
#define T_2048_187 {0.8398937941959995212570788680750411003828,-0.5427507848645158894385076564503833651543}
#define T_2048_189 {0.8365477272235120054233448172453790903091,-0.5478940591731001896746988677477929741144}
#define T_2048_191 {0.8331701647019131851124029708444140851498,-0.5530167055800275788257636122580152004957}
#define T_2048_193 {0.8297612337945230454039347023353911936283,-0.5581185312205561022125266390503384172916}
#define T_2048_195 {0.8263210628456635342686809053702745586634,-0.5631993440138340911715886250021867454052}
#define T_2048_197 {0.8228497813758263168537609999475535005331,-0.5682589526701316007262221319251693785191}
#define T_2048_199 {0.8193475200767970090254266324336640536785,-0.5732971666980422043025100720115005970001}
#define T_2048_201 {0.8158144108067337807455032816505990922451,-0.5783137964116555895799365316634066402912}
#define T_2048_203 {0.8122505865852038819951985715306363999844,-0.5833086529376982909411708533298224210739}
#define T_2048_205 {0.8086561815881749826218083398998714983463,-0.5882815482226453340786065382417291402817}
#define T_2048_207 {0.8050313311429635465543697137036360800266,-0.5932322950397997951554884821234736591578}
#define T_2048_209 {0.8013761717231402403882611906738020479679,-0.5981607069963422729230728691618423908949}
#define T_2048_211 {0.7976908409433911550934226397657766938210,-0.6030665985403481643700729364354629069567}
#define T_2048_213 {0.7939754775543371723145469331939239054918,-0.6079497849677736320828103089297655969858}
#define T_2048_215 {0.7902302214373100319733111973619088530540,-0.6128100824294097082045595925592351704836}
#define T_2048_217 {0.7864552135990857673064624577818904072046,-0.6176473079378039798825739126186817884445}
#define T_2048_219 {0.7826505961665757293843626030138693749905,-0.6224612793741499672250938601791858673096}
#define T_2048_221 {0.7788165123814759782661099052347708493471,-0.6272518154951440827460373839130625128746}
#define T_2048_223 {0.7749531065948739305682124722807202488184,-0.6320187359398090620743460021913051605225}
#define T_2048_225 {0.7710605242618138177590481063816696405411,-0.6367618612362841989948947230004705488682}
#define T_2048_227 {0.7671389119358204000675982570101041346788,-0.6414810128085831619770829092885833233595}
#define T_2048_229 {0.7631884172633812690733634553907904773951,-0.6461760129833163945889396018174011260271}
#define T_2048_231 {0.7592091889783880720443676182185299694538,-0.6508466849963808753543048624123912304640}
#define T_2048_233 {0.7552013768965365470009487580682616680861,-0.6554928529996153496739452748443000018597}
#define T_2048_235 {0.7511651319096863677060582631384022533894,-0.6601143420674204786990912907640449702740}
#define T_2048_237 {0.7471006059801801324482539712334983050823,-0.6647109782033449043581185833318158984184}
#define T_2048_239 {0.7430079521351217186619919630174990743399,-0.6692825883466361203133487833838444203138}
#define T_2048_241 {0.7388873244606151136082416996941901743412,-0.6738290003787560378256671356211882084608}
#define T_2048_243 {0.7347388780959634990708195800834801048040,-0.6783500431298614685715619998518377542496}
#define T_2048_245 {0.7305627692278275908677187544526532292366,-0.6828455463852480811226541845826432108879}
#define T_2048_247 {0.7263591550843460087349967579939402639866,-0.6873153408917591633553456631489098072052}
#define T_2048_249 {0.7221281939292153451148692511196713894606,-0.6917592583641577475006556596781592816114}
#define T_2048_251 {0.7178700450557317092048492668254766613245,-0.6961771314914629860126638050132896751165}
#define T_2048_253 {0.7135848687807936352456295026058796793222,-0.7005687939432483357649061872507445514202}
#define T_2048_255 {0.7092728264388656889138928818283602595329,-0.7049340803759048812437981723633129149675}
#define T_2048_257 {0.7049340803759048812437981723633129149675,-0.7092728264388656889138928818283602595329}
#define T_2048_259 {0.7005687939432483357649061872507445514202,-0.7135848687807936352456295026058796793222}
#define T_2048_261 {0.6961771314914629860126638050132896751165,-0.7178700450557317092048492668254766613245}
#define T_2048_263 {0.6917592583641577475006556596781592816114,-0.7221281939292153451148692511196713894606}
#define T_2048_265 {0.6873153408917591633553456631489098072052,-0.7263591550843460087349967579939402639866}
#define T_2048_267 {0.6828455463852480811226541845826432108879,-0.7305627692278275908677187544526532292366}
#define T_2048_269 {0.6783500431298614685715619998518377542496,-0.7347388780959634990708195800834801048040}
#define T_2048_271 {0.6738290003787560378256671356211882084608,-0.7388873244606151136082416996941901743412}
#define T_2048_273 {0.6692825883466361203133487833838444203138,-0.7430079521351217186619919630174990743399}
#define T_2048_275 {0.6647109782033449043581185833318158984184,-0.7471006059801801324482539712334983050823}
#define T_2048_277 {0.6601143420674204786990912907640449702740,-0.7511651319096863677060582631384022533894}
#define T_2048_279 {0.6554928529996153496739452748443000018597,-0.7552013768965365470009487580682616680861}
#define T_2048_281 {0.6508466849963808753543048624123912304640,-0.7592091889783880720443676182185299694538}
#define T_2048_283 {0.6461760129833163945889396018174011260271,-0.7631884172633812690733634553907904773951}
#define T_2048_285 {0.6414810128085831619770829092885833233595,-0.7671389119358204000675982570101041346788}
#define T_2048_287 {0.6367618612362841989948947230004705488682,-0.7710605242618138177590481063816696405411}
#define T_2048_289 {0.6320187359398090620743460021913051605225,-0.7749531065948739305682124722807202488184}
#define T_2048_291 {0.6272518154951440827460373839130625128746,-0.7788165123814759782661099052347708493471}
#define T_2048_293 {0.6224612793741499672250938601791858673096,-0.7826505961665757293843626030138693749905}
#define T_2048_295 {0.6176473079378039798825739126186817884445,-0.7864552135990857673064624577818904072046}
#define T_2048_297 {0.6128100824294097082045595925592351704836,-0.7902302214373100319733111973619088530540}
#define T_2048_299 {0.6079497849677736320828103089297655969858,-0.7939754775543371723145469331939239054918}
#define T_2048_301 {0.6030665985403481643700729364354629069567,-0.7976908409433911550934226397657766938210}
#define T_2048_303 {0.5981607069963422729230728691618423908949,-0.8013761717231402403882611906738020479679}
#define T_2048_305 {0.5932322950397997951554884821234736591578,-0.8050313311429635465543697137036360800266}
#define T_2048_307 {0.5882815482226453340786065382417291402817,-0.8086561815881749826218083398998714983463}
#define T_2048_309 {0.5833086529376982909411708533298224210739,-0.8122505865852038819951985715306363999844}
#define T_2048_311 {0.5783137964116555895799365316634066402912,-0.8158144108067337807455032816505990922451}
#define T_2048_313 {0.5732971666980422043025100720115005970001,-0.8193475200767970090254266324336640536785}
#define T_2048_315 {0.5682589526701316007262221319251693785191,-0.8228497813758263168537609999475535005331}
#define T_2048_317 {0.5631993440138340911715886250021867454052,-0.8263210628456635342686809053702745586634}
#define T_2048_319 {0.5581185312205561022125266390503384172916,-0.8297612337945230454039347023353911936283}
#define T_2048_321 {0.5530167055800275788257636122580152004957,-0.8331701647019131851124029708444140851498}
#define T_2048_323 {0.5478940591731001896746988677477929741144,-0.8365477272235120054233448172453790903091}
#define T_2048_325 {0.5427507848645158894385076564503833651543,-0.8398937941959995212570788680750411003828}
#define T_2048_327 {0.5375870762956455051195803207519929856062,-0.8432082396418454361963767951237969100475}
#define T_2048_329 {0.5324031278771980124631113540090154856443,-0.8464909387740521262699644466920290142298}
#define T_2048_331 {0.5271991347819013906672580560552887618542,-0.8497417680008524376589207349752541631460}
#define T_2048_333 {0.5219752929371543892500540096079930663109,-0.8529606049303636305936038297659251838923}
#define T_2048_335 {0.5167317990176498732068921526661142706871,-0.8561473283751944718389381705492269247770}
#define T_2048_337 {0.5114688504379704125923922219953965395689,-0.8593018183570083623479263223998714238405}
#define T_2048_339 {0.5061866453451553393705353300902061164379,-0.8624239561110405016819413503981195390224}
#define T_2048_341 {0.5008853826112408258453001508314628154039,-0.8655136240905690891977997125650290399790}
#define T_2048_343 {0.4955652618257725405825908637780230492353,-0.8685707059713408950685220588638912886381}
#define T_2048_345 {0.4902264832882911593792130133806494995952,-0.8715950866559510901154794737522024661303}
#define T_2048_347 {0.4848692480007911198569559019233565777540,-0.8745866522781761132065980746119748800993}
#define T_2048_349 {0.4794937576601530082598401349969208240509,-0.8775452902072612415551589037931989878416}
#define T_2048_351 {0.4741002146505500225437401695671724155545,-0.8804708890521607544954463264730293303728}
#define T_2048_353 {0.4686888220358279566468695520597975701094,-0.8833633386657315789136646344559267163277}
#define T_2048_355 {0.4632597835518602047422120904229814186692,-0.8862225301488806383787277809460647404194}
#define T_2048_357 {0.4578133035988772303603866475896211341023,-0.8890483558546645737052926961041521281004}
#define T_2048_359 {0.4523495872337708889610041751438984647393,-0.8918407093923427231274558835139032453299}
#define T_2048_361 {0.4468688401623742145751805310283089056611,-0.8945994856313826959492985224642325192690}
#define T_2048_363 {0.4413712687317166705192050812911475077271,-0.8973245807054183176276751510158646851778}
#define T_2048_365 {0.4358570799222554748020286297105485573411,-0.9000158920161602793541533173993229866028}
#define T_2048_367 {0.4303264813400826116485120564902899786830,-0.9026733182372588260022894246503710746765}
#define T_2048_369 {0.4247796812091088058949139849573839455843,-0.9052967593181188155071481560298707336187}
#define T_2048_371 {0.4192168883632239606562563949410105124116,-0.9078861164876662614986457811028230935335}
#define T_2048_373 {0.4136383122384345578659292641532374545932,-0.9104412922580672473671370426018256694078}
#define T_2048_375 {0.4080441628649786878213490126654505729675,-0.9129621904283982125605234614340588450432}
#define T_2048_377 {0.4024346508594184301799145941913593560457,-0.9154487160882678331574879848631098866463}
#define T_2048_379 {0.3968099874167103080502272405283292755485,-0.9179007756213904967168559778656344860792}
#define T_2048_381 {0.3911703843022538706897250904148677363992,-0.9203182767091105942469653200532775372267}
#define T_2048_383 {0.3855160538439188488979425528668798506260,-0.9227011283338785174734653082850854843855}
#define T_2048_385 {0.3798472089240511606611505612818291410804,-0.9250492407826775842494271273608319461346}
#define T_2048_387 {0.3741640629714579890929826433421112596989,-0.9273625256504011149516486511856783181429}
#define T_2048_389 {0.3684668299533723212491054255224298685789,-0.9296408958431812141753880496253259480000}
#define T_2048_391 {0.3627557243673972253716897284903097897768,-0.9318842655816681475045015758951194584370}
#define T_2048_393 {0.3570309612334300330971359471732284873724,-0.9340925504042588700670535217795986682177}
#define T_2048_395 {0.3512927560855671482720197218441171571612,-0.9362656671702782595900771411834284663200}
#define T_2048_397 {0.3455413249639890382880480501626152545214,-0.9384035340631080579498757288092747330666}
#define T_2048_399 {0.3397768844068268512259578528755810111761,-0.9405060705932682951768697421357501298189}
#define T_2048_401 {0.3339996514420093820518786742468364536762,-0.9425731976014468660451939285849221050739}
#define T_2048_403 {0.3282098435790925528010575362714007496834,-0.9446048372614802568492109458020422607660}
#define T_2048_405 {0.3224076788010698524367114714550552889705,-0.9466009130832835349877996122813783586025}
#define T_2048_407 {0.3165933755561658458077545219566673040390,-0.9485613499157302674902325634320732206106}
#define T_2048_409 {0.3107671527496114749489208861632505431771,-0.9504860739494817023498285379901062697172}
#define T_2048_411 {0.3049292297354024294797625316277844831347,-0.9523750127197658787991940698702819645405}
#define T_2048_413 {0.2990798263080404750802188118541380390525,-0.9542280951091056673263324228173587471247}
#define T_2048_415 {0.2932191626942586282211777870543301105499,-0.9560452513499964055654345429502427577972}
#define T_2048_417 {0.2873474595447295110162144737842027097940,-0.9578264130275329080177471041679382324219}
#define T_2048_419 {0.2814649379257579964175306486140470951796,-0.9595715130819845173348880962294060736895}
#define T_2048_421 {0.2755718193109581437560962058341829106212,-0.9612804858113206396552641308517195284367}
#define T_2048_423 {0.2696683255729150907598068442894145846367,-0.9629532668736838774137254404195118695498}
#define T_2048_425 {0.2637546789748314024492970020219217985868,-0.9645897932898127580259028945874888449907}
#define T_2048_427 {0.2578311021621589871344326638791244477034,-0.9661900034454125041349925595568493008614}
#define T_2048_429 {0.2518978181542169680895426608913112431765,-0.9677538370934755107555247377604246139526}
#define T_2048_431 {0.2459550503357946227289687612937996163964,-0.9692812353565485317119510000338777899742}
#define T_2048_433 {0.2400030224487414987066813409910537302494,-0.9707721407289503501303329358051996678114}
#define T_2048_435 {0.2340419585835434301834823145327391102910,-0.9722264970789362692471513582859188318253}
#define T_2048_437 {0.2280720831708857310182736455317353829741,-0.9736442496508119770481926025240682065487}
#define T_2048_439 {0.2220936209732035371278158208951936103404,-0.9750253450669941202022528159432113170624}
#define T_2048_441 {0.2161067970762195200595812138999463059008,-0.9763697313300211400033390418684575706720}
#define T_2048_443 {0.2101118368804696101559414955772808752954,-0.9776773578245099294292685954133048653603}
#define T_2048_445 {0.2041089660928168680875671725516440346837,-0.9789481753190621970972529197752010077238}
#define T_2048_447 {0.1980984107179535880227660982200177386403,-0.9801821359681174294919969725015107542276}
#define T_2048_449 {0.1920803970498924373444538105104584246874,-0.9813791933137545608900609295233152806759}
#define T_2048_451 {0.1860551516634466606703313118487130850554,-0.9825393022874412407574595818005036562681}
#define T_2048_453 {0.1800229014056995147097239851063932292163,-0.9836624192117302545312895745155401527882}
#define T_2048_455 {0.1739838733874638221355013456559390760958,-0.9847485018019042080084091139724478125572}
#define T_2048_457 {0.1679382949747311726262921638408442959189,-0.9857975091675674761404479795601218938828}
#define T_2048_459 {0.1618863937801118257908683517598547041416,-0.9868094018141855272574503032956272363663}
#define T_2048_461 {0.1558283976542652327079707674784003756940,-0.9877841416445721778316624295257497578859}
#define T_2048_463 {0.1497645346773215091484843242142233066261,-0.9887216919603237785807436921459157019854}
#define T_2048_465 {0.1436950331502944433470503327043843455613,-0.9896220174632008870219124219147488474846}
#define T_2048_467 {0.1376201215864860383231160767536493949592,-0.9904850842564570934101197963173035532236}
#define T_2048_469 {0.1315400287028831161073583189136115834117,-0.9913108598461154441494613820395898073912}
#define T_2048_471 {0.1254549834115462336736612769527710042894,-0.9920993131421917965440115949604660272598}
#define T_2048_473 {0.1193652148109913685436467289946449454874,-0.9928504144598651048880810776608996093273}
#define T_2048_475 {0.1132709521775643463081806316949950996786,-0.9935641355205953040297117695445194840431}
#define T_2048_477 {0.1071724249568088427331247203255770727992,-0.9942404494531879022289899694442283362150}
#define T_2048_479 {0.1010698627548278216714550126198446378112,-0.9948793307948056163780847782618366181850}
#define T_2048_481 {0.0949634953296390055266229524022492114455,-0.9954807554919269385607094591250643134117}
#define T_2048_483 {0.0888535525825246003117641180324426386505,-0.9960447009012519670179131026088725775480}
#define T_2048_485 {0.0827402645493756916383887300980859436095,-0.9965711457905548353863878219272010028362}
#define T_2048_487 {0.0766238613920314920457954599442018661648,-0.9970600703394829622538964031264185905457}
#define T_2048_489 {0.0705045733896138698826305812872305978090,-0.9975114561403034540987277978274505585432}
#define T_2048_491 {0.0643826309298574650519242368318373337388,-0.9979252861985959954793656834226567298174}
#define T_2048_493 {0.0582582645004357593809807269735756563023,-0.9983015449338928926081848658213857561350}
#define T_2048_495 {0.0521317046802833236607277456187148345634,-0.9986402181802652711084533621033187955618}
#define T_2048_497 {0.0460031821309146299325831819260201882571,-0.9989412931868568712445721757831051945686}
#define T_2048_499 {0.0398729275877398106620042028680472867563,-0.9992047586183638863133182894671335816383}
#define T_2048_501 {0.0337411718513775868433235416432580677792,-0.9994306045554617323745105750276707112789}
#define T_2048_503 {0.0276081457789657432055907548829054576345,-0.9996188224951786382987961587787140160799}
#define T_2048_505 {0.0214740802754695078724544998749479418620,-0.9997694053512152789764400040439795702696}
#define T_2048_507 {0.0153392062849881018887776562564795312937,-0.9998823474542125611108644989144522696733}
#define T_2048_509 {0.0092037547820598194364682953505507612135,-0.9999576445519638978609577861789148300886}
#define T_2048_511 {0.0030679567629659761432425746363605867373,-0.9999952938095761911796444110223092138767}
#define T_2048_513 {-0.0030679567629659761432425746363605867373,-0.9999952938095761911796444110223092138767}
#define T_2048_515 {-0.0092037547820598194364682953505507612135,-0.9999576445519638978609577861789148300886}
#define T_2048_517 {-0.0153392062849881018887776562564795312937,-0.9998823474542125611108644989144522696733}
#define T_2048_519 {-0.0214740802754695078724544998749479418620,-0.9997694053512152789764400040439795702696}
#define T_2048_521 {-0.0276081457789657432055907548829054576345,-0.9996188224951786382987961587787140160799}
#define T_2048_523 {-0.0337411718513775868433235416432580677792,-0.9994306045554617323745105750276707112789}
#define T_2048_525 {-0.0398729275877398106620042028680472867563,-0.9992047586183638863133182894671335816383}
#define T_2048_527 {-0.0460031821309146299325831819260201882571,-0.9989412931868568712445721757831051945686}
#define T_2048_529 {-0.0521317046802833236607277456187148345634,-0.9986402181802652711084533621033187955618}
#define T_2048_531 {-0.0582582645004357593809807269735756563023,-0.9983015449338928926081848658213857561350}
#define T_2048_533 {-0.0643826309298574650519242368318373337388,-0.9979252861985959954793656834226567298174}
#define T_2048_535 {-0.0705045733896138698826305812872305978090,-0.9975114561403034540987277978274505585432}
#define T_2048_537 {-0.0766238613920314920457954599442018661648,-0.9970600703394829622538964031264185905457}
#define T_2048_539 {-0.0827402645493756916383887300980859436095,-0.9965711457905548353863878219272010028362}
#define T_2048_541 {-0.0888535525825246003117641180324426386505,-0.9960447009012519670179131026088725775480}
#define T_2048_543 {-0.0949634953296390055266229524022492114455,-0.9954807554919269385607094591250643134117}
#define T_2048_545 {-0.1010698627548278216714550126198446378112,-0.9948793307948056163780847782618366181850}
#define T_2048_547 {-0.1071724249568088427331247203255770727992,-0.9942404494531879022289899694442283362150}
#define T_2048_549 {-0.1132709521775643463081806316949950996786,-0.9935641355205953040297117695445194840431}
#define T_2048_551 {-0.1193652148109913685436467289946449454874,-0.9928504144598651048880810776608996093273}
#define T_2048_553 {-0.1254549834115462336736612769527710042894,-0.9920993131421917965440115949604660272598}
#define T_2048_555 {-0.1315400287028831161073583189136115834117,-0.9913108598461154441494613820395898073912}
#define T_2048_557 {-0.1376201215864860383231160767536493949592,-0.9904850842564570934101197963173035532236}
#define T_2048_559 {-0.1436950331502944433470503327043843455613,-0.9896220174632008870219124219147488474846}
#define T_2048_561 {-0.1497645346773215091484843242142233066261,-0.9887216919603237785807436921459157019854}
#define T_2048_563 {-0.1558283976542652327079707674784003756940,-0.9877841416445721778316624295257497578859}
#define T_2048_565 {-0.1618863937801118257908683517598547041416,-0.9868094018141855272574503032956272363663}
#define T_2048_567 {-0.1679382949747311726262921638408442959189,-0.9857975091675674761404479795601218938828}
#define T_2048_569 {-0.1739838733874638221355013456559390760958,-0.9847485018019042080084091139724478125572}
#define T_2048_571 {-0.1800229014056995147097239851063932292163,-0.9836624192117302545312895745155401527882}
#define T_2048_573 {-0.1860551516634466606703313118487130850554,-0.9825393022874412407574595818005036562681}
#define T_2048_575 {-0.1920803970498924373444538105104584246874,-0.9813791933137545608900609295233152806759}
#define T_2048_577 {-0.1980984107179535880227660982200177386403,-0.9801821359681174294919969725015107542276}
#define T_2048_579 {-0.2041089660928168680875671725516440346837,-0.9789481753190621970972529197752010077238}
#define T_2048_581 {-0.2101118368804696101559414955772808752954,-0.9776773578245099294292685954133048653603}
#define T_2048_583 {-0.2161067970762195200595812138999463059008,-0.9763697313300211400033390418684575706720}
#define T_2048_585 {-0.2220936209732035371278158208951936103404,-0.9750253450669941202022528159432113170624}
#define T_2048_587 {-0.2280720831708857310182736455317353829741,-0.9736442496508119770481926025240682065487}
#define T_2048_589 {-0.2340419585835434301834823145327391102910,-0.9722264970789362692471513582859188318253}
#define T_2048_591 {-0.2400030224487414987066813409910537302494,-0.9707721407289503501303329358051996678114}
#define T_2048_593 {-0.2459550503357946227289687612937996163964,-0.9692812353565485317119510000338777899742}
#define T_2048_595 {-0.2518978181542169680895426608913112431765,-0.9677538370934755107555247377604246139526}
#define T_2048_597 {-0.2578311021621589871344326638791244477034,-0.9661900034454125041349925595568493008614}
#define T_2048_599 {-0.2637546789748314024492970020219217985868,-0.9645897932898127580259028945874888449907}
#define T_2048_601 {-0.2696683255729150907598068442894145846367,-0.9629532668736838774137254404195118695498}
#define T_2048_603 {-0.2755718193109581437560962058341829106212,-0.9612804858113206396552641308517195284367}
#define T_2048_605 {-0.2814649379257579964175306486140470951796,-0.9595715130819845173348880962294060736895}
#define T_2048_607 {-0.2873474595447295110162144737842027097940,-0.9578264130275329080177471041679382324219}
#define T_2048_609 {-0.2932191626942586282211777870543301105499,-0.9560452513499964055654345429502427577972}
#define T_2048_611 {-0.2990798263080404750802188118541380390525,-0.9542280951091056673263324228173587471247}
#define T_2048_613 {-0.3049292297354024294797625316277844831347,-0.9523750127197658787991940698702819645405}
#define T_2048_615 {-0.3107671527496114749489208861632505431771,-0.9504860739494817023498285379901062697172}
#define T_2048_617 {-0.3165933755561658458077545219566673040390,-0.9485613499157302674902325634320732206106}
#define T_2048_619 {-0.3224076788010698524367114714550552889705,-0.9466009130832835349877996122813783586025}
#define T_2048_621 {-0.3282098435790925528010575362714007496834,-0.9446048372614802568492109458020422607660}
#define T_2048_623 {-0.3339996514420093820518786742468364536762,-0.9425731976014468660451939285849221050739}
#define T_2048_625 {-0.3397768844068268512259578528755810111761,-0.9405060705932682951768697421357501298189}
#define T_2048_627 {-0.3455413249639890382880480501626152545214,-0.9384035340631080579498757288092747330666}
#define T_2048_629 {-0.3512927560855671482720197218441171571612,-0.9362656671702782595900771411834284663200}
#define T_2048_631 {-0.3570309612334300330971359471732284873724,-0.9340925504042588700670535217795986682177}
#define T_2048_633 {-0.3627557243673972253716897284903097897768,-0.9318842655816681475045015758951194584370}
#define T_2048_635 {-0.3684668299533723212491054255224298685789,-0.9296408958431812141753880496253259480000}
#define T_2048_637 {-0.3741640629714579890929826433421112596989,-0.9273625256504011149516486511856783181429}
#define T_2048_639 {-0.3798472089240511606611505612818291410804,-0.9250492407826775842494271273608319461346}
#define T_2048_641 {-0.3855160538439188488979425528668798506260,-0.9227011283338785174734653082850854843855}
#define T_2048_643 {-0.3911703843022538706897250904148677363992,-0.9203182767091105942469653200532775372267}
#define T_2048_645 {-0.3968099874167103080502272405283292755485,-0.9179007756213904967168559778656344860792}
#define T_2048_647 {-0.4024346508594184301799145941913593560457,-0.9154487160882678331574879848631098866463}
#define T_2048_649 {-0.4080441628649786878213490126654505729675,-0.9129621904283982125605234614340588450432}
#define T_2048_651 {-0.4136383122384345578659292641532374545932,-0.9104412922580672473671370426018256694078}
#define T_2048_653 {-0.4192168883632239606562563949410105124116,-0.9078861164876662614986457811028230935335}
#define T_2048_655 {-0.4247796812091088058949139849573839455843,-0.9052967593181188155071481560298707336187}
#define T_2048_657 {-0.4303264813400826116485120564902899786830,-0.9026733182372588260022894246503710746765}
#define T_2048_659 {-0.4358570799222554748020286297105485573411,-0.9000158920161602793541533173993229866028}
#define T_2048_661 {-0.4413712687317166705192050812911475077271,-0.8973245807054183176276751510158646851778}
#define T_2048_663 {-0.4468688401623742145751805310283089056611,-0.8945994856313826959492985224642325192690}
#define T_2048_665 {-0.4523495872337708889610041751438984647393,-0.8918407093923427231274558835139032453299}
#define T_2048_667 {-0.4578133035988772303603866475896211341023,-0.8890483558546645737052926961041521281004}
#define T_2048_669 {-0.4632597835518602047422120904229814186692,-0.8862225301488806383787277809460647404194}
#define T_2048_671 {-0.4686888220358279566468695520597975701094,-0.8833633386657315789136646344559267163277}
#define T_2048_673 {-0.4741002146505500225437401695671724155545,-0.8804708890521607544954463264730293303728}
#define T_2048_675 {-0.4794937576601530082598401349969208240509,-0.8775452902072612415551589037931989878416}
#define T_2048_677 {-0.4848692480007911198569559019233565777540,-0.8745866522781761132065980746119748800993}
#define T_2048_679 {-0.4902264832882911593792130133806494995952,-0.8715950866559510901154794737522024661303}
#define T_2048_681 {-0.4955652618257725405825908637780230492353,-0.8685707059713408950685220588638912886381}
#define T_2048_683 {-0.5008853826112408258453001508314628154039,-0.8655136240905690891977997125650290399790}
#define T_2048_685 {-0.5061866453451553393705353300902061164379,-0.8624239561110405016819413503981195390224}
#define T_2048_687 {-0.5114688504379704125923922219953965395689,-0.8593018183570083623479263223998714238405}
#define T_2048_689 {-0.5167317990176498732068921526661142706871,-0.8561473283751944718389381705492269247770}
#define T_2048_691 {-0.5219752929371543892500540096079930663109,-0.8529606049303636305936038297659251838923}
#define T_2048_693 {-0.5271991347819013906672580560552887618542,-0.8497417680008524376589207349752541631460}
#define T_2048_695 {-0.5324031278771980124631113540090154856443,-0.8464909387740521262699644466920290142298}
#define T_2048_697 {-0.5375870762956455051195803207519929856062,-0.8432082396418454361963767951237969100475}
#define T_2048_699 {-0.5427507848645158894385076564503833651543,-0.8398937941959995212570788680750411003828}
#define T_2048_701 {-0.5478940591731001896746988677477929741144,-0.8365477272235120054233448172453790903091}
#define T_2048_703 {-0.5530167055800275788257636122580152004957,-0.8331701647019131851124029708444140851498}
#define T_2048_705 {-0.5581185312205561022125266390503384172916,-0.8297612337945230454039347023353911936283}
#define T_2048_707 {-0.5631993440138340911715886250021867454052,-0.8263210628456635342686809053702745586634}
#define T_2048_709 {-0.5682589526701316007262221319251693785191,-0.8228497813758263168537609999475535005331}
#define T_2048_711 {-0.5732971666980422043025100720115005970001,-0.8193475200767970090254266324336640536785}
#define T_2048_713 {-0.5783137964116555895799365316634066402912,-0.8158144108067337807455032816505990922451}
#define T_2048_715 {-0.5833086529376982909411708533298224210739,-0.8122505865852038819951985715306363999844}
#define T_2048_717 {-0.5882815482226453340786065382417291402817,-0.8086561815881749826218083398998714983463}
#define T_2048_719 {-0.5932322950397997951554884821234736591578,-0.8050313311429635465543697137036360800266}
#define T_2048_721 {-0.5981607069963422729230728691618423908949,-0.8013761717231402403882611906738020479679}
#define T_2048_723 {-0.6030665985403481643700729364354629069567,-0.7976908409433911550934226397657766938210}
#define T_2048_725 {-0.6079497849677736320828103089297655969858,-0.7939754775543371723145469331939239054918}
#define T_2048_727 {-0.6128100824294097082045595925592351704836,-0.7902302214373100319733111973619088530540}
#define T_2048_729 {-0.6176473079378039798825739126186817884445,-0.7864552135990857673064624577818904072046}
#define T_2048_731 {-0.6224612793741499672250938601791858673096,-0.7826505961665757293843626030138693749905}
#define T_2048_733 {-0.6272518154951440827460373839130625128746,-0.7788165123814759782661099052347708493471}
#define T_2048_735 {-0.6320187359398090620743460021913051605225,-0.7749531065948739305682124722807202488184}
#define T_2048_737 {-0.6367618612362841989948947230004705488682,-0.7710605242618138177590481063816696405411}
#define T_2048_739 {-0.6414810128085831619770829092885833233595,-0.7671389119358204000675982570101041346788}
#define T_2048_741 {-0.6461760129833163945889396018174011260271,-0.7631884172633812690733634553907904773951}
#define T_2048_743 {-0.6508466849963808753543048624123912304640,-0.7592091889783880720443676182185299694538}
#define T_2048_745 {-0.6554928529996153496739452748443000018597,-0.7552013768965365470009487580682616680861}
#define T_2048_747 {-0.6601143420674204786990912907640449702740,-0.7511651319096863677060582631384022533894}
#define T_2048_749 {-0.6647109782033449043581185833318158984184,-0.7471006059801801324482539712334983050823}
#define T_2048_751 {-0.6692825883466361203133487833838444203138,-0.7430079521351217186619919630174990743399}
#define T_2048_753 {-0.6738290003787560378256671356211882084608,-0.7388873244606151136082416996941901743412}
#define T_2048_755 {-0.6783500431298614685715619998518377542496,-0.7347388780959634990708195800834801048040}
#define T_2048_757 {-0.6828455463852480811226541845826432108879,-0.7305627692278275908677187544526532292366}
#define T_2048_759 {-0.6873153408917591633553456631489098072052,-0.7263591550843460087349967579939402639866}
#define T_2048_761 {-0.6917592583641577475006556596781592816114,-0.7221281939292153451148692511196713894606}
#define T_2048_763 {-0.6961771314914629860126638050132896751165,-0.7178700450557317092048492668254766613245}
#define T_2048_765 {-0.7005687939432483357649061872507445514202,-0.7135848687807936352456295026058796793222}
#define T_2048_767 {-0.7049340803759048812437981723633129149675,-0.7092728264388656889138928818283602595329}
#define T_2048_769 {-0.7092728264388656889138928818283602595329,-0.7049340803759048812437981723633129149675}
#define T_2048_771 {-0.7135848687807936352456295026058796793222,-0.7005687939432483357649061872507445514202}
#define T_2048_773 {-0.7178700450557317092048492668254766613245,-0.6961771314914629860126638050132896751165}
#define T_2048_775 {-0.7221281939292153451148692511196713894606,-0.6917592583641577475006556596781592816114}
#define T_2048_777 {-0.7263591550843460087349967579939402639866,-0.6873153408917591633553456631489098072052}
#define T_2048_779 {-0.7305627692278275908677187544526532292366,-0.6828455463852480811226541845826432108879}
#define T_2048_781 {-0.7347388780959634990708195800834801048040,-0.6783500431298614685715619998518377542496}
#define T_2048_783 {-0.7388873244606151136082416996941901743412,-0.6738290003787560378256671356211882084608}
#define T_2048_785 {-0.7430079521351217186619919630174990743399,-0.6692825883466361203133487833838444203138}
#define T_2048_787 {-0.7471006059801801324482539712334983050823,-0.6647109782033449043581185833318158984184}
#define T_2048_789 {-0.7511651319096863677060582631384022533894,-0.6601143420674204786990912907640449702740}
#define T_2048_791 {-0.7552013768965365470009487580682616680861,-0.6554928529996153496739452748443000018597}
#define T_2048_793 {-0.7592091889783880720443676182185299694538,-0.6508466849963808753543048624123912304640}
#define T_2048_795 {-0.7631884172633812690733634553907904773951,-0.6461760129833163945889396018174011260271}
#define T_2048_797 {-0.7671389119358204000675982570101041346788,-0.6414810128085831619770829092885833233595}
#define T_2048_799 {-0.7710605242618138177590481063816696405411,-0.6367618612362841989948947230004705488682}
#define T_2048_801 {-0.7749531065948739305682124722807202488184,-0.6320187359398090620743460021913051605225}
#define T_2048_803 {-0.7788165123814759782661099052347708493471,-0.6272518154951440827460373839130625128746}
#define T_2048_805 {-0.7826505961665757293843626030138693749905,-0.6224612793741499672250938601791858673096}
#define T_2048_807 {-0.7864552135990857673064624577818904072046,-0.6176473079378039798825739126186817884445}
#define T_2048_809 {-0.7902302214373100319733111973619088530540,-0.6128100824294097082045595925592351704836}
#define T_2048_811 {-0.7939754775543371723145469331939239054918,-0.6079497849677736320828103089297655969858}
#define T_2048_813 {-0.7976908409433911550934226397657766938210,-0.6030665985403481643700729364354629069567}
#define T_2048_815 {-0.8013761717231402403882611906738020479679,-0.5981607069963422729230728691618423908949}
#define T_2048_817 {-0.8050313311429635465543697137036360800266,-0.5932322950397997951554884821234736591578}
#define T_2048_819 {-0.8086561815881749826218083398998714983463,-0.5882815482226453340786065382417291402817}
#define T_2048_821 {-0.8122505865852038819951985715306363999844,-0.5833086529376982909411708533298224210739}
#define T_2048_823 {-0.8158144108067337807455032816505990922451,-0.5783137964116555895799365316634066402912}
#define T_2048_825 {-0.8193475200767970090254266324336640536785,-0.5732971666980422043025100720115005970001}
#define T_2048_827 {-0.8228497813758263168537609999475535005331,-0.5682589526701316007262221319251693785191}
#define T_2048_829 {-0.8263210628456635342686809053702745586634,-0.5631993440138340911715886250021867454052}
#define T_2048_831 {-0.8297612337945230454039347023353911936283,-0.5581185312205561022125266390503384172916}
#define T_2048_833 {-0.8331701647019131851124029708444140851498,-0.5530167055800275788257636122580152004957}
#define T_2048_835 {-0.8365477272235120054233448172453790903091,-0.5478940591731001896746988677477929741144}
#define T_2048_837 {-0.8398937941959995212570788680750411003828,-0.5427507848645158894385076564503833651543}
#define T_2048_839 {-0.8432082396418454361963767951237969100475,-0.5375870762956455051195803207519929856062}
#define T_2048_841 {-0.8464909387740521262699644466920290142298,-0.5324031278771980124631113540090154856443}
#define T_2048_843 {-0.8497417680008524376589207349752541631460,-0.5271991347819013906672580560552887618542}
#define T_2048_845 {-0.8529606049303636305936038297659251838923,-0.5219752929371543892500540096079930663109}
#define T_2048_847 {-0.8561473283751944718389381705492269247770,-0.5167317990176498732068921526661142706871}
#define T_2048_849 {-0.8593018183570083623479263223998714238405,-0.5114688504379704125923922219953965395689}
#define T_2048_851 {-0.8624239561110405016819413503981195390224,-0.5061866453451553393705353300902061164379}
#define T_2048_853 {-0.8655136240905690891977997125650290399790,-0.5008853826112408258453001508314628154039}
#define T_2048_855 {-0.8685707059713408950685220588638912886381,-0.4955652618257725405825908637780230492353}
#define T_2048_857 {-0.8715950866559510901154794737522024661303,-0.4902264832882911593792130133806494995952}
#define T_2048_859 {-0.8745866522781761132065980746119748800993,-0.4848692480007911198569559019233565777540}
#define T_2048_861 {-0.8775452902072612415551589037931989878416,-0.4794937576601530082598401349969208240509}
#define T_2048_863 {-0.8804708890521607544954463264730293303728,-0.4741002146505500225437401695671724155545}
#define T_2048_865 {-0.8833633386657315789136646344559267163277,-0.4686888220358279566468695520597975701094}
#define T_2048_867 {-0.8862225301488806383787277809460647404194,-0.4632597835518602047422120904229814186692}
#define T_2048_869 {-0.8890483558546645737052926961041521281004,-0.4578133035988772303603866475896211341023}
#define T_2048_871 {-0.8918407093923427231274558835139032453299,-0.4523495872337708889610041751438984647393}
#define T_2048_873 {-0.8945994856313826959492985224642325192690,-0.4468688401623742145751805310283089056611}
#define T_2048_875 {-0.8973245807054183176276751510158646851778,-0.4413712687317166705192050812911475077271}
#define T_2048_877 {-0.9000158920161602793541533173993229866028,-0.4358570799222554748020286297105485573411}
#define T_2048_879 {-0.9026733182372588260022894246503710746765,-0.4303264813400826116485120564902899786830}
#define T_2048_881 {-0.9052967593181188155071481560298707336187,-0.4247796812091088058949139849573839455843}
#define T_2048_883 {-0.9078861164876662614986457811028230935335,-0.4192168883632239606562563949410105124116}
#define T_2048_885 {-0.9104412922580672473671370426018256694078,-0.4136383122384345578659292641532374545932}
#define T_2048_887 {-0.9129621904283982125605234614340588450432,-0.4080441628649786878213490126654505729675}
#define T_2048_889 {-0.9154487160882678331574879848631098866463,-0.4024346508594184301799145941913593560457}
#define T_2048_891 {-0.9179007756213904967168559778656344860792,-0.3968099874167103080502272405283292755485}
#define T_2048_893 {-0.9203182767091105942469653200532775372267,-0.3911703843022538706897250904148677363992}
#define T_2048_895 {-0.9227011283338785174734653082850854843855,-0.3855160538439188488979425528668798506260}
#define T_2048_897 {-0.9250492407826775842494271273608319461346,-0.3798472089240511606611505612818291410804}
#define T_2048_899 {-0.9273625256504011149516486511856783181429,-0.3741640629714579890929826433421112596989}
#define T_2048_901 {-0.9296408958431812141753880496253259480000,-0.3684668299533723212491054255224298685789}
#define T_2048_903 {-0.9318842655816681475045015758951194584370,-0.3627557243673972253716897284903097897768}
#define T_2048_905 {-0.9340925504042588700670535217795986682177,-0.3570309612334300330971359471732284873724}
#define T_2048_907 {-0.9362656671702782595900771411834284663200,-0.3512927560855671482720197218441171571612}
#define T_2048_909 {-0.9384035340631080579498757288092747330666,-0.3455413249639890382880480501626152545214}
#define T_2048_911 {-0.9405060705932682951768697421357501298189,-0.3397768844068268512259578528755810111761}
#define T_2048_913 {-0.9425731976014468660451939285849221050739,-0.3339996514420093820518786742468364536762}
#define T_2048_915 {-0.9446048372614802568492109458020422607660,-0.3282098435790925528010575362714007496834}
#define T_2048_917 {-0.9466009130832835349877996122813783586025,-0.3224076788010698524367114714550552889705}
#define T_2048_919 {-0.9485613499157302674902325634320732206106,-0.3165933755561658458077545219566673040390}
#define T_2048_921 {-0.9504860739494817023498285379901062697172,-0.3107671527496114749489208861632505431771}
#define T_2048_923 {-0.9523750127197658787991940698702819645405,-0.3049292297354024294797625316277844831347}
#define T_2048_925 {-0.9542280951091056673263324228173587471247,-0.2990798263080404750802188118541380390525}
#define T_2048_927 {-0.9560452513499964055654345429502427577972,-0.2932191626942586282211777870543301105499}
#define T_2048_929 {-0.9578264130275329080177471041679382324219,-0.2873474595447295110162144737842027097940}
#define T_2048_931 {-0.9595715130819845173348880962294060736895,-0.2814649379257579964175306486140470951796}
#define T_2048_933 {-0.9612804858113206396552641308517195284367,-0.2755718193109581437560962058341829106212}
#define T_2048_935 {-0.9629532668736838774137254404195118695498,-0.2696683255729150907598068442894145846367}
#define T_2048_937 {-0.9645897932898127580259028945874888449907,-0.2637546789748314024492970020219217985868}
#define T_2048_939 {-0.9661900034454125041349925595568493008614,-0.2578311021621589871344326638791244477034}
#define T_2048_941 {-0.9677538370934755107555247377604246139526,-0.2518978181542169680895426608913112431765}
#define T_2048_943 {-0.9692812353565485317119510000338777899742,-0.2459550503357946227289687612937996163964}
#define T_2048_945 {-0.9707721407289503501303329358051996678114,-0.2400030224487414987066813409910537302494}
#define T_2048_947 {-0.9722264970789362692471513582859188318253,-0.2340419585835434301834823145327391102910}
#define T_2048_949 {-0.9736442496508119770481926025240682065487,-0.2280720831708857310182736455317353829741}
#define T_2048_951 {-0.9750253450669941202022528159432113170624,-0.2220936209732035371278158208951936103404}
#define T_2048_953 {-0.9763697313300211400033390418684575706720,-0.2161067970762195200595812138999463059008}
#define T_2048_955 {-0.9776773578245099294292685954133048653603,-0.2101118368804696101559414955772808752954}
#define T_2048_957 {-0.9789481753190621970972529197752010077238,-0.2041089660928168680875671725516440346837}
#define T_2048_959 {-0.9801821359681174294919969725015107542276,-0.1980984107179535880227660982200177386403}
#define T_2048_961 {-0.9813791933137545608900609295233152806759,-0.1920803970498924373444538105104584246874}
#define T_2048_963 {-0.9825393022874412407574595818005036562681,-0.1860551516634466606703313118487130850554}
#define T_2048_965 {-0.9836624192117302545312895745155401527882,-0.1800229014056995147097239851063932292163}
#define T_2048_967 {-0.9847485018019042080084091139724478125572,-0.1739838733874638221355013456559390760958}
#define T_2048_969 {-0.9857975091675674761404479795601218938828,-0.1679382949747311726262921638408442959189}
#define T_2048_971 {-0.9868094018141855272574503032956272363663,-0.1618863937801118257908683517598547041416}
#define T_2048_973 {-0.9877841416445721778316624295257497578859,-0.1558283976542652327079707674784003756940}
#define T_2048_975 {-0.9887216919603237785807436921459157019854,-0.1497645346773215091484843242142233066261}
#define T_2048_977 {-0.9896220174632008870219124219147488474846,-0.1436950331502944433470503327043843455613}
#define T_2048_979 {-0.9904850842564570934101197963173035532236,-0.1376201215864860383231160767536493949592}
#define T_2048_981 {-0.9913108598461154441494613820395898073912,-0.1315400287028831161073583189136115834117}
#define T_2048_983 {-0.9920993131421917965440115949604660272598,-0.1254549834115462336736612769527710042894}
#define T_2048_985 {-0.9928504144598651048880810776608996093273,-0.1193652148109913685436467289946449454874}
#define T_2048_987 {-0.9935641355205953040297117695445194840431,-0.1132709521775643463081806316949950996786}
#define T_2048_989 {-0.9942404494531879022289899694442283362150,-0.1071724249568088427331247203255770727992}
#define T_2048_991 {-0.9948793307948056163780847782618366181850,-0.1010698627548278216714550126198446378112}
#define T_2048_993 {-0.9954807554919269385607094591250643134117,-0.0949634953296390055266229524022492114455}
#define T_2048_995 {-0.9960447009012519670179131026088725775480,-0.0888535525825246003117641180324426386505}
#define T_2048_997 {-0.9965711457905548353863878219272010028362,-0.0827402645493756916383887300980859436095}
#define T_2048_999 {-0.9970600703394829622538964031264185905457,-0.0766238613920314920457954599442018661648}
#define T_2048_1001 {-0.9975114561403034540987277978274505585432,-0.0705045733896138698826305812872305978090}
#define T_2048_1003 {-0.9979252861985959954793656834226567298174,-0.0643826309298574650519242368318373337388}
#define T_2048_1005 {-0.9983015449338928926081848658213857561350,-0.0582582645004357593809807269735756563023}
#define T_2048_1007 {-0.9986402181802652711084533621033187955618,-0.0521317046802833236607277456187148345634}
#define T_2048_1009 {-0.9989412931868568712445721757831051945686,-0.0460031821309146299325831819260201882571}
#define T_2048_1011 {-0.9992047586183638863133182894671335816383,-0.0398729275877398106620042028680472867563}
#define T_2048_1013 {-0.9994306045554617323745105750276707112789,-0.0337411718513775868433235416432580677792}
#define T_2048_1015 {-0.9996188224951786382987961587787140160799,-0.0276081457789657432055907548829054576345}
#define T_2048_1017 {-0.9997694053512152789764400040439795702696,-0.0214740802754695078724544998749479418620}
#define T_2048_1019 {-0.9998823474542125611108644989144522696733,-0.0153392062849881018887776562564795312937}
#define T_2048_1021 {-0.9999576445519638978609577861789148300886,-0.0092037547820598194364682953505507612135}
#define T_2048_1023 {-0.9999952938095761911796444110223092138767,-0.0030679567629659761432425746363605867373}
#define T_2048_1025 {-0.9999952938095761911796444110223092138767,0.0030679567629659761432425746363605867373}
#define T_2048_1029 {-0.9998823474542125611108644989144522696733,0.0153392062849881018887776562564795312937}
#define T_2048_1035 {-0.9994306045554617323745105750276707112789,0.0337411718513775868433235416432580677792}
#define T_2048_1037 {-0.9992047586183638863133182894671335816383,0.0398729275877398106620042028680472867563}
#define T_2048_1041 {-0.9986402181802652711084533621033187955618,0.0521317046802833236607277456187148345634}
#define T_2048_1045 {-0.9979252861985959954793656834226567298174,0.0643826309298574650519242368318373337388}
#define T_2048_1047 {-0.9975114561403034540987277978274505585432,0.0705045733896138698826305812872305978090}
#define T_2048_1053 {-0.9960447009012519670179131026088725775480,0.0888535525825246003117641180324426386505}
#define T_2048_1055 {-0.9954807554919269385607094591250643134117,0.0949634953296390055266229524022492114455}
#define T_2048_1059 {-0.9942404494531879022289899694442283362150,0.1071724249568088427331247203255770727992}
#define T_2048_1065 {-0.9920993131421917965440115949604660272598,0.1254549834115462336736612769527710042894}
#define T_2048_1071 {-0.9896220174632008870219124219147488474846,0.1436950331502944433470503327043843455613}
#define T_2048_1075 {-0.9877841416445721778316624295257497578859,0.1558283976542652327079707674784003756940}
#define T_2048_1077 {-0.9868094018141855272574503032956272363663,0.1618863937801118257908683517598547041416}
#define T_2048_1083 {-0.9836624192117302545312895745155401527882,0.1800229014056995147097239851063932292163}
#define T_2048_1085 {-0.9825393022874412407574595818005036562681,0.1860551516634466606703313118487130850554}
#define T_2048_1089 {-0.9801821359681174294919969725015107542276,0.1980984107179535880227660982200177386403}
#define T_2048_1095 {-0.9763697313300211400033390418684575706720,0.2161067970762195200595812138999463059008}
#define T_2048_1101 {-0.9722264970789362692471513582859188318253,0.2340419585835434301834823145327391102910}
#define T_2048_1105 {-0.9692812353565485317119510000338777899742,0.2459550503357946227289687612937996163964}
#define T_2048_1107 {-0.9677538370934755107555247377604246139526,0.2518978181542169680895426608913112431765}
#define T_2048_1113 {-0.9629532668736838774137254404195118695498,0.2696683255729150907598068442894145846367}
#define T_2048_1115 {-0.9612804858113206396552641308517195284367,0.2755718193109581437560962058341829106212}
#define T_2048_1119 {-0.9578264130275329080177471041679382324219,0.2873474595447295110162144737842027097940}
#define T_2048_1125 {-0.9523750127197658787991940698702819645405,0.3049292297354024294797625316277844831347}
#define T_2048_1131 {-0.9466009130832835349877996122813783586025,0.3224076788010698524367114714550552889705}
#define T_2048_1135 {-0.9425731976014468660451939285849221050739,0.3339996514420093820518786742468364536762}
#define T_2048_1137 {-0.9405060705932682951768697421357501298189,0.3397768844068268512259578528755810111761}
#define T_2048_1143 {-0.9340925504042588700670535217795986682177,0.3570309612334300330971359471732284873724}
#define T_2048_1145 {-0.9318842655816681475045015758951194584370,0.3627557243673972253716897284903097897768}
#define T_2048_1149 {-0.9273625256504011149516486511856783181429,0.3741640629714579890929826433421112596989}
#define T_2048_1155 {-0.9203182767091105942469653200532775372267,0.3911703843022538706897250904148677363992}
#define T_2048_1161 {-0.9129621904283982125605234614340588450432,0.4080441628649786878213490126654505729675}
#define T_2048_1165 {-0.9078861164876662614986457811028230935335,0.4192168883632239606562563949410105124116}
#define T_2048_1167 {-0.9052967593181188155071481560298707336187,0.4247796812091088058949139849573839455843}
#define T_2048_1173 {-0.8973245807054183176276751510158646851778,0.4413712687317166705192050812911475077271}
#define T_2048_1175 {-0.8945994856313826959492985224642325192690,0.4468688401623742145751805310283089056611}
#define T_2048_1179 {-0.8890483558546645737052926961041521281004,0.4578133035988772303603866475896211341023}
#define T_2048_1185 {-0.8804708890521607544954463264730293303728,0.4741002146505500225437401695671724155545}
#define T_2048_1191 {-0.8715950866559510901154794737522024661303,0.4902264832882911593792130133806494995952}
#define T_2048_1195 {-0.8655136240905690891977997125650290399790,0.5008853826112408258453001508314628154039}
#define T_2048_1197 {-0.8624239561110405016819413503981195390224,0.5061866453451553393705353300902061164379}
#define T_2048_1203 {-0.8529606049303636305936038297659251838923,0.5219752929371543892500540096079930663109}
#define T_2048_1205 {-0.8497417680008524376589207349752541631460,0.5271991347819013906672580560552887618542}
#define T_2048_1209 {-0.8432082396418454361963767951237969100475,0.5375870762956455051195803207519929856062}
#define T_2048_1215 {-0.8331701647019131851124029708444140851498,0.5530167055800275788257636122580152004957}
#define T_2048_1221 {-0.8228497813758263168537609999475535005331,0.5682589526701316007262221319251693785191}
#define T_2048_1225 {-0.8158144108067337807455032816505990922451,0.5783137964116555895799365316634066402912}
#define T_2048_1227 {-0.8122505865852038819951985715306363999844,0.5833086529376982909411708533298224210739}
#define T_2048_1233 {-0.8013761717231402403882611906738020479679,0.5981607069963422729230728691618423908949}
#define T_2048_1235 {-0.7976908409433911550934226397657766938210,0.6030665985403481643700729364354629069567}
#define T_2048_1239 {-0.7902302214373100319733111973619088530540,0.6128100824294097082045595925592351704836}
#define T_2048_1245 {-0.7788165123814759782661099052347708493471,0.6272518154951440827460373839130625128746}
#define T_2048_1251 {-0.7671389119358204000675982570101041346788,0.6414810128085831619770829092885833233595}
#define T_2048_1255 {-0.7592091889783880720443676182185299694538,0.6508466849963808753543048624123912304640}
#define T_2048_1257 {-0.7552013768965365470009487580682616680861,0.6554928529996153496739452748443000018597}
#define T_2048_1263 {-0.7430079521351217186619919630174990743399,0.6692825883466361203133487833838444203138}
#define T_2048_1265 {-0.7388873244606151136082416996941901743412,0.6738290003787560378256671356211882084608}
#define T_2048_1269 {-0.7305627692278275908677187544526532292366,0.6828455463852480811226541845826432108879}
#define T_2048_1275 {-0.7178700450557317092048492668254766613245,0.6961771314914629860126638050132896751165}
#define T_2048_1281 {-0.7049340803759048812437981723633129149675,0.7092728264388656889138928818283602595329}
#define T_2048_1287 {-0.6917592583641577475006556596781592816114,0.7221281939292153451148692511196713894606}
#define T_2048_1293 {-0.6783500431298614685715619998518377542496,0.7347388780959634990708195800834801048040}
#define T_2048_1299 {-0.6647109782033449043581185833318158984184,0.7471006059801801324482539712334983050823}
#define T_2048_1305 {-0.6508466849963808753543048624123912304640,0.7592091889783880720443676182185299694538}
#define T_2048_1311 {-0.6367618612362841989948947230004705488682,0.7710605242618138177590481063816696405411}
#define T_2048_1317 {-0.6224612793741499672250938601791858673096,0.7826505961665757293843626030138693749905}
#define T_2048_1323 {-0.6079497849677736320828103089297655969858,0.7939754775543371723145469331939239054918}
#define T_2048_1329 {-0.5932322950397997951554884821234736591578,0.8050313311429635465543697137036360800266}
#define T_2048_1335 {-0.5783137964116555895799365316634066402912,0.8158144108067337807455032816505990922451}
#define T_2048_1341 {-0.5631993440138340911715886250021867454052,0.8263210628456635342686809053702745586634}
#define T_2048_1347 {-0.5478940591731001896746988677477929741144,0.8365477272235120054233448172453790903091}
#define T_2048_1353 {-0.5324031278771980124631113540090154856443,0.8464909387740521262699644466920290142298}
#define T_2048_1359 {-0.5167317990176498732068921526661142706871,0.8561473283751944718389381705492269247770}
#define T_2048_1365 {-0.5008853826112408258453001508314628154039,0.8655136240905690891977997125650290399790}
#define T_2048_1371 {-0.4848692480007911198569559019233565777540,0.8745866522781761132065980746119748800993}
#define T_2048_1377 {-0.4686888220358279566468695520597975701094,0.8833633386657315789136646344559267163277}
#define T_2048_1383 {-0.4523495872337708889610041751438984647393,0.8918407093923427231274558835139032453299}
#define T_2048_1389 {-0.4358570799222554748020286297105485573411,0.9000158920161602793541533173993229866028}
#define T_2048_1395 {-0.4192168883632239606562563949410105124116,0.9078861164876662614986457811028230935335}
#define T_2048_1401 {-0.4024346508594184301799145941913593560457,0.9154487160882678331574879848631098866463}
#define T_2048_1407 {-0.3855160538439188488979425528668798506260,0.9227011283338785174734653082850854843855}
#define T_2048_1413 {-0.3684668299533723212491054255224298685789,0.9296408958431812141753880496253259480000}
#define T_2048_1419 {-0.3512927560855671482720197218441171571612,0.9362656671702782595900771411834284663200}
#define T_2048_1425 {-0.3339996514420093820518786742468364536762,0.9425731976014468660451939285849221050739}
#define T_2048_1431 {-0.3165933755561658458077545219566673040390,0.9485613499157302674902325634320732206106}
#define T_2048_1437 {-0.2990798263080404750802188118541380390525,0.9542280951091056673263324228173587471247}
#define T_2048_1443 {-0.2814649379257579964175306486140470951796,0.9595715130819845173348880962294060736895}
#define T_2048_1449 {-0.2637546789748314024492970020219217985868,0.9645897932898127580259028945874888449907}
#define T_2048_1455 {-0.2459550503357946227289687612937996163964,0.9692812353565485317119510000338777899742}
#define T_2048_1461 {-0.2280720831708857310182736455317353829741,0.9736442496508119770481926025240682065487}
#define T_2048_1467 {-0.2101118368804696101559414955772808752954,0.9776773578245099294292685954133048653603}
#define T_2048_1473 {-0.1920803970498924373444538105104584246874,0.9813791933137545608900609295233152806759}
#define T_2048_1479 {-0.1739838733874638221355013456559390760958,0.9847485018019042080084091139724478125572}
#define T_2048_1485 {-0.1558283976542652327079707674784003756940,0.9877841416445721778316624295257497578859}
#define T_2048_1491 {-0.1376201215864860383231160767536493949592,0.9904850842564570934101197963173035532236}
#define T_2048_1497 {-0.1193652148109913685436467289946449454874,0.9928504144598651048880810776608996093273}
#define T_2048_1503 {-0.1010698627548278216714550126198446378112,0.9948793307948056163780847782618366181850}
#define T_2048_1509 {-0.0827402645493756916383887300980859436095,0.9965711457905548353863878219272010028362}
#define T_2048_1515 {-0.0643826309298574650519242368318373337388,0.9979252861985959954793656834226567298174}
#define T_2048_1521 {-0.0460031821309146299325831819260201882571,0.9989412931868568712445721757831051945686}
#define T_2048_1527 {-0.0276081457789657432055907548829054576345,0.9996188224951786382987961587787140160799}
#define T_2048_1533 {-0.0092037547820598194364682953505507612135,0.9999576445519638978609577861789148300886}
// Pre-computed twiddles for N=2187
#define T_2187_1 {0.9999958730246369942307183009688742458820,-0.0028729660099040786602753172473967424594}
#define T_2187_2 {0.9999834921326118397644222568487748503685,-0.0057459083064882740879419920076998096192}
#define T_2187_4 {0.9999339690754668330541221621388103812933,-0.0114916269075918536790581470086181070656}
#define T_2187_5 {0.9998968273191078948158860839612316340208,-0.0143643557872330171476527027607517084107}
#define T_2187_7 {0.9997977848836454572989396183402277529240,-0.0201094341480766991558937206718837842345}
#define T_2187_8 {0.9997358850220334769431929089478217065334,-0.0229817362096855111464055454462140914984}
#define T_2187_10 {0.9995873305656355345405472689890302717686,-0.0287257475562743211372485063748172251508}
#define T_2187_11 {0.9995006771970108561120582635339815169573,-0.0315974094304676961231237442007113713771}
#define T_2187_13 {0.9993026217550673440115360790514387190342,-0.0373399270680699682523062676864356035367}
#define T_2187_14 {0.9991912213164882983207348843279760330915,-0.0402107354330212413140444027703779283911}
#define T_2187_16 {0.9989436796015768171841386902087833732367,-0.0459513327778657137967499579644936602563}
#define T_2187_17 {0.9988075403684415487504111297312192618847,-0.0488210743751512771249068123324832413346}
#define T_2187_19 {0.9985105307692350162795946744154207408428,-0.0545593249861159035329905009348294697702}
#define T_2187_20 {0.9983496628546664197756399516947567462921,-0.0574277866365571557083491427420085528865}
#define T_2187_22 {0.9980032074345668302584044795366935431957,-0.0631632642468473587404886870899645145983}
#define T_2187_23 {0.9978176227886617066786811847123317420483,-0.0660302328663467247293894502035982441157}
#define T_2187_25 {0.9974217472841611087375213173800148069859,-0.0717625114151607124135523463337449356914}
#define T_2187_26 {0.9972114596931024310677571520500350743532,-0.0746277740305306552803799036155396606773}
#define T_2187_28 {0.9967661935118711236114563689625356346369,-0.0803564276947093814040812276289216242731}
#define T_2187_29 {0.9965312185969036340438265142438467592001,-0.0832197714594930942899608794505184050649}
#define T_2187_31 {0.9960365948156058024665071570780128240585,-0.0889443746851526079177929773322830442339}
#define T_2187_32 {0.9957769500318757183165985225059557706118,-0.0918055868954354425959252239408669993281}
#define T_2187_34 {0.9952330053937118448104115486785303801298,-0.0975257144295791911225990133971208706498}
#define T_2187_35 {0.9949487100289704510913679769146256148815,-0.1003845825397893104513613593553600367159}
#define T_2187_37 {0.9943554849409484974742667873215395957232,-0.1060998094618981757442099933541612699628}
#define T_2187_38 {0.9940465601141187379496955145441461354494,-0.1089561211005955487785001878364710137248}
#define T_2187_40 {0.9934040986440521026068495302752126008272,-0.1146660228541930975909579615290567744523}
#define T_2187_41 {0.9930705673036605007908406150818336755037,-0.1175195658398455744730881633586250245571}
#define T_2187_43 {0.9923789171768944150642255408456549048424,-0.1232237182640363026830954140677931718528}
#define T_2187_44 {0.9920208040993658826778300863225013017654,-0.1260742806207815203123345781932584941387}
#define T_2187_46 {0.9912800166952320246593899355502799153328,-0.1317722599817597040061656343823415227234}
#define T_2187_47 {0.9908973484830494449226989672752097249031,-0.1346196299551517816528445337098673917353}
#define T_2187_49 {0.9901074788310497698518020115443505346775,-0.1403110129776786174637948079180205240846}
#define T_2187_50 {0.9897002839107778005001136989449150860310,-0.1431549790504183239381319481253740377724}
#define T_2187_52 {0.9888613906864961444753703290189150720835,-0.1488393429492649577827734219681588001549}
#define T_2187_53 {0.9884296993066696845886554001481272280216,-0.1516796938569123232021240710309939458966}
#define T_2187_55 {0.9875418448274129179509372988832183182240,-0.1573566163682665608458677297676331363618}
#define T_2187_56 {0.9870856890562899055296952610660810023546,-0.1601931411149347395106445901546976529062}
#define T_2187_58 {0.9861489392764595240947755883098579943180,-0.1658622005277689548385922080342425033450}
#define T_2187_59 {0.9856683529996386194937940672389231622219,-0.1686946884017979653158647579402895644307}
#define T_2187_61 {0.9846827775058303311439544813765678554773,-0.1743554635891959858629007840136182494462}
#define T_2187_62 {0.9841777964237343745423913787817582488060,-0.1771837041788055511215560500204446725547}
#define T_2187_64 {0.9831434684295693449129771579464431852102,-0.1828357746292460783710254190737032331526}
#define T_2187_65 {0.9826141300547924783970188400417100638151,-0.1856595578381660671674069362779846414924}
#define T_2187_67 {0.9815311263954785703234051652543712407351,-0.1913025036867605221946320170900435186923}
#define T_2187_68 {0.9809774700500003552505745574308093637228,-0.1941216197498379925079348140570800751448}
#define T_2187_70 {0.9798458711766244721985685828258283436298,-0.1997550218095201501888880102342227473855}
#define T_2187_71 {0.9792679379888882262861216076998971402645,-0.2025692613083018012165581467343145050108}
#define T_2187_73 {0.9780878279624398707881027803523465991020,-0.2081927011009672146002458248403854668140}
#define T_2187_74 {0.9774856608642977784384697770292405039072,-0.2110018549792559983124817790667293593287}
#define T_2187_76 {0.9762571273494247137136881065089255571365,-0.2166149147668487151552341174465254880488}
#define T_2187_77 {0.9756307710729488213985405309358611702919,-0.2194187743462336914745947069604881107807}
#define T_2187_79 {0.9743539053314446141129678835568483918905,-0.2250210371617779592234853680565720424056}
#define T_2187_80 {0.9737034064056033777490029024193063378334,-0.2278193941571359515396721917568356730044}
#define T_2187_82 {0.9723783032896283762269717954040970653296,-0.2334104438357106625634429519777768291533}
#define T_2187_83 {0.9717037100368306479225566363311372697353,-0.2362030903706787698936864217102993279696}
#define T_2187_85 {0.9703304679818656186540692942799068987370,-0.2417825115803323710039762772794347256422}
#define T_2187_86 {0.9696318305143708515814182646863628178835,-0.2445692402027500877981225357871153391898}
#define T_2187_88 {0.9682105515319048283373604135704226791859,-0.2501366184753535670814983404852682724595}
#define T_2187_89 {0.9674879217481004989309667507768608629704,-0.2529172221726733726931968249118654057384}
#define T_2187_91 {0.9660187114180527334639236869406886398792,-0.2584721439347090754523605937720276415348}
#define T_2187_92 {0.9652721429985990919675487020867876708508,-0.2612464161493744385644788508216151967645}
#define T_2187_94 {0.9637551104614759944766433363838586956263,-0.2667884687526583809003000169468577951193}
#define T_2187_95 {0.9629846588653184769057702396821696311235,-0.2695562033974479021480874507687985897064}
#define T_2187_97 {0.9614199168141062123993378918385133147240,-0.2750849751497835837810157499916385859251}
#define T_2187_98 {0.9606256392743554028967878366529475897551,-0.2778459666231201663499916776345344260335}
#define T_2187_100 {0.9590133039461485875420976299210451543331,-0.2833610468188809128342597887240117415786}
#define T_2187_101 {0.9581952594658289523721350633422844111919,-0.2861150900201049895876792561466572806239}
#define T_2187_103 {0.9565354506331955608544603819609619677067,-0.2916160689707435471618168776331003755331}
#define T_2187_104 {0.9556936999808621768792704642692115157843,-0.2943629593153489487633578391978517174721}
#define T_2187_106 {0.9539865409429466591717527990113012492657,-0.2998494283798311399458214054902782663703}
#define T_2187_107 {0.9531211466481711580556179796985816210508,-0.3025889618146626602879223355557769536972}
#define T_2187_109 {0.9513667642215349884438069238967727869749,-0.3080605134298232683498497408436378464103}
#define T_2187_110 {0.9504777905702603835180752867017872631550,-0.3107924864482349280869755148160038515925}
#define T_2187_112 {0.9486763150794612631244717704248614609241,-0.3162487141590537009783190569578437134624}
#define T_2187_113 {0.9477638281092265470917368475056719034910,-0.3189729238160260993417693953233538195491}
#define T_2187_115 {0.9459153933771375921679691600729711353779,-0.3244134223058212640466990706045180559158}
#define T_2187_116 {0.9449794608721723276900661403487902134657,-0.3271296662330375748517496958811534568667}
#define T_2187_118 {0.9430842042100405775428839660889934748411,-0.3325540313535748637718825193587690591812}
#define T_2187_119 {0.9421248956962291476457949102041311562061,-0.3352621077744535327269659319426864385605}
#define T_2187_121 {0.9401829578934759457098380153183825314045,-0.3406699365759684461352208018070086836815}
#define T_2187_122 {0.9392003446331931293400430149631574749947,-0.3433696443206523674085417496826266869903}
#define T_2187_124 {0.9372118699469550451297550353046972304583,-0.3487605350817832849941169115481898188591}
#define T_2187_125 {0.9362060249337719186613071542524266988039,-0.3514516736020836806808631536114262416959}
#define T_2187_127 {0.9341711610781849861595560469140764325857,-0.3568252258597138237838919394562253728509}
#define T_2187_128 {0.9331421590314470382310219065402634441853,-0.3595075952440081046290742960991337895393}
#define T_2187_130 {0.9310610571666733115137049026088789105415,-0.3648634098230139621854561937652761116624}
#define T_2187_131 {0.9300089745259497719942487492517102509737,-0.3675368108110959597389921782450983300805}
#define T_2187_133 {0.9278817892469488626261409081052988767624,-0.3728744898540001240228036749613238498569}
#define T_2187_134 {0.9268067041663539118445669373613782227039,-0.3755387238518824721822397805226501077414}
#define T_2187_136 {0.9246335934913986198679936023836489766836,-0.3808578708484084973662220363621599972248}
#define T_2187_137 {0.9235355858337865875284933281363919377327,-0.3835127399430749983721966600569430738688}
#define T_2187_139 {0.9213167111927244024016658840992022305727,-0.3888129597596022279937244547909358516335}
#define T_2187_140 {0.9201958625237562916510114519041962921619,-0.3914582667337097587889616079337429255247}
#define T_2187_142 {0.9179313887460178733590510091744363307953,-0.3967391656426259571865955422254046425223}
#define T_2187_143 {0.9167877823281026516966107919870410114527,-0.3993747139891551389823121098743285983801}
#define T_2187_145 {0.9144778776304572920352597975579556077719,-0.4046358996981044842122798854688880965114}
#define T_2187_146 {0.9133115984165666167982067236152943223715,-0.4072614936349569503271084158768644556403}
#define T_2187_148 {0.9109564343906260130978580491500906646252,-0.4125025753159815566917245632794220000505}
#define T_2187_149 {0.9097675690179838348115026747109368443489,-0.4151180198005237631520003560581244528294}
#define T_2187_151 {0.9073673206174556193914781943021807819605,-0.4203386081190965128939751593861728906631}
#define T_2187_152 {0.9061559574011017748063068211195059120655,-0.4229437088626484264608507146476767957211}
#define T_2187_154 {0.9037108029287931332262928663112688809633,-0.4281434160065946681328341583139263093472}
#define T_2187_155 {0.9024770318550230374654574916348792612553,-0.4307379794888625546001037491805618628860}
#define T_2187_157 {0.8999871529495953037525168838328681886196,-0.4359164191971687807303226236399495974183}
#define T_2187_158 {0.8987310656692755195251720579108223319054,-0.4385002526806209277587811357079772278666}
#define T_2187_160 {0.8961966472917510806439622683683410286903,-0.4436570402721281558555688206979539245367}
#define T_2187_161 {0.8949183371135107645244488594471476972103,-0.4462299518163125311431826958141755312681}
#define T_2187_163 {0.8923395675335332732913684594677761197090,-0.4513647042182925561704109895799774676561}
#define T_2187_164 {0.8910391294168331643987812640261836349964,-0.4539265026940948466460667987121269106865}
#define T_2187_166 {0.8884162001986819490184643655084073543549,-0.4590388384707067004342206928413361310959}
#define T_2187_167 {0.8870937307467594568066715510212816298008,-0.4615893335745486214527488755265949293971}
#define T_2187_169 {0.8844268367351190152092499374703038483858,-0.4666788729551736847334098001738311722875}
#define T_2187_170 {0.8830824341878128480587406556878704577684,-0.4692178752231495608704392452636966481805}
#define T_2187_172 {0.8803717734932990923724105414294172078371,-0.4742842401306028299323713781632250174880}
#define T_2187_173 {0.8790055377197512065379214618587866425514,-0.4768115609525540032898049958021147176623}
#define T_2187_175 {0.8762513117041941246299074919079430401325,-0.4818543750311697904109564660757314413786}
#define T_2187_176 {0.8748633441954307699006676557473838329315,-0.4843698266646954686542869694676483049989}
#define T_2187_178 {0.8720657574569171677225654093490447849035,-0.4893887153082847607521443933364935219288}
#define T_2187_179 {0.8706561613183099179735791040002368390560,-0.4918921108926886942569467464636545628309}
#define T_2187_181 {0.8678154216759838002204219264967832714319,-0.4968867012723668930007647759339306503534}
#define T_2187_182 {0.8663843016195901247655797305924352258444,-0.4993778548425382157738283694925485178828}
#define T_2187_184 {0.8635006200982157098522407068230677396059,-0.5043477759344209276903825411864090710878}
#define T_2187_185 {0.8620480824350003068445857934420928359032,-0.5068265024346485514428195529035292565823}
#define T_2187_187 {0.8591216732492856777980705373920500278473,-0.5117713850474131520584819554642308503389}
#define T_2187_188 {0.8576478258812235688779423981031868606806,-0.5142375003451327142300897321547381579876}
#define T_2187_190 {0.8546789064199074026362268341472372412682,-0.5191569771474434658031782419129740446806}
#define T_2187_191 {0.8531838588319681226934676487871911376715,-0.5216102980469157213150310781202279031277}
#define T_2187_193 {0.8501726496416712741677201847778633236885,-0.5265040035947116114911636941542383283377}
#define T_2187_194 {0.8486565128936859325747832372144330292940,-0.5289443478506308249365019946708343923092}
#define T_2187_196 {0.8456032376625279844972737919306382536888,-0.5338119186142720185017651601810939610004}
#define T_2187_197 {0.8440661243809388647463265442638657987118,-0.5362391049453046898420893739967141300440}
#define T_2187_199 {0.8409710099219216417054667545016855001450,-0.5410801793365777045963227465108502656221}
#define T_2187_200 {0.8394130342914158937617230549221858382225,-0.5434940274388285752493743530067149549723}
#define T_2187_202 {0.8362763105255744955357499748060945421457,-0.5483082458378070178639518417185172438622}
#define T_2187_203 {0.8346975882806021429516363241418730467558,-0.5507085763982130233173961642023641616106}
#define T_2187_205 {0.8315194882199247183862667043285910040140,-0.5554955811799715537091515216161496937275}
#define T_2187_206 {0.8299201366361010911987250437960028648376,-0.5578822158896225014146352805255446583033}
#define T_2187_208 {0.8267008963662204612532491410092916339636,-0.5626416514508036925690248608589172363281}
#define T_2187_209 {0.8250810342516141648872007863246835768223,-0.5650144130181873336482567538041621446609}
#define T_2187_211 {0.8218208929142694074698738404549658298492,-0.5697459258034170970219634000386577099562}
#define T_2187_212 {0.8201806406005770488931716499791946262121,-0.5721046379675898130301447963574901223183}
#define T_2187_214 {0.8168798403758492643333966043428517878056,-0.5768078764957418336223327059997245669365}
#define T_2187_215 {0.8152193197094562693294506061647552996874,-0.5791523640394220517890744304168038070202}
#define T_2187_217 {0.8118781057977778603529372958291787654161,-0.5838269789297272360784063494065776467323}
#define T_2187_218 {0.8101974401307073803124580990697722882032,-0.5861570676923113509815266297664493322372}
#define T_2187_220 {0.8068160607346474000323155451042111963034,-0.5908027116903118436397335244691930711269}
#define T_2187_221 {0.8051153749153968641749656853789929300547,-0.5931182285808116461112149409018456935883}
#define T_2187_223 {0.8016940812212235423217521201877389103174,-0.5977345565841565289133541227784007787704}
#define T_2187_224 {0.7999735015854902986376373519306071102619,-0.6000353295940576980882497082347981631756}
#define T_2187_226 {0.7965125477445111901175778257311321794987,-0.6046219986781391497743243235163390636444}
#define T_2187_227 {0.7947722021058077901400906739581841975451,-0.6069078568941788098811684903921559453011}
#define T_2187_229 {0.7912718452154904325013262678112369030714,-0.6114645263376061734561517369002103805542}
#define T_2187_230 {0.7895118628556496709336443018401041626930,-0.6137352999544687381927587921381928026676}
#define T_2187_232 {0.7859723629405228617628154097474180161953,-0.6182616312643790523750908505462575703859}
#define T_2187_233 {0.7841928746000946803818010266695637255907,-0.6205171515973110230035558743111323565245}
#define T_2187_235 {0.7806144945924325950770139570522587746382,-0.6250128085345140194206692285661119967699}
#define T_2187_236 {0.7788156324609710745576762747077737003565,-0.6272529080318540728455900534754619002342}
#define T_2187_238 {0.7751986381812614457231802589376457035542,-0.6317175566358099736419262626441195607185}
#define T_2187_239 {0.7733805358875058821865877689560875296593,-0.6339420688914360058063834912900347262621}
#define T_2187_241 {0.7697251960247032398498845395806711167097,-0.6383753775050633461063398499391041696072}
#define T_2187_242 {0.7678879886266511967107817326905205845833,-0.6405841372707538061703758103249128907919}
#define T_2187_244 {0.7641945747182173898082169216650072485209,-0.6449857765650672813961818974348716437817}
#define T_2187_245 {0.7623383986930919453683941355848219245672,-0.6471786197627764636308711487799882888794}
#define T_2187_247 {0.7586071851048249436999526551517192274332,-0.6515482627613505828279016895976383239031}
#define T_2187_248 {0.7567321783389363565319740700942929834127,-0.6537250264953975431581056909635663032532}
#define T_2187_250 {0.7529634422445888874975139515299815684557,-0.6580623485986564213945371193403843790293}
#define T_2187_251 {0.7510697440230919008641308209917042404413,-0.6602228711678255201888987357961013913155}
#define T_2187_253 {0.7472637653837815863155924489547032862902,-0.6645275501771560344721478941210079938173}
#define T_2187_254 {0.7453515163803283716248415657901205122471,-0.6666716710867089945580232779320795089006}
#define T_2187_256 {0.7415085779237409191466667834902182221413,-0.6709433872283946387327091542829293757677}
#define T_2187_257 {0.7395779201900313237771911190066020935774,-0.6730709472019927863684074509365018457174}
#define T_2187_259 {0.7356983073894177715956743668357376009226,-0.6773093831509687801073482660285662859678}
#define T_2187_260 {0.7337493843446467600699634203920140862465,-0.6794202241425051358447717575472779572010}
#define T_2187_262 {0.7298333853976173291044915458769537508488,-0.6836250650459307909301287509151734411716}
#define T_2187_263 {0.7278663418178212829445783427217975258827,-0.6857190302512703450332764987251721322536}
#define T_2187_265 {0.7239142476249363911122713943768758326769,-0.6898899637519176897271222514973487704992}
#define T_2187_266 {0.7219292296322382673778861317259725183249,-0.6919668976205458621464572388504166156054}
#define T_2187_268 {0.7179413337753990376199908496346324682236,-0.6961036138800035244500463704753201454878}
#define T_2187_269 {0.7159384888271538294191032036906108260155,-0.6981633621265808109512818191433325409889}
#define T_2187_271 {0.7119150875477933126944662944879382848740,-0.7022655538482702741731600326602347195148}
#define T_2187_272 {0.7098945644256339226885188509186264127493,-0.7043079634640938557765821315115317702293}
#define T_2187_274 {0.7058359566027107012686769849096890538931,-0.7083753259160967541419040571781806647778}
#define T_2187_275 {0.7037979054014957824847442680038511753082,-0.7104002451804666273815769272914621978998}
#define T_2187_277 {0.6997043925292916188851677361526526510715,-0.7144324762181621935042130644433200359344}
#define T_2187_278 {0.6976489646459559379465531492314767092466,-0.7164397547096515994624610357277560979128}
#define T_2187_280 {0.6935208508116794678954875053022988140583,-0.7204365547981613771000297674618195742369}
#define T_2187_281 {0.6914481989339869016930606449022889137268,-0.7224260434057908630833821916894521564245}
#define T_2187_283 {0.6872857907951843703386884953943081200123,-0.7263871156422297969967871722474228590727}
#define T_2187_284 {0.6851960688903859786336170145659707486629,-0.7283586665765441336972685348882805556059}
#define T_2187_286 {0.6809996756521610183909842817229218780994,-0.7322837167120757051463897369103506207466}
#define T_2187_287 {0.6788930389555574151927430648356676101685,-0.7342371835161224380428279800980817526579}
#define T_2187_289 {0.6746629723476017526095915854966733604670,-0.7381259199778172908068540891690645366907}
#define T_2187_290 {0.6725395773510111085968787847377825528383,-0.7400611575380262596723923707031644880772}
#define T_2187_292 {0.6682761516044478655729221827641595155001,-0.7439132914505218741041403518465813249350}
#define T_2187_293 {0.6661361560445813179143215165822766721249,-0.7458301560074849234638350026216357946396}
#define T_2187_295 {0.6618396878686220174969889740168582648039,-0.7496454012144442291543100509443320333958}
#define T_2187_296 {0.6596832507153659319598659749317448586226,-0.7515437503735944435589999557123519480228}
#define T_2187_298 {0.6553540592737839842740754647820722311735,-0.7553218234589634816344982937152963131666}
#define T_2187_299 {0.6531813407183909570008495393267367035151,-0.7572015162011532796171309200872201472521}
#define T_2187_301 {0.6488197476058121804243228325503878295422,-0.7609421365102146950221140286885201931000}
#define T_2187_302 {0.6466309090490012234653249834082089364529,-0.7628030332021906723127813165774568915367}
#define T_2187_304 {0.6422372382670146206962158430542331188917,-0.7665059228624120368777994372067041695118}
#define T_2187_305 {0.6400324423069811974329468284850008785725,-0.7683478852671885572789278739946894347668}
#define T_2187_307 {0.6356070202400700974720848535071127116680,-0.7720127692088643023282656940864399075508}
#define T_2187_308 {0.6333864306604080063323181093437597155571,-0.7738356604959919504693743874668143689632}
#define T_2187_310 {0.6289295860517044589599322534922976046801,-0.7774622664726769105669745840714313089848}
#define T_2187_311 {0.6266933678092387882685443400987423956394,-0.7792659512284071388066308827546890825033}
#define T_2187_313 {0.6222054317361032094169104311731643974781,-0.7828540098371403743726659740786999464035}
#define T_2187_314 {0.6199537509486364728061857931606937199831,-0.7846383540744844564684967735956888645887}
#define T_2187_316 {0.6154350567980632069620128277165349572897,-0.7881875987758021340212621907994616776705}
#define T_2187_317 {0.6131680807320354364975401040283031761646,-0.7899524699444847586349283119488973170519}
#define T_2187_319 {0.6086189641758871227139593429455999284983,-0.7934626370822196461674025158572476357222}
#define T_2187_320 {0.6063368612339504748476315398875158280134,-0.7952079040785252628253942930314224213362}
#define T_2187_322 {0.6017576602040227706780228800198528915644,-0.7986787328993929513387683982728049159050}
#define T_2187_323 {0.5994605999125314221842586448474321514368,-0.8004042660759048688490224776614923030138}
#define T_2187_325 {0.5948516545754494178055438169394619762897,-0.8038354987488735003964279712818097323179}
#define T_2187_326 {0.5925398075718665280575692122511100023985,-0.8055411699241047385200431563134770840406}
#define T_2187_328 {0.5879014603038157371628358305315487086773,-0.8089325515595481297381752483488526195288}
#define T_2187_329 {0.5855749983240376987936315344995819032192,-0.8106182340274633579824126172752585262060}
#define T_2187_331 {0.5809075936853302923879027730436064302921,-0.8139695126960955207096048980019986629486}
#define T_2187_332 {0.5785666895509289364696314805769361555576,-0.8156350812355235291306598810479044914246}
#define T_2187_334 {0.5738705742604082171709478643606416881084,-0.8189460079871134778883856597531121224165}
#define T_2187_335 {0.5715154018657930823366086769965477287769,-0.8205913388710491807032099131902214139700}
#define T_2187_337 {0.5667909247750773094054466128000058233738,-0.8238616677529139176172634506656322628260}
#define T_2187_338 {0.5644216590745777528681514922936912626028,-0.8254866387577094455352266777481418102980}
#define T_2187_340 {0.5596691711421457604558327147969976067543,-0.8287161268329846786073744624445680528879}
#define T_2187_341 {0.5572859881370144652379394756280817091465,-0.8303206172474288937479514061124064028263}
#define T_2187_343 {0.5525058424021346281662658839195501059294,-0.8335090246131157121212140737043228000402}
#define T_2187_344 {0.5501089191274732836944849623250775039196,-0.8350929152474011463169745184131897985935}
#define T_2187_346 {0.5453014706839777181457407095876988023520,-0.8382400050521873202669098645856138318777}
#define T_2187_347 {0.5428909851955860954575427967938594520092,-0.8398031782467638706179968721698969602585}
#define T_2187_349 {0.5380565911654929811547276585770305246115,-0.8429087167086182219577494834084063768387}
#define T_2187_350 {0.5356327225266416247606571232608985155821,-0.8444510563429343807939631005865521728992}
#define T_2187_352 {0.5307717420336256486379511443374212831259,-0.8475148127664733355146609028452076017857}
#define T_2187_353 {0.5283346703017546275304994196631014347076,-0.8490362042676014020514685398666188120842}
#define T_2187_355 {0.5234474644444703228529647276445757597685,-0.8520579510612262819080342524102889001369}
#define T_2187_356 {0.5209973706578132635058864252641797065735,-0.8535582814123737760425569831568282097578}
#define T_2187_358 {0.5160843024830696901261717357556335628033,-0.8565377941051774968173049273900687694550}
#define T_2187_359 {0.5136213686472057560195025871507823467255,-0.8580169518540826656405329231347423046827}
#define T_2187_361 {0.5086828031229982949312784512585494667292,-0.8609540091125245098169216362293809652328}
#define T_2187_362 {0.5062072121973312244236353762971702963114,-0.8624118843797353717306464204739313572645}
#define T_2187_364 {0.5012435161857295984333404703647829592228,-0.8653062680240830584210698361857794225216}
#define T_2187_365 {0.4987554520698973536951825735741294920444,-0.8667427525111198738372308980615343898535}
#define T_2187_367 {0.4937669942997933159034573691315017640591,-0.8695942475316564834741939193918369710445}
#define T_2187_368 {0.4912666418200062334875610758899711072445,-0.8710092345290569859628249105298891663551}
#define T_2187_370 {0.4862537928597223668703009025193750858307,-0.8738176291020536279319230743567459285259}
#define T_2187_371 {0.4837413377550338622334891169884940609336,-0.8752110134972995725277655765239614993334}
#define T_2187_373 {0.4787044699847959328131707934517180547118,-0.8779760990007504650733949347340967506170}
#define T_2187_374 {0.4761800988933048150997251468652393668890,-0.8793477772860760488526921108132228255272}
#define T_2187_376 {0.4711195864775793440415441182267386466265,-0.8820693483151960112564893279341049492359}
#define T_2187_377 {0.4685834869225651289070810889825224876404,-0.8834192185952772780055397561227437108755}
#define T_2187_379 {0.4634997057822647370528557075886055827141,-0.8860970729777601917476204107515513896942}
#define T_2187_380 {0.4609520661582576228632035508780973032117,-0.8874250349772837553885551642451900988817}
#define T_2187_382 {0.4558453939428155909929785138956503942609,-0.8900589737883211061131305541493929922581}
#define T_2187_383 {0.4532864035016014869761136196757433936000,-0.8913649288594337471991480015276465564966}
#define T_2187_385 {0.4481572195609179187769655072770547121763,-0.8939547564364916931722859771980438381433}
#define T_2187_386 {0.4455870683974799129067889680300140753388,-0.8952386075661279418724802781071048229933}
#define T_2187_388 {0.4404357537537417210948831325367791578174,-0.8977841315234823538204977921850513666868}
#define T_2187_389 {0.4378546327921387648629547584278043359518,-0.8990457833405711696173057134728878736496}
#define T_2187_391 {0.4326815701115155343714491209539119154215,-0.9015468145835986435443487607699353247881}
#define T_2187_392 {0.4300896710906996767143084525741869583726,-0.9027861733661486365321025004959665238857}
#define T_2187_394 {0.4248952446549170147704899136442691087723,-0.9052425261053737015615183736372273415327}
#define T_2187_395 {0.4222927601144900178198327012069057673216,-0.9064594997874344528554502176120877265930}
#define T_2187_397 {0.4170773557922832219801989594998303800821,-0.9088709915523308646712052905058953911066}
#define T_2187_398 {0.4144644790581937798812361961608985438943,-0.9100654897308325663729533516743686050177}
#define T_2187_400 {0.4092284842766436558925136068864958360791,-0.9124319413833783531941890032612718641758}
#define T_2187_401 {0.4066054094468259938466303538007196038961,-0.9136038753248472144008474060683511197567}
#define T_2187_403 {0.4013492131625785996895672269602073356509,-0.9159251110728316991327346840989775955677}
#define T_2187_404 {0.3987161350925340630446669365483103320003,-0.9170743937199817841232629689329769462347}
#define T_2187_406 {0.3934401277629070992070126067119417712092,-0.9193502411300642496172486062278039753437}
#define T_2187_407 {0.3907972420512292321959080254600849002600,-0.9204767871082643049263083412370178848505}
#define T_2187_409 {0.3855018156052067990202658620546571910381,-0.9227070771187837472382398118497803807259}
#define T_2187_410 {0.3828493185790511899035948317759903147817,-0.9238108027423992396620633371639996767044}
#define T_2187_412 {0.3775348663881692989896521339687751606107,-0.9259953696759326557952363145886920392513}
#define T_2187_413 {0.3748729550886695238709478417149512097239,-0.9270761929545425772403177688829600811005}
#define T_2187_415 {0.3695398719377944729558294056914746761322,-0.9292148745302124535072607613983564078808}
#define T_2187_416 {0.3668687441054248044025598574080504477024,-0.9302727151746998934811472281580790877342}
#define T_2187_418 {0.3615174261634265251430520038411486893892,-0.9323653525202293401719089160906150937080}
#define T_2187_419 {0.3588372802233126268589558094390667974949,-0.9334001319487457148937892270623706281185}
#define T_2187_421 {0.3534681250136352259616501214622985571623,-0.9354465696122601370277038768108468502760}
#define T_2187_422 {0.3507791600608142768003006040089530870318,-0.9364582109560627420918876850919332355261}
#define T_2187_424 {0.3453925664319458799234041634917957708240,-0.9384582969176381572751211024296935647726}
#define T_2187_425 {0.3426949822165768488879677988734329119325,-0.9394467250268000446666860625555273145437}
#define T_2187_427 {0.3372913503124211342942828650848241522908,-0.9414003107097551614756980598031077533960}
#define T_2187_428 {0.3345853472249459836795892897498561069369,-0.9423654521587484511613297399890143424273}
#define T_2187_430 {0.3291650784550974595532579769496805965900,-0.9442723924406820623644875922764185816050}
#define T_2187_431 {0.3264508575113553856539283515303395688534,-0.9452141755338314688117407058598473668098}
#define T_2187_433 {0.3210143545212805760158403245441149920225,-0.9470743287574030500053368086810223758221}
#define T_2187_434 {0.3182921173475755649562302096455823630095,-0.9479926835342122881655768651398830115795}
#define T_2187_436 {0.3128397839887023246241426477354252710938,-0.9498059115176648026235284305585082620382}
#define T_2187_437 {0.3101097328068250225108215545333223417401,-0.9507007697580135419102020932768937200308}
#define T_2187_439 {0.3046419741065427566617529464565450325608,-0.9524669378054382296028279597521759569645}
#define T_2187_440 {0.3019043117187485969488136561267310753465,-0.9533382330346500399542719605960883200169}
#define T_2187_442 {0.2964215338503202179509798952494747936726,-0.9550572099459924135800292788189835846424}
#define T_2187_443 {0.2936764636242643056185386285505956038833,-0.9559048774397723713391883393342141062021}
#define T_2187_445 {0.2881790738766539239357200585800455883145,-0.9575765355205786422132518964644987136126}
#define T_2187_446 {0.2854267997302835646600271957140648737550,-0.9584005123098215950250278183375485241413}
#define T_2187_448 {0.2799152064779009685402400009479606524110,-0.9600247273807243075793849129695445299149}
#define T_2187_449 {0.2771559328643078967679969082382740452886,-0.9608249522561927991048946751106996089220}
#define T_2187_451 {0.2716305455366722632071230236761039122939,-0.9624016036621353409330481554206926375628}
#define T_2187_452 {0.2688644774289045136228537558054085820913,-0.9631780171790063072023713175440207123756}
#define T_2187_454 {0.2633257064802299596273371662391582503915,-0.9647069877982058505594409325567539781332}
#define T_2187_455 {0.2605530493560656579710155256179859861732,-0.9654595322804864210297637328039854764938}
#define T_2187_457 {0.2550013062347706305210692789842141792178,-0.9669407085331348516987759467156138271093}
#define T_2187_458 {0.2522222660614539813117573885392630472779,-0.9676693280779468109287222432612907141447}
#define T_2187_460 {0.2466579631795965121821012644431903026998,-0.9691025999346472019624343374744057655334}
#define T_2187_461 {0.2438727463985374543931072821578709408641,-0.9698072404163802229248858566279523074627}
#define T_2187_463 {0.2382962971011793884557050660077948123217,-0.9711925014063208516645886447804514318705}
#define T_2187_464 {0.2355051106126180848754358976293588057160,-0.9718731104806525022965502103033941239119}
#define T_2187_466 {0.2299169291471194753739837324246764183044,-0.9732102576995160791994976534624584019184}
#define T_2187_467 {0.2271199802947566626087905206077266484499,-0.9738667848073007116127541848982218652964}
#define T_2187_469 {0.2215204817800034697850009024477913044393,-0.9751557189249084878213125193724408745766}
#define T_2187_470 {0.2187179783355979179049199956352822482586,-0.9757881152959329007501310115912929177284}
#define T_2187_472 {0.2131075787311647040667139663128182291985,-0.9770287405636235433803449268452823162079}
#define T_2187_473 {0.2102997288790989516282792237689136527479,-0.9776369592202298619554312608670443296432}
#define T_2187_475 {0.2046788449543494037285995545971672981977,-0.9788291834779719868819825023820158094168}
#define T_2187_476 {0.2018658572761645730864188408304471522570,-0.9794131792385475376860881624452304095030}
#define T_2187_478 {0.1962349065792916014139279923256253823638,-0.9805569139217858998236465595255140215158}
#define T_2187_479 {0.1934169900381930429222876455241930671036,-0.9811166434041191930504055562778376042843}
#define T_2187_481 {0.1877763908652012592170876814634539186954,-0.9822118035503539790198601622250862419605}
#define T_2187_482 {0.1849537547905356626998241154069546610117,-0.9827472251748576859142758621601387858391}
#define T_2187_484 {0.1793039261541681250733404340280685573816,-0.9837937294299555768262166566273663192987}
#define T_2187_485 {0.1764767802258733753184571924066403880715,-0.9843048034227551701391689675801899284124}
#define T_2187_487 {0.1708181418244852090015939438671921379864,-0.9853025740469929516507363587152212858200}
#define T_2187_488 {0.1679866960575143453038293728241114877164,-0.9857892624428814531967191214789636433125}
#define T_2187_490 {0.1623196682438953486471433507176698185503,-0.9867382253167208405741916976694483309984}
#define T_2187_491 {0.1594841329726155720880598209987510927022,-0.9872004919619788987361630461236927658319}
#define T_2187_493 {0.1538091367227643058157582345302216708660,-0.9881005765915724659009811148280277848244}
#define T_2187_494 {0.1509697225853322277711043852832517586648,-0.9885383871466538741046292670944239944220}
#define T_2187_496 {0.1452871794671836691570376842719269916415,-0.9893895266690820866628541807585861533880}
#define T_2187_497 {0.1424440973898981055434376230550697073340,-0.9898028486111651869094885114463977515697}
#define T_2187_499 {0.1367544295320075320443464761410723440349,-0.9906049797994027628078583802562206983566}
#define T_2187_500 {0.1339078907136406482170087883787346072495,-0.9909937824248059579090863735473249107599}
#define T_2187_502 {0.1282115207738256101865914615700603462756,-0.9917468456924191100299026402353774756193}
#define T_2187_503 {0.1253617366699342206004530453355982899666,-0.9921111001188819278340247365122195333242}
#define T_2187_505 {0.1196590878038774202751781672304787207395,-0.9928150395244543791051228254218585789204}
#define T_2187_506 {0.1168062701110947620986024730882490985096,-0.9931547186932829784922205362818203866482}
#define T_2187_508 {0.1110977659409099066456505511268915142864,-0.9938094819445720817796541268762666732073}
#define T_2187_509 {0.1082421265812198440947611288720509037375,-0.9941245606226490894030689560167957097292}
#define T_2187_511 {0.1025281911639827486792952981886628549546,-0.9947300990804700537850635555514600127935}
#define T_2187_512 {0.0996699422689771019623350412075524218380,-0.9950205538621293976930815006198827177286}
#define T_2187_514 {0.0939510000652245685914820683137804735452,-0.9955768225439682872490720910718664526939}
#define T_2187_515 {0.0910903539603448442196764744949177838862,-0.9958426318527335840968817137763835489750}
#define T_2187_517 {0.0853668298025435645648428817366948351264,-0.9963495894360892002339369355468079447746}
#define T_2187_518 {0.0825039989913083776640334576768509577960,-0.9965907335262766952865831626695580780506}
#define T_2187_520 {0.0767763180522961635743328656644735019654,-0.9970483423517300103355864848708733916283}
#define T_2187_521 {0.0739115152005153791536784524396352935582,-0.9972648033099152931058029025734867900610}
#define T_2187_523 {0.0681801029619171494733365079810027964413,-0.9976730293839271013212055549956858158112}
#define T_2187_524 {0.0653135408818939222630461927110445685685,-0.9978647911302759299090325839642900973558}
#define T_2187_526 {0.0595788231025147635433469872623390983790,-0.9982236041277120497383634756261017173529}
#define T_2187_527 {0.0567107147372368017301802467500237980857,-0.9983906524171747287610401144775096327066}
#define T_2187_529 {0.0509731174214343371597912835113675100729,-0.9987000256835586453618702762469183653593}
#define T_2187_530 {0.0481036758287553753432597147821070393547,-0.9988423481069282905409068007429596036673}
#define T_2187_532 {0.0423636251947940578599371974632958881557,-0.9991022586604211275229658895113971084356}
#define T_2187_533 {0.0394930635316068090467922502284636721015,-0.9992198446452554838614901200344320386648}
#define T_2187_535 {0.0337509859799961786652744422099203802645,-0.9994302731783634152762374469602946192026}
#define T_2187_536 {0.0308795174863979796087143370186822721735,-0.9995231139897702288266145842499099671841}
#define T_2187_538 {0.0251358395682174558249943885357424733229,-0.9996840448707785542481474294618237763643}
#define T_2187_539 {0.0222636775516696604204636145141193992458,-0.9997521336120644974698734586127102375031}
#define T_2187_541 {0.0165188259368821283024075796674878802150,-0.9998635548861989352786849849508143961430}
#define T_2187_542 {0.0136461837563645500825959544499710318632,-0.9999068864993817529196462601248640567064}
#define T_2187_544 {0.0079005852021211200875150382216816069558,-0.9999687898896965077000231758574955165386}
#define T_2187_545 {0.0050276762522826262333253133363086817553,-0.9999873611558809383126344982883892953396}
#define T_2187_547 {-0.0007182424287790828898100925492542501161,-0.9999997420638734313413920062885154038668}
#define T_2187_548 {-0.0035912047334726291715478740940170609974,-0.9999935516034902382997984204848762601614}
#define T_2187_550 {-0.0093370167049343314596976384223125933204,-0.9999564091094430562378647664445452392101}
#define T_2187_551 {-0.0122098189460535938577478987099311780185,-0.9999254573823513903008119996229652315378}
#define T_2187_553 {-0.0179550973794239399072836249615647830069,-0.9998387942454000087977306066022720187902}
#define T_2187_554 {-0.0208275261504299244452731443288939772174,-0.9997830835508536573286164639284834265709}
#define T_2187_556 {-0.0265718442568515234025738891432411037385,-0.9996469062087821599860149035521317273378}
#define T_2187_557 {-0.0294436861789485262996812764413334662095,-0.9995664406852581285178871439711656421423}
#define T_2187_559 {-0.0351866172409020100397825103755167219788,-0.9993807592540203676989563064125832170248}
#define T_2187_560 {-0.0380576589788884783738254213858454022557,-0.9992755448789121253128087118966504931450}
#define T_2187_562 {-0.0437987763818912939628447134055022615939,-0.9990403731518807672884463499940466135740}
#define T_2187_563 {-0.0466688046600074735170693429608945734799,-0.9989104177410534912695538878324441611767}
#define T_2187_565 {-0.0524076819243049774055265288552618585527,-0.9986257731879950583220306725706905126572}
#define T_2187_566 {-0.0552764835420761352358098861259350087494,-0.9984710863952058756964902386243920773268}
#define T_2187_568 {-0.0610126943543227232003012261429830687121,-0.9981369901609828954036629511392675340176}
#define T_2187_569 {-0.0638800562023967566371851489748223684728,-0.9979575834771629017083682811062317341566}
#define T_2187_571 {-0.0696131744473246216742268188681919127703,-0.9975740603801636074976499912736471742392}
#define T_2187_572 {-0.0724788835233029504756530059239594265819,-0.9973699471325649934527746154344640672207}
#define T_2187_574 {-0.0782084833153760816681909773251391015947,-0.9969370256628592441572322968568187206984}
#define T_2187_575 {-0.0810723267396365188108831034696777351201,-0.9967082210140646436613565128936897963285}
#define T_2187_577 {-0.0867979824546877276603140671795699745417,-0.9962259333312879494570779570494778454304}
#define T_2187_578 {-0.0896597474861983295690848194681166205555,-0.9959724542780845624179164587985724210739}
#define T_2187_580 {-0.0953810337930467433409376099007204174995,-0.9954408362090484407858070881047751754522}
#define T_2187_581 {-0.0982405078451692725938215744463377632201,-0.9951627015811651544296978499914985150099}
#define T_2187_583 {-0.1039569997372161436199888839837512932718,-0.9945817926171967027215714551857672631741}
#define T_2187_584 {-0.1068139703934980894173278898051648866385,-0.9942790230759054326270529600151348859072}
#define T_2187_586 {-0.1125252432202985264364514250701176933944,-0.9936488663699126755446400238724891096354}
#define T_2187_587 {-0.1153794982502525240386503924128192011267,-0.9933214844064935933332094464276451617479}
#define T_2187_589 {-0.1210851277490606336950662580420612357557,-0.9926421267697607131452741668908856809139}
#define T_2187_590 {-0.1239364551239300060725412322426564060152,-0.9922901567038312498070240508241113275290}
#define T_2187_592 {-0.1296360174512153629056143699926906265318,-0.9915616486025405906801211131096351891756}
#define T_2187_593 {-0.1324842053597247437668471548022353090346,-0.9911851165802492147349767037667334079742}
#define T_2187_595 {-0.1381772771226576490555260079418076202273,-0.9904075121317327257131069018214475363493}
#define T_2187_596 {-0.1410221139867473549855958481202833354473,-0.9900064461238162749623370473273098468781}
#define T_2187_598 {-0.1467082722746506362465623851676355116069,-0.9891798030925352813724771294801030308008}
#define T_2187_599 {-0.1495495467651938858999471904098754748702,-0.9887542328922416245973181503359228372574}
#define T_2187_601 {-0.1552283691809588916932227675715694203973,-0.9878786126854958160592445892689283937216}
#define T_2187_602 {-0.1580658702334602760952719791021081618965,-0.9874285699063699572874952536949422210455}
#define T_2187_604 {-0.1637369349249247207911395207702298648655,-0.9865040375697359253948093282815534621477}
#define T_2187_605 {-0.1665704517551992724921916533276089467108,-0.9860295556432722152706560336810071021318}
#define T_2187_607 {-0.1722333374464845301421433987343334592879,-0.9850561798557712078761028351436834782362}
#define T_2187_608 {-0.1750626595663157814009025514678796753287,-0.9845572940289296637317306704062502831221}
#define T_2187_610 {-0.1807169455891214915332909640710568055511,-0.9835351470979257770821391204663086682558}
#define T_2187_611 {-0.1835418628218977166177694471116410568357,-0.9830118944305138439787583592988085001707}
#define T_2187_613 {-0.1891871291467511484452046488513587974012,-0.9819410522863429857665096278651617467403}
#define T_2187_614 {-0.1920074316430782912501484815948060713708,-0.9813934716482622944155878030869644135237}
#define T_2187_616 {-0.1976432589105363013537441929656779393554,-0.9802740138385913626350998129055369645357}
#define T_2187_617 {-0.2004587371638266168893949270568555220962,-0.9797021459069505944228239968651905655861}
#define T_2187_619 {-0.2060847067156278689115112001672969199717,-0.9785341555908683153219840278325136750937}
#define T_2187_620 {-0.2088951515776633072185575201729079708457,-0.9779380428469612862585336188203655183315}
#define T_2187_622 {-0.2145108454878282833178104738180991262197,-0.9767216067888009334296839369926601648331}
#define T_2187_623 {-0.2173160481842969782295682534822844900191,-0.9761012935149508962240361142903566360474}
#define T_2187_625 {-0.2229210492901737561410868693201337009668,-0.9748365020778447798122101630724500864744}
#define T_2187_626 {-0.2257208014361788694923660614222171716392,-0.9741920343541149440724780106393154710531}
#define T_2187_628 {-0.2313146933694320561691881721344543620944,-0.9728789814932818913462142518255859613419}
#define T_2187_629 {-0.2341087869849717006953682130188099108636,-0.9722104071940523839501224756531883031130}
#define T_2187_631 {-0.2396911542025124131072288946597836911678,-0.9708491904498182112348558803205378353596}
#define T_2187_632 {-0.2424793817279295160549423826523707248271,-0.9701565592402295878926565819710958749056}
#define T_2187_634 {-0.2480498095427841054316786539857275784016,-0.9687472797307812300005025463178753852844}
#define T_2187_635 {-0.2508319638541849361246249827672727406025,-0.9680306430630452041441458277404308319092}
#define T_2187_637 {-0.2563900384663000409091182518750429153442,-0.9665734054769193894784962139965500682592}
#define T_2187_638 {-0.2591659128909403753127094205410685390234,-0.9658328165864967784770556136209052056074}
#define T_2187_640 {-0.2647112214179221933996188909077318385243,-0.9643277291748028057227770659665111452341}
#define T_2187_641 {-0.2674806097495602830171890218480257317424,-0.9635632430764486944241298260749317705631}
#define T_2187_643 {-0.2730127402573453987422169575438601896167,-0.9620104176448274202471111493650823831558}
#define T_2187_644 {-0.2757754367715598009525024281174410134554,-0.9612220911285047630912004024139605462551}
#define T_2187_646 {-0.2812939783050159570088055716041708365083,-0.9596216430288226906242243785527534782887}
#define T_2187_647 {-0.2840497777744878660222127564338734373450,-0.9588095346554831310825761647720355540514}
#define T_2187_649 {-0.2895543203879418214796714892145246267319,-0.9571615827772639306658675195649266242981}
#define T_2187_650 {-0.2923030180977003733566732535109622403979,-0.9563257528744980584534118861483875662088}
#define T_2187_652 {-0.2977931528853907106046960961975855752826,-0.9546304196360905214291392439918126910925}
#define T_2187_653 {-0.3005345446480204296690885712450835853815,-0.9537709302936460131761009506590198725462}
#define T_2187_655 {-0.3060098637744731453480540039890911430120,-0.9520283416331303261159746398334391415119}
#define T_2187_656 {-0.3087437459452818666605367070587817579508,-0.9511452566983000789235802585608325898647}
#define T_2187_658 {-0.3142038426756065816469742912886431440711,-0.9493555420641324182895459671271964907646}
#define T_2187_659 {-0.3169300121677531834052388148847967386246,-0.9484489271370113439019178258604370057583}
#define T_2187_661 {-0.3223744808978574738489442097488790750504,-0.9466122194784075682960633457696530967951}
#define T_2187_662 {-0.3250927351974384760247005488054128363729,-0.9456821419070194911782323288207408040762}
#define T_2187_664 {-0.3305211714841581605028864032647106796503,-0.9437985776640795965164443259709514677525}
#define T_2187_665 {-0.3332313086652511913143825950101017951965,-0.9428451065393742558384815311001148074865}
#define T_2187_667 {-0.3386433092563945757014209902990842238069,-0.9409148256329463722025252536695916205645}
#define T_2187_668 {-0.3413451279960587059214560667896876111627,-0.9399380317836673048859097434615250676870}
#define T_2187_670 {-0.3467402908603621769501046401273924857378,-0.9379611776049536775445858438615687191486}
#define T_2187_671 {-0.3494335904535930681369393369095632806420,-0.9369611335923762052146912537864409387112}
#define T_2187_673 {-0.3548115148105860372496067611791659146547,-0.9349378529922817149255820368125569075346}
#define T_2187_674 {-0.3574960951852254043004109007597435265779,-0.9339146331048230331717263652535621076822}
#define T_2187_676 {-0.3628563815350022703221100073278648778796,-0.9318450763830460337189265374036040157080}
#define T_2187_677 {-0.3655320432666003260813170072651701048017,-0.9307987566307468485504728050727862864733}
#define T_2187_679 {-0.3708742934194975693351636891748057678342,-0.9286830775246140978751441252825316041708}
#define T_2187_680 {-0.3735408377461271745012538758601294830441,-0.9276137356334916983513494415092281997204}
#define T_2187_682 {-0.3788646548523026957866477459901943802834,-0.9254520913065383824758214359462726861238}
#define T_2187_683 {-0.3815218836893245479835456990258535370231,-0.9243598067128132589331812596356030553579}
#define T_2187_685 {-0.3868268722682379756605541842873208224773,-0.9221523577431075535670856879733037203550}
#define T_2187_686 {-0.3894745882230152278502544049842981621623,-0.9210372115873021181542412705312017351389}
#define T_2187_688 {-0.3947603541928060844057313261146191507578,-0.9187841219555169525179394440783653408289}
#define T_2187_689 {-0.3973983605793678375306399175315164029598,-0.9176461970764281383949878545536193996668}
#define T_2187_691 {-0.4026645112861299558026928480103379115462,-0.9153476341536597171710809561773203313351}
#define T_2187_692 {-0.4052926121397819048119970375410048291087,-0.9141870150822053453509852261049672961235}
#define T_2187_694 {-0.4105387563867318734267541913141030818224,-0.9118431496175400940984445696813054382801}
#define T_2187_695 {-0.4131567564786137736199123082769801840186,-0.9106599225704793409974513451743405312300}
#define T_2187_697 {-0.4183825045551509691499347809440223500133,-0.9082709286783096080952759621141012758017}
#define T_2187_698 {-0.4209902094067392019915985201805597171187,-0.9070651815518385729930628258443903177977}
#define T_2187_700 {-0.4261951731173955759679472521384013816714,-0.9046312366989287534480013164284173399210}
#define T_2187_701 {-0.4287923890149498151735940609796671196818,-0.9034030590621507927906463919498492032290}
#define T_2187_703 {-0.4339761817082270489720485784346237778664,-0.9009243440544538739089830414741300046444}
#define T_2187_704 {-0.4365627157171805827751143169734859839082,-0.8996738271427262567669913551071658730507}
#define T_2187_706 {-0.4417249523142724454416452317673247307539,-0.8971505261119527840918408401194028556347}
#define T_2187_707 {-0.4443006122935642121518640124122612178326,-0.8958777628201092246840175903344061225653}
#define T_2187_709 {-0.4494409093169621782770661866379668936133,-0.8933100632100492433096405875403434038162}
#define T_2187_710 {-0.4520055039333100710408075428858865052462,-0.8920151480854988657043236344179604202509}
#define T_2187_712 {-0.4571234795352902557930008242692565545440,-0.8894032406380971700343707198044285178185}
#define T_2187_713 {-0.4596768182774041422433697334781754761934,-0.8880862698738013483179543072765227407217}
#define T_2187_715 {-0.4647720922683927224916544673760654404759,-0.8854303486149888158251997083425521850586}
#define T_2187_716 {-0.4673139854611269017325980712485034018755,-0.8840914200423153346264371066354215145111}
#define T_2187_718 {-0.4723861793379424134364796827867394313216,-0.8813916822675951223686752200592309236526}
#define T_2187_719 {-0.4749164381563854564483051490242360159755,-0.8800308953490508789840873760113026946783}
#define T_2187_721 {-0.4799651751303563584905020888982107862830,-0.8772875416088423694560560761601664125919}
#define T_2187_722 {-0.4824836116138579988898982264799997210503,-0.8759049974306847285987487339298240840435}
#define T_2187_724 {-0.4875085166388121171721081736905034631491,-0.8731182315154260020761967098223976790905}
#define T_2187_725 {-0.4900149437049460821036461766198044642806,-0.8717140327801534693819007770798634737730}
#define T_2187_727 {-0.4950156435050710457268507980188587680459,-0.8688840617051624137801013603166211396456}
#define T_2187_728 {-0.4975098749635323280848808735754573717713,-0.8674583127238855162488562200451269745827}
#define T_2187_730 {-0.5024859980611046106346861961355898529291,-0.8645853467139814618747095664730295538902}
#define T_2187_731 {-0.5049678486275408495487226900877431035042,-0.8631381533986740572927942594105843454599}
#define T_2187_733 {-0.5099190253705208064616272167768329381943,-0.8602224058725616018250548222567886114120}
#define T_2187_734 {-0.5123883106802957776437779102707281708717,-0.8587538757281929502340744875255040824413}
#define T_2187_736 {-0.5173141732697874584090413918602280318737,-0.8557955632826079739317037820001132786274}
#define T_2187_737 {-0.5197707098916770629415395887917838990688,-0.8543058053991569034124609061109367758036}
#define T_2187_739 {-0.5246708924092501336033933512226212769747,-0.8513051477927765509079449657292570918798}
#define T_2187_740 {-0.5271144978590684981867298120050691068172,-0.8497942728371273846121880524151492863894}
#define T_2187_742 {-0.5319886362939404422789380078029353171587,-0.8467514929742453455574491272273007780313}
#define T_2187_743 {-0.5344191290480956313402316482097376137972,-0.8452196131819675883889431133866310119629}
#define T_2187_745 {-0.5392668613241726749407689567306078970432,-0.8421349370959356761545677727553993463516}
#define T_2187_746 {-0.5416840608331512374462590742041356861591,-0.8405821662629459067872517152864020317793}
#define T_2187_748 {-0.5465050268359249452387871315295342355967,-0.8374558230993829344157575178542174398899}
#define T_2187_749 {-0.5489087535377041859874225337989628314972,-0.8358822765734921222957609643344767391682}
#define T_2187_751 {-0.5537025951410026181065404671244323253632,-0.8327144985732618520657410954299848526716}
#define T_2187_752 {-0.5560926704743892612370359529450070112944,-0.8311202932456061009958148133591748774052}
#define T_2187_754 {-0.5608590315669804704512557691487018018961,-0.8279113157275655998645902400312479585409}
#define T_2187_755 {-0.5632352779848753820957085736154112964869,-0.8262965700239232047508153300441335886717}
#define T_2187_757 {-0.5679738044969212529267110767250414937735,-0.8230466313674413836309895486920140683651}
#define T_2187_758 {-0.5703360454795080025647280308476183563471,-0.8214114652394356452802526291634421795607}
#define T_2187_760 {-0.5750463854088665449637574056396260857582,-0.8181208068666859789530576563265640288591}
#define T_2187_761 {-0.5773944454767246936555125103041063994169,-0.8164653417828742210105019694310612976551}
#define T_2187_763 {-0.5820762489150981267016504716593772172928,-0.8131342081409002053860035630350466817617}
#define T_2187_764 {-0.5844099536422385776646137856005225330591,-0.8114585670777507697692954025114886462688}
#define T_2187_766 {-0.5890628728011666481734209810383617877960,-0.8080872056203071140956240014929790049791}
#define T_2187_767 {-0.5913820488279888376581538977916352450848,-0.8063915130530642239037319995986763387918}
#define T_2187_769 {-0.5960057380646842650762096127436961978674,-0.8029801742222349991706664695811923593283}
#define T_2187_770 {-0.5983102131108544163851092889672145247459,-0.8012645561156713780448512807197403162718}
#define T_2187_772 {-0.6029043289538791317028199046035297214985,-0.7978134933232657877155702408344950526953}
#define T_2187_773 {-0.6051939318311279070172759020351804792881,-0.7960780771223260332547511097800452262163}
#define T_2187_775 {-0.6097581330059075321869954677822533994913,-0.7925875467310535826825912408821750432253}
#define T_2187_776 {-0.6120326936307467491360512212850153446198,-0.7908324613513866285785525178653188049793}
#define T_2187_778 {-0.6165666410849226508616993669420480728149,-0.7873027226558131363987058648490346968174}
#define T_2187_779 {-0.6188259904912802866761012410279363393784,-0.7855280984741958016925877927860710769892}
#define T_2187_781 {-0.6233293474198957628829020904959179461002,-0.7819594136814818075009725362178869545460}
#define T_2187_782 {-0.6255733177716673587553941615624353289604,-0.7801653825261336550056512351147830486298}
#define T_2187_784 {-0.6300457496421875136505263981234747916460,-0.7765580167365564445702830198570154607296}
#define T_2187_785 {-0.6322741742457038682800884998869150876999,-0.7747447118773469476593618310289457440376}
#define T_2187_787 {-0.6367153488228664004466850201424676924944,-0.7710989330646071948649478144943714141846}
#define T_2187_788 {-0.6389280621392764425436894271115306764841,-0.7692664892031556567175698546634521335363}
#define T_2187_790 {-0.6433376495097715697113471833290532231331,-0.7655825681944712357562821125611662864685}
#define T_2187_791 {-0.6455344871673397433298191572248470038176,-0.7637311214541407933253935880202334374189}
#define T_2187_793 {-0.6499121597643181535985945629363413900137,-0.7600093319101282052230317276553250849247}
#define T_2187_794 {-0.6520929585706343178941324367769993841648,-0.7581390198259135848601886209507938474417}
#define T_2187_796 {-0.6564383911980401498098558477067854255438,-0.7543796382202589967391759273596107959747}
#define T_2187_797 {-0.6586029891521428814016303476819302886724,-0.7524905997285695757881285317125730216503}
#define T_2187_799 {-0.6629158590088712887933297679410316050053,-0.7486939053274911382018785843683872371912}
#define T_2187_800 {-0.6650640953132815891279960851534269750118,-0.7467862807558306448285634360217954963446}
#define T_2187_802 {-0.6693440820171580041275660732935648411512,-0.7429525555973329753456368962361011654139}
#define T_2187_803 {-0.6714757970898246330904157730401493608952,-0.7410264866538743833146440920245368033648}
#define T_2187_805 {-0.6757225827014042840445995352638419717550,-0.7371560155267973257764424488414078950882}
#define T_2187_806 {-0.6778376181875580552826932034804485738277,-0.7352116452898568299545445370313245803118}
#define T_2187_808 {-0.6820508872337441852451433987880591303110,-0.7313047157127200437187752868339885026217}
#define T_2187_809 {-0.6841490860176615562693314132047817111015,-0.7293421886201280068817709434370044618845}
#define T_2187_811 {-0.6883285255151405657159102702280506491661,-0.7253990908197724962747088284231722354889}
#define T_2187_812 {-0.6904097317318146354025998334691394120455,-0.7234185526581439207305379568424541503191}
#define T_2187_814 {-0.6945550312103059287238693286781199276447,-0.7194395795481723920872241251345258206129}
#define T_2187_815 {-0.6966190902570253973280500758846756070852,-0.7174411774420773602045642292068805545568}
#define T_2187_817 {-0.7007299417823446008313226229802239686251,-0.7134266246010951828537827168474905192852}
#define T_2187_818 {-0.7027767003301782500201966286113020032644,-0.7114105070021293775184290097968187183142}
#define T_2187_820 {-0.7068527985271123581512142663996201008558,-0.7073606726517877030246950198488775640726}
#define T_2187_821 {-0.7088821045322990510584304502117447555065,-0.7053269893275448954028661319171078503132}
#define T_2187_823 {-0.7129231466072910583520183536165859550238,-0.7012421743103868232438458107935730367899}
#define T_2187_824 {-0.7149348493225342604517891231807880103588,-0.6991910763333333278524150955490767955780}
#define T_2187_826 {-0.7189405350861767240999711248150561004877,-0.6950715840904460041116408319794572889805}
#define T_2187_827 {-0.7209344850718429897895589419931638985872,-0.6930032238266981003960154339438304305077}
#define T_2187_829 {-0.7249045169611768590911538012733217328787,-0.6888493603751714156047114556713495403528}
#define T_2187_830 {-0.7268805660963968406917956599500030279160,-0.6867638914731769572696862269367557018995}
#define T_2187_832 {-0.7308146491970166636065187049098312854767,-0.6825759653833713969106611330062150955200}
#define T_2187_833 {-0.7327726506906884207381835949490778148174,-0.6804735427624958310488523238745983690023}
#define T_2187_835 {-0.7366704927586497086977601611579302698374,-0.6762518651351198117893659400579053908587}
#define T_2187_836 {-0.7386103011603428747378075058804824948311,-0.6741326449741382731417616014368832111359}
#define T_2187_838 {-0.7424716126438716257140981724660377949476,-0.6698775294171380734198351092345546931028}
#define T_2187_839 {-0.7443930838546325423621397021634038537741,-0.6677416691426334427461597442743368446827}
#define T_2187_841 {-0.7482175779156345907239256121101789176464,-0.6634534317478969489556561711651738733053}
#define T_2187_842 {-0.7501205691986903012491438857978209853172,-0.6613010900225652077821791863243561238050}
#define T_2187_844 {-0.7539079617340592731622450628492515534163,-0.6569800493424410303688887324824463576078}
#define T_2187_845 {-0.7557923317254211514892858758685179054737,-0.6548113860533053554036087007261812686920}
#define T_2187_847 {-0.7595423413881428054139632877195253968239,-0.6504578630769389802068758399400394409895}
#define T_2187_848 {-0.7614079501071077116236551773909013718367,-0.6482730393234722443551731885236222296953}
#define T_2187_850 {-0.7651202983271602198200866951083298772573,-0.6438873574529612175965098685992415994406}
#define T_2187_851 {-0.7669670071867086269534752318577375262976,-0.6416865355351187849564098542032297700644}
#define T_2187_853 {-0.7706414181917558003931389976060017943382,-0.6372690205614889302765391221328172832727}
#define T_2187_854 {-0.7724690900088472256257432491111103445292,-0.6350523639676523002250974059279542416334}
#define T_2187_856 {-0.7761052908447246823087084521830547600985,-0.6306033440466560779924520829808898270130}
#define T_2187_857 {-0.7779137898504882020489503702265210449696,-0.6283710174414878224524727556854486465454}
#define T_2187_859 {-0.7815115104014794811249089434568304568529,-0.6238908230692276069007107253128197044134}
#define T_2187_860 {-0.7833007022512991079921107484551612287760,-0.6216429922814393771446361824928317219019}
#define T_2187_862 {-0.7868596752602015076405450599850155413151,-0.6171319562698162064506846036238130182028}
#define T_2187_863 {-0.7886294270436963183001921606773976236582,-0.6148687882798502535308671212987974286079}
#define T_2187_865 {-0.7921493881316739038567220632103271782398,-0.6103272457318407173687546674045734107494}
#define T_2187_866 {-0.7938995683825712523784545737726148217916,-0.6080489086594655923079244530526921153069}
#define T_2187_868 {-0.7973802560687943685735490362276323139668,-0.6034771969442290773244508272910024970770}
#define T_2187_869 {-0.7991107347746956302003695782332215458155,-0.6011838600360509543563125589571427553892}
#define T_2187_871 {-0.8025518904957653631981884245760738849640,-0.5965823187638676916577651354600675404072}
#define T_2187_872 {-0.8042625391078040975045837512880098074675,-0.5942741523807575365623279139981605112553}
#define T_2187_874 {-0.8076639072369591332289928686805069446564,-0.5896431233778010039259243058040738105774}
#define T_2187_875 {-0.8093545986793505564449446865182835608721,-0.5873202989822396968833118080510757863522}
#define T_2187_877 {-0.8127159265454567682596120903326664119959,-0.5826601262651835977379732867120765149593}
#define T_2187_878 {-0.8143865352249370914705650648102164268494,-0.5803228164085246776338067320466507226229}
#define T_2187_880 {-0.8177075731312573037001811826485209167004,-0.5756338461589879385016388368967454880476}
#define T_2187_881 {-0.8193579749464140471459927539399359375238,-0.5732822244686395229962272424018010497093}
#define T_2187_883 {-0.8226384761891566421709853784705046564341,-0.5685648050074699755285223545797634869814}
#define T_2187_884 {-0.8242685485396469280416908986808266490698,-0.5661990461739967450682797789340838789940}
#define T_2187_886 {-0.8275082694262922977657126466510817408562,-0.5614535279353962682336032230523414909840}
#define T_2187_887 {-0.8291178912219508978509452390426304191351,-0.5590738076995427352500200868234969675541}
#define T_2187_889 {-0.8323165910893542962512015037646051496267,-0.5543005432050347458527994604082778096199}
#define T_2187_890 {-0.8339056427591881037741927684692200273275,-0.5519070383446702532381777928094379603863}
#define T_2187_892 {-0.8370630839914572352000732280430383980274,-0.5471063821769133195260792490444146096706}
#define T_2187_893 {-0.8386314474925281592376791195420082658529,-0.5446992704939001006536614113429095596075}
#define T_2187_895 {-0.8417473955386743922346681756607722491026,-0.5398715792703467908353331949911080300808}
#define T_2187_896 {-0.8432949543648681212104634141724091023207,-0.5374510395773320903245462432096246629953}
#define T_2187_898 {-0.8463691777562305507132123238989152014256,-0.5325966719237383850682476804649922996759}
#define T_2187_899 {-0.8478958169469108518967459531268104910851,-0.5301628840308708623396682924067135900259}
#define T_2187_901 {-0.8509280873143505452560475532663986086845,-0.5252822005546552430743645345501136034727}
#define T_2187_902 {-0.8524336934628996553797719570866320282221,-0.5228353452562281011850586764921899884939}
#define T_2187_904 {-0.8554237855537641932457404436718206852674,-0.5179287085196838669176599978527519851923}
#define T_2187_905 {-0.8569082468160068577489596464147325605154,-0.5154689675807045956545948683924507349730}
#define T_2187_907 {-0.8598559385108635044758784715668298304081,-0.5105367420740666295486676062864717096090}
#define T_2187_908 {-0.8613191446133755535541354220185894519091,-0.5080642982167543619809180199808906763792}
#define T_2187_910 {-0.8642242169425111697478314454201608896255,-0.5031068503311233452990336445509456098080}
#define T_2187_911 {-0.8656660591908109658731973468093201518059,-0.5006218872213352710787148680537939071655}
#define T_2187_913 {-0.8685282963504983300140338542405515909195,-0.4956395852214599551111007258441532030702}
#define T_2187_914 {-0.8699486676371215310155093902722001075745,-0.4931422874550479562572036229539662599564}
#define T_2187_916 {-0.8727678570056501827778561164450366050005,-0.4881355014519686008611643046606332063675}
#define T_2187_917 {-0.8741666518181057110581377855851314961910,-0.4856260545410662765597464840539032593369}
#define T_2187_919 {-0.8769425839715770942817130162438843399286,-0.4805951564646209761555439854419091716409}
#define T_2187_920 {-0.8783196984001856444379541244416031986475,-0.4780737468238628884442675825994228944182}
#define T_2187_922 {-0.8810521671280692190819650022604037076235,-0.4730191103950586728466021213534986600280}
#define T_2187_923 {-0.8824074988736820834844820637954398989677,-0.4704859253277325903397354522894602268934}
#define T_2187_925 {-0.8850963011941348490552172734169289469719,-0.4654079260309834653597249598533380776644}
#define T_2187_926 {-0.8864297495757328393395368948404211550951,-0.4628631537151164376808765155146829783916}
#define T_2187_928 {-0.8890746857506770517431959888199344277382,-0.4577621687703505304334328229742823168635}
#define T_2187_929 {-0.8903861517128502933715594735986087471247,-0.4552059982447300146013446919823763892055}
#define T_2187_931 {-0.8929870252628112625714607020199764519930,-0.4500824065793677108970882727589923888445}
#define T_2187_932 {-0.8942764113831168648616198879608418792486,-0.4475150277294990819321185426815645769238}
#define T_2187_934 {-0.8968330291018187239160397439263761043549,-0.4423692099503043206887298310903133824468}
#define T_2187_935 {-0.8981002395980182129164859361480921506882,-0.4397908134943046554177215057279681786895}
#define T_2187_937 {-0.9006124115667358820402910168922971934080,-0.4346231518591116005367780417145695537329}
#define T_2187_938 {-0.9018573523039102868281702285457868129015,-0.4320339293335427321984809623245382681489}
#define T_2187_940 {-0.9043248919055778545228463372041005641222,-0.4268448077228595982646197626309003680944}
#define T_2187_941 {-0.9055474704031206689691657629737164825201,-0.4242449514684993872037921391893178224564}
#define T_2187_943 {-0.9079701943361940807974974632088560611010,-0.4190347553569916949633977765188319608569}
#define T_2187_944 {-0.9091703197746808795542960979219060391188,-0.4164244585045462354599976606550626456738}
#define T_2187_946 {-0.9115480480667549345596967214078176766634,-0.4111935749324021061035239199554780498147}
#define T_2187_947 {-0.9127256312946900873583899738150648772717,-0.4085730313881587583146881570428377017379}
#define T_2187_949 {-0.9150581873158672996382279052340891212225,-0.4033218489323373012744866628054296597838}
#define T_2187_950 {-0.9162131408563067846984040443203411996365,-0.4006912533637604911795904172322480008006}
#define T_2187_952 {-0.9185003513323183321759302089049015194178,-0.3954201621091263940677151822455925866961}
#define T_2187_953 {-0.9196325893893677605461789426044560968876,-0.3927797099303966810168731171870604157448}
#define T_2187_955 {-0.9218742844144454107180308710667304694653,-0.3874891014407426670373979504802264273167}
#define T_2187_956 {-0.9229837228796333725711065198993310332298,-0.3848389887982402446375829185853945091367}
#define T_2187_958 {-0.9251797359291310529627594405610579997301,-0.3795292560871998399640858679049415513873}
#define T_2187_959 {-0.9262662923876572307335663936100900173187,-0.3768696798449340246150995881180278956890}
#define T_2187_961 {-0.9284164603304210228174042640603147447109,-0.3715412173467861900455488921579672023654}
#define T_2187_962 {-0.9294800540672782940276874796836636960506,-0.3688723750717711191704495377052808180451}
#define T_2187_964 {-0.9315842171777648506036939579644240438938,-0.3635255786121399101951112697861390188336}
#define T_2187_965 {-0.9326247691837353803734345092379953712225,-0.3608476685597183375442398300947388634086}
#define T_2187_967 {-0.9346827711538769900556644643074832856655,-0.3554829353261689250942367834795732051134}
#define T_2187_968 {-0.9357002041314012030781555040448438376188,-0.3527961564252848347678082063794136047363}
#define T_2187_970 {-0.9377118920822176129092895280336961150169,-0.3474138849378181070903792715398594737053}
#define T_2187_971 {-0.9387061304511364889791025234444532543421,-0.3447184367762392009915117796481354162097}
#define T_2187_973 {-0.9406713549440908206378253453294746577740,-0.3393190268576879997652895326609723269939}
#define T_2187_974 {-0.9416423248472600704417345696128904819489,-0.3366151096671791687064967391052050516009}
#define T_2187_976 {-0.9435609398953606063997767705586738884449,-0.3311989624135071030863741725625004619360}
#define T_2187_977 {-0.9445085692041376157490617515577469021082,-0.3284867770549564913729057025193469598889}
#define T_2187_979 {-0.9463804322827819026642259814252611249685,-0.3230542948054627161447172056796262040734}
#define T_2187_980 {-0.9473046506023835577892100445751566439867,-0.3203340427539603796347478237294126302004}
#define T_2187_982 {-0.9491296226599461594020112897851504385471,-0.3148856290613914477027890370663953945041}
#define T_2187_983 {-0.9500303613346777753534411203872878104448,-0.3121575123912630478351104557077633216977}
#define T_2187_985 {-0.9518083068028398985305216228880453854799,-0.3066935719918353342450245690997689962387}
#define T_2187_986 {-0.9526854989211960278439050853194203227758,-0.3039577933616308125230887071666074916720}
#define T_2187_988 {-0.9544162857250156895005943624710198491812,-0.2984787321449641761539339768205536529422}
#define T_2187_989 {-0.9552698661246501465882374759530648589134,-0.2957354947824033519765407618251629173756}
#define T_2187_991 {-0.9569533656923739917132820664846803992987,-0.2902417197613699761937766652408754453063}
#define T_2187_992 {-0.9577832709649407583185620751464739441872,-0.2874912274482456786550699234794592484832}
#define T_2187_994 {-0.9594193582375544204765560607484076172113,-0.2819831467287347570582767275482183322310}
#define T_2187_995 {-0.9602255267334176558335911977337673306465,-0.2792256037857749895181314059300348162651}
#define T_2187_997 {-0.9618140801739365475242493630503304302692,-0.2737036265363766984748394861526321619749}
#define T_2187_998 {-0.9625964520067503693567800837627146393061,-0.2709392378080663355000012870732462033629}
#define T_2187_1000 {-0.9641373536092473495173749142850283533335,-0.2654037742296765922667134418588830158114}
#define T_2187_1001 {-0.9648958706604046087207393611606676131487,-0.2626327450690408848998913526884280145168}
#define T_2187_1003 {-0.9663890059587764147508437417855020612478,-0.2570842063643896668878596756258048117161}
#define T_2187_1004 {-0.9671236118817257976232326655008364468813,-0.2543067426177392231778640052652917802334}
#define T_2187_1006 {-0.9685688699581961325080214919580612331629,-0.2487455409608440304314314062139601446688}
#define T_2187_1007 {-0.9692795101826281456425249416497536003590,-0.2459618489524837137150115040640230290592}
#define T_2187_1009 {-0.9706767836759873091523331822827458381653,-0.2403883974580314220048649076488800346851}
#define T_2187_1010 {-0.9713634054118879257444518771080765873194,-0.2375986839749334444960027212800923734903}
#define T_2187_1012 {-0.9727125905254679905098669223662000149488,-0.2320133966675918812949674929768661968410}
#define T_2187_1013 {-0.9733751427670399580804883044038433581591,-0.2292178689440345362715589772051316685975}
#define T_2187_1015 {-0.9746761392764252684983716790156904608011,-0.2236211607276966939483742180527769960463}
#define T_2187_1016 {-0.9753145728058776331437229600851424038410,-0.2208200264298700032927769143498153425753}
#define T_2187_1018 {-0.9765672840663504050695564728812314569950,-0.2152123130568326936362666401691967621446}
#define T_2187_1019 {-0.9771815514575538097474804999365005642176,-0.2124057802674119421748599734200979582965}
#define T_2187_1021 {-0.9783858844112728325725925060396548360586,-0.2067874783074917510727885883170529268682}
#define T_2187_1022 {-0.9789759400332835870273129330598749220371,-0.2039757555101798791596934279368724673986}
#define T_2187_1024 {-0.9801318052161975824532191836624406278133,-0.1983472823197681145224180454533779993653}
#define T_2187_1025 {-0.9806976052366465079757062994758598506451,-0.1955305783838086064463368529686704277992}
#define T_2187_1027 {-0.9818049167851393699280038163124118000269,-0.1898923520748679039105155652578105218709}
#define T_2187_1028 {-0.9823464191734883055318050537607632577419,-0.1870708762395288660140835190759389661252}
#define T_2187_1030 {-0.9834050948307582196150633535580709576607,-0.1814233156485337561392157113004941493273}
#define T_2187_1031 {-0.9839222593614223022484566172352060675621,-0.1785972775075645446740679744834778830409}
#define T_2187_1033 {-0.9849322204835914140730324106698390096426,-0.1729408021643880633000378566066501662135}
#define T_2187_1034 {-0.9854250087389271328675022232346236705780,-0.1701104116504495722406176128060906194150}
#define T_2187_1036 {-0.9863861803008843187612342262582387775183,-0.1644454417471984120080463753765798173845}
#define T_2187_1037 {-0.9868545556740432322939682308060582727194,-0.1616109091162682143139051049729459919035}
#define T_2187_1039 {-0.9877668662750170858188880629313644021749,-0.1559378654760687765712390273620258085430}
#define T_2187_1040 {-0.9882107939726653134115963439398910850286,-0.1530994012918222013652780333359260112047}
#define T_2187_1042 {-0.9890741758415280138194702885812148451805,-0.1474187053375595746196324853372061625123}
#define T_2187_1043 {-0.9894936228864309457620151988521683961153,-0.1445765204557279970387639878026675432920}
#define T_2187_1045 {-0.9903080118867326753218094381736591458321,-0.1388885941787405542413580405991524457932}
#define T_2187_1046 {-0.9907029471202047909983434692549053579569,-0.1360428997314478971603080026397947221994}
#define T_2187_1048 {-0.9914682827549383681287054059794172644615,-0.1303481656601796490058120525645790621638}
#define T_2187_1049 {-0.9918386768391572738678974019421730190516,-0.1274991730402584566572699031894444487989}
#define T_2187_1051 {-0.9925549022552520028739309054799377918243,-0.1217980542088713535875399429642129689455}
#define T_2187_1052 {-0.9929007276754384658801200203015469014645,-0.1189459750541593668904383207518549170345}
#define T_2187_1054 {-0.9935677896679835363613619847455993294716,-0.1132388949711082698490471898367104586214}
#define T_2187_1055 {-0.9938890207344451832582876704691443592310,-0.1103839411487269467349037199710437562317}
#define T_2187_1057 {-0.9945068697506417310094661843322683125734,-0.1046713237652991401738233889773255214095}
#define T_2187_1058 {-0.9948034826006812991749939101282507181168,-0.1018137073559150507229276172438403591514}
#define T_2187_1060 {-0.9953720727435240167579877379466779530048,-0.0960959770347370040299850302289996761829}
#define T_2187_1061 {-0.9956440453432121584498304400767665356398,-0.0932359103168073910516966407158179208636}
#define T_2187_1063 {-0.9961633343748981239684781030518934130669,-0.0875134918003209194559133266011485829949}
#define T_2187_1064 {-0.9964106465207099860847961281251627951860,-0.0846511872343245347360962682614626828581}
#define T_2187_1066 {-0.9968805958657769306086038341163657605648,-0.0789245056132347189148390498303342610598}
#define T_2187_1067 {-0.9971032291860932872396006132476031780243,-0.0760601758258892118869098908362502697855}
#define T_2187_1069 {-0.9975238039342845253187874732248019427061,-0.0703296565075865048877190588427765760571}
#define T_2187_1070 {-0.9977217418907562418439738394226878881454,-0.0674635142760533906836073470003611873835}
#define T_2187_1072 {-0.9980929107996144855619036206917371600866,-0.0617295829530121395456454536088131135330}
#define T_2187_1073 {-0.9982661386883912024714504696021322160959,-0.0588618411890906093053565939499094383791}
#define T_2187_1075 {-0.9985878741855792606330055605212692171335,-0.0531249238072464408100259447564894799143}
#define T_2187_1076 {-0.9987363791384016309393700794316828250885,-0.0502557955415571869228763546288973884657}
#define T_2187_1078 {-0.9990086573237505485067799781973008066416,-0.0445163182686655334308056808367837220430}
#define T_2187_1079 {-0.9991324283089063618135128308495040982962,-0.0416460166348257415647182710927154403180}
#define T_2187_1081 {-0.9993552289561907775450322333199437707663,-0.0359044058288039424908788532775361090899}
#define T_2187_1082 {-0.9994542567793339715720435378898400813341,-0.0330331440475946230828085958819428924471}
#define T_2187_1084 {-0.9996275633377750269303874119941610842943,-0.0272898262248498328641499455216035130434}
#define T_2187_1085 {-0.9997018406426091408079059874580707401037,-0.0244178175883766751530501437628117855638}
#define T_2187_1087 {-0.9998256402381036078708120840019546449184,-0.0186732193921220340770972256905224639922}
#define T_2187_1088 {-0.9998751615069280118675010271545033901930,-0.0158006772479710004553066227117597009055}
#define T_2187_1090 {-0.9999494449430044173965370646328665316105,-0.0100552254165323859402825235065392917022}
#define T_2187_1091 {-0.9999742064971245403270927454286720603704,-0.0071823631519211204171648788019410858396}
#define T_2187_1093 {-0.9999989682556269521285230439389124512672,-0.0014364844870368258245019177365975338034}
#define T_2187_1094 {-0.9999989682556269521285230439389124512672,0.0014364844870368258245019177365975338034}
#define T_2187_1096 {-0.9999742064971245403270927454286720603704,0.0071823631519211204171648788019410858396}
#define T_2187_1100 {-0.9998256402381036078708120840019546449184,0.0186732193921220340770972256905224639922}
#define T_2187_1102 {-0.9997018406426091408079059874580707401037,0.0244178175883766751530501437628117855638}
#define T_2187_1105 {-0.9994542567793339715720435378898400813341,0.0330331440475946230828085958819428924471}
#define T_2187_1106 {-0.9993552289561907775450322333199437707663,0.0359044058288039424908788532775361090899}
#define T_2187_1108 {-0.9991324283089063618135128308495040982962,0.0416460166348257415647182710927154403180}
#define T_2187_1112 {-0.9985878741855792606330055605212692171335,0.0531249238072464408100259447564894799143}
#define T_2187_1114 {-0.9982661386883912024714504696021322160959,0.0588618411890906093053565939499094383791}
#define T_2187_1115 {-0.9980929107996144855619036206917371600866,0.0617295829530121395456454536088131135330}
#define T_2187_1118 {-0.9975238039342845253187874732248019427061,0.0703296565075865048877190588427765760571}
#define T_2187_1120 {-0.9971032291860932872396006132476031780243,0.0760601758258892118869098908362502697855}
#define T_2187_1124 {-0.9961633343748981239684781030518934130669,0.0875134918003209194559133266011485829949}
#define T_2187_1126 {-0.9956440453432121584498304400767665356398,0.0932359103168073910516966407158179208636}
#define T_2187_1130 {-0.9945068697506417310094661843322683125734,0.1046713237652991401738233889773255214095}
#define T_2187_1132 {-0.9938890207344451832582876704691443592310,0.1103839411487269467349037199710437562317}
#define T_2187_1135 {-0.9929007276754384658801200203015469014645,0.1189459750541593668904383207518549170345}
#define T_2187_1136 {-0.9925549022552520028739309054799377918243,0.1217980542088713535875399429642129689455}
#define T_2187_1138 {-0.9918386768391572738678974019421730190516,0.1274991730402584566572699031894444487989}
#define T_2187_1142 {-0.9903080118867326753218094381736591458321,0.1388885941787405542413580405991524457932}
#define T_2187_1144 {-0.9894936228864309457620151988521683961153,0.1445765204557279970387639878026675432920}
#define T_2187_1145 {-0.9890741758415280138194702885812148451805,0.1474187053375595746196324853372061625123}
#define T_2187_1148 {-0.9877668662750170858188880629313644021749,0.1559378654760687765712390273620258085430}
#define T_2187_1150 {-0.9868545556740432322939682308060582727194,0.1616109091162682143139051049729459919035}
#define T_2187_1154 {-0.9849322204835914140730324106698390096426,0.1729408021643880633000378566066501662135}
#define T_2187_1156 {-0.9839222593614223022484566172352060675621,0.1785972775075645446740679744834778830409}
#define T_2187_1160 {-0.9818049167851393699280038163124118000269,0.1898923520748679039105155652578105218709}
#define T_2187_1162 {-0.9806976052366465079757062994758598506451,0.1955305783838086064463368529686704277992}
#define T_2187_1165 {-0.9789759400332835870273129330598749220371,0.2039757555101798791596934279368724673986}
#define T_2187_1166 {-0.9783858844112728325725925060396548360586,0.2067874783074917510727885883170529268682}
#define T_2187_1168 {-0.9771815514575538097474804999365005642176,0.2124057802674119421748599734200979582965}
#define T_2187_1172 {-0.9746761392764252684983716790156904608011,0.2236211607276966939483742180527769960463}
#define T_2187_1174 {-0.9733751427670399580804883044038433581591,0.2292178689440345362715589772051316685975}
#define T_2187_1175 {-0.9727125905254679905098669223662000149488,0.2320133966675918812949674929768661968410}
#define T_2187_1178 {-0.9706767836759873091523331822827458381653,0.2403883974580314220048649076488800346851}
#define T_2187_1180 {-0.9692795101826281456425249416497536003590,0.2459618489524837137150115040640230290592}
#define T_2187_1184 {-0.9663890059587764147508437417855020612478,0.2570842063643896668878596756258048117161}
#define T_2187_1186 {-0.9648958706604046087207393611606676131487,0.2626327450690408848998913526884280145168}
#define T_2187_1190 {-0.9618140801739365475242493630503304302692,0.2737036265363766984748394861526321619749}
#define T_2187_1192 {-0.9602255267334176558335911977337673306465,0.2792256037857749895181314059300348162651}
#define T_2187_1195 {-0.9577832709649407583185620751464739441872,0.2874912274482456786550699234794592484832}
#define T_2187_1196 {-0.9569533656923739917132820664846803992987,0.2902417197613699761937766652408754453063}
#define T_2187_1198 {-0.9552698661246501465882374759530648589134,0.2957354947824033519765407618251629173756}
#define T_2187_1202 {-0.9518083068028398985305216228880453854799,0.3066935719918353342450245690997689962387}
#define T_2187_1204 {-0.9500303613346777753534411203872878104448,0.3121575123912630478351104557077633216977}
#define T_2187_1205 {-0.9491296226599461594020112897851504385471,0.3148856290613914477027890370663953945041}
#define T_2187_1208 {-0.9463804322827819026642259814252611249685,0.3230542948054627161447172056796262040734}
#define T_2187_1210 {-0.9445085692041376157490617515577469021082,0.3284867770549564913729057025193469598889}
#define T_2187_1214 {-0.9406713549440908206378253453294746577740,0.3393190268576879997652895326609723269939}
#define T_2187_1216 {-0.9387061304511364889791025234444532543421,0.3447184367762392009915117796481354162097}
#define T_2187_1220 {-0.9346827711538769900556644643074832856655,0.3554829353261689250942367834795732051134}
#define T_2187_1222 {-0.9326247691837353803734345092379953712225,0.3608476685597183375442398300947388634086}
#define T_2187_1226 {-0.9284164603304210228174042640603147447109,0.3715412173467861900455488921579672023654}
#define T_2187_1228 {-0.9262662923876572307335663936100900173187,0.3768696798449340246150995881180278956890}
#define T_2187_1232 {-0.9218742844144454107180308710667304694653,0.3874891014407426670373979504802264273167}
#define T_2187_1234 {-0.9196325893893677605461789426044560968876,0.3927797099303966810168731171870604157448}
#define T_2187_1238 {-0.9150581873158672996382279052340891212225,0.4033218489323373012744866628054296597838}
#define T_2187_1240 {-0.9127256312946900873583899738150648772717,0.4085730313881587583146881570428377017379}
#define T_2187_1244 {-0.9079701943361940807974974632088560611010,0.4190347553569916949633977765188319608569}
#define T_2187_1246 {-0.9055474704031206689691657629737164825201,0.4242449514684993872037921391893178224564}
#define T_2187_1250 {-0.9006124115667358820402910168922971934080,0.4346231518591116005367780417145695537329}
#define T_2187_1252 {-0.8981002395980182129164859361480921506882,0.4397908134943046554177215057279681786895}
#define T_2187_1256 {-0.8929870252628112625714607020199764519930,0.4500824065793677108970882727589923888445}
#define T_2187_1258 {-0.8903861517128502933715594735986087471247,0.4552059982447300146013446919823763892055}
#define T_2187_1262 {-0.8850963011941348490552172734169289469719,0.4654079260309834653597249598533380776644}
#define T_2187_1264 {-0.8824074988736820834844820637954398989677,0.4704859253277325903397354522894602268934}
#define T_2187_1268 {-0.8769425839715770942817130162438843399286,0.4805951564646209761555439854419091716409}
#define T_2187_1270 {-0.8741666518181057110581377855851314961910,0.4856260545410662765597464840539032593369}
#define T_2187_1274 {-0.8685282963504983300140338542405515909195,0.4956395852214599551111007258441532030702}
#define T_2187_1276 {-0.8656660591908109658731973468093201518059,0.5006218872213352710787148680537939071655}
#define T_2187_1280 {-0.8598559385108635044758784715668298304081,0.5105367420740666295486676062864717096090}
#define T_2187_1282 {-0.8569082468160068577489596464147325605154,0.5154689675807045956545948683924507349730}
#define T_2187_1286 {-0.8509280873143505452560475532663986086845,0.5252822005546552430743645345501136034727}
#define T_2187_1288 {-0.8478958169469108518967459531268104910851,0.5301628840308708623396682924067135900259}
#define T_2187_1292 {-0.8417473955386743922346681756607722491026,0.5398715792703467908353331949911080300808}
#define T_2187_1294 {-0.8386314474925281592376791195420082658529,0.5446992704939001006536614113429095596075}
#define T_2187_1298 {-0.8323165910893542962512015037646051496267,0.5543005432050347458527994604082778096199}
#define T_2187_1300 {-0.8291178912219508978509452390426304191351,0.5590738076995427352500200868234969675541}
#define T_2187_1304 {-0.8226384761891566421709853784705046564341,0.5685648050074699755285223545797634869814}
#define T_2187_1306 {-0.8193579749464140471459927539399359375238,0.5732822244686395229962272424018010497093}
#define T_2187_1310 {-0.8127159265454567682596120903326664119959,0.5826601262651835977379732867120765149593}
#define T_2187_1312 {-0.8093545986793505564449446865182835608721,0.5873202989822396968833118080510757863522}
#define T_2187_1316 {-0.8025518904957653631981884245760738849640,0.5965823187638676916577651354600675404072}
#define T_2187_1318 {-0.7991107347746956302003695782332215458155,0.6011838600360509543563125589571427553892}
#define T_2187_1322 {-0.7921493881316739038567220632103271782398,0.6103272457318407173687546674045734107494}
#define T_2187_1324 {-0.7886294270436963183001921606773976236582,0.6148687882798502535308671212987974286079}
#define T_2187_1328 {-0.7815115104014794811249089434568304568529,0.6238908230692276069007107253128197044134}
#define T_2187_1330 {-0.7779137898504882020489503702265210449696,0.6283710174414878224524727556854486465454}
#define T_2187_1334 {-0.7706414181917558003931389976060017943382,0.6372690205614889302765391221328172832727}
#define T_2187_1336 {-0.7669670071867086269534752318577375262976,0.6416865355351187849564098542032297700644}
#define T_2187_1340 {-0.7595423413881428054139632877195253968239,0.6504578630769389802068758399400394409895}
#define T_2187_1342 {-0.7557923317254211514892858758685179054737,0.6548113860533053554036087007261812686920}
#define T_2187_1346 {-0.7482175779156345907239256121101789176464,0.6634534317478969489556561711651738733053}
#define T_2187_1348 {-0.7443930838546325423621397021634038537741,0.6677416691426334427461597442743368446827}
#define T_2187_1352 {-0.7366704927586497086977601611579302698374,0.6762518651351198117893659400579053908587}
#define T_2187_1354 {-0.7327726506906884207381835949490778148174,0.6804735427624958310488523238745983690023}
#define T_2187_1358 {-0.7249045169611768590911538012733217328787,0.6888493603751714156047114556713495403528}
#define T_2187_1360 {-0.7209344850718429897895589419931638985872,0.6930032238266981003960154339438304305077}
#define T_2187_1364 {-0.7129231466072910583520183536165859550238,0.7012421743103868232438458107935730367899}
#define T_2187_1366 {-0.7088821045322990510584304502117447555065,0.7053269893275448954028661319171078503132}
#define T_2187_1370 {-0.7007299417823446008313226229802239686251,0.7134266246010951828537827168474905192852}
#define T_2187_1372 {-0.6966190902570253973280500758846756070852,0.7174411774420773602045642292068805545568}
#define T_2187_1376 {-0.6883285255151405657159102702280506491661,0.7253990908197724962747088284231722354889}
#define T_2187_1378 {-0.6841490860176615562693314132047817111015,0.7293421886201280068817709434370044618845}
#define T_2187_1382 {-0.6757225827014042840445995352638419717550,0.7371560155267973257764424488414078950882}
#define T_2187_1384 {-0.6714757970898246330904157730401493608952,0.7410264866538743833146440920245368033648}
#define T_2187_1388 {-0.6629158590088712887933297679410316050053,0.7486939053274911382018785843683872371912}
#define T_2187_1390 {-0.6586029891521428814016303476819302886724,0.7524905997285695757881285317125730216503}
#define T_2187_1394 {-0.6499121597643181535985945629363413900137,0.7600093319101282052230317276553250849247}
#define T_2187_1396 {-0.6455344871673397433298191572248470038176,0.7637311214541407933253935880202334374189}
#define T_2187_1400 {-0.6367153488228664004466850201424676924944,0.7710989330646071948649478144943714141846}
#define T_2187_1402 {-0.6322741742457038682800884998869150876999,0.7747447118773469476593618310289457440376}
#define T_2187_1406 {-0.6233293474198957628829020904959179461002,0.7819594136814818075009725362178869545460}
#define T_2187_1408 {-0.6188259904912802866761012410279363393784,0.7855280984741958016925877927860710769892}
#define T_2187_1412 {-0.6097581330059075321869954677822533994913,0.7925875467310535826825912408821750432253}
#define T_2187_1414 {-0.6051939318311279070172759020351804792881,0.7960780771223260332547511097800452262163}
#define T_2187_1418 {-0.5960057380646842650762096127436961978674,0.8029801742222349991706664695811923593283}
#define T_2187_1420 {-0.5913820488279888376581538977916352450848,0.8063915130530642239037319995986763387918}
#define T_2187_1424 {-0.5820762489150981267016504716593772172928,0.8131342081409002053860035630350466817617}
#define T_2187_1426 {-0.5773944454767246936555125103041063994169,0.8164653417828742210105019694310612976551}
#define T_2187_1430 {-0.5679738044969212529267110767250414937735,0.8230466313674413836309895486920140683651}
#define T_2187_1432 {-0.5632352779848753820957085736154112964869,0.8262965700239232047508153300441335886717}
#define T_2187_1436 {-0.5537025951410026181065404671244323253632,0.8327144985732618520657410954299848526716}
#define T_2187_1438 {-0.5489087535377041859874225337989628314972,0.8358822765734921222957609643344767391682}
#define T_2187_1442 {-0.5392668613241726749407689567306078970432,0.8421349370959356761545677727553993463516}
#define T_2187_1444 {-0.5344191290480956313402316482097376137972,0.8452196131819675883889431133866310119629}
#define T_2187_1448 {-0.5246708924092501336033933512226212769747,0.8513051477927765509079449657292570918798}
#define T_2187_1450 {-0.5197707098916770629415395887917838990688,0.8543058053991569034124609061109367758036}
#define T_2187_1454 {-0.5099190253705208064616272167768329381943,0.8602224058725616018250548222567886114120}
#define T_2187_1456 {-0.5049678486275408495487226900877431035042,0.8631381533986740572927942594105843454599}
// Pre-computed twiddles for N=2401
#define T_2401_1 {0.9999965759099859186065373251040000468493,-0.0026169005146941246887914989116552533233}
#define T_2401_2 {0.9999863036633923618623498441593255847692,-0.0052337831083824094824397121783476904966}
#define T_2401_3 {0.9999691833305656141206441134272608906031,-0.0078506298601817379317902023672104405705}
#define T_2401_4 {0.9999452150287487794955154640774708241224,-0.0104674228494544517553688223188146366738}
#define T_2401_5 {0.9999143989220811157281332270940765738487,-0.0130841441559310586728592795680015115067}
#define T_2401_6 {0.9998767352215968129414136456034611910582,-0.0157007758598329723309650063356457394548}
#define T_2401_8 {0.9997808661177813860376772936433553695679,-0.0209336987839891380813739374389115255326}
#define T_2401_9 {0.9997226613709792042428148306498769670725,-0.0235499541682451345170346002078076708131}
#define T_2401_10 {0.9996576103434136051362202124437317252159,-0.0261660482781753307712779843541284208186}
#define T_2401_11 {0.9995857134805659072185335389804095029831,-0.0287819631982962897964739568124059587717}
#define T_2401_12 {0.9995069712747985946066364704165607690811,-0.0313976810143517040541105700413027079776}
#define T_2401_13 {0.9994213842653525414760906642186455428600,-0.0340131838134350647506742859604855766520}
#define T_2401_15 {0.9992296782267557908596700144698843359947,-0.0392434727165446237129309281499445205554}
#define T_2401_16 {0.9991235605104423767031107672664802521467,-0.0418582230026108212395108409964450402185}
#define T_2401_17 {0.9990106006161163509915468239341862499714,-0.0444726866360302328096132384871452813968}
#define T_2401_18 {0.9988907993173471444592337320500519126654,-0.0470868457124852257678071509872097522020}
#define T_2401_19 {0.9987641574345557105019111077126581221819,-0.0497006823297438185549346201241860399023}
#define T_2401_20 {0.9986306758350084189501671971811447292566,-0.0523141785877822909633927395134378457442}
#define T_2401_22 {0.9983431971889038525347359609440900385380,-0.0575400784378807747532214023067353991792}
#define T_2401_23 {0.9981892021110521096005641084047965705395,-0.0601524462420378047688984679552959278226}
#define T_2401_24 {0.9980283712538420282101014890940859913826,-0.0627644021114138334072052316514600533992}
#define T_2401_25 {0.9978607057186723583441789742209948599339,-0.0653759281588648377692152280360460281372}
#define T_2401_26 {0.9976862066537469653226821719727013260126,-0.0679870065001903084445089575638121459633}
#define T_2401_27 {0.9975048752540667251764716638717800378799,-0.0705976192542556862941083295481803361326}
#define T_2401_29 {0.9971217204643825215981678411480970680714,-0.0758173764921325210597302657333784736693}
#define T_2401_30 {0.9969198996982916449738354458531830459833,-0.0784264852301067016959734701231354847550}
#define T_2401_31 {0.9967112518452538871827073307940736413002,-0.0810350568893910688794690599934256169945}
#define T_2401_32 {0.9964957783341273911403845886525232344866,-0.0836430736060172486112662681989604607224}
#define T_2401_33 {0.9962734806405135756790514278691262006760,-0.0862505175198172713280087009479757398367}
#define T_2401_34 {0.9960443602867469214956486212031450122595,-0.0888573707745457797013699519084184430540}
#define T_2401_36 {0.9955656579216972668078255992440972477198,-0.0940692339021539231103119504950882401317}
#define T_2401_37 {0.9953160791886541680639766127569600939751,-0.0966742080832565658932153951354848686606}
#define T_2401_38 {0.9950596843519158296587079348682891577482,-0.0992785202219781809374055114858492743224}
#define T_2401_39 {0.9947964751673201710957528121070936322212,-0.1018821524835203801151450875295267906040}
#define T_2401_40 {0.9945264534373712272952161583816632628441,-0.1044850870377407037192796224189805798233}
#define T_2401_41 {0.9942496210112263810287913656793534755707,-0.1070873060592747311181582858807814773172}
#define T_2401_43 {0.9936755317001697562773188110440969467163,-0.1122895262274487132581057835523097310215}
#define T_2401_44 {0.9933782787467250185997613698418717831373,-0.1148894917483484073850164008945284876972}
#define T_2401_45 {0.9930742229599913706294955773046240210533,-0.1174886704853252555880160912238352466375}
#define T_2401_46 {0.9927633664221975351438231882639229297638,-0.1200870446387353462913694102098816074431}
#define T_2401_47 {0.9924457112621449805800466492655687034130,-0.1226845964144446937682531029167876113206}
#define T_2401_48 {0.9921212596551934881361489715345669537783,-0.1252813080239510989954965225479099899530}
#define T_2401_50 {0.9914519760347338950268181179126258939505,-0.1304721396192362048438440069730859249830}
#define T_2401_51 {0.9911071486046004741510273561289068311453,-0.1330662240572656196402334671802236698568}
#define T_2401_52 {0.9907555338942861666851058544125407934189,-0.1356593972338370202024293575959745794535}
#define T_2401_53 {0.9903971343117118353305272648867685347795,-0.1382516413904336383122739562168135307729}
#define T_2401_54 {0.9900319523112622865923526660481002181768,-0.1408429387749008110386483849651995114982}
#define T_2401_55 {0.9896599903937697284561636479338631033897,-0.1434332716415675779142446799596655182540}
#define T_2401_57 {0.9888957370431165072588441944390069693327,-0.1486109728719632594451383056366466917098}
#define T_2401_58 {0.9885034508437005040804024247336201369762,-0.1511983057778620020972226711819530464709}
#define T_2401_59 {0.9881043951946945069764183244842570275068,-0.1537846032505428561787397256921394728124}
#define T_2401_60 {0.9876985728289037202998201792070176452398,-0.1563698475785750552358166487465496174991}
#define T_2401_61 {0.9872859865254725031391558331961277872324,-0.1589540210577400636271505618424271233380}
#define T_2401_62 {0.9868666391098662726832912994723301380873,-0.1615371059911526741004195173445623368025}
#define T_2401_64 {0.9860076724754767152347767478204332292080,-0.1666999394705737380650845125273917801678}
#define T_2401_65 {0.9855680591390515443706021869729738682508,-0.1692796526605690743405574494317988865077}
#define T_2401_66 {0.9851216964551273713723844593914691358805,-0.1718582065930278901522143542024423368275}
#define T_2401_67 {0.9846685874804761429146537921042181551456,-0.1744355836095486111947394647359033115208}
#define T_2401_68 {0.9842087353180697384402719762874767184258,-0.1770117660597894659879614209785358980298}
#define T_2401_69 {0.9837421431170586538783595642598811537027,-0.1795867363015892503863568663291516713798}
#define T_2401_71 {0.9827887514265866153451156606024596840143,-0.1847329696328485759693194268038496375084}
#define T_2401_72 {0.9823019584661236702771702766767702996731,-0.1873041974799757869440952617878792807460}
#define T_2401_73 {0.9818084385250072099182716556242667138577,-0.1898741426342386573455911502605886198580}
#define T_2401_74 {0.9813081949829504102567057088890578597784,-0.1924427874961900375438972332631237804890}
#define T_2401_75 {0.9808012312657112818925497776945121586323,-0.1950101144752875437227146449004067108035}
#define T_2401_76 {0.9802875508450685781980382671463303267956,-0.1975761059900137950329224167944630607963}
#define T_2401_78 {0.9792400540106493966874268153333105146885,-0.2027040123461310017205505573656409978867}
#define T_2401_79 {0.9787062447703198664328283484792336821556,-0.2052658920706960932189844015738344751298}
#define T_2401_80 {0.9781657331734314730908863566583022475243,-0.2078263660974786208868181347497738897800}
#define T_2401_81 {0.9776185229215048622108952258713543415070,-0.2103854168918915246155876275224727578461}
#define T_2401_82 {0.9770646177619344285858460352756083011627,-0.2129430269290942256965593060158425942063}
#define T_2401_83 {0.9765040214879623370336503285216167569160,-0.2154991786941127529519945937863667495549}
#define T_2401_85 {0.9753627709988658134321326542703900486231,-0.2206070373977538912058093956147786229849}
#define T_2401_86 {0.9747821245992301930627377259952481836081,-0.2231587093568405122390174710744759067893}
#define T_2401_87 {0.9741948027161170253762634274607989937067,-0.2257088530849106211562116186541970819235}
#define T_2401_88 {0.9736008093716124189853644566028378903866,-0.2282574511181208187782232243989710696042}
#define T_2401_89 {0.9730001486334894922336502531834412366152,-0.2308044860032129885762941512439283542335}
#define T_2401_90 {0.9723928246151812837538841449713800102472,-0.2333499402976337011583751746002235449851}
#define T_2401_92 {0.9711582034198688040405045285297092050314,-0.2384360373984872050190375603051506914198}
#define T_2401_93 {0.9705309146977726397764740795537363737822,-0.2409766453744114356183558811608236283064}
#define T_2401_94 {0.9698969796052496761262773361522704362869,-0.2435156030988855357932720835378859192133}
#define T_2401_95 {0.9692564024836015645902875803585629910231,-0.2460528931846699407515188795514404773712}
#define T_2401_96 {0.9686091877196157939877707576670218259096,-0.2485884982559453393324844228118308819830}
#define T_2401_97 {0.9679553397455354923906156727753113955259,-0.2511224009484318009377545877214288339019}
#define T_2401_99 {0.9666277621231609273877438681665807962418,-0.2561850297983274127311403844942105934024}
#define T_2401_100 {0.9659540415663571133464415652269963175058,-0.2587137212859428325728572417574469000101}
#define T_2401_101 {0.9652737059823776055722532873915042728186,-0.2612406410554191649175947986805113032460}
#define T_2401_102 {0.9645867600302832078895676204410847276449,-0.2637657718019548180876654441817663609982}
#define T_2401_103 {0.9638932084144031797734442079672589898109,-0.2662890962329999000601787884079385548830}
#define T_2401_104 {0.9631930558843040390826217844733037054539,-0.2688105970683744572191642419056734070182}
#define T_2401_106 {0.9617729673057018313642174689448438584805,-0.2738480588939518622915159085096092894673}
#define T_2401_107 {0.9610530409822211073134212711011059582233,-0.2763639853867091988881554698309628292918}
#define T_2401_108 {0.9603265331944991212154150161950383335352,-0.2788780192891412990086053014238132163882}
#define T_2401_109 {0.9595934489177918580438131357368547469378,-0.2813901433846914268421812721499009057879}
#define T_2401_110 {0.9588537931723926099891741614555940032005,-0.2839003404698814403417372886906377971172}
#define T_2401_111 {0.9581075710235968934114225703524425625801,-0.2864085933544299189534854122030083090067}
#define T_2401_113 {0.9565954480018038497135535180859733372927,-0.2914191978271645777631704277155222371221}
#define T_2401_114 {0.9558295574840972586017073808761779218912,-0.2939215151018294003293362948170397430658}
#define T_2401_115 {0.9550571212735046167097152647329494357109,-0.2964218195490445628692555146699305623770}
#define T_2401_116 {0.9542781446598083139321033740998245775700,-0.2989200940462752309478844381374074146152}
#define T_2401_117 {0.9534926329775803566235481412149965763092,-0.3014163214848877836438134636409813538194}
#define T_2401_118 {0.9527005916061462853505759085237514227629,-0.3039104847702673861675748412380926311016}
#define T_2401_120 {0.9510969415365063683864832455583382397890,-0.3088925505736636045739373912510927766562}
#define T_2401_121 {0.9502853438203850977572528790915384888649,-0.3113804189735966398977495828148676082492}
#define T_2401_122 {0.9494672383791510350548037422413472086191,-0.3138661549843632658784997602197108790278}
#define T_2401_123 {0.9486426308153377284781981870764866471291,-0.3163497415831958425869174789113458245993}
#define T_2401_124 {0.9478115267760062190305347940011415630579,-0.3188311617620461779765150822640862315893}
#define T_2401_125 {0.9469739319527065157799938788230065256357,-0.3213103985277021568123245742754079401493}
#define T_2401_127 {0.9452792929426139245663307519862428307533,-0.3262622539214609651558873792964732274413}
#define T_2401_128 {0.9444222603610140653884741368528921157122,-0.3287348386383665554966171384876361116767}
#define T_2401_129 {0.9435587602057526890320104939746670424938,-0.3312051721199155696062632614484755322337}
#define T_2401_130 {0.9426887983902342282860331579286139458418,-0.3336732374488197150341761698655318468809}
#define T_2401_131 {0.9418123808721137191213301775860600173473,-0.3361390177233231635334220754884881898761}
#define T_2401_132 {0.9409295136532562775499854978988878428936,-0.3386024960573187914114612340199528262019}
#define T_2401_134 {0.9391444543415923273954604155733250081539,-0.3435224794382935042946769499394576996565}
#define T_2401_135 {0.9382422744731934161066533306438941508532,-0.3459789507923406448597347662143874913454}
#define T_2401_136 {0.9373336693527887231169870574376545846462,-0.3484330528202468357790166919585317373276}
#define T_2401_137 {0.9364186452026698193051856833335477858782,-0.3508847687158795358719487467169528827071}
#define T_2401_138 {0.9354972082890868900761915938346646726131,-0.3533340816894469105235998540592845529318}
#define T_2401_139 {0.9345693649222056587078100164944771677256,-0.3557809749676127952788817765394924208522}
#define T_2401_141 {0.9326944842885311892644040199229493737221,-0.3606674354273625704436767591687384992838}
#define T_2401_142 {0.9317474598612580649614756111986935138702,-0.3631069691455855452666412475082324817777}
#define T_2401_143 {0.9307940546596390474221038857649546116590,-0.3655440162419143490524220396764576435089}
#define T_2401_144 {0.9298342752127644050830213018343783915043,-0.3679785600270116252552554669819073751569}
#define T_2401_145 {0.9288681280933768213969869975699111819267,-0.3704105838286833596306735216785455122590}
#define T_2401_146 {0.9278956199178255426218697721196804195642,-0.3728400709919926780955279355111997574568}
#define T_2401_148 {0.9259315470813924697779384587192907929420,-0.3776913688707475014183501116349361836910}
#define T_2401_149 {0.9249399958708349744895826916035730391741,-0.3801131463636318041920958421542309224606}
#define T_2401_150 {0.9239421105046704552066216820094268769026,-0.3825323207732586605622771003254456445575}
#define T_2401_151 {0.9229378978165976299408157501602545380592,-0.3849488755326862521322084376151906326413}
#define T_2401_152 {0.9219273646836456670428106008330360054970,-0.3873627940929125768043661537376465275884}
#define T_2401_153 {0.9209105180261274448128006042679771780968,-0.3897740599229887470400512938795145601034}
#define T_2401_155 {0.9188579120347765138987483624077867716551,-0.3945885673598399367989486563601531088352}
#define T_2401_156 {0.9178221667575591213861230244219768792391,-0.3969917759960013836639802775607677176595}
#define T_2401_157 {0.9167801360689099565703941152605693787336,-0.3993922659610110170724794897978426888585}
#define T_2401_158 {0.9157318271048426883140791687765158712864,-0.4017900208158814989722884547518333420157}
#define T_2401_159 {0.9146772470443658153982369185541756451130,-0.4041850241403559529373978875810280442238}
#define T_2401_160 {0.9136164031094335946647788659902289509773,-0.4065772595330203187380391227634390816092}
#define T_2401_162 {0.9114759527184500553786961063451599329710,-0.4113533610121520300850761486799456179142}
#define T_2401_163 {0.9103963609205883988906293780019041150808,-0.4137371943910165272839662975457031279802}
#define T_2401_164 {0.9093105345645501325080317656102124601603,-0.4161181944230895046743512466491665691137}
#define T_2401_165 {0.9082184810862695689692714040575083345175,-0.4184963448028540811129971643822500482202}
#define T_2401_166 {0.9071202079643256865892908535897731781006,-0.4208716292443082651608676769683370366693}
#define T_2401_167 {0.9060157227198905038889620300324168056250,-0.4232440314810766435194011592102469876409}
#define T_2401_169 {0.9037881461608909816618506738450378179550,-0.4279801243738545202255352251086151227355}
#define T_2401_170 {0.9026650701011720290267703603603877127171,-0.4303437825962473373131444986938731744885}
#define T_2401_171 {0.9015358124285478558235240598150994628668,-0.4327044937469428642629054593271575868130}
#define T_2401_172 {0.9004003808763784144630903938377741724253,-0.4350622416593662444839196723478380590677}
#define T_2401_173 {0.8992587832203031705802231954294256865978,-0.4374170101872352223182360830833204090595}
#define T_2401_174 {0.8981110272781884784620842765434645116329,-0.4397687832046710543210110699874348938465}
#define T_2401_176 {0.8957970720181174240082100368454121053219,-0.4444632783074073389961711200157878920436}
#define T_2401_177 {0.8946308885465431570693795038096141070127,-0.4468059682439601831838160705956397578120}
#define T_2401_178 {0.8934585784815852749218834105704445391893,-0.4491455983728047662850713095394894480705}
#define T_2401_179 {0.8922801498514343343515520246000960469246,-0.4514821526717328614708435452484991401434}
#define T_2401_180 {0.8910956107261815972719887213315814733505,-0.4538156151395998927355890373291913419962}
#define T_2401_181 {0.8899049692177641857071535014256369322538,-0.4561459697964349024879027183487778529525}
#define T_2401_183 {0.8875054117080797277949955059739295393229,-0.4607972918636478731890804283466422930360}
#define T_2401_184 {0.8862965121394144052402452871319837868214,-0.4631182274209349469806795696058543398976}
#define T_2401_185 {0.8850815430526756122375786617340054363012,-0.4654359914612263282585047363681951537728}
#define T_2401_186 {0.8838605127681903317338196757191326469183,-0.4677505681120565639297126381279667839408}
#define T_2401_187 {0.8826334296477937879643604901502840220928,-0.4700619415227881292551614933472592383623}
#define T_2401_188 {0.8814003020947721589450907231366727501154,-0.4723700958647196745943119822186417877674}
#define T_2401_190 {0.8789159475109068475617846161185298115015,-0.4769766841377101052046327822608873248100}
#define T_2401_191 {0.8776647374933705947341877617873251438141,-0.4792750865220231637486847375839715823531}
#define T_2401_192 {0.8764075170697077643566785809525754302740,-0.4815702067442607092750961328420089557767}
#define T_2401_193 {0.8751442948495897766747475543525069952011,-0.4838620290870261908544591733516426756978}
#define T_2401_194 {0.8738750794837901736400453955866396427155,-0.4861505378555077139246520800952566787601}
#define T_2401_195 {0.8725998796641240007332385175686795264482,-0.4884357173775852323238666485849535092711}
#define T_2401_197 {0.8700315616353069270161313397693447768688,-0.4929960261081514638625833413243526592851}
#define T_2401_198 {0.8687384610144601726489099746686406433582,-0.4952711240868249986668558904057135805488}
#define T_2401_199 {0.8674394111162350151644773177395109087229,-0.4975428303596781121065362185618141666055}
#define T_2401_200 {0.8661344208367589558861254772637039422989,-0.4998111293696571033606801393034402281046}
#define T_2401_201 {0.8648234991128403992277640099928248673677,-0.5020760055830421064726465374405961483717}
#define T_2401_202 {0.8635066549219072573606581499916501343250,-0.5043374434895530056266466090164612978697}
#define T_2401_204 {0.8608552352514381444947844101989176124334,-0.5088499424586692132521648090914823114872}
#define T_2401_205 {0.8595206779293014243137349694734439253807,-0.5111009726188692203763253019133117049932}
#define T_2401_206 {0.8581802344548241645583175341016612946987,-0.5133485026675961293562977516558021306992}
#define T_2401_207 {0.8568339140076047799610137190029490739107,-0.5155925172133595246748427598504349589348}
#define T_2401_208 {0.8554817258074880470530843012966215610504,-0.5178330008887438440368100600608158856630}
#define T_2401_209 {0.8541236791145021545190729739260859787464,-0.5200699383505136275118729827227070927620}
#define T_2401_211 {0.8513900474905720106022499749087728559971,-0.5245331133817974222921520777163095772266}
#define T_2401_212 {0.8500144812800293214749558501353021711111,-0.5267593203866852702432765909179579466581}
#define T_2401_213 {0.8486330940172923664732707038638181984425,-0.5289819200489157546840601753501687198877}
#define T_2401_214 {0.8472458951623496048455308482516556978226,-0.5312008971477260033111633674707263708115}
#define T_2401_215 {0.8458528942149886598045327446016017347574,-0.5334162364871614103734032141801435500383}
#define T_2401_216 {0.8444541007147307043467776566103566437960,-0.5356279228961794425245557249581906944513}
#define T_2401_218 {0.8416391744118856266254624642897397279739,-0.5400402763639760017611024522921070456505}
#define T_2401_219 {0.8402230608864206251595874164195265620947,-0.5422409132061636327648557198699563741684}
#define T_2401_220 {0.8388011933621707383323951034981291741133,-0.5444378366849590422660298827395308762789}
#define T_2401_221 {0.8373735815763410084144879874656908214092,-0.5466310317554347042445783699804451316595}
#define T_2401_222 {0.8359402353054736778403821517713367938995,-0.5488204833981958907784814982733223587275}
#define T_2401_223 {0.8345011643653821309385421045590192079544,-0.5510061766194835897181292239110916852951}
#define T_2401_225 {0.8316058879367300704643639619462192058563,-0.5553662279513966737454211397562175989151}
#define T_2401_226 {0.8301497022755438548458073455549310892820,-0.5575405562036056528185667957586701959372}
#define T_2401_227 {0.8286878315997460164865628939878661185503,-0.5597110663177127243272934720152989029884}
#define T_2401_228 {0.8272202859204901281842126081755850464106,-0.5618777434296738926278180770168546587229}
#define T_2401_229 {0.8257470752877933417579470187774859368801,-0.5640405727016942760698725578549783676863}
#define T_2401_230 {0.8242682097904673321764335014449898153543,-0.5661995393223295813811546395299956202507}
#define T_2401_232 {0.8212935547507319578031115270277950912714,-0.5705058254960299057856332183291669934988}
#define T_2401_233 {0.8197977855792959456238122584181837737560,-0.5726531155588719945725983961892779916525}
#define T_2401_234 {0.8182964022850375274131806691002566367388,-0.5747964839900849831622053898172453045845}
#define T_2401_235 {0.8167894151496998267347748878819402307272,-0.5769359161114960832250631028728093951941}
#define T_2401_236 {0.8152768344934021582659511295787524431944,-0.5790713972718889435142841648485045880079}
#define T_2401_237 {0.8137586706745689735242876849952153861523,-0.5812029128471040140269110452209133654833}
#define T_2401_239 {0.8107056351740962174545757079613395035267,-0.5854539888812486658764555613743141293526}
#define T_2401_240 {0.8091707844001934102351469846325926482677,-0.5875735202280440994115906505612656474113}
#define T_2401_241 {0.8076303922790853961899415480729658156633,-0.5896890277655932877109989931341260671616}
#define T_2401_242 {0.8060844693596548315994709810183849185705,-0.5918004970065195990969186823349446058273}
#define T_2401_243 {0.8045330262286601863408463941595982760191,-0.5939079134911017243680930732807610183954}
#define T_2401_244 {0.8029760735106632463242704034200869500637,-0.5960112627873720425597525718330871313810}
#define T_2401_246 {0.7998456820004904432863668262143619358540,-0.6002057022264702945690828528313431888819}
#define T_2401_247 {0.7982722646457990345325583803059998899698,-0.6022967636450218265053990762680768966675}
#define T_2401_248 {0.7966933805789279121611912160005886107683,-0.6043837004269055901417573295475449413061}
#define T_2401_249 {0.7951090406123592080334105958172585815191,-0.6064664982804026660545559934689663350582}
#define T_2401_250 {0.7935192555959383886587943379709031432867,-0.6085451429421384617057810828555375337601}
#define T_2401_251 {0.7919240364167994261634930808213539421558,-0.6106196201771800780022658727830275893211}
#define T_2401_253 {0.7887173393048988456754955223004799336195,-0.6147560155702431750057712633861228823662}
#define T_2401_254 {0.7871058833321762371326713036978617310524,-0.6168179054014842899178461266274098306894}
#define T_2401_255 {0.7854890371166634022159769301651977002621,-0.6188755711526646718922961554198991507292}
#define T_2401_256 {0.7838668117308141836119261824933346360922,-0.6209289987325187221145483817963395267725}
#define T_2401_257 {0.7822392182839201790756078480626456439495,-0.6229781740788047361689905301318503916264}
#define T_2401_258 {0.7806062679220341360419865850417409092188,-0.6250230831584009383306010931846685707569}
#define T_2401_260 {0.7773243412208471481150695581163745373487,-0.6291000465312143186125126703700516372919}
#define T_2401_261 {0.7756753873567709955949567302013747394085,-0.6311320729046522304273025838483590632677}
#define T_2401_262 {0.7740211215279988454796011865255422890186,-0.6331597771720333112099865502386819571257}
#define T_2401_263 {0.7723615550632407789066746772732585668564,-0.6351831454472737226168987945129629224539}
#define T_2401_264 {0.7706966993275068400492955333902500569820,-0.6372021638739832072317881284106988459826}
#define T_2401_265 {0.7690265657220287653927925930474884808064,-0.6392168186255601236567258638388011604548}
#define T_2401_267 {0.7656705106874079902468110958579927682877,-0.6432329819464202014245302052586339414120}
#define T_2401_268 {0.7639846122411344531144550273893401026726,-0.6452344630122940349892246558738406747580}
#define T_2401_269 {0.7622934818906974552277233669883571565151,-0.6472315253964047165879946987843140959740}
#define T_2401_270 {0.7605971312172622456060366857855115085840,-0.6492241554225095523378286088700406253338}
#define T_2401_271 {0.7588955718377434767063505205442197620869,-0.6512123394447193458489664408261887729168}
#define T_2401_272 {0.7571888154047261565438020625151693820953,-0.6531960638475921010481783923751208931208}
#define T_2401_274 {0.7537597581664073898011224628135096281767,-0.6571500794863521788258253764070104807615}
#define T_2401_275 {0.7520374808439073133214947119995485991240,-0.6591203436444286190010188875021412968636}
#define T_2401_276 {0.7503100534333504434414408024167641997337,-0.6610860940277315522806134140409994870424}
#define T_2401_277 {0.7485774877644707503421273031563032418489,-0.6630473171744484250922369028558023273945}
#define T_2401_278 {0.7468397957021897237694929572171531617641,-0.6650039996537701059153846472327131778002}
#define T_2401_279 {0.7450969891465355487980559701099991798401,-0.6669561280659827007255557873577345162630}
#define T_2401_281 {0.7415960803302630299782549627707339823246,-0.6708466692462519143091981277393642812967}
#define T_2401_282 {0.7398380020444984550564981873321812599897,-0.6727850553711821612878907217236701399088}
#define T_2401_283 {0.7380748572149042896484161246917210519314,-0.6747188341429329883069954121310729533434}
#define T_2401_284 {0.7363066579158135116500716321752406656742,-0.6766479923186391465250721921620424836874}
#define T_2401_285 {0.7345334162561735213969882352103013545275,-0.6785725166870781865924300291226245462894}
#define T_2401_286 {0.7327551443794620977811860029760282486677,-0.6804923940687607197830288896511774510145}
#define T_2401_288 {0.7291835587208940205883322960289660841227,-0.6843181553131062466732714710815344005823}
#define T_2401_289 {0.7273902693978987477052555732370819896460,-0.6862240129762673390700911113526672124863}
#define T_2401_290 {0.7255919987753878253045058954739943146706,-0.6881251712538479781144928892899770289660}
#define T_2401_291 {0.7237887591682423682470925996312871575356,-0.6900216171263738873520310335152316838503}
#define T_2401_292 {0.7219805629253717160764836080488748848438,-0.6919133376066423091188539729046169668436}
#define T_2401_293 {0.7201674224296292781133388416492380201817,-0.6938003197398109334059768116276245564222}
#define T_2401_295 {0.7165263583801533275874362516333349049091,-0.6975600173078128074521941925922874361277}
#define T_2401_296 {0.7146984597610818168433866048872005194426,-0.6994327069955602604878208694572094827890}
#define T_2401_297 {0.7128656667582921047099375755351502448320,-0.7013006068422126260131221897609066218138}
#define T_2401_298 {0.7110279919230805267815753722970839589834,-0.7031637040560553275625466085330117493868}
#define T_2401_299 {0.7091854478401751205041136927320621907711,-0.7050219858782634796412480682192835956812}
#define T_2401_300 {0.7073380471276494718679828110907692462206,-0.7068754395829883740987042983761057257652}
#define T_2401_302 {0.7036287264522408380074125489045400172472,-0.7105678119020011340722930981428362429142}
#define T_2401_303 {0.7017668318914535019459322029433678835630,-0.7124067052302585079104346732492558658123}
#define T_2401_304 {0.6999001315050635829706493495905306190252,-0.7142407198691451686300979417865164577961}
#define T_2401_305 {0.6980286380765713394325189256051089614630,-0.7160698432589986950347338279243558645248}
#define T_2401_306 {0.6961523644223007734055386208638083189726,-0.7178940628736527607145490037510171532631}
#define T_2401_307 {0.6942713233913115900008961034473031759262,-0.7197133662205231763309143389051314443350}
#define T_2401_309 {0.6904949907585673507526280445745214819908,-0.7233371743089981320551373755733948200941}
#define T_2401_310 {0.6885997250178180761892576811078470200300,-0.7251416542341125870407836373487953096628}
#define T_2401_311 {0.6866997436221845552140052859613206237555,-0.7269411682586328637967199028935283422470}
#define T_2401_312 {0.6847950595830814002340503066079691052437,-0.7287357040591629919745741972292307764292}
#define T_2401_313 {0.6828856859441276849764790313201956450939,-0.7305252493463988416877441522956360131502}
#define T_2401_314 {0.6809716357810580156240121141308918595314,-0.7323097918652119453497562062693759799004}
#define T_2401_316 {0.6771295583455470001865705853560939431190,-0.7358638197484399512404706911183893680573}
#define T_2401_317 {0.6752015573843435092271647590678185224533,-0.7376332807742320696320348361041396856308}
#define T_2401_318 {0.6732689325213198072717091235972475260496,-0.7393976903545226297964632067305501550436}
#define T_2401_319 {0.6713316969914386866946642840048298239708,-0.7411570364063172489110797869216185063124}
#define T_2401_320 {0.6693898640612380157577376849076244980097,-0.7429113068812973619259309998597018420696}
#define T_2401_321 {0.6674434470287392562326544975803699344397,-0.7446604897659030442014227446634322404861}
#define T_2401_323 {0.6635369140058056114384044121834449470043,-0.7481435448840363378053552878554910421371}
#define T_2401_324 {0.6615768247680122726706031244248151779175,-0.7498773932649754891954785307461861521006}
#define T_2401_325 {0.6596122049330204184514059306820854544640,-0.7516061063505266037765295550343580543995}
#define T_2401_326 {0.6576430679549003510686588924727402627468,-0.7533296723021510876705519876850303262472}
#define T_2401_327 {0.6556694273186567389899437330313958227634,-0.7550480793165589288307160131807904690504}
#define T_2401_328 {0.6536912965401358022177191742230206727982,-0.7567613156257898543444184724648948758841}
#define T_2401_330 {0.6497216187733013681437910236127208918333,-0.7601722292340077347105875560373533517122}
#define T_2401_331 {0.6477300989700559563644333138654474169016,-0.7618698831744443733526850337511859834194}
#define T_2401_332 {0.6457341433944830955127258675929624587297,-0.7635623196927630029762212870991788804531}
#define T_2401_333 {0.6437337657152458758602620036981534212828,-0.7652495271988535296969757837359793484211}
#define T_2401_334 {0.6417289796312908300990329735213890671730,-0.7669314941384154371561976404336746782064}
#define T_2401_335 {0.6397197988717540084735446725971996784210,-0.7686082089930360572438416966178920120001}
#define T_2401_337 {0.6356883083928622779623651695146691054106,-0.7719458365537191779637282706971745938063}
#define T_2401_338 {0.6336660262818799571604699849558528512716,-0.7736067264031071255558913435379508882761}
#define T_2401_339 {0.6316394047118719656808139006898272782564,-0.7752623184543615542096972603758331388235}
#define T_2401_340 {0.6296084575615076284194060463050846010447,-0.7769126013696902033345281779475044459105}
#define T_2401_341 {0.6275731987390785748814892031077761203051,-0.7785575638476586179947958044067490845919}
#define T_2401_342 {0.6255336421824037040906318907218519598246,-0.7801971946232673094101528477040119469166}
#define T_2401_344 {0.6214416917646544691322674225375521928072,-0.7834604161900486918312935813446529209614}
#define T_2401_348 {0.6132068346373660272519146019476465880871,-0.7899223872976521843014552359818480908871}
#define T_2401_352 {0.6049047884724643164844337661634199321270,-0.7962978066546982924833741890324745327234}
#define T_2401_356 {0.5965364629246703298548482052865438163280,-0.8025859757068544153568723231728654354811}
#define T_2401_360 {0.5881027749109331015375801143818534910679,-0.8087862054597990679738472863391507416964}
#define T_2401_368 {0.5710430148609823008953867429227102547884,-0.8209201393427255633028494230529759079218}
#define T_2401_372 {0.5624188120616966379827772470889613032341,-0.8268525139582693084250308857008349150419}
#define T_2401_376 {0.5537329850655110519141999247949570417404,-0.8326942903914007487742310331668704748154}
#define T_2401_380 {0.5449864855779902317323148963623680174351,-0.8384448285590120342192221869481727480888}
#define T_2401_384 {0.5361802719525800009492400022281799465418,-0.8441034983749666764651919947937130928040}
#define T_2401_388 {0.5273153090856010916098739471635781228542,-0.8496696798191383237508489401079714298248}
#define T_2401_396 {0.5094130272915455837079434786573983728886,-0.8605221482481801853481329089845530688763}
#define T_2401_400 {0.5003776699164557140164788506808690726757,-0.8658072461287087406844875658862292766571}
#define T_2401_404 {0.4912874861888437694190656657156068831682,-0.8709974775590607620756600226741284132004}
#define T_2401_408 {0.4821434721196179440383389191993046551943,-0.8760922738458770675507025771366897970438}
#define T_2401_412 {0.4729466296178740924993633143458282575011,-0.8810910767526212161726562044350430369377}
#define T_2401_416 {0.4636979663811163221431854708498576655984,-0.8859933385607462463795513940567616373301}
#define T_2401_424 {0.4450492367715148112061740448552882298827,-0.8955061009558182849588092722115106880665}
#define T_2401_428 {0.4356512137389021432909430586732923984528,-0.9001155592299365792996468371711671352386}
#define T_2401_432 {0.4262054564278490165207813333836384117603,-0.9046263918939845272149113952764309942722}
#define T_2401_436 {0.4167129998094408760422879822726827114820,-0.9090381046962866529170810281357262283564}
#define T_2401_440 {0.4071748839716036183489222821663133800030,-0.9133502142457246009144000709056854248047}
#define T_2401_444 {0.3975921540051412517158269110950641334057,-0.9175622480647032119804862304590642452240}
#define T_2401_452 {0.3782970563763480287278184732713270932436,-0.9256842534779287090529464876453857868910}
#define T_2401_456 {0.3685868028767549930968527860386529937387,-0.9295933351445093695275545542244799435139}
#define T_2401_460 {0.3588361633423636232187448058539303019643,-0.9334005613228076869702931617212016135454}
#define T_2401_464 {0.3490462061501870549840020885312696918845,-0.9371055148552702718234286294318735599518}
#define T_2401_468 {0.3392180039852719652948564998951042070985,-0.9407077897903514118738144134113099426031}
#define T_2401_472 {0.3293526337231644229852633998234523460269,-0.9442069914269938246675906157179269939661}
#define T_2401_480 {0.3095147166536484362175940532324602827430,-0.9508946525114186920646375256183091551065}
#define T_2401_484 {0.2995443434856727149551147704187314957380,-0.9540823791925607810782139495131559669971}
#define T_2401_488 {0.2895411492612042780869785474351374432445,-0.9571655671222721872837269074807409197092}
#define T_2401_492 {0.2795062300296592971982079234294360503554,-0.9601438784758288269571835371607448905706}
#define T_2401_496 {0.2694406853165609017075610154279274865985,-0.9630169869198268450816158292582258582115}
#define T_2401_500 {0.2593456180030645485956597440235782414675,-0.9657845776479393462565781192097347229719}
#define T_2401_508 {0.2390713431522510368232303790136938914657,-0.9710020045722761450335269728384446352720}
#define T_2401_512 {0.2288943570660635362656876168330200016499,-0.9734512690953325275700080965179949998856}
#define T_2401_516 {0.2186922910383331808414908437043777666986,-0.9757938726188051248300325823947787284851}
#define T_2401_520 {0.2084662629088480656491810805164277553558,-0.9780295584637608286016074998769909143448}
#define T_2401_524 {0.1982173931429223601163869261654326692224,-0.9801580816662300854602563049411401152611}
#define T_2401_528 {0.1879468047086269855139306628188933245838,-0.9821792090040478706569615496846381574869}
#define T_2401_536 {0.1673449754824731794400349826901219785213,-0.9858984020581281759731950842251535505056}
#define T_2401_540 {0.1570159920318584534371098015981260687113,-0.9875960602626213669097410274844150990248}
#define T_2401_544 {0.1466698043480248458969583680300274863839,-0.9891855076235761545788705006998497992754}
#define T_2401_548 {0.1363075460621619994228126415691804140806,-0.9906665699853365314453412793227471411228}
#define T_2401_552 {0.1259303525663144907031920638473820872605,-0.9920390850679844385595629319141153246164}
#define T_2401_556 {0.1155393608889769829772831144509837031364,-0.9933029024851214305869007148430682718754}
#define T_2401_564 {0.0947205385383906722784885801047494169325,-0.9955039023424253619154455918760504573584}
#define T_2401_568 {0.0842949889823097625596304283135395962745,-0.9964408436191645179746956273447722196579}
#define T_2401_572 {0.0738602032291328369772998030384769663215,-0.9972686049299612776053436391521245241165}
#define T_2401_576 {0.0634173246177348881591484541786485351622,-0.9979870955770564489029084143112413585186}
#define T_2401_580 {0.0529674973737249144001282274984987452626,-0.9985962368354711626849962158303242176771}
#define T_2401_584 {0.0425118664840732074505780246909125708044,-0.9990959619616327502811259364534635096788}
#define T_2401_592 {0.0215877767697255050494131722871316014789,-0.9997669567925019373788586563023272901773}
#define T_2401_596 {0.0111216105963364217390498822624067543074,-0.9999381529763445852765357813041191548109}
#define T_2401_600 {0.0006542258287137657198420659376836283627,-0.9999997859942596489801758252724539488554}
#define T_2401_604 {-0.0098132306223953271601123660161647421774,-0.9999518490931209591110473411390557885170}
#define T_2401_608 {-0.0202796118383893608783097306513809598982,-0.9997943475253719958217857310955878347158}
#define T_2401_612 {-0.0307437710184802932833481037278033909388,-0.9995272985484504602027300279587507247925}
#define T_2401_620 {-0.0516608374107706200262235540776600828394,-0.9986646874091513748084025792195461690426}
#define T_2401_624 {-0.0621114527412080993928888972277491120622,-0.9980692197630265383168080006726086139679}
#define T_2401_628 {-0.0725552625233399778315046546595112886280,-0.9973643937298790618228849780280143022537}
#define T_2401_632 {-0.0829911224295289406960307587723946198821,-0.9965502865374566976441883525694720447063}
#define T_2401_636 {-0.0934178890032050929237428249507502187043,-0.9956269873874376008515696412359829992056}
#define T_2401_640 {-0.1038344197841544608307273733771580737084,-0.9945945974456567029164943960495293140411}
#define T_2401_648 {-0.1246322098597495708904858702226192690432,-0.9922030096031131396472346750670112669468}
#define T_2401_652 {-0.1350111903417325343035315654560690745711,-0.9908440737484927041123228264041244983673}
#define T_2401_656 {-0.1453753776553525778325592909823171794415,-0.9893765711656828942821562122844625264406}
#define T_2401_660 {-0.1557236361972016702726051562422071583569,-0.9878006626488573527211656255531124770641}
#define T_2401_664 {-0.1660548321091863677168021240504458546638,-0.9861165208702215023706116880930494517088}
#define T_2401_668 {-0.1763678334027646288362234372470993548632,-0.9843243303610932359859475582197774201632}
#define T_2401_676 {-0.1969347342722635452183510551549261435866,-0.9804166004495807884566715983964968472719}
#define T_2401_680 {-0.2071863803340384668771889664640184491873,-0.9783014892169382692443946325511205941439}
#define T_2401_684 {-0.2174153249960329437051598233665572479367,-0.9760791855463722965779993501200806349516}
#define T_2401_688 {-0.2276204474733684590681548343127360567451,-0.9737499329355682187170373254048172384501}
#define T_2401_692 {-0.2378006295913619450033138491562567651272,-0.9713139866006006428733599022962152957916}
#define T_2401_696 {-0.2479547559080441110346271216258173808455,-0.9687716134479695817560696013970300555229}
#define T_2401_704 {-0.2681803937661663694846936323301633819938,-0.9633687125910951332130593982583377510309}
#define T_2401_708 {-0.2782496891856293119715815009840298444033,-0.9605087768823877825141721586987841874361}
#define T_2401_712 {-0.2882884968026468985868859817855991423130,-0.9575435982822245728485199833812657743692}
#define T_2401_716 {-0.2982957166656456937658958850079216063023,-0.9544735016850540709754113777307793498039}
#define T_2401_720 {-0.3082702522841207493087267721421085298061,-0.9512988234811837751081498026906047016382}
#define T_2401_724 {-0.3182110107487778338786199583410052582622,-0.9480199115199222648087129527993965893984}
#define T_2401_732 {-0.3379868432036098879756025326059898361564,-0.9411508347875267022075718159612733870745}
#define T_2401_736 {-0.3478197503569597781591937746270559728146,-0.9375614226607353884901385754346847534180}
#define T_2401_740 {-0.3576145469202618998316722809249768033624,-0.9338692819827707491953106000437401235104}
#define T_2401_744 {-0.3673701596782198985913225897093070670962,-0.9300748173012745034782255970640107989311}
#define T_2401_748 {-0.3770855197089049704040064625587547197938,-0.9261784443755236573281308665173128247261}
#define T_2401_752 {-0.3867595625008770077180031421448802575469,-0.9221805901308757213996614154893904924393}
#define T_2401_760 {-0.4059794610747021192942440848128171637654,-0.9138822009348329666877930321788880974054}
#define T_2401_764 {-0.4155232109333735768252893194585340097547,-0.9095825752374652184428782675240654498339}
#define T_2401_768 {-0.4250214319377146332534778139233822003007,-0.9051832866296276591810965328477323055267}
#define T_2401_772 {-0.4344730833681960668890553733945125713944,-0.9006848171411199199809516358072869479656}
#define T_2401_776 {-0.4438771296079139783152811560285044834018,-0.8960876596689852924271235679043456912041}
#define T_2401_780 {-0.4532325402560626326220472037675790488720,-0.8913923179235035965106703770288731902838}
#define T_2401_788 {-0.4717933599317410964246732874016743153334,-0.8817091501874745329558891171473078429699}
#define T_2401_792 {-0.4809967352513261351631967954745050519705,-0.8767223851810592716304881832911632955074}
#define T_2401_796 {-0.4901474077862859046739174573303898796439,-0.8716395577533091465483039428363554179668}
#define T_2401_800 {-0.4992443748979568662882400076341582462192,-0.8664612248293331875359513105649966746569}
#define T_2401_804 {-0.5082866398321755907474539526447188109159,-0.8611879537987722210701235781016293913126}
#define T_2401_808 {-0.5172732118284932845142520818626508116722,-0.8558203224536297115676575231191236525774}
#define T_2401_816 {-0.5350753445848783762528455554274842143059,-0.8448043416184446430250432058528531342745}
#define T_2401_820 {-0.5438889547662832946173239179188385605812,-0.8391571991487887238747589435661211609840}
#define T_2401_824 {-0.5526429710661868721643941171350888907909,-0.8334181102730716661497467612207401543856}
#define T_2401_828 {-0.5613364343075263329652102584077510982752,-0.8275877038229315640904815154499374330044}
#define T_2401_832 {-0.5699683919480341698360348345886450260878,-0.8216666186356678114321994144120253622532}
#define T_2401_836 {-0.5785378981846082124818053671333473175764,-0.8156555034842442042375409982923883944750}
#define T_2401_844 {-0.5954858075504105840991542208939790725708,-0.8033658276314940005491394003911409527063}
#define T_2401_848 {-0.6038623536981843065163388928340282291174,-0.7970886135092439817029230653133708983660}
#define T_2401_852 {-0.6121727346825839299881977240147534757853,-0.7907240624334425094232869923871476203203}
#define T_2401_856 {-0.6204160399356428712280830950476229190826,-0.7842728717675849781088004419871140271425}
#define T_2401_860 {-0.6285913662388784572954136820044368505478,-0.7777357483682617589337837671337183564901}
#define T_2401_864 {-0.6366978178222578721445756855246145278215,-0.7711134085077078204051304055610671639442}
#define T_2401_872 {-0.6527005515796339141232351721555460244417,-0.7576159910981563605503197322832420468330}
#define T_2401_876 {-0.6605950803350129074686947205918841063976,-0.7507423924604084142231386067578569054604}
#define T_2401_880 {-0.6684172277254222249709414427343290299177,-0.7437865350218845206242690437647979706526}
#define T_2401_884 {-0.6761661366786221316615979048947338014841,-0.7367491809354842491330828124773688614368}
#define T_2401_888 {-0.6838409581471041054356874155928380787373,-0.7296311012836902420986007200554013252258}
#define T_2401_892 {-0.6914408512011211982439817802514880895615,-0.7224330759940805757324255864659789949656}
#define T_2401_900 {-0.7064125294875237548453128511027898639441,-0.7078003519235056550940043962327763438225}
#define T_2401_904 {-0.7137826742739803442816537426551803946495,-0.7003672564492752217191195995837915688753}
#define T_2401_908 {-0.7210746099338575243464788400160614401102,-0.6928574217750252950409617369587067514658}
#define T_2401_912 {-0.7282875374901842668862173013621941208839,-0.6852716707529090678363559163699392229319}
#define T_2401_916 {-0.7354206666229031741366384267166722565889,-0.6776108345532299015445687473402358591557}
#define T_2401_920 {-0.7424732157554650990860523052106145769358,-0.6698757525733698425796092124073766171932}
#define T_2401_928 {-0.7563334919443222004176163864030968397856,-0.6541862494452996834581881557824090123177}
#define T_2401_932 {-0.7631397003309523530134583779727108776569,-0.6462335473950452380265119245450478047132}
#define T_2401_936 {-0.7698622915444960357334025502495933324099,-0.6382100375721596607903052245092112571001}
#define T_2401_940 {-0.7765005289910204000491944498207885771990,-0.6301165991121527865104212651203852146864}
#define T_2401_944 {-0.7830536853192302526593948641675524413586,-0.6219541188126114228396090766182169318199}
#define T_2401_948 {-0.7895210425001633058883498961222358047962,-0.6137234910360327422296222721342928707600}
#define T_2401_956 {-0.8021955343870335042311126017011702060699,-0.5970614077375138162295797883416526019573}
#define T_2401_960 {-0.8084012803496234411682053178083151578903,-0.5886317778790824961632210943207610398531}
#define T_2401_964 {-0.8145184498304065545681851290282793343067,-0.5801376516705940566964727622689679265022}
#define T_2401_968 {-0.8205463725714746692219137003121431916952,-0.5715799598129684966352215269580483436584}
#define T_2401_972 {-0.8264843880936796338687599927652627229691,-0.5629596399720108168551746530283708125353}
#define T_2401_976 {-0.8323318457690019878114640050625894218683,-0.5542776366756702044469307111285161226988}
#define T_2401_984 {-0.8437525347492144112138134914857801049948,-0.5367323915176684945294027784257195889950}
#define T_2401_988 {-0.8493245146898693587189654863323085010052,-0.5278710720875106066074522459530271589756}
#define T_2401_992 {-0.8548034341922839951521950752066913992167,-0.5189519138543353671266800120065454393625}
#define T_2401_996 {-0.8601886929315634144899149760021828114986,-0.5099758940897977099737659045786131173372}
#define T_2401_1000 {-0.8654797008452170814507553586736321449280,-0.5009439962958669445569626077485736459494}
#define T_2401_1004 {-0.8706758781978121142230975237907841801643,-0.4918572100970652338780553236574633046985}
#define T_2401_1012 {-0.8807814742933738338948046475707087665796,-0.4735229609444412401941804091620724648237}
#define T_2401_1016 {-0.8856897857667572759865493026154581457376,-0.4642775068732444831987038469378603622317}
#define T_2401_1020 {-0.8905010522612393231156602269038558006287,-0.4549811819423145164975608167878817766905}
#define T_2401_1024 {-0.8952147466066268099993408213777001947165,-0.4456350047494394561731212434096960350871}
#define T_2401_1028 {-0.8998303523237013434865616545721422880888,-0.4362399993547169674279473383649019524455}
#define T_2401_1032 {-0.9043473636808099236361613293411210179329,-0.4267971951683479092665152165864128619432}
#define T_2401_1033 {-0.9054611529137387426757754838035907596350,-0.4244291466948553193105908576399087905884}
#define T_2401_1037 {-0.9098542265985954946572178414498921483755,-0.4149280495949528302368491949891904368997}
#define T_2401_1040 {-0.9130836344576380714244123737444169819355,-0.4077723341346619623237756968592293560505}
#define T_2401_1041 {-0.9141476076081582746724052412901073694229,-0.4053814888525136272967586137383477762341}
#define T_2401_1044 {-0.9173019366446709677020976414496544748545,-0.3981923618402745668198861039854818955064}
#define T_2401_1045 {-0.9183408255169168699083570572838652879000,-0.3957905104836493270781261344382073730230}
#define T_2401_1048 {-0.9214197301112483362572902478859759867191,-0.3885687596316954595110360060061793774366}
#define T_2401_1049 {-0.9224334208742258622848453342157881706953,-0.3861561653713083686056961596477776765823}
#define T_2401_1052 {-0.9254365636709769304957262647803872823715,-0.3789025819664652572349439196841558441520}
#define T_2401_1053 {-0.9264249452546474694614175859896931797266,-0.3764795091501307311432356073055416345596}
#define T_2401_1056 {-0.9293519971996344608555773447733372449875,-0.3691948879671150818282399086456280201674}
#define T_2401_1060 {-0.9331656016833943523280936460650991648436,-0.3594467413051181114980181519058533012867}
#define T_2401_1061 {-0.9341030428027026211168504232773557305336,-0.3570035089837804709311797068949090316892}
#define T_2401_1065 {-0.9377887746816293557117205637041479349136,-0.3472062990228262924219393426028545945883}
#define T_2401_1068 {-0.9404856632937125260340849308704491704702,-0.3398333667240249211793923223012825474143}
#define T_2401_1069 {-0.9413717530984347936495737485529389232397,-0.3373710456876517493896017185761593282223}
#define T_2401_1072 {-0.9439913183615409320026401474024169147015,-0.3299702878412538731289771476440364494920}
#define T_2401_1073 {-0.9448515854663798174684075092955026775599,-0.3274988266263991754101425613043829798698}
#define T_2401_1076 {-0.9473935403548937594919721050246153026819,-0.3200710541330165082030134726664982736111}
#define T_2401_1077 {-0.9482278905004321023497482201491948217154,-0.3175907235375436399316129154613008722663}
#define T_2401_1080 {-0.9506919564925027099633325633476488292217,-0.3101367502577811463559953608637442812324}
#define T_2401_1081 {-0.9515002982590431424014809635991696268320,-0.3076478220513707562133731698850169777870}
#define T_2401_1084 {-0.9538862053671014473721356807800475507975,-0.3001684647166521502370528651226777583361}
#define T_2401_1088 {-0.9569759369850242558541708604025188833475,-0.2901672897341031065465699612104799598455}
#define T_2401_1089 {-0.9577319991431272327986334857996553182602,-0.2876619853531379167321802015067078173161}
#define T_2401_1093 {-0.9606906094614927615893407164548989385366,-0.2776212399880558234777083725930424407125}
#define T_2401_1096 {-0.9628405057730231586532454457483254373074,-0.2700706582410405953709187087952159345150}
#define T_2401_1097 {-0.9635439569650169344683376948523800820112,-0.2675500756796708179408028627221938222647}
#define T_2401_1100 {-0.9656147003626344149651572479342576116323,-0.2599774037172842278131668081186944618821}
#define T_2401_1101 {-0.9662917290125779823384277733566705137491,-0.2574495959248770948768481048318790271878}
#define T_2401_1104 {-0.9682830926050474129596068451064638793468,-0.2498556634843506762955200883880024775863}
#define T_2401_1105 {-0.9689336245309506656653297795855905860662,-0.2473209074326606082827595400885911658406}
#define T_2401_1108 {-0.9708453901246777428823975242266897112131,-0.2397065465807352580007716369436820968986}
#define T_2401_1109 {-0.9714693540477948863198776052740868180990,-0.2371651200028370987116232981861685402691}
#define T_2401_1112 {-0.9733013121707334569521208322839811444283,-0.2295311650445935325315360842068912461400}
#define T_2401_1116 {-0.9756505896479771289264704137167427688837,-0.2193306337918953796695120672666234895587}
#define T_2401_1117 {-0.9762212153809940451409943307226058095694,-0.2167767022538510113260912248733802698553}
#define T_2401_1121 {-0.9784368265361760297338378222775645554066,-0.2065463058924489059275941826854250393808}
#define T_2401_1124 {-0.9800281929684797610491386876674368977547,-0.1988585954565109670255651508341543376446}
#define T_2401_1125 {-0.9805452304245321215603325981646776199341,-0.1962932782641860773864550537837203592062}
#define T_2401_1128 {-0.9820560391579944425899384441436268389225,-0.1885893314938880127584752699476666748524}
#define T_2401_1129 {-0.9825461960283696782880724640563130378723,-0.1860187427927102454816576937446370720863}
#define T_2401_1132 {-0.9839762815237645954269396497693378478289,-0.1782994038090567057164292918969294987619}
#define T_2401_1133 {-0.9844395041020025383105007676931563764811,-0.1757238252582822568559350884243031032383}
#define T_2401_1136 {-0.9857887096649445846097137291508261114359,-0.1679899398688018408165589789859950542450}
#define T_2401_1137 {-0.9862249471957739155314470735902432352304,-0.1654096536744244227978839489878737367690}
#define T_2401_1140 {-0.9874931249938869726179291319567710161209,-0.1576620692804945877973921142256585881114}
#define T_2401_1144 {-0.9890893407579023355324920885323081165552,-0.1473169236683214700089905591084971092641}
#define T_2401_1145 {-0.9894714677603384522797114186687394976616,-0.1447280708370063950773953820316819474101}
#define T_2401_1149 {-0.9909321895100600130490420269779860973358,-0.1343629256632885571320912276860326528549}
#define T_2401_1152 {-0.9919564858766576342929965903749689459801,-0.1265793432090412118373734529086505062878}
#define T_2401_1153 {-0.9922843348767533822041286839521490037441,-0.1239830583515313250364542341230844613165}
#define T_2401_1156 {-0.9932271010784717857333703250333201140165,-0.1161891805774326325018108718722942285240}
#define T_2401_1157 {-0.9935277557059282171891823054465930908918,-0.1135896062231992742486141878544003702700}
#define T_2401_1160 {-0.9943888884439289199690392706543207168579,-0.1057862871039888102986381568371143657714}
#define T_2401_1161 {-0.9946623157560358086115570586116518825293,-0.1031837080882444662721653116932429838926}
#define T_2401_1164 {-0.9954417206760541869670078085619024932384,-0.0953718026331494550529299658592208288610}
#define T_2401_1165 {-0.9956878907133968059639528291882015764713,-0.0927665041203272477954300256897113285959}
#define T_2401_1168 {-0.9963854824160807144295404214062727987766,-0.0849468682793792367879959215315466281027}
#define T_2401_1172 {-0.9972200702560886087510994002514053136110,-0.0745126263021358842264518784759275149554}
#define T_2401_1173 {-0.9974116478149254172436144472158048301935,-0.0719027454490797773845045526286412496120}
#define T_2401_1177 {-0.9981096410871265200981383713951800018549,-0.0614584767865875014614118754252558574080}
#define T_2401_1180 {-0.9985613704252799260885353760386351495981,-0.0536207934889705584158292595020611770451}
#define T_2401_1181 {-0.9986982715433425639162123843561857938766,-0.0510074741223274369383844373260217253119}
#define T_2401_1184 {-0.9990679357882810140978335766703821718693,-0.0431654917699686724308349994316813535988}
#define T_2401_1185 {-0.9991774746873685053571989556076005101204,-0.0405508825720605967091181298656010767445}
#define T_2401_1188 {-0.9994650333350018067690712086914572864771,-0.0327054604105154675397493235777801601216}
#define T_2401_1189 {-0.9995471980129432276740431007056031376123,-0.0300898478639219230101886637385177891701}
#define T_2401_1192 {-0.9997526195554868877479748334735631942749,-0.0222418455156455675825188933458775863983}
#define T_2401_1193 {-0.9998074010095033825606947175401728600264,-0.0196255162128828909706701466575395897962}
#define T_2401_1196 {-0.9999306629389307365940453564689960330725,-0.0117757935830413735384114559678891964722}
#define T_2401_1200 {-0.9999991439771300782979324139887467026711,-0.0013084513774113655862341154545447352575}
#define T_2401_1208 {-0.9998074010095033825606947175401728600264,0.0196255162128828909706701466575395897962}
#define T_2401_1212 {-0.9995471980129432276740431007056031376123,0.0300898478639219230101886637385177891701}
#define T_2401_1216 {-0.9991774746873685053571989556076005101204,0.0405508825720605967091181298656010767445}
#define T_2401_1220 {-0.9986982715433425639162123843561857938766,0.0510074741223274369383844373260217253119}
#define T_2401_1224 {-0.9981096410871265200981383713951800018549,0.0614584767865875014614118754252558574080}
#define T_2401_1228 {-0.9974116478149254172436144472158048301935,0.0719027454490797773845045526286412496120}
#define T_2401_1236 {-0.9956878907133968059639528291882015764713,0.0927665041203272477954300256897113285959}
#define T_2401_1240 {-0.9946623157560358086115570586116518825293,0.1031837080882444662721653116932429838926}
#define T_2401_1244 {-0.9935277557059282171891823054465930908918,0.1135896062231992742486141878544003702700}
#define T_2401_1248 {-0.9922843348767533822041286839521490037441,0.1239830583515313250364542341230844613165}
#define T_2401_1252 {-0.9909321895100600130490420269779860973358,0.1343629256632885571320912276860326528549}
#define T_2401_1256 {-0.9894714677603384522797114186687394976616,0.1447280708370063950773953820316819474101}
#define T_2401_1264 {-0.9862249471957739155314470735902432352304,0.1654096536744244227978839489878737367690}
#define T_2401_1268 {-0.9844395041020025383105007676931563764811,0.1757238252582822568559350884243031032383}
#define T_2401_1272 {-0.9825461960283696782880724640563130378723,0.1860187427927102454816576937446370720863}
#define T_2401_1276 {-0.9805452304245321215603325981646776199341,0.1962932782641860773864550537837203592062}
#define T_2401_1280 {-0.9784368265361760297338378222775645554066,0.2065463058924489059275941826854250393808}
#define T_2401_1284 {-0.9762212153809940451409943307226058095694,0.2167767022538510113260912248733802698553}
#define T_2401_1292 {-0.9714693540477948863198776052740868180990,0.2371651200028370987116232981861685402691}
#define T_2401_1296 {-0.9689336245309506656653297795855905860662,0.2473209074326606082827595400885911658406}
#define T_2401_1300 {-0.9662917290125779823384277733566705137491,0.2574495959248770948768481048318790271878}
#define T_2401_1304 {-0.9635439569650169344683376948523800820112,0.2675500756796708179408028627221938222647}
#define T_2401_1308 {-0.9606906094614927615893407164548989385366,0.2776212399880558234777083725930424407125}
#define T_2401_1312 {-0.9577319991431272327986334857996553182602,0.2876619853531379167321802015067078173161}
#define T_2401_1320 {-0.9515002982590431424014809635991696268320,0.3076478220513707562133731698850169777870}
#define T_2401_1324 {-0.9482278905004321023497482201491948217154,0.3175907235375436399316129154613008722663}
#define T_2401_1328 {-0.9448515854663798174684075092955026775599,0.3274988266263991754101425613043829798698}
#define T_2401_1332 {-0.9413717530984347936495737485529389232397,0.3373710456876517493896017185761593282223}
#define T_2401_1336 {-0.9377887746816293557117205637041479349136,0.3472062990228262924219393426028545945883}
#define T_2401_1340 {-0.9341030428027026211168504232773557305336,0.3570035089837804709311797068949090316892}
#define T_2401_1348 {-0.9264249452546474694614175859896931797266,0.3764795091501307311432356073055416345596}
#define T_2401_1352 {-0.9224334208742258622848453342157881706953,0.3861561653713083686056961596477776765823}
#define T_2401_1356 {-0.9183408255169168699083570572838652879000,0.3957905104836493270781261344382073730230}
#define T_2401_1360 {-0.9141476076081582746724052412901073694229,0.4053814888525136272967586137383477762341}
#define T_2401_1364 {-0.9098542265985954946572178414498921483755,0.4149280495949528302368491949891904368997}
#define T_2401_1368 {-0.9054611529137387426757754838035907596350,0.4244291466948553193105908576399087905884}
// Pre-computed twiddles for N=2500
#define T_2500_1 {0.9999968417282540933399559435201808810234,-0.0025132714770037269634561649667148230947}
#define T_2500_3 {0.9999715756739829819466081062273588031530,-0.0075397509303570921582182684517192683415}
#define T_2500_7 {0.9998452485944885337332266317389439791441,-0.0175920113410997225322773829248035326600}
#define T_2500_9 {0.9997441907610622457980298349866643548012,-0.0226175383167297565367714895501194405369}
#define T_2500_11 {0.9996178732568780089806637079163920134306,-0.0276424938346043792825046381267384276725}
#define T_2500_13 {0.9994662992734908435465968068456277251244,-0.0326667509335237943313146047330519650131}
#define T_2500_17 {0.9990873978258987264666757255326956510544,-0.0427126621211368767694338544060883577913}
#define T_2500_19 {0.9988600799350685344180078573117498308420,-0.0477340623884916423480540004220529226586}
#define T_2500_21 {0.9986075247115431263722484800382517278194,-0.0527542566006264715405826848382275784388}
#define T_2500_23 {0.9983297385364165998922203471011016517878,-0.0577731179166413380543509958897629985586}
#define T_2500_27 {0.9976985020430021444681756292993668466806,-0.0678063346683007578397095471700595226139}
#define T_2500_29 {0.9973450676736201891969813004834577441216,-0.0728204366033457090034985981219506356865}
#define T_2500_31 {0.9969664342500459408569213337614201009274,-0.0778326986474765225576533111961907707155}
#define T_2500_33 {0.9965626113388820206395735112891998142004,-0.0828429941602083913521070712704386096448}
#define T_2500_37 {0.9956794385021441318173174295225180685520,-0.0928571792811678370371808455274731386453}
#define T_2500_39 {0.9952001108909334092800236248876899480820,-0.0978608158696515489927136854930722620338}
#define T_2500_41 {0.9946956384202959577933711443620268255472,-0.1028619798936414586609799926009145565331}
#define T_2500_43 {0.9941660338363007554107753094285726547241,-0.1078605449930568199734537415679369587451}
#define T_2500_47 {0.9930314824871324663746463556890375912189,-0.1178493733093558537561307275609578937292}
#define T_2500_49 {0.9924265643876858389305084529041778296232,-0.1228393841471641101392719974683132022619}
#define T_2500_51 {0.9917965715056101805302546381426509469748,-0.1278262913086236074455825928453123196959}
#define T_2500_53 {0.9911415197583902658706733745930250734091,-0.1328099687938694151156937550695147365332}
#define T_2500_57 {0.9897563065037409124613532185321673750877,-0.1427671311474489335147097790468251332641}
#define T_2500_59 {0.9890261799952952959102958629955537617207,-0.1477403644367836499373680680946563370526}
#define T_2500_61 {0.9882710646187887748581601954356301575899,-0.1527098648982631867720982654645922593772}
#define T_2500_63 {0.9874909794530675188894974780851043760777,-0.1576755069718226431874086301831994205713}
#define T_2500_67 {0.9858559792233186902521424599399324506521,-0.1675947142055242422564731441525509580970}
#define T_2500_69 {0.9850011054694260970165942126186564564705,-0.1725480287456465922080184327569440938532}
#define T_2500_71 {0.9841213445455451180876593753055203706026,-0.1774969836641414056011001321166986599565}
#define T_2500_73 {0.9832167186798331792729754852189216762781,-0.1824414539200502061166986322859884239733}
#define T_2500_77 {0.9813329641761735500082863836723845452070,-0.1923164408499827837673024077957961708307}
#define T_2500_79 {0.9803538831334196457234497756871860474348,-0.1972467080212628731672452886414248496294}
#define T_2500_81 {0.9793500323380199823475322773447260260582,-0.2021719915307735038201286670300760306418}
#define T_2500_83 {0.9783214371534033615418479712388943880796,-0.2070921669356412253559795999535708688200}
#define T_2500_87 {0.9761901181955526807243472831032704561949,-0.2169166963084052934807033352626604028046}
#define T_2500_89 {0.9750874482725092606827388408419210463762,-0.2218208020484253029103172139002708718181}
#define T_2500_91 {0.9739601416592692517681939534668345004320,-0.2267193032343216008150932339049177244306}
#define T_2500_93 {0.9728082268385126463172696276160422712564,-0.2316120760999064442930972518297494389117}
#define T_2500_97 {0.9704306896132062210114099798374809324741,-0.2413799425321770664165654807220562361181}
#define T_2500_99 {0.9692051272798304362154908631055150181055,-0.2462547893026399703497730797607800923288}
#define T_2500_101 {0.9679550768797691162603769043926149606705,-0.2511234141665813490718051070871297270060}
#define T_2500_103 {0.9666805699969629461776321477373130619526,-0.2559856941126726903590338224603328853846}
#define T_2500_107 {0.9640583162076707957055532460799440741539,-0.2656907280106526325624827222782187163830}
#define T_2500_109 {0.9627106355554005956420837719633709639311,-0.2705332367538536564310902576835360378027}
#define T_2500_111 {0.9613386309271433338707879556750413030386,-0.2753689101680248940695605597284156829119}
#define T_2500_113 {0.9599423369881517897894696034200023859739,-0.2801976260743935798203096965153235942125}
#define T_2500_117 {0.9570770229065711509619518437830265611410,-0.2898336975306610163727327744709327816963}
#define T_2500_119 {0.9556080751593917232966646224667783826590,-0.2946408096142865695732382391724968329072}
#define T_2500_121 {0.9541149828904684770947142169461585581303,-0.2994404772637143663516212654940318316221}
#define T_2500_123 {0.9525977838244708006953942458494566380978,-0.3042325792098980463684654296230291947722}
#define T_2500_127 {0.9494912192443889509263499348890036344528,-0.3137936018751875111298943465953925624490}
#define T_2500_129 {0.9479019322211821307888612864189781248569,-0.3185622810242127456170635468879481777549}
#define T_2500_131 {0.9462886953806719514403766879695467650890,-0.3233229113359364914614957342564594000578}
#define T_2500_133 {0.9446515494831168036071744609216693788767,-0.3280753725276349674899734054633881896734}
#define T_2500_137 {0.9413056965773068940350754019164014607668,-0.3375553074551057575192203330516349524260}
#define T_2500_139 {0.9395970741058202735374038638838101178408,-0.3422825416695712275050311745872022584081}
#define T_2500_141 {0.9378647116486887869157840214029420167208,-0.3470011277274495098410511673137079924345}
#define T_2500_143 {0.9361086529760148655654461435915436595678,-0.3517109464083127967626296594971790909767}
#define T_2500_147 {0.9325256250568850768800643891154322773218,-0.3611038058678774920196019593277014791965}
#define T_2500_149 {0.9306987463396931836712155927671119570732,-0.3657866093253325234790906961279688403010}
#define T_2500_151 {0.9288483524631988563768913991225417703390,-0.3704601707692759537948745673929806798697}
#define T_2500_153 {0.9269744901797019043243608393822796642780,-0.3751243721168776579233394841139670461416}
#define T_2500_157 {0.9231565503644826309326276714273262768984,-0.3844242233771806849240704195835860446095}
#define T_2500_159 {0.9212125692973394119889007924939505755901,-0.3890596383185932483073088405944872647524}
#define T_2500_161 {0.9192453127499148335388667874212842434645,-0.3936852232270234286382049049279885366559}
#define T_2500_163 {0.9172548304271764818551559983461629599333,-0.3983008612318227892323818650766042992473}
#define T_2500_167 {0.9132043902084862052603853044274728745222,-0.4075018303074807168862037087819771841168}
#define T_2500_169 {0.9111445346514999155118630369543097913265,-0.4120869289054210904410524562990758568048}
#define T_2500_171 {0.9090616579945454134303872706368565559387,-0.4166616156597678921613692182290833443403}
#define T_2500_173 {0.9069558128638635086105068694450892508030,-0.4212257749858722144509215468133334070444}
#define T_2500_177 {0.9026754305865591909707745799096301198006,-0.4303220503476088421024314811802469193935}
#define T_2500_179 {0.9005010015886493190961914478975813835859,-0.4348539365555282865116737411881331354380}
#define T_2500_181 {0.8983038204117045344432312958815600723028,-0.4393748356855865511150227575853932648897}
#define T_2500_183 {0.8960839425699989035933867853600531816483,-0.4438846335121400255019352698582224547863}
#define T_2500_187 {0.8915763218152700231300400446343701332808,-0.4528704697574726933950728380295913666487}
#define T_2500_189 {0.8892886927923970841192158331978134810925,-0.4573462811389086279945104251964949071407}
#define T_2500_191 {0.8869785948821864440816398200695402920246,-0.4618105371478895548875698295887559652328}
#define T_2500_193 {0.8846460864518815858659195328073110431433,-0.4662631249899246155266041569120716303587}
#define T_2500_197 {0.8799140743296104405501978362735826522112,-0.4751328464720838140600278620695462450385}
#define T_2500_199 {0.8775146901972968871419311653880868107080,-0.4795497560086358079800561426964122802019}
#define T_2500_201 {0.8750931346611736660889846461941488087177,-0.4839545491767599516563791439693886786699}
#define T_2500_203 {0.8726494689045877217736801867431495338678,-0.4883471146843615384725012518174480646849}
#define T_2500_207 {0.8676960542550539168260570477286819368601,-0.4970951190971508171223547378758667036891}
#define T_2500_209 {0.8651864305157446199956439158995635807514,-0.5014503369740861415948529611341655254364}
#define T_2500_211 {0.8626549468600877013102490309393033385277,-0.5057928851395788738543046747508924454451}
#define T_2500_213 {0.8601016672488885905778488449868746101856,-0.5101226538742247296198684125556610524654}
#define T_2500_217 {0.8549299787549532458896806019765790551901,-0.5187434157905574938496329195913858711720}
#define T_2500_219 {0.8523117005407917501358383560727816075087,-0.5230341911589180270425458729732781648636}
#define T_2500_221 {0.8496718877049364015974219910276588052511,-0.5273117514752824197543645823316182941198}
#define T_2500_223 {0.8470106069452519870210949193278793245554,-0.5315759886622380969711798570642713457346}
#define T_2500_227 {0.8416239111562147101608388766180723905563,-0.5400640630241156925350765050097834318876}
#define T_2500_229 {0.8388986322278397800289440056076273322105,-0.5442876857382129562878958495275583118200}
#define T_2500_231 {0.8361521575741531764336400556203443557024,-0.5484975564066704167842658534937072545290}
#define T_2500_233 {0.8333845565879515193685733720485586673021,-0.5526935686623315469034878333332017064095}
#define T_2500_237 {0.8277862558563279238299514872778672724962,-0.5610435942200587833283975669473875313997}
#define T_2500_239 {0.8249556975583226536841152665147092193365,-0.5651973965492598228621545786154456436634}
#define T_2500_241 {0.8221042958190623028968957441975362598896,-0.5693369185252644681938249959785025566816}
#define T_2500_243 {0.8192321226824456070758628811745438724756,-0.5734620555583554990519701277662534266710}
#define T_2500_247 {0.8134257530149683335096710834477562457323,-0.5816687582568207393052261977572925388813}
#define T_2500_249 {0.8104917031886222922310025751357898116112,-0.5857501165705443213482794817537069320679}
#define T_2500_261 {0.7924599971331904857407835152116604149342,-0.6099238911074591484862139623146504163742}
#define T_2500_267 {0.7831728108260403997675780374265741556883,-0.6218041077243211534053557443257886916399}
#define T_2500_273 {0.7737075377755030514137501995719503611326,-0.6335429314492969643524133971368428319693}
#define T_2500_279 {0.7640663303030451602992911830369848757982,-0.6451376929751027056170187279349192976952}
#define T_2500_291 {0.7442649209095699713856220114394091069698,-0.6678845165921063475877872406272217631340}
#define T_2500_297 {0.7341092216582886242903782658686395734549,-0.6790314062517740500979357420874293893576}
#define T_2500_303 {0.7237865923006904234071612336265388876200,-0.6900238900253774509963022865122184157372}
#define T_2500_309 {0.7132993801136727762823852572182659059763,-0.7008594683169017125479172136692795902491}
#define T_2500_321 {0.6918407829402886122238669486250728368759,-0.7220500890246939196259745585848577320576}
#define T_2500_327 {0.6808742774538681929996641883917618542910,-0.7324003128765530501453895340091548860073}
#define T_2500_333 {0.6697529470283645203210198815213516354561,-0.7425839952132153864994279501843266189098}
#define T_2500_339 {0.6584793205584099640148565413255710154772,-0.7525988203531378539778984304575715214014}
#define T_2500_351 {0.6354854676347906350386551821429748088121,-0.7721128288177779852574644792184699326754}
#define T_2500_357 {0.6237704697849901780415393659495748579502,-0.7816075748252524491022086294833570718765}
#define T_2500_363 {0.6119136319095279663571318451431579887867,-0.7909245900105082993647442890505772083998}
#define T_2500_369 {0.5999176501510879999656822292308788746595,-0.8000617557646388933179082414426375180483}
#define T_2500_381 {0.5755191971363310399212309675931464880705,-0.8177882694974004662569200263533275574446}
#define T_2500_387 {0.5631222738778264291781283645832445472479,-0.8263735866196754153989445512706879526377}
#define T_2500_393 {0.5505973014704015344733534220722503960133,-0.8347709935146954141060859910794533789158}
#define T_2500_399 {0.5379471279847712894550681994587648659945,-0.8429785806845486728633431994239799678326}
#define T_2500_411 {0.5122827117558800269492280676786322146654,-0.8588168740983388449450330881518311798573}
#define T_2500_417 {0.4992743048795490468094726566050667315722,-0.8664439788509370465874326328048482537270}
#define T_2500_423 {0.4861523673318466909343271709076361730695,-0.8738740617146393274694560204807203263044}
#define T_2500_429 {0.4729198829282125204898079573467839509249,-0.8811054331526765315274474232865031808615}
#define T_2500_441 {0.4461353338177057592517371631402056664228,-0.8949655099049148576639822749712038785219}
#define T_2500_447 {0.4325893596863208401259726088028401136398,-0.9015910635571866560411535829189233481884}
#define T_2500_453 {0.4189450184650349573445282658212818205357,-0.9080116031765956829957531226682476699352}
#define T_2500_459 {0.4052054127593781029936792492662789300084,-0.9142256687878009824288483287091366946697}
#define T_2500_471 {0.3774529259182506923941957666102098301053,-0.9260287731575901348790580414060968905687}
#define T_2500_477 {0.3634463554589605904787674717226764187217,-0.9316151279920259486999611908686347305775}
#define T_2500_483 {0.3493571404326670237772134441911475732923,-0.9369896415802629885405394816189073026180}
#define T_2500_489 {0.3351884846053667099674555629462702199817,-0.9421510918042592663823597831651568412781}
#define T_2500_501 {0.3066257551998819441685384390439139679074,-0.9518301561981014069502293750701937824488}
#define T_2500_507 {0.2922381765400498543350238378479843959212,-0.9563455694321727484918937989277765154839}
#define T_2500_513 {0.2777841454390272413199625134438974782825,-0.9606435179309280592008235544199123978615}
#define T_2500_519 {0.2632669486188402574455835747357923537493,-0.9647230243779428837669343010929878801107}
#define T_2500_531 {0.2340562757751382949589213922081398777664,-0.9722230504211841761730283906217664480209}
#define T_2500_537 {0.2193694420067258954443190077654435299337,-0.9756418645761659735882176391896791756153}
#define T_2500_543 {0.2046327255189626659337420733209000900388,-0.9788388261847201787801964201207738369703}
#define T_2500_549 {0.1898494773140938784994347088286303915083,-0.9818132082853465725236219441285356879234}
#define T_2500_561 {0.1601568419021817957226261341929784975946,-0.9870915793339134491901631918153725564480}
#define T_2500_567 {0.1452542065443727936635553987798630259931,-0.9893943680257961670321265046368353068829}
#define T_2500_573 {0.1303185416326145262821967207855777814984,-0.9914721769705635567859758339182008057833}
#define T_2500_579 {0.1153532434083082286457866416640172246844,-0.9933245336923797186301499095861800014973}
#define T_2500_591 {0.0853473649056469552132142553091398440301,-0.9963512569890512482473354793910402804613}
#define T_2500_597 {0.0703136077053038016648756070026138331741,-0.9975249353131302454400497481401544064283}
#define T_2500_603 {0.0552638617969271883634263531348551623523,-0.9984717850692077512064770417055115103722}
#define T_2500_609 {0.0402015493629532053021513604562642285600,-0.9991915909518144234269243497692514210939}
#define T_2500_621 {0.0100529271567306524581830728948261821643,-0.9999494680510517818916582655219826847315}
#define T_2500_627 {-0.0050265270788188622791414772450480086263,-0.9999873669329657488447082869242876768112}
#define T_2500_633 {-0.0201048383254575774303773982865095604211,-0.9997978773111629857694993006589356809855}
#define T_2500_639 {-0.0351785779052378247411247969012038083747,-0.9993810422739491938770584056328516453505}
#define T_2500_651 {-0.0652986333296357579492052991554373875260,-0.9978657667668942021776956607936881482601}
#define T_2500_657 {-0.0803381001333942218467498719292052555829,-0.9967676708576360677938055232516489923000}
#define T_2500_663 {-0.0953592987459886270995568224861926864833,-0.9954429185757831533010175917297601699829}
#define T_2500_669 {-0.1103588134763917733005555987801926676184,-0.9938918111585802739327277777192648500204}
#define T_2500_681 {-0.1402791539557319833164683586801402270794,-0.9901119931429293030689109400555025786161}
#define T_2500_687 {-0.1551931760772660706670933450368465855718,-0.9878841420425021890849848205107264220715}
#define T_2500_693 {-0.1700719086088891551789004097372526302934,-0.9854316546073247362613756195059977471828}
#define T_2500_699 {-0.1849119682551322307872965211572591215372,-0.9827550885118900847459144642925821244717}
#define T_2500_711 {-0.2144625804463383411668786493464722298086,-0.9767322056676015495924048082088120281696}
#define T_2500_717 {-0.2291664134369226779597283893963322043419,-0.9733872584703672226069670614378992468119}
#define T_2500_723 {-0.2438181359613384724394080649290117435157,-0.9698209714046909235563020956760738044977}
#define T_2500_729 {-0.2584144163442346764369972333952318876982,-0.9660341554134970198930432161432690918446}
#define T_2500_741 {-0.2874273877741164162635811862855916842818,-0.9578024309623294207938215549802407622337}
#define T_2500_747 {-0.3018374815215959516834232090332079678774,-0.9533593943255084246501951383834239095449}
#define T_2500_753 {-0.3161789400287130513689248800801578909159,-0.9486995719838390295208796487713698297739}
#define T_2500_759 {-0.3304485021714786974200706026749685406685,-0.9438240235407373557308119416120462119579}
#define T_2500_771 {-0.3587589753488995003571915276552317664027,-0.9334302317830763806583149744255933910608}
#define T_2500_777 {-0.3727934488260932766046096276113530620933,-0.9279143519271306761453388389782048761845}
#define T_2500_783 {-0.3867431522878577720980786125437589362264,-0.9221874723495493419989088579313829541206}
#define T_2500_789 {-0.4006049136919229147757448572519933804870,-0.9162508952933617889513584486849140375853}
#define T_2500_801 {-0.4280520228609502875194436910533113405108,-0.9037540958273154734214926975255366414785}
#define T_2500_807 {-0.4416311293899813361640838138555409386754,-0.8971967150818874747741915598453488200903}
#define T_2500_813 {-0.4551098128086537575320846826798515394330,-0.8904353195405447785049091180553659796715}
#define T_2500_819 {-0.4684850081805932986434015674603870138526,-0.8834714466863258230944211391033604741096}
#define T_2500_831 {-0.4949127933918132660195965399907436221838,-0.8689426488193063846665609162300825119019}
#define T_2500_837 {-0.5079593737806400444156906814896501600742,-0.8613810275298499075091740451171062886715}
#define T_2500_843 {-0.5208904485883242285737537713430356234312,-0.8536235356229666670913047710200771689415}
#define T_2500_849 {-0.5337030773999673627372430928517132997513,-0.8456719370854187678432367647474166005850}
#define T_2500_861 {-0.5589613707060275826776774010795634239912,-0.8291936963450933228969574884104076772928}
#define T_2500_867 {-0.5714012916823650867215178550395648926497,-0.8206708011521579582137064790003933012486}
#define T_2500_873 {-0.5837112809325288864670255861710757017136,-0.8119612924962041899945575096353422850370}
#define T_2500_879 {-0.5958885392711202877435994196275714784861,-0.8030671508443926187581496378697920590639}
#define T_2500_891 {-0.6198338180109623785085659619653597474098,-0.7847330998817070302209231158485636115074}
#define T_2500_897 {-0.6315963934623227693521130277076736092567,-0.7752973595759157232620850663806777447462}
#define T_2500_903 {-0.6432153493404652033760271478968206793070,-0.7656853233364364630375575870857574045658}
#define T_2500_909 {-0.6546880435950205301409710045845713466406,-0.7558991768574195857510744644969236105680}
#define T_2500_921 {-0.6771842459182698670261402185133192688227,-0.7358134934071977051317503537575248628855}
#define T_2500_927 {-0.6882026385445545457741900463588535785675,-0.7255185237471978298984254251990932971239}
#define T_2500_933 {-0.6990645398256409848158909881021827459335,-0.7150585774315030285208649729611352086067}
#define T_2500_939 {-0.7097674798588468059179490410315338522196,-0.7044360329617029847781850548926740884781}
#define T_2500_951 {-0.7306867778563879145536930082016624510288,-0.6827128478839764591512562219577375799417}
#define T_2500_957 {-0.7408983789527587848766643219278194010258,-0.6716171469410040506531345272378530353308}
#define T_2500_963 {-0.7509415061469912888725275479373522102833,-0.6603687260505968215085204064962454140186}
#define T_2500_969 {-0.7608138757185697320650774599926080554724,-0.6489701430066630027937435443163849413395}
#define T_2500_981 {-0.7800374017662247139170972332067321985960,-0.6257328917723579131404676445527002215385}
#define T_2500_987 {-0.7893841869782546316614002535061445087194,-0.6138995075325276440381117026845458894968}
#define T_2500_993 {-0.7985514730335249167225697419780772179365,-0.6019265278387284645589261344866827130318}
#define T_2500_999 {-0.8075371753702420551945806437288410961628,-0.5898166752432919546222933604440186172724}
#define T_2500_1011 {-0.8249556975583226536841152665147092193365,-0.5651973965492598228621545786154456436634}
#define T_2500_1017 {-0.8333845565879515193685733720485586673021,-0.5526935686623315469034878333332017064095}
#define T_2500_1023 {-0.8416239111562147101608388766180723905563,-0.5400640630241156925350765050097834318876}
#define T_2500_1029 {-0.8496718877049364015974219910276588052511,-0.5273117514752824197543645823316182941198}
#define T_2500_1041 {-0.8651864305157446199956439158995635807514,-0.5014503369740861415948529611341655254364}
#define T_2500_1047 {-0.8726494689045877217736801867431495338678,-0.4883471146843615384725012518174480646849}
#define T_2500_1053 {-0.8799140743296104405501978362735826522112,-0.4751328464720838140600278620695462450385}
#define T_2500_1059 {-0.8869785948821864440816398200695402920246,-0.4618105371478895548875698295887559652328}
#define T_2500_1071 {-0.9005010015886493190961914478975813835859,-0.4348539365555282865116737411881331354380}
#define T_2500_1077 {-0.9069558128638635086105068694450892508030,-0.4212257749858722144509215468133334070444}
#define T_2500_1083 {-0.9132043902084862052603853044274728745222,-0.4075018303074807168862037087819771841168}
#define T_2500_1089 {-0.9192453127499148335388667874212842434645,-0.3936852232270234286382049049279885366559}
#define T_2500_1101 {-0.9306987463396931836712155927671119570732,-0.3657866093253325234790906961279688403010}
#define T_2500_1107 {-0.9361086529760148655654461435915436595678,-0.3517109464083127967626296594971790909767}
#define T_2500_1113 {-0.9413056965773068940350754019164014607668,-0.3375553074551057575192203330516349524260}
#define T_2500_1119 {-0.9462886953806719514403766879695467650890,-0.3233229113359364914614957342564594000578}
#define T_2500_1131 {-0.9556080751593917232966646224667783826590,-0.2946408096142865695732382391724968329072}
#define T_2500_1137 {-0.9599423369881517897894696034200023859739,-0.2801976260743935798203096965153235942125}
#define T_2500_1143 {-0.9640583162076707957055532460799440741539,-0.2656907280106526325624827222782187163830}
#define T_2500_1149 {-0.9679550768797691162603769043926149606705,-0.2511234141665813490718051070871297270060}
#define T_2500_1161 {-0.9750874482725092606827388408419210463762,-0.2218208020484253029103172139002708718181}
#define T_2500_1167 {-0.9783214371534033615418479712388943880796,-0.2070921669356412253559795999535708688200}
#define T_2500_1173 {-0.9813329641761735500082863836723845452070,-0.1923164408499827837673024077957961708307}
#define T_2500_1179 {-0.9841213445455451180876593753055203706026,-0.1774969836641414056011001321166986599565}
#define T_2500_1191 {-0.9890261799952952959102958629955537617207,-0.1477403644367836499373680680946563370526}
#define T_2500_1197 {-0.9911415197583902658706733745930250734091,-0.1328099687938694151156937550695147365332}
#define T_2500_1203 {-0.9930314824871324663746463556890375912189,-0.1178493733093558537561307275609578937292}
#define T_2500_1209 {-0.9946956384202959577933711443620268255472,-0.1028619798936414586609799926009145565331}
#define T_2500_1221 {-0.9973450676736201891969813004834577441216,-0.0728204366033457090034985981219506356865}
#define T_2500_1227 {-0.9983297385364165998922203471011016517878,-0.0577731179166413380543509958897629985586}
#define T_2500_1233 {-0.9990873978258987264666757255326956510544,-0.0427126621211368767694338544060883577913}
#define T_2500_1239 {-0.9996178732568780089806637079163920134306,-0.0276424938346043792825046381267384276725}
#define T_2500_1251 {-0.9999968417282540933399559435201808810234,0.0025132714770037269634561649667148230947}
#define T_2500_1257 {-0.9998452485944885337332266317389439791441,0.0175920113410997225322773829248035326600}
#define T_2500_1263 {-0.9994662992734908435465968068456277251244,0.0326667509335237943313146047330519650131}
#define T_2500_1269 {-0.9988600799350685344180078573117498308420,0.0477340623884916423480540004220529226586}
#define T_2500_1281 {-0.9969664342500459408569213337614201009274,0.0778326986474765225576533111961907707155}
#define T_2500_1287 {-0.9956794385021441318173174295225180685520,0.0928571792811678370371808455274731386453}
#define T_2500_1293 {-0.9941660338363007554107753094285726547241,0.1078605449930568199734537415679369587451}
#define T_2500_1299 {-0.9924265643876858389305084529041778296232,0.1228393841471641101392719974683132022619}
#define T_2500_1311 {-0.9882710646187887748581601954356301575899,0.1527098648982631867720982654645922593772}
#define T_2500_1317 {-0.9858559792233186902521424599399324506521,0.1675947142055242422564731441525509580970}
#define T_2500_1323 {-0.9832167186798331792729754852189216762781,0.1824414539200502061166986322859884239733}
#define T_2500_1329 {-0.9803538831334196457234497756871860474348,0.1972467080212628731672452886414248496294}
#define T_2500_1341 {-0.9739601416592692517681939534668345004320,0.2267193032343216008150932339049177244306}
#define T_2500_1347 {-0.9704306896132062210114099798374809324741,0.2413799425321770664165654807220562361181}
#define T_2500_1353 {-0.9666805699969629461776321477373130619526,0.2559856941126726903590338224603328853846}
#define T_2500_1359 {-0.9627106355554005956420837719633709639311,0.2705332367538536564310902576835360378027}
#define T_2500_1371 {-0.9541149828904684770947142169461585581303,0.2994404772637143663516212654940318316221}
#define T_2500_1377 {-0.9494912192443889509263499348890036344528,0.3137936018751875111298943465953925624490}
#define T_2500_1383 {-0.9446515494831168036071744609216693788767,0.3280753725276349674899734054633881896734}
#define T_2500_1389 {-0.9395970741058202735374038638838101178408,0.3422825416695712275050311745872022584081}
#define T_2500_1401 {-0.9288483524631988563768913991225417703390,0.3704601707692759537948745673929806798697}
#define T_2500_1407 {-0.9231565503644826309326276714273262768984,0.3844242233771806849240704195835860446095}
#define T_2500_1413 {-0.9172548304271764818551559983461629599333,0.3983008612318227892323818650766042992473}
#define T_2500_1419 {-0.9111445346514999155118630369543097913265,0.4120869289054210904410524562990758568048}
#define T_2500_1431 {-0.8983038204117045344432312958815600723028,0.4393748356855865511150227575853932648897}
#define T_2500_1437 {-0.8915763218152700231300400446343701332808,0.4528704697574726933950728380295913666487}
#define T_2500_1443 {-0.8846460864518815858659195328073110431433,0.4662631249899246155266041569120716303587}
#define T_2500_1449 {-0.8775146901972968871419311653880868107080,0.4795497560086358079800561426964122802019}
#define T_2500_1461 {-0.8626549468600877013102490309393033385277,0.5057928851395788738543046747508924454451}
#define T_2500_1467 {-0.8549299787549532458896806019765790551901,0.5187434157905574938496329195913858711720}
#define T_2500_1473 {-0.8470106069452519870210949193278793245554,0.5315759886622380969711798570642713457346}
#define T_2500_1479 {-0.8388986322278397800289440056076273322105,0.5442876857382129562878958495275583118200}
#define T_2500_1491 {-0.8221042958190623028968957441975362598896,0.5693369185252644681938249959785025566816}
#define T_2500_1497 {-0.8134257530149683335096710834477562457323,0.5816687582568207393052261977572925388813}
// Pre-computed twiddles for N=3125
#define T_3125_1 {0.9999979787056996194394287158502265810966,-0.0020106179436128425105922978843864257215}
#define T_3125_2 {0.9999919148309696081966535530227702111006,-0.0040212277591245059252256233151001652004}
#define T_3125_3 {0.9999818084003239127000028929614927619696,-0.0060318213184666685452994805416437884560}
#define T_3125_4 {0.9999676594546185182110775713226757943630,-0.0080423904936367269363772791734845668543}
#define T_3125_6 {0.9999272342631642107591005697031505405903,-0.0120634231799758503966835121445910772309}
#define T_3125_7 {0.9999009581808376845302177571284119039774,-0.0140738704357640138919993688659815234132}
#define T_3125_8 {0.9998706399102956776658857052098028361797,-0.0160842607966839822031257511980584240519}
#define T_3125_9 {0.9998362795741025932372281204152386635542,-0.0180945861355546050441844840861449483782}
#define T_3125_11 {0.9997554332767213391974792102701030671597,-0.0221150092397703161573030428144193137996}
#define T_3125_12 {0.9997089476423616227762636299303267151117,-0.0241250907521987946469099739488228806295}
#define T_3125_13 {0.9996584205960060698359370690013747662306,-0.0261350747368104020795787079123329021968}
#define T_3125_14 {0.9996038523419146226700604529469273984432,-0.0281449530680667990567567215975941508077}
#define T_3125_16 {0.9994825931092484738726966497779358178377,-0.0321643602705289979870606487111217575148}
#define T_3125_17 {0.9994159026208749851960533305827993899584,-0.0341738728929250543120410554820409743115}
#define T_3125_18 {0.9993451719051660298021033668192103505135,-0.0361832473644121063727219222982967039570}
#define T_3125_19 {0.9992704012480567721254942625819239765406,-0.0381924755619158298736159906638931715861}
#define T_3125_21 {0.9991087413350364654363033878325950354338,-0.0422104606456653874690942984670982696116}
#define T_3125_22 {0.9990218527326497621743328636512160301208,-0.0442192012888505334156086234997928841040}
#define T_3125_23 {0.9989309254959092276848764413443859666586,-0.0462277631719966164425272836524527519941}
#define T_3125_24 {0.9988359599923963827450279495678842067719,-0.0482361381753142540174117414153442950919}
#define T_3125_26 {0.9986339157370026642368543434713501483202,-0.0522522950671169342240496291651652427390}
#define T_3125_27 {0.9985268378019036550341525071416981518269,-0.0542600607199319046047847336922131944448}
#define T_3125_28 {0.9984157232335926224209288193378597497940,-0.0562676070216439269677799472901824628934}
#define T_3125_29 {0.9983005724812599179784911029855720698833,-0.0582749258565692096478727535213693045080}
#define T_3125_31 {0.9980581643028729743605254043359309434891,-0.0622888486679549560620650083819782594219}
#define T_3125_32 {0.9979309078567751845056932324951048940420,-0.0642954364177768245003363745126989670098}
#define T_3125_33 {0.9977996171865649577270573900023009628057,-0.0663017642476003282725471876801748294383}
#define T_3125_34 {0.9976642928229964013553399126976728439331,-0.0683078240466674785347223064491117838770}
#define T_3125_36 {0.9973815452203315112811310427787248045206,-0.0723191071149511255367059447962674312294}
#define T_3125_37 {0.9972341231242675130275188166706357151270,-0.0743243141682004004877626357483677566051}
#define T_3125_38 {0.9970826696209049710972749380744062364101,-0.0763292207588244647764597061723179649562}
#define T_3125_39 {0.9969271853225081247984462606837041676044,-0.0783338187818107822835145270801149308681}
#define T_3125_41 {0.9966041268711401945878947117307689040899,-0.0823420567110898643514715899982547853142}
#define T_3125_42 {0.9964365540241614249694634963816497474909,-0.0843456804137256710429682016183505766094}
#define T_3125_43 {0.9962649529941279835654199814598541706800,-0.0863489631414753183724641871776839252561}
#define T_3125_44 {0.9960893244747522912163617547776084393263,-0.0883518967958908663096195823527523316443}
#define T_3125_46 {0.9957259878242276096571572452376130968332,-0.0923566844980165807532657140654919203371}
#define T_3125_47 {0.9955382811618993521562970272498205304146,-0.0943585223560176045154435087169986218214}
#define T_3125_48 {0.9953465499478639788577538638492114841938,-0.0963599787613317743106833290767099242657}
#define T_3125_49 {0.9951507949572119260395197670732159167528,-0.0983610456228942303669171565161377657205}
#define T_3125_51 {0.9947472168277486925802577388822101056576,-0.1023619783584111264662652729384717531502}
#define T_3125_52 {0.9945393953204378911792105100175831466913,-0.1043618280582404994616396720630291383713}
#define T_3125_53 {0.9943275532995045074002860019390936940908,-0.1063612558661334028808909124563797377050}
#define T_3125_54 {0.9941116916213386112133321148576214909554,-0.1083602536992257781012227724204421974719}
#define T_3125_56 {0.9936679128001156824367967601574491709471,-0.1123569271182763978922380943004100117832}
#define T_3125_57 {0.9934399974510738084987337970233056694269,-0.1143545865473282324709103363602480385453}
#define T_3125_58 {0.9932080660328227450506233253690879791975,-0.1163517836878320416138521409266104456037}
#define T_3125_59 {0.9929721194829655983582483713689725846052,-0.1183485104659414421934826577853527851403}
#define T_3125_61 {0.9924881848200004519355843513039872050285,-0.1223405206491314234362732804584084078670}
#define T_3125_62 {0.9922401986632412018707327661104500293732,-0.1243357879161571671877695166585908737034}
#define T_3125_63 {0.9919882012875655963313192842178978025913,-0.1263305525447439847663844147973577491939}
#define T_3125_64 {0.9917321937116951868773639944265596568584,-0.1283248064708791824628519862017128616571}
#define T_3125_66 {0.9912081521153112140254393125360365957022,-0.1323117499700989796451722213532775640488}
#define T_3125_67 {0.9909401202132821495638381747994571924210,-0.1343044234256112745562461441295454278588}
#define T_3125_68 {0.9906680823480190634100495117309037595987,-0.1362965539435923578714948689594166353345}
#define T_3125_69 {0.9903920396192590347439477227453608065844,-0.1382881334706781706334055570550845004618}
#define T_3125_71 {0.9898279440511426052751176030142232775688,-0.1422696073498770641396760083807748742402}
#define T_3125_72 {0.9895398934921924016805405699415132403374,-0.1442594856065292363567209577013272792101}
#define T_3125_73 {0.9892478426305488792280584675609134137630,-0.1462487806814293522794656610130914486945}
#define T_3125_74 {0.9889517926468532893480301027011591941118,-0.1482374845326757950569884769720374606550}
#define T_3125_76 {0.9883477001167012554461166473629418760538,-0.1522130864085841916999441991720232181251}
#define T_3125_77 {0.9880396600123424466488586404011584818363,-0.1541999683615233041056313822991796769202}
#define T_3125_78 {0.9877276256701168488660869115847162902355,-0.1561862269474280917602726503901067189872}
#define T_3125_79 {0.9874115983514510919150097834062762558460,-0.1581718541366722019514412522767088375986}
#define T_3125_81 {0.9867675699112092857490097230765968561172,-0.1621411822194679941411266099748900160193}
#define T_3125_82 {0.9864395713931752851522105629555881023407,-0.1641248670666592412992201843735529109836}
#define T_3125_83 {0.9861075851057746755046196085459087044001,-0.1661078884245337783376328388840192928910}
#define T_3125_84 {0.9857716123910913452732529549393802881241,-0.1680902382765520342022824706873507238925}
#define T_3125_86 {0.9850877131287842924933784161112271249294,-0.1720528914104672013607455482997465878725}
#define T_3125_87 {0.9847397893458840201219572918489575386047,-0.1740331786729877039388014736687182448804}
#define T_3125_88 {0.9843878846651364922237803511961828917265,-0.1760127623909639171806418289634166285396}
#define T_3125_89 {0.9840320005091477417735745802929159253836,-0.1779916345617533202094762145861750468612}
#define T_3125_91 {0.9833082995423005900903490328346379101276,-0.1819472122656161094944593514810549095273}
#define T_3125_92 {0.9829404856570675974580808542668819427490,-0.1839239018079161513963271090688067488372}
#define T_3125_93 {0.9825686981478320980443186272168532013893,-0.1858998478215473648678113249843590892851}
#define T_3125_94 {0.9821929385175778293159964960068464279175,-0.1878750423185728546382478043597075156868}
#define T_3125_96 {0.9814295089862313803408255807880777865648,-0.1918231448262820715289223016952746547759}
#define T_3125_97 {0.9810418421713706926823306275764480233192,-0.1937960368764116148021514618449145928025}
#define T_3125_98 {0.9806502094079417863881076300458516925573,-0.1957681454888915706380458914281916804612}
#define T_3125_99 {0.9802546122791551130859488694113679230213,-0.1977394626912981900890287079164409078658}
#define T_3125_101 {0.9794515313384734023216537934786174446344,-0.2016796909922251301860995909009943716228}
#define T_3125_102 {0.9790440507731043018324612603464629501104,-0.2036485861620234427693532097691786475480}
#define T_3125_103 {0.9786326123354158745826225640485063195229,-0.2056166580643687402663033481076126918197}
#define T_3125_104 {0.9782172176886845260668224000255577266216,-0.2075838987431560256347040649416157975793}
#define T_3125_106 {0.9773745665011578376279999247344676405191,-0.2115158546224699953608450186948175542057}
#define T_3125_107 {0.9769473133668545861141296882124152034521,-0.2134805539277166430700560795230558142066}
#define T_3125_108 {0.9765161108364788233870967815164476633072,-0.2154443902189095150223607788575463928282}
#define T_3125_109 {0.9760809606532049320648525281285401433706,-0.2174073555570663618397020400152541697025}
#define T_3125_111 {0.9751988243804468048381295375293120741844,-0.2213306416359798189930074840958695858717}
#define T_3125_112 {0.9747518418570766396413773691165260970592,-0.2232909465165048568113803639789693988860}
#define T_3125_113 {0.9743009188130220543655468645738437771797,-0.2252503487235948398392793023958802223206}
#define T_3125_114 {0.9738460570711792163578479630814399570227,-0.2272088403361927355650351501026307232678}
#define T_3125_116 {0.9729245248653198840926847879018168896437,-0.2311230601121219974114495698813698254526}
#define T_3125_117 {0.9724578581266789534254257887369021773338,-0.2330787724518731118816816660910262726247}
#define T_3125_118 {0.9719872601409859091958765020535793155432,-0.2350335425500356123507117445115000009537}
#define T_3125_119 {0.9715127328106749615699300193227827548981,-0.2369873625042782094851645524613559246063}
#define T_3125_121 {0.9705518978053511158776700540329329669476,-0.2408921203909155095423955117439618334174}
#define T_3125_122 {0.9700655940145989086786926236527506262064,-0.2428430425379804746821577055015950463712}
#define T_3125_123 {0.9695753686477343036287379618443083018064,-0.2447929829705298987452266601394512690604}
#define T_3125_124 {0.9690812236865368189953073851938825100660,-0.2467419338057568189981338946381583809853}
#define T_3125_126 {0.9680811829874793605910099358879961073399,-0.2506368351730497434637356946041109040380}
#define T_3125_127 {0.9675752912923726301031024377152789384127,-0.2525827699596319142472111707320436835289}
#define T_3125_128 {0.9670654880884228532522683963179588317871,-0.2545276836579875023858221538830548524857}
#define T_3125_129 {0.9665517754365546831962774376734159886837,-0.2564715684056305122773267157754162326455}
#define T_3125_131 {0.9655126301117747944502411883149761706591,-0.2603562196196650413426709747000131756067}
#define T_3125_132 {0.9649872016396999763188091492338571697474,-0.2622969703820098308355568406113889068365}
#define T_3125_133 {0.9644578721213640237763797813386190682650,-0.2642366607856120874764371819765074178576}
#define T_3125_134 {0.9639246436966282249869664155994541943073,-0.2661752829891015359464745415607467293739}
#define T_3125_136 {0.9628464987662028740089681377867236733437,-0.2700492914518839437931774227763526141644}
#define T_3125_137 {0.9623015866190096634369410821818746626377,-0.2719846620501544798287341109244152903557}
#define T_3125_138 {0.9617527842823917483272566641971934586763,-0.2739189331263305327013313217321410775185}
#define T_3125_139 {0.9612000939749314465387897143955342471600,-0.2758520968609500245705135057505685836077}
#define T_3125_141 {0.9600830584003897660849702333507593721151,-0.2797150710500845849360018746665446087718}
#define T_3125_142 {0.9595187176490236335979489012970589101315,-0.2816448658881842703749498468823730945587}
#define T_3125_143 {0.9589504979582272881089011207222938537598,-0.2835735221519596338524138445791322737932}
#define T_3125_144 {0.9583784016250791459867741650668904185295,-0.2855010320446468297106434874876867979765}
#define T_3125_146 {0.9572225882983903533229863569431472569704,-0.2893525815529045530638541094958782196045}
#define T_3125_147 {0.9566388759773274408360066445311531424522,-0.2912766055982449198147321567375911399722}
#define T_3125_148 {0.9560512963588494450561938720056787133217,-0.2931994521320998581259686943667475134134}
#define T_3125_149 {0.9554598518182989552727235604834277182817,-0.2951211133811917908253974474064307287335}
#define T_3125_151 {0.9542653775504630342396694686613045632839,-0.2989608489559664183943255011399742215872}
#define T_3125_152 {0.9536623526519457660910461527237202972174,-0.3008789077591778049480808476801030337811}
#define T_3125_153 {0.9530554724888725681708478987275157123804,-0.3027957502327464633928855164413107559085}
#define T_3125_154 {0.9524447395146103945151594416529405862093,-0.3047113686276669008989870235382113605738}
#define T_3125_156 {0.9512117250238529830852485247305594384670,-0.3085389022103143252806489726935978978872}
#define T_3125_157 {0.9505894484919280573720357097045052796602,-0.3104508019248977124249222470098175108433}
#define T_3125_158 {0.9499633291179345739863038033945485949516,-0.3123614466146081292130531892325961962342}
#define T_3125_159 {0.9493333694330156058427405696420464664698,-0.3142708285554951519458199982182122766972}
#define T_3125_161 {0.9480619393325872001909715436340775340796,-0.3180857733205522119845909401192329823971}
#define T_3125_162 {0.9474204740569465155175521431374363601208,-0.3199913207224700517627979934331960976124}
#define T_3125_163 {0.9467751787500973126299186333199031651020,-0.3218955745311223859417282255890313535929}
#define T_3125_164 {0.9461260560207028769141857083013746887445,-0.3237985270483944577613044657482532784343}
#define T_3125_166 {0.9448163388062852385829160084540490061045,-0.3276004974426728888481363810569746419787}
#define T_3125_167 {0.9441557496159099782673251866071950644255,-0.3294994999498771504065075532707851380110}
#define T_3125_168 {0.9434913435922639424191515900020021945238,-0.3313971704261588491213785800937330350280}
#define T_3125_169 {0.9428231234212672839944957559055183082819,-0.3332935012000171060009279244695790112019}
#define T_3125_171 {0.9414752514579873832190060056746006011963,-0.3370821129815692596132237213168991729617}
#define T_3125_172 {0.9407956051145959230908033532614354044199,-0.3389743786734643604674488415184896439314}
#define T_3125_173 {0.9401121555216156444600983377313241362572,-0.3408652740314002671517812359525123611093}
#define T_3125_174 {0.9394249054419518962788515636930242180824,-0.3427547914112649696249945918680168688297}
#define T_3125_176 {0.9380390149510041686298222884943243116140,-0.3465296616882165281481320562306791543961}
#define T_3125_177 {0.9373403801423052517094447466661222279072,-0.3484149993250558741131328588380711153150}
#define T_3125_178 {0.9366379560520705638282379368320107460022,-0.3502989284633905575638834761775797232985}
#define T_3125_179 {0.9359317455199115398656317665881942957640,-0.3521814414872701526348919287556782364845}
#define T_3125_181 {0.9345079765647911207437914526963140815496,-0.3559421887565168973743823244149098172784}
#define T_3125_182 {0.9337904238975416326695722091244533658028,-0.3578204077987299780438945617788704112172}
#define T_3125_183 {0.9330690962997690851565835146175231784582,-0.3596971803202413942024406878772424533963}
#define T_3125_184 {0.9323439966875040063598589767934754490852,-0.3615724987340318552497819837299175560474}
#define T_3125_186 {0.9308824931598510543651059379044454544783,-0.3653187429197957691862086448963964357972}
#define T_3125_187 {0.9301460951527206200140085456951055675745,-0.3671896535472451428283591212675673887134}
#define T_3125_188 {0.9294059369475888843226130120456218719482,-0.3690590797779866871763942981488071382046}
#define T_3125_189 {0.9286620215366109265531235905655194073915,-0.3709270140546993554941934689850313588977}
#define T_3125_191 {0.9271629311416688112856832049146760255098,-0.3746583765469405080672515850892523303628}
#define T_3125_192 {0.9264077622179104354316336866759229451418,-0.3765217896781055118005099302536109462380}
#define T_3125_193 {0.9256488482086927538361464939953293651342,-0.3783836806865756297035829902597470209002}
#define T_3125_194 {0.9248861921819930831389910963480360805988,-0.3802440420454914482562003286147955805063}
#define T_3125_196 {0.9233496664236803264103059518674854189157,-0.3839601457381718874195541957305977120996}
#define T_3125_197 {0.9225758029036089657992647516948636621237,-0.3858158730492581289794884469301905483007}
#define T_3125_198 {0.9217982097891134207756635987607296556234,-0.3876700406654939312645069549034815281630}
#define T_3125_199 {0.9210168902236826049545470596058294177055,-0.3895226410912425163424188667704584077001}
#define T_3125_201 {0.9194430843892817950546714200754649937153,-0.3932231104204381155753367238503415137529}
#define T_3125_202 {0.9186506044825611949633525910030584782362,-0.3950709643644100821369136156135937198997}
#define T_3125_203 {0.9178544108493787989644374647468794137239,-0.3969172211990049659036117191135417670012}
#define T_3125_204 {0.9170545067084178159078078351740259677172,-0.3987618734605659631675678156170761212707}
#define T_3125_206 {0.9154435798528809398177941147878300398588,-0.4024463344424223376627480774914147332311}
#define T_3125_207 {0.9146325636506195122521489793143700808287,-0.4042861282679576784282460266695125028491}
#define T_3125_208 {0.9138178499651823383231885600253008306026,-0.4061242877309994003809379137237556278706}
#define T_3125_209 {0.9129994420901216267694167072477284818888,-0.4079608054006250705825209479371551424265}
#define T_3125_211 {0.9113515570199959281438850666745565831661,-0.4116288856691536213183724157715914770961}
#define T_3125_212 {0.9105220864866522267888626629428472369909,-0.4134604334395170499583116452413378283381}
#define T_3125_213 {0.9096889350871010249122150526090990751982,-0.4152903097594453640795109095051884651184}
#define T_3125_214 {0.9088521061894305752559830580139532685280,-0.4171185072315014008559330704883905127645}
#define T_3125_216 {0.9071674294464044940866642718901857733727,-0.4207698360762124889511426317767472937703}
#define T_3125_217 {0.9063195884115039513417855232546571642160,-0.4225929526880470854521831824968103319407}
#define T_3125_218 {0.9054680834993666938004253097460605204105,-0.4244143609304284470162826892192242667079}
#define T_3125_219 {0.9046129181522766238288113527232781052589,-0.4262340534401522496033010156679665669799}
#define T_3125_221 {0.9028916199963485933466245114686898887157,-0.4298682618435202273943218642671126872301}
#define T_3125_222 {0.9020254941460109643358578068728093057871,-0.4316827630455549735799536392732989042997}
#define T_3125_223 {0.9011557217776930972519267015741206705570,-0.4334955191317726441724289543344639241695}
#define T_3125_224 {0.9002823064075267112116307544056326150894,-0.4353065227739462139666670736914966255426}
#define T_3125_226 {0.8985245607997978112280179630033671855927,-0.4389232434487041478732294308429118245840}
#define T_3125_227 {0.8976402376680776562523078609956428408623,-0.4407289458603747545062390145176323130727}
#define T_3125_228 {0.8967522857461649454791086100158281624317,-0.4425328665862328092472921525768470019102}
#define T_3125_229 {0.8958607086236841654525164813094306737185,-0.4443349983337688824391875641595106571913}
#define T_3125_231 {0.8940666932087770746306887303944677114487,-0.4479338657600277495696161622618092224002}
#define T_3125_232 {0.8931642621688168359739279367204289883375,-0.4497305868900101089025156397838145494461}
#define T_3125_233 {0.8922582204331918065420836683188099414110,-0.4515254899442484592952951061306521296501}
#define T_3125_234 {0.8913485716646558643105890951119363307953,-0.4533185676666882102381350705400109291077}
#define T_3125_236 {0.8895184677527612215897079295245930552483,-0.4568992181288779041992142992967274039984}
#define T_3125_237 {0.8885980200077596702357141111860983073711,-0.4586867763935311148593143570906249806285}
#define T_3125_238 {0.8876739800265316393534931194153614342213,-0.4604724803762507701065942455898039042950}
#define T_3125_239 {0.8867463515445908051049173081992194056511,-0.4622563228581703098640787175099831074476}
#define T_3125_241 {0.8848803440931434227678664683480747044086,-0.4658183944817981259056693943421123549342}
#define T_3125_242 {0.8839419726671373656046171163325197994709,-0.4675966092235163129586794639180880039930}
#define T_3125_243 {0.8830000278273887337476821812742855399847,-0.4693729336645122707238897419301792979240}
#define T_3125_244 {0.8820545133817931926500932604540139436722,-0.4711473606238370526178016461926745250821}
#define T_3125_246 {0.8801527909767796753470747717074118554592,-0.4746904934120601549096818416728638112545}
#define T_3125_247 {0.8791965907052431417056936879816930741072,-0.4764591849175301985219732614496024325490}
#define T_3125_248 {0.8782368362035910536178562324494123458862,-0.4782259502945305218446492290240712463856}
#define T_3125_249 {0.8772735313517161515051157039124518632889,-0.4799907824007556000900365233974298462272}
#define T_3125_251 {0.8753362861886154755453048892377410084009,-0.4835146182707635853503802536579314619303}
#define T_3125_252 {0.8743623537088749397838682853034697473049,-0.4852736077891278143603415173856774345040}
#define T_3125_253 {0.8733848865418503137902916932944208383560,-0.4870306355459368408133968841866590082645}
#define T_3125_254 {0.8724038886390392821823525082436390221119,-0.4887856944382504287283097710314905270934}
#define T_3125_256 {0.8704313165033988886065685619541909545660,-0.4922898772574547110458809129340806975961}
#define T_3125_257 {0.8694397502448671932739898693398572504520,-0.4940389870183759524202571355999680235982}
#define T_3125_258 {0.8684446691991120070852616663614753633738,-0.4957860995829199146633925465721404179931}
#define T_3125_259 {0.8674460773888366116324277754756622016430,-0.4975312078882292432524536707205697894096}
#define T_3125_261 {0.8654383776364853453344494482735171914101,-0.5010153835102553188107776804827153682709}
#define T_3125_262 {0.8644292778107135477583256033540237694979,-0.5027544367418832482741208877996541559696}
#define T_3125_263 {0.8634166834529969358769108112028334289789,-0.5044914575441562520907723410346079617739}
#define T_3125_264 {0.8624005986568381576518049769219942390919,-0.5062264388950138416234381111280526965857}
#define T_3125_266 {0.8603579741937387170835904726118315011263,-0.5096902551954921589683067395526450127363}
#define T_3125_267 {0.8593314427842885239172687761310953646898,-0.5114190761423287323594877307186834514141}
#define T_3125_268 {0.8583014374513434630031838423747103661299,-0.5131458296322377599096853373339399695396}
#define T_3125_269 {0.8572679623587912134397015506692696362734,-0.5148705086846654399579392702435143291950}
#define T_3125_271 {0.8551906196205338872573520347941666841507,-0.5183136155968193214960137993330135941505}
#define T_3125_272 {0.8541467603726708990308225111220963299274,-0.5200320295374807333388389452011324465275}
#define T_3125_273 {0.8530994481608509261150175007060170173645,-0.5217483412025873956707755496609024703503}
#define T_3125_274 {0.8520486872189265703525506978621706366539,-0.5234625436537975184947413254121784120798}
#define T_3125_276 {0.8499368361498657042929494309646543115377,-0.5268845932038214163739553441700991243124}
#define T_3125_277 {0.8488757545600743581459823872137349098921,-0.5285924264686966411730395520862657576799}
#define T_3125_278 {0.8478112413148340964497151617251802235842,-0.5302981228518540701699635064869653433561}
#define T_3125_279 {0.8467433007175340087258064158959314227104,-0.5320016754578651418938761707977391779423}
#define T_3125_281 {0.8445971547495705333830073868739418685436,-0.5354023218000927286652768088970333337784}
#define T_3125_282 {0.8435189580548921872704681845789309591055,-0.5370994017888950367023426224477589130402}
#define T_3125_283 {0.8424373513600895702069237813702784478664,-0.5387943105057783066413890082912985235453}
#define T_3125_284 {0.8413523390376533850343321319087408483028,-0.5404870410989236484411435412766877561808}
#define T_3125_286 {0.8391721150686640706695129665604326874018,-0.5438659405507801913870480348123237490654}
#define T_3125_287 {0.8380769122358595613064835561090148985386,-0.5455520957499909728838360933877993375063}
#define T_3125_288 {0.8369783214028830853337126427504699677229,-0.5472360455065182760492348279512953013182}
#define T_3125_289 {0.8358763470108853121942615871375892311335,-0.5489177830128461055281263725191820412874}
#define T_3125_291 {0.8336622653828029694267343074898235499859,-0.5522745940895824601213348614692222326994}
#define T_3125_292 {0.8325501670973394219288366002729162573814,-0.5539496540897848042561690817819908261299}
#define T_3125_293 {0.8314347031540608723432228543970268219709,-0.5556224746994300467406446841778233647346}
#define T_3125_294 {0.8303158780623289825228994232020340859890,-0.5572930491559927590472511838015634566545}
#define T_3125_296 {0.8280681625388729427683642825286369770765,-0.5606274326051968737161246281175408512354}
#define T_3125_297 {0.8269392811937380516340567737643141299486,-0.5622912281182979032934099450358189642429}
#define T_3125_298 {0.8258070568732914784604304259119089692831,-0.5639527505192898360064646112732589244843}
#define T_3125_299 {0.8246714941546503530034328832698520272970,-0.5656119930913210414047398444381542503834}
#define T_3125_301 {0.8223903718987130018192033276136498898268,-0.5689236119272046421357913459360133856535}
#define T_3125_302 {0.8212448215830556730310263446881435811520,-0.5705759748035444944846972248342353850603}
#define T_3125_303 {0.8200959513124441713216583593748509883881,-0.5722260310759527124346845994296018034220}
#define T_3125_304 {0.8189437657312883533933245416847057640553,-0.5738737740739305870363295980496332049370}
#define T_3125_306 {0.8166294672819763844628937476954888552427,-0.5771622936113857127438109273498412221670}
#define T_3125_307 {0.8154673637695768473321322744595818221569,-0.5788030568567313904893012477259617298841}
#define T_3125_308 {0.8143019636581082520976337946194689720869,-0.5804414802394372019378465665795374661684}
#define T_3125_309 {0.8131332716588036690907870251976419240236,-0.5820775571360317091063052430399693548679}
#define T_3125_311 {0.8107860309081392768959517525217961519957,-0.5853426450244555434565540963376406580210}
#define T_3125_312 {0.8096074916457082215615059794799890369177,-0.5869716428168779698282264689623843878508}
#define T_3125_313 {0.8084256794732602724451453468645922839642,-0.5885982677244280258932462857046630233526}
#define T_3125_314 {0.8072405991683758719190677766164299100637,-0.5902225131713306760516957183426711708307}
#define T_3125_316 {0.8048606533376586602557267724478151649237,-0.5934638394282142348501452033815439790487}
#define T_3125_317 {0.8036657974329676212832396231533493846655,-0.5950809071348468481943427832447923719883}
#define T_3125_318 {0.8024676926380851504916336125461384654045,-0.5966955691741875345002199537702836096287}
#define T_3125_319 {0.8012663437964558932335989993589464575052,-0.5983078190188222400536233180901035666466}
#define T_3125_321 {0.7988539334122881641064850555267184972763,-0.6015250560630998055700047189020551741123}
#define T_3125_322 {0.7976428816221325934776587018859572708607,-0.6031300302567769167083611137059051543474}
#define T_3125_323 {0.7964286052899561818563256565539631992579,-0.6047325662438688409494602638005744665861}
#define T_3125_324 {0.7952111093245786133110186710837297141552,-0.6063326575459819789415405466570518910885}
#define T_3125_326 {0.7927664781945572558541357466310728341341,-0.6095254802311372843703907165036071091890}
#define T_3125_327 {0.7915393529125513971678174129920080304146,-0.6111181987069108645371784405142534524202}
#define T_3125_328 {0.7903090277625803850014563067816197872162,-0.6127084466832206643971403536852449178696}
#define T_3125_329 {0.7890755077183425614251177648839075118303,-0.6142962177313482374785280626383610069752}
#define T_3125_331 {0.7865989029064184290263028742629103362560,-0.6174643033782754031335571198724210262299}
#define T_3125_332 {0.7853558281506265448257408934296108782291,-0.6190446051698080820457903428177814930677}
#define T_3125_333 {0.7841095785243161753186313944752328097820,-0.6206224044186765542718831056845374405384}
#define T_3125_334 {0.7828601590655618336356269537645857781172,-0.6221976947464874507787158108840230852365}
#define T_3125_336 {0.7803518308670708281127303962421137839556,-0.6253407231761022311289366371056530624628}
#define T_3125_337 {0.7790929322674731150044635796803049743176,-0.6269084485719350618992962154152337461710}
#define T_3125_338 {0.7778308841156683639539437535859178751707,-0.6284736396348200582195886454428546130657}
#define T_3125_339 {0.7765656915135982218956200995307881385088,-0.6300362900373335239834204912767745554447}
#define T_3125_341 {0.7740258934299651949473286549618933349848,-0.6331539436029315348619661563134286552668}
#define T_3125_342 {0.7727512982157611620692705400870181620121,-0.6347089341626253045092198590282350778580}
#define T_3125_343 {0.7714735790859676978215020426432602107525,-0.6362613588552169519019230392586905509233}
#define T_3125_344 {0.7701927412058775512804231766494922339916,-0.6378112114048921643671974379685707390308}
#define T_3125_346 {0.7676217299189967979700099931505974382162,-0.6409031750242518699067773013666737824678}
#define T_3125_347 {0.7663315669057469969871476678235922008753,-0.6424452735943992909284361303434707224369}
#define T_3125_348 {0.7650383059292404919204955149325542151928,-0.6439847750226070921542032010620459914207}
#define T_3125_349 {0.7637419522175991071222256323380861431360,-0.6455216730853042816917763957462739199400}
#define T_3125_351 {0.7611399875638927836618563560477923601866,-0.6485876342725299670277649966010358184576}
#define T_3125_352 {0.7598343871405003335794958729820791631937,-0.6501166850026387500349756010109558701515}
#define T_3125_353 {0.7585257150192760144946646505559328943491,-0.6516431075784475668299933204252738505602}
#define T_3125_354 {0.7572139764906425929424926835054066032171,-0.6531668958292577986668447920237667858601}
#define T_3125_356 {0.7545813214348007225140690934495069086552,-0.6562065447263611961403739769593812525272}
#define T_3125_357 {0.7532604155503335174870471746544353663921,-0.6577223930846043398190658990642987191677}
#define T_3125_358 {0.7519364645438969541046958511287812143564,-0.6592355825417987036374256604176480323076}
#define T_3125_359 {0.7506094737676803907433509266411419957876,-0.6607461069807418763133455286151729524136}
#define T_3125_361 {0.7479463943760847888242437875305768102407,-0.6637591363889572271261840796796604990959}
#define T_3125_362 {0.7466103165264401653189452190417796373367,-0.6652616291777910806359841444646008312702}
#define T_3125_363 {0.7452712204384407401747125732072163373232,-0.6667614325875462766290979743644129484892}
#define T_3125_364 {0.7439291115255011188622802364989183843136,-0.6682585405551346724450922920368611812592}
#define T_3125_366 {0.7412358769393354585020006197737529873848,-0.6712446459659654474094736542610917240381}
#define T_3125_367 {0.7398847621537489871457182744052261114120,-0.6727336313376122145513136274530552327633}
#define T_3125_368 {0.7385306563184570460833811011980287730694,-0.6742198971239494742491160650388337671757}
#define T_3125_369 {0.7371735649075524809958892547001596540213,-0.6757034373166163065960176936641801148653}
#define T_3125_371 {0.7344504473156021617796795908361673355103,-0.6786623169426102553103419268154539167881}
#define T_3125_372 {0.7330844321430003418527121539227664470673,-0.6801376444144042743289446661947295069695}
#define T_3125_373 {0.7317154534116298014723156484251376241446,-0.6816102223695100770228805231454316526651}
#define T_3125_374 {0.7303435166557081803517803564318455755711,-0.6830800448549008141441163388662971556187}
#define T_3125_376 {0.7275907912668513333187547686975449323654,-0.6860113996601494568139401053485926240683}
#define T_3125_377 {0.7262100137620521866921308173914439976215,-0.6874729201297459235675546551647130399942}
#define T_3125_378 {0.7248263004889297089761157621978782117367,-0.6889316614291520757262787810759618878365}
#define T_3125_379 {0.7234396570412673366234912464278750121593,-0.6903876176612769866025587361946236342192}
#define T_3125_381 {0.7206576020566615170537261292338371276855,-0.6932911513916375501054289998137392103672}
#define T_3125_382 {0.7192622017664218603272274776827543973923,-0.6947387171520809090452530654147267341614}
#define T_3125_383 {0.7178638937950043708013936338829807937145,-0.6961834743697056238076470435771625488997}
#define T_3125_384 {0.7164626837951929561043584726576227694750,-0.6976254172039528800297603083890862762928}
#define T_3125_386 {0.7136515803801591895094702522328589111567,-0.7005008364169890144879104809660930186510}
#define T_3125_387 {0.7122416983290714709298185880470555275679,-0.7019343011716409064248978211253415793180}
#define T_3125_388 {0.7108289369778131305821489149820990860462,-0.7033649282946884406797494193597231060266}
#define T_3125_389 {0.7094133020375968934345678462705109268427,-0.7047927120026946656849986538873054087162}
#define T_3125_391 {0.7065734342932037392870370240416377782822,-0.7076397260973324998545308517350349575281}
#define T_3125_392 {0.7051492129694435506692684612062294036150,-0.7090589449746574901567441884253639727831}
#define T_3125_393 {0.7037221410175132918496387901541311293840,-0.7104752974183741187630403146613389253616}
#define T_3125_394 {0.7022922242064775222303296686732210218906,-0.7118887777027523844353140702878590673208}
#define T_3125_396 {0.6994238791408284861006450228160247206688,-0.7147070989486502545773305428156163543463}
#define T_3125_397 {0.6979854624817544150872095087834168225527,-0.7161119285168564552179759630234912037849}
#define T_3125_398 {0.6965442241546061508117304583720397204161,-0.7175138631391436705442288257472682744265}
#define T_3125_399 {0.6951001699857173310448388292570598423481,-0.7189128971480667207316628264379687607288}
#define T_3125_401 {0.6922036374849456219493504249840043485165,-0.7217022407146939100286431312269996851683}
#define T_3125_402 {0.6907511708625518886961458520090673118830,-0.7230925389962294946855081434478051960468}
#define T_3125_403 {0.6892959118173488386460689980594906955957,-0.7244799141121096575091087288456037640572}
#define T_3125_404 {0.6878378662323501036013340126373805105686,-0.7258643604537473592586138693150132894516}
#define T_3125_406 {0.6849134390313202924716051711584441363811,-0.7286244444391705155084082434768788516521}
#define T_3125_407 {0.6834470692375453904077176048303954303265,-0.7300000709250717978449074507807381451130}
#define T_3125_408 {0.6819779365484390787344182172091677784920,-0.7313727463210076829014383292815182358027}
#define T_3125_409 {0.6805060469031005698781200408120639622211,-0.7327424650778164849640461397939361631870}
#define T_3125_411 {0.6775540205558249207129506430646870285273,-0.7354730105371893866816890295012854039669}
#define T_3125_412 {0.6760738957877159283071932804887183010578,-0.7368338262012816830548445068416185677052}
#define T_3125_413 {0.6745910379309825177784887273446656763554,-0.7381916631493474767466977937147021293640}
#define T_3125_414 {0.6731054529802089625434291519923135638237,-0.7395465158922105430860938213299959897995}
#define T_3125_416 {0.6701261258299767709090133394056465476751,-0.7422472468659658817458080193318892270327}
#define T_3125_417 {0.6686323956747121100008257599256467074156,-0.7435931141789138276720905196270905435085}
#define T_3125_418 {0.6671359625137466276001418918895069509745,-0.7449359754508146913565269642276689410210}
#define T_3125_419 {0.6656368323965439204314975540910381823778,-0.7462758252530329317053769955236930400133}
#define T_3125_421 {0.6626305055457700765586537272611167281866,-0.7489464687947712251414600359566975384951}
#define T_3125_422 {0.6611233209655417164540835983643773943186,-0.7502772517379781014312811748823150992393}
#define T_3125_423 {0.6596134637357122798562159005086869001389,-0.7516050016189196325555599287326913326979}
#define T_3125_424 {0.6581009399600133980001714917307253926992,-0.7529297130700494111721354784094728529453}
#define T_3125_426 {0.6550679172398078398131815447413828223944,-0.7555699992741243820049135138106066733599}
#define T_3125_427 {0.6535474305565642794135783333331346511841,-0.7568855633534786742089295330515597015619}
#define T_3125_428 {0.6520243018499277676269798575958702713251,-0.7581980676558824905342248712258879095316}
#define T_3125_429 {0.6504985372772812413089127403509337455034,-0.7595075068754209013377476367168128490448}
#define T_3125_431 {0.6474391252167425170327419436944182962179,-0.7621171689042173236217081466747913509607}
#define T_3125_432 {0.6459054900967945433976069580239709466696,-0.7634173811636852935436081679654307663441}
#define T_3125_433 {0.6443692438466751548631350487994495779276,-0.7647145072407506294354107012622989714146}
#define T_3125_434 {0.6428303926767959808330488158389925956726,-0.7660085418916660060517642705235630273819}
#define T_3125_436 {0.6397449004720320298034152983746025711298,-0.7685873160025670225437011140456888824701}
#define T_3125_437 {0.6381982719105230295042474608635529875755,-0.7698720450376297375072454087785445153713}
#define T_3125_438 {0.6366490633759549488956963614327833056450,-0.7711536617967390538908034613996278494596}
#define T_3125_439 {0.6350972811311405008538599759049247950315,-0.7724321610988457154078901112370658665895}
#define T_3125_441 {0.6319860206140206493330424564192071557045,-0.7749797866708877380759190600656438618898}
#define T_3125_442 {0.6304265549192614725981798073917161673307,-0.7762489026418211146562953217653557658195}
#define T_3125_443 {0.6288645406692977557483459349896293133497,-0.7775148805577891675255841619218699634075}
#define T_3125_444 {0.6272999841787104680079778518120292574167,-0.7787777153009641795122774965420830994844}
#define T_3125_446 {0.6241632697853498612516887078527361154556,-0.7812939348611767087504631490446627140045}
#define T_3125_447 {0.6225911245630223467273367532470729202032,-0.7825473095061736827915410685818642377853}
#define T_3125_448 {0.6210164624609116890141535805014427751303,-0.7837975206343377188034082792000845074654}
#define T_3125_449 {0.6194392898447290685126631615275982767344,-0.7850445631915794475474967839545570313931}
#define T_3125_451 {0.6162774385837108681585050362627953290939,-0.7875291224410057022708997465088032186031}
#define T_3125_452 {0.6146927727209392511298347017145715653896,-0.7887666290891391929207543398661073297262}
#define T_3125_453 {0.6131056219081716385232994070975109934807,-0.7900009470782893838958216292667202651501}
#define T_3125_454 {0.6115159925616057146058324178738985210657,-0.7912320714186161785264062018541153520346}
#define T_3125_456 {0.6083293239819429487624802277423441410065,-0.7936847192580138710127357626333832740784}
#define T_3125_457 {0.6067322976312361504369619069620966911316,-0.7949062328420384293536926634260453283787}
#define T_3125_458 {0.6051328185114591695636931945045944303274,-0.7961245329471874354609894908207934349775}
#define T_3125_459 {0.6035308930886481570965429455100093036890,-0.7973396146483747726207980122126173228025}
#define T_3125_461 {0.6003197292474887758473300891637336462736,-0.7997601032035930312957816568086855113506}
#define T_3125_462 {0.5987105038105547949456308742810506373644,-0.8009655002725845074351695984660182148218}
#define T_3125_463 {0.5970988580333630446617121378949377685785,-0.8021676593675749478151715265994425863028}
#define T_3125_464 {0.5954847984311341102525716451054904609919,-0.8033665756287297066151609215012285858393}
#define T_3125_466 {0.5922494638612127992871592141455039381981,-0.8057546602757603704247912901337258517742}
#define T_3125_467 {0.5906282019726468712761402457545045763254,-0.8069438190075924888233771525847259908915}
#define T_3125_468 {0.5890045524172444757482480781618505716324,-0.8081297155975404322703070647548884153366}
#define T_3125_469 {0.5873785217587526030769140561460517346859,-0.8093123452515119664596454640559386461973}
#define T_3125_471 {0.5841193434355919089639996855112258344889,-0.8116677846412121422048357999301515519619}
#define T_3125_472 {0.5824862089464400982663505601522047072649,-0.8128405848548682088861028205428738147020}
#define T_3125_473 {0.5808507197051799852971498694387264549732,-0.8140100990884415743664703768445178866386}
#define T_3125_474 {0.5792128823234214962667465442791581153870,-0.8151763226140674722941525942587759345770}
#define T_3125_476 {0.5759301896322867042599114029144402593374,-0.8174988786965510234594489702431019395590}
#define T_3125_477 {0.5742853475934862617080511881795246154070,-0.8186552018642699879436008814082015305758}
#define T_3125_478 {0.5726381839552860952835544594563543796539,-0.8198082155458018549509802141983527690172}
#define T_3125_479 {0.5709887053764910458397707770927809178829,-0.8209579150799867219845395993615966290236}
#define T_3125_481 {0.5676828300791010306625139492098242044449,-0.8232473531286830237263529852498322725296}
#define T_3125_482 {0.5660264467247998476651105193013790994883,-0.8243870823879382303545071408734656870365}
#define T_3125_483 {0.5643677751584373902815627843665424734354,-0.8255234789893716174091764514741953462362}
#define T_3125_484 {0.5627068220853403968106931642978452146053,-0.8266565383389991028550980445288587361574}
#define T_3125_486 {0.5593780982863387762904494593385607004166,-0.8289126269743748443019626392924692481756}
#define T_3125_487 {0.5577103410170949349122793137212283909321,-0.8300356471396850288613222801359370350838}
#define T_3125_488 {0.5560403291543840609278959163930267095566,-0.8311553118123496952662776493525598198175}
#define T_3125_489 {0.5543680694493768879027584262075833976269,-0.8322716164660254323237609241914469748735}
#define T_3125_491 {0.5510168335625656998999488678236957639456,-0.8344941276789691331217113656748551875353}
#define T_3125_492 {0.5493378709284297833903565333457663655281,-0.8356003252535387781918529981339816004038}
#define T_3125_493 {0.5476566875472788087364506282028742134571,-0.8367031448397587167775668604008387774229}
#define T_3125_494 {0.5459732902154454947662998165469616651535,-0.8378025819793830653026134314131923019886}
#define T_3125_496 {0.5425998809297863934020256238000001758337,-0.8399912911542486426696996204555034637451}
#define T_3125_497 {0.5409098826132664461496801777684595435858,-0.8410805543414390239576050589676015079021}
#define T_3125_498 {0.5392176976206208838249267500941641628742,-0.8421664173859680913025727022613864392042}
#define T_3125_499 {0.5375233327926577375777128509071189910173,-0.8432488758981382392931891445186920464039}
#define T_3125_501 {0.5341280910380421520500249243923462927341,-0.8454035618354449610478695831261575222015}
#define T_3125_502 {0.5324272278369555078114672141964547336102,-0.8464757805500725540426287807349581271410}
#define T_3125_503 {0.5307242122516268034715380963461939245462,-0.8475445773113590153258201098651625216007}
#define T_3125_504 {0.5290190511666476025354199919092934578657,-0.8486099477985984407268915674649178981781}
#define T_3125_506 {0.5256023200794416316838919556175824254751,-0.8507303927373867091787928984558675438166}
#define T_3125_507 {0.5238907638896531659966626648383680731058,-0.8517854586168489561259775655344128608704}
#define T_3125_508 {0.5221770898250346348845596367027610540390,-0.8528370810781258359867251783725805580616}
#define T_3125_509 {0.5204613048132650243715602300653699785471,-0.8538852558699403516584425233304500579834}
#define T_3125_511 {0.5170234297016305102800970416865311563015,-0.8559712455097794325808990834048017859459}
#define T_3125_512 {0.5153013534996803146626120906148571521044,-0.8570090519250058713751627692545298486948}
#define T_3125_513 {0.5135771941463525003257473144913092255592,-0.8580433938052083320258134335745126008987}
#define T_3125_514 {0.5118509586117139242844586988212540745735,-0.8590742669689679367195367376552894711494}
#define T_3125_516 {0.5083922869207100347921368665993213653564,-0.8611255904916137460247682611225172877312}
#define T_3125_517 {0.5066598647463314009087298472877591848373,-0.8621460325578429451098827485111542046070}
#define T_3125_518 {0.5049253943545591871711053499893750995398,-0.8631629893223485838760211663611698895693}
#define T_3125_519 {0.5031888827571434630314684000040870159864,-0.8641764566739930097938326980511192232370}
#define T_3125_521 {0.4997097640336128354654476879659341648221,-0.8661929067646946256431306210288312286139}
#define T_3125_522 {0.4979671709721436578810482842527562752366,-0.8671958813520737052726872207131236791611}
#define T_3125_523 {0.4962225648342655781597443365171784535050,-0.8681953502232681030292837931483518332243}
#define T_3125_524 {0.4944759526727033893678253662073984742165,-0.8691913093378363930341379273158963769674}
#define T_3125_526 {0.4909767385299455000335910881403833627701,-0.8711726822062877406693814918980933725834}
#define T_3125_527 {0.4892241506946329865357370181300211697817,-0.8721580879502952576842744747409597039223}
#define T_3125_528 {0.4874695851273456170815734367351979017258,-0.8731399679179584483179610288061667233706}
#define T_3125_529 {0.4857130489210702006808162423112662509084,-0.8741183181399404533706842812534887343645}
#define T_3125_531 {0.4821940930033059014014895637956215068698,-0.8760644135408761634664642770076170563698}
#define T_3125_532 {0.4804316875175080325810483827808639034629,-0.8770321508525668052769219684705603867769}
#define T_3125_533 {0.4786673398440468019110483055555960163474,-0.8779963426840818874197225341049488633871}
#define T_3125_534 {0.4769010571154539412930262187728658318520,-0.8789569851375905740198390958539675921202}
#define T_3125_536 {0.4733627150620847157114212677697651088238,-0.8808676063910237941101399883336853235960}
#define T_3125_537 {0.4715906700413696750473491192678920924664,-0.8818175774670926614362542750313878059387}
#define T_3125_538 {0.4698167185735876438812397282163146883249,-0.8827639837174748871362339741608593612909}
#define T_3125_539 {0.4680408678300946312411667804553871974349,-0.8837068213162394547666167454735841602087}
#define T_3125_541 {0.4644834972397605676874832170142326503992,-0.8855817753273388381884956288558896631002}
#define T_3125_542 {0.4627019917739053078697963883314514532685,-0.8865138841600062047376695772982202470303}
#define T_3125_543 {0.4609186157942525285946544499893207103014,-0.8874424091817508797319646873802412301302}
#define T_3125_544 {0.4591333765102576514038901223102584481239,-0.8883673466389284678612625612004194408655}
#define T_3125_546 {0.4555573369046968523754514990287134423852,-0.8902064439175334520371052349219098687172}
#define T_3125_547 {0.4537665510395878509797285005333833396435,-0.8911205963042472255608572595519945025444}
#define T_3125_548 {0.4519739307829922503323416549392277374864,-0.8920311462569964211510864515730645507574}
#define T_3125_549 {0.4501794833817361896066699955554213374853,-0.8929380900948021837493229213578160852194}
#define T_3125_551 {0.4465851361694501697741088719340041279793,-0.8947411447745731161163007527648005634546}
#define T_3125_552 {0.4447852508888873734882452026795363053679,-0.8956372483275298890248450334183871746063}
#define T_3125_553 {0.4429835675245394899235407137894071638584,-0.8965297311875561891980623840936459600925}
#define T_3125_554 {0.4411800933598711282890292295633116737008,-0.8974185897467108485869857759098522365093}
#define T_3125_556 {0.4375678017995996982314466094976523891091,-0.8991854196039136271068059613753575831652}
#define T_3125_557 {0.4357589990070051544357454531564144417644,-0.9000633837593955410838475472701247781515}
#define T_3125_558 {0.4339484346200486175604282834683544933796,-0.9009377093289021587452225503511726856232}
#define T_3125_559 {0.4321361159580969224514035431639058515429,-0.9018083927778950403819635539548471570015}
#define T_3125_561 {0.4285062451221053336780641984660178422928,-0.9035388192498173820510487530555110424757}
#define T_3125_562 {0.4266887076221399510700393875595182180405,-0.9043985552773444736018859657633583992720}
#define T_3125_563 {0.4248694451952689798979179158777697011828,-0.9052546351935815138745056174229830503464}
#define T_3125_564 {0.4230484651960221276212337215838488191366,-0.9061070555377493951354495038685854524374}
#define T_3125_566 {0.4194013819332059744837692960572894662619,-0.9078009037407470671610099088866263628006}
#define T_3125_567 {0.4175752934132940241696019256778527051210,-0.9086423247520453161385489693202544003725}
#define T_3125_568 {0.4157475168082608862896165646816371008754,-0.9094800724962394111727803647227119654417}
#define T_3125_569 {0.4139180595070555135350787168135866522789,-0.9103141435866596298254194152832496911287}
#define T_3125_571 {0.4102541324058653349204917049064533784986,-0.9119712423338307560882753932673949748278}
#define T_3125_572 {0.4084196774176305222425753527204506099224,-0.9127942632916130616393957097898237407207}
#define T_3125_573 {0.4065835713566633979887399163999361917377,-0.9136135941977117091994387010345235466957}
#define T_3125_574 {0.4047458216455854240756195849826326593757,-0.9144292317399088654283900723385158926249}
#define T_3125_576 {0.4010654209967756678167916106758639216423,-0.9160494135583948649426133670203853398561}
#define T_3125_577 {0.3992227849373896075846346320759039372206,-0.9168539512849550598971859471930656582117}
#define T_3125_578 {0.3973785349845239678323594034736743196845,-0.9176547825481832232341616872872691601515}
#define T_3125_579 {0.3955326785937225420042295809253118932247,-0.9184519041106480319314186999690718948841}
#define T_3125_581 {0.3918361763529286112550664711307035759091,-0.9200350052585589688547429432219360023737}
#define T_3125_582 {0.3899855454463738713144493885920383036137,-0.9208209784441785394903945416444912552834}
#define T_3125_583 {0.3881333379886985901485729755222564563155,-0.9216032291294071754350625269580632448196}
#define T_3125_584 {0.3862795614676156064071221862832317128778,-0.9223817541519273577321769153058994561434}
#define T_3125_586 {0.3825673312177624851848634079942712560296,-0.9239276146348905927041528229892719537020}
#define T_3125_587 {0.3807088924960120301932420261437073349953,-0.9246949438460556613961216498864814639091}
#define T_3125_588 {0.3788489147248325639161237177177099511027,-0.9254585348959815105374104859947692602873}
#define T_3125_589 {0.3769874054233490201504253036546288058162,-0.9262183846977836143565809834399260580540}
#define T_3125_591 {0.3732598223368956968926113404450006783009,-0.9277268482851129816069146727386396378279}
#define T_3125_592 {0.3713937636210107862133611433819169178605,-0.9284754559725425515637198259355500340462}
#define T_3125_593 {0.3695262035129306399383608550124336034060,-0.9292203102156776362008372416312340646982}
#define T_3125_594 {0.3676571495624325058848569369729375466704,-0.9299614080033790086687872644688468426466}
#define T_3125_596 {0.3639145903634553591565747865388402715325,-0.9314323222438646299181641552422661334276}
#define T_3125_597 {0.3620411002446035642066135551431216299534,-0.9321621327503477605347370626986958086491}
#define T_3125_598 {0.3601661465425268771056721561762969940901,-0.9328881749088189234697665597195737063885}
#define T_3125_599 {0.3582897368368917478953505906247301027179,-0.9336104457841882808821765138418413698673}
#define T_3125_601 {0.3545325797630116126946120402863016352057,-0.9350436620215035743441944759979378432035}
#define T_3125_602 {0.3526518475834068966356937835371354594827,-0.9357546015895458202393797364493366330862}
#define T_3125_603 {0.3507696897774631450417359701532404869795,-0.9364617582867024170312220121559221297503}
#define T_3125_604 {0.3488861139539699562917007824580650776625,-0.9371651292542299005461359229229856282473}
#define T_3125_606 {0.3451147387181257020216662567690946161747,-0.9385605026419553409411378197546582669020}
#define T_3125_607 {0.3432269545518931153083030949346721172333,-0.9392524994212326783227240412088576704264}
#define T_3125_608 {0.3413377828602865982077219086932018399239,-0.9399406991890625340246856467274483293295}
#define T_3125_609 {0.3394472312804500679916941408009734004736,-0.9406250991633364755273305490845814347267}
#define T_3125_611 {0.3356620190325234065475967781821964308619,-0.9419824886795984397735992388334125280380}
#define T_3125_612 {0.3337673736664892309988772467477247118950,-0.9426554727342191242200897249858826398849}
#define T_3125_613 {0.3318713790162748922263347139960387721658,-0.9433246460205712002888844835979398339987}
#define T_3125_614 {0.3299740427466067993478304742893669754267,-0.9439900058334624866063222725642845034599}
#define T_3125_616 {0.3261753760349019870545816957019269466400,-0.9453092742951855198541011304769199341536}
#define T_3125_617 {0.3242740609493119374739933391538215801120,-0.9459631776107577660894776272471062839031}
#define T_3125_618 {0.3223714349570995230109815565811004489660,-0.9466132567863713154210358879936393350363}
#define T_3125_619 {0.3204675057497989865140652909758500754833,-0.9472595091940236855521106917876750230789}
#define T_3125_621 {0.3166557684823805840501620423310669139028,-0.9485405232707946332482151774456724524498}
#define T_3125_622 {0.3147479758315483988617700106260599568486,-0.9491752797613004499766020671813748776913}
#define T_3125_623 {0.3128389107841369476403770022443495690823,-0.9498061991266401049571754811040591448545}
#define T_3125_624 {0.3109285810577109288033170741982758045197,-0.9504332788162662692954540943901520222425}
#define T_3125_627 {0.3051900810564923127721215223573381081223,-0.9522914545582836787218639074126258492470}
#define T_3125_633 {0.2936799788683579492953867884352803230286,-0.9559037974670259174558850645553320646286}
#define T_3125_636 {0.2879087954557846273928589653223752975464,-0.9576578332051585151774020232551265507936}
#define T_3125_637 {0.2859827294840936451336688151059206575155,-0.9582347720871058349700888356892392039299}
#define T_3125_639 {0.2821271370001109946024087093974230811000,-0.9593770262874343757175665814429521560669}
#define T_3125_642 {0.2763352138565692284188912708486896008253,-0.9610613141641090040323547327716369181871}
#define T_3125_648 {0.2647214167864538891805636922072153538465,-0.9643249304537203636655817717837635427713}
#define T_3125_651 {0.2588999654069744082995896405918756499887,-0.9659041401258550152419957157690078020096}
#define T_3125_654 {0.2530690944184412205508749593718675896525,-0.9674482071151044859647072371444664895535}
#define T_3125_657 {0.2472290159665959108359345464123180136085,-0.9689570752433714906359796259494032710791}
#define T_3125_663 {0.2355220869231894331718990542867686599493,-0.9718689966098031929320200106303673237562}
#define T_3125_666 {0.2296556622671614145136942397584789432585,-0.9732719439029522412454298319062218070030}
#define T_3125_669 {0.2237808820033907741819945158567861653864,-0.9746394804489424412707876399508677423000}
#define T_3125_672 {0.2178979598751789870103579005444771610200,-0.9759715564924189568074552880716510117054}
#define T_3125_676 {0.2100417685683246549199765240700799040496,-0.9776924135210881550150929797382559627295}
#define T_3125_678 {0.2061085464719858983961842113785678520799,-0.9785291345030076026745291528641246259212}
#define T_3125_681 {0.2002024841335826865762470561094232834876,-0.9797545434172492129221154755214229226112}
#define T_3125_684 {0.1942891377882884074157487930278875865042,-0.9809443057266215015843613400647882372141}
#define T_3125_687 {0.1883687225825620426000739371374947950244,-0.9820983781437651050083559312042780220509}
#define T_3125_689 {0.1844179583292170632180528855315060354769,-0.9828479112485731805648470071901101619005}
#define T_3125_693 {0.1765075474537503019689665961777791380882,-0.9842992866460190670707675053563434630632}
#define T_3125_696 {0.1705672190781642449941557515558088198304,-0.9853460426550367801112884080794174224138}
#define T_3125_699 {0.1646206849214434664308015499045723117888,-0.9863569486225536309120798250660300254822}
#define T_3125_702 {0.1586681613375257315912136846236535347998,-0.9873319677685762352226106486341450363398}
#define T_3125_708 {0.1467460123855430231820662356767570599914,-0.9891742050058432988990375633875373750925}
#define T_3125_711 {0.1407768207834000639966376411393866874278,-0.9900413560706029514335568819660693407059}
#define T_3125_714 {0.1348025072701223847637663766363402828574,-0.9908724862633377927778610683162696659565}
#define T_3125_717 {0.1288232892103495230706755592109402641654,-0.9916675653448723259941743890522047877312}
#define T_3125_723 {0.1168510097941769659835031802685989532620,-0.9931494557769646736034019340877421200275}
#define T_3125_726 {0.1108583840276059773177763645435334183276,-0.9938362132116075331467186515510547906160}
#define T_3125_728 {0.1068610459502429832490122407762100920081,-0.9942739646890187410477324192470405250788}
#define T_3125_729 {0.1048617248783490496499837263399967923760,-0.9944868117051816058804547537874896079302}
#define T_3125_732 {0.0988612505240514527482531548230326734483,-0.9951012275868323930794190346205141395330}
#define T_3125_738 {0.0868497295970191429681506178894778713584,-0.9962214234139540325330131054215598851442}
#define T_3125_741 {0.0808391200418448335751619993061467539519,-0.9967271626031168896275858060107566416264}
#define T_3125_744 {0.0748255693008505889940451538677734788507,-0.9971966376692229516720544779673218727112}
#define T_3125_747 {0.0688092961662518376453334667530725710094,-0.9976298315312673858912262403464410454035}
#define T_3125_753 {0.0567694583723854506729367130901664495468,-0.9983873139198564672369684558361768722534}
#define T_3125_754 {0.0547619681765601148959454747000563656911,-0.9984994375769219443483848408504854887724}
#define T_3125_756 {0.0507463317609364514271241830556391505525,-0.9987115748867683162615094261127524077892}
#define T_3125_759 {0.0447213588355825919506969512440264225006,-0.9989994995313556946925359625311102718115}
#define T_3125_762 {0.0386947588041149231896653759577020537108,-0.9992510773779987864884333248483017086983}
#define T_3125_767 {0.0286474051903728224588441264586435863748,-0.9995895788651752988940302202536258846521}
#define T_3125_768 {0.0266375545420212619940336651325196726248,-0.9996451573873705864770045081968419253826}
#define T_3125_771 {0.0206073889910615738740862212807769537903,-0.9997876452122076429418484622146934270859}
#define T_3125_774 {0.0145764736773600963454233792049308249261,-0.9998937575638390251597797941940370947123}
#define T_3125_777 {0.0085450280249109618335712212910948437639,-0.9999634905815579788423974605393595993519}
#define T_3125_783 {-0.0035185765117606818304374360906194851850,-0.9999938097905061162862239143578335642815}
#define T_3125_786 {-0.0095502964834544273181604623346174776088,-0.9999543948786254743410495393618475645781}
#define T_3125_789 {-0.0155816689848073432200781240908327163197,-0.9998785984266529425212866044603288173676}
#define T_3125_792 {-0.0216124745751913420466205906222967314534,-0.9997664231923057975848223577486351132393}
#define T_3125_793 {-0.0236225791999117480657321976877938141115,-0.9997209479409461252430446620564907789230}
#define T_3125_798 {-0.0336715073716536417158806671068305149674,-0.9994329540250914689636374532710760831833}
#define T_3125_801 {-0.0396992958315377092448628104648378212005,-0.9992116722248994831190316290303599089384}
#define T_3125_804 {-0.0457256399040274000289407752006809459999,-0.9989540359072419661856656603049486875534}
#define T_3125_806 {-0.0497422919037794133978458432920888299122,-0.9987620859825222519035037294088397175074}
#define T_3125_807 {-0.0517503203314449503058547463751892792061,-0.9986600544457522321550868582562543451786}
#define T_3125_813 {-0.0637938135309713688636534811848832760006,-0.9979631001971844828091207091347314417362}
#define T_3125_816 {-0.0698121881222662776789178451508632861078,-0.9975601527675317381493869106634519994259}
#define T_3125_819 {-0.0758280227228035064168665257966495119035,-0.9971209109079750554371912585338577628136}
#define T_3125_822 {-0.0818410984572735256126208014393341727555,-0.9966453905995386053362494749308098107576}
#define T_3125_828 {-0.0938580983366153892566430272381694521755,-0.9955855851591234317865541925129946321249}
#define T_3125_831 {-0.0998615852645850093916024547979759518057,-0.9950013385862573889184545805619563907385}
#define T_3125_832 {-0.1018619509602122080726971375952416565269,-0.9947985439005122554334548112819902598858}
#define T_3125_834 {-0.1058614389085903023657309063310094643384,-0.9943808906813338399643953380291350185871}
#define T_3125_837 {-0.1118574409747600945097545377393544185907,-0.9937242640182326613995655861799605190754}
#define T_3125_843 {-0.1238370179067089793534250929951667785645,-0.9923025712936419662213438641629181802273}
#define T_3125_846 {-0.1298201569171524294432629176299087703228,-0.9915375569578823711225368242594413459301}
#define T_3125_849 {-0.1357985726549467975221574533861712552607,-0.9907364673135228283484821076854132115841}
#define T_3125_852 {-0.1417720476062005463546711325761862099171,-0.9898993315067675657914492148847784847021}
#define T_3125_858 {-0.1537033060002351014805554996200953610241,-0.9881170445471518792857068547164089977741}
#define T_3125_861 {-0.1596606553456632326959407919275690801442,-0.9871719582395932501839297401602379977703}
#define T_3125_864 {-0.1656121957256392329682626041176263242960,-0.9861909554578831560434082348365336656570}
#define T_3125_867 {-0.1715577106040829802324765296361874789000,-0.9851740718940413810145173556520603597164}
#define T_3125_871 {-0.1794753169245356660965740047686267644167,-0.9837624767263881686574222840135917067528}
#define T_3125_873 {-0.1834297988160587811190538332084543071687,-0.9830328117139834898097205950762145221233}
#define T_3125_876 {-0.1893559402050386808458171117308665998280,-0.9819085130036635522543519982718862593174}
#define T_3125_879 {-0.1952751922190975875093243985247681848705,-0.9807484893201694475806107220705598592758}
#define T_3125_882 {-0.2011873394969094508422102762779104523361,-0.9795527828688739280238451101467944681644}
#define T_3125_884 {-0.2051247177052628045679227852815529331565,-0.9787358429046809638052195623458828777075}
#define T_3125_888 {-0.2129894596987791377529219971620477735996,-0.9770544969740542207148337183753028512001}
#define T_3125_891 {-0.2188790032239448790640778952365508303046,-0.9757520084261637194344984891358762979507}
#define T_3125_894 {-0.2247605832307023321359196188495843671262,-0.9744140188984323769361139966349583119154}
#define T_3125_897 {-0.2306339857283535854648448548687156289816,-0.9730405770711998414412846614141017198563}
#define T_3125_903 {-0.2423554037289404605726161889833747409284,-0.9701875376871124112554412022291216999292}
#define T_3125_906 {-0.2482029927691883075535628222496598027647,-0.9687080439329582848273503259406425058842}
#define T_3125_909 {-0.2540415513904704103431697603809880092740,-0.9671933054809276342211887822486460208893}
#define T_3125_912 {-0.2598708671673445325112083992280531674623,-0.9656433774420515314673707507608924061060}
#define T_3125_918 {-0.2715009221752375245806376824475592002273,-0.9624381794473844120574312910321168601513}
#define T_3125_921 {-0.2773012382676466325293063164281193166971,-0.9607830261069508770432889832591172307730}
#define T_3125_923 {-0.2811625236153397766614148167718667536974,-0.9596601665768218492047481049667112529278}
#define T_3125_924 {-0.2830914652538231712775029791373526677489,-0.9590929164061443579214483179384842514992}
#define T_3125_927 {-0.2888713924667845045490821576095186173916,-0.9573679118365628903930542037414852529764}
#define T_3125_933 {-0.3003995067864751455921634715195978060365,-0.9538134704031194788242942195211071521044}
#define T_3125_936 {-0.3061472744635230225362931832933099940419,-0.9519841628612086825711458004661835730076}
#define T_3125_939 {-0.3118839035232529033336845714075025171041,-0.9501202190897204413744248086004517972469}
#define T_3125_942 {-0.3176091852487462063869827488815644755960,-0.9482217069048923807628170834504999220371}
#define T_3125_948 {-0.3290248739011885081851005452335812151432,-0.9443212548462027733364720916142687201500}
#define T_3125_949 {-0.3309228781046149592270921857561916112900,-0.9436578027796719281283799318771343678236}
#define T_3125_951 {-0.3347148654888615348923508463485632091761,-0.9423194568832660156232350345817394554615}
#define T_3125_954 {-0.3403926790788573408796935382270021364093,-0.9402833743236759245220923730812501162291}
#define T_3125_957 {-0.3460581080941521614491307445860002189875,-0.9382130812466302760554981432505883276463}
#define T_3125_962 {-0.3554724088667650105932693804788868874311,-0.9346867745584396258706760818313341587782}
#define T_3125_963 {-0.3573509883529958353065580922702793031931,-0.9339701660776628111548802735342178493738}
#define T_3125_966 {-0.3629780287254309456557166413404047489166,-0.9317976983565693371858174032240640372038}
#define T_3125_969 {-0.3685918627958865156912793281662743538618,-0.9295913288540607055665532243438065052032}
#define T_3125_972 {-0.3741922863151183609176086974912323057652,-0.9273511378449181830063707820954732596874}
#define T_3125_978 {-0.3853520871499416799998982696706661954522,-0.9227696185555653851650959040853194892406}
#define T_3125_981 {-0.3909110584362747164988149961573071777821,-0.9204284569656847603269511637336108833551}
#define T_3125_984 {-0.3964558071276397255289225540764164179564,-0.9180538072437648411394661707163322716951}
#define T_3125_987 {-0.4019861314883396152808359147456940263510,-0.9156457557871598984533534348884131759405}
#define T_3125_988 {-0.4038263327426417914622902571863960474730,-0.9148356644685585736809230184007901698351}
#define T_3125_993 {-0.4130027029062933729974815832974854856730,-0.9107297993324342533227877538593020290136}
#define T_3125_996 {-0.4184885491454332084870770813722629100084,-0.9082220731925371159931614783999975770712}
#define T_3125_999 {-0.4239591694322628612212611187715083360672,-0.9056813030278950682472327571304049342871}
#define T_3125_1001 {-0.4275976924473718909780473040882498025894,-0.9039691440606160144355385455128271132708}
#define T_3125_1002 {-0.4294143647281138953530899016186594963074,-0.9031075812798552426841069973306730389595}
#define T_3125_1008 {-0.4402776870054798674658513846225105226040,-0.8978616587899856948951082813437096774578}
#define T_3125_1011 {-0.4456854187445748460838501614489359781146,-0.8951896489115995780849743823637254536152}
#define T_3125_1014 {-0.4510769350222312290554782521212473511696,-0.8924850691697591154039059802016708999872}
#define T_3125_1017 {-0.4564520396778375399549076973926275968552,-0.8897480179657282217675628999131731688976}
#define T_3125_1023 {-0.4671522324731054998103729758440749719739,-0.8841769006796058594233045369037427008152}
#define T_3125_1026 {-0.4724769313055195985029399707855191081762,-0.8813430372925852296361881599295884370804}
#define T_3125_1027 {-0.4742480204158500134425935357285197824240,-0.8803912852429012225741189467953518033028}
#define T_3125_1029 {-0.4777844399155526944333871597336838021874,-0.8784771078261411902943223140027839690447}
#define T_3125_1032 {-0.4830745651990608902082158238044939935207,-0.8755792165519566960796282728551886975765}
#define T_3125_1038 {-0.4936018965392355295485060651117237284780,-0.8696879714776269976184153165377210825682}
#define T_3125_1041 {-0.4988387195779070970580448829423403367400,-0.8666948320198258892688158994133118540049}
#define T_3125_1044 {-0.5040573932679996982386683157528750598431,-0.8636701594311737562037478710408322513103}
#define T_3125_1047 {-0.5092577277374680244648175175825599581003,-0.8606140637589365649517958445358090102673}
#define T_3125_1053 {-0.5196026228694325954649002596852369606495,-0.8544080490650858283885327182360924780369}
#define T_3125_1056 {-0.5247468071515470899868205378879792988300,-0.8512583558381421333649541338672861456871}
#define T_3125_1059 {-0.5298718994659674663694204355124384164810,-0.8480776911087377634146378113655373454094}
#define T_3125_1062 {-0.5349777133454384214772403538518119603395,-0.8448661705996316495514975031255744397640}
#define T_3125_1066 {-0.5417551555332476009851916387560777366161,-0.8405363474907832088689474403508938848972}
#define T_3125_1068 {-0.5451307634443250949018988649186212569475,-0.8383510307422584739711624024494085460901}
#define T_3125_1071 {-0.5501776302632950255144805851159617304802,-0.8350476484356237349970797367859631776810}
#define T_3125_1074 {-0.5552044798598639863129733384994324296713,-0.8317138844239272410518992728611920028925}
#define T_3125_1077 {-0.5602111293411610182246818112616892904043,-0.8283498600001698575212571995507460087538}
#define T_3125_1079 {-0.5635375833907871889749685578863136470318,-0.8260904261072583576464012367068789899349}
#define T_3125_1083 {-0.5701631000678066829578938268241472542286,-0.8215315205888744642948040564078837633133}
#define T_3125_1086 {-0.5751080592286204051788445212878286838531,-0.8180774536743385949577600513293873518705}
#define T_3125_1089 {-0.5800320941182662837221073459659237414598,-0.8145936224847201145848885062150657176971}
#define T_3125_1092 {-0.5849350255846010870897089262143708765507,-0.8110801537729437349355521291727200150490}
#define T_3125_1098 {-0.5946768654843063162118710351933259516954,-0.8039648161815045046552086205338127911091}
#define T_3125_1101 {-0.5995154194783735013274394987092819064856,-0.8003632061805876496407563536195084452629}
#define T_3125_1104 {-0.6043321611834190365541985556774307042360,-0.7967324764055861985312390061153564602137}
#define T_3125_1107 {-0.6091269153509694112003103327879216521978,-0.7930727589540652600064163380011450499296}
#define T_3125_1113 {-0.6186497640859212054920135415159165859222,-0.7856668946802035646825856929353903979063}
#define T_3125_1116 {-0.6233775121816188535817104821035172790289,-0.7819210173068988911637688943301327526569}
#define T_3125_1118 {-0.6265167545693004491624833462992683053017,-0.7794079523869068548691529940697364509106}
#define T_3125_1119 {-0.6280825798090190481559602631023153662682,-0.7781466911453439605494963871024083346128}
#define T_3125_1122 {-0.6327647957827083891046981989347841590643,-0.7743440535175997174732742678315844386816}
#define T_3125_1128 {-0.6420599921905801865662510863330680876970,-0.7666543982970632775675312586827203631401}
#define T_3125_1131 {-0.6466726344357786038230528902204241603613,-0.7627676604785298408728522190358489751816}
#define T_3125_1134 {-0.6512617486616028017465396260377019643784,-0.7588531707321458652515389076143037527800}
#define T_3125_1137 {-0.6558271679013949473358024988556280732155,-0.7549110714795720378234022973629180341959}
#define T_3125_1143 {-0.6648862578727927630239946665824390947819,-0.7469446191598906326092333074484486132860}
#define T_3125_1144 {-0.6663867341961572376973776954400818794966,-0.7456062771244486020449926400033291429281}
#define T_3125_1146 {-0.6693795990057219702507040892669465392828,-0.7429205559378060375053109964937902987003}
#define T_3125_1149 {-0.6738485859672582733992385328747332096100,-0.7388694628890318805147785496956203132868}
#define T_3125_1152 {-0.6782930561613581543767281800683122128248,-0.7347914874052942080240313771355431526899}
#define T_3125_1157 {-0.6856455859895435045459066714101936668158,-0.7279355262748586907761705333541613072157}
#define T_3125_1158 {-0.6871078003289499136485574126709252595901,-0.7265554835847788384128875804890412837267}
#define T_3125_1161 {-0.6914777535938475550025827942590694874525,-0.7223977549001701081721193986595608294010}
#define T_3125_1164 {-0.6958225486857885222491404419997707009315,-0.7182137430740332950662718758394476026297}
#define T_3125_1167 {-0.7001420275272269844180073050665669143200,-0.7140036003341045933723307825857773423195}
#define T_3125_1173 {-0.7087044087595608665708368789637461304665,-0.7055055357718756914309210515057202428579}
#define T_3125_1176 {-0.7129469996236330597838559697265736758709,-0.7012179231363523390641034893633332103491}
#define T_3125_1179 {-0.7171636511948903391910903337702620774508,-0.6969047979493422362295973471191246062517}
#define T_3125_1182 {-0.7213542100580581095670140712172724306583,-0.6925663171361389203184444340877234935760}
#define T_3125_1183 {-0.7227452382532805197357106408162508159876,-0.6911145495373459679555594448174815624952}
#define T_3125_1188 {-0.7296564407512542427269863765104673802853,-0.6838139209391772554980093445919919759035}
#define T_3125_1191 {-0.7337678105195681865779988584108650684357,-0.6794003239955946904515826645365450531244}
#define T_3125_1194 {-0.7378524834673538812523929664166644215584,-0.6749620082945841925692320728558115661144}
#define T_3125_1196 {-0.7405606937694141356232080397603567689657,-0.6719894782240001251949479410541243851185}
#define T_3125_1197 {-0.7419103109811409080265320881153456866741,-0.6704991353162707001800413308956194669008}
#define T_3125_1203 {-0.7499448401418243870253377281187567859888,-0.6615003679096886912702757399529218673706}
#define T_3125_1206 {-0.7539212494668445785350741061847656965256,-0.6569648008853685716701420460594817996025}
#define T_3125_1209 {-0.7578702287247495172906042171234730631113,-0.6524053313797304465282422825112007558346}
#define T_3125_1212 {-0.7617916342390397277384295193769503384829,-0.6478221252808622487862066918751224875450}
#define T_3125_1218 {-0.7695511543520733299672542671032715588808,-0.6385851711677866804350856000382918864489}
#define T_3125_1221 {-0.7733889866346496111404462681093718856573,-0.6339317592235222953434004011796787381172}
#define T_3125_1222 {-0.7746620179580198106705779537151101976633,-0.6323754880869503214313454009243287146091}
#define T_3125_1224 {-0.7771986805515482821249406697461381554604,-0.6292552828136862563823683558439370244741}
#define T_3125_1227 {-0.7809800974939162809818071764311753213406,-0.6245559120834522914833542017731815576553}
#define T_3125_1233 {-0.7884575511686865434413107323052827268839,-0.6150891724011064987109875801252201199532}
#define T_3125_1236 {-0.7921533158474011182548224496713373810053,-0.6103221478792717480388319017947651445866}
#define T_3125_1239 {-0.7958202594541076146938962665444705635309,-0.6055329178850615834406312387727666646242}
#define T_3125_1242 {-0.7994582485736659860364738960925024002790,-0.6007216566659857592824778294016141444445}
#define T_3125_1248 {-0.8066468349628769241022041569522116333246,-0.5910337415447387554578995150222908705473}
#define T_3125_1251 {-0.8101971706887579616207517574366647750139,-0.5861574401199147743568573787342756986618}
#define T_3125_1253 {-0.8125476926771126873205730589688755571842,-0.5828947135847952765175250533502548933029}
#define T_3125_1254 {-0.8137180288494633151330504006182309240103,-0.5812598124120951226245779253076761960983}
#define T_3125_1256 {-0.8160488278945919882190196403826121240854,-0.5779829673025517200457557009940501302481}
#define T_3125_1257 {-0.8172092813449084447441350675944704562426,-0.5763410366126450190549235230719204992056}
#define T_3125_1259 {-0.8195202726448849173124244771315716207027,-0.5730501921507865636939982323383446782827}
#define T_3125_1261 {-0.8218180120250051512442723833373747766018,-0.5697500812735952768761649167572613805532}
#define T_3125_1262 {-0.8229619006257250513058920660114381462336,-0.5680965675996416663906529720406979322433}
#define T_3125_1263 {-0.8241024623300465812292259215610101819038,-0.5664407573449796728937144507654011249542}
#define T_3125_1266 {-0.8275041400237616029400555817119311541319,-0.5614596140805985235999742144485935568810}
#define T_3125_1268 {-0.8297552064986845055116759795055259019136,-0.5581274919660610400740097247762605547905}
#define T_3125_1269 {-0.8308757104693854644850148361001629382372,-0.5564580431191501475041150115430355072021}
#define T_3125_1271 {-0.8331066372286018983928101988567505031824,-0.5531124035904914082451000467699486762285}
#define T_3125_1272 {-0.8342170509983982684687475739337969571352,-0.5514362264337877572728530140011571347713}
#define T_3125_1274 {-0.8364277568736554480111067277903202921152,-0.5480771912160778969180796593718696385622}
#define T_3125_1277 {-0.8397184446008868485833431805076543241739,-0.5430220380399558566253404023882467299700}
#define T_3125_1278 {-0.8408085571362411414497728401329368352890,-0.5413325874603082121794273007253650575876}
#define T_3125_1281 {-0.8440584829249893061842158203944563865662,-0.5362511327749018841259953660483006387949}
#define T_3125_1283 {-0.8462080465104597770675809442764148116112,-0.5328526456919882026141976893995888531208}
#define T_3125_1284 {-0.8472776991656882916714721432072110474110,-0.5311501675576290049107797131000552326441}
#define T_3125_1286 {-0.8494067245803212928834113881748635321856,-0.5277387765151716481071275666181463748217}
#define T_3125_1287 {-0.8504660887329518192956356870126910507679,-0.5260298773979239506104477186454460024834}
#define T_3125_1289 {-0.8525744985159912081584820953139569610357,-0.5226057065132432288834252176457084715366}
#define T_3125_1292 {-0.8557112530637190905835609555651899427176,-0.5174536224437120690566871417104266583920}
#define T_3125_1293 {-0.8567499249577132935939971503103151917458,-0.5157320681176928989231100786128081381321}
#define T_3125_1296 {-0.8598451429891451613940489551168866455555,-0.5105549236644150168373812448407988995314}
#define T_3125_1298 {-0.8618912486274211692816038521414157003164,-0.5070931625840214840295061549113597720861}
#define T_3125_1299 {-0.8629090771033275375501148118928540498018,-0.5053592035895690948166247835615649819374}
#define T_3125_1301 {-0.8649342647953848217667882636305876076221,-0.5018851637405385979207039781613275408745}
#define T_3125_1302 {-0.8659416158245348826838494460389483720064,-0.5001450969300744731071972637437283992767}
#define T_3125_1304 {-0.8679458118875658101387671194970607757568,-0.4966589047090913533466505214164499193430}
#define T_3125_1307 {-0.8709257803342459469675418404222000390291,-0.4914145756377040208384698871668661013246}
#define T_3125_1308 {-0.8719120669004601920093477929185610264540,-0.4896624833427281053843671543290838599205}
#define T_3125_1311 {-0.8748497620310663469567202810139860957861,-0.4843943578058961807464299909042892977595}
#define T_3125_1313 {-0.8767905487608365078244787582661956548691,-0.4808724712474931606287498198071261867881}
#define T_3125_1314 {-0.8777556273283773080606806615833193063736,-0.4791086084525791322086263335222611203790}
#define T_3125_1316 {-0.8796751353617080493307867072871886193752,-0.4755750794841552830938269380567362532020}
#define T_3125_1317 {-0.8806295570677167283690778276650235056877,-0.4738054275952494065471398698718985542655}
#define T_3125_1319 {-0.8825277165667645418167808202269952744246,-0.4702603847778935586276816138706635683775}
#define T_3125_1322 {-0.8853481885899753267565870373800862580538,-0.4649285804943050215420896620344137772918}
#define T_3125_1323 {-0.8862811927871681039192708340124227106571,-0.4631475437824910668105360400659264996648}
#define T_3125_1326 {-0.8890586931426912586928779091977048665285,-0.4577932285949738999697444796765921637416}
#define T_3125_1328 {-0.8908923957916445868221444470691494643688,-0.4542144197629834345697474873304599896073}
#define T_3125_1329 {-0.8918038466985458434521660819882526993752,-0.4524222574251586803661950852983864024282}
#define T_3125_1331 {-0.8936159292541071552662401700217742472887,-0.4488324531306960851750886831723619252443}
#define T_3125_1332 {-0.8945165535772630072131050837924703955650,-0.4470348256861601532463623698276933282614}
#define T_3125_1334 {-0.8963069501100714431274241178471129387617,-0.4434341565377907801170920265576569363475}
#define T_3125_1337 {-0.8989653604515890350512563600204885005951,-0.4380197263915685534918509347335202619433}
#define T_3125_1338 {-0.8998442336995690071788089881010819226503,-0.4362113651403817793372752475988818332553}
#define T_3125_1339 {-0.9007194692475072317350281991821248084307,-0.4344012404661027337837708728329744189978}
#define T_3125_1341 {-0.9024590131051098973458124419266823679209,-0.4307757301257246207448758923419518396258}
#define T_3125_1343 {-0.9041839638953846902680311359290499240160,-0.4271432539961619867519004856148967519403}
#define T_3125_1344 {-0.9050409581644697221136652842687908560038,-0.4253244221118022139194181363563984632492}
#define T_3125_1346 {-0.9067439671281731783381019340595230460167,-0.4216816074678410575238274304865626618266}
#define T_3125_1347 {-0.9075899749382267955866154807154089212418,-0.4198576394346407170132806641049683094025}
#define T_3125_1349 {-0.9092709801144442938181100544170476496220,-0.4162046188135324897849898206914076581597}
#define T_3125_1352 {-0.9117649109133807439064867139677517116070,-0.4107124873036063217313085260684601962566}
#define T_3125_1353 {-0.9125888538648014858267742965836077928543,-0.4088784462425575916277864507719641551375}
#define T_3125_1356 {-0.9150385341424104312935128291428554803133,-0.4033664351858106122961089567979797720909}
#define T_3125_1358 {-0.9166531642074609020909292667056433856487,-0.3996835955458388767169708444271236658096}
#define T_3125_1359 {-0.9174549223906167672026867876411415636539,-0.3978397483676402446306497040495742112398}
#define T_3125_1361 {-0.9190473088523105626990172822843305766582,-0.3941472365643651221134291517955716699362}
#define T_3125_1362 {-0.9198379306934851840082956186961382627487,-0.3922985868665948006039911888365168124437}
#define T_3125_1364 {-0.9214080156157081757939408817037474364042,-0.3885965372454093236243011233455035835505}
#define T_3125_1367 {-0.9237351986075890142302569074672646820545,-0.3830316995411713332231329331989400088787}
#define T_3125_1368 {-0.9245034618749669030890458998328540474176,-0.3811736467559129759585800911736441776156}
#define T_3125_1371 {-0.9267858150066293765334535237343516200781,-0.3755902729071904366797696184221422299743}
#define T_3125_1373 {-0.9282886558181315805882150016259402036667,-0.3718604193502803578752491375780664384365}
#define T_3125_1374 {-0.9290344487052275557203984135412611067295,-0.3699932338826940059206549449299927800894}
#define T_3125_1376 {-0.9305147643674520629986091080354526638985,-0.3662543833105415536088855787966167554259}
#define T_3125_1377 {-0.9312492811582734342223943713179323822260,-0.3643827333206102192519892923883162438869}
#define T_3125_1378 {-0.9319800332913663609701870882418006658554,-0.3625096102811947718080887170799542218447}
#define T_3125_1379 {-0.9327070178126004584839847666444256901741,-0.3606350217645611921923887166485656052828}
#define T_3125_1382 {-0.9348653363923824510806070975377224385738,-0.3550025391626905335584751810529269278049}
#define T_3125_1383 {-0.9355772212296750156568236889143008738756,-0.3531221645778693241091161780786933377385}
#define T_3125_1386 {-0.9376901713837241247873066640750039368868,-0.3474725060927296160784294443146791309118}
#define T_3125_1388 {-0.9390798560872231082186090134200640022755,-0.3436990309721579817114900379237951710820}
#define T_3125_1389 {-0.9397690053693372735921229832456447184086,-0.3418102054461312766520109107659664005041}
#define T_3125_1391 {-0.9411359038645714658599672475247643887997,-0.3380284166412879653940137814061017706990}
#define T_3125_1392 {-0.9418136475518830152964255830738693475723,-0.3361354686506876077167760286101838573813}
#define T_3125_1394 {-0.9431577101067120105781782513076905161142,-0.3323455037551485413693796999723417684436}
#define T_3125_1397 {-0.9451452012538651414885748636152129620314,-0.3266504990762922333580320355395087972283}
#define T_3125_1398 {-0.9458000601919896999092429723532404750586,-0.3247495129185395956739057510276325047016}
#define T_3125_1401 {-0.9477416856111047227528842995525337755680,-0.3190387082393325024476382623106474056840}
#define T_3125_1403 {-0.9490169502691866432186884594557341188192,-0.3152250435827903540797478854074142873287}
#define T_3125_1404 {-0.9496488291555378324915182020049542188644,-0.3133162959112024137375840382446767762303}
#define T_3125_1406 {-0.9509010672707387534785539173753932118416,-0.3094950084627696718087008775910362601280}
#define T_3125_1407 {-0.9515214214373051149209459254052489995956,-0.3075824841338179460592527902917936444283}
#define T_3125_1409 {-0.9527505874491961623817815052461810410023,-0.3037537129241576483451581225381232798100}
#define T_3125_1412 {-0.9545654435130974668766157265054062008858,-0.2980013658536542764387888837518403306603}
#define T_3125_1413 {-0.9551626809488136249370882069342769682407,-0.2960814970961117564840492377697955816984}
#define T_3125_1416 {-0.9569312156978840855359180750383529812098,-0.2903147402784942987530314439936773851514}
#define T_3125_1417 {-0.9575129934843711332348448195261880755424,-0.2883901303938790072756148674670839682221}
#define T_3125_1418 {-0.9580909004397456518731246433162596076727,-0.2864643546666100215603023571020457893610}
#define T_3125_1419 {-0.9586649342277675511780898887082003057003,-0.2845374208818063355153071825043298304081}
#define T_3125_1421 {-0.9598013730350903882637680908374022692442,-0.2806801103034470834529656713129952549934}
#define T_3125_1422 {-0.9603637734602369357972406760382000356913,-0.2787497491034112706564940253883833065629}
#define T_3125_1424 {-0.9614769249857414434856650586880277842283,-0.2748856538998767362613762088585644960403}
#define T_3125_1427 {-0.9631174953297583218869704069220460951328,-0.2690811962767615250768926671298686414957}
#define T_3125_1428 {-0.9636565680673772060771398173528723418713,-0.2671441910665556807025211583095369860530}
#define T_3125_1431 {-0.9652504036396454267787703429348766803741,-0.2613267270554267551752047893387498334050}
#define T_3125_1433 {-0.9662934537160118297904887185723055154085,-0.2574431224670444828817039706336800009012}
#define T_3125_1434 {-0.9668091203140533052007299374963622540236,-0.2554997551418913270815380656131310388446}
#define T_3125_1436 {-0.9678287262067215568350775356520898640156,-0.2516099297108022048163888939598109573126}
#define T_3125_1437 {-0.9683326613795012471896939132420811802149,-0.2496634873298301526833853358766646124423}
#define T_3125_1439 {-0.9693287859919468285596622081357054412365,-0.2457675825803282143589001407235627993941}
#define T_3125_1442 {-0.9707935784947135937628104329633060842752,-0.2399162936389029054939925345024676062167}
#define T_3125_1443 {-0.9712739962401419901993904204573482275009,-0.2379639137090004130659082193233189173043}
#define T_3125_1446 {-0.9726916830201622898854907361965160816908,-0.2321010335681512604111276232288219034672}
#define T_3125_1448 {-0.9736171497625963899835710435581859201193,-0.2281877421952325235565695038530975580215}
#define T_3125_1449 {-0.9740739801647710915943889631307683885098,-0.2262297088491279362099106720052077434957}
#define T_3125_1451 {-0.9749758257971561370425206405343487858772,-0.2223109064152127278823911638028221204877}
#define T_3125_1452 {-0.9754208373815757004976489952241536229849,-0.2203501531695081505635158691802644170821}
#define T_3125_1454 {-0.9762990290918822644528063392499461770058,-0.2164259822531666710432318723178468644619}
#define T_3125_1456 {-0.9771614337168401664968087061424739658833,-0.2124983116555269890834978241400676779449}
#define T_3125_1457 {-0.9775867115044055699613068100006785243750,-0.2105331838214632711459017855304409749806}
#define T_3125_1458 {-0.9780080373110748848120010734419338405132,-0.2085672048883505380612035651211044751108}
#define T_3125_1461 {-0.9792482858931585987249945901567116379738,-0.2026642409881689588235786914083291776478}
#define T_3125_1463 {-0.9800553275768880689966522368195001035929,-0.1987248220232155082598524131753947585821}
#define T_3125_1464 {-0.9804529062896414348671214611385948956013,-0.1967539035145059456155536281585227698088}
#define T_3125_1466 {-0.9812361714206964125040144608647096902132,-0.1928096882826524360865505514084361493587}
#define T_3125_1467 {-0.9816218546725793414609029241546522825956,-0.1908364075043480490023739548632875084877}
#define T_3125_1469 {-0.9823813147532685086105175287229940295219,-0.1868875395087635782331858536053914576769}
#define T_3125_1472 {-0.9834907159106259788572401703277137130499,-0.1809585911682682901613361536874435842037}
#define T_3125_1473 {-0.9838525665769012329420206697250250726938,-0.1789808013169127964836491173628019168973}
#define T_3125_1476 {-0.9849142489378492903995265805860981345177,-0.1730431224845188353800295999462832696736}
#define T_3125_1478 {-0.9856021315473265653750445380865130573511,-0.1690811588834378598189545073182671330869}
#define T_3125_1479 {-0.9859400969673335346499243314610794186592,-0.1670991477897030008659129407533328048885}
#define T_3125_1481 {-0.9866040692066136985616253696207422763109,-0.1631331070780893399696509504792629741132}
#define T_3125_1482 {-0.9869300733417204485320439744100440293550,-0.1611490934932815199953637375074322335422}
#define T_3125_1484 {-0.9875701110533692261839178172522224485874,-0.1571791199683850448476363226291141472757}
#define T_3125_1487 {-0.9885002219398999478983114386210218071938,-0.1512194141794249158117224851594073697925}
#define T_3125_1488 {-0.9888022683576072058286854371544905006886,-0.1492316122369873043762567021985887549818}
#define T_3125_1491 {-0.9896844188826626753652249135484453290701,-0.1432646188732108472052573233668226748705}
#define T_3125_1493 {-0.9902525167791625948510159105353523045778,-0.1392837140965672293457799923999118618667}
#define T_3125_1494 {-0.9905305615222100845684849446115549653769,-0.1372924130842458068091360701146186329424}
#define T_3125_1496 {-0.9910746369778019593255180552660021930933,-0.1333081540616251337016961997505859471858}
#define T_3125_1497 {-0.9913406654908731852060554956551641225815,-0.1313152121580459796845730124914553016424}
#define T_3125_1499 {-0.9918606987103513183967606892110779881477,-0.1273277438495385716077379356647725217044}
#define T_3125_1502 {-0.9926106733773698564959886425640434026718,-0.1213427010467644645563822791700658854097}
#define T_3125_1503 {-0.9928526408311242335003043990582227706909,-0.1193466949465402798802315942339191678911}
#define T_3125_1506 {-0.9935544571922120260509814215765800327063,-0.1133558141141820380104476839733251836151}
#define T_3125_1508 {-0.9940022536828588828328179261006880551577,-0.1093595888498011398093368029549310449511}
#define T_3125_1509 {-0.9942201248634163768258531490573659539223,-0.1073608090346411525484171534117194823921}
#define T_3125_1511 {-0.9946438086911856268912401901616249233484,-0.1033619554395718703743156652308243792504}
#define T_3125_1512 {-0.9948496196256179091577109829813707619905,-0.1013618978253825325674952750887314323336}
#define T_3125_1513 {-0.9950514087923183481620981183368712663651,-0.0993614304467405062837315199431031942368}
#define T_3125_1514 {-0.9952491753755364767286550886637996882200,-0.0973605613907123912387220343589433468878}
#define T_3125_1517 {-0.9958183317107344167951055169396568089724,-0.0913556250531387947777517410941072739661}
#define T_3125_1518 {-0.9960000001277981018787954781146254390478,-0.0893532301902183606623353284703625831753}
#define T_3125_1521 {-0.9965208440132535816502468151156790554523,-0.0833439106780613225833320711899432353675}
#define T_3125_1523 {-0.9968479318209600981148810205922927707434,-0.0793359995479635538018214901967439800501}
#define T_3125_1524 {-0.9970054312821827746660119373700581490993,-0.0773315588477872795092338265021680854261}
#define T_3125_1526 {-0.9973083381358417431883367498812731355429,-0.0733217476927928019092561839897825848311}
#define T_3125_1527 {-0.9974537443037503336995541758369654417038,-0.0713163934479914690678370448040368501097}
#define T_3125_1529 {-0.9977324591826413069384216214530169963837,-0.0673048281578588897255954748288786504418}
#define T_3125_1532 {-0.9981202795304783270680104578786995261908,-0.0612854598579447365502836930772900814191}
#define T_3125_1533 {-0.9982414836809191394095819305221084505320,-0.0592784974380861848231027977362828096375}
#define T_3125_1534 {-0.9983586523517171684716231538914144039154,-0.0572712953796496171410268516410724259913}
#define T_3125_1536 {-0.9985808813760417290694704206543974578381,-0.0532562048051470268705820387822313932702}
#define T_3125_1538 {-0.9987869630099333040362807878409512341022,-0.0492402530598089055446919815040018875152}
#define T_3125_1539 {-0.9988839475038877591117625343031249940395,-0.0472319745410916952410573799170379061252}
#define T_3125_1541 {-0.9990658018854734478964019217528402805328,-0.0432148528047473987068194389848940772936}
#define T_3125_1542 {-0.9991506710379421951628842180070932954550,-0.0412060258266908410740292367790971184149}
#define T_3125_1544 {-0.9993082915507774943719709881406743079424,-0.0371878802550813167271392956081399461254}
#define T_3125_1547 {-0.9995144231832957526506788781262002885342,-0.0311595546913544275968721564140651025809}
#define T_3125_1548 {-0.9995750528302664861257653683423995971680,-0.0291498500745719542337486274163893540390}
#define T_3125_1551 {-0.9997326956481690229949776949069928377867,-0.0231200616790997320881828613892139401287}
#define T_3125_1552 {-0.9997771605050388421531692983990069478750,-0.0211099344499641877748175033957522828132}
#define T_3125_1553 {-0.9998175836741561850473658523696940392256,-0.0190997218820482747569933223985572112724}
#define T_3125_1554 {-0.9998539649921069916160831780871376395226,-0.0170894321018144022816809268761062412523}
#define T_3125_1556 {-0.9999146015025498490658151240495499223471,-0.0130686534117702632395996431569074047729}
#define T_3125_1557 {-0.9999388564499135378937921814213041216135,-0.0110581807563140972067161627023779146839}
#define T_3125_1559 {-0.9999752392386617172448382007132750004530,-0.0070371094620699081029213672877631324809}
#define T_3125_1562 {-0.9999994946762972292120252859604079276323,-0.0010053094798131300031951429474474934977}
#define T_3125_1563 {-0.9999994946762972292120252859604079276323,0.0010053094798131300031951429474474934977}
#define T_3125_1566 {-0.9999752392386617172448382007132750004530,0.0070371094620699081029213672877631324809}
#define T_3125_1569 {-0.9999146015025498490658151240495499223471,0.0130686534117702632395996431569074047729}
#define T_3125_1572 {-0.9998175836741561850473658523696940392256,0.0190997218820482747569933223985572112724}
#define T_3125_1573 {-0.9997771605050388421531692983990069478750,0.0211099344499641877748175033957522828132}
#define T_3125_1578 {-0.9995144231832957526506788781262002885342,0.0311595546913544275968721564140651025809}
#define T_3125_1581 {-0.9993082915507774943719709881406743079424,0.0371878802550813167271392956081399461254}
#define T_3125_1584 {-0.9990658018854734478964019217528402805328,0.0432148528047473987068194389848940772936}
#define T_3125_1586 {-0.9988839475038877591117625343031249940395,0.0472319745410916952410573799170379061252}
#define T_3125_1587 {-0.9987869630099333040362807878409512341022,0.0492402530598089055446919815040018875152}
#define T_3125_1593 {-0.9981202795304783270680104578786995261908,0.0612854598579447365502836930772900814191}
#define T_3125_1596 {-0.9977324591826413069384216214530169963837,0.0673048281578588897255954748288786504418}
#define T_3125_1599 {-0.9973083381358417431883367498812731355429,0.0733217476927928019092561839897825848311}
#define T_3125_1602 {-0.9968479318209600981148810205922927707434,0.0793359995479635538018214901967439800501}
#define T_3125_1608 {-0.9958183317107344167951055169396568089724,0.0913556250531387947777517410941072739661}
#define T_3125_1611 {-0.9952491753755364767286550886637996882200,0.0973605613907123912387220343589433468878}
#define T_3125_1612 {-0.9950514087923183481620981183368712663651,0.0993614304467405062837315199431031942368}
#define T_3125_1614 {-0.9946438086911856268912401901616249233484,0.1033619554395718703743156652308243792504}
#define T_3125_1617 {-0.9940022536828588828328179261006880551577,0.1093595888498011398093368029549310449511}
#define T_3125_1623 {-0.9926106733773698564959886425640434026718,0.1213427010467644645563822791700658854097}
#define T_3125_1626 {-0.9918606987103513183967606892110779881477,0.1273277438495385716077379356647725217044}
#define T_3125_1629 {-0.9910746369778019593255180552660021930933,0.1333081540616251337016961997505859471858}
#define T_3125_1632 {-0.9902525167791625948510159105353523045778,0.1392837140965672293457799923999118618667}
#define T_3125_1638 {-0.9885002219398999478983114386210218071938,0.1512194141794249158117224851594073697925}
#define T_3125_1641 {-0.9875701110533692261839178172522224485874,0.1571791199683850448476363226291141472757}
#define T_3125_1644 {-0.9866040692066136985616253696207422763109,0.1631331070780893399696509504792629741132}
#define T_3125_1647 {-0.9856021315473265653750445380865130573511,0.1690811588834378598189545073182671330869}
#define T_3125_1653 {-0.9834907159106259788572401703277137130499,0.1809585911682682901613361536874435842037}
#define T_3125_1656 {-0.9823813147532685086105175287229940295219,0.1868875395087635782331858536053914576769}
#define T_3125_1659 {-0.9812361714206964125040144608647096902132,0.1928096882826524360865505514084361493587}
#define T_3125_1662 {-0.9800553275768880689966522368195001035929,0.1987248220232155082598524131753947585821}
#define T_3125_1668 {-0.9775867115044055699613068100006785243750,0.2105331838214632711459017855304409749806}
#define T_3125_1671 {-0.9762990290918822644528063392499461770058,0.2164259822531666710432318723178468644619}
#define T_3125_1674 {-0.9749758257971561370425206405343487858772,0.2223109064152127278823911638028221204877}
#define T_3125_1677 {-0.9736171497625963899835710435581859201193,0.2281877421952325235565695038530975580215}
#define T_3125_1683 {-0.9707935784947135937628104329633060842752,0.2399162936389029054939925345024676062167}
#define T_3125_1686 {-0.9693287859919468285596622081357054412365,0.2457675825803282143589001407235627993941}
#define T_3125_1689 {-0.9678287262067215568350775356520898640156,0.2516099297108022048163888939598109573126}
#define T_3125_1692 {-0.9662934537160118297904887185723055154085,0.2574431224670444828817039706336800009012}
#define T_3125_1698 {-0.9631174953297583218869704069220460951328,0.2690811962767615250768926671298686414957}
#define T_3125_1701 {-0.9614769249857414434856650586880277842283,0.2748856538998767362613762088585644960403}
#define T_3125_1704 {-0.9598013730350903882637680908374022692442,0.2806801103034470834529656713129952549934}
#define T_3125_1707 {-0.9580909004397456518731246433162596076727,0.2864643546666100215603023571020457893610}
#define T_3125_1713 {-0.9545654435130974668766157265054062008858,0.2980013658536542764387888837518403306603}
#define T_3125_1716 {-0.9527505874491961623817815052461810410023,0.3037537129241576483451581225381232798100}
#define T_3125_1719 {-0.9509010672707387534785539173753932118416,0.3094950084627696718087008775910362601280}
#define T_3125_1722 {-0.9490169502691866432186884594557341188192,0.3152250435827903540797478854074142873287}
#define T_3125_1728 {-0.9451452012538651414885748636152129620314,0.3266504990762922333580320355395087972283}
#define T_3125_1731 {-0.9431577101067120105781782513076905161142,0.3323455037551485413693796999723417684436}
#define T_3125_1734 {-0.9411359038645714658599672475247643887997,0.3380284166412879653940137814061017706990}
#define T_3125_1737 {-0.9390798560872231082186090134200640022755,0.3436990309721579817114900379237951710820}
#define T_3125_1743 {-0.9348653363923824510806070975377224385738,0.3550025391626905335584751810529269278049}
#define T_3125_1746 {-0.9327070178126004584839847666444256901741,0.3606350217645611921923887166485656052828}
#define T_3125_1749 {-0.9305147643674520629986091080354526638985,0.3662543833105415536088855787966167554259}
#define T_3125_1752 {-0.9282886558181315805882150016259402036667,0.3718604193502803578752491375780664384365}
#define T_3125_1758 {-0.9237351986075890142302569074672646820545,0.3830316995411713332231329331989400088787}
#define T_3125_1761 {-0.9214080156157081757939408817037474364042,0.3885965372454093236243011233455035835505}
#define T_3125_1764 {-0.9190473088523105626990172822843305766582,0.3941472365643651221134291517955716699362}
#define T_3125_1767 {-0.9166531642074609020909292667056433856487,0.3996835955458388767169708444271236658096}
#define T_3125_1773 {-0.9117649109133807439064867139677517116070,0.4107124873036063217313085260684601962566}
#define T_3125_1776 {-0.9092709801144442938181100544170476496220,0.4162046188135324897849898206914076581597}
#define T_3125_1779 {-0.9067439671281731783381019340595230460167,0.4216816074678410575238274304865626618266}
#define T_3125_1782 {-0.9041839638953846902680311359290499240160,0.4271432539961619867519004856148967519403}
#define T_3125_1788 {-0.8989653604515890350512563600204885005951,0.4380197263915685534918509347335202619433}
#define T_3125_1791 {-0.8963069501100714431274241178471129387617,0.4434341565377907801170920265576569363475}
#define T_3125_1794 {-0.8936159292541071552662401700217742472887,0.4488324531306960851750886831723619252443}
#define T_3125_1797 {-0.8908923957916445868221444470691494643688,0.4542144197629834345697474873304599896073}
#define T_3125_1803 {-0.8853481885899753267565870373800862580538,0.4649285804943050215420896620344137772918}
#define T_3125_1806 {-0.8825277165667645418167808202269952744246,0.4702603847778935586276816138706635683775}
#define T_3125_1809 {-0.8796751353617080493307867072871886193752,0.4755750794841552830938269380567362532020}
#define T_3125_1812 {-0.8767905487608365078244787582661956548691,0.4808724712474931606287498198071261867881}
#define T_3125_1818 {-0.8709257803342459469675418404222000390291,0.4914145756377040208384698871668661013246}
#define T_3125_1821 {-0.8679458118875658101387671194970607757568,0.4966589047090913533466505214164499193430}
#define T_3125_1824 {-0.8649342647953848217667882636305876076221,0.5018851637405385979207039781613275408745}
#define T_3125_1827 {-0.8618912486274211692816038521414157003164,0.5070931625840214840295061549113597720861}
#define T_3125_1833 {-0.8557112530637190905835609555651899427176,0.5174536224437120690566871417104266583920}
#define T_3125_1836 {-0.8525744985159912081584820953139569610357,0.5226057065132432288834252176457084715366}
#define T_3125_1839 {-0.8494067245803212928834113881748635321856,0.5277387765151716481071275666181463748217}
#define T_3125_1842 {-0.8462080465104597770675809442764148116112,0.5328526456919882026141976893995888531208}
#define T_3125_1848 {-0.8397184446008868485833431805076543241739,0.5430220380399558566253404023882467299700}
#define T_3125_1851 {-0.8364277568736554480111067277903202921152,0.5480771912160778969180796593718696385622}
#define T_3125_1854 {-0.8331066372286018983928101988567505031824,0.5531124035904914082451000467699486762285}
#define T_3125_1857 {-0.8297552064986845055116759795055259019136,0.5581274919660610400740097247762605547905}
#define T_3125_1863 {-0.8229619006257250513058920660114381462336,0.5680965675996416663906529720406979322433}
#define T_3125_1866 {-0.8195202726448849173124244771315716207027,0.5730501921507865636939982323383446782827}
#define T_3125_1869 {-0.8160488278945919882190196403826121240854,0.5779829673025517200457557009940501302481}
#define T_3125_1872 {-0.8125476926771126873205730589688755571842,0.5828947135847952765175250533502548933029}
// Pre-computed twiddles for N=4096
#define T_4096_1 {0.9999988234517018792502085489104501903057,-0.0015339801862847657169808268662336558918}
#define T_4096_3 {0.9999894110819284032132259198988322168589,-0.0046019261204485704952471536444136290811}
#define T_4096_5 {0.9999705864309741398798792033630888909101,-0.0076698287395310978803442125695255526807}
#define T_4096_7 {0.9999423496760239116198931696999352425337,-0.0107376591672644922798030009403191797901}
#define T_4096_9 {0.9999047010828528980752594179648440331221,-0.0138053885280603905877372383770307351369}
#define T_4096_11 {0.9998576410058238606026748129806946963072,-0.0168729879472817138885698540207158657722}
#define T_4096_13 {0.9998011698878842556936774599307682365179,-0.0199404285515144379103968930166956852190}
#define T_4096_15 {0.9997352882605616830602457412169314920902,-0.0230076814688393721519688028820382896811}
#define T_4096_17 {0.9996599967439592226980948908021673560143,-0.0260747178291039008457552483832841971889}
#define T_4096_19 {0.9995752960467492176377390933339484035969,-0.0291415087641937256557334023909788811579}
#define T_4096_21 {0.9994811869661669456732511207519564777613,-0.0322080254083045858237710490357130765915}
#define T_4096_23 {0.9993776703880028478010899561922997236252,-0.0352742388982139540298810231888637645170}
#define T_4096_25 {0.9992647472865944235920210303447674959898,-0.0383401203735526940885591784535790793598}
#define T_4096_27 {0.9991424187248169053177093701378908008337,-0.0414056409770767394618040668774483492598}
#define T_4096_29 {0.9990106858540733769658004348457325249910,-0.0444707718549386676887280600567464716733}
#define T_4096_31 {0.9988695499142835609873714020068291574717,-0.0475354841569593025707440858695917995647}
#define T_4096_33 {0.9987190122338729381112898408900946378708,-0.0505997490368992816622828456729621393606}
#define T_4096_35 {0.9985590742297593136456157481006812304258,-0.0536635376527305266169953767985134618357}
#define T_4096_37 {0.9983897374073401609351208207954186946154,-0.0567268211669077482284251345845405012369}
#define T_4096_39 {0.9982110033604781884619683296477887779474,-0.0597895707466398751428471314284252002835}
#define T_4096_41 {0.9980228737714862408125782167189754545689,-0.0628517575641614201220619406740297563374}
#define T_4096_43 {0.9978253504111116445329798807506449520588,-0.0659133527970038185506140848701761569828}
#define T_4096_45 {0.9976184351385195547834427998168393969536,-0.0689743276282667461263287123074405826628}
#define T_4096_47 {0.9974021299012753027923849913349840790033,-0.0720346532468893185896519071320653893054}
#define T_4096_49 {0.9971764367353261881987691594986245036125,-0.0750943008479213192085666150887846015394}
#define T_4096_51 {0.9969413577649821611714742175536230206490,-0.0781532416327942458522670676757115870714}
#define T_4096_53 {0.9966968952028960604394569600117392838001,-0.0812114468095924413315600531859672628343}
#define T_4096_55 {0.9964430513500426300765866471920162439346,-0.0842688875933240710836003017902839928865}
#define T_4096_57 {0.9961798285956969811749672771838959306479,-0.0873255352061920731010502549906959757209}
#define T_4096_59 {0.9959072294174117212506303076224867254496,-0.0903813608778649829611495647441188339144}
#define T_4096_61 {0.9956252563809943056938323024951387196779,-0.0934363358457477866103602082148427143693}
#define T_4096_63 {0.9953339121404822797956057911505922675133,-0.0964904313552525927377701009390875697136}
#define T_4096_65 {0.9950331994381186317966125898237805813551,-0.0995436186600693329040723256184719502926}
#define T_4096_67 {0.9947231211043257026460651104571297764778,-0.1025958690224362951370906671400007326156}
#define T_4096_69 {0.9944036800576790957606476695218589156866,-0.1056471537134106158939417241526825819165}
#define T_4096_71 {0.9940748793048793663373885465261992067099,-0.1086974440131387165120457893863203935325}
#define T_4096_73 {0.9937367219407245988449517426488455384970,-0.1117467112111266008822596518257341813296}
#define T_4096_75 {0.9933892111480806530465770265436731278896,-0.1147949266065100837330703598127001896501}
#define T_4096_77 {0.9930323501978514100230199801444541662931,-0.1178420615083249772814255607045197393745}
#define T_4096_79 {0.9926661424489480189947698818286880850792,-0.1208880872357770835945345311301934998482}
#define T_4096_81 {0.9922905913482573669881503519718535244465,-0.1239329751185121730738813994321390055120}
#define T_4096_83 {0.9919057004306093272560929108294658362865,-0.1269766964968858657947237134067108854651}
#define T_4096_85 {0.9915114733187438966766080739034805446863,-0.1300192227222333463121373142712400294840}
#define T_4096_87 {0.9911079137232768898613244346051942557096,-0.1330605251571390645892734028166159987450}
#define T_4096_89 {0.9906950254426646340633055842772591859102,-0.1361005751757062010032228727141045965254}
#define T_4096_91 {0.9902728123631691081740768822783138602972,-0.1391393441638262007398196828944492153823}
#define T_4096_93 {0.9898412784588205282076955882075708359480,-0.1421768035194480583882636892667505890131}
#define T_4096_95 {0.9894004277913803768740308441920205950737,-0.1452129246528474637578653982927789911628}
#define T_4096_97 {0.9889502645103029898621116444701328873634,-0.1482476789868960309615175674480269663036}
#define T_4096_99 {0.9884907928526965870119624923972878605127,-0.1512810379573302221878350337647134438157}
#define T_4096_101 {0.9880220171432835263303218198416288942099,-0.1543129730130201049398408486013067886233}
#define T_4096_103 {0.9875439417943592257387308563920669257641,-0.1573434556162382480515304905566154047847}
#define T_4096_105 {0.9870565713057509737993200360506307333708,-0.1603724572429282568819530752080027014017}
#define T_4096_107 {0.9865599102647754081729658537369687110186,-0.1633999493829732252425657179628615267575}
#define T_4096_109 {0.9860539633461954389659354092145804315805,-0.1664259035404641318134366656522615812719}
#define T_4096_111 {0.9855387353121760618535063258605077862740,-0.1694502912339679590036922718354617245495}
#define T_4096_113 {0.9850142310122398381366792818880639970303,-0.1724730839967959783454176658779033459723}
#define T_4096_115 {0.9844804553832209315089585288660600781441,-0.1754942533772714252648938781931065022945}
#define T_4096_117 {0.9839374134492189227785274852067232131958,-0.1785137709389975346763179686604416929185}
#define T_4096_119 {0.9833851103215511813004923169501125812531,-0.1815316082611249937084352268357179127634}
#define T_4096_121 {0.9828235511987052364091255185485351830721,-0.1845477369386196164757762971930787898600}
#define T_4096_123 {0.9822527413662893724932700934004969894886,-0.1875621285825296025162600699331960640848}
#define T_4096_125 {0.9816726861969831130494412718690000474453,-0.1905747548202527674732209561625495553017}
#define T_4096_127 {0.9810833911504867055342060666589532047510,-0.1935855872958036349995580849281395785511}
#define T_4096_129 {0.9804848617734693849712357405223883688450,-0.1965945976700802233505527283341507427394}
#define T_4096_131 {0.9798771036995176375583582739636767655611,-0.1996017576211309707545638048031833022833}
#define T_4096_133 {0.9792601226490820209846788202412426471710,-0.2026070388444211334277866853881278075278}
#define T_4096_135 {0.9786339244294232075915829227596987038851,-0.2056104130530992668557388469707802869380}
#define T_4096_137 {0.9779985149345571393553200323367491364479,-0.2086118519782634850301406004291493445635}
#define T_4096_139 {0.9773539001451999608249820994387846440077,-0.2116113273692275809079177406601957045496}
#define T_4096_141 {0.9767000861287118418374575412599369883537,-0.2146088109937867582921455777977826073766}
#define T_4096_143 {0.9760370790390390238755458085506688803434,-0.2176042746384836412687491247197613120079}
#define T_4096_145 {0.9753648851166569766490965776029042899609,-0.2205976901088735342426616625743918120861}
#define T_4096_147 {0.9746835106885106680962849168281536549330,-0.2235890292297899872853150782248121686280}
#define T_4096_149 {0.9739929621679558335856086159765254706144,-0.2265782638456100006596471985176322050393}
#define T_4096_151 {0.9732932460546982467164411900739651173353,-0.2295653658205188962782017370045650750399}
#define T_4096_153 {0.9725843689347322129634676457499153912067,-0.2325503070387752446723794719218858517706}
#define T_4096_155 {0.9718663374802793963880276351119391620159,-0.2355330594049755144059332678807550109923}
#define T_4096_157 {0.9711391584497250928365019717602990567684,-0.2385135948443184439327069412684068083763}
#define T_4096_159 {0.9704028386875555023394213094434235244989,-0.2414918853028693301876472787625971250236}
#define T_4096_161 {0.9696573851242924479976181828533299267292,-0.2444679027478241783999379777014837600291}
#define T_4096_163 {0.9689028047764288720244962860306259244680,-0.2474416191677732967946212738752365112305}
#define T_4096_165 {0.9681391047463624444091578880033921450377,-0.2504130065729652798722781881224364042282}
#define T_4096_167 {0.9673662922223285054457164733321405947208,-0.2533820369955701590214403040590696036816}
#define T_4096_169 {0.9665843744783331192849118451704271137714,-0.2563486824899429139534845489833969622850}
#define T_4096_171 {0.9657933588740836849950710529810748994350,-0.2593129151328862347369863528001587837934}
#define T_4096_173 {0.9649932528549203247791865578619763255119,-0.2622747070239136446545558101206552237272}
#define T_4096_175 {0.9641840639517458289020623851683922111988,-0.2652340302855117903924053734954213723540}
#define T_4096_177 {0.9633657997809540463052258019160944968462,-0.2681908570634031763191273967095185071230}
#define T_4096_179 {0.9625384680443591634002586943097412586212,-0.2711451595268080105860519779525930061936}
#define T_4096_181 {0.9617020765291225403714747699268627911806,-0.2740969098687063842945121905358973890543}
#define T_4096_183 {0.9608566331076796585008992224175017327070,-0.2770460803060998955515970010310411453247}
#define T_4096_185 {0.9600021457376658462479213085316587239504,-0.2799926430802732180147529561509145423770}
#define T_4096_187 {0.9591386224618418943066444626310840249062,-0.2829365704570553363694784820836503058672}
#define T_4096_189 {0.9582660714080176722617920859192963689566,-0.2858778347270806152735644900531042367220}
#define T_4096_191 {0.9573845007889758562669157981872558593750,-0.2888164082060494797232763630745466798544}
#define T_4096_193 {0.9564939189023951016110913769807666540146,-0.2917522632349892619529896364838350564241}
#define T_4096_195 {0.9555943341307711058618679089704528450966,-0.2946853721805143266898596721148351207376}
#define T_4096_197 {0.9546857549413383381420317164156585931778,-0.2976157074350861964084913324768422171474}
#define T_4096_199 {0.9537681898859903251164382709248457103968,-0.3005432414172734545410037299006944522262}
#define T_4096_201 {0.9528416476011987157335170195437967777252,-0.3034679465720113156201875881379237398505}
#define T_4096_203 {0.9519061368079323459667762108438182622194,-0.3063897953708609733780576789285987615585}
#define T_4096_205 {0.9509616663115750823109806333377491682768,-0.3093087603122687267998003335378598421812}
#define T_4096_207 {0.9500082450018429991445145788020454347134,-0.3122248139218249396442672605189727619290}
#define T_4096_209 {0.9490458818527005568910226429579779505730,-0.3151379287525223893418058196402853354812}
#define T_4096_211 {0.9480745859222762250695382135745603591204,-0.3180480773850149489589966833591461181641}
#define T_4096_213 {0.9470943663527772171661922584462445229292,-0.3209552324278752144515181043971097096801}
#define T_4096_215 {0.9461052323704034483498048757610376924276,-0.3238593665178529090731274209247203543782}
#define T_4096_217 {0.9451071932852606050090571443433873355389,-0.3267604523201317889835593177849659696221}
#define T_4096_219 {0.9441002584912726591781506613187957555056,-0.3296584625285874925459950190997915342450}
#define T_4096_221 {0.9430844374660934947840473796532023698092,-0.3325533698660442238903556244622450321913}
#define T_4096_223 {0.9420597397710173126483823580201715230942,-0.3354451470845316585212003701599314808846}
#define T_4096_225 {0.9410261750508892575339814356993883848190,-0.3383337669655411827918101153045427054167}
#define T_4096_227 {0.9399837530340139357676321196777280420065,-0.3412192023202824109340269842505222186446}
#define T_4096_229 {0.9389324835320644879743667843285948038101,-0.3441014259899388694208255401463247835636}
#define T_4096_231 {0.9378723764399898854549064708407968282700,-0.3469804108459236813288839584856759756804}
#define T_4096_233 {0.9368034417359215604292899115534964948893,-0.3498561297901349176342478131118696182966}
#define T_4096_235 {0.9357256894810803693474099418381229043007,-0.3527285557552107264633889371907571330667}
#define T_4096_237 {0.9346391298196807806419883490889333188534,-0.3555976617047839072327519716054666787386}
#define T_4096_239 {0.9335437729788361727045753468701150268316,-0.3584634206337365402994521446089493110776}
#define T_4096_241 {0.9324396292684623555047096488124225288630,-0.3613258055684542835450656639295630156994}
#define T_4096_243 {0.9313267090811804260752637674158904701471,-0.3641847895670798918033028712670784443617}
#define T_4096_245 {0.9302050228922190688862770002742763608694,-0.3670403457197671803768912468513008207083}
#define T_4096_247 {0.9290745812593157459957637911429628729820,-0.3698924471489341003760387138754595071077}
#define T_4096_249 {0.9279353948226178872005220910068601369858,-0.3727410670095158140568969429295975714922}
#define T_4096_251 {0.9267874743045817487185900063195731490850,-0.3755861784892172150485123438556911423802}
#define T_4096_253 {0.9256308305098727151616344599460717290640,-0.3784277548087655596020795201184228062630}
#define T_4096_255 {0.9244654743252626039051733641827013343573,-0.3812657692221623761952287168242037296295}
#define T_4096_257 {0.9232914167195276355926125688711181282997,-0.3841001950169350420694058811932336539030}
#define T_4096_259 {0.9221086687433450723716532593243755400181,-0.3869310055143885818118576480628689751029}
#define T_4096_261 {0.9209172415291894120414895041903946548700,-0.3897581740698564667368941627501044422388}
#define T_4096_263 {0.9197171462912273609546787156432401388884,-0.3925816740729514697783031351718818768859}
#define T_4096_265 {0.9185083943252122518074997969961259514093,-0.3954014789478163538483102001919178292155}
#define T_4096_267 {0.9172909970083779063187989777361508458853,-0.3982175621533736165069683465844718739390}
#define T_4096_269 {0.9160649657993317207527184109494555741549,-0.4010298971835756232096059648029040545225}
#define T_4096_271 {0.9148303122379461971291902955272234976292,-0.4038384575676541299316113509121350944042}
#define T_4096_273 {0.9135870479452508075013383859186433255672,-0.4066432168703690286370999729115283116698}
#define T_4096_275 {0.9123351846233227480098548767273314297199,-0.4094441486922575923479428183782147243619}
#define T_4096_277 {0.9110747340551763606697477371199056506157,-0.4122412266698828875455262732430128380656}
#define T_4096_279 {0.9098057081046522220901806576875969767570,-0.4150344244760816314609996879880782216787}
#define T_4096_281 {0.9085281187163061211720105347922071814537,-0.4178237158202123269212791001336881890893}
#define T_4096_283 {0.9072419779152958163592757045989856123924,-0.4206090744484025090166312565997941419482}
#define T_4096_285 {0.9059472978072684590244989522034302353859,-0.4233904741437960472794088673254009336233}
#define T_4096_287 {0.9046440905782462404971511205076240003109,-0.4261678887267996707066686212783679366112}
#define T_4096_289 {0.9033323684945118170475097940652631223202,-0.4289412920553294927827892024652101099491}
#define T_4096_291 {0.9020121439024931797590056703484151512384,-0.4317106580250572589463331496517639607191}
#define T_4096_293 {0.9006834292286468590660319932794664055109,-0.4344759605696557058784890159586211666465}
#define T_4096_295 {0.8993462369793415733809638368256855756044,-0.4372371736610440873249672222300432622433}
#define T_4096_297 {0.8980005797407398793197330633120145648718,-0.4399942713096332558286860603402601554990}
#define T_4096_299 {0.8966464701786801549943106692808214575052,-0.4427472275645700228174916901480173692107}
#define T_4096_301 {0.8952839210385574730821645061951130628586,-0.4454960165139817407364830614824313670397}
#define T_4096_303 {0.8939129451452032526503899134695529937744,-0.4482406122852199414907659047457855194807}
#define T_4096_305 {0.8925335554027645779129329639545176178217,-0.4509809890451038638659042590006720274687}
#define T_4096_307 {0.8911457647945831839209063218731898814440,-0.4537171210001638699260695375414798036218}
#define T_4096_309 {0.8897495863830727769183681630238424986601,-0.4564489823968839177226186620828229933977}
#define T_4096_311 {0.8883450333095963546981010949821211397648,-0.4591765475219441450249746594636235386133}
#define T_4096_313 {0.8869321187943421946897615271154791116714,-0.4618997907024627314065412519994424656034}
#define T_4096_315 {0.8855108561361999530703315031132660806179,-0.4646186863062378158417686790926381945610}
#define T_4096_317 {0.8840812587126349875177311332663521170616,-0.4673332087419884151024973562016384676099}
#define T_4096_319 {0.8826433399795627909867334892624057829380,-0.4700433324595956197100576900993473827839}
#define T_4096_321 {0.8811971134712219821949474862776696681976,-0.4727490319503427906866477314906660467386}
#define T_4096_323 {0.8797425928000474071311032275843899697065,-0.4754502817471558673290132901456672698259}
#define T_4096_325 {0.8782797916565414642064979489077813923359,-0.4781470564248430643594645061966730281711}
#define T_4096_327 {0.8768087238091456514510468878143001347780,-0.4808393306003339584542288775992346927524}
#define T_4096_329 {0.8753294031041108924640070654277224093676,-0.4835270789329187413052579813665943220258}
#define T_4096_331 {0.8738418434653668631639789055043365806341,-0.4862102761244864179701608009054325520992}
#define T_4096_333 {0.8723460588943915405835127785394433885813,-0.4888888969197631717555907471250975504518}
#define T_4096_335 {0.8708420634700788642845736831077374517918,-0.4915629161065499519445154419372556731105}
#define T_4096_337 {0.8693298713486067308409133147506508976221,-0.4942323085159597284565791142085799947381}
#define T_4096_339 {0.8678094967633032119636027346132323145866,-0.4968970490226545244638600706821307539940}
#define T_4096_341 {0.8662809540245129946711699631123337894678,-0.4995571125450818938951158543204655870795}
#define T_4096_343 {0.8647442575194623781698055609012953937054,-0.5022124740457107883173648588126525282860}
#define T_4096_345 {0.8631994217121241597112657473189756274223,-0.5048631085312675903509216368547640740871}
#define T_4096_347 {0.8616464611430812992054484311665873974562,-0.5075089910529708703279538895003497600555}
#define T_4096_349 {0.8600853904293901397437593914219178259373,-0.5101500967067668090848542306048329919577}
#define T_4096_351 {0.8585162242644427399440587578283157199621,-0.5127864006335630664423774760507512837648}
#define T_4096_353 {0.8569389774178287622063976414210628718138,-0.5154178780194630382638365517777856439352}
#define T_4096_355 {0.8553536647351960287011252148658968508244,-0.5180445040959993363571811642032116651535}
#define T_4096_357 {0.8537603011381114104239031803444959223270,-0.5206662541403671573547740081266965717077}
#define T_4096_359 {0.8521589016239198288715783746738452464342,-0.5232831034756564303478398869629018008709}
#define T_4096_361 {0.8505494812656034797626602994569111615419,-0.5258950274710846306547296080680098384619}
#define T_4096_363 {0.8489320552116396134678666385298129171133,-0.5285020015422284833661592529097106307745}
#define T_4096_365 {0.8473066386858584264629712379246484488249,-0.5311040011512550007566346721432637423277}
#define T_4096_367 {0.8456732469872990654025102230662014335394,-0.5337010018071529637850858307501766830683}
#define T_4096_369 {0.8440318954900664083496053535782266408205,-0.5362929790659631823501740655046887695789}
#define T_4096_371 {0.8423825996431858476043430528079625219107,-0.5388799085310084224786919548932928591967}
#define T_4096_373 {0.8407253749704580725321534373506437987089,-0.5414617658531234445362656515499111264944}
#define T_4096_375 {0.8390602370703127421691647214174736291170,-0.5440385267308839312150325895345304161310}
#define T_4096_377 {0.8373872016156619357829526961722876876593,-0.5466101669108348604098068790335673838854}
#define T_4096_379 {0.8357062843537526042325680464273318648338,-0.5491766621877197662726644011854659765959}
#define T_4096_381 {0.8340175011060181331501439672138076275587,-0.5517379884047074467545712650462519377470}
#define T_4096_383 {0.8323208677679296840778988553211092948914,-0.5542941214536201144369442772585898637772}
#define T_4096_385 {0.8306164003088463143598119131638668477535,-0.5568450372751601040732793990173377096653}
#define T_4096_387 {0.8289041147718648749886938276176806539297,-0.5593907118591360250192678904568310827017}
#define T_4096_389 {0.8271840272736691312971402112452778965235,-0.5619311212446894687744247676164377480745}
#define T_4096_391 {0.8254561540043775513808554933348204940557,-0.5644662415205194960776680090930312871933}
#define T_4096_393 {0.8237205112273914275888841984851751476526,-0.5669960488251086783151322379126213490963}
#define T_4096_395 {0.8219771152792415547239102124876808375120,-0.5695205193469471405265380781202111393213}
#define T_4096_397 {0.8202259825694346861979511231766082346439,-0.5720396293247570485007713614322710782290}
#define T_4096_399 {0.8184671295802986579204230110917706042528,-0.5745533550477157636038327837013639509678}
#define T_4096_401 {0.8167005728668278452531126276880968362093,-0.5770616728556795527182998739590402692556}
#define T_4096_403 {0.8149263290565266215637052482634317129850,-0.5795645591394057438705544882395770400763}
#define T_4096_405 {0.8131444148492534829131272999802604317665,-0.5820619903407755479918250784976407885551}
#define T_4096_407 {0.8113548470170637294529569771839305758476,-0.5845539429530153263669944863067939877510}
#define T_4096_409 {0.8095576424040512586444151565956417471170,-0.5870403935209179691057101990736555308104}
#define T_4096_411 {0.8077528179261903584773563125054351985455,-0.5895213186410639405465872187050990760326}
#define T_4096_413 {0.8059403905711762794439323442929890006781,-0.5919966949620409923937813800876028835773}
#define T_4096_415 {0.8041203773982656954899539414327591657639,-0.5944664991846644319650749821448698639870}
#define T_4096_417 {0.8022927955381157216763199357956182211637,-0.5969307080621965022615427187702152878046}
#define T_4096_419 {0.8004576621926228208181441914348397403955,-0.5993892984005645407918905220867600291967}
#define T_4096_421 {0.7986149946347608219454627942468505352736,-0.6018422470585800265752141058328561484814}
#define T_4096_423 {0.7967648102084187167193363166006747633219,-0.6042895309481560728315230335283558815718}
#define T_4096_425 {0.7949071263282370125580200692638754844666,-0.6067311270345244755830549365782644599676}
#define T_4096_427 {0.7930419604794436416739245032658800482750,-0.6091670123364532063447995824390091001987}
#define T_4096_429 {0.7911693302176902031774829993082676082850,-0.6115971639264619064135786175029352307320}
#define T_4096_431 {0.7892892531688856516680630193150136619806,-0.6140215589310383803578474726236891001463}
#define T_4096_433 {0.7874017470290314291148092706862371414900,-0.6164401745308536462175652559380978345871}
#define T_4096_435 {0.7855068295640539322022277701762504875660,-0.6188529879609763195702498705941252410412}
#define T_4096_437 {0.7836045186096382009210969954438041895628,-0.6212599765110876637308479075727518647909}
#define T_4096_439 {0.7816948320710593867133297862892504781485,-0.6236611175256945305278577507124282419682}
#define T_4096_441 {0.7797777879230144426614401709230151027441,-0.6260563884043435223247797694057226181030}
#define T_4096_443 {0.7778534042094530365218929546244908124208,-0.6284457666018327115509123359515797346830}
#define T_4096_445 {0.7759216990434075755800336082756984978914,-0.6308292296284245814774749305797740817070}
#define T_4096_447 {0.7739826906068227874158083068323321640491,-0.6332067550500573016591943087405525147915}
#define T_4096_449 {0.7720363971503845235133667301852256059647,-0.6355783204885561143981931309099309146404}
#define T_4096_451 {0.7700828369933480077591525514435488730669,-0.6379439036218440550740638173010665923357}
#define T_4096_453 {0.7681220285233654188061791501240804791451,-0.6403034821841516732732202399347443133593}
#define T_4096_455 {0.7661539901963129173267930127622094005346,-0.6426570339662268649405518772255163639784}
#define T_4096_457 {0.7641787405361166740647149708820506930351,-0.6450045368155439273749607309582643210888}
#define T_4096_459 {0.7621962981345788978870814389665611088276,-0.6473459686365120591133859306864906102419}
#define T_4096_461 {0.7602066816512024205465536397241521626711,-0.6496813073906831936810135630366858094931}
#define T_4096_463 {0.7582099098130152814434268293553031980991,-0.6520105310969595002745791134657338261604}
#define T_4096_465 {0.7562060014143945352316222852095961570740,-0.6543336178318005513787625204713549464941}
#define T_4096_467 {0.7541949753168891712462595933175180107355,-0.6566505457294290470926512170990463346243}
#define T_4096_469 {0.7521768504490426998643215483753010630608,-0.6589612929820373166123204100586008280516}
#define T_4096_471 {0.7501516458062150727315042786358390003443,-0.6612658378399922654011788836214691400528}
#define T_4096_473 {0.7481193804504036037883452081587165594101,-0.6635641586120397672488024909398518502712}
#define T_4096_475 {0.7460800735100637792740485565445851534605,-0.6658562336655097224635824204597156494856}
#define T_4096_477 {0.7440337441799292905741936010599602013826,-0.6681420414265185625524168244737666100264}
#define T_4096_479 {0.7419804117208310678677207761211320757866,-0.6704215603801730871680319978622719645500}
#define T_4096_481 {0.7399200954595162027516153102624230086803,-0.6726947690707729687886740066460333764553}
#define T_4096_483 {0.7378528147884659826871711629792116582394,-0.6749616461020120361524732288671657443047}
#define T_4096_485 {0.7357785891657134813570451115083415061235,-0.6772221701371804458702285955951083451509}
#define T_4096_487 {0.7336974381146602608438911374832969158888,-0.6794763198993650776813524316821713000536}
#define T_4096_489 {0.7316093812238925186974825010111089795828,-0.6817240741716498186875128340034279972315}
#define T_4096_491 {0.7295144381469970129572288897179532796144,-0.6839654117973154034970661996339913457632}
#define T_4096_493 {0.7274126286023757659293664801225531846285,-0.6862003116800385882356749789323657751083}
#define T_4096_495 {0.7253039723730607679641479990095831453800,-0.6884287527840904363785057284985668957233}
#define T_4096_497 {0.7231884893065274599877056971308775246143,-0.6906507141345346045824271641322411596775}
#define T_4096_499 {0.7210661993145081050116118603909853845835,-0.6928661748174246293174860511498991400003}
#define T_4096_501 {0.7189371223728044935086245459388010203838,-0.6950751139800008804314757071551866829395}
#define T_4096_503 {0.7168012785210995385654086931026540696621,-0.6972775108308865155137823421682696789503}
#define T_4096_505 {0.7146586878627690930798621593567077070475,-0.6994733446402837673261387863021809607744}
#define T_4096_507 {0.7125093705646923236685097435838542878628,-0.7016625947401684548765388171887025237083}
#define T_4096_509 {0.7103533468570623066185021343699190765619,-0.7038452405244849385823613374668639153242}
#define T_4096_511 {0.7081906370331952915719853081100154668093,-0.7060212614493397431658650020835921168327}
#define T_4096_513 {0.7060212614493397431658650020835921168327,-0.7081906370331952915719853081100154668093}
#define T_4096_515 {0.7038452405244849385823613374668639153242,-0.7103533468570623066185021343699190765619}
#define T_4096_517 {0.7016625947401684548765388171887025237083,-0.7125093705646923236685097435838542878628}
#define T_4096_519 {0.6994733446402837673261387863021809607744,-0.7146586878627690930798621593567077070475}
#define T_4096_521 {0.6972775108308865155137823421682696789503,-0.7168012785210995385654086931026540696621}
#define T_4096_523 {0.6950751139800008804314757071551866829395,-0.7189371223728044935086245459388010203838}
#define T_4096_525 {0.6928661748174246293174860511498991400003,-0.7210661993145081050116118603909853845835}
#define T_4096_527 {0.6906507141345346045824271641322411596775,-0.7231884893065274599877056971308775246143}
#define T_4096_529 {0.6884287527840904363785057284985668957233,-0.7253039723730607679641479990095831453800}
#define T_4096_531 {0.6862003116800385882356749789323657751083,-0.7274126286023757659293664801225531846285}
#define T_4096_533 {0.6839654117973154034970661996339913457632,-0.7295144381469970129572288897179532796144}
#define T_4096_535 {0.6817240741716498186875128340034279972315,-0.7316093812238925186974825010111089795828}
#define T_4096_537 {0.6794763198993650776813524316821713000536,-0.7336974381146602608438911374832969158888}
#define T_4096_539 {0.6772221701371804458702285955951083451509,-0.7357785891657134813570451115083415061235}
#define T_4096_541 {0.6749616461020120361524732288671657443047,-0.7378528147884659826871711629792116582394}
#define T_4096_543 {0.6726947690707729687886740066460333764553,-0.7399200954595162027516153102624230086803}
#define T_4096_545 {0.6704215603801730871680319978622719645500,-0.7419804117208310678677207761211320757866}
#define T_4096_547 {0.6681420414265185625524168244737666100264,-0.7440337441799292905741936010599602013826}
#define T_4096_549 {0.6658562336655097224635824204597156494856,-0.7460800735100637792740485565445851534605}
#define T_4096_551 {0.6635641586120397672488024909398518502712,-0.7481193804504036037883452081587165594101}
#define T_4096_553 {0.6612658378399922654011788836214691400528,-0.7501516458062150727315042786358390003443}
#define T_4096_555 {0.6589612929820373166123204100586008280516,-0.7521768504490426998643215483753010630608}
#define T_4096_557 {0.6566505457294290470926512170990463346243,-0.7541949753168891712462595933175180107355}
#define T_4096_559 {0.6543336178318005513787625204713549464941,-0.7562060014143945352316222852095961570740}
#define T_4096_561 {0.6520105310969595002745791134657338261604,-0.7582099098130152814434268293553031980991}
#define T_4096_563 {0.6496813073906831936810135630366858094931,-0.7602066816512024205465536397241521626711}
#define T_4096_565 {0.6473459686365120591133859306864906102419,-0.7621962981345788978870814389665611088276}
#define T_4096_567 {0.6450045368155439273749607309582643210888,-0.7641787405361166740647149708820506930351}
#define T_4096_569 {0.6426570339662268649405518772255163639784,-0.7661539901963129173267930127622094005346}
#define T_4096_571 {0.6403034821841516732732202399347443133593,-0.7681220285233654188061791501240804791451}
#define T_4096_573 {0.6379439036218440550740638173010665923357,-0.7700828369933480077591525514435488730669}
#define T_4096_575 {0.6355783204885561143981931309099309146404,-0.7720363971503845235133667301852256059647}
#define T_4096_577 {0.6332067550500573016591943087405525147915,-0.7739826906068227874158083068323321640491}
#define T_4096_579 {0.6308292296284245814774749305797740817070,-0.7759216990434075755800336082756984978914}
#define T_4096_581 {0.6284457666018327115509123359515797346830,-0.7778534042094530365218929546244908124208}
#define T_4096_583 {0.6260563884043435223247797694057226181030,-0.7797777879230144426614401709230151027441}
#define T_4096_585 {0.6236611175256945305278577507124282419682,-0.7816948320710593867133297862892504781485}
#define T_4096_587 {0.6212599765110876637308479075727518647909,-0.7836045186096382009210969954438041895628}
#define T_4096_589 {0.6188529879609763195702498705941252410412,-0.7855068295640539322022277701762504875660}
#define T_4096_591 {0.6164401745308536462175652559380978345871,-0.7874017470290314291148092706862371414900}
#define T_4096_593 {0.6140215589310383803578474726236891001463,-0.7892892531688856516680630193150136619806}
#define T_4096_595 {0.6115971639264619064135786175029352307320,-0.7911693302176902031774829993082676082850}
#define T_4096_597 {0.6091670123364532063447995824390091001987,-0.7930419604794436416739245032658800482750}
#define T_4096_599 {0.6067311270345244755830549365782644599676,-0.7949071263282370125580200692638754844666}
#define T_4096_601 {0.6042895309481560728315230335283558815718,-0.7967648102084187167193363166006747633219}
#define T_4096_603 {0.6018422470585800265752141058328561484814,-0.7986149946347608219454627942468505352736}
#define T_4096_605 {0.5993892984005645407918905220867600291967,-0.8004576621926228208181441914348397403955}
#define T_4096_607 {0.5969307080621965022615427187702152878046,-0.8022927955381157216763199357956182211637}
#define T_4096_609 {0.5944664991846644319650749821448698639870,-0.8041203773982656954899539414327591657639}
#define T_4096_611 {0.5919966949620409923937813800876028835773,-0.8059403905711762794439323442929890006781}
#define T_4096_613 {0.5895213186410639405465872187050990760326,-0.8077528179261903584773563125054351985455}
#define T_4096_615 {0.5870403935209179691057101990736555308104,-0.8095576424040512586444151565956417471170}
#define T_4096_617 {0.5845539429530153263669944863067939877510,-0.8113548470170637294529569771839305758476}
#define T_4096_619 {0.5820619903407755479918250784976407885551,-0.8131444148492534829131272999802604317665}
#define T_4096_621 {0.5795645591394057438705544882395770400763,-0.8149263290565266215637052482634317129850}
#define T_4096_623 {0.5770616728556795527182998739590402692556,-0.8167005728668278452531126276880968362093}
#define T_4096_625 {0.5745533550477157636038327837013639509678,-0.8184671295802986579204230110917706042528}
#define T_4096_627 {0.5720396293247570485007713614322710782290,-0.8202259825694346861979511231766082346439}
#define T_4096_629 {0.5695205193469471405265380781202111393213,-0.8219771152792415547239102124876808375120}
#define T_4096_631 {0.5669960488251086783151322379126213490963,-0.8237205112273914275888841984851751476526}
#define T_4096_633 {0.5644662415205194960776680090930312871933,-0.8254561540043775513808554933348204940557}
#define T_4096_635 {0.5619311212446894687744247676164377480745,-0.8271840272736691312971402112452778965235}
#define T_4096_637 {0.5593907118591360250192678904568310827017,-0.8289041147718648749886938276176806539297}
#define T_4096_639 {0.5568450372751601040732793990173377096653,-0.8306164003088463143598119131638668477535}
#define T_4096_641 {0.5542941214536201144369442772585898637772,-0.8323208677679296840778988553211092948914}
#define T_4096_643 {0.5517379884047074467545712650462519377470,-0.8340175011060181331501439672138076275587}
#define T_4096_645 {0.5491766621877197662726644011854659765959,-0.8357062843537526042325680464273318648338}
#define T_4096_647 {0.5466101669108348604098068790335673838854,-0.8373872016156619357829526961722876876593}
#define T_4096_649 {0.5440385267308839312150325895345304161310,-0.8390602370703127421691647214174736291170}
#define T_4096_651 {0.5414617658531234445362656515499111264944,-0.8407253749704580725321534373506437987089}
#define T_4096_653 {0.5388799085310084224786919548932928591967,-0.8423825996431858476043430528079625219107}
#define T_4096_655 {0.5362929790659631823501740655046887695789,-0.8440318954900664083496053535782266408205}
#define T_4096_657 {0.5337010018071529637850858307501766830683,-0.8456732469872990654025102230662014335394}
#define T_4096_659 {0.5311040011512550007566346721432637423277,-0.8473066386858584264629712379246484488249}
#define T_4096_661 {0.5285020015422284833661592529097106307745,-0.8489320552116396134678666385298129171133}
#define T_4096_663 {0.5258950274710846306547296080680098384619,-0.8505494812656034797626602994569111615419}
#define T_4096_665 {0.5232831034756564303478398869629018008709,-0.8521589016239198288715783746738452464342}
#define T_4096_667 {0.5206662541403671573547740081266965717077,-0.8537603011381114104239031803444959223270}
#define T_4096_669 {0.5180445040959993363571811642032116651535,-0.8553536647351960287011252148658968508244}
#define T_4096_671 {0.5154178780194630382638365517777856439352,-0.8569389774178287622063976414210628718138}
#define T_4096_673 {0.5127864006335630664423774760507512837648,-0.8585162242644427399440587578283157199621}
#define T_4096_675 {0.5101500967067668090848542306048329919577,-0.8600853904293901397437593914219178259373}
#define T_4096_677 {0.5075089910529708703279538895003497600555,-0.8616464611430812992054484311665873974562}
#define T_4096_679 {0.5048631085312675903509216368547640740871,-0.8631994217121241597112657473189756274223}
#define T_4096_681 {0.5022124740457107883173648588126525282860,-0.8647442575194623781698055609012953937054}
#define T_4096_683 {0.4995571125450818938951158543204655870795,-0.8662809540245129946711699631123337894678}
#define T_4096_685 {0.4968970490226545244638600706821307539940,-0.8678094967633032119636027346132323145866}
#define T_4096_687 {0.4942323085159597284565791142085799947381,-0.8693298713486067308409133147506508976221}
#define T_4096_689 {0.4915629161065499519445154419372556731105,-0.8708420634700788642845736831077374517918}
#define T_4096_691 {0.4888888969197631717555907471250975504518,-0.8723460588943915405835127785394433885813}
#define T_4096_693 {0.4862102761244864179701608009054325520992,-0.8738418434653668631639789055043365806341}
#define T_4096_695 {0.4835270789329187413052579813665943220258,-0.8753294031041108924640070654277224093676}
#define T_4096_697 {0.4808393306003339584542288775992346927524,-0.8768087238091456514510468878143001347780}
#define T_4096_699 {0.4781470564248430643594645061966730281711,-0.8782797916565414642064979489077813923359}
#define T_4096_701 {0.4754502817471558673290132901456672698259,-0.8797425928000474071311032275843899697065}
#define T_4096_703 {0.4727490319503427906866477314906660467386,-0.8811971134712219821949474862776696681976}
#define T_4096_705 {0.4700433324595956197100576900993473827839,-0.8826433399795627909867334892624057829380}
#define T_4096_707 {0.4673332087419884151024973562016384676099,-0.8840812587126349875177311332663521170616}
#define T_4096_709 {0.4646186863062378158417686790926381945610,-0.8855108561361999530703315031132660806179}
#define T_4096_711 {0.4618997907024627314065412519994424656034,-0.8869321187943421946897615271154791116714}
#define T_4096_713 {0.4591765475219441450249746594636235386133,-0.8883450333095963546981010949821211397648}
#define T_4096_715 {0.4564489823968839177226186620828229933977,-0.8897495863830727769183681630238424986601}
#define T_4096_717 {0.4537171210001638699260695375414798036218,-0.8911457647945831839209063218731898814440}
#define T_4096_719 {0.4509809890451038638659042590006720274687,-0.8925335554027645779129329639545176178217}
#define T_4096_721 {0.4482406122852199414907659047457855194807,-0.8939129451452032526503899134695529937744}
#define T_4096_723 {0.4454960165139817407364830614824313670397,-0.8952839210385574730821645061951130628586}
#define T_4096_725 {0.4427472275645700228174916901480173692107,-0.8966464701786801549943106692808214575052}
#define T_4096_727 {0.4399942713096332558286860603402601554990,-0.8980005797407398793197330633120145648718}
#define T_4096_729 {0.4372371736610440873249672222300432622433,-0.8993462369793415733809638368256855756044}
#define T_4096_731 {0.4344759605696557058784890159586211666465,-0.9006834292286468590660319932794664055109}
#define T_4096_733 {0.4317106580250572589463331496517639607191,-0.9020121439024931797590056703484151512384}
#define T_4096_735 {0.4289412920553294927827892024652101099491,-0.9033323684945118170475097940652631223202}
#define T_4096_737 {0.4261678887267996707066686212783679366112,-0.9046440905782462404971511205076240003109}
#define T_4096_739 {0.4233904741437960472794088673254009336233,-0.9059472978072684590244989522034302353859}
#define T_4096_741 {0.4206090744484025090166312565997941419482,-0.9072419779152958163592757045989856123924}
#define T_4096_743 {0.4178237158202123269212791001336881890893,-0.9085281187163061211720105347922071814537}
#define T_4096_745 {0.4150344244760816314609996879880782216787,-0.9098057081046522220901806576875969767570}
#define T_4096_747 {0.4122412266698828875455262732430128380656,-0.9110747340551763606697477371199056506157}
#define T_4096_749 {0.4094441486922575923479428183782147243619,-0.9123351846233227480098548767273314297199}
#define T_4096_751 {0.4066432168703690286370999729115283116698,-0.9135870479452508075013383859186433255672}
#define T_4096_753 {0.4038384575676541299316113509121350944042,-0.9148303122379461971291902955272234976292}
#define T_4096_755 {0.4010298971835756232096059648029040545225,-0.9160649657993317207527184109494555741549}
#define T_4096_757 {0.3982175621533736165069683465844718739390,-0.9172909970083779063187989777361508458853}
#define T_4096_759 {0.3954014789478163538483102001919178292155,-0.9185083943252122518074997969961259514093}
#define T_4096_761 {0.3925816740729514697783031351718818768859,-0.9197171462912273609546787156432401388884}
#define T_4096_763 {0.3897581740698564667368941627501044422388,-0.9209172415291894120414895041903946548700}
#define T_4096_765 {0.3869310055143885818118576480628689751029,-0.9221086687433450723716532593243755400181}
#define T_4096_767 {0.3841001950169350420694058811932336539030,-0.9232914167195276355926125688711181282997}
#define T_4096_769 {0.3812657692221623761952287168242037296295,-0.9244654743252626039051733641827013343573}
#define T_4096_771 {0.3784277548087655596020795201184228062630,-0.9256308305098727151616344599460717290640}
#define T_4096_773 {0.3755861784892172150485123438556911423802,-0.9267874743045817487185900063195731490850}
#define T_4096_775 {0.3727410670095158140568969429295975714922,-0.9279353948226178872005220910068601369858}
#define T_4096_777 {0.3698924471489341003760387138754595071077,-0.9290745812593157459957637911429628729820}
#define T_4096_779 {0.3670403457197671803768912468513008207083,-0.9302050228922190688862770002742763608694}
#define T_4096_781 {0.3641847895670798918033028712670784443617,-0.9313267090811804260752637674158904701471}
#define T_4096_783 {0.3613258055684542835450656639295630156994,-0.9324396292684623555047096488124225288630}
#define T_4096_785 {0.3584634206337365402994521446089493110776,-0.9335437729788361727045753468701150268316}
#define T_4096_787 {0.3555976617047839072327519716054666787386,-0.9346391298196807806419883490889333188534}
#define T_4096_789 {0.3527285557552107264633889371907571330667,-0.9357256894810803693474099418381229043007}
#define T_4096_791 {0.3498561297901349176342478131118696182966,-0.9368034417359215604292899115534964948893}
#define T_4096_793 {0.3469804108459236813288839584856759756804,-0.9378723764399898854549064708407968282700}
#define T_4096_795 {0.3441014259899388694208255401463247835636,-0.9389324835320644879743667843285948038101}
#define T_4096_797 {0.3412192023202824109340269842505222186446,-0.9399837530340139357676321196777280420065}
#define T_4096_799 {0.3383337669655411827918101153045427054167,-0.9410261750508892575339814356993883848190}
#define T_4096_801 {0.3354451470845316585212003701599314808846,-0.9420597397710173126483823580201715230942}
#define T_4096_803 {0.3325533698660442238903556244622450321913,-0.9430844374660934947840473796532023698092}
#define T_4096_805 {0.3296584625285874925459950190997915342450,-0.9441002584912726591781506613187957555056}
#define T_4096_807 {0.3267604523201317889835593177849659696221,-0.9451071932852606050090571443433873355389}
#define T_4096_809 {0.3238593665178529090731274209247203543782,-0.9461052323704034483498048757610376924276}
#define T_4096_811 {0.3209552324278752144515181043971097096801,-0.9470943663527772171661922584462445229292}
#define T_4096_813 {0.3180480773850149489589966833591461181641,-0.9480745859222762250695382135745603591204}
#define T_4096_815 {0.3151379287525223893418058196402853354812,-0.9490458818527005568910226429579779505730}
#define T_4096_817 {0.3122248139218249396442672605189727619290,-0.9500082450018429991445145788020454347134}
#define T_4096_819 {0.3093087603122687267998003335378598421812,-0.9509616663115750823109806333377491682768}
#define T_4096_821 {0.3063897953708609733780576789285987615585,-0.9519061368079323459667762108438182622194}
#define T_4096_823 {0.3034679465720113156201875881379237398505,-0.9528416476011987157335170195437967777252}
#define T_4096_825 {0.3005432414172734545410037299006944522262,-0.9537681898859903251164382709248457103968}
#define T_4096_827 {0.2976157074350861964084913324768422171474,-0.9546857549413383381420317164156585931778}
#define T_4096_829 {0.2946853721805143266898596721148351207376,-0.9555943341307711058618679089704528450966}
#define T_4096_831 {0.2917522632349892619529896364838350564241,-0.9564939189023951016110913769807666540146}
#define T_4096_833 {0.2888164082060494797232763630745466798544,-0.9573845007889758562669157981872558593750}
#define T_4096_835 {0.2858778347270806152735644900531042367220,-0.9582660714080176722617920859192963689566}
#define T_4096_837 {0.2829365704570553363694784820836503058672,-0.9591386224618418943066444626310840249062}
#define T_4096_839 {0.2799926430802732180147529561509145423770,-0.9600021457376658462479213085316587239504}
#define T_4096_841 {0.2770460803060998955515970010310411453247,-0.9608566331076796585008992224175017327070}
#define T_4096_843 {0.2740969098687063842945121905358973890543,-0.9617020765291225403714747699268627911806}
#define T_4096_845 {0.2711451595268080105860519779525930061936,-0.9625384680443591634002586943097412586212}
#define T_4096_847 {0.2681908570634031763191273967095185071230,-0.9633657997809540463052258019160944968462}
#define T_4096_849 {0.2652340302855117903924053734954213723540,-0.9641840639517458289020623851683922111988}
#define T_4096_851 {0.2622747070239136446545558101206552237272,-0.9649932528549203247791865578619763255119}
#define T_4096_853 {0.2593129151328862347369863528001587837934,-0.9657933588740836849950710529810748994350}
#define T_4096_855 {0.2563486824899429139534845489833969622850,-0.9665843744783331192849118451704271137714}
#define T_4096_857 {0.2533820369955701590214403040590696036816,-0.9673662922223285054457164733321405947208}
#define T_4096_859 {0.2504130065729652798722781881224364042282,-0.9681391047463624444091578880033921450377}
#define T_4096_861 {0.2474416191677732967946212738752365112305,-0.9689028047764288720244962860306259244680}
#define T_4096_863 {0.2444679027478241783999379777014837600291,-0.9696573851242924479976181828533299267292}
#define T_4096_865 {0.2414918853028693301876472787625971250236,-0.9704028386875555023394213094434235244989}
#define T_4096_867 {0.2385135948443184439327069412684068083763,-0.9711391584497250928365019717602990567684}
#define T_4096_869 {0.2355330594049755144059332678807550109923,-0.9718663374802793963880276351119391620159}
#define T_4096_871 {0.2325503070387752446723794719218858517706,-0.9725843689347322129634676457499153912067}
#define T_4096_873 {0.2295653658205188962782017370045650750399,-0.9732932460546982467164411900739651173353}
#define T_4096_875 {0.2265782638456100006596471985176322050393,-0.9739929621679558335856086159765254706144}
#define T_4096_877 {0.2235890292297899872853150782248121686280,-0.9746835106885106680962849168281536549330}
#define T_4096_879 {0.2205976901088735342426616625743918120861,-0.9753648851166569766490965776029042899609}
#define T_4096_881 {0.2176042746384836412687491247197613120079,-0.9760370790390390238755458085506688803434}
#define T_4096_883 {0.2146088109937867582921455777977826073766,-0.9767000861287118418374575412599369883537}
#define T_4096_885 {0.2116113273692275809079177406601957045496,-0.9773539001451999608249820994387846440077}
#define T_4096_887 {0.2086118519782634850301406004291493445635,-0.9779985149345571393553200323367491364479}
#define T_4096_889 {0.2056104130530992668557388469707802869380,-0.9786339244294232075915829227596987038851}
#define T_4096_891 {0.2026070388444211334277866853881278075278,-0.9792601226490820209846788202412426471710}
#define T_4096_893 {0.1996017576211309707545638048031833022833,-0.9798771036995176375583582739636767655611}
#define T_4096_895 {0.1965945976700802233505527283341507427394,-0.9804848617734693849712357405223883688450}
#define T_4096_897 {0.1935855872958036349995580849281395785511,-0.9810833911504867055342060666589532047510}
#define T_4096_899 {0.1905747548202527674732209561625495553017,-0.9816726861969831130494412718690000474453}
#define T_4096_901 {0.1875621285825296025162600699331960640848,-0.9822527413662893724932700934004969894886}
#define T_4096_903 {0.1845477369386196164757762971930787898600,-0.9828235511987052364091255185485351830721}
#define T_4096_905 {0.1815316082611249937084352268357179127634,-0.9833851103215511813004923169501125812531}
#define T_4096_907 {0.1785137709389975346763179686604416929185,-0.9839374134492189227785274852067232131958}
#define T_4096_909 {0.1754942533772714252648938781931065022945,-0.9844804553832209315089585288660600781441}
#define T_4096_911 {0.1724730839967959783454176658779033459723,-0.9850142310122398381366792818880639970303}
#define T_4096_913 {0.1694502912339679590036922718354617245495,-0.9855387353121760618535063258605077862740}
#define T_4096_915 {0.1664259035404641318134366656522615812719,-0.9860539633461954389659354092145804315805}
#define T_4096_917 {0.1633999493829732252425657179628615267575,-0.9865599102647754081729658537369687110186}
#define T_4096_919 {0.1603724572429282568819530752080027014017,-0.9870565713057509737993200360506307333708}
#define T_4096_921 {0.1573434556162382480515304905566154047847,-0.9875439417943592257387308563920669257641}
#define T_4096_923 {0.1543129730130201049398408486013067886233,-0.9880220171432835263303218198416288942099}
#define T_4096_925 {0.1512810379573302221878350337647134438157,-0.9884907928526965870119624923972878605127}
#define T_4096_927 {0.1482476789868960309615175674480269663036,-0.9889502645103029898621116444701328873634}
#define T_4096_929 {0.1452129246528474637578653982927789911628,-0.9894004277913803768740308441920205950737}
#define T_4096_931 {0.1421768035194480583882636892667505890131,-0.9898412784588205282076955882075708359480}
#define T_4096_933 {0.1391393441638262007398196828944492153823,-0.9902728123631691081740768822783138602972}
#define T_4096_935 {0.1361005751757062010032228727141045965254,-0.9906950254426646340633055842772591859102}
#define T_4096_937 {0.1330605251571390645892734028166159987450,-0.9911079137232768898613244346051942557096}
#define T_4096_939 {0.1300192227222333463121373142712400294840,-0.9915114733187438966766080739034805446863}
#define T_4096_941 {0.1269766964968858657947237134067108854651,-0.9919057004306093272560929108294658362865}
#define T_4096_943 {0.1239329751185121730738813994321390055120,-0.9922905913482573669881503519718535244465}
#define T_4096_945 {0.1208880872357770835945345311301934998482,-0.9926661424489480189947698818286880850792}
#define T_4096_947 {0.1178420615083249772814255607045197393745,-0.9930323501978514100230199801444541662931}
#define T_4096_949 {0.1147949266065100837330703598127001896501,-0.9933892111480806530465770265436731278896}
#define T_4096_951 {0.1117467112111266008822596518257341813296,-0.9937367219407245988449517426488455384970}
#define T_4096_953 {0.1086974440131387165120457893863203935325,-0.9940748793048793663373885465261992067099}
#define T_4096_955 {0.1056471537134106158939417241526825819165,-0.9944036800576790957606476695218589156866}
#define T_4096_957 {0.1025958690224362951370906671400007326156,-0.9947231211043257026460651104571297764778}
#define T_4096_959 {0.0995436186600693329040723256184719502926,-0.9950331994381186317966125898237805813551}
#define T_4096_961 {0.0964904313552525927377701009390875697136,-0.9953339121404822797956057911505922675133}
#define T_4096_963 {0.0934363358457477866103602082148427143693,-0.9956252563809943056938323024951387196779}
#define T_4096_965 {0.0903813608778649829611495647441188339144,-0.9959072294174117212506303076224867254496}
#define T_4096_967 {0.0873255352061920731010502549906959757209,-0.9961798285956969811749672771838959306479}
#define T_4096_969 {0.0842688875933240710836003017902839928865,-0.9964430513500426300765866471920162439346}
#define T_4096_971 {0.0812114468095924413315600531859672628343,-0.9966968952028960604394569600117392838001}
#define T_4096_973 {0.0781532416327942458522670676757115870714,-0.9969413577649821611714742175536230206490}
#define T_4096_975 {0.0750943008479213192085666150887846015394,-0.9971764367353261881987691594986245036125}
#define T_4096_977 {0.0720346532468893185896519071320653893054,-0.9974021299012753027923849913349840790033}
#define T_4096_979 {0.0689743276282667461263287123074405826628,-0.9976184351385195547834427998168393969536}
#define T_4096_981 {0.0659133527970038185506140848701761569828,-0.9978253504111116445329798807506449520588}
#define T_4096_983 {0.0628517575641614201220619406740297563374,-0.9980228737714862408125782167189754545689}
#define T_4096_985 {0.0597895707466398751428471314284252002835,-0.9982110033604781884619683296477887779474}
#define T_4096_987 {0.0567268211669077482284251345845405012369,-0.9983897374073401609351208207954186946154}
#define T_4096_989 {0.0536635376527305266169953767985134618357,-0.9985590742297593136456157481006812304258}
#define T_4096_991 {0.0505997490368992816622828456729621393606,-0.9987190122338729381112898408900946378708}
#define T_4096_993 {0.0475354841569593025707440858695917995647,-0.9988695499142835609873714020068291574717}
#define T_4096_995 {0.0444707718549386676887280600567464716733,-0.9990106858540733769658004348457325249910}
#define T_4096_997 {0.0414056409770767394618040668774483492598,-0.9991424187248169053177093701378908008337}
#define T_4096_999 {0.0383401203735526940885591784535790793598,-0.9992647472865944235920210303447674959898}
#define T_4096_1001 {0.0352742388982139540298810231888637645170,-0.9993776703880028478010899561922997236252}
#define T_4096_1003 {0.0322080254083045858237710490357130765915,-0.9994811869661669456732511207519564777613}
#define T_4096_1005 {0.0291415087641937256557334023909788811579,-0.9995752960467492176377390933339484035969}
#define T_4096_1007 {0.0260747178291039008457552483832841971889,-0.9996599967439592226980948908021673560143}
#define T_4096_1009 {0.0230076814688393721519688028820382896811,-0.9997352882605616830602457412169314920902}
#define T_4096_1011 {0.0199404285515144379103968930166956852190,-0.9998011698878842556936774599307682365179}
#define T_4096_1013 {0.0168729879472817138885698540207158657722,-0.9998576410058238606026748129806946963072}
#define T_4096_1015 {0.0138053885280603905877372383770307351369,-0.9999047010828528980752594179648440331221}
#define T_4096_1017 {0.0107376591672644922798030009403191797901,-0.9999423496760239116198931696999352425337}
#define T_4096_1019 {0.0076698287395310978803442125695255526807,-0.9999705864309741398798792033630888909101}
#define T_4096_1021 {0.0046019261204485704952471536444136290811,-0.9999894110819284032132259198988322168589}
#define T_4096_1023 {0.0015339801862847657169808268662336558918,-0.9999988234517018792502085489104501903057}
#define T_4096_1025 {-0.0015339801862847657169808268662336558918,-0.9999988234517018792502085489104501903057}
#define T_4096_1029 {-0.0076698287395310978803442125695255526807,-0.9999705864309741398798792033630888909101}
#define T_4096_1035 {-0.0168729879472817138885698540207158657722,-0.9998576410058238606026748129806946963072}
#define T_4096_1037 {-0.0199404285515144379103968930166956852190,-0.9998011698878842556936774599307682365179}
#define T_4096_1041 {-0.0260747178291039008457552483832841971889,-0.9996599967439592226980948908021673560143}
#define T_4096_1045 {-0.0322080254083045858237710490357130765915,-0.9994811869661669456732511207519564777613}
#define T_4096_1047 {-0.0352742388982139540298810231888637645170,-0.9993776703880028478010899561922997236252}
#define T_4096_1053 {-0.0444707718549386676887280600567464716733,-0.9990106858540733769658004348457325249910}
#define T_4096_1055 {-0.0475354841569593025707440858695917995647,-0.9988695499142835609873714020068291574717}
#define T_4096_1059 {-0.0536635376527305266169953767985134618357,-0.9985590742297593136456157481006812304258}
#define T_4096_1065 {-0.0628517575641614201220619406740297563374,-0.9980228737714862408125782167189754545689}
#define T_4096_1071 {-0.0720346532468893185896519071320653893054,-0.9974021299012753027923849913349840790033}
#define T_4096_1075 {-0.0781532416327942458522670676757115870714,-0.9969413577649821611714742175536230206490}
#define T_4096_1077 {-0.0812114468095924413315600531859672628343,-0.9966968952028960604394569600117392838001}
#define T_4096_1083 {-0.0903813608778649829611495647441188339144,-0.9959072294174117212506303076224867254496}
#define T_4096_1085 {-0.0934363358457477866103602082148427143693,-0.9956252563809943056938323024951387196779}
#define T_4096_1089 {-0.0995436186600693329040723256184719502926,-0.9950331994381186317966125898237805813551}
#define T_4096_1095 {-0.1086974440131387165120457893863203935325,-0.9940748793048793663373885465261992067099}
#define T_4096_1101 {-0.1178420615083249772814255607045197393745,-0.9930323501978514100230199801444541662931}
#define T_4096_1105 {-0.1239329751185121730738813994321390055120,-0.9922905913482573669881503519718535244465}
#define T_4096_1107 {-0.1269766964968858657947237134067108854651,-0.9919057004306093272560929108294658362865}
#define T_4096_1113 {-0.1361005751757062010032228727141045965254,-0.9906950254426646340633055842772591859102}
#define T_4096_1115 {-0.1391393441638262007398196828944492153823,-0.9902728123631691081740768822783138602972}
#define T_4096_1119 {-0.1452129246528474637578653982927789911628,-0.9894004277913803768740308441920205950737}
#define T_4096_1125 {-0.1543129730130201049398408486013067886233,-0.9880220171432835263303218198416288942099}
#define T_4096_1131 {-0.1633999493829732252425657179628615267575,-0.9865599102647754081729658537369687110186}
#define T_4096_1135 {-0.1694502912339679590036922718354617245495,-0.9855387353121760618535063258605077862740}
#define T_4096_1137 {-0.1724730839967959783454176658779033459723,-0.9850142310122398381366792818880639970303}
#define T_4096_1139 {-0.1754942533772714252648938781931065022945,-0.9844804553832209315089585288660600781441}
#define T_4096_1143 {-0.1815316082611249937084352268357179127634,-0.9833851103215511813004923169501125812531}
#define T_4096_1145 {-0.1845477369386196164757762971930787898600,-0.9828235511987052364091255185485351830721}
#define T_4096_1149 {-0.1905747548202527674732209561625495553017,-0.9816726861969831130494412718690000474453}
#define T_4096_1155 {-0.1996017576211309707545638048031833022833,-0.9798771036995176375583582739636767655611}
#define T_4096_1161 {-0.2086118519782634850301406004291493445635,-0.9779985149345571393553200323367491364479}
#define T_4096_1165 {-0.2146088109937867582921455777977826073766,-0.9767000861287118418374575412599369883537}
#define T_4096_1167 {-0.2176042746384836412687491247197613120079,-0.9760370790390390238755458085506688803434}
#define T_4096_1173 {-0.2265782638456100006596471985176322050393,-0.9739929621679558335856086159765254706144}
#define T_4096_1175 {-0.2295653658205188962782017370045650750399,-0.9732932460546982467164411900739651173353}
#define T_4096_1179 {-0.2355330594049755144059332678807550109923,-0.9718663374802793963880276351119391620159}
#define T_4096_1185 {-0.2444679027478241783999379777014837600291,-0.9696573851242924479976181828533299267292}
#define T_4096_1191 {-0.2533820369955701590214403040590696036816,-0.9673662922223285054457164733321405947208}
#define T_4096_1195 {-0.2593129151328862347369863528001587837934,-0.9657933588740836849950710529810748994350}
#define T_4096_1197 {-0.2622747070239136446545558101206552237272,-0.9649932528549203247791865578619763255119}
#define T_4096_1203 {-0.2711451595268080105860519779525930061936,-0.9625384680443591634002586943097412586212}
#define T_4096_1205 {-0.2740969098687063842945121905358973890543,-0.9617020765291225403714747699268627911806}
#define T_4096_1207 {-0.2770460803060998955515970010310411453247,-0.9608566331076796585008992224175017327070}
#define T_4096_1209 {-0.2799926430802732180147529561509145423770,-0.9600021457376658462479213085316587239504}
#define T_4096_1215 {-0.2888164082060494797232763630745466798544,-0.9573845007889758562669157981872558593750}
#define T_4096_1221 {-0.2976157074350861964084913324768422171474,-0.9546857549413383381420317164156585931778}
#define T_4096_1225 {-0.3034679465720113156201875881379237398505,-0.9528416476011987157335170195437967777252}
#define T_4096_1227 {-0.3063897953708609733780576789285987615585,-0.9519061368079323459667762108438182622194}
#define T_4096_1233 {-0.3151379287525223893418058196402853354812,-0.9490458818527005568910226429579779505730}
#define T_4096_1235 {-0.3180480773850149489589966833591461181641,-0.9480745859222762250695382135745603591204}
#define T_4096_1239 {-0.3238593665178529090731274209247203543782,-0.9461052323704034483498048757610376924276}
#define T_4096_1241 {-0.3267604523201317889835593177849659696221,-0.9451071932852606050090571443433873355389}
#define T_4096_1245 {-0.3325533698660442238903556244622450321913,-0.9430844374660934947840473796532023698092}
#define T_4096_1251 {-0.3412192023202824109340269842505222186446,-0.9399837530340139357676321196777280420065}
#define T_4096_1255 {-0.3469804108459236813288839584856759756804,-0.9378723764399898854549064708407968282700}
#define T_4096_1257 {-0.3498561297901349176342478131118696182966,-0.9368034417359215604292899115534964948893}
#define T_4096_1263 {-0.3584634206337365402994521446089493110776,-0.9335437729788361727045753468701150268316}
#define T_4096_1265 {-0.3613258055684542835450656639295630156994,-0.9324396292684623555047096488124225288630}
#define T_4096_1269 {-0.3670403457197671803768912468513008207083,-0.9302050228922190688862770002742763608694}
#define T_4096_1275 {-0.3755861784892172150485123438556911423802,-0.9267874743045817487185900063195731490850}
#define T_4096_1281 {-0.3841001950169350420694058811932336539030,-0.9232914167195276355926125688711181282997}
#define T_4096_1285 {-0.3897581740698564667368941627501044422388,-0.9209172415291894120414895041903946548700}
#define T_4096_1287 {-0.3925816740729514697783031351718818768859,-0.9197171462912273609546787156432401388884}
#define T_4096_1293 {-0.4010298971835756232096059648029040545225,-0.9160649657993317207527184109494555741549}
#define T_4096_1295 {-0.4038384575676541299316113509121350944042,-0.9148303122379461971291902955272234976292}
#define T_4096_1299 {-0.4094441486922575923479428183782147243619,-0.9123351846233227480098548767273314297199}
#define T_4096_1305 {-0.4178237158202123269212791001336881890893,-0.9085281187163061211720105347922071814537}
#define T_4096_1309 {-0.4233904741437960472794088673254009336233,-0.9059472978072684590244989522034302353859}
#define T_4096_1311 {-0.4261678887267996707066686212783679366112,-0.9046440905782462404971511205076240003109}
#define T_4096_1315 {-0.4317106580250572589463331496517639607191,-0.9020121439024931797590056703484151512384}
#define T_4096_1317 {-0.4344759605696557058784890159586211666465,-0.9006834292286468590660319932794664055109}
#define T_4096_1323 {-0.4427472275645700228174916901480173692107,-0.8966464701786801549943106692808214575052}
#define T_4096_1325 {-0.4454960165139817407364830614824313670397,-0.8952839210385574730821645061951130628586}
#define T_4096_1329 {-0.4509809890451038638659042590006720274687,-0.8925335554027645779129329639545176178217}
#define T_4096_1335 {-0.4591765475219441450249746594636235386133,-0.8883450333095963546981010949821211397648}
#define T_4096_1341 {-0.4673332087419884151024973562016384676099,-0.8840812587126349875177311332663521170616}
#define T_4096_1343 {-0.4700433324595956197100576900993473827839,-0.8826433399795627909867334892624057829380}
#define T_4096_1345 {-0.4727490319503427906866477314906660467386,-0.8811971134712219821949474862776696681976}
#define T_4096_1347 {-0.4754502817471558673290132901456672698259,-0.8797425928000474071311032275843899697065}
#define T_4096_1353 {-0.4835270789329187413052579813665943220258,-0.8753294031041108924640070654277224093676}
#define T_4096_1355 {-0.4862102761244864179701608009054325520992,-0.8738418434653668631639789055043365806341}
#define T_4096_1359 {-0.4915629161065499519445154419372556731105,-0.8708420634700788642845736831077374517918}
#define T_4096_1365 {-0.4995571125450818938951158543204655870795,-0.8662809540245129946711699631123337894678}
#define T_4096_1371 {-0.5075089910529708703279538895003497600555,-0.8616464611430812992054484311665873974562}
#define T_4096_1375 {-0.5127864006335630664423774760507512837648,-0.8585162242644427399440587578283157199621}
#define T_4096_1377 {-0.5154178780194630382638365517777856439352,-0.8569389774178287622063976414210628718138}
#define T_4096_1383 {-0.5232831034756564303478398869629018008709,-0.8521589016239198288715783746738452464342}
#define T_4096_1385 {-0.5258950274710846306547296080680098384619,-0.8505494812656034797626602994569111615419}
#define T_4096_1389 {-0.5311040011512550007566346721432637423277,-0.8473066386858584264629712379246484488249}
#define T_4096_1395 {-0.5388799085310084224786919548932928591967,-0.8423825996431858476043430528079625219107}
#define T_4096_1401 {-0.5466101669108348604098068790335673838854,-0.8373872016156619357829526961722876876593}
#define T_4096_1405 {-0.5517379884047074467545712650462519377470,-0.8340175011060181331501439672138076275587}
#define T_4096_1407 {-0.5542941214536201144369442772585898637772,-0.8323208677679296840778988553211092948914}
#define T_4096_1411 {-0.5593907118591360250192678904568310827017,-0.8289041147718648749886938276176806539297}
#define T_4096_1413 {-0.5619311212446894687744247676164377480745,-0.8271840272736691312971402112452778965235}
#define T_4096_1415 {-0.5644662415205194960776680090930312871933,-0.8254561540043775513808554933348204940557}
#define T_4096_1419 {-0.5695205193469471405265380781202111393213,-0.8219771152792415547239102124876808375120}
#define T_4096_1425 {-0.5770616728556795527182998739590402692556,-0.8167005728668278452531126276880968362093}
#define T_4096_1431 {-0.5845539429530153263669944863067939877510,-0.8113548470170637294529569771839305758476}
#define T_4096_1435 {-0.5895213186410639405465872187050990760326,-0.8077528179261903584773563125054351985455}
#define T_4096_1437 {-0.5919966949620409923937813800876028835773,-0.8059403905711762794439323442929890006781}
#define T_4096_1443 {-0.5993892984005645407918905220867600291967,-0.8004576621926228208181441914348397403955}
#define T_4096_1445 {-0.6018422470585800265752141058328561484814,-0.7986149946347608219454627942468505352736}
#define T_4096_1449 {-0.6067311270345244755830549365782644599676,-0.7949071263282370125580200692638754844666}
#define T_4096_1455 {-0.6140215589310383803578474726236891001463,-0.7892892531688856516680630193150136619806}
#define T_4096_1461 {-0.6212599765110876637308479075727518647909,-0.7836045186096382009210969954438041895628}
#define T_4096_1465 {-0.6260563884043435223247797694057226181030,-0.7797777879230144426614401709230151027441}
#define T_4096_1467 {-0.6284457666018327115509123359515797346830,-0.7778534042094530365218929546244908124208}
#define T_4096_1473 {-0.6355783204885561143981931309099309146404,-0.7720363971503845235133667301852256059647}
#define T_4096_1475 {-0.6379439036218440550740638173010665923357,-0.7700828369933480077591525514435488730669}
#define T_4096_1479 {-0.6426570339662268649405518772255163639784,-0.7661539901963129173267930127622094005346}
#define T_4096_1485 {-0.6496813073906831936810135630366858094931,-0.7602066816512024205465536397241521626711}
#define T_4096_1491 {-0.6566505457294290470926512170990463346243,-0.7541949753168891712462595933175180107355}
#define T_4096_1495 {-0.6612658378399922654011788836214691400528,-0.7501516458062150727315042786358390003443}
#define T_4096_1497 {-0.6635641586120397672488024909398518502712,-0.7481193804504036037883452081587165594101}
#define T_4096_1503 {-0.6704215603801730871680319978622719645500,-0.7419804117208310678677207761211320757866}
#define T_4096_1505 {-0.6726947690707729687886740066460333764553,-0.7399200954595162027516153102624230086803}
#define T_4096_1509 {-0.6772221701371804458702285955951083451509,-0.7357785891657134813570451115083415061235}
#define T_4096_1513 {-0.6817240741716498186875128340034279972315,-0.7316093812238925186974825010111089795828}
#define T_4096_1515 {-0.6839654117973154034970661996339913457632,-0.7295144381469970129572288897179532796144}
#define T_4096_1521 {-0.6906507141345346045824271641322411596775,-0.7231884893065274599877056971308775246143}
#define T_4096_1525 {-0.6950751139800008804314757071551866829395,-0.7189371223728044935086245459388010203838}
#define T_4096_1527 {-0.6972775108308865155137823421682696789503,-0.7168012785210995385654086931026540696621}
#define T_4096_1533 {-0.7038452405244849385823613374668639153242,-0.7103533468570623066185021343699190765619}
#define T_4096_1535 {-0.7060212614493397431658650020835921168327,-0.7081906370331952915719853081100154668093}
#define T_4096_1539 {-0.7103533468570623066185021343699190765619,-0.7038452405244849385823613374668639153242}
#define T_4096_1545 {-0.7168012785210995385654086931026540696621,-0.6972775108308865155137823421682696789503}
#define T_4096_1547 {-0.7189371223728044935086245459388010203838,-0.6950751139800008804314757071551866829395}
#define T_4096_1551 {-0.7231884893065274599877056971308775246143,-0.6906507141345346045824271641322411596775}
#define T_4096_1555 {-0.7274126286023757659293664801225531846285,-0.6862003116800385882356749789323657751083}
#define T_4096_1557 {-0.7295144381469970129572288897179532796144,-0.6839654117973154034970661996339913457632}
#define T_4096_1563 {-0.7357785891657134813570451115083415061235,-0.6772221701371804458702285955951083451509}
#define T_4096_1565 {-0.7378528147884659826871711629792116582394,-0.6749616461020120361524732288671657443047}
#define T_4096_1569 {-0.7419804117208310678677207761211320757866,-0.6704215603801730871680319978622719645500}
#define T_4096_1575 {-0.7481193804504036037883452081587165594101,-0.6635641586120397672488024909398518502712}
#define T_4096_1581 {-0.7541949753168891712462595933175180107355,-0.6566505457294290470926512170990463346243}
#define T_4096_1585 {-0.7582099098130152814434268293553031980991,-0.6520105310969595002745791134657338261604}
#define T_4096_1587 {-0.7602066816512024205465536397241521626711,-0.6496813073906831936810135630366858094931}
#define T_4096_1593 {-0.7661539901963129173267930127622094005346,-0.6426570339662268649405518772255163639784}
#define T_4096_1595 {-0.7681220285233654188061791501240804791451,-0.6403034821841516732732202399347443133593}
#define T_4096_1599 {-0.7720363971503845235133667301852256059647,-0.6355783204885561143981931309099309146404}
#define T_4096_1605 {-0.7778534042094530365218929546244908124208,-0.6284457666018327115509123359515797346830}
#define T_4096_1611 {-0.7836045186096382009210969954438041895628,-0.6212599765110876637308479075727518647909}
#define T_4096_1615 {-0.7874017470290314291148092706862371414900,-0.6164401745308536462175652559380978345871}
#define T_4096_1617 {-0.7892892531688856516680630193150136619806,-0.6140215589310383803578474726236891001463}
#define T_4096_1623 {-0.7949071263282370125580200692638754844666,-0.6067311270345244755830549365782644599676}
#define T_4096_1625 {-0.7967648102084187167193363166006747633219,-0.6042895309481560728315230335283558815718}
#define T_4096_1629 {-0.8004576621926228208181441914348397403955,-0.5993892984005645407918905220867600291967}
#define T_4096_1635 {-0.8059403905711762794439323442929890006781,-0.5919966949620409923937813800876028835773}
#define T_4096_1641 {-0.8113548470170637294529569771839305758476,-0.5845539429530153263669944863067939877510}
#define T_4096_1645 {-0.8149263290565266215637052482634317129850,-0.5795645591394057438705544882395770400763}
#define T_4096_1647 {-0.8167005728668278452531126276880968362093,-0.5770616728556795527182998739590402692556}
#define T_4096_1649 {-0.8184671295802986579204230110917706042528,-0.5745533550477157636038327837013639509678}
#define T_4096_1653 {-0.8219771152792415547239102124876808375120,-0.5695205193469471405265380781202111393213}
#define T_4096_1655 {-0.8237205112273914275888841984851751476526,-0.5669960488251086783151322379126213490963}
#define T_4096_1659 {-0.8271840272736691312971402112452778965235,-0.5619311212446894687744247676164377480745}
#define T_4096_1665 {-0.8323208677679296840778988553211092948914,-0.5542941214536201144369442772585898637772}
#define T_4096_1671 {-0.8373872016156619357829526961722876876593,-0.5466101669108348604098068790335673838854}
#define T_4096_1675 {-0.8407253749704580725321534373506437987089,-0.5414617658531234445362656515499111264944}
#define T_4096_1677 {-0.8423825996431858476043430528079625219107,-0.5388799085310084224786919548932928591967}
#define T_4096_1683 {-0.8473066386858584264629712379246484488249,-0.5311040011512550007566346721432637423277}
#define T_4096_1685 {-0.8489320552116396134678666385298129171133,-0.5285020015422284833661592529097106307745}
#define T_4096_1689 {-0.8521589016239198288715783746738452464342,-0.5232831034756564303478398869629018008709}
#define T_4096_1695 {-0.8569389774178287622063976414210628718138,-0.5154178780194630382638365517777856439352}
#define T_4096_1701 {-0.8616464611430812992054484311665873974562,-0.5075089910529708703279538895003497600555}
#define T_4096_1705 {-0.8647442575194623781698055609012953937054,-0.5022124740457107883173648588126525282860}
#define T_4096_1707 {-0.8662809540245129946711699631123337894678,-0.4995571125450818938951158543204655870795}
#define T_4096_1713 {-0.8708420634700788642845736831077374517918,-0.4915629161065499519445154419372556731105}
#define T_4096_1715 {-0.8723460588943915405835127785394433885813,-0.4888888969197631717555907471250975504518}
#define T_4096_1717 {-0.8738418434653668631639789055043365806341,-0.4862102761244864179701608009054325520992}
#define T_4096_1719 {-0.8753294031041108924640070654277224093676,-0.4835270789329187413052579813665943220258}
#define T_4096_1725 {-0.8797425928000474071311032275843899697065,-0.4754502817471558673290132901456672698259}
#define T_4096_1731 {-0.8840812587126349875177311332663521170616,-0.4673332087419884151024973562016384676099}
#define T_4096_1735 {-0.8869321187943421946897615271154791116714,-0.4618997907024627314065412519994424656034}
#define T_4096_1737 {-0.8883450333095963546981010949821211397648,-0.4591765475219441450249746594636235386133}
#define T_4096_1743 {-0.8925335554027645779129329639545176178217,-0.4509809890451038638659042590006720274687}
#define T_4096_1745 {-0.8939129451452032526503899134695529937744,-0.4482406122852199414907659047457855194807}
#define T_4096_1749 {-0.8966464701786801549943106692808214575052,-0.4427472275645700228174916901480173692107}
#define T_4096_1751 {-0.8980005797407398793197330633120145648718,-0.4399942713096332558286860603402601554990}
#define T_4096_1755 {-0.9006834292286468590660319932794664055109,-0.4344759605696557058784890159586211666465}
#define T_4096_1761 {-0.9046440905782462404971511205076240003109,-0.4261678887267996707066686212783679366112}
#define T_4096_1765 {-0.9072419779152958163592757045989856123924,-0.4206090744484025090166312565997941419482}
#define T_4096_1767 {-0.9085281187163061211720105347922071814537,-0.4178237158202123269212791001336881890893}
#define T_4096_1773 {-0.9123351846233227480098548767273314297199,-0.4094441486922575923479428183782147243619}
#define T_4096_1775 {-0.9135870479452508075013383859186433255672,-0.4066432168703690286370999729115283116698}
#define T_4096_1779 {-0.9160649657993317207527184109494555741549,-0.4010298971835756232096059648029040545225}
#define T_4096_1785 {-0.9197171462912273609546787156432401388884,-0.3925816740729514697783031351718818768859}
#define T_4096_1791 {-0.9232914167195276355926125688711181282997,-0.3841001950169350420694058811932336539030}
#define T_4096_1795 {-0.9256308305098727151616344599460717290640,-0.3784277548087655596020795201184228062630}
#define T_4096_1797 {-0.9267874743045817487185900063195731490850,-0.3755861784892172150485123438556911423802}
#define T_4096_1803 {-0.9302050228922190688862770002742763608694,-0.3670403457197671803768912468513008207083}
#define T_4096_1805 {-0.9313267090811804260752637674158904701471,-0.3641847895670798918033028712670784443617}
#define T_4096_1809 {-0.9335437729788361727045753468701150268316,-0.3584634206337365402994521446089493110776}
#define T_4096_1815 {-0.9368034417359215604292899115534964948893,-0.3498561297901349176342478131118696182966}
#define T_4096_1819 {-0.9389324835320644879743667843285948038101,-0.3441014259899388694208255401463247835636}
#define T_4096_1821 {-0.9399837530340139357676321196777280420065,-0.3412192023202824109340269842505222186446}
#define T_4096_1825 {-0.9420597397710173126483823580201715230942,-0.3354451470845316585212003701599314808846}
#define T_4096_1827 {-0.9430844374660934947840473796532023698092,-0.3325533698660442238903556244622450321913}
#define T_4096_1833 {-0.9461052323704034483498048757610376924276,-0.3238593665178529090731274209247203543782}
#define T_4096_1835 {-0.9470943663527772171661922584462445229292,-0.3209552324278752144515181043971097096801}
#define T_4096_1839 {-0.9490458818527005568910226429579779505730,-0.3151379287525223893418058196402853354812}
#define T_4096_1845 {-0.9519061368079323459667762108438182622194,-0.3063897953708609733780576789285987615585}
#define T_4096_1851 {-0.9546857549413383381420317164156585931778,-0.2976157074350861964084913324768422171474}
#define T_4096_1853 {-0.9555943341307711058618679089704528450966,-0.2946853721805143266898596721148351207376}
#define T_4096_1855 {-0.9564939189023951016110913769807666540146,-0.2917522632349892619529896364838350564241}
#define T_4096_1857 {-0.9573845007889758562669157981872558593750,-0.2888164082060494797232763630745466798544}
#define T_4096_1863 {-0.9600021457376658462479213085316587239504,-0.2799926430802732180147529561509145423770}
#define T_4096_1865 {-0.9608566331076796585008992224175017327070,-0.2770460803060998955515970010310411453247}
#define T_4096_1869 {-0.9625384680443591634002586943097412586212,-0.2711451595268080105860519779525930061936}
#define T_4096_1875 {-0.9649932528549203247791865578619763255119,-0.2622747070239136446545558101206552237272}
#define T_4096_1881 {-0.9673662922223285054457164733321405947208,-0.2533820369955701590214403040590696036816}
#define T_4096_1885 {-0.9689028047764288720244962860306259244680,-0.2474416191677732967946212738752365112305}
#define T_4096_1887 {-0.9696573851242924479976181828533299267292,-0.2444679027478241783999379777014837600291}
#define T_4096_1893 {-0.9718663374802793963880276351119391620159,-0.2355330594049755144059332678807550109923}
#define T_4096_1895 {-0.9725843689347322129634676457499153912067,-0.2325503070387752446723794719218858517706}
#define T_4096_1899 {-0.9739929621679558335856086159765254706144,-0.2265782638456100006596471985176322050393}
#define T_4096_1905 {-0.9760370790390390238755458085506688803434,-0.2176042746384836412687491247197613120079}
#define T_4096_1911 {-0.9779985149345571393553200323367491364479,-0.2086118519782634850301406004291493445635}
#define T_4096_1915 {-0.9792601226490820209846788202412426471710,-0.2026070388444211334277866853881278075278}
#define T_4096_1917 {-0.9798771036995176375583582739636767655611,-0.1996017576211309707545638048031833022833}
#define T_4096_1921 {-0.9810833911504867055342060666589532047510,-0.1935855872958036349995580849281395785511}
#define T_4096_1923 {-0.9816726861969831130494412718690000474453,-0.1905747548202527674732209561625495553017}
#define T_4096_1925 {-0.9822527413662893724932700934004969894886,-0.1875621285825296025162600699331960640848}
#define T_4096_1929 {-0.9833851103215511813004923169501125812531,-0.1815316082611249937084352268357179127634}
#define T_4096_1935 {-0.9850142310122398381366792818880639970303,-0.1724730839967959783454176658779033459723}
#define T_4096_1941 {-0.9865599102647754081729658537369687110186,-0.1633999493829732252425657179628615267575}
#define T_4096_1945 {-0.9875439417943592257387308563920669257641,-0.1573434556162382480515304905566154047847}
#define T_4096_1947 {-0.9880220171432835263303218198416288942099,-0.1543129730130201049398408486013067886233}
#define T_4096_1953 {-0.9894004277913803768740308441920205950737,-0.1452129246528474637578653982927789911628}
#define T_4096_1955 {-0.9898412784588205282076955882075708359480,-0.1421768035194480583882636892667505890131}
#define T_4096_1959 {-0.9906950254426646340633055842772591859102,-0.1361005751757062010032228727141045965254}
#define T_4096_1965 {-0.9919057004306093272560929108294658362865,-0.1269766964968858657947237134067108854651}
#define T_4096_1971 {-0.9930323501978514100230199801444541662931,-0.1178420615083249772814255607045197393745}
#define T_4096_1975 {-0.9937367219407245988449517426488455384970,-0.1117467112111266008822596518257341813296}
#define T_4096_1977 {-0.9940748793048793663373885465261992067099,-0.1086974440131387165120457893863203935325}
#define T_4096_1983 {-0.9950331994381186317966125898237805813551,-0.0995436186600693329040723256184719502926}
#define T_4096_1985 {-0.9953339121404822797956057911505922675133,-0.0964904313552525927377701009390875697136}
#define T_4096_1989 {-0.9959072294174117212506303076224867254496,-0.0903813608778649829611495647441188339144}
#define T_4096_1995 {-0.9966968952028960604394569600117392838001,-0.0812114468095924413315600531859672628343}
#define T_4096_2001 {-0.9974021299012753027923849913349840790033,-0.0720346532468893185896519071320653893054}
#define T_4096_2005 {-0.9978253504111116445329798807506449520588,-0.0659133527970038185506140848701761569828}
#define T_4096_2007 {-0.9980228737714862408125782167189754545689,-0.0628517575641614201220619406740297563374}
#define T_4096_2013 {-0.9985590742297593136456157481006812304258,-0.0536635376527305266169953767985134618357}
#define T_4096_2015 {-0.9987190122338729381112898408900946378708,-0.0505997490368992816622828456729621393606}
#define T_4096_2019 {-0.9990106858540733769658004348457325249910,-0.0444707718549386676887280600567464716733}
#define T_4096_2023 {-0.9992647472865944235920210303447674959898,-0.0383401203735526940885591784535790793598}
#define T_4096_2025 {-0.9993776703880028478010899561922997236252,-0.0352742388982139540298810231888637645170}
#define T_4096_2031 {-0.9996599967439592226980948908021673560143,-0.0260747178291039008457552483832841971889}
#define T_4096_2035 {-0.9998011698878842556936774599307682365179,-0.0199404285515144379103968930166956852190}
#define T_4096_2037 {-0.9998576410058238606026748129806946963072,-0.0168729879472817138885698540207158657722}
#define T_4096_2043 {-0.9999705864309741398798792033630888909101,-0.0076698287395310978803442125695255526807}
#define T_4096_2045 {-0.9999894110819284032132259198988322168589,-0.0046019261204485704952471536444136290811}
#define T_4096_2049 {-0.9999988234517018792502085489104501903057,0.0015339801862847657169808268662336558918}
#define T_4096_2055 {-0.9999423496760239116198931696999352425337,0.0107376591672644922798030009403191797901}
#define T_4096_2057 {-0.9999047010828528980752594179648440331221,0.0138053885280603905877372383770307351369}
#define T_4096_2061 {-0.9998011698878842556936774599307682365179,0.0199404285515144379103968930166956852190}
#define T_4096_2065 {-0.9996599967439592226980948908021673560143,0.0260747178291039008457552483832841971889}
#define T_4096_2067 {-0.9995752960467492176377390933339484035969,0.0291415087641937256557334023909788811579}
#define T_4096_2073 {-0.9992647472865944235920210303447674959898,0.0383401203735526940885591784535790793598}
#define T_4096_2075 {-0.9991424187248169053177093701378908008337,0.0414056409770767394618040668774483492598}
#define T_4096_2079 {-0.9988695499142835609873714020068291574717,0.0475354841569593025707440858695917995647}
#define T_4096_2085 {-0.9983897374073401609351208207954186946154,0.0567268211669077482284251345845405012369}
#define T_4096_2091 {-0.9978253504111116445329798807506449520588,0.0659133527970038185506140848701761569828}
#define T_4096_2095 {-0.9974021299012753027923849913349840790033,0.0720346532468893185896519071320653893054}
#define T_4096_2097 {-0.9971764367353261881987691594986245036125,0.0750943008479213192085666150887846015394}
#define T_4096_2103 {-0.9964430513500426300765866471920162439346,0.0842688875933240710836003017902839928865}
#define T_4096_2105 {-0.9961798285956969811749672771838959306479,0.0873255352061920731010502549906959757209}
#define T_4096_2109 {-0.9956252563809943056938323024951387196779,0.0934363358457477866103602082148427143693}
#define T_4096_2115 {-0.9947231211043257026460651104571297764778,0.1025958690224362951370906671400007326156}
#define T_4096_2121 {-0.9937367219407245988449517426488455384970,0.1117467112111266008822596518257341813296}
#define T_4096_2125 {-0.9930323501978514100230199801444541662931,0.1178420615083249772814255607045197393745}
#define T_4096_2127 {-0.9926661424489480189947698818286880850792,0.1208880872357770835945345311301934998482}
#define T_4096_2133 {-0.9915114733187438966766080739034805446863,0.1300192227222333463121373142712400294840}
#define T_4096_2135 {-0.9911079137232768898613244346051942557096,0.1330605251571390645892734028166159987450}
#define T_4096_2139 {-0.9902728123631691081740768822783138602972,0.1391393441638262007398196828944492153823}
#define T_4096_2145 {-0.9889502645103029898621116444701328873634,0.1482476789868960309615175674480269663036}
#define T_4096_2151 {-0.9875439417943592257387308563920669257641,0.1573434556162382480515304905566154047847}
#define T_4096_2155 {-0.9865599102647754081729658537369687110186,0.1633999493829732252425657179628615267575}
#define T_4096_2157 {-0.9860539633461954389659354092145804315805,0.1664259035404641318134366656522615812719}
#define T_4096_2159 {-0.9855387353121760618535063258605077862740,0.1694502912339679590036922718354617245495}
#define T_4096_2163 {-0.9844804553832209315089585288660600781441,0.1754942533772714252648938781931065022945}
#define T_4096_2165 {-0.9839374134492189227785274852067232131958,0.1785137709389975346763179686604416929185}
#define T_4096_2169 {-0.9828235511987052364091255185485351830721,0.1845477369386196164757762971930787898600}
#define T_4096_2175 {-0.9810833911504867055342060666589532047510,0.1935855872958036349995580849281395785511}
#define T_4096_2181 {-0.9792601226490820209846788202412426471710,0.2026070388444211334277866853881278075278}
#define T_4096_2185 {-0.9779985149345571393553200323367491364479,0.2086118519782634850301406004291493445635}
#define T_4096_2187 {-0.9773539001451999608249820994387846440077,0.2116113273692275809079177406601957045496}
#define T_4096_2193 {-0.9753648851166569766490965776029042899609,0.2205976901088735342426616625743918120861}
#define T_4096_2195 {-0.9746835106885106680962849168281536549330,0.2235890292297899872853150782248121686280}
#define T_4096_2199 {-0.9732932460546982467164411900739651173353,0.2295653658205188962782017370045650750399}
#define T_4096_2205 {-0.9711391584497250928365019717602990567684,0.2385135948443184439327069412684068083763}
#define T_4096_2211 {-0.9689028047764288720244962860306259244680,0.2474416191677732967946212738752365112305}
#define T_4096_2215 {-0.9673662922223285054457164733321405947208,0.2533820369955701590214403040590696036816}
#define T_4096_2217 {-0.9665843744783331192849118451704271137714,0.2563486824899429139534845489833969622850}
#define T_4096_2223 {-0.9641840639517458289020623851683922111988,0.2652340302855117903924053734954213723540}
#define T_4096_2225 {-0.9633657997809540463052258019160944968462,0.2681908570634031763191273967095185071230}
#define T_4096_2229 {-0.9617020765291225403714747699268627911806,0.2740969098687063842945121905358973890543}
#define T_4096_2235 {-0.9591386224618418943066444626310840249062,0.2829365704570553363694784820836503058672}
#define T_4096_2241 {-0.9564939189023951016110913769807666540146,0.2917522632349892619529896364838350564241}
#define T_4096_2245 {-0.9546857549413383381420317164156585931778,0.2976157074350861964084913324768422171474}
#define T_4096_2247 {-0.9537681898859903251164382709248457103968,0.3005432414172734545410037299006944522262}
#define T_4096_2253 {-0.9509616663115750823109806333377491682768,0.3093087603122687267998003335378598421812}
#define T_4096_2255 {-0.9500082450018429991445145788020454347134,0.3122248139218249396442672605189727619290}
#define T_4096_2259 {-0.9480745859222762250695382135745603591204,0.3180480773850149489589966833591461181641}
#define T_4096_2265 {-0.9451071932852606050090571443433873355389,0.3267604523201317889835593177849659696221}
#define T_4096_2271 {-0.9420597397710173126483823580201715230942,0.3354451470845316585212003701599314808846}
#define T_4096_2275 {-0.9399837530340139357676321196777280420065,0.3412192023202824109340269842505222186446}
#define T_4096_2277 {-0.9389324835320644879743667843285948038101,0.3441014259899388694208255401463247835636}
#define T_4096_2283 {-0.9357256894810803693474099418381229043007,0.3527285557552107264633889371907571330667}
#define T_4096_2285 {-0.9346391298196807806419883490889333188534,0.3555976617047839072327519716054666787386}
#define T_4096_2289 {-0.9324396292684623555047096488124225288630,0.3613258055684542835450656639295630156994}
#define T_4096_2295 {-0.9290745812593157459957637911429628729820,0.3698924471489341003760387138754595071077}
#define T_4096_2301 {-0.9256308305098727151616344599460717290640,0.3784277548087655596020795201184228062630}
#define T_4096_2305 {-0.9232914167195276355926125688711181282997,0.3841001950169350420694058811932336539030}
#define T_4096_2307 {-0.9221086687433450723716532593243755400181,0.3869310055143885818118576480628689751029}
#define T_4096_2313 {-0.9185083943252122518074997969961259514093,0.3954014789478163538483102001919178292155}
#define T_4096_2315 {-0.9172909970083779063187989777361508458853,0.3982175621533736165069683465844718739390}
#define T_4096_2319 {-0.9148303122379461971291902955272234976292,0.4038384575676541299316113509121350944042}
#define T_4096_2325 {-0.9110747340551763606697477371199056506157,0.4122412266698828875455262732430128380656}
#define T_4096_2331 {-0.9072419779152958163592757045989856123924,0.4206090744484025090166312565997941419482}
#define T_4096_2335 {-0.9046440905782462404971511205076240003109,0.4261678887267996707066686212783679366112}
#define T_4096_2337 {-0.9033323684945118170475097940652631223202,0.4289412920553294927827892024652101099491}
#define T_4096_2343 {-0.8993462369793415733809638368256855756044,0.4372371736610440873249672222300432622433}
#define T_4096_2345 {-0.8980005797407398793197330633120145648718,0.4399942713096332558286860603402601554990}
#define T_4096_2349 {-0.8952839210385574730821645061951130628586,0.4454960165139817407364830614824313670397}
#define T_4096_2355 {-0.8911457647945831839209063218731898814440,0.4537171210001638699260695375414798036218}
#define T_4096_2361 {-0.8869321187943421946897615271154791116714,0.4618997907024627314065412519994424656034}
#define T_4096_2365 {-0.8840812587126349875177311332663521170616,0.4673332087419884151024973562016384676099}
#define T_4096_2367 {-0.8826433399795627909867334892624057829380,0.4700433324595956197100576900993473827839}
#define T_4096_2373 {-0.8782797916565414642064979489077813923359,0.4781470564248430643594645061966730281711}
#define T_4096_2375 {-0.8768087238091456514510468878143001347780,0.4808393306003339584542288775992346927524}
#define T_4096_2379 {-0.8738418434653668631639789055043365806341,0.4862102761244864179701608009054325520992}
#define T_4096_2385 {-0.8693298713486067308409133147506508976221,0.4942323085159597284565791142085799947381}
#define T_4096_2391 {-0.8647442575194623781698055609012953937054,0.5022124740457107883173648588126525282860}
#define T_4096_2395 {-0.8616464611430812992054484311665873974562,0.5075089910529708703279538895003497600555}
#define T_4096_2397 {-0.8600853904293901397437593914219178259373,0.5101500967067668090848542306048329919577}
#define T_4096_2403 {-0.8553536647351960287011252148658968508244,0.5180445040959993363571811642032116651535}
#define T_4096_2405 {-0.8537603011381114104239031803444959223270,0.5206662541403671573547740081266965717077}
#define T_4096_2409 {-0.8505494812656034797626602994569111615419,0.5258950274710846306547296080680098384619}
#define T_4096_2415 {-0.8456732469872990654025102230662014335394,0.5337010018071529637850858307501766830683}
#define T_4096_2421 {-0.8407253749704580725321534373506437987089,0.5414617658531234445362656515499111264944}
#define T_4096_2425 {-0.8373872016156619357829526961722876876593,0.5466101669108348604098068790335673838854}
#define T_4096_2427 {-0.8357062843537526042325680464273318648338,0.5491766621877197662726644011854659765959}
#define T_4096_2433 {-0.8306164003088463143598119131638668477535,0.5568450372751601040732793990173377096653}
#define T_4096_2435 {-0.8289041147718648749886938276176806539297,0.5593907118591360250192678904568310827017}
#define T_4096_2439 {-0.8254561540043775513808554933348204940557,0.5644662415205194960776680090930312871933}
#define T_4096_2445 {-0.8202259825694346861979511231766082346439,0.5720396293247570485007713614322710782290}
#define T_4096_2451 {-0.8149263290565266215637052482634317129850,0.5795645591394057438705544882395770400763}
#define T_4096_2455 {-0.8113548470170637294529569771839305758476,0.5845539429530153263669944863067939877510}
#define T_4096_2457 {-0.8095576424040512586444151565956417471170,0.5870403935209179691057101990736555308104}
#define T_4096_2463 {-0.8041203773982656954899539414327591657639,0.5944664991846644319650749821448698639870}
#define T_4096_2465 {-0.8022927955381157216763199357956182211637,0.5969307080621965022615427187702152878046}
#define T_4096_2469 {-0.7986149946347608219454627942468505352736,0.6018422470585800265752141058328561484814}
#define T_4096_2475 {-0.7930419604794436416739245032658800482750,0.6091670123364532063447995824390091001987}
#define T_4096_2481 {-0.7874017470290314291148092706862371414900,0.6164401745308536462175652559380978345871}
#define T_4096_2485 {-0.7836045186096382009210969954438041895628,0.6212599765110876637308479075727518647909}
#define T_4096_2487 {-0.7816948320710593867133297862892504781485,0.6236611175256945305278577507124282419682}
#define T_4096_2493 {-0.7759216990434075755800336082756984978914,0.6308292296284245814774749305797740817070}
#define T_4096_2495 {-0.7739826906068227874158083068323321640491,0.6332067550500573016591943087405525147915}
#define T_4096_2499 {-0.7700828369933480077591525514435488730669,0.6379439036218440550740638173010665923357}
#define T_4096_2505 {-0.7641787405361166740647149708820506930351,0.6450045368155439273749607309582643210888}
#define T_4096_2511 {-0.7582099098130152814434268293553031980991,0.6520105310969595002745791134657338261604}
#define T_4096_2515 {-0.7541949753168891712462595933175180107355,0.6566505457294290470926512170990463346243}
#define T_4096_2517 {-0.7521768504490426998643215483753010630608,0.6589612929820373166123204100586008280516}
#define T_4096_2523 {-0.7460800735100637792740485565445851534605,0.6658562336655097224635824204597156494856}
#define T_4096_2525 {-0.7440337441799292905741936010599602013826,0.6681420414265185625524168244737666100264}
#define T_4096_2529 {-0.7399200954595162027516153102624230086803,0.6726947690707729687886740066460333764553}
#define T_4096_2535 {-0.7336974381146602608438911374832969158888,0.6794763198993650776813524316821713000536}
#define T_4096_2541 {-0.7274126286023757659293664801225531846285,0.6862003116800385882356749789323657751083}
#define T_4096_2545 {-0.7231884893065274599877056971308775246143,0.6906507141345346045824271641322411596775}
#define T_4096_2547 {-0.7210661993145081050116118603909853845835,0.6928661748174246293174860511498991400003}
#define T_4096_2553 {-0.7146586878627690930798621593567077070475,0.6994733446402837673261387863021809607744}
#define T_4096_2555 {-0.7125093705646923236685097435838542878628,0.7016625947401684548765388171887025237083}
#define T_4096_2559 {-0.7081906370331952915719853081100154668093,0.7060212614493397431658650020835921168327}
#define T_4096_2565 {-0.7016625947401684548765388171887025237083,0.7125093705646923236685097435838542878628}
#define T_4096_2571 {-0.6950751139800008804314757071551866829395,0.7189371223728044935086245459388010203838}
#define T_4096_2577 {-0.6884287527840904363785057284985668957233,0.7253039723730607679641479990095831453800}
#define T_4096_2583 {-0.6817240741716498186875128340034279972315,0.7316093812238925186974825010111089795828}
#define T_4096_2589 {-0.6749616461020120361524732288671657443047,0.7378528147884659826871711629792116582394}
#define T_4096_2595 {-0.6681420414265185625524168244737666100264,0.7440337441799292905741936010599602013826}
#define T_4096_2601 {-0.6612658378399922654011788836214691400528,0.7501516458062150727315042786358390003443}
#define T_4096_2607 {-0.6543336178318005513787625204713549464941,0.7562060014143945352316222852095961570740}
#define T_4096_2613 {-0.6473459686365120591133859306864906102419,0.7621962981345788978870814389665611088276}
#define T_4096_2619 {-0.6403034821841516732732202399347443133593,0.7681220285233654188061791501240804791451}
#define T_4096_2625 {-0.6332067550500573016591943087405525147915,0.7739826906068227874158083068323321640491}
#define T_4096_2631 {-0.6260563884043435223247797694057226181030,0.7797777879230144426614401709230151027441}
#define T_4096_2637 {-0.6188529879609763195702498705941252410412,0.7855068295640539322022277701762504875660}
#define T_4096_2643 {-0.6115971639264619064135786175029352307320,0.7911693302176902031774829993082676082850}
#define T_4096_2649 {-0.6042895309481560728315230335283558815718,0.7967648102084187167193363166006747633219}
#define T_4096_2655 {-0.5969307080621965022615427187702152878046,0.8022927955381157216763199357956182211637}
#define T_4096_2661 {-0.5895213186410639405465872187050990760326,0.8077528179261903584773563125054351985455}
#define T_4096_2667 {-0.5820619903407755479918250784976407885551,0.8131444148492534829131272999802604317665}
#define T_4096_2673 {-0.5745533550477157636038327837013639509678,0.8184671295802986579204230110917706042528}
#define T_4096_2679 {-0.5669960488251086783151322379126213490963,0.8237205112273914275888841984851751476526}
#define T_4096_2685 {-0.5593907118591360250192678904568310827017,0.8289041147718648749886938276176806539297}
#define T_4096_2691 {-0.5517379884047074467545712650462519377470,0.8340175011060181331501439672138076275587}
#define T_4096_2697 {-0.5440385267308839312150325895345304161310,0.8390602370703127421691647214174736291170}
#define T_4096_2703 {-0.5362929790659631823501740655046887695789,0.8440318954900664083496053535782266408205}
#define T_4096_2709 {-0.5285020015422284833661592529097106307745,0.8489320552116396134678666385298129171133}
#define T_4096_2715 {-0.5206662541403671573547740081266965717077,0.8537603011381114104239031803444959223270}
#define T_4096_2721 {-0.5127864006335630664423774760507512837648,0.8585162242644427399440587578283157199621}
#define T_4096_2727 {-0.5048631085312675903509216368547640740871,0.8631994217121241597112657473189756274223}
#define T_4096_2733 {-0.4968970490226545244638600706821307539940,0.8678094967633032119636027346132323145866}
#define T_4096_2739 {-0.4888888969197631717555907471250975504518,0.8723460588943915405835127785394433885813}
#define T_4096_2745 {-0.4808393306003339584542288775992346927524,0.8768087238091456514510468878143001347780}
#define T_4096_2751 {-0.4727490319503427906866477314906660467386,0.8811971134712219821949474862776696681976}
#define T_4096_2757 {-0.4646186863062378158417686790926381945610,0.8855108561361999530703315031132660806179}
#define T_4096_2763 {-0.4564489823968839177226186620828229933977,0.8897495863830727769183681630238424986601}
#define T_4096_2769 {-0.4482406122852199414907659047457855194807,0.8939129451452032526503899134695529937744}
#define T_4096_2775 {-0.4399942713096332558286860603402601554990,0.8980005797407398793197330633120145648718}
#define T_4096_2781 {-0.4317106580250572589463331496517639607191,0.9020121439024931797590056703484151512384}
#define T_4096_2787 {-0.4233904741437960472794088673254009336233,0.9059472978072684590244989522034302353859}
#define T_4096_2793 {-0.4150344244760816314609996879880782216787,0.9098057081046522220901806576875969767570}
#define T_4096_2799 {-0.4066432168703690286370999729115283116698,0.9135870479452508075013383859186433255672}
#define T_4096_2805 {-0.3982175621533736165069683465844718739390,0.9172909970083779063187989777361508458853}
#define T_4096_2811 {-0.3897581740698564667368941627501044422388,0.9209172415291894120414895041903946548700}
#define T_4096_2817 {-0.3812657692221623761952287168242037296295,0.9244654743252626039051733641827013343573}
#define T_4096_2823 {-0.3727410670095158140568969429295975714922,0.9279353948226178872005220910068601369858}
#define T_4096_2829 {-0.3641847895670798918033028712670784443617,0.9313267090811804260752637674158904701471}
#define T_4096_2835 {-0.3555976617047839072327519716054666787386,0.9346391298196807806419883490889333188534}
#define T_4096_2841 {-0.3469804108459236813288839584856759756804,0.9378723764399898854549064708407968282700}
#define T_4096_2847 {-0.3383337669655411827918101153045427054167,0.9410261750508892575339814356993883848190}
#define T_4096_2853 {-0.3296584625285874925459950190997915342450,0.9441002584912726591781506613187957555056}
#define T_4096_2859 {-0.3209552324278752144515181043971097096801,0.9470943663527772171661922584462445229292}
#define T_4096_2865 {-0.3122248139218249396442672605189727619290,0.9500082450018429991445145788020454347134}
#define T_4096_2871 {-0.3034679465720113156201875881379237398505,0.9528416476011987157335170195437967777252}
#define T_4096_2877 {-0.2946853721805143266898596721148351207376,0.9555943341307711058618679089704528450966}
#define T_4096_2883 {-0.2858778347270806152735644900531042367220,0.9582660714080176722617920859192963689566}
#define T_4096_2889 {-0.2770460803060998955515970010310411453247,0.9608566331076796585008992224175017327070}
#define T_4096_2895 {-0.2681908570634031763191273967095185071230,0.9633657997809540463052258019160944968462}
#define T_4096_2901 {-0.2593129151328862347369863528001587837934,0.9657933588740836849950710529810748994350}
#define T_4096_2907 {-0.2504130065729652798722781881224364042282,0.9681391047463624444091578880033921450377}
#define T_4096_2913 {-0.2414918853028693301876472787625971250236,0.9704028386875555023394213094434235244989}
#define T_4096_2919 {-0.2325503070387752446723794719218858517706,0.9725843689347322129634676457499153912067}
#define T_4096_2925 {-0.2235890292297899872853150782248121686280,0.9746835106885106680962849168281536549330}
#define T_4096_2931 {-0.2146088109937867582921455777977826073766,0.9767000861287118418374575412599369883537}
#define T_4096_2937 {-0.2056104130530992668557388469707802869380,0.9786339244294232075915829227596987038851}
#define T_4096_2943 {-0.1965945976700802233505527283341507427394,0.9804848617734693849712357405223883688450}
#define T_4096_2949 {-0.1875621285825296025162600699331960640848,0.9822527413662893724932700934004969894886}
#define T_4096_2955 {-0.1785137709389975346763179686604416929185,0.9839374134492189227785274852067232131958}
#define T_4096_2961 {-0.1694502912339679590036922718354617245495,0.9855387353121760618535063258605077862740}
#define T_4096_2967 {-0.1603724572429282568819530752080027014017,0.9870565713057509737993200360506307333708}
#define T_4096_2973 {-0.1512810379573302221878350337647134438157,0.9884907928526965870119624923972878605127}
#define T_4096_2979 {-0.1421768035194480583882636892667505890131,0.9898412784588205282076955882075708359480}
#define T_4096_2985 {-0.1330605251571390645892734028166159987450,0.9911079137232768898613244346051942557096}
#define T_4096_2991 {-0.1239329751185121730738813994321390055120,0.9922905913482573669881503519718535244465}
#define T_4096_2997 {-0.1147949266065100837330703598127001896501,0.9933892111480806530465770265436731278896}
#define T_4096_3003 {-0.1056471537134106158939417241526825819165,0.9944036800576790957606476695218589156866}
#define T_4096_3009 {-0.0964904313552525927377701009390875697136,0.9953339121404822797956057911505922675133}
#define T_4096_3015 {-0.0873255352061920731010502549906959757209,0.9961798285956969811749672771838959306479}
#define T_4096_3021 {-0.0781532416327942458522670676757115870714,0.9969413577649821611714742175536230206490}
#define T_4096_3027 {-0.0689743276282667461263287123074405826628,0.9976184351385195547834427998168393969536}
#define T_4096_3033 {-0.0597895707466398751428471314284252002835,0.9982110033604781884619683296477887779474}
#define T_4096_3039 {-0.0505997490368992816622828456729621393606,0.9987190122338729381112898408900946378708}
#define T_4096_3045 {-0.0414056409770767394618040668774483492598,0.9991424187248169053177093701378908008337}
#define T_4096_3051 {-0.0322080254083045858237710490357130765915,0.9994811869661669456732511207519564777613}
#define T_4096_3057 {-0.0230076814688393721519688028820382896811,0.9997352882605616830602457412169314920902}
#define T_4096_3063 {-0.0138053885280603905877372383770307351369,0.9999047010828528980752594179648440331221}
#define T_4096_3069 {-0.0046019261204485704952471536444136290811,0.9999894110819284032132259198988322168589}
// Pre-computed twiddles for N=5000
#define T_5000_1 {0.9999992104317517727096742419234942644835,-0.0012566367307023254638181919418116194720}
#define T_5000_3 {0.9999928938932473032608072571747470647097,-0.0037699022545064136621717487685145897558}
#define T_5000_7 {0.9999613114002182667761076118040364235640,-0.0087963459888593647367782679680203727912}
#define T_5000_9 {0.9999360456451857892545831418829038739204,-0.0113094924496577719369438952412565413397}
#define T_5000_11 {0.9999044637506320221120859059737995266914,-0.0138225674735552497146562345164966245648}
#define T_5000_13 {0.9998665659160452801046403692453168332577,-0.0163355551866041122377470884430294972844}
#define T_5000_17 {0.9997718234241997903311016671068500727415,-0.0213612051872230264415453149240420316346}
#define T_5000_19 {0.9997149793653861138409411069005727767944,-0.0238738357300562718810166273897266364656}
#define T_5000_21 {0.9996518205634257192571112682344391942024,-0.0263863154727678149435998733451924636029}
#define T_5000_23 {0.9995823474172642608692740395781584084034,-0.0288986285451700818105447154948706156574}
#define T_5000_27 {0.9994244598875400287241177466057706624269,-0.0339226912036606764733193131178268231452}
#define T_5000_29 {0.9993360465012808280249601011746563017368,-0.0364344090550387106342000720360374543816}
#define T_5000_31 {0.9992413207654209372776676900684833526611,-0.0389458967668873529133222177733841817826}
#define T_5000_33 {0.9991402832782997345262288035883102566004,-0.0414571384752852392652222590641031274572}
#define T_5000_37 {0.9989192756429681185892377470736391842365,-0.0464788204339129581987855033275991445407}
#define T_5000_39 {0.9987993068907620175522765748610254377127,-0.0489892289644702980111468093582516303286}
#define T_5000_41 {0.9986730291792944580464563841815106570721,-0.0514993280524322499802636343702033627778}
#define T_5000_43 {0.9985404433062039508683938038302585482597,-0.0540091018426487601278296324380789883435}
#define T_5000_47 {0.9982563504649325514250790547521319240332,-0.0590276101196191491093934189393621636555}
#define T_5000_49 {0.9981048452912363311284593692107591778040,-0.0615363129067472286459761221522057894617}
#define T_5000_51 {0.9979470355448755158889184713189024478197,-0.0640446269970785103664567827763676177710}
#define T_5000_53 {0.9977829222226621830316162231611087918282,-0.0665525365467379420580940063700836617500}
#define T_5000_57 {0.9974357890370038060012802816345356404781,-0.0715670786614176768214434787296340800822}
#define T_5000_59 {0.9972527713662407977679436044127214699984,-0.0740736795518646129465878402697853744030}
#define T_5000_61 {0.9970634545049750219192219446995295584202,-0.0765798125526930689721538669800793286413}
#define T_5000_63 {0.9968678396490348037062290131871122866869,-0.0790854618338049236703213296095782425255}
#define T_5000_67 {0.9964577209353436826333449971571099013090,-0.0840952459318636824647796856879722326994}
#define T_5000_69 {0.9962432196681255680559274878760334104300,-0.0865993491042914287358911451519816182554}
#define T_5000_71 {0.9960224255872819343338164799206424504519,-0.0891029052681641953181923554438981227577}
#define T_5000_73 {0.9957953400874682836629858684318605810404,-0.0916058986096605909477119666917133145034}
#define T_5000_77 {0.9953223006082435597718927056121174246073,-0.0966101335881140305117398270340345334262}
#define T_5000_79 {0.9950763496168069099923059184220619499683,-0.0991113436156031701873558859006152488291}
#define T_5000_81 {0.9948241131823303273762348908348940312862,-0.1016119276019798456367482231144094839692}
#define T_5000_83 {0.9945655928980761117941256088670343160629,-0.1041118697521965369423568859019724186510}
#define T_5000_87 {0.9940297073517352366422983322991058230400,-0.1091097653843306064525009446697367820889}
#define T_5000_89 {0.9937523454745929019082950617303140461445,-0.1116076872968228689275704823558044154197}
#define T_5000_91 {0.9934687065175402675976101818378083407879,-0.1141049042345042979773594993275764863938}
#define T_5000_93 {0.9931787922721951877846890965884085744619,-0.1166014004235955137112057400372577831149}
#define T_5000_97 {0.9925801452812780256707014814310241490602,-0.1215921674837524696366486409715435001999}
#define T_5000_99 {0.9922714163170857082363340850861277431250,-0.1240864068304210476867410761769860982895}
#define T_5000_101 {0.9919564196273364942157968471292406320572,-0.1265798623799041233706219600207987241447}
#define T_5000_103 {0.9916351572017207960385576370754279196262,-0.1290725183821812838136366963226464577019}
#define T_5000_107 {0.9909738432995269796776938164839521050453,-0.1340553687703875396231012473435839638114}
#define T_5000_109 {0.9906337960001668774268068773380946367979,-0.1365455316819254305560349393999786116183}
#define T_5000_111 {0.9902874913193500105990096926689147949219,-0.1390348320976738383247806041254079900682}
#define T_5000_113 {0.9899349314445247127736138281761668622494,-0.1415232542938584248126687725743977352977}
#define T_5000_117 {0.9892110550601855845087584384600631892681,-0.1464974011602746262195040571896242909133}
#define T_5000_119 {0.9888397431230684375691453169565647840500,-0.1489830944110912269717772460353444330394}
#define T_5000_121 {0.9884621851367073608329860689991619437933,-0.1514678466037124304754968306951923295856}
#define T_5000_123 {0.9880783834859637737579873828508425503969,-0.1539516420430929455331892086178413592279}
#define T_5000_127 {0.9872920589279519099079607258317992091179,-0.1589162999122667452311929991992656141520}
#define T_5000_129 {0.9868895409875367841223692266794387251139,-0.1613971309825826816464200419432017952204}
#define T_5000_131 {0.9864807893164143637321217283897567540407,-0.1638769425809012969530442660470725968480}
#define T_5000_133 {0.9860658064964824554010647261748090386391,-0.1663557190433848087529611348145408555865}
#define T_5000_137 {0.9852171579345608831701497365429531782866,-0.1713101039382865231619490486991708166897}
#define T_5000_139 {0.9847834975530967982493280032940674573183,-0.1737856810761170822665633295400766655803}
#define T_5000_141 {0.9843436167438402994989132821501698344946,-0.1762601604891348705539400043562636710703}
#define T_5000_143 {0.9838975182853179068942495177907403558493,-0.1787335265471830525463303729338804259896}
#define T_5000_147 {0.9829866797309323445119844109285622835159,-0.1836768561130047439089452154803439043462}
#define T_5000_149 {0.9825219453884206366467424231814220547676,-0.1861467883960220559558251807175111025572}
#define T_5000_151 {0.9820510049033092103698550090484786778688,-0.1886155448747545981813544813121552579105}
#define T_5000_153 {0.9815738612503140947396218507492449134588,-0.1910831099551947298564869015535805374384}
#define T_5000_157 {0.9806009765354312124330249389458913356066,-0.1960146035828930488609245230691158212721}
#define T_5000_159 {0.9801052416188119620343854876409750431776,-0.1984785009801572630561139476412790827453}
#define T_5000_161 {0.9796033158248074190765919411205686628819,-0.2009411446793378519526385161952930502594}
#define T_5000_163 {0.9790952023238538304283906654745806008577,-0.2034025191250387887276218634724500589073}
#define T_5000_167 {0.9780604250782479747172715178749058395624,-0.2083213980746022320200694366576499305665}
#define T_5000_169 {0.9775337678698112764408278962946496903896,-0.2107788715081519159699752208325662650168}
#define T_5000_171 {0.9770009360268150366835016029654070734978,-0.2132350135477925900939766279407194815576}
#define T_5000_173 {0.9764619329149148985180772797320969402790,-0.2156898086791962099173503020210773684084}
#define T_5000_177 {0.9753654265419087199262548892875202000141,-0.2205952962026171693121767702905344776809}
#define T_5000_179 {0.9748079302069329044044820875569712370634,-0.2230459576089092454953544120144215412438}
#define T_5000_181 {0.9742442764552697864743890932004433125257,-0.2254952101357094174094441996203386224806}
#define T_5000_183 {0.9736744688472628306286082988663110882044,-0.2279430383122075798318917350115953013301}
#define T_5000_187 {0.9725164064979238132124805815692525357008,-0.2328343597761399486056888008533860556781}
#define T_5000_189 {0.9719281590715429519633516974863596260548,-0.2352778221673293701510232267537503503263}
#define T_5000_191 {0.9713337724186744681631466846738476306200,-0.2377197984159224453115655251167481765151}
#define T_5000_193 {0.9707332502937873197623730447958223521709,-0.2401602730970699428603154501615790650249}
#define T_5000_197 {0.9695138148395850974381460218864958733320,-0.2450366561051525171599507757491664960980}
#define T_5000_199 {0.9688949092128869011730785132385790348053,-0.2474725336302022182799476013315143063664}
#define T_5000_201 {0.9682698835193558339895503195293713361025,-0.2499068479842302403781673092453274875879}
#define T_5000_203 {0.9676387417069935992230966803617775440216,-0.2523395837907840832947670151042984798551}
#define T_5000_207 {0.9663581257109223887624693816178478300571,-0.2572002583056110514014847012731479480863}
#define T_5000_209 {0.9657086596162800518072799604851752519608,-0.2596281663112222637401771407894557341933}
#define T_5000_211 {0.9650530935808888655103032760962378233671,-0.2620544343642292606233468177379108965397}
#define T_5000_213 {0.9643914317456601104083802056265994906425,-0.2644790471390043862243146577384322881699}
#define T_5000_217 {0.9630498374318312571062961069401353597641,-0.2693232456037231714596202891698339954019}
#define T_5000_219 {0.9623699134274699140689790510805323719978,-0.2717428006950765584370799388125305995345}
#define T_5000_221 {0.9616839105716952218472215463407337665558,-0.2741606393112107631360174764267867431045}
#define T_5000_223 {0.9609918331976738947730609652353450655937,-0.2765767461797430382119955538655631244183}
#define T_5000_227 {0.9595894724193817504342973734310362488031,-0.2814037036392603163825754108984256163239}
#define T_5000_229 {0.9588791978731835419225149053090717643499,-0.2838145237405585996626200540049467235804}
#define T_5000_231 {0.9581628665248286269573441131797153502703,-0.2862235511150740818742121973627945408225}
#define T_5000_233 {0.9574404828990550342382448434364050626755,-0.2886307705460806061203982153529068455100}
#define T_5000_237 {0.9559775771053230508655929043015930801630,-0.2934397247678576237106540247623343020678}
#define T_5000_239 {0.9552370641778726856330195005284622311592,-0.2958414291826597097845308326213853433728}
#define T_5000_241 {0.9544905174539615178019857921754010021687,-0.2982412649022077033578170812688767910004}
#define T_5000_243 {0.9537379416491842398784228862496092915535,-0.3006392167678348381620878626563353464007}
#define T_5000_247 {0.9522147218497959419991616414336021989584,-0.3054294083622529076826879190775798633695}
#define T_5000_249 {0.9514440874766688649444290604151319712400,-0.3078216178335902442064764272799948230386}
#define T_5000_251 {0.9506674432655832784888616515672765672207,-0.3102118829362908170033108490315498784184}
#define T_5000_253 {0.9498847941222460233845481525349896401167,-0.3126001885721411133189917563868220895529}
#define T_5000_257 {0.9483015008512654109296136084594763815403,-0.3173708611124177458862050116294994950294}
#define T_5000_259 {0.9475008667245626847730477493314538151026,-0.3197531978826834153650793268752750009298}
#define T_5000_261 {0.9466942476674268247549548505048733204603,-0.3221335149179680445996609705616720020771}
#define T_5000_263 {0.9458816487749021062469978460285346955061,-0.3245117971828955227842072872590506449342}
#define T_5000_267 {0.9442385320526907044325071183266118168831,-0.3292621973245331568058702487178379669785}
#define T_5000_269 {0.9434080246018221593828911863965913653374,-0.3316342851951342707295111722487490624189}
#define T_5000_271 {0.9425715580731357512433987722033634781837,-0.3340042782833495538241663780354429036379}
#define T_5000_273 {0.9417291377502087224016236177703831344843,-0.3363721616190146201930133429414127022028}
#define T_5000_277 {0.9400264570439446076832723520055878907442,-0.3411015392187625727693500721215968951583}
#define T_5000_279 {0.9391662074156642558975249812647234648466,-0.3434630036095261962358904384018387645483}
#define T_5000_281 {0.9383000255031889169643477544013876467943,-0.3458222985012897043866075819096295163035}
#define T_5000_283 {0.9374279167777940235950495662109460681677,-0.3481794089914642675864797638496384024620}
#define T_5000_287 {0.9356659409604988208997156107216142117977,-0.3528870172257748683009026535728480666876}
#define T_5000_289 {0.9347760849981954223153479688335210084915,-0.3552374852340987598786625767388613894582}
#define T_5000_291 {0.9338803244820960136607368440309073776007,-0.3575857093693972088566113143315305933356}
#define T_5000_293 {0.9329786650703109085469577621552161872387,-0.3599316747990104481402795499889180064201}
#define T_5000_297 {0.9311576723783917541865662315103691071272,-0.3646167702819711475825670277117751538754}
#define T_5000_299 {0.9302383506006371982621772076527122408152,-0.3669558707417092668912061981245642527938}
#define T_5000_301 {0.9293131529318833239372565913072321563959,-0.3692926533087302898294979058846365660429}
#define T_5000_303 {0.9283820852161814851655208258307538926601,-0.3716271032226454718028207935276441276073}
#define T_5000_307 {0.9265023632054938396152010682271793484688,-0.3762889461233681620555557856278028339148}
#define T_5000_309 {0.9255537207838540059157139694434590637684,-0.3786163096634422853270507403067313134670}
#define T_5000_311 {0.9245992320618827697842334600863978266716,-0.3809412816571296489520648265170166268945}
#define T_5000_313 {0.9236389030686498191613509334274567663670,-0.3832638474186436106094788556220009922981}
#define T_5000_317 {0.9217007485690897894414774782489985227585,-0.3879017015780925059509343100216938182712}
#define T_5000_319 {0.9207229353051999964918650221079587936401,-0.3902169606808199020520078192930668592453}
#define T_5000_321 {0.9197393062548454567561861949798185378313,-0.3925297549611438951977504530077567324042}
#define T_5000_323 {0.9187498676311617318290814182546455413103,-0.3948400698101989236832309870806057006121}
#define T_5000_327 {0.9167535866997925664279023294511716812849,-0.3994532028574384607821912140934728085995}
#define T_5000_329 {0.9157467570017023827944058211869560182095,-0.4017559919165675230701140208111610263586}
#define T_5000_331 {0.9147341429493940356820758097455836832523,-0.4040562432665005254683876501076156273484}
#define T_5000_333 {0.9137157509390884113642528063792269676924,-0.4063539423775998637999862239666981622577}
#define T_5000_337 {0.9116616588118107156191172180115245282650,-0.4109416258454448023229588216054253280163}
#define T_5000_339 {0.9106259716696010197978239375515840947628,-0.4132315812238883112605947189877042546868}
#define T_5000_341 {0.9095845325188364194346490876341704279184,-0.4155189264070768273562350714200874790549}
#define T_5000_343 {0.9085373479378128225292243769217748194933,-0.4178036469468950353522984642040682956576}
#define T_5000_347 {0.9064257689795853778491618868429213762283,-0.4223651563869436631470932752563385292888}
#define T_5000_349 {0.9053613879402618858094342613185290247202,-0.4246419164742013530045028346648905426264}
#define T_5000_351 {0.9042912881463557317474055707862135022879,-0.4269159942923252404334277798625407740474}
#define T_5000_353 {0.9032154763571986766379495747969485819340,-0.4291873754770037519001846249011578038335}
#define T_5000_357 {0.9010467440108171910395640225033275783062,-0.4337219905740368752766755733318859711289}
#define T_5000_359 {0.8999538371524847812921166223532054573298,-0.4359851958432979235347204394201980903745}
#define T_5000_361 {0.8988552456965994696957977794227190315723,-0.4382456471931076569248375562892761081457}
#define T_5000_363 {0.8977509765824618348517560662003234028816,-0.4405033303452267623434579491004114970565}
#define T_5000_367 {0.8955254333159045065926306961046066135168,-0.4450103350309535521489578968612477183342}
#define T_5000_369 {0.8944041732212255624290264677256345748901,-0.4472596280958700543095574175822548568249}
#define T_5000_371 {0.8932772635836871977232931385515257716179,-0.4495060960258935867095431149209616705775}
#define T_5000_373 {0.8921447115214631295998515270184725522995,-0.4517497246311116820827180617925478145480}
#define T_5000_377 {0.8898627087738110175152428382716607302427,-0.4562284071972453891596899211435811594129}
#define T_5000_379 {0.8887132725027525603778144613897893577814,-0.4584634328683677706450794175907503813505}
#define T_5000_381 {0.8875582226356564241598334774607792496681,-0.4606955626352770560849592129670782014728}
#define T_5000_383 {0.8863975664684456967634673674183432012796,-0.4629247823986284426922566126449964940548}
#define T_5000_387 {0.8840594645943864460235772639862261712551,-0.4673744356092733309715470113587798550725}
#define T_5000_389 {0.8828820336562601678309647468267939984798,-0.4695948409501388698394919174461392685771}
#define T_5000_391 {0.8816990259553703079831166178337298333645,-0.4718122800747679979060933419532375410199}
#define T_5000_393 {0.8805104489642362475265713328553829342127,-0.4740267389766100736281373428937513381243}
#define T_5000_397 {0.8781166171771599415762921125860884785652,-0.4784466601799422513785486898996168747544}
#define T_5000_399 {0.8769113775019603540528123630792833864689,-0.4806520945628078300693175606284057721496}
#define T_5000_401 {0.8757005987779062916587236031773500144482,-0.4828544928858136686677937632339308038354}
#define T_5000_403 {0.8744842886529343717327833473973441869020,-0.4850538412374150176731291139731183648109}
#define T_5000_407 {0.8720351049666303921981125313322991132736,-0.4894433324766390702720286753901746124029}
#define T_5000_409 {0.8708022468756737577422200047294609248638,-0.4916334476378494966475329874810995534062}
#define T_5000_411 {0.8695638883244519723447751857747789472342,-0.4938204573750058501424575752025702968240}
#define T_5000_413 {0.8683200371351107449413575523067265748978,-0.4960043478737660715971458103012992069125}
#define T_5000_417 {0.8658158883040750763981918680656235665083,-0.5003627159973307314544399559963494539261}
#define T_5000_419 {0.8645556064799456708058755793899763375521,-0.5025371660923133587672850808303337544203}
#define T_5000_421 {0.8632898636527268632079312737914733588696,-0.5047084418894302038083310435467865318060}
#define T_5000_423 {0.8620186678175382199995624432631302624941,-0.5068765296737230974244425851793494075537}
#define T_5000_427 {0.8594599492759001924113704262708779424429,-0.5112030864447778544246148157981224358082}
#define T_5000_429 {0.8581724427317077852350735156505834311247,-0.5133615281026556731447385573119390755892}
#define T_5000_431 {0.8568795155039573563371391173859592527151,-0.5155167270901142018146856571547687053680}
#define T_5000_433 {0.8555811757594800059933959346381016075611,-0.5176686697937453729423395998310297727585}
#define T_5000_437 {0.8529682915585590219365030861808918416500,-0.5219627319988210389922755894076544791460}
#define T_5000_439 {0.8516537636065120153716634376905858516693,-0.5241048243766349701289186668873298913240}
#define T_5000_441 {0.8503338561464273137602276619873009622097,-0.5262436062235313904977829224662855267525}
#define T_5000_443 {0.8490085775155576941486401665315497666597,-0.5283790640298017260434448871819768100977}
#define T_5000_447 {0.8463419402600584895424162823474034667015,-0.5326399535866978007803140826581511646509}
#define T_5000_449 {0.8450005984793591551351710222661495208740,-0.5347653584232292534039743259199894964695}
#define T_5000_451 {0.8436539192156289335144947472144849598408,-0.5368873853911163562813158023345749825239}
#define T_5000_453 {0.8423019109752259980794519833580125123262,-0.5390060210864833223354253277648240327835}
#define T_5000_457 {0.8395819417580838717185542918741703033447,-0.5432330651513449515377374154923018068075}
#define T_5000_459 {0.8382139979621486824967746542824897915125,-0.5453414468205318721416574589966330677271}
#define T_5000_461 {0.8368407595510399810123658426164183765650,-0.5474463838167520357558260002406314015388}
#define T_5000_463 {0.8354622351988777451126111373014282435179,-0.5495478628440793045228929258882999420166}
#define T_5000_467 {0.8326893635347630828746900988335255533457,-0.5537403939176471778793597877665888518095}
#define T_5000_469 {0.8312950337377751353074017970357090234756,-0.5558314194815828779283606309036258608103}
#define T_5000_471 {0.8298954530295520326532709987077396363020,-0.5579189341121831846592726833478081971407}
#define T_5000_473 {0.8284906302506062081292270704580005258322,-0.5600029246235713742407824611291289329529}
#define T_5000_477 {0.8256652940080988489768287763581611216068,-0.5641602806565876315758600867411587387323}
#define T_5000_479 {0.8242447983908965936095114557247143238783,-0.5662336199180955098597678443184122443199}
#define T_5000_481 {0.8228190963955773762350531796982977539301,-0.5683033825403166483525296825973782688379}
#define T_5000_483 {0.8213881970276499799865632667206227779388,-0.5703695554495055164423433780029881745577}
#define T_5000_487 {0.8185108423600949700826845401024911552668,-0.5744910799472588980307818928849883377552}
#define T_5000_489 {0.8170644052354033570750857506936881691217,-0.5765464055020347311497630471421871334314}
#define T_5000_491 {0.8156128070878603253390792815480381250381,-0.5785980892763651350918507887399755418301}
#define T_5000_493 {0.8141560570865490342740145024436060339212,-0.5806461183107004542236495581164490431547}
#define T_5000_497 {0.8112271383616037612185323268931824713945,-0.5847311604366945969601943033921997994184}
#define T_5000_499 {0.8097549881386122416770945164898876100779,-0.5867681477250071830908950687444303184748}
#define T_5000_501 {0.8082777230630205922423670017451513558626,-0.5888014286667950791809289512457326054573}
#define T_5000_503 {0.8067953524660377295774082995194476097822,-0.5908309904187508676542961438826750963926}
#define T_5000_507 {0.8038153321939218720615372149040922522545,-0.5948789050974787606662630423670634627342}
#define T_5000_509 {0.8023177013422165826384002684790175408125,-0.5968972324554218111813952418742701411247}
#define T_5000_511 {0.8008150026158564749323431897209957242012,-0.5989117894860358504161013115663081407547}
#define T_5000_513 {0.7993072455067035120279683724220376461744,-0.6009225634642839652954648954619187861681}
#define T_5000_517 {0.7962765942671635732708068644569721072912,-0.6049327114830929108535428895265795290470}
#define T_5000_519 {0.7947537192800170346984600655559916049242,-0.6069320601933794190330218043527565896511}
#define T_5000_521 {0.7932258241964373901566887070657685399055,-0.6089275751909111189519308027229271829128}
#define T_5000_523 {0.7916929186674402929568827858020085841417,-0.6109192438709307726441011254792101681232}
#define T_5000_527 {0.7886121150354394870873875333927571773529,-0.6148909919809614210706172343634534627199}
#define T_5000_529 {0.7870642363924658102547482485533691942692,-0.6168710463232528473653815126453991979361}
#define T_5000_531 {0.7855113862240121758162558762705884873867,-0.6188472041727511863129507219127845019102}
#define T_5000_533 {0.7839535743387240351864875265164300799370,-0.6208194530469697269836615305393934249878}
#define T_5000_537 {0.7808231048088696280018439210834912955761,-0.6247521740631536424359637749148532748222}
#define T_5000_539 {0.7792504669380501125530713579792063683271,-0.6267126213639157006340951738820876926184}
#define T_5000_541 {0.7776729068977652481464701850200071930885,-0.6286691100071480908795251707488205283880}
#define T_5000_543 {0.7760904346527415231804525319603271782398,-0.6306216276346051641255030517640989273787}
#define T_5000_547 {0.7729107935624618397341123454680200666189,-0.6345147005347043789313943307206500321627}
#define T_5000_549 {0.7713136448015469603944893606239929795265,-0.6364552312165822067768772285489831119776}
#define T_5000_551 {0.7697116240044489243743441875267308205366,-0.6383917417013114103951920696999877691269}
#define T_5000_553 {0.7681047412904017379631227413483429700136,-0.6403242197568393967443967085273470729589}
#define T_5000_557 {0.7648764307418843833019650446658488363028,-0.6441770297795128552564847268513403832912}
#define T_5000_559 {0.7632550232991781591351809765910729765892,-0.6460973374102163546695010154508054256439}
#define T_5000_561 {0.7616287947229219978950709446507971733809,-0.6480135639389881241356761165661737322807}
#define T_5000_563 {0.7599977552852593687404691991105210036039,-0.6499256972619000816138168374891392886639}
#define T_5000_567 {0.7567212850661638734450775700679514557123,-0.6537376360037822076165525686519686132669}
#define T_5000_569 {0.7550758749806975034246647737745661288500,-0.6556374173444755593109789515438023954630}
#define T_5000_571 {0.7534256954256273175474234449211508035660,-0.6575330573229074548891048834775574505329}
#define T_5000_573 {0.7517707568243841009802963526453822851181,-0.6594245439651853502027734066359698772430}
#define T_5000_577 {0.7484466443273399827162961628346238285303,-0.6631950094769594183929939390509389340878}
#define T_5000_579 {0.7467774914284401877040409090113826096058,-0.6650739645301460001292070955969393253326}
#define T_5000_581 {0.7451036214770371257642977980140130966902,-0.6669487186147103896516341592359822243452}
#define T_5000_583 {0.7434250450462031034604137857968453317881,-0.6688192598886868456276033612084574997425}
#define T_5000_587 {0.7400538151871081105070970806991681456566,-0.6725476567701397234699811633618082851171}
#define T_5000_589 {0.7383611830533670650211774955096188932657,-0.6744054888270351044710082533129025250673}
#define T_5000_591 {0.7366638870291005725121635805408004671335,-0.6762590609723292400801142321142833679914}
#define T_5000_593 {0.7349619378353529075553751681582070887089,-0.6781083614978530293981862087093759328127}
#define T_5000_597 {0.7315441229704821024526495421014260500669,-0.6817941009918963013447523735521826893091}
#define T_5000_599 {0.7298282788881353955190434135147370398045,-0.6836305166792820964261068183986935764551}
#define T_5000_601 {0.7281078248137233810410862133721821010113,-0.6854626141847768305837007574154995381832}
#define T_5000_603 {0.7263827716145693225158197492419276386499,-0.6872903819358571197994933754671365022659}
#define T_5000_607 {0.7229189114565106599741284298943355679512,-0.6909328820214982735947728542669210582972}
#define T_5000_609 {0.7211801263772293912879263189097400754690,-0.6927475913480489744245005567790940403938}
#define T_5000_611 {0.7194367859323145264482946004136465489864,-0.6945579249043100089622271298139821738005}
#define T_5000_613 {0.7176889011336515800110191776184365153313,-0.6963638712552308041026094542758073657751}
#define T_5000_617 {0.7141795426660783041583613339753355830908,-0.6999625567394810454757703155337367206812}
#define T_5000_619 {0.7124180911641833091607622918672859668732,-0.7017552731415571676265585665532853454351}
#define T_5000_621 {0.7106521396424310132999835332157090306282,-0.7035435568759298430308035676716826856136}
#define T_5000_623 {0.7088816992555312390678068368288222700357,-0.7053273966468270872454127129458356648684}
#define T_5000_627 {0.7053273966468270872454127129458356648684,-0.7088816992555312390678068368288222700357}
#define T_5000_633 {0.6999625567394810454757703155337367206812,-0.7141795426660783041583613339753355830908}
#define T_5000_639 {0.6945579249043100089622271298139821738005,-0.7194367859323145264482946004136465489864}
#define T_5000_651 {0.6836305166792820964261068183986935764551,-0.7298282788881353955190434135147370398045}
#define T_5000_657 {0.6781083614978530293981862087093759328127,-0.7349619378353529075553751681582070887089}
#define T_5000_663 {0.6725476567701397234699811633618082851171,-0.7400538151871081105070970806991681456566}
#define T_5000_669 {0.6669487186147103896516341592359822243452,-0.7451036214770371257642977980140130966902}
#define T_5000_681 {0.6556374173444755593109789515438023954630,-0.7550758749806975034246647737745661288500}
#define T_5000_687 {0.6499256972619000816138168374891392886639,-0.7599977552852593687404691991105210036039}
#define T_5000_693 {0.6441770297795128552564847268513403832912,-0.7648764307418843833019650446658488363028}
#define T_5000_699 {0.6383917417013114103951920696999877691269,-0.7697116240044489243743441875267308205366}
#define T_5000_711 {0.6267126213639157006340951738820876926184,-0.7792504669380501125530713579792063683271}
#define T_5000_717 {0.6208194530469697269836615305393934249878,-0.7839535743387240351864875265164300799370}
#define T_5000_723 {0.6148909919809614210706172343634534627199,-0.7886121150354394870873875333927571773529}
#define T_5000_729 {0.6089275751909111189519308027229271829128,-0.7932258241964373901566887070657685399055}
#define T_5000_741 {0.5968972324554218111813952418742701411247,-0.8023177013422165826384002684790175408125}
#define T_5000_747 {0.5908309904187508676542961438826750963926,-0.8067953524660377295774082995194476097822}
#define T_5000_753 {0.5847311604366945969601943033921997994184,-0.8112271383616037612185323268931824713945}
#define T_5000_759 {0.5785980892763651350918507887399755418301,-0.8156128070878603253390792815480381250381}
#define T_5000_771 {0.5662336199180955098597678443184122443199,-0.8242447983908965936095114557247143238783}
#define T_5000_777 {0.5600029246235713742407824611291289329529,-0.8284906302506062081292270704580005258322}
#define T_5000_783 {0.5537403939176471778793597877665888518095,-0.8326893635347630828746900988335255533457}
#define T_5000_789 {0.5474463838167520357558260002406314015388,-0.8368407595510399810123658426164183765650}
#define T_5000_801 {0.5347653584232292534039743259199894964695,-0.8450005984793591551351710222661495208740}
#define T_5000_807 {0.5283790640298017260434448871819768100977,-0.8490085775155576941486401665315497666597}
#define T_5000_813 {0.5219627319988210389922755894076544791460,-0.8529682915585590219365030861808918416500}
#define T_5000_819 {0.5155167270901142018146856571547687053680,-0.8568795155039573563371391173859592527151}
#define T_5000_831 {0.5025371660923133587672850808303337544203,-0.8645556064799456708058755793899763375521}
#define T_5000_837 {0.4960043478737660715971458103012992069125,-0.8683200371351107449413575523067265748978}
#define T_5000_843 {0.4894433324766390702720286753901746124029,-0.8720351049666303921981125313322991132736}
#define T_5000_849 {0.4828544928858136686677937632339308038354,-0.8757005987779062916587236031773500144482}
#define T_5000_861 {0.4695948409501388698394919174461392685771,-0.8828820336562601678309647468267939984798}
#define T_5000_867 {0.4629247823986284426922566126449964940548,-0.8863975664684456967634673674183432012796}
#define T_5000_873 {0.4562284071972453891596899211435811594129,-0.8898627087738110175152428382716607302427}
#define T_5000_879 {0.4495060960258935867095431149209616705775,-0.8932772635836871977232931385515257716179}
#define T_5000_891 {0.4359851958432979235347204394201980903745,-0.8999538371524847812921166223532054573298}
#define T_5000_897 {0.4291873754770037519001846249011578038335,-0.9032154763571986766379495747969485819340}
#define T_5000_903 {0.4223651563869436631470932752563385292888,-0.9064257689795853778491618868429213762283}
#define T_5000_909 {0.4155189264070768273562350714200874790549,-0.9095845325188364194346490876341704279184}
#define T_5000_921 {0.4017559919165675230701140208111610263586,-0.9157467570017023827944058211869560182095}
#define T_5000_927 {0.3948400698101989236832309870806057006121,-0.9187498676311617318290814182546455413103}
#define T_5000_933 {0.3879017015780925059509343100216938182712,-0.9217007485690897894414774782489985227585}
#define T_5000_939 {0.3809412816571296489520648265170166268945,-0.9245992320618827697842334600863978266716}
#define T_5000_951 {0.3669558707417092668912061981245642527938,-0.9302383506006371982621772076527122408152}
#define T_5000_957 {0.3599316747990104481402795499889180064201,-0.9329786650703109085469577621552161872387}
#define T_5000_963 {0.3528870172257748683009026535728480666876,-0.9356659409604988208997156107216142117977}
#define T_5000_969 {0.3458222985012897043866075819096295163035,-0.9383000255031889169643477544013876467943}
#define T_5000_981 {0.3316342851951342707295111722487490624189,-0.9434080246018221593828911863965913653374}
#define T_5000_987 {0.3245117971828955227842072872590506449342,-0.9458816487749021062469978460285346955061}
#define T_5000_993 {0.3173708611124177458862050116294994950294,-0.9483015008512654109296136084594763815403}
#define T_5000_999 {0.3102118829362908170033108490315498784184,-0.9506674432655832784888616515672765672207}
#define T_5000_1011 {0.2958414291826597097845308326213853433728,-0.9552370641778726856330195005284622311592}
#define T_5000_1017 {0.2886307705460806061203982153529068455100,-0.9574404828990550342382448434364050626755}
#define T_5000_1023 {0.2814037036392603163825754108984256163239,-0.9595894724193817504342973734310362488031}
#define T_5000_1029 {0.2741606393112107631360174764267867431045,-0.9616839105716952218472215463407337665558}
#define T_5000_1041 {0.2596281663112222637401771407894557341933,-0.9657086596162800518072799604851752519608}
#define T_5000_1047 {0.2523395837907840832947670151042984798551,-0.9676387417069935992230966803617775440216}
#define T_5000_1053 {0.2450366561051525171599507757491664960980,-0.9695138148395850974381460218864958733320}
#define T_5000_1059 {0.2377197984159224453115655251167481765151,-0.9713337724186744681631466846738476306200}
#define T_5000_1071 {0.2230459576089092454953544120144215412438,-0.9748079302069329044044820875569712370634}
#define T_5000_1077 {0.2156898086791962099173503020210773684084,-0.9764619329149148985180772797320969402790}
#define T_5000_1083 {0.2083213980746022320200694366576499305665,-0.9780604250782479747172715178749058395624}
#define T_5000_1089 {0.2009411446793378519526385161952930502594,-0.9796033158248074190765919411205686628819}
#define T_5000_1101 {0.1861467883960220559558251807175111025572,-0.9825219453884206366467424231814220547676}
#define T_5000_1107 {0.1787335265471830525463303729338804259896,-0.9838975182853179068942495177907403558493}
#define T_5000_1113 {0.1713101039382865231619490486991708166897,-0.9852171579345608831701497365429531782866}
#define T_5000_1119 {0.1638769425809012969530442660470725968480,-0.9864807893164143637321217283897567540407}
#define T_5000_1131 {0.1489830944110912269717772460353444330394,-0.9888397431230684375691453169565647840500}
#define T_5000_1137 {0.1415232542938584248126687725743977352977,-0.9899349314445247127736138281761668622494}
#define T_5000_1143 {0.1340553687703875396231012473435839638114,-0.9909738432995269796776938164839521050453}
#define T_5000_1149 {0.1265798623799041233706219600207987241447,-0.9919564196273364942157968471292406320572}
#define T_5000_1161 {0.1116076872968228689275704823558044154197,-0.9937523454745929019082950617303140461445}
#define T_5000_1167 {0.1041118697521965369423568859019724186510,-0.9945655928980761117941256088670343160629}
#define T_5000_1173 {0.0966101335881140305117398270340345334262,-0.9953223006082435597718927056121174246073}
#define T_5000_1179 {0.0891029052681641953181923554438981227577,-0.9960224255872819343338164799206424504519}
#define T_5000_1191 {0.0740736795518646129465878402697853744030,-0.9972527713662407977679436044127214699984}
#define T_5000_1197 {0.0665525365467379420580940063700836617500,-0.9977829222226621830316162231611087918282}
#define T_5000_1203 {0.0590276101196191491093934189393621636555,-0.9982563504649325514250790547521319240332}
#define T_5000_1209 {0.0514993280524322499802636343702033627778,-0.9986730291792944580464563841815106570721}
#define T_5000_1221 {0.0364344090550387106342000720360374543816,-0.9993360465012808280249601011746563017368}
#define T_5000_1227 {0.0288986285451700818105447154948706156574,-0.9995823474172642608692740395781584084034}
#define T_5000_1233 {0.0213612051872230264415453149240420316346,-0.9997718234241997903311016671068500727415}
#define T_5000_1239 {0.0138225674735552497146562345164966245648,-0.9999044637506320221120859059737995266914}
#define T_5000_1251 {-0.0012566367307023254638181919418116194720,-0.9999992104317517727096742419234942644835}
#define T_5000_1257 {-0.0087963459888593647367782679680203727912,-0.9999613114002182667761076118040364235640}
#define T_5000_1263 {-0.0163355551866041122377470884430294972844,-0.9998665659160452801046403692453168332577}
#define T_5000_1269 {-0.0238738357300562718810166273897266364656,-0.9997149793653861138409411069005727767944}
#define T_5000_1281 {-0.0389458967668873529133222177733841817826,-0.9992413207654209372776676900684833526611}
#define T_5000_1287 {-0.0464788204339129581987855033275991445407,-0.9989192756429681185892377470736391842365}
#define T_5000_1293 {-0.0540091018426487601278296324380789883435,-0.9985404433062039508683938038302585482597}
#define T_5000_1299 {-0.0615363129067472286459761221522057894617,-0.9981048452912363311284593692107591778040}
#define T_5000_1311 {-0.0765798125526930689721538669800793286413,-0.9970634545049750219192219446995295584202}
#define T_5000_1317 {-0.0840952459318636824647796856879722326994,-0.9964577209353436826333449971571099013090}
#define T_5000_1323 {-0.0916058986096605909477119666917133145034,-0.9957953400874682836629858684318605810404}
#define T_5000_1329 {-0.0991113436156031701873558859006152488291,-0.9950763496168069099923059184220619499683}
#define T_5000_1341 {-0.1141049042345042979773594993275764863938,-0.9934687065175402675976101818378083407879}
#define T_5000_1347 {-0.1215921674837524696366486409715435001999,-0.9925801452812780256707014814310241490602}
#define T_5000_1353 {-0.1290725183821812838136366963226464577019,-0.9916351572017207960385576370754279196262}
#define T_5000_1359 {-0.1365455316819254305560349393999786116183,-0.9906337960001668774268068773380946367979}
#define T_5000_1371 {-0.1514678466037124304754968306951923295856,-0.9884621851367073608329860689991619437933}
#define T_5000_1377 {-0.1589162999122667452311929991992656141520,-0.9872920589279519099079607258317992091179}
#define T_5000_1383 {-0.1663557190433848087529611348145408555865,-0.9860658064964824554010647261748090386391}
#define T_5000_1389 {-0.1737856810761170822665633295400766655803,-0.9847834975530967982493280032940674573183}
#define T_5000_1401 {-0.1886155448747545981813544813121552579105,-0.9820510049033092103698550090484786778688}
#define T_5000_1407 {-0.1960146035828930488609245230691158212721,-0.9806009765354312124330249389458913356066}
#define T_5000_1413 {-0.2034025191250387887276218634724500589073,-0.9790952023238538304283906654745806008577}
#define T_5000_1419 {-0.2107788715081519159699752208325662650168,-0.9775337678698112764408278962946496903896}
#define T_5000_1431 {-0.2254952101357094174094441996203386224806,-0.9742442764552697864743890932004433125257}
#define T_5000_1437 {-0.2328343597761399486056888008533860556781,-0.9725164064979238132124805815692525357008}
#define T_5000_1443 {-0.2401602730970699428603154501615790650249,-0.9707332502937873197623730447958223521709}
#define T_5000_1449 {-0.2474725336302022182799476013315143063664,-0.9688949092128869011730785132385790348053}
#define T_5000_1461 {-0.2620544343642292606233468177379108965397,-0.9650530935808888655103032760962378233671}
#define T_5000_1467 {-0.2693232456037231714596202891698339954019,-0.9630498374318312571062961069401353597641}
#define T_5000_1473 {-0.2765767461797430382119955538655631244183,-0.9609918331976738947730609652353450655937}
#define T_5000_1479 {-0.2838145237405585996626200540049467235804,-0.9588791978731835419225149053090717643499}
#define T_5000_1491 {-0.2982412649022077033578170812688767910004,-0.9544905174539615178019857921754010021687}
#define T_5000_1497 {-0.3054294083622529076826879190775798633695,-0.9522147218497959419991616414336021989584}
#define T_5000_1503 {-0.3126001885721411133189917563868220895529,-0.9498847941222460233845481525349896401167}
#define T_5000_1509 {-0.3197531978826834153650793268752750009298,-0.9475008667245626847730477493314538151026}
#define T_5000_1521 {-0.3340042782833495538241663780354429036379,-0.9425715580731357512433987722033634781837}
#define T_5000_1527 {-0.3411015392187625727693500721215968951583,-0.9400264570439446076832723520055878907442}
#define T_5000_1533 {-0.3481794089914642675864797638496384024620,-0.9374279167777940235950495662109460681677}
#define T_5000_1539 {-0.3552374852340987598786625767388613894582,-0.9347760849981954223153479688335210084915}
#define T_5000_1551 {-0.3692926533087302898294979058846365660429,-0.9293131529318833239372565913072321563959}
#define T_5000_1557 {-0.3762889461233681620555557856278028339148,-0.9265023632054938396152010682271793484688}
#define T_5000_1563 {-0.3832638474186436106094788556220009922981,-0.9236389030686498191613509334274567663670}
#define T_5000_1569 {-0.3902169606808199020520078192930668592453,-0.9207229353051999964918650221079587936401}
#define T_5000_1581 {-0.4040562432665005254683876501076156273484,-0.9147341429493940356820758097455836832523}
#define T_5000_1587 {-0.4109416258454448023229588216054253280163,-0.9116616588118107156191172180115245282650}
#define T_5000_1593 {-0.4178036469468950353522984642040682956576,-0.9085373479378128225292243769217748194933}
#define T_5000_1599 {-0.4246419164742013530045028346648905426264,-0.9053613879402618858094342613185290247202}
#define T_5000_1611 {-0.4382456471931076569248375562892761081457,-0.8988552456965994696957977794227190315723}
#define T_5000_1617 {-0.4450103350309535521489578968612477183342,-0.8955254333159045065926306961046066135168}
#define T_5000_1623 {-0.4517497246311116820827180617925478145480,-0.8921447115214631295998515270184725522995}
#define T_5000_1629 {-0.4584634328683677706450794175907503813505,-0.8887132725027525603778144613897893577814}
#define T_5000_1641 {-0.4718122800747679979060933419532375410199,-0.8816990259553703079831166178337298333645}
#define T_5000_1647 {-0.4784466601799422513785486898996168747544,-0.8781166171771599415762921125860884785652}
#define T_5000_1653 {-0.4850538412374150176731291139731183648109,-0.8744842886529343717327833473973441869020}
#define T_5000_1659 {-0.4916334476378494966475329874810995534062,-0.8708022468756737577422200047294609248638}
#define T_5000_1671 {-0.5047084418894302038083310435467865318060,-0.8632898636527268632079312737914733588696}
#define T_5000_1677 {-0.5112030864447778544246148157981224358082,-0.8594599492759001924113704262708779424429}
#define T_5000_1683 {-0.5176686697937453729423395998310297727585,-0.8555811757594800059933959346381016075611}
#define T_5000_1689 {-0.5241048243766349701289186668873298913240,-0.8516537636065120153716634376905858516693}
#define T_5000_1701 {-0.5368873853911163562813158023345749825239,-0.8436539192156289335144947472144849598408}
#define T_5000_1707 {-0.5432330651513449515377374154923018068075,-0.8395819417580838717185542918741703033447}
#define T_5000_1713 {-0.5495478628440793045228929258882999420166,-0.8354622351988777451126111373014282435179}
#define T_5000_1719 {-0.5558314194815828779283606309036258608103,-0.8312950337377751353074017970357090234756}
#define T_5000_1731 {-0.5683033825403166483525296825973782688379,-0.8228190963955773762350531796982977539301}
#define T_5000_1737 {-0.5744910799472588980307818928849883377552,-0.8185108423600949700826845401024911552668}
#define T_5000_1743 {-0.5806461183107004542236495581164490431547,-0.8141560570865490342740145024436060339212}
#define T_5000_1749 {-0.5867681477250071830908950687444303184748,-0.8097549881386122416770945164898876100779}
#define T_5000_1761 {-0.5989117894860358504161013115663081407547,-0.8008150026158564749323431897209957242012}
#define T_5000_1767 {-0.6049327114830929108535428895265795290470,-0.7962765942671635732708068644569721072912}
#define T_5000_1773 {-0.6109192438709307726441011254792101681232,-0.7916929186674402929568827858020085841417}
#define T_5000_1779 {-0.6168710463232528473653815126453991979361,-0.7870642363924658102547482485533691942692}
#define T_5000_1791 {-0.6286691100071480908795251707488205283880,-0.7776729068977652481464701850200071930885}
#define T_5000_1797 {-0.6345147005347043789313943307206500321627,-0.7729107935624618397341123454680200666189}
#define T_5000_1803 {-0.6403242197568393967443967085273470729589,-0.7681047412904017379631227413483429700136}
#define T_5000_1809 {-0.6460973374102163546695010154508054256439,-0.7632550232991781591351809765910729765892}
#define T_5000_1821 {-0.6575330573229074548891048834775574505329,-0.7534256954256273175474234449211508035660}
#define T_5000_1827 {-0.6631950094769594183929939390509389340878,-0.7484466443273399827162961628346238285303}
#define T_5000_1833 {-0.6688192598886868456276033612084574997425,-0.7434250450462031034604137857968453317881}
#define T_5000_1839 {-0.6744054888270351044710082533129025250673,-0.7383611830533670650211774955096188932657}
#define T_5000_1851 {-0.6854626141847768305837007574154995381832,-0.7281078248137233810410862133721821010113}
#define T_5000_1857 {-0.6909328820214982735947728542669210582972,-0.7229189114565106599741284298943355679512}
#define T_5000_1863 {-0.6963638712552308041026094542758073657751,-0.7176889011336515800110191776184365153313}
#define T_5000_1869 {-0.7017552731415571676265585665532853454351,-0.7124180911641833091607622918672859668732}
#define T_5000_1881 {-0.7124180911641833091607622918672859668732,-0.7017552731415571676265585665532853454351}
#define T_5000_1887 {-0.7176889011336515800110191776184365153313,-0.6963638712552308041026094542758073657751}
#define T_5000_1893 {-0.7229189114565106599741284298943355679512,-0.6909328820214982735947728542669210582972}
#define T_5000_1899 {-0.7281078248137233810410862133721821010113,-0.6854626141847768305837007574154995381832}
#define T_5000_1911 {-0.7383611830533670650211774955096188932657,-0.6744054888270351044710082533129025250673}
#define T_5000_1917 {-0.7434250450462031034604137857968453317881,-0.6688192598886868456276033612084574997425}
#define T_5000_1923 {-0.7484466443273399827162961628346238285303,-0.6631950094769594183929939390509389340878}
#define T_5000_1929 {-0.7534256954256273175474234449211508035660,-0.6575330573229074548891048834775574505329}
#define T_5000_1941 {-0.7632550232991781591351809765910729765892,-0.6460973374102163546695010154508054256439}
#define T_5000_1947 {-0.7681047412904017379631227413483429700136,-0.6403242197568393967443967085273470729589}
#define T_5000_1953 {-0.7729107935624618397341123454680200666189,-0.6345147005347043789313943307206500321627}
#define T_5000_1959 {-0.7776729068977652481464701850200071930885,-0.6286691100071480908795251707488205283880}
#define T_5000_1971 {-0.7870642363924658102547482485533691942692,-0.6168710463232528473653815126453991979361}
#define T_5000_1977 {-0.7916929186674402929568827858020085841417,-0.6109192438709307726441011254792101681232}
#define T_5000_1983 {-0.7962765942671635732708068644569721072912,-0.6049327114830929108535428895265795290470}
#define T_5000_1989 {-0.8008150026158564749323431897209957242012,-0.5989117894860358504161013115663081407547}
#define T_5000_2001 {-0.8097549881386122416770945164898876100779,-0.5867681477250071830908950687444303184748}
#define T_5000_2007 {-0.8141560570865490342740145024436060339212,-0.5806461183107004542236495581164490431547}
#define T_5000_2013 {-0.8185108423600949700826845401024911552668,-0.5744910799472588980307818928849883377552}
#define T_5000_2019 {-0.8228190963955773762350531796982977539301,-0.5683033825403166483525296825973782688379}
#define T_5000_2031 {-0.8312950337377751353074017970357090234756,-0.5558314194815828779283606309036258608103}
#define T_5000_2037 {-0.8354622351988777451126111373014282435179,-0.5495478628440793045228929258882999420166}
#define T_5000_2043 {-0.8395819417580838717185542918741703033447,-0.5432330651513449515377374154923018068075}
#define T_5000_2049 {-0.8436539192156289335144947472144849598408,-0.5368873853911163562813158023345749825239}
#define T_5000_2061 {-0.8516537636065120153716634376905858516693,-0.5241048243766349701289186668873298913240}
#define T_5000_2067 {-0.8555811757594800059933959346381016075611,-0.5176686697937453729423395998310297727585}
#define T_5000_2073 {-0.8594599492759001924113704262708779424429,-0.5112030864447778544246148157981224358082}
#define T_5000_2079 {-0.8632898636527268632079312737914733588696,-0.5047084418894302038083310435467865318060}
#define T_5000_2091 {-0.8708022468756737577422200047294609248638,-0.4916334476378494966475329874810995534062}
#define T_5000_2097 {-0.8744842886529343717327833473973441869020,-0.4850538412374150176731291139731183648109}
#define T_5000_2103 {-0.8781166171771599415762921125860884785652,-0.4784466601799422513785486898996168747544}
#define T_5000_2109 {-0.8816990259553703079831166178337298333645,-0.4718122800747679979060933419532375410199}
#define T_5000_2121 {-0.8887132725027525603778144613897893577814,-0.4584634328683677706450794175907503813505}
#define T_5000_2127 {-0.8921447115214631295998515270184725522995,-0.4517497246311116820827180617925478145480}
#define T_5000_2133 {-0.8955254333159045065926306961046066135168,-0.4450103350309535521489578968612477183342}
#define T_5000_2139 {-0.8988552456965994696957977794227190315723,-0.4382456471931076569248375562892761081457}
#define T_5000_2151 {-0.9053613879402618858094342613185290247202,-0.4246419164742013530045028346648905426264}
#define T_5000_2157 {-0.9085373479378128225292243769217748194933,-0.4178036469468950353522984642040682956576}
#define T_5000_2163 {-0.9116616588118107156191172180115245282650,-0.4109416258454448023229588216054253280163}
#define T_5000_2169 {-0.9147341429493940356820758097455836832523,-0.4040562432665005254683876501076156273484}
#define T_5000_2181 {-0.9207229353051999964918650221079587936401,-0.3902169606808199020520078192930668592453}
#define T_5000_2187 {-0.9236389030686498191613509334274567663670,-0.3832638474186436106094788556220009922981}
#define T_5000_2193 {-0.9265023632054938396152010682271793484688,-0.3762889461233681620555557856278028339148}
#define T_5000_2199 {-0.9293131529318833239372565913072321563959,-0.3692926533087302898294979058846365660429}
#define T_5000_2211 {-0.9347760849981954223153479688335210084915,-0.3552374852340987598786625767388613894582}
#define T_5000_2217 {-0.9374279167777940235950495662109460681677,-0.3481794089914642675864797638496384024620}
#define T_5000_2223 {-0.9400264570439446076832723520055878907442,-0.3411015392187625727693500721215968951583}
#define T_5000_2229 {-0.9425715580731357512433987722033634781837,-0.3340042782833495538241663780354429036379}
#define T_5000_2241 {-0.9475008667245626847730477493314538151026,-0.3197531978826834153650793268752750009298}
#define T_5000_2247 {-0.9498847941222460233845481525349896401167,-0.3126001885721411133189917563868220895529}
#define T_5000_2253 {-0.9522147218497959419991616414336021989584,-0.3054294083622529076826879190775798633695}
#define T_5000_2259 {-0.9544905174539615178019857921754010021687,-0.2982412649022077033578170812688767910004}
#define T_5000_2271 {-0.9588791978731835419225149053090717643499,-0.2838145237405585996626200540049467235804}
#define T_5000_2277 {-0.9609918331976738947730609652353450655937,-0.2765767461797430382119955538655631244183}
#define T_5000_2283 {-0.9630498374318312571062961069401353597641,-0.2693232456037231714596202891698339954019}
#define T_5000_2289 {-0.9650530935808888655103032760962378233671,-0.2620544343642292606233468177379108965397}
#define T_5000_2301 {-0.9688949092128869011730785132385790348053,-0.2474725336302022182799476013315143063664}
#define T_5000_2307 {-0.9707332502937873197623730447958223521709,-0.2401602730970699428603154501615790650249}
#define T_5000_2313 {-0.9725164064979238132124805815692525357008,-0.2328343597761399486056888008533860556781}
#define T_5000_2319 {-0.9742442764552697864743890932004433125257,-0.2254952101357094174094441996203386224806}
#define T_5000_2331 {-0.9775337678698112764408278962946496903896,-0.2107788715081519159699752208325662650168}
#define T_5000_2337 {-0.9790952023238538304283906654745806008577,-0.2034025191250387887276218634724500589073}
#define T_5000_2343 {-0.9806009765354312124330249389458913356066,-0.1960146035828930488609245230691158212721}
#define T_5000_2349 {-0.9820510049033092103698550090484786778688,-0.1886155448747545981813544813121552579105}
#define T_5000_2361 {-0.9847834975530967982493280032940674573183,-0.1737856810761170822665633295400766655803}
#define T_5000_2367 {-0.9860658064964824554010647261748090386391,-0.1663557190433848087529611348145408555865}
#define T_5000_2373 {-0.9872920589279519099079607258317992091179,-0.1589162999122667452311929991992656141520}
#define T_5000_2379 {-0.9884621851367073608329860689991619437933,-0.1514678466037124304754968306951923295856}
#define T_5000_2391 {-0.9906337960001668774268068773380946367979,-0.1365455316819254305560349393999786116183}
#define T_5000_2397 {-0.9916351572017207960385576370754279196262,-0.1290725183821812838136366963226464577019}
#define T_5000_2403 {-0.9925801452812780256707014814310241490602,-0.1215921674837524696366486409715435001999}
#define T_5000_2409 {-0.9934687065175402675976101818378083407879,-0.1141049042345042979773594993275764863938}
#define T_5000_2421 {-0.9950763496168069099923059184220619499683,-0.0991113436156031701873558859006152488291}
#define T_5000_2427 {-0.9957953400874682836629858684318605810404,-0.0916058986096605909477119666917133145034}
#define T_5000_2433 {-0.9964577209353436826333449971571099013090,-0.0840952459318636824647796856879722326994}
#define T_5000_2439 {-0.9970634545049750219192219446995295584202,-0.0765798125526930689721538669800793286413}
#define T_5000_2451 {-0.9981048452912363311284593692107591778040,-0.0615363129067472286459761221522057894617}
#define T_5000_2457 {-0.9985404433062039508683938038302585482597,-0.0540091018426487601278296324380789883435}
#define T_5000_2463 {-0.9989192756429681185892377470736391842365,-0.0464788204339129581987855033275991445407}
#define T_5000_2469 {-0.9992413207654209372776676900684833526611,-0.0389458967668873529133222177733841817826}
#define T_5000_2481 {-0.9997149793653861138409411069005727767944,-0.0238738357300562718810166273897266364656}
#define T_5000_2487 {-0.9998665659160452801046403692453168332577,-0.0163355551866041122377470884430294972844}
#define T_5000_2493 {-0.9999613114002182667761076118040364235640,-0.0087963459888593647367782679680203727912}
#define T_5000_2499 {-0.9999992104317517727096742419234942644835,-0.0012566367307023254638181919418116194720}
#define T_5000_2511 {-0.9999044637506320221120859059737995266914,0.0138225674735552497146562345164966245648}
#define T_5000_2517 {-0.9997718234241997903311016671068500727415,0.0213612051872230264415453149240420316346}
#define T_5000_2523 {-0.9995823474172642608692740395781584084034,0.0288986285451700818105447154948706156574}
#define T_5000_2529 {-0.9993360465012808280249601011746563017368,0.0364344090550387106342000720360374543816}
#define T_5000_2541 {-0.9986730291792944580464563841815106570721,0.0514993280524322499802636343702033627778}
#define T_5000_2547 {-0.9982563504649325514250790547521319240332,0.0590276101196191491093934189393621636555}
#define T_5000_2553 {-0.9977829222226621830316162231611087918282,0.0665525365467379420580940063700836617500}
#define T_5000_2559 {-0.9972527713662407977679436044127214699984,0.0740736795518646129465878402697853744030}
#define T_5000_2571 {-0.9960224255872819343338164799206424504519,0.0891029052681641953181923554438981227577}
#define T_5000_2577 {-0.9953223006082435597718927056121174246073,0.0966101335881140305117398270340345334262}
#define T_5000_2583 {-0.9945655928980761117941256088670343160629,0.1041118697521965369423568859019724186510}
#define T_5000_2589 {-0.9937523454745929019082950617303140461445,0.1116076872968228689275704823558044154197}
#define T_5000_2601 {-0.9919564196273364942157968471292406320572,0.1265798623799041233706219600207987241447}
#define T_5000_2607 {-0.9909738432995269796776938164839521050453,0.1340553687703875396231012473435839638114}
#define T_5000_2613 {-0.9899349314445247127736138281761668622494,0.1415232542938584248126687725743977352977}
#define T_5000_2619 {-0.9888397431230684375691453169565647840500,0.1489830944110912269717772460353444330394}
#define T_5000_2631 {-0.9864807893164143637321217283897567540407,0.1638769425809012969530442660470725968480}
#define T_5000_2637 {-0.9852171579345608831701497365429531782866,0.1713101039382865231619490486991708166897}
#define T_5000_2643 {-0.9838975182853179068942495177907403558493,0.1787335265471830525463303729338804259896}
#define T_5000_2649 {-0.9825219453884206366467424231814220547676,0.1861467883960220559558251807175111025572}
#define T_5000_2661 {-0.9796033158248074190765919411205686628819,0.2009411446793378519526385161952930502594}
#define T_5000_2667 {-0.9780604250782479747172715178749058395624,0.2083213980746022320200694366576499305665}
#define T_5000_2673 {-0.9764619329149148985180772797320969402790,0.2156898086791962099173503020210773684084}
#define T_5000_2679 {-0.9748079302069329044044820875569712370634,0.2230459576089092454953544120144215412438}
#define T_5000_2691 {-0.9713337724186744681631466846738476306200,0.2377197984159224453115655251167481765151}
#define T_5000_2697 {-0.9695138148395850974381460218864958733320,0.2450366561051525171599507757491664960980}
#define T_5000_2703 {-0.9676387417069935992230966803617775440216,0.2523395837907840832947670151042984798551}
#define T_5000_2709 {-0.9657086596162800518072799604851752519608,0.2596281663112222637401771407894557341933}
#define T_5000_2721 {-0.9616839105716952218472215463407337665558,0.2741606393112107631360174764267867431045}
#define T_5000_2727 {-0.9595894724193817504342973734310362488031,0.2814037036392603163825754108984256163239}
#define T_5000_2733 {-0.9574404828990550342382448434364050626755,0.2886307705460806061203982153529068455100}
#define T_5000_2739 {-0.9552370641778726856330195005284622311592,0.2958414291826597097845308326213853433728}
#define T_5000_2751 {-0.9506674432655832784888616515672765672207,0.3102118829362908170033108490315498784184}
#define T_5000_2757 {-0.9483015008512654109296136084594763815403,0.3173708611124177458862050116294994950294}
#define T_5000_2763 {-0.9458816487749021062469978460285346955061,0.3245117971828955227842072872590506449342}
#define T_5000_2769 {-0.9434080246018221593828911863965913653374,0.3316342851951342707295111722487490624189}
#define T_5000_2781 {-0.9383000255031889169643477544013876467943,0.3458222985012897043866075819096295163035}
#define T_5000_2787 {-0.9356659409604988208997156107216142117977,0.3528870172257748683009026535728480666876}
#define T_5000_2793 {-0.9329786650703109085469577621552161872387,0.3599316747990104481402795499889180064201}
#define T_5000_2799 {-0.9302383506006371982621772076527122408152,0.3669558707417092668912061981245642527938}
#define T_5000_2811 {-0.9245992320618827697842334600863978266716,0.3809412816571296489520648265170166268945}
#define T_5000_2817 {-0.9217007485690897894414774782489985227585,0.3879017015780925059509343100216938182712}
#define T_5000_2823 {-0.9187498676311617318290814182546455413103,0.3948400698101989236832309870806057006121}
#define T_5000_2829 {-0.9157467570017023827944058211869560182095,0.4017559919165675230701140208111610263586}
#define T_5000_2841 {-0.9095845325188364194346490876341704279184,0.4155189264070768273562350714200874790549}
#define T_5000_2847 {-0.9064257689795853778491618868429213762283,0.4223651563869436631470932752563385292888}
#define T_5000_2853 {-0.9032154763571986766379495747969485819340,0.4291873754770037519001846249011578038335}
#define T_5000_2859 {-0.8999538371524847812921166223532054573298,0.4359851958432979235347204394201980903745}
#define T_5000_2871 {-0.8932772635836871977232931385515257716179,0.4495060960258935867095431149209616705775}
#define T_5000_2877 {-0.8898627087738110175152428382716607302427,0.4562284071972453891596899211435811594129}
#define T_5000_2883 {-0.8863975664684456967634673674183432012796,0.4629247823986284426922566126449964940548}
#define T_5000_2889 {-0.8828820336562601678309647468267939984798,0.4695948409501388698394919174461392685771}
#define T_5000_2901 {-0.8757005987779062916587236031773500144482,0.4828544928858136686677937632339308038354}
#define T_5000_2907 {-0.8720351049666303921981125313322991132736,0.4894433324766390702720286753901746124029}
#define T_5000_2913 {-0.8683200371351107449413575523067265748978,0.4960043478737660715971458103012992069125}
#define T_5000_2919 {-0.8645556064799456708058755793899763375521,0.5025371660923133587672850808303337544203}
#define T_5000_2931 {-0.8568795155039573563371391173859592527151,0.5155167270901142018146856571547687053680}
#define T_5000_2937 {-0.8529682915585590219365030861808918416500,0.5219627319988210389922755894076544791460}
#define T_5000_2943 {-0.8490085775155576941486401665315497666597,0.5283790640298017260434448871819768100977}
#define T_5000_2949 {-0.8450005984793591551351710222661495208740,0.5347653584232292534039743259199894964695}
#define T_5000_2961 {-0.8368407595510399810123658426164183765650,0.5474463838167520357558260002406314015388}
#define T_5000_2967 {-0.8326893635347630828746900988335255533457,0.5537403939176471778793597877665888518095}
#define T_5000_2973 {-0.8284906302506062081292270704580005258322,0.5600029246235713742407824611291289329529}
#define T_5000_2979 {-0.8242447983908965936095114557247143238783,0.5662336199180955098597678443184122443199}
#define T_5000_2991 {-0.8156128070878603253390792815480381250381,0.5785980892763651350918507887399755418301}
#define T_5000_2997 {-0.8112271383616037612185323268931824713945,0.5847311604366945969601943033921997994184}
// Pre-computed twiddles for N=6561
#define T_6561_1 {0.9999995414469015075908941980742383748293,-0.0009576565076647147170194052101521720033}
#define T_6561_2 {0.9999981657880266938676072641101200133562,-0.0019153121370567118605249268270540596859}
#define T_6561_4 {0.9999926631588352821111698176537174731493,-0.0038306172479365147715002493100655556191}
#define T_6561_5 {0.9999885361935653138587554167315829545259,-0.0047882649728861340424068693266690388555}
#define T_6561_7 {0.9999775309806009371271784402779303491116,-0.0067035463704822996836019122213201626437}
#define T_6561_8 {0.9999706527429996771871856253710575401783,-0.0076611782866124076771252582318538770778}
#define T_6561_10 {0.9999541450370988959761575642914976924658,-0.0095764201622866532842559550431360548828}
#define T_6561_11 {0.9999445155839388199581208027666434645653,-0.0105340283653505995681287643606083292980}
#define T_6561_13 {0.9999225055213553092769984687038231641054,-0.0124492149107908560423663146821127156727}
#define T_6561_14 {0.9999101249321176165807401048368774354458,-0.0134067914967377181667540497755908290856}
#define T_6561_16 {0.9998826126945214998187339006108231842518,-0.0153219069040886092525344253090224810876}
#define T_6561_17 {0.9998674810713947813667346053989604115486,-0.0162794439691284278937111196228215703741}
#define T_6561_19 {0.9998344668858706318914641997253056615591,-0.0181944724311217456702571837467985460535}
#define T_6561_20 {0.9998165843537506480842580458556767553091,-0.0191519620717907727847073573457237216644}
#define T_6561_22 {0.9997780684927959349295178981265053153038,-0.0210668877818759522901892466961726313457}
#define T_6561_23 {0.9997574351992842833780628097883891314268,-0.0220243220951018697784107303050404880196}
#define T_6561_25 {0.9997134179808070397754704572435002774000,-0.0239391292475764558278505944599601207301}
#define T_6561_26 {0.9996900340962099340558211224561091512442,-0.0248965003307436184842860171784195699729}
#define T_6561_28 {0.9996405158835259818772556172916665673256,-0.0268111731208837272832923304122232366353}
#define T_6561_29 {0.9996143816008526972183290126849897205830,-0.0277684730718983918684727996151195839047}
#define T_6561_31 {0.9995593628026830934629742841934785246849,-0.0296829956960891518102929609312923275866}
#define T_6561_32 {0.9995304783376448565235250498517416417599,-0.0306402166134446887757469824009604053572}
#define T_6561_34 {0.9994699594081120075372837163740769028664,-0.0325545732693107020550016272864013444632}
#define T_6561_35 {0.9994383249991196649375524430070072412491,-0.0335117072521528280848457370666437782347}
#define T_6561_37 {0.9993723064377437736993670114316046237946,-0.0354258821386885872084526738490239949897}
#define T_6561_38 {0.9993379223459063487311482276709284633398,-0.0363829212868805665359595025165617698804}
#define T_6561_40 {0.9992664046976014180501124428701587021351,-0.0382968986045808673646106967680680099875}
#define T_6561_41 {0.9992292712067232240968905898625962436199,-0.0392538350187687304360117934720619814470}
#define T_6561_43 {0.9991522550617923936755460090353153645992,-0.0411675989697591060423320641348254866898}
#define T_6561_44 {0.9991123724783717019448658902547322213650,-0.0421244247514368438944920569610985694453}
#define T_6561_46 {0.9990298584725023633978935322375036776066,-0.0440379595396039463794934931684110779315}
#define T_6561_47 {0.9989872271257279612299839754996355623007,-0.0449946667911787015481372975500562461093}
#define T_6561_49 {0.9988992159399867620805935075622983276844,-0.0469079566223006699798858676331292372197}
#define T_6561_50 {0.9988538361817356214800156521960161626339,-0.0478645374471579274078258947611175244674}
#define T_6561_52 {0.9987603285425625809779148767120204865932,-0.0497775665290347835156836708847549743950}
#define T_6561_53 {0.9987122007473970830560006106679793447256,-0.0507340130316035475832592283040867187083}
#define T_6561_55 {0.9986131974265994859507600267534144222736,-0.0526467655741875012465058603083889465779}
#define T_6561_56 {0.9985623219917639792342356486187782138586,-0.0536030698600054728020225525142450351268}
#define T_6561_58 {0.9984578238065104915932579388027079403400,-0.0555155300755312830496279730141395702958}
#define T_6561_59 {0.9984042011519284054443801323941443115473,-0.0564716842513100086842214864191191736609}
#define T_6561_61 {0.9982942089647418582032400991010945290327,-0.0583838363544252961223612885532929794863}
#define T_6561_62 {0.9982378395330119280615122079325374215841,-0.0593398325281153243837550803618796635419}
#define T_6561_64 {0.9981223542517623226189016349962912499905,-0.0612516607360108489288563760055694729090}
#define T_6561_65 {0.9980632385081550372873948617780115455389,-0.0622074910168668587795437474596838001162}
#define T_6561_67 {0.9979422610860524400777649134397506713867,-0.0641189795494068043302249293446948286146}
#define T_6561_68 {0.9978803995185061559425321320304647088051,-0.0650746360480527613612267145981604699045}
#define T_6561_70 {0.9977539309540920386965012767177540808916,-0.0669857691279049510812981793606013525277}
#define T_6561_71 {0.9976893240732092049682933065923862159252,-0.0679412439563991943369813952813274227083}
#define T_6561_73 {0.9975573654103488951960798658546991646290,-0.0698520058091653822662792094888573046774}
#define T_6561_74 {0.9974900137493915019959445089625660330057,-0.0708072910810657596414330328116193413734}
#define T_6561_76 {0.9973525660772653012031696562189608812332,-0.0727176659354117349565171934955287724733}
#define T_6561_77 {0.9972824701921506607149581213889177888632,-0.0736727537658407038989594184386078268290}
#define T_6561_79 {0.9971395346452448515961464181600604206324,-0.0755827258536265617072658073993807192892}
#define T_6561_80 {0.9970666951145409351298098954430315643549,-0.0765376083593362205315102642089186701924}
#define T_6561_82 {0.9969182728726385667172849025519099086523,-0.0784471619157464661320489085483131930232}
#define T_6561_83 {0.9968426902975592307498686750477645546198,-0.0794018312151836408441241133004950825125}
#define T_6561_85 {0.9966887825857301264065313262108247727156,-0.0813109504788573078659652537680813111365}
#define T_6561_86 {0.9966104575901302276008664193795993924141,-0.0822653986922286667438086738002311903983}
#define T_6561_88 {0.9964510656787211040352758573135361075401,-0.0841740679053894214067810253254720009863}
#define T_6561_89 {0.9963699989090911701694608382240403443575,-0.0851282871547264369249674587081244681031}
#define T_6561_91 {0.9962051241137150903171004756586626172066,-0.0870364905633126267892052396746294107288}
#define T_6561_92 {0.9961213162391764353031931022997014224529,-0.0879904729725366346881898493847984354943}
#define T_6561_94 {0.9959509599207015950739219078968744724989,-0.0898981948263313790370432343479478731751}
#define T_6561_95 {0.9958644116330002127313036908162757754326,-0.0908519325213185680034655433701118454337}
#define T_6561_97 {0.9956885751975395049129247126984409987926,-0.0927591570740796678151696141867432743311}
#define T_6561_98 {0.9955992872110407398977827142516616731882,-0.0937126421827261107955209240572003182024}
#define T_6561_100 {0.9954179721099392086358648157329298555851,-0.0956193536923160836149548913454054854810}
#define T_6561_101 {0.9953259451616217612368586742377374321222,-0.0965725783446026581069432381809747312218}
#define T_6561_103 {0.9951391528914453887821878197428304702044,-0.0984787610731186618950872002642427105457}
#define T_6561_104 {0.9950443877408949866492093860870227217674,-0.0994317174011760812613047733066196087748}
#define T_6561_106 {0.9948521198434181478376103768823668360710,-0.1013373556150797966113330517146096099168}
#define T_6561_107 {0.9947546172728217728220556637097615748644,-0.1022900357532534748594699181012401822954}
#define T_6561_109 {0.9945568753350140234203990985406562685966,-0.1041951137235009872128443930705543607473}
#define T_6561_110 {0.9944566361491531392147180667961947619915,-0.1051475098084160009204168773067067377269}
#define T_6561_112 {0.9942534218031667814230445401335600763559,-0.1070520118105876133940412842093792278320}
#define T_6561_113 {0.9941504468294104501779884230927564203739,-0.1080041159812136081219691163823881652206}
#define T_6561_115 {0.9939417617525667658640031731920316815376,-0.1099080262956436265797677265254606027156}
#define T_6561_116 {0.9938360518408655419619890381000004708767,-0.1108598306933596955303755748900584876537}
#define T_6561_118 {0.9936218977556406928286492075130809098482,-0.1127631336052662136548718763151555322111}
#define T_6561_119 {0.9935134537785189623448900420044083148241,-0.1137146303739257624521030720643466338515}
#define T_6561_121 {0.9932938324525303341872017881541978567839,-0.1156173101735403080381203722026839386672}
#define T_6561_122 {0.9931826553050793204846513617667369544506,-0.1165684914595358778743872107952483929694}
#define T_6561_124 {0.9929575685510704241565349548181984573603,-0.1184705324422331701450517016382946167141}
#define T_6561_125 {0.9928436591509409714362277554755564779043,-0.1194213903945613025614491675696626771241}
#define T_6561_127 {0.9926131088267667879065925262693781405687,-0.1213227768609887596840124501795799005777}
#define T_6561_128 {0.9924964681141612565795639966381713747978,-0.1222733036313147642060172870515089016408}
#define T_6561_130 {0.9922604561227728048322660470148548483849,-0.1241740198875222050967082054739876184613}
#define T_6561_131 {0.9921410850604380771144974460185039788485,-0.1251242076302449546254536016931524500251}
#define T_6561_133 {0.9918996133498667600036924341111443936825,-0.1270242379878140370763617283955682069063}
#define T_6561_134 {0.9917775129230854691542162981932051479816,-0.1279740788601307632799120028721517883241}
#define T_6561_136 {0.9915305834864269751705023736576549708843,-0.1298734076363045331081735866973758675158}
#define T_6561_137 {0.9914057547030101780194399907486513257027,-0.1308228937982754136459817573268082924187}
#define T_6561_139 {0.9911533695784077169221859548997599631548,-0.1327215053160877844540266323747346177697}
#define T_6561_140 {0.9910258134686860120865503631648607552052,-0.1336706289307008355127237564374809153378}
#define T_6561_142 {0.9907679747393141056477361416909843683243,-0.1355685075191058464039173259152448736131}
#define T_6561_143 {0.9906376923561293068587474408559501171112,-0.1365172607523415793107091076308279298246}
#define T_6561_145 {0.9903744021501761363168725438299588859081,-0.1384143907463428746495992527343332767487}
#define T_6561_146 {0.9902413945688726126803658189601264894009,-0.1393627657672387998299967648563324473798}
#define T_6561_148 {0.9899726550595224772166602633660659193993,-0.1412591315080189147135314442493836395442}
#define T_6561_149 {0.9898369233779383824511910461296793073416,-0.1422071204887343509604136215784819796681}
#define T_6561_151 {0.9895627367833538245989188908424694091082,-0.1441027063237838856668560083562624640763}
#define T_6561_152 {0.9894242821218117711623563081957399845123,-0.1450503014396644918537759849641588516533}
#define T_6561_154 {0.9891446507051155911938167264452204108238,-0.1469450917229113695583464505034498870373}
#define T_6561_155 {0.9890034742064133244099366493173874914646,-0.1478922851525537596195647438435116782784}
#define T_6561_157 {0.9887184002756695955227428385114762932062,-0.1497862642444923730877803791372571140528}
#define T_6561_158 {0.9885745031050711117970308805524837225676,-0.1507330481698086199759956116395187564194}
#define T_6561_160 {0.9882839890132657512111791220377199351788,-0.1526262004376288394791316704868222586811}
#define T_6561_161 {0.9881373723584911950013065506936982274055,-0.1535725670439111179010893692975514568388}
#define T_6561_163 {0.9878414205035133122123625071253627538681,-0.1554648768616274101539431740093277767301}
#define T_6561_164 {0.9876920855747293170878720047767274081707,-0.1564108183376123895058640300703700631857}
#define T_6561_166 {0.9873906983993510078079225422698073089123,-0.1583022700861927700710651834015152417123}
#define T_6561_167 {0.9872386464291607044430065798223949968815,-0.1592477786241260628852245417874655686319}
#define T_6561_169 {0.9869318264210167335193091275868937373161,-0.1611383566916209930663939076112001203001}
#define T_6561_170 {0.9867770586644496466632858755474444478750,-0.1620834244873217699911549516400555148721}
#define T_6561_172 {0.9864648083560173530415227105550002306700,-0.1639731132689930259704880199933541007340}
#define T_6561_173 {0.9863073260905188544001021000440232455730,-0.1649177325219182421722763365323771722615}
#define T_6561_175 {0.9859896480590968348423075440223328769207,-0.1668065164203677563925509730324847623706}
#define T_6561_176 {0.9858294525845178180034622528182808309793,-0.1677506793336766277580096584642888046801}
#define T_6561_178 {0.9855063494522048328505547942768316715956,-0.1696385427589751637711401599517557770014}
#define T_6561_179 {0.9853434420907908330988789202820044010878,-0.1705822415395935598425580792536493390799}
#define T_6561_181 {0.9850149165244643789662859489908441901207,-0.1724691689094094149137248450642800889909}
#define T_6561_182 {0.9848492986208448041196561462129466235638,-0.1734123957680940852910111971141304820776}
#define T_6561_184 {0.9845153533321385763699140625249128788710,-0.1752983715078217374916391690931050106883}
#define T_6561_185 {0.9843470262533153825046383644803427159786,-0.1762411186592246770121761301197693683207}
#define T_6561_187 {0.9840076639985974038538074637472163885832,-0.1781261272021132935350351544911973178387}
#define T_6561_188 {0.9838366291339338820520765693800058215857,-0.1790683868648459686756524433803861029446}
#define T_6561_190 {0.9834918527142835209531313012121245265007,-0.1809524126521279141499576326168607920408}
#define T_6561_191 {0.9833181114754931950727723233285360038280,-0.1818941770488254894289070762170013040304}
#define T_6561_193 {0.9829679237366779620543866258230991661549,-0.1837772045298447509686923240224132314324}
#define T_6561_194 {0.9827914775578124872978946768853347748518,-0.1847184658872302875920468068215996026993}
#define T_6561_196 {0.9824358813902647202809248483390547335148,-0.1866004795195708443333870718561229296029}
#define T_6561_197 {0.9822567317277020038090995512902736663818,-0.1875412300685194710858638700301526114345}
#define T_6561_199 {0.9818957300664948872892523468181025236845,-0.1894222143181335249462193814906640909612}
#define T_6561_200 {0.9817138783989275419017417334544006735086,-0.1903624462937366090820034969510743394494}
#define T_6561_202 {0.9813474742237511261322424616082571446896,-0.1922423856350728155195639601515722461045}
#define T_6561_203 {0.9811629220521738137250622457941062748432,-0.1931820912767019393641021451912820339203}
#define T_6561_205 {0.9807911183873100346986007025407161563635,-0.1950609701928336381371309471433050930500}
#define T_6561_206 {0.9806038672350072538108634034870192408562,-0.1960001417442047144668038072268245741725}
#define T_6561_208 {0.9802266671493052863084471937327180057764,-0.1978779447269579105928016815596492961049}
#define T_6561_209 {0.9800367185618388266021838717279024422169,-0.1988165744361952702590201624843757599592}
#define T_6561_211 {0.9796541251686896600858744932338595390320,-0.2006932859862766704850400856230407953262}
#define T_6561_212 {0.9794614807138857237589490978280082345009,-0.2016313661059769002381614200203330256045}
#define T_6561_214 {0.9790734971711962941753881750628352165222,-0.2035069707331018384888210448480094783008}
#define T_6561_215 {0.9788781584391328394190168182831257581711,-0.2044444935203978963578208549733972176909}
#define T_6561_217 {0.9784847879493001610029523362754844129086,-0.2063189757434181759165880976070184260607}
#define T_6561_218 {0.9782867565522933572808028657163958996534,-0.2072559334600431735218251105834497138858}
#define T_6561_220 {0.9778880023621780992471030913293361663818,-0.2091292778070749092123037371493410319090}
#define T_6561_221 {0.9776872799347695597305119008524343371391,-0.2100656627194259773450113470971700735390}
#define T_6561_223 {0.9772831453356690678546669914794620126486,-0.2119378537279772711787728667331975884736}
#define T_6561_224 {0.9770797335346116385679238192096818238497,-0.2128736581071795086472775437869131565094}
#define T_6561_226 {0.9766702218622330677888498939864803105593,-0.2147446803242779589382394078711513429880}
#define T_6561_227 {0.9764641223664777269775072454649489372969,-0.2156798964462481316139985665358835831285}
#define T_6561_229 {0.9760492370009103968442332188715226948261,-0.2175497344285685918929829085755045525730}
#define T_6561_230 {0.9758404515115922661649960900831501930952,-0.2184843545740789150233496229702723212540}
#define T_6561_232 {0.9754201958772792391272332679363898932934,-0.2203529928880708088634321484278189018369}
#define T_6561_233 {0.9752087261177034838155464058218058198690,-0.2212870093428126461176930206420365720987}
#define T_6561_235 {0.9747831036834142537372827064245939254761,-0.2231544325648274207374299749062629416585}
#define T_6561_236 {0.9745689513990417607303129443607758730650,-0.2240878376194749554972673877273336984217}
#define T_6561_238 {0.9741379656778428319796603318536654114723,-0.2259540303358933133193175990527379326522}
#define T_6561_239 {0.9739211326362761100838838501658756285906,-0.2268868162861672477248475843225605785847}
#define T_6561_241 {0.9734847871855024648013454680040013045073,-0.2287517630935265167124725849134847521782}
#define T_6561_242 {0.9732652751764707677040178168681450188160,-0.2296839222402575486636777668536524288356}
#define T_6561_244 {0.9728235735976962228477304961415939033031,-0.2315476077453786363236076795146800577641}
#define T_6561_245 {0.9726013844330406721283566184865776449442,-0.2324791323945711307707995274540735408664}
#define T_6561_247 {0.9721543303720483475416358487564139068127,-0.2343415412146857002007038772717351093888}
#define T_6561_248 {0.9719294658857076107949524157447740435600,-0.2352724236775811106348044177138945087790}
#define T_6561_250 {0.9714770630324595090954176157538313418627,-0.2371335404404585345261580187070649117231}
#define T_6561_251 {0.9712495250804538127198384245275519788265,-0.2380637730335988522245571630264748819172}
#define T_6561_253 {0.9707917771690610653223529880051501095295,-0.2399235823776731113543547735389438457787}
#define T_6561_254 {0.9705615676294774285537414471036754548550,-0.2408531574229643423823432613062323071063}
#define T_6561_256 {0.9700984784381686543142109258042182773352,-0.2427116439974607298157849299968802370131}
#define T_6561_257 {0.9698655992111453461035353029728867113590,-0.2436405538222362887612604254172765649855}
#define T_6561_259 {0.9693971725622357871188228273240383714437,-0.2454977022872981418100124528791639022529}
#define T_6561_260 {0.9691616255699464499429041097755543887615,-0.2464259392243821067403075630863895639777}
#define T_6561_262 {0.9686878653298066632615359594637993723154,-0.2482817342511975666763390790947596542537}
#define T_6561_263 {0.9684496525164446589784006391710136085749,-0.2492092906389679618506249880738323554397}
#define T_6561_265 {0.9679705625954683201328521136019844561815,-0.2510637169098963172864102944004116579890}
#define T_6561_266 {0.9677296859272304097032701974967494606972,-0.2519905850923483958681003969104494899511}
#define T_6561_268 {0.9672452702798021162422514862555544823408,-0.2538436273010465926702750039112288504839}
#define T_6561_269 {0.9670017317448723614958794314588885754347,-0.2547697996278561194394285394082544371486}
#define T_6561_271 {0.9665119943693349924274116347078233957291,-0.2566214424794049930866890463221352547407}
#define T_6561_272 {0.9662657959778685468066328212444204837084,-0.2575469113059912218410829609638312831521}
#define T_6561_274 {0.9657707409164902889742165825737174600363,-0.2593971395170219795822674768714932724833}
#define T_6561_275 {0.9655218847005965221441670109925325959921,-0.2603218972046107970719219792954390868545}
#define T_6561_277 {0.9650215160395374525137413002084940671921,-0.2621706955034309172170026158710243180394}
#define T_6561_278 {0.9647700040532634080392426767502911388874,-0.2630947344191179038119798860861919820309}
#define T_6561_280 {0.9642643259225417429192361851164605468512,-0.2649420875458373680899626378959510475397}
#define T_6561_281 {0.9640101602418548187856117692717816680670,-0.2658654000626508584481655361742014065385}
#define T_6561_283 {0.9634991768153130520246918422344606369734,-0.2677112927693079957869315421703504398465}
#define T_6561_284 {0.9632423595380842362700946068798657506704,-0.2686338712662719729884486241644481197000}
#define T_6561_286 {0.9627260750333543892764964766683988273144,-0.2704782883169593032945954291790258139372}
#define T_6561_287 {0.9624666082793409405127249556244350969791,-0.2714001251791562929760459610406542196870}
#define T_6561_289 {0.9619450269578097012512785113358404487371,-0.2732430513501463709147287772793788462877}
#define T_6561_290 {0.9616829128686373850953827968623954802752,-0.2741641389687803909147589820349821820855}
#define T_6561_292 {0.9611560390354114691291442795773036777973,-0.2760055590486513721337757942819735035300}
#define T_6561_293 {0.9608912797745571277019394074159208685160,-0.2769258898211106045827989419194636866450}
#define T_6561_295 {0.9603591177784269738992861675797030329704,-0.2787657886108719229589780752576189115644}
#define T_6561_296 {0.9600917155312004291900507269019726663828,-0.2796853549407914418800658040709095075727}
#define T_6561_298 {0.9595542697646052276994055318937171250582,-0.2815237172540091536987461040553171187639}
#define T_6561_299 {0.9592842267381314069751852002809755504131,-0.2824425115513338746531246670201653614640}
#define T_6561_301 {0.9587415016371217957313888291537296026945,-0.2842793222142560027876356798515189439058}
#define T_6561_302 {0.9584688200603226349016949825454503297806,-0.2851973368953029663863674159074435010552}
#define T_6561_304 {0.9579208201045249504446132959856186062098,-0.2870325807469848444775095686054555699229}
#define T_6561_305 {0.9576455022281006312923068435338791459799,-0.2879498082345062215381403802894055843353}
#define T_6561_307 {0.9570922319406794942509009160858113318682,-0.2897834701269354495956065420614322647452}
#define T_6561_308 {0.9568142800370903477968909101036842912436,-0.2906999028501807136315449042740510776639}
#define T_6561_310 {0.9562557439847114704178920874255709350109,-0.2925319676484024467022493354306789115071}
#define T_6561_311 {0.9559751603481586590405072456633206456900,-0.2934475980431809905013551542651839554310}
#define T_6561_313 {0.9554113631409510976055798892048187553883,-0.2952780506254226722262501425575464963913}
#define T_6561_314 {0.9551281500873581853383598172513302415609,-0.2961928711341664244294236141286091879010}
#define T_6561_316 {0.9545590963788762595143566613842267543077,-0.2980216963919626316226185736013576388359}
#define T_6561_317 {0.9542732562458698941654233749432023614645,-0.2989356994637881181908767302957130596042}
#define T_6561_319 {0.9536989507330549953323384215764235705137,-0.3007628823021052388853036063665058463812}
#define T_6561_320 {0.9534104858799454795814654062269255518913,-0.3016760603928761441672179444140056148171}
#define T_6561_322 {0.9528309333030868799596646567806601524353,-0.3035015857302371111714478502108249813318}
#define T_6561_323 {0.9525398461108489644999508527689613401890,-0.3044139313026265059036745697085279971361}
#define T_6561_325 {0.9519550512535450703666128902113996446133,-0.3062377840712351417806758036022074520588}
#define T_6561_326 {0.9516613441247980809123419021489098668098,-0.3071492895947876000661835860228165984154}
#define T_6561_328 {0.9510713118139167976394787729077506810427,-0.3089714547406529621120796491595683619380}
#define T_6561_329 {0.9507749871729048729562805419845972210169,-0.3098821126918469004429823598911752924323}
#define T_6561_331 {0.9501797222785439700487586378585547208786,-0.3117025751749076811769612049829447641969}
#define T_6561_332 {0.9498807825711161889614686515415087342262,-0.3126123780372170868346870520326774567366}
#define T_6561_334 {0.9492802900065626658943074289709329605103,-0.3144311228314656814220029446005355566740}
#define T_6561_335 {0.9489787377001525081610111556074116379023,-0.3153400630954226735447321061656111851335}
#define T_6561_337 {0.9483730224218425153281941675231792032719,-0.3171570751890291361974050232674926519394}
#define T_6561_338 {0.9480688600054478776257838035235181450844,-0.3180651453522855276467851126653840765357}
#define T_6561_340 {0.9474579270129253050214401810080744326115,-0.3198804097477215835354513728816527873278}
#define T_6561_341 {0.9471511569970878507973566229338757693768,-0.3207876023151109978748252160585252568126}
#define T_6561_343 {0.9465350113329636938530597944918554276228,-0.3226011040292737774848319531884044408798}
#define T_6561_344 {0.9462256362497479811324296861130278557539,-0.3235074115128734328905579786805901676416}
#define T_6561_346 {0.9456042829996580412199591592070646584034,-0.3253191355772091508669063841807655990124}
#define T_6561_347 {0.9452923054026307614350344010745175182819,-0.3262245504964017550619814755918923765421}
#define T_6561_349 {0.944665749695