#ifndef CUFFTDX_FFT_81_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_81_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<509, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<12>;
.reg .f64 fd<383>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 1296, r2;
add.f64 fd37, %28, %36;
add.f64 fd38, %20, fd37;
add.f64 fd39, %29, %37;
add.f64 fd40, %21, fd39;
mul.f64 fd41, fd37, 0d3FE0000000000000;
sub.f64 fd42, %20, fd41;
sub.f64 fd43, %29, %37;
mul.f64 fd44, fd43, 0d3FEBB67AE8584CAA;
add.f64 fd45, fd44, fd42;
sub.f64 fd46, fd42, fd44;
mul.f64 fd47, fd39, 0d3FE0000000000000;
sub.f64 fd48, %21, fd47;
sub.f64 fd49, %28, %36;
mul.f64 fd50, fd49, 0d3FEBB67AE8584CAA;
sub.f64 fd51, fd48, fd50;
add.f64 fd52, fd50, fd48;
add.f64 fd53, %30, %38;
add.f64 fd54, %22, fd53;
add.f64 fd55, %32, %40;
add.f64 fd56, %24, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, %22, fd57;
sub.f64 fd59, %32, %40;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, %24, fd63;
sub.f64 fd65, %30, %38;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
add.f64 fd69, %33, %41;
add.f64 fd70, %25, fd69;
add.f64 fd71, %35, %42;
add.f64 fd72, %27, fd71;
mul.f64 fd73, fd69, 0d3FE0000000000000;
sub.f64 fd74, %25, fd73;
sub.f64 fd75, %35, %42;
mul.f64 fd76, fd75, 0d3FEBB67AE8584CAA;
add.f64 fd77, fd76, fd74;
sub.f64 fd78, fd74, fd76;
mul.f64 fd79, fd71, 0d3FE0000000000000;
sub.f64 fd80, %27, fd79;
sub.f64 fd81, %33, %41;
mul.f64 fd82, fd81, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd80, fd82;
add.f64 fd84, fd82, fd80;
mov.u32 r4, %tid.x;
mul.f64 fd85, fd61, 0d3FE8836FA2CF5039;
mul.f64 fd86, fd67, 0dBFE491B7523C161D;
sub.f64 fd87, fd85, fd86;
mul.f64 fd88, fd67, 0d3FE8836FA2CF5039;
fma.rn.f64 fd89, fd61, 0dBFE491B7523C161D, fd88;
mul.f64 fd90, fd77, 0d3FC63A1A7E0B738A;
mul.f64 fd91, fd83, 0dBFEF838B8C811C17;
sub.f64 fd92, fd90, fd91;
mul.f64 fd93, fd83, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd94, fd77, 0dBFEF838B8C811C17, fd93;
mul.f64 fd95, fd62, 0d3FC63A1A7E0B738A;
mul.f64 fd96, fd68, 0dBFEF838B8C811C17;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd68, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd99, fd62, 0dBFEF838B8C811C17, fd98;
mul.f64 fd100, fd78, 0dBFEE11F642522D1C;
mul.f64 fd101, fd84, 0dBFD5E3A8748A0BF5;
sub.f64 fd102, fd100, fd101;
mul.f64 fd103, fd84, 0dBFEE11F642522D1C;
fma.rn.f64 fd104, fd78, 0dBFD5E3A8748A0BF5, fd103;
add.f64 fd105, fd54, fd70;
add.f64 fd106, fd56, fd72;
mul.f64 fd107, fd105, 0d3FE0000000000000;
sub.f64 fd108, fd38, fd107;
sub.f64 fd109, fd56, fd72;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd106, 0d3FE0000000000000;
sub.f64 fd114, fd40, fd113;
sub.f64 fd115, fd54, fd70;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
add.f64 fd119, fd87, fd92;
add.f64 fd120, fd45, fd119;
add.f64 fd121, fd89, fd94;
add.f64 fd122, fd51, fd121;
mul.f64 fd123, fd119, 0d3FE0000000000000;
sub.f64 fd124, fd45, fd123;
sub.f64 fd125, fd89, fd94;
mul.f64 fd126, fd125, 0d3FEBB67AE8584CAA;
add.f64 fd127, fd126, fd124;
sub.f64 fd128, fd124, fd126;
mul.f64 fd129, fd121, 0d3FE0000000000000;
sub.f64 fd130, fd51, fd129;
sub.f64 fd131, fd87, fd92;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
sub.f64 fd133, fd130, fd132;
add.f64 fd134, fd132, fd130;
add.f64 fd135, fd97, fd102;
add.f64 fd136, fd46, fd135;
add.f64 fd137, fd99, fd104;
add.f64 fd138, fd52, fd137;
mul.f64 fd139, fd135, 0d3FE0000000000000;
sub.f64 fd140, fd46, fd139;
sub.f64 fd141, fd99, fd104;
mul.f64 fd142, fd141, 0d3FEBB67AE8584CAA;
add.f64 fd143, fd142, fd140;
sub.f64 fd144, fd140, fd142;
mul.f64 fd145, fd137, 0d3FE0000000000000;
sub.f64 fd146, fd52, fd145;
sub.f64 fd147, fd97, fd102;
mul.f64 fd148, fd147, 0d3FEBB67AE8584CAA;
sub.f64 fd149, fd146, fd148;
add.f64 fd150, fd148, fd146;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 9;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1296, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd151, fd152}, [rd6];
mul.f64 fd155, fd151, fd120;
mul.f64 fd156, fd152, fd122;
mul.f64 fd157, fd151, fd122;
mul.f64 fd158, fd151, fd151;
mul.f64 fd159, fd152, fd152;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd152, fd151;
fma.rn.f64 fd162, fd152, fd151, fd161;
mul.f64 fd163, fd160, fd136;
mul.f64 fd164, fd162, fd138;
mul.f64 fd165, fd160, fd138;
mul.f64 fd166, fd151, fd160;
mul.f64 fd167, fd152, fd162;
sub.f64 fd168, fd166, fd167;
mul.f64 fd169, fd151, fd162;
fma.rn.f64 fd170, fd152, fd160, fd169;
mul.f64 fd171, fd168, fd111;
mul.f64 fd172, fd170, fd117;
mul.f64 fd173, fd168, fd117;
mul.f64 fd174, fd151, fd168;
mul.f64 fd175, fd152, fd170;
sub.f64 fd176, fd174, fd175;
mul.f64 fd177, fd151, fd170;
fma.rn.f64 fd178, fd152, fd168, fd177;
mul.f64 fd179, fd176, fd127;
mul.f64 fd180, fd178, fd133;
mul.f64 fd181, fd176, fd133;
ld.global.v2.f64 {fd182, fd183}, [rd6+144];
mul.f64 fd186, fd182, fd143;
mul.f64 fd187, fd183, fd149;
mul.f64 fd188, fd182, fd149;
mul.f64 fd189, fd151, fd182;
mul.f64 fd190, fd152, fd183;
sub.f64 fd191, fd189, fd190;
mul.f64 fd192, fd151, fd183;
fma.rn.f64 fd193, fd152, fd182, fd192;
mul.f64 fd194, fd191, fd112;
mul.f64 fd195, fd193, fd118;
mul.f64 fd196, fd191, fd118;
mul.f64 fd197, fd151, fd191;
mul.f64 fd198, fd152, fd193;
sub.f64 fd199, fd197, fd198;
mul.f64 fd200, fd151, fd193;
fma.rn.f64 fd201, fd152, fd191, fd200;
mul.f64 fd202, fd199, fd128;
mul.f64 fd203, fd201, fd134;
mul.f64 fd204, fd199, fd134;
mul.f64 fd205, fd151, fd199;
mul.f64 fd206, fd152, fd201;
sub.f64 fd207, fd205, fd206;
mul.f64 fd208, fd151, fd201;
fma.rn.f64 fd209, fd152, fd199, fd208;
mul.f64 fd210, fd207, fd144;
mul.f64 fd211, fd209, fd150;
mul.f64 fd212, fd207, fd150;
barrier.sync 0;
mad.lo.s32 r9, r7, 144, r8;
add.f64 fd213, fd40, fd106;
add.f64 fd214, fd38, fd105;
st.shared.v2.f64 [r9], {fd214, fd213};
fma.rn.f64 fd215, fd152, fd120, fd157;
sub.f64 fd216, fd155, fd156;
st.shared.v2.f64 [r9+16], {fd216, fd215};
fma.rn.f64 fd217, fd162, fd136, fd165;
sub.f64 fd218, fd163, fd164;
st.shared.v2.f64 [r9+32], {fd218, fd217};
sub.f64 fd219, fd171, fd172;
fma.rn.f64 fd220, fd170, fd111, fd173;
st.shared.v2.f64 [r9+48], {fd219, fd220};
fma.rn.f64 fd221, fd178, fd127, fd181;
sub.f64 fd222, fd179, fd180;
st.shared.v2.f64 [r9+64], {fd222, fd221};
fma.rn.f64 fd223, fd183, fd143, fd188;
sub.f64 fd224, fd186, fd187;
st.shared.v2.f64 [r9+80], {fd224, fd223};
fma.rn.f64 fd225, fd193, fd112, fd196;
sub.f64 fd226, fd194, fd195;
st.shared.v2.f64 [r9+96], {fd226, fd225};
fma.rn.f64 fd227, fd201, fd128, fd204;
sub.f64 fd228, fd202, fd203;
st.shared.v2.f64 [r9+112], {fd228, fd227};
fma.rn.f64 fd229, fd209, fd144, fd212;
sub.f64 fd230, fd210, fd211;
st.shared.v2.f64 [r9+128], {fd230, fd229};
barrier.sync 0;
shl.b32 r10, r7, 7;
sub.s32 r11, r9, r10;
ld.shared.v2.f64 {fd231, fd232}, [r11];
ld.shared.v2.f64 {fd235, fd236}, [r11+144];
ld.shared.v2.f64 {fd239, fd240}, [r11+288];
ld.shared.v2.f64 {fd243, fd244}, [r11+432];
ld.shared.v2.f64 {fd247, fd248}, [r11+576];
ld.shared.v2.f64 {fd251, fd252}, [r11+720];
ld.shared.v2.f64 {fd255, fd256}, [r11+864];
ld.shared.v2.f64 {fd259, fd260}, [r11+1008];
ld.shared.v2.f64 {fd263, fd264}, [r11+1152];
add.f64 fd267, fd243, fd255;
add.f64 fd268, fd231, fd267;
add.f64 fd269, fd244, fd256;
add.f64 fd270, fd232, fd269;
mul.f64 fd271, fd267, 0d3FE0000000000000;
sub.f64 fd272, fd231, fd271;
sub.f64 fd273, fd244, fd256;
mul.f64 fd274, fd273, 0d3FEBB67AE8584CAA;
add.f64 fd275, fd274, fd272;
sub.f64 fd276, fd272, fd274;
mul.f64 fd277, fd269, 0d3FE0000000000000;
sub.f64 fd278, fd232, fd277;
sub.f64 fd279, fd243, fd255;
mul.f64 fd280, fd279, 0d3FEBB67AE8584CAA;
sub.f64 fd281, fd278, fd280;
add.f64 fd282, fd280, fd278;
add.f64 fd283, fd247, fd259;
add.f64 fd284, fd235, fd283;
add.f64 fd285, fd248, fd260;
add.f64 fd286, fd236, fd285;
mul.f64 fd287, fd283, 0d3FE0000000000000;
sub.f64 fd288, fd235, fd287;
sub.f64 fd289, fd248, fd260;
mul.f64 fd290, fd289, 0d3FEBB67AE8584CAA;
add.f64 fd291, fd290, fd288;
sub.f64 fd292, fd288, fd290;
mul.f64 fd293, fd285, 0d3FE0000000000000;
sub.f64 fd294, fd236, fd293;
sub.f64 fd295, fd247, fd259;
mul.f64 fd296, fd295, 0d3FEBB67AE8584CAA;
sub.f64 fd297, fd294, fd296;
add.f64 fd298, fd296, fd294;
add.f64 fd299, fd251, fd263;
add.f64 fd300, fd239, fd299;
add.f64 fd301, fd252, fd264;
add.f64 fd302, fd240, fd301;
mul.f64 fd303, fd299, 0d3FE0000000000000;
sub.f64 fd304, fd239, fd303;
sub.f64 fd305, fd252, fd264;
mul.f64 fd306, fd305, 0d3FEBB67AE8584CAA;
add.f64 fd307, fd306, fd304;
sub.f64 fd308, fd304, fd306;
mul.f64 fd309, fd301, 0d3FE0000000000000;
sub.f64 fd310, fd240, fd309;
sub.f64 fd311, fd251, fd263;
mul.f64 fd312, fd311, 0d3FEBB67AE8584CAA;
sub.f64 fd313, fd310, fd312;
add.f64 fd314, fd312, fd310;
mul.f64 fd315, fd291, 0d3FE8836FA2CF5039;
mul.f64 fd316, fd297, 0dBFE491B7523C161D;
sub.f64 fd317, fd315, fd316;
mul.f64 fd318, fd297, 0d3FE8836FA2CF5039;
fma.rn.f64 fd319, fd291, 0dBFE491B7523C161D, fd318;
mul.f64 fd320, fd307, 0d3FC63A1A7E0B738A;
mul.f64 fd321, fd313, 0dBFEF838B8C811C17;
sub.f64 fd322, fd320, fd321;
mul.f64 fd323, fd313, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd324, fd307, 0dBFEF838B8C811C17, fd323;
mul.f64 fd325, fd292, 0d3FC63A1A7E0B738A;
mul.f64 fd326, fd298, 0dBFEF838B8C811C17;
sub.f64 fd327, fd325, fd326;
mul.f64 fd328, fd298, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd329, fd292, 0dBFEF838B8C811C17, fd328;
mul.f64 fd330, fd308, 0dBFEE11F642522D1C;
mul.f64 fd331, fd314, 0dBFD5E3A8748A0BF5;
sub.f64 fd332, fd330, fd331;
mul.f64 fd333, fd314, 0dBFEE11F642522D1C;
fma.rn.f64 fd334, fd308, 0dBFD5E3A8748A0BF5, fd333;
add.f64 fd335, fd284, fd300;
add.f64 fd336, fd286, fd302;
mul.f64 fd337, fd335, 0d3FE0000000000000;
sub.f64 fd338, fd268, fd337;
sub.f64 fd339, fd286, fd302;
mul.f64 fd340, fd339, 0d3FEBB67AE8584CAA;
mul.f64 fd341, fd336, 0d3FE0000000000000;
sub.f64 fd342, fd270, fd341;
sub.f64 fd343, fd284, fd300;
mul.f64 fd344, fd343, 0d3FEBB67AE8584CAA;
add.f64 fd345, fd317, fd322;
add.f64 fd346, fd319, fd324;
mul.f64 fd347, fd345, 0d3FE0000000000000;
sub.f64 fd348, fd275, fd347;
sub.f64 fd349, fd319, fd324;
mul.f64 fd350, fd349, 0d3FEBB67AE8584CAA;
mul.f64 fd351, fd346, 0d3FE0000000000000;
sub.f64 fd352, fd281, fd351;
sub.f64 fd353, fd317, fd322;
mul.f64 fd354, fd353, 0d3FEBB67AE8584CAA;
add.f64 fd355, fd327, fd332;
add.f64 fd356, fd329, fd334;
mul.f64 fd357, fd355, 0d3FE0000000000000;
sub.f64 fd358, fd276, fd357;
sub.f64 fd359, fd329, fd334;
mul.f64 fd360, fd359, 0d3FEBB67AE8584CAA;
mul.f64 fd361, fd356, 0d3FE0000000000000;
sub.f64 fd362, fd282, fd361;
sub.f64 fd363, fd327, fd332;
mul.f64 fd364, fd363, 0d3FEBB67AE8584CAA;
add.f64 %1, fd270, fd336;
add.f64 %0, fd268, fd335;
add.f64 %3, fd281, fd346;
add.f64 %2, fd275, fd345;
add.f64 %5, fd282, fd356;
add.f64 %4, fd276, fd355;
sub.f64 %7, fd342, fd344;
add.f64 %6, fd340, fd338;
sub.f64 %9, fd352, fd354;
add.f64 %8, fd350, fd348;
sub.f64 %11, fd362, fd364;
add.f64 %10, fd360, fd358;
add.f64 %13, fd344, fd342;
sub.f64 %12, fd338, fd340;
add.f64 %15, fd354, fd352;
sub.f64 %14, fd348, fd350;
add.f64 %17, fd364, fd362;
sub.f64 %16, fd358, fd360;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y): "r"(smem), "l"(lut_dp_9_81), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<510, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<12>;
.reg .f64 fd<365>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 648, r2;
add.f64 fd37, %28, %36;
add.f64 fd38, %20, fd37;
add.f64 fd39, %29, %37;
add.f64 fd40, %21, fd39;
mul.f64 fd41, fd37, 0d3FE0000000000000;
sub.f64 fd42, %20, fd41;
sub.f64 fd43, %29, %37;
mul.f64 fd44, fd43, 0d3FEBB67AE8584CAA;
add.f64 fd45, fd44, fd42;
sub.f64 fd46, fd42, fd44;
mul.f64 fd47, fd39, 0d3FE0000000000000;
sub.f64 fd48, %21, fd47;
sub.f64 fd49, %28, %36;
mul.f64 fd50, fd49, 0d3FEBB67AE8584CAA;
sub.f64 fd51, fd48, fd50;
add.f64 fd52, fd50, fd48;
add.f64 fd53, %30, %38;
add.f64 fd54, %22, fd53;
add.f64 fd55, %32, %40;
add.f64 fd56, %24, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, %22, fd57;
sub.f64 fd59, %32, %40;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, %24, fd63;
sub.f64 fd65, %30, %38;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
add.f64 fd69, %33, %41;
add.f64 fd70, %25, fd69;
add.f64 fd71, %35, %42;
add.f64 fd72, %27, fd71;
mul.f64 fd73, fd69, 0d3FE0000000000000;
sub.f64 fd74, %25, fd73;
sub.f64 fd75, %35, %42;
mul.f64 fd76, fd75, 0d3FEBB67AE8584CAA;
add.f64 fd77, fd76, fd74;
sub.f64 fd78, fd74, fd76;
mul.f64 fd79, fd71, 0d3FE0000000000000;
sub.f64 fd80, %27, fd79;
sub.f64 fd81, %33, %41;
mul.f64 fd82, fd81, 0d3FEBB67AE8584CAA;
sub.f64 fd83, fd80, fd82;
add.f64 fd84, fd82, fd80;
mov.u32 r4, %tid.x;
mul.f64 fd85, fd61, 0d3FE8836FA2CF5039;
mul.f64 fd86, fd67, 0dBFE491B7523C161D;
sub.f64 fd87, fd85, fd86;
mul.f64 fd88, fd67, 0d3FE8836FA2CF5039;
fma.rn.f64 fd89, fd61, 0dBFE491B7523C161D, fd88;
mul.f64 fd90, fd77, 0d3FC63A1A7E0B738A;
mul.f64 fd91, fd83, 0dBFEF838B8C811C17;
sub.f64 fd92, fd90, fd91;
mul.f64 fd93, fd83, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd94, fd77, 0dBFEF838B8C811C17, fd93;
mul.f64 fd95, fd62, 0d3FC63A1A7E0B738A;
mul.f64 fd96, fd68, 0dBFEF838B8C811C17;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd68, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd99, fd62, 0dBFEF838B8C811C17, fd98;
mul.f64 fd100, fd78, 0dBFEE11F642522D1C;
mul.f64 fd101, fd84, 0dBFD5E3A8748A0BF5;
sub.f64 fd102, fd100, fd101;
mul.f64 fd103, fd84, 0dBFEE11F642522D1C;
fma.rn.f64 fd104, fd78, 0dBFD5E3A8748A0BF5, fd103;
add.f64 fd105, fd54, fd70;
add.f64 fd106, fd38, fd105;
add.f64 fd107, fd56, fd72;
add.f64 fd108, fd40, fd107;
mul.f64 fd109, fd105, 0d3FE0000000000000;
sub.f64 fd110, fd38, fd109;
sub.f64 fd111, fd56, fd72;
mul.f64 fd112, fd111, 0d3FEBB67AE8584CAA;
add.f64 fd113, fd112, fd110;
sub.f64 fd114, fd110, fd112;
mul.f64 fd115, fd107, 0d3FE0000000000000;
sub.f64 fd116, fd40, fd115;
sub.f64 fd117, fd54, fd70;
mul.f64 fd118, fd117, 0d3FEBB67AE8584CAA;
sub.f64 fd119, fd116, fd118;
add.f64 fd120, fd118, fd116;
add.f64 fd121, fd87, fd92;
add.f64 fd122, fd45, fd121;
add.f64 fd123, fd89, fd94;
add.f64 fd124, fd51, fd123;
mul.f64 fd125, fd121, 0d3FE0000000000000;
sub.f64 fd126, fd45, fd125;
sub.f64 fd127, fd89, fd94;
mul.f64 fd128, fd127, 0d3FEBB67AE8584CAA;
add.f64 fd129, fd128, fd126;
sub.f64 fd130, fd126, fd128;
mul.f64 fd131, fd123, 0d3FE0000000000000;
sub.f64 fd132, fd51, fd131;
sub.f64 fd133, fd87, fd92;
mul.f64 fd134, fd133, 0d3FEBB67AE8584CAA;
sub.f64 fd135, fd132, fd134;
add.f64 fd136, fd134, fd132;
add.f64 fd137, fd97, fd102;
add.f64 fd138, fd46, fd137;
add.f64 fd139, fd99, fd104;
add.f64 fd140, fd52, fd139;
mul.f64 fd141, fd137, 0d3FE0000000000000;
sub.f64 fd142, fd46, fd141;
sub.f64 fd143, fd99, fd104;
mul.f64 fd144, fd143, 0d3FEBB67AE8584CAA;
add.f64 fd145, fd144, fd142;
sub.f64 fd146, fd142, fd144;
mul.f64 fd147, fd139, 0d3FE0000000000000;
sub.f64 fd148, fd52, fd147;
sub.f64 fd149, fd97, fd102;
mul.f64 fd150, fd149, 0d3FEBB67AE8584CAA;
sub.f64 fd151, fd148, fd150;
add.f64 fd152, fd150, fd148;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 9;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd153, fd154}, [rd6];
mul.f64 fd157, fd153, fd122;
mul.f64 fd158, fd154, fd124;
sub.f64 fd159, fd157, fd158;
mul.f64 fd160, fd153, fd124;
fma.rn.f64 fd161, fd154, fd122, fd160;
mul.f64 fd162, fd153, fd153;
mul.f64 fd163, fd154, fd154;
sub.f64 fd164, fd162, fd163;
mul.f64 fd165, fd154, fd153;
fma.rn.f64 fd166, fd154, fd153, fd165;
mul.f64 fd167, fd164, fd138;
mul.f64 fd168, fd166, fd140;
sub.f64 fd169, fd167, fd168;
mul.f64 fd170, fd164, fd140;
fma.rn.f64 fd171, fd166, fd138, fd170;
mul.f64 fd172, fd153, fd164;
mul.f64 fd173, fd154, fd166;
sub.f64 fd174, fd172, fd173;
mul.f64 fd175, fd153, fd166;
fma.rn.f64 fd176, fd154, fd164, fd175;
mul.f64 fd177, fd174, fd113;
mul.f64 fd178, fd176, fd119;
sub.f64 fd179, fd177, fd178;
mul.f64 fd180, fd174, fd119;
fma.rn.f64 fd181, fd176, fd113, fd180;
mul.f64 fd182, fd153, fd174;
mul.f64 fd183, fd154, fd176;
sub.f64 fd184, fd182, fd183;
mul.f64 fd185, fd153, fd176;
fma.rn.f64 fd186, fd154, fd174, fd185;
mul.f64 fd187, fd184, fd129;
mul.f64 fd188, fd186, fd135;
sub.f64 fd189, fd187, fd188;
mul.f64 fd190, fd184, fd135;
fma.rn.f64 fd191, fd186, fd129, fd190;
ld.global.v2.f64 {fd192, fd193}, [rd6+144];
mul.f64 fd196, fd192, fd145;
mul.f64 fd197, fd193, fd151;
sub.f64 fd198, fd196, fd197;
mul.f64 fd199, fd192, fd151;
fma.rn.f64 fd200, fd193, fd145, fd199;
mul.f64 fd201, fd153, fd192;
mul.f64 fd202, fd154, fd193;
sub.f64 fd203, fd201, fd202;
mul.f64 fd204, fd153, fd193;
fma.rn.f64 fd205, fd154, fd192, fd204;
mul.f64 fd206, fd203, fd114;
mul.f64 fd207, fd205, fd120;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd203, fd120;
fma.rn.f64 fd210, fd205, fd114, fd209;
mul.f64 fd211, fd153, fd203;
mul.f64 fd212, fd154, fd205;
sub.f64 fd213, fd211, fd212;
mul.f64 fd214, fd153, fd205;
fma.rn.f64 fd215, fd154, fd203, fd214;
mul.f64 fd216, fd213, fd130;
mul.f64 fd217, fd215, fd136;
sub.f64 fd218, fd216, fd217;
mul.f64 fd219, fd213, fd136;
fma.rn.f64 fd220, fd215, fd130, fd219;
mul.f64 fd221, fd153, fd213;
mul.f64 fd222, fd154, fd215;
sub.f64 fd223, fd221, fd222;
mul.f64 fd224, fd153, fd215;
fma.rn.f64 fd225, fd154, fd213, fd224;
mul.f64 fd226, fd223, fd146;
mul.f64 fd227, fd225, fd152;
sub.f64 fd228, fd226, fd227;
mul.f64 fd229, fd223, fd152;
fma.rn.f64 fd230, fd225, fd146, fd229;
mad.lo.s32 r8, r5, 648, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 72, r8;
st.shared.f64 [r9], fd106;
st.shared.f64 [r9+8], fd159;
st.shared.f64 [r9+16], fd169;
st.shared.f64 [r9+24], fd179;
st.shared.f64 [r9+32], fd189;
st.shared.f64 [r9+40], fd198;
st.shared.f64 [r9+48], fd208;
st.shared.f64 [r9+56], fd218;
st.shared.f64 [r9+64], fd228;
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.f64 fd231, [r11];
ld.shared.f64 fd232, [r11+72];
ld.shared.f64 fd233, [r11+144];
ld.shared.f64 fd234, [r11+216];
ld.shared.f64 fd235, [r11+288];
ld.shared.f64 fd236, [r11+360];
ld.shared.f64 fd237, [r11+432];
ld.shared.f64 fd238, [r11+504];
ld.shared.f64 fd239, [r11+576];
barrier.sync 0;
st.shared.f64 [r9], fd108;
st.shared.f64 [r9+8], fd161;
st.shared.f64 [r9+16], fd171;
st.shared.f64 [r9+24], fd181;
st.shared.f64 [r9+32], fd191;
st.shared.f64 [r9+40], fd200;
st.shared.f64 [r9+48], fd210;
st.shared.f64 [r9+56], fd220;
st.shared.f64 [r9+64], fd230;
barrier.sync 0;
ld.shared.f64 fd240, [r11];
ld.shared.f64 fd241, [r11+72];
ld.shared.f64 fd242, [r11+144];
ld.shared.f64 fd243, [r11+216];
ld.shared.f64 fd244, [r11+288];
ld.shared.f64 fd245, [r11+360];
ld.shared.f64 fd246, [r11+432];
ld.shared.f64 fd247, [r11+504];
ld.shared.f64 fd248, [r11+576];
add.f64 fd249, fd234, fd237;
add.f64 fd250, fd231, fd249;
add.f64 fd251, fd243, fd246;
add.f64 fd252, fd240, fd251;
mul.f64 fd253, fd249, 0d3FE0000000000000;
sub.f64 fd254, fd231, fd253;
sub.f64 fd255, fd243, fd246;
mul.f64 fd256, fd255, 0d3FEBB67AE8584CAA;
add.f64 fd257, fd256, fd254;
sub.f64 fd258, fd254, fd256;
mul.f64 fd259, fd251, 0d3FE0000000000000;
sub.f64 fd260, fd240, fd259;
sub.f64 fd261, fd234, fd237;
mul.f64 fd262, fd261, 0d3FEBB67AE8584CAA;
sub.f64 fd263, fd260, fd262;
add.f64 fd264, fd262, fd260;
add.f64 fd265, fd235, fd238;
add.f64 fd266, fd232, fd265;
add.f64 fd267, fd244, fd247;
add.f64 fd268, fd241, fd267;
mul.f64 fd269, fd265, 0d3FE0000000000000;
sub.f64 fd270, fd232, fd269;
sub.f64 fd271, fd244, fd247;
mul.f64 fd272, fd271, 0d3FEBB67AE8584CAA;
add.f64 fd273, fd272, fd270;
sub.f64 fd274, fd270, fd272;
mul.f64 fd275, fd267, 0d3FE0000000000000;
sub.f64 fd276, fd241, fd275;
sub.f64 fd277, fd235, fd238;
mul.f64 fd278, fd277, 0d3FEBB67AE8584CAA;
sub.f64 fd279, fd276, fd278;
add.f64 fd280, fd278, fd276;
add.f64 fd281, fd236, fd239;
add.f64 fd282, fd233, fd281;
add.f64 fd283, fd245, fd248;
add.f64 fd284, fd242, fd283;
mul.f64 fd285, fd281, 0d3FE0000000000000;
sub.f64 fd286, fd233, fd285;
sub.f64 fd287, fd245, fd248;
mul.f64 fd288, fd287, 0d3FEBB67AE8584CAA;
add.f64 fd289, fd288, fd286;
sub.f64 fd290, fd286, fd288;
mul.f64 fd291, fd283, 0d3FE0000000000000;
sub.f64 fd292, fd242, fd291;
sub.f64 fd293, fd236, fd239;
mul.f64 fd294, fd293, 0d3FEBB67AE8584CAA;
sub.f64 fd295, fd292, fd294;
add.f64 fd296, fd294, fd292;
mul.f64 fd297, fd273, 0d3FE8836FA2CF5039;
mul.f64 fd298, fd279, 0dBFE491B7523C161D;
sub.f64 fd299, fd297, fd298;
mul.f64 fd300, fd279, 0d3FE8836FA2CF5039;
fma.rn.f64 fd301, fd273, 0dBFE491B7523C161D, fd300;
mul.f64 fd302, fd289, 0d3FC63A1A7E0B738A;
mul.f64 fd303, fd295, 0dBFEF838B8C811C17;
sub.f64 fd304, fd302, fd303;
mul.f64 fd305, fd295, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd306, fd289, 0dBFEF838B8C811C17, fd305;
mul.f64 fd307, fd274, 0d3FC63A1A7E0B738A;
mul.f64 fd308, fd280, 0dBFEF838B8C811C17;
sub.f64 fd309, fd307, fd308;
mul.f64 fd310, fd280, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd311, fd274, 0dBFEF838B8C811C17, fd310;
mul.f64 fd312, fd290, 0dBFEE11F642522D1C;
mul.f64 fd313, fd296, 0dBFD5E3A8748A0BF5;
sub.f64 fd314, fd312, fd313;
mul.f64 fd315, fd296, 0dBFEE11F642522D1C;
fma.rn.f64 fd316, fd290, 0dBFD5E3A8748A0BF5, fd315;
add.f64 fd317, fd266, fd282;
add.f64 fd318, fd268, fd284;
mul.f64 fd319, fd317, 0d3FE0000000000000;
sub.f64 fd320, fd250, fd319;
sub.f64 fd321, fd268, fd284;
mul.f64 fd322, fd321, 0d3FEBB67AE8584CAA;
mul.f64 fd323, fd318, 0d3FE0000000000000;
sub.f64 fd324, fd252, fd323;
sub.f64 fd325, fd266, fd282;
mul.f64 fd326, fd325, 0d3FEBB67AE8584CAA;
add.f64 fd327, fd299, fd304;
add.f64 fd328, fd301, fd306;
mul.f64 fd329, fd327, 0d3FE0000000000000;
sub.f64 fd330, fd257, fd329;
sub.f64 fd331, fd301, fd306;
mul.f64 fd332, fd331, 0d3FEBB67AE8584CAA;
mul.f64 fd333, fd328, 0d3FE0000000000000;
sub.f64 fd334, fd263, fd333;
sub.f64 fd335, fd299, fd304;
mul.f64 fd336, fd335, 0d3FEBB67AE8584CAA;
add.f64 fd337, fd309, fd314;
add.f64 fd338, fd311, fd316;
mul.f64 fd339, fd337, 0d3FE0000000000000;
sub.f64 fd340, fd258, fd339;
sub.f64 fd341, fd311, fd316;
mul.f64 fd342, fd341, 0d3FEBB67AE8584CAA;
mul.f64 fd343, fd338, 0d3FE0000000000000;
sub.f64 fd344, fd264, fd343;
sub.f64 fd345, fd309, fd314;
mul.f64 fd346, fd345, 0d3FEBB67AE8584CAA;
add.f64 %0, fd250, fd317;
add.f64 %1, fd252, fd318;
add.f64 %3, fd263, fd328;
add.f64 %2, fd257, fd327;
add.f64 %5, fd264, fd338;
add.f64 %4, fd258, fd337;
add.f64 %6, fd322, fd320;
sub.f64 %7, fd324, fd326;
sub.f64 %9, fd334, fd336;
add.f64 %8, fd332, fd330;
sub.f64 %11, fd344, fd346;
add.f64 %10, fd342, fd340;
sub.f64 %12, fd320, fd322;
add.f64 %13, fd326, fd324;
add.f64 %15, fd336, fd334;
sub.f64 %14, fd330, fd332;
add.f64 %17, fd346, fd344;
sub.f64 %16, fd340, fd342;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y): "r"(smem), "l"(lut_dp_9_81), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<512, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<14>;
.reg .f64 fd<1383>;
.reg .b64 rd<11>;
mov.u32 r12, %tid.y;
mov.u32 r13, %54;
mad.lo.s32 r3, r12, 1296, r13;
add.f64 fd109, %74, %92;
add.f64 fd110, %56, fd109;
mul.f64 fd113, fd109, 0d3FE0000000000000;
sub.f64 fd114, %56, fd113;
add.f64 fd1382, %75, %93;
sub.f64 fd115, %75, %93;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
add.f64 fd117, fd116, fd114;
sub.f64 fd118, fd114, fd116;
add.f64 fd1381, %57, fd1382;
mul.f64 fd119, fd1382, 0d3FE0000000000000;
sub.f64 fd120, %57, fd119;
sub.f64 fd121, %74, %92;
mul.f64 fd122, fd121, 0d3FEBB67AE8584CAA;
sub.f64 fd123, fd120, fd122;
add.f64 fd124, fd122, fd120;
add.f64 fd125, %80, %98;
add.f64 fd126, %62, fd125;
mul.f64 fd129, fd125, 0d3FE0000000000000;
sub.f64 fd130, %62, fd129;
add.f64 fd1380, %81, %99;
sub.f64 fd131, %81, %99;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
add.f64 fd133, fd132, fd130;
sub.f64 fd134, fd130, fd132;
add.f64 fd1379, %63, fd1380;
mul.f64 fd135, fd1380, 0d3FE0000000000000;
sub.f64 fd136, %63, fd135;
sub.f64 fd137, %80, %98;
mul.f64 fd138, fd137, 0d3FEBB67AE8584CAA;
sub.f64 fd139, fd136, fd138;
add.f64 fd140, fd138, fd136;
add.f64 fd141, %86, %104;
add.f64 fd142, %68, fd141;
mul.f64 fd145, fd141, 0d3FE0000000000000;
sub.f64 fd146, %68, fd145;
add.f64 fd1378, %87, %105;
sub.f64 fd147, %87, %105;
mul.f64 fd148, fd147, 0d3FEBB67AE8584CAA;
add.f64 fd149, fd148, fd146;
sub.f64 fd150, fd146, fd148;
add.f64 fd1377, %69, fd1378;
mul.f64 fd151, fd1378, 0d3FE0000000000000;
sub.f64 fd152, %69, fd151;
sub.f64 fd153, %86, %104;
mul.f64 fd154, fd153, 0d3FEBB67AE8584CAA;
sub.f64 fd155, fd152, fd154;
add.f64 fd156, fd154, fd152;
mul.f64 fd158, fd139, 0dBFE491B7523C161D;
mul.f64 fd1376, fd133, 0d3FE8836FA2CF5039;
sub.f64 fd159, fd1376, fd158;
mul.f64 fd160, fd139, 0d3FE8836FA2CF5039;
fma.rn.f64 fd161, fd133, 0dBFE491B7523C161D, fd160;
mul.f64 fd1374, fd149, 0d3FC63A1A7E0B738A;
mul.f64 fd1375, fd155, 0dBFEF838B8C811C17;
sub.f64 fd164, fd1374, fd1375;
mul.f64 fd165, fd155, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd166, fd149, 0dBFEF838B8C811C17, fd165;
mul.f64 fd1372, fd134, 0d3FC63A1A7E0B738A;
mul.f64 fd1373, fd140, 0dBFEF838B8C811C17;
sub.f64 fd169, fd1372, fd1373;
mul.f64 fd170, fd140, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd171, fd134, 0dBFEF838B8C811C17, fd170;
mul.f64 fd1370, fd150, 0dBFEE11F642522D1C;
mul.f64 fd1371, fd156, 0dBFD5E3A8748A0BF5;
sub.f64 fd174, fd1370, fd1371;
mul.f64 fd175, fd156, 0dBFEE11F642522D1C;
fma.rn.f64 fd176, fd150, 0dBFD5E3A8748A0BF5, fd175;
add.f64 fd177, fd126, fd142;
add.f64 fd178, fd110, fd177;
mul.f64 fd181, fd177, 0d3FE0000000000000;
sub.f64 fd182, fd110, fd181;
add.f64 fd1369, fd1379, fd1377;
sub.f64 fd183, fd1379, fd1377;
mul.f64 fd184, fd183, 0d3FEBB67AE8584CAA;
add.f64 fd185, fd184, fd182;
sub.f64 fd186, fd182, fd184;
add.f64 fd1368, fd1381, fd1369;
mul.f64 fd187, fd1369, 0d3FE0000000000000;
sub.f64 fd188, fd1381, fd187;
sub.f64 fd189, fd126, fd142;
mul.f64 fd190, fd189, 0d3FEBB67AE8584CAA;
sub.f64 fd191, fd188, fd190;
add.f64 fd192, fd190, fd188;
add.f64 fd193, fd159, fd164;
add.f64 fd194, fd117, fd193;
mul.f64 fd197, fd193, 0d3FE0000000000000;
sub.f64 fd198, fd117, fd197;
add.f64 fd1367, fd161, fd166;
sub.f64 fd199, fd161, fd166;
mul.f64 fd200, fd199, 0d3FEBB67AE8584CAA;
add.f64 fd201, fd200, fd198;
sub.f64 fd202, fd198, fd200;
add.f64 fd1366, fd123, fd1367;
mul.f64 fd203, fd1367, 0d3FE0000000000000;
sub.f64 fd204, fd123, fd203;
sub.f64 fd205, fd159, fd164;
mul.f64 fd206, fd205, 0d3FEBB67AE8584CAA;
sub.f64 fd207, fd204, fd206;
add.f64 fd208, fd206, fd204;
add.f64 fd209, fd169, fd174;
add.f64 fd210, fd118, fd209;
mul.f64 fd213, fd209, 0d3FE0000000000000;
sub.f64 fd214, fd118, fd213;
add.f64 fd1365, fd171, fd176;
sub.f64 fd215, fd171, fd176;
mul.f64 fd216, fd215, 0d3FEBB67AE8584CAA;
add.f64 fd217, fd216, fd214;
sub.f64 fd218, fd214, fd216;
add.f64 fd1364, fd124, fd1365;
mul.f64 fd219, fd1365, 0d3FE0000000000000;
sub.f64 fd220, fd124, fd219;
sub.f64 fd221, fd169, fd174;
mul.f64 fd222, fd221, 0d3FEBB67AE8584CAA;
sub.f64 fd223, fd220, fd222;
add.f64 fd224, fd222, fd220;
add.f64 fd225, %76, %94;
add.f64 fd226, %58, fd225;
mul.f64 fd229, fd225, 0d3FE0000000000000;
sub.f64 fd230, %58, fd229;
add.f64 fd1361, %111, %110;
sub.f64 fd231, %111, %110;
mul.f64 fd232, fd231, 0d3FEBB67AE8584CAA;
add.f64 fd233, fd232, fd230;
sub.f64 fd234, fd230, fd232;
add.f64 fd1359, %112, fd1361;
mul.f64 fd235, fd1361, 0d3FE0000000000000;
sub.f64 fd236, %112, fd235;
sub.f64 fd237, %76, %94;
mul.f64 fd238, fd237, 0d3FEBB67AE8584CAA;
sub.f64 fd239, fd236, fd238;
add.f64 fd240, fd238, fd236;
add.f64 fd241, %82, %100;
add.f64 fd242, %64, fd241;
mul.f64 fd245, fd241, 0d3FE0000000000000;
sub.f64 fd246, %64, fd245;
add.f64 fd1356, %114, %113;
sub.f64 fd247, %114, %113;
mul.f64 fd248, fd247, 0d3FEBB67AE8584CAA;
add.f64 fd249, fd248, fd246;
sub.f64 fd250, fd246, fd248;
add.f64 fd1354, %115, fd1356;
mul.f64 fd251, fd1356, 0d3FE0000000000000;
sub.f64 fd252, %115, fd251;
sub.f64 fd253, %82, %100;
mul.f64 fd254, fd253, 0d3FEBB67AE8584CAA;
sub.f64 fd255, fd252, fd254;
add.f64 fd256, fd254, fd252;
add.f64 fd257, %88, %106;
add.f64 fd258, %70, fd257;
mul.f64 fd261, fd257, 0d3FE0000000000000;
sub.f64 fd262, %70, fd261;
add.f64 fd1351, %116, %117;
sub.f64 fd263, %116, %117;
mul.f64 fd264, fd263, 0d3FEBB67AE8584CAA;
add.f64 fd265, fd264, fd262;
sub.f64 fd266, fd262, fd264;
add.f64 fd1349, %118, fd1351;
mul.f64 fd267, fd1351, 0d3FE0000000000000;
sub.f64 fd268, %118, fd267;
sub.f64 fd269, %88, %106;
mul.f64 fd270, fd269, 0d3FEBB67AE8584CAA;
sub.f64 fd271, fd268, fd270;
add.f64 fd272, fd270, fd268;
mul.f64 fd274, fd255, 0dBFE491B7523C161D;
mul.f64 fd1348, fd249, 0d3FE8836FA2CF5039;
sub.f64 fd275, fd1348, fd274;
mul.f64 fd276, fd255, 0d3FE8836FA2CF5039;
fma.rn.f64 fd277, fd249, 0dBFE491B7523C161D, fd276;
mul.f64 fd279, fd271, 0dBFEF838B8C811C17;
mul.f64 fd1347, fd265, 0d3FC63A1A7E0B738A;
sub.f64 fd280, fd1347, fd279;
mul.f64 fd281, fd271, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd282, fd265, 0dBFEF838B8C811C17, fd281;
mul.f64 fd1345, fd250, 0d3FC63A1A7E0B738A;
mul.f64 fd1346, fd256, 0dBFEF838B8C811C17;
sub.f64 fd285, fd1345, fd1346;
mul.f64 fd286, fd256, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd287, fd250, 0dBFEF838B8C811C17, fd286;
mul.f64 fd1343, fd266, 0dBFEE11F642522D1C;
mul.f64 fd1344, fd272, 0dBFD5E3A8748A0BF5;
sub.f64 fd290, fd1343, fd1344;
mul.f64 fd291, fd272, 0dBFEE11F642522D1C;
fma.rn.f64 fd292, fd266, 0dBFD5E3A8748A0BF5, fd291;
add.f64 fd293, fd242, fd258;
add.f64 fd294, fd226, fd293;
mul.f64 fd297, fd293, 0d3FE0000000000000;
sub.f64 fd298, fd226, fd297;
add.f64 fd1342, fd1354, fd1349;
sub.f64 fd299, fd1354, fd1349;
mul.f64 fd300, fd299, 0d3FEBB67AE8584CAA;
add.f64 fd301, fd300, fd298;
sub.f64 fd302, fd298, fd300;
add.f64 fd1341, fd1359, fd1342;
mul.f64 fd303, fd1342, 0d3FE0000000000000;
sub.f64 fd304, fd1359, fd303;
sub.f64 fd305, fd242, fd258;
mul.f64 fd306, fd305, 0d3FEBB67AE8584CAA;
sub.f64 fd307, fd304, fd306;
add.f64 fd308, fd306, fd304;
add.f64 fd309, fd275, fd280;
add.f64 fd310, fd233, fd309;
mul.f64 fd313, fd309, 0d3FE0000000000000;
sub.f64 fd314, fd233, fd313;
add.f64 fd1340, fd277, fd282;
sub.f64 fd315, fd277, fd282;
mul.f64 fd316, fd315, 0d3FEBB67AE8584CAA;
add.f64 fd317, fd316, fd314;
sub.f64 fd318, fd314, fd316;
add.f64 fd1339, fd239, fd1340;
mul.f64 fd319, fd1340, 0d3FE0000000000000;
sub.f64 fd320, fd239, fd319;
sub.f64 fd321, fd275, fd280;
mul.f64 fd322, fd321, 0d3FEBB67AE8584CAA;
sub.f64 fd323, fd320, fd322;
add.f64 fd324, fd322, fd320;
add.f64 fd325, fd285, fd290;
add.f64 fd326, fd234, fd325;
mul.f64 fd329, fd325, 0d3FE0000000000000;
sub.f64 fd330, fd234, fd329;
add.f64 fd1338, fd287, fd292;
sub.f64 fd331, fd287, fd292;
mul.f64 fd332, fd331, 0d3FEBB67AE8584CAA;
add.f64 fd333, fd332, fd330;
sub.f64 fd334, fd330, fd332;
add.f64 fd1337, fd240, fd1338;
mul.f64 fd335, fd1338, 0d3FE0000000000000;
sub.f64 fd336, fd240, fd335;
sub.f64 fd337, fd285, fd290;
mul.f64 fd338, fd337, 0d3FEBB67AE8584CAA;
sub.f64 fd339, fd336, fd338;
add.f64 fd340, fd338, fd336;
add.f64 fd341, %78, %96;
add.f64 fd342, %60, fd341;
mul.f64 fd345, fd341, 0d3FE0000000000000;
sub.f64 fd346, %60, fd345;
add.f64 fd1334, %119, %120;
sub.f64 fd347, %119, %120;
mul.f64 fd348, fd347, 0d3FEBB67AE8584CAA;
add.f64 fd349, fd348, fd346;
sub.f64 fd350, fd346, fd348;
add.f64 fd1332, %121, fd1334;
mul.f64 fd351, fd1334, 0d3FE0000000000000;
sub.f64 fd352, %121, fd351;
sub.f64 fd353, %78, %96;
mul.f64 fd354, fd353, 0d3FEBB67AE8584CAA;
sub.f64 fd355, fd352, fd354;
add.f64 fd356, fd354, fd352;
add.f64 fd357, %84, %102;
add.f64 fd358, %66, fd357;
mul.f64 fd361, fd357, 0d3FE0000000000000;
sub.f64 fd362, %66, fd361;
add.f64 fd1329, %123, %122;
sub.f64 fd363, %123, %122;
mul.f64 fd364, fd363, 0d3FEBB67AE8584CAA;
add.f64 fd365, fd364, fd362;
sub.f64 fd366, fd362, fd364;
add.f64 fd1327, %124, fd1329;
mul.f64 fd367, fd1329, 0d3FE0000000000000;
sub.f64 fd368, %124, fd367;
sub.f64 fd369, %84, %102;
mul.f64 fd370, fd369, 0d3FEBB67AE8584CAA;
sub.f64 fd371, fd368, fd370;
add.f64 fd372, fd370, fd368;
add.f64 fd373, %90, %108;
add.f64 fd374, %72, fd373;
mul.f64 fd377, fd373, 0d3FE0000000000000;
sub.f64 fd378, %72, fd377;
add.f64 fd1325, %125, %109;
sub.f64 fd379, %125, %109;
mul.f64 fd380, fd379, 0d3FEBB67AE8584CAA;
add.f64 fd381, fd380, fd378;
sub.f64 fd382, fd378, fd380;
add.f64 fd1323, %126, fd1325;
mul.f64 fd383, fd1325, 0d3FE0000000000000;
sub.f64 fd384, %126, fd383;
sub.f64 fd385, %90, %108;
mul.f64 fd386, fd385, 0d3FEBB67AE8584CAA;
sub.f64 fd387, fd384, fd386;
add.f64 fd388, fd386, fd384;
mul.f64 fd390, fd371, 0dBFE491B7523C161D;
mul.f64 fd1322, fd365, 0d3FE8836FA2CF5039;
sub.f64 fd391, fd1322, fd390;
mul.f64 fd392, fd371, 0d3FE8836FA2CF5039;
fma.rn.f64 fd393, fd365, 0dBFE491B7523C161D, fd392;
mul.f64 fd395, fd387, 0dBFEF838B8C811C17;
mul.f64 fd1321, fd381, 0d3FC63A1A7E0B738A;
sub.f64 fd396, fd1321, fd395;
mul.f64 fd397, fd387, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd398, fd381, 0dBFEF838B8C811C17, fd397;
mul.f64 fd1319, fd366, 0d3FC63A1A7E0B738A;
mul.f64 fd1320, fd372, 0dBFEF838B8C811C17;
sub.f64 fd401, fd1319, fd1320;
mul.f64 fd402, fd372, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd403, fd366, 0dBFEF838B8C811C17, fd402;
mul.f64 fd1317, fd382, 0dBFEE11F642522D1C;
mul.f64 fd1318, fd388, 0dBFD5E3A8748A0BF5;
sub.f64 fd406, fd1317, fd1318;
mul.f64 fd407, fd388, 0dBFEE11F642522D1C;
fma.rn.f64 fd408, fd382, 0dBFD5E3A8748A0BF5, fd407;
add.f64 fd409, fd358, fd374;
add.f64 fd410, fd342, fd409;
mul.f64 fd413, fd409, 0d3FE0000000000000;
sub.f64 fd414, fd342, fd413;
add.f64 fd1316, fd1327, fd1323;
sub.f64 fd415, fd1327, fd1323;
mul.f64 fd416, fd415, 0d3FEBB67AE8584CAA;
add.f64 fd417, fd416, fd414;
sub.f64 fd418, fd414, fd416;
add.f64 fd1315, fd1332, fd1316;
mul.f64 fd419, fd1316, 0d3FE0000000000000;
sub.f64 fd420, fd1332, fd419;
sub.f64 fd421, fd358, fd374;
mul.f64 fd422, fd421, 0d3FEBB67AE8584CAA;
sub.f64 fd423, fd420, fd422;
add.f64 fd424, fd422, fd420;
add.f64 fd425, fd391, fd396;
add.f64 fd426, fd349, fd425;
mul.f64 fd429, fd425, 0d3FE0000000000000;
sub.f64 fd430, fd349, fd429;
add.f64 fd1314, fd393, fd398;
sub.f64 fd431, fd393, fd398;
mul.f64 fd432, fd431, 0d3FEBB67AE8584CAA;
add.f64 fd433, fd432, fd430;
sub.f64 fd434, fd430, fd432;
add.f64 fd1313, fd355, fd1314;
mul.f64 fd435, fd1314, 0d3FE0000000000000;
sub.f64 fd436, fd355, fd435;
sub.f64 fd437, fd391, fd396;
mul.f64 fd438, fd437, 0d3FEBB67AE8584CAA;
sub.f64 fd439, fd436, fd438;
add.f64 fd440, fd438, fd436;
add.f64 fd441, fd401, fd406;
add.f64 fd442, fd350, fd441;
mul.f64 fd445, fd441, 0d3FE0000000000000;
sub.f64 fd446, fd350, fd445;
add.f64 fd1312, fd403, fd408;
sub.f64 fd447, fd403, fd408;
mul.f64 fd448, fd447, 0d3FEBB67AE8584CAA;
add.f64 fd449, fd448, fd446;
sub.f64 fd450, fd446, fd448;
add.f64 fd1311, fd356, fd1312;
mul.f64 fd451, fd1312, 0d3FE0000000000000;
sub.f64 fd452, fd356, fd451;
sub.f64 fd453, fd401, fd406;
mul.f64 fd454, fd453, 0d3FEBB67AE8584CAA;
sub.f64 fd455, fd452, fd454;
add.f64 fd456, fd454, fd452;
mul.f64 fd458, fd1339, 0dBFCD84D223638000;
mul.f64 fd1310, fd310, 0d3FEF232EFF15C9E6;
sub.f64 fd459, fd1310, fd458;
mul.f64 fd460, fd1339, 0d3FEF232EFF15C9E6;
fma.rn.f64 fd461, fd310, 0dBFCD84D223638000, fd460;
mul.f64 fd1308, fd426, 0d3FEC98A37A9A7850;
mul.f64 fd1309, fd1313, 0dBFDCB920325BAFA6;
sub.f64 fd464, fd1308, fd1309;
mul.f64 fd465, fd1313, 0d3FEC98A37A9A7850;
fma.rn.f64 fd466, fd426, 0dBFDCB920325BAFA6, fd465;
mul.f64 fd1306, fd326, 0d3FEC98A37A9A7850;
mul.f64 fd1307, fd1337, 0dBFDCB920325BAFA6;
sub.f64 fd469, fd1306, fd1307;
mul.f64 fd470, fd1337, 0d3FEC98A37A9A7850;
fma.rn.f64 fd471, fd326, 0dBFDCB920325BAFA6, fd470;
mul.f64 fd1304, fd442, 0d3FE31BEC55BC71BC;
mul.f64 fd1305, fd1311, 0dBFE9AAFE4207DF5F;
sub.f64 fd474, fd1304, fd1305;
mul.f64 fd475, fd1311, 0d3FE31BEC55BC71BC;
fma.rn.f64 fd476, fd442, 0dBFE9AAFE4207DF5F, fd475;
mul.f64 fd1302, fd301, 0d3FE8836FA2CF5039;
mul.f64 fd1303, fd307, 0dBFE491B7523C161D;
sub.f64 fd479, fd1302, fd1303;
mul.f64 fd480, fd307, 0d3FE8836FA2CF5039;
fma.rn.f64 fd481, fd301, 0dBFE491B7523C161D, fd480;
mul.f64 fd483, fd423, 0dBFEF838B8C811C17;
mul.f64 fd1301, fd417, 0d3FC63A1A7E0B738A;
sub.f64 fd484, fd1301, fd483;
mul.f64 fd485, fd423, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd486, fd417, 0dBFEF838B8C811C17, fd485;
mul.f64 fd488, fd323, 0dBFE9AAFE4207DF5F;
mul.f64 fd1300, fd317, 0d3FE31BEC55BC71BC;
sub.f64 fd489, fd1300, fd488;
mul.f64 fd490, fd323, 0d3FE31BEC55BC71BC;
fma.rn.f64 fd491, fd317, 0dBFE9AAFE4207DF5F, fd490;
mul.f64 fd493, fd439, 0dBFEEA7D99F29CADE;
mul.f64 fd1299, fd433, 0dBFD25AFBF23865BF;
sub.f64 fd494, fd1299, fd493;
mul.f64 fd495, fd439, 0dBFD25AFBF23865BF;
fma.rn.f64 fd496, fd433, 0dBFEEA7D99F29CADE, fd495;
mul.f64 fd498, fd339, 0dBFED6206BEB6C24B;
mul.f64 fd1298, fd333, 0d3FD9595EF26FB670;
sub.f64 fd499, fd1298, fd498;
mul.f64 fd500, fd339, 0d3FD9595EF26FB670;
fma.rn.f64 fd501, fd333, 0dBFED6206BEB6C24B, fd500;
mul.f64 fd503, fd455, 0dBFE746A51650EADE;
mul.f64 fd1297, fd449, 0dBFE5F5B105F99707;
sub.f64 fd504, fd1297, fd503;
mul.f64 fd505, fd455, 0dBFE5F5B105F99707;
fma.rn.f64 fd506, fd449, 0dBFE746A51650EADE, fd505;
mul.f64 fd508, fd308, 0dBFEF838B8C811C17;
mul.f64 fd1296, fd302, 0d3FC63A1A7E0B738A;
sub.f64 fd509, fd1296, fd508;
mul.f64 fd510, fd308, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd511, fd302, 0dBFEF838B8C811C17, fd510;
mul.f64 fd1294, fd418, 0dBFEE11F642522D1C;
mul.f64 fd1295, fd424, 0dBFD5E3A8748A0BF5;
sub.f64 fd514, fd1294, fd1295;
mul.f64 fd515, fd424, 0dBFEE11F642522D1C;
fma.rn.f64 fd516, fd418, 0dBFD5E3A8748A0BF5, fd515;
mul.f64 fd1292, fd318, 0dBFADC528B5343A86;
mul.f64 fd1293, fd324, 0dBFEFF223F3635CE3;
sub.f64 fd519, fd1292, fd1293;
mul.f64 fd520, fd324, 0dBFADC528B5343A86;
fma.rn.f64 fd521, fd318, 0dBFEFF223F3635CE3, fd520;
mul.f64 fd1290, fd434, 0dBFEFC89BCEF44CF4;
mul.f64 fd1291, fd440, 0d3FBDB843E577175E;
sub.f64 fd524, fd1290, fd1291;
mul.f64 fd525, fd440, 0dBFEFC89BCEF44CF4;
fma.rn.f64 fd526, fd434, 0d3FBDB843E577175E, fd525;
mul.f64 fd528, fd340, 0dBFEEA7D99F29CADE;
mul.f64 fd1289, fd334, 0dBFD25AFBF23865BF;
sub.f64 fd529, fd1289, fd528;
mul.f64 fd530, fd340, 0dBFD25AFBF23865BF;
fma.rn.f64 fd531, fd334, 0dBFEEA7D99F29CADE, fd530;
mul.f64 fd533, fd456, 0d3FE19593DA358510;
mul.f64 fd1288, fd450, 0dBFEABC50EF4734A7;
sub.f64 fd534, fd1288, fd533;
mul.f64 fd535, fd456, 0dBFEABC50EF4734A7;
fma.rn.f64 fd536, fd450, 0d3FE19593DA358510, fd535;
add.f64 fd537, fd294, fd410;
mul.f64 fd539, fd537, 0d3FE0000000000000;
sub.f64 fd540, fd178, fd539;
add.f64 fd1287, fd1341, fd1315;
sub.f64 fd541, fd1341, fd1315;
mul.f64 fd542, fd541, 0d3FEBB67AE8584CAA;
add.f64 fd543, fd542, fd540;
sub.f64 fd544, fd540, fd542;
mul.f64 fd545, fd1287, 0d3FE0000000000000;
sub.f64 fd546, fd1368, fd545;
sub.f64 fd547, fd294, fd410;
mul.f64 fd548, fd547, 0d3FEBB67AE8584CAA;
sub.f64 fd549, fd546, fd548;
add.f64 fd550, fd548, fd546;
add.f64 fd551, fd459, fd464;
add.f64 fd552, fd194, fd551;
mul.f64 fd555, fd551, 0d3FE0000000000000;
sub.f64 fd556, fd194, fd555;
add.f64 fd1286, fd461, fd466;
sub.f64 fd557, fd461, fd466;
mul.f64 fd558, fd557, 0d3FEBB67AE8584CAA;
add.f64 fd559, fd558, fd556;
sub.f64 fd560, fd556, fd558;
add.f64 fd1285, fd1366, fd1286;
mul.f64 fd561, fd1286, 0d3FE0000000000000;
sub.f64 fd562, fd1366, fd561;
sub.f64 fd563, fd459, fd464;
mul.f64 fd564, fd563, 0d3FEBB67AE8584CAA;
sub.f64 fd565, fd562, fd564;
add.f64 fd566, fd564, fd562;
add.f64 fd567, fd469, fd474;
add.f64 fd568, fd210, fd567;
mul.f64 fd571, fd567, 0d3FE0000000000000;
sub.f64 fd572, fd210, fd571;
add.f64 fd1284, fd471, fd476;
sub.f64 fd573, fd471, fd476;
mul.f64 fd574, fd573, 0d3FEBB67AE8584CAA;
add.f64 fd575, fd574, fd572;
sub.f64 fd576, fd572, fd574;
add.f64 fd1283, fd1364, fd1284;
mul.f64 fd577, fd1284, 0d3FE0000000000000;
sub.f64 fd578, fd1364, fd577;
sub.f64 fd579, fd469, fd474;
mul.f64 fd580, fd579, 0d3FEBB67AE8584CAA;
sub.f64 fd581, fd578, fd580;
add.f64 fd582, fd580, fd578;
add.f64 fd583, fd479, fd484;
add.f64 fd584, fd185, fd583;
mul.f64 fd587, fd583, 0d3FE0000000000000;
sub.f64 fd588, fd185, fd587;
add.f64 fd1282, fd481, fd486;
sub.f64 fd589, fd481, fd486;
mul.f64 fd590, fd589, 0d3FEBB67AE8584CAA;
add.f64 fd591, fd590, fd588;
sub.f64 fd592, fd588, fd590;
add.f64 fd1281, fd191, fd1282;
mul.f64 fd593, fd1282, 0d3FE0000000000000;
sub.f64 fd594, fd191, fd593;
sub.f64 fd595, fd479, fd484;
mul.f64 fd596, fd595, 0d3FEBB67AE8584CAA;
sub.f64 fd597, fd594, fd596;
add.f64 fd598, fd596, fd594;
add.f64 fd599, fd489, fd494;
add.f64 fd600, fd201, fd599;
mul.f64 fd603, fd599, 0d3FE0000000000000;
sub.f64 fd604, fd201, fd603;
add.f64 fd1280, fd491, fd496;
sub.f64 fd605, fd491, fd496;
mul.f64 fd606, fd605, 0d3FEBB67AE8584CAA;
add.f64 fd607, fd606, fd604;
sub.f64 fd608, fd604, fd606;
add.f64 fd1279, fd207, fd1280;
mul.f64 fd609, fd1280, 0d3FE0000000000000;
sub.f64 fd610, fd207, fd609;
sub.f64 fd611, fd489, fd494;
mul.f64 fd612, fd611, 0d3FEBB67AE8584CAA;
sub.f64 fd613, fd610, fd612;
add.f64 fd614, fd612, fd610;
add.f64 fd615, fd499, fd504;
add.f64 fd616, fd217, fd615;
mul.f64 fd619, fd615, 0d3FE0000000000000;
sub.f64 fd620, fd217, fd619;
add.f64 fd1278, fd501, fd506;
sub.f64 fd621, fd501, fd506;
mul.f64 fd622, fd621, 0d3FEBB67AE8584CAA;
add.f64 fd623, fd622, fd620;
sub.f64 fd624, fd620, fd622;
add.f64 fd1277, fd223, fd1278;
mul.f64 fd625, fd1278, 0d3FE0000000000000;
sub.f64 fd626, fd223, fd625;
sub.f64 fd627, fd499, fd504;
mul.f64 fd628, fd627, 0d3FEBB67AE8584CAA;
sub.f64 fd629, fd626, fd628;
add.f64 fd630, fd628, fd626;
add.f64 fd631, fd509, fd514;
add.f64 fd632, fd186, fd631;
mul.f64 fd635, fd631, 0d3FE0000000000000;
sub.f64 fd636, fd186, fd635;
add.f64 fd1276, fd511, fd516;
sub.f64 fd637, fd511, fd516;
mul.f64 fd638, fd637, 0d3FEBB67AE8584CAA;
add.f64 fd639, fd638, fd636;
sub.f64 fd640, fd636, fd638;
add.f64 fd1275, fd192, fd1276;
mul.f64 fd641, fd1276, 0d3FE0000000000000;
sub.f64 fd642, fd192, fd641;
sub.f64 fd643, fd509, fd514;
mul.f64 fd644, fd643, 0d3FEBB67AE8584CAA;
sub.f64 fd645, fd642, fd644;
add.f64 fd646, fd644, fd642;
add.f64 fd647, fd519, fd524;
add.f64 fd648, fd202, fd647;
mul.f64 fd651, fd647, 0d3FE0000000000000;
sub.f64 fd652, fd202, fd651;
add.f64 fd1274, fd521, fd526;
sub.f64 fd653, fd521, fd526;
mul.f64 fd654, fd653, 0d3FEBB67AE8584CAA;
add.f64 fd655, fd654, fd652;
sub.f64 fd656, fd652, fd654;
add.f64 fd1273, fd208, fd1274;
mul.f64 fd657, fd1274, 0d3FE0000000000000;
sub.f64 fd658, fd208, fd657;
sub.f64 fd659, fd519, fd524;
mul.f64 fd660, fd659, 0d3FEBB67AE8584CAA;
sub.f64 fd661, fd658, fd660;
add.f64 fd662, fd660, fd658;
add.f64 fd663, fd529, fd534;
add.f64 fd664, fd218, fd663;
mul.f64 fd667, fd663, 0d3FE0000000000000;
sub.f64 fd668, fd218, fd667;
add.f64 fd1272, fd531, fd536;
sub.f64 fd669, fd531, fd536;
mul.f64 fd670, fd669, 0d3FEBB67AE8584CAA;
add.f64 fd671, fd670, fd668;
sub.f64 fd672, fd668, fd670;
add.f64 fd1271, fd224, fd1272;
mul.f64 fd673, fd1272, 0d3FE0000000000000;
sub.f64 fd674, fd224, fd673;
sub.f64 fd675, fd529, fd534;
mul.f64 fd676, fd675, 0d3FEBB67AE8584CAA;
sub.f64 fd677, fd674, fd676;
add.f64 fd678, fd676, fd674;
mov.u32 r11, %tid.x;
mul.wide.u32 rd2, r11, -1431655765;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 3;
sub.s32 r7, r11, r6;
mad.lo.s32 r8, r5, 1296, r3;
mul.wide.u32 rd7, r7, 16;
mov.u64 rd8, %55;
add.s64 rd6, rd8, rd7;
ld.global.v2.f64 {fd679, fd680}, [rd6];
mul.f64 fd684, fd680, fd1285;
mul.f64 fd685, fd679, fd1285;
mul.f64 fd1269, fd679, fd679;
mul.f64 fd1270, fd680, fd680;
sub.f64 fd688, fd1269, fd1270;
mul.f64 fd689, fd680, fd679;
fma.rn.f64 fd690, fd680, fd679, fd689;
mul.f64 fd692, fd690, fd1283;
mul.f64 fd693, fd688, fd1283;
mul.f64 fd695, fd680, fd690;
mul.f64 fd1268, fd679, fd688;
sub.f64 fd696, fd1268, fd695;
mul.f64 fd1267, fd688, fd568;
mul.f64 fd697, fd679, fd690;
fma.rn.f64 fd698, fd680, fd688, fd697;
mul.f64 fd700, fd698, fd1281;
mul.f64 fd701, fd696, fd1281;
mul.f64 fd1265, fd679, fd696;
mul.f64 fd1266, fd680, fd698;
sub.f64 fd704, fd1265, fd1266;
mul.f64 fd1264, fd696, fd584;
mul.f64 fd705, fd679, fd698;
fma.rn.f64 fd706, fd680, fd696, fd705;
mul.f64 fd708, fd706, fd1279;
mul.f64 fd709, fd704, fd1279;
mul.f64 fd711, fd680, fd706;
mul.f64 fd1263, fd679, fd704;
sub.f64 fd712, fd1263, fd711;
mul.f64 fd1262, fd704, fd600;
mul.f64 fd713, fd679, fd706;
fma.rn.f64 fd714, fd680, fd704, fd713;
mul.f64 fd716, fd714, fd1277;
mul.f64 fd717, fd712, fd1277;
mul.f64 fd719, fd680, fd714;
mul.f64 fd1261, fd679, fd712;
sub.f64 fd720, fd1261, fd719;
mul.f64 fd1260, fd712, fd616;
mul.f64 fd721, fd679, fd714;
fma.rn.f64 fd722, fd680, fd712, fd721;
mul.f64 fd724, fd722, fd1275;
mul.f64 fd725, fd720, fd1275;
mul.f64 fd1258, fd679, fd720;
mul.f64 fd1259, fd680, fd722;
sub.f64 fd728, fd1258, fd1259;
mul.f64 fd1257, fd720, fd632;
mul.f64 fd729, fd679, fd722;
fma.rn.f64 fd730, fd680, fd720, fd729;
mul.f64 fd732, fd730, fd1273;
mul.f64 fd733, fd728, fd1273;
mul.f64 fd735, fd680, fd730;
mul.f64 fd1256, fd679, fd728;
sub.f64 fd736, fd1256, fd735;
mul.f64 fd1255, fd728, fd648;
mul.f64 fd737, fd679, fd730;
fma.rn.f64 fd738, fd680, fd728, fd737;
mul.f64 fd740, fd738, fd1271;
mul.f64 fd741, fd736, fd1271;
mul.f64 fd743, fd680, fd738;
mul.f64 fd1254, fd679, fd736;
sub.f64 fd744, fd1254, fd743;
mul.f64 fd1253, fd736, fd664;
mul.f64 fd745, fd679, fd738;
fma.rn.f64 fd746, fd680, fd736, fd745;
mul.f64 fd748, fd746, fd549;
mul.f64 fd749, fd744, fd549;
mul.f64 fd1251, fd679, fd744;
mul.f64 fd1252, fd680, fd746;
sub.f64 fd752, fd1251, fd1252;
mul.f64 fd1250, fd744, fd543;
mul.f64 fd753, fd679, fd746;
fma.rn.f64 fd754, fd680, fd744, fd753;
mul.f64 fd756, fd754, fd565;
mul.f64 fd757, fd752, fd565;
mul.f64 fd759, fd680, fd754;
mul.f64 fd1249, fd679, fd752;
sub.f64 fd760, fd1249, fd759;
mul.f64 fd1248, fd752, fd559;
mul.f64 fd761, fd679, fd754;
fma.rn.f64 fd762, fd680, fd752, fd761;
mul.f64 fd764, fd762, fd581;
mul.f64 fd765, fd760, fd581;
mul.f64 fd1246, fd679, fd760;
mul.f64 fd1247, fd680, fd762;
sub.f64 fd768, fd1246, fd1247;
mul.f64 fd1245, fd760, fd575;
mul.f64 fd769, fd679, fd762;
fma.rn.f64 fd770, fd680, fd760, fd769;
mul.f64 fd772, fd770, fd597;
mul.f64 fd773, fd768, fd597;
mul.f64 fd775, fd680, fd770;
mul.f64 fd1244, fd679, fd768;
sub.f64 fd776, fd1244, fd775;
mul.f64 fd1243, fd768, fd591;
mul.f64 fd777, fd679, fd770;
fma.rn.f64 fd778, fd680, fd768, fd777;
mul.f64 fd779, fd776, fd607;
mul.f64 fd780, fd778, fd613;
mul.f64 fd781, fd776, fd613;
ld.global.v2.f64 {fd782, fd783}, [rd6+48];
mul.f64 fd787, fd783, fd629;
mul.f64 fd788, fd782, fd629;
mul.f64 fd790, fd680, fd783;
mul.f64 fd1242, fd679, fd782;
sub.f64 fd791, fd1242, fd790;
mul.f64 fd1241, fd782, fd623;
mul.f64 fd792, fd679, fd783;
fma.rn.f64 fd793, fd680, fd782, fd792;
mul.f64 fd795, fd793, fd645;
mul.f64 fd796, fd791, fd645;
mul.f64 fd1239, fd679, fd791;
mul.f64 fd1240, fd680, fd793;
sub.f64 fd799, fd1239, fd1240;
mul.f64 fd1238, fd791, fd639;
mul.f64 fd800, fd679, fd793;
fma.rn.f64 fd801, fd680, fd791, fd800;
mul.f64 fd803, fd801, fd661;
mul.f64 fd804, fd799, fd661;
mul.f64 fd806, fd680, fd801;
mul.f64 fd1237, fd679, fd799;
sub.f64 fd807, fd1237, fd806;
mul.f64 fd1236, fd799, fd655;
mul.f64 fd808, fd679, fd801;
fma.rn.f64 fd809, fd680, fd799, fd808;
mul.f64 fd811, fd809, fd677;
mul.f64 fd812, fd807, fd677;
mul.f64 fd814, fd680, fd809;
mul.f64 fd1235, fd679, fd807;
sub.f64 fd815, fd1235, fd814;
mul.f64 fd1234, fd807, fd671;
mul.f64 fd816, fd679, fd809;
fma.rn.f64 fd817, fd680, fd807, fd816;
mul.f64 fd819, fd817, fd550;
mul.f64 fd820, fd815, fd550;
mul.f64 fd1232, fd679, fd815;
mul.f64 fd1233, fd680, fd817;
sub.f64 fd823, fd1232, fd1233;
mul.f64 fd1231, fd815, fd544;
mul.f64 fd824, fd679, fd817;
fma.rn.f64 fd825, fd680, fd815, fd824;
mul.f64 fd827, fd825, fd566;
mul.f64 fd828, fd823, fd566;
mul.f64 fd830, fd680, fd825;
mul.f64 fd1230, fd679, fd823;
sub.f64 fd831, fd1230, fd830;
mul.f64 fd1229, fd823, fd560;
mul.f64 fd832, fd679, fd825;
fma.rn.f64 fd833, fd680, fd823, fd832;
mul.f64 fd835, fd833, fd582;
mul.f64 fd836, fd831, fd582;
mul.f64 fd1227, fd679, fd831;
mul.f64 fd1228, fd680, fd833;
sub.f64 fd839, fd1227, fd1228;
mul.f64 fd1226, fd831, fd576;
mul.f64 fd840, fd679, fd833;
fma.rn.f64 fd841, fd680, fd831, fd840;
mul.f64 fd843, fd841, fd598;
mul.f64 fd844, fd839, fd598;
mul.f64 fd1224, fd679, fd839;
mul.f64 fd1225, fd680, fd841;
sub.f64 fd847, fd1224, fd1225;
mul.f64 fd1223, fd839, fd592;
mul.f64 fd848, fd679, fd841;
fma.rn.f64 fd849, fd680, fd839, fd848;
mul.f64 fd851, fd849, fd614;
mul.f64 fd852, fd847, fd614;
mul.f64 fd854, fd680, fd849;
mul.f64 fd1222, fd679, fd847;
sub.f64 fd855, fd1222, fd854;
mul.f64 fd1221, fd847, fd608;
mul.f64 fd856, fd679, fd849;
fma.rn.f64 fd857, fd680, fd847, fd856;
mul.f64 fd859, fd857, fd630;
mul.f64 fd860, fd855, fd630;
mul.f64 fd1219, fd679, fd855;
mul.f64 fd1220, fd680, fd857;
sub.f64 fd863, fd1219, fd1220;
mul.f64 fd1218, fd855, fd624;
mul.f64 fd864, fd679, fd857;
fma.rn.f64 fd865, fd680, fd855, fd864;
mul.f64 fd867, fd865, fd646;
mul.f64 fd868, fd863, fd646;
mul.f64 fd870, fd680, fd865;
mul.f64 fd1217, fd679, fd863;
sub.f64 fd871, fd1217, fd870;
mul.f64 fd1216, fd863, fd640;
mul.f64 fd872, fd679, fd865;
fma.rn.f64 fd873, fd680, fd863, fd872;
mul.f64 fd875, fd873, fd662;
mul.f64 fd876, fd871, fd662;
mul.f64 fd878, fd680, fd873;
mul.f64 fd1215, fd679, fd871;
sub.f64 fd879, fd1215, fd878;
mul.f64 fd1214, fd679, fd552;
mul.f64 fd880, fd679, fd873;
mul.f64 fd1213, fd871, fd656;
fma.rn.f64 fd881, fd680, fd871, fd880;
mul.f64 fd882, fd879, fd672;
mul.f64 fd883, fd881, fd678;
mul.f64 fd884, fd879, fd678;
barrier.sync 0;
mad.lo.s32 r9, r7, 432, r8;
add.f64 fd885, fd1368, fd1287;
add.f64 fd886, fd178, fd537;
st.shared.v2.f64 [r9], {fd886, fd885};
fma.rn.f64 fd887, fd680, fd552, fd685;
sub.f64 fd888, fd1214, fd684;
st.shared.v2.f64 [r9+16], {fd888, fd887};
fma.rn.f64 fd889, fd690, fd568, fd693;
sub.f64 fd890, fd1267, fd692;
st.shared.v2.f64 [r9+32], {fd890, fd889};
fma.rn.f64 fd891, fd698, fd584, fd701;
sub.f64 fd892, fd1264, fd700;
st.shared.v2.f64 [r9+48], {fd892, fd891};
fma.rn.f64 fd893, fd706, fd600, fd709;
sub.f64 fd894, fd1262, fd708;
st.shared.v2.f64 [r9+64], {fd894, fd893};
fma.rn.f64 fd895, fd714, fd616, fd717;
sub.f64 fd896, fd1260, fd716;
st.shared.v2.f64 [r9+80], {fd896, fd895};
fma.rn.f64 fd897, fd722, fd632, fd725;
sub.f64 fd898, fd1257, fd724;
st.shared.v2.f64 [r9+96], {fd898, fd897};
sub.f64 fd899, fd1255, fd732;
fma.rn.f64 fd900, fd730, fd648, fd733;
st.shared.v2.f64 [r9+112], {fd899, fd900};
fma.rn.f64 fd901, fd738, fd664, fd741;
sub.f64 fd902, fd1253, fd740;
st.shared.v2.f64 [r9+128], {fd902, fd901};
fma.rn.f64 fd903, fd746, fd543, fd749;
sub.f64 fd904, fd1250, fd748;
st.shared.v2.f64 [r9+144], {fd904, fd903};
fma.rn.f64 fd905, fd754, fd559, fd757;
sub.f64 fd906, fd1248, fd756;
st.shared.v2.f64 [r9+160], {fd906, fd905};
fma.rn.f64 fd907, fd762, fd575, fd765;
sub.f64 fd908, fd1245, fd764;
st.shared.v2.f64 [r9+176], {fd908, fd907};
fma.rn.f64 fd909, fd770, fd591, fd773;
sub.f64 fd910, fd1243, fd772;
st.shared.v2.f64 [r9+192], {fd910, fd909};
fma.rn.f64 fd911, fd778, fd607, fd781;
sub.f64 fd912, fd779, fd780;
st.shared.v2.f64 [r9+208], {fd912, fd911};
fma.rn.f64 fd913, fd783, fd623, fd788;
sub.f64 fd914, fd1241, fd787;
st.shared.v2.f64 [r9+224], {fd914, fd913};
fma.rn.f64 fd915, fd793, fd639, fd796;
sub.f64 fd916, fd1238, fd795;
st.shared.v2.f64 [r9+240], {fd916, fd915};
fma.rn.f64 fd917, fd801, fd655, fd804;
sub.f64 fd918, fd1236, fd803;
st.shared.v2.f64 [r9+256], {fd918, fd917};
fma.rn.f64 fd919, fd809, fd671, fd812;
sub.f64 fd920, fd1234, fd811;
st.shared.v2.f64 [r9+272], {fd920, fd919};
fma.rn.f64 fd921, fd817, fd544, fd820;
sub.f64 fd922, fd1231, fd819;
st.shared.v2.f64 [r9+288], {fd922, fd921};
fma.rn.f64 fd923, fd825, fd560, fd828;
sub.f64 fd924, fd1229, fd827;
st.shared.v2.f64 [r9+304], {fd924, fd923};
sub.f64 fd925, fd1226, fd835;
fma.rn.f64 fd926, fd833, fd576, fd836;
st.shared.v2.f64 [r9+320], {fd925, fd926};
fma.rn.f64 fd927, fd841, fd592, fd844;
sub.f64 fd928, fd1223, fd843;
st.shared.v2.f64 [r9+336], {fd928, fd927};
fma.rn.f64 fd929, fd849, fd608, fd852;
sub.f64 fd930, fd1221, fd851;
st.shared.v2.f64 [r9+352], {fd930, fd929};
fma.rn.f64 fd931, fd857, fd624, fd860;
sub.f64 fd932, fd1218, fd859;
st.shared.v2.f64 [r9+368], {fd932, fd931};
fma.rn.f64 fd933, fd865, fd640, fd868;
sub.f64 fd934, fd1216, fd867;
st.shared.v2.f64 [r9+384], {fd934, fd933};
fma.rn.f64 fd935, fd873, fd656, fd876;
sub.f64 fd936, fd1213, fd875;
st.shared.v2.f64 [r9+400], {fd936, fd935};
fma.rn.f64 fd937, fd881, fd672, fd884;
sub.f64 fd938, fd882, fd883;
st.shared.v2.f64 [r9+416], {fd938, fd937};
barrier.sync 0;
mad.lo.s32 r10, r7, -416, r9;
ld.shared.v2.f64 {fd939, fd940}, [r10];
ld.shared.v2.f64 {fd943, fd944}, [r10+48];
ld.shared.v2.f64 {fd947, fd948}, [r10+96];
ld.shared.v2.f64 {fd951, fd952}, [r10+144];
ld.shared.v2.f64 {fd955, fd956}, [r10+192];
ld.shared.v2.f64 {fd959, fd960}, [r10+240];
ld.shared.v2.f64 {fd963, fd964}, [r10+288];
ld.shared.v2.f64 {fd967, fd968}, [r10+336];
ld.shared.v2.f64 {fd971, fd972}, [r10+384];
ld.shared.v2.f64 {fd975, fd976}, [r10+432];
ld.shared.v2.f64 {fd979, fd980}, [r10+480];
ld.shared.v2.f64 {fd983, fd984}, [r10+528];
ld.shared.v2.f64 {fd987, fd988}, [r10+576];
ld.shared.v2.f64 {fd991, fd992}, [r10+624];
ld.shared.v2.f64 {fd995, fd996}, [r10+672];
ld.shared.v2.f64 {fd999, fd1000}, [r10+720];
ld.shared.v2.f64 {fd1003, fd1004}, [r10+768];
ld.shared.v2.f64 {fd1007, fd1008}, [r10+816];
ld.shared.v2.f64 {fd1011, fd1012}, [r10+864];
ld.shared.v2.f64 {fd1015, fd1016}, [r10+912];
ld.shared.v2.f64 {fd1019, fd1020}, [r10+960];
ld.shared.v2.f64 {fd1023, fd1024}, [r10+1008];
ld.shared.v2.f64 {fd1027, fd1028}, [r10+1056];
ld.shared.v2.f64 {fd1031, fd1032}, [r10+1104];
ld.shared.v2.f64 {fd1035, fd1036}, [r10+1152];
ld.shared.v2.f64 {fd1039, fd1040}, [r10+1200];
ld.shared.v2.f64 {fd1043, fd1044}, [r10+1248];
add.f64 fd1047, fd975, fd1011;
mul.f64 fd1049, fd1047, 0d3FE0000000000000;
sub.f64 fd1050, fd939, fd1049;
add.f64 fd1212, fd976, fd1012;
sub.f64 fd1051, fd976, fd1012;
mul.f64 fd1052, fd1051, 0d3FEBB67AE8584CAA;
mul.f64 fd1053, fd1212, 0d3FE0000000000000;
sub.f64 fd1054, fd940, fd1053;
sub.f64 fd1055, fd975, fd1011;
mul.f64 fd1056, fd1055, 0d3FEBB67AE8584CAA;
add.f64 fd1057, fd979, fd1015;
mul.f64 fd1059, fd1057, 0d3FE0000000000000;
sub.f64 fd1060, fd943, fd1059;
add.f64 fd1211, fd980, fd1016;
sub.f64 fd1061, fd980, fd1016;
mul.f64 fd1062, fd1061, 0d3FEBB67AE8584CAA;
mul.f64 fd1063, fd1211, 0d3FE0000000000000;
sub.f64 fd1064, fd944, fd1063;
sub.f64 fd1065, fd979, fd1015;
mul.f64 fd1066, fd1065, 0d3FEBB67AE8584CAA;
add.f64 fd1067, fd983, fd1019;
mul.f64 fd1069, fd1067, 0d3FE0000000000000;
sub.f64 fd1070, fd947, fd1069;
add.f64 fd1210, fd984, fd1020;
sub.f64 fd1071, fd984, fd1020;
mul.f64 fd1072, fd1071, 0d3FEBB67AE8584CAA;
mul.f64 fd1073, fd1210, 0d3FE0000000000000;
sub.f64 fd1074, fd948, fd1073;
sub.f64 fd1075, fd983, fd1019;
mul.f64 fd1076, fd1075, 0d3FEBB67AE8584CAA;
add.f64 fd1077, fd987, fd1023;
mul.f64 fd1079, fd1077, 0d3FE0000000000000;
sub.f64 fd1080, fd951, fd1079;
add.f64 fd1209, fd988, fd1024;
sub.f64 fd1081, fd988, fd1024;
mul.f64 fd1082, fd1081, 0d3FEBB67AE8584CAA;
mul.f64 fd1083, fd1209, 0d3FE0000000000000;
sub.f64 fd1084, fd952, fd1083;
sub.f64 fd1085, fd987, fd1023;
mul.f64 fd1086, fd1085, 0d3FEBB67AE8584CAA;
add.f64 fd1087, fd991, fd1027;
mul.f64 fd1089, fd1087, 0d3FE0000000000000;
sub.f64 fd1090, fd955, fd1089;
add.f64 fd1208, fd992, fd1028;
sub.f64 fd1091, fd992, fd1028;
mul.f64 fd1092, fd1091, 0d3FEBB67AE8584CAA;
mul.f64 fd1093, fd1208, 0d3FE0000000000000;
sub.f64 fd1094, fd956, fd1093;
sub.f64 fd1095, fd991, fd1027;
mul.f64 fd1096, fd1095, 0d3FEBB67AE8584CAA;
add.f64 fd1097, fd995, fd1031;
mul.f64 fd1099, fd1097, 0d3FE0000000000000;
sub.f64 fd1100, fd959, fd1099;
add.f64 fd1207, fd996, fd1032;
sub.f64 fd1101, fd996, fd1032;
mul.f64 fd1102, fd1101, 0d3FEBB67AE8584CAA;
mul.f64 fd1103, fd1207, 0d3FE0000000000000;
sub.f64 fd1104, fd960, fd1103;
sub.f64 fd1105, fd995, fd1031;
mul.f64 fd1106, fd1105, 0d3FEBB67AE8584CAA;
add.f64 fd1107, fd999, fd1035;
mul.f64 fd1109, fd1107, 0d3FE0000000000000;
sub.f64 fd1110, fd963, fd1109;
add.f64 fd1206, fd1000, fd1036;
sub.f64 fd1111, fd1000, fd1036;
mul.f64 fd1112, fd1111, 0d3FEBB67AE8584CAA;
mul.f64 fd1113, fd1206, 0d3FE0000000000000;
sub.f64 fd1114, fd964, fd1113;
sub.f64 fd1115, fd999, fd1035;
mul.f64 fd1116, fd1115, 0d3FEBB67AE8584CAA;
add.f64 fd1117, fd1003, fd1039;
mul.f64 fd1119, fd1117, 0d3FE0000000000000;
sub.f64 fd1120, fd967, fd1119;
add.f64 fd1205, fd1004, fd1040;
sub.f64 fd1121, fd1004, fd1040;
mul.f64 fd1122, fd1121, 0d3FEBB67AE8584CAA;
mul.f64 fd1123, fd1205, 0d3FE0000000000000;
sub.f64 fd1124, fd968, fd1123;
sub.f64 fd1125, fd1003, fd1039;
mul.f64 fd1126, fd1125, 0d3FEBB67AE8584CAA;
add.f64 fd1127, fd1007, fd1043;
mul.f64 fd1129, fd1127, 0d3FE0000000000000;
sub.f64 fd1130, fd971, fd1129;
add.f64 fd1204, fd1008, fd1044;
sub.f64 fd1131, fd1008, fd1044;
mul.f64 fd1132, fd1131, 0d3FEBB67AE8584CAA;
mul.f64 fd1133, fd1204, 0d3FE0000000000000;
sub.f64 fd1134, fd972, fd1133;
sub.f64 fd1135, fd1007, fd1043;
mul.f64 fd1136, fd1135, 0d3FEBB67AE8584CAA;
add.f64 %1, fd940, fd1212;
add.f64 %0, fd939, fd1047;
add.f64 %3, fd944, fd1211;
add.f64 %2, fd943, fd1057;
add.f64 %5, fd948, fd1210;
add.f64 %4, fd947, fd1067;
add.f64 %7, fd952, fd1209;
add.f64 %6, fd951, fd1077;
add.f64 %9, fd956, fd1208;
add.f64 %8, fd955, fd1087;
add.f64 %11, fd960, fd1207;
add.f64 %10, fd959, fd1097;
add.f64 %13, fd964, fd1206;
add.f64 %12, fd963, fd1107;
add.f64 %15, fd968, fd1205;
add.f64 %14, fd967, fd1117;
add.f64 %17, fd972, fd1204;
add.f64 %16, fd971, fd1127;
sub.f64 %19, fd1054, fd1056;
add.f64 %18, fd1052, fd1050;
add.f64 %20, fd1062, fd1060;
sub.f64 %21, fd1064, fd1066;
add.f64 %22, fd1072, fd1070;
sub.f64 %23, fd1074, fd1076;
add.f64 %24, fd1082, fd1080;
sub.f64 %25, fd1084, fd1086;
sub.f64 %27, fd1094, fd1096;
add.f64 %26, fd1092, fd1090;
sub.f64 %29, fd1104, fd1106;
add.f64 %28, fd1102, fd1100;
sub.f64 %31, fd1114, fd1116;
add.f64 %30, fd1112, fd1110;
add.f64 %32, fd1122, fd1120;
sub.f64 %33, fd1124, fd1126;
add.f64 %34, fd1132, fd1130;
sub.f64 %35, fd1134, fd1136;
add.f64 %37, fd1056, fd1054;
sub.f64 %36, fd1050, fd1052;
add.f64 %39, fd1066, fd1064;
sub.f64 %38, fd1060, fd1062;
add.f64 %41, fd1076, fd1074;
sub.f64 %40, fd1070, fd1072;
add.f64 %43, fd1086, fd1084;
sub.f64 %42, fd1080, fd1082;
add.f64 %45, fd1096, fd1094;
sub.f64 %44, fd1090, fd1092;
add.f64 %47, fd1106, fd1104;
sub.f64 %46, fd1100, fd1102;
add.f64 %49, fd1116, fd1114;
sub.f64 %48, fd1110, fd1112;
add.f64 %51, fd1126, fd1124;
sub.f64 %50, fd1120, fd1122;
add.f64 %53, fd1136, fd1134;
sub.f64 %52, fd1130, fd1132;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y), "=d"(rmem[25].x), "=d"(rmem[25].y), "=d"(rmem[26].x), "=d"(rmem[26].y): "r"(smem), "l"(lut_dp_27_81), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y), "d"(rmem[25].x), "d"(rmem[25].y), "d"(rmem[26].x), "d"(rmem[26].y), "d"(rmem[19].y), "d"(rmem[10].y), "d"(rmem[1].y), "d"(rmem[22].y), "d"(rmem[13].y), "d"(rmem[4].y), "d"(rmem[16].y), "d"(rmem[25].y), "d"(rmem[7].y), "d"(rmem[11].y), "d"(rmem[20].y), "d"(rmem[2].y), "d"(rmem[23].y), "d"(rmem[14].y), "d"(rmem[5].y), "d"(rmem[17].y), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<511, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<14>;
.reg .f64 fd<1349>;
.reg .b64 rd<9>;
mov.u32 r12, %tid.y;
mov.u32 r13, %54;
mad.lo.s32 r3, r12, 648, r13;
add.f64 fd109, %74, %92;
add.f64 fd110, %56, fd109;
mul.f64 fd113, fd109, 0d3FE0000000000000;
sub.f64 fd114, %56, fd113;
add.f64 fd1340, %75, %93;
sub.f64 fd115, %75, %93;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
add.f64 fd117, fd116, fd114;
sub.f64 fd118, fd114, fd116;
add.f64 fd1339, %57, fd1340;
mul.f64 fd119, fd1340, 0d3FE0000000000000;
sub.f64 fd120, %57, fd119;
sub.f64 fd121, %74, %92;
mul.f64 fd122, fd121, 0d3FEBB67AE8584CAA;
sub.f64 fd123, fd120, fd122;
add.f64 fd124, fd122, fd120;
add.f64 fd125, %80, %98;
add.f64 fd126, %62, fd125;
mul.f64 fd129, fd125, 0d3FE0000000000000;
sub.f64 fd130, %62, fd129;
add.f64 fd1338, %81, %99;
sub.f64 fd131, %81, %99;
mul.f64 fd132, fd131, 0d3FEBB67AE8584CAA;
add.f64 fd133, fd132, fd130;
sub.f64 fd134, fd130, fd132;
add.f64 fd1337, %63, fd1338;
mul.f64 fd135, fd1338, 0d3FE0000000000000;
sub.f64 fd136, %63, fd135;
sub.f64 fd137, %80, %98;
mul.f64 fd138, fd137, 0d3FEBB67AE8584CAA;
sub.f64 fd139, fd136, fd138;
add.f64 fd140, fd138, fd136;
add.f64 fd141, %86, %104;
add.f64 fd142, %68, fd141;
mul.f64 fd145, fd141, 0d3FE0000000000000;
sub.f64 fd146, %68, fd145;
add.f64 fd1336, %87, %105;
sub.f64 fd147, %87, %105;
mul.f64 fd148, fd147, 0d3FEBB67AE8584CAA;
add.f64 fd149, fd148, fd146;
sub.f64 fd150, fd146, fd148;
add.f64 fd1335, %69, fd1336;
mul.f64 fd151, fd1336, 0d3FE0000000000000;
sub.f64 fd152, %69, fd151;
sub.f64 fd153, %86, %104;
mul.f64 fd154, fd153, 0d3FEBB67AE8584CAA;
sub.f64 fd155, fd152, fd154;
add.f64 fd156, fd154, fd152;
mul.f64 fd158, fd139, 0dBFE491B7523C161D;
mul.f64 fd1334, fd133, 0d3FE8836FA2CF5039;
sub.f64 fd159, fd1334, fd158;
mul.f64 fd160, fd139, 0d3FE8836FA2CF5039;
fma.rn.f64 fd161, fd133, 0dBFE491B7523C161D, fd160;
mul.f64 fd1332, fd149, 0d3FC63A1A7E0B738A;
mul.f64 fd1333, fd155, 0dBFEF838B8C811C17;
sub.f64 fd164, fd1332, fd1333;
mul.f64 fd165, fd155, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd166, fd149, 0dBFEF838B8C811C17, fd165;
mul.f64 fd1330, fd134, 0d3FC63A1A7E0B738A;
mul.f64 fd1331, fd140, 0dBFEF838B8C811C17;
sub.f64 fd169, fd1330, fd1331;
mul.f64 fd170, fd140, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd171, fd134, 0dBFEF838B8C811C17, fd170;
mul.f64 fd1328, fd150, 0dBFEE11F642522D1C;
mul.f64 fd1329, fd156, 0dBFD5E3A8748A0BF5;
sub.f64 fd174, fd1328, fd1329;
mul.f64 fd175, fd156, 0dBFEE11F642522D1C;
fma.rn.f64 fd176, fd150, 0dBFD5E3A8748A0BF5, fd175;
add.f64 fd177, fd126, fd142;
add.f64 fd178, fd110, fd177;
mul.f64 fd181, fd177, 0d3FE0000000000000;
sub.f64 fd182, fd110, fd181;
add.f64 fd1327, fd1337, fd1335;
sub.f64 fd183, fd1337, fd1335;
mul.f64 fd184, fd183, 0d3FEBB67AE8584CAA;
add.f64 fd185, fd184, fd182;
sub.f64 fd186, fd182, fd184;
add.f64 fd1326, fd1339, fd1327;
mul.f64 fd187, fd1327, 0d3FE0000000000000;
sub.f64 fd188, fd1339, fd187;
sub.f64 fd189, fd126, fd142;
mul.f64 fd190, fd189, 0d3FEBB67AE8584CAA;
sub.f64 fd191, fd188, fd190;
add.f64 fd192, fd190, fd188;
add.f64 fd193, fd159, fd164;
add.f64 fd194, fd117, fd193;
mul.f64 fd197, fd193, 0d3FE0000000000000;
sub.f64 fd198, fd117, fd197;
add.f64 fd1325, fd161, fd166;
sub.f64 fd199, fd161, fd166;
mul.f64 fd200, fd199, 0d3FEBB67AE8584CAA;
add.f64 fd201, fd200, fd198;
sub.f64 fd202, fd198, fd200;
add.f64 fd1324, fd123, fd1325;
mul.f64 fd203, fd1325, 0d3FE0000000000000;
sub.f64 fd204, fd123, fd203;
sub.f64 fd205, fd159, fd164;
mul.f64 fd206, fd205, 0d3FEBB67AE8584CAA;
sub.f64 fd207, fd204, fd206;
add.f64 fd208, fd206, fd204;
add.f64 fd209, fd169, fd174;
add.f64 fd210, fd118, fd209;
mul.f64 fd213, fd209, 0d3FE0000000000000;
sub.f64 fd214, fd118, fd213;
add.f64 fd1323, fd171, fd176;
sub.f64 fd215, fd171, fd176;
mul.f64 fd216, fd215, 0d3FEBB67AE8584CAA;
add.f64 fd217, fd216, fd214;
sub.f64 fd218, fd214, fd216;
add.f64 fd1322, fd124, fd1323;
mul.f64 fd219, fd1323, 0d3FE0000000000000;
sub.f64 fd220, fd124, fd219;
sub.f64 fd221, fd169, fd174;
mul.f64 fd222, fd221, 0d3FEBB67AE8584CAA;
sub.f64 fd223, fd220, fd222;
add.f64 fd224, fd222, fd220;
add.f64 fd225, %76, %94;
add.f64 fd226, %58, fd225;
mul.f64 fd229, fd225, 0d3FE0000000000000;
sub.f64 fd230, %58, fd229;
add.f64 fd1319, %111, %110;
sub.f64 fd231, %111, %110;
mul.f64 fd232, fd231, 0d3FEBB67AE8584CAA;
add.f64 fd233, fd232, fd230;
sub.f64 fd234, fd230, fd232;
add.f64 fd1317, %112, fd1319;
mul.f64 fd235, fd1319, 0d3FE0000000000000;
sub.f64 fd236, %112, fd235;
sub.f64 fd237, %76, %94;
mul.f64 fd238, fd237, 0d3FEBB67AE8584CAA;
sub.f64 fd239, fd236, fd238;
add.f64 fd240, fd238, fd236;
add.f64 fd241, %82, %100;
add.f64 fd242, %64, fd241;
mul.f64 fd245, fd241, 0d3FE0000000000000;
sub.f64 fd246, %64, fd245;
add.f64 fd1314, %114, %113;
sub.f64 fd247, %114, %113;
mul.f64 fd248, fd247, 0d3FEBB67AE8584CAA;
add.f64 fd249, fd248, fd246;
sub.f64 fd250, fd246, fd248;
add.f64 fd1312, %115, fd1314;
mul.f64 fd251, fd1314, 0d3FE0000000000000;
sub.f64 fd252, %115, fd251;
sub.f64 fd253, %82, %100;
mul.f64 fd254, fd253, 0d3FEBB67AE8584CAA;
sub.f64 fd255, fd252, fd254;
add.f64 fd256, fd254, fd252;
add.f64 fd257, %88, %106;
add.f64 fd258, %70, fd257;
mul.f64 fd261, fd257, 0d3FE0000000000000;
sub.f64 fd262, %70, fd261;
add.f64 fd1309, %116, %117;
sub.f64 fd263, %116, %117;
mul.f64 fd264, fd263, 0d3FEBB67AE8584CAA;
add.f64 fd265, fd264, fd262;
sub.f64 fd266, fd262, fd264;
add.f64 fd1307, %118, fd1309;
mul.f64 fd267, fd1309, 0d3FE0000000000000;
sub.f64 fd268, %118, fd267;
sub.f64 fd269, %88, %106;
mul.f64 fd270, fd269, 0d3FEBB67AE8584CAA;
sub.f64 fd271, fd268, fd270;
add.f64 fd272, fd270, fd268;
mul.f64 fd274, fd255, 0dBFE491B7523C161D;
mul.f64 fd1306, fd249, 0d3FE8836FA2CF5039;
sub.f64 fd275, fd1306, fd274;
mul.f64 fd276, fd255, 0d3FE8836FA2CF5039;
fma.rn.f64 fd277, fd249, 0dBFE491B7523C161D, fd276;
mul.f64 fd279, fd271, 0dBFEF838B8C811C17;
mul.f64 fd1305, fd265, 0d3FC63A1A7E0B738A;
sub.f64 fd280, fd1305, fd279;
mul.f64 fd281, fd271, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd282, fd265, 0dBFEF838B8C811C17, fd281;
mul.f64 fd1303, fd250, 0d3FC63A1A7E0B738A;
mul.f64 fd1304, fd256, 0dBFEF838B8C811C17;
sub.f64 fd285, fd1303, fd1304;
mul.f64 fd286, fd256, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd287, fd250, 0dBFEF838B8C811C17, fd286;
mul.f64 fd1301, fd266, 0dBFEE11F642522D1C;
mul.f64 fd1302, fd272, 0dBFD5E3A8748A0BF5;
sub.f64 fd290, fd1301, fd1302;
mul.f64 fd291, fd272, 0dBFEE11F642522D1C;
fma.rn.f64 fd292, fd266, 0dBFD5E3A8748A0BF5, fd291;
add.f64 fd293, fd242, fd258;
add.f64 fd294, fd226, fd293;
mul.f64 fd297, fd293, 0d3FE0000000000000;
sub.f64 fd298, fd226, fd297;
add.f64 fd1300, fd1312, fd1307;
sub.f64 fd299, fd1312, fd1307;
mul.f64 fd300, fd299, 0d3FEBB67AE8584CAA;
add.f64 fd301, fd300, fd298;
sub.f64 fd302, fd298, fd300;
add.f64 fd1299, fd1317, fd1300;
mul.f64 fd303, fd1300, 0d3FE0000000000000;
sub.f64 fd304, fd1317, fd303;
sub.f64 fd305, fd242, fd258;
mul.f64 fd306, fd305, 0d3FEBB67AE8584CAA;
sub.f64 fd307, fd304, fd306;
add.f64 fd308, fd306, fd304;
add.f64 fd309, fd275, fd280;
add.f64 fd310, fd233, fd309;
mul.f64 fd313, fd309, 0d3FE0000000000000;
sub.f64 fd314, fd233, fd313;
add.f64 fd1298, fd277, fd282;
sub.f64 fd315, fd277, fd282;
mul.f64 fd316, fd315, 0d3FEBB67AE8584CAA;
add.f64 fd317, fd316, fd314;
sub.f64 fd318, fd314, fd316;
add.f64 fd1297, fd239, fd1298;
mul.f64 fd319, fd1298, 0d3FE0000000000000;
sub.f64 fd320, fd239, fd319;
sub.f64 fd321, fd275, fd280;
mul.f64 fd322, fd321, 0d3FEBB67AE8584CAA;
sub.f64 fd323, fd320, fd322;
add.f64 fd324, fd322, fd320;
add.f64 fd325, fd285, fd290;
add.f64 fd326, fd234, fd325;
mul.f64 fd329, fd325, 0d3FE0000000000000;
sub.f64 fd330, fd234, fd329;
add.f64 fd1296, fd287, fd292;
sub.f64 fd331, fd287, fd292;
mul.f64 fd332, fd331, 0d3FEBB67AE8584CAA;
add.f64 fd333, fd332, fd330;
sub.f64 fd334, fd330, fd332;
add.f64 fd1295, fd240, fd1296;
mul.f64 fd335, fd1296, 0d3FE0000000000000;
sub.f64 fd336, fd240, fd335;
sub.f64 fd337, fd285, fd290;
mul.f64 fd338, fd337, 0d3FEBB67AE8584CAA;
sub.f64 fd339, fd336, fd338;
add.f64 fd340, fd338, fd336;
add.f64 fd341, %78, %96;
add.f64 fd342, %60, fd341;
mul.f64 fd345, fd341, 0d3FE0000000000000;
sub.f64 fd346, %60, fd345;
add.f64 fd1292, %119, %120;
sub.f64 fd347, %119, %120;
mul.f64 fd348, fd347, 0d3FEBB67AE8584CAA;
add.f64 fd349, fd348, fd346;
sub.f64 fd350, fd346, fd348;
add.f64 fd1290, %121, fd1292;
mul.f64 fd351, fd1292, 0d3FE0000000000000;
sub.f64 fd352, %121, fd351;
sub.f64 fd353, %78, %96;
mul.f64 fd354, fd353, 0d3FEBB67AE8584CAA;
sub.f64 fd355, fd352, fd354;
add.f64 fd356, fd354, fd352;
add.f64 fd357, %84, %102;
add.f64 fd358, %66, fd357;
mul.f64 fd361, fd357, 0d3FE0000000000000;
sub.f64 fd362, %66, fd361;
add.f64 fd1287, %123, %122;
sub.f64 fd363, %123, %122;
mul.f64 fd364, fd363, 0d3FEBB67AE8584CAA;
add.f64 fd365, fd364, fd362;
sub.f64 fd366, fd362, fd364;
add.f64 fd1285, %124, fd1287;
mul.f64 fd367, fd1287, 0d3FE0000000000000;
sub.f64 fd368, %124, fd367;
sub.f64 fd369, %84, %102;
mul.f64 fd370, fd369, 0d3FEBB67AE8584CAA;
sub.f64 fd371, fd368, fd370;
add.f64 fd372, fd370, fd368;
add.f64 fd373, %90, %108;
add.f64 fd374, %72, fd373;
mul.f64 fd377, fd373, 0d3FE0000000000000;
sub.f64 fd378, %72, fd377;
add.f64 fd1283, %125, %109;
sub.f64 fd379, %125, %109;
mul.f64 fd380, fd379, 0d3FEBB67AE8584CAA;
add.f64 fd381, fd380, fd378;
sub.f64 fd382, fd378, fd380;
add.f64 fd1281, %126, fd1283;
mul.f64 fd383, fd1283, 0d3FE0000000000000;
sub.f64 fd384, %126, fd383;
sub.f64 fd385, %90, %108;
mul.f64 fd386, fd385, 0d3FEBB67AE8584CAA;
sub.f64 fd387, fd384, fd386;
add.f64 fd388, fd386, fd384;
mul.f64 fd390, fd371, 0dBFE491B7523C161D;
mul.f64 fd1280, fd365, 0d3FE8836FA2CF5039;
sub.f64 fd391, fd1280, fd390;
mul.f64 fd392, fd371, 0d3FE8836FA2CF5039;
fma.rn.f64 fd393, fd365, 0dBFE491B7523C161D, fd392;
mul.f64 fd395, fd387, 0dBFEF838B8C811C17;
mul.f64 fd1279, fd381, 0d3FC63A1A7E0B738A;
sub.f64 fd396, fd1279, fd395;
mul.f64 fd397, fd387, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd398, fd381, 0dBFEF838B8C811C17, fd397;
mul.f64 fd1277, fd366, 0d3FC63A1A7E0B738A;
mul.f64 fd1278, fd372, 0dBFEF838B8C811C17;
sub.f64 fd401, fd1277, fd1278;
mul.f64 fd402, fd372, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd403, fd366, 0dBFEF838B8C811C17, fd402;
mul.f64 fd1275, fd382, 0dBFEE11F642522D1C;
mul.f64 fd1276, fd388, 0dBFD5E3A8748A0BF5;
sub.f64 fd406, fd1275, fd1276;
mul.f64 fd407, fd388, 0dBFEE11F642522D1C;
fma.rn.f64 fd408, fd382, 0dBFD5E3A8748A0BF5, fd407;
add.f64 fd409, fd358, fd374;
add.f64 fd410, fd342, fd409;
mul.f64 fd413, fd409, 0d3FE0000000000000;
sub.f64 fd414, fd342, fd413;
add.f64 fd1274, fd1285, fd1281;
sub.f64 fd415, fd1285, fd1281;
mul.f64 fd416, fd415, 0d3FEBB67AE8584CAA;
add.f64 fd417, fd416, fd414;
sub.f64 fd418, fd414, fd416;
add.f64 fd1273, fd1290, fd1274;
mul.f64 fd419, fd1274, 0d3FE0000000000000;
sub.f64 fd420, fd1290, fd419;
sub.f64 fd421, fd358, fd374;
mul.f64 fd422, fd421, 0d3FEBB67AE8584CAA;
sub.f64 fd423, fd420, fd422;
add.f64 fd424, fd422, fd420;
add.f64 fd425, fd391, fd396;
add.f64 fd426, fd349, fd425;
mul.f64 fd429, fd425, 0d3FE0000000000000;
sub.f64 fd430, fd349, fd429;
add.f64 fd1272, fd393, fd398;
sub.f64 fd431, fd393, fd398;
mul.f64 fd432, fd431, 0d3FEBB67AE8584CAA;
add.f64 fd433, fd432, fd430;
sub.f64 fd434, fd430, fd432;
add.f64 fd1271, fd355, fd1272;
mul.f64 fd435, fd1272, 0d3FE0000000000000;
sub.f64 fd436, fd355, fd435;
sub.f64 fd437, fd391, fd396;
mul.f64 fd438, fd437, 0d3FEBB67AE8584CAA;
sub.f64 fd439, fd436, fd438;
add.f64 fd440, fd438, fd436;
add.f64 fd441, fd401, fd406;
add.f64 fd442, fd350, fd441;
mul.f64 fd445, fd441, 0d3FE0000000000000;
sub.f64 fd446, fd350, fd445;
add.f64 fd1270, fd403, fd408;
sub.f64 fd447, fd403, fd408;
mul.f64 fd448, fd447, 0d3FEBB67AE8584CAA;
add.f64 fd449, fd448, fd446;
sub.f64 fd450, fd446, fd448;
add.f64 fd1269, fd356, fd1270;
mul.f64 fd451, fd1270, 0d3FE0000000000000;
sub.f64 fd452, fd356, fd451;
sub.f64 fd453, fd401, fd406;
mul.f64 fd454, fd453, 0d3FEBB67AE8584CAA;
sub.f64 fd455, fd452, fd454;
add.f64 fd456, fd454, fd452;
mul.f64 fd458, fd1297, 0dBFCD84D223638000;
mul.f64 fd1268, fd310, 0d3FEF232EFF15C9E6;
sub.f64 fd459, fd1268, fd458;
mul.f64 fd460, fd1297, 0d3FEF232EFF15C9E6;
fma.rn.f64 fd461, fd310, 0dBFCD84D223638000, fd460;
mul.f64 fd1266, fd426, 0d3FEC98A37A9A7850;
mul.f64 fd1267, fd1271, 0dBFDCB920325BAFA6;
sub.f64 fd464, fd1266, fd1267;
mul.f64 fd465, fd1271, 0d3FEC98A37A9A7850;
fma.rn.f64 fd466, fd426, 0dBFDCB920325BAFA6, fd465;
mul.f64 fd1264, fd326, 0d3FEC98A37A9A7850;
mul.f64 fd1265, fd1295, 0dBFDCB920325BAFA6;
sub.f64 fd469, fd1264, fd1265;
mul.f64 fd470, fd1295, 0d3FEC98A37A9A7850;
fma.rn.f64 fd471, fd326, 0dBFDCB920325BAFA6, fd470;
mul.f64 fd1262, fd442, 0d3FE31BEC55BC71BC;
mul.f64 fd1263, fd1269, 0dBFE9AAFE4207DF5F;
sub.f64 fd474, fd1262, fd1263;
mul.f64 fd475, fd1269, 0d3FE31BEC55BC71BC;
fma.rn.f64 fd476, fd442, 0dBFE9AAFE4207DF5F, fd475;
mul.f64 fd1260, fd301, 0d3FE8836FA2CF5039;
mul.f64 fd1261, fd307, 0dBFE491B7523C161D;
sub.f64 fd479, fd1260, fd1261;
mul.f64 fd480, fd307, 0d3FE8836FA2CF5039;
fma.rn.f64 fd481, fd301, 0dBFE491B7523C161D, fd480;
mul.f64 fd483, fd423, 0dBFEF838B8C811C17;
mul.f64 fd1259, fd417, 0d3FC63A1A7E0B738A;
sub.f64 fd484, fd1259, fd483;
mul.f64 fd485, fd423, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd486, fd417, 0dBFEF838B8C811C17, fd485;
mul.f64 fd488, fd323, 0dBFE9AAFE4207DF5F;
mul.f64 fd1258, fd317, 0d3FE31BEC55BC71BC;
sub.f64 fd489, fd1258, fd488;
mul.f64 fd490, fd323, 0d3FE31BEC55BC71BC;
fma.rn.f64 fd491, fd317, 0dBFE9AAFE4207DF5F, fd490;
mul.f64 fd493, fd439, 0dBFEEA7D99F29CADE;
mul.f64 fd1257, fd433, 0dBFD25AFBF23865BF;
sub.f64 fd494, fd1257, fd493;
mul.f64 fd495, fd439, 0dBFD25AFBF23865BF;
fma.rn.f64 fd496, fd433, 0dBFEEA7D99F29CADE, fd495;
mul.f64 fd498, fd339, 0dBFED6206BEB6C24B;
mul.f64 fd1256, fd333, 0d3FD9595EF26FB670;
sub.f64 fd499, fd1256, fd498;
mul.f64 fd500, fd339, 0d3FD9595EF26FB670;
fma.rn.f64 fd501, fd333, 0dBFED6206BEB6C24B, fd500;
mul.f64 fd503, fd455, 0dBFE746A51650EADE;
mul.f64 fd1255, fd449, 0dBFE5F5B105F99707;
sub.f64 fd504, fd1255, fd503;
mul.f64 fd505, fd455, 0dBFE5F5B105F99707;
fma.rn.f64 fd506, fd449, 0dBFE746A51650EADE, fd505;
mul.f64 fd508, fd308, 0dBFEF838B8C811C17;
mul.f64 fd1254, fd302, 0d3FC63A1A7E0B738A;
sub.f64 fd509, fd1254, fd508;
mul.f64 fd510, fd308, 0d3FC63A1A7E0B738A;
fma.rn.f64 fd511, fd302, 0dBFEF838B8C811C17, fd510;
mul.f64 fd1252, fd418, 0dBFEE11F642522D1C;
mul.f64 fd1253, fd424, 0dBFD5E3A8748A0BF5;
sub.f64 fd514, fd1252, fd1253;
mul.f64 fd515, fd424, 0dBFEE11F642522D1C;
fma.rn.f64 fd516, fd418, 0dBFD5E3A8748A0BF5, fd515;
mul.f64 fd1250, fd318, 0dBFADC528B5343A86;
mul.f64 fd1251, fd324, 0dBFEFF223F3635CE3;
sub.f64 fd519, fd1250, fd1251;
mul.f64 fd520, fd324, 0dBFADC528B5343A86;
fma.rn.f64 fd521, fd318, 0dBFEFF223F3635CE3, fd520;
mul.f64 fd1248, fd434, 0dBFEFC89BCEF44CF4;
mul.f64 fd1249, fd440, 0d3FBDB843E577175E;
sub.f64 fd524, fd1248, fd1249;
mul.f64 fd525, fd440, 0dBFEFC89BCEF44CF4;
fma.rn.f64 fd526, fd434, 0d3FBDB843E577175E, fd525;
mul.f64 fd528, fd340, 0dBFEEA7D99F29CADE;
mul.f64 fd1247, fd334, 0dBFD25AFBF23865BF;
sub.f64 fd529, fd1247, fd528;
mul.f64 fd530, fd340, 0dBFD25AFBF23865BF;
fma.rn.f64 fd531, fd334, 0dBFEEA7D99F29CADE, fd530;
mul.f64 fd533, fd456, 0d3FE19593DA358510;
mul.f64 fd1246, fd450, 0dBFEABC50EF4734A7;
sub.f64 fd534, fd1246, fd533;
mul.f64 fd535, fd456, 0dBFEABC50EF4734A7;
fma.rn.f64 fd536, fd450, 0d3FE19593DA358510, fd535;
add.f64 fd537, fd294, fd410;
add.f64 fd538, fd178, fd537;
mul.f64 fd541, fd537, 0d3FE0000000000000;
sub.f64 fd542, fd178, fd541;
add.f64 fd1245, fd1299, fd1273;
sub.f64 fd543, fd1299, fd1273;
mul.f64 fd544, fd543, 0d3FEBB67AE8584CAA;
add.f64 fd545, fd544, fd542;
sub.f64 fd546, fd542, fd544;
add.f64 fd1244, fd1326, fd1245;
mul.f64 fd547, fd1245, 0d3FE0000000000000;
sub.f64 fd548, fd1326, fd547;
sub.f64 fd549, fd294, fd410;
mul.f64 fd550, fd549, 0d3FEBB67AE8584CAA;
sub.f64 fd551, fd548, fd550;
add.f64 fd552, fd550, fd548;
add.f64 fd553, fd459, fd464;
add.f64 fd554, fd194, fd553;
mul.f64 fd557, fd553, 0d3FE0000000000000;
sub.f64 fd558, fd194, fd557;
add.f64 fd1243, fd461, fd466;
sub.f64 fd559, fd461, fd466;
mul.f64 fd560, fd559, 0d3FEBB67AE8584CAA;
add.f64 fd561, fd560, fd558;
sub.f64 fd562, fd558, fd560;
add.f64 fd1242, fd1324, fd1243;
mul.f64 fd563, fd1243, 0d3FE0000000000000;
sub.f64 fd564, fd1324, fd563;
sub.f64 fd565, fd459, fd464;
mul.f64 fd566, fd565, 0d3FEBB67AE8584CAA;
sub.f64 fd567, fd564, fd566;
add.f64 fd568, fd566, fd564;
add.f64 fd569, fd469, fd474;
add.f64 fd570, fd210, fd569;
mul.f64 fd573, fd569, 0d3FE0000000000000;
sub.f64 fd574, fd210, fd573;
add.f64 fd1241, fd471, fd476;
sub.f64 fd575, fd471, fd476;
mul.f64 fd576, fd575, 0d3FEBB67AE8584CAA;
add.f64 fd577, fd576, fd574;
sub.f64 fd578, fd574, fd576;
add.f64 fd1240, fd1322, fd1241;
mul.f64 fd579, fd1241, 0d3FE0000000000000;
sub.f64 fd580, fd1322, fd579;
sub.f64 fd581, fd469, fd474;
mul.f64 fd582, fd581, 0d3FEBB67AE8584CAA;
sub.f64 fd583, fd580, fd582;
add.f64 fd584, fd582, fd580;
add.f64 fd585, fd479, fd484;
add.f64 fd586, fd185, fd585;
mul.f64 fd589, fd585, 0d3FE0000000000000;
sub.f64 fd590, fd185, fd589;
add.f64 fd1239, fd481, fd486;
sub.f64 fd591, fd481, fd486;
mul.f64 fd592, fd591, 0d3FEBB67AE8584CAA;
add.f64 fd593, fd592, fd590;
sub.f64 fd594, fd590, fd592;
add.f64 fd1238, fd191, fd1239;
mul.f64 fd595, fd1239, 0d3FE0000000000000;
sub.f64 fd596, fd191, fd595;
sub.f64 fd597, fd479, fd484;
mul.f64 fd598, fd597, 0d3FEBB67AE8584CAA;
sub.f64 fd599, fd596, fd598;
add.f64 fd600, fd598, fd596;
add.f64 fd601, fd489, fd494;
add.f64 fd602, fd201, fd601;
mul.f64 fd605, fd601, 0d3FE0000000000000;
sub.f64 fd606, fd201, fd605;
add.f64 fd1237, fd491, fd496;
sub.f64 fd607, fd491, fd496;
mul.f64 fd608, fd607, 0d3FEBB67AE8584CAA;
add.f64 fd609, fd608, fd606;
sub.f64 fd610, fd606, fd608;
add.f64 fd1236, fd207, fd1237;
mul.f64 fd611, fd1237, 0d3FE0000000000000;
sub.f64 fd612, fd207, fd611;
sub.f64 fd613, fd489, fd494;
mul.f64 fd614, fd613, 0d3FEBB67AE8584CAA;
sub.f64 fd615, fd612, fd614;
add.f64 fd616, fd614, fd612;
add.f64 fd617, fd499, fd504;
add.f64 fd618, fd217, fd617;
mul.f64 fd621, fd617, 0d3FE0000000000000;
sub.f64 fd622, fd217, fd621;
add.f64 fd1235, fd501, fd506;
sub.f64 fd623, fd501, fd506;
mul.f64 fd624, fd623, 0d3FEBB67AE8584CAA;
add.f64 fd625, fd624, fd622;
sub.f64 fd626, fd622, fd624;
add.f64 fd1234, fd223, fd1235;
mul.f64 fd627, fd1235, 0d3FE0000000000000;
sub.f64 fd628, fd223, fd627;
sub.f64 fd629, fd499, fd504;
mul.f64 fd630, fd629, 0d3FEBB67AE8584CAA;
sub.f64 fd631, fd628, fd630;
add.f64 fd632, fd630, fd628;
add.f64 fd633, fd509, fd514;
add.f64 fd634, fd186, fd633;
mul.f64 fd637, fd633, 0d3FE0000000000000;
sub.f64 fd638, fd186, fd637;
add.f64 fd1233, fd511, fd516;
sub.f64 fd639, fd511, fd516;
mul.f64 fd640, fd639, 0d3FEBB67AE8584CAA;
add.f64 fd641, fd640, fd638;
sub.f64 fd642, fd638, fd640;
add.f64 fd1232, fd192, fd1233;
mul.f64 fd643, fd1233, 0d3FE0000000000000;
sub.f64 fd644, fd192, fd643;
sub.f64 fd645, fd509, fd514;
mul.f64 fd646, fd645, 0d3FEBB67AE8584CAA;
sub.f64 fd647, fd644, fd646;
add.f64 fd648, fd646, fd644;
add.f64 fd649, fd519, fd524;
add.f64 fd650, fd202, fd649;
mul.f64 fd653, fd649, 0d3FE0000000000000;
sub.f64 fd654, fd202, fd653;
add.f64 fd1231, fd521, fd526;
sub.f64 fd655, fd521, fd526;
mul.f64 fd656, fd655, 0d3FEBB67AE8584CAA;
add.f64 fd657, fd656, fd654;
sub.f64 fd658, fd654, fd656;
add.f64 fd1230, fd208, fd1231;
mul.f64 fd659, fd1231, 0d3FE0000000000000;
sub.f64 fd660, fd208, fd659;
sub.f64 fd661, fd519, fd524;
mul.f64 fd662, fd661, 0d3FEBB67AE8584CAA;
sub.f64 fd663, fd660, fd662;
add.f64 fd664, fd662, fd660;
add.f64 fd665, fd529, fd534;
add.f64 fd666, fd218, fd665;
mul.f64 fd669, fd665, 0d3FE0000000000000;
sub.f64 fd670, fd218, fd669;
add.f64 fd1229, fd531, fd536;
sub.f64 fd671, fd531, fd536;
mul.f64 fd672, fd671, 0d3FEBB67AE8584CAA;
add.f64 fd673, fd672, fd670;
sub.f64 fd674, fd670, fd672;
add.f64 fd1228, fd224, fd1229;
mul.f64 fd675, fd1229, 0d3FE0000000000000;
sub.f64 fd676, fd224, fd675;
sub.f64 fd677, fd529, fd534;
mul.f64 fd678, fd677, 0d3FEBB67AE8584CAA;
sub.f64 fd679, fd676, fd678;
add.f64 fd680, fd678, fd676;
mov.u32 r11, %tid.x;
mul.wide.u32 rd2, r11, -1431655765;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 3;
sub.s32 r7, r11, r6;
mov.u64 rd5, %55;
mul.wide.u32 rd7, r7, 16;
add.s64 rd6, rd5, rd7;
ld.global.v2.f64 {fd681, fd682}, [rd6];
mul.f64 fd686, fd682, fd1242;
mul.f64 fd1227, fd681, fd554;
sub.f64 fd687, fd1227, fd686;
mul.f64 fd688, fd681, fd1242;
fma.rn.f64 fd689, fd682, fd554, fd688;
mul.f64 fd691, fd682, fd682;
mul.f64 fd1226, fd681, fd681;
sub.f64 fd692, fd1226, fd691;
mul.f64 fd693, fd682, fd681;
fma.rn.f64 fd694, fd682, fd681, fd693;
mul.f64 fd696, fd694, fd1240;
mul.f64 fd1225, fd692, fd570;
sub.f64 fd697, fd1225, fd696;
mul.f64 fd698, fd692, fd1240;
fma.rn.f64 fd699, fd694, fd570, fd698;
mul.f64 fd701, fd682, fd694;
mul.f64 fd1224, fd681, fd692;
sub.f64 fd702, fd1224, fd701;
mul.f64 fd703, fd681, fd694;
fma.rn.f64 fd704, fd682, fd692, fd703;
mul.f64 fd706, fd704, fd1238;
mul.f64 fd1223, fd702, fd586;
sub.f64 fd707, fd1223, fd706;
mul.f64 fd708, fd702, fd1238;
fma.rn.f64 fd709, fd704, fd586, fd708;
mul.f64 fd1221, fd681, fd702;
mul.f64 fd1222, fd682, fd704;
sub.f64 fd712, fd1221, fd1222;
mul.f64 fd713, fd681, fd704;
fma.rn.f64 fd714, fd682, fd702, fd713;
mul.f64 fd1219, fd712, fd602;
mul.f64 fd1220, fd714, fd1236;
sub.f64 fd717, fd1219, fd1220;
mul.f64 fd718, fd712, fd1236;
fma.rn.f64 fd719, fd714, fd602, fd718;
mul.f64 fd1217, fd681, fd712;
mul.f64 fd1218, fd682, fd714;
sub.f64 fd722, fd1217, fd1218;
mul.f64 fd723, fd681, fd714;
fma.rn.f64 fd724, fd682, fd712, fd723;
mul.f64 fd1215, fd722, fd618;
mul.f64 fd1216, fd724, fd1234;
sub.f64 fd727, fd1215, fd1216;
mul.f64 fd728, fd722, fd1234;
fma.rn.f64 fd729, fd724, fd618, fd728;
mul.f64 fd731, fd682, fd724;
mul.f64 fd1214, fd681, fd722;
sub.f64 fd732, fd1214, fd731;
mul.f64 fd733, fd681, fd724;
fma.rn.f64 fd734, fd682, fd722, fd733;
mul.f64 fd736, fd734, fd1232;
mul.f64 fd1213, fd732, fd634;
sub.f64 fd737, fd1213, fd736;
mul.f64 fd738, fd732, fd1232;
fma.rn.f64 fd739, fd734, fd634, fd738;
mul.f64 fd741, fd682, fd734;
mul.f64 fd1212, fd681, fd732;
sub.f64 fd742, fd1212, fd741;
mul.f64 fd743, fd681, fd734;
fma.rn.f64 fd744, fd682, fd732, fd743;
mul.f64 fd746, fd744, fd1230;
mul.f64 fd1211, fd742, fd650;
sub.f64 fd747, fd1211, fd746;
mul.f64 fd748, fd742, fd1230;
fma.rn.f64 fd749, fd744, fd650, fd748;
mul.f64 fd751, fd682, fd744;
mul.f64 fd1210, fd681, fd742;
sub.f64 fd752, fd1210, fd751;
mul.f64 fd753, fd681, fd744;
fma.rn.f64 fd754, fd682, fd742, fd753;
mul.f64 fd756, fd754, fd1228;
mul.f64 fd1209, fd752, fd666;
sub.f64 fd757, fd1209, fd756;
mul.f64 fd758, fd752, fd1228;
fma.rn.f64 fd759, fd754, fd666, fd758;
mul.f64 fd1207, fd681, fd752;
mul.f64 fd1208, fd682, fd754;
sub.f64 fd762, fd1207, fd1208;
mul.f64 fd763, fd681, fd754;
fma.rn.f64 fd764, fd682, fd752, fd763;
mul.f64 fd1205, fd762, fd545;
mul.f64 fd1206, fd764, fd551;
sub.f64 fd767, fd1205, fd1206;
mul.f64 fd768, fd762, fd551;
fma.rn.f64 fd769, fd764, fd545, fd768;
mul.f64 fd1203, fd681, fd762;
mul.f64 fd1204, fd682, fd764;
sub.f64 fd772, fd1203, fd1204;
mul.f64 fd773, fd681, fd764;
fma.rn.f64 fd774, fd682, fd762, fd773;
mul.f64 fd776, fd774, fd567;
mul.f64 fd1202, fd772, fd561;
sub.f64 fd777, fd1202, fd776;
mul.f64 fd778, fd772, fd567;
fma.rn.f64 fd779, fd774, fd561, fd778;
mul.f64 fd781, fd682, fd774;
mul.f64 fd1201, fd681, fd772;
sub.f64 fd782, fd1201, fd781;
mul.f64 fd783, fd681, fd774;
fma.rn.f64 fd784, fd682, fd772, fd783;
mul.f64 fd786, fd784, fd583;
mul.f64 fd1200, fd782, fd577;
sub.f64 fd787, fd1200, fd786;
mul.f64 fd788, fd782, fd583;
fma.rn.f64 fd789, fd784, fd577, fd788;
mul.f64 fd791, fd682, fd784;
mul.f64 fd1199, fd681, fd782;
sub.f64 fd792, fd1199, fd791;
mul.f64 fd793, fd681, fd784;
fma.rn.f64 fd794, fd682, fd782, fd793;
mul.f64 fd796, fd794, fd599;
mul.f64 fd1198, fd792, fd593;
sub.f64 fd797, fd1198, fd796;
mul.f64 fd798, fd792, fd599;
fma.rn.f64 fd799, fd794, fd593, fd798;
mul.f64 fd801, fd682, fd794;
mul.f64 fd1197, fd681, fd792;
sub.f64 fd802, fd1197, fd801;
mul.f64 fd803, fd681, fd794;
fma.rn.f64 fd804, fd682, fd792, fd803;
mul.f64 fd1195, fd802, fd609;
mul.f64 fd1196, fd804, fd615;
sub.f64 fd807, fd1195, fd1196;
mul.f64 fd808, fd802, fd615;
fma.rn.f64 fd809, fd804, fd609, fd808;
ld.global.v2.f64 {fd810, fd811}, [rd6+48];
mul.f64 fd815, fd811, fd631;
mul.f64 fd1194, fd810, fd625;
sub.f64 fd816, fd1194, fd815;
mul.f64 fd817, fd810, fd631;
fma.rn.f64 fd818, fd811, fd625, fd817;
mul.f64 fd820, fd682, fd811;
mul.f64 fd1193, fd681, fd810;
sub.f64 fd821, fd1193, fd820;
mul.f64 fd822, fd681, fd811;
fma.rn.f64 fd823, fd682, fd810, fd822;
mul.f64 fd1191, fd821, fd641;
mul.f64 fd1192, fd823, fd647;
sub.f64 fd826, fd1191, fd1192;
mul.f64 fd827, fd821, fd647;
fma.rn.f64 fd828, fd823, fd641, fd827;
mul.f64 fd1189, fd681, fd821;
mul.f64 fd1190, fd682, fd823;
sub.f64 fd831, fd1189, fd1190;
mul.f64 fd832, fd681, fd823;
fma.rn.f64 fd833, fd682, fd821, fd832;
mul.f64 fd1187, fd831, fd657;
mul.f64 fd1188, fd833, fd663;
sub.f64 fd836, fd1187, fd1188;
mul.f64 fd837, fd831, fd663;
fma.rn.f64 fd838, fd833, fd657, fd837;
mul.f64 fd840, fd682, fd833;
mul.f64 fd1186, fd681, fd831;
sub.f64 fd841, fd1186, fd840;
mul.f64 fd842, fd681, fd833;
fma.rn.f64 fd843, fd682, fd831, fd842;
mul.f64 fd845, fd843, fd679;
mul.f64 fd1185, fd841, fd673;
sub.f64 fd846, fd1185, fd845;
mul.f64 fd847, fd841, fd679;
fma.rn.f64 fd848, fd843, fd673, fd847;
mul.f64 fd850, fd682, fd843;
mul.f64 fd1184, fd681, fd841;
sub.f64 fd851, fd1184, fd850;
mul.f64 fd852, fd681, fd843;
fma.rn.f64 fd853, fd682, fd841, fd852;
mul.f64 fd855, fd853, fd552;
mul.f64 fd1183, fd851, fd546;
sub.f64 fd856, fd1183, fd855;
mul.f64 fd857, fd851, fd552;
fma.rn.f64 fd858, fd853, fd546, fd857;
mul.f64 fd860, fd682, fd853;
mul.f64 fd1182, fd681, fd851;
sub.f64 fd861, fd1182, fd860;
mul.f64 fd862, fd681, fd853;
fma.rn.f64 fd863, fd682, fd851, fd862;
mul.f64 fd865, fd863, fd568;
mul.f64 fd1181, fd861, fd562;
sub.f64 fd866, fd1181, fd865;
mul.f64 fd867, fd861, fd568;
fma.rn.f64 fd868, fd863, fd562, fd867;
mul.f64 fd1179, fd681, fd861;
mul.f64 fd1180, fd682, fd863;
sub.f64 fd871, fd1179, fd1180;
mul.f64 fd872, fd681, fd863;
fma.rn.f64 fd873, fd682, fd861, fd872;
mul.f64 fd1177, fd871, fd578;
mul.f64 fd1178, fd873, fd584;
sub.f64 fd876, fd1177, fd1178;
mul.f64 fd877, fd871, fd584;
fma.rn.f64 fd878, fd873, fd578, fd877;
mul.f64 fd1175, fd681, fd871;
mul.f64 fd1176, fd682, fd873;
sub.f64 fd881, fd1175, fd1176;
mul.f64 fd882, fd681, fd873;
fma.rn.f64 fd883, fd682, fd871, fd882;
mul.f64 fd1173, fd881, fd594;
mul.f64 fd1174, fd883, fd600;
sub.f64 fd886, fd1173, fd1174;
mul.f64 fd887, fd881, fd600;
fma.rn.f64 fd888, fd883, fd594, fd887;
mul.f64 fd890, fd682, fd883;
mul.f64 fd1172, fd681, fd881;
sub.f64 fd891, fd1172, fd890;
mul.f64 fd892, fd681, fd883;
fma.rn.f64 fd893, fd682, fd881, fd892;
mul.f64 fd895, fd893, fd616;
mul.f64 fd1171, fd891, fd610;
sub.f64 fd896, fd1171, fd895;
mul.f64 fd897, fd891, fd616;
fma.rn.f64 fd898, fd893, fd610, fd897;
mul.f64 fd900, fd682, fd893;
mul.f64 fd1170, fd681, fd891;
sub.f64 fd901, fd1170, fd900;
mul.f64 fd902, fd681, fd893;
fma.rn.f64 fd903, fd682, fd891, fd902;
mul.f64 fd905, fd903, fd632;
mul.f64 fd1169, fd901, fd626;
sub.f64 fd906, fd1169, fd905;
mul.f64 fd907, fd901, fd632;
fma.rn.f64 fd908, fd903, fd626, fd907;
mul.f64 fd910, fd682, fd903;
mul.f64 fd1168, fd681, fd901;
sub.f64 fd911, fd1168, fd910;
mul.f64 fd912, fd681, fd903;
fma.rn.f64 fd913, fd682, fd901, fd912;
mul.f64 fd1166, fd911, fd642;
mul.f64 fd1167, fd913, fd648;
sub.f64 fd916, fd1166, fd1167;
mul.f64 fd917, fd911, fd648;
fma.rn.f64 fd918, fd913, fd642, fd917;
mul.f64 fd1164, fd681, fd911;
mul.f64 fd1165, fd682, fd913;
sub.f64 fd921, fd1164, fd1165;
mul.f64 fd922, fd681, fd913;
fma.rn.f64 fd923, fd682, fd911, fd922;
mul.f64 fd1162, fd921, fd658;
mul.f64 fd1163, fd923, fd664;
sub.f64 fd926, fd1162, fd1163;
mul.f64 fd927, fd921, fd664;
fma.rn.f64 fd928, fd923, fd658, fd927;
mul.f64 fd1160, fd681, fd921;
mul.f64 fd1161, fd682, fd923;
sub.f64 fd931, fd1160, fd1161;
mul.f64 fd932, fd681, fd923;
fma.rn.f64 fd933, fd682, fd921, fd932;
mul.f64 fd935, fd933, fd680;
mul.f64 fd1159, fd931, fd674;
sub.f64 fd936, fd1159, fd935;
mul.f64 fd937, fd931, fd680;
fma.rn.f64 fd938, fd933, fd674, fd937;
mad.lo.s32 r8, r5, 648, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 216, r8;
st.shared.f64 [r9], fd538;
st.shared.f64 [r9+8], fd687;
st.shared.f64 [r9+16], fd697;
st.shared.f64 [r9+24], fd707;
st.shared.f64 [r9+32], fd717;
st.shared.f64 [r9+40], fd727;
st.shared.f64 [r9+48], fd737;
st.shared.f64 [r9+56], fd747;
st.shared.f64 [r9+64], fd757;
st.shared.f64 [r9+72], fd767;
st.shared.f64 [r9+80], fd777;
st.shared.f64 [r9+88], fd787;
st.shared.f64 [r9+96], fd797;
st.shared.f64 [r9+104], fd807;
st.shared.f64 [r9+112], fd816;
st.shared.f64 [r9+120], fd826;
st.shared.f64 [r9+128], fd836;
st.shared.f64 [r9+136], fd846;
st.shared.f64 [r9+144], fd856;
st.shared.f64 [r9+152], fd866;
st.shared.f64 [r9+160], fd876;
st.shared.f64 [r9+168], fd886;
st.shared.f64 [r9+176], fd896;
st.shared.f64 [r9+184], fd906;
st.shared.f64 [r9+192], fd916;
st.shared.f64 [r9+200], fd926;
st.shared.f64 [r9+208], fd936;
barrier.sync 0;
mad.lo.s32 r10, r7, -208, r9;
ld.shared.f64 fd939, [r10];
ld.shared.f64 fd940, [r10+24];
ld.shared.f64 fd941, [r10+48];
ld.shared.f64 fd942, [r10+72];
ld.shared.f64 fd943, [r10+96];
ld.shared.f64 fd944, [r10+120];
ld.shared.f64 fd945, [r10+144];
ld.shared.f64 fd946, [r10+168];
ld.shared.f64 fd947, [r10+192];
ld.shared.f64 fd948, [r10+216];
ld.shared.f64 fd949, [r10+240];
ld.shared.f64 fd950, [r10+264];
ld.shared.f64 fd951, [r10+288];
ld.shared.f64 fd952, [r10+312];
ld.shared.f64 fd953, [r10+336];
ld.shared.f64 fd954, [r10+360];
ld.shared.f64 fd955, [r10+384];
ld.shared.f64 fd956, [r10+408];
ld.shared.f64 fd957, [r10+432];
ld.shared.f64 fd958, [r10+456];
ld.shared.f64 fd959, [r10+480];
ld.shared.f64 fd960, [r10+504];
ld.shared.f64 fd961, [r10+528];
ld.shared.f64 fd962, [r10+552];
ld.shared.f64 fd963, [r10+576];
ld.shared.f64 fd964, [r10+600];
ld.shared.f64 fd965, [r10+624];
barrier.sync 0;
st.shared.f64 [r9], fd1244;
st.shared.f64 [r9+8], fd689;
st.shared.f64 [r9+16], fd699;
st.shared.f64 [r9+24], fd709;
st.shared.f64 [r9+32], fd719;
st.shared.f64 [r9+40], fd729;
st.shared.f64 [r9+48], fd739;
st.shared.f64 [r9+56], fd749;
st.shared.f64 [r9+64], fd759;
st.shared.f64 [r9+72], fd769;
st.shared.f64 [r9+80], fd779;
st.shared.f64 [r9+88], fd789;
st.shared.f64 [r9+96], fd799;
st.shared.f64 [r9+104], fd809;
st.shared.f64 [r9+112], fd818;
st.shared.f64 [r9+120], fd828;
st.shared.f64 [r9+128], fd838;
st.shared.f64 [r9+136], fd848;
st.shared.f64 [r9+144], fd858;
st.shared.f64 [r9+152], fd868;
st.shared.f64 [r9+160], fd878;
st.shared.f64 [r9+168], fd888;
st.shared.f64 [r9+176], fd898;
st.shared.f64 [r9+184], fd908;
st.shared.f64 [r9+192], fd918;
st.shared.f64 [r9+200], fd928;
st.shared.f64 [r9+208], fd938;
barrier.sync 0;
ld.shared.f64 fd966, [r10];
ld.shared.f64 fd967, [r10+24];
ld.shared.f64 fd968, [r10+48];
ld.shared.f64 fd969, [r10+72];
ld.shared.f64 fd970, [r10+96];
ld.shared.f64 fd971, [r10+120];
ld.shared.f64 fd972, [r10+144];
ld.shared.f64 fd973, [r10+168];
ld.shared.f64 fd974, [r10+192];
ld.shared.f64 fd975, [r10+216];
ld.shared.f64 fd976, [r10+240];
ld.shared.f64 fd977, [r10+264];
ld.shared.f64 fd978, [r10+288];
ld.shared.f64 fd979, [r10+312];
ld.shared.f64 fd980, [r10+336];
ld.shared.f64 fd981, [r10+360];
ld.shared.f64 fd982, [r10+384];
ld.shared.f64 fd983, [r10+408];
ld.shared.f64 fd984, [r10+432];
ld.shared.f64 fd985, [r10+456];
ld.shared.f64 fd986, [r10+480];
ld.shared.f64 fd987, [r10+504];
ld.shared.f64 fd988, [r10+528];
ld.shared.f64 fd989, [r10+552];
ld.shared.f64 fd990, [r10+576];
ld.shared.f64 fd991, [r10+600];
ld.shared.f64 fd992, [r10+624];
add.f64 fd993, fd948, fd957;
mul.f64 fd995, fd993, 0d3FE0000000000000;
sub.f64 fd996, fd939, fd995;
add.f64 fd1158, fd975, fd984;
sub.f64 fd997, fd975, fd984;
mul.f64 fd998, fd997, 0d3FEBB67AE8584CAA;
mul.f64 fd999, fd1158, 0d3FE0000000000000;
sub.f64 fd1000, fd966, fd999;
sub.f64 fd1001, fd948, fd957;
mul.f64 fd1002, fd1001, 0d3FEBB67AE8584CAA;
add.f64 fd1003, fd949, fd958;
mul.f64 fd1005, fd1003, 0d3FE0000000000000;
sub.f64 fd1006, fd940, fd1005;
add.f64 fd1157, fd976, fd985;
sub.f64 fd1007, fd976, fd985;
mul.f64 fd1008, fd1007, 0d3FEBB67AE8584CAA;
mul.f64 fd1009, fd1157, 0d3FE0000000000000;
sub.f64 fd1010, fd967, fd1009;
sub.f64 fd1011, fd949, fd958;
mul.f64 fd1012, fd1011, 0d3FEBB67AE8584CAA;
add.f64 fd1013, fd950, fd959;
mul.f64 fd1015, fd1013, 0d3FE0000000000000;
sub.f64 fd1016, fd941, fd1015;
add.f64 fd1156, fd977, fd986;
sub.f64 fd1017, fd977, fd986;
mul.f64 fd1018, fd1017, 0d3FEBB67AE8584CAA;
mul.f64 fd1019, fd1156, 0d3FE0000000000000;
sub.f64 fd1020, fd968, fd1019;
sub.f64 fd1021, fd950, fd959;
mul.f64 fd1022, fd1021, 0d3FEBB67AE8584CAA;
add.f64 fd1023, fd951, fd960;
mul.f64 fd1025, fd1023, 0d3FE0000000000000;
sub.f64 fd1026, fd942, fd1025;
add.f64 fd1155, fd978, fd987;
sub.f64 fd1027, fd978, fd987;
mul.f64 fd1028, fd1027, 0d3FEBB67AE8584CAA;
mul.f64 fd1029, fd1155, 0d3FE0000000000000;
sub.f64 fd1030, fd969, fd1029;
sub.f64 fd1031, fd951, fd960;
mul.f64 fd1032, fd1031, 0d3FEBB67AE8584CAA;
add.f64 fd1033, fd952, fd961;
mul.f64 fd1035, fd1033, 0d3FE0000000000000;
sub.f64 fd1036, fd943, fd1035;
add.f64 fd1154, fd979, fd988;
sub.f64 fd1037, fd979, fd988;
mul.f64 fd1038, fd1037, 0d3FEBB67AE8584CAA;
mul.f64 fd1039, fd1154, 0d3FE0000000000000;
sub.f64 fd1040, fd970, fd1039;
sub.f64 fd1041, fd952, fd961;
mul.f64 fd1042, fd1041, 0d3FEBB67AE8584CAA;
add.f64 fd1043, fd953, fd962;
mul.f64 fd1045, fd1043, 0d3FE0000000000000;
sub.f64 fd1046, fd944, fd1045;
add.f64 fd1153, fd980, fd989;
sub.f64 fd1047, fd980, fd989;
mul.f64 fd1048, fd1047, 0d3FEBB67AE8584CAA;
mul.f64 fd1049, fd1153, 0d3FE0000000000000;
sub.f64 fd1050, fd971, fd1049;
sub.f64 fd1051, fd953, fd962;
mul.f64 fd1052, fd1051, 0d3FEBB67AE8584CAA;
add.f64 fd1053, fd954, fd963;
mul.f64 fd1055, fd1053, 0d3FE0000000000000;
sub.f64 fd1056, fd945, fd1055;
add.f64 fd1152, fd981, fd990;
sub.f64 fd1057, fd981, fd990;
mul.f64 fd1058, fd1057, 0d3FEBB67AE8584CAA;
mul.f64 fd1059, fd1152, 0d3FE0000000000000;
sub.f64 fd1060, fd972, fd1059;
sub.f64 fd1061, fd954, fd963;
mul.f64 fd1062, fd1061, 0d3FEBB67AE8584CAA;
add.f64 fd1063, fd955, fd964;
mul.f64 fd1065, fd1063, 0d3FE0000000000000;
sub.f64 fd1066, fd946, fd1065;
add.f64 fd1151, fd982, fd991;
sub.f64 fd1067, fd982, fd991;
mul.f64 fd1068, fd1067, 0d3FEBB67AE8584CAA;
mul.f64 fd1069, fd1151, 0d3FE0000000000000;
sub.f64 fd1070, fd973, fd1069;
sub.f64 fd1071, fd955, fd964;
mul.f64 fd1072, fd1071, 0d3FEBB67AE8584CAA;
add.f64 fd1073, fd956, fd965;
mul.f64 fd1075, fd1073, 0d3FE0000000000000;
sub.f64 fd1076, fd947, fd1075;
add.f64 fd1150, fd983, fd992;
sub.f64 fd1077, fd983, fd992;
mul.f64 fd1078, fd1077, 0d3FEBB67AE8584CAA;
mul.f64 fd1079, fd1150, 0d3FE0000000000000;
sub.f64 fd1080, fd974, fd1079;
sub.f64 fd1081, fd956, fd965;
mul.f64 fd1342, fd1013, 0d3FE0000000000000;
sub.f64 fd1341, fd941, fd1342;
mul.f64 fd1082, fd1081, 0d3FEBB67AE8584CAA;
add.f64 %0, fd939, fd993;
mul.f64 fd1344, fd1155, 0d3FE0000000000000;
sub.f64 fd1343, fd969, fd1344;
add.f64 %1, fd966, fd1158;
mul.f64 fd1346, fd1013, 0d3FE0000000000000;
sub.f64 fd1345, fd941, fd1346;
mul.f64 fd1348, fd1003, 0d3FE0000000000000;
sub.f64 fd1347, fd940, fd1348;
add.f64 %2, fd940, fd1003;
add.f64 %3, fd967, fd1157;
add.f64 %4, fd941, fd1013;
add.f64 %5, fd968, fd1156;
add.f64 %6, fd942, fd1023;
add.f64 %7, fd969, fd1155;
add.f64 %8, fd943, fd1033;
add.f64 %9, fd970, fd1154;
add.f64 %10, fd944, fd1043;
add.f64 %11, fd971, fd1153;
add.f64 %12, fd945, fd1053;
add.f64 %13, fd972, fd1152;
add.f64 %14, fd946, fd1063;
add.f64 %15, fd973, fd1151;
add.f64 %16, fd947, fd1073;
add.f64 %17, fd974, fd1150;
add.f64 %18, fd998, fd996;
sub.f64 %19, fd1000, fd1002;
add.f64 %20, fd1008, fd1347;
sub.f64 %21, fd1010, fd1012;
sub.f64 %23, fd1020, fd1022;
add.f64 %22, fd1018, fd1345;
sub.f64 %25, fd1343, fd1032;
add.f64 %24, fd1028, fd1026;
sub.f64 %27, fd1040, fd1042;
add.f64 %26, fd1038, fd1036;
sub.f64 %29, fd1050, fd1052;
add.f64 %28, fd1048, fd1046;
add.f64 %30, fd1058, fd1056;
sub.f64 %31, fd1060, fd1062;
add.f64 %32, fd1068, fd1066;
sub.f64 %33, fd1070, fd1072;
sub.f64 %35, fd1080, fd1082;
add.f64 %34, fd1078, fd1076;
sub.f64 %36, fd996, fd998;
add.f64 %37, fd1002, fd1000;
sub.f64 %38, fd1347, fd1008;
add.f64 %39, fd1012, fd1010;
sub.f64 %40, fd1345, fd1018;
add.f64 %41, fd1022, fd1020;
sub.f64 %42, fd1026, fd1028;
add.f64 %43, fd1032, fd1343;
sub.f64 %44, fd1036, fd1038;
add.f64 %45, fd1042, fd1040;
sub.f64 %46, fd1046, fd1048;
add.f64 %47, fd1052, fd1050;
sub.f64 %48, fd1056, fd1058;
add.f64 %49, fd1062, fd1060;
sub.f64 %50, fd1066, fd1068;
add.f64 %51, fd1072, fd1070;
sub.f64 %52, fd1076, fd1078;
add.f64 %53, fd1082, fd1080;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y), "=d"(rmem[25].x), "=d"(rmem[25].y), "=d"(rmem[26].x), "=d"(rmem[26].y): "r"(smem), "l"(lut_dp_27_81), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y), "d"(rmem[25].x), "d"(rmem[25].y), "d"(rmem[26].x), "d"(rmem[26].y), "d"(rmem[19].y), "d"(rmem[10].y), "d"(rmem[1].y), "d"(rmem[22].y), "d"(rmem[13].y), "d"(rmem[4].y), "d"(rmem[16].y), "d"(rmem[25].y), "d"(rmem[7].y), "d"(rmem[11].y), "d"(rmem[20].y), "d"(rmem[2].y), "d"(rmem[23].y), "d"(rmem[14].y), "d"(rmem[5].y), "d"(rmem[17].y), "d"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<513, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<167>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 1296, r2;
mov.u32 r4, %tid.x;
add.f64 fd13, %12, %15;
add.f64 fd14, %14, %16;
mul.f64 fd15, fd13, 0d3FE0000000000000;
sub.f64 fd16, %10, fd15;
sub.f64 fd17, %14, %16;
mul.f64 fd18, fd17, 0d3FEBB67AE8584CAA;
add.f64 fd19, fd18, fd16;
sub.f64 fd20, fd16, fd18;
mul.f64 fd21, fd14, 0d3FE0000000000000;
sub.f64 fd22, %11, fd21;
sub.f64 fd23, %12, %15;
mul.f64 fd24, fd23, 0d3FEBB67AE8584CAA;
sub.f64 fd25, fd22, fd24;
add.f64 fd26, fd24, fd22;
mul.wide.u32 rd2, r4, 795364315;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 4;
mul.lo.s32 r10, r9, 27;
sub.s32 r11, r4, r10;
mad.lo.s32 r12, r9, 1296, r3;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd27, fd28}, [rd6];
mul.f64 fd31, fd27, fd19;
mul.f64 fd32, fd28, fd25;
mul.f64 fd33, fd27, fd25;
ld.global.v2.f64 {fd34, fd35}, [rd6+432];
mul.f64 fd38, fd34, fd20;
mul.f64 fd39, fd35, fd26;
mul.f64 fd40, fd34, fd26;
barrier.sync 0;
mad.lo.s32 r13, r11, 48, r12;
add.f64 fd41, %11, fd14;
add.f64 fd42, %10, fd13;
st.shared.v2.f64 [r13], {fd42, fd41};
fma.rn.f64 fd43, fd28, fd19, fd33;
sub.f64 fd44, fd31, fd32;
st.shared.v2.f64 [r13+16], {fd44, fd43};
fma.rn.f64 fd45, fd35, fd20, fd40;
sub.f64 fd46, fd38, fd39;
st.shared.v2.f64 [r13+32], {fd46, fd45};
barrier.sync 0;
shl.b32 r14, r11, 5;
sub.s32 r15, r13, r14;
ld.shared.v2.f64 {fd47, fd48}, [r15];
ld.shared.v2.f64 {fd51, fd52}, [r15+432];
ld.shared.v2.f64 {fd55, fd56}, [r15+864];
add.f64 fd59, fd51, fd55;
add.f64 fd60, fd52, fd56;
mul.f64 fd61, fd59, 0d3FE0000000000000;
sub.f64 fd62, fd47, fd61;
sub.f64 fd63, fd52, fd56;
mul.f64 fd64, fd63, 0d3FEBB67AE8584CAA;
add.f64 fd65, fd64, fd62;
sub.f64 fd66, fd62, fd64;
mul.f64 fd67, fd60, 0d3FE0000000000000;
sub.f64 fd68, fd48, fd67;
sub.f64 fd69, fd51, fd55;
mul.f64 fd70, fd69, 0d3FEBB67AE8584CAA;
sub.f64 fd71, fd68, fd70;
add.f64 fd72, fd70, fd68;
mul.wide.u32 rd7, r11, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r16, rd8;
mul.lo.s32 r17, r16, 3;
sub.s32 r18, r11, r17;
shl.b32 r19, r18, 4;
add.s32 r20, r12, r19;
mul.wide.u32 rd9, r16, 16;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd73, fd74}, [rd11];
mul.f64 fd77, fd73, fd65;
mul.f64 fd78, fd74, fd71;
mul.f64 fd79, fd73, fd71;
ld.global.v2.f64 {fd80, fd81}, [rd11+144];
mul.f64 fd84, fd80, fd66;
mul.f64 fd85, fd81, fd72;
mul.f64 fd86, fd80, fd72;
barrier.sync 0;
mad.lo.s32 r21, r16, 144, r20;
add.f64 fd87, fd48, fd60;
add.f64 fd88, fd47, fd59;
st.shared.v2.f64 [r21], {fd88, fd87};
fma.rn.f64 fd89, fd74, fd65, fd79;
sub.f64 fd90, fd77, fd78;
st.shared.v2.f64 [r21+48], {fd90, fd89};
fma.rn.f64 fd91, fd81, fd66, fd86;
sub.f64 fd92, fd84, fd85;
st.shared.v2.f64 [r21+96], {fd92, fd91};
barrier.sync 0;
ld.shared.v2.f64 {fd93, fd94}, [r15];
ld.shared.v2.f64 {fd97, fd98}, [r15+432];
ld.shared.v2.f64 {fd101, fd102}, [r15+864];
add.f64 fd105, fd97, fd101;
add.f64 fd106, fd98, fd102;
mul.f64 fd107, fd105, 0d3FE0000000000000;
sub.f64 fd108, fd93, fd107;
sub.f64 fd109, fd98, fd102;
mul.f64 fd110, fd109, 0d3FEBB67AE8584CAA;
add.f64 fd111, fd110, fd108;
sub.f64 fd112, fd108, fd110;
mul.f64 fd113, fd106, 0d3FE0000000000000;
sub.f64 fd114, fd94, fd113;
sub.f64 fd115, fd97, fd101;
mul.f64 fd116, fd115, 0d3FEBB67AE8584CAA;
sub.f64 fd117, fd114, fd116;
add.f64 fd118, fd116, fd114;
mul.wide.u32 rd12, r11, 954437177;
shr.u64 rd13, rd12, 33;
cvt.u32.u64 r22, rd13;
mul.lo.s32 r23, r22, 9;
sub.s32 r24, r11, r23;
shl.b32 r25, r24, 4;
add.s32 r26, r12, r25;
mul.wide.u32 rd14, r22, 16;
mov.u64 rd15, %9;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd119, fd120}, [rd16];
mul.f64 fd123, fd119, fd111;
mul.f64 fd124, fd120, fd117;
mul.f64 fd125, fd119, fd117;
ld.global.v2.f64 {fd126, fd127}, [rd16+48];
mul.f64 fd130, fd126, fd112;
mul.f64 fd131, fd127, fd118;
mul.f64 fd132, fd126, fd118;
barrier.sync 0;
mad.lo.s32 r27, r22, 432, r26;
add.f64 fd133, fd94, fd106;
add.f64 fd134, fd93, fd105;
st.shared.v2.f64 [r27], {fd134, fd133};
fma.rn.f64 fd135, fd120, fd111, fd125;
sub.f64 fd136, fd123, fd124;
st.shared.v2.f64 [r27+144], {fd136, fd135};
fma.rn.f64 fd137, fd127, fd112, fd132;
sub.f64 fd138, fd130, fd131;
st.shared.v2.f64 [r27+288], {fd138, fd137};
barrier.sync 0;
ld.shared.v2.f64 {fd139, fd140}, [r15];
ld.shared.v2.f64 {fd143, fd144}, [r15+432];
ld.shared.v2.f64 {fd147, fd148}, [r15+864];
add.f64 fd151, fd143, fd147;
add.f64 fd152, fd144, fd148;
mul.f64 fd153, fd151, 0d3FE0000000000000;
sub.f64 fd154, fd139, fd153;
sub.f64 fd155, fd144, fd148;
mul.f64 fd156, fd155, 0d3FEBB67AE8584CAA;
mul.f64 fd157, fd152, 0d3FE0000000000000;
sub.f64 fd158, fd140, fd157;
sub.f64 fd159, fd143, fd147;
mul.f64 fd160, fd159, 0d3FEBB67AE8584CAA;
add.f64 %1, fd140, fd152;
add.f64 %0, fd139, fd151;
sub.f64 %3, fd158, fd160;
add.f64 %2, fd156, fd154;
add.f64 %5, fd160, fd158;
sub.f64 %4, fd154, fd156;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y): "r"(smem), "l"(lut_dp_3_81), "l"(lut_dp_3_27), "l"(lut_dp_3_9), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<514, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<149>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 648, r2;
mov.u32 r4, %tid.x;
add.f64 fd13, %12, %15;
add.f64 fd14, %10, fd13;
add.f64 fd15, %14, %16;
add.f64 fd16, %11, fd15;
mul.f64 fd17, fd13, 0d3FE0000000000000;
sub.f64 fd18, %10, fd17;
sub.f64 fd19, %14, %16;
mul.f64 fd20, fd19, 0d3FEBB67AE8584CAA;
add.f64 fd21, fd20, fd18;
sub.f64 fd22, fd18, fd20;
mul.f64 fd23, fd15, 0d3FE0000000000000;
sub.f64 fd24, %11, fd23;
sub.f64 fd25, %12, %15;
mul.f64 fd26, fd25, 0d3FEBB67AE8584CAA;
sub.f64 fd27, fd24, fd26;
add.f64 fd28, fd26, fd24;
mul.wide.u32 rd2, r4, 795364315;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 4;
mul.lo.s32 r10, r9, 27;
sub.s32 r11, r4, r10;
mad.lo.s32 r12, r9, 648, r3;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd29, fd30}, [rd6];
mul.f64 fd33, fd29, fd21;
mul.f64 fd34, fd30, fd27;
sub.f64 fd35, fd33, fd34;
mul.f64 fd36, fd29, fd27;
fma.rn.f64 fd37, fd30, fd21, fd36;
ld.global.v2.f64 {fd38, fd39}, [rd6+432];
mul.f64 fd42, fd38, fd22;
mul.f64 fd43, fd39, fd28;
sub.f64 fd44, fd42, fd43;
mul.f64 fd45, fd38, fd28;
fma.rn.f64 fd46, fd39, fd22, fd45;
barrier.sync 0;
mad.lo.s32 r13, r11, 24, r12;
st.shared.f64 [r13], fd14;
st.shared.f64 [r13+8], fd35;
st.shared.f64 [r13+16], fd44;
barrier.sync 0;
shl.b32 r14, r11, 4;
sub.s32 r15, r13, r14;
ld.shared.f64 fd47, [r15];
ld.shared.f64 fd48, [r15+216];
ld.shared.f64 fd49, [r15+432];
barrier.sync 0;
st.shared.f64 [r13], fd16;
st.shared.f64 [r13+8], fd37;
st.shared.f64 [r13+16], fd46;
barrier.sync 0;
ld.shared.f64 fd50, [r15];
ld.shared.f64 fd51, [r15+216];
ld.shared.f64 fd52, [r15+432];
add.f64 fd53, fd48, fd49;
add.f64 fd54, fd47, fd53;
add.f64 fd55, fd51, fd52;
add.f64 fd56, fd50, fd55;
mul.f64 fd57, fd53, 0d3FE0000000000000;
sub.f64 fd58, fd47, fd57;
sub.f64 fd59, fd51, fd52;
mul.f64 fd60, fd59, 0d3FEBB67AE8584CAA;
add.f64 fd61, fd60, fd58;
sub.f64 fd62, fd58, fd60;
mul.f64 fd63, fd55, 0d3FE0000000000000;
sub.f64 fd64, fd50, fd63;
sub.f64 fd65, fd48, fd49;
mul.f64 fd66, fd65, 0d3FEBB67AE8584CAA;
sub.f64 fd67, fd64, fd66;
add.f64 fd68, fd66, fd64;
mul.wide.u32 rd7, r11, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r16, rd8;
mul.lo.s32 r17, r16, 3;
sub.s32 r18, r11, r17;
shl.b32 r19, r18, 3;
add.s32 r20, r12, r19;
mul.wide.u32 rd9, r16, 16;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd69, fd70}, [rd11];
mul.f64 fd73, fd69, fd61;
mul.f64 fd74, fd70, fd67;
sub.f64 fd75, fd73, fd74;
mul.f64 fd76, fd69, fd67;
fma.rn.f64 fd77, fd70, fd61, fd76;
ld.global.v2.f64 {fd78, fd79}, [rd11+144];
mul.f64 fd82, fd78, fd62;
mul.f64 fd83, fd79, fd68;
sub.f64 fd84, fd82, fd83;
mul.f64 fd85, fd78, fd68;
fma.rn.f64 fd86, fd79, fd62, fd85;
barrier.sync 0;
mad.lo.s32 r21, r16, 72, r20;
st.shared.f64 [r21], fd54;
st.shared.f64 [r21+24], fd75;
st.shared.f64 [r21+48], fd84;
barrier.sync 0;
ld.shared.f64 fd87, [r15];
ld.shared.f64 fd88, [r15+216];
ld.shared.f64 fd89, [r15+432];
barrier.sync 0;
st.shared.f64 [r21], fd56;
st.shared.f64 [r21+24], fd77;
st.shared.f64 [r21+48], fd86;
barrier.sync 0;
ld.shared.f64 fd90, [r15];
ld.shared.f64 fd91, [r15+216];
ld.shared.f64 fd92, [r15+432];
add.f64 fd93, fd88, fd89;
add.f64 fd94, fd87, fd93;
add.f64 fd95, fd91, fd92;
add.f64 fd96, fd90, fd95;
mul.f64 fd97, fd93, 0d3FE0000000000000;
sub.f64 fd98, fd87, fd97;
sub.f64 fd99, fd91, fd92;
mul.f64 fd100, fd99, 0d3FEBB67AE8584CAA;
add.f64 fd101, fd100, fd98;
sub.f64 fd102, fd98, fd100;
mul.f64 fd103, fd95, 0d3FE0000000000000;
sub.f64 fd104, fd90, fd103;
sub.f64 fd105, fd88, fd89;
mul.f64 fd106, fd105, 0d3FEBB67AE8584CAA;
sub.f64 fd107, fd104, fd106;
add.f64 fd108, fd106, fd104;
mul.wide.u32 rd12, r11, 954437177;
shr.u64 rd13, rd12, 33;
cvt.u32.u64 r22, rd13;
mul.lo.s32 r23, r22, 9;
sub.s32 r24, r11, r23;
shl.b32 r25, r24, 3;
add.s32 r26, r12, r25;
mul.wide.u32 rd14, r22, 16;
mov.u64 rd15, %9;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd109, fd110}, [rd16];
mul.f64 fd113, fd109, fd101;
mul.f64 fd114, fd110, fd107;
sub.f64 fd115, fd113, fd114;
mul.f64 fd116, fd109, fd107;
fma.rn.f64 fd117, fd110, fd101, fd116;
ld.global.v2.f64 {fd118, fd119}, [rd16+48];
mul.f64 fd122, fd118, fd102;
mul.f64 fd123, fd119, fd108;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd118, fd108;
fma.rn.f64 fd126, fd119, fd102, fd125;
barrier.sync 0;
mad.lo.s32 r27, r22, 216, r26;
st.shared.f64 [r27], fd94;
st.shared.f64 [r27+72], fd115;
st.shared.f64 [r27+144], fd124;
barrier.sync 0;
ld.shared.f64 fd127, [r15];
ld.shared.f64 fd128, [r15+216];
ld.shared.f64 fd129, [r15+432];
barrier.sync 0;
st.shared.f64 [r27], fd96;
st.shared.f64 [r27+72], fd117;
st.shared.f64 [r27+144], fd126;
barrier.sync 0;
ld.shared.f64 fd130, [r15];
ld.shared.f64 fd131, [r15+216];
ld.shared.f64 fd132, [r15+432];
add.f64 fd133, fd128, fd129;
add.f64 fd134, fd131, fd132;
mul.f64 fd135, fd133, 0d3FE0000000000000;
sub.f64 fd136, fd127, fd135;
sub.f64 fd137, fd131, fd132;
mul.f64 fd138, fd137, 0d3FEBB67AE8584CAA;
mul.f64 fd139, fd134, 0d3FE0000000000000;
sub.f64 fd140, fd130, fd139;
sub.f64 fd141, fd128, fd129;
mul.f64 fd142, fd141, 0d3FEBB67AE8584CAA;
add.f64 %0, fd127, fd133;
add.f64 %1, fd130, fd134;
add.f64 %2, fd138, fd136;
sub.f64 %3, fd140, fd142;
sub.f64 %4, fd136, fd138;
add.f64 %5, fd142, fd140;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y): "r"(smem), "l"(lut_dp_3_81), "l"(lut_dp_3_27), "l"(lut_dp_3_9), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y));
};


#endif
