#ifndef CUFFTDX_FFT_49_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_49_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<548, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<15>;
.reg .f64 fd<291>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 784, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %18, %32;
add.f64 fd30, %16, fd29;
add.f64 fd31, %21, %29;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %24, %26;
add.f64 fd34, %20, %33;
add.f64 fd35, %17, fd34;
add.f64 fd36, %23, %31;
add.f64 fd37, fd36, fd35;
add.f64 fd38, %25, %28;
fma.rn.f64 fd39, fd29, 0d3FE3F3A0E28BEDD1, %16;
mul.f64 fd40, fd31, 0d3FCC7B90E3024582;
sub.f64 fd41, fd39, fd40;
mul.f64 fd42, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, %20, %33;
mul.f64 fd45, fd44, 0d3FE904C37505DE4B;
sub.f64 fd46, %23, %31;
mul.f64 fd47, fd46, 0dBFEF329C0558E969;
sub.f64 fd48, fd47, fd45;
sub.f64 fd49, %25, %28;
mul.f64 fd50, fd49, 0d3FDBC4C04D71ABC1;
sub.f64 fd51, fd48, fd50;
sub.f64 fd52, fd43, fd51;
add.f64 fd53, fd51, fd43;
mul.f64 fd54, fd29, 0d3FCC7B90E3024582;
sub.f64 fd55, %16, fd54;
mul.f64 fd56, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd57, fd55, fd56;
fma.rn.f64 fd58, fd33, 0d3FE3F3A0E28BEDD1, fd57;
mul.f64 fd59, fd44, 0d3FEF329C0558E969;
mul.f64 fd60, fd46, 0d3FDBC4C04D71ABC1;
sub.f64 fd61, fd60, fd59;
fma.rn.f64 fd62, fd49, 0d3FE904C37505DE4B, fd61;
sub.f64 fd63, fd58, fd62;
add.f64 fd64, fd62, fd58;
mul.f64 fd65, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd66, %16, fd65;
fma.rn.f64 fd67, fd31, 0d3FE3F3A0E28BEDD1, fd66;
mul.f64 fd68, fd33, 0d3FCC7B90E3024582;
sub.f64 fd69, fd67, fd68;
mul.f64 fd70, fd44, 0d3FDBC4C04D71ABC1;
mul.f64 fd71, fd46, 0d3FE904C37505DE4B;
sub.f64 fd72, fd71, fd70;
mul.f64 fd73, fd49, 0d3FEF329C0558E969;
sub.f64 fd74, fd72, fd73;
sub.f64 fd75, fd69, fd74;
add.f64 fd76, fd74, fd69;
fma.rn.f64 fd77, fd34, 0d3FE3F3A0E28BEDD1, %17;
mul.f64 fd78, fd36, 0d3FCC7B90E3024582;
sub.f64 fd79, fd77, fd78;
mul.f64 fd80, fd38, 0d3FECD4BCA9CB5C71;
sub.f64 fd81, fd79, fd80;
sub.f64 fd82, %18, %32;
mul.f64 fd83, fd82, 0d3FE904C37505DE4B;
sub.f64 fd84, %21, %29;
mul.f64 fd85, fd84, 0dBFEF329C0558E969;
sub.f64 fd86, fd85, fd83;
sub.f64 fd87, %24, %26;
mul.f64 fd88, fd87, 0d3FDBC4C04D71ABC1;
sub.f64 fd89, fd86, fd88;
add.f64 fd90, fd89, fd81;
sub.f64 fd91, fd81, fd89;
mul.f64 fd92, fd34, 0d3FCC7B90E3024582;
sub.f64 fd93, %17, fd92;
mul.f64 fd94, fd36, 0d3FECD4BCA9CB5C71;
sub.f64 fd95, fd93, fd94;
fma.rn.f64 fd96, fd38, 0d3FE3F3A0E28BEDD1, fd95;
mul.f64 fd97, fd82, 0d3FEF329C0558E969;
mul.f64 fd98, fd84, 0d3FDBC4C04D71ABC1;
sub.f64 fd99, fd98, fd97;
fma.rn.f64 fd100, fd87, 0d3FE904C37505DE4B, fd99;
add.f64 fd101, fd100, fd96;
sub.f64 fd102, fd96, fd100;
mul.f64 fd103, fd34, 0d3FECD4BCA9CB5C71;
sub.f64 fd104, %17, fd103;
fma.rn.f64 fd105, fd36, 0d3FE3F3A0E28BEDD1, fd104;
mul.f64 fd106, fd38, 0d3FCC7B90E3024582;
sub.f64 fd107, fd105, fd106;
mul.f64 fd108, fd82, 0d3FDBC4C04D71ABC1;
mul.f64 fd109, fd84, 0d3FE904C37505DE4B;
sub.f64 fd110, fd109, fd108;
mul.f64 fd111, fd87, 0d3FEF329C0558E969;
sub.f64 fd112, fd110, fd111;
add.f64 fd113, fd112, fd107;
sub.f64 fd114, fd107, fd112;
mul.wide.u32 rd2, r4, 613566757;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 2;
mul.lo.s32 r10, r9, 7;
sub.s32 r11, r4, r10;
mad.lo.s32 r12, r9, 784, r3;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd115, fd116}, [rd6];
mul.f64 fd119, fd115, fd52;
mul.f64 fd120, fd116, fd90;
mul.f64 fd121, fd115, fd90;
mul.f64 fd122, fd115, fd115;
mul.f64 fd123, fd116, fd116;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd116, fd115;
fma.rn.f64 fd126, fd116, fd115, fd125;
mul.f64 fd127, fd124, fd63;
mul.f64 fd128, fd126, fd101;
mul.f64 fd129, fd124, fd101;
mul.f64 fd130, fd115, fd124;
mul.f64 fd131, fd116, fd126;
sub.f64 fd132, fd130, fd131;
mul.f64 fd133, fd115, fd126;
fma.rn.f64 fd134, fd116, fd124, fd133;
mul.f64 fd135, fd132, fd75;
mul.f64 fd136, fd134, fd113;
mul.f64 fd137, fd132, fd113;
ld.global.v2.f64 {fd138, fd139}, [rd6+112];
mul.f64 fd142, fd138, fd76;
mul.f64 fd143, fd139, fd114;
mul.f64 fd144, fd138, fd114;
mul.f64 fd145, fd115, fd138;
mul.f64 fd146, fd116, fd139;
sub.f64 fd147, fd145, fd146;
mul.f64 fd148, fd115, fd139;
fma.rn.f64 fd149, fd116, fd138, fd148;
mul.f64 fd150, fd147, fd64;
mul.f64 fd151, fd149, fd102;
mul.f64 fd152, fd147, fd102;
mul.f64 fd153, fd115, fd147;
mul.f64 fd154, fd116, fd149;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd115, fd149;
fma.rn.f64 fd157, fd116, fd147, fd156;
mul.f64 fd158, fd155, fd53;
mul.f64 fd159, fd157, fd91;
mul.f64 fd160, fd155, fd91;
barrier.sync 0;
mad.lo.s32 r13, r11, 112, r12;
add.f64 fd161, fd38, fd37;
add.f64 fd162, fd33, fd32;
st.shared.v2.f64 [r13], {fd162, fd161};
fma.rn.f64 fd163, fd116, fd52, fd121;
sub.f64 fd164, fd119, fd120;
st.shared.v2.f64 [r13+16], {fd164, fd163};
fma.rn.f64 fd165, fd126, fd63, fd129;
sub.f64 fd166, fd127, fd128;
st.shared.v2.f64 [r13+32], {fd166, fd165};
sub.f64 fd167, fd135, fd136;
fma.rn.f64 fd168, fd134, fd75, fd137;
st.shared.v2.f64 [r13+48], {fd167, fd168};
fma.rn.f64 fd169, fd139, fd76, fd144;
sub.f64 fd170, fd142, fd143;
st.shared.v2.f64 [r13+64], {fd170, fd169};
fma.rn.f64 fd171, fd149, fd64, fd152;
sub.f64 fd172, fd150, fd151;
st.shared.v2.f64 [r13+80], {fd172, fd171};
sub.f64 fd173, fd158, fd159;
fma.rn.f64 fd174, fd157, fd53, fd160;
st.shared.v2.f64 [r13+96], {fd173, fd174};
barrier.sync 0;
mad.lo.s32 r14, r11, -96, r13;
ld.shared.v2.f64 {fd175, fd176}, [r14];
ld.shared.v2.f64 {fd179, fd180}, [r14+112];
ld.shared.v2.f64 {fd183, fd184}, [r14+224];
ld.shared.v2.f64 {fd187, fd188}, [r14+336];
ld.shared.v2.f64 {fd191, fd192}, [r14+448];
ld.shared.v2.f64 {fd195, fd196}, [r14+560];
ld.shared.v2.f64 {fd199, fd200}, [r14+672];
add.f64 fd203, fd179, fd199;
add.f64 fd204, fd175, fd203;
add.f64 fd205, fd183, fd195;
add.f64 fd206, fd205, fd204;
add.f64 fd207, fd187, fd191;
add.f64 fd208, fd180, fd200;
add.f64 fd209, fd176, fd208;
add.f64 fd210, fd184, fd196;
add.f64 fd211, fd210, fd209;
add.f64 fd212, fd188, fd192;
fma.rn.f64 fd213, fd203, 0d3FE3F3A0E28BEDD1, fd175;
mul.f64 fd214, fd205, 0d3FCC7B90E3024582;
sub.f64 fd215, fd213, fd214;
mul.f64 fd216, fd207, 0d3FECD4BCA9CB5C71;
sub.f64 fd217, fd215, fd216;
sub.f64 fd218, fd180, fd200;
mul.f64 fd219, fd218, 0d3FE904C37505DE4B;
sub.f64 fd220, fd184, fd196;
mul.f64 fd221, fd220, 0dBFEF329C0558E969;
sub.f64 fd222, fd221, fd219;
sub.f64 fd223, fd188, fd192;
mul.f64 fd224, fd223, 0d3FDBC4C04D71ABC1;
sub.f64 fd225, fd222, fd224;
mul.f64 fd226, fd203, 0d3FCC7B90E3024582;
sub.f64 fd227, fd175, fd226;
mul.f64 fd228, fd205, 0d3FECD4BCA9CB5C71;
sub.f64 fd229, fd227, fd228;
fma.rn.f64 fd230, fd207, 0d3FE3F3A0E28BEDD1, fd229;
mul.f64 fd231, fd218, 0d3FEF329C0558E969;
mul.f64 fd232, fd220, 0d3FDBC4C04D71ABC1;
sub.f64 fd233, fd232, fd231;
fma.rn.f64 fd234, fd223, 0d3FE904C37505DE4B, fd233;
mul.f64 fd235, fd203, 0d3FECD4BCA9CB5C71;
sub.f64 fd236, fd175, fd235;
fma.rn.f64 fd237, fd205, 0d3FE3F3A0E28BEDD1, fd236;
mul.f64 fd238, fd207, 0d3FCC7B90E3024582;
sub.f64 fd239, fd237, fd238;
mul.f64 fd240, fd218, 0d3FDBC4C04D71ABC1;
mul.f64 fd241, fd220, 0d3FE904C37505DE4B;
sub.f64 fd242, fd241, fd240;
mul.f64 fd243, fd223, 0d3FEF329C0558E969;
sub.f64 fd244, fd242, fd243;
fma.rn.f64 fd245, fd208, 0d3FE3F3A0E28BEDD1, fd176;
mul.f64 fd246, fd210, 0d3FCC7B90E3024582;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd212, 0d3FECD4BCA9CB5C71;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd179, fd199;
mul.f64 fd251, fd250, 0d3FE904C37505DE4B;
sub.f64 fd252, fd183, fd195;
mul.f64 fd253, fd252, 0dBFEF329C0558E969;
sub.f64 fd254, fd253, fd251;
sub.f64 fd255, fd187, fd191;
mul.f64 fd256, fd255, 0d3FDBC4C04D71ABC1;
sub.f64 fd257, fd254, fd256;
mul.f64 fd258, fd208, 0d3FCC7B90E3024582;
sub.f64 fd259, fd176, fd258;
mul.f64 fd260, fd210, 0d3FECD4BCA9CB5C71;
sub.f64 fd261, fd259, fd260;
fma.rn.f64 fd262, fd212, 0d3FE3F3A0E28BEDD1, fd261;
mul.f64 fd263, fd250, 0d3FEF329C0558E969;
mul.f64 fd264, fd252, 0d3FDBC4C04D71ABC1;
sub.f64 fd265, fd264, fd263;
fma.rn.f64 fd266, fd255, 0d3FE904C37505DE4B, fd265;
mul.f64 fd267, fd208, 0d3FECD4BCA9CB5C71;
sub.f64 fd268, fd176, fd267;
fma.rn.f64 fd269, fd210, 0d3FE3F3A0E28BEDD1, fd268;
mul.f64 fd270, fd212, 0d3FCC7B90E3024582;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd250, 0d3FDBC4C04D71ABC1;
mul.f64 fd273, fd252, 0d3FE904C37505DE4B;
sub.f64 fd274, fd273, fd272;
mul.f64 fd275, fd255, 0d3FEF329C0558E969;
sub.f64 fd276, fd274, fd275;
add.f64 %1, fd212, fd211;
add.f64 %0, fd207, fd206;
add.f64 %3, fd257, fd249;
sub.f64 %2, fd217, fd225;
add.f64 %5, fd266, fd262;
sub.f64 %4, fd230, fd234;
add.f64 %7, fd276, fd271;
sub.f64 %6, fd239, fd244;
sub.f64 %9, fd271, fd276;
add.f64 %8, fd244, fd239;
sub.f64 %11, fd262, fd266;
add.f64 %10, fd234, fd230;
sub.f64 %13, fd249, fd257;
add.f64 %12, fd225, fd217;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<547, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<15>;
.reg .f64 fd<277>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 392, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %18, %32;
add.f64 fd30, %16, fd29;
add.f64 fd31, %21, %29;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %24, %26;
add.f64 fd34, fd33, fd32;
add.f64 fd35, %20, %33;
add.f64 fd36, %17, fd35;
add.f64 fd37, %23, %31;
add.f64 fd38, fd37, fd36;
add.f64 fd39, %25, %28;
add.f64 fd40, fd39, fd38;
fma.rn.f64 fd41, fd29, 0d3FE3F3A0E28BEDD1, %16;
mul.f64 fd42, fd31, 0d3FCC7B90E3024582;
sub.f64 fd43, fd41, fd42;
mul.f64 fd44, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd45, fd43, fd44;
sub.f64 fd46, %20, %33;
mul.f64 fd47, fd46, 0d3FE904C37505DE4B;
sub.f64 fd48, %23, %31;
mul.f64 fd49, fd48, 0dBFEF329C0558E969;
sub.f64 fd50, fd49, fd47;
sub.f64 fd51, %25, %28;
mul.f64 fd52, fd51, 0d3FDBC4C04D71ABC1;
sub.f64 fd53, fd50, fd52;
sub.f64 fd54, fd45, fd53;
add.f64 fd55, fd53, fd45;
mul.f64 fd56, fd29, 0d3FCC7B90E3024582;
sub.f64 fd57, %16, fd56;
mul.f64 fd58, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd59, fd57, fd58;
fma.rn.f64 fd60, fd33, 0d3FE3F3A0E28BEDD1, fd59;
mul.f64 fd61, fd46, 0d3FEF329C0558E969;
mul.f64 fd62, fd48, 0d3FDBC4C04D71ABC1;
sub.f64 fd63, fd62, fd61;
fma.rn.f64 fd64, fd51, 0d3FE904C37505DE4B, fd63;
sub.f64 fd65, fd60, fd64;
add.f64 fd66, fd64, fd60;
mul.f64 fd67, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd68, %16, fd67;
fma.rn.f64 fd69, fd31, 0d3FE3F3A0E28BEDD1, fd68;
mul.f64 fd70, fd33, 0d3FCC7B90E3024582;
sub.f64 fd71, fd69, fd70;
mul.f64 fd72, fd46, 0d3FDBC4C04D71ABC1;
mul.f64 fd73, fd48, 0d3FE904C37505DE4B;
sub.f64 fd74, fd73, fd72;
mul.f64 fd75, fd51, 0d3FEF329C0558E969;
sub.f64 fd76, fd74, fd75;
sub.f64 fd77, fd71, fd76;
add.f64 fd78, fd76, fd71;
fma.rn.f64 fd79, fd35, 0d3FE3F3A0E28BEDD1, %17;
mul.f64 fd80, fd37, 0d3FCC7B90E3024582;
sub.f64 fd81, fd79, fd80;
mul.f64 fd82, fd39, 0d3FECD4BCA9CB5C71;
sub.f64 fd83, fd81, fd82;
sub.f64 fd84, %18, %32;
mul.f64 fd85, fd84, 0d3FE904C37505DE4B;
sub.f64 fd86, %21, %29;
mul.f64 fd87, fd86, 0dBFEF329C0558E969;
sub.f64 fd88, fd87, fd85;
sub.f64 fd89, %24, %26;
mul.f64 fd90, fd89, 0d3FDBC4C04D71ABC1;
sub.f64 fd91, fd88, fd90;
add.f64 fd92, fd91, fd83;
sub.f64 fd93, fd83, fd91;
mul.f64 fd94, fd35, 0d3FCC7B90E3024582;
sub.f64 fd95, %17, fd94;
mul.f64 fd96, fd37, 0d3FECD4BCA9CB5C71;
sub.f64 fd97, fd95, fd96;
fma.rn.f64 fd98, fd39, 0d3FE3F3A0E28BEDD1, fd97;
mul.f64 fd99, fd84, 0d3FEF329C0558E969;
mul.f64 fd100, fd86, 0d3FDBC4C04D71ABC1;
sub.f64 fd101, fd100, fd99;
fma.rn.f64 fd102, fd89, 0d3FE904C37505DE4B, fd101;
add.f64 fd103, fd102, fd98;
sub.f64 fd104, fd98, fd102;
mul.f64 fd105, fd35, 0d3FECD4BCA9CB5C71;
sub.f64 fd106, %17, fd105;
fma.rn.f64 fd107, fd37, 0d3FE3F3A0E28BEDD1, fd106;
mul.f64 fd108, fd39, 0d3FCC7B90E3024582;
sub.f64 fd109, fd107, fd108;
mul.f64 fd110, fd84, 0d3FDBC4C04D71ABC1;
mul.f64 fd111, fd86, 0d3FE904C37505DE4B;
sub.f64 fd112, fd111, fd110;
mul.f64 fd113, fd89, 0d3FEF329C0558E969;
sub.f64 fd114, fd112, fd113;
add.f64 fd115, fd114, fd109;
sub.f64 fd116, fd109, fd114;
mul.wide.u32 rd2, r4, 613566757;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 2;
mul.lo.s32 r10, r9, 7;
sub.s32 r11, r4, r10;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd117, fd118}, [rd6];
mul.f64 fd121, fd117, fd54;
mul.f64 fd122, fd118, fd92;
sub.f64 fd123, fd121, fd122;
mul.f64 fd124, fd117, fd92;
fma.rn.f64 fd125, fd118, fd54, fd124;
mul.f64 fd126, fd117, fd117;
mul.f64 fd127, fd118, fd118;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd118, fd117;
fma.rn.f64 fd130, fd118, fd117, fd129;
mul.f64 fd131, fd128, fd65;
mul.f64 fd132, fd130, fd103;
sub.f64 fd133, fd131, fd132;
mul.f64 fd134, fd128, fd103;
fma.rn.f64 fd135, fd130, fd65, fd134;
mul.f64 fd136, fd117, fd128;
mul.f64 fd137, fd118, fd130;
sub.f64 fd138, fd136, fd137;
mul.f64 fd139, fd117, fd130;
fma.rn.f64 fd140, fd118, fd128, fd139;
mul.f64 fd141, fd138, fd77;
mul.f64 fd142, fd140, fd115;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd138, fd115;
fma.rn.f64 fd145, fd140, fd77, fd144;
ld.global.v2.f64 {fd146, fd147}, [rd6+112];
mul.f64 fd150, fd146, fd78;
mul.f64 fd151, fd147, fd116;
sub.f64 fd152, fd150, fd151;
mul.f64 fd153, fd146, fd116;
fma.rn.f64 fd154, fd147, fd78, fd153;
mul.f64 fd155, fd117, fd146;
mul.f64 fd156, fd118, fd147;
sub.f64 fd157, fd155, fd156;
mul.f64 fd158, fd117, fd147;
fma.rn.f64 fd159, fd118, fd146, fd158;
mul.f64 fd160, fd157, fd66;
mul.f64 fd161, fd159, fd104;
sub.f64 fd162, fd160, fd161;
mul.f64 fd163, fd157, fd104;
fma.rn.f64 fd164, fd159, fd66, fd163;
mul.f64 fd165, fd117, fd157;
mul.f64 fd166, fd118, fd159;
sub.f64 fd167, fd165, fd166;
mul.f64 fd168, fd117, fd159;
fma.rn.f64 fd169, fd118, fd157, fd168;
mul.f64 fd170, fd167, fd55;
mul.f64 fd171, fd169, fd93;
sub.f64 fd172, fd170, fd171;
mul.f64 fd173, fd167, fd93;
fma.rn.f64 fd174, fd169, fd55, fd173;
mad.lo.s32 r12, r9, 392, r3;
barrier.sync 0;
mad.lo.s32 r13, r11, 56, r12;
st.shared.f64 [r13], fd34;
st.shared.f64 [r13+8], fd123;
st.shared.f64 [r13+16], fd133;
st.shared.f64 [r13+24], fd143;
st.shared.f64 [r13+32], fd152;
st.shared.f64 [r13+40], fd162;
st.shared.f64 [r13+48], fd172;
barrier.sync 0;
mad.lo.s32 r14, r11, -48, r13;
ld.shared.f64 fd175, [r14];
ld.shared.f64 fd176, [r14+56];
ld.shared.f64 fd177, [r14+112];
ld.shared.f64 fd178, [r14+168];
ld.shared.f64 fd179, [r14+224];
ld.shared.f64 fd180, [r14+280];
ld.shared.f64 fd181, [r14+336];
barrier.sync 0;
st.shared.f64 [r13], fd40;
st.shared.f64 [r13+8], fd125;
st.shared.f64 [r13+16], fd135;
st.shared.f64 [r13+24], fd145;
st.shared.f64 [r13+32], fd154;
st.shared.f64 [r13+40], fd164;
st.shared.f64 [r13+48], fd174;
barrier.sync 0;
ld.shared.f64 fd182, [r14];
ld.shared.f64 fd183, [r14+56];
ld.shared.f64 fd184, [r14+112];
ld.shared.f64 fd185, [r14+168];
ld.shared.f64 fd186, [r14+224];
ld.shared.f64 fd187, [r14+280];
ld.shared.f64 fd188, [r14+336];
add.f64 fd189, fd176, fd181;
add.f64 fd190, fd175, fd189;
add.f64 fd191, fd177, fd180;
add.f64 fd192, fd191, fd190;
add.f64 fd193, fd178, fd179;
add.f64 fd194, fd183, fd188;
add.f64 fd195, fd182, fd194;
add.f64 fd196, fd184, fd187;
add.f64 fd197, fd196, fd195;
add.f64 fd198, fd185, fd186;
fma.rn.f64 fd199, fd189, 0d3FE3F3A0E28BEDD1, fd175;
mul.f64 fd200, fd191, 0d3FCC7B90E3024582;
sub.f64 fd201, fd199, fd200;
mul.f64 fd202, fd193, 0d3FECD4BCA9CB5C71;
sub.f64 fd203, fd201, fd202;
sub.f64 fd204, fd183, fd188;
mul.f64 fd205, fd204, 0d3FE904C37505DE4B;
sub.f64 fd206, fd184, fd187;
mul.f64 fd207, fd206, 0dBFEF329C0558E969;
sub.f64 fd208, fd207, fd205;
sub.f64 fd209, fd185, fd186;
mul.f64 fd210, fd209, 0d3FDBC4C04D71ABC1;
sub.f64 fd211, fd208, fd210;
mul.f64 fd212, fd189, 0d3FCC7B90E3024582;
sub.f64 fd213, fd175, fd212;
mul.f64 fd214, fd191, 0d3FECD4BCA9CB5C71;
sub.f64 fd215, fd213, fd214;
fma.rn.f64 fd216, fd193, 0d3FE3F3A0E28BEDD1, fd215;
mul.f64 fd217, fd204, 0d3FEF329C0558E969;
mul.f64 fd218, fd206, 0d3FDBC4C04D71ABC1;
sub.f64 fd219, fd218, fd217;
fma.rn.f64 fd220, fd209, 0d3FE904C37505DE4B, fd219;
mul.f64 fd221, fd189, 0d3FECD4BCA9CB5C71;
sub.f64 fd222, fd175, fd221;
fma.rn.f64 fd223, fd191, 0d3FE3F3A0E28BEDD1, fd222;
mul.f64 fd224, fd193, 0d3FCC7B90E3024582;
sub.f64 fd225, fd223, fd224;
mul.f64 fd226, fd204, 0d3FDBC4C04D71ABC1;
mul.f64 fd227, fd206, 0d3FE904C37505DE4B;
sub.f64 fd228, fd227, fd226;
mul.f64 fd229, fd209, 0d3FEF329C0558E969;
sub.f64 fd230, fd228, fd229;
fma.rn.f64 fd231, fd194, 0d3FE3F3A0E28BEDD1, fd182;
mul.f64 fd232, fd196, 0d3FCC7B90E3024582;
sub.f64 fd233, fd231, fd232;
mul.f64 fd234, fd198, 0d3FECD4BCA9CB5C71;
sub.f64 fd235, fd233, fd234;
sub.f64 fd236, fd176, fd181;
mul.f64 fd237, fd236, 0d3FE904C37505DE4B;
sub.f64 fd238, fd177, fd180;
mul.f64 fd239, fd238, 0dBFEF329C0558E969;
sub.f64 fd240, fd239, fd237;
sub.f64 fd241, fd178, fd179;
mul.f64 fd242, fd241, 0d3FDBC4C04D71ABC1;
sub.f64 fd243, fd240, fd242;
mul.f64 fd244, fd194, 0d3FCC7B90E3024582;
sub.f64 fd245, fd182, fd244;
mul.f64 fd246, fd196, 0d3FECD4BCA9CB5C71;
sub.f64 fd247, fd245, fd246;
fma.rn.f64 fd248, fd198, 0d3FE3F3A0E28BEDD1, fd247;
mul.f64 fd249, fd236, 0d3FEF329C0558E969;
mul.f64 fd250, fd238, 0d3FDBC4C04D71ABC1;
sub.f64 fd251, fd250, fd249;
fma.rn.f64 fd252, fd241, 0d3FE904C37505DE4B, fd251;
mul.f64 fd253, fd194, 0d3FECD4BCA9CB5C71;
sub.f64 fd254, fd182, fd253;
fma.rn.f64 fd255, fd196, 0d3FE3F3A0E28BEDD1, fd254;
mul.f64 fd256, fd198, 0d3FCC7B90E3024582;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd236, 0d3FDBC4C04D71ABC1;
mul.f64 fd259, fd238, 0d3FE904C37505DE4B;
sub.f64 fd260, fd259, fd258;
mul.f64 fd261, fd241, 0d3FEF329C0558E969;
sub.f64 fd262, fd260, fd261;
add.f64 %0, fd193, fd192;
add.f64 %1, fd198, fd197;
add.f64 %3, fd243, fd235;
sub.f64 %2, fd203, fd211;
sub.f64 %4, fd216, fd220;
add.f64 %5, fd252, fd248;
sub.f64 %6, fd225, fd230;
add.f64 %7, fd262, fd257;
add.f64 %8, fd230, fd225;
sub.f64 %9, fd257, fd262;
add.f64 %10, fd220, fd216;
sub.f64 %11, fd248, fd252;
sub.f64 %13, fd235, fd243;
add.f64 %12, fd211, fd203;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};


#endif
