#ifndef CUFFTDX_FFT_4096_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_4096_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<492, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<29>;
.reg .f64 fd<513>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 15;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %20, %30;
add.f64 fd34, %21, %32;
sub.f64 fd35, %20, %30;
sub.f64 fd36, %21, %32;
add.f64 fd37, %25, %36;
add.f64 fd38, %27, %37;
sub.f64 fd39, %25, %36;
sub.f64 fd40, %27, %37;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %22, %33;
add.f64 fd50, %24, %35;
sub.f64 fd51, %22, %33;
sub.f64 fd52, %24, %35;
add.f64 fd53, %28, %38;
add.f64 fd54, %29, %39;
sub.f64 fd55, %28, %38;
sub.f64 fd56, %29, %39;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
add.f64 fd74, fd41, fd57;
add.f64 fd75, fd42, fd58;
sub.f64 fd76, fd41, fd57;
sub.f64 fd77, fd42, fd58;
add.f64 fd78, fd45, fd67;
add.f64 fd79, fd46, fd69;
sub.f64 fd80, fd45, fd67;
sub.f64 fd81, fd46, fd69;
add.f64 fd82, fd43, fd60;
sub.f64 fd83, fd44, fd59;
sub.f64 fd84, fd43, fd60;
add.f64 fd85, fd44, fd59;
add.f64 fd86, fd47, fd72;
add.f64 fd87, fd48, fd73;
sub.f64 fd88, fd47, fd72;
sub.f64 fd89, fd48, fd73;
and.b32 r6, r5, 511;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd90, fd91}, [rd5];
mul.f64 fd94, fd90, fd78;
mul.f64 fd95, fd91, fd79;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd90, fd79;
fma.rn.f64 fd98, fd91, fd78, fd97;
mul.f64 fd99, fd90, fd90;
mul.f64 fd100, fd91, fd91;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd91, fd90;
fma.rn.f64 fd103, fd91, fd90, fd102;
mul.f64 fd104, fd101, fd82;
mul.f64 fd105, fd103, fd83;
sub.f64 fd106, fd104, fd105;
mul.f64 fd107, fd101, fd83;
fma.rn.f64 fd108, fd103, fd82, fd107;
mul.f64 fd109, fd90, fd101;
mul.f64 fd110, fd91, fd103;
sub.f64 fd111, fd109, fd110;
mul.f64 fd112, fd90, fd103;
fma.rn.f64 fd113, fd91, fd101, fd112;
mul.f64 fd114, fd111, fd86;
mul.f64 fd115, fd113, fd87;
sub.f64 fd116, fd114, fd115;
mul.f64 fd117, fd111, fd87;
fma.rn.f64 fd118, fd113, fd86, fd117;
mul.f64 fd119, fd90, fd111;
mul.f64 fd120, fd91, fd113;
sub.f64 fd121, fd119, fd120;
mul.f64 fd122, fd90, fd113;
fma.rn.f64 fd123, fd91, fd111, fd122;
mul.f64 fd124, fd121, fd76;
mul.f64 fd125, fd123, fd77;
sub.f64 fd126, fd124, fd125;
mul.f64 fd127, fd121, fd77;
fma.rn.f64 fd128, fd123, fd76, fd127;
ld.global.v2.f64 {fd129, fd130}, [rd5+8192];
mul.f64 fd133, fd129, fd80;
mul.f64 fd134, fd130, fd81;
sub.f64 fd135, fd133, fd134;
mul.f64 fd136, fd129, fd81;
fma.rn.f64 fd137, fd130, fd80, fd136;
mul.f64 fd138, fd90, fd129;
mul.f64 fd139, fd91, fd130;
sub.f64 fd140, fd138, fd139;
mul.f64 fd141, fd90, fd130;
fma.rn.f64 fd142, fd91, fd129, fd141;
mul.f64 fd143, fd140, fd84;
mul.f64 fd144, fd142, fd85;
sub.f64 fd145, fd143, fd144;
mul.f64 fd146, fd140, fd85;
fma.rn.f64 fd147, fd142, fd84, fd146;
mul.f64 fd148, fd90, fd140;
mul.f64 fd149, fd91, fd142;
sub.f64 fd150, fd148, fd149;
mul.f64 fd151, fd90, fd142;
fma.rn.f64 fd152, fd91, fd140, fd151;
mul.f64 fd153, fd150, fd88;
mul.f64 fd154, fd152, fd89;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd150, fd89;
fma.rn.f64 fd157, fd152, fd88, fd156;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -32768;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 32704;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd74, fd96};
st.shared.v2.f64 [r12+16], {fd106, fd116};
st.shared.v2.f64 [r12+32], {fd126, fd135};
st.shared.v2.f64 [r12+48], {fd145, fd155};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.f64 fd158, [r13];
ld.shared.f64 fd159, [r13+4096];
ld.shared.f64 fd160, [r13+8192];
ld.shared.f64 fd161, [r13+12288];
ld.shared.f64 fd162, [r13+16384];
ld.shared.f64 fd163, [r13+20480];
ld.shared.f64 fd164, [r13+24576];
ld.shared.f64 fd165, [r13+28672];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd75, fd98};
st.shared.v2.f64 [r12+16], {fd108, fd118};
st.shared.v2.f64 [r12+32], {fd128, fd137};
st.shared.v2.f64 [r12+48], {fd147, fd157};
barrier.sync 0;
ld.shared.f64 fd166, [r13];
ld.shared.f64 fd167, [r13+4096];
ld.shared.f64 fd168, [r13+8192];
ld.shared.f64 fd169, [r13+12288];
ld.shared.f64 fd170, [r13+16384];
ld.shared.f64 fd171, [r13+20480];
ld.shared.f64 fd172, [r13+24576];
ld.shared.f64 fd173, [r13+28672];
add.f64 fd174, fd158, fd162;
add.f64 fd175, fd166, fd170;
sub.f64 fd176, fd158, fd162;
sub.f64 fd177, fd166, fd170;
add.f64 fd178, fd160, fd164;
add.f64 fd179, fd168, fd172;
sub.f64 fd180, fd160, fd164;
sub.f64 fd181, fd168, fd172;
add.f64 fd182, fd174, fd178;
add.f64 fd183, fd175, fd179;
sub.f64 fd184, fd174, fd178;
sub.f64 fd185, fd175, fd179;
add.f64 fd186, fd176, fd181;
sub.f64 fd187, fd177, fd180;
sub.f64 fd188, fd176, fd181;
add.f64 fd189, fd177, fd180;
add.f64 fd190, fd159, fd163;
add.f64 fd191, fd167, fd171;
sub.f64 fd192, fd159, fd163;
sub.f64 fd193, fd167, fd171;
add.f64 fd194, fd161, fd165;
add.f64 fd195, fd169, fd173;
sub.f64 fd196, fd161, fd165;
sub.f64 fd197, fd169, fd173;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
mul.f64 fd206, fd202, 0d3FE6A09E667F3BCD;
mul.f64 fd207, fd203, 0dBFE6A09E667F3BCD;
sub.f64 fd208, fd206, fd207;
mul.f64 fd209, fd203, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd210, fd202, 0dBFE6A09E667F3BCD, fd209;
mul.f64 fd211, fd204, 0dBFE6A09E667F3BCD;
mul.f64 fd212, fd205, 0dBFE6A09E667F3BCD;
sub.f64 fd213, fd211, fd212;
add.f64 fd214, fd211, fd212;
add.f64 fd215, fd182, fd198;
add.f64 fd216, fd183, fd199;
sub.f64 fd217, fd182, fd198;
sub.f64 fd218, fd183, fd199;
add.f64 fd219, fd186, fd208;
add.f64 fd220, fd187, fd210;
sub.f64 fd221, fd186, fd208;
sub.f64 fd222, fd187, fd210;
add.f64 fd223, fd184, fd201;
sub.f64 fd224, fd185, fd200;
sub.f64 fd225, fd184, fd201;
add.f64 fd226, fd185, fd200;
add.f64 fd227, fd188, fd213;
add.f64 fd228, fd189, fd214;
sub.f64 fd229, fd188, fd213;
sub.f64 fd230, fd189, fd214;
and.b32 r14, r5, 504;
bfe.u32 r15, r5, 3, 6;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd231, fd232}, [rd8];
mul.f64 fd235, fd231, fd219;
mul.f64 fd236, fd232, fd220;
sub.f64 fd237, fd235, fd236;
mul.f64 fd238, fd231, fd220;
fma.rn.f64 fd239, fd232, fd219, fd238;
mul.f64 fd240, fd231, fd231;
mul.f64 fd241, fd232, fd232;
sub.f64 fd242, fd240, fd241;
mul.f64 fd243, fd232, fd231;
fma.rn.f64 fd244, fd232, fd231, fd243;
mul.f64 fd245, fd242, fd223;
mul.f64 fd246, fd244, fd224;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd242, fd224;
fma.rn.f64 fd249, fd244, fd223, fd248;
mul.f64 fd250, fd231, fd242;
mul.f64 fd251, fd232, fd244;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd231, fd244;
fma.rn.f64 fd254, fd232, fd242, fd253;
mul.f64 fd255, fd252, fd227;
mul.f64 fd256, fd254, fd228;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd252, fd228;
fma.rn.f64 fd259, fd254, fd227, fd258;
mul.f64 fd260, fd231, fd252;
mul.f64 fd261, fd232, fd254;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd231, fd254;
fma.rn.f64 fd264, fd232, fd252, fd263;
mul.f64 fd265, fd262, fd217;
mul.f64 fd266, fd264, fd218;
sub.f64 fd267, fd265, fd266;
mul.f64 fd268, fd262, fd218;
fma.rn.f64 fd269, fd264, fd217, fd268;
ld.global.v2.f64 {fd270, fd271}, [rd8+1024];
mul.f64 fd274, fd270, fd221;
mul.f64 fd275, fd271, fd222;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd270, fd222;
fma.rn.f64 fd278, fd271, fd221, fd277;
mul.f64 fd279, fd231, fd270;
mul.f64 fd280, fd232, fd271;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd231, fd271;
fma.rn.f64 fd283, fd232, fd270, fd282;
mul.f64 fd284, fd281, fd225;
mul.f64 fd285, fd283, fd226;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd226;
fma.rn.f64 fd288, fd283, fd225, fd287;
mul.f64 fd289, fd231, fd281;
mul.f64 fd290, fd232, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd231, fd283;
fma.rn.f64 fd293, fd232, fd281, fd292;
mul.f64 fd294, fd291, fd229;
mul.f64 fd295, fd293, fd230;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd230;
fma.rn.f64 fd298, fd293, fd229, fd297;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 56;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 32256;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd215;
st.shared.f64 [r20+64], fd237;
st.shared.f64 [r20+128], fd247;
st.shared.f64 [r20+192], fd257;
st.shared.f64 [r20+256], fd267;
st.shared.f64 [r20+320], fd276;
st.shared.f64 [r20+384], fd286;
st.shared.f64 [r20+448], fd296;
barrier.sync 0;
mad.lo.s32 r21, r14, -56, r20;
ld.shared.f64 fd299, [r21];
ld.shared.f64 fd300, [r21+4096];
ld.shared.f64 fd301, [r21+8192];
ld.shared.f64 fd302, [r21+12288];
ld.shared.f64 fd303, [r21+16384];
ld.shared.f64 fd304, [r21+20480];
ld.shared.f64 fd305, [r21+24576];
ld.shared.f64 fd306, [r21+28672];
barrier.sync 0;
st.shared.f64 [r20], fd216;
st.shared.f64 [r20+64], fd239;
st.shared.f64 [r20+128], fd249;
st.shared.f64 [r20+192], fd259;
st.shared.f64 [r20+256], fd269;
st.shared.f64 [r20+320], fd278;
st.shared.f64 [r20+384], fd288;
st.shared.f64 [r20+448], fd298;
barrier.sync 0;
ld.shared.f64 fd307, [r21];
ld.shared.f64 fd308, [r21+4096];
ld.shared.f64 fd309, [r21+8192];
ld.shared.f64 fd310, [r21+12288];
ld.shared.f64 fd311, [r21+16384];
ld.shared.f64 fd312, [r21+20480];
ld.shared.f64 fd313, [r21+24576];
ld.shared.f64 fd314, [r21+28672];
add.f64 fd315, fd299, fd303;
add.f64 fd316, fd307, fd311;
sub.f64 fd317, fd299, fd303;
sub.f64 fd318, fd307, fd311;
add.f64 fd319, fd301, fd305;
add.f64 fd320, fd309, fd313;
sub.f64 fd321, fd301, fd305;
sub.f64 fd322, fd309, fd313;
add.f64 fd323, fd315, fd319;
add.f64 fd324, fd316, fd320;
sub.f64 fd325, fd315, fd319;
sub.f64 fd326, fd316, fd320;
add.f64 fd327, fd317, fd322;
sub.f64 fd328, fd318, fd321;
sub.f64 fd329, fd317, fd322;
add.f64 fd330, fd318, fd321;
add.f64 fd331, fd300, fd304;
add.f64 fd332, fd308, fd312;
sub.f64 fd333, fd300, fd304;
sub.f64 fd334, fd308, fd312;
add.f64 fd335, fd302, fd306;
add.f64 fd336, fd310, fd314;
sub.f64 fd337, fd302, fd306;
sub.f64 fd338, fd310, fd314;
add.f64 fd339, fd331, fd335;
add.f64 fd340, fd332, fd336;
sub.f64 fd341, fd331, fd335;
sub.f64 fd342, fd332, fd336;
add.f64 fd343, fd333, fd338;
sub.f64 fd344, fd334, fd337;
sub.f64 fd345, fd333, fd338;
add.f64 fd346, fd334, fd337;
mul.f64 fd347, fd343, 0d3FE6A09E667F3BCD;
mul.f64 fd348, fd344, 0dBFE6A09E667F3BCD;
sub.f64 fd349, fd347, fd348;
mul.f64 fd350, fd344, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd351, fd343, 0dBFE6A09E667F3BCD, fd350;
mul.f64 fd352, fd345, 0dBFE6A09E667F3BCD;
mul.f64 fd353, fd346, 0dBFE6A09E667F3BCD;
sub.f64 fd354, fd352, fd353;
add.f64 fd355, fd352, fd353;
add.f64 fd356, fd323, fd339;
add.f64 fd357, fd324, fd340;
sub.f64 fd358, fd323, fd339;
sub.f64 fd359, fd324, fd340;
add.f64 fd360, fd327, fd349;
add.f64 fd361, fd328, fd351;
sub.f64 fd362, fd327, fd349;
sub.f64 fd363, fd328, fd351;
add.f64 fd364, fd325, fd342;
sub.f64 fd365, fd326, fd341;
sub.f64 fd366, fd325, fd342;
add.f64 fd367, fd326, fd341;
add.f64 fd368, fd329, fd354;
add.f64 fd369, fd330, fd355;
sub.f64 fd370, fd329, fd354;
sub.f64 fd371, fd330, fd355;
and.b32 r22, r5, 448;
bfe.u32 r23, r5, 6, 3;
mul.wide.u32 rd9, r23, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd372, fd373}, [rd11];
mul.f64 fd376, fd372, fd360;
mul.f64 fd377, fd373, fd361;
sub.f64 fd378, fd376, fd377;
mul.f64 fd379, fd372, fd361;
fma.rn.f64 fd380, fd373, fd360, fd379;
mul.f64 fd381, fd372, fd372;
mul.f64 fd382, fd373, fd373;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd373, fd372;
fma.rn.f64 fd385, fd373, fd372, fd384;
mul.f64 fd386, fd383, fd364;
mul.f64 fd387, fd385, fd365;
sub.f64 fd388, fd386, fd387;
mul.f64 fd389, fd383, fd365;
fma.rn.f64 fd390, fd385, fd364, fd389;
mul.f64 fd391, fd372, fd383;
mul.f64 fd392, fd373, fd385;
sub.f64 fd393, fd391, fd392;
mul.f64 fd394, fd372, fd385;
fma.rn.f64 fd395, fd373, fd383, fd394;
mul.f64 fd396, fd393, fd368;
mul.f64 fd397, fd395, fd369;
sub.f64 fd398, fd396, fd397;
mul.f64 fd399, fd393, fd369;
fma.rn.f64 fd400, fd395, fd368, fd399;
mul.f64 fd401, fd372, fd393;
mul.f64 fd402, fd373, fd395;
sub.f64 fd403, fd401, fd402;
mul.f64 fd404, fd372, fd395;
fma.rn.f64 fd405, fd373, fd393, fd404;
mul.f64 fd406, fd403, fd358;
mul.f64 fd407, fd405, fd359;
sub.f64 fd408, fd406, fd407;
mul.f64 fd409, fd403, fd359;
fma.rn.f64 fd410, fd405, fd358, fd409;
ld.global.v2.f64 {fd411, fd412}, [rd11+128];
mul.f64 fd415, fd411, fd362;
mul.f64 fd416, fd412, fd363;
sub.f64 fd417, fd415, fd416;
mul.f64 fd418, fd411, fd363;
fma.rn.f64 fd419, fd412, fd362, fd418;
mul.f64 fd420, fd372, fd411;
mul.f64 fd421, fd373, fd412;
sub.f64 fd422, fd420, fd421;
mul.f64 fd423, fd372, fd412;
fma.rn.f64 fd424, fd373, fd411, fd423;
mul.f64 fd425, fd422, fd366;
mul.f64 fd426, fd424, fd367;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd422, fd367;
fma.rn.f64 fd429, fd424, fd366, fd428;
mul.f64 fd430, fd372, fd422;
mul.f64 fd431, fd373, fd424;
sub.f64 fd432, fd430, fd431;
mul.f64 fd433, fd372, fd424;
fma.rn.f64 fd434, fd373, fd422, fd433;
mul.f64 fd435, fd432, fd370;
mul.f64 fd436, fd434, fd371;
sub.f64 fd437, fd435, fd436;
mul.f64 fd438, fd432, fd371;
fma.rn.f64 fd439, fd434, fd370, fd438;
and.b32 r24, r16, 504;
add.s32 r25, r10, r24;
barrier.sync 0;
and.b32 r26, r8, 28672;
add.s32 r27, r25, r26;
st.shared.f64 [r27], fd356;
st.shared.f64 [r27+512], fd378;
st.shared.f64 [r27+1024], fd388;
st.shared.f64 [r27+1536], fd398;
st.shared.f64 [r27+2048], fd408;
st.shared.f64 [r27+2560], fd417;
st.shared.f64 [r27+3072], fd427;
st.shared.f64 [r27+3584], fd437;
barrier.sync 0;
mad.lo.s32 r28, r22, -56, r27;
ld.shared.f64 fd440, [r28];
ld.shared.f64 fd441, [r28+4096];
ld.shared.f64 fd442, [r28+8192];
ld.shared.f64 fd443, [r28+12288];
ld.shared.f64 fd444, [r28+16384];
ld.shared.f64 fd445, [r28+20480];
ld.shared.f64 fd446, [r28+24576];
ld.shared.f64 fd447, [r28+28672];
barrier.sync 0;
st.shared.f64 [r27], fd357;
st.shared.f64 [r27+512], fd380;
st.shared.f64 [r27+1024], fd390;
st.shared.f64 [r27+1536], fd400;
st.shared.f64 [r27+2048], fd410;
st.shared.f64 [r27+2560], fd419;
st.shared.f64 [r27+3072], fd429;
st.shared.f64 [r27+3584], fd439;
barrier.sync 0;
ld.shared.f64 fd448, [r28];
ld.shared.f64 fd449, [r28+4096];
ld.shared.f64 fd450, [r28+8192];
ld.shared.f64 fd451, [r28+12288];
ld.shared.f64 fd452, [r28+16384];
ld.shared.f64 fd453, [r28+20480];
ld.shared.f64 fd454, [r28+24576];
ld.shared.f64 fd455, [r28+28672];
add.f64 fd456, fd440, fd444;
add.f64 fd457, fd448, fd452;
sub.f64 fd458, fd440, fd444;
sub.f64 fd459, fd448, fd452;
add.f64 fd460, fd442, fd446;
add.f64 fd461, fd450, fd454;
sub.f64 fd462, fd442, fd446;
sub.f64 fd463, fd450, fd454;
add.f64 fd464, fd456, fd460;
add.f64 fd465, fd457, fd461;
sub.f64 fd466, fd456, fd460;
sub.f64 fd467, fd457, fd461;
add.f64 fd468, fd458, fd463;
sub.f64 fd469, fd459, fd462;
sub.f64 fd470, fd458, fd463;
add.f64 fd471, fd459, fd462;
add.f64 fd472, fd441, fd445;
add.f64 fd473, fd449, fd453;
sub.f64 fd474, fd441, fd445;
sub.f64 fd475, fd449, fd453;
add.f64 fd476, fd443, fd447;
add.f64 fd477, fd451, fd455;
sub.f64 fd478, fd443, fd447;
sub.f64 fd479, fd451, fd455;
add.f64 fd480, fd472, fd476;
add.f64 fd481, fd473, fd477;
sub.f64 fd482, fd472, fd476;
sub.f64 fd483, fd473, fd477;
add.f64 fd484, fd474, fd479;
sub.f64 fd485, fd475, fd478;
sub.f64 fd486, fd474, fd479;
add.f64 fd487, fd475, fd478;
mul.f64 fd488, fd484, 0d3FE6A09E667F3BCD;
mul.f64 fd489, fd485, 0dBFE6A09E667F3BCD;
sub.f64 fd490, fd488, fd489;
mul.f64 fd491, fd485, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd492, fd484, 0dBFE6A09E667F3BCD, fd491;
mul.f64 fd493, fd486, 0dBFE6A09E667F3BCD;
mul.f64 fd494, fd487, 0dBFE6A09E667F3BCD;
sub.f64 fd495, fd493, fd494;
add.f64 fd496, fd493, fd494;
add.f64 %0, fd464, fd480;
add.f64 %1, fd465, fd481;
add.f64 %3, fd469, fd492;
add.f64 %2, fd468, fd490;
sub.f64 %5, fd467, fd482;
add.f64 %4, fd466, fd483;
add.f64 %7, fd471, fd496;
add.f64 %6, fd470, fd495;
sub.f64 %8, fd464, fd480;
sub.f64 %9, fd465, fd481;
sub.f64 %11, fd469, fd492;
sub.f64 %10, fd468, fd490;
add.f64 %13, fd467, fd482;
sub.f64 %12, fd466, fd483;
sub.f64 %15, fd471, fd496;
sub.f64 %14, fd470, fd495;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_4096), "l"(lut_dp_8_512), "l"(lut_dp_8_64), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<494, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<49>;
.reg .f64 fd<1232>;
.reg .b64 rd<13>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 16;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f64 fd65, %35, %51;
sub.f64 fd67, %35, %51;
add.f64 fd1214, %36, %67;
sub.f64 fd68, %36, %67;
add.f64 fd69, %43, %59;
sub.f64 fd71, %43, %59;
add.f64 fd1212, %68, %60;
sub.f64 fd72, %68, %60;
add.f64 fd73, fd65, fd69;
sub.f64 fd75, fd65, fd69;
add.f64 fd1211, fd1214, fd1212;
sub.f64 fd76, fd1214, fd1212;
add.f64 fd77, fd67, fd72;
sub.f64 fd79, fd67, fd72;
sub.f64 fd1210, fd68, fd71;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %39, %55;
sub.f64 fd83, %39, %55;
add.f64 fd1207, %70, %69;
sub.f64 fd84, %70, %69;
add.f64 fd85, %47, %63;
sub.f64 fd87, %47, %63;
add.f64 fd1205, %48, %71;
sub.f64 fd88, %48, %71;
add.f64 fd89, fd81, fd85;
sub.f64 fd91, fd81, fd85;
add.f64 fd1204, fd1207, fd1205;
sub.f64 fd92, fd1207, fd1205;
add.f64 fd93, fd83, fd88;
sub.f64 fd95, fd83, fd88;
sub.f64 fd1203, fd84, fd87;
add.f64 fd96, fd84, fd87;
mul.f64 fd98, fd1203, 0dBFE6A09E667F3BCD;
mul.f64 fd1202, fd93, 0d3FE6A09E667F3BCD;
sub.f64 fd99, fd1202, fd98;
mul.f64 fd100, fd1203, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
sub.f64 fd108, fd73, fd89;
add.f64 fd1201, fd1211, fd1204;
sub.f64 fd109, fd1211, fd1204;
add.f64 fd110, fd77, fd99;
sub.f64 fd112, fd77, fd99;
add.f64 fd1200, fd1210, fd101;
sub.f64 fd113, fd1210, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd116, fd75, fd92;
sub.f64 fd1199, fd76, fd91;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
sub.f64 fd120, fd79, fd104;
add.f64 fd1198, fd80, fd105;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %37, %53;
sub.f64 fd124, %37, %53;
add.f64 fd1196, %72, %54;
sub.f64 fd125, %72, %54;
add.f64 fd126, %45, %61;
sub.f64 fd128, %45, %61;
add.f64 fd1193, %73, %74;
sub.f64 fd129, %73, %74;
add.f64 fd130, fd122, fd126;
sub.f64 fd132, fd122, fd126;
add.f64 fd1192, fd1196, fd1193;
sub.f64 fd133, fd1196, fd1193;
add.f64 fd134, fd124, fd129;
sub.f64 fd136, fd124, fd129;
sub.f64 fd1191, fd125, fd128;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %41, %57;
sub.f64 fd140, %41, %57;
add.f64 fd1189, %42, %75;
sub.f64 fd141, %42, %75;
add.f64 fd142, %49, %65;
sub.f64 fd144, %49, %65;
add.f64 fd1187, %76, %66;
sub.f64 fd145, %76, %66;
add.f64 fd146, fd138, fd142;
sub.f64 fd148, fd138, fd142;
add.f64 fd1186, fd1189, fd1187;
sub.f64 fd149, fd1189, fd1187;
add.f64 fd150, fd140, fd145;
sub.f64 fd152, fd140, fd145;
sub.f64 fd1185, fd141, fd144;
add.f64 fd153, fd141, fd144;
mul.f64 fd155, fd1185, 0dBFE6A09E667F3BCD;
mul.f64 fd1184, fd150, 0d3FE6A09E667F3BCD;
sub.f64 fd156, fd1184, fd155;
mul.f64 fd157, fd1185, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
sub.f64 fd165, fd130, fd146;
add.f64 fd1183, fd1192, fd1186;
sub.f64 fd166, fd1192, fd1186;
add.f64 fd167, fd134, fd156;
sub.f64 fd169, fd134, fd156;
add.f64 fd1182, fd1191, fd158;
sub.f64 fd170, fd1191, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd173, fd132, fd149;
sub.f64 fd1181, fd133, fd148;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
sub.f64 fd177, fd136, fd161;
add.f64 fd1180, fd137, fd162;
sub.f64 fd178, fd137, fd162;
mul.f64 fd1178, fd167, 0d3FED906BCF328D46;
mul.f64 fd1179, fd1182, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd1178, fd1179;
mul.f64 fd182, fd1182, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd1176, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd1177, fd1181, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd1176, fd1177;
mul.f64 fd187, fd1181, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd1174, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd1175, fd1180, 0dBFED906BCF328D46;
sub.f64 fd191, fd1174, fd1175;
mul.f64 fd192, fd1180, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd1172, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd1173, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd1172, fd1173;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd1170, fd177, 0dBFED906BCF328D46;
mul.f64 fd1171, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd1170, fd1171;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd210, fd110, fd181;
sub.f64 fd212, fd110, fd181;
add.f64 fd1169, fd1200, fd183;
sub.f64 fd213, fd1200, fd183;
add.f64 fd214, fd114, fd186;
sub.f64 fd216, fd114, fd186;
add.f64 fd1168, fd1199, fd188;
sub.f64 fd217, fd1199, fd188;
add.f64 fd218, fd118, fd191;
sub.f64 fd220, fd118, fd191;
add.f64 fd1167, fd1198, fd193;
sub.f64 fd221, fd1198, fd193;
add.f64 fd222, fd108, fd166;
sub.f64 fd224, fd108, fd166;
sub.f64 fd1166, fd109, fd165;
add.f64 fd225, fd109, fd165;
add.f64 fd226, fd112, fd196;
sub.f64 fd228, fd112, fd196;
add.f64 fd1165, fd113, fd198;
sub.f64 fd229, fd113, fd198;
add.f64 fd230, fd116, fd201;
sub.f64 fd232, fd116, fd201;
add.f64 fd1164, fd117, fd202;
sub.f64 fd233, fd117, fd202;
add.f64 fd234, fd120, fd205;
sub.f64 fd236, fd120, fd205;
add.f64 fd1163, fd121, fd207;
sub.f64 fd237, fd121, fd207;
mov.u32 r21, %tid.x;
shl.b32 r7, r21, 8;
and.b32 r8, r7, -65536;
add.s32 r9, r4, r8;
shl.b32 r10, r21, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 4080;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd238, fd239}, [rd5];
mul.f64 fd243, fd239, fd1169;
mul.f64 fd244, fd238, fd1169;
mul.f64 fd246, fd239, fd239;
mul.f64 fd1162, fd238, fd238;
sub.f64 fd247, fd1162, fd246;
mul.f64 fd248, fd239, fd238;
fma.rn.f64 fd249, fd239, fd238, fd248;
mul.f64 fd251, fd249, fd1168;
mul.f64 fd252, fd247, fd1168;
mul.f64 fd1160, fd238, fd247;
mul.f64 fd1161, fd239, fd249;
sub.f64 fd255, fd1160, fd1161;
mul.f64 fd1159, fd247, fd214;
mul.f64 fd256, fd238, fd249;
fma.rn.f64 fd257, fd239, fd247, fd256;
mul.f64 fd259, fd257, fd1167;
mul.f64 fd260, fd255, fd1167;
mul.f64 fd262, fd239, fd257;
mul.f64 fd1158, fd238, fd255;
sub.f64 fd263, fd1158, fd262;
mul.f64 fd1157, fd255, fd218;
mul.f64 fd264, fd238, fd257;
fma.rn.f64 fd265, fd239, fd255, fd264;
mul.f64 fd267, fd265, fd1166;
mul.f64 fd268, fd263, fd1166;
mul.f64 fd270, fd239, fd265;
mul.f64 fd1156, fd238, fd263;
sub.f64 fd271, fd1156, fd270;
mul.f64 fd1155, fd263, fd222;
mul.f64 fd272, fd238, fd265;
fma.rn.f64 fd273, fd239, fd263, fd272;
mul.f64 fd275, fd273, fd1165;
mul.f64 fd276, fd271, fd1165;
mul.f64 fd1153, fd238, fd271;
mul.f64 fd1154, fd239, fd273;
sub.f64 fd279, fd1153, fd1154;
mul.f64 fd1152, fd271, fd226;
mul.f64 fd280, fd238, fd273;
fma.rn.f64 fd281, fd239, fd271, fd280;
mul.f64 fd283, fd281, fd1164;
mul.f64 fd284, fd279, fd1164;
mul.f64 fd286, fd239, fd281;
mul.f64 fd1151, fd238, fd279;
sub.f64 fd287, fd1151, fd286;
mul.f64 fd1150, fd279, fd230;
mul.f64 fd288, fd238, fd281;
fma.rn.f64 fd289, fd239, fd279, fd288;
mul.f64 fd291, fd289, fd1163;
mul.f64 fd292, fd287, fd1163;
mul.f64 fd294, fd239, fd289;
mul.f64 fd1149, fd238, fd287;
sub.f64 fd295, fd1149, fd294;
mul.f64 fd1148, fd287, fd234;
mul.f64 fd296, fd238, fd289;
fma.rn.f64 fd297, fd239, fd287, fd296;
sub.f64 fd1147, fd1201, fd1183;
sub.f64 fd1146, fd106, fd163;
mul.f64 fd298, fd295, fd1146;
mul.f64 fd299, fd297, fd1147;
mul.f64 fd300, fd295, fd1147;
ld.global.v2.f64 {fd301, fd302}, [rd5+4096];
mul.f64 fd306, fd302, fd213;
mul.f64 fd307, fd301, fd213;
mul.f64 fd1144, fd238, fd301;
mul.f64 fd1145, fd239, fd302;
sub.f64 fd310, fd1144, fd1145;
mul.f64 fd1143, fd301, fd212;
mul.f64 fd311, fd238, fd302;
fma.rn.f64 fd312, fd239, fd301, fd311;
mul.f64 fd314, fd312, fd217;
mul.f64 fd315, fd310, fd217;
mul.f64 fd317, fd239, fd312;
mul.f64 fd1142, fd238, fd310;
sub.f64 fd318, fd1142, fd317;
mul.f64 fd1141, fd310, fd216;
mul.f64 fd319, fd238, fd312;
fma.rn.f64 fd320, fd239, fd310, fd319;
mul.f64 fd322, fd320, fd221;
mul.f64 fd323, fd318, fd221;
mul.f64 fd1139, fd238, fd318;
mul.f64 fd1140, fd239, fd320;
sub.f64 fd326, fd1139, fd1140;
mul.f64 fd1138, fd318, fd220;
mul.f64 fd327, fd238, fd320;
fma.rn.f64 fd328, fd239, fd318, fd327;
mul.f64 fd330, fd328, fd225;
mul.f64 fd331, fd326, fd225;
mul.f64 fd1136, fd238, fd326;
mul.f64 fd1137, fd239, fd328;
sub.f64 fd334, fd1136, fd1137;
mul.f64 fd1135, fd326, fd224;
mul.f64 fd335, fd238, fd328;
fma.rn.f64 fd336, fd239, fd326, fd335;
mul.f64 fd338, fd336, fd229;
mul.f64 fd339, fd334, fd229;
mul.f64 fd341, fd239, fd336;
mul.f64 fd1134, fd238, fd334;
sub.f64 fd342, fd1134, fd341;
mul.f64 fd1133, fd334, fd228;
mul.f64 fd343, fd238, fd336;
fma.rn.f64 fd344, fd239, fd334, fd343;
mul.f64 fd346, fd344, fd233;
mul.f64 fd347, fd342, fd233;
mul.f64 fd1131, fd238, fd342;
mul.f64 fd1132, fd239, fd344;
sub.f64 fd350, fd1131, fd1132;
mul.f64 fd1130, fd238, fd210;
mul.f64 fd351, fd238, fd344;
mul.f64 fd1129, fd342, fd232;
fma.rn.f64 fd352, fd239, fd342, fd351;
mul.f64 fd353, fd350, fd236;
mul.f64 fd354, fd352, fd237;
mul.f64 fd355, fd350, fd237;
sub.f64 fd1227, fd1201, fd1183;
mul.f64 fd1226, fd297, fd1227;
mov.u32 r48, %tid.x;
shl.b32 r47, r48, 8;
barrier.sync 0;
and.b32 r11, r47, 65280;
add.s32 r12, r9, r11;
mov.u32 r32, %tid.x;
shl.b32 r31, r32, 4;
sub.f64 fd1231, fd1201, fd1183;
mul.f64 fd1230, fd297, fd1231;
add.f64 fd356, fd1201, fd1183;
mov.u32 r40, %tid.x;
shl.b32 r39, r40, 8;
and.b32 r23, r39, 65280;
add.s32 r22, r9, r23;
sub.f64 fd1225, fd106, fd163;
add.f64 fd357, fd106, fd163;
mov.u32 r38, %tid.x;
shl.b32 r37, r38, 8;
and.b32 r30, r37, 65280;
add.s32 r29, r9, r30;
st.shared.v2.f64 [r29], {fd357, fd356};
mov.u32 r28, %tid.x;
fma.rn.f64 fd358, fd239, fd210, fd244;
sub.f64 fd359, fd1130, fd243;
st.shared.v2.f64 [r29+16], {fd359, fd358};
fma.rn.f64 fd360, fd249, fd214, fd252;
sub.f64 fd361, fd1159, fd251;
st.shared.v2.f64 [r29+32], {fd361, fd360};
fma.rn.f64 fd362, fd257, fd218, fd260;
sub.f64 fd363, fd1157, fd259;
st.shared.v2.f64 [r29+48], {fd363, fd362};
sub.f64 fd364, fd1155, fd267;
fma.rn.f64 fd365, fd265, fd222, fd268;
st.shared.v2.f64 [r29+64], {fd364, fd365};
fma.rn.f64 fd366, fd273, fd226, fd276;
sub.f64 fd367, fd1152, fd275;
st.shared.v2.f64 [r29+80], {fd367, fd366};
fma.rn.f64 fd368, fd281, fd230, fd284;
sub.f64 fd369, fd1150, fd283;
st.shared.v2.f64 [r29+96], {fd369, fd368};
fma.rn.f64 fd370, fd289, fd234, fd292;
sub.f64 fd371, fd1148, fd291;
st.shared.v2.f64 [r29+112], {fd371, fd370};
fma.rn.f64 fd372, fd297, fd1225, fd300;
sub.f64 fd373, fd298, fd1230;
st.shared.v2.f64 [r29+128], {fd373, fd372};
fma.rn.f64 fd374, fd302, fd212, fd307;
sub.f64 fd375, fd1143, fd306;
st.shared.v2.f64 [r29+144], {fd375, fd374};
fma.rn.f64 fd376, fd312, fd216, fd315;
sub.f64 fd377, fd1141, fd314;
st.shared.v2.f64 [r29+160], {fd377, fd376};
fma.rn.f64 fd378, fd320, fd220, fd323;
sub.f64 fd379, fd1138, fd322;
st.shared.v2.f64 [r29+176], {fd379, fd378};
sub.f64 fd380, fd1135, fd330;
fma.rn.f64 fd381, fd328, fd224, fd331;
st.shared.v2.f64 [r29+192], {fd380, fd381};
fma.rn.f64 fd382, fd336, fd228, fd339;
sub.f64 fd383, fd1133, fd338;
st.shared.v2.f64 [r29+208], {fd383, fd382};
fma.rn.f64 fd384, fd344, fd232, fd347;
sub.f64 fd385, fd1129, fd346;
st.shared.v2.f64 [r29+224], {fd385, fd384};
fma.rn.f64 fd386, fd352, fd236, fd355;
sub.f64 fd387, fd353, fd354;
st.shared.v2.f64 [r29+240], {fd387, fd386};
barrier.sync 0;
and.b32 r20, r28, 255;
mad.lo.s32 r13, r20, -240, r29;
ld.shared.v2.f64 {fd388, fd389}, [r13];
ld.shared.v2.f64 {fd392, fd393}, [r13+4096];
ld.shared.v2.f64 {fd396, fd397}, [r13+8192];
ld.shared.v2.f64 {fd400, fd401}, [r13+12288];
ld.shared.v2.f64 {fd404, fd405}, [r13+16384];
ld.shared.v2.f64 {fd408, fd409}, [r13+20480];
ld.shared.v2.f64 {fd412, fd413}, [r13+24576];
ld.shared.v2.f64 {fd416, fd417}, [r13+28672];
ld.shared.v2.f64 {fd420, fd421}, [r13+32768];
ld.shared.v2.f64 {fd424, fd425}, [r13+36864];
ld.shared.v2.f64 {fd428, fd429}, [r13+40960];
ld.shared.v2.f64 {fd432, fd433}, [r13+45056];
ld.shared.v2.f64 {fd436, fd437}, [r13+49152];
ld.shared.v2.f64 {fd440, fd441}, [r13+53248];
ld.shared.v2.f64 {fd444, fd445}, [r13+57344];
ld.shared.v2.f64 {fd448, fd449}, [r13+61440];
add.f64 fd452, fd388, fd420;
sub.f64 fd454, fd388, fd420;
add.f64 fd1128, fd389, fd421;
sub.f64 fd455, fd389, fd421;
add.f64 fd456, fd404, fd436;
sub.f64 fd458, fd404, fd436;
add.f64 fd1127, fd405, fd437;
sub.f64 fd459, fd405, fd437;
add.f64 fd460, fd452, fd456;
sub.f64 fd462, fd452, fd456;
add.f64 fd1126, fd1128, fd1127;
sub.f64 fd463, fd1128, fd1127;
add.f64 fd464, fd454, fd459;
sub.f64 fd466, fd454, fd459;
sub.f64 fd1125, fd455, fd458;
add.f64 fd467, fd455, fd458;
add.f64 fd468, fd396, fd428;
sub.f64 fd470, fd396, fd428;
add.f64 fd1124, fd397, fd429;
sub.f64 fd471, fd397, fd429;
add.f64 fd472, fd412, fd444;
sub.f64 fd474, fd412, fd444;
add.f64 fd1123, fd413, fd445;
sub.f64 fd475, fd413, fd445;
add.f64 fd476, fd468, fd472;
sub.f64 fd478, fd468, fd472;
add.f64 fd1122, fd1124, fd1123;
sub.f64 fd479, fd1124, fd1123;
add.f64 fd480, fd470, fd475;
sub.f64 fd482, fd470, fd475;
sub.f64 fd1121, fd471, fd474;
add.f64 fd483, fd471, fd474;
mul.f64 fd485, fd1121, 0dBFE6A09E667F3BCD;
mul.f64 fd1120, fd480, 0d3FE6A09E667F3BCD;
sub.f64 fd486, fd1120, fd485;
mul.f64 fd487, fd1121, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd488, fd480, 0dBFE6A09E667F3BCD, fd487;
mul.f64 fd489, fd482, 0dBFE6A09E667F3BCD;
mul.f64 fd490, fd483, 0dBFE6A09E667F3BCD;
sub.f64 fd491, fd489, fd490;
add.f64 fd492, fd489, fd490;
add.f64 fd493, fd460, fd476;
sub.f64 fd495, fd460, fd476;
add.f64 fd1119, fd1126, fd1122;
sub.f64 fd496, fd1126, fd1122;
add.f64 fd497, fd464, fd486;
sub.f64 fd499, fd464, fd486;
add.f64 fd1118, fd1125, fd488;
sub.f64 fd500, fd1125, fd488;
add.f64 fd501, fd462, fd479;
sub.f64 fd503, fd462, fd479;
sub.f64 fd1117, fd463, fd478;
add.f64 fd504, fd463, fd478;
add.f64 fd505, fd466, fd491;
sub.f64 fd507, fd466, fd491;
add.f64 fd1116, fd467, fd492;
sub.f64 fd508, fd467, fd492;
add.f64 fd509, fd392, fd424;
sub.f64 fd511, fd392, fd424;
add.f64 fd1115, fd393, fd425;
sub.f64 fd512, fd393, fd425;
add.f64 fd513, fd408, fd440;
sub.f64 fd515, fd408, fd440;
add.f64 fd1114, fd409, fd441;
sub.f64 fd516, fd409, fd441;
add.f64 fd517, fd509, fd513;
sub.f64 fd519, fd509, fd513;
add.f64 fd1113, fd1115, fd1114;
sub.f64 fd520, fd1115, fd1114;
add.f64 fd521, fd511, fd516;
sub.f64 fd523, fd511, fd516;
sub.f64 fd1112, fd512, fd515;
add.f64 fd524, fd512, fd515;
add.f64 fd525, fd400, fd432;
sub.f64 fd527, fd400, fd432;
add.f64 fd1111, fd401, fd433;
sub.f64 fd528, fd401, fd433;
add.f64 fd529, fd416, fd448;
sub.f64 fd531, fd416, fd448;
add.f64 fd1110, fd417, fd449;
sub.f64 fd532, fd417, fd449;
add.f64 fd533, fd525, fd529;
sub.f64 fd535, fd525, fd529;
add.f64 fd1109, fd1111, fd1110;
sub.f64 fd536, fd1111, fd1110;
add.f64 fd537, fd527, fd532;
sub.f64 fd539, fd527, fd532;
sub.f64 fd1108, fd528, fd531;
add.f64 fd540, fd528, fd531;
mul.f64 fd542, fd1108, 0dBFE6A09E667F3BCD;
mul.f64 fd1107, fd537, 0d3FE6A09E667F3BCD;
sub.f64 fd543, fd1107, fd542;
mul.f64 fd544, fd1108, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd545, fd537, 0dBFE6A09E667F3BCD, fd544;
mul.f64 fd546, fd539, 0dBFE6A09E667F3BCD;
mul.f64 fd547, fd540, 0dBFE6A09E667F3BCD;
sub.f64 fd548, fd546, fd547;
add.f64 fd549, fd546, fd547;
add.f64 fd550, fd517, fd533;
sub.f64 fd552, fd517, fd533;
add.f64 fd1106, fd1113, fd1109;
sub.f64 fd553, fd1113, fd1109;
add.f64 fd554, fd521, fd543;
sub.f64 fd556, fd521, fd543;
add.f64 fd1105, fd1112, fd545;
sub.f64 fd557, fd1112, fd545;
add.f64 fd558, fd519, fd536;
sub.f64 fd560, fd519, fd536;
sub.f64 fd1104, fd520, fd535;
add.f64 fd561, fd520, fd535;
add.f64 fd562, fd523, fd548;
sub.f64 fd564, fd523, fd548;
add.f64 fd1103, fd524, fd549;
sub.f64 fd565, fd524, fd549;
mul.f64 fd1101, fd554, 0d3FED906BCF328D46;
mul.f64 fd1102, fd1105, 0dBFD87DE2A6AEA963;
sub.f64 fd568, fd1101, fd1102;
mul.f64 fd569, fd1105, 0d3FED906BCF328D46;
fma.rn.f64 fd570, fd554, 0dBFD87DE2A6AEA963, fd569;
mul.f64 fd572, fd1104, 0dBFE6A09E667F3BCD;
mul.f64 fd1100, fd558, 0d3FE6A09E667F3BCD;
sub.f64 fd573, fd1100, fd572;
mul.f64 fd574, fd1104, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd575, fd558, 0dBFE6A09E667F3BCD, fd574;
mul.f64 fd577, fd1103, 0dBFED906BCF328D46;
mul.f64 fd1099, fd562, 0d3FD87DE2A6AEA963;
sub.f64 fd578, fd1099, fd577;
mul.f64 fd579, fd1103, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd580, fd562, 0dBFED906BCF328D46, fd579;
mul.f64 fd582, fd557, 0dBFED906BCF328D46;
mul.f64 fd1098, fd556, 0dBFD87DE2A6AEA963;
sub.f64 fd583, fd1098, fd582;
mul.f64 fd584, fd557, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd585, fd556, 0dBFED906BCF328D46, fd584;
mul.f64 fd586, fd560, 0dBFE6A09E667F3BCD;
mul.f64 fd587, fd561, 0dBFE6A09E667F3BCD;
sub.f64 fd588, fd586, fd587;
add.f64 fd589, fd586, fd587;
mul.f64 fd591, fd565, 0dBFD87DE2A6AEA963;
mul.f64 fd1097, fd564, 0dBFED906BCF328D46;
sub.f64 fd592, fd1097, fd591;
mul.f64 fd593, fd565, 0dBFED906BCF328D46;
fma.rn.f64 fd594, fd564, 0dBFD87DE2A6AEA963, fd593;
add.f64 fd597, fd497, fd568;
sub.f64 fd599, fd497, fd568;
add.f64 fd1096, fd1118, fd570;
sub.f64 fd600, fd1118, fd570;
add.f64 fd601, fd501, fd573;
sub.f64 fd603, fd501, fd573;
add.f64 fd1095, fd1117, fd575;
sub.f64 fd604, fd1117, fd575;
add.f64 fd605, fd505, fd578;
sub.f64 fd607, fd505, fd578;
add.f64 fd1094, fd1116, fd580;
sub.f64 fd608, fd1116, fd580;
add.f64 fd609, fd495, fd553;
sub.f64 fd611, fd495, fd553;
sub.f64 fd1093, fd496, fd552;
add.f64 fd612, fd496, fd552;
add.f64 fd613, fd499, fd583;
sub.f64 fd615, fd499, fd583;
add.f64 fd1092, fd500, fd585;
sub.f64 fd616, fd500, fd585;
add.f64 fd617, fd503, fd588;
sub.f64 fd619, fd503, fd588;
add.f64 fd1091, fd504, fd589;
sub.f64 fd620, fd504, fd589;
add.f64 fd621, fd507, fd592;
sub.f64 fd623, fd507, fd592;
add.f64 fd1090, fd508, fd594;
sub.f64 fd624, fd508, fd594;
and.b32 r14, r28, 240;
mov.u64 rd7, %34;
cvt.u64.u32 rd9, r14;
add.s64 rd8, rd7, rd9;
ld.global.v2.f64 {fd625, fd626}, [rd8];
mul.f64 fd630, fd626, fd1096;
mul.f64 fd631, fd625, fd1096;
mul.f64 fd633, fd626, fd626;
mul.f64 fd1089, fd625, fd625;
sub.f64 fd634, fd1089, fd633;
mul.f64 fd635, fd626, fd625;
fma.rn.f64 fd636, fd626, fd625, fd635;
mul.f64 fd638, fd636, fd1095;
mul.f64 fd639, fd634, fd1095;
mul.f64 fd1087, fd625, fd634;
mul.f64 fd1088, fd626, fd636;
sub.f64 fd642, fd1087, fd1088;
mul.f64 fd1086, fd634, fd601;
mul.f64 fd643, fd625, fd636;
fma.rn.f64 fd644, fd626, fd634, fd643;
mul.f64 fd646, fd644, fd1094;
mul.f64 fd647, fd642, fd1094;
mul.f64 fd649, fd626, fd644;
mul.f64 fd1085, fd625, fd642;
sub.f64 fd650, fd1085, fd649;
mul.f64 fd1084, fd642, fd605;
mul.f64 fd651, fd625, fd644;
fma.rn.f64 fd652, fd626, fd642, fd651;
mul.f64 fd654, fd652, fd1093;
mul.f64 fd655, fd650, fd1093;
mul.f64 fd1082, fd625, fd650;
mul.f64 fd1083, fd626, fd652;
sub.f64 fd658, fd1082, fd1083;
mul.f64 fd1081, fd650, fd609;
mul.f64 fd659, fd625, fd652;
fma.rn.f64 fd660, fd626, fd650, fd659;
mul.f64 fd662, fd660, fd1092;
mul.f64 fd663, fd658, fd1092;
mul.f64 fd1079, fd625, fd658;
mul.f64 fd1080, fd626, fd660;
sub.f64 fd666, fd1079, fd1080;
mul.f64 fd1078, fd658, fd613;
mul.f64 fd667, fd625, fd660;
fma.rn.f64 fd668, fd626, fd658, fd667;
mul.f64 fd670, fd668, fd1091;
mul.f64 fd671, fd666, fd1091;
mul.f64 fd673, fd626, fd668;
mul.f64 fd1077, fd625, fd666;
sub.f64 fd674, fd1077, fd673;
mul.f64 fd1076, fd666, fd617;
mul.f64 fd675, fd625, fd668;
fma.rn.f64 fd676, fd626, fd666, fd675;
mul.f64 fd678, fd676, fd1090;
mul.f64 fd679, fd674, fd1090;
mul.f64 fd1074, fd625, fd674;
mul.f64 fd1075, fd626, fd676;
sub.f64 fd682, fd1074, fd1075;
mul.f64 fd1073, fd674, fd621;
mul.f64 fd683, fd625, fd676;
fma.rn.f64 fd684, fd626, fd674, fd683;
sub.f64 fd1072, fd1119, fd1106;
sub.f64 fd1071, fd493, fd550;
mul.f64 fd685, fd682, fd1071;
mul.f64 fd686, fd684, fd1072;
mul.f64 fd687, fd682, fd1072;
ld.global.v2.f64 {fd688, fd689}, [rd8+256];
mul.f64 fd693, fd689, fd600;
mul.f64 fd694, fd688, fd600;
mul.f64 fd696, fd626, fd689;
mul.f64 fd1070, fd625, fd688;
sub.f64 fd697, fd1070, fd696;
mul.f64 fd1069, fd688, fd599;
mul.f64 fd698, fd625, fd689;
fma.rn.f64 fd699, fd626, fd688, fd698;
mul.f64 fd701, fd699, fd604;
mul.f64 fd702, fd697, fd604;
mul.f64 fd704, fd626, fd699;
mul.f64 fd1068, fd625, fd697;
sub.f64 fd705, fd1068, fd704;
mul.f64 fd1067, fd697, fd603;
mul.f64 fd706, fd625, fd699;
fma.rn.f64 fd707, fd626, fd697, fd706;
mul.f64 fd709, fd707, fd608;
mul.f64 fd710, fd705, fd608;
mul.f64 fd1065, fd625, fd705;
mul.f64 fd1066, fd626, fd707;
sub.f64 fd713, fd1065, fd1066;
mul.f64 fd1064, fd705, fd607;
mul.f64 fd714, fd625, fd707;
fma.rn.f64 fd715, fd626, fd705, fd714;
mul.f64 fd717, fd715, fd612;
mul.f64 fd718, fd713, fd612;
mul.f64 fd720, fd626, fd715;
mul.f64 fd1063, fd625, fd713;
sub.f64 fd721, fd1063, fd720;
mul.f64 fd1062, fd713, fd611;
mul.f64 fd722, fd625, fd715;
fma.rn.f64 fd723, fd626, fd713, fd722;
mul.f64 fd725, fd723, fd616;
mul.f64 fd726, fd721, fd616;
mul.f64 fd728, fd626, fd723;
mul.f64 fd1061, fd625, fd721;
sub.f64 fd729, fd1061, fd728;
mul.f64 fd1060, fd721, fd615;
mul.f64 fd730, fd625, fd723;
fma.rn.f64 fd731, fd626, fd721, fd730;
mul.f64 fd733, fd731, fd620;
mul.f64 fd734, fd729, fd620;
mul.f64 fd1058, fd625, fd729;
mul.f64 fd1059, fd626, fd731;
sub.f64 fd737, fd1058, fd1059;
mul.f64 fd1057, fd625, fd597;
mul.f64 fd738, fd625, fd731;
mul.f64 fd1056, fd729, fd619;
fma.rn.f64 fd739, fd626, fd729, fd738;
mul.f64 fd740, fd737, fd623;
mul.f64 fd741, fd739, fd624;
mul.f64 fd742, fd737, fd624;
sub.f64 fd1219, fd1119, fd1106;
mul.f64 fd1218, fd684, fd1219;
mov.u32 r36, %tid.x;
shl.b32 r35, r36, 8;
mov.u32 r46, %tid.x;
shl.b32 r45, r46, 4;
and.b32 r15, r45, 240;
add.s32 r16, r9, r15;
sub.f64 fd1223, fd1119, fd1106;
mul.f64 fd1222, fd684, fd1223;
mov.u32 r44, %tid.x;
shl.b32 r43, r44, 8;
barrier.sync 0;
and.b32 r17, r43, 61440;
add.s32 r18, r16, r17;
mov.u32 r27, %tid.x;
and.b32 r26, r27, 240;
sub.f64 fd1229, fd1119, fd1106;
mul.f64 fd1228, fd684, fd1229;
add.f64 fd743, fd1119, fd1106;
sub.f64 fd1224, fd493, fd550;
add.f64 fd744, fd493, fd550;
st.shared.v2.f64 [r18], {fd744, fd743};
mov.u32 r34, %tid.x;
and.b32 r33, r34, 240;
mov.u32 r42, %tid.x;
and.b32 r41, r42, 240;
fma.rn.f64 fd745, fd626, fd597, fd631;
sub.f64 fd746, fd1057, fd630;
st.shared.v2.f64 [r18+256], {fd746, fd745};
fma.rn.f64 fd747, fd636, fd601, fd639;
sub.f64 fd748, fd1086, fd638;
st.shared.v2.f64 [r18+512], {fd748, fd747};
fma.rn.f64 fd749, fd644, fd605, fd647;
sub.f64 fd750, fd1084, fd646;
st.shared.v2.f64 [r18+768], {fd750, fd749};
fma.rn.f64 fd751, fd652, fd609, fd655;
sub.f64 fd752, fd1081, fd654;
st.shared.v2.f64 [r18+1024], {fd752, fd751};
sub.f64 fd753, fd1078, fd662;
fma.rn.f64 fd754, fd660, fd613, fd663;
st.shared.v2.f64 [r18+1280], {fd753, fd754};
fma.rn.f64 fd755, fd668, fd617, fd671;
sub.f64 fd756, fd1076, fd670;
st.shared.v2.f64 [r18+1536], {fd756, fd755};
fma.rn.f64 fd757, fd676, fd621, fd679;
sub.f64 fd758, fd1073, fd678;
st.shared.v2.f64 [r18+1792], {fd758, fd757};
fma.rn.f64 fd759, fd684, fd1224, fd687;
sub.f64 fd760, fd685, fd1228;
st.shared.v2.f64 [r18+2048], {fd760, fd759};
fma.rn.f64 fd761, fd689, fd599, fd694;
sub.f64 fd762, fd1069, fd693;
st.shared.v2.f64 [r18+2304], {fd762, fd761};
fma.rn.f64 fd763, fd699, fd603, fd702;
sub.f64 fd764, fd1067, fd701;
st.shared.v2.f64 [r18+2560], {fd764, fd763};
fma.rn.f64 fd765, fd707, fd607, fd710;
sub.f64 fd766, fd1064, fd709;
st.shared.v2.f64 [r18+2816], {fd766, fd765};
fma.rn.f64 fd767, fd715, fd611, fd718;
sub.f64 fd768, fd1062, fd717;
st.shared.v2.f64 [r18+3072], {fd768, fd767};
sub.f64 fd769, fd1060, fd725;
fma.rn.f64 fd770, fd723, fd615, fd726;
st.shared.v2.f64 [r18+3328], {fd769, fd770};
fma.rn.f64 fd771, fd731, fd619, fd734;
sub.f64 fd772, fd1056, fd733;
st.shared.v2.f64 [r18+3584], {fd772, fd771};
fma.rn.f64 fd773, fd739, fd623, fd742;
sub.f64 fd774, fd740, fd741;
st.shared.v2.f64 [r18+3840], {fd774, fd773};
barrier.sync 0;
mad.lo.s32 r19, r41, -240, r18;
ld.shared.v2.f64 {fd775, fd776}, [r19];
ld.shared.v2.f64 {fd779, fd780}, [r19+4096];
ld.shared.v2.f64 {fd783, fd784}, [r19+8192];
ld.shared.v2.f64 {fd787, fd788}, [r19+12288];
ld.shared.v2.f64 {fd791, fd792}, [r19+16384];
ld.shared.v2.f64 {fd795, fd796}, [r19+20480];
ld.shared.v2.f64 {fd799, fd800}, [r19+24576];
ld.shared.v2.f64 {fd803, fd804}, [r19+28672];
ld.shared.v2.f64 {fd807, fd808}, [r19+32768];
ld.shared.v2.f64 {fd811, fd812}, [r19+36864];
ld.shared.v2.f64 {fd815, fd816}, [r19+40960];
ld.shared.v2.f64 {fd819, fd820}, [r19+45056];
ld.shared.v2.f64 {fd823, fd824}, [r19+49152];
ld.shared.v2.f64 {fd827, fd828}, [r19+53248];
ld.shared.v2.f64 {fd831, fd832}, [r19+57344];
ld.shared.v2.f64 {fd835, fd836}, [r19+61440];
add.f64 fd839, fd775, fd807;
sub.f64 fd841, fd775, fd807;
add.f64 fd1055, fd776, fd808;
sub.f64 fd842, fd776, fd808;
add.f64 fd843, fd791, fd823;
sub.f64 fd845, fd791, fd823;
add.f64 fd1054, fd792, fd824;
sub.f64 fd846, fd792, fd824;
add.f64 fd847, fd839, fd843;
sub.f64 fd849, fd839, fd843;
add.f64 fd1053, fd1055, fd1054;
sub.f64 fd850, fd1055, fd1054;
add.f64 fd851, fd841, fd846;
sub.f64 fd853, fd841, fd846;
sub.f64 fd1052, fd842, fd845;
add.f64 fd854, fd842, fd845;
add.f64 fd855, fd783, fd815;
sub.f64 fd857, fd783, fd815;
add.f64 fd1051, fd784, fd816;
sub.f64 fd858, fd784, fd816;
add.f64 fd859, fd799, fd831;
sub.f64 fd861, fd799, fd831;
add.f64 fd1050, fd800, fd832;
sub.f64 fd862, fd800, fd832;
add.f64 fd863, fd855, fd859;
sub.f64 fd865, fd855, fd859;
add.f64 fd1049, fd1051, fd1050;
sub.f64 fd866, fd1051, fd1050;
add.f64 fd867, fd857, fd862;
sub.f64 fd869, fd857, fd862;
sub.f64 fd1048, fd858, fd861;
add.f64 fd870, fd858, fd861;
mul.f64 fd872, fd1048, 0dBFE6A09E667F3BCD;
mul.f64 fd1047, fd867, 0d3FE6A09E667F3BCD;
sub.f64 fd873, fd1047, fd872;
mul.f64 fd874, fd1048, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd875, fd867, 0dBFE6A09E667F3BCD, fd874;
mul.f64 fd876, fd869, 0dBFE6A09E667F3BCD;
mul.f64 fd877, fd870, 0dBFE6A09E667F3BCD;
sub.f64 fd878, fd876, fd877;
add.f64 fd879, fd876, fd877;
add.f64 fd880, fd847, fd863;
sub.f64 fd882, fd847, fd863;
add.f64 fd1046, fd1053, fd1049;
sub.f64 fd883, fd1053, fd1049;
add.f64 fd884, fd851, fd873;
sub.f64 fd886, fd851, fd873;
add.f64 fd1045, fd1052, fd875;
sub.f64 fd887, fd1052, fd875;
add.f64 fd888, fd849, fd866;
sub.f64 fd890, fd849, fd866;
sub.f64 fd1044, fd850, fd865;
add.f64 fd891, fd850, fd865;
add.f64 fd892, fd853, fd878;
sub.f64 fd894, fd853, fd878;
add.f64 fd1043, fd854, fd879;
sub.f64 fd895, fd854, fd879;
add.f64 fd896, fd779, fd811;
sub.f64 fd898, fd779, fd811;
add.f64 fd1042, fd780, fd812;
sub.f64 fd899, fd780, fd812;
add.f64 fd900, fd795, fd827;
sub.f64 fd902, fd795, fd827;
add.f64 fd1041, fd796, fd828;
sub.f64 fd903, fd796, fd828;
add.f64 fd904, fd896, fd900;
sub.f64 fd906, fd896, fd900;
add.f64 fd1040, fd1042, fd1041;
sub.f64 fd907, fd1042, fd1041;
add.f64 fd908, fd898, fd903;
sub.f64 fd910, fd898, fd903;
sub.f64 fd1039, fd899, fd902;
add.f64 fd911, fd899, fd902;
add.f64 fd912, fd787, fd819;
sub.f64 fd914, fd787, fd819;
add.f64 fd1038, fd788, fd820;
sub.f64 fd915, fd788, fd820;
add.f64 fd916, fd803, fd835;
sub.f64 fd918, fd803, fd835;
add.f64 fd1037, fd804, fd836;
sub.f64 fd919, fd804, fd836;
add.f64 fd920, fd912, fd916;
sub.f64 fd922, fd912, fd916;
add.f64 fd1036, fd1038, fd1037;
sub.f64 fd923, fd1038, fd1037;
add.f64 fd924, fd914, fd919;
sub.f64 fd926, fd914, fd919;
sub.f64 fd1035, fd915, fd918;
add.f64 fd927, fd915, fd918;
mul.f64 fd929, fd1035, 0dBFE6A09E667F3BCD;
mul.f64 fd1034, fd924, 0d3FE6A09E667F3BCD;
sub.f64 fd930, fd1034, fd929;
mul.f64 fd931, fd1035, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd932, fd924, 0dBFE6A09E667F3BCD, fd931;
mul.f64 fd933, fd926, 0dBFE6A09E667F3BCD;
mul.f64 fd934, fd927, 0dBFE6A09E667F3BCD;
sub.f64 fd935, fd933, fd934;
add.f64 fd936, fd933, fd934;
add.f64 fd937, fd904, fd920;
sub.f64 fd939, fd904, fd920;
add.f64 fd1033, fd1040, fd1036;
sub.f64 fd940, fd1040, fd1036;
add.f64 fd941, fd908, fd930;
sub.f64 fd943, fd908, fd930;
add.f64 fd1032, fd1039, fd932;
sub.f64 fd944, fd1039, fd932;
add.f64 fd945, fd906, fd923;
sub.f64 fd947, fd906, fd923;
sub.f64 fd1031, fd907, fd922;
add.f64 fd948, fd907, fd922;
add.f64 fd949, fd910, fd935;
sub.f64 fd951, fd910, fd935;
add.f64 fd1030, fd911, fd936;
sub.f64 fd952, fd911, fd936;
mul.f64 fd954, fd1032, 0dBFD87DE2A6AEA963;
mul.f64 fd1029, fd941, 0d3FED906BCF328D46;
sub.f64 fd955, fd1029, fd954;
mul.f64 fd956, fd1032, 0d3FED906BCF328D46;
fma.rn.f64 fd957, fd941, 0dBFD87DE2A6AEA963, fd956;
mul.f64 fd959, fd1031, 0dBFE6A09E667F3BCD;
mul.f64 fd1028, fd945, 0d3FE6A09E667F3BCD;
sub.f64 fd960, fd1028, fd959;
mul.f64 fd961, fd1031, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd962, fd945, 0dBFE6A09E667F3BCD, fd961;
mul.f64 fd964, fd1030, 0dBFED906BCF328D46;
mul.f64 fd1027, fd949, 0d3FD87DE2A6AEA963;
sub.f64 fd965, fd1027, fd964;
mul.f64 fd966, fd1030, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd967, fd949, 0dBFED906BCF328D46, fd966;
mul.f64 fd969, fd944, 0dBFED906BCF328D46;
mul.f64 fd1026, fd943, 0dBFD87DE2A6AEA963;
sub.f64 fd970, fd1026, fd969;
mul.f64 fd971, fd944, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd972, fd943, 0dBFED906BCF328D46, fd971;
mul.f64 fd973, fd947, 0dBFE6A09E667F3BCD;
mul.f64 fd974, fd948, 0dBFE6A09E667F3BCD;
sub.f64 fd975, fd973, fd974;
add.f64 fd976, fd973, fd974;
mul.f64 fd978, fd952, 0dBFD87DE2A6AEA963;
mul.f64 fd1025, fd951, 0dBFED906BCF328D46;
sub.f64 fd979, fd1025, fd978;
mul.f64 fd980, fd952, 0dBFED906BCF328D46;
fma.rn.f64 fd981, fd951, 0dBFD87DE2A6AEA963, fd980;
add.f64 %0, fd880, fd937;
add.f64 %1, fd1046, fd1033;
add.f64 %2, fd884, fd955;
add.f64 %3, fd1045, fd957;
add.f64 %5, fd1044, fd962;
add.f64 %4, fd888, fd960;
add.f64 %7, fd1043, fd967;
add.f64 %6, fd892, fd965;
sub.f64 %9, fd883, fd939;
add.f64 %8, fd882, fd940;
add.f64 %10, fd886, fd970;
add.f64 %11, fd887, fd972;
add.f64 %12, fd890, fd975;
add.f64 %13, fd891, fd976;
add.f64 %14, fd894, fd979;
add.f64 %15, fd895, fd981;
sub.f64 %17, fd1046, fd1033;
sub.f64 %16, fd880, fd937;
sub.f64 %19, fd1045, fd957;
sub.f64 %18, fd884, fd955;
sub.f64 %21, fd1044, fd962;
sub.f64 %20, fd888, fd960;
sub.f64 %23, fd1043, fd967;
sub.f64 %22, fd892, fd965;
add.f64 %25, fd883, fd939;
sub.f64 %24, fd882, fd940;
sub.f64 %27, fd887, fd972;
sub.f64 %26, fd886, fd970;
sub.f64 %29, fd891, fd976;
sub.f64 %28, fd890, fd975;
sub.f64 %31, fd895, fd981;
sub.f64 %30, fd894, fd979;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_4096), "l"(lut_dp_16_256), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[8].y), "d"(rmem[4].y), "d"(rmem[10].y), "d"(rmem[2].y), "d"(rmem[14].y), "d"(rmem[1].y), "d"(rmem[5].y), "d"(rmem[13].y), "d"(rmem[11].y), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<495, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<28>;
.reg .f64 fd<561>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 16;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd33, %20, %30;
add.f64 fd34, %21, %32;
sub.f64 fd35, %20, %30;
sub.f64 fd36, %21, %32;
add.f64 fd37, %25, %36;
add.f64 fd38, %27, %37;
sub.f64 fd39, %25, %36;
sub.f64 fd40, %27, %37;
add.f64 fd41, fd33, fd37;
add.f64 fd42, fd34, fd38;
sub.f64 fd43, fd33, fd37;
sub.f64 fd44, fd34, fd38;
add.f64 fd45, fd35, fd40;
sub.f64 fd46, fd36, fd39;
sub.f64 fd47, fd35, fd40;
add.f64 fd48, fd36, fd39;
add.f64 fd49, %22, %33;
add.f64 fd50, %24, %35;
sub.f64 fd51, %22, %33;
sub.f64 fd52, %24, %35;
add.f64 fd53, %28, %38;
add.f64 fd54, %29, %39;
sub.f64 fd55, %28, %38;
sub.f64 fd56, %29, %39;
add.f64 fd57, fd49, fd53;
add.f64 fd58, fd50, fd54;
sub.f64 fd59, fd49, fd53;
sub.f64 fd60, fd50, fd54;
add.f64 fd61, fd51, fd56;
sub.f64 fd62, fd52, fd55;
sub.f64 fd63, fd51, fd56;
add.f64 fd64, fd52, fd55;
mul.f64 fd65, fd61, 0d3FE6A09E667F3BCD;
mul.f64 fd66, fd62, 0dBFE6A09E667F3BCD;
sub.f64 fd67, fd65, fd66;
mul.f64 fd68, fd62, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd69, fd61, 0dBFE6A09E667F3BCD, fd68;
mul.f64 fd70, fd63, 0dBFE6A09E667F3BCD;
mul.f64 fd71, fd64, 0dBFE6A09E667F3BCD;
sub.f64 fd72, fd70, fd71;
add.f64 fd73, fd70, fd71;
sub.f64 fd74, fd41, fd57;
sub.f64 fd75, fd42, fd58;
add.f64 fd76, fd45, fd67;
add.f64 fd77, fd46, fd69;
sub.f64 fd78, fd45, fd67;
sub.f64 fd79, fd46, fd69;
add.f64 fd80, fd43, fd60;
sub.f64 fd81, fd44, fd59;
sub.f64 fd82, fd43, fd60;
add.f64 fd83, fd44, fd59;
add.f64 fd84, fd47, fd72;
add.f64 fd85, fd48, fd73;
sub.f64 fd86, fd47, fd72;
sub.f64 fd87, fd48, fd73;
and.b32 r6, r5, 511;
shl.b32 r7, r5, 7;
and.b32 r8, r7, -65536;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 8176;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd88, fd89}, [rd5];
mul.f64 fd92, fd88, fd76;
mul.f64 fd93, fd89, fd77;
mul.f64 fd94, fd88, fd77;
mul.f64 fd95, fd88, fd88;
mul.f64 fd96, fd89, fd89;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd89, fd88;
fma.rn.f64 fd99, fd89, fd88, fd98;
mul.f64 fd100, fd97, fd80;
mul.f64 fd101, fd99, fd81;
mul.f64 fd102, fd97, fd81;
mul.f64 fd103, fd88, fd97;
mul.f64 fd104, fd89, fd99;
sub.f64 fd105, fd103, fd104;
mul.f64 fd106, fd88, fd99;
fma.rn.f64 fd107, fd89, fd97, fd106;
mul.f64 fd108, fd105, fd84;
mul.f64 fd109, fd107, fd85;
mul.f64 fd110, fd105, fd85;
mul.f64 fd111, fd88, fd105;
mul.f64 fd112, fd89, fd107;
sub.f64 fd113, fd111, fd112;
mul.f64 fd114, fd88, fd107;
fma.rn.f64 fd115, fd89, fd105, fd114;
mul.f64 fd116, fd113, fd74;
mul.f64 fd117, fd115, fd75;
mul.f64 fd118, fd113, fd75;
ld.global.v2.f64 {fd119, fd120}, [rd5+8192];
mul.f64 fd123, fd119, fd78;
mul.f64 fd124, fd120, fd79;
mul.f64 fd125, fd119, fd79;
mul.f64 fd126, fd88, fd119;
mul.f64 fd127, fd89, fd120;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd88, fd120;
fma.rn.f64 fd130, fd89, fd119, fd129;
mul.f64 fd131, fd128, fd82;
mul.f64 fd132, fd130, fd83;
mul.f64 fd133, fd128, fd83;
mul.f64 fd134, fd88, fd128;
mul.f64 fd135, fd89, fd130;
sub.f64 fd136, fd134, fd135;
mul.f64 fd137, fd88, fd130;
fma.rn.f64 fd138, fd89, fd128, fd137;
mul.f64 fd139, fd136, fd86;
mul.f64 fd140, fd138, fd87;
mul.f64 fd141, fd136, fd87;
barrier.sync 0;
and.b32 r11, r7, 65408;
add.s32 r12, r9, r11;
add.f64 fd142, fd42, fd58;
add.f64 fd143, fd41, fd57;
st.shared.v2.f64 [r12], {fd143, fd142};
fma.rn.f64 fd144, fd89, fd76, fd94;
sub.f64 fd145, fd92, fd93;
st.shared.v2.f64 [r12+16], {fd145, fd144};
fma.rn.f64 fd146, fd99, fd80, fd102;
sub.f64 fd147, fd100, fd101;
st.shared.v2.f64 [r12+32], {fd147, fd146};
sub.f64 fd148, fd108, fd109;
fma.rn.f64 fd149, fd107, fd84, fd110;
st.shared.v2.f64 [r12+48], {fd148, fd149};
fma.rn.f64 fd150, fd115, fd74, fd118;
sub.f64 fd151, fd116, fd117;
st.shared.v2.f64 [r12+64], {fd151, fd150};
fma.rn.f64 fd152, fd120, fd78, fd125;
sub.f64 fd153, fd123, fd124;
st.shared.v2.f64 [r12+80], {fd153, fd152};
fma.rn.f64 fd154, fd130, fd82, fd133;
sub.f64 fd155, fd131, fd132;
st.shared.v2.f64 [r12+96], {fd155, fd154};
sub.f64 fd156, fd139, fd140;
fma.rn.f64 fd157, fd138, fd86, fd141;
st.shared.v2.f64 [r12+112], {fd156, fd157};
barrier.sync 0;
mad.lo.s32 r13, r6, -112, r12;
ld.shared.v2.f64 {fd158, fd159}, [r13];
ld.shared.v2.f64 {fd162, fd163}, [r13+8192];
ld.shared.v2.f64 {fd166, fd167}, [r13+16384];
ld.shared.v2.f64 {fd170, fd171}, [r13+24576];
ld.shared.v2.f64 {fd174, fd175}, [r13+32768];
ld.shared.v2.f64 {fd178, fd179}, [r13+40960];
ld.shared.v2.f64 {fd182, fd183}, [r13+49152];
ld.shared.v2.f64 {fd186, fd187}, [r13+57344];
add.f64 fd190, fd158, fd174;
add.f64 fd191, fd159, fd175;
sub.f64 fd192, fd158, fd174;
sub.f64 fd193, fd159, fd175;
add.f64 fd194, fd166, fd182;
add.f64 fd195, fd167, fd183;
sub.f64 fd196, fd166, fd182;
sub.f64 fd197, fd167, fd183;
add.f64 fd198, fd190, fd194;
add.f64 fd199, fd191, fd195;
sub.f64 fd200, fd190, fd194;
sub.f64 fd201, fd191, fd195;
add.f64 fd202, fd192, fd197;
sub.f64 fd203, fd193, fd196;
sub.f64 fd204, fd192, fd197;
add.f64 fd205, fd193, fd196;
add.f64 fd206, fd162, fd178;
add.f64 fd207, fd163, fd179;
sub.f64 fd208, fd162, fd178;
sub.f64 fd209, fd163, fd179;
add.f64 fd210, fd170, fd186;
add.f64 fd211, fd171, fd187;
sub.f64 fd212, fd170, fd186;
sub.f64 fd213, fd171, fd187;
add.f64 fd214, fd206, fd210;
add.f64 fd215, fd207, fd211;
sub.f64 fd216, fd206, fd210;
sub.f64 fd217, fd207, fd211;
add.f64 fd218, fd208, fd213;
sub.f64 fd219, fd209, fd212;
sub.f64 fd220, fd208, fd213;
add.f64 fd221, fd209, fd212;
mul.f64 fd222, fd218, 0d3FE6A09E667F3BCD;
mul.f64 fd223, fd219, 0dBFE6A09E667F3BCD;
sub.f64 fd224, fd222, fd223;
mul.f64 fd225, fd219, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd226, fd218, 0dBFE6A09E667F3BCD, fd225;
mul.f64 fd227, fd220, 0dBFE6A09E667F3BCD;
mul.f64 fd228, fd221, 0dBFE6A09E667F3BCD;
sub.f64 fd229, fd227, fd228;
add.f64 fd230, fd227, fd228;
sub.f64 fd231, fd198, fd214;
sub.f64 fd232, fd199, fd215;
add.f64 fd233, fd202, fd224;
add.f64 fd234, fd203, fd226;
sub.f64 fd235, fd202, fd224;
sub.f64 fd236, fd203, fd226;
add.f64 fd237, fd200, fd217;
sub.f64 fd238, fd201, fd216;
sub.f64 fd239, fd200, fd217;
add.f64 fd240, fd201, fd216;
add.f64 fd241, fd204, fd229;
add.f64 fd242, fd205, fd230;
sub.f64 fd243, fd204, fd229;
sub.f64 fd244, fd205, fd230;
and.b32 r14, r5, 504;
bfe.u32 r15, r5, 3, 6;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd245, fd246}, [rd8];
mul.f64 fd249, fd245, fd233;
mul.f64 fd250, fd246, fd234;
mul.f64 fd251, fd245, fd234;
mul.f64 fd252, fd245, fd245;
mul.f64 fd253, fd246, fd246;
sub.f64 fd254, fd252, fd253;
mul.f64 fd255, fd246, fd245;
fma.rn.f64 fd256, fd246, fd245, fd255;
mul.f64 fd257, fd254, fd237;
mul.f64 fd258, fd256, fd238;
mul.f64 fd259, fd254, fd238;
mul.f64 fd260, fd245, fd254;
mul.f64 fd261, fd246, fd256;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd245, fd256;
fma.rn.f64 fd264, fd246, fd254, fd263;
mul.f64 fd265, fd262, fd241;
mul.f64 fd266, fd264, fd242;
mul.f64 fd267, fd262, fd242;
mul.f64 fd268, fd245, fd262;
mul.f64 fd269, fd246, fd264;
sub.f64 fd270, fd268, fd269;
mul.f64 fd271, fd245, fd264;
fma.rn.f64 fd272, fd246, fd262, fd271;
mul.f64 fd273, fd270, fd231;
mul.f64 fd274, fd272, fd232;
mul.f64 fd275, fd270, fd232;
ld.global.v2.f64 {fd276, fd277}, [rd8+1024];
mul.f64 fd280, fd276, fd235;
mul.f64 fd281, fd277, fd236;
mul.f64 fd282, fd276, fd236;
mul.f64 fd283, fd245, fd276;
mul.f64 fd284, fd246, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd245, fd277;
fma.rn.f64 fd287, fd246, fd276, fd286;
mul.f64 fd288, fd285, fd239;
mul.f64 fd289, fd287, fd240;
mul.f64 fd290, fd285, fd240;
mul.f64 fd291, fd245, fd285;
mul.f64 fd292, fd246, fd287;
sub.f64 fd293, fd291, fd292;
mul.f64 fd294, fd245, fd287;
fma.rn.f64 fd295, fd246, fd285, fd294;
mul.f64 fd296, fd293, fd243;
mul.f64 fd297, fd295, fd244;
mul.f64 fd298, fd293, fd244;
and.b32 r16, r10, 112;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 64512;
add.s32 r19, r17, r18;
add.f64 fd299, fd199, fd215;
add.f64 fd300, fd198, fd214;
st.shared.v2.f64 [r19], {fd300, fd299};
fma.rn.f64 fd301, fd246, fd233, fd251;
sub.f64 fd302, fd249, fd250;
st.shared.v2.f64 [r19+128], {fd302, fd301};
fma.rn.f64 fd303, fd256, fd237, fd259;
sub.f64 fd304, fd257, fd258;
st.shared.v2.f64 [r19+256], {fd304, fd303};
fma.rn.f64 fd305, fd264, fd241, fd267;
sub.f64 fd306, fd265, fd266;
st.shared.v2.f64 [r19+384], {fd306, fd305};
sub.f64 fd307, fd273, fd274;
fma.rn.f64 fd308, fd272, fd231, fd275;
st.shared.v2.f64 [r19+512], {fd307, fd308};
fma.rn.f64 fd309, fd277, fd235, fd282;
sub.f64 fd310, fd280, fd281;
st.shared.v2.f64 [r19+640], {fd310, fd309};
fma.rn.f64 fd311, fd287, fd239, fd290;
sub.f64 fd312, fd288, fd289;
st.shared.v2.f64 [r19+768], {fd312, fd311};
fma.rn.f64 fd313, fd295, fd243, fd298;
sub.f64 fd314, fd296, fd297;
st.shared.v2.f64 [r19+896], {fd314, fd313};
barrier.sync 0;
mad.lo.s32 r20, r14, -112, r19;
ld.shared.v2.f64 {fd315, fd316}, [r20];
ld.shared.v2.f64 {fd319, fd320}, [r20+8192];
ld.shared.v2.f64 {fd323, fd324}, [r20+16384];
ld.shared.v2.f64 {fd327, fd328}, [r20+24576];
ld.shared.v2.f64 {fd331, fd332}, [r20+32768];
ld.shared.v2.f64 {fd335, fd336}, [r20+40960];
ld.shared.v2.f64 {fd339, fd340}, [r20+49152];
ld.shared.v2.f64 {fd343, fd344}, [r20+57344];
add.f64 fd347, fd315, fd331;
add.f64 fd348, fd316, fd332;
sub.f64 fd349, fd315, fd331;
sub.f64 fd350, fd316, fd332;
add.f64 fd351, fd323, fd339;
add.f64 fd352, fd324, fd340;
sub.f64 fd353, fd323, fd339;
sub.f64 fd354, fd324, fd340;
add.f64 fd355, fd347, fd351;
add.f64 fd356, fd348, fd352;
sub.f64 fd357, fd347, fd351;
sub.f64 fd358, fd348, fd352;
add.f64 fd359, fd349, fd354;
sub.f64 fd360, fd350, fd353;
sub.f64 fd361, fd349, fd354;
add.f64 fd362, fd350, fd353;
add.f64 fd363, fd319, fd335;
add.f64 fd364, fd320, fd336;
sub.f64 fd365, fd319, fd335;
sub.f64 fd366, fd320, fd336;
add.f64 fd367, fd327, fd343;
add.f64 fd368, fd328, fd344;
sub.f64 fd369, fd327, fd343;
sub.f64 fd370, fd328, fd344;
add.f64 fd371, fd363, fd367;
add.f64 fd372, fd364, fd368;
sub.f64 fd373, fd363, fd367;
sub.f64 fd374, fd364, fd368;
add.f64 fd375, fd365, fd370;
sub.f64 fd376, fd366, fd369;
sub.f64 fd377, fd365, fd370;
add.f64 fd378, fd366, fd369;
mul.f64 fd379, fd375, 0d3FE6A09E667F3BCD;
mul.f64 fd380, fd376, 0dBFE6A09E667F3BCD;
sub.f64 fd381, fd379, fd380;
mul.f64 fd382, fd376, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd383, fd375, 0dBFE6A09E667F3BCD, fd382;
mul.f64 fd384, fd377, 0dBFE6A09E667F3BCD;
mul.f64 fd385, fd378, 0dBFE6A09E667F3BCD;
sub.f64 fd386, fd384, fd385;
add.f64 fd387, fd384, fd385;
sub.f64 fd388, fd355, fd371;
sub.f64 fd389, fd356, fd372;
add.f64 fd390, fd359, fd381;
add.f64 fd391, fd360, fd383;
sub.f64 fd392, fd359, fd381;
sub.f64 fd393, fd360, fd383;
add.f64 fd394, fd357, fd374;
sub.f64 fd395, fd358, fd373;
sub.f64 fd396, fd357, fd374;
add.f64 fd397, fd358, fd373;
add.f64 fd398, fd361, fd386;
add.f64 fd399, fd362, fd387;
sub.f64 fd400, fd361, fd386;
sub.f64 fd401, fd362, fd387;
and.b32 r21, r5, 448;
bfe.u32 r22, r5, 6, 3;
mul.wide.u32 rd9, r22, 16;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd402, fd403}, [rd11];
mul.f64 fd406, fd402, fd390;
mul.f64 fd407, fd403, fd391;
mul.f64 fd408, fd402, fd391;
mul.f64 fd409, fd402, fd402;
mul.f64 fd410, fd403, fd403;
sub.f64 fd411, fd409, fd410;
mul.f64 fd412, fd403, fd402;
fma.rn.f64 fd413, fd403, fd402, fd412;
mul.f64 fd414, fd411, fd394;
mul.f64 fd415, fd413, fd395;
mul.f64 fd416, fd411, fd395;
mul.f64 fd417, fd402, fd411;
mul.f64 fd418, fd403, fd413;
sub.f64 fd419, fd417, fd418;
mul.f64 fd420, fd402, fd413;
fma.rn.f64 fd421, fd403, fd411, fd420;
mul.f64 fd422, fd419, fd398;
mul.f64 fd423, fd421, fd399;
mul.f64 fd424, fd419, fd399;
mul.f64 fd425, fd402, fd419;
mul.f64 fd426, fd403, fd421;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd402, fd421;
fma.rn.f64 fd429, fd403, fd419, fd428;
mul.f64 fd430, fd427, fd388;
mul.f64 fd431, fd429, fd389;
mul.f64 fd432, fd427, fd389;
ld.global.v2.f64 {fd433, fd434}, [rd11+128];
mul.f64 fd437, fd433, fd392;
mul.f64 fd438, fd434, fd393;
mul.f64 fd439, fd433, fd393;
mul.f64 fd440, fd402, fd433;
mul.f64 fd441, fd403, fd434;
sub.f64 fd442, fd440, fd441;
mul.f64 fd443, fd402, fd434;
fma.rn.f64 fd444, fd403, fd433, fd443;
mul.f64 fd445, fd442, fd396;
mul.f64 fd446, fd444, fd397;
mul.f64 fd447, fd442, fd397;
mul.f64 fd448, fd402, fd442;
mul.f64 fd449, fd403, fd444;
sub.f64 fd450, fd448, fd449;
mul.f64 fd451, fd402, fd444;
fma.rn.f64 fd452, fd403, fd442, fd451;
mul.f64 fd453, fd450, fd400;
mul.f64 fd454, fd452, fd401;
mul.f64 fd455, fd450, fd401;
and.b32 r23, r10, 1008;
add.s32 r24, r9, r23;
barrier.sync 0;
and.b32 r25, r7, 57344;
add.s32 r26, r24, r25;
add.f64 fd456, fd356, fd372;
add.f64 fd457, fd355, fd371;
st.shared.v2.f64 [r26], {fd457, fd456};
fma.rn.f64 fd458, fd403, fd390, fd408;
sub.f64 fd459, fd406, fd407;
st.shared.v2.f64 [r26+1024], {fd459, fd458};
fma.rn.f64 fd460, fd413, fd394, fd416;
sub.f64 fd461, fd414, fd415;
st.shared.v2.f64 [r26+2048], {fd461, fd460};
fma.rn.f64 fd462, fd421, fd398, fd424;
sub.f64 fd463, fd422, fd423;
st.shared.v2.f64 [r26+3072], {fd463, fd462};
sub.f64 fd464, fd430, fd431;
fma.rn.f64 fd465, fd429, fd388, fd432;
st.shared.v2.f64 [r26+4096], {fd464, fd465};
fma.rn.f64 fd466, fd434, fd392, fd439;
sub.f64 fd467, fd437, fd438;
st.shared.v2.f64 [r26+5120], {fd467, fd466};
fma.rn.f64 fd468, fd444, fd396, fd447;
sub.f64 fd469, fd445, fd446;
st.shared.v2.f64 [r26+6144], {fd469, fd468};
fma.rn.f64 fd470, fd452, fd400, fd455;
sub.f64 fd471, fd453, fd454;
st.shared.v2.f64 [r26+7168], {fd471, fd470};
barrier.sync 0;
mad.lo.s32 r27, r21, -112, r26;
ld.shared.v2.f64 {fd472, fd473}, [r27];
ld.shared.v2.f64 {fd476, fd477}, [r27+8192];
ld.shared.v2.f64 {fd480, fd481}, [r27+16384];
ld.shared.v2.f64 {fd484, fd485}, [r27+24576];
ld.shared.v2.f64 {fd488, fd489}, [r27+32768];
ld.shared.v2.f64 {fd492, fd493}, [r27+40960];
ld.shared.v2.f64 {fd496, fd497}, [r27+49152];
ld.shared.v2.f64 {fd500, fd501}, [r27+57344];
add.f64 fd504, fd472, fd488;
add.f64 fd505, fd473, fd489;
sub.f64 fd506, fd472, fd488;
sub.f64 fd507, fd473, fd489;
add.f64 fd508, fd480, fd496;
add.f64 fd509, fd481, fd497;
sub.f64 fd510, fd480, fd496;
sub.f64 fd511, fd481, fd497;
add.f64 fd512, fd504, fd508;
add.f64 fd513, fd505, fd509;
sub.f64 fd514, fd504, fd508;
sub.f64 fd515, fd505, fd509;
add.f64 fd516, fd506, fd511;
sub.f64 fd517, fd507, fd510;
sub.f64 fd518, fd506, fd511;
add.f64 fd519, fd507, fd510;
add.f64 fd520, fd476, fd492;
add.f64 fd521, fd477, fd493;
sub.f64 fd522, fd476, fd492;
sub.f64 fd523, fd477, fd493;
add.f64 fd524, fd484, fd500;
add.f64 fd525, fd485, fd501;
sub.f64 fd526, fd484, fd500;
sub.f64 fd527, fd485, fd501;
add.f64 fd528, fd520, fd524;
add.f64 fd529, fd521, fd525;
sub.f64 fd530, fd520, fd524;
sub.f64 fd531, fd521, fd525;
add.f64 fd532, fd522, fd527;
sub.f64 fd533, fd523, fd526;
sub.f64 fd534, fd522, fd527;
add.f64 fd535, fd523, fd526;
mul.f64 fd536, fd532, 0d3FE6A09E667F3BCD;
mul.f64 fd537, fd533, 0dBFE6A09E667F3BCD;
sub.f64 fd538, fd536, fd537;
mul.f64 fd539, fd533, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd540, fd532, 0dBFE6A09E667F3BCD, fd539;
mul.f64 fd541, fd534, 0dBFE6A09E667F3BCD;
mul.f64 fd542, fd535, 0dBFE6A09E667F3BCD;
sub.f64 fd543, fd541, fd542;
add.f64 fd544, fd541, fd542;
add.f64 %1, fd513, fd529;
add.f64 %0, fd512, fd528;
add.f64 %3, fd517, fd540;
add.f64 %2, fd516, fd538;
sub.f64 %5, fd515, fd530;
add.f64 %4, fd514, fd531;
add.f64 %7, fd519, fd544;
add.f64 %6, fd518, fd543;
sub.f64 %9, fd513, fd529;
sub.f64 %8, fd512, fd528;
sub.f64 %11, fd517, fd540;
sub.f64 %10, fd516, fd538;
add.f64 %13, fd515, fd530;
sub.f64 %12, fd514, fd531;
sub.f64 %15, fd519, fd544;
sub.f64 %14, fd518, fd543;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y): "r"(smem), "l"(lut_dp_8_4096), "l"(lut_dp_8_512), "l"(lut_dp_8_64), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<493, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<950>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 15;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd65, %35, %56;
add.f64 fd66, %36, %58;
sub.f64 fd67, %35, %56;
sub.f64 fd68, %36, %58;
add.f64 fd69, %45, %67;
add.f64 fd70, %47, %68;
sub.f64 fd71, %45, %67;
sub.f64 fd72, %47, %68;
add.f64 fd73, fd65, fd69;
add.f64 fd74, fd66, fd70;
sub.f64 fd75, fd65, fd69;
sub.f64 fd76, fd66, fd70;
add.f64 fd77, fd67, fd72;
sub.f64 fd78, fd68, fd71;
sub.f64 fd79, fd67, fd72;
add.f64 fd80, fd68, fd71;
add.f64 fd81, %40, %61;
add.f64 fd82, %42, %63;
sub.f64 fd83, %40, %61;
sub.f64 fd84, %42, %63;
add.f64 fd85, %51, %72;
add.f64 fd86, %52, %74;
sub.f64 fd87, %51, %72;
sub.f64 fd88, %52, %74;
add.f64 fd89, fd81, fd85;
add.f64 fd90, fd82, fd86;
sub.f64 fd91, fd81, fd85;
sub.f64 fd92, fd82, fd86;
add.f64 fd93, fd83, fd88;
sub.f64 fd94, fd84, fd87;
sub.f64 fd95, fd83, fd88;
add.f64 fd96, fd84, fd87;
mul.f64 fd97, fd93, 0d3FE6A09E667F3BCD;
mul.f64 fd98, fd94, 0dBFE6A09E667F3BCD;
sub.f64 fd99, fd97, fd98;
mul.f64 fd100, fd94, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd101, fd93, 0dBFE6A09E667F3BCD, fd100;
mul.f64 fd102, fd95, 0dBFE6A09E667F3BCD;
mul.f64 fd103, fd96, 0dBFE6A09E667F3BCD;
sub.f64 fd104, fd102, fd103;
add.f64 fd105, fd102, fd103;
add.f64 fd106, fd73, fd89;
add.f64 fd107, fd74, fd90;
sub.f64 fd108, fd73, fd89;
sub.f64 fd109, fd74, fd90;
add.f64 fd110, fd77, fd99;
add.f64 fd111, fd78, fd101;
sub.f64 fd112, fd77, fd99;
sub.f64 fd113, fd78, fd101;
add.f64 fd114, fd75, fd92;
sub.f64 fd115, fd76, fd91;
sub.f64 fd116, fd75, fd92;
add.f64 fd117, fd76, fd91;
add.f64 fd118, fd79, fd104;
add.f64 fd119, fd80, fd105;
sub.f64 fd120, fd79, fd104;
sub.f64 fd121, fd80, fd105;
add.f64 fd122, %37, %59;
add.f64 fd123, %39, %60;
sub.f64 fd124, %37, %59;
sub.f64 fd125, %39, %60;
add.f64 fd126, %48, %69;
add.f64 fd127, %50, %71;
sub.f64 fd128, %48, %69;
sub.f64 fd129, %50, %71;
add.f64 fd130, fd122, fd126;
add.f64 fd131, fd123, fd127;
sub.f64 fd132, fd122, fd126;
sub.f64 fd133, fd123, fd127;
add.f64 fd134, fd124, fd129;
sub.f64 fd135, fd125, fd128;
sub.f64 fd136, fd124, fd129;
add.f64 fd137, fd125, fd128;
add.f64 fd138, %43, %64;
add.f64 fd139, %44, %66;
sub.f64 fd140, %43, %64;
sub.f64 fd141, %44, %66;
add.f64 fd142, %53, %75;
add.f64 fd143, %55, %76;
sub.f64 fd144, %53, %75;
sub.f64 fd145, %55, %76;
add.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd143;
sub.f64 fd148, fd138, fd142;
sub.f64 fd149, fd139, fd143;
add.f64 fd150, fd140, fd145;
sub.f64 fd151, fd141, fd144;
sub.f64 fd152, fd140, fd145;
add.f64 fd153, fd141, fd144;
mul.f64 fd154, fd150, 0d3FE6A09E667F3BCD;
mul.f64 fd155, fd151, 0dBFE6A09E667F3BCD;
sub.f64 fd156, fd154, fd155;
mul.f64 fd157, fd151, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd158, fd150, 0dBFE6A09E667F3BCD, fd157;
mul.f64 fd159, fd152, 0dBFE6A09E667F3BCD;
mul.f64 fd160, fd153, 0dBFE6A09E667F3BCD;
sub.f64 fd161, fd159, fd160;
add.f64 fd162, fd159, fd160;
add.f64 fd163, fd130, fd146;
add.f64 fd164, fd131, fd147;
sub.f64 fd165, fd130, fd146;
sub.f64 fd166, fd131, fd147;
add.f64 fd167, fd134, fd156;
add.f64 fd168, fd135, fd158;
sub.f64 fd169, fd134, fd156;
sub.f64 fd170, fd135, fd158;
add.f64 fd171, fd132, fd149;
sub.f64 fd172, fd133, fd148;
sub.f64 fd173, fd132, fd149;
add.f64 fd174, fd133, fd148;
add.f64 fd175, fd136, fd161;
add.f64 fd176, fd137, fd162;
sub.f64 fd177, fd136, fd161;
sub.f64 fd178, fd137, fd162;
mul.f64 fd179, fd167, 0d3FED906BCF328D46;
mul.f64 fd180, fd168, 0dBFD87DE2A6AEA963;
sub.f64 fd181, fd179, fd180;
mul.f64 fd182, fd168, 0d3FED906BCF328D46;
fma.rn.f64 fd183, fd167, 0dBFD87DE2A6AEA963, fd182;
mul.f64 fd184, fd171, 0d3FE6A09E667F3BCD;
mul.f64 fd185, fd172, 0dBFE6A09E667F3BCD;
sub.f64 fd186, fd184, fd185;
mul.f64 fd187, fd172, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd188, fd171, 0dBFE6A09E667F3BCD, fd187;
mul.f64 fd189, fd175, 0d3FD87DE2A6AEA963;
mul.f64 fd190, fd176, 0dBFED906BCF328D46;
sub.f64 fd191, fd189, fd190;
mul.f64 fd192, fd176, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd193, fd175, 0dBFED906BCF328D46, fd192;
mul.f64 fd194, fd169, 0dBFD87DE2A6AEA963;
mul.f64 fd195, fd170, 0dBFED906BCF328D46;
sub.f64 fd196, fd194, fd195;
mul.f64 fd197, fd170, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd198, fd169, 0dBFED906BCF328D46, fd197;
mul.f64 fd199, fd173, 0dBFE6A09E667F3BCD;
mul.f64 fd200, fd174, 0dBFE6A09E667F3BCD;
sub.f64 fd201, fd199, fd200;
add.f64 fd202, fd199, fd200;
mul.f64 fd203, fd177, 0dBFED906BCF328D46;
mul.f64 fd204, fd178, 0dBFD87DE2A6AEA963;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd178, 0dBFED906BCF328D46;
fma.rn.f64 fd207, fd177, 0dBFD87DE2A6AEA963, fd206;
add.f64 fd208, fd106, fd163;
add.f64 fd209, fd107, fd164;
sub.f64 fd210, fd106, fd163;
sub.f64 fd211, fd107, fd164;
add.f64 fd212, fd110, fd181;
add.f64 fd213, fd111, fd183;
sub.f64 fd214, fd110, fd181;
sub.f64 fd215, fd111, fd183;
add.f64 fd216, fd114, fd186;
add.f64 fd217, fd115, fd188;
sub.f64 fd218, fd114, fd186;
sub.f64 fd219, fd115, fd188;
add.f64 fd220, fd118, fd191;
add.f64 fd221, fd119, fd193;
sub.f64 fd222, fd118, fd191;
sub.f64 fd223, fd119, fd193;
add.f64 fd224, fd108, fd166;
sub.f64 fd225, fd109, fd165;
sub.f64 fd226, fd108, fd166;
add.f64 fd227, fd109, fd165;
add.f64 fd228, fd112, fd196;
add.f64 fd229, fd113, fd198;
sub.f64 fd230, fd112, fd196;
sub.f64 fd231, fd113, fd198;
add.f64 fd232, fd116, fd201;
add.f64 fd233, fd117, fd202;
sub.f64 fd234, fd116, fd201;
sub.f64 fd235, fd117, fd202;
add.f64 fd236, fd120, fd205;
add.f64 fd237, fd121, fd207;
sub.f64 fd238, fd120, fd205;
sub.f64 fd239, fd121, fd207;
and.b32 r6, r5, 255;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 4080;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd240, fd241}, [rd5];
mul.f64 fd244, fd240, fd212;
mul.f64 fd245, fd241, fd213;
sub.f64 fd246, fd244, fd245;
mul.f64 fd247, fd240, fd213;
fma.rn.f64 fd248, fd241, fd212, fd247;
mul.f64 fd249, fd240, fd240;
mul.f64 fd250, fd241, fd241;
sub.f64 fd251, fd249, fd250;
mul.f64 fd252, fd241, fd240;
fma.rn.f64 fd253, fd241, fd240, fd252;
mul.f64 fd254, fd251, fd216;
mul.f64 fd255, fd253, fd217;
sub.f64 fd256, fd254, fd255;
mul.f64 fd257, fd251, fd217;
fma.rn.f64 fd258, fd253, fd216, fd257;
mul.f64 fd259, fd240, fd251;
mul.f64 fd260, fd241, fd253;
sub.f64 fd261, fd259, fd260;
mul.f64 fd262, fd240, fd253;
fma.rn.f64 fd263, fd241, fd251, fd262;
mul.f64 fd264, fd261, fd220;
mul.f64 fd265, fd263, fd221;
sub.f64 fd266, fd264, fd265;
mul.f64 fd267, fd261, fd221;
fma.rn.f64 fd268, fd263, fd220, fd267;
mul.f64 fd269, fd240, fd261;
mul.f64 fd270, fd241, fd263;
sub.f64 fd271, fd269, fd270;
mul.f64 fd272, fd240, fd263;
fma.rn.f64 fd273, fd241, fd261, fd272;
mul.f64 fd274, fd271, fd224;
mul.f64 fd275, fd273, fd225;
sub.f64 fd276, fd274, fd275;
mul.f64 fd277, fd271, fd225;
fma.rn.f64 fd278, fd273, fd224, fd277;
mul.f64 fd279, fd240, fd271;
mul.f64 fd280, fd241, fd273;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd240, fd273;
fma.rn.f64 fd283, fd241, fd271, fd282;
mul.f64 fd284, fd281, fd228;
mul.f64 fd285, fd283, fd229;
sub.f64 fd286, fd284, fd285;
mul.f64 fd287, fd281, fd229;
fma.rn.f64 fd288, fd283, fd228, fd287;
mul.f64 fd289, fd240, fd281;
mul.f64 fd290, fd241, fd283;
sub.f64 fd291, fd289, fd290;
mul.f64 fd292, fd240, fd283;
fma.rn.f64 fd293, fd241, fd281, fd292;
mul.f64 fd294, fd291, fd232;
mul.f64 fd295, fd293, fd233;
sub.f64 fd296, fd294, fd295;
mul.f64 fd297, fd291, fd233;
fma.rn.f64 fd298, fd293, fd232, fd297;
mul.f64 fd299, fd240, fd291;
mul.f64 fd300, fd241, fd293;
sub.f64 fd301, fd299, fd300;
mul.f64 fd302, fd240, fd293;
fma.rn.f64 fd303, fd241, fd291, fd302;
mul.f64 fd304, fd301, fd236;
mul.f64 fd305, fd303, fd237;
sub.f64 fd306, fd304, fd305;
mul.f64 fd307, fd301, fd237;
fma.rn.f64 fd308, fd303, fd236, fd307;
mul.f64 fd309, fd240, fd301;
mul.f64 fd310, fd241, fd303;
sub.f64 fd311, fd309, fd310;
mul.f64 fd312, fd240, fd303;
fma.rn.f64 fd313, fd241, fd301, fd312;
mul.f64 fd314, fd311, fd210;
mul.f64 fd315, fd313, fd211;
sub.f64 fd316, fd314, fd315;
mul.f64 fd317, fd311, fd211;
fma.rn.f64 fd318, fd313, fd210, fd317;
ld.global.v2.f64 {fd319, fd320}, [rd5+4096];
mul.f64 fd323, fd319, fd214;
mul.f64 fd324, fd320, fd215;
sub.f64 fd325, fd323, fd324;
mul.f64 fd326, fd319, fd215;
fma.rn.f64 fd327, fd320, fd214, fd326;
mul.f64 fd328, fd240, fd319;
mul.f64 fd329, fd241, fd320;
sub.f64 fd330, fd328, fd329;
mul.f64 fd331, fd240, fd320;
fma.rn.f64 fd332, fd241, fd319, fd331;
mul.f64 fd333, fd330, fd218;
mul.f64 fd334, fd332, fd219;
sub.f64 fd335, fd333, fd334;
mul.f64 fd336, fd330, fd219;
fma.rn.f64 fd337, fd332, fd218, fd336;
mul.f64 fd338, fd240, fd330;
mul.f64 fd339, fd241, fd332;
sub.f64 fd340, fd338, fd339;
mul.f64 fd341, fd240, fd332;
fma.rn.f64 fd342, fd241, fd330, fd341;
mul.f64 fd343, fd340, fd222;
mul.f64 fd344, fd342, fd223;
sub.f64 fd345, fd343, fd344;
mul.f64 fd346, fd340, fd223;
fma.rn.f64 fd347, fd342, fd222, fd346;
mul.f64 fd348, fd240, fd340;
mul.f64 fd349, fd241, fd342;
sub.f64 fd350, fd348, fd349;
mul.f64 fd351, fd240, fd342;
fma.rn.f64 fd352, fd241, fd340, fd351;
mul.f64 fd353, fd350, fd226;
mul.f64 fd354, fd352, fd227;
sub.f64 fd355, fd353, fd354;
mul.f64 fd356, fd350, fd227;
fma.rn.f64 fd357, fd352, fd226, fd356;
mul.f64 fd358, fd240, fd350;
mul.f64 fd359, fd241, fd352;
sub.f64 fd360, fd358, fd359;
mul.f64 fd361, fd240, fd352;
fma.rn.f64 fd362, fd241, fd350, fd361;
mul.f64 fd363, fd360, fd230;
mul.f64 fd364, fd362, fd231;
sub.f64 fd365, fd363, fd364;
mul.f64 fd366, fd360, fd231;
fma.rn.f64 fd367, fd362, fd230, fd366;
mul.f64 fd368, fd240, fd360;
mul.f64 fd369, fd241, fd362;
sub.f64 fd370, fd368, fd369;
mul.f64 fd371, fd240, fd362;
fma.rn.f64 fd372, fd241, fd360, fd371;
mul.f64 fd373, fd370, fd234;
mul.f64 fd374, fd372, fd235;
sub.f64 fd375, fd373, fd374;
mul.f64 fd376, fd370, fd235;
fma.rn.f64 fd377, fd372, fd234, fd376;
mul.f64 fd378, fd240, fd370;
mul.f64 fd379, fd241, fd372;
sub.f64 fd380, fd378, fd379;
mul.f64 fd381, fd240, fd372;
fma.rn.f64 fd382, fd241, fd370, fd381;
mul.f64 fd383, fd380, fd238;
mul.f64 fd384, fd382, fd239;
sub.f64 fd385, fd383, fd384;
mul.f64 fd386, fd380, fd239;
fma.rn.f64 fd387, fd382, fd238, fd386;
shl.b32 r8, r5, 7;
and.b32 r9, r8, -32768;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 32640;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd208, fd246};
st.shared.v2.f64 [r12+16], {fd256, fd266};
st.shared.v2.f64 [r12+32], {fd276, fd286};
st.shared.v2.f64 [r12+48], {fd296, fd306};
st.shared.v2.f64 [r12+64], {fd316, fd325};
st.shared.v2.f64 [r12+80], {fd335, fd345};
st.shared.v2.f64 [r12+96], {fd355, fd365};
st.shared.v2.f64 [r12+112], {fd375, fd385};
barrier.sync 0;
mad.lo.s32 r13, r6, -120, r12;
ld.shared.f64 fd388, [r13];
ld.shared.f64 fd389, [r13+2048];
ld.shared.f64 fd390, [r13+4096];
ld.shared.f64 fd391, [r13+6144];
ld.shared.f64 fd392, [r13+8192];
ld.shared.f64 fd393, [r13+10240];
ld.shared.f64 fd394, [r13+12288];
ld.shared.f64 fd395, [r13+14336];
ld.shared.f64 fd396, [r13+16384];
ld.shared.f64 fd397, [r13+18432];
ld.shared.f64 fd398, [r13+20480];
ld.shared.f64 fd399, [r13+22528];
ld.shared.f64 fd400, [r13+24576];
ld.shared.f64 fd401, [r13+26624];
ld.shared.f64 fd402, [r13+28672];
ld.shared.f64 fd403, [r13+30720];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd209, fd248};
st.shared.v2.f64 [r12+16], {fd258, fd268};
st.shared.v2.f64 [r12+32], {fd278, fd288};
st.shared.v2.f64 [r12+48], {fd298, fd308};
st.shared.v2.f64 [r12+64], {fd318, fd327};
st.shared.v2.f64 [r12+80], {fd337, fd347};
st.shared.v2.f64 [r12+96], {fd357, fd367};
st.shared.v2.f64 [r12+112], {fd377, fd387};
barrier.sync 0;
ld.shared.f64 fd404, [r13];
ld.shared.f64 fd405, [r13+2048];
ld.shared.f64 fd406, [r13+4096];
ld.shared.f64 fd407, [r13+6144];
ld.shared.f64 fd408, [r13+8192];
ld.shared.f64 fd409, [r13+10240];
ld.shared.f64 fd410, [r13+12288];
ld.shared.f64 fd411, [r13+14336];
ld.shared.f64 fd412, [r13+16384];
ld.shared.f64 fd413, [r13+18432];
ld.shared.f64 fd414, [r13+20480];
ld.shared.f64 fd415, [r13+22528];
ld.shared.f64 fd416, [r13+24576];
ld.shared.f64 fd417, [r13+26624];
ld.shared.f64 fd418, [r13+28672];
ld.shared.f64 fd419, [r13+30720];
add.f64 fd420, fd388, fd396;
add.f64 fd421, fd404, fd412;
sub.f64 fd422, fd388, fd396;
sub.f64 fd423, fd404, fd412;
add.f64 fd424, fd392, fd400;
add.f64 fd425, fd408, fd416;
sub.f64 fd426, fd392, fd400;
sub.f64 fd427, fd408, fd416;
add.f64 fd428, fd420, fd424;
add.f64 fd429, fd421, fd425;
sub.f64 fd430, fd420, fd424;
sub.f64 fd431, fd421, fd425;
add.f64 fd432, fd422, fd427;
sub.f64 fd433, fd423, fd426;
sub.f64 fd434, fd422, fd427;
add.f64 fd435, fd423, fd426;
add.f64 fd436, fd390, fd398;
add.f64 fd437, fd406, fd414;
sub.f64 fd438, fd390, fd398;
sub.f64 fd439, fd406, fd414;
add.f64 fd440, fd394, fd402;
add.f64 fd441, fd410, fd418;
sub.f64 fd442, fd394, fd402;
sub.f64 fd443, fd410, fd418;
add.f64 fd444, fd436, fd440;
add.f64 fd445, fd437, fd441;
sub.f64 fd446, fd436, fd440;
sub.f64 fd447, fd437, fd441;
add.f64 fd448, fd438, fd443;
sub.f64 fd449, fd439, fd442;
sub.f64 fd450, fd438, fd443;
add.f64 fd451, fd439, fd442;
mul.f64 fd452, fd448, 0d3FE6A09E667F3BCD;
mul.f64 fd453, fd449, 0dBFE6A09E667F3BCD;
sub.f64 fd454, fd452, fd453;
mul.f64 fd455, fd449, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd456, fd448, 0dBFE6A09E667F3BCD, fd455;
mul.f64 fd457, fd450, 0dBFE6A09E667F3BCD;
mul.f64 fd458, fd451, 0dBFE6A09E667F3BCD;
sub.f64 fd459, fd457, fd458;
add.f64 fd460, fd457, fd458;
add.f64 fd461, fd428, fd444;
add.f64 fd462, fd429, fd445;
sub.f64 fd463, fd428, fd444;
sub.f64 fd464, fd429, fd445;
add.f64 fd465, fd432, fd454;
add.f64 fd466, fd433, fd456;
sub.f64 fd467, fd432, fd454;
sub.f64 fd468, fd433, fd456;
add.f64 fd469, fd430, fd447;
sub.f64 fd470, fd431, fd446;
sub.f64 fd471, fd430, fd447;
add.f64 fd472, fd431, fd446;
add.f64 fd473, fd434, fd459;
add.f64 fd474, fd435, fd460;
sub.f64 fd475, fd434, fd459;
sub.f64 fd476, fd435, fd460;
add.f64 fd477, fd389, fd397;
add.f64 fd478, fd405, fd413;
sub.f64 fd479, fd389, fd397;
sub.f64 fd480, fd405, fd413;
add.f64 fd481, fd393, fd401;
add.f64 fd482, fd409, fd417;
sub.f64 fd483, fd393, fd401;
sub.f64 fd484, fd409, fd417;
add.f64 fd485, fd477, fd481;
add.f64 fd486, fd478, fd482;
sub.f64 fd487, fd477, fd481;
sub.f64 fd488, fd478, fd482;
add.f64 fd489, fd479, fd484;
sub.f64 fd490, fd480, fd483;
sub.f64 fd491, fd479, fd484;
add.f64 fd492, fd480, fd483;
add.f64 fd493, fd391, fd399;
add.f64 fd494, fd407, fd415;
sub.f64 fd495, fd391, fd399;
sub.f64 fd496, fd407, fd415;
add.f64 fd497, fd395, fd403;
add.f64 fd498, fd411, fd419;
sub.f64 fd499, fd395, fd403;
sub.f64 fd500, fd411, fd419;
add.f64 fd501, fd493, fd497;
add.f64 fd502, fd494, fd498;
sub.f64 fd503, fd493, fd497;
sub.f64 fd504, fd494, fd498;
add.f64 fd505, fd495, fd500;
sub.f64 fd506, fd496, fd499;
sub.f64 fd507, fd495, fd500;
add.f64 fd508, fd496, fd499;
mul.f64 fd509, fd505, 0d3FE6A09E667F3BCD;
mul.f64 fd510, fd506, 0dBFE6A09E667F3BCD;
sub.f64 fd511, fd509, fd510;
mul.f64 fd512, fd506, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd513, fd505, 0dBFE6A09E667F3BCD, fd512;
mul.f64 fd514, fd507, 0dBFE6A09E667F3BCD;
mul.f64 fd515, fd508, 0dBFE6A09E667F3BCD;
sub.f64 fd516, fd514, fd515;
add.f64 fd517, fd514, fd515;
add.f64 fd518, fd485, fd501;
add.f64 fd519, fd486, fd502;
sub.f64 fd520, fd485, fd501;
sub.f64 fd521, fd486, fd502;
add.f64 fd522, fd489, fd511;
add.f64 fd523, fd490, fd513;
sub.f64 fd524, fd489, fd511;
sub.f64 fd525, fd490, fd513;
add.f64 fd526, fd487, fd504;
sub.f64 fd527, fd488, fd503;
sub.f64 fd528, fd487, fd504;
add.f64 fd529, fd488, fd503;
add.f64 fd530, fd491, fd516;
add.f64 fd531, fd492, fd517;
sub.f64 fd532, fd491, fd516;
sub.f64 fd533, fd492, fd517;
mul.f64 fd534, fd522, 0d3FED906BCF328D46;
mul.f64 fd535, fd523, 0dBFD87DE2A6AEA963;
sub.f64 fd536, fd534, fd535;
mul.f64 fd537, fd523, 0d3FED906BCF328D46;
fma.rn.f64 fd538, fd522, 0dBFD87DE2A6AEA963, fd537;
mul.f64 fd539, fd526, 0d3FE6A09E667F3BCD;
mul.f64 fd540, fd527, 0dBFE6A09E667F3BCD;
sub.f64 fd541, fd539, fd540;
mul.f64 fd542, fd527, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd543, fd526, 0dBFE6A09E667F3BCD, fd542;
mul.f64 fd544, fd530, 0d3FD87DE2A6AEA963;
mul.f64 fd545, fd531, 0dBFED906BCF328D46;
sub.f64 fd546, fd544, fd545;
mul.f64 fd547, fd531, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd548, fd530, 0dBFED906BCF328D46, fd547;
mul.f64 fd549, fd524, 0dBFD87DE2A6AEA963;
mul.f64 fd550, fd525, 0dBFED906BCF328D46;
sub.f64 fd551, fd549, fd550;
mul.f64 fd552, fd525, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd553, fd524, 0dBFED906BCF328D46, fd552;
mul.f64 fd554, fd528, 0dBFE6A09E667F3BCD;
mul.f64 fd555, fd529, 0dBFE6A09E667F3BCD;
sub.f64 fd556, fd554, fd555;
add.f64 fd557, fd554, fd555;
mul.f64 fd558, fd532, 0dBFED906BCF328D46;
mul.f64 fd559, fd533, 0dBFD87DE2A6AEA963;
sub.f64 fd560, fd558, fd559;
mul.f64 fd561, fd533, 0dBFED906BCF328D46;
fma.rn.f64 fd562, fd532, 0dBFD87DE2A6AEA963, fd561;
add.f64 fd563, fd461, fd518;
add.f64 fd564, fd462, fd519;
sub.f64 fd565, fd461, fd518;
sub.f64 fd566, fd462, fd519;
add.f64 fd567, fd465, fd536;
add.f64 fd568, fd466, fd538;
sub.f64 fd569, fd465, fd536;
sub.f64 fd570, fd466, fd538;
add.f64 fd571, fd469, fd541;
add.f64 fd572, fd470, fd543;
sub.f64 fd573, fd469, fd541;
sub.f64 fd574, fd470, fd543;
add.f64 fd575, fd473, fd546;
add.f64 fd576, fd474, fd548;
sub.f64 fd577, fd473, fd546;
sub.f64 fd578, fd474, fd548;
add.f64 fd579, fd463, fd521;
sub.f64 fd580, fd464, fd520;
sub.f64 fd581, fd463, fd521;
add.f64 fd582, fd464, fd520;
add.f64 fd583, fd467, fd551;
add.f64 fd584, fd468, fd553;
sub.f64 fd585, fd467, fd551;
sub.f64 fd586, fd468, fd553;
add.f64 fd587, fd471, fd556;
add.f64 fd588, fd472, fd557;
sub.f64 fd589, fd471, fd556;
sub.f64 fd590, fd472, fd557;
add.f64 fd591, fd475, fd560;
add.f64 fd592, fd476, fd562;
sub.f64 fd593, fd475, fd560;
sub.f64 fd594, fd476, fd562;
and.b32 r14, r5, 240;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd595, fd596}, [rd8];
mul.f64 fd599, fd595, fd567;
mul.f64 fd600, fd596, fd568;
sub.f64 fd601, fd599, fd600;
mul.f64 fd602, fd595, fd568;
fma.rn.f64 fd603, fd596, fd567, fd602;
mul.f64 fd604, fd595, fd595;
mul.f64 fd605, fd596, fd596;
sub.f64 fd606, fd604, fd605;
mul.f64 fd607, fd596, fd595;
fma.rn.f64 fd608, fd596, fd595, fd607;
mul.f64 fd609, fd606, fd571;
mul.f64 fd610, fd608, fd572;
sub.f64 fd611, fd609, fd610;
mul.f64 fd612, fd606, fd572;
fma.rn.f64 fd613, fd608, fd571, fd612;
mul.f64 fd614, fd595, fd606;
mul.f64 fd615, fd596, fd608;
sub.f64 fd616, fd614, fd615;
mul.f64 fd617, fd595, fd608;
fma.rn.f64 fd618, fd596, fd606, fd617;
mul.f64 fd619, fd616, fd575;
mul.f64 fd620, fd618, fd576;
sub.f64 fd621, fd619, fd620;
mul.f64 fd622, fd616, fd576;
fma.rn.f64 fd623, fd618, fd575, fd622;
mul.f64 fd624, fd595, fd616;
mul.f64 fd625, fd596, fd618;
sub.f64 fd626, fd624, fd625;
mul.f64 fd627, fd595, fd618;
fma.rn.f64 fd628, fd596, fd616, fd627;
mul.f64 fd629, fd626, fd579;
mul.f64 fd630, fd628, fd580;
sub.f64 fd631, fd629, fd630;
mul.f64 fd632, fd626, fd580;
fma.rn.f64 fd633, fd628, fd579, fd632;
mul.f64 fd634, fd595, fd626;
mul.f64 fd635, fd596, fd628;
sub.f64 fd636, fd634, fd635;
mul.f64 fd637, fd595, fd628;
fma.rn.f64 fd638, fd596, fd626, fd637;
mul.f64 fd639, fd636, fd583;
mul.f64 fd640, fd638, fd584;
sub.f64 fd641, fd639, fd640;
mul.f64 fd642, fd636, fd584;
fma.rn.f64 fd643, fd638, fd583, fd642;
mul.f64 fd644, fd595, fd636;
mul.f64 fd645, fd596, fd638;
sub.f64 fd646, fd644, fd645;
mul.f64 fd647, fd595, fd638;
fma.rn.f64 fd648, fd596, fd636, fd647;
mul.f64 fd649, fd646, fd587;
mul.f64 fd650, fd648, fd588;
sub.f64 fd651, fd649, fd650;
mul.f64 fd652, fd646, fd588;
fma.rn.f64 fd653, fd648, fd587, fd652;
mul.f64 fd654, fd595, fd646;
mul.f64 fd655, fd596, fd648;
sub.f64 fd656, fd654, fd655;
mul.f64 fd657, fd595, fd648;
fma.rn.f64 fd658, fd596, fd646, fd657;
mul.f64 fd659, fd656, fd591;
mul.f64 fd660, fd658, fd592;
sub.f64 fd661, fd659, fd660;
mul.f64 fd662, fd656, fd592;
fma.rn.f64 fd663, fd658, fd591, fd662;
mul.f64 fd664, fd595, fd656;
mul.f64 fd665, fd596, fd658;
sub.f64 fd666, fd664, fd665;
mul.f64 fd667, fd595, fd658;
fma.rn.f64 fd668, fd596, fd656, fd667;
mul.f64 fd669, fd666, fd565;
mul.f64 fd670, fd668, fd566;
sub.f64 fd671, fd669, fd670;
mul.f64 fd672, fd666, fd566;
fma.rn.f64 fd673, fd668, fd565, fd672;
ld.global.v2.f64 {fd674, fd675}, [rd8+256];
mul.f64 fd678, fd674, fd569;
mul.f64 fd679, fd675, fd570;
sub.f64 fd680, fd678, fd679;
mul.f64 fd681, fd674, fd570;
fma.rn.f64 fd682, fd675, fd569, fd681;
mul.f64 fd683, fd595, fd674;
mul.f64 fd684, fd596, fd675;
sub.f64 fd685, fd683, fd684;
mul.f64 fd686, fd595, fd675;
fma.rn.f64 fd687, fd596, fd674, fd686;
mul.f64 fd688, fd685, fd573;
mul.f64 fd689, fd687, fd574;
sub.f64 fd690, fd688, fd689;
mul.f64 fd691, fd685, fd574;
fma.rn.f64 fd692, fd687, fd573, fd691;
mul.f64 fd693, fd595, fd685;
mul.f64 fd694, fd596, fd687;
sub.f64 fd695, fd693, fd694;
mul.f64 fd696, fd595, fd687;
fma.rn.f64 fd697, fd596, fd685, fd696;
mul.f64 fd698, fd695, fd577;
mul.f64 fd699, fd697, fd578;
sub.f64 fd700, fd698, fd699;
mul.f64 fd701, fd695, fd578;
fma.rn.f64 fd702, fd697, fd577, fd701;
mul.f64 fd703, fd595, fd695;
mul.f64 fd704, fd596, fd697;
sub.f64 fd705, fd703, fd704;
mul.f64 fd706, fd595, fd697;
fma.rn.f64 fd707, fd596, fd695, fd706;
mul.f64 fd708, fd705, fd581;
mul.f64 fd709, fd707, fd582;
sub.f64 fd710, fd708, fd709;
mul.f64 fd711, fd705, fd582;
fma.rn.f64 fd712, fd707, fd581, fd711;
mul.f64 fd713, fd595, fd705;
mul.f64 fd714, fd596, fd707;
sub.f64 fd715, fd713, fd714;
mul.f64 fd716, fd595, fd707;
fma.rn.f64 fd717, fd596, fd705, fd716;
mul.f64 fd718, fd715, fd585;
mul.f64 fd719, fd717, fd586;
sub.f64 fd720, fd718, fd719;
mul.f64 fd721, fd715, fd586;
fma.rn.f64 fd722, fd717, fd585, fd721;
mul.f64 fd723, fd595, fd715;
mul.f64 fd724, fd596, fd717;
sub.f64 fd725, fd723, fd724;
mul.f64 fd726, fd595, fd717;
fma.rn.f64 fd727, fd596, fd715, fd726;
mul.f64 fd728, fd725, fd589;
mul.f64 fd729, fd727, fd590;
sub.f64 fd730, fd728, fd729;
mul.f64 fd731, fd725, fd590;
fma.rn.f64 fd732, fd727, fd589, fd731;
mul.f64 fd733, fd595, fd725;
mul.f64 fd734, fd596, fd727;
sub.f64 fd735, fd733, fd734;
mul.f64 fd736, fd595, fd727;
fma.rn.f64 fd737, fd596, fd725, fd736;
mul.f64 fd738, fd735, fd593;
mul.f64 fd739, fd737, fd594;
sub.f64 fd740, fd738, fd739;
mul.f64 fd741, fd735, fd594;
fma.rn.f64 fd742, fd737, fd593, fd741;
shl.b32 r15, r5, 3;
and.b32 r16, r15, 120;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 30720;
add.s32 r19, r17, r18;
st.shared.f64 [r19], fd563;
st.shared.f64 [r19+128], fd601;
st.shared.f64 [r19+256], fd611;
st.shared.f64 [r19+384], fd621;
st.shared.f64 [r19+512], fd631;
st.shared.f64 [r19+640], fd641;
st.shared.f64 [r19+768], fd651;
st.shared.f64 [r19+896], fd661;
st.shared.f64 [r19+1024], fd671;
st.shared.f64 [r19+1152], fd680;
st.shared.f64 [r19+1280], fd690;
st.shared.f64 [r19+1408], fd700;
st.shared.f64 [r19+1536], fd710;
st.shared.f64 [r19+1664], fd720;
st.shared.f64 [r19+1792], fd730;
st.shared.f64 [r19+1920], fd740;
barrier.sync 0;
mad.lo.s32 r20, r14, -120, r19;
ld.shared.f64 fd743, [r20];
ld.shared.f64 fd744, [r20+2048];
ld.shared.f64 fd745, [r20+4096];
ld.shared.f64 fd746, [r20+6144];
ld.shared.f64 fd747, [r20+8192];
ld.shared.f64 fd748, [r20+10240];
ld.shared.f64 fd749, [r20+12288];
ld.shared.f64 fd750, [r20+14336];
ld.shared.f64 fd751, [r20+16384];
ld.shared.f64 fd752, [r20+18432];
ld.shared.f64 fd753, [r20+20480];
ld.shared.f64 fd754, [r20+22528];
ld.shared.f64 fd755, [r20+24576];
ld.shared.f64 fd756, [r20+26624];
ld.shared.f64 fd757, [r20+28672];
ld.shared.f64 fd758, [r20+30720];
barrier.sync 0;
st.shared.f64 [r19], fd564;
st.shared.f64 [r19+128], fd603;
st.shared.f64 [r19+256], fd613;
st.shared.f64 [r19+384], fd623;
st.shared.f64 [r19+512], fd633;
st.shared.f64 [r19+640], fd643;
st.shared.f64 [r19+768], fd653;
st.shared.f64 [r19+896], fd663;
st.shared.f64 [r19+1024], fd673;
st.shared.f64 [r19+1152], fd682;
st.shared.f64 [r19+1280], fd692;
st.shared.f64 [r19+1408], fd702;
st.shared.f64 [r19+1536], fd712;
st.shared.f64 [r19+1664], fd722;
st.shared.f64 [r19+1792], fd732;
st.shared.f64 [r19+1920], fd742;
barrier.sync 0;
ld.shared.f64 fd759, [r20];
ld.shared.f64 fd760, [r20+2048];
ld.shared.f64 fd761, [r20+4096];
ld.shared.f64 fd762, [r20+6144];
ld.shared.f64 fd763, [r20+8192];
ld.shared.f64 fd764, [r20+10240];
ld.shared.f64 fd765, [r20+12288];
ld.shared.f64 fd766, [r20+14336];
ld.shared.f64 fd767, [r20+16384];
ld.shared.f64 fd768, [r20+18432];
ld.shared.f64 fd769, [r20+20480];
ld.shared.f64 fd770, [r20+22528];
ld.shared.f64 fd771, [r20+24576];
ld.shared.f64 fd772, [r20+26624];
ld.shared.f64 fd773, [r20+28672];
ld.shared.f64 fd774, [r20+30720];
add.f64 fd775, fd743, fd751;
add.f64 fd776, fd759, fd767;
sub.f64 fd777, fd743, fd751;
sub.f64 fd778, fd759, fd767;
add.f64 fd779, fd747, fd755;
add.f64 fd780, fd763, fd771;
sub.f64 fd781, fd747, fd755;
sub.f64 fd782, fd763, fd771;
add.f64 fd783, fd775, fd779;
add.f64 fd784, fd776, fd780;
sub.f64 fd785, fd775, fd779;
sub.f64 fd786, fd776, fd780;
add.f64 fd787, fd777, fd782;
sub.f64 fd788, fd778, fd781;
sub.f64 fd789, fd777, fd782;
add.f64 fd790, fd778, fd781;
add.f64 fd791, fd745, fd753;
add.f64 fd792, fd761, fd769;
sub.f64 fd793, fd745, fd753;
sub.f64 fd794, fd761, fd769;
add.f64 fd795, fd749, fd757;
add.f64 fd796, fd765, fd773;
sub.f64 fd797, fd749, fd757;
sub.f64 fd798, fd765, fd773;
add.f64 fd799, fd791, fd795;
add.f64 fd800, fd792, fd796;
sub.f64 fd801, fd791, fd795;
sub.f64 fd802, fd792, fd796;
add.f64 fd803, fd793, fd798;
sub.f64 fd804, fd794, fd797;
sub.f64 fd805, fd793, fd798;
add.f64 fd806, fd794, fd797;
mul.f64 fd807, fd803, 0d3FE6A09E667F3BCD;
mul.f64 fd808, fd804, 0dBFE6A09E667F3BCD;
sub.f64 fd809, fd807, fd808;
mul.f64 fd810, fd804, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd811, fd803, 0dBFE6A09E667F3BCD, fd810;
mul.f64 fd812, fd805, 0dBFE6A09E667F3BCD;
mul.f64 fd813, fd806, 0dBFE6A09E667F3BCD;
sub.f64 fd814, fd812, fd813;
add.f64 fd815, fd812, fd813;
add.f64 fd816, fd783, fd799;
add.f64 fd817, fd784, fd800;
sub.f64 fd818, fd783, fd799;
sub.f64 fd819, fd784, fd800;
add.f64 fd820, fd787, fd809;
add.f64 fd821, fd788, fd811;
sub.f64 fd822, fd787, fd809;
sub.f64 fd823, fd788, fd811;
add.f64 fd824, fd785, fd802;
sub.f64 fd825, fd786, fd801;
sub.f64 fd826, fd785, fd802;
add.f64 fd827, fd786, fd801;
add.f64 fd828, fd789, fd814;
add.f64 fd829, fd790, fd815;
sub.f64 fd830, fd789, fd814;
sub.f64 fd831, fd790, fd815;
add.f64 fd832, fd744, fd752;
add.f64 fd833, fd760, fd768;
sub.f64 fd834, fd744, fd752;
sub.f64 fd835, fd760, fd768;
add.f64 fd836, fd748, fd756;
add.f64 fd837, fd764, fd772;
sub.f64 fd838, fd748, fd756;
sub.f64 fd839, fd764, fd772;
add.f64 fd840, fd832, fd836;
add.f64 fd841, fd833, fd837;
sub.f64 fd842, fd832, fd836;
sub.f64 fd843, fd833, fd837;
add.f64 fd844, fd834, fd839;
sub.f64 fd845, fd835, fd838;
sub.f64 fd846, fd834, fd839;
add.f64 fd847, fd835, fd838;
add.f64 fd848, fd746, fd754;
add.f64 fd849, fd762, fd770;
sub.f64 fd850, fd746, fd754;
sub.f64 fd851, fd762, fd770;
add.f64 fd852, fd750, fd758;
add.f64 fd853, fd766, fd774;
sub.f64 fd854, fd750, fd758;
sub.f64 fd855, fd766, fd774;
add.f64 fd856, fd848, fd852;
add.f64 fd857, fd849, fd853;
sub.f64 fd858, fd848, fd852;
sub.f64 fd859, fd849, fd853;
add.f64 fd860, fd850, fd855;
sub.f64 fd861, fd851, fd854;
sub.f64 fd862, fd850, fd855;
add.f64 fd863, fd851, fd854;
mul.f64 fd864, fd860, 0d3FE6A09E667F3BCD;
mul.f64 fd865, fd861, 0dBFE6A09E667F3BCD;
sub.f64 fd866, fd864, fd865;
mul.f64 fd867, fd861, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd868, fd860, 0dBFE6A09E667F3BCD, fd867;
mul.f64 fd869, fd862, 0dBFE6A09E667F3BCD;
mul.f64 fd870, fd863, 0dBFE6A09E667F3BCD;
sub.f64 fd871, fd869, fd870;
add.f64 fd872, fd869, fd870;
add.f64 fd873, fd840, fd856;
add.f64 fd874, fd841, fd857;
sub.f64 fd875, fd840, fd856;
sub.f64 fd876, fd841, fd857;
add.f64 fd877, fd844, fd866;
add.f64 fd878, fd845, fd868;
sub.f64 fd879, fd844, fd866;
sub.f64 fd880, fd845, fd868;
add.f64 fd881, fd842, fd859;
sub.f64 fd882, fd843, fd858;
sub.f64 fd883, fd842, fd859;
add.f64 fd884, fd843, fd858;
add.f64 fd885, fd846, fd871;
add.f64 fd886, fd847, fd872;
sub.f64 fd887, fd846, fd871;
sub.f64 fd888, fd847, fd872;
mul.f64 fd889, fd877, 0d3FED906BCF328D46;
mul.f64 fd890, fd878, 0dBFD87DE2A6AEA963;
sub.f64 fd891, fd889, fd890;
mul.f64 fd892, fd878, 0d3FED906BCF328D46;
fma.rn.f64 fd893, fd877, 0dBFD87DE2A6AEA963, fd892;
mul.f64 fd894, fd881, 0d3FE6A09E667F3BCD;
mul.f64 fd895, fd882, 0dBFE6A09E667F3BCD;
sub.f64 fd896, fd894, fd895;
mul.f64 fd897, fd882, 0d3FE6A09E667F3BCD;
fma.rn.f64 fd898, fd881, 0dBFE6A09E667F3BCD, fd897;
mul.f64 fd899, fd885, 0d3FD87DE2A6AEA963;
mul.f64 fd900, fd886, 0dBFED906BCF328D46;
sub.f64 fd901, fd899, fd900;
mul.f64 fd902, fd886, 0d3FD87DE2A6AEA963;
fma.rn.f64 fd903, fd885, 0dBFED906BCF328D46, fd902;
mul.f64 fd904, fd879, 0dBFD87DE2A6AEA963;
mul.f64 fd905, fd880, 0dBFED906BCF328D46;
sub.f64 fd906, fd904, fd905;
mul.f64 fd907, fd880, 0dBFD87DE2A6AEA963;
fma.rn.f64 fd908, fd879, 0dBFED906BCF328D46, fd907;
mul.f64 fd909, fd883, 0dBFE6A09E667F3BCD;
mul.f64 fd910, fd884, 0dBFE6A09E667F3BCD;
sub.f64 fd911, fd909, fd910;
add.f64 fd912, fd909, fd910;
mul.f64 fd913, fd887, 0dBFED906BCF328D46;
mul.f64 fd914, fd888, 0dBFD87DE2A6AEA963;
sub.f64 fd915, fd913, fd914;
mul.f64 fd916, fd888, 0dBFED906BCF328D46;
fma.rn.f64 fd917, fd887, 0dBFD87DE2A6AEA963, fd916;
add.f64 %0, fd816, fd873;
add.f64 %1, fd817, fd874;
add.f64 %3, fd821, fd893;
add.f64 %2, fd820, fd891;
add.f64 %5, fd825, fd898;
add.f64 %4, fd824, fd896;
add.f64 %7, fd829, fd903;
add.f64 %6, fd828, fd901;
sub.f64 %9, fd819, fd875;
add.f64 %8, fd818, fd876;
add.f64 %11, fd823, fd908;
add.f64 %10, fd822, fd906;
add.f64 %13, fd827, fd912;
add.f64 %12, fd826, fd911;
add.f64 %15, fd831, fd917;
add.f64 %14, fd830, fd915;
sub.f64 %16, fd816, fd873;
sub.f64 %17, fd817, fd874;
sub.f64 %19, fd821, fd893;
sub.f64 %18, fd820, fd891;
sub.f64 %21, fd825, fd898;
sub.f64 %20, fd824, fd896;
sub.f64 %23, fd829, fd903;
sub.f64 %22, fd828, fd901;
add.f64 %25, fd819, fd875;
sub.f64 %24, fd818, fd876;
sub.f64 %27, fd823, fd908;
sub.f64 %26, fd822, fd906;
sub.f64 %29, fd827, fd912;
sub.f64 %28, fd826, fd911;
sub.f64 %31, fd831, fd917;
sub.f64 %30, fd830, fd915;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y): "r"(smem), "l"(lut_dp_16_4096), "l"(lut_dp_16_256), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<497, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<41>;
.reg .f64 fd<333>;
.reg .b64 rd<18>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 16;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %14, %19;
add.f64 fd18, %15, %21;
sub.f64 fd19, %14, %19;
sub.f64 fd20, %15, %21;
add.f64 fd21, %16, %22;
add.f64 fd22, %18, %23;
sub.f64 fd23, %16, %22;
sub.f64 fd24, %18, %23;
sub.f64 fd25, fd17, fd21;
sub.f64 fd26, fd18, fd22;
add.f64 fd27, fd19, fd24;
sub.f64 fd28, fd20, fd23;
sub.f64 fd29, fd19, fd24;
add.f64 fd30, fd20, fd23;
and.b32 r6, r5, 1023;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -65536;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 4;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 16368;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd31, fd32}, [rd5];
mul.f64 fd35, fd31, fd27;
mul.f64 fd36, fd32, fd28;
mul.f64 fd37, fd31, fd28;
mul.f64 fd38, fd31, fd31;
mul.f64 fd39, fd32, fd32;
sub.f64 fd40, fd38, fd39;
mul.f64 fd41, fd32, fd31;
fma.rn.f64 fd42, fd32, fd31, fd41;
mul.f64 fd43, fd40, fd25;
mul.f64 fd44, fd42, fd26;
mul.f64 fd45, fd40, fd26;
ld.global.v2.f64 {fd46, fd47}, [rd5+16384];
mul.f64 fd50, fd46, fd29;
mul.f64 fd51, fd47, fd30;
mul.f64 fd52, fd46, fd30;
barrier.sync 0;
and.b32 r11, r7, 65472;
add.s32 r12, r9, r11;
add.f64 fd53, fd18, fd22;
add.f64 fd54, fd17, fd21;
st.shared.v2.f64 [r12], {fd54, fd53};
fma.rn.f64 fd55, fd32, fd27, fd37;
sub.f64 fd56, fd35, fd36;
st.shared.v2.f64 [r12+16], {fd56, fd55};
sub.f64 fd57, fd43, fd44;
fma.rn.f64 fd58, fd42, fd25, fd45;
st.shared.v2.f64 [r12+32], {fd57, fd58};
fma.rn.f64 fd59, fd47, fd29, fd52;
sub.f64 fd60, fd50, fd51;
st.shared.v2.f64 [r12+48], {fd60, fd59};
barrier.sync 0;
mad.lo.s32 r13, r6, -48, r12;
ld.shared.v2.f64 {fd61, fd62}, [r13];
ld.shared.v2.f64 {fd65, fd66}, [r13+16384];
ld.shared.v2.f64 {fd69, fd70}, [r13+32768];
ld.shared.v2.f64 {fd73, fd74}, [r13+49152];
add.f64 fd77, fd61, fd69;
add.f64 fd78, fd62, fd70;
sub.f64 fd79, fd61, fd69;
sub.f64 fd80, fd62, fd70;
add.f64 fd81, fd65, fd73;
add.f64 fd82, fd66, fd74;
sub.f64 fd83, fd65, fd73;
sub.f64 fd84, fd66, fd74;
sub.f64 fd85, fd77, fd81;
sub.f64 fd86, fd78, fd82;
add.f64 fd87, fd79, fd84;
sub.f64 fd88, fd80, fd83;
sub.f64 fd89, fd79, fd84;
add.f64 fd90, fd80, fd83;
and.b32 r14, r5, 1020;
bfe.u32 r15, r5, 2, 8;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd91, fd92}, [rd8];
mul.f64 fd95, fd91, fd87;
mul.f64 fd96, fd92, fd88;
mul.f64 fd97, fd91, fd88;
mul.f64 fd98, fd91, fd91;
mul.f64 fd99, fd92, fd92;
sub.f64 fd100, fd98, fd99;
mul.f64 fd101, fd92, fd91;
fma.rn.f64 fd102, fd92, fd91, fd101;
mul.f64 fd103, fd100, fd85;
mul.f64 fd104, fd102, fd86;
mul.f64 fd105, fd100, fd86;
ld.global.v2.f64 {fd106, fd107}, [rd8+4096];
mul.f64 fd110, fd106, fd89;
mul.f64 fd111, fd107, fd90;
mul.f64 fd112, fd106, fd90;
and.b32 r16, r10, 48;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 65280;
add.s32 r19, r17, r18;
add.f64 fd113, fd78, fd82;
add.f64 fd114, fd77, fd81;
st.shared.v2.f64 [r19], {fd114, fd113};
fma.rn.f64 fd115, fd92, fd87, fd97;
sub.f64 fd116, fd95, fd96;
st.shared.v2.f64 [r19+64], {fd116, fd115};
fma.rn.f64 fd117, fd102, fd85, fd105;
sub.f64 fd118, fd103, fd104;
st.shared.v2.f64 [r19+128], {fd118, fd117};
fma.rn.f64 fd119, fd107, fd89, fd112;
sub.f64 fd120, fd110, fd111;
st.shared.v2.f64 [r19+192], {fd120, fd119};
barrier.sync 0;
mad.lo.s32 r20, r14, -48, r19;
ld.shared.v2.f64 {fd121, fd122}, [r20];
ld.shared.v2.f64 {fd125, fd126}, [r20+16384];
ld.shared.v2.f64 {fd129, fd130}, [r20+32768];
ld.shared.v2.f64 {fd133, fd134}, [r20+49152];
add.f64 fd137, fd121, fd129;
add.f64 fd138, fd122, fd130;
sub.f64 fd139, fd121, fd129;
sub.f64 fd140, fd122, fd130;
add.f64 fd141, fd125, fd133;
add.f64 fd142, fd126, fd134;
sub.f64 fd143, fd125, fd133;
sub.f64 fd144, fd126, fd134;
sub.f64 fd145, fd137, fd141;
sub.f64 fd146, fd138, fd142;
add.f64 fd147, fd139, fd144;
sub.f64 fd148, fd140, fd143;
sub.f64 fd149, fd139, fd144;
add.f64 fd150, fd140, fd143;
and.b32 r21, r5, 1008;
cvt.u64.u32 rd9, r21;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd151, fd152}, [rd11];
mul.f64 fd155, fd151, fd147;
mul.f64 fd156, fd152, fd148;
mul.f64 fd157, fd151, fd148;
mul.f64 fd158, fd151, fd151;
mul.f64 fd159, fd152, fd152;
sub.f64 fd160, fd158, fd159;
mul.f64 fd161, fd152, fd151;
fma.rn.f64 fd162, fd152, fd151, fd161;
mul.f64 fd163, fd160, fd145;
mul.f64 fd164, fd162, fd146;
mul.f64 fd165, fd160, fd146;
ld.global.v2.f64 {fd166, fd167}, [rd11+1024];
mul.f64 fd170, fd166, fd149;
mul.f64 fd171, fd167, fd150;
mul.f64 fd172, fd166, fd150;
and.b32 r22, r10, 240;
add.s32 r23, r9, r22;
barrier.sync 0;
and.b32 r24, r7, 64512;
add.s32 r25, r23, r24;
add.f64 fd173, fd138, fd142;
add.f64 fd174, fd137, fd141;
st.shared.v2.f64 [r25], {fd174, fd173};
fma.rn.f64 fd175, fd152, fd147, fd157;
sub.f64 fd176, fd155, fd156;
st.shared.v2.f64 [r25+256], {fd176, fd175};
fma.rn.f64 fd177, fd162, fd145, fd165;
sub.f64 fd178, fd163, fd164;
st.shared.v2.f64 [r25+512], {fd178, fd177};
fma.rn.f64 fd179, fd167, fd149, fd172;
sub.f64 fd180, fd170, fd171;
st.shared.v2.f64 [r25+768], {fd180, fd179};
barrier.sync 0;
mad.lo.s32 r26, r21, -48, r25;
ld.shared.v2.f64 {fd181, fd182}, [r26];
ld.shared.v2.f64 {fd185, fd186}, [r26+16384];
ld.shared.v2.f64 {fd189, fd190}, [r26+32768];
ld.shared.v2.f64 {fd193, fd194}, [r26+49152];
add.f64 fd197, fd181, fd189;
add.f64 fd198, fd182, fd190;
sub.f64 fd199, fd181, fd189;
sub.f64 fd200, fd182, fd190;
add.f64 fd201, fd185, fd193;
add.f64 fd202, fd186, fd194;
sub.f64 fd203, fd185, fd193;
sub.f64 fd204, fd186, fd194;
sub.f64 fd205, fd197, fd201;
sub.f64 fd206, fd198, fd202;
add.f64 fd207, fd199, fd204;
sub.f64 fd208, fd200, fd203;
sub.f64 fd209, fd199, fd204;
add.f64 fd210, fd200, fd203;
and.b32 r27, r5, 960;
bfe.u32 r28, r5, 6, 4;
mul.wide.u32 rd12, r28, 16;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd211, fd212}, [rd14];
mul.f64 fd215, fd211, fd207;
mul.f64 fd216, fd212, fd208;
mul.f64 fd217, fd211, fd208;
mul.f64 fd218, fd211, fd211;
mul.f64 fd219, fd212, fd212;
sub.f64 fd220, fd218, fd219;
mul.f64 fd221, fd212, fd211;
fma.rn.f64 fd222, fd212, fd211, fd221;
mul.f64 fd223, fd220, fd205;
mul.f64 fd224, fd222, fd206;
mul.f64 fd225, fd220, fd206;
ld.global.v2.f64 {fd226, fd227}, [rd14+256];
mul.f64 fd230, fd226, fd209;
mul.f64 fd231, fd227, fd210;
mul.f64 fd232, fd226, fd210;
and.b32 r29, r10, 1008;
add.s32 r30, r9, r29;
barrier.sync 0;
and.b32 r31, r7, 61440;
add.s32 r32, r30, r31;
add.f64 fd233, fd198, fd202;
add.f64 fd234, fd197, fd201;
st.shared.v2.f64 [r32], {fd234, fd233};
fma.rn.f64 fd235, fd212, fd207, fd217;
sub.f64 fd236, fd215, fd216;
st.shared.v2.f64 [r32+1024], {fd236, fd235};
fma.rn.f64 fd237, fd222, fd205, fd225;
sub.f64 fd238, fd223, fd224;
st.shared.v2.f64 [r32+2048], {fd238, fd237};
fma.rn.f64 fd239, fd227, fd209, fd232;
sub.f64 fd240, fd230, fd231;
st.shared.v2.f64 [r32+3072], {fd240, fd239};
barrier.sync 0;
mad.lo.s32 r33, r27, -48, r32;
ld.shared.v2.f64 {fd241, fd242}, [r33];
ld.shared.v2.f64 {fd245, fd246}, [r33+16384];
ld.shared.v2.f64 {fd249, fd250}, [r33+32768];
ld.shared.v2.f64 {fd253, fd254}, [r33+49152];
add.f64 fd257, fd241, fd249;
add.f64 fd258, fd242, fd250;
sub.f64 fd259, fd241, fd249;
sub.f64 fd260, fd242, fd250;
add.f64 fd261, fd245, fd253;
add.f64 fd262, fd246, fd254;
sub.f64 fd263, fd245, fd253;
sub.f64 fd264, fd246, fd254;
sub.f64 fd265, fd257, fd261;
sub.f64 fd266, fd258, fd262;
add.f64 fd267, fd259, fd264;
sub.f64 fd268, fd260, fd263;
sub.f64 fd269, fd259, fd264;
add.f64 fd270, fd260, fd263;
and.b32 r34, r5, 768;
bfe.u32 r35, r5, 8, 2;
mul.wide.u32 rd15, r35, 16;
mov.u64 rd16, %13;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd271, fd272}, [rd17];
mul.f64 fd275, fd271, fd267;
mul.f64 fd276, fd272, fd268;
mul.f64 fd277, fd271, fd268;
mul.f64 fd278, fd271, fd271;
mul.f64 fd279, fd272, fd272;
sub.f64 fd280, fd278, fd279;
mul.f64 fd281, fd272, fd271;
fma.rn.f64 fd282, fd272, fd271, fd281;
mul.f64 fd283, fd280, fd265;
mul.f64 fd284, fd282, fd266;
mul.f64 fd285, fd280, fd266;
ld.global.v2.f64 {fd286, fd287}, [rd17+64];
mul.f64 fd290, fd286, fd269;
mul.f64 fd291, fd287, fd270;
mul.f64 fd292, fd286, fd270;
and.b32 r36, r10, 4080;
add.s32 r37, r9, r36;
barrier.sync 0;
and.b32 r38, r7, 49152;
add.s32 r39, r37, r38;
add.f64 fd293, fd258, fd262;
add.f64 fd294, fd257, fd261;
st.shared.v2.f64 [r39], {fd294, fd293};
fma.rn.f64 fd295, fd272, fd267, fd277;
sub.f64 fd296, fd275, fd276;
st.shared.v2.f64 [r39+4096], {fd296, fd295};
fma.rn.f64 fd297, fd282, fd265, fd285;
sub.f64 fd298, fd283, fd284;
st.shared.v2.f64 [r39+8192], {fd298, fd297};
fma.rn.f64 fd299, fd287, fd269, fd292;
sub.f64 fd300, fd290, fd291;
st.shared.v2.f64 [r39+12288], {fd300, fd299};
barrier.sync 0;
mad.lo.s32 r40, r34, -48, r39;
ld.shared.v2.f64 {fd301, fd302}, [r40];
ld.shared.v2.f64 {fd305, fd306}, [r40+16384];
ld.shared.v2.f64 {fd309, fd310}, [r40+32768];
ld.shared.v2.f64 {fd313, fd314}, [r40+49152];
add.f64 fd317, fd301, fd309;
add.f64 fd318, fd302, fd310;
sub.f64 fd319, fd301, fd309;
sub.f64 fd320, fd302, fd310;
add.f64 fd321, fd305, fd313;
add.f64 fd322, fd306, fd314;
sub.f64 fd323, fd305, fd313;
sub.f64 fd324, fd306, fd314;
add.f64 %1, fd318, fd322;
add.f64 %0, fd317, fd321;
sub.f64 %3, fd320, fd323;
add.f64 %2, fd319, fd324;
sub.f64 %5, fd318, fd322;
sub.f64 %4, fd317, fd321;
add.f64 %7, fd320, fd323;
sub.f64 %6, fd319, fd324;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_4096), "l"(lut_dp_4_1024), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<496, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<42>;
.reg .f64 fd<293>;
.reg .b64 rd<18>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 15;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f64 fd17, %14, %19;
add.f64 fd18, %15, %21;
sub.f64 fd19, %14, %19;
sub.f64 fd20, %15, %21;
add.f64 fd21, %16, %22;
add.f64 fd22, %18, %23;
sub.f64 fd23, %16, %22;
sub.f64 fd24, %18, %23;
add.f64 fd25, fd17, fd21;
add.f64 fd26, fd18, fd22;
sub.f64 fd27, fd17, fd21;
sub.f64 fd28, fd18, fd22;
add.f64 fd29, fd19, fd24;
sub.f64 fd30, fd20, fd23;
sub.f64 fd31, fd19, fd24;
add.f64 fd32, fd20, fd23;
and.b32 r6, r5, 1023;
shl.b32 r7, r5, 4;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 16368;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f64 {fd33, fd34}, [rd5];
mul.f64 fd37, fd33, fd29;
mul.f64 fd38, fd34, fd30;
sub.f64 fd39, fd37, fd38;
mul.f64 fd40, fd33, fd30;
fma.rn.f64 fd41, fd34, fd29, fd40;
mul.f64 fd42, fd33, fd33;
mul.f64 fd43, fd34, fd34;
sub.f64 fd44, fd42, fd43;
mul.f64 fd45, fd34, fd33;
fma.rn.f64 fd46, fd34, fd33, fd45;
mul.f64 fd47, fd44, fd27;
mul.f64 fd48, fd46, fd28;
sub.f64 fd49, fd47, fd48;
mul.f64 fd50, fd44, fd28;
fma.rn.f64 fd51, fd46, fd27, fd50;
ld.global.v2.f64 {fd52, fd53}, [rd5+16384];
mul.f64 fd56, fd52, fd31;
mul.f64 fd57, fd53, fd32;
sub.f64 fd58, fd56, fd57;
mul.f64 fd59, fd52, fd32;
fma.rn.f64 fd60, fd53, fd31, fd59;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -32768;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 32736;
add.s32 r12, r10, r11;
st.shared.v2.f64 [r12], {fd25, fd39};
st.shared.v2.f64 [r12+16], {fd49, fd58};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.f64 fd61, [r13];
ld.shared.f64 fd62, [r13+8192];
ld.shared.f64 fd63, [r13+16384];
ld.shared.f64 fd64, [r13+24576];
barrier.sync 0;
st.shared.v2.f64 [r12], {fd26, fd41};
st.shared.v2.f64 [r12+16], {fd51, fd60};
barrier.sync 0;
ld.shared.f64 fd65, [r13];
ld.shared.f64 fd66, [r13+8192];
ld.shared.f64 fd67, [r13+16384];
ld.shared.f64 fd68, [r13+24576];
add.f64 fd69, fd61, fd63;
add.f64 fd70, fd65, fd67;
sub.f64 fd71, fd61, fd63;
sub.f64 fd72, fd65, fd67;
add.f64 fd73, fd62, fd64;
add.f64 fd74, fd66, fd68;
sub.f64 fd75, fd62, fd64;
sub.f64 fd76, fd66, fd68;
add.f64 fd77, fd69, fd73;
add.f64 fd78, fd70, fd74;
sub.f64 fd79, fd69, fd73;
sub.f64 fd80, fd70, fd74;
add.f64 fd81, fd71, fd76;
sub.f64 fd82, fd72, fd75;
sub.f64 fd83, fd71, fd76;
add.f64 fd84, fd72, fd75;
and.b32 r14, r5, 1020;
bfe.u32 r15, r5, 2, 8;
mul.wide.u32 rd6, r15, 16;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f64 {fd85, fd86}, [rd8];
mul.f64 fd89, fd85, fd81;
mul.f64 fd90, fd86, fd82;
sub.f64 fd91, fd89, fd90;
mul.f64 fd92, fd85, fd82;
fma.rn.f64 fd93, fd86, fd81, fd92;
mul.f64 fd94, fd85, fd85;
mul.f64 fd95, fd86, fd86;
sub.f64 fd96, fd94, fd95;
mul.f64 fd97, fd86, fd85;
fma.rn.f64 fd98, fd86, fd85, fd97;
mul.f64 fd99, fd96, fd79;
mul.f64 fd100, fd98, fd80;
sub.f64 fd101, fd99, fd100;
mul.f64 fd102, fd96, fd80;
fma.rn.f64 fd103, fd98, fd79, fd102;
ld.global.v2.f64 {fd104, fd105}, [rd8+4096];
mul.f64 fd108, fd104, fd83;
mul.f64 fd109, fd105, fd84;
sub.f64 fd110, fd108, fd109;
mul.f64 fd111, fd104, fd84;
fma.rn.f64 fd112, fd105, fd83, fd111;
shl.b32 r16, r5, 3;
and.b32 r17, r16, 24;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 32640;
add.s32 r20, r18, r19;
st.shared.f64 [r20], fd77;
st.shared.f64 [r20+32], fd91;
st.shared.f64 [r20+64], fd101;
st.shared.f64 [r20+96], fd110;
barrier.sync 0;
mad.lo.s32 r21, r14, -24, r20;
ld.shared.f64 fd113, [r21];
ld.shared.f64 fd114, [r21+8192];
ld.shared.f64 fd115, [r21+16384];
ld.shared.f64 fd116, [r21+24576];
barrier.sync 0;
st.shared.f64 [r20], fd78;
st.shared.f64 [r20+32], fd93;
st.shared.f64 [r20+64], fd103;
st.shared.f64 [r20+96], fd112;
barrier.sync 0;
ld.shared.f64 fd117, [r21];
ld.shared.f64 fd118, [r21+8192];
ld.shared.f64 fd119, [r21+16384];
ld.shared.f64 fd120, [r21+24576];
add.f64 fd121, fd113, fd115;
add.f64 fd122, fd117, fd119;
sub.f64 fd123, fd113, fd115;
sub.f64 fd124, fd117, fd119;
add.f64 fd125, fd114, fd116;
add.f64 fd126, fd118, fd120;
sub.f64 fd127, fd114, fd116;
sub.f64 fd128, fd118, fd120;
add.f64 fd129, fd121, fd125;
add.f64 fd130, fd122, fd126;
sub.f64 fd131, fd121, fd125;
sub.f64 fd132, fd122, fd126;
add.f64 fd133, fd123, fd128;
sub.f64 fd134, fd124, fd127;
sub.f64 fd135, fd123, fd128;
add.f64 fd136, fd124, fd127;
and.b32 r22, r5, 1008;
cvt.u64.u32 rd9, r22;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd137, fd138}, [rd11];
mul.f64 fd141, fd137, fd133;
mul.f64 fd142, fd138, fd134;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd137, fd134;
fma.rn.f64 fd145, fd138, fd133, fd144;
mul.f64 fd146, fd137, fd137;
mul.f64 fd147, fd138, fd138;
sub.f64 fd148, fd146, fd147;
mul.f64 fd149, fd138, fd137;
fma.rn.f64 fd150, fd138, fd137, fd149;
mul.f64 fd151, fd148, fd131;
mul.f64 fd152, fd150, fd132;
sub.f64 fd153, fd151, fd152;
mul.f64 fd154, fd148, fd132;
fma.rn.f64 fd155, fd150, fd131, fd154;
ld.global.v2.f64 {fd156, fd157}, [rd11+1024];
mul.f64 fd160, fd156, fd135;
mul.f64 fd161, fd157, fd136;
sub.f64 fd162, fd160, fd161;
mul.f64 fd163, fd156, fd136;
fma.rn.f64 fd164, fd157, fd135, fd163;
and.b32 r23, r16, 120;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 32256;
add.s32 r26, r24, r25;
st.shared.f64 [r26], fd129;
st.shared.f64 [r26+128], fd143;
st.shared.f64 [r26+256], fd153;
st.shared.f64 [r26+384], fd162;
barrier.sync 0;
mad.lo.s32 r27, r22, -24, r26;
ld.shared.f64 fd165, [r27];
ld.shared.f64 fd166, [r27+8192];
ld.shared.f64 fd167, [r27+16384];
ld.shared.f64 fd168, [r27+24576];
barrier.sync 0;
st.shared.f64 [r26], fd130;
st.shared.f64 [r26+128], fd145;
st.shared.f64 [r26+256], fd155;
st.shared.f64 [r26+384], fd164;
barrier.sync 0;
ld.shared.f64 fd169, [r27];
ld.shared.f64 fd170, [r27+8192];
ld.shared.f64 fd171, [r27+16384];
ld.shared.f64 fd172, [r27+24576];
add.f64 fd173, fd165, fd167;
add.f64 fd174, fd169, fd171;
sub.f64 fd175, fd165, fd167;
sub.f64 fd176, fd169, fd171;
add.f64 fd177, fd166, fd168;
add.f64 fd178, fd170, fd172;
sub.f64 fd179, fd166, fd168;
sub.f64 fd180, fd170, fd172;
add.f64 fd181, fd173, fd177;
add.f64 fd182, fd174, fd178;
sub.f64 fd183, fd173, fd177;
sub.f64 fd184, fd174, fd178;
add.f64 fd185, fd175, fd180;
sub.f64 fd186, fd176, fd179;
sub.f64 fd187, fd175, fd180;
add.f64 fd188, fd176, fd179;
and.b32 r28, r5, 960;
bfe.u32 r29, r5, 6, 4;
mul.wide.u32 rd12, r29, 16;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f64 {fd189, fd190}, [rd14];
mul.f64 fd193, fd189, fd185;
mul.f64 fd194, fd190, fd186;
sub.f64 fd195, fd193, fd194;
mul.f64 fd196, fd189, fd186;
fma.rn.f64 fd197, fd190, fd185, fd196;
mul.f64 fd198, fd189, fd189;
mul.f64 fd199, fd190, fd190;
sub.f64 fd200, fd198, fd199;
mul.f64 fd201, fd190, fd189;
fma.rn.f64 fd202, fd190, fd189, fd201;
mul.f64 fd203, fd200, fd183;
mul.f64 fd204, fd202, fd184;
sub.f64 fd205, fd203, fd204;
mul.f64 fd206, fd200, fd184;
fma.rn.f64 fd207, fd202, fd183, fd206;
ld.global.v2.f64 {fd208, fd209}, [rd14+256];
mul.f64 fd212, fd208, fd187;
mul.f64 fd213, fd209, fd188;
sub.f64 fd214, fd212, fd213;
mul.f64 fd215, fd208, fd188;
fma.rn.f64 fd216, fd209, fd187, fd215;
and.b32 r30, r16, 504;
add.s32 r31, r10, r30;
barrier.sync 0;
and.b32 r32, r8, 30720;
add.s32 r33, r31, r32;
st.shared.f64 [r33], fd181;
st.shared.f64 [r33+512], fd195;
st.shared.f64 [r33+1024], fd205;
st.shared.f64 [r33+1536], fd214;
barrier.sync 0;
mad.lo.s32 r34, r28, -24, r33;
ld.shared.f64 fd217, [r34];
ld.shared.f64 fd218, [r34+8192];
ld.shared.f64 fd219, [r34+16384];
ld.shared.f64 fd220, [r34+24576];
barrier.sync 0;
st.shared.f64 [r33], fd182;
st.shared.f64 [r33+512], fd197;
st.shared.f64 [r33+1024], fd207;
st.shared.f64 [r33+1536], fd216;
barrier.sync 0;
ld.shared.f64 fd221, [r34];
ld.shared.f64 fd222, [r34+8192];
ld.shared.f64 fd223, [r34+16384];
ld.shared.f64 fd224, [r34+24576];
add.f64 fd225, fd217, fd219;
add.f64 fd226, fd221, fd223;
sub.f64 fd227, fd217, fd219;
sub.f64 fd228, fd221, fd223;
add.f64 fd229, fd218, fd220;
add.f64 fd230, fd222, fd224;
sub.f64 fd231, fd218, fd220;
sub.f64 fd232, fd222, fd224;
add.f64 fd233, fd225, fd229;
add.f64 fd234, fd226, fd230;
sub.f64 fd235, fd225, fd229;
sub.f64 fd236, fd226, fd230;
add.f64 fd237, fd227, fd232;
sub.f64 fd238, fd228, fd231;
sub.f64 fd239, fd227, fd232;
add.f64 fd240, fd228, fd231;
and.b32 r35, r5, 768;
bfe.u32 r36, r5, 8, 2;
mul.wide.u32 rd15, r36, 16;
mov.u64 rd16, %13;
add.s64 rd17, rd16, rd15;
ld.global.v2.f64 {fd241, fd242}, [rd17];
mul.f64 fd245, fd241, fd237;
mul.f64 fd246, fd242, fd238;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd241, fd238;
fma.rn.f64 fd249, fd242, fd237, fd248;
mul.f64 fd250, fd241, fd241;
mul.f64 fd251, fd242, fd242;
sub.f64 fd252, fd250, fd251;
mul.f64 fd253, fd242, fd241;
fma.rn.f64 fd254, fd242, fd241, fd253;
mul.f64 fd255, fd252, fd235;
mul.f64 fd256, fd254, fd236;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd252, fd236;
fma.rn.f64 fd259, fd254, fd235, fd258;
ld.global.v2.f64 {fd260, fd261}, [rd17+64];
mul.f64 fd264, fd260, fd239;
mul.f64 fd265, fd261, fd240;
sub.f64 fd266, fd264, fd265;
mul.f64 fd267, fd260, fd240;
fma.rn.f64 fd268, fd261, fd239, fd267;
and.b32 r37, r16, 2040;
add.s32 r38, r10, r37;
barrier.sync 0;
and.b32 r39, r8, 24576;
add.s32 r40, r38, r39;
st.shared.f64 [r40], fd233;
st.shared.f64 [r40+2048], fd247;
st.shared.f64 [r40+4096], fd257;
st.shared.f64 [r40+6144], fd266;
barrier.sync 0;
mad.lo.s32 r41, r35, -24, r40;
ld.shared.f64 fd269, [r41];
ld.shared.f64 fd270, [r41+8192];
ld.shared.f64 fd271, [r41+16384];
ld.shared.f64 fd272, [r41+24576];
barrier.sync 0;
st.shared.f64 [r40], fd234;
st.shared.f64 [r40+2048], fd249;
st.shared.f64 [r40+4096], fd259;
st.shared.f64 [r40+6144], fd268;
barrier.sync 0;
ld.shared.f64 fd273, [r41];
ld.shared.f64 fd274, [r41+8192];
ld.shared.f64 fd275, [r41+16384];
ld.shared.f64 fd276, [r41+24576];
add.f64 fd277, fd269, fd271;
add.f64 fd278, fd273, fd275;
sub.f64 fd279, fd269, fd271;
sub.f64 fd280, fd273, fd275;
add.f64 fd281, fd270, fd272;
add.f64 fd282, fd274, fd276;
sub.f64 fd283, fd270, fd272;
sub.f64 fd284, fd274, fd276;
add.f64 %0, fd277, fd281;
add.f64 %1, fd278, fd282;
sub.f64 %3, fd280, fd283;
add.f64 %2, fd279, fd284;
sub.f64 %4, fd277, fd281;
sub.f64 %5, fd278, fd282;
add.f64 %7, fd280, fd283;
sub.f64 %6, fd279, fd284;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y): "r"(smem), "l"(lut_dp_4_4096), "l"(lut_dp_4_1024), "l"(lut_dp_4_256), "l"(lut_dp_4_64), "l"(lut_dp_4_16), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y));
};


#endif
