#ifndef CUFFTDX_FFT_36_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_36_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<185, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<206>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 288, r2;
mov.u32 r4, %tid.x;
add.f32 f25, %19, %24;
add.f32 f26, %14, f25;
add.f32 f27, %21, %26;
add.f32 f28, %15, f27;
mul.f32 f29, f25, 0f3F000000;
sub.f32 f30, %14, f29;
sub.f32 f31, %21, %26;
mul.f32 f32, f31, 0f3F5DB3D7;
add.f32 f33, f32, f30;
sub.f32 f34, f30, f32;
mul.f32 f35, f27, 0f3F000000;
sub.f32 f36, %15, f35;
sub.f32 f37, %19, %24;
mul.f32 f38, f37, 0f3F5DB3D7;
sub.f32 f39, f36, f38;
add.f32 f40, f38, f36;
add.f32 f41, %22, %27;
add.f32 f42, %16, f41;
add.f32 f43, %23, %28;
add.f32 f44, %18, f43;
mul.f32 f45, f41, 0f3F000000;
sub.f32 f46, %16, f45;
sub.f32 f47, %23, %28;
mul.f32 f48, f47, 0f3F5DB3D7;
add.f32 f49, f48, f46;
sub.f32 f50, f46, f48;
mul.f32 f51, f43, 0f3F000000;
sub.f32 f52, %18, f51;
sub.f32 f53, %22, %27;
mul.f32 f54, f53, 0f3F5DB3D7;
sub.f32 f55, f52, f54;
add.f32 f56, f54, f52;
mul.f32 f57, f49, 0f3F000000;
mul.f32 f58, f55, 0fBF5DB3D7;
sub.f32 f59, f57, f58;
mul.f32 f60, f55, 0f3F000000;
fma.rn.f32 f61, f49, 0fBF5DB3D7, f60;
mul.f32 f62, f50, 0fBF000000;
mul.f32 f63, f56, 0fBF5DB3D7;
sub.f32 f64, f62, f63;
mul.f32 f65, f56, 0fBF000000;
fma.rn.f32 f66, f50, 0fBF5DB3D7, f65;
sub.f32 f67, f26, f42;
sub.f32 f68, f28, f44;
add.f32 f69, f33, f59;
add.f32 f70, f39, f61;
sub.f32 f71, f33, f59;
sub.f32 f72, f39, f61;
add.f32 f73, f34, f64;
add.f32 f74, f40, f66;
sub.f32 f75, f34, f64;
sub.f32 f76, f40, f66;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 6;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 288, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f77, f78}, [rd6];
mul.f32 f81, f77, f69;
mul.f32 f82, f78, f70;
mul.f32 f83, f77, f70;
mul.f32 f84, f77, f77;
mul.f32 f85, f78, f78;
sub.f32 f86, f84, f85;
mul.f32 f87, f78, f77;
fma.rn.f32 f88, f78, f77, f87;
mul.f32 f89, f86, f73;
mul.f32 f90, f88, f74;
mul.f32 f91, f86, f74;
mul.f32 f92, f77, f86;
mul.f32 f93, f78, f88;
sub.f32 f94, f92, f93;
mul.f32 f95, f77, f88;
fma.rn.f32 f96, f78, f86, f95;
mul.f32 f97, f94, f67;
mul.f32 f98, f96, f68;
mul.f32 f99, f94, f68;
mul.f32 f100, f77, f94;
mul.f32 f101, f78, f96;
sub.f32 f102, f100, f101;
mul.f32 f103, f77, f96;
fma.rn.f32 f104, f78, f94, f103;
mul.f32 f105, f102, f71;
mul.f32 f106, f104, f72;
mul.f32 f107, f102, f72;
mul.f32 f108, f77, f102;
mul.f32 f109, f78, f104;
sub.f32 f110, f108, f109;
mul.f32 f111, f77, f104;
fma.rn.f32 f112, f78, f102, f111;
mul.f32 f113, f110, f75;
mul.f32 f114, f112, f76;
mul.f32 f115, f110, f76;
barrier.sync 0;
mad.lo.s32 r9, r7, 48, r8;
add.f32 f116, f28, f44;
add.f32 f117, f26, f42;
st.shared.v2.f32 [r9], {f117, f116};
fma.rn.f32 f118, f78, f69, f83;
sub.f32 f119, f81, f82;
st.shared.v2.f32 [r9+8], {f119, f118};
fma.rn.f32 f120, f88, f73, f91;
sub.f32 f121, f89, f90;
st.shared.v2.f32 [r9+16], {f121, f120};
fma.rn.f32 f122, f96, f67, f99;
sub.f32 f123, f97, f98;
st.shared.v2.f32 [r9+24], {f123, f122};
fma.rn.f32 f124, f104, f71, f107;
sub.f32 f125, f105, f106;
st.shared.v2.f32 [r9+32], {f125, f124};
fma.rn.f32 f126, f112, f75, f115;
sub.f32 f127, f113, f114;
st.shared.v2.f32 [r9+40], {f127, f126};
barrier.sync 0;
mad.lo.s32 r10, r7, -40, r9;
ld.shared.v2.f32 {f128, f129}, [r10];
ld.shared.v2.f32 {f132, f133}, [r10+48];
ld.shared.v2.f32 {f136, f137}, [r10+96];
ld.shared.v2.f32 {f140, f141}, [r10+144];
ld.shared.v2.f32 {f144, f145}, [r10+192];
ld.shared.v2.f32 {f148, f149}, [r10+240];
add.f32 f152, f136, f144;
add.f32 f153, f128, f152;
add.f32 f154, f137, f145;
add.f32 f155, f129, f154;
mul.f32 f156, f152, 0f3F000000;
sub.f32 f157, f128, f156;
sub.f32 f158, f137, f145;
mul.f32 f159, f158, 0f3F5DB3D7;
add.f32 f160, f159, f157;
sub.f32 f161, f157, f159;
mul.f32 f162, f154, 0f3F000000;
sub.f32 f163, f129, f162;
sub.f32 f164, f136, f144;
mul.f32 f165, f164, 0f3F5DB3D7;
sub.f32 f166, f163, f165;
add.f32 f167, f165, f163;
add.f32 f168, f140, f148;
add.f32 f169, f132, f168;
add.f32 f170, f141, f149;
add.f32 f171, f133, f170;
mul.f32 f172, f168, 0f3F000000;
sub.f32 f173, f132, f172;
sub.f32 f174, f141, f149;
mul.f32 f175, f174, 0f3F5DB3D7;
add.f32 f176, f175, f173;
sub.f32 f177, f173, f175;
mul.f32 f178, f170, 0f3F000000;
sub.f32 f179, f133, f178;
sub.f32 f180, f140, f148;
mul.f32 f181, f180, 0f3F5DB3D7;
sub.f32 f182, f179, f181;
add.f32 f183, f181, f179;
mul.f32 f184, f176, 0f3F000000;
mul.f32 f185, f182, 0fBF5DB3D7;
sub.f32 f186, f184, f185;
mul.f32 f187, f182, 0f3F000000;
fma.rn.f32 f188, f176, 0fBF5DB3D7, f187;
mul.f32 f189, f177, 0fBF000000;
mul.f32 f190, f183, 0fBF5DB3D7;
sub.f32 f191, f189, f190;
mul.f32 f192, f183, 0fBF000000;
fma.rn.f32 f193, f177, 0fBF5DB3D7, f192;
add.f32 %1, f155, f171;
add.f32 %0, f153, f169;
add.f32 %3, f166, f188;
add.f32 %2, f160, f186;
add.f32 %5, f167, f193;
add.f32 %4, f161, f191;
sub.f32 %7, f155, f171;
sub.f32 %6, f153, f169;
sub.f32 %9, f166, f188;
sub.f32 %8, f160, f186;
sub.f32 %11, f167, f193;
sub.f32 %10, f161, f191;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y): "r"(smem), "l"(lut_sp_6_36), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<184, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<194>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 144, r2;
mov.u32 r4, %tid.x;
add.f32 f25, %19, %24;
add.f32 f26, %14, f25;
add.f32 f27, %21, %26;
add.f32 f28, %15, f27;
mul.f32 f29, f25, 0f3F000000;
sub.f32 f30, %14, f29;
sub.f32 f31, %21, %26;
mul.f32 f32, f31, 0f3F5DB3D7;
add.f32 f33, f32, f30;
sub.f32 f34, f30, f32;
mul.f32 f35, f27, 0f3F000000;
sub.f32 f36, %15, f35;
sub.f32 f37, %19, %24;
mul.f32 f38, f37, 0f3F5DB3D7;
sub.f32 f39, f36, f38;
add.f32 f40, f38, f36;
add.f32 f41, %22, %27;
add.f32 f42, %16, f41;
add.f32 f43, %23, %28;
add.f32 f44, %18, f43;
mul.f32 f45, f41, 0f3F000000;
sub.f32 f46, %16, f45;
sub.f32 f47, %23, %28;
mul.f32 f48, f47, 0f3F5DB3D7;
add.f32 f49, f48, f46;
sub.f32 f50, f46, f48;
mul.f32 f51, f43, 0f3F000000;
sub.f32 f52, %18, f51;
sub.f32 f53, %22, %27;
mul.f32 f54, f53, 0f3F5DB3D7;
sub.f32 f55, f52, f54;
add.f32 f56, f54, f52;
mul.f32 f57, f49, 0f3F000000;
mul.f32 f58, f55, 0fBF5DB3D7;
sub.f32 f59, f57, f58;
mul.f32 f60, f55, 0f3F000000;
fma.rn.f32 f61, f49, 0fBF5DB3D7, f60;
mul.f32 f62, f50, 0fBF000000;
mul.f32 f63, f56, 0fBF5DB3D7;
sub.f32 f64, f62, f63;
mul.f32 f65, f56, 0fBF000000;
fma.rn.f32 f66, f50, 0fBF5DB3D7, f65;
add.f32 f67, f26, f42;
add.f32 f68, f28, f44;
sub.f32 f69, f26, f42;
sub.f32 f70, f28, f44;
add.f32 f71, f33, f59;
add.f32 f72, f39, f61;
sub.f32 f73, f33, f59;
sub.f32 f74, f39, f61;
add.f32 f75, f34, f64;
add.f32 f76, f40, f66;
sub.f32 f77, f34, f64;
sub.f32 f78, f40, f66;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 6;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f79, f80}, [rd6];
mul.f32 f83, f79, f71;
mul.f32 f84, f80, f72;
sub.f32 f85, f83, f84;
mul.f32 f86, f79, f72;
fma.rn.f32 f87, f80, f71, f86;
mul.f32 f88, f79, f79;
mul.f32 f89, f80, f80;
sub.f32 f90, f88, f89;
mul.f32 f91, f80, f79;
fma.rn.f32 f92, f80, f79, f91;
mul.f32 f93, f90, f75;
mul.f32 f94, f92, f76;
sub.f32 f95, f93, f94;
mul.f32 f96, f90, f76;
fma.rn.f32 f97, f92, f75, f96;
mul.f32 f98, f79, f90;
mul.f32 f99, f80, f92;
sub.f32 f100, f98, f99;
mul.f32 f101, f79, f92;
fma.rn.f32 f102, f80, f90, f101;
mul.f32 f103, f100, f69;
mul.f32 f104, f102, f70;
sub.f32 f105, f103, f104;
mul.f32 f106, f100, f70;
fma.rn.f32 f107, f102, f69, f106;
mul.f32 f108, f79, f100;
mul.f32 f109, f80, f102;
sub.f32 f110, f108, f109;
mul.f32 f111, f79, f102;
fma.rn.f32 f112, f80, f100, f111;
mul.f32 f113, f110, f73;
mul.f32 f114, f112, f74;
sub.f32 f115, f113, f114;
mul.f32 f116, f110, f74;
fma.rn.f32 f117, f112, f73, f116;
mul.f32 f118, f79, f110;
mul.f32 f119, f80, f112;
sub.f32 f120, f118, f119;
mul.f32 f121, f79, f112;
fma.rn.f32 f122, f80, f110, f121;
mul.f32 f123, f120, f77;
mul.f32 f124, f122, f78;
sub.f32 f125, f123, f124;
mul.f32 f126, f120, f78;
fma.rn.f32 f127, f122, f77, f126;
mad.lo.s32 r8, r5, 144, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 24, r8;
st.shared.v2.f32 [r9], {f67, f85};
st.shared.v2.f32 [r9+8], {f95, f105};
st.shared.v2.f32 [r9+16], {f115, f125};
barrier.sync 0;
mad.lo.s32 r10, r7, -20, r9;
ld.shared.f32 f128, [r10];
ld.shared.f32 f129, [r10+24];
ld.shared.f32 f130, [r10+48];
ld.shared.f32 f131, [r10+72];
ld.shared.f32 f132, [r10+96];
ld.shared.f32 f133, [r10+120];
barrier.sync 0;
st.shared.v2.f32 [r9], {f68, f87};
st.shared.v2.f32 [r9+8], {f97, f107};
st.shared.v2.f32 [r9+16], {f117, f127};
barrier.sync 0;
ld.shared.f32 f134, [r10];
ld.shared.f32 f135, [r10+24];
ld.shared.f32 f136, [r10+48];
ld.shared.f32 f137, [r10+72];
ld.shared.f32 f138, [r10+96];
ld.shared.f32 f139, [r10+120];
add.f32 f140, f130, f132;
add.f32 f141, f128, f140;
add.f32 f142, f136, f138;
add.f32 f143, f134, f142;
mul.f32 f144, f140, 0f3F000000;
sub.f32 f145, f128, f144;
sub.f32 f146, f136, f138;
mul.f32 f147, f146, 0f3F5DB3D7;
add.f32 f148, f147, f145;
sub.f32 f149, f145, f147;
mul.f32 f150, f142, 0f3F000000;
sub.f32 f151, f134, f150;
sub.f32 f152, f130, f132;
mul.f32 f153, f152, 0f3F5DB3D7;
sub.f32 f154, f151, f153;
add.f32 f155, f153, f151;
add.f32 f156, f131, f133;
add.f32 f157, f129, f156;
add.f32 f158, f137, f139;
add.f32 f159, f135, f158;
mul.f32 f160, f156, 0f3F000000;
sub.f32 f161, f129, f160;
sub.f32 f162, f137, f139;
mul.f32 f163, f162, 0f3F5DB3D7;
add.f32 f164, f163, f161;
sub.f32 f165, f161, f163;
mul.f32 f166, f158, 0f3F000000;
sub.f32 f167, f135, f166;
sub.f32 f168, f131, f133;
mul.f32 f169, f168, 0f3F5DB3D7;
sub.f32 f170, f167, f169;
add.f32 f171, f169, f167;
mul.f32 f172, f164, 0f3F000000;
mul.f32 f173, f170, 0fBF5DB3D7;
sub.f32 f174, f172, f173;
mul.f32 f175, f170, 0f3F000000;
fma.rn.f32 f176, f164, 0fBF5DB3D7, f175;
mul.f32 f177, f165, 0fBF000000;
mul.f32 f178, f171, 0fBF5DB3D7;
sub.f32 f179, f177, f178;
mul.f32 f180, f171, 0fBF000000;
fma.rn.f32 f181, f165, 0fBF5DB3D7, f180;
add.f32 %0, f141, f157;
add.f32 %1, f143, f159;
add.f32 %3, f154, f176;
add.f32 %2, f148, f174;
add.f32 %5, f155, f181;
add.f32 %4, f149, f179;
sub.f32 %6, f141, f157;
sub.f32 %7, f143, f159;
sub.f32 %9, f154, f176;
sub.f32 %8, f148, f174;
sub.f32 %11, f155, f181;
sub.f32 %10, f149, f179;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y): "r"(smem), "l"(lut_sp_6_36), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y));
};


#endif
