#ifndef CUFFTDX_FFT_343_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_343_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<720, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<453>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 5488, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %19, %33;
add.f64 fd30, %17, fd29;
add.f64 fd31, %22, %30;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %25, %27;
add.f64 fd34, %21, %34;
add.f64 fd35, %18, fd34;
add.f64 fd36, %24, %32;
add.f64 fd37, fd36, fd35;
add.f64 fd38, %26, %29;
fma.rn.f64 fd39, fd29, 0d3FE3F3A0E28BEDD1, %17;
mul.f64 fd40, fd31, 0d3FCC7B90E3024582;
sub.f64 fd41, fd39, fd40;
mul.f64 fd42, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, %21, %34;
mul.f64 fd45, fd44, 0d3FE904C37505DE4B;
sub.f64 fd46, %24, %32;
fma.rn.f64 fd47, fd46, 0d3FEF329C0558E969, fd45;
sub.f64 fd48, %26, %29;
fma.rn.f64 fd49, fd48, 0d3FDBC4C04D71ABC1, fd47;
sub.f64 fd50, fd43, fd49;
add.f64 fd51, fd49, fd43;
mul.f64 fd52, fd29, 0d3FCC7B90E3024582;
sub.f64 fd53, %17, fd52;
mul.f64 fd54, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd55, fd53, fd54;
fma.rn.f64 fd56, fd33, 0d3FE3F3A0E28BEDD1, fd55;
mul.f64 fd57, fd44, 0d3FEF329C0558E969;
mul.f64 fd58, fd46, 0d3FDBC4C04D71ABC1;
sub.f64 fd59, fd57, fd58;
mul.f64 fd60, fd48, 0d3FE904C37505DE4B;
sub.f64 fd61, fd59, fd60;
sub.f64 fd62, fd56, fd61;
add.f64 fd63, fd61, fd56;
mul.f64 fd64, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd65, %17, fd64;
fma.rn.f64 fd66, fd31, 0d3FE3F3A0E28BEDD1, fd65;
mul.f64 fd67, fd33, 0d3FCC7B90E3024582;
sub.f64 fd68, fd66, fd67;
mul.f64 fd69, fd44, 0d3FDBC4C04D71ABC1;
mul.f64 fd70, fd46, 0d3FE904C37505DE4B;
sub.f64 fd71, fd69, fd70;
fma.rn.f64 fd72, fd48, 0d3FEF329C0558E969, fd71;
sub.f64 fd73, fd68, fd72;
add.f64 fd74, fd72, fd68;
fma.rn.f64 fd75, fd34, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd76, fd36, 0d3FCC7B90E3024582;
sub.f64 fd77, fd75, fd76;
mul.f64 fd78, fd38, 0d3FECD4BCA9CB5C71;
sub.f64 fd79, fd77, fd78;
sub.f64 fd80, %19, %33;
mul.f64 fd81, fd80, 0d3FE904C37505DE4B;
sub.f64 fd82, %22, %30;
fma.rn.f64 fd83, fd82, 0d3FEF329C0558E969, fd81;
sub.f64 fd84, %25, %27;
fma.rn.f64 fd85, fd84, 0d3FDBC4C04D71ABC1, fd83;
add.f64 fd86, fd85, fd79;
sub.f64 fd87, fd79, fd85;
mul.f64 fd88, fd34, 0d3FCC7B90E3024582;
sub.f64 fd89, %18, fd88;
mul.f64 fd90, fd36, 0d3FECD4BCA9CB5C71;
sub.f64 fd91, fd89, fd90;
fma.rn.f64 fd92, fd38, 0d3FE3F3A0E28BEDD1, fd91;
mul.f64 fd93, fd80, 0d3FEF329C0558E969;
mul.f64 fd94, fd82, 0d3FDBC4C04D71ABC1;
sub.f64 fd95, fd93, fd94;
mul.f64 fd96, fd84, 0d3FE904C37505DE4B;
sub.f64 fd97, fd95, fd96;
add.f64 fd98, fd97, fd92;
sub.f64 fd99, fd92, fd97;
mul.f64 fd100, fd34, 0d3FECD4BCA9CB5C71;
sub.f64 fd101, %18, fd100;
fma.rn.f64 fd102, fd36, 0d3FE3F3A0E28BEDD1, fd101;
mul.f64 fd103, fd38, 0d3FCC7B90E3024582;
sub.f64 fd104, fd102, fd103;
mul.f64 fd105, fd80, 0d3FDBC4C04D71ABC1;
mul.f64 fd106, fd82, 0d3FE904C37505DE4B;
sub.f64 fd107, fd105, fd106;
fma.rn.f64 fd108, fd84, 0d3FEF329C0558E969, fd107;
add.f64 fd109, fd108, fd104;
sub.f64 fd110, fd104, fd108;
mul.wide.u32 rd2, r4, 1402438301;
shr.u64 rd3, rd2, 36;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 49;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 5488, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd111, fd112}, [rd6];
mul.f64 fd115, fd86, fd112;
mul.f64 fd116, fd50, fd112;
mul.f64 fd117, fd111, fd86;
mul.f64 fd118, fd111, fd111;
mul.f64 fd119, fd112, fd112;
sub.f64 fd120, fd118, fd119;
mul.f64 fd121, fd112, fd111;
fma.rn.f64 fd122, fd112, fd111, fd121;
mul.f64 fd123, fd98, fd122;
mul.f64 fd124, fd62, fd122;
mul.f64 fd125, fd120, fd98;
mul.f64 fd126, fd111, fd120;
mul.f64 fd127, fd112, fd122;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd111, fd122;
fma.rn.f64 fd130, fd112, fd120, fd129;
mul.f64 fd131, fd109, fd130;
mul.f64 fd132, fd73, fd130;
mul.f64 fd133, fd128, fd109;
ld.global.v2.f64 {fd134, fd135}, [rd6+784];
mul.f64 fd138, fd110, fd135;
mul.f64 fd139, fd74, fd135;
mul.f64 fd140, fd134, fd110;
mul.f64 fd141, fd111, fd134;
mul.f64 fd142, fd112, fd135;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd111, fd135;
fma.rn.f64 fd145, fd112, fd134, fd144;
mul.f64 fd146, fd99, fd145;
mul.f64 fd147, fd63, fd145;
mul.f64 fd148, fd143, fd99;
mul.f64 fd149, fd111, fd143;
mul.f64 fd150, fd112, fd145;
sub.f64 fd151, fd149, fd150;
mul.f64 fd152, fd111, fd145;
fma.rn.f64 fd153, fd112, fd143, fd152;
mul.f64 fd154, fd87, fd153;
mul.f64 fd155, fd51, fd153;
mul.f64 fd156, fd151, fd87;
barrier.sync 0;
mad.lo.s32 r9, r7, 112, r8;
add.f64 fd157, fd38, fd37;
add.f64 fd158, fd33, fd32;
st.shared.v2.f64 [r9], {fd158, fd157};
fma.rn.f64 fd159, fd111, fd50, fd115;
sub.f64 fd160, fd117, fd116;
st.shared.v2.f64 [r9+16], {fd159, fd160};
fma.rn.f64 fd161, fd120, fd62, fd123;
sub.f64 fd162, fd125, fd124;
st.shared.v2.f64 [r9+32], {fd161, fd162};
sub.f64 fd163, fd133, fd132;
fma.rn.f64 fd164, fd128, fd73, fd131;
st.shared.v2.f64 [r9+48], {fd164, fd163};
fma.rn.f64 fd165, fd134, fd74, fd138;
sub.f64 fd166, fd140, fd139;
st.shared.v2.f64 [r9+64], {fd165, fd166};
fma.rn.f64 fd167, fd143, fd63, fd146;
sub.f64 fd168, fd148, fd147;
st.shared.v2.f64 [r9+80], {fd167, fd168};
sub.f64 fd169, fd156, fd155;
fma.rn.f64 fd170, fd151, fd51, fd154;
st.shared.v2.f64 [r9+96], {fd170, fd169};
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.v2.f64 {fd171, fd172}, [r10];
ld.shared.v2.f64 {fd175, fd176}, [r10+784];
ld.shared.v2.f64 {fd179, fd180}, [r10+1568];
ld.shared.v2.f64 {fd183, fd184}, [r10+2352];
ld.shared.v2.f64 {fd187, fd188}, [r10+3136];
ld.shared.v2.f64 {fd191, fd192}, [r10+3920];
ld.shared.v2.f64 {fd195, fd196}, [r10+4704];
add.f64 fd199, fd175, fd195;
add.f64 fd200, fd171, fd199;
add.f64 fd201, fd179, fd191;
add.f64 fd202, fd201, fd200;
add.f64 fd203, fd183, fd187;
add.f64 fd204, fd176, fd196;
add.f64 fd205, fd172, fd204;
add.f64 fd206, fd180, fd192;
add.f64 fd207, fd206, fd205;
add.f64 fd208, fd184, fd188;
fma.rn.f64 fd209, fd199, 0d3FE3F3A0E28BEDD1, fd171;
mul.f64 fd210, fd201, 0d3FCC7B90E3024582;
sub.f64 fd211, fd209, fd210;
mul.f64 fd212, fd203, 0d3FECD4BCA9CB5C71;
sub.f64 fd213, fd211, fd212;
sub.f64 fd214, fd176, fd196;
mul.f64 fd215, fd214, 0d3FE904C37505DE4B;
sub.f64 fd216, fd180, fd192;
fma.rn.f64 fd217, fd216, 0d3FEF329C0558E969, fd215;
sub.f64 fd218, fd184, fd188;
fma.rn.f64 fd219, fd218, 0d3FDBC4C04D71ABC1, fd217;
sub.f64 fd220, fd213, fd219;
add.f64 fd221, fd219, fd213;
mul.f64 fd222, fd199, 0d3FCC7B90E3024582;
sub.f64 fd223, fd171, fd222;
mul.f64 fd224, fd201, 0d3FECD4BCA9CB5C71;
sub.f64 fd225, fd223, fd224;
fma.rn.f64 fd226, fd203, 0d3FE3F3A0E28BEDD1, fd225;
mul.f64 fd227, fd214, 0d3FEF329C0558E969;
mul.f64 fd228, fd216, 0d3FDBC4C04D71ABC1;
sub.f64 fd229, fd227, fd228;
mul.f64 fd230, fd218, 0d3FE904C37505DE4B;
sub.f64 fd231, fd229, fd230;
sub.f64 fd232, fd226, fd231;
add.f64 fd233, fd231, fd226;
mul.f64 fd234, fd199, 0d3FECD4BCA9CB5C71;
sub.f64 fd235, fd171, fd234;
fma.rn.f64 fd236, fd201, 0d3FE3F3A0E28BEDD1, fd235;
mul.f64 fd237, fd203, 0d3FCC7B90E3024582;
sub.f64 fd238, fd236, fd237;
mul.f64 fd239, fd214, 0d3FDBC4C04D71ABC1;
mul.f64 fd240, fd216, 0d3FE904C37505DE4B;
sub.f64 fd241, fd239, fd240;
fma.rn.f64 fd242, fd218, 0d3FEF329C0558E969, fd241;
sub.f64 fd243, fd238, fd242;
add.f64 fd244, fd242, fd238;
fma.rn.f64 fd245, fd204, 0d3FE3F3A0E28BEDD1, fd172;
mul.f64 fd246, fd206, 0d3FCC7B90E3024582;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd208, 0d3FECD4BCA9CB5C71;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd175, fd195;
mul.f64 fd251, fd250, 0d3FE904C37505DE4B;
sub.f64 fd252, fd179, fd191;
fma.rn.f64 fd253, fd252, 0d3FEF329C0558E969, fd251;
sub.f64 fd254, fd183, fd187;
fma.rn.f64 fd255, fd254, 0d3FDBC4C04D71ABC1, fd253;
add.f64 fd256, fd255, fd249;
sub.f64 fd257, fd249, fd255;
mul.f64 fd258, fd204, 0d3FCC7B90E3024582;
sub.f64 fd259, fd172, fd258;
mul.f64 fd260, fd206, 0d3FECD4BCA9CB5C71;
sub.f64 fd261, fd259, fd260;
fma.rn.f64 fd262, fd208, 0d3FE3F3A0E28BEDD1, fd261;
mul.f64 fd263, fd250, 0d3FEF329C0558E969;
mul.f64 fd264, fd252, 0d3FDBC4C04D71ABC1;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd254, 0d3FE904C37505DE4B;
sub.f64 fd267, fd265, fd266;
add.f64 fd268, fd267, fd262;
sub.f64 fd269, fd262, fd267;
mul.f64 fd270, fd204, 0d3FECD4BCA9CB5C71;
sub.f64 fd271, fd172, fd270;
fma.rn.f64 fd272, fd206, 0d3FE3F3A0E28BEDD1, fd271;
mul.f64 fd273, fd208, 0d3FCC7B90E3024582;
sub.f64 fd274, fd272, fd273;
mul.f64 fd275, fd250, 0d3FDBC4C04D71ABC1;
mul.f64 fd276, fd252, 0d3FE904C37505DE4B;
sub.f64 fd277, fd275, fd276;
fma.rn.f64 fd278, fd254, 0d3FEF329C0558E969, fd277;
add.f64 fd279, fd278, fd274;
sub.f64 fd280, fd274, fd278;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd281, fd282}, [rd11];
mul.f64 fd285, fd256, fd282;
mul.f64 fd286, fd220, fd282;
mul.f64 fd287, fd281, fd256;
mul.f64 fd288, fd281, fd281;
mul.f64 fd289, fd282, fd282;
sub.f64 fd290, fd288, fd289;
mul.f64 fd291, fd282, fd281;
fma.rn.f64 fd292, fd282, fd281, fd291;
mul.f64 fd293, fd268, fd292;
mul.f64 fd294, fd232, fd292;
mul.f64 fd295, fd290, fd268;
mul.f64 fd296, fd281, fd290;
mul.f64 fd297, fd282, fd292;
sub.f64 fd298, fd296, fd297;
mul.f64 fd299, fd281, fd292;
fma.rn.f64 fd300, fd282, fd290, fd299;
mul.f64 fd301, fd279, fd300;
mul.f64 fd302, fd243, fd300;
mul.f64 fd303, fd298, fd279;
ld.global.v2.f64 {fd304, fd305}, [rd11+112];
mul.f64 fd308, fd280, fd305;
mul.f64 fd309, fd244, fd305;
mul.f64 fd310, fd304, fd280;
mul.f64 fd311, fd281, fd304;
mul.f64 fd312, fd282, fd305;
sub.f64 fd313, fd311, fd312;
mul.f64 fd314, fd281, fd305;
fma.rn.f64 fd315, fd282, fd304, fd314;
mul.f64 fd316, fd269, fd315;
mul.f64 fd317, fd233, fd315;
mul.f64 fd318, fd313, fd269;
mul.f64 fd319, fd281, fd313;
mul.f64 fd320, fd282, fd315;
sub.f64 fd321, fd319, fd320;
mul.f64 fd322, fd281, fd315;
fma.rn.f64 fd323, fd282, fd313, fd322;
mul.f64 fd324, fd257, fd323;
mul.f64 fd325, fd221, fd323;
mul.f64 fd326, fd321, fd257;
shl.b32 r18, r17, 4;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 784, r19;
add.f64 fd327, fd208, fd207;
add.f64 fd328, fd203, fd202;
st.shared.v2.f64 [r20], {fd328, fd327};
fma.rn.f64 fd329, fd281, fd220, fd285;
sub.f64 fd330, fd287, fd286;
st.shared.v2.f64 [r20+112], {fd329, fd330};
fma.rn.f64 fd331, fd290, fd232, fd293;
sub.f64 fd332, fd295, fd294;
st.shared.v2.f64 [r20+224], {fd331, fd332};
fma.rn.f64 fd333, fd298, fd243, fd301;
sub.f64 fd334, fd303, fd302;
st.shared.v2.f64 [r20+336], {fd333, fd334};
fma.rn.f64 fd335, fd304, fd244, fd308;
sub.f64 fd336, fd310, fd309;
st.shared.v2.f64 [r20+448], {fd335, fd336};
fma.rn.f64 fd337, fd313, fd233, fd316;
sub.f64 fd338, fd318, fd317;
st.shared.v2.f64 [r20+560], {fd337, fd338};
fma.rn.f64 fd339, fd321, fd221, fd324;
sub.f64 fd340, fd326, fd325;
st.shared.v2.f64 [r20+672], {fd339, fd340};
barrier.sync 0;
ld.shared.v2.f64 {fd341, fd342}, [r10];
ld.shared.v2.f64 {fd345, fd346}, [r10+784];
ld.shared.v2.f64 {fd349, fd350}, [r10+1568];
ld.shared.v2.f64 {fd353, fd354}, [r10+2352];
ld.shared.v2.f64 {fd357, fd358}, [r10+3136];
ld.shared.v2.f64 {fd361, fd362}, [r10+3920];
ld.shared.v2.f64 {fd365, fd366}, [r10+4704];
add.f64 fd369, fd345, fd365;
add.f64 fd370, fd341, fd369;
add.f64 fd371, fd349, fd361;
add.f64 fd372, fd371, fd370;
add.f64 fd373, fd353, fd357;
add.f64 fd374, fd346, fd366;
add.f64 fd375, fd342, fd374;
add.f64 fd376, fd350, fd362;
add.f64 fd377, fd376, fd375;
add.f64 fd378, fd354, fd358;
fma.rn.f64 fd379, fd369, 0d3FE3F3A0E28BEDD1, fd341;
mul.f64 fd380, fd371, 0d3FCC7B90E3024582;
sub.f64 fd381, fd379, fd380;
mul.f64 fd382, fd373, 0d3FECD4BCA9CB5C71;
sub.f64 fd383, fd381, fd382;
sub.f64 fd384, fd346, fd366;
mul.f64 fd385, fd384, 0d3FE904C37505DE4B;
sub.f64 fd386, fd350, fd362;
fma.rn.f64 fd387, fd386, 0d3FEF329C0558E969, fd385;
sub.f64 fd388, fd354, fd358;
fma.rn.f64 fd389, fd388, 0d3FDBC4C04D71ABC1, fd387;
mul.f64 fd390, fd369, 0d3FCC7B90E3024582;
sub.f64 fd391, fd341, fd390;
mul.f64 fd392, fd371, 0d3FECD4BCA9CB5C71;
sub.f64 fd393, fd391, fd392;
fma.rn.f64 fd394, fd373, 0d3FE3F3A0E28BEDD1, fd393;
mul.f64 fd395, fd384, 0d3FEF329C0558E969;
mul.f64 fd396, fd386, 0d3FDBC4C04D71ABC1;
sub.f64 fd397, fd395, fd396;
mul.f64 fd398, fd388, 0d3FE904C37505DE4B;
sub.f64 fd399, fd397, fd398;
mul.f64 fd400, fd369, 0d3FECD4BCA9CB5C71;
sub.f64 fd401, fd341, fd400;
fma.rn.f64 fd402, fd371, 0d3FE3F3A0E28BEDD1, fd401;
mul.f64 fd403, fd373, 0d3FCC7B90E3024582;
sub.f64 fd404, fd402, fd403;
mul.f64 fd405, fd384, 0d3FDBC4C04D71ABC1;
mul.f64 fd406, fd386, 0d3FE904C37505DE4B;
sub.f64 fd407, fd405, fd406;
fma.rn.f64 fd408, fd388, 0d3FEF329C0558E969, fd407;
fma.rn.f64 fd409, fd374, 0d3FE3F3A0E28BEDD1, fd342;
mul.f64 fd410, fd376, 0d3FCC7B90E3024582;
sub.f64 fd411, fd409, fd410;
mul.f64 fd412, fd378, 0d3FECD4BCA9CB5C71;
sub.f64 fd413, fd411, fd412;
sub.f64 fd414, fd345, fd365;
mul.f64 fd415, fd414, 0d3FE904C37505DE4B;
sub.f64 fd416, fd349, fd361;
fma.rn.f64 fd417, fd416, 0d3FEF329C0558E969, fd415;
sub.f64 fd418, fd353, fd357;
fma.rn.f64 fd419, fd418, 0d3FDBC4C04D71ABC1, fd417;
mul.f64 fd420, fd374, 0d3FCC7B90E3024582;
sub.f64 fd421, fd342, fd420;
mul.f64 fd422, fd376, 0d3FECD4BCA9CB5C71;
sub.f64 fd423, fd421, fd422;
fma.rn.f64 fd424, fd378, 0d3FE3F3A0E28BEDD1, fd423;
mul.f64 fd425, fd414, 0d3FEF329C0558E969;
mul.f64 fd426, fd416, 0d3FDBC4C04D71ABC1;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd418, 0d3FE904C37505DE4B;
sub.f64 fd429, fd427, fd428;
mul.f64 fd430, fd374, 0d3FECD4BCA9CB5C71;
sub.f64 fd431, fd342, fd430;
fma.rn.f64 fd432, fd376, 0d3FE3F3A0E28BEDD1, fd431;
mul.f64 fd433, fd378, 0d3FCC7B90E3024582;
sub.f64 fd434, fd432, fd433;
mul.f64 fd435, fd414, 0d3FDBC4C04D71ABC1;
mul.f64 fd436, fd416, 0d3FE904C37505DE4B;
sub.f64 fd437, fd435, fd436;
fma.rn.f64 fd438, fd418, 0d3FEF329C0558E969, fd437;
add.f64 %1, fd378, fd377;
add.f64 %0, fd373, fd372;
add.f64 %3, fd419, fd413;
sub.f64 %2, fd383, fd389;
add.f64 %5, fd429, fd424;
sub.f64 %4, fd394, fd399;
add.f64 %7, fd438, fd434;
sub.f64 %6, fd404, fd408;
sub.f64 %9, fd434, fd438;
add.f64 %8, fd408, fd404;
sub.f64 %11, fd424, fd429;
add.f64 %10, fd399, fd394;
sub.f64 %13, fd413, fd419;
add.f64 %12, fd389, fd383;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<721, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<425>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 2744, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %19, %33;
add.f64 fd30, %17, fd29;
add.f64 fd31, %22, %30;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %25, %27;
add.f64 fd34, fd33, fd32;
add.f64 fd35, %21, %34;
add.f64 fd36, %18, fd35;
add.f64 fd37, %24, %32;
add.f64 fd38, fd37, fd36;
add.f64 fd39, %26, %29;
add.f64 fd40, fd39, fd38;
fma.rn.f64 fd41, fd29, 0d3FE3F3A0E28BEDD1, %17;
mul.f64 fd42, fd31, 0d3FCC7B90E3024582;
sub.f64 fd43, fd41, fd42;
mul.f64 fd44, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd45, fd43, fd44;
sub.f64 fd46, %21, %34;
mul.f64 fd47, fd46, 0d3FE904C37505DE4B;
sub.f64 fd48, %24, %32;
fma.rn.f64 fd49, fd48, 0d3FEF329C0558E969, fd47;
sub.f64 fd50, %26, %29;
fma.rn.f64 fd51, fd50, 0d3FDBC4C04D71ABC1, fd49;
sub.f64 fd52, fd45, fd51;
add.f64 fd53, fd51, fd45;
mul.f64 fd54, fd29, 0d3FCC7B90E3024582;
sub.f64 fd55, %17, fd54;
mul.f64 fd56, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd57, fd55, fd56;
fma.rn.f64 fd58, fd33, 0d3FE3F3A0E28BEDD1, fd57;
mul.f64 fd59, fd46, 0d3FEF329C0558E969;
mul.f64 fd60, fd48, 0d3FDBC4C04D71ABC1;
sub.f64 fd61, fd59, fd60;
mul.f64 fd62, fd50, 0d3FE904C37505DE4B;
sub.f64 fd63, fd61, fd62;
sub.f64 fd64, fd58, fd63;
add.f64 fd65, fd63, fd58;
mul.f64 fd66, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd67, %17, fd66;
fma.rn.f64 fd68, fd31, 0d3FE3F3A0E28BEDD1, fd67;
mul.f64 fd69, fd33, 0d3FCC7B90E3024582;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd46, 0d3FDBC4C04D71ABC1;
mul.f64 fd72, fd48, 0d3FE904C37505DE4B;
sub.f64 fd73, fd71, fd72;
fma.rn.f64 fd74, fd50, 0d3FEF329C0558E969, fd73;
sub.f64 fd75, fd70, fd74;
add.f64 fd76, fd74, fd70;
fma.rn.f64 fd77, fd35, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd78, fd37, 0d3FCC7B90E3024582;
sub.f64 fd79, fd77, fd78;
mul.f64 fd80, fd39, 0d3FECD4BCA9CB5C71;
sub.f64 fd81, fd79, fd80;
sub.f64 fd82, %19, %33;
mul.f64 fd83, fd82, 0d3FE904C37505DE4B;
sub.f64 fd84, %22, %30;
fma.rn.f64 fd85, fd84, 0d3FEF329C0558E969, fd83;
sub.f64 fd86, %25, %27;
fma.rn.f64 fd87, fd86, 0d3FDBC4C04D71ABC1, fd85;
add.f64 fd88, fd87, fd81;
sub.f64 fd89, fd81, fd87;
mul.f64 fd90, fd35, 0d3FCC7B90E3024582;
sub.f64 fd91, %18, fd90;
mul.f64 fd92, fd37, 0d3FECD4BCA9CB5C71;
sub.f64 fd93, fd91, fd92;
fma.rn.f64 fd94, fd39, 0d3FE3F3A0E28BEDD1, fd93;
mul.f64 fd95, fd82, 0d3FEF329C0558E969;
mul.f64 fd96, fd84, 0d3FDBC4C04D71ABC1;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd86, 0d3FE904C37505DE4B;
sub.f64 fd99, fd97, fd98;
add.f64 fd100, fd99, fd94;
sub.f64 fd101, fd94, fd99;
mul.f64 fd102, fd35, 0d3FECD4BCA9CB5C71;
sub.f64 fd103, %18, fd102;
fma.rn.f64 fd104, fd37, 0d3FE3F3A0E28BEDD1, fd103;
mul.f64 fd105, fd39, 0d3FCC7B90E3024582;
sub.f64 fd106, fd104, fd105;
mul.f64 fd107, fd82, 0d3FDBC4C04D71ABC1;
mul.f64 fd108, fd84, 0d3FE904C37505DE4B;
sub.f64 fd109, fd107, fd108;
fma.rn.f64 fd110, fd86, 0d3FEF329C0558E969, fd109;
add.f64 fd111, fd110, fd106;
sub.f64 fd112, fd106, fd110;
mul.wide.u32 rd2, r4, 1402438301;
shr.u64 rd3, rd2, 36;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 49;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd113, fd114}, [rd6];
mul.f64 fd117, fd88, fd114;
fma.rn.f64 fd118, fd113, fd52, fd117;
mul.f64 fd119, fd52, fd114;
mul.f64 fd120, fd113, fd88;
sub.f64 fd121, fd120, fd119;
mul.f64 fd122, fd113, fd113;
mul.f64 fd123, fd114, fd114;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd114, fd113;
fma.rn.f64 fd126, fd114, fd113, fd125;
mul.f64 fd127, fd100, fd126;
fma.rn.f64 fd128, fd124, fd64, fd127;
mul.f64 fd129, fd64, fd126;
mul.f64 fd130, fd124, fd100;
sub.f64 fd131, fd130, fd129;
mul.f64 fd132, fd113, fd124;
mul.f64 fd133, fd114, fd126;
sub.f64 fd134, fd132, fd133;
mul.f64 fd135, fd113, fd126;
fma.rn.f64 fd136, fd114, fd124, fd135;
mul.f64 fd137, fd111, fd136;
fma.rn.f64 fd138, fd134, fd75, fd137;
mul.f64 fd139, fd75, fd136;
mul.f64 fd140, fd134, fd111;
sub.f64 fd141, fd140, fd139;
ld.global.v2.f64 {fd142, fd143}, [rd6+784];
mul.f64 fd146, fd112, fd143;
fma.rn.f64 fd147, fd142, fd76, fd146;
mul.f64 fd148, fd76, fd143;
mul.f64 fd149, fd142, fd112;
sub.f64 fd150, fd149, fd148;
mul.f64 fd151, fd113, fd142;
mul.f64 fd152, fd114, fd143;
sub.f64 fd153, fd151, fd152;
mul.f64 fd154, fd113, fd143;
fma.rn.f64 fd155, fd114, fd142, fd154;
mul.f64 fd156, fd101, fd155;
fma.rn.f64 fd157, fd153, fd65, fd156;
mul.f64 fd158, fd65, fd155;
mul.f64 fd159, fd153, fd101;
sub.f64 fd160, fd159, fd158;
mul.f64 fd161, fd113, fd153;
mul.f64 fd162, fd114, fd155;
sub.f64 fd163, fd161, fd162;
mul.f64 fd164, fd113, fd155;
fma.rn.f64 fd165, fd114, fd153, fd164;
mul.f64 fd166, fd89, fd165;
fma.rn.f64 fd167, fd163, fd53, fd166;
mul.f64 fd168, fd53, fd165;
mul.f64 fd169, fd163, fd89;
sub.f64 fd170, fd169, fd168;
mad.lo.s32 r8, r5, 2744, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 56, r8;
st.shared.f64 [r9], fd34;
st.shared.f64 [r9+8], fd118;
st.shared.f64 [r9+16], fd128;
st.shared.f64 [r9+24], fd138;
st.shared.f64 [r9+32], fd147;
st.shared.f64 [r9+40], fd157;
st.shared.f64 [r9+48], fd167;
barrier.sync 0;
mad.lo.s32 r10, r7, -48, r9;
ld.shared.f64 fd171, [r10];
ld.shared.f64 fd172, [r10+392];
ld.shared.f64 fd173, [r10+784];
ld.shared.f64 fd174, [r10+1176];
ld.shared.f64 fd175, [r10+1568];
ld.shared.f64 fd176, [r10+1960];
ld.shared.f64 fd177, [r10+2352];
barrier.sync 0;
st.shared.f64 [r9], fd40;
st.shared.f64 [r9+8], fd121;
st.shared.f64 [r9+16], fd131;
st.shared.f64 [r9+24], fd141;
st.shared.f64 [r9+32], fd150;
st.shared.f64 [r9+40], fd160;
st.shared.f64 [r9+48], fd170;
barrier.sync 0;
ld.shared.f64 fd178, [r10];
ld.shared.f64 fd179, [r10+392];
ld.shared.f64 fd180, [r10+784];
ld.shared.f64 fd181, [r10+1176];
ld.shared.f64 fd182, [r10+1568];
ld.shared.f64 fd183, [r10+1960];
ld.shared.f64 fd184, [r10+2352];
add.f64 fd185, fd172, fd177;
add.f64 fd186, fd171, fd185;
add.f64 fd187, fd173, fd176;
add.f64 fd188, fd187, fd186;
add.f64 fd189, fd174, fd175;
add.f64 fd190, fd189, fd188;
add.f64 fd191, fd179, fd184;
add.f64 fd192, fd178, fd191;
add.f64 fd193, fd180, fd183;
add.f64 fd194, fd193, fd192;
add.f64 fd195, fd181, fd182;
add.f64 fd196, fd195, fd194;
fma.rn.f64 fd197, fd185, 0d3FE3F3A0E28BEDD1, fd171;
mul.f64 fd198, fd187, 0d3FCC7B90E3024582;
sub.f64 fd199, fd197, fd198;
mul.f64 fd200, fd189, 0d3FECD4BCA9CB5C71;
sub.f64 fd201, fd199, fd200;
sub.f64 fd202, fd179, fd184;
mul.f64 fd203, fd202, 0d3FE904C37505DE4B;
sub.f64 fd204, fd180, fd183;
fma.rn.f64 fd205, fd204, 0d3FEF329C0558E969, fd203;
sub.f64 fd206, fd181, fd182;
fma.rn.f64 fd207, fd206, 0d3FDBC4C04D71ABC1, fd205;
sub.f64 fd208, fd201, fd207;
add.f64 fd209, fd207, fd201;
mul.f64 fd210, fd185, 0d3FCC7B90E3024582;
sub.f64 fd211, fd171, fd210;
mul.f64 fd212, fd187, 0d3FECD4BCA9CB5C71;
sub.f64 fd213, fd211, fd212;
fma.rn.f64 fd214, fd189, 0d3FE3F3A0E28BEDD1, fd213;
mul.f64 fd215, fd202, 0d3FEF329C0558E969;
mul.f64 fd216, fd204, 0d3FDBC4C04D71ABC1;
sub.f64 fd217, fd215, fd216;
mul.f64 fd218, fd206, 0d3FE904C37505DE4B;
sub.f64 fd219, fd217, fd218;
sub.f64 fd220, fd214, fd219;
add.f64 fd221, fd219, fd214;
mul.f64 fd222, fd185, 0d3FECD4BCA9CB5C71;
sub.f64 fd223, fd171, fd222;
fma.rn.f64 fd224, fd187, 0d3FE3F3A0E28BEDD1, fd223;
mul.f64 fd225, fd189, 0d3FCC7B90E3024582;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd202, 0d3FDBC4C04D71ABC1;
mul.f64 fd228, fd204, 0d3FE904C37505DE4B;
sub.f64 fd229, fd227, fd228;
fma.rn.f64 fd230, fd206, 0d3FEF329C0558E969, fd229;
sub.f64 fd231, fd226, fd230;
add.f64 fd232, fd230, fd226;
fma.rn.f64 fd233, fd191, 0d3FE3F3A0E28BEDD1, fd178;
mul.f64 fd234, fd193, 0d3FCC7B90E3024582;
sub.f64 fd235, fd233, fd234;
mul.f64 fd236, fd195, 0d3FECD4BCA9CB5C71;
sub.f64 fd237, fd235, fd236;
sub.f64 fd238, fd172, fd177;
mul.f64 fd239, fd238, 0d3FE904C37505DE4B;
sub.f64 fd240, fd173, fd176;
fma.rn.f64 fd241, fd240, 0d3FEF329C0558E969, fd239;
sub.f64 fd242, fd174, fd175;
fma.rn.f64 fd243, fd242, 0d3FDBC4C04D71ABC1, fd241;
add.f64 fd244, fd243, fd237;
sub.f64 fd245, fd237, fd243;
mul.f64 fd246, fd191, 0d3FCC7B90E3024582;
sub.f64 fd247, fd178, fd246;
mul.f64 fd248, fd193, 0d3FECD4BCA9CB5C71;
sub.f64 fd249, fd247, fd248;
fma.rn.f64 fd250, fd195, 0d3FE3F3A0E28BEDD1, fd249;
mul.f64 fd251, fd238, 0d3FEF329C0558E969;
mul.f64 fd252, fd240, 0d3FDBC4C04D71ABC1;
sub.f64 fd253, fd251, fd252;
mul.f64 fd254, fd242, 0d3FE904C37505DE4B;
sub.f64 fd255, fd253, fd254;
add.f64 fd256, fd255, fd250;
sub.f64 fd257, fd250, fd255;
mul.f64 fd258, fd191, 0d3FECD4BCA9CB5C71;
sub.f64 fd259, fd178, fd258;
fma.rn.f64 fd260, fd193, 0d3FE3F3A0E28BEDD1, fd259;
mul.f64 fd261, fd195, 0d3FCC7B90E3024582;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd238, 0d3FDBC4C04D71ABC1;
mul.f64 fd264, fd240, 0d3FE904C37505DE4B;
sub.f64 fd265, fd263, fd264;
fma.rn.f64 fd266, fd242, 0d3FEF329C0558E969, fd265;
add.f64 fd267, fd266, fd262;
sub.f64 fd268, fd262, fd266;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd269, fd270}, [rd11];
mul.f64 fd273, fd244, fd270;
fma.rn.f64 fd274, fd269, fd208, fd273;
mul.f64 fd275, fd208, fd270;
mul.f64 fd276, fd269, fd244;
sub.f64 fd277, fd276, fd275;
mul.f64 fd278, fd269, fd269;
mul.f64 fd279, fd270, fd270;
sub.f64 fd280, fd278, fd279;
mul.f64 fd281, fd270, fd269;
fma.rn.f64 fd282, fd270, fd269, fd281;
mul.f64 fd283, fd256, fd282;
fma.rn.f64 fd284, fd280, fd220, fd283;
mul.f64 fd285, fd220, fd282;
mul.f64 fd286, fd280, fd256;
sub.f64 fd287, fd286, fd285;
mul.f64 fd288, fd269, fd280;
mul.f64 fd289, fd270, fd282;
sub.f64 fd290, fd288, fd289;
mul.f64 fd291, fd269, fd282;
fma.rn.f64 fd292, fd270, fd280, fd291;
mul.f64 fd293, fd267, fd292;
fma.rn.f64 fd294, fd290, fd231, fd293;
mul.f64 fd295, fd231, fd292;
mul.f64 fd296, fd290, fd267;
sub.f64 fd297, fd296, fd295;
ld.global.v2.f64 {fd298, fd299}, [rd11+112];
mul.f64 fd302, fd268, fd299;
fma.rn.f64 fd303, fd298, fd232, fd302;
mul.f64 fd304, fd232, fd299;
mul.f64 fd305, fd298, fd268;
sub.f64 fd306, fd305, fd304;
mul.f64 fd307, fd269, fd298;
mul.f64 fd308, fd270, fd299;
sub.f64 fd309, fd307, fd308;
mul.f64 fd310, fd269, fd299;
fma.rn.f64 fd311, fd270, fd298, fd310;
mul.f64 fd312, fd257, fd311;
fma.rn.f64 fd313, fd309, fd221, fd312;
mul.f64 fd314, fd221, fd311;
mul.f64 fd315, fd309, fd257;
sub.f64 fd316, fd315, fd314;
mul.f64 fd317, fd269, fd309;
mul.f64 fd318, fd270, fd311;
sub.f64 fd319, fd317, fd318;
mul.f64 fd320, fd269, fd311;
fma.rn.f64 fd321, fd270, fd309, fd320;
mul.f64 fd322, fd245, fd321;
fma.rn.f64 fd323, fd319, fd209, fd322;
mul.f64 fd324, fd209, fd321;
mul.f64 fd325, fd319, fd245;
sub.f64 fd326, fd325, fd324;
shl.b32 r18, r17, 3;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 392, r19;
st.shared.f64 [r20], fd190;
st.shared.f64 [r20+56], fd274;
st.shared.f64 [r20+112], fd284;
st.shared.f64 [r20+168], fd294;
st.shared.f64 [r20+224], fd303;
st.shared.f64 [r20+280], fd313;
st.shared.f64 [r20+336], fd323;
barrier.sync 0;
ld.shared.f64 fd327, [r10];
ld.shared.f64 fd328, [r10+392];
ld.shared.f64 fd329, [r10+784];
ld.shared.f64 fd330, [r10+1176];
ld.shared.f64 fd331, [r10+1568];
ld.shared.f64 fd332, [r10+1960];
ld.shared.f64 fd333, [r10+2352];
barrier.sync 0;
st.shared.f64 [r20], fd196;
st.shared.f64 [r20+56], fd277;
st.shared.f64 [r20+112], fd287;
st.shared.f64 [r20+168], fd297;
st.shared.f64 [r20+224], fd306;
st.shared.f64 [r20+280], fd316;
st.shared.f64 [r20+336], fd326;
barrier.sync 0;
ld.shared.f64 fd334, [r10];
ld.shared.f64 fd335, [r10+392];
ld.shared.f64 fd336, [r10+784];
ld.shared.f64 fd337, [r10+1176];
ld.shared.f64 fd338, [r10+1568];
ld.shared.f64 fd339, [r10+1960];
ld.shared.f64 fd340, [r10+2352];
add.f64 fd341, fd328, fd333;
add.f64 fd342, fd327, fd341;
add.f64 fd343, fd329, fd332;
add.f64 fd344, fd343, fd342;
add.f64 fd345, fd330, fd331;
add.f64 fd346, fd335, fd340;
add.f64 fd347, fd334, fd346;
add.f64 fd348, fd336, fd339;
add.f64 fd349, fd348, fd347;
add.f64 fd350, fd337, fd338;
fma.rn.f64 fd351, fd341, 0d3FE3F3A0E28BEDD1, fd327;
mul.f64 fd352, fd343, 0d3FCC7B90E3024582;
sub.f64 fd353, fd351, fd352;
mul.f64 fd354, fd345, 0d3FECD4BCA9CB5C71;
sub.f64 fd355, fd353, fd354;
sub.f64 fd356, fd335, fd340;
mul.f64 fd357, fd356, 0d3FE904C37505DE4B;
sub.f64 fd358, fd336, fd339;
fma.rn.f64 fd359, fd358, 0d3FEF329C0558E969, fd357;
sub.f64 fd360, fd337, fd338;
fma.rn.f64 fd361, fd360, 0d3FDBC4C04D71ABC1, fd359;
mul.f64 fd362, fd341, 0d3FCC7B90E3024582;
sub.f64 fd363, fd327, fd362;
mul.f64 fd364, fd343, 0d3FECD4BCA9CB5C71;
sub.f64 fd365, fd363, fd364;
fma.rn.f64 fd366, fd345, 0d3FE3F3A0E28BEDD1, fd365;
mul.f64 fd367, fd356, 0d3FEF329C0558E969;
mul.f64 fd368, fd358, 0d3FDBC4C04D71ABC1;
sub.f64 fd369, fd367, fd368;
mul.f64 fd370, fd360, 0d3FE904C37505DE4B;
sub.f64 fd371, fd369, fd370;
mul.f64 fd372, fd341, 0d3FECD4BCA9CB5C71;
sub.f64 fd373, fd327, fd372;
fma.rn.f64 fd374, fd343, 0d3FE3F3A0E28BEDD1, fd373;
mul.f64 fd375, fd345, 0d3FCC7B90E3024582;
sub.f64 fd376, fd374, fd375;
mul.f64 fd377, fd356, 0d3FDBC4C04D71ABC1;
mul.f64 fd378, fd358, 0d3FE904C37505DE4B;
sub.f64 fd379, fd377, fd378;
fma.rn.f64 fd380, fd360, 0d3FEF329C0558E969, fd379;
fma.rn.f64 fd381, fd346, 0d3FE3F3A0E28BEDD1, fd334;
mul.f64 fd382, fd348, 0d3FCC7B90E3024582;
sub.f64 fd383, fd381, fd382;
mul.f64 fd384, fd350, 0d3FECD4BCA9CB5C71;
sub.f64 fd385, fd383, fd384;
sub.f64 fd386, fd328, fd333;
mul.f64 fd387, fd386, 0d3FE904C37505DE4B;
sub.f64 fd388, fd329, fd332;
fma.rn.f64 fd389, fd388, 0d3FEF329C0558E969, fd387;
sub.f64 fd390, fd330, fd331;
fma.rn.f64 fd391, fd390, 0d3FDBC4C04D71ABC1, fd389;
mul.f64 fd392, fd346, 0d3FCC7B90E3024582;
sub.f64 fd393, fd334, fd392;
mul.f64 fd394, fd348, 0d3FECD4BCA9CB5C71;
sub.f64 fd395, fd393, fd394;
fma.rn.f64 fd396, fd350, 0d3FE3F3A0E28BEDD1, fd395;
mul.f64 fd397, fd386, 0d3FEF329C0558E969;
mul.f64 fd398, fd388, 0d3FDBC4C04D71ABC1;
sub.f64 fd399, fd397, fd398;
mul.f64 fd400, fd390, 0d3FE904C37505DE4B;
sub.f64 fd401, fd399, fd400;
mul.f64 fd402, fd346, 0d3FECD4BCA9CB5C71;
sub.f64 fd403, fd334, fd402;
fma.rn.f64 fd404, fd348, 0d3FE3F3A0E28BEDD1, fd403;
mul.f64 fd405, fd350, 0d3FCC7B90E3024582;
sub.f64 fd406, fd404, fd405;
mul.f64 fd407, fd386, 0d3FDBC4C04D71ABC1;
mul.f64 fd408, fd388, 0d3FE904C37505DE4B;
sub.f64 fd409, fd407, fd408;
fma.rn.f64 fd410, fd390, 0d3FEF329C0558E969, fd409;
add.f64 %0, fd345, fd344;
add.f64 %1, fd350, fd349;
add.f64 %3, fd391, fd385;
sub.f64 %2, fd355, fd361;
sub.f64 %4, fd366, fd371;
add.f64 %5, fd401, fd396;
sub.f64 %6, fd376, fd380;
add.f64 %7, fd410, fd406;
add.f64 %8, fd380, fd376;
sub.f64 %9, fd406, fd410;
add.f64 %10, fd371, fd366;
sub.f64 %11, fd396, fd401;
sub.f64 %13, fd385, fd391;
add.f64 %12, fd361, fd355;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};


#endif
