#ifndef CUFFTDX_FFT_32_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_32_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<32, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<612>;
.reg .b64 rd<2>;
add.f32 f129, %64, %106;
add.f32 f130, %65, %108;
sub.f32 f131, %64, %106;
sub.f32 f132, %65, %108;
add.f32 f133, %85, %128;
add.f32 f134, %87, %129;
sub.f32 f135, %85, %128;
sub.f32 f136, %87, %129;
add.f32 f137, f129, f133;
add.f32 f138, f130, f134;
sub.f32 f139, f129, f133;
sub.f32 f140, f130, f134;
add.f32 f141, f131, f136;
sub.f32 f142, f132, f135;
sub.f32 f143, f131, f136;
add.f32 f144, f132, f135;
add.f32 f145, %74, %117;
add.f32 f146, %76, %119;
sub.f32 f147, %74, %117;
sub.f32 f148, %76, %119;
add.f32 f149, %96, %138;
add.f32 f150, %97, %140;
sub.f32 f151, %96, %138;
sub.f32 f152, %97, %140;
add.f32 f153, f145, f149;
add.f32 f154, f146, f150;
sub.f32 f155, f145, f149;
sub.f32 f156, f146, f150;
add.f32 f157, f147, f152;
sub.f32 f158, f148, f151;
sub.f32 f159, f147, f152;
add.f32 f160, f148, f151;
mul.f32 f161, f157, 0f3F3504F3;
mul.f32 f162, f158, 0fBF3504F3;
sub.f32 f163, f161, f162;
mul.f32 f164, f158, 0f3F3504F3;
fma.rn.f32 f165, f157, 0fBF3504F3, f164;
mul.f32 f166, f159, 0fBF3504F3;
mul.f32 f167, f160, 0fBF3504F3;
sub.f32 f168, f166, f167;
add.f32 f169, f166, f167;
add.f32 f170, f137, f153;
add.f32 f171, f138, f154;
sub.f32 f172, f137, f153;
sub.f32 f173, f138, f154;
add.f32 f174, f141, f163;
add.f32 f175, f142, f165;
sub.f32 f176, f141, f163;
sub.f32 f177, f142, f165;
add.f32 f178, f139, f156;
sub.f32 f179, f140, f155;
sub.f32 f180, f139, f156;
add.f32 f181, f140, f155;
add.f32 f182, f143, f168;
add.f32 f183, f144, f169;
sub.f32 f184, f143, f168;
sub.f32 f185, f144, f169;
add.f32 f186, %69, %112;
add.f32 f187, %71, %113;
sub.f32 f188, %69, %112;
sub.f32 f189, %71, %113;
add.f32 f190, %90, %133;
add.f32 f191, %92, %135;
sub.f32 f192, %90, %133;
sub.f32 f193, %92, %135;
add.f32 f194, f186, f190;
add.f32 f195, f187, f191;
sub.f32 f196, f186, f190;
sub.f32 f197, f187, f191;
add.f32 f198, f188, f193;
sub.f32 f199, f189, f192;
sub.f32 f200, f188, f193;
add.f32 f201, f189, f192;
add.f32 f202, %80, %122;
add.f32 f203, %81, %124;
sub.f32 f204, %80, %122;
sub.f32 f205, %81, %124;
add.f32 f206, %101, %144;
add.f32 f207, %103, %145;
sub.f32 f208, %101, %144;
sub.f32 f209, %103, %145;
add.f32 f210, f202, f206;
add.f32 f211, f203, f207;
sub.f32 f212, f202, f206;
sub.f32 f213, f203, f207;
add.f32 f214, f204, f209;
sub.f32 f215, f205, f208;
sub.f32 f216, f204, f209;
add.f32 f217, f205, f208;
mul.f32 f218, f214, 0f3F3504F3;
mul.f32 f219, f215, 0fBF3504F3;
sub.f32 f220, f218, f219;
mul.f32 f221, f215, 0f3F3504F3;
fma.rn.f32 f222, f214, 0fBF3504F3, f221;
mul.f32 f223, f216, 0fBF3504F3;
mul.f32 f224, f217, 0fBF3504F3;
sub.f32 f225, f223, f224;
add.f32 f226, f223, f224;
add.f32 f227, f194, f210;
add.f32 f228, f195, f211;
sub.f32 f229, f194, f210;
sub.f32 f230, f195, f211;
add.f32 f231, f198, f220;
add.f32 f232, f199, f222;
sub.f32 f233, f198, f220;
sub.f32 f234, f199, f222;
add.f32 f235, f196, f213;
sub.f32 f236, f197, f212;
sub.f32 f237, f196, f213;
add.f32 f238, f197, f212;
add.f32 f239, f200, f225;
add.f32 f240, f201, f226;
sub.f32 f241, f200, f225;
sub.f32 f242, f201, f226;
mul.f32 f243, f231, 0f3F6C835E;
mul.f32 f244, f232, 0fBEC3EF15;
sub.f32 f245, f243, f244;
mul.f32 f246, f232, 0f3F6C835E;
fma.rn.f32 f247, f231, 0fBEC3EF15, f246;
mul.f32 f248, f235, 0f3F3504F3;
mul.f32 f249, f236, 0fBF3504F3;
sub.f32 f250, f248, f249;
mul.f32 f251, f236, 0f3F3504F3;
fma.rn.f32 f252, f235, 0fBF3504F3, f251;
mul.f32 f253, f239, 0f3EC3EF15;
mul.f32 f254, f240, 0fBF6C835E;
sub.f32 f255, f253, f254;
mul.f32 f256, f240, 0f3EC3EF15;
fma.rn.f32 f257, f239, 0fBF6C835E, f256;
mul.f32 f258, f233, 0fBEC3EF15;
mul.f32 f259, f234, 0fBF6C835E;
sub.f32 f260, f258, f259;
mul.f32 f261, f234, 0fBEC3EF15;
fma.rn.f32 f262, f233, 0fBF6C835E, f261;
mul.f32 f263, f237, 0fBF3504F3;
mul.f32 f264, f238, 0fBF3504F3;
sub.f32 f265, f263, f264;
add.f32 f266, f263, f264;
mul.f32 f267, f241, 0fBF6C835E;
mul.f32 f268, f242, 0fBEC3EF15;
sub.f32 f269, f267, f268;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0fBEC3EF15, f270;
add.f32 f272, f170, f227;
add.f32 f273, f171, f228;
sub.f32 f274, f170, f227;
sub.f32 f275, f171, f228;
add.f32 f276, f174, f245;
add.f32 f277, f175, f247;
sub.f32 f278, f174, f245;
sub.f32 f279, f175, f247;
add.f32 f280, f178, f250;
add.f32 f281, f179, f252;
sub.f32 f282, f178, f250;
sub.f32 f283, f179, f252;
add.f32 f284, f182, f255;
add.f32 f285, f183, f257;
sub.f32 f286, f182, f255;
sub.f32 f287, f183, f257;
add.f32 f288, f172, f230;
sub.f32 f289, f173, f229;
sub.f32 f290, f172, f230;
add.f32 f291, f173, f229;
add.f32 f292, f176, f260;
add.f32 f293, f177, f262;
sub.f32 f294, f176, f260;
sub.f32 f295, f177, f262;
add.f32 f296, f180, f265;
add.f32 f297, f181, f266;
sub.f32 f298, f180, f265;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
add.f32 f301, f185, f271;
sub.f32 f302, f184, f269;
sub.f32 f303, f185, f271;
add.f32 f304, %66, %109;
add.f32 f305, %68, %111;
sub.f32 f306, %66, %109;
sub.f32 f307, %68, %111;
add.f32 f308, %88, %130;
add.f32 f309, %89, %132;
sub.f32 f310, %88, %130;
sub.f32 f311, %89, %132;
add.f32 f312, f304, f308;
add.f32 f313, f305, f309;
sub.f32 f314, f304, f308;
sub.f32 f315, f305, f309;
add.f32 f316, f306, f311;
sub.f32 f317, f307, f310;
sub.f32 f318, f306, f311;
add.f32 f319, f307, f310;
add.f32 f320, %77, %120;
add.f32 f321, %79, %121;
sub.f32 f322, %77, %120;
sub.f32 f323, %79, %121;
add.f32 f324, %98, %141;
add.f32 f325, %100, %143;
sub.f32 f326, %98, %141;
sub.f32 f327, %100, %143;
add.f32 f328, f320, f324;
add.f32 f329, f321, f325;
sub.f32 f330, f320, f324;
sub.f32 f331, f321, f325;
add.f32 f332, f322, f327;
sub.f32 f333, f323, f326;
sub.f32 f334, f322, f327;
add.f32 f335, f323, f326;
mul.f32 f336, f332, 0f3F3504F3;
mul.f32 f337, f333, 0fBF3504F3;
sub.f32 f338, f336, f337;
mul.f32 f339, f333, 0f3F3504F3;
fma.rn.f32 f340, f332, 0fBF3504F3, f339;
mul.f32 f341, f334, 0fBF3504F3;
mul.f32 f342, f335, 0fBF3504F3;
sub.f32 f343, f341, f342;
add.f32 f344, f341, f342;
add.f32 f345, f312, f328;
add.f32 f346, f313, f329;
sub.f32 f347, f312, f328;
sub.f32 f348, f313, f329;
add.f32 f349, f316, f338;
add.f32 f350, f317, f340;
sub.f32 f351, f316, f338;
sub.f32 f352, f317, f340;
add.f32 f353, f314, f331;
sub.f32 f354, f315, f330;
sub.f32 f355, f314, f331;
add.f32 f356, f315, f330;
add.f32 f357, f318, f343;
add.f32 f358, f319, f344;
sub.f32 f359, f318, f343;
sub.f32 f360, f319, f344;
add.f32 f361, %72, %114;
add.f32 f362, %73, %116;
sub.f32 f363, %72, %114;
sub.f32 f364, %73, %116;
add.f32 f365, %93, %136;
add.f32 f366, %95, %137;
sub.f32 f367, %93, %136;
sub.f32 f368, %95, %137;
add.f32 f369, f361, f365;
add.f32 f370, f362, f366;
sub.f32 f371, f361, f365;
sub.f32 f372, f362, f366;
add.f32 f373, f363, f368;
sub.f32 f374, f364, f367;
sub.f32 f375, f363, f368;
add.f32 f376, f364, f367;
add.f32 f377, %82, %125;
add.f32 f378, %84, %127;
sub.f32 f379, %82, %125;
sub.f32 f380, %84, %127;
add.f32 f381, %104, %146;
add.f32 f382, %105, %147;
sub.f32 f383, %104, %146;
sub.f32 f384, %105, %147;
add.f32 f385, f377, f381;
add.f32 f386, f378, f382;
sub.f32 f387, f377, f381;
sub.f32 f388, f378, f382;
add.f32 f389, f379, f384;
sub.f32 f390, f380, f383;
sub.f32 f391, f379, f384;
add.f32 f392, f380, f383;
mul.f32 f393, f389, 0f3F3504F3;
mul.f32 f394, f390, 0fBF3504F3;
sub.f32 f395, f393, f394;
mul.f32 f396, f390, 0f3F3504F3;
fma.rn.f32 f397, f389, 0fBF3504F3, f396;
mul.f32 f398, f391, 0fBF3504F3;
mul.f32 f399, f392, 0fBF3504F3;
sub.f32 f400, f398, f399;
add.f32 f401, f398, f399;
add.f32 f402, f369, f385;
add.f32 f403, f370, f386;
sub.f32 f404, f369, f385;
sub.f32 f405, f370, f386;
add.f32 f406, f373, f395;
add.f32 f407, f374, f397;
sub.f32 f408, f373, f395;
sub.f32 f409, f374, f397;
add.f32 f410, f371, f388;
sub.f32 f411, f372, f387;
sub.f32 f412, f371, f388;
add.f32 f413, f372, f387;
add.f32 f414, f375, f400;
add.f32 f415, f376, f401;
sub.f32 f416, f375, f400;
sub.f32 f417, f376, f401;
mul.f32 f418, f406, 0f3F6C835E;
mul.f32 f419, f407, 0fBEC3EF15;
sub.f32 f420, f418, f419;
mul.f32 f421, f407, 0f3F6C835E;
fma.rn.f32 f422, f406, 0fBEC3EF15, f421;
mul.f32 f423, f410, 0f3F3504F3;
mul.f32 f424, f411, 0fBF3504F3;
sub.f32 f425, f423, f424;
mul.f32 f426, f411, 0f3F3504F3;
fma.rn.f32 f427, f410, 0fBF3504F3, f426;
mul.f32 f428, f414, 0f3EC3EF15;
mul.f32 f429, f415, 0fBF6C835E;
sub.f32 f430, f428, f429;
mul.f32 f431, f415, 0f3EC3EF15;
fma.rn.f32 f432, f414, 0fBF6C835E, f431;
mul.f32 f433, f408, 0fBEC3EF15;
mul.f32 f434, f409, 0fBF6C835E;
sub.f32 f435, f433, f434;
mul.f32 f436, f409, 0fBEC3EF15;
fma.rn.f32 f437, f408, 0fBF6C835E, f436;
mul.f32 f438, f412, 0fBF3504F3;
mul.f32 f439, f413, 0fBF3504F3;
sub.f32 f440, f438, f439;
add.f32 f441, f438, f439;
mul.f32 f442, f416, 0fBF6C835E;
mul.f32 f443, f417, 0fBEC3EF15;
sub.f32 f444, f442, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0fBEC3EF15, f445;
add.f32 f447, f345, f402;
add.f32 f448, f346, f403;
sub.f32 f449, f345, f402;
sub.f32 f450, f346, f403;
add.f32 f451, f349, f420;
add.f32 f452, f350, f422;
sub.f32 f453, f349, f420;
sub.f32 f454, f350, f422;
add.f32 f455, f353, f425;
add.f32 f456, f354, f427;
sub.f32 f457, f353, f425;
sub.f32 f458, f354, f427;
add.f32 f459, f357, f430;
add.f32 f460, f358, f432;
sub.f32 f461, f357, f430;
sub.f32 f462, f358, f432;
add.f32 f463, f347, f405;
sub.f32 f464, f348, f404;
sub.f32 f465, f347, f405;
add.f32 f466, f348, f404;
add.f32 f467, f351, f435;
add.f32 f468, f352, f437;
sub.f32 f469, f351, f435;
sub.f32 f470, f352, f437;
add.f32 f471, f355, f440;
add.f32 f472, f356, f441;
sub.f32 f473, f355, f440;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
add.f32 f476, f360, f446;
sub.f32 f477, f359, f444;
sub.f32 f478, f360, f446;
mul.f32 f479, f451, 0f3F7B14BE;
mul.f32 f480, f452, 0fBE47C5C2;
sub.f32 f481, f479, f480;
mul.f32 f482, f452, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0fBE47C5C2, f482;
mul.f32 f484, f455, 0f3F6C835E;
mul.f32 f485, f456, 0fBEC3EF15;
sub.f32 f486, f484, f485;
mul.f32 f487, f456, 0f3F6C835E;
fma.rn.f32 f488, f455, 0fBEC3EF15, f487;
mul.f32 f489, f459, 0f3F54DB31;
mul.f32 f490, f460, 0fBF0E39DA;
sub.f32 f491, f489, f490;
mul.f32 f492, f460, 0f3F54DB31;
fma.rn.f32 f493, f459, 0fBF0E39DA, f492;
mul.f32 f494, f463, 0f3F3504F3;
mul.f32 f495, f464, 0fBF3504F3;
sub.f32 f496, f494, f495;
mul.f32 f497, f464, 0f3F3504F3;
fma.rn.f32 f498, f463, 0fBF3504F3, f497;
mul.f32 f499, f467, 0f3F0E39DA;
mul.f32 f500, f468, 0fBF54DB31;
sub.f32 f501, f499, f500;
mul.f32 f502, f468, 0f3F0E39DA;
fma.rn.f32 f503, f467, 0fBF54DB31, f502;
mul.f32 f504, f471, 0f3EC3EF15;
mul.f32 f505, f472, 0fBF6C835E;
sub.f32 f506, f504, f505;
mul.f32 f507, f472, 0f3EC3EF15;
fma.rn.f32 f508, f471, 0fBF6C835E, f507;
mul.f32 f509, f475, 0f3E47C5C2;
mul.f32 f510, f476, 0fBF7B14BE;
sub.f32 f511, f509, f510;
mul.f32 f512, f476, 0f3E47C5C2;
fma.rn.f32 f513, f475, 0fBF7B14BE, f512;
mul.f32 f514, f453, 0fBE47C5C2;
mul.f32 f515, f454, 0fBF7B14BE;
sub.f32 f516, f514, f515;
mul.f32 f517, f454, 0fBE47C5C2;
fma.rn.f32 f518, f453, 0fBF7B14BE, f517;
mul.f32 f519, f457, 0fBEC3EF15;
mul.f32 f520, f458, 0fBF6C835E;
sub.f32 f521, f519, f520;
mul.f32 f522, f458, 0fBEC3EF15;
fma.rn.f32 f523, f457, 0fBF6C835E, f522;
mul.f32 f524, f461, 0fBF0E39DA;
mul.f32 f525, f462, 0fBF54DB31;
sub.f32 f526, f524, f525;
mul.f32 f527, f462, 0fBF0E39DA;
fma.rn.f32 f528, f461, 0fBF54DB31, f527;
mul.f32 f529, f465, 0fBF3504F3;
mul.f32 f530, f466, 0fBF3504F3;
sub.f32 f531, f529, f530;
add.f32 f532, f529, f530;
mul.f32 f533, f469, 0fBF54DB31;
mul.f32 f534, f470, 0fBF0E39DA;
sub.f32 f535, f533, f534;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0fBF0E39DA, f536;
mul.f32 f538, f473, 0fBF6C835E;
mul.f32 f539, f474, 0fBEC3EF15;
sub.f32 f540, f538, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0fBEC3EF15, f541;
mul.f32 f543, f477, 0fBF7B14BE;
mul.f32 f544, f478, 0fBE47C5C2;
sub.f32 f545, f543, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0fBE47C5C2, f546;
add.f32 %1, f273, f448;
add.f32 %0, f272, f447;
add.f32 %3, f277, f483;
add.f32 %2, f276, f481;
add.f32 %5, f281, f488;
add.f32 %4, f280, f486;
add.f32 %7, f285, f493;
add.f32 %6, f284, f491;
add.f32 %9, f289, f498;
add.f32 %8, f288, f496;
add.f32 %11, f293, f503;
add.f32 %10, f292, f501;
add.f32 %13, f297, f508;
add.f32 %12, f296, f506;
add.f32 %15, f301, f513;
add.f32 %14, f300, f511;
sub.f32 %17, f275, f449;
add.f32 %16, f274, f450;
add.f32 %19, f279, f518;
add.f32 %18, f278, f516;
add.f32 %21, f283, f523;
add.f32 %20, f282, f521;
add.f32 %23, f287, f528;
add.f32 %22, f286, f526;
add.f32 %25, f291, f532;
add.f32 %24, f290, f531;
add.f32 %27, f295, f537;
add.f32 %26, f294, f535;
add.f32 %29, f299, f542;
add.f32 %28, f298, f540;
add.f32 %31, f303, f547;
add.f32 %30, f302, f545;
sub.f32 %33, f273, f448;
sub.f32 %32, f272, f447;
sub.f32 %35, f277, f483;
sub.f32 %34, f276, f481;
sub.f32 %37, f281, f488;
sub.f32 %36, f280, f486;
sub.f32 %39, f285, f493;
sub.f32 %38, f284, f491;
sub.f32 %41, f289, f498;
sub.f32 %40, f288, f496;
sub.f32 %43, f293, f503;
sub.f32 %42, f292, f501;
sub.f32 %45, f297, f508;
sub.f32 %44, f296, f506;
sub.f32 %47, f301, f513;
sub.f32 %46, f300, f511;
add.f32 %49, f275, f449;
sub.f32 %48, f274, f450;
sub.f32 %51, f279, f518;
sub.f32 %50, f278, f516;
sub.f32 %53, f283, f523;
sub.f32 %52, f282, f521;
sub.f32 %55, f287, f528;
sub.f32 %54, f286, f526;
sub.f32 %57, f291, f532;
sub.f32 %56, f290, f531;
sub.f32 %59, f295, f537;
sub.f32 %58, f294, f535;
sub.f32 %61, f299, f542;
sub.f32 %60, f298, f540;
sub.f32 %63, f303, f547;
sub.f32 %62, f302, f545;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<33, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<223>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %18, %28;
add.f32 f34, %19, %30;
sub.f32 f35, %18, %28;
sub.f32 f36, %19, %30;
add.f32 f37, %23, %34;
add.f32 f38, %25, %35;
sub.f32 f39, %23, %34;
sub.f32 f40, %25, %35;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
add.f32 f45, f35, f40;
sub.f32 f46, f36, f39;
sub.f32 f47, f35, f40;
add.f32 f48, f36, f39;
add.f32 f49, %20, %31;
add.f32 f50, %22, %33;
sub.f32 f51, %20, %31;
sub.f32 f52, %22, %33;
add.f32 f53, %26, %36;
add.f32 f54, %27, %37;
sub.f32 f55, %26, %36;
sub.f32 f56, %27, %37;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
add.f32 f61, f51, f56;
sub.f32 f62, f52, f55;
sub.f32 f63, f51, f56;
add.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0fBF3504F3;
sub.f32 f67, f65, f66;
mul.f32 f68, f62, 0f3F3504F3;
fma.rn.f32 f69, f61, 0fBF3504F3, f68;
mul.f32 f70, f63, 0fBF3504F3;
mul.f32 f71, f64, 0fBF3504F3;
sub.f32 f72, f70, f71;
add.f32 f73, f70, f71;
sub.f32 f74, f41, f57;
sub.f32 f75, f42, f58;
add.f32 f76, f45, f67;
add.f32 f77, f46, f69;
sub.f32 f78, f45, f67;
sub.f32 f79, f46, f69;
add.f32 f80, f43, f60;
sub.f32 f81, f44, f59;
sub.f32 f82, f43, f60;
add.f32 f83, f44, f59;
add.f32 f84, f47, f72;
add.f32 f85, f48, f73;
sub.f32 f86, f47, f72;
sub.f32 f87, f48, f73;
and.b32 r6, r5, 3;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f88, f89}, [rd5];
mul.f32 f92, f88, f76;
mul.f32 f93, f89, f77;
mul.f32 f94, f88, f77;
mul.f32 f95, f88, f88;
mul.f32 f96, f89, f89;
sub.f32 f97, f95, f96;
mul.f32 f98, f89, f88;
fma.rn.f32 f99, f89, f88, f98;
mul.f32 f100, f97, f80;
mul.f32 f101, f99, f81;
mul.f32 f102, f97, f81;
mul.f32 f103, f88, f97;
mul.f32 f104, f89, f99;
sub.f32 f105, f103, f104;
mul.f32 f106, f88, f99;
fma.rn.f32 f107, f89, f97, f106;
mul.f32 f108, f105, f84;
mul.f32 f109, f107, f85;
mul.f32 f110, f105, f85;
mul.f32 f111, f88, f105;
mul.f32 f112, f89, f107;
sub.f32 f113, f111, f112;
mul.f32 f114, f88, f107;
fma.rn.f32 f115, f89, f105, f114;
mul.f32 f116, f113, f74;
mul.f32 f117, f115, f75;
mul.f32 f118, f113, f75;
mul.f32 f119, f88, f113;
mul.f32 f120, f89, f115;
sub.f32 f121, f119, f120;
mul.f32 f122, f88, f115;
fma.rn.f32 f123, f89, f113, f122;
mul.f32 f124, f121, f78;
mul.f32 f125, f123, f79;
mul.f32 f126, f121, f79;
mul.f32 f127, f88, f121;
mul.f32 f128, f89, f123;
sub.f32 f129, f127, f128;
mul.f32 f130, f88, f123;
fma.rn.f32 f131, f89, f121, f130;
mul.f32 f132, f129, f82;
mul.f32 f133, f131, f83;
mul.f32 f134, f129, f83;
mul.f32 f135, f88, f129;
mul.f32 f136, f89, f131;
sub.f32 f137, f135, f136;
mul.f32 f138, f88, f131;
fma.rn.f32 f139, f89, f129, f138;
mul.f32 f140, f137, f86;
mul.f32 f141, f139, f87;
mul.f32 f142, f137, f87;
barrier.sync 0;
and.b32 r11, r7, 192;
add.s32 r12, r9, r11;
add.f32 f143, f42, f58;
add.f32 f144, f41, f57;
fma.rn.f32 f145, f89, f76, f94;
sub.f32 f146, f92, f93;
st.shared.v4.f32 [r12], {f144, f143, f146, f145};
fma.rn.f32 f147, f99, f80, f102;
sub.f32 f148, f100, f101;
sub.f32 f149, f108, f109;
fma.rn.f32 f150, f107, f84, f110;
st.shared.v4.f32 [r12+16], {f148, f147, f149, f150};
fma.rn.f32 f151, f115, f74, f118;
sub.f32 f152, f116, f117;
fma.rn.f32 f153, f123, f78, f126;
sub.f32 f154, f124, f125;
st.shared.v4.f32 [r12+32], {f152, f151, f154, f153};
fma.rn.f32 f155, f131, f82, f134;
sub.f32 f156, f132, f133;
fma.rn.f32 f157, f139, f86, f142;
sub.f32 f158, f140, f141;
st.shared.v4.f32 [r12+48], {f156, f155, f158, f157};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.v2.f32 {f159, f160}, [r13];
ld.shared.v2.f32 {f163, f164}, [r13+32];
ld.shared.v2.f32 {f167, f168}, [r13+64];
ld.shared.v2.f32 {f171, f172}, [r13+96];
ld.shared.v2.f32 {f175, f176}, [r13+128];
ld.shared.v2.f32 {f179, f180}, [r13+160];
ld.shared.v2.f32 {f183, f184}, [r13+192];
ld.shared.v2.f32 {f187, f188}, [r13+224];
add.f32 f191, f159, f175;
add.f32 f192, f160, f176;
sub.f32 f193, f159, f175;
sub.f32 f194, f160, f176;
add.f32 f195, f167, f183;
add.f32 f196, f168, f184;
sub.f32 f197, f167, f183;
sub.f32 f198, f168, f184;
add.f32 f199, f163, f179;
add.f32 f200, f164, f180;
sub.f32 f201, f163, f179;
sub.f32 f202, f164, f180;
add.f32 f203, f171, f187;
add.f32 f204, f172, f188;
sub.f32 f205, f171, f187;
sub.f32 f206, f172, f188;
add.f32 %1, f192, f196;
add.f32 %0, f191, f195;
add.f32 %3, f200, f204;
add.f32 %2, f199, f203;
sub.f32 %5, f194, f197;
add.f32 %4, f193, f198;
sub.f32 %7, f202, f205;
add.f32 %6, f201, f206;
sub.f32 %9, f192, f196;
sub.f32 %8, f191, f195;
sub.f32 %11, f200, f204;
sub.f32 %10, f199, f203;
add.f32 %13, f194, f197;
sub.f32 %12, f193, f198;
add.f32 %15, f202, f205;
sub.f32 %14, f201, f206;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<34, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<207>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %18, %28;
add.f32 f34, %19, %30;
sub.f32 f35, %18, %28;
sub.f32 f36, %19, %30;
add.f32 f37, %23, %34;
add.f32 f38, %25, %35;
sub.f32 f39, %23, %34;
sub.f32 f40, %25, %35;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
add.f32 f45, f35, f40;
sub.f32 f46, f36, f39;
sub.f32 f47, f35, f40;
add.f32 f48, f36, f39;
add.f32 f49, %20, %31;
add.f32 f50, %22, %33;
sub.f32 f51, %20, %31;
sub.f32 f52, %22, %33;
add.f32 f53, %26, %36;
add.f32 f54, %27, %37;
sub.f32 f55, %26, %36;
sub.f32 f56, %27, %37;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
add.f32 f61, f51, f56;
sub.f32 f62, f52, f55;
sub.f32 f63, f51, f56;
add.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0fBF3504F3;
sub.f32 f67, f65, f66;
mul.f32 f68, f62, 0f3F3504F3;
fma.rn.f32 f69, f61, 0fBF3504F3, f68;
mul.f32 f70, f63, 0fBF3504F3;
mul.f32 f71, f64, 0fBF3504F3;
sub.f32 f72, f70, f71;
add.f32 f73, f70, f71;
add.f32 f74, f41, f57;
add.f32 f75, f42, f58;
sub.f32 f76, f41, f57;
sub.f32 f77, f42, f58;
add.f32 f78, f45, f67;
add.f32 f79, f46, f69;
sub.f32 f80, f45, f67;
sub.f32 f81, f46, f69;
add.f32 f82, f43, f60;
sub.f32 f83, f44, f59;
sub.f32 f84, f43, f60;
add.f32 f85, f44, f59;
add.f32 f86, f47, f72;
add.f32 f87, f48, f73;
sub.f32 f88, f47, f72;
sub.f32 f89, f48, f73;
and.b32 r6, r5, 3;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 24;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f90, f91}, [rd5];
mul.f32 f94, f90, f78;
mul.f32 f95, f91, f79;
sub.f32 f96, f94, f95;
mul.f32 f97, f90, f79;
fma.rn.f32 f98, f91, f78, f97;
mul.f32 f99, f90, f90;
mul.f32 f100, f91, f91;
sub.f32 f101, f99, f100;
mul.f32 f102, f91, f90;
fma.rn.f32 f103, f91, f90, f102;
mul.f32 f104, f101, f82;
mul.f32 f105, f103, f83;
sub.f32 f106, f104, f105;
mul.f32 f107, f101, f83;
fma.rn.f32 f108, f103, f82, f107;
mul.f32 f109, f90, f101;
mul.f32 f110, f91, f103;
sub.f32 f111, f109, f110;
mul.f32 f112, f90, f103;
fma.rn.f32 f113, f91, f101, f112;
mul.f32 f114, f111, f86;
mul.f32 f115, f113, f87;
sub.f32 f116, f114, f115;
mul.f32 f117, f111, f87;
fma.rn.f32 f118, f113, f86, f117;
mul.f32 f119, f90, f111;
mul.f32 f120, f91, f113;
sub.f32 f121, f119, f120;
mul.f32 f122, f90, f113;
fma.rn.f32 f123, f91, f111, f122;
mul.f32 f124, f121, f76;
mul.f32 f125, f123, f77;
sub.f32 f126, f124, f125;
mul.f32 f127, f121, f77;
fma.rn.f32 f128, f123, f76, f127;
mul.f32 f129, f90, f121;
mul.f32 f130, f91, f123;
sub.f32 f131, f129, f130;
mul.f32 f132, f90, f123;
fma.rn.f32 f133, f91, f121, f132;
mul.f32 f134, f131, f80;
mul.f32 f135, f133, f81;
sub.f32 f136, f134, f135;
mul.f32 f137, f131, f81;
fma.rn.f32 f138, f133, f80, f137;
mul.f32 f139, f90, f131;
mul.f32 f140, f91, f133;
sub.f32 f141, f139, f140;
mul.f32 f142, f90, f133;
fma.rn.f32 f143, f91, f131, f142;
mul.f32 f144, f141, f84;
mul.f32 f145, f143, f85;
sub.f32 f146, f144, f145;
mul.f32 f147, f141, f85;
fma.rn.f32 f148, f143, f84, f147;
mul.f32 f149, f90, f141;
mul.f32 f150, f91, f143;
sub.f32 f151, f149, f150;
mul.f32 f152, f90, f143;
fma.rn.f32 f153, f91, f141, f152;
mul.f32 f154, f151, f88;
mul.f32 f155, f153, f89;
sub.f32 f156, f154, f155;
mul.f32 f157, f151, f89;
fma.rn.f32 f158, f153, f88, f157;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 96;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f74, f96, f106, f116};
st.shared.v4.f32 [r12+16], {f126, f136, f146, f156};
barrier.sync 0;
mad.lo.s32 r13, r6, -28, r12;
ld.shared.f32 f159, [r13];
ld.shared.f32 f160, [r13+16];
ld.shared.f32 f161, [r13+32];
ld.shared.f32 f162, [r13+48];
ld.shared.f32 f163, [r13+64];
ld.shared.f32 f164, [r13+80];
ld.shared.f32 f165, [r13+96];
ld.shared.f32 f166, [r13+112];
barrier.sync 0;
st.shared.v4.f32 [r12], {f75, f98, f108, f118};
st.shared.v4.f32 [r12+16], {f128, f138, f148, f158};
barrier.sync 0;
ld.shared.f32 f167, [r13];
ld.shared.f32 f168, [r13+16];
ld.shared.f32 f169, [r13+32];
ld.shared.f32 f170, [r13+48];
ld.shared.f32 f171, [r13+64];
ld.shared.f32 f172, [r13+80];
ld.shared.f32 f173, [r13+96];
ld.shared.f32 f174, [r13+112];
add.f32 f175, f159, f163;
add.f32 f176, f167, f171;
sub.f32 f177, f159, f163;
sub.f32 f178, f167, f171;
add.f32 f179, f161, f165;
add.f32 f180, f169, f173;
sub.f32 f181, f161, f165;
sub.f32 f182, f169, f173;
add.f32 f183, f160, f164;
add.f32 f184, f168, f172;
sub.f32 f185, f160, f164;
sub.f32 f186, f168, f172;
add.f32 f187, f162, f166;
add.f32 f188, f170, f174;
sub.f32 f189, f162, f166;
sub.f32 f190, f170, f174;
add.f32 %0, f175, f179;
add.f32 %1, f176, f180;
add.f32 %2, f183, f187;
add.f32 %3, f184, f188;
sub.f32 %5, f178, f181;
add.f32 %4, f177, f182;
sub.f32 %7, f186, f189;
add.f32 %6, f185, f190;
sub.f32 %8, f175, f179;
sub.f32 %9, f176, f180;
sub.f32 %10, f183, f187;
sub.f32 %11, f184, f188;
add.f32 %13, f178, f181;
sub.f32 %12, f177, f182;
add.f32 %15, f186, f189;
sub.f32 %14, f185, f190;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<35, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<147>;
.reg .b32 r<21>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %11, %16;
add.f32 f18, %12, %18;
sub.f32 f19, %11, %16;
sub.f32 f20, %12, %18;
add.f32 f21, %13, %19;
add.f32 f22, %15, %20;
sub.f32 f23, %13, %19;
sub.f32 f24, %15, %20;
sub.f32 f25, f17, f21;
sub.f32 f26, f18, f22;
add.f32 f27, f19, f24;
sub.f32 f28, f20, f23;
sub.f32 f29, f19, f24;
add.f32 f30, f20, f23;
and.b32 r6, r5, 7;
shl.b32 r7, r5, 5;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f31, f32}, [rd5];
mul.f32 f35, f31, f27;
mul.f32 f36, f32, f28;
mul.f32 f37, f31, f28;
mul.f32 f38, f31, f31;
mul.f32 f39, f32, f32;
sub.f32 f40, f38, f39;
mul.f32 f41, f32, f31;
fma.rn.f32 f42, f32, f31, f41;
mul.f32 f43, f40, f25;
mul.f32 f44, f42, f26;
mul.f32 f45, f40, f26;
mul.f32 f46, f31, f40;
mul.f32 f47, f32, f42;
sub.f32 f48, f46, f47;
mul.f32 f49, f31, f42;
fma.rn.f32 f50, f32, f40, f49;
mul.f32 f51, f48, f29;
mul.f32 f52, f50, f30;
mul.f32 f53, f48, f30;
barrier.sync 0;
and.b32 r11, r7, 224;
add.s32 r12, r9, r11;
add.f32 f54, f18, f22;
add.f32 f55, f17, f21;
fma.rn.f32 f56, f32, f27, f37;
sub.f32 f57, f35, f36;
st.shared.v4.f32 [r12], {f55, f54, f57, f56};
sub.f32 f58, f43, f44;
fma.rn.f32 f59, f42, f25, f45;
fma.rn.f32 f60, f50, f29, f53;
sub.f32 f61, f51, f52;
st.shared.v4.f32 [r12+16], {f58, f59, f61, f60};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.v2.f32 {f62, f63}, [r13];
ld.shared.v2.f32 {f66, f67}, [r13+64];
ld.shared.v2.f32 {f70, f71}, [r13+128];
ld.shared.v2.f32 {f74, f75}, [r13+192];
add.f32 f78, f62, f70;
add.f32 f79, f63, f71;
sub.f32 f80, f62, f70;
sub.f32 f81, f63, f71;
add.f32 f82, f66, f74;
add.f32 f83, f67, f75;
sub.f32 f84, f66, f74;
sub.f32 f85, f67, f75;
sub.f32 f86, f78, f82;
sub.f32 f87, f79, f83;
add.f32 f88, f80, f85;
sub.f32 f89, f81, f84;
sub.f32 f90, f80, f85;
add.f32 f91, f81, f84;
and.b32 r14, r5, 4;
bfe.u32 r15, r5, 2, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f92, f93}, [rd8];
mul.f32 f96, f92, f88;
mul.f32 f97, f93, f89;
mul.f32 f98, f92, f89;
mul.f32 f99, f92, f92;
mul.f32 f100, f93, f93;
sub.f32 f101, f99, f100;
mul.f32 f102, f93, f92;
fma.rn.f32 f103, f93, f92, f102;
mul.f32 f104, f101, f86;
mul.f32 f105, f103, f87;
mul.f32 f106, f101, f87;
mul.f32 f107, f92, f101;
mul.f32 f108, f93, f103;
sub.f32 f109, f107, f108;
mul.f32 f110, f92, f103;
fma.rn.f32 f111, f93, f101, f110;
mul.f32 f112, f109, f90;
mul.f32 f113, f111, f91;
mul.f32 f114, f109, f91;
and.b32 r16, r10, 24;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 128;
add.s32 r19, r17, r18;
add.f32 f115, f79, f83;
add.f32 f116, f78, f82;
st.shared.v2.f32 [r19], {f116, f115};
fma.rn.f32 f117, f93, f88, f98;
sub.f32 f118, f96, f97;
st.shared.v2.f32 [r19+32], {f118, f117};
fma.rn.f32 f119, f103, f86, f106;
sub.f32 f120, f104, f105;
st.shared.v2.f32 [r19+64], {f120, f119};
sub.f32 f121, f112, f113;
fma.rn.f32 f122, f111, f90, f114;
st.shared.v2.f32 [r19+96], {f121, f122};
barrier.sync 0;
mad.lo.s32 r20, r14, -24, r19;
ld.shared.v2.f32 {f123, f124}, [r20];
ld.shared.v2.f32 {f127, f128}, [r20+64];
ld.shared.v2.f32 {f131, f132}, [r20+128];
ld.shared.v2.f32 {f135, f136}, [r20+192];
add.f32 %1, f124, f132;
add.f32 %0, f123, f131;
add.f32 %3, f128, f136;
add.f32 %2, f127, f135;
sub.f32 %5, f124, f132;
sub.f32 %4, f123, f131;
sub.f32 %7, f128, f136;
sub.f32 %6, f127, f135;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<36, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<131>;
.reg .b32 r<22>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %11, %16;
add.f32 f18, %12, %18;
sub.f32 f19, %11, %16;
sub.f32 f20, %12, %18;
add.f32 f21, %13, %19;
add.f32 f22, %15, %20;
sub.f32 f23, %13, %19;
sub.f32 f24, %15, %20;
add.f32 f25, f17, f21;
add.f32 f26, f18, f22;
sub.f32 f27, f17, f21;
sub.f32 f28, f18, f22;
add.f32 f29, f19, f24;
sub.f32 f30, f20, f23;
sub.f32 f31, f19, f24;
add.f32 f32, f20, f23;
and.b32 r6, r5, 7;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 56;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f33, f34}, [rd5];
mul.f32 f37, f33, f29;
mul.f32 f38, f34, f30;
sub.f32 f39, f37, f38;
mul.f32 f40, f33, f30;
fma.rn.f32 f41, f34, f29, f40;
mul.f32 f42, f33, f33;
mul.f32 f43, f34, f34;
sub.f32 f44, f42, f43;
mul.f32 f45, f34, f33;
fma.rn.f32 f46, f34, f33, f45;
mul.f32 f47, f44, f27;
mul.f32 f48, f46, f28;
sub.f32 f49, f47, f48;
mul.f32 f50, f44, f28;
fma.rn.f32 f51, f46, f27, f50;
mul.f32 f52, f33, f44;
mul.f32 f53, f34, f46;
sub.f32 f54, f52, f53;
mul.f32 f55, f33, f46;
fma.rn.f32 f56, f34, f44, f55;
mul.f32 f57, f54, f31;
mul.f32 f58, f56, f32;
sub.f32 f59, f57, f58;
mul.f32 f60, f54, f32;
fma.rn.f32 f61, f56, f31, f60;
shl.b32 r8, r5, 4;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 112;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f25, f39, f49, f59};
barrier.sync 0;
mad.lo.s32 r13, r6, -12, r12;
ld.shared.f32 f62, [r13];
ld.shared.f32 f63, [r13+32];
ld.shared.f32 f64, [r13+64];
ld.shared.f32 f65, [r13+96];
barrier.sync 0;
st.shared.v4.f32 [r12], {f26, f41, f51, f61};
barrier.sync 0;
ld.shared.f32 f66, [r13];
ld.shared.f32 f67, [r13+32];
ld.shared.f32 f68, [r13+64];
ld.shared.f32 f69, [r13+96];
add.f32 f70, f62, f64;
add.f32 f71, f66, f68;
sub.f32 f72, f62, f64;
sub.f32 f73, f66, f68;
add.f32 f74, f63, f65;
add.f32 f75, f67, f69;
sub.f32 f76, f63, f65;
sub.f32 f77, f67, f69;
add.f32 f78, f70, f74;
add.f32 f79, f71, f75;
sub.f32 f80, f70, f74;
sub.f32 f81, f71, f75;
add.f32 f82, f72, f77;
sub.f32 f83, f73, f76;
sub.f32 f84, f72, f77;
add.f32 f85, f73, f76;
and.b32 r14, r5, 4;
bfe.u32 r15, r5, 2, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f86, f87}, [rd8];
mul.f32 f90, f86, f82;
mul.f32 f91, f87, f83;
sub.f32 f92, f90, f91;
mul.f32 f93, f86, f83;
fma.rn.f32 f94, f87, f82, f93;
mul.f32 f95, f86, f86;
mul.f32 f96, f87, f87;
sub.f32 f97, f95, f96;
mul.f32 f98, f87, f86;
fma.rn.f32 f99, f87, f86, f98;
mul.f32 f100, f97, f80;
mul.f32 f101, f99, f81;
sub.f32 f102, f100, f101;
mul.f32 f103, f97, f81;
fma.rn.f32 f104, f99, f80, f103;
mul.f32 f105, f86, f97;
mul.f32 f106, f87, f99;
sub.f32 f107, f105, f106;
mul.f32 f108, f86, f99;
fma.rn.f32 f109, f87, f97, f108;
mul.f32 f110, f107, f84;
mul.f32 f111, f109, f85;
sub.f32 f112, f110, f111;
mul.f32 f113, f107, f85;
fma.rn.f32 f114, f109, f84, f113;
shl.b32 r16, r5, 2;
and.b32 r17, r16, 12;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 64;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f78;
st.shared.f32 [r20+16], f92;
st.shared.f32 [r20+32], f102;
st.shared.f32 [r20+48], f112;
barrier.sync 0;
mad.lo.s32 r21, r14, -12, r20;
ld.shared.f32 f115, [r21];
ld.shared.f32 f116, [r21+32];
ld.shared.f32 f117, [r21+64];
ld.shared.f32 f118, [r21+96];
barrier.sync 0;
st.shared.f32 [r20], f79;
st.shared.f32 [r20+16], f94;
st.shared.f32 [r20+32], f104;
st.shared.f32 [r20+48], f114;
barrier.sync 0;
ld.shared.f32 f119, [r21];
ld.shared.f32 f120, [r21+32];
ld.shared.f32 f121, [r21+64];
ld.shared.f32 f122, [r21+96];
add.f32 %0, f115, f117;
add.f32 %1, f119, f121;
add.f32 %2, f116, f118;
add.f32 %3, f120, f122;
sub.f32 %4, f115, f117;
sub.f32 %5, f119, f121;
sub.f32 %6, f116, f118;
sub.f32 %7, f120, f122;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<37, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<97>;
.reg .b32 r<35>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f32 f9, %9, %11;
sub.f32 f10, %10, %12;
shl.b32 r6, r5, 4;
and.b32 r7, r6, -256;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 3;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f11, f12}, [rd5];
mul.f32 f15, f11, f9;
mul.f32 f16, f12, f10;
mul.f32 f17, f11, f10;
barrier.sync 0;
and.b32 r10, r6, 240;
add.s32 r11, r8, r10;
add.f32 f18, %10, %12;
add.f32 f19, %9, %11;
st.shared.v2.f32 [r11], {f19, f18};
sub.f32 f20, f15, f16;
fma.rn.f32 f21, f12, f9, f17;
st.shared.v2.f32 [r11+8], {f20, f21};
barrier.sync 0;
and.b32 r12, r9, 120;
sub.s32 r13, r11, r12;
ld.shared.v2.f32 {f22, f23}, [r13];
ld.shared.v2.f32 {f26, f27}, [r13+128];
sub.f32 f30, f22, f26;
sub.f32 f31, f23, f27;
bfe.u32 r14, r5, 1, 3;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f32, f33}, [rd8];
mul.f32 f36, f32, f30;
mul.f32 f37, f33, f31;
mul.f32 f38, f32, f31;
and.b32 r15, r9, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 224;
add.s32 r18, r16, r17;
add.f32 f39, f23, f27;
add.f32 f40, f22, f26;
st.shared.v2.f32 [r18], {f40, f39};
fma.rn.f32 f41, f33, f30, f38;
sub.f32 f42, f36, f37;
st.shared.v2.f32 [r18+16], {f42, f41};
barrier.sync 0;
and.b32 r19, r9, 112;
sub.s32 r20, r18, r19;
ld.shared.v2.f32 {f43, f44}, [r20];
ld.shared.v2.f32 {f47, f48}, [r20+128];
sub.f32 f51, f43, f47;
sub.f32 f52, f44, f48;
bfe.u32 r21, r5, 2, 2;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f53, f54}, [rd11];
mul.f32 f57, f53, f51;
mul.f32 f58, f54, f52;
mul.f32 f59, f53, f52;
and.b32 r22, r9, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 192;
add.s32 r25, r23, r24;
add.f32 f60, f44, f48;
add.f32 f61, f43, f47;
st.shared.v2.f32 [r25], {f61, f60};
fma.rn.f32 f62, f54, f51, f59;
sub.f32 f63, f57, f58;
st.shared.v2.f32 [r25+32], {f63, f62};
barrier.sync 0;
and.b32 r26, r9, 96;
sub.s32 r27, r25, r26;
ld.shared.v2.f32 {f64, f65}, [r27];
ld.shared.v2.f32 {f68, f69}, [r27+128];
sub.f32 f72, f64, f68;
sub.f32 f73, f65, f69;
and.b32 r28, r5, 8;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f74, f75}, [rd14];
mul.f32 f78, f74, f72;
mul.f32 f79, f75, f73;
mul.f32 f80, f74, f73;
and.b32 r29, r9, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 128;
add.s32 r32, r30, r31;
add.f32 f81, f65, f69;
add.f32 f82, f64, f68;
st.shared.v2.f32 [r32], {f82, f81};
fma.rn.f32 f83, f75, f72, f80;
sub.f32 f84, f78, f79;
st.shared.v2.f32 [r32+64], {f84, f83};
barrier.sync 0;
and.b32 r33, r9, 64;
sub.s32 r34, r32, r33;
ld.shared.v2.f32 {f85, f86}, [r34];
ld.shared.v2.f32 {f89, f90}, [r34+128];
add.f32 %1, f86, f90;
add.f32 %0, f85, f89;
sub.f32 %3, f86, f90;
sub.f32 %2, f85, f89;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<38, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<589>;
.reg .b32 r<26>;
.reg .b64 rd<10>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 8;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f32 f65, %34, %50;
sub.f32 f67, %34, %50;
add.f32 f582, %35, %66;
sub.f32 f68, %35, %66;
add.f32 f69, %42, %58;
sub.f32 f71, %42, %58;
add.f32 f580, %67, %59;
sub.f32 f72, %67, %59;
add.f32 f73, f65, f69;
sub.f32 f75, f65, f69;
add.f32 f579, f582, f580;
sub.f32 f76, f582, f580;
add.f32 f77, f67, f72;
sub.f32 f79, f67, f72;
sub.f32 f578, f68, f71;
add.f32 f80, f68, f71;
add.f32 f81, %38, %54;
sub.f32 f83, %38, %54;
add.f32 f575, %69, %68;
sub.f32 f84, %69, %68;
add.f32 f85, %46, %62;
sub.f32 f87, %46, %62;
add.f32 f573, %47, %70;
sub.f32 f88, %47, %70;
add.f32 f89, f81, f85;
sub.f32 f91, f81, f85;
add.f32 f572, f575, f573;
sub.f32 f92, f575, f573;
add.f32 f93, f83, f88;
sub.f32 f95, f83, f88;
sub.f32 f571, f84, f87;
add.f32 f96, f84, f87;
mul.f32 f98, f571, 0fBF3504F3;
mul.f32 f570, f93, 0f3F3504F3;
sub.f32 f99, f570, f98;
mul.f32 f100, f571, 0f3F3504F3;
fma.rn.f32 f101, f93, 0fBF3504F3, f100;
mul.f32 f102, f95, 0fBF3504F3;
mul.f32 f103, f96, 0fBF3504F3;
sub.f32 f104, f102, f103;
add.f32 f105, f102, f103;
add.f32 f106, f73, f89;
sub.f32 f108, f73, f89;
add.f32 f569, f579, f572;
sub.f32 f109, f579, f572;
add.f32 f110, f77, f99;
sub.f32 f112, f77, f99;
add.f32 f568, f578, f101;
sub.f32 f113, f578, f101;
add.f32 f114, f75, f92;
sub.f32 f116, f75, f92;
sub.f32 f567, f76, f91;
add.f32 f117, f76, f91;
add.f32 f118, f79, f104;
sub.f32 f120, f79, f104;
add.f32 f566, f80, f105;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %52;
sub.f32 f124, %36, %52;
add.f32 f564, %71, %53;
sub.f32 f125, %71, %53;
add.f32 f126, %44, %60;
sub.f32 f128, %44, %60;
add.f32 f561, %72, %73;
sub.f32 f129, %72, %73;
add.f32 f130, f122, f126;
sub.f32 f132, f122, f126;
add.f32 f560, f564, f561;
sub.f32 f133, f564, f561;
add.f32 f134, f124, f129;
sub.f32 f136, f124, f129;
sub.f32 f559, f125, f128;
add.f32 f137, f125, f128;
add.f32 f138, %40, %56;
sub.f32 f140, %40, %56;
add.f32 f557, %41, %74;
sub.f32 f141, %41, %74;
add.f32 f142, %48, %64;
sub.f32 f144, %48, %64;
add.f32 f555, %75, %65;
sub.f32 f145, %75, %65;
add.f32 f146, f138, f142;
sub.f32 f148, f138, f142;
add.f32 f554, f557, f555;
sub.f32 f149, f557, f555;
add.f32 f150, f140, f145;
sub.f32 f152, f140, f145;
sub.f32 f553, f141, f144;
add.f32 f153, f141, f144;
mul.f32 f155, f553, 0fBF3504F3;
mul.f32 f552, f150, 0f3F3504F3;
sub.f32 f156, f552, f155;
mul.f32 f157, f553, 0f3F3504F3;
fma.rn.f32 f158, f150, 0fBF3504F3, f157;
mul.f32 f159, f152, 0fBF3504F3;
mul.f32 f160, f153, 0fBF3504F3;
sub.f32 f161, f159, f160;
add.f32 f162, f159, f160;
add.f32 f163, f130, f146;
sub.f32 f165, f130, f146;
add.f32 f551, f560, f554;
sub.f32 f166, f560, f554;
add.f32 f167, f134, f156;
sub.f32 f169, f134, f156;
add.f32 f550, f559, f158;
sub.f32 f170, f559, f158;
add.f32 f171, f132, f149;
sub.f32 f173, f132, f149;
sub.f32 f549, f133, f148;
add.f32 f174, f133, f148;
add.f32 f175, f136, f161;
sub.f32 f177, f136, f161;
add.f32 f548, f137, f162;
sub.f32 f178, f137, f162;
mul.f32 f546, f167, 0f3F6C835E;
mul.f32 f547, f550, 0fBEC3EF15;
sub.f32 f181, f546, f547;
mul.f32 f182, f550, 0f3F6C835E;
fma.rn.f32 f183, f167, 0fBEC3EF15, f182;
mul.f32 f544, f171, 0f3F3504F3;
mul.f32 f545, f549, 0fBF3504F3;
sub.f32 f186, f544, f545;
mul.f32 f187, f549, 0f3F3504F3;
fma.rn.f32 f188, f171, 0fBF3504F3, f187;
mul.f32 f542, f175, 0f3EC3EF15;
mul.f32 f543, f548, 0fBF6C835E;
sub.f32 f191, f542, f543;
mul.f32 f192, f548, 0f3EC3EF15;
fma.rn.f32 f193, f175, 0fBF6C835E, f192;
mul.f32 f540, f169, 0fBEC3EF15;
mul.f32 f541, f170, 0fBF6C835E;
sub.f32 f196, f540, f541;
mul.f32 f197, f170, 0fBEC3EF15;
fma.rn.f32 f198, f169, 0fBF6C835E, f197;
mul.f32 f199, f173, 0fBF3504F3;
mul.f32 f200, f174, 0fBF3504F3;
sub.f32 f201, f199, f200;
add.f32 f202, f199, f200;
mul.f32 f538, f177, 0fBF6C835E;
mul.f32 f539, f178, 0fBEC3EF15;
sub.f32 f205, f538, f539;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0fBEC3EF15, f206;
add.f32 f210, f110, f181;
sub.f32 f212, f110, f181;
add.f32 f537, f568, f183;
sub.f32 f213, f568, f183;
add.f32 f214, f114, f186;
sub.f32 f216, f114, f186;
add.f32 f536, f567, f188;
sub.f32 f217, f567, f188;
add.f32 f218, f118, f191;
sub.f32 f220, f118, f191;
add.f32 f535, f566, f193;
sub.f32 f221, f566, f193;
add.f32 f222, f108, f166;
sub.f32 f224, f108, f166;
sub.f32 f534, f109, f165;
add.f32 f225, f109, f165;
add.f32 f226, f112, f196;
sub.f32 f228, f112, f196;
add.f32 f533, f113, f198;
sub.f32 f229, f113, f198;
add.f32 f230, f116, f201;
sub.f32 f232, f116, f201;
add.f32 f532, f117, f202;
sub.f32 f233, f117, f202;
add.f32 f234, f120, f205;
sub.f32 f236, f120, f205;
add.f32 f531, f121, f207;
sub.f32 f237, f121, f207;
mov.u32 r15, %tid.x;
shl.b32 r7, r15, 7;
and.b32 r8, r7, -256;
add.s32 r9, r4, r8;
and.b32 r14, r15, 1;
shl.b32 r10, r15, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 8;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f238, f239}, [rd5];
mul.f32 f243, f239, f537;
mul.f32 f244, f238, f537;
mul.f32 f246, f239, f239;
mul.f32 f530, f238, f238;
sub.f32 f247, f530, f246;
mul.f32 f248, f239, f238;
fma.rn.f32 f249, f239, f238, f248;
mul.f32 f251, f249, f536;
mul.f32 f252, f247, f536;
mul.f32 f528, f238, f247;
mul.f32 f529, f239, f249;
sub.f32 f255, f528, f529;
mul.f32 f527, f247, f214;
mul.f32 f256, f238, f249;
fma.rn.f32 f257, f239, f247, f256;
mul.f32 f259, f257, f535;
mul.f32 f260, f255, f535;
mul.f32 f262, f239, f257;
mul.f32 f526, f238, f255;
sub.f32 f263, f526, f262;
mul.f32 f525, f255, f218;
mul.f32 f264, f238, f257;
fma.rn.f32 f265, f239, f255, f264;
mul.f32 f267, f265, f534;
mul.f32 f268, f263, f534;
mul.f32 f270, f239, f265;
mul.f32 f524, f238, f263;
sub.f32 f271, f524, f270;
mul.f32 f523, f263, f222;
mul.f32 f272, f238, f265;
fma.rn.f32 f273, f239, f263, f272;
mul.f32 f275, f273, f533;
mul.f32 f276, f271, f533;
mul.f32 f521, f238, f271;
mul.f32 f522, f239, f273;
sub.f32 f279, f521, f522;
mul.f32 f520, f271, f226;
mul.f32 f280, f238, f273;
fma.rn.f32 f281, f239, f271, f280;
mul.f32 f283, f281, f532;
mul.f32 f284, f279, f532;
mul.f32 f286, f239, f281;
mul.f32 f519, f238, f279;
sub.f32 f287, f519, f286;
mul.f32 f518, f279, f230;
mul.f32 f288, f238, f281;
fma.rn.f32 f289, f239, f279, f288;
mul.f32 f291, f289, f531;
mul.f32 f292, f287, f531;
mul.f32 f294, f239, f289;
mul.f32 f517, f238, f287;
sub.f32 f295, f517, f294;
mul.f32 f516, f287, f234;
mul.f32 f296, f238, f289;
fma.rn.f32 f297, f239, f287, f296;
sub.f32 f515, f569, f551;
mul.f32 f299, f297, f515;
mul.f32 f300, f295, f515;
mul.f32 f513, f238, f295;
mul.f32 f514, f239, f297;
sub.f32 f303, f513, f514;
sub.f32 f512, f106, f163;
mul.f32 f511, f295, f512;
mul.f32 f304, f238, f297;
fma.rn.f32 f305, f239, f295, f304;
mul.f32 f307, f305, f213;
mul.f32 f308, f303, f213;
mul.f32 f310, f239, f305;
mul.f32 f510, f238, f303;
sub.f32 f311, f510, f310;
mul.f32 f509, f303, f212;
mul.f32 f312, f238, f305;
fma.rn.f32 f313, f239, f303, f312;
mul.f32 f315, f313, f217;
mul.f32 f316, f311, f217;
mul.f32 f507, f238, f311;
mul.f32 f508, f239, f313;
sub.f32 f319, f507, f508;
mul.f32 f506, f311, f216;
mul.f32 f320, f238, f313;
fma.rn.f32 f321, f239, f311, f320;
mul.f32 f323, f321, f221;
mul.f32 f324, f319, f221;
mul.f32 f326, f239, f321;
mul.f32 f505, f238, f319;
sub.f32 f327, f505, f326;
mul.f32 f504, f319, f220;
mul.f32 f328, f238, f321;
fma.rn.f32 f329, f239, f319, f328;
mul.f32 f331, f329, f225;
mul.f32 f332, f327, f225;
mul.f32 f334, f239, f329;
mul.f32 f503, f238, f327;
sub.f32 f335, f503, f334;
mul.f32 f502, f327, f224;
mul.f32 f336, f238, f329;
fma.rn.f32 f337, f239, f327, f336;
mul.f32 f339, f337, f229;
mul.f32 f340, f335, f229;
mul.f32 f500, f238, f335;
mul.f32 f501, f239, f337;
sub.f32 f343, f500, f501;
mul.f32 f499, f335, f228;
mul.f32 f344, f238, f337;
fma.rn.f32 f345, f239, f335, f344;
mul.f32 f347, f345, f233;
mul.f32 f348, f343, f233;
mul.f32 f350, f239, f345;
mul.f32 f498, f238, f343;
sub.f32 f351, f498, f350;
mul.f32 f497, f238, f210;
mul.f32 f352, f238, f345;
mul.f32 f496, f343, f232;
fma.rn.f32 f353, f239, f343, f352;
mul.f32 f354, f351, f236;
mul.f32 f355, f353, f237;
mul.f32 f356, f351, f237;
mov.u32 r17, %tid.x;
and.b32 r16, r17, 1;
sub.f32 f585, f569, f551;
mul.f32 f584, f297, f585;
mov.u32 r23, %tid.x;
shl.b32 r22, r23, 7;
barrier.sync 0;
and.b32 r11, r22, 128;
add.s32 r12, r9, r11;
sub.f32 f587, f569, f551;
mul.f32 f586, f297, f587;
add.f32 f357, f569, f551;
mov.u32 r19, %tid.x;
and.b32 r18, r19, 1;
sub.f32 f588, f106, f163;
add.f32 f358, f106, f163;
mov.u32 r21, %tid.x;
and.b32 r20, r21, 1;
mov.u32 r25, %tid.x;
and.b32 r24, r25, 1;
fma.rn.f32 f359, f239, f210, f244;
sub.f32 f360, f497, f243;
st.shared.v4.f32 [r12], {f358, f357, f360, f359};
fma.rn.f32 f361, f249, f214, f252;
sub.f32 f362, f527, f251;
fma.rn.f32 f363, f257, f218, f260;
sub.f32 f364, f525, f259;
st.shared.v4.f32 [r12+16], {f362, f361, f364, f363};
sub.f32 f365, f523, f267;
fma.rn.f32 f366, f265, f222, f268;
fma.rn.f32 f367, f273, f226, f276;
sub.f32 f368, f520, f275;
st.shared.v4.f32 [r12+32], {f365, f366, f368, f367};
fma.rn.f32 f369, f281, f230, f284;
sub.f32 f370, f518, f283;
fma.rn.f32 f371, f289, f234, f292;
sub.f32 f372, f516, f291;
st.shared.v4.f32 [r12+48], {f370, f369, f372, f371};
fma.rn.f32 f373, f297, f588, f300;
sub.f32 f374, f511, f586;
fma.rn.f32 f375, f305, f212, f308;
sub.f32 f376, f509, f307;
st.shared.v4.f32 [r12+64], {f374, f373, f376, f375};
fma.rn.f32 f377, f313, f216, f316;
sub.f32 f378, f506, f315;
fma.rn.f32 f379, f321, f220, f324;
sub.f32 f380, f504, f323;
st.shared.v4.f32 [r12+80], {f378, f377, f380, f379};
fma.rn.f32 f381, f329, f224, f332;
sub.f32 f382, f502, f331;
fma.rn.f32 f383, f337, f228, f340;
sub.f32 f384, f499, f339;
st.shared.v4.f32 [r12+96], {f382, f381, f384, f383};
fma.rn.f32 f385, f345, f232, f348;
sub.f32 f386, f496, f347;
fma.rn.f32 f387, f353, f236, f356;
sub.f32 f388, f354, f355;
st.shared.v4.f32 [r12+112], {f386, f385, f388, f387};
barrier.sync 0;
mad.lo.s32 r13, r24, -120, r12;
ld.shared.v2.f32 {f389, f390}, [r13];
ld.shared.v2.f32 {f393, f394}, [r13+16];
ld.shared.v2.f32 {f397, f398}, [r13+32];
ld.shared.v2.f32 {f401, f402}, [r13+48];
ld.shared.v2.f32 {f405, f406}, [r13+64];
ld.shared.v2.f32 {f409, f410}, [r13+80];
ld.shared.v2.f32 {f413, f414}, [r13+96];
ld.shared.v2.f32 {f417, f418}, [r13+112];
ld.shared.v2.f32 {f421, f422}, [r13+128];
ld.shared.v2.f32 {f425, f426}, [r13+144];
ld.shared.v2.f32 {f429, f430}, [r13+160];
ld.shared.v2.f32 {f433, f434}, [r13+176];
ld.shared.v2.f32 {f437, f438}, [r13+192];
ld.shared.v2.f32 {f441, f442}, [r13+208];
ld.shared.v2.f32 {f445, f446}, [r13+224];
ld.shared.v2.f32 {f449, f450}, [r13+240];
add.f32 %0, f389, f421;
add.f32 %1, f390, f422;
add.f32 %2, f393, f425;
add.f32 %3, f394, f426;
add.f32 %5, f398, f430;
add.f32 %4, f397, f429;
add.f32 %7, f402, f434;
add.f32 %6, f401, f433;
add.f32 %9, f406, f438;
add.f32 %8, f405, f437;
add.f32 %10, f409, f441;
add.f32 %11, f410, f442;
add.f32 %12, f413, f445;
add.f32 %13, f414, f446;
add.f32 %14, f417, f449;
add.f32 %15, f418, f450;
sub.f32 %17, f390, f422;
sub.f32 %16, f389, f421;
sub.f32 %19, f394, f426;
sub.f32 %18, f393, f425;
sub.f32 %21, f398, f430;
sub.f32 %20, f397, f429;
sub.f32 %23, f402, f434;
sub.f32 %22, f401, f433;
sub.f32 %25, f406, f438;
sub.f32 %24, f405, f437;
sub.f32 %27, f410, f442;
sub.f32 %26, f409, f441;
sub.f32 %29, f414, f446;
sub.f32 %28, f413, f445;
sub.f32 %31, f418, f450;
sub.f32 %30, f417, f449;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[10].y), "f"(rmem[2].y), "f"(rmem[14].y), "f"(rmem[1].y), "f"(rmem[5].y), "f"(rmem[13].y), "f"(rmem[11].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<39, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<81>;
.reg .b32 r<35>;
.reg .b64 rd<15>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f9, %9, %11;
add.f32 f10, %10, %12;
sub.f32 f11, %9, %11;
sub.f32 f12, %10, %12;
shl.b32 r6, r5, 3;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 120;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f13, f14}, [rd5];
mul.f32 f17, f13, f11;
mul.f32 f18, f14, f12;
sub.f32 f19, f17, f18;
mul.f32 f20, f13, f12;
fma.rn.f32 f21, f14, f11, f20;
and.b32 r7, r6, -128;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 120;
add.s32 r10, r8, r9;
st.shared.v2.f32 [r10], {f9, f19};
barrier.sync 0;
shl.b32 r11, r5, 2;
and.b32 r12, r11, 60;
sub.s32 r13, r10, r12;
ld.shared.f32 f22, [r13];
ld.shared.f32 f23, [r13+64];
barrier.sync 0;
st.shared.v2.f32 [r10], {f10, f21};
barrier.sync 0;
ld.shared.f32 f24, [r13];
ld.shared.f32 f25, [r13+64];
add.f32 f26, f22, f23;
add.f32 f27, f24, f25;
sub.f32 f28, f22, f23;
sub.f32 f29, f24, f25;
bfe.u32 r14, r5, 1, 3;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f30, f31}, [rd8];
mul.f32 f34, f30, f28;
mul.f32 f35, f31, f29;
sub.f32 f36, f34, f35;
mul.f32 f37, f30, f29;
fma.rn.f32 f38, f31, f28, f37;
and.b32 r15, r11, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 112;
add.s32 r18, r16, r17;
st.shared.f32 [r18], f26;
st.shared.f32 [r18+8], f36;
barrier.sync 0;
and.b32 r19, r11, 56;
sub.s32 r20, r18, r19;
ld.shared.f32 f39, [r20];
ld.shared.f32 f40, [r20+64];
barrier.sync 0;
st.shared.f32 [r18], f27;
st.shared.f32 [r18+8], f38;
barrier.sync 0;
ld.shared.f32 f41, [r20];
ld.shared.f32 f42, [r20+64];
add.f32 f43, f39, f40;
add.f32 f44, f41, f42;
sub.f32 f45, f39, f40;
sub.f32 f46, f41, f42;
bfe.u32 r21, r5, 2, 2;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f47, f48}, [rd11];
mul.f32 f51, f47, f45;
mul.f32 f52, f48, f46;
sub.f32 f53, f51, f52;
mul.f32 f54, f47, f46;
fma.rn.f32 f55, f48, f45, f54;
and.b32 r22, r11, 12;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 96;
add.s32 r25, r23, r24;
st.shared.f32 [r25], f43;
st.shared.f32 [r25+16], f53;
barrier.sync 0;
and.b32 r26, r11, 48;
sub.s32 r27, r25, r26;
ld.shared.f32 f56, [r27];
ld.shared.f32 f57, [r27+64];
barrier.sync 0;
st.shared.f32 [r25], f44;
st.shared.f32 [r25+16], f55;
barrier.sync 0;
ld.shared.f32 f58, [r27];
ld.shared.f32 f59, [r27+64];
add.f32 f60, f56, f57;
add.f32 f61, f58, f59;
sub.f32 f62, f56, f57;
sub.f32 f63, f58, f59;
and.b32 r28, r5, 8;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f64, f65}, [rd14];
mul.f32 f68, f64, f62;
mul.f32 f69, f65, f63;
sub.f32 f70, f68, f69;
mul.f32 f71, f64, f63;
fma.rn.f32 f72, f65, f62, f71;
and.b32 r29, r11, 28;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 64;
add.s32 r32, r30, r31;
st.shared.f32 [r32], f60;
st.shared.f32 [r32+32], f70;
barrier.sync 0;
and.b32 r33, r11, 32;
sub.s32 r34, r32, r33;
ld.shared.f32 f73, [r34];
ld.shared.f32 f74, [r34+64];
barrier.sync 0;
st.shared.f32 [r32], f61;
st.shared.f32 [r32+32], f72;
barrier.sync 0;
ld.shared.f32 f75, [r34];
ld.shared.f32 f76, [r34+64];
add.f32 %0, f73, f74;
add.f32 %1, f75, f76;
sub.f32 %2, f73, f74;
sub.f32 %3, f75, f76;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<40, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<453>;
.reg .b32 r<14>;
.reg .b64 rd<6>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 7;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f65, %34, %55;
add.f32 f66, %35, %57;
sub.f32 f67, %34, %55;
sub.f32 f68, %35, %57;
add.f32 f69, %44, %66;
add.f32 f70, %46, %67;
sub.f32 f71, %44, %66;
sub.f32 f72, %46, %67;
add.f32 f73, f65, f69;
add.f32 f74, f66, f70;
sub.f32 f75, f65, f69;
sub.f32 f76, f66, f70;
add.f32 f77, f67, f72;
sub.f32 f78, f68, f71;
sub.f32 f79, f67, f72;
add.f32 f80, f68, f71;
add.f32 f81, %39, %60;
add.f32 f82, %41, %62;
sub.f32 f83, %39, %60;
sub.f32 f84, %41, %62;
add.f32 f85, %50, %71;
add.f32 f86, %51, %73;
sub.f32 f87, %50, %71;
sub.f32 f88, %51, %73;
add.f32 f89, f81, f85;
add.f32 f90, f82, f86;
sub.f32 f91, f81, f85;
sub.f32 f92, f82, f86;
add.f32 f93, f83, f88;
sub.f32 f94, f84, f87;
sub.f32 f95, f83, f88;
add.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f94, 0fBF3504F3;
sub.f32 f99, f97, f98;
mul.f32 f100, f94, 0f3F3504F3;
fma.rn.f32 f101, f93, 0fBF3504F3, f100;
mul.f32 f102, f95, 0fBF3504F3;
mul.f32 f103, f96, 0fBF3504F3;
sub.f32 f104, f102, f103;
add.f32 f105, f102, f103;
add.f32 f106, f73, f89;
add.f32 f107, f74, f90;
sub.f32 f108, f73, f89;
sub.f32 f109, f74, f90;
add.f32 f110, f77, f99;
add.f32 f111, f78, f101;
sub.f32 f112, f77, f99;
sub.f32 f113, f78, f101;
add.f32 f114, f75, f92;
sub.f32 f115, f76, f91;
sub.f32 f116, f75, f92;
add.f32 f117, f76, f91;
add.f32 f118, f79, f104;
add.f32 f119, f80, f105;
sub.f32 f120, f79, f104;
sub.f32 f121, f80, f105;
add.f32 f122, %36, %58;
add.f32 f123, %38, %59;
sub.f32 f124, %36, %58;
sub.f32 f125, %38, %59;
add.f32 f126, %47, %68;
add.f32 f127, %49, %70;
sub.f32 f128, %47, %68;
sub.f32 f129, %49, %70;
add.f32 f130, f122, f126;
add.f32 f131, f123, f127;
sub.f32 f132, f122, f126;
sub.f32 f133, f123, f127;
add.f32 f134, f124, f129;
sub.f32 f135, f125, f128;
sub.f32 f136, f124, f129;
add.f32 f137, f125, f128;
add.f32 f138, %42, %63;
add.f32 f139, %43, %65;
sub.f32 f140, %42, %63;
sub.f32 f141, %43, %65;
add.f32 f142, %52, %74;
add.f32 f143, %54, %75;
sub.f32 f144, %52, %74;
sub.f32 f145, %54, %75;
add.f32 f146, f138, f142;
add.f32 f147, f139, f143;
sub.f32 f148, f138, f142;
sub.f32 f149, f139, f143;
add.f32 f150, f140, f145;
sub.f32 f151, f141, f144;
sub.f32 f152, f140, f145;
add.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f151, 0fBF3504F3;
sub.f32 f156, f154, f155;
mul.f32 f157, f151, 0f3F3504F3;
fma.rn.f32 f158, f150, 0fBF3504F3, f157;
mul.f32 f159, f152, 0fBF3504F3;
mul.f32 f160, f153, 0fBF3504F3;
sub.f32 f161, f159, f160;
add.f32 f162, f159, f160;
add.f32 f163, f130, f146;
add.f32 f164, f131, f147;
sub.f32 f165, f130, f146;
sub.f32 f166, f131, f147;
add.f32 f167, f134, f156;
add.f32 f168, f135, f158;
sub.f32 f169, f134, f156;
sub.f32 f170, f135, f158;
add.f32 f171, f132, f149;
sub.f32 f172, f133, f148;
sub.f32 f173, f132, f149;
add.f32 f174, f133, f148;
add.f32 f175, f136, f161;
add.f32 f176, f137, f162;
sub.f32 f177, f136, f161;
sub.f32 f178, f137, f162;
mul.f32 f179, f167, 0f3F6C835E;
mul.f32 f180, f168, 0fBEC3EF15;
sub.f32 f181, f179, f180;
mul.f32 f182, f168, 0f3F6C835E;
fma.rn.f32 f183, f167, 0fBEC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f172, 0fBF3504F3;
sub.f32 f186, f184, f185;
mul.f32 f187, f172, 0f3F3504F3;
fma.rn.f32 f188, f171, 0fBF3504F3, f187;
mul.f32 f189, f175, 0f3EC3EF15;
mul.f32 f190, f176, 0fBF6C835E;
sub.f32 f191, f189, f190;
mul.f32 f192, f176, 0f3EC3EF15;
fma.rn.f32 f193, f175, 0fBF6C835E, f192;
mul.f32 f194, f169, 0fBEC3EF15;
mul.f32 f195, f170, 0fBF6C835E;
sub.f32 f196, f194, f195;
mul.f32 f197, f170, 0fBEC3EF15;
fma.rn.f32 f198, f169, 0fBF6C835E, f197;
mul.f32 f199, f173, 0fBF3504F3;
mul.f32 f200, f174, 0fBF3504F3;
sub.f32 f201, f199, f200;
add.f32 f202, f199, f200;
mul.f32 f203, f177, 0fBF6C835E;
mul.f32 f204, f178, 0fBEC3EF15;
sub.f32 f205, f203, f204;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0fBEC3EF15, f206;
add.f32 f208, f106, f163;
add.f32 f209, f107, f164;
sub.f32 f210, f106, f163;
sub.f32 f211, f107, f164;
add.f32 f212, f110, f181;
add.f32 f213, f111, f183;
sub.f32 f214, f110, f181;
sub.f32 f215, f111, f183;
add.f32 f216, f114, f186;
add.f32 f217, f115, f188;
sub.f32 f218, f114, f186;
sub.f32 f219, f115, f188;
add.f32 f220, f118, f191;
add.f32 f221, f119, f193;
sub.f32 f222, f118, f191;
sub.f32 f223, f119, f193;
add.f32 f224, f108, f166;
sub.f32 f225, f109, f165;
sub.f32 f226, f108, f166;
add.f32 f227, f109, f165;
add.f32 f228, f112, f196;
add.f32 f229, f113, f198;
sub.f32 f230, f112, f196;
sub.f32 f231, f113, f198;
add.f32 f232, f116, f201;
add.f32 f233, f117, f202;
sub.f32 f234, f116, f201;
sub.f32 f235, f117, f202;
add.f32 f236, f120, f205;
add.f32 f237, f121, f207;
sub.f32 f238, f120, f205;
sub.f32 f239, f121, f207;
and.b32 r6, r5, 1;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 8;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f240, f241}, [rd5];
mul.f32 f244, f240, f212;
mul.f32 f245, f241, f213;
sub.f32 f246, f244, f245;
mul.f32 f247, f240, f213;
fma.rn.f32 f248, f241, f212, f247;
mul.f32 f249, f240, f240;
mul.f32 f250, f241, f241;
sub.f32 f251, f249, f250;
mul.f32 f252, f241, f240;
fma.rn.f32 f253, f241, f240, f252;
mul.f32 f254, f251, f216;
mul.f32 f255, f253, f217;
sub.f32 f256, f254, f255;
mul.f32 f257, f251, f217;
fma.rn.f32 f258, f253, f216, f257;
mul.f32 f259, f240, f251;
mul.f32 f260, f241, f253;
sub.f32 f261, f259, f260;
mul.f32 f262, f240, f253;
fma.rn.f32 f263, f241, f251, f262;
mul.f32 f264, f261, f220;
mul.f32 f265, f263, f221;
sub.f32 f266, f264, f265;
mul.f32 f267, f261, f221;
fma.rn.f32 f268, f263, f220, f267;
mul.f32 f269, f240, f261;
mul.f32 f270, f241, f263;
sub.f32 f271, f269, f270;
mul.f32 f272, f240, f263;
fma.rn.f32 f273, f241, f261, f272;
mul.f32 f274, f271, f224;
mul.f32 f275, f273, f225;
sub.f32 f276, f274, f275;
mul.f32 f277, f271, f225;
fma.rn.f32 f278, f273, f224, f277;
mul.f32 f279, f240, f271;
mul.f32 f280, f241, f273;
sub.f32 f281, f279, f280;
mul.f32 f282, f240, f273;
fma.rn.f32 f283, f241, f271, f282;
mul.f32 f284, f281, f228;
mul.f32 f285, f283, f229;
sub.f32 f286, f284, f285;
mul.f32 f287, f281, f229;
fma.rn.f32 f288, f283, f228, f287;
mul.f32 f289, f240, f281;
mul.f32 f290, f241, f283;
sub.f32 f291, f289, f290;
mul.f32 f292, f240, f283;
fma.rn.f32 f293, f241, f281, f292;
mul.f32 f294, f291, f232;
mul.f32 f295, f293, f233;
sub.f32 f296, f294, f295;
mul.f32 f297, f291, f233;
fma.rn.f32 f298, f293, f232, f297;
mul.f32 f299, f240, f291;
mul.f32 f300, f241, f293;
sub.f32 f301, f299, f300;
mul.f32 f302, f240, f293;
fma.rn.f32 f303, f241, f291, f302;
mul.f32 f304, f301, f236;
mul.f32 f305, f303, f237;
sub.f32 f306, f304, f305;
mul.f32 f307, f301, f237;
fma.rn.f32 f308, f303, f236, f307;
mul.f32 f309, f240, f301;
mul.f32 f310, f241, f303;
sub.f32 f311, f309, f310;
mul.f32 f312, f240, f303;
fma.rn.f32 f313, f241, f301, f312;
mul.f32 f314, f311, f210;
mul.f32 f315, f313, f211;
sub.f32 f316, f314, f315;
mul.f32 f317, f311, f211;
fma.rn.f32 f318, f313, f210, f317;
mul.f32 f319, f240, f311;
mul.f32 f320, f241, f313;
sub.f32 f321, f319, f320;
mul.f32 f322, f240, f313;
fma.rn.f32 f323, f241, f311, f322;
mul.f32 f324, f321, f214;
mul.f32 f325, f323, f215;
sub.f32 f326, f324, f325;
mul.f32 f327, f321, f215;
fma.rn.f32 f328, f323, f214, f327;
mul.f32 f329, f240, f321;
mul.f32 f330, f241, f323;
sub.f32 f331, f329, f330;
mul.f32 f332, f240, f323;
fma.rn.f32 f333, f241, f321, f332;
mul.f32 f334, f331, f218;
mul.f32 f335, f333, f219;
sub.f32 f336, f334, f335;
mul.f32 f337, f331, f219;
fma.rn.f32 f338, f333, f218, f337;
mul.f32 f339, f240, f331;
mul.f32 f340, f241, f333;
sub.f32 f341, f339, f340;
mul.f32 f342, f240, f333;
fma.rn.f32 f343, f241, f331, f342;
mul.f32 f344, f341, f222;
mul.f32 f345, f343, f223;
sub.f32 f346, f344, f345;
mul.f32 f347, f341, f223;
fma.rn.f32 f348, f343, f222, f347;
mul.f32 f349, f240, f341;
mul.f32 f350, f241, f343;
sub.f32 f351, f349, f350;
mul.f32 f352, f240, f343;
fma.rn.f32 f353, f241, f341, f352;
mul.f32 f354, f351, f226;
mul.f32 f355, f353, f227;
sub.f32 f356, f354, f355;
mul.f32 f357, f351, f227;
fma.rn.f32 f358, f353, f226, f357;
mul.f32 f359, f240, f351;
mul.f32 f360, f241, f353;
sub.f32 f361, f359, f360;
mul.f32 f362, f240, f353;
fma.rn.f32 f363, f241, f351, f362;
mul.f32 f364, f361, f230;
mul.f32 f365, f363, f231;
sub.f32 f366, f364, f365;
mul.f32 f367, f361, f231;
fma.rn.f32 f368, f363, f230, f367;
mul.f32 f369, f240, f361;
mul.f32 f370, f241, f363;
sub.f32 f371, f369, f370;
mul.f32 f372, f240, f363;
fma.rn.f32 f373, f241, f361, f372;
mul.f32 f374, f371, f234;
mul.f32 f375, f373, f235;
sub.f32 f376, f374, f375;
mul.f32 f377, f371, f235;
fma.rn.f32 f378, f373, f234, f377;
mul.f32 f379, f240, f371;
mul.f32 f380, f241, f373;
sub.f32 f381, f379, f380;
mul.f32 f382, f240, f373;
fma.rn.f32 f383, f241, f371, f382;
mul.f32 f384, f381, f238;
mul.f32 f385, f383, f239;
sub.f32 f386, f384, f385;
mul.f32 f387, f381, f239;
fma.rn.f32 f388, f383, f238, f387;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -128;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 64;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f208, f246, f256, f266};
st.shared.v4.f32 [r12+16], {f276, f286, f296, f306};
st.shared.v4.f32 [r12+32], {f316, f326, f336, f346};
st.shared.v4.f32 [r12+48], {f356, f366, f376, f386};
barrier.sync 0;
mad.lo.s32 r13, r6, -60, r12;
ld.shared.f32 f389, [r13];
ld.shared.f32 f390, [r13+8];
ld.shared.f32 f391, [r13+16];
ld.shared.f32 f392, [r13+24];
ld.shared.f32 f393, [r13+32];
ld.shared.f32 f394, [r13+40];
ld.shared.f32 f395, [r13+48];
ld.shared.f32 f396, [r13+56];
ld.shared.f32 f397, [r13+64];
ld.shared.f32 f398, [r13+72];
ld.shared.f32 f399, [r13+80];
ld.shared.f32 f400, [r13+88];
ld.shared.f32 f401, [r13+96];
ld.shared.f32 f402, [r13+104];
ld.shared.f32 f403, [r13+112];
ld.shared.f32 f404, [r13+120];
barrier.sync 0;
st.shared.v4.f32 [r12], {f209, f248, f258, f268};
st.shared.v4.f32 [r12+16], {f278, f288, f298, f308};
st.shared.v4.f32 [r12+32], {f318, f328, f338, f348};
st.shared.v4.f32 [r12+48], {f358, f368, f378, f388};
barrier.sync 0;
ld.shared.f32 f405, [r13];
ld.shared.f32 f406, [r13+8];
ld.shared.f32 f407, [r13+16];
ld.shared.f32 f408, [r13+24];
ld.shared.f32 f409, [r13+32];
ld.shared.f32 f410, [r13+40];
ld.shared.f32 f411, [r13+48];
ld.shared.f32 f412, [r13+56];
ld.shared.f32 f413, [r13+64];
ld.shared.f32 f414, [r13+72];
ld.shared.f32 f415, [r13+80];
ld.shared.f32 f416, [r13+88];
ld.shared.f32 f417, [r13+96];
ld.shared.f32 f418, [r13+104];
ld.shared.f32 f419, [r13+112];
ld.shared.f32 f420, [r13+120];
add.f32 %0, f389, f397;
add.f32 %1, f405, f413;
add.f32 %2, f390, f398;
add.f32 %3, f406, f414;
add.f32 %4, f391, f399;
add.f32 %5, f407, f415;
add.f32 %6, f392, f400;
add.f32 %7, f408, f416;
add.f32 %8, f393, f401;
add.f32 %9, f409, f417;
add.f32 %10, f394, f402;
add.f32 %11, f410, f418;
add.f32 %12, f395, f403;
add.f32 %13, f411, f419;
add.f32 %14, f396, f404;
add.f32 %15, f412, f420;
sub.f32 %16, f389, f397;
sub.f32 %17, f405, f413;
sub.f32 %18, f390, f398;
sub.f32 %19, f406, f414;
sub.f32 %20, f391, f399;
sub.f32 %21, f407, f415;
sub.f32 %22, f392, f400;
sub.f32 %23, f408, f416;
sub.f32 %24, f393, f401;
sub.f32 %25, f409, f417;
sub.f32 %26, f394, f402;
sub.f32 %27, f410, f418;
sub.f32 %28, f395, f403;
sub.f32 %29, f411, f419;
sub.f32 %30, f396, f404;
sub.f32 %31, f412, f420;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y));
};


#endif
